/*
 * Decompiled with CFR 0.152.
 */
package org.cogroo.analyzer;

import java.util.List;
import org.cogroo.analyzer.Analyzer;
import org.cogroo.text.Chunk;
import org.cogroo.text.Document;
import org.cogroo.text.Sentence;
import org.cogroo.text.Token;
import org.cogroo.tools.chunker2.ChunkerME;
import org.cogroo.util.TextUtils;

public class HeadFinder
implements Analyzer {
    private ChunkerME headFinder;

    public HeadFinder(ChunkerME headFinder) {
        this.headFinder = headFinder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void analyze(Document document) {
        List<Sentence> sentences = document.getSentences();
        for (Sentence sentence : sentences) {
            String[] heads;
            List<Token> tokens = sentence.getTokens();
            List<Chunk> chunks = sentence.getChunks();
            String[] tags = new String[tokens.size()];
            for (int i = 0; i < tokens.size(); ++i) {
                tags[i] = tokens.get(i).getPOSTag() + "|" + tokens.get(i).getChunkTag();
            }
            String[] tokensString = TextUtils.tokensToString(tokens);
            ChunkerME chunkerME = this.headFinder;
            synchronized (chunkerME) {
                heads = this.headFinder.chunk(tokensString, tags);
            }
            for (Chunk chunk : chunks) {
                for (int i = chunk.getStart(); i < chunk.getEnd(); ++i) {
                    if (!heads[i].equals("B-H")) continue;
                    tokens.get(i).isChunkHead(true);
                    chunk.setHeadIndex(i);
                }
            }
        }
    }
}

