# -*- coding: utf-8 -*-
# pylint: skip-file
"""This module contains implemtation of F9.

When using it, please cite :cite:`Blumlein:2009ta`.
Mellin transform is defined with the convention x^(N).
"""
import numba as nb
import numpy as np


@nb.njit(cache=True)
def F9(n, S1):
    """Implements eq 9.19 of :cite:`Blumlein:2009ta`"""
    return (
        0.06236473052300693 * n
        + (0.2690947900632558 * n) / (2.0 + n)
        - (0.12825410062391376 * n) / (3.0 + n)
        + (0.007553694508943639 * n) / (4.0 + n)
        + (0.030446610389993342 * n) / (5.0 + n)
        - (0.11774020607944516 * n) / (6.0 + n)
        + (0.33716180147388786 * n) / (7.0 + n)
        - (0.6676623948212598 * n) / (8.0 + n)
        + (0.9225597682535133 * n) / (9.0 + n)
        - (0.8726283036193748 * n) / (10.0 + n)
        + (0.5398117849858193 * n) / (11.0 + n)
        - (0.1970839223372511 * n) / (12.0 + n)
        + (0.03230590731253853 * n) / (13.0 + n)
        + 0.21793029342350395 * (-1.0 + 1 / (1.0 + n))
        - 0.000925925925925926
        * n
        * (
            67.35391078053772
            + 993.5438760599122 / (1.0 + n)
            + 185.10074515651877 / (2.0 + n)
            - 21.841303653529422 / (3.0 + n)
            + (180.0 * (1.0 + (1.0 + n) * S1)) / np.power(1.0 + n, 2)
            - (180.0 * (1.0 + (2.0 + n) * (1 / (1.0 + n) + S1))) / np.power(2.0 + n, 2)
            + (60.0 * (1.0 + (3.0 + n) * (1 / (1.0 + n) + 1 / (2.0 + n) + S1)))
            / np.power(3.0 + n, 2)
            - (
                1228.9090924080292
                * (
                    1.0
                    + n
                    * (1 / (1.0 + n) + (1.0 - 2.0 * (1.0 + n)) / (n * (1.0 + n)) + S1)
                )
            )
            / np.power(n, 2)
        )
    )
