# -*- coding: utf-8 -*-
# pylint: skip-file
"""This module contains implemtation of F19.

When using it, please cite :cite:`Blumlein:2009ta`.
Mellin transform is defined with the convention x^(N).
"""
import numba as nb
import numpy as np


@nb.njit(cache=True)
def F19(n, S1, S2, S3):
    """Mellin tranfrom of eq 9.3 of :cite:`Blumlein:2009ta`"""
    return (
        7.548974594558902
        - 1.5497677311665408 / np.power(1.0 + n, 3)
        - 0.5497677311665407 / np.power(2.0 + n, 3)
        + 2.0 / np.power(2.0 + n, 2)
        - 11.975319856741933 / (np.power(1.0 + n, 2) * np.power(2.0 + n, 2))
        - (14.370383828090318 * n) / (np.power(1.0 + n, 2) * np.power(2.0 + n, 2))
        - (4.790127942696773 * np.power(n, 2))
        / (np.power(1.0 + n, 2) * np.power(2.0 + n, 2))
        + 3.0 / (2.0 + n)
        - 9.738329251443808 / ((1.0 + n) * (2.0 + n))
        - (6.492219500962539 * n) / ((1.0 + n) * (2.0 + n))
        - 0.2997677311665407 / np.power(3.0 + n, 3)
        - 0.1450639713483865 / np.power(3.0 + n, 2)
        - 0.05860975048126964 / (3.0 + n)
        - 0.18865662005542957 / np.power(4.0 + n, 3)
        - 0.07098989727431243 / np.power(4.0 + n, 2)
        - 0.021572713444232602 / (4.0 + n)
        - 0.12615662005542957 / np.power(5.0 + n, 3)
        - 0.03973989727431243 / np.power(5.0 + n, 2)
        - 0.009853963444232604 / (5.0 + n)
        - 0.08615662005542958 / np.power(6.0 + n, 3)
        - 0.02373989727431243 / np.power(6.0 + n, 2)
        - 0.005053963444232604 / (6.0 + n)
        - 0.058378842277651805 / np.power(7.0 + n, 3)
        - 0.01448063801505317 / np.power(7.0 + n, 2)
        - 0.0027391486294177886 / (7.0 + n)
        - 0.03797067901234568 / np.power(8.0 + n, 3)
        - 0.008649734224965707 / np.power(8.0 + n, 2)
        - 0.0014896692458276177 / (8.0 + n)
        - 0.02234567901234568 / np.power(9.0 + n, 3)
        - 0.004743484224965707 / np.power(9.0 + n, 2)
        - 0.0007572473708276177 / (9.0 + n)
        - 0.01 / np.power(10.0 + n, 3)
        - 0.002 / np.power(10.0 + n, 2)
        - 0.0003 / (10.0 + n)
        - 3.2461097504812697 * S1
        - 2.3950639713483866 * S2
        - (1.5497677311665408 * S3) / np.power(1.0 + n, 3)
        - (4.649303193499622 * n * S3) / np.power(1.0 + n, 3)
        - (4.649303193499622 * np.power(n, 2) * S3) / np.power(1.0 + n, 3)
        - (1.5497677311665408 * np.power(n, 3) * S3) / np.power(1.0 + n, 3)
    )
