"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.BalancerEntry = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_elasticloadbalancingv2_1 = require("@aws-cdk/aws-elasticloadbalancingv2");
const cdk = require("@aws-cdk/core");
/**
 * @stability stable
 */
class BalancerEntry extends cdk.Resource {
    /**
     * @stability stable
     */
    constructor(scope, id, props) {
        super(scope, id);
        const listeners = this.getLoadBalancerListener(props.lbArn, props.sslEnabled, props.appName);
        if (props.sslEnabled) {
            new aws_elasticloadbalancingv2_1.CfnListenerRule(this, props.appName + '-https-rule', {
                listenerArn: listeners[0],
                actions: [
                    {
                        type: 'forward',
                        targetGroupArn: props.targetGroupArn,
                    },
                ],
                conditions: [
                    {
                        field: 'host-header',
                        hostHeaderConfig: {
                            values: [props.hostHeader],
                        },
                    },
                ],
                priority: Math.floor(Math.random() * (1000 - 200 + 1)) + 200,
            });
        }
        else {
            new aws_elasticloadbalancingv2_1.CfnListenerRule(this, props.appName + '-http-rule', {
                listenerArn: listeners[0],
                actions: [
                    {
                        type: 'forward',
                        targetGroupArn: props.targetGroupArn,
                    },
                ],
                conditions: [
                    {
                        field: 'host-header',
                        hostHeaderConfig: {
                            values: [props.hostHeader],
                        },
                    },
                ],
                priority: Math.floor(Math.random() * (1000 - 200 + 1)) + 200,
            });
        }
    }
    getLoadBalancerListener(loadBalancerArn, sslEnabled, appName) {
        const listeners = [];
        if (!sslEnabled) {
            listeners.push(aws_elasticloadbalancingv2_1.ApplicationListener.fromLookup(this, appName + '-listener-http', {
                loadBalancerArn: loadBalancerArn,
                listenerProtocol: aws_elasticloadbalancingv2_1.ApplicationProtocol.HTTP,
            }).listenerArn);
        }
        if (sslEnabled) {
            listeners.push(aws_elasticloadbalancingv2_1.ApplicationListener.fromLookup(this, appName + '-listener-https', {
                loadBalancerArn: loadBalancerArn,
                listenerProtocol: aws_elasticloadbalancingv2_1.ApplicationProtocol.HTTPS,
            }).listenerArn);
        }
        return listeners;
    }
}
exports.BalancerEntry = BalancerEntry;
_a = JSII_RTTI_SYMBOL_1;
BalancerEntry[_a] = { fqn: "@smallcase/aws-cdk-microservice.BalancerEntry", version: "0.0.9" };
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoibmV0d29yay5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbIi4uLy4uL3NyYy9jb25zdHJ1Y3RzL25ldHdvcmsudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6Ijs7Ozs7QUFBQSxvRkFBZ0g7QUFDaEgscUNBQXFDOzs7O0FBVXJDLE1BQWEsYUFBYyxTQUFRLEdBQUcsQ0FBQyxRQUFROzs7O0lBQzdDLFlBQVksS0FBb0IsRUFBRSxFQUFVLEVBQUUsS0FBd0I7UUFDcEUsS0FBSyxDQUFDLEtBQUssRUFBRSxFQUFFLENBQUMsQ0FBQztRQUNqQixNQUFNLFNBQVMsR0FBRyxJQUFJLENBQUMsdUJBQXVCLENBQUMsS0FBSyxDQUFDLEtBQUssRUFBRSxLQUFLLENBQUMsVUFBVSxFQUFFLEtBQUssQ0FBQyxPQUFPLENBQUMsQ0FBQztRQUM3RixJQUFJLEtBQUssQ0FBQyxVQUFVLEVBQUU7WUFDcEIsSUFBSSw0Q0FBZSxDQUFDLElBQUksRUFBRSxLQUFLLENBQUMsT0FBTyxHQUFHLGFBQWEsRUFBRTtnQkFDdkQsV0FBVyxFQUFFLFNBQVMsQ0FBQyxDQUFDLENBQUM7Z0JBQ3pCLE9BQU8sRUFBRTtvQkFDUDt3QkFDRSxJQUFJLEVBQUUsU0FBUzt3QkFDZixjQUFjLEVBQUUsS0FBSyxDQUFDLGNBQWM7cUJBQ3JDO2lCQUNGO2dCQUNELFVBQVUsRUFBRTtvQkFDVjt3QkFDRSxLQUFLLEVBQUUsYUFBYTt3QkFDcEIsZ0JBQWdCLEVBQUU7NEJBQ2hCLE1BQU0sRUFBRSxDQUFDLEtBQUssQ0FBQyxVQUFVLENBQUM7eUJBQzNCO3FCQUNGO2lCQUNGO2dCQUNELFFBQVEsRUFBRSxJQUFJLENBQUMsS0FBSyxDQUFDLElBQUksQ0FBQyxNQUFNLEVBQUUsR0FBRyxDQUFDLElBQUksR0FBRyxHQUFHLEdBQUcsQ0FBQyxDQUFDLENBQUMsR0FBRyxHQUFHO2FBQzdELENBQUMsQ0FBQztTQUNKO2FBQU07WUFDTCxJQUFJLDRDQUFlLENBQUMsSUFBSSxFQUFFLEtBQUssQ0FBQyxPQUFPLEdBQUcsWUFBWSxFQUFFO2dCQUN0RCxXQUFXLEVBQUUsU0FBUyxDQUFDLENBQUMsQ0FBQztnQkFDekIsT0FBTyxFQUFFO29CQUNQO3dCQUNFLElBQUksRUFBRSxTQUFTO3dCQUNmLGNBQWMsRUFBRSxLQUFLLENBQUMsY0FBYztxQkFDckM7aUJBQ0Y7Z0JBQ0QsVUFBVSxFQUFFO29CQUNWO3dCQUNFLEtBQUssRUFBRSxhQUFhO3dCQUNwQixnQkFBZ0IsRUFBRTs0QkFDaEIsTUFBTSxFQUFFLENBQUMsS0FBSyxDQUFDLFVBQVUsQ0FBQzt5QkFDM0I7cUJBQ0Y7aUJBQ0Y7Z0JBQ0QsUUFBUSxFQUFFLElBQUksQ0FBQyxLQUFLLENBQUMsSUFBSSxDQUFDLE1BQU0sRUFBRSxHQUFHLENBQUMsSUFBSSxHQUFHLEdBQUcsR0FBRyxDQUFDLENBQUMsQ0FBQyxHQUFHLEdBQUc7YUFDN0QsQ0FBQyxDQUFDO1NBQ0o7SUFDSCxDQUFDO0lBRU8sdUJBQXVCLENBQUMsZUFBdUIsRUFBRSxVQUFtQixFQUFFLE9BQWU7UUFDM0YsTUFBTSxTQUFTLEdBQUcsRUFBRSxDQUFDO1FBRXJCLElBQUksQ0FBQyxVQUFVLEVBQUU7WUFDZixTQUFTLENBQUMsSUFBSSxDQUFDLGdEQUFtQixDQUFDLFVBQVUsQ0FBQyxJQUFJLEVBQUUsT0FBTyxHQUFHLGdCQUFnQixFQUFFO2dCQUM5RSxlQUFlLEVBQUUsZUFBZTtnQkFDaEMsZ0JBQWdCLEVBQUUsZ0RBQW1CLENBQUMsSUFBSTthQUMzQyxDQUFDLENBQUMsV0FBVyxDQUFDLENBQUM7U0FDakI7UUFFRCxJQUFJLFVBQVUsRUFBRTtZQUNkLFNBQVMsQ0FBQyxJQUFJLENBQUMsZ0RBQW1CLENBQUMsVUFBVSxDQUFDLElBQUksRUFBRSxPQUFPLEdBQUcsaUJBQWlCLEVBQUU7Z0JBQy9FLGVBQWUsRUFBRSxlQUFlO2dCQUNoQyxnQkFBZ0IsRUFBRSxnREFBbUIsQ0FBQyxLQUFLO2FBQzVDLENBQUMsQ0FBQyxXQUFXLENBQUMsQ0FBQztTQUNqQjtRQUNELE9BQU8sU0FBUyxDQUFDO0lBQ25CLENBQUM7O0FBOURILHNDQStEQyIsInNvdXJjZXNDb250ZW50IjpbImltcG9ydCB7IEFwcGxpY2F0aW9uTGlzdGVuZXIsIEFwcGxpY2F0aW9uUHJvdG9jb2wsIENmbkxpc3RlbmVyUnVsZSB9IGZyb20gJ0Bhd3MtY2RrL2F3cy1lbGFzdGljbG9hZGJhbGFuY2luZ3YyJztcbmltcG9ydCAqIGFzIGNkayBmcm9tICdAYXdzLWNkay9jb3JlJztcblxuZXhwb3J0IGludGVyZmFjZSBMb2FkQmFsYW5jZXJQcm9wcyB7XG4gIHJlYWRvbmx5IGFwcE5hbWU6IHN0cmluZztcbiAgcmVhZG9ubHkgaG9zdEhlYWRlcjogc3RyaW5nO1xuICByZWFkb25seSB0YXJnZXRHcm91cEFybjogc3RyaW5nO1xuICByZWFkb25seSBsYkFybjogc3RyaW5nO1xuICByZWFkb25seSBzc2xFbmFibGVkOiBib29sZWFuO1xufVxuXG5leHBvcnQgY2xhc3MgQmFsYW5jZXJFbnRyeSBleHRlbmRzIGNkay5SZXNvdXJjZSB7XG4gIGNvbnN0cnVjdG9yKHNjb3BlOiBjZGsuQ29uc3RydWN0LCBpZDogc3RyaW5nLCBwcm9wczogTG9hZEJhbGFuY2VyUHJvcHMpIHtcbiAgICBzdXBlcihzY29wZSwgaWQpO1xuICAgIGNvbnN0IGxpc3RlbmVycyA9IHRoaXMuZ2V0TG9hZEJhbGFuY2VyTGlzdGVuZXIocHJvcHMubGJBcm4sIHByb3BzLnNzbEVuYWJsZWQsIHByb3BzLmFwcE5hbWUpO1xuICAgIGlmIChwcm9wcy5zc2xFbmFibGVkKSB7XG4gICAgICBuZXcgQ2ZuTGlzdGVuZXJSdWxlKHRoaXMsIHByb3BzLmFwcE5hbWUgKyAnLWh0dHBzLXJ1bGUnLCB7XG4gICAgICAgIGxpc3RlbmVyQXJuOiBsaXN0ZW5lcnNbMF0sXG4gICAgICAgIGFjdGlvbnM6IFtcbiAgICAgICAgICB7XG4gICAgICAgICAgICB0eXBlOiAnZm9yd2FyZCcsXG4gICAgICAgICAgICB0YXJnZXRHcm91cEFybjogcHJvcHMudGFyZ2V0R3JvdXBBcm4sXG4gICAgICAgICAgfSxcbiAgICAgICAgXSxcbiAgICAgICAgY29uZGl0aW9uczogW1xuICAgICAgICAgIHtcbiAgICAgICAgICAgIGZpZWxkOiAnaG9zdC1oZWFkZXInLFxuICAgICAgICAgICAgaG9zdEhlYWRlckNvbmZpZzoge1xuICAgICAgICAgICAgICB2YWx1ZXM6IFtwcm9wcy5ob3N0SGVhZGVyXSxcbiAgICAgICAgICAgIH0sXG4gICAgICAgICAgfSxcbiAgICAgICAgXSxcbiAgICAgICAgcHJpb3JpdHk6IE1hdGguZmxvb3IoTWF0aC5yYW5kb20oKSAqICgxMDAwIC0gMjAwICsgMSkpICsgMjAwLCAvLyB0aGlzIGxpbmUgaXMgYSBmbGlwcGluZyBsZWFwIG9mIGZhaXRoXG4gICAgICB9KTtcbiAgICB9IGVsc2Uge1xuICAgICAgbmV3IENmbkxpc3RlbmVyUnVsZSh0aGlzLCBwcm9wcy5hcHBOYW1lICsgJy1odHRwLXJ1bGUnLCB7XG4gICAgICAgIGxpc3RlbmVyQXJuOiBsaXN0ZW5lcnNbMF0sXG4gICAgICAgIGFjdGlvbnM6IFtcbiAgICAgICAgICB7XG4gICAgICAgICAgICB0eXBlOiAnZm9yd2FyZCcsXG4gICAgICAgICAgICB0YXJnZXRHcm91cEFybjogcHJvcHMudGFyZ2V0R3JvdXBBcm4sXG4gICAgICAgICAgfSxcbiAgICAgICAgXSxcbiAgICAgICAgY29uZGl0aW9uczogW1xuICAgICAgICAgIHtcbiAgICAgICAgICAgIGZpZWxkOiAnaG9zdC1oZWFkZXInLFxuICAgICAgICAgICAgaG9zdEhlYWRlckNvbmZpZzoge1xuICAgICAgICAgICAgICB2YWx1ZXM6IFtwcm9wcy5ob3N0SGVhZGVyXSxcbiAgICAgICAgICAgIH0sXG4gICAgICAgICAgfSxcbiAgICAgICAgXSxcbiAgICAgICAgcHJpb3JpdHk6IE1hdGguZmxvb3IoTWF0aC5yYW5kb20oKSAqICgxMDAwIC0gMjAwICsgMSkpICsgMjAwLCAvLyB0aGlzIGxpbmUgaXMgYSBmbGlwcGluZyBsZWFwIG9mIGZhaXRoXG4gICAgICB9KTtcbiAgICB9XG4gIH1cblxuICBwcml2YXRlIGdldExvYWRCYWxhbmNlckxpc3RlbmVyKGxvYWRCYWxhbmNlckFybjogc3RyaW5nLCBzc2xFbmFibGVkOiBib29sZWFuLCBhcHBOYW1lOiBzdHJpbmcpIHtcbiAgICBjb25zdCBsaXN0ZW5lcnMgPSBbXTtcblxuICAgIGlmICghc3NsRW5hYmxlZCkge1xuICAgICAgbGlzdGVuZXJzLnB1c2goQXBwbGljYXRpb25MaXN0ZW5lci5mcm9tTG9va3VwKHRoaXMsIGFwcE5hbWUgKyAnLWxpc3RlbmVyLWh0dHAnLCB7XG4gICAgICAgIGxvYWRCYWxhbmNlckFybjogbG9hZEJhbGFuY2VyQXJuLFxuICAgICAgICBsaXN0ZW5lclByb3RvY29sOiBBcHBsaWNhdGlvblByb3RvY29sLkhUVFAsXG4gICAgICB9KS5saXN0ZW5lckFybik7XG4gICAgfVxuXG4gICAgaWYgKHNzbEVuYWJsZWQpIHtcbiAgICAgIGxpc3RlbmVycy5wdXNoKEFwcGxpY2F0aW9uTGlzdGVuZXIuZnJvbUxvb2t1cCh0aGlzLCBhcHBOYW1lICsgJy1saXN0ZW5lci1odHRwcycsIHtcbiAgICAgICAgbG9hZEJhbGFuY2VyQXJuOiBsb2FkQmFsYW5jZXJBcm4sXG4gICAgICAgIGxpc3RlbmVyUHJvdG9jb2w6IEFwcGxpY2F0aW9uUHJvdG9jb2wuSFRUUFMsXG4gICAgICB9KS5saXN0ZW5lckFybik7XG4gICAgfVxuICAgIHJldHVybiBsaXN0ZW5lcnM7XG4gIH1cbn1cbiJdfQ==