import { Construct } from '@aws-cdk/core';
import { DatadogCredentials, MonitorOptions, MonitorType } from './properties';
/**
 * @stability stable
 */
export interface DatadogMonitorProps {
    /**
     * Credentials for the Datadog API.
     *
     * @stability stable
     */
    readonly datadogCredentials: DatadogCredentials;
    /**
     * The monitor query.
     *
     * @stability stable
     */
    readonly query: string;
    /**
     * The type of the monitor.
     *
     * @stability stable
     */
    readonly type: MonitorType;
    /**
     * A message to include with notifications for the monitor.
     *
     * @stability stable
     */
    readonly message?: string;
    /**
     * Name of the monitor.
     *
     * @stability stable
     */
    readonly name?: string;
    /**
     * Tags associated with the monitor.
     *
     * @stability stable
     */
    readonly tags?: string[];
    /**
     * The monitor options.
     *
     * @stability stable
     */
    readonly options?: MonitorOptions;
    /**
     * Whether or not the monitor is multi alert.
     *
     * @stability stable
     */
    readonly multi?: boolean;
}
/**
 * Datadog Monitor 3.0.0.
 *
 * @stability stable
 */
export declare class DatadogMonitor {
    /**
     * @stability stable
     */
    constructor(scope: Construct, id: string, props: DatadogMonitorProps);
}
