"""Data downloaded from NCBI Gene converted into Python namedtuples."""

from collections import namedtuple

WRITTEN = "2020_10_28" # 26023 items

#pylint: disable=line-too-long,too-many-lines,invalid-name
ntncbi = namedtuple('ntncbi', 'tax_id Org_name GeneID CurrentID Status Symbol Aliases description other_designations map_location chromosome genomic_nucleotide_accession_version start_position_on_the_genomic_accession end_position_on_the_genomic_accession orientation exon_count OMIM no_hdr0')

GENEID2NT = { # 26,023 items
    11287 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=11287, CurrentID=0, Status='live', Symbol='Pzp', Aliases=['A1m', 'A2m', 'AI893533', 'MAM'], description='PZP, alpha-2-macroglobulin like', other_designations='pregnancy zone protein|alpha 1 macroglobulin|alpha-2-M|alpha-2-macroglobulin', map_location='6 63.02 cM', chromosome='6', genomic_nucleotide_accession_version='NC_000072.6', start_position_on_the_genomic_accession=128483567, end_position_on_the_genomic_accession=128526720, orientation='minus', exon_count=36, OMIM=[], no_hdr0=''),
    11298 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=11298, CurrentID=0, Status='live', Symbol='Aanat', Aliases=['AA-NAT', 'Na', 'Nat', 'Nat-2', 'Nat4', 'S', 'Snat'], description='arylalkylamine N-acetyltransferase', other_designations='serotonin N-acetyltransferase|aralkylamine N-acetyltransferase|serotonin acetylase', map_location='11 E2', chromosome='11', genomic_nucleotide_accession_version='NC_000077.6', start_position_on_the_genomic_accession=116591721, end_position_on_the_genomic_accession=116597680, orientation='plus', exon_count=6, OMIM=[], no_hdr0=''),
    11302 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=11302, CurrentID=0, Status='live', Symbol='Aatk', Aliases=['AATY', 'AATYK', 'aatyk1', 'mKIAA0641'], description='apoptosis-associated tyrosine kinase', other_designations='serine/threonine-protein kinase LMTK1|apoptosis-associated tyrosine kinase 1B|brain apoptosis-associated tyrosine kinase|lemur tyrosine kinase 1', map_location='11 E2', chromosome='11', genomic_nucleotide_accession_version='NC_000077.6', start_position_on_the_genomic_accession=120007311, end_position_on_the_genomic_accession=120047183, orientation='minus', exon_count=16, OMIM=[], no_hdr0=''),
    11303 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=11303, CurrentID=0, Status='live', Symbol='Abca1', Aliases=['ABC', 'ABC-1', 'Abc1'], description='ATP-binding cassette, sub-family A (ABC1), member 1', other_designations='phospholipid-transporting ATPase ABCA1|ATP-binding cassette 1|ATP-binding cassette sub-family A member 1|ATP-binding cassette transporter 1', map_location='4 28.57 cM', chromosome='4', genomic_nucleotide_accession_version='NC_000070.6', start_position_on_the_genomic_accession=53030789, end_position_on_the_genomic_accession=53159988, orientation='minus', exon_count=52, OMIM=[], no_hdr0=''),
    11304 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=11304, CurrentID=0, Status='live', Symbol='Abca4', Aliases=['AW050280', 'Abc1', 'Abc10', 'Abcr', 'D430003I15Rik', 'R', 'RmP'], description='ATP-binding cassette, sub-family A (ABC1), member 4', other_designations='retinal-specific phospholipid-transporting ATPase ABCA4|ATP-binding cassette 10|ATP-binding cassette sub-family A member 4|RIM ABC transporter|Rim protein|retinal-specific ATP-binding cassette transporter', map_location='3 52.94 cM', chromosome='3', genomic_nucleotide_accession_version='NC_000069.6', start_position_on_the_genomic_accession=122043891, end_position_on_the_genomic_accession=122180070, orientation='plus', exon_count=55, OMIM=[], no_hdr0=''),
    11305 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=11305, CurrentID=0, Status='live', Symbol='Abca2', Aliases=['AI413825', 'Abc', 'Abc2', 'D2H0S1474', 'D2H0S1474E', 'mKIAA1062'], description='ATP-binding cassette, sub-family A (ABC1), member 2', other_designations='ATP-binding cassette sub-family A member 2|ATP-binding cassette 2|ATP-binding cassette transporter 2', map_location='2 17.25 cM', chromosome='2', genomic_nucleotide_accession_version='NC_000068.7', start_position_on_the_genomic_accession=25428599, end_position_on_the_genomic_accession=25448544, orientation='plus', exon_count=50, OMIM=[], no_hdr0=''),
    11306 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=11306, CurrentID=0, Status='live', Symbol='Abcb7', Aliases=['AA517758', 'AU019072', 'Abc', 'Abc7'], description='ATP-binding cassette, sub-family B (MDR/TAP), member 7', other_designations='ATP-binding cassette sub-family B member 7, mitochondrial|ABC transporter 7 protein|ATP-binding cassette 7|ATP-binding cassette transporter 7', map_location='X 46.58 cM', chromosome='X', genomic_nucleotide_accession_version='NC_000086.7', start_position_on_the_genomic_accession=104280565, end_position_on_the_genomic_accession=104413846, orientation='minus', exon_count=16, OMIM=[], no_hdr0=''),
    11307 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=11307, CurrentID=0, Status='live', Symbol='Abcg1', Aliases=['AW413978', 'Abc', 'Abc8', 'Whit', 'White'], description='ATP binding cassette subfamily G member 1', other_designations='ATP-binding cassette sub-family G member 1|ATP-binding cassette 8|ATP-binding cassette transporter 8|ATP-binding cassette, sub-family G (WHITE), member 1|white protein homolog', map_location='17 A3.3', chromosome='17', genomic_nucleotide_accession_version='NC_000083.6', start_position_on_the_genomic_accession=31057694, end_position_on_the_genomic_accession=31117984, orientation='plus', exon_count=15, OMIM=[], no_hdr0=''),
    11308 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=11308, CurrentID=0, Status='live', Symbol='Abi1', Aliases=['E3B1', 'NAP1', 'Ssh3', 'Ssh3bp1', 'abi-1'], description='abl-interactor 1', other_designations='abl interactor 1|abelson interactor 1|ablphilin-1|eps8 SH3 domain-binding protein|eps8 binding protein|spectrin SH3 domain binding protein 1', map_location='2 15.18 cM', chromosome='2', genomic_nucleotide_accession_version='NC_000068.7', start_position_on_the_genomic_accession=22940073, end_position_on_the_genomic_accession=23040241, orientation='minus', exon_count=11, OMIM=[], no_hdr0=''),
    11350 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=11350, CurrentID=0, Status='live', Symbol='Abl1', Aliases=['AI325092', 'Abl', 'E430008G22Rik', 'c-A', 'c-Abl'], description='c-abl oncogene 1, non-receptor tyrosine kinase', other_designations='tyrosine-protein kinase ABL1|Abelson murine leukemia oncogene|Abelson tyrosine-protein kinase 1|abelson murine leukemia viral oncogene homolog 1|c-abl oncogene 1, receptor tyrosine kinase|c-abl protein, type I|c-abl protein, type II|c-abl protein, type III|p150|proto-oncogene c-Abl|proto-oncogene tyrosine-protein kinase ABL1|v-abl Abelson murine leukemia oncogene 1', map_location='2 B', chromosome='2', genomic_nucleotide_accession_version='NC_000068.7', start_position_on_the_genomic_accession=31688244, end_position_on_the_genomic_accession=31807093, orientation='plus', exon_count=16, OMIM=[], no_hdr0=''),
    11352 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=11352, CurrentID=0, Status='live', Symbol='Abl2', Aliases=['A', 'AA536808', 'Abll', 'Arg'], description='v-abl Abelson murine leukemia viral oncogene 2 (arg, Abelson-related gene)', other_designations='tyrosine-protein kinase ABL2|Abelson tyrosine-protein kinase 2|Abelson-related gene protein|abelson murine leukemia viral oncogene homolog 2|tyrosine kinase ARG|tyrosine-protein kinase ARG|v-abl Abelson murine leukemia viral oncogene homolog 2 (arg, Abelson-related gene)', map_location='1 67.71 cM', chromosome='1', genomic_nucleotide_accession_version='NC_000067.6', start_position_on_the_genomic_accession=156558590, end_position_on_the_genomic_accession=156649619, orientation='plus', exon_count=14, OMIM=[], no_hdr0=''),
    11354 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=11354, CurrentID=0, Status='live', Symbol='Scgb1b27', Aliases=['A', 'Abp', 'Abpa', 'Abpa27', 'Sa', 'Sal-1', 'Tc', 'Tcp'], description='secretoglobin, family 1B, member 27', other_designations='secretoglobin, family 1B, member 27|androgen binding protein alpha|androgen-binding protein|major allergen 1-like; lacrimal gland protein|salivary androgen-binding alpha subunit|salivary androgen-binding protein alpha subunit', map_location='7 19.38 cM', chromosome='7', genomic_nucleotide_accession_version='NC_000073.6', start_position_on_the_genomic_accession=34021481, end_position_on_the_genomic_accession=34022881, orientation='plus', exon_count=3, OMIM=[], no_hdr0=''),
    11363 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=11363, CurrentID=0, Status='live', Symbol='Acadl', Aliases=['AA960361', 'AU018452', 'C79855', 'LC', 'LCAD'], description='acyl-Coenzyme A dehydrogenase, long-chain', other_designations='long-chain specific acyl-CoA dehydrogenase, mitochondrial|acetyl-Coenzyme A dehydrogenase, long-chain', map_location='1 33.64 cM', chromosome='1', genomic_nucleotide_accession_version='NC_000067.6', start_position_on_the_genomic_accession=66830839, end_position_on_the_genomic_accession=66863309, orientation='minus', exon_count=11, OMIM=[], no_hdr0=''),
    11364 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=11364, CurrentID=0, Status='live', Symbol='Acadm', Aliases=['AU018656', 'MCA', 'MCAD'], description='acyl-Coenzyme A dehydrogenase, medium chain', other_designations='medium-chain specific acyl-CoA dehydrogenase, mitochondrial', map_location='3 78.77 cM', chromosome='3', genomic_nucleotide_accession_version='NC_000069.6', start_position_on_the_genomic_accession=153922353, end_position_on_the_genomic_accession=153944643, orientation='minus', exon_count=12, OMIM=[], no_hdr0=''),
    11370 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=11370, CurrentID=0, Status='live', Symbol='Acadvl', Aliases=['VL', 'vlcad'], description='acyl-Coenzyme A dehydrogenase, very long chain', other_designations='very long-chain specific acyl-CoA dehydrogenase, mitochondrial|MVLCAD', map_location='11 42.96 cM', chromosome='11', genomic_nucleotide_accession_version='NC_000077.6', start_position_on_the_genomic_accession=70010183, end_position_on_the_genomic_accession=70015428, orientation='minus', exon_count=20, OMIM=[], no_hdr0=''),
    11409 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=11409, CurrentID=0, Status='live', Symbol='Acads', Aliases=['AI196007', 'Bcd-1', 'Bcd1', 'Hdlq', 'Hdlq8', 'SC', 'SCAD'], description='acyl-Coenzyme A dehydrogenase, short chain', other_designations='short-chain specific acyl-CoA dehydrogenase, mitochondrial|butyryl-CoA dehydrogenase', map_location='5 F', chromosome='5', genomic_nucleotide_accession_version='NC_000071.6', start_position_on_the_genomic_accession=115110299, end_position_on_the_genomic_accession=115119346, orientation='minus', exon_count=10, OMIM=[], no_hdr0=''),
    11416 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=11416, CurrentID=0, Status='live', Symbol='Slc33a1', Aliases=['AI315656', 'AI788741', 'Ac', 'Acatn', 'D630022N01Rik'], description='solute carrier family 33 (acetyl-CoA transporter), member 1', other_designations='acetyl-coenzyme A transporter 1|AT-1|acetyl-CoA transporter 1|solute carrier family 33 member 1', map_location='3 E1', chromosome='3', genomic_nucleotide_accession_version='NC_000069.6', start_position_on_the_genomic_accession=63942323, end_position_on_the_genomic_accession=63964733, orientation='minus', exon_count=7, OMIM=[], no_hdr0=''),
    11418 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=11418, CurrentID=0, Status='live', Symbol='Asic2', Aliases=['ACIC2', 'Acc', 'Accn1', 'BNC', 'BNC1', 'BNa', 'BNaC1', 'BNaC1a', 'Mdeg'], description='acid-sensing (proton-gated) ion channel 2', other_designations='acid-sensing ion channel 2|amiloride-sensitive brain sodium channel|amiloride-sensitive cation channel 1, neuronal (degenerin)|brain sodium channel 1|degenerin', map_location='11 48.43 cM', chromosome='11', genomic_nucleotide_accession_version='NC_000077.6', start_position_on_the_genomic_accession=80880163, end_position_on_the_genomic_accession=81968396, orientation='minus', exon_count=11, OMIM=[], no_hdr0=''),
    11419 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=11419, CurrentID=0, Status='live', Symbol='Asic1', Aliases=['A', 'AI843610', 'AS', 'ASIC', 'ASIC1a', 'Acc', 'Accn2', 'B530003N02Rik', 'BNa', 'BNaC2'], description='acid-sensing (proton-gated) ion channel 1', other_designations='acid-sensing ion channel 1|amiloride-sensitive cation channel 2, neuronal|brain sodium channel 2|degenerin 2', map_location='15 F1', chromosome='15', genomic_nucleotide_accession_version='NC_000081.6', start_position_on_the_genomic_accession=99670197, end_position_on_the_genomic_accession=99701130, orientation='plus', exon_count=14, OMIM=[], no_hdr0=''),
    11421 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=11421, CurrentID=0, Status='live', Symbol='Ace', Aliases=['AW208573', 'CD143'], description='angiotensin I converting enzyme (peptidyl-dipeptidase A) 1', other_designations='angiotensin-converting enzyme|dipeptidyl carboxypeptidase I|dipeptidyl peptidase|kininase II', map_location='11 68.84 cM', chromosome='11', genomic_nucleotide_accession_version='NC_000077.6', start_position_on_the_genomic_accession=105967948, end_position_on_the_genomic_accession=105989964, orientation='plus', exon_count=26, OMIM=[], no_hdr0=''),
    11423 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=11423, CurrentID=0, Status='live', Symbol='Ache', Aliases=[], description='acetylcholinesterase', other_designations='acetylcholinesterase', map_location='5 76.32 cM', chromosome='5', genomic_nucleotide_accession_version='NC_000071.6', start_position_on_the_genomic_accession=137288247, end_position_on_the_genomic_accession=137294466, orientation='plus', exon_count=5, OMIM=[], no_hdr0=''),
    11425 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=11425, CurrentID=0, Status='live', Symbol='Apoc4', Aliases=['A', 'Acl', 'apo-CIV', 'apoC-IV'], description='apolipoprotein C-IV', other_designations='apolipoprotein C-IV|apolipoprotein C2-linked|apolipoprotein C4', map_location='7 9.94 cM', chromosome='7', genomic_nucleotide_accession_version='NC_000073.6', start_position_on_the_genomic_accession=19678084, end_position_on_the_genomic_accession=19681460, orientation='minus', exon_count=3, OMIM=[], no_hdr0=''),
    11426 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=11426, CurrentID=0, Status='live', Symbol='Macf1', Aliases=['ABP620', 'Ac', 'Acf', 'Acf7', 'Aclp7', 'MACF', 'R74989', 'mKIAA0465'], description='microtubule-actin crosslinking factor 1', other_designations='microtubule-actin cross-linking factor 1|actin cross-linking family 7|actin-crosslinking protein 7|trabeculin alpha', map_location='4 57.42 cM', chromosome='4', genomic_nucleotide_accession_version='NC_000070.6', start_position_on_the_genomic_accession=123349633, end_position_on_the_genomic_accession=123687802, orientation='minus', exon_count=105, OMIM=[], no_hdr0=''),
    11428 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=11428, CurrentID=0, Status='live', Symbol='Aco1', Aliases=['Aco', 'Aco-1', 'I', 'Ir', 'Irebp', 'Irp1'], description='aconitase 1', other_designations='cytoplasmic aconitate hydratase|IRE-BP 1|citrate hydro-lyase|cytoplasmic aconitase|iron regulatory protein 1|iron-responsive element-binding protein 1', map_location='4 20.24 cM', chromosome='4', genomic_nucleotide_accession_version='NC_000070.6', start_position_on_the_genomic_accession=40143265, end_position_on_the_genomic_accession=40199009, orientation='plus', exon_count=21, OMIM=[], no_hdr0=''),
    11429 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=11429, CurrentID=0, Status='live', Symbol='Aco2', Aliases=['Ac', 'Aco', 'Aco-2', 'Aco3', 'D10Wsu183', 'D10Wsu183e'], description='aconitase 2, mitochondrial', other_designations='aconitate hydratase, mitochondrial|citrate hydro-lyase', map_location='15 E1', chromosome='15', genomic_nucleotide_accession_version='NC_000081.6', start_position_on_the_genomic_accession=81872463, end_position_on_the_genomic_accession=81915137, orientation='plus', exon_count=18, OMIM=[], no_hdr0=''),
    11430 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=11430, CurrentID=0, Status='live', Symbol='Acox1', Aliases=['A', 'AOX', 'Acox', 'D130055E20Rik', 'Paox'], description='acyl-Coenzyme A oxidase 1, palmitoyl', other_designations='peroxisomal acyl-coenzyme A oxidase 1|palmitoyl-CoA oxidase|peroxisomal fatty acyl-coenzyme A oxidase|peroxisomal straight-chain Acyl-CoA oxidase', map_location='11 E2', chromosome='11', genomic_nucleotide_accession_version='NC_000077.6', start_position_on_the_genomic_accession=116171883, end_position_on_the_genomic_accession=116199045, orientation='minus', exon_count=15, OMIM=[], no_hdr0=''),
    11431 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=11431, CurrentID=0, Status='live', Symbol='Acp1', Aliases=['4632432E04Rik', 'AI427468', 'Acp', 'Acp-1', 'LMW-', 'LMW-PTP', 'Lm', 'Lmptp'], description='acid phosphatase 1, soluble', other_designations='low molecular weight phosphotyrosine protein phosphatase|LMW-PTPase|low molecular weight cytosolic acid phosphatase', map_location='12 A2', chromosome='12', genomic_nucleotide_accession_version='NC_000078.6', start_position_on_the_genomic_accession=30893326, end_position_on_the_genomic_accession=30911619, orientation='minus', exon_count=7, OMIM=[], no_hdr0=''),
    11432 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=11432, CurrentID=0, Status='live', Symbol='Acp2', Aliases=['Acp', 'Acp-2', 'LAP'], description='acid phosphatase 2, lysosomal', other_designations='lysosomal acid phosphatase', map_location='2 50.54 cM', chromosome='2', genomic_nucleotide_accession_version='NC_000068.7', start_position_on_the_genomic_accession=91202812, end_position_on_the_genomic_accession=91214098, orientation='plus', exon_count=12, OMIM=[], no_hdr0=''),
    11433 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=11433, CurrentID=0, Status='live', Symbol='Acp5', Aliases=['T', 'TR', 'TRACP', 'TRAP'], description='acid phosphatase 5, tartrate resistant', other_designations='tartrate-resistant acid phosphatase type 5|TR-AP|acid phosphatase type V|tartrate-resistant acid ATPase|trATPase|type 5 acid phosphatase', map_location='9 8.38 cM', chromosome='9', genomic_nucleotide_accession_version='NC_000075.6', start_position_on_the_genomic_accession=22126727, end_position_on_the_genomic_accession=22135746, orientation='minus', exon_count=8, OMIM=[], no_hdr0=''),
    11434 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=11434, CurrentID=0, Status='live', Symbol='Acr', Aliases=[], description='acrosin prepropeptide', other_designations='acrosin|preproacrosin', map_location='15 44.96 cM', chromosome='15', genomic_nucleotide_accession_version='NC_000081.6', start_position_on_the_genomic_accession=89568326, end_position_on_the_genomic_accession=89578853, orientation='plus', exon_count=5, OMIM=[], no_hdr0=''),
    11435 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=11435, CurrentID=0, Status='live', Symbol='Chrna1', Aliases=['A', 'AI385656', 'AI608266', 'Achr', 'Achr-1', 'Acra'], description='cholinergic receptor, nicotinic, alpha polypeptide 1 (muscle)', other_designations='acetylcholine receptor subunit alpha', map_location='2 43.76 cM', chromosome='2', genomic_nucleotide_accession_version='NC_000068.7', start_position_on_the_genomic_accession=73563281, end_position_on_the_genomic_accession=73580338, orientation='minus', exon_count=9, OMIM=[], no_hdr0=''),
    11438 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=11438, CurrentID=0, Status='live', Symbol='Chrna4', Aliases=['Ac', 'Acr', 'Acra-4', 'Acra4', 'EBN1', 'ENFL1'], description='cholinergic receptor, nicotinic, alpha polypeptide 4', other_designations='neuronal acetylcholine receptor subunit alpha-4|a4 nicotinic receptor|acetylcholine receptor alpha 4 neural|acetylcholine receptor, neuronal, nicotinic, alpha-4 subunit|alpha4 nAChR', map_location='2 103.54 cM', chromosome='2', genomic_nucleotide_accession_version='NC_000068.7', start_position_on_the_genomic_accession=181022311, end_position_on_the_genomic_accession=181043579, orientation='minus', exon_count=7, OMIM=[], no_hdr0=''),
    11440 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=11440, CurrentID=0, Status='live', Symbol='Chrna6', Aliases=['Ac', 'Acra6', 'Nica6'], description='cholinergic receptor, nicotinic, alpha polypeptide 6', other_designations='neuronal acetylcholine receptor subunit alpha-6|acetylcholine receptor alpha 6 neural|alpha6 nAChR|nicotinic acetylcholine receptor subunit alpha 6', map_location='8 A2', chromosome='8', genomic_nucleotide_accession_version='NC_000074.6', start_position_on_the_genomic_accession=27403212, end_position_on_the_genomic_accession=27413944, orientation='minus', exon_count=6, OMIM=[], no_hdr0=''),
    11441 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=11441, CurrentID=0, Status='live', Symbol='Chrna7', Aliases=['Ac', 'Acra7', 'al', 'alpha7', 'nAchR'], description='cholinergic receptor, nicotinic, alpha polypeptide 7', other_designations='neuronal acetylcholine receptor subunit alpha-7|acetylcholine receptor alpha 7 neural|alpha7 nicotinic receptor|alpha7-nAChR', map_location='7 34.47 cM', chromosome='7', genomic_nucleotide_accession_version='NC_000073.6', start_position_on_the_genomic_accession=63098692, end_position_on_the_genomic_accession=63212526, orientation='minus', exon_count=10, OMIM=[], no_hdr0=''),
    11443 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=11443, CurrentID=0, Status='live', Symbol='Chrnb1', Aliases=['Ac', 'Achr', 'Achr-2', 'Acrb'], description='cholinergic receptor, nicotinic, beta polypeptide 1 (muscle)', other_designations='acetylcholine receptor subunit beta|AChR beta|acetylcholine receptor beta', map_location='11 42.87 cM', chromosome='11', genomic_nucleotide_accession_version='NC_000077.6', start_position_on_the_genomic_accession=69784036, end_position_on_the_genomic_accession=69795966, orientation='minus', exon_count=11, OMIM=[], no_hdr0=''),
    11444 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=11444, CurrentID=0, Status='live', Symbol='Chrnb2', Aliases=['Acr', 'Acrb', 'Acrb-2', 'Acrb2', 'C030030P04Rik', '[b]2-nA', '[b]2-nAchR'], description='cholinergic receptor, nicotinic, beta polypeptide 2 (neuronal)', other_designations='neuronal acetylcholine receptor subunit beta-2|acetylcholine receptor beta 2 neural', map_location='3 39.19 cM', chromosome='3', genomic_nucleotide_accession_version='NC_000069.6', start_position_on_the_genomic_accession=89753448, end_position_on_the_genomic_accession=89764632, orientation='minus', exon_count=7, OMIM=[], no_hdr0=''),
    11447 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=11447, CurrentID=0, Status='live', Symbol='Chrnd', Aliases=['Ac', 'Achr', 'Achr-4', 'Acrd', 'L10076'], description='cholinergic receptor, nicotinic, delta polypeptide', other_designations='acetylcholine receptor subunit delta|AChR delta subunit', map_location='1 44.07 cM', chromosome='1', genomic_nucleotide_accession_version='NC_000067.6', start_position_on_the_genomic_accession=87190597, end_position_on_the_genomic_accession=87200070, orientation='plus', exon_count=12, OMIM=[], no_hdr0=''),
    11448 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=11448, CurrentID=0, Status='live', Symbol='Chrne', Aliases=['ACh', 'AChrepsilon', 'Ac', 'Acre', 'nAChRE'], description='cholinergic receptor, nicotinic, epsilon polypeptide', other_designations='acetylcholine receptor subunit epsilon|AchR epsilon subunit|nicotinic acetylcholine receptor epsilon subunit', map_location='11 43.14 cM', chromosome='11', genomic_nucleotide_accession_version='NC_000077.6', start_position_on_the_genomic_accession=70614883, end_position_on_the_genomic_accession=70619213, orientation='minus', exon_count=12, OMIM=[], no_hdr0=''),
    11449 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=11449, CurrentID=0, Status='live', Symbol='Chrng', Aliases=['Ac', 'Achr', 'Achr-3', 'Acrg'], description='cholinergic receptor, nicotinic, gamma polypeptide', other_designations='acetylcholine receptor subunit gamma|chrng variant N1|chrng variant N2|nicotinic acetylcholine receptor gamma subunit', map_location='1 44.07 cM', chromosome='1', genomic_nucleotide_accession_version='NC_000067.6', start_position_on_the_genomic_accession=87205811, end_position_on_the_genomic_accession=87211835, orientation='plus', exon_count=12, OMIM=[], no_hdr0=''),
    11450 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=11450, CurrentID=0, Status='live', Symbol='Adipoq', Aliases=['30kDa', 'APN', 'Acd', 'Acdc', 'Acr', 'Acrp30', 'Ad', 'Adid', 'GBP2', 'GBP28', 'a', 'adip', 'adipo', 'ap', 'apM1'], description='adiponectin, C1Q and collagen domain containing', other_designations='adiponectin|30 kDa adipocyte complement-related protein|adipocyte complement related protein|adipocyte complement-related 30 kDa protein|adipocyte, C1Q and collagen domain containing|adipocyte, C1q and collagen domain-containing protein|adipocyte-specific protein AdipoQ|adiponectin d', map_location='16 13.96 cM', chromosome='16', genomic_nucleotide_accession_version='NC_000082.6', start_position_on_the_genomic_accession=23146536, end_position_on_the_genomic_accession=23157968, orientation='plus', exon_count=3, OMIM=[], no_hdr0=''),
    11451 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=11451, CurrentID=0, Status='live', Symbol='Acrv1', Aliases=['Msa', 'Msa63', 'SP-', 'SP-10'], description='acrosomal vesicle protein 1', other_designations='acrosomal protein SP-10|MSA-63', map_location='9 20.67 cM', chromosome='9', genomic_nucleotide_accession_version='NC_000075.6', start_position_on_the_genomic_accession=36693220, end_position_on_the_genomic_accession=36698845, orientation='plus', exon_count=5, OMIM=[], no_hdr0=''),
    11459 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=11459, CurrentID=0, Status='live', Symbol='Acta1', Aliases=['AA959943', 'Ac', 'Acta-2', 'Acts', 'Actsk', 'Actsk-1'], description='actin, alpha 1, skeletal muscle', other_designations='actin, alpha skeletal muscle|alpha-actin-1', map_location='8 72.26 cM', chromosome='8', genomic_nucleotide_accession_version='NC_000074.6', start_position_on_the_genomic_accession=123891758, end_position_on_the_genomic_accession=123894775, orientation='minus', exon_count=8, OMIM=[], no_hdr0=''),
    11461 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=11461, CurrentID=0, Status='live', Symbol='Actb', Aliases=['Act', 'Actx', 'E430023M04Rik', 'beta-a', 'beta-actin'], description='actin, beta', other_designations='actin, cytoplasmic 1|A-X actin-like protein|actin, beta, cytoplasmic|melanoma X-actin', map_location='5 81.8 cM', chromosome='5', genomic_nucleotide_accession_version='NC_000071.6', start_position_on_the_genomic_accession=142903115, end_position_on_the_genomic_accession=142907976, orientation='minus', exon_count=7, OMIM=[], no_hdr0=''),
    11464 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=11464, CurrentID=0, Status='live', Symbol='Actc1', Aliases=['Actc-', 'Actc-1'], description='actin, alpha, cardiac muscle 1', other_designations='actin, alpha cardiac muscle 1|actin alpha cardiac|alpha-cardiac actin|alphac-actin', map_location='2 57.55 cM', chromosome='2', genomic_nucleotide_accession_version='NC_000068.7', start_position_on_the_genomic_accession=114047282, end_position_on_the_genomic_accession=114052875, orientation='minus', exon_count=7, OMIM=[], no_hdr0=''),
    11465 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=11465, CurrentID=0, Status='live', Symbol='Actg1', Aliases=['AL023024', 'Ac', 'Actg', 'Actl', 'E51'], description='actin, gamma, cytoplasmic 1', other_designations='actin, cytoplasmic 2|beta-actin FE-3|gamma-actin', map_location='11 E2', chromosome='11', genomic_nucleotide_accession_version='NC_000077.6', start_position_on_the_genomic_accession=120345687, end_position_on_the_genomic_accession=120348495, orientation='minus', exon_count=7, OMIM=[], no_hdr0=''),
    11468 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=11468, CurrentID=0, Status='live', Symbol='Actg2', Aliases=['ACTA3', 'Act', 'Act-', 'Act-4', 'Act4', 'SM', 'SMGA'], description='actin, gamma 2, smooth muscle, enteric', other_designations='actin, gamma-enteric smooth muscle|alpha-actin-3|gamma-2-actin|smooth muscle gamma-actin', map_location='6 35.94 cM', chromosome='6', genomic_nucleotide_accession_version='NC_000072.6', start_position_on_the_genomic_accession=83512909, end_position_on_the_genomic_accession=83536251, orientation='minus', exon_count=9, OMIM=[], no_hdr0=''),
    11470 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=11470, CurrentID=0, Status='live', Symbol='Actl7a', Aliases=['Tact', 'Tact2'], description='actin-like 7a', other_designations='actin-like protein 7A|T-actin-2|actin-like Tact2|actin-like-7-alpha|t-actin 2|testis-specific actin-2', map_location='4 31.66 cM', chromosome='4', genomic_nucleotide_accession_version='NC_000070.6', start_position_on_the_genomic_accession=56743422, end_position_on_the_genomic_accession=56744925, orientation='plus', exon_count=1, OMIM=[], no_hdr0=''),
    11471 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=11471, CurrentID=0, Status='live', Symbol='Actl7b', Aliases=['Gm26657', 'Tact', 'Tact1'], description='actin-like 7b', other_designations='actin-like protein 7B|T-actin-1|actin-like-7-beta|t-actin 1|testis-specific actin-1', map_location='4 31.66 cM', chromosome='4', genomic_nucleotide_accession_version='NC_000070.6', start_position_on_the_genomic_accession=56740005, end_position_on_the_genomic_accession=56741425, orientation='minus', exon_count=1, OMIM=[], no_hdr0=''),
    11472 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=11472, CurrentID=0, Status='live', Symbol='Actn2', Aliases=['1110008F24Rik'], description='actinin alpha 2', other_designations='alpha-actinin-2|F-actin cross-linking protein|alpha-actinin skeletal muscle', map_location='13 4.54 cM', chromosome='13', genomic_nucleotide_accession_version='NC_000079.6', start_position_on_the_genomic_accession=12269426, end_position_on_the_genomic_accession=12340732, orientation='minus', exon_count=21, OMIM=[], no_hdr0=''),
    11474 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=11474, CurrentID=0, Status='live', Symbol='Actn3', Aliases=[], description='actinin alpha 3', other_designations='alpha-actinin-3|F-actin cross-linking protein|alpha-actinin skeletal muscle', map_location='19 4.12 cM', chromosome='19', genomic_nucleotide_accession_version='NC_000085.6', start_position_on_the_genomic_accession=4861216, end_position_on_the_genomic_accession=4877909, orientation='minus', exon_count=21, OMIM=[], no_hdr0=''),
    11475 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=11475, CurrentID=0, Status='live', Symbol='Acta2', Aliases=['0610041G09Rik', 'Ac', 'Actvs', 'SM', 'SMAalpha', 'SMalphaA', 'a-', 'a-SMA', 'al', 'alphaSMA'], description='actin, alpha 2, smooth muscle, aorta', other_designations='actin, aortic smooth muscle|actin, alpha, vascular smooth muscle|alpha-actin-2', map_location='19 C1', chromosome='19', genomic_nucleotide_accession_version='NC_000085.6', start_position_on_the_genomic_accession=34240336, end_position_on_the_genomic_accession=34255585, orientation='minus', exon_count=10, OMIM=[], no_hdr0=''),
    11477 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=11477, CurrentID=0, Status='live', Symbol='Acvr1', Aliases=['A', 'AL', 'ALK2', 'Ac', 'Act', 'ActR-I', 'ActRIA', 'Acv', 'Acvra', 'Acvrlk2', 'Alk', 'Alk-2', 'Alk8', 'D330013D15Rik', 'SK', 'SKR1', 'Tsk', 'Tsk7L', 'Acvr1'], description='activin A receptor, type 1', other_designations='activin receptor type-1|TGF-B superfamily receptor type I|TSK-7L|TSR-I|activin receptor type I|serine/threonine-protein kinase receptor R1', map_location='2 C1.1', chromosome='2', genomic_nucleotide_accession_version='NC_000068.7', start_position_on_the_genomic_accession=58446438, end_position_on_the_genomic_accession=58566828, orientation='minus', exon_count=15, OMIM=[], no_hdr0=''),
    11479 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=11479, CurrentID=0, Status='live', Symbol='Acvr1b', Aliases=['6820432J04', 'ALK-4', 'Act', 'ActR', 'ActR-IB', 'ActRIB', 'Acv', 'Acvrlk4', 'Al', 'Alk4', 'SK', 'SKR2'], description='activin A receptor, type 1B', other_designations='activin receptor type-1B|activin receptor type IB|activin receptor-like kinase 4|serine/threonine-protein kinase receptor R2', map_location='15 56.48 cM', chromosome='15', genomic_nucleotide_accession_version='NC_000081.6', start_position_on_the_genomic_accession=101174072, end_position_on_the_genomic_accession=101213684, orientation='plus', exon_count=9, OMIM=[], no_hdr0=''),
    11480 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=11480, CurrentID=0, Status='live', Symbol='Acvr2a', Aliases=['Ac', 'ActrIIa', 'Acvr2', 'TactrII', 'tAc'], description='activin receptor IIA', other_designations='activin receptor type-2A|ACTR-IIA|activin receptor type IIA', map_location='2 28.38 cM', chromosome='2', genomic_nucleotide_accession_version='NC_000068.7', start_position_on_the_genomic_accession=48814109, end_position_on_the_genomic_accession=48903264, orientation='plus', exon_count=12, OMIM=[], no_hdr0=''),
    11481 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=11481, CurrentID=0, Status='live', Symbol='Acvr2b', Aliases=['4930516B21Rik', 'AI047905', 'Act', 'ActRIIB'], description='activin receptor IIB', other_designations='activin receptor type-2B|activin receptor type IIB', map_location='9 F3', chromosome='9', genomic_nucleotide_accession_version='NC_000075.6', start_position_on_the_genomic_accession=119401583, end_position_on_the_genomic_accession=119442148, orientation='plus', exon_count=12, OMIM=[], no_hdr0=''),
    11482 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=11482, CurrentID=0, Status='live', Symbol='Acvrl1', Aliases=['AI115505', 'AI427544', 'Acv', 'Acvrlk1', 'Al', 'Alk', 'Alk1'], description='activin A receptor, type II-like 1', other_designations='serine/threonine-protein kinase receptor R3|SKR3|TGF-B superfamily receptor type I|TSR-I|activin receptor-like kinase 1', map_location='15 F1', chromosome='15', genomic_nucleotide_accession_version='NC_000081.6', start_position_on_the_genomic_accession=101128522, end_position_on_the_genomic_accession=101145336, orientation='plus', exon_count=13, OMIM=[], no_hdr0=''),
    11484 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=11484, CurrentID=0, Status='live', Symbol='Aspa', Aliases=['Acy', 'Acy-', 'Acy-2', 'Acy2', 'nu', 'nur7'], description='aspartoacylase', other_designations='aspartoacylase|aminoacylase-2|aspartoacylase (aminoacylase) 2', map_location='11 B4', chromosome='11', genomic_nucleotide_accession_version='NC_000077.6', start_position_on_the_genomic_accession=73304987, end_position_on_the_genomic_accession=73326876, orientation='minus', exon_count=10, OMIM=[], no_hdr0=''),
    11486 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=11486, CurrentID=0, Status='live', Symbol='Ada', Aliases=[], description='adenosine deaminase', other_designations='adenosine deaminase|adenosine aminohydrolase', map_location='2 H3', chromosome='2', genomic_nucleotide_accession_version='NC_000068.7', start_position_on_the_genomic_accession=163726571, end_position_on_the_genomic_accession=163750239, orientation='minus', exon_count=12, OMIM=[], no_hdr0=''),
    11487 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=11487, CurrentID=0, Status='live', Symbol='Adam10', Aliases=['1700031C13Rik', 'MADM', 'kuz', 'kuzb', 'kuzbanian'], description='a disintegrin and metallopeptidase domain 10', other_designations='disintegrin and metalloproteinase domain-containing protein 10|a disintegrin and metalloprotease domain (ADAM) 10|kuzbanian protein homolog|mammalian disintegrin-metalloprotease', map_location='9 39.53 cM', chromosome='9', genomic_nucleotide_accession_version='NC_000075.6', start_position_on_the_genomic_accession=70678944, end_position_on_the_genomic_accession=70780229, orientation='plus', exon_count=17, OMIM=[], no_hdr0=''),
    11488 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=11488, CurrentID=0, Status='live', Symbol='Adam11', Aliases=['AW060611', 'Mdc'], description='a disintegrin and metallopeptidase domain 11', other_designations='disintegrin and metalloproteinase domain-containing protein 11|a disintegrin and metalloprotease domain (ADAM) 11|metalloproteinase-like, disintegrin-like, and cysteine-rich protein', map_location='11 66.48 cM', chromosome='11', genomic_nucleotide_accession_version='NC_000077.6', start_position_on_the_genomic_accession=102761413, end_position_on_the_genomic_accession=102780263, orientation='plus', exon_count=26, OMIM=[], no_hdr0=''),
    11489 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=11489, CurrentID=0, Status='live', Symbol='Adam12', Aliases=['ADAM', 'Ml', 'Mltna'], description='a disintegrin and metallopeptidase domain 12 (meltrin alpha)', other_designations='disintegrin and metalloproteinase domain-containing protein 12|a disintegrin and metalloprotease domain 12|a disintegrin and metalloproteinase domain 12 (meltrin alpha)', map_location='7 F3', chromosome='7', genomic_nucleotide_accession_version='NC_000073.6', start_position_on_the_genomic_accession=133883199, end_position_on_the_genomic_accession=134225097, orientation='minus', exon_count=23, OMIM=[], no_hdr0=''),
    11490 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=11490, CurrentID=0, Status='live', Symbol='Adam15', Aliases=['AD56', 'MDC15', 'metar'], description='a disintegrin and metallopeptidase domain 15 (metargidin)', other_designations='disintegrin and metalloproteinase domain-containing protein 15|a disintegrin and metalloprotease domain 15 (metargidin)|metalloprotease RGD disintegrin protein|metalloproteinase-like, disintegrin-like, and cysteine-rich protein 15', map_location='3 39.07 cM', chromosome='3', genomic_nucleotide_accession_version='NC_000069.6', start_position_on_the_genomic_accession=89339640, end_position_on_the_genomic_accession=89350028, orientation='minus', exon_count=25, OMIM=[], no_hdr0=''),
    11491 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=11491, CurrentID=0, Status='live', Symbol='Adam17', Aliases=['CD156b', 'Tac', 'Tace'], description='a disintegrin and metallopeptidase domain 17', other_designations='disintegrin and metalloproteinase domain-containing protein 17|TNF-alpha convertase|TNF-alpha converting enzyme', map_location='12 8.3 cM', chromosome='12', genomic_nucleotide_accession_version='NC_000078.6', start_position_on_the_genomic_accession=21323509, end_position_on_the_genomic_accession=21373632, orientation='minus', exon_count=20, OMIM=[], no_hdr0=''),
    11492 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=11492, CurrentID=0, Status='live', Symbol='Adam19', Aliases=['AL024287', 'MADDAM', 'MTLNB', 'Mlt', 'Mltnb'], description='a disintegrin and metallopeptidase domain 19 (meltrin beta)', other_designations='disintegrin and metalloproteinase domain-containing protein 19|MDC beta|Mel beta|a disintegrin and metalloproteinase domain 19 (meltrin beta)|adamalysin 19', map_location='11 27.54 cM', chromosome='11', genomic_nucleotide_accession_version='NC_000077.6', start_position_on_the_genomic_accession=46054502, end_position_on_the_genomic_accession=46147347, orientation='plus', exon_count=25, OMIM=[], no_hdr0=''),
    11495 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=11495, CurrentID=0, Status='live', Symbol='Adam2', Aliases=['AI323749', 'Ftn', 'Ftnb', 'Ph30-be', 'Ph30-beta'], description='a disintegrin and metallopeptidase domain 2', other_designations='disintegrin and metalloproteinase domain-containing protein 2|a disintegrin and metalloprotease domain 2 (fertilin beta)|fertilin subunit beta', map_location='14 34.36 cM', chromosome='14', genomic_nucleotide_accession_version='NC_000080.6', start_position_on_the_genomic_accession=66027322, end_position_on_the_genomic_accession=66077851, orientation='minus', exon_count=21, OMIM=[], no_hdr0=''),
    11496 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=11496, CurrentID=0, Status='live', Symbol='Adam22', Aliases=['2900022I03Rik', 'AI854032', 'MDC2'], description='a disintegrin and metallopeptidase domain 22', other_designations='disintegrin and metalloproteinase domain-containing protein 22|a disintegrin and metalloprotease domain (ADAM) 22', map_location='5 3.39 cM', chromosome='5', genomic_nucleotide_accession_version='NC_000071.6', start_position_on_the_genomic_accession=8072347, end_position_on_the_genomic_accession=8368312, orientation='minus', exon_count=35, OMIM=[], no_hdr0=''),
    11497 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=11497, CurrentID=0, Status='live', Symbol='Adam3', Aliases=['ADA', 'Cyr', 'Cyrn1', 'Taz8', 'Taz83', 'tMDC'], description='a disintegrin and metallopeptidase domain 3 (cyritestin)', other_designations='A disintegrin and metallopeptidase domain 3', map_location='8 13.09 cM', chromosome='8', genomic_nucleotide_accession_version='NC_000074.6', start_position_on_the_genomic_accession=24677232, end_position_on_the_genomic_accession=24726377, orientation='minus', exon_count=23, OMIM=[], no_hdr0=''),
    11498 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=11498, CurrentID=0, Status='live', Symbol='Adam4', Aliases=['AV274654', 'tMDC', 'tMDCV'], description='a disintegrin and metallopeptidase domain 4', other_designations='a disintegrin and metallopeptidase domain 4|a disintegrin and metalloprotease domain (ADAM) 4|a disintegrin and metalloprotease domain 4', map_location='12 D1', chromosome='12', genomic_nucleotide_accession_version='NC_000078.6', start_position_on_the_genomic_accession=81419443, end_position_on_the_genomic_accession=81422039, orientation='minus', exon_count=1, OMIM=[], no_hdr0=''),
    11499 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=11499, CurrentID=0, Status='live', Symbol='Adam5', Aliases=['tMDC', 'tMDC II', 'tMDCII'], description='a disintegrin and metallopeptidase domain 5', other_designations='disintegrin and metalloproteinase domain-containing protein 5|a disintegrin and metalloprotease domain (ADAM) 5|transmembrane metalloproteinase-like, disintegrin-like, and cysteine-rich protein II', map_location='8 13.26 cM', chromosome='8', genomic_nucleotide_accession_version='NC_000074.6', start_position_on_the_genomic_accession=24727093, end_position_on_the_genomic_accession=24824369, orientation='minus', exon_count=22, OMIM=[], no_hdr0=''),
    11500 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=11500, CurrentID=0, Status='live', Symbol='Adam7', Aliases=['ADAM 7', 'EA', 'EAP1', 'EAPI'], description='a disintegrin and metallopeptidase domain 7', other_designations='disintegrin and metalloproteinase domain-containing protein 7|a disintegrin and metalloprotease domain (ADAM) 7|epididymal apical protein I', map_location='14 D1', chromosome='14', genomic_nucleotide_accession_version='NC_000080.6', start_position_on_the_genomic_accession=68497336, end_position_on_the_genomic_accession=68533689, orientation='minus', exon_count=23, OMIM=[], no_hdr0=''),
    11501 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=11501, CurrentID=0, Status='live', Symbol='Adam8', Aliases=['ADAM 8', 'CD156', 'CD156a', 'E430039A18Rik', 'MS', 'MS2'], description='a disintegrin and metallopeptidase domain 8', other_designations='disintegrin and metalloproteinase domain-containing protein 8|a disintegrin and metalloprotease domain 8|cell surface antigen MS2|macrophage cysteine-rich glycoprotein', map_location='7 F4', chromosome='7', genomic_nucleotide_accession_version='NC_000073.6', start_position_on_the_genomic_accession=139978932, end_position_on_the_genomic_accession=139995207, orientation='minus', exon_count=26, OMIM=[], no_hdr0=''),
    11502 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=11502, CurrentID=0, Status='live', Symbol='Adam9', Aliases=['AU020942', 'MDC9', 'Mlt', 'Mltng', 'mKIAA0021'], description='a disintegrin and metallopeptidase domain 9 (meltrin gamma)', other_designations='disintegrin and metalloproteinase domain-containing protein 9|a disintegrin and metalloproteinase domain 9 (meltrin gamma)|metalloprotease/disintegrin/cysteine-rich protein 9|myeloma cell metalloproteinase', map_location='8 13.7 cM', chromosome='8', genomic_nucleotide_accession_version='NC_000074.6', start_position_on_the_genomic_accession=24949611, end_position_on_the_genomic_accession=25017040, orientation='minus', exon_count=23, OMIM=[], no_hdr0=''),
    11504 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=11504, CurrentID=0, Status='live', Symbol='Adamts1', Aliases=['ADAM-', 'ADAM-TS1', 'ADAMT', 'ADAMTS', 'ADAMTS-1', 'C3-C5', 'METH-1', 'METH1'], description='a disintegrin-like and metallopeptidase (reprolysin type) with thrombospondin type 1 motif, 1', other_designations='A disintegrin and metalloproteinase with thrombospondin motifs 1|ADAM-TS 1', map_location='16 48.2 cM', chromosome='16', genomic_nucleotide_accession_version='NC_000082.6', start_position_on_the_genomic_accession=85793827, end_position_on_the_genomic_accession=85803113, orientation='minus', exon_count=9, OMIM=[], no_hdr0=''),
    11512 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=11512, CurrentID=0, Status='live', Symbol='Adcy6', Aliases=['AC', 'AC6', 'mKIAA0422'], description='adenylate cyclase 6', other_designations='adenylate cyclase type 6|ATP pyrophosphate-lyase 6|adenylate cyclase type VI|adenylyl cyclase 6|ca(2+)-inhibitable adenylyl cyclase', map_location='15 F1', chromosome='15', genomic_nucleotide_accession_version='NC_000081.6', start_position_on_the_genomic_accession=98589978, end_position_on_the_genomic_accession=98610287, orientation='minus', exon_count=28, OMIM=[], no_hdr0=''),
    11513 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=11513, CurrentID=0, Status='live', Symbol='Adcy7', Aliases=['AA407758'], description='adenylate cyclase 7', other_designations='adenylate cyclase type 7|ATP pyrophosphate-lyase 7|adenylate cyclase type VII|adenylyl cyclase 7|adenylyl cyclase type VII', map_location='8 43.06 cM', chromosome='8', genomic_nucleotide_accession_version='NC_000074.6', start_position_on_the_genomic_accession=88272190, end_position_on_the_genomic_accession=88329965, orientation='plus', exon_count=36, OMIM=[], no_hdr0=''),
    11514 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=11514, CurrentID=0, Status='live', Symbol='Adcy8', Aliases=['AC', 'AC8', 'AW060868'], description='adenylate cyclase 8', other_designations='adenylate cyclase type 8|ATP pyrophosphate-lyase 8|adenylate cyclase type VIII|adenylyl cyclase 8|ca(2+)/calmodulin-activated adenylyl cyclase', map_location='15 29.03 cM', chromosome='15', genomic_nucleotide_accession_version='NC_000081.6', start_position_on_the_genomic_accession=64699035, end_position_on_the_genomic_accession=64922296, orientation='minus', exon_count=18, OMIM=[], no_hdr0=''),
    11515 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=11515, CurrentID=0, Status='live', Symbol='Adcy9', Aliases=['AC9', 'ACtp', 'ACtp10', 'AW125421', 'D16Wsu65', 'D16Wsu65e', 'mKIAA0520'], description='adenylate cyclase 9', other_designations='adenylate cyclase type 9|ATP pyrophosphate-lyase 9|adenylate cyclase type IX|adenylyl cyclase 9|adenylyl cyclase type 10', map_location='16 2.42 cM', chromosome='16', genomic_nucleotide_accession_version='NC_000082.6', start_position_on_the_genomic_accession=4284886, end_position_on_the_genomic_accession=4437236, orientation='minus', exon_count=12, OMIM=[], no_hdr0=''),
    11516 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=11516, CurrentID=0, Status='live', Symbol='Adcyap1', Aliases=['P', 'PACAP'], description='adenylate cyclase activating polypeptide 1', other_designations='pituitary adenylate cyclase-activating polypeptide', map_location='17 E5', chromosome='17', genomic_nucleotide_accession_version='NC_000083.6', start_position_on_the_genomic_accession=93198245, end_position_on_the_genomic_accession=93206541, orientation='plus', exon_count=7, OMIM=[], no_hdr0=''),
    11517 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=11517, CurrentID=0, Status='live', Symbol='Adcyap1r1', Aliases=['2900024I10Rik', 'AI846590', 'PA', 'PAC', 'PAC1', 'PAC1R', 'PACAP1-R'], description='adenylate cyclase activating polypeptide 1 receptor 1', other_designations='pituitary adenylate cyclase-activating polypeptide type I receptor|PACAP type I receptor', map_location='6 B3', chromosome='6', genomic_nucleotide_accession_version='NC_000072.6', start_position_on_the_genomic_accession=55451501, end_position_on_the_genomic_accession=55501455, orientation='plus', exon_count=18, OMIM=[], no_hdr0=''),
    11518 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=11518, CurrentID=0, Status='live', Symbol='Add1', Aliases=['AI256389'], description='adducin 1 (alpha)', other_designations='alpha-adducin|erythrocyte adducin subunit alpha', map_location='5 17.9 cM', chromosome='5', genomic_nucleotide_accession_version='NC_000071.6', start_position_on_the_genomic_accession=34573664, end_position_on_the_genomic_accession=34632308, orientation='plus', exon_count=20, OMIM=[], no_hdr0=''),
    11519 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=11519, CurrentID=0, Status='live', Symbol='Add2', Aliases=['2900072M03Rik', 'add97'], description='adducin 2 (beta)', other_designations='beta-adducin|erythrocyte adducin subunit beta|snoRNA MBII-396', map_location='6 37.55 cM', chromosome='6', genomic_nucleotide_accession_version='NC_000072.6', start_position_on_the_genomic_accession=86028681, end_position_on_the_genomic_accession=86124409, orientation='plus', exon_count=17, OMIM=[], no_hdr0=''),
    11520 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=11520, CurrentID=0, Status='live', Symbol='Plin2', Aliases=['A', 'AA407157', 'AD', 'ADPH', 'Adfp', 'Adrp'], description='perilipin 2', other_designations='perilipin-2|adipophilin|adipose differentiation-related protein', map_location='4 40.69 cM', chromosome='4', genomic_nucleotide_accession_version='NC_000070.6', start_position_on_the_genomic_accession=86626910, end_position_on_the_genomic_accession=86670217, orientation='minus', exon_count=10, OMIM=[], no_hdr0=''),
    11522 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=11522, CurrentID=0, Status='live', Symbol='Adh1', Aliases=['ADH', 'ADH-A2', 'ADH-AA', 'AI194826', 'Adh-', 'Adh-1', 'Adh-1-', 'Adh-1-t', 'Adh-1e', 'Adh-1t', 'Adh-3e-', 'Adh1-e', 'Adh1-t', 'Adh1tl', 'Adh3-e', 'Adh1'], description='alcohol dehydrogenase 1 (class I)', other_designations='alcohol dehydrogenase 1|alcohol dehydrogenase 1 temporal, liver|alcohol dehydrogenase 1, complex|alcohol dehydrogenase 1, electrophoretic|alcohol dehydrogenase 3, electrophoretic|alcohol dehydrogenase A subunit|class I alcohol dehydrogenase', map_location='3 64.16 cM', chromosome='3', genomic_nucleotide_accession_version='NC_000069.6', start_position_on_the_genomic_accession=138277585, end_position_on_the_genomic_accession=138290698, orientation='plus', exon_count=9, OMIM=[], no_hdr0=''),
    11529 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=11529, CurrentID=0, Status='live', Symbol='Adh7', Aliases=['AI325182', 'Adh', 'Adh-', 'Adh-3', 'Adh-3e', 'Adh-3t', 'Adh3', 'Adh3-', 'Adh3-e', 'Adh3-t', 'Adh4', 'Adt-', 'Adt-1'], description='alcohol dehydrogenase 7 (class IV), mu or sigma polypeptide', other_designations='all-trans-retinol dehydrogenase [NAD(+)] ADH7|ADH-C2|IV ADH|alcohol dehydrogenase 3 complex|alcohol dehydrogenase 3 temporal|alcohol dehydrogenase 4|alcohol dehydrogenase class 4 mu/sigma chain|alcohol dehydrogenase class IV mu/sigma chain|gastric alcohol dehydrogenase|omega-hydroxydecanoate dehydrogenase ADH7|retinol dehydrogenase', map_location='3 64.13 cM', chromosome='3', genomic_nucleotide_accession_version='NC_000069.6', start_position_on_the_genomic_accession=138198064, end_position_on_the_genomic_accession=138232042, orientation='plus', exon_count=11, OMIM=[], no_hdr0=''),
    11532 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=11532, CurrentID=0, Status='live', Symbol='Adh5', Aliases=['Adh', 'Adh-', 'Adh-5', 'Adh3', 'G', 'GSNOR'], description='alcohol dehydrogenase 5 (class III), chi polypeptide', other_designations='alcohol dehydrogenase class-3|ADH-B2|FALDH|FDH|GSH-FDH|S-(hydroxymethyl)glutathione dehydrogenase|S-nitrosoglutathione reductase|alcohol dehydrogenase 2|alcohol dehydrogenase B2|alcohol dehydrogenase class-III|glutathione-dependent formaldehyde dehydrogenase', map_location='3 G3', chromosome='3', genomic_nucleotide_accession_version='NC_000069.6', start_position_on_the_genomic_accession=138437200, end_position_on_the_genomic_accession=138455499, orientation='plus', exon_count=10, OMIM=[], no_hdr0=''),
    11534 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=11534, CurrentID=0, Status='live', Symbol='Adk', Aliases=['2310026J05Rik', '5033405D03Rik', 'A', 'AI255373', 'AI987814', 'Ak'], description='adenosine kinase', other_designations="adenosine kinase|adenosine 5'-phosphotransferase", map_location='14 A3', chromosome='14', genomic_nucleotide_accession_version='NC_000080.6', start_position_on_the_genomic_accession=21052574, end_position_on_the_genomic_accession=21448569, orientation='plus', exon_count=14, OMIM=[], no_hdr0=''),
    11535 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=11535, CurrentID=0, Status='live', Symbol='Adm', Aliases=['A', 'AM'], description='adrenomedullin', other_designations='pro-adrenomedullin', map_location='7 57.7 cM', chromosome='7', genomic_nucleotide_accession_version='NC_000073.6', start_position_on_the_genomic_accession=110627657, end_position_on_the_genomic_accession=110629820, orientation='plus', exon_count=4, OMIM=[], no_hdr0=''),
    11536 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=11536, CurrentID=0, Status='live', Symbol='Gpr182', Aliases=['AM', 'AM-R', 'Ad', 'Admr', 'G10-D', 'Gpcr', 'Gpcr17', 'Gpcr22', 'MB10', 'N', 'NOW'], description='G protein-coupled receptor 182', other_designations='G-protein coupled receptor 182|G10D|adrenomedullin receptor', map_location='10 75.07 cM', chromosome='10', genomic_nucleotide_accession_version='NC_000076.6', start_position_on_the_genomic_accession=127749602, end_position_on_the_genomic_accession=127751798, orientation='minus', exon_count=2, OMIM=[], no_hdr0=''),
    11537 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=11537, CurrentID=0, Status='live', Symbol='Cfd', Aliases=['A', 'Adn', 'DF'], description='complement factor D (adipsin)', other_designations='complement factor D|28 kDa adipocyte protein|C3 convertase activator|D component (adipsin) of complement|properdin factor D', map_location='10 39.72 cM', chromosome='10', genomic_nucleotide_accession_version='NC_000076.6', start_position_on_the_genomic_accession=79890853, end_position_on_the_genomic_accession=79892655, orientation='plus', exon_count=5, OMIM=[], no_hdr0=''),
    11538 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=11538, CurrentID=0, Status='live', Symbol='Adnp', Aliases=['AA589558', 'mKIAA0784'], description='activity-dependent neuroprotective protein', other_designations='activity-dependent neuroprotector homeobox protein', map_location='2 H3', chromosome='2', genomic_nucleotide_accession_version='NC_000068.7', start_position_on_the_genomic_accession=168180965, end_position_on_the_genomic_accession=168207112, orientation='minus', exon_count=5, OMIM=[], no_hdr0=''),
    11539 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=11539, CurrentID=0, Status='live', Symbol='Adora1', Aliases=['A', 'A1', 'A1-AR', 'A1AR', 'A1R', 'AA1R', 'AI848715', 'ARA1', 'BB176431', 'Ri'], description='adenosine A1 receptor', other_designations='adenosine receptor A1', map_location='1 E4', chromosome='1', genomic_nucleotide_accession_version='NC_000067.6', start_position_on_the_genomic_accession=134199215, end_position_on_the_genomic_accession=134235457, orientation='minus', exon_count=4, OMIM=[], no_hdr0=''),
    11540 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=11540, CurrentID=0, Status='live', Symbol='Adora2a', Aliases=['A', 'A2AAR', 'A2aR', 'AA2AR', 'ARA2A'], description='adenosine A2a receptor', other_designations='adenosine receptor A2a', map_location='10 C1', chromosome='10', genomic_nucleotide_accession_version='NC_000076.6', start_position_on_the_genomic_accession=75316877, end_position_on_the_genomic_accession=75334792, orientation='plus', exon_count=6, OMIM=[], no_hdr0=''),
    11541 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=11541, CurrentID=0, Status='live', Symbol='Adora2b', Aliases=['A2', 'A2BAR', 'A2BR', 'A2b', 'AA', 'AA2BR', 'AI480866', 'AI605384', 'AR', 'ARA2B'], description='adenosine A2b receptor', other_designations='adenosine receptor A2b|A2b, Rs', map_location='11 B2', chromosome='11', genomic_nucleotide_accession_version='NC_000077.6', start_position_on_the_genomic_accession=62248984, end_position_on_the_genomic_accession=62266452, orientation='plus', exon_count=2, OMIM=[], no_hdr0=''),
    11542 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=11542, CurrentID=0, Status='live', Symbol='Adora3', Aliases=['A', 'A3AR', 'A3R', 'AA3R', 'ARA3', 'Gpcr2'], description='adenosine A3 receptor', other_designations='adenosine receptor A3|G-protein coupled receptor 2', map_location='3 46.45 cM', chromosome='3', genomic_nucleotide_accession_version='NC_000069.6', start_position_on_the_genomic_accession=105904421, end_position_on_the_genomic_accession=105908928, orientation='plus', exon_count=2, OMIM=[], no_hdr0=''),
    11544 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=11544, CurrentID=0, Status='live', Symbol='Adprh', Aliases=['Ar', 'Arh1'], description='ADP-ribosylarginine hydrolase', other_designations='ADP-ribosylarginine hydrolase|ADP-ribose-L-arginine cleaving enzyme|[Protein ADP-ribosylarginine] hydrolase', map_location='16 B4', chromosome='16', genomic_nucleotide_accession_version='NC_000082.6', start_position_on_the_genomic_accession=38445399, end_position_on_the_genomic_accession=38452689, orientation='minus', exon_count=4, OMIM=[], no_hdr0=''),
    11545 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=11545, CurrentID=0, Status='live', Symbol='Parp1', Aliases=['5830444G22Rik', 'A', 'AI893648', 'ARTD1', 'Adp', 'Adprp', 'Adprt1', 'C80510', 'PARP', 'PPOL', 'msPARP', 'pa', 'parp-1', 'sP', 'sPARP-1'], description='poly (ADP-ribose) polymerase family, member 1', other_designations='poly [ADP-ribose] polymerase 1|ADP-ribosyltransferase (NAD+, poly (ADP-ribose) polymerase) 1|ADP-ribosyltransferase diphtheria toxin-like 1|ADPRT 1|DNA ADP-ribosyltransferase PARP1|NAD(+) ADP-ribosyltransferase 1|poly(ADP-ribose) polymerase|poly[ADP-ribose] synthase 1|poly[ADP-ribose] synthetase 1|protein poly-ADP-ribosyltransferase PARP1', map_location='1 84.44 cM', chromosome='1', genomic_nucleotide_accession_version='NC_000067.6', start_position_on_the_genomic_accession=180568891, end_position_on_the_genomic_accession=180600999, orientation='plus', exon_count=23, OMIM=[], no_hdr0=''),
    11546 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=11546, CurrentID=0, Status='live', Symbol='Parp2', Aliases=['ADPRT-2', 'ARTD2', 'Adp', 'Adprt2', 'Adprtl2', 'As', 'Aspartl2', 'C78626', 'PA', 'PARP-2', 'mPARP-2', 'pADPRT-2'], description='poly (ADP-ribose) polymerase family, member 2', other_designations='poly [ADP-ribose] polymerase 2|ADP-ribosyltransferase (NAD+, poly(ADP-ribose) polymerase)-like 2|ADP-ribosyltransferase (NAD+; poly (ADP-ribose) polymerase) 2|ADP-ribosyltransferase diphtheria toxin-like 2|DNA ADP-ribosyltransferase PARP2|NAD(+) ADP-ribosyltransferase 2|poly[ADP-ribose] synthase 2|poly[ADP-ribose] synthetase 2|protein poly-ADP-ribosyltransferase PARP2', map_location='14 C1', chromosome='14', genomic_nucleotide_accession_version='NC_000080.6', start_position_on_the_genomic_accession=50807897, end_position_on_the_genomic_accession=50821301, orientation='plus', exon_count=16, OMIM=[], no_hdr0=''),
    11548 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=11548, CurrentID=0, Status='live', Symbol='Adra1b', Aliases=['[a]1b'], description='adrenergic receptor, alpha 1b', other_designations='alpha-1B adrenergic receptor|alpha-1B adrenoceptor|alpha-1B adrenoreceptor|alpha1B-adrenergic receptor', map_location='11 25.81 cM', chromosome='11', genomic_nucleotide_accession_version='NC_000077.6', start_position_on_the_genomic_accession=43774605, end_position_on_the_genomic_accession=43901250, orientation='minus', exon_count=5, OMIM=[], no_hdr0=''),
    11549 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=11549, CurrentID=0, Status='live', Symbol='Adra1a', Aliases=['Adr', 'Adra1c'], description='adrenergic receptor, alpha 1a', other_designations='alpha-1A adrenergic receptor|alpha-1A adrenoceptor|alpha-1A adrenoreceptor|alpha-1C adrenergic receptor', map_location='14 D1', chromosome='14', genomic_nucleotide_accession_version='NC_000080.6', start_position_on_the_genomic_accession=66635251, end_position_on_the_genomic_accession=66771240, orientation='plus', exon_count=6, OMIM=[], no_hdr0=''),
    11550 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=11550, CurrentID=0, Status='live', Symbol='Adra1d', Aliases=['Ad', 'Adr', 'Adra-1', 'Adra1', 'Adra1a', 'Gpc', 'Gpcr8', 'Spr8', '[a]1d', 'alph', 'alpha1D-AR'], description='adrenergic receptor, alpha 1d', other_designations='alpha-1D adrenergic receptor|alpha-1A adrenergic receptor|alpha-1D adrenoceptor|alpha-1D adrenoreceptor', map_location='2 63.5 cM', chromosome='2', genomic_nucleotide_accession_version='NC_000068.7', start_position_on_the_genomic_accession=131545357, end_position_on_the_genomic_accession=131562497, orientation='minus', exon_count=2, OMIM=[], no_hdr0=''),
    11551 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=11551, CurrentID=0, Status='live', Symbol='Adra2a', Aliases=['AW122659', 'Adr', 'Adra-2', 'Adra-2a', 'al', 'alp', 'alph', 'alpha(2A)AR', 'alpha2-C10', 'alpha2A', 'alpha2A-AR'], description='adrenergic receptor, alpha 2a', other_designations='alpha-2A adrenergic receptor|alpha-2A adrenoceptor|alpha-2A adrenoreceptor|alpha-2AAR|alpha2A-adrenergic receptor|subtype alpha2-C10', map_location='19 49.04 cM', chromosome='19', genomic_nucleotide_accession_version='NC_000085.6', start_position_on_the_genomic_accession=54045259, end_position_on_the_genomic_accession=54048982, orientation='plus', exon_count=1, OMIM=[], no_hdr0=''),
    11552 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=11552, CurrentID=0, Status='live', Symbol='Adra2b', Aliases=['Adra', 'Adra-2b', '[a]2', '[a]2B', 'a2b', 'a2b-AR', 'alp', 'alpha2-C2', 'alpha2B'], description='adrenergic receptor, alpha 2b', other_designations='alpha-2B adrenergic receptor|alpha-2B adrenoceptor|alpha-2B adrenoreceptor|alpha-2BAR|subtype alpha2-C2', map_location='2 61.95 cM', chromosome='2', genomic_nucleotide_accession_version='NC_000068.7', start_position_on_the_genomic_accession=127363179, end_position_on_the_genomic_accession=127367221, orientation='plus', exon_count=1, OMIM=[], no_hdr0=''),
    11553 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=11553, CurrentID=0, Status='live', Symbol='Adra2c', Aliases=['Adra', 'Adra-2c', '[a]2', '[a]2C', 'alp', 'alpha2-C4', 'alpha2C'], description='adrenergic receptor, alpha 2c', other_designations='alpha-2C adrenergic receptor|alpha-2 adrenergic receptor subtype C4|alpha-2C adrenoceptor|alpha-2C adrenoreceptor|alpha-2CAR|subtype alpha2-C4', map_location='5 18.09 cM', chromosome='5', genomic_nucleotide_accession_version='NC_000071.6', start_position_on_the_genomic_accession=35278566, end_position_on_the_genomic_accession=35281763, orientation='plus', exon_count=1, OMIM=[], no_hdr0=''),
    11554 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=11554, CurrentID=0, Status='live', Symbol='Adrb1', Aliases=['Adrb', 'Adrb-1', 'beta-AR'], description='adrenergic receptor, beta 1', other_designations='beta-1 adrenergic receptor|beta 1-AR|beta-1 adrenoceptor|beta-1 adrenoreceptor|cardiac beta adrenergic receptor', map_location='19 51.96 cM', chromosome='19', genomic_nucleotide_accession_version='NC_000085.6', start_position_on_the_genomic_accession=56722117, end_position_on_the_genomic_accession=56725150, orientation='plus', exon_count=1, OMIM=[], no_hdr0=''),
    11555 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=11555, CurrentID=0, Status='live', Symbol='Adrb2', Aliases=['Adrb', 'Adrb-2', 'Bad', 'Badm', 'Gpc', 'Gpcr7'], description='adrenergic receptor, beta 2', other_designations='beta-2 adrenergic receptor|beta 2-AR|beta-2 adrenoceptor|beta-2 adrenoreceptor', map_location='18 35.1 cM', chromosome='18', genomic_nucleotide_accession_version='NC_000084.6', start_position_on_the_genomic_accession=62177713, end_position_on_the_genomic_accession=62179981, orientation='minus', exon_count=1, OMIM=[], no_hdr0=''),
    11556 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=11556, CurrentID=0, Status='live', Symbol='Adrb3', Aliases=['Adrb', 'Adrb-3', 'beta 3-AR'], description='adrenergic receptor, beta 3', other_designations='beta-3 adrenergic receptor|Beta-3 AR|beta-3 adrenoceptor|beta-3 adrenoreceptor', map_location='8 15.94 cM', chromosome='8', genomic_nucleotide_accession_version='NC_000074.6', start_position_on_the_genomic_accession=27225776, end_position_on_the_genomic_accession=27230845, orientation='minus', exon_count=5, OMIM=[], no_hdr0=''),
    11564 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=11564, CurrentID=0, Status='live', Symbol='Adsl', Aliases=['Adl', 'Asl'], description='adenylosuccinate lyase', other_designations='adenylosuccinate lyase|ASase|adenylosuccinase|adenylosuccinate lyase 1', map_location='15 37.95 cM', chromosome='15', genomic_nucleotide_accession_version='NC_000081.6', start_position_on_the_genomic_accession=80948490, end_position_on_the_genomic_accession=80970947, orientation='plus', exon_count=13, OMIM=[], no_hdr0=''),
    11565 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=11565, CurrentID=0, Status='live', Symbol='Adssl1', Aliases=['A', 'AI528595', 'Adss', 'Adss1'], description='adenylosuccinate synthetase like 1', other_designations='adenylosuccinate synthetase isozyme 1|AMPSase 1|IMP--aspartate ligase 1|M-type adenylosuccinate synthetase|adSS 1|adenylosuccinate synthetase 1, muscle|adenylosuccinate synthetase, basic isozyme|adenylosuccinate synthetase, muscle isozyme', map_location='12 F1', chromosome='12', genomic_nucleotide_accession_version='NC_000078.6', start_position_on_the_genomic_accession=112620047, end_position_on_the_genomic_accession=112641355, orientation='plus', exon_count=13, OMIM=[], no_hdr0=''),
    11566 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=11566, CurrentID=0, Status='live', Symbol='Adss', Aliases=['AI314886', 'AS2', 'Adss'], description='adenylosuccinate synthetase, non muscle', other_designations='adenylosuccinate synthetase isozyme 2|AMPSase 2|IMP--aspartate ligase 2|L-type adenylosuccinate synthetase|adSS 2|adenylosuccinate synthetase 2, non muscle|adenylosuccinate synthetase, acidic isozyme|adenylosuccinate synthetase, liver isozyme|adenylosuccinate synthetase, non-muscle isozyme', map_location='1 H4', chromosome='1', genomic_nucleotide_accession_version='NC_000067.6', start_position_on_the_genomic_accession=177763176, end_position_on_the_genomic_accession=177796695, orientation='minus', exon_count=13, OMIM=[], no_hdr0=''),
    11567 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=11567, CurrentID=0, Status='live', Symbol='Avil', Aliases=['Advil', 'DOC', 'DOC6'], description='advillin', other_designations='advillin|actin-binding protein DOC6|p92', map_location='10 D3', chromosome='10', genomic_nucleotide_accession_version='NC_000076.6', start_position_on_the_genomic_accession=127000065, end_position_on_the_genomic_accession=127020994, orientation='plus', exon_count=21, OMIM=[], no_hdr0=''),
    11568 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=11568, CurrentID=0, Status='live', Symbol='Aebp1', Aliases=['A', 'ACLP'], description='AE binding protein 1', other_designations='adipocyte enhancer-binding protein 1|aortic carboxypeptidase-like protein', map_location='11 A1', chromosome='11', genomic_nucleotide_accession_version='NC_000077.6', start_position_on_the_genomic_accession=5861866, end_position_on_the_genomic_accession=5872248, orientation='plus', exon_count=21, OMIM=[], no_hdr0=''),
    11569 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=11569, CurrentID=0, Status='live', Symbol='Aebp2', Aliases=['AU023766', 'B230313N05Rik'], description='AE binding protein 2', other_designations='zinc finger protein AEBP2|adipocyte enhancer-binding protein 2', map_location='6 G2', chromosome='6', genomic_nucleotide_accession_version='NC_000072.6', start_position_on_the_genomic_accession=140622454, end_position_on_the_genomic_accession=140678472, orientation='plus', exon_count=13, OMIM=[], no_hdr0=''),
    11571 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=11571, CurrentID=0, Status='live', Symbol='Crisp1', Aliases=['AW324342', 'Aeg', 'Aeg1', 'CRI', 'CRISP-1', 'SCP 1'], description='cysteine-rich secretory protein 1', other_designations='cysteine-rich secretory protein 1|acidic epididymal glycoprotein 1|sperm-coating glycoprotein 1', map_location='17 19.47 cM', chromosome='17', genomic_nucleotide_accession_version='NC_000083.6', start_position_on_the_genomic_accession=40293758, end_position_on_the_genomic_accession=40319207, orientation='minus', exon_count=8, OMIM=[], no_hdr0=''),
    11572 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=11572, CurrentID=0, Status='live', Symbol='Crisp3', Aliases=['Aeg', 'Aeg2', 'CR', 'CRI', 'CRISP-3', 'CRS3', 'SGP', 'SGP28'], description='cysteine-rich secretory protein 3', other_designations='cysteine-rich secretory protein 3|SCP 2|acidic epididymal glycoprotein 2|sperm-coating glycoprotein 2', map_location='17 19.45 cM', chromosome='17', genomic_nucleotide_accession_version='NC_000083.6', start_position_on_the_genomic_accession=40221777, end_position_on_the_genomic_accession=40242288, orientation='minus', exon_count=8, OMIM=[], no_hdr0=''),
    11576 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=11576, CurrentID=0, Status='live', Symbol='Afp', Aliases=[], description='alpha fetoprotein', other_designations='alpha-fetoprotein|alpha-1-fetoprotein|alpha-fetoglobulin|alpha-foetoprotein', map_location='5 44.77 cM', chromosome='5', genomic_nucleotide_accession_version='NC_000071.6', start_position_on_the_genomic_accession=90490714, end_position_on_the_genomic_accession=90508907, orientation='plus', exon_count=15, OMIM=[], no_hdr0=''),
    11593 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=11593, CurrentID=0, Status='live', Symbol='Aga', Aliases=['AW060726'], description='aspartylglucosaminidase', other_designations='N(4)-(beta-N-acetylglucosaminyl)-L-asparaginase|N4-(N-acetyl-beta-glucosaminyl)-L-asparagine amidase|glycosylasparaginase', map_location='8 B1.3', chromosome='8', genomic_nucleotide_accession_version='NC_000074.6', start_position_on_the_genomic_accession=53511683, end_position_on_the_genomic_accession=53523422, orientation='plus', exon_count=9, OMIM=[], no_hdr0=''),
    11595 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=11595, CurrentID=0, Status='live', Symbol='Acan', Aliases=['Agc', 'Agc1', 'CSPCP', 'Csp', 'Cspg1', 'b2b183C', 'b2b183Clo', 'cmd'], description='aggrecan', other_designations='aggrecan core protein|aggrecan 1|cartilage-specific proteoglycan core protein', map_location='7 44.88 cM', chromosome='7', genomic_nucleotide_accession_version='NC_000073.6', start_position_on_the_genomic_accession=79053226, end_position_on_the_genomic_accession=79115099, orientation='plus', exon_count=18, OMIM=[], no_hdr0=''),
    11596 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=11596, CurrentID=0, Status='live', Symbol='Ager', Aliases=['RA', 'RAGE'], description='advanced glycosylation end product-specific receptor', other_designations='advanced glycosylation end product-specific receptor|advanced glycation end-products receptor|receptor for advanced glycation end-products variant 20|receptor for advanced glycosylation end products', map_location='17 B1', chromosome='17', genomic_nucleotide_accession_version='NC_000083.6', start_position_on_the_genomic_accession=34597460, end_position_on_the_genomic_accession=34600937, orientation='plus', exon_count=10, OMIM=[], no_hdr0=''),
    11600 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=11600, CurrentID=0, Status='live', Symbol='Angpt1', Aliases=['1110046O21Rik', 'Ang', 'Ang-1', 'Ang1', 'an'], description='angiopoietin 1', other_designations='angiopoietin-1', map_location='15 16.69 cM', chromosome='15', genomic_nucleotide_accession_version='NC_000081.6', start_position_on_the_genomic_accession=42424667, end_position_on_the_genomic_accession=42676977, orientation='minus', exon_count=10, OMIM=[], no_hdr0=''),
    11601 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=11601, CurrentID=0, Status='live', Symbol='Angpt2', Aliases=['Agpt2', 'An', 'Ang', 'Ang-2', 'Ang2'], description='angiopoietin 2', other_designations='angiopoietin-2', map_location='8 10.3 cM', chromosome='8', genomic_nucleotide_accession_version='NC_000074.6', start_position_on_the_genomic_accession=18690263, end_position_on_the_genomic_accession=18741562, orientation='minus', exon_count=9, OMIM=[], no_hdr0=''),
    11602 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=11602, CurrentID=0, Status='live', Symbol='Angpt4', Aliases=['ANG-3', 'ANG-4', 'Agpt4', 'Ang3'], description='angiopoietin 4', other_designations='angiopoietin-4|angiopoietin-3', map_location='2 74.83 cM', chromosome='2', genomic_nucleotide_accession_version='NC_000068.7', start_position_on_the_genomic_accession=151911207, end_position_on_the_genomic_accession=151945337, orientation='plus', exon_count=9, OMIM=[], no_hdr0=''),
    11603 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=11603, CurrentID=0, Status='live', Symbol='Agrn', Aliases=['A', 'Agrin', 'NMF38', 'nmf380'], description='agrin', other_designations='agrin', map_location='4 88.55 cM', chromosome='4', genomic_nucleotide_accession_version='NC_000070.6', start_position_on_the_genomic_accession=156165290, end_position_on_the_genomic_accession=156197533, orientation='minus', exon_count=44, OMIM=[], no_hdr0=''),
    11604 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=11604, CurrentID=0, Status='live', Symbol='Agrp', Aliases=['Ag', 'Agrt', 'Art'], description='agouti related neuropeptide', other_designations='agouti-related protein|orexigenic neuropeptide', map_location='8 D3', chromosome='8', genomic_nucleotide_accession_version='NC_000074.6', start_position_on_the_genomic_accession=105566695, end_position_on_the_genomic_accession=105579845, orientation='minus', exon_count=6, OMIM=[], no_hdr0=''),
    11605 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=11605, CurrentID=0, Status='live', Symbol='Gla', Aliases=['A', 'Ags'], description='galactosidase, alpha', other_designations='alpha-galactosidase A|alpha-D-galactosidase A|alpha-D-galactoside galactohydrolase|galactosylgalactosylglucosylceramidase GLA|melibiase', map_location='X 56.2 cM', chromosome='X', genomic_nucleotide_accession_version='NC_000086.7', start_position_on_the_genomic_accession=134588169, end_position_on_the_genomic_accession=134601005, orientation='minus', exon_count=7, OMIM=[], no_hdr0=''),
    11606 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=11606, CurrentID=0, Status='live', Symbol='Agt', Aliases=['AI265500', 'AngI', 'AngII', 'Ao', 'Aogen', 'Se', 'Serpina8'], description='angiotensinogen (serpin peptidase inhibitor, clade A, member 8)', other_designations='angiotensinogen|angiotensin I|angiotensin ll|serpin A8', map_location='8 72.81 cM', chromosome='8', genomic_nucleotide_accession_version='NC_000074.6', start_position_on_the_genomic_accession=124556587, end_position_on_the_genomic_accession=124569706, orientation='minus', exon_count=6, OMIM=[], no_hdr0=''),
    11607 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=11607, CurrentID=0, Status='live', Symbol='Agtr1a', Aliases=['1810074K20Rik', 'AG2S', 'AI551199', 'AT', 'AT1', 'AT1a', 'AT2R1', 'AT2R1A', 'Agt', 'Agt1ar', 'Agtr', 'Agtr-1a', 'Agtr1', 'Angt', 'Angtr-1a'], description='angiotensin II receptor, type 1a', other_designations='type-1A angiotensin II receptor|angiotensin II type-1A receptor|angiotensin receptor 1|angiotensin receptor 1a', map_location='13 13.19 cM', chromosome='13', genomic_nucleotide_accession_version='NC_000079.6', start_position_on_the_genomic_accession=30336356, end_position_on_the_genomic_accession=30382867, orientation='plus', exon_count=5, OMIM=[], no_hdr0=''),
    11608 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=11608, CurrentID=0, Status='live', Symbol='Agtr1b', Aliases=['AT1', 'AT1B', 'AT2R1B', 'Agtr-', 'Agtr-1b', 'Angtr', 'Angtr-1b'], description='angiotensin II receptor, type 1b', other_designations='type-1B angiotensin II receptor|AT3|angiotensin II type-1B receptor', map_location='3 6.37 cM', chromosome='3', genomic_nucleotide_accession_version='NC_000069.6', start_position_on_the_genomic_accession=20314473, end_position_on_the_genomic_accession=20367177, orientation='minus', exon_count=2, OMIM=[], no_hdr0=''),
    11609 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=11609, CurrentID=0, Status='live', Symbol='Agtr2', Aliases=['AI316812', 'AW107640'], description='angiotensin II receptor, type 2', other_designations='type-2 angiotensin II receptor|AT2 receptor|angiotensin II type-2 receptor', map_location='X 16.71 cM', chromosome='X', genomic_nucleotide_accession_version='NC_000086.7', start_position_on_the_genomic_accession=21484624, end_position_on_the_genomic_accession=21488833, orientation='plus', exon_count=3, OMIM=[], no_hdr0=''),
    11610 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=11610, CurrentID=0, Status='live', Symbol='Agtrap', Aliases=['3300002E14Rik', 'A', 'AT1R', 'Atrap', 'D4Wsu124', 'D4Wsu124e'], description='angiotensin II, type I receptor-associated protein', other_designations='type-1 angiotensin II receptor-associated protein|AT1 receptor-associated protein', map_location='4 78.67 cM', chromosome='4', genomic_nucleotide_accession_version='NC_000070.6', start_position_on_the_genomic_accession=148077061, end_position_on_the_genomic_accession=148088064, orientation='minus', exon_count=5, OMIM=[], no_hdr0=''),
    11611 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=11611, CurrentID=0, Status='live', Symbol='Agxt', Aliases=['AGT', 'Agt11', 'SPT', 'Agxt'], description='alanine-glyoxylate aminotransferase', other_designations='serine--pyruvate aminotransferase, mitochondrial|serine--pyruvate aminotransferase, peroxisomal|alanine-glyoxylate aminotransferase 1|serine-pyruvate aminotransferase', map_location='1 47.0 cM', chromosome='1', genomic_nucleotide_accession_version='NC_000067.6', start_position_on_the_genomic_accession=93135240, end_position_on_the_genomic_accession=93145421, orientation='plus', exon_count=11, OMIM=[], no_hdr0=''),
    11614 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=11614, CurrentID=0, Status='live', Symbol='Nr0b1', Aliases=['AH', 'AHX', 'Ahc', 'Ahch', 'DAX-', 'DAX-1', 'Dax', 'Dax1'], description='nuclear receptor subfamily 0, group B, member 1', other_designations='nuclear receptor subfamily 0 group B member 1|adrenal hypoplasia congenita-like protein|adrenal hypoplasia, congenital homolog|nuclear receptor DAX-1', map_location='X 39.67 cM', chromosome='X', genomic_nucleotide_accession_version='NC_000086.7', start_position_on_the_genomic_accession=86191775, end_position_on_the_genomic_accession=86195947, orientation='plus', exon_count=2, OMIM=[], no_hdr0=''),
    11615 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=11615, CurrentID=0, Status='live', Symbol='Gm4737', Aliases=['AL024110', 'EG11615'], description='predicted gene 4737', other_designations='predicted gene 4737', map_location='16', chromosome='16', genomic_nucleotide_accession_version='NC_000082.6', start_position_on_the_genomic_accession=46152985, end_position_on_the_genomic_accession=46155077, orientation='minus', exon_count=1, OMIM=[], no_hdr0=''),
    11622 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=11622, CurrentID=0, Status='live', Symbol='Ahr', Aliases=['A', 'Ah', 'Ahhe', 'In', 'bHLHe7', 'bHLHe76', 'Ahr'], description='aryl-hydrocarbon receptor', other_designations='aryl hydrocarbon receptor|ah receptor|dioxin receptor', map_location='12 15.78 cM', chromosome='12', genomic_nucleotide_accession_version='NC_000078.6', start_position_on_the_genomic_accession=35497979, end_position_on_the_genomic_accession=35534989, orientation='minus', exon_count=11, OMIM=[], no_hdr0=''),
    11624 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=11624, CurrentID=0, Status='live', Symbol='Ahrr', Aliases=['mKIAA1234'], description='aryl-hydrocarbon receptor repressor', other_designations='aryl hydrocarbon receptor repressor|ahR repressor', map_location='13 C1', chromosome='13', genomic_nucleotide_accession_version='NC_000079.6', start_position_on_the_genomic_accession=74211118, end_position_on_the_genomic_accession=74292331, orientation='minus', exon_count=14, OMIM=[], no_hdr0=''),
    11625 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=11625, CurrentID=0, Status='live', Symbol='Ahsg', Aliases=['fetui'], description='alpha-2-HS-glycoprotein', other_designations='alpha-2-HS-glycoprotein|countertrypin|fetuin-A', map_location='16 13.74 cM', chromosome='16', genomic_nucleotide_accession_version='NC_000082.6', start_position_on_the_genomic_accession=22892015, end_position_on_the_genomic_accession=22899451, orientation='plus', exon_count=7, OMIM=[], no_hdr0=''),
    11628 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=11628, CurrentID=0, Status='live', Symbol='Aicda', Aliases=['A', 'Aid', 'Arp2'], description='activation-induced cytidine deaminase', other_designations='single-stranded DNA cytosine deaminase|activation induced deaminase|cytidine aminohydrolase', map_location='6 F1', chromosome='6', genomic_nucleotide_accession_version='NC_000072.6', start_position_on_the_genomic_accession=122553809, end_position_on_the_genomic_accession=122564180, orientation='plus', exon_count=5, OMIM=[], no_hdr0=''),
    11629 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=11629, CurrentID=0, Status='live', Symbol='Aif1', Aliases=['AI607846', 'AIF-1', 'D17H6S50', 'D17H6S50E', 'G1', 'Ib', 'Iba1'], description='allograft inflammatory factor 1', other_designations='allograft inflammatory factor 1|ionized calcium binding adapter molecule 1|testis specific', map_location='17 18.59 cM', chromosome='17', genomic_nucleotide_accession_version='NC_000083.6', start_position_on_the_genomic_accession=35170986, end_position_on_the_genomic_accession=35176083, orientation='minus', exon_count=8, OMIM=[], no_hdr0=''),
    11630 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=11630, CurrentID=0, Status='live', Symbol='Crybg1', Aliases=['Ai', 'Aim1'], description='crystallin beta-gamma domain containing 1', other_designations='beta/gamma crystallin domain-containing protein 1|absent in melanoma 1', map_location='10 23.14 cM', chromosome='10', genomic_nucleotide_accession_version='NC_000076.6', start_position_on_the_genomic_accession=43950307, end_position_on_the_genomic_accession=44148828, orientation='minus', exon_count=23, OMIM=[], no_hdr0=''),
    11632 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=11632, CurrentID=0, Status='live', Symbol='Aip', Aliases=['A', 'AA408703', 'AW476050', 'Ara9', 'D19Bwg1412e', 'Fkbp1', 'Fkbp16', 'Xa', 'Xap2'], description='aryl-hydrocarbon receptor-interacting protein', other_designations='AH receptor-interacting protein', map_location='19 3.82 cM', chromosome='19', genomic_nucleotide_accession_version='NC_000085.6', start_position_on_the_genomic_accession=4113756, end_position_on_the_genomic_accession=4126559, orientation='minus', exon_count=8, OMIM=[], no_hdr0=''),
    11634 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=11634, CurrentID=0, Status='live', Symbol='Aire', Aliases=[], description='autoimmune regulator (autoimmune polyendocrinopathy candidiasis ectodermal dystrophy)', other_designations='autoimmune regulator|APECED protein homolog|autoimmune polyendocrinopathy candidiasis ectodermal dystrophy protein homolog|autoimmune regulator AIRE1a', map_location='10 39.72 cM', chromosome='10', genomic_nucleotide_accession_version='NC_000076.6', start_position_on_the_genomic_accession=78030022, end_position_on_the_genomic_accession=78043610, orientation='minus', exon_count=15, OMIM=[], no_hdr0=''),
    11636 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=11636, CurrentID=0, Status='live', Symbol='Ak1', Aliases=['Ak-', 'Ak-1', 'B430205N08Rik'], description='adenylate kinase 1', other_designations='adenylate kinase isoenzyme 1|cytosolic adenylate kinase', map_location='2 22.09 cM', chromosome='2', genomic_nucleotide_accession_version='NC_000068.7', start_position_on_the_genomic_accession=32621758, end_position_on_the_genomic_accession=32635058, orientation='plus', exon_count=10, OMIM=[], no_hdr0=''),
    11637 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=11637, CurrentID=0, Status='live', Symbol='Ak2', Aliases=['Ak-', 'Ak-2', 'D4Ertd220', 'D4Ertd220e'], description='adenylate kinase 2', other_designations='adenylate kinase 2, mitochondrial|AK 2|ATP-AMP transphosphorylase 2|ATP:AMP phosphotransferase|adenylate monophosphate kinase', map_location='4 62.62 cM', chromosome='4', genomic_nucleotide_accession_version='NC_000070.6', start_position_on_the_genomic_accession=128993224, end_position_on_the_genomic_accession=129011529, orientation='plus', exon_count=7, OMIM=[], no_hdr0=''),
    11639 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=11639, CurrentID=0, Status='live', Symbol='Ak4', Aliases=['AK 4', 'Ak-', 'Ak-3', 'Ak-4', 'Ak3', 'Ak3l1', 'D4Ertd274', 'D4Ertd274e'], description='adenylate kinase 4', other_designations='adenylate kinase 4, mitochondrial|ATP-AMP transphosphorylase|GTP:AMP phosphotransferase AK4, mitochondrial|adenylate kinase 3 alpha-like 1|adenylate kinase 3-like 1|adenylate kinase isoenzyme 4, mitochondrial', map_location='4 46.84 cM', chromosome='4', genomic_nucleotide_accession_version='NC_000070.6', start_position_on_the_genomic_accession=101416478, end_position_on_the_genomic_accession=101467771, orientation='plus', exon_count=7, OMIM=[], no_hdr0=''),
    11640 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=11640, CurrentID=0, Status='live', Symbol='Akap1', Aliases=['AKA', 'AKAP121', 'AKAP84', 'Akap', 'C76494', 'C81186', 'DAK', 'DAKAP1', 'S-AK', 'S-AKAP84'], description='A kinase (PRKA) anchor protein 1', other_designations='A-kinase anchor protein 1, mitochondrial|D-AKAP-1|PRKA1|S-AKAP|a kinase anchor protein 1, mitochondrial|dual specificity A-kinase-anchoring protein 1|protein kinase A-anchoring protein 1|spermatid A-kinase anchor protein', map_location='11 C', chromosome='11', genomic_nucleotide_accession_version='NC_000077.6', start_position_on_the_genomic_accession=88830792, end_position_on_the_genomic_accession=88864596, orientation='minus', exon_count=14, OMIM=[], no_hdr0=''),
    11642 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=11642, CurrentID=0, Status='live', Symbol='Akap3', Aliases=['Prka3'], description='A kinase (PRKA) anchor protein 3', other_designations='A-kinase anchor protein 3|A-kinase anchor protein 110 kDa|AKAP 110|AKAP-3|Protein kinase A-anchoring protein 3', map_location='6 F3', chromosome='6', genomic_nucleotide_accession_version='NC_000072.6', start_position_on_the_genomic_accession=126853098, end_position_on_the_genomic_accession=126874308, orientation='plus', exon_count=6, OMIM=[], no_hdr0=''),
    11643 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=11643, CurrentID=0, Status='live', Symbol='Akap4', Aliases=['AKAP-4', 'AKAP82', 'Fsc', 'Fsc1', 'PRKA4', 'mAKAP82', 'p82'], description='A kinase (PRKA) anchor protein 4', other_designations='A-kinase anchor protein 4|A kinase anchoring protein 4|A-kinase anchor protein 82 kDa|major sperm fibrous sheath protein|protein kinase A-anchoring protein 4', map_location='X 3.17 cM', chromosome='X', genomic_nucleotide_accession_version='NC_000086.7', start_position_on_the_genomic_accession=7067515, end_position_on_the_genomic_accession=7078609, orientation='plus', exon_count=7, OMIM=[], no_hdr0=''),
    11647 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=11647, CurrentID=0, Status='live', Symbol='Alpl', Aliases=['ALP', 'APTNAP', 'Ak', 'Akp', 'Akp-2', 'Akp2', 'T', 'TNAP', 'TNSALP'], description='alkaline phosphatase, liver/bone/kidney', other_designations='alkaline phosphatase, tissue-nonspecific isozyme|alkaline phosphatase 2, liver', map_location='4 70.02 cM', chromosome='4', genomic_nucleotide_accession_version='NC_000070.6', start_position_on_the_genomic_accession=137741731, end_position_on_the_genomic_accession=137796384, orientation='minus', exon_count=18, OMIM=[], no_hdr0=''),
    11648 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=11648, CurrentID=0, Status='live', Symbol='Akp3', Aliases=['Akp', 'Akp-3', 'IAP', 'dIAP'], description='alkaline phosphatase 3, intestine, not Mn requiring', other_designations='intestinal-type alkaline phosphatase|intestinal alkaline phosphatase', map_location='1 44.06 cM', chromosome='1', genomic_nucleotide_accession_version='NC_000067.6', start_position_on_the_genomic_accession=87124954, end_position_on_the_genomic_accession=87128728, orientation='plus', exon_count=11, OMIM=[], no_hdr0=''),
    11650 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=11650, CurrentID=0, Status='live', Symbol='Alppl2', Aliases=['Ak', 'Akp5', 'Alpg', 'C77216', 'D1Ertd816', 'D1Ertd816e', 'EAP'], description='alkaline phosphatase, placental-like 2', other_designations='alkaline phosphatase, germ cell type|alkaline phosphatase 5|embryonic alkaline phosphatase|embryonic-type alkaline phosphatase', map_location='1 44.05 cM', chromosome='1', genomic_nucleotide_accession_version='NC_000067.6', start_position_on_the_genomic_accession=87086690, end_position_on_the_genomic_accession=87095934, orientation='minus', exon_count=12, OMIM=[], no_hdr0=''),
    11651 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=11651, CurrentID=0, Status='live', Symbol='Akt1', Aliases=['Ak', 'Akt', 'LTR-akt', 'PK', 'PKB', 'PKB/A', 'PKB/Akt', 'PKBalpha', 'Rac'], description='thymoma viral proto-oncogene 1', other_designations='RAC-alpha serine/threonine-protein kinase|AKT1 kinase|Akt1m protein|PKB alpha|RAC-PK-alpha|protein kinase B-alpha|proto-oncogene c-AKT|related to A and C kinases|tumor rejection antigen peptide pRLib', map_location='12 61.2 cM', chromosome='12', genomic_nucleotide_accession_version='NC_000078.6', start_position_on_the_genomic_accession=112653821, end_position_on_the_genomic_accession=112674884, orientation='minus', exon_count=16, OMIM=[], no_hdr0=''),
    11652 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=11652, CurrentID=0, Status='live', Symbol='Akt2', Aliases=['2410016A19Rik', 'AW554154', 'PK', 'PKB', 'PKBbe', 'PKBbeta'], description='thymoma viral proto-oncogene 2', other_designations='RAC-beta serine/threonine-protein kinase|PKB beta|RAC-PK-beta|protein kinase Akt-2|protein kinase B, beta', map_location='7 15.94 cM', chromosome='7', genomic_nucleotide_accession_version='NC_000073.6', start_position_on_the_genomic_accession=27591552, end_position_on_the_genomic_accession=27640826, orientation='plus', exon_count=21, OMIM=[], no_hdr0=''),
    11655 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=11655, CurrentID=0, Status='live', Symbol='Alas1', Aliases=['A', 'ALAS', 'ALAS-N', 'Al', 'Alas-1', 'Alas-h'], description='aminolevulinic acid synthase 1', other_designations='5-aminolevulinate synthase, nonspecific, mitochondrial|5-aminolevulinic acid synthase 1|aminolevulinate synthase H|delta-ALA synthase 1|delta-aminolevulinate synthase 1|succinyl-CoA: glycine C-succinyl transferase', map_location='9 F1', chromosome='9', genomic_nucleotide_accession_version='NC_000075.6', start_position_on_the_genomic_accession=106233455, end_position_on_the_genomic_accession=106247954, orientation='minus', exon_count=12, OMIM=[], no_hdr0=''),
    11656 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=11656, CurrentID=0, Status='live', Symbol='Alas2', Aliases=['A', 'ALAS', 'ALAS-E', 'ALASE', 'Al', 'Alas-2'], description='aminolevulinic acid synthase 2, erythroid', other_designations='5-aminolevulinate synthase, erythroid-specific, mitochondrial|5-aminolevulinic acid synthase 2|delta-ALA synthase 2|delta-aminolevulinate synthase 2|erythroid-specific ALAS', map_location='X 68.46 cM', chromosome='X', genomic_nucleotide_accession_version='NC_000086.7', start_position_on_the_genomic_accession=150547417, end_position_on_the_genomic_accession=150570622, orientation='plus', exon_count=12, OMIM=[], no_hdr0=''),
    11657 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=11657, CurrentID=0, Status='live', Symbol='Alb', Aliases=['Al-1', 'Alb1', 'BCL002', 'Alb'], description='albumin', other_designations='albumin|albumin 1|serum albumin', map_location='5 44.7 cM', chromosome='5', genomic_nucleotide_accession_version='NC_000071.6', start_position_on_the_genomic_accession=90460870, end_position_on_the_genomic_accession=90476602, orientation='plus', exon_count=15, OMIM=[], no_hdr0=''),
    11658 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=11658, CurrentID=0, Status='live', Symbol='Alcam', Aliases=['AI853494', 'BE', 'BEN', 'CD166', 'DM-G', 'DM-GRASP', 'MuS', 'MuSC', 'SC', 'SC1'], description='activated leukocyte cell adhesion molecule', other_designations='CD166 antigen', map_location='16 B5', chromosome='16', genomic_nucleotide_accession_version='NC_000082.6', start_position_on_the_genomic_accession=52248996, end_position_on_the_genomic_accession=52453081, orientation='minus', exon_count=16, OMIM=[], no_hdr0=''),
    11666 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=11666, CurrentID=0, Status='live', Symbol='Abcd1', Aliases=['A', 'ALDP', 'Ald', 'Aldgh'], description='ATP-binding cassette, sub-family D (ALD), member 1', other_designations='ATP-binding cassette sub-family D member 1|X-linked adrenoleukodystrophy (ALD) gene homolog|adrenoleukodystrophy protein', map_location='X 37.39 cM', chromosome='X', genomic_nucleotide_accession_version='NC_000086.7', start_position_on_the_genomic_accession=73716597, end_position_on_the_genomic_accession=73738534, orientation='plus', exon_count=10, OMIM=[], no_hdr0=''),
    11668 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=11668, CurrentID=0, Status='live', Symbol='Aldh1a1', Aliases=['ALD', 'ALDH-E1', 'ALHDII', 'Ahd', 'Ahd-', 'Ahd-2', 'Ahd2', 'Aldh1', 'Aldh1a2', 'E1', 'Ral', 'Raldh1'], description='aldehyde dehydrogenase family 1, subfamily A1', other_designations='retinal dehydrogenase 1|RALDH 1|alcohol dehydrogenase family 1, subfamily A1|alcohol dehydrogenase family 1, subfamily A2|aldehyde dehydrogenase 1, liver cytosolic (class 1)|aldehyde dehydrogenase family 1 member A1|aldehyde dehydrogenase, cytosolic', map_location='19 13.91 cM', chromosome='19', genomic_nucleotide_accession_version='NC_000085.6', start_position_on_the_genomic_accession=20492583, end_position_on_the_genomic_accession=20643463, orientation='plus', exon_count=17, OMIM=[], no_hdr0=''),
    11669 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=11669, CurrentID=0, Status='live', Symbol='Aldh2', Aliases=['AHD-M1', 'ALDH-E2', 'ALDHI', 'Ahd', 'Ahd-', 'Ahd-5', 'Ahd5'], description='aldehyde dehydrogenase 2, mitochondrial', other_designations='aldehyde dehydrogenase, mitochondrial|ALDH class 2', map_location='5 F', chromosome='5', genomic_nucleotide_accession_version='NC_000071.6', start_position_on_the_genomic_accession=121566027, end_position_on_the_genomic_accession=121593824, orientation='minus', exon_count=13, OMIM=[], no_hdr0=''),
    11670 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=11670, CurrentID=0, Status='live', Symbol='Aldh3a1', Aliases=['Ahd', 'Ahd-', 'Ahd-4', 'Ahd4', 'Al', 'Ald', 'Aldh', 'Aldh3'], description='aldehyde dehydrogenase family 3, subfamily A1', other_designations='aldehyde dehydrogenase, dimeric NADP-preferring|alcohol dehydrogenase family 3, subfamily A1|aldehyde dehydrogenase 3, stomach cytosolic (class 3)|aldehyde dehydrogenase 4|aldehyde dehydrogenase family 3 member A1|dioxin-inducible aldehyde dehydrogenase 3', map_location='11 37.96 cM', chromosome='11', genomic_nucleotide_accession_version='NC_000077.6', start_position_on_the_genomic_accession=61208510, end_position_on_the_genomic_accession=61218418, orientation='plus', exon_count=13, OMIM=[], no_hdr0=''),
    11671 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=11671, CurrentID=0, Status='live', Symbol='Aldh3a2', Aliases=['AI194803', 'Ahd', 'Ahd-', 'Ahd-3', 'Ahd-3r', 'Ahd3', 'Ahd3-r', 'Ald', 'Aldh', 'Aldh4', 'Aldh4-r', 'FAL', 'FALDH'], description='aldehyde dehydrogenase family 3, subfamily A2', other_designations='aldehyde dehydrogenase family 3 member A2|alcohol dehydrogenase family 3, subfamily A2|aldehyde dehydrogenase 3|aldehyde dehydrogenase 4, liver microsomal (class 3) regulator|fatty aldehyde dehydrogenase variant form', map_location='11 37.96 cM', chromosome='11', genomic_nucleotide_accession_version='NC_000077.6', start_position_on_the_genomic_accession=61223417, end_position_on_the_genomic_accession=61267528, orientation='minus', exon_count=14, OMIM=[], no_hdr0=''),
    11674 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=11674, CurrentID=0, Status='live', Symbol='Aldoa', Aliases=['Al', 'Ald', 'Aldo-1', 'Aldo1'], description='aldolase A, fructose-bisphosphate', other_designations='fructose-bisphosphate aldolase A|muscle-type aldolase', map_location='7 F3', chromosome='7', genomic_nucleotide_accession_version='NC_000073.6', start_position_on_the_genomic_accession=126795234, end_position_on_the_genomic_accession=126800994, orientation='minus', exon_count=13, OMIM=[], no_hdr0=''),
    11676 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=11676, CurrentID=0, Status='live', Symbol='Aldoc', Aliases=['AI847350', 'AU040929', 'Al', 'Aldo3', 'Scr', 'Scrg2'], description='aldolase C, fructose-bisphosphate', other_designations='fructose-bisphosphate aldolase C|brain-type aldolase|scrapie responsive gene 2|scrapie-responsive protein 2|zebrin II', map_location='11 46.74 cM', chromosome='11', genomic_nucleotide_accession_version='NC_000077.6', start_position_on_the_genomic_accession=78323073, end_position_on_the_genomic_accession=78327781, orientation='plus', exon_count=9, OMIM=[], no_hdr0=''),
    11677 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=11677, CurrentID=0, Status='live', Symbol='Akr1b3', Aliases=['A', 'ALR2', 'AR', 'Ah', 'Ahr', 'Ahr-1', 'Ahr1', 'Akr1b1', 'Al', 'Aldor1', 'Aldr1'], description='aldo-keto reductase family 1, member B3 (aldose reductase)', other_designations='aldo-keto reductase family 1 member B1|aldehyde reductase 1|aldo-keto reductase family 1 member B3|aldo-keto reductase family 1, member B1 (aldose reductase)|aldose reductase', map_location='6 B1', chromosome='6', genomic_nucleotide_accession_version='NC_000072.6', start_position_on_the_genomic_accession=34303930, end_position_on_the_genomic_accession=34317489, orientation='minus', exon_count=10, OMIM=[], no_hdr0=''),
    11682 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=11682, CurrentID=0, Status='live', Symbol='Alk', Aliases=['CD246', 'Tcr', 'Tcrz'], description='anaplastic lymphoma kinase', other_designations='ALK tyrosine kinase receptor', map_location='17 43.77 cM', chromosome='17', genomic_nucleotide_accession_version='NC_000083.6', start_position_on_the_genomic_accession=71868988, end_position_on_the_genomic_accession=72604702, orientation='minus', exon_count=29, OMIM=[], no_hdr0=''),
    11684 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=11684, CurrentID=0, Status='live', Symbol='Alox12', Aliases=['9930022G08Rik', 'Alop', 'P-1', 'P-12LO', 'Alox12'], description='arachidonate 12-lipoxygenase', other_designations='polyunsaturated fatty acid lipoxygenase ALOX12|12S-LOX|12S-lipoxygenase|arachidonate (12S)-lipoxygenase|arachidonate (15S)-lipoxygenase|arachidonate 12-lipoxygenase, 12S-type|arachidonate 15-lipoxygenase,15S-type|linoleate 13S-lipoxygenase|lipoxin synthase 12-LO|platelet-type lipoxygenase 12', map_location='11 42.99 cM', chromosome='11', genomic_nucleotide_accession_version='NC_000077.6', start_position_on_the_genomic_accession=70241457, end_position_on_the_genomic_accession=70255380, orientation='minus', exon_count=14, OMIM=[], no_hdr0=''),
    11685 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=11685, CurrentID=0, Status='live', Symbol='Alox12e', Aliases=['12-LOX', '12-LOX-e', '8-L', '8-LOX', 'AW259591', 'Al', 'Alox1', 'Alox12-ps1', 'Alox12-ps2', 'Aloxe', 'e-LO', 'e-LOX1'], description='arachidonate lipoxygenase, epidermal', other_designations='polyunsaturated fatty acid (12S)/(13S)-lipoxygenase, epidermal-type|arachidonate (12S)-lipoxygenase, epidermal-type|arachidonate 12-lipoxygenase, epidermal|arachidonate 12-lipoxygenase, epidermal-type|e(12S)-LOX|linoleate (13S)-lipoxygenase', map_location='11 42.99 cM', chromosome='11', genomic_nucleotide_accession_version='NC_000077.6', start_position_on_the_genomic_accession=70315610, end_position_on_the_genomic_accession=70322720, orientation='minus', exon_count=15, OMIM=[], no_hdr0=''),
    11686 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=11686, CurrentID=0, Status='live', Symbol='Alox12b', Aliases=['12R-', '12R-LOX', 'Alo', 'Aloxe2', 'e-LO', 'e-LOX2'], description='arachidonate 12-lipoxygenase, 12R type', other_designations='arachidonate 12-lipoxygenase, 12R-type|12R-lipoxygenase|epidermis-type lipoxygenase 12|epidermis-type lipoxygenase 2', map_location='11 42.38 cM', chromosome='11', genomic_nucleotide_accession_version='NC_000077.6', start_position_on_the_genomic_accession=69157072, end_position_on_the_genomic_accession=69169791, orientation='plus', exon_count=15, OMIM=[], no_hdr0=''),
    11687 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=11687, CurrentID=0, Status='live', Symbol='Alox15', Aliases=['12-', '12-LO', '12/15-LO', '15-LOX', 'Alo', 'Alox12l', 'L-1', 'L-12LO'], description='arachidonate 15-lipoxygenase', other_designations='polyunsaturated fatty acid lipoxygenase ALOX15|12-LOX|12/15-lipoxygenase|arachidonate 12-lipoxygenase, leukocyte-type|arachidonate omega-6 lipoxygenase|hepoxilin A3 synthase Alox15|linoleate 13S-lipoxygenase', map_location='11 42.99 cM', chromosome='11', genomic_nucleotide_accession_version='NC_000077.6', start_position_on_the_genomic_accession=70344147, end_position_on_the_genomic_accession=70390538, orientation='minus', exon_count=15, OMIM=[], no_hdr0=''),
    11688 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=11688, CurrentID=0, Status='live', Symbol='Alox8', Aliases=['15-LOX-2', '15-LOX-B', '8-L', '8-LOX', '8S-', '8S-LOX', 'Alox', 'Alox15b'], description='arachidonate 8-lipoxygenase', other_designations='polyunsaturated fatty acid lipoxygenase ALOX8|15-lipoxygenase 2|8S-lipoxygenase|arachidonate 15-lipoxygenase B|arachidonate 15-lipoxygenase type II|arachidonate 15-lipoxygenase, second type|arachidonate 8S-lipoxygenase|linoleate 9S-lipoxygenase ALOX8', map_location='11 B3', chromosome='11', genomic_nucleotide_accession_version='NC_000077.6', start_position_on_the_genomic_accession=69183885, end_position_on_the_genomic_accession=69197843, orientation='minus', exon_count=14, OMIM=[], no_hdr0=''),
    11689 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=11689, CurrentID=0, Status='live', Symbol='Alox5', Aliases=['5-L', '5-LO', '5-LOX', '5L', '5LO', '5LX', 'AI850497', 'F730011J02'], description='arachidonate 5-lipoxygenase', other_designations='polyunsaturated fatty acid 5-lipoxygenase|5-lipoxygenase', map_location='6 53.79 cM', chromosome='6', genomic_nucleotide_accession_version='NC_000072.6', start_position_on_the_genomic_accession=116410071, end_position_on_the_genomic_accession=116461178, orientation='minus', exon_count=14, OMIM=[], no_hdr0=''),
    11690 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=11690, CurrentID=0, Status='live', Symbol='Alox5ap', Aliases=['F', 'Flap'], description='arachidonate 5-lipoxygenase activating protein', other_designations='arachidonate 5-lipoxygenase-activating protein|MK-886-binding protein', map_location='5 G3', chromosome='5', genomic_nucleotide_accession_version='NC_000071.6', start_position_on_the_genomic_accession=149265004, end_position_on_the_genomic_accession=149288153, orientation='plus', exon_count=5, OMIM=[], no_hdr0=''),
    11692 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=11692, CurrentID=0, Status='live', Symbol='Gfer', Aliases=['Alr', 'ER', 'ERV1'], description='growth factor, augmenter of liver regeneration', other_designations='FAD-linked sulfhydryl oxidase ALR|augmenter of liver regeneration|growth factor, erv1-like (augmenter of liver regeneration)', map_location='17 12.48 cM', chromosome='17', genomic_nucleotide_accession_version='NC_000083.6', start_position_on_the_genomic_accession=24693190, end_position_on_the_genomic_accession=24696156, orientation='minus', exon_count=3, OMIM=[], no_hdr0=''),
    11694 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=11694, CurrentID=0, Status='live', Symbol='Alx3', Aliases=[], description='aristaless-like homeobox 3', other_designations='homeobox protein aristaless-like 3|proline-rich transcription factor Alx3', map_location='3 46.83 cM', chromosome='3', genomic_nucleotide_accession_version='NC_000069.6', start_position_on_the_genomic_accession=107595031, end_position_on_the_genomic_accession=107605875, orientation='plus', exon_count=4, OMIM=[], no_hdr0=''),
    11695 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=11695, CurrentID=0, Status='live', Symbol='Alx4', Aliases=['lst'], description='aristaless-like homeobox 4', other_designations="homeobox protein aristaless-like 4|ALX-4|Aristaless-like 4|Strong's luxoid|aristaless 4", map_location='2 51.62 cM', chromosome='2', genomic_nucleotide_accession_version='NC_000068.7', start_position_on_the_genomic_accession=93642434, end_position_on_the_genomic_accession=93681341, orientation='plus', exon_count=5, OMIM=[], no_hdr0=''),
    11698 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=11698, CurrentID=0, Status='live', Symbol='Ambn', Aliases=[], description='ameloblastin', other_designations='ameloblastin', map_location='5 43.63 cM', chromosome='5', genomic_nucleotide_accession_version='NC_000071.6', start_position_on_the_genomic_accession=88455991, end_position_on_the_genomic_accession=88468531, orientation='plus', exon_count=11, OMIM=[], no_hdr0=''),
    11699 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=11699, CurrentID=0, Status='live', Symbol='Ambp', Aliases=['AI194774', 'ASPI', 'HI-3', 'HI-30', 'I', 'In', 'Intin4', 'Itil', 'UT', 'UTI', 'uli'], description='alpha 1 microglobulin/bikunin precursor', other_designations='protein AMBP|Urinary Trypsin Inhibitor|ulinastatin', map_location='4 33.96 cM', chromosome='4', genomic_nucleotide_accession_version='NC_000070.6', start_position_on_the_genomic_accession=63143275, end_position_on_the_genomic_accession=63154172, orientation='minus', exon_count=10, OMIM=[], no_hdr0=''),
    11702 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=11702, CurrentID=0, Status='live', Symbol='Amd1', Aliases=['AdoMet', 'AdoMetDC', 'Amd-', 'Amd-1', 'SAM', 'SAMDC', 'SAMDC 1', 'adoMetDC1'], description='S-adenosylmethionine decarboxylase 1', other_designations='S-adenosylmethionine decarboxylase proenzyme 1|adoMetDC 1', map_location='10 21.85 cM', chromosome='10', genomic_nucleotide_accession_version='NC_000076.6', start_position_on_the_genomic_accession=40287458, end_position_on_the_genomic_accession=40302188, orientation='minus', exon_count=8, OMIM=[], no_hdr0=''),
    11704 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=11704, CurrentID=0, Status='live', Symbol='Amelx', Aliases=['ALGN', 'AMGL', 'AMGX', 'Am', 'Amel', 'Amg', 'LRAP', 'Rgsc8', 'Rgsc888'], description='amelogenin, X-linked', other_designations='amelogenin, X isoform|amelogenin X chromosome|enamel matrix protein|leucine-rich amelogenin peptide', map_location='X 78.95 cM', chromosome='X', genomic_nucleotide_accession_version='NC_000086.7', start_position_on_the_genomic_accession=169176114, end_position_on_the_genomic_accession=169187209, orientation='minus', exon_count=8, OMIM=[], no_hdr0=''),
    11705 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=11705, CurrentID=0, Status='live', Symbol='Amh', Aliases=['M', 'MIS'], description='anti-Mullerian hormone', other_designations='muellerian-inhibiting factor|Mullerian inhibiting substance|anti-Muellerian hormone|muellerian-inhibiting substance', map_location='10 39.72 cM', chromosome='10', genomic_nucleotide_accession_version='NC_000076.6', start_position_on_the_genomic_accession=80805240, end_position_on_the_genomic_accession=80807679, orientation='plus', exon_count=5, OMIM=[], no_hdr0=''),
    11717 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=11717, CurrentID=0, Status='live', Symbol='Ampd3', Aliases=[], description='adenosine monophosphate deaminase 3', other_designations='AMP deaminase 3|AMP deaminase H-type|heart-type AMPD', map_location='7 57.85 cM', chromosome='7', genomic_nucleotide_accession_version='NC_000073.6', start_position_on_the_genomic_accession=110767790, end_position_on_the_genomic_accession=110812409, orientation='plus', exon_count=21, OMIM=[], no_hdr0=''),
    11720 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=11720, CurrentID=0, Status='live', Symbol='Mat1a', Aliases=['A', 'AI046368', 'AdoM', 'AdoMet', 'Ams', 'MA', 'MAT', 'MATA1', 'S', 'SA', 'SAMS', 'SAMS1'], description='methionine adenosyltransferase I, alpha', other_designations='S-adenosylmethionine synthase isoform type-1|S-adenosylmethionine synthase|adoMet synthetase 1', map_location='14 B', chromosome='14', genomic_nucleotide_accession_version='NC_000080.6', start_position_on_the_genomic_accession=41105012, end_position_on_the_genomic_accession=41124428, orientation='plus', exon_count=10, OMIM=[], no_hdr0=''),
    11722 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=11722, CurrentID=0, Status='live', Symbol='Amy1', Aliases=['Amy-', 'Amy-1a', 'C030014B17Rik', 'Amy1'], description='amylase 1, salivary', other_designations='alpha-amylase 1|1,4-alpha-D-glucan glucanohydrolase 1|alpha-amylase amy1a|salivary and hepatic alpha-amylase', map_location='3 49.35 cM', chromosome='3', genomic_nucleotide_accession_version='NC_000069.6', start_position_on_the_genomic_accession=113555952, end_position_on_the_genomic_accession=113577750, orientation='minus', exon_count=12, OMIM=[], no_hdr0=''),
    11727 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=11727, CurrentID=0, Status='live', Symbol='Ang', Aliases=['AI385586', 'An1', 'Rn', 'Rnase5', 'Rnase5a', 'Ang'], description='angiogenin, ribonuclease, RNase A family, 5', other_designations='angiogenin|RNase 5|angiogenin, ribonuclease A family, member 1|angiogenin-1|ribonuclease 5', map_location='14 26.37 cM', chromosome='14', genomic_nucleotide_accession_version='NC_000080.6', start_position_on_the_genomic_accession=51091077, end_position_on_the_genomic_accession=51102009, orientation='plus', exon_count=3, OMIM=[], no_hdr0=''),
    11730 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=11730, CurrentID=0, Status='live', Symbol='Ang3', Aliases=['A', 'Angl', 'Ef-5', 'Rna', 'Rnase5c'], description='angiogenin, ribonuclease A family, member 3', other_designations='angiogenin-3|angiogenin related protein 2', map_location='14 C1', chromosome='14', genomic_nucleotide_accession_version='', start_position_on_the_genomic_accession='', end_position_on_the_genomic_accession='', orientation='', exon_count='', OMIM=[], no_hdr0=''),
    11731 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=11731, CurrentID=0, Status='live', Symbol='Ang2', Aliases=['A', 'Angrp', 'Raa3', 'Rna', 'Rnase5b'], description='angiogenin, ribonuclease A family, member 2', other_designations='angiogenin-2|angiogenin related protein|ribonuclease A a3', map_location='14 C1', chromosome='14', genomic_nucleotide_accession_version='NC_000080.6', start_position_on_the_genomic_accession=51195486, end_position_on_the_genomic_accession=51195923, orientation='minus', exon_count=1, OMIM=[], no_hdr0=''),
    11732 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=11732, CurrentID=0, Status='live', Symbol='Ank', Aliases=['Ankh', 'D15Ertd221', 'D15Ertd221e', 'ank', 'mKIAA1581'], description='progressive ankylosis', other_designations='progressive ankylosis protein|fn54 protein', map_location='15 10.23 cM', chromosome='15', genomic_nucleotide_accession_version='NC_000081.6', start_position_on_the_genomic_accession=27466677, end_position_on_the_genomic_accession=27594909, orientation='plus', exon_count=12, OMIM=[], no_hdr0=''),
    11733 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=11733, CurrentID=0, Status='live', Symbol='Ank1', Aliases=['Ank', 'Ank-1', 'nb', 'p', 'pale'], description='ankyrin 1, erythroid', other_designations='ankyrin-1|erythrocyte ankyrin|normoblastic anemia', map_location='8 11.42 cM', chromosome='8', genomic_nucleotide_accession_version='NC_000074.6', start_position_on_the_genomic_accession=22974836, end_position_on_the_genomic_accession=23150501, orientation='plus', exon_count=50, OMIM=[], no_hdr0=''),
    11735 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=11735, CurrentID=0, Status='live', Symbol='Ank3', Aliases=['2900054D09Rik', 'AI314020', 'An', 'Ank', 'Ank-3', 'AnkG', 'Anky', 'Ankyrin-3', 'Ankyrin-G'], description='ankyrin 3, epithelial', other_designations='ankyrin-3|brain-specific ankyrin-G', map_location='10 36.1 cM', chromosome='10', genomic_nucleotide_accession_version='NC_000076.6', start_position_on_the_genomic_accession=69533486, end_position_on_the_genomic_accession=70027436, orientation='plus', exon_count=51, OMIM=[], no_hdr0=''),
    11736 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=11736, CurrentID=0, Status='live', Symbol='Ankfy1', Aliases=['Ank', 'Ankhzn', 'ZFYVE14', 'mKIAA1255'], description='ankyrin repeat and FYVE domain containing 1', other_designations='rabankyrin-5|Rabankyrin-5|ankyrin repeat and FYVE domain-containing protein 1|ankyrin repeat hooked to a zinc finger motif|ankyrin repeat hooked to zinc finger motif|ankyrin repeats hooked to a zinc finger motif|rank-5', map_location='11 B4', chromosome='11', genomic_nucleotide_accession_version='NC_000077.6', start_position_on_the_genomic_accession=72690002, end_position_on_the_genomic_accession=72772146, orientation='plus', exon_count=25, OMIM=[], no_hdr0=''),
    11737 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=11737, CurrentID=0, Status='live', Symbol='Anp32a', Aliases=['An', 'Anp32', 'I1PP2A', 'LANP', 'PHAP1', 'W91701', 'pp', 'pp32'], description='acidic (leucine-rich) nuclear phosphoprotein 32 family, member A', other_designations='acidic leucine-rich nuclear phosphoprotein 32 family member A|acidic nuclear phosphoprotein 32|acidic nuclear phosphoprotein pp32|leucine-rich acidic nuclear protein|potent heat-stable protein phosphatase 2A inhibitor I1PP2A|vacidic (leucine-rich) nuclear phosphoprotein 32 family, member A', map_location='9 33.68 cM', chromosome='9', genomic_nucleotide_accession_version='NC_000075.6', start_position_on_the_genomic_accession=62341343, end_position_on_the_genomic_accession=62378804, orientation='plus', exon_count=8, OMIM=[], no_hdr0=''),
    11739 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=11739, CurrentID=0, Status='live', Symbol='Slc25a4', Aliases=['AU019225', 'An', 'Ant1', 'mANC1'], description='solute carrier family 25 (mitochondrial carrier, adenine nucleotide translocator), member 4', other_designations='ADP/ATP translocase 1|ADP,ATP carrier protein 1|ADP,ATP carrier protein, heart/skeletal muscle|ANT 1|adenine nucleotide translocase-1|adenine nucleotide translocator 1, skeletal muscle|solute carrier family 25 member 4', map_location='8 26.22 cM', chromosome='8', genomic_nucleotide_accession_version='NC_000074.6', start_position_on_the_genomic_accession=46207168, end_position_on_the_genomic_accession=46211062, orientation='minus', exon_count=4, OMIM=[], no_hdr0=''),
    11740 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=11740, CurrentID=0, Status='live', Symbol='Slc25a5', Aliases=['An', 'Ant2'], description='solute carrier family 25 (mitochondrial carrier, adenine nucleotide translocator), member 5', other_designations='ADP/ATP translocase 2|ADP, ATP carrier protein 2|adenine nucleotide translocase|adenine nucleotide translocator 2, fibroblast', map_location='X 21.2 cM', chromosome='X', genomic_nucleotide_accession_version='NC_000086.7', start_position_on_the_genomic_accession=36795597, end_position_on_the_genomic_accession=36798808, orientation='plus', exon_count=4, OMIM=[], no_hdr0=''),
    11744 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=11744, CurrentID=0, Status='live', Symbol='Anxa11', Aliases=['A830099O17Rik', 'Anx', 'Anx11'], description='annexin A11', other_designations='annexin A11|Annexin A11 (Annexin XI) (Calcyclin-associated annexin 50) (CAP-50)|CAP-50|annexin XI|annexin-11|calcyclin-associated annexin 50', map_location='14 15.06 cM', chromosome='14', genomic_nucleotide_accession_version='NC_000080.6', start_position_on_the_genomic_accession=25842127, end_position_on_the_genomic_accession=25886804, orientation='plus', exon_count=16, OMIM=[], no_hdr0=''),
    11745 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=11745, CurrentID=0, Status='live', Symbol='Anxa3', Aliases=['An', 'Anx3'], description='annexin A3', other_designations='annexin A3|35-alpha calcimedin|PAP-III|annexin III|annexin-3|lipocortin III|placental anticoagulant protein III', map_location='5 47.29 cM', chromosome='5', genomic_nucleotide_accession_version='NC_000071.6', start_position_on_the_genomic_accession=96793385, end_position_on_the_genomic_accession=96845968, orientation='plus', exon_count=13, OMIM=[], no_hdr0=''),
    11746 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=11746, CurrentID=0, Status='live', Symbol='Anxa4', Aliases=['AI265406', 'AIV', 'AW106930', 'An', 'Anx4', 'Xanx', 'Xanx-4'], description='annexin A4', other_designations='annexin A4|annexin IV|annexin-4', map_location='6 37.75 cM', chromosome='6', genomic_nucleotide_accession_version='NC_000072.6', start_position_on_the_genomic_accession=86736840, end_position_on_the_genomic_accession=86793634, orientation='minus', exon_count=16, OMIM=[], no_hdr0=''),
    11747 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=11747, CurrentID=0, Status='live', Symbol='Anxa5', Aliases=['An', 'Anx5', 'R74653'], description='annexin A5', other_designations='annexin A5|CBP-I|PAP-I|PP4|VAC-alpha|anchorin CII|annexin V|annexin-5|calphobindin I|endonexin II|lipocortin V|placental anticoagulant protein 4|placental anticoagulant protein I|thromboplastin inhibitor|vascular anticoagulant-alpha', map_location='3 17.46 cM', chromosome='3', genomic_nucleotide_accession_version='NC_000069.6', start_position_on_the_genomic_accession=36448923, end_position_on_the_genomic_accession=36475887, orientation='minus', exon_count=13, OMIM=[], no_hdr0=''),
    11749 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=11749, CurrentID=0, Status='live', Symbol='Anxa6', Aliases=['A', 'AW107198', 'An', 'Anx6', 'AnxVI', 'Cab', 'Cabm', 'Cam', 'Camb'], description='annexin A6', other_designations='annexin A6|67 kDa calelectrin|CPB-II|annexin VI, p68|annexin-6|calphobindin-II|chromobindin-20|lipocortin VI|p68|p70', map_location='11 32.13 cM', chromosome='11', genomic_nucleotide_accession_version='NC_000077.6', start_position_on_the_genomic_accession=54978953, end_position_on_the_genomic_accession=55033471, orientation='minus', exon_count=26, OMIM=[], no_hdr0=''),
    11750 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=11750, CurrentID=0, Status='live', Symbol='Anxa7', Aliases=['AI265384', 'AI316497', 'An', 'Anx7', 'syn', 'synexin'], description='annexin A7', other_designations='annexin A7|annexin VII|annexin-7', map_location='14 11.53 cM', chromosome='14', genomic_nucleotide_accession_version='NC_000080.6', start_position_on_the_genomic_accession=20455261, end_position_on_the_genomic_accession=20480133, orientation='minus', exon_count=14, OMIM=[], no_hdr0=''),
    11752 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=11752, CurrentID=0, Status='live', Symbol='Anxa8', Aliases=['AI466995', 'An', 'Anx8'], description='annexin A8', other_designations='annexin A8|annexin 8|annexin VIII', map_location='14 20.8 cM', chromosome='14', genomic_nucleotide_accession_version='NC_000080.6', start_position_on_the_genomic_accession=34085979, end_position_on_the_genomic_accession=34100571, orientation='plus', exon_count=12, OMIM=[], no_hdr0=''),
    11754 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=11754, CurrentID=0, Status='live', Symbol='Aoc3', Aliases=['SSAO', 'V', 'VAP1'], description='amine oxidase, copper containing 3', other_designations='membrane primary amine oxidase|VAP-1|copper amine oxidase|semicarbazide-sensitive amine oxidase|vascular adhesion protein 1', map_location='11 D', chromosome='11', genomic_nucleotide_accession_version='NC_000077.6', start_position_on_the_genomic_accession=101330606, end_position_on_the_genomic_accession=101339430, orientation='plus', exon_count=6, OMIM=[], no_hdr0=''),
    11757 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=11757, CurrentID=0, Status='live', Symbol='Prdx3', Aliases=['A', 'AW822249', 'Aop1', 'D0Toh', 'D0Tohi1', 'Ef2', 'Ef2l', 'Mer', 'Mer5', 'Prx3', 'SP', 'SP22', 'TDXM'], description='peroxiredoxin 3', other_designations='thioredoxin-dependent peroxide reductase, mitochondrial|AOP-1|Prx III|anti-oxidant protein 1|mitochondrial Trx dependent peroxide reductase|mitochondrial thioredoxin dependent peroxide reductase|perioredoxin-3|peroxiredoxin III|thioredoxin-dependent peroxiredoxin 3', map_location='19 56.52 cM', chromosome='19', genomic_nucleotide_accession_version='NC_000085.6', start_position_on_the_genomic_accession=60864066, end_position_on_the_genomic_accession=60874538, orientation='minus', exon_count=7, OMIM=[], no_hdr0=''),
    11758 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=11758, CurrentID=0, Status='live', Symbol='Prdx6', Aliases=['1-Cys Prx', '1-cys', '1-cysPrx', '9430088D19Rik', 'AA690119', 'Aop2', 'Brp-', 'Brp-12', 'CP-', 'CP-3', 'GP', 'GPx', 'Ltw', 'Ltw-', 'Ltw-4', 'Ltw4', 'Lvtw', 'Lvtw-4', 'N', 'NSGPx', 'ORF06', 'Prdx5', 'a', 'aiPLA2'], description='peroxiredoxin 6', other_designations='peroxiredoxin-6|1-Cys peroxiredoxin|acidic calcium-independent phospholipase A2|anti-oxidant protein 2, related sequence 3|antioxidant protein 2|glutathione-dependent peroxiredoxin|non-selenium glutathione peroxidase|peroxiredoxin 5, related sequence 3|peroxiredoxin 6, related sequence 3', map_location='1 69.75 cM', chromosome='1', genomic_nucleotide_accession_version='NC_000067.6', start_position_on_the_genomic_accession=161240112, end_position_on_the_genomic_accession=161251210, orientation='minus', exon_count=6, OMIM=[], no_hdr0=''),
    11761 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=11761, CurrentID=0, Status='live', Symbol='Aox1', Aliases=['AI196512', 'AI255253', 'Ao', 'Aox', 'Aox-1', 'Aox-2', 'Aox2', 'Moro', 'Ro'], description='aldehyde oxidase 1', other_designations='aldehyde oxidase 1|aldehyde oxidase 2|azaheterocycle hydroxylase 1|retinal oxidase', map_location='1 28.86 cM', chromosome='1', genomic_nucleotide_accession_version='NC_000067.6', start_position_on_the_genomic_accession=58029809, end_position_on_the_genomic_accession=58106410, orientation='plus', exon_count=36, OMIM=[], no_hdr0=''),
    11764 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=11764, CurrentID=0, Status='live', Symbol='Ap1b1', Aliases=['Adtb', 'Adtb1', 'b2b1660C', 'b2b1660Clo'], description='adaptor protein complex AP-1, beta 1 subunit', other_designations='AP-1 complex subunit beta-1|adaptor protein complex AP-1 subunit beta-1|adaptor-related protein complex AP-1, beta 1 subunit|beta-adaptin 1|beta-prime adaptin|clathrin assembly protein complex 1 beta large chain|golgi adaptor HA1/AP1 adaptin beta subunit', map_location='11 A1', chromosome='11', genomic_nucleotide_accession_version='NC_000077.6', start_position_on_the_genomic_accession=4947320, end_position_on_the_genomic_accession=5042794, orientation='plus', exon_count=25, OMIM=[], no_hdr0=''),
    11765 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=11765, CurrentID=0, Status='live', Symbol='Ap1g1', Aliases=['AA409002', 'AU041323', 'AW551707', 'Adt', 'Adtg', 'D8Ertd374', 'D8Ertd374e'], description='adaptor protein complex AP-1, gamma 1 subunit', other_designations='AP-1 complex subunit gamma-1|adapter-related protein complex 1 subunit gamma-1|adaptor protein complex AP-1 subunit gamma-1|adaptor-related protein complex 1 subunit gamma-1|clathrin assembly protein complex 1 gamma-1 large chain|gamma-adaptin|gamma1-adaptin|golgi adaptor HA1/AP1 adaptin subunit gamma-1', map_location='8 57.26 cM', chromosome='8', genomic_nucleotide_accession_version='NC_000074.6', start_position_on_the_genomic_accession=109778583, end_position_on_the_genomic_accession=109864210, orientation='plus', exon_count=24, OMIM=[], no_hdr0=''),
    11766 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=11766, CurrentID=0, Status='live', Symbol='Ap1g2', Aliases=['Adtg', 'Adtg2', 'G2ad'], description='adaptor protein complex AP-1, gamma 2 subunit', other_designations='AP-1 complex subunit gamma-like 2|gamma 2-adaptin', map_location='14 C3', chromosome='14', genomic_nucleotide_accession_version='NC_000080.6', start_position_on_the_genomic_accession=55098835, end_position_on_the_genomic_accession=55106593, orientation='minus', exon_count=22, OMIM=[], no_hdr0=''),
    11767 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=11767, CurrentID=0, Status='live', Symbol='Ap1m1', Aliases=['AA408894', 'AP', 'AP47', 'Adtm', 'Adtm1A', 'Clt', 'Cltnm', '[m]1', 'mu1', 'mu1A'], description='adaptor-related protein complex AP-1, mu subunit 1', other_designations='AP-1 complex subunit mu-1|AP-mu chain family member mu1A|adapter-related protein complex 1 subunit mu-1|adaptor protein complex AP-1 mu-1 subunit|adaptor-related protein complex 1 mu-1 subunit|clathrin assembly protein complex 1 medium chain 1|clathrin assembly protein complex 1 mu-1 medium chain 1|clathrin coat assembly protein AP47|clathrin coat-associated protein AP47|golgi adaptor HA1/AP1 adaptin mu-1 subunit|mu-adaptin 1|mu1A-adaptin', map_location='8 34.92 cM', chromosome='8', genomic_nucleotide_accession_version='NC_000074.6', start_position_on_the_genomic_accession=72240013, end_position_on_the_genomic_accession=72257386, orientation='plus', exon_count=14, OMIM=[], no_hdr0=''),
    11768 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=11768, CurrentID=0, Status='live', Symbol='Ap1m2', Aliases=['D9Ertd818', 'D9Ertd818e', '[m]1B', 'mu1B'], description='adaptor protein complex AP-1, mu 2 subunit', other_designations='AP-1 complex subunit mu-2|AP-mu chain family member mu1B|adaptor protein complex AP-1 subunit mu-2|adaptor-related protein complex 1 mu-2 subunit|adaptor-related protein complex 1 subunit mu-2|adaptor-related protein complex AP-1, mu 2 subunit|clathrin assembly protein complex 1 medium chain 2|clathrin assembly protein complex 1 mu-2 medium chain 2|golgi adaptor HA1/AP1 adaptin mu-2 subunit|mu-adaptin 2|mu1B-adaptin', map_location='9 7.76 cM', chromosome='9', genomic_nucleotide_accession_version='NC_000075.6', start_position_on_the_genomic_accession=21294615, end_position_on_the_genomic_accession=21312349, orientation='minus', exon_count=11, OMIM=[], no_hdr0=''),
    11769 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=11769, CurrentID=0, Status='live', Symbol='Ap1s1', Aliases=['AP', 'AP19'], description='adaptor protein complex AP-1, sigma 1', other_designations='AP-1 complex subunit sigma-1A|HA1 19 kDa subunit|adapter-related protein complex 1 sigma-1A subunit|adapter-related protein complex 1 subunit sigma-1A|adaptor protein complex AP-1 sigma-1A subunit|adaptor protein complex AP-1 subunit sigma-1A|adaptor-related protein complex 1 subunit sigma-1A|adaptor-related protein complex AP-1, sigma 1|clathrin assembly protein complex 1 sigma-1A small chain|clathrin coat assembly protein AP19|golgi adaptor HA1/AP1 adaptin sigma-1A subunit|sigma 1a subunit of AP-1 clathrin|sigma-adaptin 1A|sigma1A-adaptin', map_location='5 G2', chromosome='5', genomic_nucleotide_accession_version='NC_000071.6', start_position_on_the_genomic_accession=137034993, end_position_on_the_genomic_accession=137046108, orientation='minus', exon_count=6, OMIM=[], no_hdr0=''),
    11770 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=11770, CurrentID=0, Status='live', Symbol='Fabp4', Aliases=['422/a', '422/aP2', 'A', 'AFABP', 'ALB', 'ALBP', 'ALBP/Ap2', 'Ap2', 'L', 'Lbpl', 'P15'], description='fatty acid binding protein 4, adipocyte', other_designations='fatty acid-binding protein, adipocyte|3T3-L1 lipid-binding protein|P2 adipocyte protein|adipocyte lipid-binding protein|adipocyte protein aP2|adipocyte-type fatty acid-binding protein|fatty acid-binding protein 4|myelin P2 protein homolog|protein 422', map_location='3 2.56 cM', chromosome='3', genomic_nucleotide_accession_version='NC_000069.6', start_position_on_the_genomic_accession=10204342, end_position_on_the_genomic_accession=10208616, orientation='minus', exon_count=4, OMIM=[], no_hdr0=''),
    11771 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=11771, CurrentID=0, Status='live', Symbol='Ap2a1', Aliases=['Ad', 'Adtaa'], description='adaptor-related protein complex 2, alpha 1 subunit', other_designations='AP-2 complex subunit alpha-1|100 kDa coated vesicle protein A|adapter-related protein complex 2 alpha-1 subunit|adapter-related protein complex 2 subunit alpha-1|adaptor protein complex AP-2 subunit alpha-1|adaptor protein complex AP-2, alpha 1 subunit|adaptor-related protein complex 2 subunit alpha-1|adaptor-related protein complex AP-2, alpha 1 subunit|alpha-adaptin A|alpha1-adaptin|clathrin assembly protein complex 2 alpha-A large chain|plasma membrane adaptor HA2/AP2 adaptin alpha A subunit', map_location='7 B3', chromosome='7', genomic_nucleotide_accession_version='NC_000073.6', start_position_on_the_genomic_accession=44900373, end_position_on_the_genomic_accession=44929490, orientation='minus', exon_count=25, OMIM=[], no_hdr0=''),
    11772 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=11772, CurrentID=0, Status='live', Symbol='Ap2a2', Aliases=['2410074K14Rik', 'AF006990', 'AW146353', 'Adt', 'Adtab', 'C78001', 'L2', 'L25'], description='adaptor-related protein complex 2, alpha 2 subunit', other_designations='AP-2 complex subunit alpha-2|100 kDa coated vesicle protein C|adapter-related protein complex 2 alpha-2 subunit|adapter-related protein complex 2 subunit alpha-2|adaptor protein complex AP-2 subunit alpha-2|adaptor protein complex AP-2, alpha 2 subunit|adaptor-related protein complex 2 subunit alpha-2|adaptor-related protein complex AP-2, alpha 2 subunit|alpha-C adaptin|alpha-adaptin C|alpha2-adaptin|clathrin assembly protein complex 2 alpha-C large chain|plasma membrane adaptor HA2/AP2 adaptin alpha C subunit', map_location='7 F5', chromosome='7', genomic_nucleotide_accession_version='NC_000073.6', start_position_on_the_genomic_accession=141562180, end_position_on_the_genomic_accession=141633011, orientation='plus', exon_count=23, OMIM=[], no_hdr0=''),
    11773 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=11773, CurrentID=0, Status='live', Symbol='Ap2m1', Aliases=[], description='adaptor-related protein complex 2, mu 1 subunit', other_designations='AP-2 complex subunit mu|AP-2 mu chain|adapter-related protein complex 2 mu subunit|adaptor protein complex AP-2 subunit mu|adaptor protein complex AP-2, mu1|adaptor-related protein complex 2 subunit mu|adaptor-related protein complex AP-2, mu1|clathrin assembly protein complex 2 medium chain|clathrin assembly protein complex 2 mu medium chain|clathrin coat assembly protein AP50|clathrin coat-associated protein AP50|clathrin-associated AP-2|mu2-adaptin|plasma membrane adaptor AP-2 50 kDa protein', map_location='16 A3', chromosome='16', genomic_nucleotide_accession_version='NC_000082.6', start_position_on_the_genomic_accession=20535480, end_position_on_the_genomic_accession=20544909, orientation='plus', exon_count=12, OMIM=[], no_hdr0=''),
    11774 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=11774, CurrentID=0, Status='live', Symbol='Ap3b1', Aliases=['AP', 'AP-3', 'AU015684', 'C78395', 'Hp', 'Hps2', 'beta3A', 'pe', 'pearl', 'ri', 'rim2'], description='adaptor-related protein complex 3, beta 1 subunit', other_designations='AP-3 complex subunit beta-1|adapter-related protein complex 3 subunit beta-1|adaptor protein complex AP-3 beta-1 subunit|adaptor protein complex AP-3 subunit beta-1|adaptor-related protein complex 3 subunit beta-1|adaptor-related protein complex AP-3 beta 1 subunit|beta-3A-adaptin|beta3A-adaptin|clathrin assembly protein complex 3 beta-1 large chain|recombination induced mutation 2', map_location='13 49.22 cM', chromosome='13', genomic_nucleotide_accession_version='NC_000079.6', start_position_on_the_genomic_accession=94358960, end_position_on_the_genomic_accession=94566316, orientation='plus', exon_count=28, OMIM=[], no_hdr0=''),
    11775 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=11775, CurrentID=0, Status='live', Symbol='Ap3b2', Aliases=['AI549966', 'AU042881', 'Na', 'Naptb', '[b]-NAP', 'beta-NAP', 'beta3', 'beta3B'], description='adaptor-related protein complex 3, beta 2 subunit', other_designations='AP-3 complex subunit beta-2|AP-3 complex beta-2 subunit|adapter-related protein complex 3 subunit beta-2|adaptor protein complex AP-3 beta-2 subunit|adaptor protein complex AP-3 subunit beta-2|adaptor-related protein complex 3 subunit beta-2|adaptor-related protein complex AP-3, beta 2 subunit|beta-3B-adaptin|beta3B-adaptin|clathrin assembly protein complex 3 beta-2 large chain', map_location='7 45.71 cM', chromosome='7', genomic_nucleotide_accession_version='NC_000073.6', start_position_on_the_genomic_accession=81460399, end_position_on_the_genomic_accession=81493997, orientation='minus', exon_count=27, OMIM=[], no_hdr0=''),
    11776 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=11776, CurrentID=0, Status='live', Symbol='Ap3d1', Aliases=['AA407035', 'Ap3d', 'B', 'Bolvr', 'mBL', 'mBLVR1', 'mh', 'mocha'], description='adaptor-related protein complex 3, delta 1 subunit', other_designations='AP-3 complex subunit delta-1|AP-3 complex subunit delta|adapter-related protein complex 3 subunit delta-1|adaptor-related protein complex 3 subunit delta-1|adaptor-related protein complex 3, delta subunit|adaptor-related protein complex AP-3, delta subunit|delta-adaptin', map_location='10 39.72 cM', chromosome='10', genomic_nucleotide_accession_version='NC_000076.6', start_position_on_the_genomic_accession=80706956, end_position_on_the_genomic_accession=80742303, orientation='minus', exon_count=32, OMIM=[], no_hdr0=''),
    11777 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=11777, CurrentID=0, Status='live', Symbol='Ap3s1', Aliases=['[s]'], description='adaptor-related protein complex 3, sigma 1 subunit', other_designations='AP-3 complex subunit sigma-1|AP-3 complex sigma-3A subunit|adapter-related protein complex 3 sigma-1 subunit|adaptor-related protein complex AP-3, sigma 1 subunit|sigma-3A-adaptin|sigma-adaptin 3a', map_location='18 C', chromosome='18', genomic_nucleotide_accession_version='NC_000084.6', start_position_on_the_genomic_accession=46741694, end_position_on_the_genomic_accession=46790826, orientation='plus', exon_count=7, OMIM=[], no_hdr0=''),
    11778 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=11778, CurrentID=0, Status='live', Symbol='Ap3s2', Aliases=['[s]3', '[s]3B'], description='adaptor-related protein complex 3, sigma 2 subunit', other_designations='AP-3 complex subunit sigma-2|AP-3 complex sigma-3B subunit|AP-3 complex subunit sigma-3B|adapter-related protein complex 3 sigma-2 subunit|adapter-related protein complex 3 subunit sigma-2|adaptor-related protein complex 3 subunit sigma-2|adaptor-related protein complex AP-3, sigma 2 subunit|sigma 3B|sigma-3B-adaptin|sigma-adaptin 3b|sigma3B-adaptin', map_location='7 D2', chromosome='7', genomic_nucleotide_accession_version='NC_000073.6', start_position_on_the_genomic_accession=79875325, end_position_on_the_genomic_accession=79920640, orientation='minus', exon_count=6, OMIM=[], no_hdr0=''),
    11781 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=11781, CurrentID=0, Status='live', Symbol='Ap4m1', Aliases=['4930443L05Rik', 'Ap4m4'], description='adaptor-related protein complex AP-4, mu 1', other_designations='AP-4 complex subunit mu-1|AP-4 adapter complex mu subunit|AP-4 adaptor complex mu subunit|adapter-related protein complex 4 mu-1 subunit|adapter-related protein complex 4 subunit mu-1|adaptor-related protein complex 4 subunit mu-1|adaptor-related protein complex AP-4 mu4 subunit|mu subunit of AP-4|mu-ARP2|mu-adaptin-related protein 2|mu4|mu4-adaptin', map_location='5 G2', chromosome='5', genomic_nucleotide_accession_version='NC_000071.6', start_position_on_the_genomic_accession=138172021, end_position_on_the_genomic_accession=138180429, orientation='plus', exon_count=15, OMIM=[], no_hdr0=''),
    11782 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=11782, CurrentID=0, Status='live', Symbol='Ap4s1', Aliases=['AI314282'], description='adaptor-related protein complex AP-4, sigma 1', other_designations='AP-4 complex subunit sigma-1|AP-4 adapter complex subunit sigma-1|adapter-related protein complex 4 subunit sigma-1|sigma4-adaptin', map_location='12 B3', chromosome='12', genomic_nucleotide_accession_version='NC_000078.6', start_position_on_the_genomic_accession=51680481, end_position_on_the_genomic_accession=51738933, orientation='plus', exon_count=8, OMIM=[], no_hdr0=''),
    11783 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=11783, CurrentID=0, Status='live', Symbol='Apaf1', Aliases=['6230400I06Rik', 'Ap', 'Apaf-1l', 'fog', 'mKIAA0413', 'Apaf1'], description='apoptotic peptidase activating factor 1', other_designations='apoptotic protease-activating factor 1|forebrain overgrowth', map_location='10 45.47 cM', chromosome='10', genomic_nucleotide_accession_version='NC_000076.6', start_position_on_the_genomic_accession=90989311, end_position_on_the_genomic_accession=91082743, orientation='minus', exon_count=27, OMIM=[], no_hdr0=''),
    11784 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=11784, CurrentID=0, Status='live', Symbol='Apba2', Aliases=['X11', 'X11-li', 'X11-like', 'X11L', 'XllL', 'mXllL'], description='amyloid beta (A4) precursor protein-binding, family A, member 2', other_designations='amyloid-beta A4 precursor protein-binding family A member 2|Mint 2|adapter protein X11beta|mint-2|neuron-specific X11L protein|neuronal Munc18-1-interacting protein 2', map_location='7 34.65 cM', chromosome='7', genomic_nucleotide_accession_version='NC_000073.6', start_position_on_the_genomic_accession=64501560, end_position_on_the_genomic_accession=64753878, orientation='plus', exon_count=19, OMIM=[], no_hdr0=''),
    11785 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=11785, CurrentID=0, Status='live', Symbol='Apbb1', Aliases=['Fe65', 'Rir'], description='amyloid beta (A4) precursor protein-binding, family B, member 1', other_designations='amyloid-beta A4 precursor protein-binding family B member 1', map_location='7 55.9 cM', chromosome='7', genomic_nucleotide_accession_version='NC_000073.6', start_position_on_the_genomic_accession=105558465, end_position_on_the_genomic_accession=105581924, orientation='minus', exon_count=19, OMIM=[], no_hdr0=''),
    11787 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=11787, CurrentID=0, Status='live', Symbol='Apbb2', Aliases=['2310007D03Rik', 'FE65L', 'FE65L1', 'R', 'Rirl1', 'TR', 'TR2L', 'Zf', 'Zfra'], description='amyloid beta (A4) precursor protein-binding, family B, member 2', other_designations='amyloid-beta A4 precursor protein-binding family B member 2|zinc finger-like protein', map_location='5 C3.1', chromosome='5', genomic_nucleotide_accession_version='NC_000071.6', start_position_on_the_genomic_accession=66298725, end_position_on_the_genomic_accession=66619064, orientation='minus', exon_count=21, OMIM=[], no_hdr0=''),
    11789 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=11789, CurrentID=0, Status='live', Symbol='Apc', Aliases=['AI047805', 'AU020952', 'AW124434', 'CC1', 'M', 'Min', 'mAPC'], description='APC, WNT signaling pathway regulator', other_designations='adenomatous polyposis coli protein|adenomatosis polyposis coli|multiple intestinal neoplasia', map_location='18 18.53 cM', chromosome='18', genomic_nucleotide_accession_version='NC_000084.6', start_position_on_the_genomic_accession=34220297, end_position_on_the_genomic_accession=34322190, orientation='plus', exon_count=19, OMIM=[], no_hdr0=''),
    11790 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=11790, CurrentID=0, Status='live', Symbol='Speg', Aliases=['AW125581', 'Ape', 'Apeg1', 'BPE', 'BPEG', 'D1Bwg1450e', 'SP', 'SPE', 'SPEGalpha', 'SPEGb', 'SPEGbeta', 'mKIAA1297'], description='SPEG complex locus', other_designations='striated muscle-specific serine/threonine-protein kinase|APEG-1|aortic preferentially expressed gene 1|aortic preferentially expressed protein 1', map_location='1 38.88 cM', chromosome='1', genomic_nucleotide_accession_version='NC_000067.6', start_position_on_the_genomic_accession=75375297, end_position_on_the_genomic_accession=75432320, orientation='plus', exon_count=49, OMIM=[], no_hdr0=''),
    11792 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=11792, CurrentID=0, Status='live', Symbol='Apex1', Aliases=['APE', 'Apex', 'HA', 'HAP1', 'Ref-', 'Ref-1'], description='apurinic/apyrimidinic endonuclease 1', other_designations='DNA-(apurinic or apyrimidinic site) endonuclease|AP endonuclease 1|APEN|APEX nuclease|DNA-(apurinic or apyrimidinic site) lyase|redox factor-1', map_location='14 26.3 cM', chromosome='14', genomic_nucleotide_accession_version='NC_000080.6', start_position_on_the_genomic_accession=50924949, end_position_on_the_genomic_accession=50927188, orientation='plus', exon_count=5, OMIM=[], no_hdr0=''),
    11793 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=11793, CurrentID=0, Status='live', Symbol='Atg5', Aliases=['2010107M05Rik', '3110067M24Rik', 'AW319544', 'Ap', 'Apg5ll', 'C88337', 'Pad', 'Paddy', 'Atg5'], description='autophagy related 5', other_designations='autophagy protein 5', map_location='10 23.24 cM', chromosome='10', genomic_nucleotide_accession_version='NC_000076.6', start_position_on_the_genomic_accession=44268322, end_position_on_the_genomic_accession=44364299, orientation='plus', exon_count=9, OMIM=[], no_hdr0=''),
    11796 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=11796, CurrentID=0, Status='live', Symbol='Birc3', Aliases=['A', 'AW107670', 'Api1', 'Api2', 'Birc2', 'C-IAP2', 'HI', 'HIAP2', 'I', 'IAP1', 'IAP2', 'MI', 'MIAP1', 'MIAP2', 'MIH', 'MIHB', 'MIHC', 'RNF', 'RNF49', 'cI', 'cIA', 'cIAP-1', 'cIAP-2', 'cIAP1', 'cIAP2'], description='baculoviral IAP repeat-containing 3', other_designations='baculoviral IAP repeat-containing protein 3|IAP-1|RING-type E3 ubiquitin transferase BIRC3|apoptosis inhibitor 1|baculoviral IAP repeat-containing 2|cellular inhibitor of apoptosis 2|inhibitor of apoptosis protein 1|mIAP-1', map_location='9 A1', chromosome='9', genomic_nucleotide_accession_version='NC_000075.6', start_position_on_the_genomic_accession=7847468, end_position_on_the_genomic_accession=7873205, orientation='minus', exon_count=13, OMIM=[], no_hdr0=''),
    11797 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=11797, CurrentID=0, Status='live', Symbol='Birc2', Aliases=['A', 'AW146227', 'Api1', 'Api2', 'Birc3', 'C-IAP1', 'C330006D17Rik', 'HI', 'HIAP1', 'HIAP2', 'I', 'IAP1', 'IAP2', 'MI', 'MIAP1', 'MIAP2', 'MIH', 'MIHB', 'MIHC', 'RNF48', 'cI', 'cIA', 'cIAP1', 'cIAP2', 'mcI', 'mcIAP1'], description='baculoviral IAP repeat-containing 2', other_designations='baculoviral IAP repeat-containing protein 2|IAP-2|RING-type E3 ubiquitin transferase BIRC2|apoptosis inhibitor 2|baculoviral IAP repeat-containing 3|cellular inhibitor of apoptosis 1|inhibitor of apoptosis protein 2|mIAP-2', map_location='9 A1', chromosome='9', genomic_nucleotide_accession_version='NC_000075.6', start_position_on_the_genomic_accession=7818226, end_position_on_the_genomic_accession=7837131, orientation='minus', exon_count=9, OMIM=[], no_hdr0=''),
    11798 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=11798, CurrentID=0, Status='live', Symbol='Xiap', Aliases=['1110015C02Rik', 'A', 'Aipa', 'Api3', 'Bir', 'Birc4', 'I', 'IAP3', 'IL', 'ILP-1', 'MIHA'], description='X-linked inhibitor of apoptosis', other_designations='E3 ubiquitin-protein ligase XIAP|IAP homolog A|RING-type E3 ubiquitin transferase XIAP|X-linked IAP|baculoviral IAP repeat-containing protein 4|inhibitor of apoptosis protein 3', map_location='X A4', chromosome='X', genomic_nucleotide_accession_version='NC_000086.7', start_position_on_the_genomic_accession=42059613, end_position_on_the_genomic_accession=42109664, orientation='plus', exon_count=13, OMIM=[], no_hdr0=''),
    11799 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=11799, CurrentID=0, Status='live', Symbol='Birc5', Aliases=['A', 'AAC-11', 'Api4', 'T', 'TIAP', 's', 'survivin40'], description='baculoviral IAP repeat-containing 5', other_designations='baculoviral IAP repeat-containing protein 5|apoptosis inhibitor 4|apoptosis inhibitor survivin|survivin', map_location='11 E2', chromosome='11', genomic_nucleotide_accession_version='NC_000077.6', start_position_on_the_genomic_accession=117849237, end_position_on_the_genomic_accession=117855743, orientation='plus', exon_count=3, OMIM=[], no_hdr0=''),
    11800 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=11800, CurrentID=0, Status='live', Symbol='Api5', Aliases=['AAC-', 'AAC-11', 'AI196452', 'API-5'], description='apoptosis inhibitor 5', other_designations='apoptosis inhibitor 5|apoptosis inhibitory protein 5', map_location='2 E1', chromosome='2', genomic_nucleotide_accession_version='NC_000068.7', start_position_on_the_genomic_accession=94411727, end_position_on_the_genomic_accession=94438186, orientation='minus', exon_count=14, OMIM=[], no_hdr0=''),
    11801 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=11801, CurrentID=0, Status='live', Symbol='Cd5l', Aliases=['1/6', 'A', 'AAC-', 'AAC-11', 'AI047839', 'AIM', 'Api6', 'CT2', 'Pdp', 'Sp', 'Sp-alpha', 'mAIM'], description='CD5 antigen-like', other_designations='CD5 antigen-like|AIM/Spalpha|CT-2|Pdp 1/6|apoptosis inhibitor 6|apoptosis inhibitor expressed by macrophages', map_location='3 F1', chromosome='3', genomic_nucleotide_accession_version='NC_000069.6', start_position_on_the_genomic_accession=87357881, end_position_on_the_genomic_accession=87371074, orientation='plus', exon_count=6, OMIM=[], no_hdr0=''),
    11803 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=11803, CurrentID=0, Status='live', Symbol='Aplp1', Aliases=[], description='amyloid beta (A4) precursor-like protein 1', other_designations='amyloid-like protein 1|APLP|APLP-1', map_location='7 18.32 cM', chromosome='7', genomic_nucleotide_accession_version='NC_000073.6', start_position_on_the_genomic_accession=30434980, end_position_on_the_genomic_accession=30445582, orientation='minus', exon_count=17, OMIM=[], no_hdr0=''),
    11804 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=11804, CurrentID=0, Status='live', Symbol='Aplp2', Aliases=['AI790698', 'APLP-2', 'CDEBP'], description='amyloid beta (A4) precursor-like protein 2', other_designations='amyloid-like protein 2|CDE1-binding protein CDEBP|CDEI box-binding protein', map_location='9 16.66 cM', chromosome='9', genomic_nucleotide_accession_version='NC_000075.6', start_position_on_the_genomic_accession=31149557, end_position_on_the_genomic_accession=31211848, orientation='minus', exon_count=19, OMIM=[], no_hdr0=''),
    11806 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=11806, CurrentID=0, Status='live', Symbol='Apoa1', Aliases=['Al', 'Alp-1', 'Ap', 'Apoa-1', 'Brp-', 'Brp-14', 'Ltw-', 'Ltw-1', 'Lvtw', 'Lvtw-1', 'Se', 'Sep', 'Sep-1', 'Sep-2', 'Sep2', 'apo-AI', 'apoA-I'], description='apolipoprotein A-I', other_designations='apolipoprotein A-I|apolipoprotein A1', map_location='9 25.36 cM', chromosome='9', genomic_nucleotide_accession_version='NC_000075.6', start_position_on_the_genomic_accession=46228630, end_position_on_the_genomic_accession=46230469, orientation='plus', exon_count=4, OMIM=[], no_hdr0=''),
    11807 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=11807, CurrentID=0, Status='live', Symbol='Apoa2', Aliases=['A', 'Al', 'Alp-2', 'Ap', 'Apo-AII', 'ApoA-II', 'ApoAII', 'Apoa-2', 'Hdl-', 'Hdl-1'], description='apolipoprotein A-II', other_designations='apolipoprotein A-II|apolipoprotein A2', map_location='1 79.22 cM', chromosome='1', genomic_nucleotide_accession_version='NC_000067.6', start_position_on_the_genomic_accession=171221564, end_position_on_the_genomic_accession=171226379, orientation='plus', exon_count=5, OMIM=[], no_hdr0=''),
    11808 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=11808, CurrentID=0, Status='live', Symbol='Apoa4', Aliases=['Ap', 'Apoa-4'], description='apolipoprotein A-IV', other_designations='apolipoprotein A-IV|apo-AIV|apoA-IV|apolipoprotein A4', map_location='9 25.36 cM', chromosome='9', genomic_nucleotide_accession_version='NC_000075.6', start_position_on_the_genomic_accession=46240844, end_position_on_the_genomic_accession=46243458, orientation='plus', exon_count=3, OMIM=[], no_hdr0=''),
    11810 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=11810, CurrentID=0, Status='live', Symbol='Apobec1', Aliases=['Cdar1'], description='apolipoprotein B mRNA editing enzyme, catalytic polypeptide 1', other_designations='C->U-editing enzyme APOBEC-1|apolipoprotein B editing complex 1|mRNA(cytosine(6666)) deaminase 1', map_location='6 57.68 cM', chromosome='6', genomic_nucleotide_accession_version='NC_000072.6', start_position_on_the_genomic_accession=122577792, end_position_on_the_genomic_accession=122603024, orientation='minus', exon_count=10, OMIM=[], no_hdr0=''),
    11811 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=11811, CurrentID=0, Status='live', Symbol='Apobec2', Aliases=['Arp1'], description='apolipoprotein B mRNA editing enzyme, catalytic polypeptide 2', other_designations='C->U-editing enzyme APOBEC-2|apolipoprotein B editing complex 2|mRNA(cytosine(6666)) deaminase 2|probable C->U-editing enzyme APOBEC-2', map_location='17 24.02 cM', chromosome='17', genomic_nucleotide_accession_version='NC_000083.6', start_position_on_the_genomic_accession=48419231, end_position_on_the_genomic_accession=48432728, orientation='minus', exon_count=3, OMIM=[], no_hdr0=''),
    11812 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=11812, CurrentID=0, Status='live', Symbol='Apoc1', Aliases=['Apo-CIB', 'ApoC-IB', 'apo-CI', 'apoC-I'], description='apolipoprotein C-I', other_designations='apolipoprotein C-I|apolipoprotein C1', map_location='7 9.94 cM', chromosome='7', genomic_nucleotide_accession_version='NC_000073.6', start_position_on_the_genomic_accession=19689480, end_position_on_the_genomic_accession=19692659, orientation='minus', exon_count=4, OMIM=[], no_hdr0=''),
    11813 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=11813, CurrentID=0, Status='live', Symbol='Apoc2', Aliases=['apo-CII', 'apoC-II'], description='apolipoprotein C-II', other_designations='apolipoprotein C-II|apolipoprotein C2', map_location='7 9.94 cM', chromosome='7', genomic_nucleotide_accession_version='NC_000073.6', start_position_on_the_genomic_accession=19671579, end_position_on_the_genomic_accession=19677941, orientation='minus', exon_count=6, OMIM=[], no_hdr0=''),
    11814 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=11814, CurrentID=0, Status='live', Symbol='Apoc3', Aliases=['apo-CIII', 'apoC-III'], description='apolipoprotein C-III', other_designations='apolipoprotein C-III|apolipoprotein C3', map_location='9 25.36 cM', chromosome='9', genomic_nucleotide_accession_version='NC_000075.6', start_position_on_the_genomic_accession=46233050, end_position_on_the_genomic_accession=46235636, orientation='minus', exon_count=5, OMIM=[], no_hdr0=''),
    11815 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=11815, CurrentID=0, Status='live', Symbol='Apod', Aliases=[], description='apolipoprotein D', other_designations='apolipoprotein D', map_location='16 21.41 cM', chromosome='16', genomic_nucleotide_accession_version='NC_000082.6', start_position_on_the_genomic_accession=31296192, end_position_on_the_genomic_accession=31314808, orientation='minus', exon_count=6, OMIM=[], no_hdr0=''),
    11816 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=11816, CurrentID=0, Status='live', Symbol='Apoe', Aliases=['A', 'AI255918', 'Apo-E'], description='apolipoprotein E', other_designations='apolipoprotein E', map_location='7 9.94 cM', chromosome='7', genomic_nucleotide_accession_version='NC_000073.6', start_position_on_the_genomic_accession=19696244, end_position_on_the_genomic_accession=19701310, orientation='minus', exon_count=7, OMIM=[], no_hdr0=''),
    11818 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=11818, CurrentID=0, Status='live', Symbol='Apoh', Aliases=['B2G', 'B2GPI', 'beta-2-', 'beta-2-GPI', 'beta2-GPI'], description='apolipoprotein H', other_designations='beta-2-glycoprotein 1|APC inhibitor|activated protein C-binding protein|apo-H|beta(2)GPI|beta-2-glycoprotein I', map_location='11 71.8 cM', chromosome='11', genomic_nucleotide_accession_version='NC_000077.6', start_position_on_the_genomic_accession=108395297, end_position_on_the_genomic_accession=108414396, orientation='plus', exon_count=8, OMIM=[], no_hdr0=''),
    11819 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=11819, CurrentID=0, Status='live', Symbol='Nr2f2', Aliases=['2700033K02Rik', '9430015G03Rik', 'A', 'AR', 'ARP-1', 'Aporp1', 'COUP-', 'COUP-T', 'COUP-TF2', 'COUP-TFII', 'COUPTFB', 'EA', 'EAR3', 'SVP40', 'Tcfcou', 'Tcfcoup2'], description='nuclear receptor subfamily 2, group F, member 2', other_designations='COUP transcription factor 2|COUP transcription factor II|COUP-TF II|apolipoprotein AI regulatory protein 1|apolipoprotein regulatory protein 1', map_location='7 38.66 cM', chromosome='7', genomic_nucleotide_accession_version='NC_000073.6', start_position_on_the_genomic_accession=70351946, end_position_on_the_genomic_accession=70366746, orientation='minus', exon_count=5, OMIM=[], no_hdr0=''),
    11820 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=11820, CurrentID=0, Status='live', Symbol='App', Aliases=['A', 'Abe', 'Abeta', 'Abpp', 'Adap', 'Ag', 'C', 'Cvap', 'E030013M08Rik', 'bet', 'betaApp'], description='amyloid beta (A4) precursor protein', other_designations='amyloid-beta A4 protein|alzheimer disease amyloid A4 protein homolog|amyloid beta A4 protein|amyloid precursor protein|amyloid-beta precursor protein|amyloidogenic glycoprotein|appican|beta-amyloid precursor protein|protease nexin II', map_location='16 46.92 cM', chromosome='16', genomic_nucleotide_accession_version='NC_000082.6', start_position_on_the_genomic_accession=84952666, end_position_on_the_genomic_accession=85175255, orientation='minus', exon_count=19, OMIM=[], no_hdr0=''),
    11821 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=11821, CurrentID=0, Status='live', Symbol='Aprt', Aliases=['C85684'], description='adenine phosphoribosyl transferase', other_designations='adenine phosphoribosyltransferase', map_location='8 71.91 cM', chromosome='8', genomic_nucleotide_accession_version='NC_000074.6', start_position_on_the_genomic_accession=122574637, end_position_on_the_genomic_accession=122576907, orientation='minus', exon_count=5, OMIM=[], no_hdr0=''),
    11826 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=11826, CurrentID=0, Status='live', Symbol='Aqp1', Aliases=['CHIP', 'CHIP28'], description='aquaporin 1', other_designations='aquaporin-1|AQP-1|DER2|aquaporin-CHIP|delayed early response protein 2|growth factor-induced delayed early response protein|water channel protein for red blood cells and kidney proximal tubule', map_location='6 27.38 cM', chromosome='6', genomic_nucleotide_accession_version='NC_000072.6', start_position_on_the_genomic_accession=55336299, end_position_on_the_genomic_accession=55348555, orientation='plus', exon_count=4, OMIM=[], no_hdr0=''),
    11827 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=11827, CurrentID=0, Status='live', Symbol='Aqp2', Aliases=['AQP-CD', 'WCH-CD', 'cph', 'jpk'], description='aquaporin 2', other_designations='aquaporin-2|ADH water channel|AQP-2|aquaporin-CD|collecting duct water channel protein|water channel protein for renal collecting duct', map_location='15 56.13 cM', chromosome='15', genomic_nucleotide_accession_version='NC_000081.6', start_position_on_the_genomic_accession=99579056, end_position_on_the_genomic_accession=99584545, orientation='plus', exon_count=4, OMIM=[], no_hdr0=''),
    11828 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=11828, CurrentID=0, Status='live', Symbol='Aqp3', Aliases=['AQP-2'], description='aquaporin 3', other_designations='aquaporin-3|AQP-3|aquaglyceroporin-3', map_location='4 A5', chromosome='4', genomic_nucleotide_accession_version='NC_000070.6', start_position_on_the_genomic_accession=41092724, end_position_on_the_genomic_accession=41098183, orientation='minus', exon_count=6, OMIM=[], no_hdr0=''),
    11829 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=11829, CurrentID=0, Status='live', Symbol='Aqp4', Aliases=['WCH4', 'aqua'], description='aquaporin 4', other_designations='aquaporin-4|mercurial-insensitive water channel', map_location='18 8.74 cM', chromosome='18', genomic_nucleotide_accession_version='NC_000084.6', start_position_on_the_genomic_accession=15389394, end_position_on_the_genomic_accession=15410982, orientation='minus', exon_count=10, OMIM=[], no_hdr0=''),
    11830 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=11830, CurrentID=0, Status='live', Symbol='Aqp5', Aliases=[], description='aquaporin 5', other_designations='aquaporin-5|AQP-5', map_location='15 56.13 cM', chromosome='15', genomic_nucleotide_accession_version='NC_000081.6', start_position_on_the_genomic_accession=99591028, end_position_on_the_genomic_accession=99594829, orientation='plus', exon_count=4, OMIM=[], no_hdr0=''),
    11831 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=11831, CurrentID=0, Status='live', Symbol='Aqp6', Aliases=['AI790337'], description='aquaporin 6', other_designations='aquaporin-6|AQP-6', map_location='15 56.13 cM', chromosome='15', genomic_nucleotide_accession_version='NC_000081.6', start_position_on_the_genomic_accession=99598468, end_position_on_the_genomic_accession=99605478, orientation='plus', exon_count=5, OMIM=[], no_hdr0=''),
    11832 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=11832, CurrentID=0, Status='live', Symbol='Aqp7', Aliases=['A', 'AQ', 'AQP7L', 'AQPap'], description='aquaporin 7', other_designations='aquaporin-7|AQP-7|aquaglyceroporin-7', map_location='4 A5', chromosome='4', genomic_nucleotide_accession_version='NC_000070.6', start_position_on_the_genomic_accession=41033074, end_position_on_the_genomic_accession=41048237, orientation='minus', exon_count=11, OMIM=[], no_hdr0=''),
    11833 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=11833, CurrentID=0, Status='live', Symbol='Aqp8', Aliases=['AI255744', 'AQP-8'], description='aquaporin 8', other_designations='aquaporin-8', map_location='7 F3', chromosome='7', genomic_nucleotide_accession_version='NC_000073.6', start_position_on_the_genomic_accession=123462294, end_position_on_the_genomic_accession=123468003, orientation='plus', exon_count=6, OMIM=[], no_hdr0=''),
    11834 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=11834, CurrentID=0, Status='live', Symbol='Aqr', Aliases=['AW495846', 'mKIAA0560'], description='aquarius', other_designations='RNA helicase aquarius|intron-binding protein aquarius|intron-binding protein of 160 kDa', map_location='2 57.57 cM', chromosome='2', genomic_nucleotide_accession_version='NC_000068.7', start_position_on_the_genomic_accession=114101161, end_position_on_the_genomic_accession=114175339, orientation='minus', exon_count=36, OMIM=[], no_hdr0=''),
    11835 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=11835, CurrentID=0, Status='live', Symbol='Ar', Aliases=['AW320017', 'Tfm'], description='androgen receptor', other_designations='androgen receptor|dihydrotestosterone receptor|nuclear receptor subfamily 3 group C member 4|testicular feminization', map_location='X 42.82 cM', chromosome='X', genomic_nucleotide_accession_version='NC_000086.7', start_position_on_the_genomic_accession=98148757, end_position_on_the_genomic_accession=98323218, orientation='plus', exon_count=8, OMIM=[], no_hdr0=''),
    11836 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=11836, CurrentID=0, Status='live', Symbol='Araf', Aliases=['1200013E08Rik', 'A-', 'A-Raf', 'AW495444', 'Ar1', 'Araf'], description='Araf proto-oncogene, serine/threonine kinase', other_designations='serine/threonine-protein kinase A-Raf|A-Raf proto-oncogene serine/threonine-protein kinase|proto-oncogene A-Raf|raf-related oncogene|v-raf murine sarcoma 3611 viral oncogene homolog 1', map_location='X 16.3 cM', chromosome='X', genomic_nucleotide_accession_version='NC_000086.7', start_position_on_the_genomic_accession=20797707, end_position_on_the_genomic_accession=20860521, orientation='plus', exon_count=17, OMIM=[], no_hdr0=''),
    11837 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=11837, CurrentID=0, Status='live', Symbol='Rplp0', Aliases=['36B4', 'A', 'Arbp', 'L10E'], description='ribosomal protein, large, P0', other_designations='60S acidic ribosomal protein P0|60S ribosomal protein L10E|acidic ribosomal phosphoprotein P0', map_location='5 F', chromosome='5', genomic_nucleotide_accession_version='NC_000071.6', start_position_on_the_genomic_accession=115559467, end_position_on_the_genomic_accession=115563729, orientation='plus', exon_count=7, OMIM=[], no_hdr0=''),
    11838 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=11838, CurrentID=0, Status='live', Symbol='Arc', Aliases=['Arc33.1', 'C86064', 'arg3.1', 'mArc', 'Arc'], description='activity regulated cytoskeletal-associated protein', other_designations='activity-regulated cytoskeleton-associated protein|ARC/ARG3.1|activity-regulated gene 3.1 protein homolog', map_location='15 34.25 cM', chromosome='15', genomic_nucleotide_accession_version='NC_000081.6', start_position_on_the_genomic_accession=74669081, end_position_on_the_genomic_accession=74672570, orientation='minus', exon_count=3, OMIM=[], no_hdr0=''),
    11839 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=11839, CurrentID=0, Status='live', Symbol='Areg', Aliases=['AR', 'Mcub', 'Sdg', 'Sdgf'], description='amphiregulin', other_designations='amphiregulin|schwannoma-derived growth factor', map_location='5 44.78 cM', chromosome='5', genomic_nucleotide_accession_version='NC_000071.6', start_position_on_the_genomic_accession=91139599, end_position_on_the_genomic_accession=91148432, orientation='plus', exon_count=6, OMIM=[], no_hdr0=''),
    11840 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=11840, CurrentID=0, Status='live', Symbol='Arf1', Aliases=[], description='ADP-ribosylation factor 1', other_designations='ADP-ribosylation factor 1', map_location='11 B1.3', chromosome='11', genomic_nucleotide_accession_version='NC_000077.6', start_position_on_the_genomic_accession=59211412, end_position_on_the_genomic_accession=59228267, orientation='minus', exon_count=6, OMIM=[], no_hdr0=''),
    11841 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=11841, CurrentID=0, Status='live', Symbol='Arf2', Aliases=[], description='ADP-ribosylation factor 2', other_designations='ADP-ribosylation factor 2', map_location='11 67.64 cM', chromosome='11', genomic_nucleotide_accession_version='NC_000077.6', start_position_on_the_genomic_accession=103966725, end_position_on_the_genomic_accession=103985350, orientation='plus', exon_count=6, OMIM=[], no_hdr0=''),
    11842 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=11842, CurrentID=0, Status='live', Symbol='Arf3', Aliases=['5430400P17Rik', 'AI854770'], description='ADP-ribosylation factor 3', other_designations='ADP-ribosylation factor 3', map_location='15 F1', chromosome='15', genomic_nucleotide_accession_version='NC_000081.6', start_position_on_the_genomic_accession=98737624, end_position_on_the_genomic_accession=98763118, orientation='minus', exon_count=5, OMIM=[], no_hdr0=''),
    11843 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=11843, CurrentID=0, Status='live', Symbol='Arf4', Aliases=['AA407803'], description='ADP-ribosylation factor 4', other_designations='ADP-ribosylation factor 4', map_location='14 16.09 cM', chromosome='14', genomic_nucleotide_accession_version='NC_000080.6', start_position_on_the_genomic_accession=26638134, end_position_on_the_genomic_accession=26656842, orientation='plus', exon_count=6, OMIM=[], no_hdr0=''),
    11844 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=11844, CurrentID=0, Status='live', Symbol='Arf5', Aliases=[], description='ADP-ribosylation factor 5', other_designations='ADP-ribosylation factor 5', map_location='6 A3.3', chromosome='6', genomic_nucleotide_accession_version='NC_000072.6', start_position_on_the_genomic_accession=28423604, end_position_on_the_genomic_accession=28426602, orientation='plus', exon_count=6, OMIM=[], no_hdr0=''),
    11845 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=11845, CurrentID=0, Status='live', Symbol='Arf6', Aliases=['AI788669', 'AW496366'], description='ADP-ribosylation factor 6', other_designations='ADP-ribosylation factor 6', map_location='12 C2', chromosome='12', genomic_nucleotide_accession_version='NC_000078.6', start_position_on_the_genomic_accession=69372150, end_position_on_the_genomic_accession=69375980, orientation='plus', exon_count=2, OMIM=[], no_hdr0=''),
    11846 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=11846, CurrentID=0, Status='live', Symbol='Arg1', Aliases=['AI', 'AI256583', 'Arg', 'Arg-1', 'PG', 'PGIF'], description='arginase, liver', other_designations='arginase-1|arginase 1, liver|arginase I|liver-type arginase|type I arginase', map_location='10 A4', chromosome='10', genomic_nucleotide_accession_version='NC_000076.6', start_position_on_the_genomic_accession=24915207, end_position_on_the_genomic_accession=24927470, orientation='minus', exon_count=8, OMIM=[], no_hdr0=''),
    11847 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=11847, CurrentID=0, Status='live', Symbol='Arg2', Aliases=['AII', 'AU022422'], description='arginase type II', other_designations='arginase-2, mitochondrial|arginase II|kidney-type arginase|non-hepatic arginase|type II arginase', map_location='12 C3', chromosome='12', genomic_nucleotide_accession_version='NC_000078.6', start_position_on_the_genomic_accession=79130788, end_position_on_the_genomic_accession=79156301, orientation='plus', exon_count=8, OMIM=[], no_hdr0=''),
    11848 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=11848, CurrentID=0, Status='live', Symbol='Rhoa', Aliases=['A', 'Ar', 'Arha', 'Arha1', 'Arha2', 'R'], description='ras homolog family member A', other_designations='transforming protein RhoA|aplysia ras-related homolog A|ras homolog gene family, member A', map_location='9 F1-F2', chromosome='9', genomic_nucleotide_accession_version='NC_000075.6', start_position_on_the_genomic_accession=108306160, end_position_on_the_genomic_accession=108337943, orientation='plus', exon_count=7, OMIM=[], no_hdr0=''),
    11852 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=11852, CurrentID=0, Status='live', Symbol='Rhob', Aliases=['AA017882', 'Ar', 'Arh6', 'Arhb'], description='ras homolog family member B', other_designations='rho-related GTP-binding protein RhoB|aplysia ras-related homolog B|ras homolog B|ras homolog gene family, member AB|ras homolog gene family, member B', map_location='12 A1.1', chromosome='12', genomic_nucleotide_accession_version='NC_000078.6', start_position_on_the_genomic_accession=8497661, end_position_on_the_genomic_accession=8500009, orientation='minus', exon_count=1, OMIM=[], no_hdr0=''),
    11853 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=11853, CurrentID=0, Status='live', Symbol='Rhoc', Aliases=['AI324259', 'Ar', 'Arh9', 'Arhc'], description='ras homolog family member C', other_designations='rho-related GTP-binding protein RhoC|SIG-61|aplysia ras-related homolog 9 (RhoC)|ras homolog 9 (RhoC)|ras homolog gene family, member C|silica-induced gene 61 protein', map_location='3 F2.2', chromosome='3', genomic_nucleotide_accession_version='NC_000069.6', start_position_on_the_genomic_accession=104789034, end_position_on_the_genomic_accession=104794459, orientation='plus', exon_count=5, OMIM=[], no_hdr0=''),
    11854 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=11854, CurrentID=0, Status='live', Symbol='Rhod', Aliases=['AI326383', 'Ar', 'Arhd', 'Rho', 'RhoHP1', 'RhoM'], description='ras homolog family member D', other_designations='rho-related GTP-binding protein RhoD|aplysia ras-related homolog D|ras homolog D (RhoD)|ras homolog gene family, member D', map_location='19 A', chromosome='19', genomic_nucleotide_accession_version='NC_000085.6', start_position_on_the_genomic_accession=4423472, end_position_on_the_genomic_accession=4439534, orientation='minus', exon_count=5, OMIM=[], no_hdr0=''),
    11855 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=11855, CurrentID=0, Status='live', Symbol='Arhgap5', Aliases=['p190', 'p190-', 'p190-B', 'p190B'], description='Rho GTPase activating protein 5', other_designations='rho GTPase-activating protein 5|rho-type GTPase-activating protein 5', map_location='12 22.16 cM', chromosome='12', genomic_nucleotide_accession_version='NC_000078.6', start_position_on_the_genomic_accession=52503763, end_position_on_the_genomic_accession=52571978, orientation='plus', exon_count=8, OMIM=[], no_hdr0=''),
    11856 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=11856, CurrentID=0, Status='live', Symbol='Arhgap6', Aliases=['AI504284', 'RhoGA', 'RhoGAPX-1'], description='Rho GTPase activating protein 6', other_designations='rho GTPase-activating protein 6|rho-type GTPase-activating protein 6|rho-type GTPase-activating protein RhoGAPX-1', map_location='X F5', chromosome='X', genomic_nucleotide_accession_version='NC_000086.7', start_position_on_the_genomic_accession=168795094, end_position_on_the_genomic_accession=169304440, orientation='plus', exon_count=18, OMIM=[], no_hdr0=''),
    11857 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=11857, CurrentID=0, Status='live', Symbol='Arhgdib', Aliases=['D4', 'Gdid', 'Gdid4', 'Ly-G', 'Ly-GDI'], description='Rho, GDP dissociation inhibitor (GDI) beta', other_designations='rho GDP-dissociation inhibitor 2|rho GDI 2|rho-GDI beta', map_location='6 G1', chromosome='6', genomic_nucleotide_accession_version='NC_000072.6', start_position_on_the_genomic_accession=136923655, end_position_on_the_genomic_accession=136941899, orientation='minus', exon_count=10, OMIM=[], no_hdr0=''),
    11858 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=11858, CurrentID=0, Status='live', Symbol='Rnd2', Aliases=['A', 'Arhn', 'R', 'Rohn', 'rho7'], description='Rho family GTPase 2', other_designations='rho-related GTP-binding protein RhoN|aplysia ras-related homolog N (RhoN)|ras homolog N (RhoN)|ras homolog gene family, member N|rho-related GTP-binding protein Rho7', map_location='11 D', chromosome='11', genomic_nucleotide_accession_version='NC_000077.6', start_position_on_the_genomic_accession=101468175, end_position_on_the_genomic_accession=101471853, orientation='plus', exon_count=5, OMIM=[], no_hdr0=''),
    11859 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=11859, CurrentID=0, Status='live', Symbol='Phox2a', Aliases=['A', 'Arix', 'Phox2', 'Pmx', 'Pmx2', 'Pmx2a', 'Px', 'Px2a'], description='paired-like homeobox 2a', other_designations='paired mesoderm homeobox protein 2A|PHOX2A homeodomain protein|aristaless homeobox gene homolog|aristaless homeobox protein homolog|paired mesoderm homeobox 2a', map_location='7 54.66 cM', chromosome='7', genomic_nucleotide_accession_version='NC_000073.6', start_position_on_the_genomic_accession=101818313, end_position_on_the_genomic_accession=101822726, orientation='plus', exon_count=3, OMIM=[], no_hdr0=''),
    11861 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=11861, CurrentID=0, Status='live', Symbol='Arl4a', Aliases=['A', 'AI467555', 'Arl4'], description='ADP-ribosylation factor-like 4A', other_designations='ADP-ribosylation factor-like protein 4A|ADP-ribosylation factor-like 4|ADP-ribosylation-like 4', map_location='12 18.06 cM', chromosome='12', genomic_nucleotide_accession_version='NC_000078.6', start_position_on_the_genomic_accession=40033291, end_position_on_the_genomic_accession=40037987, orientation='minus', exon_count=3, OMIM=[], no_hdr0=''),
    11863 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=11863, CurrentID=0, Status='live', Symbol='Arnt', Aliases=['D3Ertd557', 'D3Ertd557e', 'Drnt', 'ESTM4', 'ESTM42', 'Hif1', 'Hif1b', 'W08714', 'bHLHe', 'bHLHe2', 'mKIAA4051'], description='aryl hydrocarbon receptor nuclear translocator', other_designations='aryl hydrocarbon receptor nuclear translocator|HIF-1-beta|HIF1-beta|dioxin receptor, nuclear translocator|hypoxia-inducible factor 1-beta', map_location='3 40.74 cM', chromosome='3', genomic_nucleotide_accession_version='NC_000069.6', start_position_on_the_genomic_accession=95434367, end_position_on_the_genomic_accession=95497240, orientation='plus', exon_count=24, OMIM=[], no_hdr0=''),
    11864 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=11864, CurrentID=0, Status='live', Symbol='Arnt2', Aliases=['Hif-2b', 'bHLHe', 'bHLHe1', 'mKIAA0307'], description='aryl hydrocarbon receptor nuclear translocator 2', other_designations='aryl hydrocarbon receptor nuclear translocator 2|ARNT protein 2', map_location='7 48.35 cM', chromosome='7', genomic_nucleotide_accession_version='NC_000073.6', start_position_on_the_genomic_accession=84246274, end_position_on_the_genomic_accession=84411741, orientation='minus', exon_count=23, OMIM=[], no_hdr0=''),
    11865 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=11865, CurrentID=0, Status='live', Symbol='Arntl', Aliases=['Ar', 'Arnt3', 'BMAL1b', 'Bma', 'Bmal1', 'MO', 'MOP3', 'bHLHe', 'bHLHe5', "bmal1b'"], description='aryl hydrocarbon receptor nuclear translocator-like', other_designations='aryl hydrocarbon receptor nuclear translocator-like protein 1|brain and muscle ARNT-like 1', map_location='7 59.17 cM', chromosome='7', genomic_nucleotide_accession_version='NC_000073.6', start_position_on_the_genomic_accession=113178471, end_position_on_the_genomic_accession=113314126, orientation='plus', exon_count=25, OMIM=[], no_hdr0=''),
    11867 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=11867, CurrentID=0, Status='live', Symbol='Arpc1b', Aliases=['41kDa', 'AA408064', 'AA408534', 'AA571392', 'AF007010', 'AW208418', 'L7', 'L72', 'SO', 'SOP2Hs', 'p41-', 'p41-ARC'], description='actin related protein 2/3 complex, subunit 1B', other_designations='actin-related protein 2/3 complex subunit 1B|arp2/3 complex 41 kDa subunit', map_location='5 G2', chromosome='5', genomic_nucleotide_accession_version='NC_000071.6', start_position_on_the_genomic_accession=145114256, end_position_on_the_genomic_accession=145128186, orientation='plus', exon_count=10, OMIM=[], no_hdr0=''),
    11870 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=11870, CurrentID=0, Status='live', Symbol='Art1', Aliases=['AD', 'ADPRT', 'ARTC1', 'Yac-', 'Yac-1'], description='ADP-ribosyltransferase 1', other_designations='GPI-linked NAD(P)(+)--arginine ADP-ribosyltransferase 1|ADP-ribosyltransferase C2 and C3 toxin-like 1|mono(ADP-ribosyl)transferase 1', map_location='7 54.71 cM', chromosome='7', genomic_nucleotide_accession_version='NC_000073.6', start_position_on_the_genomic_accession=102101706, end_position_on_the_genomic_accession=102122062, orientation='plus', exon_count=8, OMIM=[], no_hdr0=''),
    11871 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=11871, CurrentID=0, Status='live', Symbol='Art2a', Aliases=['ARTC2', 'Art-ps', 'Ly92a', 'Rt', 'Rt-', 'Rt-6', 'Rt6', 'Rt6-', 'Rt6-1', 'Art2a'], description='ADP-ribosyltransferase 2a', other_designations='T-cell ecto-ADP-ribosyltransferase 1|ADP-ribosyltransferase 2a, pseudogene|ADP-ribosyltransferase C2 and C3 toxin-like 2|NAD(+) glycohydrolase|T-cell NAD(P)(+)--arginine ADP-ribosyltransferase 1|T-cell differentiation marker Rt6 homolog 1|T-cell mono(ADP-ribosyl)transferase 1|mono(ADP-ribosyl)transferase 2A', map_location='7 54.6 cM', chromosome='7', genomic_nucleotide_accession_version='NC_000073.6', start_position_on_the_genomic_accession=101552453, end_position_on_the_genomic_accession=101560865, orientation='minus', exon_count=4, OMIM=[], no_hdr0=''),
    11872 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=11872, CurrentID=0, Status='live', Symbol='Art2b', Aliases=['ART2', 'ART2.2', 'ARTC2', 'Art', 'Ly92b', 'Rt', 'Rt-', 'Rt-6', 'Rt6', 'Rt6-', 'Rt6-2'], description='ADP-ribosyltransferase 2b', other_designations='T-cell ecto-ADP-ribosyltransferase 2|ADP-ribosyltransferase C2 and C3 toxin-like 2|NAD(+) glycohydrolase|T-cell NAD(P)(+)--arginine ADP-ribosyltransferase 2|T-cell differentiation marker Rt6 homolog 2|T-cell mono(ADP-ribosyl)transferase 2|mono(ADP-ribosyl)transferase 2B', map_location='7 54.61 cM', chromosome='7', genomic_nucleotide_accession_version='NC_000073.6', start_position_on_the_genomic_accession=101575729, end_position_on_the_genomic_accession=101585591, orientation='minus', exon_count=4, OMIM=[], no_hdr0=''),
    11875 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=11875, CurrentID=0, Status='live', Symbol='Art5', Aliases=['ARTC5', 'Yac-', 'Yac-2'], description='ADP-ribosyltransferase 5', other_designations='ecto-ADP-ribosyltransferase 5|ADP-ribosyltransferase C2 and C3 toxin-like 5|NAD(P)(+)--arginine ADP-ribosyltransferase 5|mono(ADP-ribosyl)transferase 5', map_location='7 54.71 cM', chromosome='7', genomic_nucleotide_accession_version='NC_000073.6', start_position_on_the_genomic_accession=102096879, end_position_on_the_genomic_accession=102100291, orientation='minus', exon_count=5, OMIM=[], no_hdr0=''),
    11876 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=11876, CurrentID=0, Status='live', Symbol='Artn', Aliases=['neub', 'neublastin'], description='artemin', other_designations='artemin', map_location='4 D2.1', chromosome='4', genomic_nucleotide_accession_version='NC_000070.6', start_position_on_the_genomic_accession=117925908, end_position_on_the_genomic_accession=117930795, orientation='minus', exon_count=5, OMIM=[], no_hdr0=''),
    11877 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=11877, CurrentID=0, Status='live', Symbol='Arvcf', Aliases=[], description='armadillo repeat gene deleted in velocardiofacial syndrome', other_designations='armadillo repeat protein deleted in velo-cardio-facial syndrome homolog|armadillo repeat gene deleted in velo-cardio-facial syndrome', map_location='16 11.37 cM', chromosome='16', genomic_nucleotide_accession_version='NC_000082.6', start_position_on_the_genomic_accession=18348182, end_position_on_the_genomic_accession=18407076, orientation='plus', exon_count=21, OMIM=[], no_hdr0=''),
    11878 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=11878, CurrentID=0, Status='live', Symbol='Arx', Aliases=['Ar1', 'Arx'], description='aristaless related homeobox', other_designations='homeobox protein ARX', map_location='X 41.05 cM', chromosome='X', genomic_nucleotide_accession_version='NC_000086.7', start_position_on_the_genomic_accession=93286507, end_position_on_the_genomic_accession=93298357, orientation='plus', exon_count=5, OMIM=[], no_hdr0=''),
    11881 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=11881, CurrentID=0, Status='live', Symbol='Arsb', Aliases=['1110007C02Rik', 'A', 'AI480648', 'As', 'As-', 'As-1', 'As-1r', 'As-1s', 'As-1t', 'As1', 'As1-r', 'As1-s', 'As1-t', 'Asr-1', 'Ast', 'Ast-1'], description='arylsulfatase B', other_designations='arylsulfatase B|ASB|G4S|N-acetylgalactosamine-4-sulfatase|arylsulfatase B complex|arylsulfatase B regulation|arylsulfatase B structural|arylsulfatase B temporal regulation', map_location='13 47.88 cM', chromosome='13', genomic_nucleotide_accession_version='NC_000079.6', start_position_on_the_genomic_accession=93771679, end_position_on_the_genomic_accession=93943016, orientation='plus', exon_count=8, OMIM=[], no_hdr0=''),
    11883 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=11883, CurrentID=0, Status='live', Symbol='Arsa', Aliases=['A', 'AS-A', 'ASA', 'AW212749', 'As', 'As-2', 'As2', 'TISP73'], description='arylsulfatase A', other_designations='arylsulfatase A|cerebroside-sulfatase', map_location='15 E3', chromosome='15', genomic_nucleotide_accession_version='NC_000081.6', start_position_on_the_genomic_accession=89472476, end_position_on_the_genomic_accession=89477424, orientation='minus', exon_count=9, OMIM=[], no_hdr0=''),
    11886 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=11886, CurrentID=0, Status='live', Symbol='Asah1', Aliases=['2310081N20Rik', 'AC', 'Asah'], description='N-acylsphingosine amidohydrolase 1', other_designations='acid ceramidase|ACDase|N-acylethanolamine hydrolase ASAH1|acid CDase|acylsphingosine deacylase', map_location='8 A4', chromosome='8', genomic_nucleotide_accession_version='NC_000074.6', start_position_on_the_genomic_accession=41340646, end_position_on_the_genomic_accession=41397644, orientation='minus', exon_count=19, OMIM=[], no_hdr0=''),
    11889 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=11889, CurrentID=0, Status='live', Symbol='Asgr1', Aliases=['A', 'AS', 'ASGPR1', 'Asg', 'Asgr', 'Asgr-1', 'HL-1'], description='asialoglycoprotein receptor 1', other_designations='asialoglycoprotein receptor 1|hepatic lectin 1', map_location='11 42.98 cM', chromosome='11', genomic_nucleotide_accession_version='NC_000077.6', start_position_on_the_genomic_accession=70048909, end_position_on_the_genomic_accession=70057895, orientation='plus', exon_count=11, OMIM=[], no_hdr0=''),
    11890 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=11890, CurrentID=0, Status='live', Symbol='Asgr2', Aliases=['A', 'AS', 'ASGPR2', 'Asg', 'Asgr', 'Asgr-2', 'HL-2'], description='asialoglycoprotein receptor 2', other_designations='asialoglycoprotein receptor 2|hepatic lectin 2', map_location='11 42.99 cM', chromosome='11', genomic_nucleotide_accession_version='NC_000077.6', start_position_on_the_genomic_accession=70092644, end_position_on_the_genomic_accession=70106187, orientation='plus', exon_count=9, OMIM=[], no_hdr0=''),
    11891 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=11891, CurrentID=0, Status='live', Symbol='Rab27a', Aliases=['2210402C08Rik', '2410003M20Rik', '4933437C11Rik', 'ash'], description='RAB27A, member RAS oncogene family', other_designations='ras-related protein Rab-27A|ashen', map_location='9 40.08 cM', chromosome='9', genomic_nucleotide_accession_version='NC_000075.6', start_position_on_the_genomic_accession=73044810, end_position_on_the_genomic_accession=73097623, orientation='plus', exon_count=9, OMIM=[], no_hdr0=''),
    11898 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=11898, CurrentID=0, Status='live', Symbol='Ass1', Aliases=['AA408052', 'ASS', 'As', 'Ass-1', 'fo', 'fold'], description='argininosuccinate synthetase 1', other_designations='argininosuccinate synthase|arginosuccinate synthetase 1|citrulline--aspartate ligase', map_location='2 21.81 cM', chromosome='2', genomic_nucleotide_accession_version='NC_000068.7', start_position_on_the_genomic_accession=31470270, end_position_on_the_genomic_accession=31520670, orientation='plus', exon_count=16, OMIM=[], no_hdr0=''),
    11899 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=11899, CurrentID=0, Status='live', Symbol='Astn1', Aliases=['Astn', 'GC14', 'mKIAA0289'], description='astrotactin 1', other_designations='astrotactin-1|neuronal migration protein GC14', map_location='1 H1', chromosome='1', genomic_nucleotide_accession_version='NC_000067.6', start_position_on_the_genomic_accession=158362102, end_position_on_the_genomic_accession=158691786, orientation='plus', exon_count=24, OMIM=[], no_hdr0=''),
    11905 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=11905, CurrentID=0, Status='live', Symbol='Serpinc1', Aliases=['A', 'AI114908', 'ATIII', 'At', 'At-', 'At-3', 'At3'], description='serine (or cysteine) peptidase inhibitor, clade C (antithrombin), member 1', other_designations='antithrombin-III|anti-thrombin 3|antithrombin|serine (or cysteine) proteinase inhibitor, clade C (antithrombin), member 1|serpin C1|serpin peptidase inhibitor, clade C, member 1', map_location='1 69.75 cM', chromosome='1', genomic_nucleotide_accession_version='NC_000067.6', start_position_on_the_genomic_accession=160978583, end_position_on_the_genomic_accession=161002543, orientation='plus', exon_count=9, OMIM=[], no_hdr0=''),
    11906 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=11906, CurrentID=0, Status='live', Symbol='Zfhx3', Aliases=['A230102L03Rik', 'Atbf', 'Atbf1', 'S', 'Sci', 'WBP', 'WBP9', 'mKIAA4228'], description='zinc finger homeobox 3', other_designations='zinc finger homeobox protein 3|AT motif-binding factor 1|AT-binding transcription factor 1|ZFH-3|alpha-fetoprotein enhancer-binding protein|zinc finger homeodomain protein 3', map_location='8 D3', chromosome='8', genomic_nucleotide_accession_version='NC_000074.6', start_position_on_the_genomic_accession=108279311, end_position_on_the_genomic_accession=108961636, orientation='plus', exon_count=17, OMIM=[], no_hdr0=''),
    11907 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=11907, CurrentID=0, Status='live', Symbol='Ate1', Aliases=['AI225793', 'AW547406'], description='arginyltransferase 1', other_designations='arginyl-tRNA--protein transferase 1|R-transferase 1|arginine-tRNA--protein transferase 1', map_location='7 F3', chromosome='7', genomic_nucleotide_accession_version='NC_000073.6', start_position_on_the_genomic_accession=130391493, end_position_on_the_genomic_accession=130520619, orientation='minus', exon_count=17, OMIM=[], no_hdr0=''),
    11908 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=11908, CurrentID=0, Status='live', Symbol='Atf1', Aliases=[], description='activating transcription factor 1', other_designations='cyclic AMP-dependent transcription factor ATF-1|TCR-ATF1|cAMP-dependent transcription factor ATF-1', map_location='15 F1', chromosome='15', genomic_nucleotide_accession_version='NC_000081.6', start_position_on_the_genomic_accession=100227859, end_position_on_the_genomic_accession=100261248, orientation='plus', exon_count=9, OMIM=[], no_hdr0=''),
    11909 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=11909, CurrentID=0, Status='live', Symbol='Atf2', Aliases=['ATF-', 'Atf-2', 'CRE-', 'CRE-BP', 'Creb', 'Creb2', 'D130078H02Rik', 'D18875', 'Tg(Gzma-Klra1)7Wum', 'mXB', 'mXBP'], description='activating transcription factor 2', other_designations='cyclic AMP-dependent transcription factor ATF-2|cAMP response element-binding protein CRE-BP1|cAMP-dependent transcription factor ATF-2', map_location='2 C3', chromosome='2', genomic_nucleotide_accession_version='NC_000068.7', start_position_on_the_genomic_accession=73816509, end_position_on_the_genomic_accession=73892677, orientation='minus', exon_count=18, OMIM=[], no_hdr0=''),
    11910 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=11910, CurrentID=0, Status='live', Symbol='Atf3', Aliases=['LRG-', 'LRG-21'], description='activating transcription factor 3', other_designations='cyclic AMP-dependent transcription factor ATF-3|cAMP-dependent transcription factor ATF-3|transcription factor LRG-21', map_location='1 96.28 cM', chromosome='1', genomic_nucleotide_accession_version='NC_000067.6', start_position_on_the_genomic_accession=191170296, end_position_on_the_genomic_accession=191183333, orientation='minus', exon_count=4, OMIM=[], no_hdr0=''),
    11911 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=11911, CurrentID=0, Status='live', Symbol='Atf4', Aliases=['Atf-', 'Atf-4', 'C/AT', 'C/ATF', 'CREB', 'CREB-2', 'CREB2', 'TAXREB', 'TAXREB67'], description='activating transcription factor 4', other_designations='cyclic AMP-dependent transcription factor ATF-4|c/EBP-related ATF|cAMP-dependent transcription factor ATF-4|cAMP-responsive element-binding protein 2|cyclic AMP-responsive element-binding protein 2|tax-responsive enhancer element-binding protein 67 homolog|taxREB67 homolog', map_location='15 37.85 cM', chromosome='15', genomic_nucleotide_accession_version='NC_000081.6', start_position_on_the_genomic_accession=80255184, end_position_on_the_genomic_accession=80257545, orientation='plus', exon_count=4, OMIM=[], no_hdr0=''),
    11920 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=11920, CurrentID=0, Status='live', Symbol='Atm', Aliases=['AI256621', 'C030026E19Rik'], description='ataxia telangiectasia mutated', other_designations='serine-protein kinase ATM|A-T mutated homolog|ataxia telangiectasia gene mutated in human beings|ataxia telangiectasia mutated homolog', map_location='9 29.12 cM', chromosome='9', genomic_nucleotide_accession_version='NC_000075.6', start_position_on_the_genomic_accession=53437122, end_position_on_the_genomic_accession=53536828, orientation='minus', exon_count=63, OMIM=[], no_hdr0=''),
    11921 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=11921, CurrentID=0, Status='live', Symbol='Atoh1', Aliases=['Hath', 'Hath1', 'MATH-1', 'Math', 'Math1', 'bHLHa', 'bHLHa14'], description='atonal bHLH transcription factor 1', other_designations='protein atonal homolog 1|atonal homolog 1|helix-loop-helix protein mATH-1', map_location='6 30.03 cM', chromosome='6', genomic_nucleotide_accession_version='NC_000072.6', start_position_on_the_genomic_accession=64729125, end_position_on_the_genomic_accession=64731245, orientation='plus', exon_count=1, OMIM=[], no_hdr0=''),
    11922 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=11922, CurrentID=0, Status='live', Symbol='Neurod6', Aliases=['Ato', 'Atoh2', 'Math', 'Math-', 'Math-2', 'Math2', 'Ne', 'Nex', 'Nex1', 'Nex1m', 'bHLH', 'bHLHa2'], description='neurogenic differentiation 6', other_designations='neurogenic differentiation factor 6|atonal homolog 2|helix-loop-helix protein mATH-2|protein NEX-1|protein atonal homolog 2', map_location='6 27.53 cM', chromosome='6', genomic_nucleotide_accession_version='NC_000072.6', start_position_on_the_genomic_accession=55677818, end_position_on_the_genomic_accession=55681263, orientation='minus', exon_count=2, OMIM=[], no_hdr0=''),
    11923 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=11923, CurrentID=0, Status='live', Symbol='Neurod4', Aliases=['AI846749', 'ATH-3', 'Ato', 'Atoh3', 'MATH-', 'MATH-3', 'Math', 'Math3', 'bHLH', 'bHLHa4'], description='neurogenic differentiation 4', other_designations='neurogenic differentiation factor 4|atonal homolog 3|helix-loop-helix protein mATH-3', map_location='10 77.81 cM', chromosome='10', genomic_nucleotide_accession_version='NC_000076.6', start_position_on_the_genomic_accession=130268152, end_position_on_the_genomic_accession=130280254, orientation='minus', exon_count=2, OMIM=[], no_hdr0=''),
    11924 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=11924, CurrentID=0, Status='live', Symbol='Neurog2', Aliases=['Ato', 'Atoh4', 'Math', 'Math4A', 'bHLH', 'bHLHa8', 'ng', 'ngn-2', 'ngn2'], description='neurogenin 2', other_designations='neurogenin-2|atonal homolog 4|helix-loop-helix protein mATH-4A|protein atonal homolog 4', map_location='3 G2', chromosome='3', genomic_nucleotide_accession_version='NC_000069.6', start_position_on_the_genomic_accession=127632733, end_position_on_the_genomic_accession=127635636, orientation='plus', exon_count=3, OMIM=[], no_hdr0=''),
    11925 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=11925, CurrentID=0, Status='live', Symbol='Neurog3', Aliases=['Ato', 'Atoh5', 'Math4', 'Math4B', 'bHLH', 'bHLHa7', 'ng', 'ngn3'], description='neurogenin 3', other_designations='neurogenin-3|NGN-3|Neurogenin 3 (Atonal protein homolog 5) (Helix-loop-helix protein mATH-4B) (MATH4B)|atonal homolog 5|helix-loop-helix protein mATH-4B|protein atonal homolog 5', map_location='10 B4', chromosome='10', genomic_nucleotide_accession_version='NC_000076.6', start_position_on_the_genomic_accession=62133090, end_position_on_the_genomic_accession=62134763, orientation='plus', exon_count=2, OMIM=[], no_hdr0=''),
    11927 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=11927, CurrentID=0, Status='live', Symbol='Atox1', Aliases=['AI256639', 'ATX', 'Atx1'], description='antioxidant 1 copper chaperone', other_designations='copper transport protein ATOX1|ATX1 (antioxidant protein 1) homolog 1|metal transport protein ATX1', map_location='11 33.07 cM', chromosome='11', genomic_nucleotide_accession_version='NC_000077.6', start_position_on_the_genomic_accession=55446637, end_position_on_the_genomic_accession=55461208, orientation='minus', exon_count=4, OMIM=[], no_hdr0=''),
    11928 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=11928, CurrentID=0, Status='live', Symbol='Atp1a1', Aliases=['Atp', 'Atpa-1', 'BC010319'], description='ATPase, Na+/K+ transporting, alpha 1 polypeptide', other_designations='sodium/potassium-transporting ATPase subunit alpha-1|Na(+)/K(+) ATPase alpha-1 subunit|sodium pump subunit alpha-1', map_location='3 44.3 cM', chromosome='3', genomic_nucleotide_accession_version='NC_000069.6', start_position_on_the_genomic_accession=101576219, end_position_on_the_genomic_accession=101604707, orientation='minus', exon_count=23, OMIM=[], no_hdr0=''),
    11931 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=11931, CurrentID=0, Status='live', Symbol='Atp1b1', Aliases=['At', 'Atp4b', 'Atpb', 'Atpb-1', 'NKbeta1'], description='ATPase, Na+/K+ transporting, beta 1 polypeptide', other_designations='sodium/potassium-transporting ATPase subunit beta-1|sodium/potassium ATPase beta subunit|sodium/potassium-dependent ATPase subunit beta-1', map_location='1 71.75 cM', chromosome='1', genomic_nucleotide_accession_version='NC_000067.6', start_position_on_the_genomic_accession=164437099, end_position_on_the_genomic_accession=164458355, orientation='minus', exon_count=6, OMIM=[], no_hdr0=''),
    11932 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=11932, CurrentID=0, Status='live', Symbol='Atp1b2', Aliases=['Am', 'Amog', 'Atpb', 'Atpb-2'], description='ATPase, Na+/K+ transporting, beta 2 polypeptide', other_designations='sodium/potassium-transporting ATPase subunit beta-2|adhesion molecule in glia|glial cell adhesion molecule|sodium/potassium-dependent ATPase subunit beta-2', map_location='11 42.86 cM', chromosome='11', genomic_nucleotide_accession_version='NC_000077.6', start_position_on_the_genomic_accession=69599728, end_position_on_the_genomic_accession=69605978, orientation='minus', exon_count=7, OMIM=[], no_hdr0=''),
    11933 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=11933, CurrentID=0, Status='live', Symbol='Atp1b3', Aliases=['AA409958', 'AI664000', 'AW212096'], description='ATPase, Na+/K+ transporting, beta 3 polypeptide', other_designations='sodium/potassium-transporting ATPase subunit beta-3|ATPB-3|ATPase, Na+/K+ beta 3 polypeptide|Na K-ATPase beta-3 subunit|sodium/potassium-dependent ATPase subunit beta-3', map_location='9 50.31 cM', chromosome='9', genomic_nucleotide_accession_version='NC_000075.6', start_position_on_the_genomic_accession=96332655, end_position_on_the_genomic_accession=96364431, orientation='minus', exon_count=9, OMIM=[], no_hdr0=''),
    11936 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=11936, CurrentID=0, Status='live', Symbol='Fxyd2', Aliases=['Atp1', 'Atp1g1'], description='FXYD domain-containing ion transport regulator 2', other_designations='sodium/potassium-transporting ATPase subunit gamma|ATPase, Na+/K+ transporting, gamma 1 polypeptide|Na(+)/K(+) ATPase subunit gamma|sodium pump gamma chain|sodium/potassium-transporting ATPase gamma chain', map_location='9 A5.2', chromosome='9', genomic_nucleotide_accession_version='NC_000075.6', start_position_on_the_genomic_accession=45399709, end_position_on_the_genomic_accession=45410278, orientation='plus', exon_count=9, OMIM=[], no_hdr0=''),
    11937 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=11937, CurrentID=0, Status='live', Symbol='Atp2a1', Aliases=['SER', 'SERCA1'], description='ATPase, Ca++ transporting, cardiac muscle, fast twitch 1', other_designations='sarcoplasmic/endoplasmic reticulum calcium ATPase 1|SR Ca(2+)-ATPase 1|calcium pump 1|endoplasmic reticulum class 1/2 Ca(2+) ATPase', map_location='7 69.04 cM', chromosome='7', genomic_nucleotide_accession_version='NC_000073.6', start_position_on_the_genomic_accession=126445858, end_position_on_the_genomic_accession=126463103, orientation='minus', exon_count=23, OMIM=[], no_hdr0=''),
    11938 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=11938, CurrentID=0, Status='live', Symbol='Atp2a2', Aliases=['9530097L16Rik', 'D5Wsu150', 'D5Wsu150e', 'SER', 'SERC', 'SERCA2', 'SERCA2B', 'Serca2a', 'mKIAA4195'], description='ATPase, Ca++ transporting, cardiac muscle, slow twitch 2', other_designations='sarcoplasmic/endoplasmic reticulum calcium ATPase 2|SR Ca(2+)-ATPase 2|calcium pump 2|endoplasmic reticulum class 1/2 Ca(2+) ATPase|sarco/endoplasmic reticulum Ca2+-ATPase 2', map_location='5 F', chromosome='5', genomic_nucleotide_accession_version='NC_000071.6', start_position_on_the_genomic_accession=122453513, end_position_on_the_genomic_accession=122502225, orientation='minus', exon_count=21, OMIM=[], no_hdr0=''),
    11941 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=11941, CurrentID=0, Status='live', Symbol='Atp2b2', Aliases=['D6Abb2', 'D6Abb2e', 'Gena3', 'Gena300', 'PMC', 'PMCA2', 'Tmy', 'dfw', 'jo', 'jog', 'wm', 'wms', 'wri'], description='ATPase, Ca++ transporting, plasma membrane 2', other_designations='plasma membrane calcium-transporting ATPase 2|deaf waddler|plasma membrane calcium ATPase|plasma membrane calcium pump|wriggle', map_location='6 52.85 cM', chromosome='6', genomic_nucleotide_accession_version='NC_000072.6', start_position_on_the_genomic_accession=113743831, end_position_on_the_genomic_accession=114042613, orientation='minus', exon_count=30, OMIM=[], no_hdr0=''),
    11944 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=11944, CurrentID=0, Status='live', Symbol='Atp4a', Aliases=[], description='ATPase, H+/K+ exchanging, gastric, alpha polypeptide', other_designations='potassium-transporting ATPase alpha chain 1|ATPase, H+/K+ exchanging, alpha polypeptide|ATPase, H+/K+ transporting, alpha polypeptide|H+/K+-ATPase alpha|H+K+-transporting alpha 1|gastric H(+)/K(+) ATPase subunit alpha|proton pump', map_location='7 19.2 cM', chromosome='7', genomic_nucleotide_accession_version='NC_000073.6', start_position_on_the_genomic_accession=30712209, end_position_on_the_genomic_accession=30725534, orientation='plus', exon_count=22, OMIM=[], no_hdr0=''),
    11945 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=11945, CurrentID=0, Status='live', Symbol='Atp4b', Aliases=['AV080843'], description='ATPase, H+/K+ exchanging, beta polypeptide', other_designations='potassium-transporting ATPase subunit beta|ATPase, H+/K+ transporting, beta polypeptide, gastric specific|H+,K+-ATPase|H+/K+-ATPase beta|H,K-ATPase-Beta|gastric H(+)/K(+) ATPase subunit beta|proton pump beta chain', map_location='8 5.89 cM', chromosome='8', genomic_nucleotide_accession_version='NC_000074.6', start_position_on_the_genomic_accession=13386209, end_position_on_the_genomic_accession=13396778, orientation='minus', exon_count=7, OMIM=[], no_hdr0=''),
    11946 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=11946, CurrentID=0, Status='live', Symbol='Atp5a1', Aliases=['AI035633', 'AL022851', 'AL023067', 'At', 'Atp5f1a', 'Atpm', 'D18Ertd206', 'D18Ertd206e', 'Mom', 'Mom2'], description='ATP synthase, H+ transporting, mitochondrial F1 complex, alpha subunit 1', other_designations='ATP synthase subunit alpha, mitochondrial|ATP synthase F1 subunit alpha|modifier of Min 2', map_location='18 52.38 cM', chromosome='18', genomic_nucleotide_accession_version='NC_000084.6', start_position_on_the_genomic_accession=77773768, end_position_on_the_genomic_accession=77782869, orientation='plus', exon_count=12, OMIM=[], no_hdr0=''),
    11947 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=11947, CurrentID=0, Status='live', Symbol='Atp5b', Aliases=['Atp5f1b'], description='ATP synthase, H+ transporting mitochondrial F1 complex, beta subunit', other_designations='ATP synthase subunit beta, mitochondrial|ATP synthase F1 subunit beta|ATP synthase, H+ transporting mitochondrial F1 complex, alpha subunit|mitochondrial ATP synthase, H+ transporting F1 complex beta subunit', map_location='10 D3', chromosome='10', genomic_nucleotide_accession_version='NC_000076.6', start_position_on_the_genomic_accession=128083307, end_position_on_the_genomic_accession=128090388, orientation='plus', exon_count=10, OMIM=[], no_hdr0=''),
    11949 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=11949, CurrentID=0, Status='live', Symbol='Atp5c1', Aliases=['1700094F02Rik', 'Atp5f1c'], description='ATP synthase, H+ transporting, mitochondrial F1 complex, gamma polypeptide 1', other_designations='ATP synthase subunit gamma, mitochondrial|ATP synthase F1 subunit gamma|ATP synthase gamma-subunit gene encoding a mitochondrial protein|F-ATPase gamma subunit|F1 gamma', map_location='2 A1', chromosome='2', genomic_nucleotide_accession_version='NC_000068.7', start_position_on_the_genomic_accession=10056030, end_position_on_the_genomic_accession=10080510, orientation='minus', exon_count=10, OMIM=[], no_hdr0=''),
    11950 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=11950, CurrentID=0, Status='live', Symbol='Atp5pb', Aliases=['Atp5', 'Atp5f1', 'C76477'], description='ATP synthase peripheral stalk-membrane subunit b', other_designations='ATP synthase F(0) complex subunit B1, mitochondrial|ATP synthase subunit b, mitochondrial|ATP synthase, H+ transporting, mitochondrial F0 complex, subunit B1|ATPase subunit b', map_location='3 46.46 cM', chromosome='3', genomic_nucleotide_accession_version='NC_000069.6', start_position_on_the_genomic_accession=105942698, end_position_on_the_genomic_accession=105959263, orientation='minus', exon_count=8, OMIM=[], no_hdr0=''),
    11951 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=11951, CurrentID=0, Status='live', Symbol='Atp5g1', Aliases=['Atp5mc1'], description='ATP synthase, H+ transporting, mitochondrial F0 complex, subunit C1 (subunit 9)', other_designations='ATP synthase F(0) complex subunit C1, mitochondrial|ATP synthase lipid-binding protein, mitochondrial|ATP synthase membrane subunit c locus 1|ATP synthase proteolipid P1|ATPase protein 9|ATPase subunit c', map_location='11 D', chromosome='11', genomic_nucleotide_accession_version='NC_000077.6', start_position_on_the_genomic_accession=96072793, end_position_on_the_genomic_accession=96075694, orientation='minus', exon_count=5, OMIM=[], no_hdr0=''),
    11957 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=11957, CurrentID=0, Status='live', Symbol='Atp5j', Aliases=['Atp5pf', 'CF6'], description='ATP synthase, H+ transporting, mitochondrial F0 complex, subunit F', other_designations='ATP synthase-coupling factor 6, mitochondrial|ATP synthase coupling factor VI|ATP synthase peripheral stalk subunit F6|ATPase subunit F6', map_location='16 C3.3', chromosome='16', genomic_nucleotide_accession_version='NC_000082.6', start_position_on_the_genomic_accession=84827871, end_position_on_the_genomic_accession=84835857, orientation='minus', exon_count=7, OMIM=[], no_hdr0=''),
    11958 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=11958, CurrentID=0, Status='live', Symbol='Atp5k', Aliases=['2610008D24Rik', 'Atp5i', 'Atp5me', 'Lfm', 'Lfm1'], description='ATP synthase, H+ transporting, mitochondrial F1F0 complex, subunit E', other_designations='ATP synthase subunit e, mitochondrial|ATP synthase membrane subunit e|ATPase subunit e', map_location='5 53.11 cM', chromosome='5', genomic_nucleotide_accession_version='NC_000071.6', start_position_on_the_genomic_accession=108433246, end_position_on_the_genomic_accession=108434399, orientation='minus', exon_count=4, OMIM=[], no_hdr0=''),
    11964 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=11964, CurrentID=0, Status='live', Symbol='Atp6v1a', Aliases=['AI647066', 'Atp', 'Atp6a1', 'Atp6a21', 'V', 'VA', 'VA68', 'VPP2', 'Atp6v1a'], description='ATPase, H+ transporting, lysosomal V1 subunit A', other_designations='V-type proton ATPase catalytic subunit A|70-kDa subunit|ATPase, H+ transporting, V1 subunit A|ATPase, H+ transporting, V1 subunit A1|ATPase, H+ transporting, lysosomal (vacuolar proton pump), alpha 70 kDa|ATPase, H+ transporting, lysosomal 70kD, V1 subunit A|V-ATPase 69 kDa subunit|V-ATPase subunit A|lysosomal 70kDa|vacuolar proton pump subunit alpha', map_location='16 B4', chromosome='16', genomic_nucleotide_accession_version='NC_000082.6', start_position_on_the_genomic_accession=44085402, end_position_on_the_genomic_accession=44139702, orientation='minus', exon_count=16, OMIM=[], no_hdr0=''),
    11966 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=11966, CurrentID=0, Status='live', Symbol='Atp6v1b2', Aliases=['AI194269', 'AI790362', 'Atp6', 'Atp6b2', 'HO5', 'HO57', 'R74844'], description='ATPase, H+ transporting, lysosomal V1 subunit B2', other_designations='V-type proton ATPase subunit B, brain isoform|ATPase, H+ transporting, V1 subunit B|ATPase, H+ transporting, lysosomal (vacuolar proton pump), beta 56/58 kDa|ATPase, H+ transporting, lysosomal 56/58kD, V1 subunit B|V-ATPase subunit B 2|endomembrane proton pump 58 kDa subunit|lysosomal 56/58kDa|vacuolar proton pump subunit B 2', map_location='8 B3.3', chromosome='8', genomic_nucleotide_accession_version='NC_000074.6', start_position_on_the_genomic_accession=69088736, end_position_on_the_genomic_accession=69113718, orientation='plus', exon_count=14, OMIM=[], no_hdr0=''),
    11972 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=11972, CurrentID=0, Status='live', Symbol='Atp6v0d1', Aliases=['AI267038', 'Ac3', 'Ac39', 'Atp', 'Atp6d', 'P3', 'P39', 'VATX', 'Vm', 'Vma6'], description='ATPase, H+ transporting, lysosomal V0 subunit D1', other_designations='V-type proton ATPase subunit d 1|ATPase, H+ transporting, V0 subunit D|ATPase, H+ transporting, lysosomal (vacuolar proton pump), 42 kDa|ATPase, H+ transporting, lysosomal 38kDa, V0 subunit D|V-ATPase 40 kDa accessory protein|V-ATPase AC39 subunit|V-ATPase subunit d 1|lysosomal 38kDa|physophilin|vacuolar proton pump subunit d 1', map_location='8 D3', chromosome='8', genomic_nucleotide_accession_version='NC_000074.6', start_position_on_the_genomic_accession=105524461, end_position_on_the_genomic_accession=105566064, orientation='minus', exon_count=8, OMIM=[], no_hdr0=''),
    11973 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=11973, CurrentID=0, Status='live', Symbol='Atp6v1e1', Aliases=['2410029D23Rik', 'Atp', 'Atp6', 'Atp6e', 'Atp6e2', 'Atp6v1e', 'D6Ertd385', 'D6Ertd385e', 'Vma4', 'p31'], description='ATPase, H+ transporting, lysosomal V1 subunit E1', other_designations='V-type proton ATPase subunit E 1|ATPase, H+ transporting, lysosomal 31kDa, V1 subunit E|H(+)-ATPase E-like protein|V-ATPase 31 kDa subunit|V-ATPase subunit E 1|VATPase, H+ transporting, lysosomal V1 subunit E1|vacuolar proton pump subunit E 1', map_location='6 57.01 cM', chromosome='6', genomic_nucleotide_accession_version='NC_000072.6', start_position_on_the_genomic_accession=120795244, end_position_on_the_genomic_accession=120822698, orientation='minus', exon_count=9, OMIM=[], no_hdr0=''),
    11974 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=11974, CurrentID=0, Status='live', Symbol='Atp6v0e', Aliases=['Atp', 'Atp6k1', 'M9.2', 'Atp6v0e'], description='ATPase, H+ transporting, lysosomal V0 subunit E', other_designations='V-type proton ATPase subunit e 1|ATPase, H+ transporting lysosomal (vacuolar proton pump), 9.2 kDa|ATPase, H+ transporting, V0 subunit e|ATPase, H+ transporting, lysosomal 9kD V0 subunit E|V-ATPase subunit e 1|lysosomal 9kDa|vacuolar proton pump subunit e 1', map_location='17 A3.3', chromosome='17', genomic_nucleotide_accession_version='NC_000083.6', start_position_on_the_genomic_accession=26676396, end_position_on_the_genomic_accession=26699647, orientation='plus', exon_count=4, OMIM=[], no_hdr0=''),
    11975 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=11975, CurrentID=0, Status='live', Symbol='Atp6v0a1', Aliases=['AA959968', 'ATP6a1', 'Atp', 'Atp6n1', 'Atp6n1a', 'Atpv0a1', 'V', 'Vp', 'Vpp-1', 'Vpp1'], description='ATPase, H+ transporting, lysosomal V0 subunit A1', other_designations='V-type proton ATPase 116 kDa subunit a1|V-type proton ATPase 116 kDa subunit a|ATPase, H+ transporting, lysosomal (vacuolar proton pump) noncatalytic accessory protein 1 (110/160 kDa)|ATPase, H+ transporting, lysosomal (vacuolar proton pump) noncatalytic accessory protein 1A (110/160 kDa)|ATPase, H+ transporting, lysosomal V0 subunit a|V-ATPase 116 kDa subunit a1|V-ATPase a1|clathrin-coated vesicle/synaptic vesicle proton pump 116 kDa subunit|vacuolar adenosine triphosphatase subunit Ac116|vacuolar proton pump subunit 1|vacuolar proton translocating ATPase 116 kDa subunit a', map_location='11 64.04 cM', chromosome='11', genomic_nucleotide_accession_version='NC_000077.6', start_position_on_the_genomic_accession=101009422, end_position_on_the_genomic_accession=101063719, orientation='plus', exon_count=24, OMIM=[], no_hdr0=''),
    11977 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=11977, CurrentID=0, Status='live', Symbol='Atp7a', Aliases=['MN', 'MNK', 'b'], description='ATPase, Cu++ transporting, alpha polypeptide', other_designations='copper-transporting ATPase 1|Menkes protein|copper pump 1|menkes disease-associated protein homolog', map_location='X 47.36 cM', chromosome='X', genomic_nucleotide_accession_version='NC_000086.7', start_position_on_the_genomic_accession=106027224, end_position_on_the_genomic_accession=106128161, orientation='plus', exon_count=24, OMIM=[], no_hdr0=''),
    11979 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=11979, CurrentID=0, Status='live', Symbol='Atp7b', Aliases=['At', 'Atp7a', 'WN', 'WND', 'tx'], description='ATPase, Cu++ transporting, beta polypeptide', other_designations='copper-transporting ATPase 2|Wilson protein|copper pump 2|toxic milk|wilson disease-associated protein homolog', map_location='8 10.78 cM', chromosome='8', genomic_nucleotide_accession_version='NC_000074.6', start_position_on_the_genomic_accession=21992783, end_position_on_the_genomic_accession=22060074, orientation='minus', exon_count=24, OMIM=[], no_hdr0=''),
    11980 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=11980, CurrentID=0, Status='live', Symbol='Atp8a1', Aliases=['AI481521', 'AI853962', 'APLT', 'AW743152', 'AW822227', 'Atp', 'Atp3a2', 'B230107D19Rik', 'ClassI'], description='ATPase, aminophospholipid transporter (APLT), class I, type 8A, member 1', other_designations='phospholipid-transporting ATPase IA|ATPase 8A1, aminophospholipid transporter (APLT), class I|ATPase 8A1, p type|ATPase class I type 8A member 1|P4-ATPase flippase complex alpha subunit ATP8A1|chromaffin granule ATPase II|probable phospholipid-transporting ATPase IA', map_location='5 C3.1', chromosome='5', genomic_nucleotide_accession_version='NC_000071.6', start_position_on_the_genomic_accession=67618139, end_position_on_the_genomic_accession=67847484, orientation='minus', exon_count=41, OMIM=[], no_hdr0=''),
    11981 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=11981, CurrentID=0, Status='live', Symbol='Atp9a', Aliases=['IIa'], description='ATPase, class II, type 9A', other_designations='probable phospholipid-transporting ATPase IIA|ATPase 9A, class II|ATPase 9A, p type|ATPase, class 2', map_location='2 H3', chromosome='2', genomic_nucleotide_accession_version='NC_000068.7', start_position_on_the_genomic_accession=168634438, end_position_on_the_genomic_accession=168742370, orientation='minus', exon_count=33, OMIM=[], no_hdr0=''),
    11982 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=11982, CurrentID=0, Status='live', Symbol='Atp10a', Aliases=['Atp1', 'Atp10c', 'pf', 'pfatp'], description='ATPase, class V, type 10A', other_designations='probable phospholipid-transporting ATPase VA|ATPase 10A, class V|ATPase, class 5|P-locus fat-associated ATPase|P4-ATPase flippase complex alpha subunit ATP10A', map_location='7 B5', chromosome='7', genomic_nucleotide_accession_version='NC_000073.6', start_position_on_the_genomic_accession=58656142, end_position_on_the_genomic_accession=58830244, orientation='plus', exon_count=24, OMIM=[], no_hdr0=''),
    11983 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=11983, CurrentID=0, Status='live', Symbol='Atpif1', Aliases=['ATP5IF1', 'Atpi', 'IF(1)', 'If', 'If1'], description='ATPase inhibitory factor 1', other_designations='ATPase inhibitor, mitochondrial|ATP synthase F1 subunit epsilon|inhibitor of F(1)F(o)-ATPase', map_location='4 D2.3', chromosome='4', genomic_nucleotide_accession_version='NC_000070.6', start_position_on_the_genomic_accession=132530555, end_position_on_the_genomic_accession=132535450, orientation='minus', exon_count=4, OMIM=[], no_hdr0=''),
    11984 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=11984, CurrentID=0, Status='live', Symbol='Atp6v0c', Aliases=['A', 'At', 'Atp', 'Atp6', 'Atp6c', 'Atp6c2', 'Atp6l', 'Atpl', 'Atpl-rs1', 'PL', 'PL16', 'VATL', 'Vma3', 'pro'], description='ATPase, H+ transporting, lysosomal V0 subunit C', other_designations='V-type proton ATPase 16 kDa proteolipid subunit|ATPase, H+ transporting, lysosomal (vacuolar proton pump) 16 kDa|ATPase, H+ transporting, lysosomal 16kD, V0 subunit C|ATPase, H+ transporting, lysosomal 2|H(+)-ATPase (mvp)|V-ATPase 16 kDa proteolipid subunit|vacuolar proton pump 16 kDa proteolipid subunit', map_location='17 A3.3', chromosome='17', genomic_nucleotide_accession_version='NC_000083.6', start_position_on_the_genomic_accession=24163865, end_position_on_the_genomic_accession=24169678, orientation='minus', exon_count=6, OMIM=[], no_hdr0=''),
    11987 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=11987, CurrentID=0, Status='live', Symbol='Slc7a1', Aliases=['4831426K01Rik', 'AI447493', 'Atr', 'Atrc', 'Atrc-1', 'Atrc1', 'Cat', 'Cat1', 'Rec-', 'Rec-1', 'Rev', 'Rev-1', 'mCAT-', 'mCAT-1'], description='solute carrier family 7 (cationic amino acid transporter, y+ system), member 1', other_designations='high affinity cationic amino acid transporter 1|CAT-1|ERR|cationic amino acid transporter 1|ecotropic retroviral leukemia receptor|ecotropic retrovirus receptor|solute carrier family 7 member 1|system Y+ basic amino acid transporter', map_location='5 88.48 cM', chromosome='5', genomic_nucleotide_accession_version='NC_000071.6', start_position_on_the_genomic_accession=148327410, end_position_on_the_genomic_accession=148399904, orientation='minus', exon_count=15, OMIM=[], no_hdr0=''),
    11988 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=11988, CurrentID=0, Status='live', Symbol='Slc7a2', Aliases=['20.5', 'AI158848', 'Atr', 'Atrc2', 'CAT-2', 'Cat', 'Cat2', 'Te', 'Tea'], description='solute carrier family 7 (cationic amino acid transporter, y+ system), member 2', other_designations='cationic amino acid transporter 2|T-cell early activation protein|amino acid transporter, cationic 2 (low affinity)|cationic amino acid transporter 2A|cationic amino acid transporter 2B|low affinity cationic amino acid transporter 2|solute carrier family 7 member 2', map_location='8 23.89 cM', chromosome='8', genomic_nucleotide_accession_version='NC_000074.6', start_position_on_the_genomic_accession=40862341, end_position_on_the_genomic_accession=40922070, orientation='plus', exon_count=15, OMIM=[], no_hdr0=''),
    11989 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=11989, CurrentID=0, Status='live', Symbol='Slc7a3', Aliases=['Atr', 'Atrc3', 'CAT-3', 'CAT3', 'Cat', 'SLC', 'SLC7A1', 'SLC7A2'], description='solute carrier family 7 (cationic amino acid transporter, y+ system), member 3', other_designations='cationic amino acid transporter 3|amino acid transporter, cationic 3|cationic amino acid transporter y+|solute carrier family 7 member 3', map_location='X D', chromosome='X', genomic_nucleotide_accession_version='NC_000086.7', start_position_on_the_genomic_accession=101079146, end_position_on_the_genomic_accession=101090452, orientation='minus', exon_count=15, OMIM=[], no_hdr0=''),
    11990 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=11990, CurrentID=0, Status='live', Symbol='Atrn', Aliases=['AW558010', 'Mgc', 'Mgca', 'mg'], description='attractin', other_designations='attractin|protein mahogany', map_location='2 63.26 cM', chromosome='2', genomic_nucleotide_accession_version='NC_000068.7', start_position_on_the_genomic_accession=130906430, end_position_on_the_genomic_accession=131030333, orientation='plus', exon_count=30, OMIM=[], no_hdr0=''),
    11991 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=11991, CurrentID=0, Status='live', Symbol='Hnrnpd', Aliases=['Auf', 'Auf1', 'Hn', 'Hnrpd'], description='heterogeneous nuclear ribonucleoprotein D', other_designations='heterogeneous nuclear ribonucleoprotein D0|AU-rich element RNA-binding protein 1|hnRNP D0', map_location='5 E4', chromosome='5', genomic_nucleotide_accession_version='NC_000071.6', start_position_on_the_genomic_accession=99955935, end_position_on_the_genomic_accession=99979130, orientation='minus', exon_count=10, OMIM=[], no_hdr0=''),
    11992 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=11992, CurrentID=0, Status='live', Symbol='Auh', Aliases=['C77140', 'W91705'], description='AU RNA binding protein/enoyl-coenzyme A hydratase', other_designations='methylglutaconyl-CoA hydratase, mitochondrial|AU-binding enoyl-CoA hydratase|AU-specific RNA-binding enoyl-CoA hydratase|itaconyl-CoA hydratase|muAUH', map_location='13 B1', chromosome='13', genomic_nucleotide_accession_version='NC_000079.6', start_position_on_the_genomic_accession=52835107, end_position_on_the_genomic_accession=52929704, orientation='minus', exon_count=14, OMIM=[], no_hdr0=''),
    11993 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=11993, CurrentID=0, Status='live', Symbol='Aup1', Aliases=['AA589454'], description='ancient ubiquitous protein 1', other_designations='ancient ubiquitous protein 1', map_location='6 35.94 cM', chromosome='6', genomic_nucleotide_accession_version='NC_000072.6', start_position_on_the_genomic_accession=83054495, end_position_on_the_genomic_accession=83057682, orientation='plus', exon_count=12, OMIM=[], no_hdr0=''),
    11994 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=11994, CurrentID=0, Status='live', Symbol='Pcdh15', Aliases=['BB078305', 'Gm9815', 'Ush1', 'Ush1f', 'av', 'nmf1', 'nmf19', 'r', 'roda'], description='protocadherin 15', other_designations='protocadherin-15|Ames waltzer|protocadherin 15 CD2', map_location='10 37.43 cM', chromosome='10', genomic_nucleotide_accession_version='NC_000076.6', start_position_on_the_genomic_accession=73096277, end_position_on_the_genomic_accession=74649831, orientation='plus', exon_count=52, OMIM=[], no_hdr0=''),
    11997 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=11997, CurrentID=0, Status='live', Symbol='Akr1b7', Aliases=['A', 'AR', 'Avdp', 'MV', 'MVDP'], description='aldo-keto reductase family 1, member B7', other_designations='aldo-keto reductase family 1 member B7|aldehyde reductase|aldose reductase-related protein 1|androgen regulated vas deferens protein|vas deferens androgen-dependent protein', map_location='6 14.95 cM', chromosome='6', genomic_nucleotide_accession_version='NC_000072.6', start_position_on_the_genomic_accession=34412362, end_position_on_the_genomic_accession=34423137, orientation='plus', exon_count=10, OMIM=[], no_hdr0=''),
    11998 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=11998, CurrentID=0, Status='live', Symbol='Avp', Aliases=['Vp', 'Vsp'], description='arginine vasopressin', other_designations='vasopressin-neurophysin 2-copeptin|AVP-NPII|pre-pro-arginine-vasopressin-neurophysin II|prepro-AVP-NP II', map_location='2 63.24 cM', chromosome='2', genomic_nucleotide_accession_version='NC_000068.7', start_position_on_the_genomic_accession=130580620, end_position_on_the_genomic_accession=130582588, orientation='minus', exon_count=3, OMIM=[], no_hdr0=''),
    12000 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=12000, CurrentID=0, Status='live', Symbol='Avpr2', Aliases=['ADHR', 'DI', 'DI1', 'DIR', 'ND', 'ND1', 'V', 'V2R', 'VPV2R'], description='arginine vasopressin receptor 2', other_designations='vasopressin V2 receptor|antidiuretic hormone receptor|nephrogenic diabetes insipidus|renal-type arginine vasopressin receptor', map_location='X 37.46 cM', chromosome='X', genomic_nucleotide_accession_version='NC_000086.7', start_position_on_the_genomic_accession=73891765, end_position_on_the_genomic_accession=73894428, orientation='plus', exon_count=4, OMIM=[], no_hdr0=''),
    12005 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=12005, CurrentID=0, Status='live', Symbol='Axin1', Aliases=['AI316800', 'Axin', 'Fu', 'Kb', 'Ki', 'fused', 'kinky', 'knobbly'], description='axin 1', other_designations='axin-1|axis inhibition protein 1|protein Fused', map_location='17 13.07 cM', chromosome='17', genomic_nucleotide_accession_version='NC_000083.6', start_position_on_the_genomic_accession=26131217, end_position_on_the_genomic_accession=26195811, orientation='plus', exon_count=13, OMIM=[], no_hdr0=''),
    12006 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=12006, CurrentID=0, Status='live', Symbol='Axin2', Aliases=['A', 'Axi1', 'Axil', 'Condu', 'Conductin'], description='axin 2', other_designations='axin-2|axin-like protein|axis inhibition protein 2', map_location='11 71.83 cM', chromosome='11', genomic_nucleotide_accession_version='NC_000077.6', start_position_on_the_genomic_accession=108917828, end_position_on_the_genomic_accession=108950783, orientation='plus', exon_count=15, OMIM=[], no_hdr0=''),
    12007 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=12007, CurrentID=0, Status='live', Symbol='Azgp1', Aliases=['Za', 'Zag'], description='alpha-2-glycoprotein 1, zinc', other_designations='zinc-alpha-2-glycoprotein|major histocompatibility complex class I-like protein|zn-alpha-2-GP', map_location='5 76.92 cM', chromosome='5', genomic_nucleotide_accession_version='NC_000071.6', start_position_on_the_genomic_accession=137981521, end_position_on_the_genomic_accession=137990233, orientation='plus', exon_count=4, OMIM=[], no_hdr0=''),
    12009 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=12009, CurrentID=0, Status='live', Symbol='Cep131', Aliases=['AZ', 'AZ1', 'Azi', 'Azi1'], description='centrosomal protein 131', other_designations='centrosomal protein of 131 kDa|5-azacytidine induced gene 1|5-azacytidine-induced protein 1|pre-acrosome localization protein 1', map_location='11 E2', chromosome='11', genomic_nucleotide_accession_version='NC_000077.6', start_position_on_the_genomic_accession=120064429, end_position_on_the_genomic_accession=120086865, orientation='minus', exon_count=26, OMIM=[], no_hdr0=''),
    12010 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=12010, CurrentID=0, Status='live', Symbol='B2m', Aliases=['Ly-m1', 'Ly-m11', 'beta2-', 'beta2-m', 'beta2m'], description='beta-2 microglobulin', other_designations='beta-2-microglobulin', map_location='2 60.55 cM', chromosome='2', genomic_nucleotide_accession_version='NC_000068.7', start_position_on_the_genomic_accession=122147687, end_position_on_the_genomic_accession=122153082, orientation='plus', exon_count=4, OMIM=[], no_hdr0=''),
    12012 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=12012, CurrentID=0, Status='live', Symbol='Baat', Aliases=['AI118337', 'AI158864', 'BA', 'BAT'], description='bile acid-Coenzyme A: amino acid N-acyltransferase', other_designations='bile acid-CoA:amino acid N-acyltransferase|BACAT|bile acid-CoA thioesterase|bile acid-Coenzyme A dehydrogenase: amino acid n-acyltransferase|choloyl-CoA hydrolase|glycine N-choloyltransferase|long-chain fatty-acyl-CoA hydrolase|taurine N-acyltransferase', map_location='4 26.51 cM', chromosome='4', genomic_nucleotide_accession_version='NC_000070.6', start_position_on_the_genomic_accession=49489416, end_position_on_the_genomic_accession=49507915, orientation='minus', exon_count=4, OMIM=[], no_hdr0=''),
    12013 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=12013, CurrentID=0, Status='live', Symbol='Bach1', Aliases=['6230421P05Rik', 'AI323795'], description='BTB and CNC homology 1, basic leucine zipper transcription factor 1', other_designations='transcription regulator protein BACH1|BTB and CNC homolog 1|BTB and CNC homology 1 transcription factor', map_location='16 C3.3', chromosome='16', genomic_nucleotide_accession_version='NC_000082.6', start_position_on_the_genomic_accession=87698954, end_position_on_the_genomic_accession=87733346, orientation='plus', exon_count=6, OMIM=[], no_hdr0=''),
    12014 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=12014, CurrentID=0, Status='live', Symbol='Bach2', Aliases=['E030004N02Rik'], description='BTB and CNC homology, basic leucine zipper transcription factor 2', other_designations='transcription regulator protein BACH2|BTB and CNC homolog 2|BTB and CNC homology 2|Transcription regulator protein BACH2 (BTB and CNC homolog 2)', map_location='4 A5', chromosome='4', genomic_nucleotide_accession_version='NC_000070.6', start_position_on_the_genomic_accession=32238413, end_position_on_the_genomic_accession=32586109, orientation='plus', exon_count=13, OMIM=[], no_hdr0=''),
    12015 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=12015, CurrentID=0, Status='live', Symbol='Bad', Aliases=['AI325008', 'Bbc2'], description='BCL2-associated agonist of cell death', other_designations='bcl2-associated agonist of cell death|bcl-2-binding component 6|bcl-xL/Bcl-2-associated death promoter|bcl2 antagonist of cell death', map_location='19 A', chromosome='19', genomic_nucleotide_accession_version='NC_000085.6', start_position_on_the_genomic_accession=6941861, end_position_on_the_genomic_accession=6951905, orientation='plus', exon_count=5, OMIM=[], no_hdr0=''),
    12017 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=12017, CurrentID=0, Status='live', Symbol='Bag1', Aliases=['BAG-1', 'Ra', 'Rap46'], description='BCL2-associated athanogene 1', other_designations='BAG family molecular chaperone regulator 1|Bcl-2-binding protein|bcl-2-associated athanogene 1', map_location='4 A5', chromosome='4', genomic_nucleotide_accession_version='NC_000070.6', start_position_on_the_genomic_accession=40936398, end_position_on_the_genomic_accession=40948294, orientation='minus', exon_count=7, OMIM=[], no_hdr0=''),
    12018 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=12018, CurrentID=0, Status='live', Symbol='Bak1', Aliases=['Ba', 'Bak', 'N-B', 'N-BAK1', 'N-Bak'], description='BCL2-antagonist/killer 1', other_designations='bcl-2 homologous antagonist/killer|Bcl2 homologous antagonist/killer|apoptosis regulator BAK', map_location='17 A3.3', chromosome='17', genomic_nucleotide_accession_version='NC_000083.6', start_position_on_the_genomic_accession=27019812, end_position_on_the_genomic_accession=27028627, orientation='minus', exon_count=7, OMIM=[], no_hdr0=''),
    12020 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=12020, CurrentID=0, Status='live', Symbol='Nkx3-2', Aliases=['Bap', 'Bapx1', 'NKX3.2', 'Nkx-3.', 'Nkx-3.2'], description='NK3 homeobox 2', other_designations='homeobox protein Nkx-3.2|bagpipe homeobox gene 1 homolog|bagpipe homeobox protein homolog 1|homeobox protein NK-3 homolog B|homeodomain protein Nkx-3.2', map_location='5 22.58 cM', chromosome='5', genomic_nucleotide_accession_version='NC_000071.6', start_position_on_the_genomic_accession=41761483, end_position_on_the_genomic_accession=41764220, orientation='minus', exon_count=2, OMIM=[], no_hdr0=''),
    12021 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=12021, CurrentID=0, Status='live', Symbol='Bard1', Aliases=[], description='BRCA1 associated RING domain 1', other_designations='BRCA1-associated RING domain protein 1|BARD-1|RING-type E3 ubiquitin transferase BARD1', map_location='1 C3', chromosome='1', genomic_nucleotide_accession_version='NC_000067.6', start_position_on_the_genomic_accession=71027535, end_position_on_the_genomic_accession=71103141, orientation='minus', exon_count=11, OMIM=[], no_hdr0=''),
    12022 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=12022, CurrentID=0, Status='live', Symbol='Barx1', Aliases=[], description='BarH-like homeobox 1', other_designations='homeobox protein BarH-like 1', map_location='13 24.9 cM', chromosome='13', genomic_nucleotide_accession_version='NC_000079.6', start_position_on_the_genomic_accession=48663036, end_position_on_the_genomic_accession=48666507, orientation='plus', exon_count=4, OMIM=[], no_hdr0=''),
    12023 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=12023, CurrentID=0, Status='live', Symbol='Barx2', Aliases=['2310006E12Rik', 'Barxb', 'Barx2'], description='BarH-like homeobox 2', other_designations='homeobox protein BarH-like 2|homeodomain transcription factor BARX2', map_location='9 A4', chromosome='9', genomic_nucleotide_accession_version='NC_000075.6', start_position_on_the_genomic_accession=31846044, end_position_on_the_genomic_accession=31913285, orientation='minus', exon_count=4, OMIM=[], no_hdr0=''),
    12028 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=12028, CurrentID=0, Status='live', Symbol='Bax', Aliases=[], description='BCL2-associated X protein', other_designations='apoptosis regulator BAX', map_location='7 29.32 cM', chromosome='7', genomic_nucleotide_accession_version='NC_000073.6', start_position_on_the_genomic_accession=45461695, end_position_on_the_genomic_accession=45466903, orientation='minus', exon_count=7, OMIM=[], no_hdr0=''),
    12029 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=12029, CurrentID=0, Status='live', Symbol='Bcl6b', Aliases=['Baz', 'Bazf'], description='B cell CLL/lymphoma 6, member B', other_designations='B-cell CLL/lymphoma 6 member B protein|BcL6-associated zinc finger protein', map_location='11 B3', chromosome='11', genomic_nucleotide_accession_version='NC_000077.6', start_position_on_the_genomic_accession=70224127, end_position_on_the_genomic_accession=70229798, orientation='minus', exon_count=9, OMIM=[], no_hdr0=''),
    12032 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=12032, CurrentID=0, Status='live', Symbol='Bcan', Aliases=['Csp', 'Cspg7'], description='brevican', other_designations='brevican core protein', map_location='3 38.78 cM', chromosome='3', genomic_nucleotide_accession_version='NC_000069.6', start_position_on_the_genomic_accession=87987531, end_position_on_the_genomic_accession=88002175, orientation='minus', exon_count=15, OMIM=[], no_hdr0=''),
    12033 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=12033, CurrentID=0, Status='live', Symbol='Bcap29', Aliases=['AW208404', 'Bap', 'Bap29'], description='B cell receptor associated protein 29', other_designations='B-cell receptor-associated protein 29|BCR-associated protein 29', map_location='12 13.63 cM', chromosome='12', genomic_nucleotide_accession_version='NC_000078.6', start_position_on_the_genomic_accession=31595354, end_position_on_the_genomic_accession=31634658, orientation='minus', exon_count=8, OMIM=[], no_hdr0=''),
    12034 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=12034, CurrentID=0, Status='live', Symbol='Phb2', Aliases=['AU044498', 'BAP', 'Bap37', 'Bcap', 'Bcap37', 'R', 'REA'], description='prohibitin 2', other_designations='prohibitin-2|B-cell receptor-associated protein 37|B-cell receptor-associated protein BAP37|repressor of estrogen receptor activity', map_location='6 59.17 cM', chromosome='6', genomic_nucleotide_accession_version='NC_000072.6', start_position_on_the_genomic_accession=124712289, end_position_on_the_genomic_accession=124716945, orientation='plus', exon_count=10, OMIM=[], no_hdr0=''),
    12035 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=12035, CurrentID=0, Status='live', Symbol='Bcat1', Aliases=['BCAT', 'BCATc', 'Bcat-', 'Eca3', 'Eca39'], description='branched chain aminotransferase 1, cytosolic', other_designations='branched-chain-amino-acid aminotransferase, cytosolic|BCAT(c)', map_location='6 77.27 cM', chromosome='6', genomic_nucleotide_accession_version='NC_000072.6', start_position_on_the_genomic_accession=144993835, end_position_on_the_genomic_accession=145076157, orientation='minus', exon_count=13, OMIM=[], no_hdr0=''),
    12036 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=12036, CurrentID=0, Status='live', Symbol='Bcat2', Aliases=['Bcat(m)', 'Bcat-', 'Bcat-2', 'Eca4', 'Eca40'], description='branched chain aminotransferase 2, mitochondrial', other_designations='branched-chain-amino-acid aminotransferase, mitochondrial', map_location='7 29.36 cM', chromosome='7', genomic_nucleotide_accession_version='NC_000073.6', start_position_on_the_genomic_accession=45568967, end_position_on_the_genomic_accession=45589710, orientation='plus', exon_count=12, OMIM=[], no_hdr0=''),
    12038 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=12038, CurrentID=0, Status='live', Symbol='Bche', Aliases=['C730038G20Rik'], description='butyrylcholinesterase', other_designations='cholinesterase|acylcholine acylhydrolase|butyrylcholine esterase|choline esterase II|pseudocholinesterase', map_location='3 E3', chromosome='3', genomic_nucleotide_accession_version='NC_000069.6', start_position_on_the_genomic_accession=73635805, end_position_on_the_genomic_accession=73708436, orientation='minus', exon_count=5, OMIM=[], no_hdr0=''),
    12039 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=12039, CurrentID=0, Status='live', Symbol='Bckdha', Aliases=[], description='branched chain ketoacid dehydrogenase E1, alpha polypeptide', other_designations='2-oxoisovalerate dehydrogenase subunit alpha, mitochondrial|BCKAD E1[a]|BCKDE1A|BCKDH E1-alpha|branched-chain alpha-keto acid dehydrogenase E1 component alpha chain', map_location='7 A3', chromosome='7', genomic_nucleotide_accession_version='NC_000073.6', start_position_on_the_genomic_accession=25629852, end_position_on_the_genomic_accession=25658782, orientation='minus', exon_count=12, OMIM=[], no_hdr0=''),
    12040 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=12040, CurrentID=0, Status='live', Symbol='Bckdhb', Aliases=['BCKDE1B', 'BCKDH E1-beta'], description='branched chain ketoacid dehydrogenase E1, beta polypeptide', other_designations='2-oxoisovalerate dehydrogenase subunit beta, mitochondrial|branched-chain alpha-keto acid dehydrogenase E1 component beta chain', map_location='9 E2', chromosome='9', genomic_nucleotide_accession_version='NC_000075.6', start_position_on_the_genomic_accession=83925111, end_position_on_the_genomic_accession=84124240, orientation='plus', exon_count=13, OMIM=[], no_hdr0=''),
    12041 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=12041, CurrentID=0, Status='live', Symbol='Bckdk', Aliases=['AI327402', 'BCKD-ki'], description='branched chain ketoacid dehydrogenase kinase', other_designations='[3-methyl-2-oxobutanoate dehydrogenase [lipoamide]] kinase, mitochondrial|BCKD-kinase|BCKDHKIN|branched-chain alpha-ketoacid dehydrogenase kinase', map_location='7 F3', chromosome='7', genomic_nucleotide_accession_version='NC_000073.6', start_position_on_the_genomic_accession=127904073, end_position_on_the_genomic_accession=127909664, orientation='plus', exon_count=12, OMIM=[], no_hdr0=''),
    12042 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=12042, CurrentID=0, Status='live', Symbol='Bcl10', Aliases=['AI132454', 'BCL-1', 'BCL-10', 'C81403', 'CARMEN', 'CIPER', 'CLAP', 'ME10', 'cE10'], description='B cell leukemia/lymphoma 10', other_designations='B-cell lymphoma/leukemia 10|B-cell CLL/lymphoma 10|CARD-containing molecule enhancing NF-kappa-B|CARD-like apoptotic protein|CED-3/ICH-1 prodomain homologous E10-like regulator|cellular homolog of vCARMEN|cellular-E10|mammalian CARD-containing adapter molecule E10', map_location='3 H2', chromosome='3', genomic_nucleotide_accession_version='NC_000069.6', start_position_on_the_genomic_accession=145924262, end_position_on_the_genomic_accession=145934366, orientation='plus', exon_count=3, OMIM=[], no_hdr0=''),
    12043 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=12043, CurrentID=0, Status='live', Symbol='Bcl2', Aliases=['AW986256', 'Bcl-', 'Bcl-2', 'C430015F12Rik', 'D630044D05Rik', 'D830018M01Rik'], description='B cell leukemia/lymphoma 2', other_designations='apoptosis regulator Bcl-2', map_location='1 49.76 cM', chromosome='1', genomic_nucleotide_accession_version='NC_000067.6', start_position_on_the_genomic_accession=106538176, end_position_on_the_genomic_accession=106714290, orientation='minus', exon_count=2, OMIM=[], no_hdr0=''),
    12044 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=12044, CurrentID=0, Status='live', Symbol='Bcl2a1a', Aliases=['A', 'A1', 'BB218357', 'Bcl2', 'Bcl2a1', 'Bfl-', 'Bfl-1', 'Hbp', 'Hbpa1'], description='B cell leukemia/lymphoma 2 related protein A1a', other_designations='bcl-2-related protein A1|A1-A|hemopoietic-specific early response protein|protein BFL-1', map_location='9 47.24 cM', chromosome='9', genomic_nucleotide_accession_version='NC_000075.6', start_position_on_the_genomic_accession=88956920, end_position_on_the_genomic_accession=88962416, orientation='plus', exon_count=2, OMIM=[], no_hdr0=''),
    12045 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=12045, CurrentID=0, Status='live', Symbol='Bcl2a1b', Aliases=['A1-', 'A1-b'], description='B cell leukemia/lymphoma 2 related protein A1b', other_designations='B-cell leukemia/lymphoma 2 related protein A1b|anti-apoptotic protein A1-b', map_location='9 E3.1', chromosome='9', genomic_nucleotide_accession_version='NC_000075.6', start_position_on_the_genomic_accession=89199273, end_position_on_the_genomic_accession=89207838, orientation='plus', exon_count=2, OMIM=[], no_hdr0=''),
    12046 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=12046, CurrentID=0, Status='live', Symbol='Bcl2a1c', Aliases=['A1-', 'A1-c'], description='B cell leukemia/lymphoma 2 related protein A1c', other_designations='B cell leukemia/lymphoma 2 related protein A1c|hematopoietic-specific early-response A1-c protein', map_location='9 F3', chromosome='9', genomic_nucleotide_accession_version='NC_000075.6', start_position_on_the_genomic_accession=114330135, end_position_on_the_genomic_accession=114330578, orientation='plus', exon_count=1, OMIM=[], no_hdr0=''),
    12047 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=12047, CurrentID=0, Status='live', Symbol='Bcl2a1d', Aliases=['A1-', 'A1-d'], description='B cell leukemia/lymphoma 2 related protein A1d', other_designations='B cell leukemia/lymphoma 2 related protein A1d', map_location='9 E3.1', chromosome='9', genomic_nucleotide_accession_version='NC_000075.6', start_position_on_the_genomic_accession=88723288, end_position_on_the_genomic_accession=88731850, orientation='minus', exon_count=2, OMIM=[], no_hdr0=''),
    12048 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=12048, CurrentID=0, Status='live', Symbol='Bcl2l1', Aliases=['Bcl', 'Bcl(X', 'Bcl(X)L', 'Bcl-XL', 'Bcl2l', 'BclX', 'bcl-', 'bcl-x', 'bcl2-L-1'], description='BCL2-like 1', other_designations='bcl-2-like protein 1|B-cell leukemia/lymphoma x|anti-apoptosis regulatory protein|apoptosis regulator Bcl-X', map_location='2 H1', chromosome='2', genomic_nucleotide_accession_version='NC_000068.7', start_position_on_the_genomic_accession=152758732, end_position_on_the_genomic_accession=152833803, orientation='minus', exon_count=7, OMIM=[], no_hdr0=''),
    12049 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=12049, CurrentID=0, Status='live', Symbol='Bcl2l10', Aliases=['AA420380', 'AU023065', 'B', 'Boo', 'C85687', 'D', 'Diva'], description='Bcl2-like 10', other_designations='bcl-2-like protein 10|anti-apoptotic protein Boo|apoptosis regulator Bcl-B|bcl-2 homolog Diva|bcl2-L-10', map_location='9 D', chromosome='9', genomic_nucleotide_accession_version='NC_000075.6', start_position_on_the_genomic_accession=75347758, end_position_on_the_genomic_accession=75351640, orientation='plus', exon_count=2, OMIM=[], no_hdr0=''),
    12050 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=12050, CurrentID=0, Status='live', Symbol='Bcl2l2', Aliases=['AW048834', 'Bcl-', 'Bcl-w', 'Gtrg', 'Gtrgal2', 'Gtro', 'Gtrosa41', 'bcl', 'bclw', 'c98'], description='BCL2-like 2', other_designations='bcl-2-like protein 2|apoptosis regulator Bcl-W|bcl2-L-2', map_location='14 27.98 cM', chromosome='14', genomic_nucleotide_accession_version='NC_000080.6', start_position_on_the_genomic_accession=54883366, end_position_on_the_genomic_accession=54890858, orientation='plus', exon_count=4, OMIM=[], no_hdr0=''),
    12051 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=12051, CurrentID=0, Status='live', Symbol='Bcl3', Aliases=['AI528691', 'Bcl-', 'Bcl-3'], description='B cell leukemia/lymphoma 3', other_designations='B-cell lymphoma 3 protein homolog|B-cell CLL/lymphoma 3', map_location='7 9.95 cM', chromosome='7', genomic_nucleotide_accession_version='NC_000073.6', start_position_on_the_genomic_accession=19808462, end_position_on_the_genomic_accession=19822824, orientation='minus', exon_count=9, OMIM=[], no_hdr0=''),
    12053 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=12053, CurrentID=0, Status='live', Symbol='Bcl6', Aliases=['Bcl', 'Bcl5'], description='B cell leukemia/lymphoma 6', other_designations='B-cell lymphoma 6 protein homolog|B-cell leukemia/lymphoma 5', map_location='16 15.26 cM', chromosome='16', genomic_nucleotide_accession_version='NC_000082.6', start_position_on_the_genomic_accession=23965050, end_position_on_the_genomic_accession=23988866, orientation='minus', exon_count=12, OMIM=[], no_hdr0=''),
    12054 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=12054, CurrentID=0, Status='live', Symbol='Bcl7b', Aliases=[], description='B cell CLL/lymphoma 7B', other_designations='B-cell CLL/lymphoma 7 protein family member B', map_location='5 G2', chromosome='5', genomic_nucleotide_accession_version='NC_000071.6', start_position_on_the_genomic_accession=135168372, end_position_on_the_genomic_accession=135181852, orientation='plus', exon_count=6, OMIM=[], no_hdr0=''),
    12055 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=12055, CurrentID=0, Status='live', Symbol='Bcl7c', Aliases=['C230096E12Rik'], description='B cell CLL/lymphoma 7C', other_designations='B-cell CLL/lymphoma 7 protein family member C|B-cell chronic lymphocytic leukemia/lymphoma 7C protein', map_location='7 F3', chromosome='7', genomic_nucleotide_accession_version='NC_000073.6', start_position_on_the_genomic_accession=127661454, end_position_on_the_genomic_accession=127708766, orientation='minus', exon_count=7, OMIM=[], no_hdr0=''),
    12057 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=12057, CurrentID=0, Status='live', Symbol='Opn1sw', Aliases=['AW551857', 'Bc', 'Bcp'], description='opsin 1 (cone pigments), short-wave-sensitive (color blindness, tritan)', other_designations='short-wave-sensitive opsin 1|BOP|S opsin|SWS opsin|UV cone pigment|blue cone opsin|blue cone photoreceptor pigment|blue cone pigment|blue opsin|blue visual pigment protein|blue-sensitive opsin|blue/UV opsin|short wavelength sensitive opsin|short wavelength-sensitive cone opsin', map_location='6 A3.3', chromosome='6', genomic_nucleotide_accession_version='NC_000072.6', start_position_on_the_genomic_accession=29376671, end_position_on_the_genomic_accession=29380513, orientation='minus', exon_count=5, OMIM=[], no_hdr0=''),
    12061 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=12061, CurrentID=0, Status='live', Symbol='Bdkrb1', Aliases=['B1', 'B1BKR', 'B1R', 'BKR1', 'BRADYB1', 'Bdkrb'], description='bradykinin receptor, beta 1', other_designations='B1 bradykinin receptor|BK-1 receptor|kinin B1', map_location='12 E', chromosome='12', genomic_nucleotide_accession_version='NC_000078.6', start_position_on_the_genomic_accession=105604091, end_position_on_the_genomic_accession=105605511, orientation='plus', exon_count=1, OMIM=[], no_hdr0=''),
    12062 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=12062, CurrentID=0, Status='live', Symbol='Bdkrb2', Aliases=['B(2)', 'B2', 'B2R', 'BK-2', 'BK2', 'BK2R', 'BKR2', 'BRB2'], description='bradykinin receptor, beta 2', other_designations='B2 bradykinin receptor|BK-2 receptor|kinin B2', map_location='12 55.76 cM', chromosome='12', genomic_nucleotide_accession_version='NC_000078.6', start_position_on_the_genomic_accession=105563172, end_position_on_the_genomic_accession=105595244, orientation='plus', exon_count=5, OMIM=[], no_hdr0=''),
    12064 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=12064, CurrentID=0, Status='live', Symbol='Bdnf', Aliases=[], description='brain derived neurotrophic factor', other_designations='brain-derived neurotrophic factor', map_location='2 56.63 cM', chromosome='2', genomic_nucleotide_accession_version='NC_000068.7', start_position_on_the_genomic_accession=109674700, end_position_on_the_genomic_accession=109727043, orientation='plus', exon_count=9, OMIM=[], no_hdr0=''),
    12068 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=12068, CurrentID=0, Status='live', Symbol='Bet1', Aliases=['AW555236', 'Bet-1'], description='Bet1 golgi vesicular membrane trafficking protein', other_designations='BET1 homolog|blocked early in transport 1 homolog|golgi vesicular membrane-trafficking protein p18', map_location='6 A1', chromosome='6', genomic_nucleotide_accession_version='NC_000072.6', start_position_on_the_genomic_accession=4076899, end_position_on_the_genomic_accession=4086998, orientation='minus', exon_count=5, OMIM=[], no_hdr0=''),
    12069 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=12069, CurrentID=0, Status='live', Symbol='Bex2', Aliases=['AL024066', 'Bex1'], description='brain expressed X-linked 2', other_designations='protein BEX2|brain-expressed X-linked protein 2 homolog', map_location='X 57.37 cM', chromosome='X', genomic_nucleotide_accession_version='NC_000086.7', start_position_on_the_genomic_accession=136066565, end_position_on_the_genomic_accession=136068236, orientation='minus', exon_count=3, OMIM=[], no_hdr0=''),
    12070 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=12070, CurrentID=0, Status='live', Symbol='Bex3', Aliases=['AL033356', 'DXWsu67', 'DXWsu67e', 'Gcap', 'Gcap27', 'Na', 'Nade', 'Ngf', 'Ngfrap1'], description='brain expressed X-linked 3', other_designations='protein BEX3|brain-expressed X-linked protein 3 homolog|granule cell antiserum positive 27|nerve growth factor receptor (TNFRSF16) associated protein 1|nerve growth factor receptor-associated protein 1|p75NTR-associated Cell Death Executor', map_location='X 57.64 cM', chromosome='X', genomic_nucleotide_accession_version='NC_000086.7', start_position_on_the_genomic_accession=136270253, end_position_on_the_genomic_accession=136271978, orientation='plus', exon_count=3, OMIM=[], no_hdr0=''),
    12075 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=12075, CurrentID=0, Status='live', Symbol='Bfsp1', Aliases=['CP95', 'fi'], description='beaded filament structural protein 1, in lens-CP94', other_designations='filensin|beaded filament structural protein in lens-CP94|lens fiber cell beaded-filament structural protein CP 95', map_location='2 G1', chromosome='2', genomic_nucleotide_accession_version='NC_000068.7', start_position_on_the_genomic_accession=143826528, end_position_on_the_genomic_accession=143915219, orientation='minus', exon_count=11, OMIM=[], no_hdr0=''),
    12091 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=12091, CurrentID=0, Status='live', Symbol='Glb1', Aliases=['AW125515', 'Bg', 'Bge', 'Bgl', 'Bgl-', 'Bgl-e', 'Bgl-s', 'Bgl-t', 'Bgs', 'Bgt', 'C130097A14Rik'], description='galactosidase, beta 1', other_designations='beta-galactosidase|acid beta-galactosidase|lactase', map_location='9 64.4 cM', chromosome='9', genomic_nucleotide_accession_version='NC_000075.6', start_position_on_the_genomic_accession=114401078, end_position_on_the_genomic_accession=114474379, orientation='plus', exon_count=16, OMIM=[], no_hdr0=''),
    12095 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=12095, CurrentID=0, Status='live', Symbol='Bglap3', Aliases=['AI461847', 'Bgla', 'Bglap-rs1', 'O', 'OC-X', 'ORG', 'mOC-', 'mOC-X'], description='bone gamma-carboxyglutamate protein 3', other_designations='osteocalcin-related protein|bone gamma-carboxyglutamate protein, related sequence 1|gamma-carboxyglutamic acid-containing protein 3|nephrocalcin', map_location='3 38.81 cM', chromosome='3', genomic_nucleotide_accession_version='NC_000069.6', start_position_on_the_genomic_accession=88368616, end_position_on_the_genomic_accession=88372741, orientation='minus', exon_count=7, OMIM=[], no_hdr0=''),
    12096 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=12096, CurrentID=0, Status='live', Symbol='Bglap', Aliases=['BGP', 'Bgl1', 'O', 'OC', 'OG', 'OG1', 'mOC', 'mOC-A', 'oste', 'Bglap'], description='bone gamma carboxyglutamate protein', other_designations='osteocalcin|bone Gla protein|bone gamma carboxyglutamate protein 1|gamma-carboxyglutamic acid-containing protein', map_location='3 38.82 cM', chromosome='3', genomic_nucleotide_accession_version='NC_000069.6', start_position_on_the_genomic_accession=88383495, end_position_on_the_genomic_accession=88384466, orientation='minus', exon_count=4, OMIM=[], no_hdr0=''),
    12097 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=12097, CurrentID=0, Status='live', Symbol='Bglap2', Aliases=['BGP2', 'Bglap1', 'Bgp', 'OG', 'Og2', 'mOC-', 'mOC-B', 'oste'], description='bone gamma-carboxyglutamate protein 2', other_designations='osteocalcin-2|bone Gla protein 2|gamma-carboxyglutamic acid-containing protein 2|osteocalcin', map_location='3 38.81 cM', chromosome='3', genomic_nucleotide_accession_version='NC_000069.6', start_position_on_the_genomic_accession=88377736, end_position_on_the_genomic_accession=88378701, orientation='minus', exon_count=4, OMIM=[], no_hdr0=''),
    12111 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=12111, CurrentID=0, Status='live', Symbol='Bgn', Aliases=['BG', 'DSPG1', 'PG-S1', 'PGI', 'S', 'SLRR1A'], description='biglycan', other_designations='biglycan|bone/cartilage proteoglycan I', map_location='X 37.33 cM', chromosome='X', genomic_nucleotide_accession_version='NC_000086.7', start_position_on_the_genomic_accession=73483601, end_position_on_the_genomic_accession=73495936, orientation='plus', exon_count=9, OMIM=[], no_hdr0=''),
    12116 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=12116, CurrentID=0, Status='live', Symbol='Bhmt', Aliases=[], description='betaine-homocysteine methyltransferase', other_designations='betaine--homocysteine S-methyltransferase 1', map_location='13 C3', chromosome='13', genomic_nucleotide_accession_version='NC_000079.6', start_position_on_the_genomic_accession=93616891, end_position_on_the_genomic_accession=93637758, orientation='minus', exon_count=8, OMIM=[], no_hdr0=''),
    12121 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=12121, CurrentID=0, Status='live', Symbol='Bicd1', Aliases=['B830009D06Rik', 'bic-D 1'], description='BICD cargo adaptor 1', other_designations='protein bicaudal D homolog 1|bicaudal D homolog 1', map_location='6 G3', chromosome='6', genomic_nucleotide_accession_version='NC_000072.6', start_position_on_the_genomic_accession=149408824, end_position_on_the_genomic_accession=149563329, orientation='plus', exon_count=11, OMIM=[], no_hdr0=''),
    12122 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=12122, CurrentID=0, Status='live', Symbol='Bid', Aliases=['2700049M22Rik', 'AI875481', 'AU022477'], description='BH3 interacting domain death agonist', other_designations='BH3-interacting domain death agonist|p22 BID', map_location='6 57.02 cM', chromosome='6', genomic_nucleotide_accession_version='NC_000072.6', start_position_on_the_genomic_accession=120893119, end_position_on_the_genomic_accession=120917062, orientation='minus', exon_count=9, OMIM=[], no_hdr0=''),
    12123 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=12123, CurrentID=0, Status='live', Symbol='Hrk', Aliases=['AI838259', 'Bid', 'Bid3', 'DP', 'DP5', 'harakiri'], description='harakiri, BCL2 interacting protein (contains only BH3 domain)', other_designations='activator of apoptosis harakiri|BH3 interacting (with BCL2 family) domain, apoptosis agonist|BH3-interacting domain-containing protein 3|neuronal death protein DP5', map_location='5 F', chromosome='5', genomic_nucleotide_accession_version='NC_000071.6', start_position_on_the_genomic_accession=118169764, end_position_on_the_genomic_accession=118189478, orientation='plus', exon_count=2, OMIM=[], no_hdr0=''),
    12124 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=12124, CurrentID=0, Status='live', Symbol='Bik', Aliases=['Biklk', 'Bl', 'Blk', 'Nb', 'Nbk'], description='BCL2-interacting killer', other_designations='bcl-2-interacting killer|apoptosis inducer NBK|bik-like killer protein', map_location='15 E1', chromosome='15', genomic_nucleotide_accession_version='NC_000081.6', start_position_on_the_genomic_accession=83526790, end_position_on_the_genomic_accession=83544635, orientation='plus', exon_count=9, OMIM=[], no_hdr0=''),
    12125 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=12125, CurrentID=0, Status='live', Symbol='Bcl2l11', Aliases=['1500006F24Rik', 'Bi', 'Bim', 'Bo', 'Bod', 'bcl2-L-11'], description='BCL2-like 11 (apoptosis facilitator)', other_designations='bcl-2-like protein 11|Bcl2 interacting mediator of cell death|bcl2-interacting mediator of cell death', map_location='2 F1', chromosome='2', genomic_nucleotide_accession_version='NC_000068.7', start_position_on_the_genomic_accession=128126038, end_position_on_the_genomic_accession=128162547, orientation='plus', exon_count=7, OMIM=[], no_hdr0=''),
    12140 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=12140, CurrentID=0, Status='live', Symbol='Fabp7', Aliases=['B-FA', 'B-FABP', 'BFA', 'BFABP', 'Bl', 'Blbp', 'MRG'], description='fatty acid binding protein 7, brain', other_designations='fatty acid-binding protein, brain|brain lipid-binding protein|brain-type fatty acid-binding protein|fatty acid-binding protein 7|mammary-derived growth inhibitor-related', map_location='10 B4', chromosome='10', genomic_nucleotide_accession_version='NC_000076.6', start_position_on_the_genomic_accession=57784923, end_position_on_the_genomic_accession=57788450, orientation='plus', exon_count=4, OMIM=[], no_hdr0=''),
    12142 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=12142, CurrentID=0, Status='live', Symbol='Prdm1', Aliases=['Bli', 'Blim', 'Blimp-1', 'Blimp1', 'PRDI-', 'PRDI-BF1', 'ZNFPR1A1', 'b2b1765C', 'b2b1765Clo'], description='PR domain containing 1, with ZNF domain', other_designations='PR domain zinc finger protein 1|B lymphocyte induced maturation protein|B lymphocyte-induced maturation protein 1|PR domain-containing protein 1|beta-interferon gene positive regulatory domain I-binding factor', map_location='10 23.24 cM', chromosome='10', genomic_nucleotide_accession_version='NC_000076.6', start_position_on_the_genomic_accession=44437174, end_position_on_the_genomic_accession=44528558, orientation='minus', exon_count=12, OMIM=[], no_hdr0=''),
    12143 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=12143, CurrentID=0, Status='live', Symbol='Blk', Aliases=[], description='B lymphoid kinase', other_designations='tyrosine-protein kinase Blk|b lymphocyte kinase|p55-Blk', map_location='14 33.25 cM', chromosome='14', genomic_nucleotide_accession_version='NC_000080.6', start_position_on_the_genomic_accession=63372837, end_position_on_the_genomic_accession=63417187, orientation='minus', exon_count=13, OMIM=[], no_hdr0=''),
    12144 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=12144, CurrentID=0, Status='live', Symbol='Blm', Aliases=[], description='Bloom syndrome, RecQ like helicase', other_designations='Bloom syndrome protein homolog|Bloom syndrome homolog|Bloom syndrome, RecQ helicase-like|mBLM|recQ helicase homolog', map_location='7 45.65 cM', chromosome='7', genomic_nucleotide_accession_version='NC_000073.6', start_position_on_the_genomic_accession=80454993, end_position_on_the_genomic_accession=80535148, orientation='minus', exon_count=24, OMIM=[], no_hdr0=''),
    12145 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=12145, CurrentID=0, Status='live', Symbol='Cxcr5', Aliases=['Bl', 'Blr1', 'CXC-R5', 'CXCR-', 'CXCR-5', 'Gpc', 'Gpcr6', 'MDR15'], description='chemokine (C-X-C motif) receptor 5', other_designations='C-X-C chemokine receptor type 5|burkitt lymphoma receptor 1 homolog|chemochine (C-X-C motif) receptor 5', map_location='9 24.84 cM', chromosome='9', genomic_nucleotide_accession_version='NC_000075.6', start_position_on_the_genomic_accession=44511787, end_position_on_the_genomic_accession=44526444, orientation='minus', exon_count=2, OMIM=[], no_hdr0=''),
    12151 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=12151, CurrentID=0, Status='live', Symbol='Bmi1', Aliases=['AW546694', 'Bmi', 'Bmi-', 'Bmi-1', 'Pcgf', 'Pcgf4'], description='Bmi1 polycomb ring finger oncogene', other_designations='polycomb complex protein BMI-1|B lymphoma Mo-MLV insertion region 1|polycomb group RING finger protein 4|polycomb group ring finger 4', map_location='2 12.9 cM', chromosome='2', genomic_nucleotide_accession_version='NC_000068.7', start_position_on_the_genomic_accession=18677018, end_position_on_the_genomic_accession=18686629, orientation='plus', exon_count=12, OMIM=[], no_hdr0=''),
    12153 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=12153, CurrentID=0, Status='live', Symbol='Bmp1', Aliases=['Pcp', 'Tld'], description='bone morphogenetic protein 1', other_designations='bone morphogenetic protein 1|mammalian tolloid protein|procollagen C-proteinase', map_location='14 36.32 cM', chromosome='14', genomic_nucleotide_accession_version='NC_000080.6', start_position_on_the_genomic_accession=70474555, end_position_on_the_genomic_accession=70520716, orientation='minus', exon_count=23, OMIM=[], no_hdr0=''),
    12154 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=12154, CurrentID=0, Status='live', Symbol='Bmp10', Aliases=['b2b2711C', 'b2b2711Clo'], description='bone morphogenetic protein 10', other_designations='bone morphogenetic protein 10|BMP-10', map_location='6 D1', chromosome='6', genomic_nucleotide_accession_version='NC_000072.6', start_position_on_the_genomic_accession=87428994, end_position_on_the_genomic_accession=87434512, orientation='plus', exon_count=2, OMIM=[], no_hdr0=''),
    12155 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=12155, CurrentID=0, Status='live', Symbol='Bmp15', Aliases=['AU015375', 'AU018861', 'AU021453', 'Bmp-1', 'Bmp-15', 'C86824', 'C87336', 'GDF-9B'], description='bone morphogenetic protein 15', other_designations='bone morphogenetic protein 15|growth/differentiation factor 9B', map_location='X 2.81 cM', chromosome='X', genomic_nucleotide_accession_version='NC_000086.7', start_position_on_the_genomic_accession=6314054, end_position_on_the_genomic_accession=6320724, orientation='minus', exon_count=2, OMIM=[], no_hdr0=''),
    12156 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=12156, CurrentID=0, Status='live', Symbol='Bmp2', Aliases=['AI467020', 'Bmpa', 'Bmp2'], description='bone morphogenetic protein 2', other_designations='bone morphogenetic protein 2|bone morphogenetic protein 2A', map_location='2 65.21 cM', chromosome='2', genomic_nucleotide_accession_version='NC_000068.7', start_position_on_the_genomic_accession=133552159, end_position_on_the_genomic_accession=133562896, orientation='plus', exon_count=3, OMIM=[], no_hdr0=''),
    12159 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=12159, CurrentID=0, Status='live', Symbol='Bmp4', Aliases=['Bmp-', 'Bmp-4', 'Bmp2', 'Bmp2b', 'Bmp2b-', 'Bmp2b-1', 'Bmp2b1'], description='bone morphogenetic protein 4', other_designations='bone morphogenetic protein 4|bone morphogenetic protein 2B', map_location='14 23.95 cM', chromosome='14', genomic_nucleotide_accession_version='NC_000080.6', start_position_on_the_genomic_accession=46383525, end_position_on_the_genomic_accession=46390669, orientation='minus', exon_count=4, OMIM=[], no_hdr0=''),
    12160 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=12160, CurrentID=0, Status='live', Symbol='Bmp5', Aliases=['AU023399', 'se'], description='bone morphogenetic protein 5', other_designations='bone morphogenetic protein 5', map_location='9 42.34 cM', chromosome='9', genomic_nucleotide_accession_version='NC_000075.6', start_position_on_the_genomic_accession=75775365, end_position_on_the_genomic_accession=75900316, orientation='plus', exon_count=7, OMIM=[], no_hdr0=''),
    12161 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=12161, CurrentID=0, Status='live', Symbol='Bmp6', Aliases=['D13Wsu115', 'D13Wsu115e', 'Vg', 'Vgr1'], description='bone morphogenetic protein 6', other_designations='bone morphogenetic protein 6|VG-1-related protein', map_location='13 18.15 cM', chromosome='13', genomic_nucleotide_accession_version='NC_000079.6', start_position_on_the_genomic_accession=38345716, end_position_on_the_genomic_accession=38500314, orientation='plus', exon_count=7, OMIM=[], no_hdr0=''),
    12162 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=12162, CurrentID=0, Status='live', Symbol='Bmp7', Aliases=['O', 'OP1'], description='bone morphogenetic protein 7', other_designations='bone morphogenetic protein 7|osteogenic protein 1', map_location='2 95.54 cM', chromosome='2', genomic_nucleotide_accession_version='NC_000068.7', start_position_on_the_genomic_accession=172868012, end_position_on_the_genomic_accession=172940321, orientation='minus', exon_count=7, OMIM=[], no_hdr0=''),
    12163 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=12163, CurrentID=0, Status='live', Symbol='Bmp8a', Aliases=['Bmp7', 'Bmp7r1', 'O', 'OP-2', 'OP2'], description='bone morphogenetic protein 8a', other_designations='bone morphogenetic protein 8A|osteogenic protein 2', map_location='4 57.42 cM', chromosome='4', genomic_nucleotide_accession_version='NC_000070.6', start_position_on_the_genomic_accession=123312645, end_position_on_the_genomic_accession=123343252, orientation='minus', exon_count=7, OMIM=[], no_hdr0=''),
    12164 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=12164, CurrentID=0, Status='live', Symbol='Bmp8b', Aliases=['O', 'Op3'], description='bone morphogenetic protein 8b', other_designations='bone morphogenetic protein 8B', map_location='4 57.38 cM', chromosome='4', genomic_nucleotide_accession_version='NC_000070.6', start_position_on_the_genomic_accession=123104308, end_position_on_the_genomic_accession=123126094, orientation='plus', exon_count=8, OMIM=[], no_hdr0=''),
    12165 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=12165, CurrentID=0, Status='live', Symbol='Gdf2', Aliases=['Bmp', 'Bmp9'], description='growth differentiation factor 2', other_designations='growth/differentiation factor 2|bone morphogenetic protein 9', map_location='14 B', chromosome='14', genomic_nucleotide_accession_version='NC_000080.6', start_position_on_the_genomic_accession=33941039, end_position_on_the_genomic_accession=33947198, orientation='plus', exon_count=2, OMIM=[], no_hdr0=''),
    12166 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=12166, CurrentID=0, Status='live', Symbol='Bmpr1a', Aliases=['1110037I22Rik', 'AL', 'ALK-3', 'ALK3', 'AU045487', 'BMP', 'BMPR-1A', 'BMPR-IA', 'Bm', 'Bmpr', 'SKR5'], description='bone morphogenetic protein receptor, type 1A', other_designations='bone morphogenetic protein receptor type-1A|BMP type-1A receptor|BMP-2/BMP-4 receptor|activin receptor-like kinase 3|serine/threonine-protein kinase receptor R5', map_location='14 20.81 cM', chromosome='14', genomic_nucleotide_accession_version='NC_000080.6', start_position_on_the_genomic_accession=34411061, end_position_on_the_genomic_accession=34503336, orientation='minus', exon_count=15, OMIM=[], no_hdr0=''),
    12167 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=12167, CurrentID=0, Status='live', Symbol='Bmpr1b', Aliases=['AI385617', 'ALK-6', 'AV355320', 'Acv', 'Acvrlk6', 'Al', 'Alk6', 'BMPR', 'BMPR-1B', 'BMPR-IB', 'CFK-43', 'CFK-43a', 'SKR6'], description='bone morphogenetic protein receptor, type 1B', other_designations='bone morphogenetic protein receptor type-1B|BMP type-1B receptor|activin receptor-like kinase 6|serine/threonine-protein kinase receptor R6', map_location='3 H1', chromosome='3', genomic_nucleotide_accession_version='NC_000069.6', start_position_on_the_genomic_accession=141837135, end_position_on_the_genomic_accession=142169585, orientation='minus', exon_count=18, OMIM=[], no_hdr0=''),
    12168 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=12168, CurrentID=0, Status='live', Symbol='Bmpr2', Aliases=['2610024H22Rik', 'AL117858', 'AW546137', 'BB189135', 'BM', 'BMP', 'BMP-', 'BMP-2', 'BMPR-2', 'BMPR-II', 'BMPRII', 'BRK-3', 'Gm20272'], description='bone morphogenetic protein receptor, type II (serine/threonine kinase)', other_designations='bone morphogenetic protein receptor type-2|BMP type II receptor|BMP type-2 receptor|bone morphogenic protein receptor, type II (serine/threonine kinase)', map_location='1 C2', chromosome='1', genomic_nucleotide_accession_version='NC_000067.6', start_position_on_the_genomic_accession=59764279, end_position_on_the_genomic_accession=59878081, orientation='plus', exon_count=13, OMIM=[], no_hdr0=''),
    12169 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=12169, CurrentID=0, Status='live', Symbol='Bmx', Aliases=['Etk', 'Etk/Bmx', 'Tyr', 'Tyro8'], description='BMX non-receptor tyrosine kinase', other_designations='cytoplasmic tyrosine-protein kinase BMX|TYRO8 protein tyrosine kinase 8|bone marrow tyrosine kinase gene in chromosome X protein homolog', map_location='X F5', chromosome='X', genomic_nucleotide_accession_version='NC_000086.7', start_position_on_the_genomic_accession=164192842, end_position_on_the_genomic_accession=164258193, orientation='minus', exon_count=19, OMIM=[], no_hdr0=''),
    12173 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=12173, CurrentID=0, Status='live', Symbol='Bnc1', Aliases=['AI047752', 'AW546376', 'Bnc'], description='basonuclin 1', other_designations='zinc finger protein basonuclin-1', map_location='7 D3', chromosome='7', genomic_nucleotide_accession_version='NC_000073.6', start_position_on_the_genomic_accession=81966657, end_position_on_the_genomic_accession=81992299, orientation='minus', exon_count=6, OMIM=[], no_hdr0=''),
    12175 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=12175, CurrentID=0, Status='live', Symbol='Bnip2', Aliases=['5730523P12Rik', 'BNIP2beta', 'Nip21'], description='BCL2/adenovirus E1B interacting protein 2', other_designations='BCL2/adenovirus E1B 19 kDa protein-interacting protein 2|BCL2/adenovirus E1B 19 kDa-interacting protein 2 beta|BCL2/adenovirus E1B 19kDa-interacting protein 1, NIP2|BCL2/adenovirus E1B interacting protein 1, NIP2', map_location='9 D', chromosome='9', genomic_nucleotide_accession_version='NC_000075.6', start_position_on_the_genomic_accession=69989438, end_position_on_the_genomic_accession=70011659, orientation='plus', exon_count=11, OMIM=[], no_hdr0=''),
    12176 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=12176, CurrentID=0, Status='live', Symbol='Bnip3', Aliases=['N', 'Nip3'], description='BCL2/adenovirus E1B interacting protein 3', other_designations='BCL2/adenovirus E1B 19 kDa protein-interacting protein 3|BCL2/adenovirus E1B 19 kDa-interacting protein 1, NIP3|BCL2/adenovirus E1B 19kDa-interacting protein 1, NIP3|BCL2/adenovirus E1B interacting protein 1, NIP3', map_location='7 F4', chromosome='7', genomic_nucleotide_accession_version='NC_000073.6', start_position_on_the_genomic_accession=138890836, end_position_on_the_genomic_accession=138909506, orientation='minus', exon_count=6, OMIM=[], no_hdr0=''),
    12177 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=12177, CurrentID=0, Status='live', Symbol='Bnip3l', Aliases=['C86132', 'D14Ertd719', 'D14Ertd719e', 'N', 'Nip3L', 'Nix'], description='BCL2/adenovirus E1B interacting protein 3-like', other_designations='BCL2/adenovirus E1B 19 kDa protein-interacting protein 3-like|BCL2/adenovirus E1B 19 kDa-interacting protein 3-like|BCL2/adenovirus E1B 19kDa-interacting protein 3-like|NIP3-like protein X', map_location='14 34.6 cM', chromosome='14', genomic_nucleotide_accession_version='NC_000080.6', start_position_on_the_genomic_accession=66985238, end_position_on_the_genomic_accession=67008877, orientation='minus', exon_count=8, OMIM=[], no_hdr0=''),
    12180 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=12180, CurrentID=0, Status='live', Symbol='Smyd1', Aliases=['4632404M21Rik', 'B', 'Bop', 'C78565', 'Zmynd18'], description='SET and MYND domain containing 1', other_designations='histone-lysine N-methyltransferase Smyd1|CD8b-opposite|CD8beta opposite strand|SET and MYND domain-containing protein 1|m-BOP|zinc finger protein BOP', map_location='6 32.14 cM', chromosome='6', genomic_nucleotide_accession_version='NC_000072.6', start_position_on_the_genomic_accession=71213940, end_position_on_the_genomic_accession=71262281, orientation='minus', exon_count=10, OMIM=[], no_hdr0=''),
    12181 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=12181, CurrentID=0, Status='live', Symbol='Bop1', Aliases=['AU020183', 'AW146150', 'D18861', 'Erb', 'Erb1p', 'Kiaa0124', 'mKIAA0124'], description='block of proliferation 1', other_designations='ribosome biogenesis protein BOP1|block of proliferation 1 protein', map_location='15 35.91 cM', chromosome='15', genomic_nucleotide_accession_version='NC_000081.6', start_position_on_the_genomic_accession=76452988, end_position_on_the_genomic_accession=76477249, orientation='minus', exon_count=16, OMIM=[], no_hdr0=''),
    12182 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=12182, CurrentID=0, Status='live', Symbol='Bst1', Aliases=['114/A1', '114/A10', 'A530073F09', 'BP-3', 'Bp', 'Bp3', 'Bst', 'Bsta1', 'CD157', 'Ly6', 'Ly65'], description='bone marrow stromal cell antigen 1', other_designations='ADP-ribosyl cyclase/cyclic ADP-ribose hydrolase 2|ADP-ribosyl cyclase 2|BP-3 alloantigen|BST-1|antigen BP3|bone marrow stromal antigen 1|cADPr hydrolase 2|cyclic ADP-ribose hydrolase 2|leukocyte antigen 65|ly-65', map_location='5 23.84 cM', chromosome='5', genomic_nucleotide_accession_version='NC_000071.6', start_position_on_the_genomic_accession=43818880, end_position_on_the_genomic_accession=43843468, orientation='plus', exon_count=9, OMIM=[], no_hdr0=''),
    12183 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=12183, CurrentID=0, Status='live', Symbol='Bpgm', Aliases=['AI323730', 'AL022789', 'C86192'], description='2,3-bisphosphoglycerate mutase', other_designations='bisphosphoglycerate mutase|2,3-bisphosphoglycerate mutase, erythrocyte|2,3-bisphosphoglycerate synthase|BPG-dependent PGAM', map_location='6 B1', chromosome='6', genomic_nucleotide_accession_version='NC_000072.6', start_position_on_the_genomic_accession=34476356, end_position_on_the_genomic_accession=34505136, orientation='plus', exon_count=3, OMIM=[], no_hdr0=''),
    12189 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=12189, CurrentID=0, Status='live', Symbol='Brca1', Aliases=[], description='breast cancer 1, early onset', other_designations='breast cancer type 1 susceptibility protein homolog|RING-type E3 ubiquitin transferase BRCA1|breast and ovarian cancer susceptibility protein|breast cancer associated 1', map_location='11 D', chromosome='11', genomic_nucleotide_accession_version='NC_000077.6', start_position_on_the_genomic_accession=101488761, end_position_on_the_genomic_accession=101551955, orientation='minus', exon_count=25, OMIM=[], no_hdr0=''),
    12190 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=12190, CurrentID=0, Status='live', Symbol='Brca2', Aliases=['Fanc', 'Fancd1', 'RAB1', 'RAB163'], description='breast cancer 2, early onset', other_designations='breast cancer type 2 susceptibility protein homolog|fanconi anemia group D1 protein homolog', map_location='5 89.52 cM', chromosome='5', genomic_nucleotide_accession_version='NC_000071.6', start_position_on_the_genomic_accession=150522297, end_position_on_the_genomic_accession=150570147, orientation='plus', exon_count=27, OMIM=[], no_hdr0=''),
    12192 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=12192, CurrentID=0, Status='live', Symbol='Zfp36l1', Aliases=['AW742437', 'AW743212', 'Berg36', 'Brf', 'Brf1', 'D530020L18Rik', 'ERF1', 'TIS1', 'TIS11b', 'cMG1'], description='zinc finger protein 36, C3H type-like 1', other_designations='mRNA decay activator protein ZFP36L1|TPA-induced sequence 11b|ZFP36-like 1|butyrate response factor 1|zinc finger protein 36, C3H1 type-like 1', map_location='12 C3', chromosome='12', genomic_nucleotide_accession_version='NC_000078.6', start_position_on_the_genomic_accession=80107760, end_position_on_the_genomic_accession=80113013, orientation='minus', exon_count=2, OMIM=[], no_hdr0=''),
    12193 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=12193, CurrentID=0, Status='live', Symbol='Zfp36l2', Aliases=['Brf', 'Brf2', 'ERF', 'ERF2', 'Tis1', 'Tis11d'], description='zinc finger protein 36, C3H type-like 2', other_designations='mRNA decay activator protein ZFP36L2|TPA-induced sequence 11d|ZFP36-like 2|butyrate response factor 2|zinc finger protein 36, C3H1 type-like 2', map_location='17 E4', chromosome='17', genomic_nucleotide_accession_version='NC_000083.6', start_position_on_the_genomic_accession=84183924, end_position_on_the_genomic_accession=84187947, orientation='minus', exon_count=2, OMIM=[], no_hdr0=''),
    12209 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=12209, CurrentID=0, Status='live', Symbol='Brs3', Aliases=['BRS', 'BRS-3'], description='bombesin-like receptor 3', other_designations='bombesin receptor subtype-3', map_location='X A6', chromosome='X', genomic_nucleotide_accession_version='NC_000086.7', start_position_on_the_genomic_accession=57043074, end_position_on_the_genomic_accession=57048758, orientation='plus', exon_count=3, OMIM=[], no_hdr0=''),
    12211 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=12211, CurrentID=0, Status='live', Symbol='Birc6', Aliases=['A430032G04Rik', 'A430040A19Rik', 'AA501170', 'Bruc', 'Bruce', 'D630005A10Rik', 'mKIAA1289'], description='baculoviral IAP repeat-containing 6', other_designations='baculoviral IAP repeat-containing protein 6|BIR repeat-containing ubiquitin-conjugating enzyme|RING-type E3 ubiquitin transferase BIRC6|apollon|baculovirus inhibitor of apoptosis repeat containing ubiquitin-conjugating enzyme|baculovirus inhibitor of apoptosis repeat containing ubiquitin-conjugating enzyme; accccbaculoviral IAP repeat-containing 6|ubiquitin-conjugating BIR domain enzyme apollon', map_location='17 E2', chromosome='17', genomic_nucleotide_accession_version='NC_000083.6', start_position_on_the_genomic_accession=74528254, end_position_on_the_genomic_accession=74703356, orientation='plus', exon_count=75, OMIM=[], no_hdr0=''),
    12212 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=12212, CurrentID=0, Status='live', Symbol='Chic1', Aliases=['Br', 'Brx', 'Gm10454'], description='cysteine-rich hydrophobic domain 1', other_designations='cysteine-rich hydrophobic domain-containing protein 1|brain X-linked protein', map_location='X 46.08 cM', chromosome='X', genomic_nucleotide_accession_version='NC_000086.7', start_position_on_the_genomic_accession=103356403, end_position_on_the_genomic_accession=103409092, orientation='plus', exon_count=7, OMIM=[], no_hdr0=''),
    12215 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=12215, CurrentID=0, Status='live', Symbol='Bsg', Aliases=['AI115436', 'AI325119', 'CD147', 'EMM', 'EMMPRIN', 'HT-7', 'neuro'], description='basigin', other_designations='basigin|5A11/Basigin|HT7 antigen|basic immunoglobulin superfamily|gp 42|membrane glycoprotein gp42|neurothelin', map_location='10 39.72 cM', chromosome='10', genomic_nucleotide_accession_version='NC_000076.6', start_position_on_the_genomic_accession=79704358, end_position_on_the_genomic_accession=79711979, orientation='plus', exon_count=8, OMIM=[], no_hdr0=''),
    12217 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=12217, CurrentID=0, Status='live', Symbol='Bsn', Aliases=[], description='bassoon', other_designations='protein bassoon|presynaptic cytomatrix protein', map_location='9 59.07 cM', chromosome='9', genomic_nucleotide_accession_version='NC_000075.6', start_position_on_the_genomic_accession=108096022, end_position_on_the_genomic_accession=108190419, orientation='minus', exon_count=12, OMIM=[], no_hdr0=''),
    12223 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=12223, CurrentID=0, Status='live', Symbol='Btc', Aliases=['Bcn'], description='betacellulin, epidermal growth factor family member', other_designations='betacellulin|probetacellulin', map_location='5 44.78 cM', chromosome='5', genomic_nucleotide_accession_version='NC_000071.6', start_position_on_the_genomic_accession=91357261, end_position_on_the_genomic_accession=91402994, orientation='minus', exon_count=6, OMIM=[], no_hdr0=''),
    12224 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=12224, CurrentID=0, Status='live', Symbol='Klf5', Aliases=['4930520J07Rik', 'Bteb2', 'CKL', 'CKLF', 'IK', 'IKLF'], description='Kruppel-like factor 5', other_designations='Krueppel-like factor 5|BTE-binding protein 2|basic transcription element-binding protein 2|intestinal-enriched krueppel-like factor|transcription factor BTEB2', map_location='14 E2.2', chromosome='14', genomic_nucleotide_accession_version='NC_000080.6', start_position_on_the_genomic_accession=99298691, end_position_on_the_genomic_accession=99313412, orientation='plus', exon_count=4, OMIM=[], no_hdr0=''),
    12226 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=12226, CurrentID=0, Status='live', Symbol='Btg1', Aliases=['AI426953', 'AW546738'], description='BTG anti-proliferation factor 1', other_designations='protein BTG1|B cell translocation gene 1, anti-proliferative|B-cell translocation gene 1 protein', map_location='10 C3', chromosome='10', genomic_nucleotide_accession_version='NC_000076.6', start_position_on_the_genomic_accession=96617001, end_position_on_the_genomic_accession=96622813, orientation='plus', exon_count=2, OMIM=[], no_hdr0=''),
    12227 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=12227, CurrentID=0, Status='live', Symbol='Btg2', Aliases=['A', 'AA959598', 'APRO1', 'Pc', 'Pc3', 'TIS', 'TIS21'], description='BTG anti-proliferation factor 2', other_designations='protein BTG2|B cell translocation gene 2, anti-proliferative|BTG family member 2|NGF-inducible protein TIS21', map_location='1 58.1 cM', chromosome='1', genomic_nucleotide_accession_version='NC_000067.6', start_position_on_the_genomic_accession=134074865, end_position_on_the_genomic_accession=134079155, orientation='minus', exon_count=2, OMIM=[], no_hdr0=''),
    12228 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=12228, CurrentID=0, Status='live', Symbol='Btg3', Aliases=['ANA', 'tob', 'tob5'], description='BTG anti-proliferation factor 3', other_designations='protein BTG3|B cell translocation gene 3|BTG family member 3|abundant in neuroepithelium area protein', map_location='16 C3.1', chromosome='16', genomic_nucleotide_accession_version='NC_000082.6', start_position_on_the_genomic_accession=78359860, end_position_on_the_genomic_accession=78377181, orientation='minus', exon_count=6, OMIM=[], no_hdr0=''),
    12229 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=12229, CurrentID=0, Status='live', Symbol='Btk', Aliases=['AI528679', 'xi', 'xid'], description='Bruton agammaglobulinemia tyrosine kinase', other_designations="tyrosine-protein kinase BTK|ATK|B-cell progenitor kinase|BPK|Bruton's tyrosine kinase|Tyrosine-protein kinase BTK (Brutons tyrosine kinase) (Agammaglobulinaemia tyrosine kinase) (ATK) (B cell progenitor kinase) (BPK) (Kinase EMB)|X-linked immune deficiency|agammaglobulinaemia tyrosine kinase|agammaglobulinemia tyrosine kinase|bruton tyrosine kinase|kinase EMB", map_location='X 56.18 cM', chromosome='X', genomic_nucleotide_accession_version='NC_000086.7', start_position_on_the_genomic_accession=134542334, end_position_on_the_genomic_accession=134583628, orientation='minus', exon_count=21, OMIM=[], no_hdr0=''),
    12231 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=12231, CurrentID=0, Status='live', Symbol='Btn1a1', Aliases=['Btn'], description='butyrophilin, subfamily 1, member A1', other_designations='butyrophilin subfamily 1 member A1|BT', map_location='13 9.72 cM', chromosome='13', genomic_nucleotide_accession_version='NC_000079.6', start_position_on_the_genomic_accession=23456984, end_position_on_the_genomic_accession=23465914, orientation='minus', exon_count=8, OMIM=[], no_hdr0=''),
    12234 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=12234, CurrentID=0, Status='live', Symbol='Btrc', Aliases=['Beta-Tr', 'Beta-Trcp1', 'E3RS-IkappaB', 'E3RSIkappaB', 'FWD1', 'Fbw1', 'Fbw1a', 'HOS', 'SCF b-TRCP', 'Sl', 'Slimb', 'b-TrCP', 'beta-T', 'beta-TrCP'], description='beta-transducin repeat containing protein', other_designations='F-box/WD repeat-containing protein 1A', map_location='19 C3', chromosome='19', genomic_nucleotide_accession_version='NC_000085.6', start_position_on_the_genomic_accession=45363688, end_position_on_the_genomic_accession=45533343, orientation='plus', exon_count=21, OMIM=[], no_hdr0=''),
    12235 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=12235, CurrentID=0, Status='live', Symbol='Bub1', Aliases=['AL022991a', 'C80208', 'D2Xrf8', 'D2Xrf87', 'Bub1'], description='BUB1, mitotic checkpoint serine/threonine kinase', other_designations='mitotic checkpoint serine/threonine-protein kinase BUB1|budding uninhibited by benzimidazoles 1 homolog|mBUB1', map_location='2 62.1 cM', chromosome='2', genomic_nucleotide_accession_version='NC_000068.7', start_position_on_the_genomic_accession=127800197, end_position_on_the_genomic_accession=127831859, orientation='minus', exon_count=25, OMIM=[], no_hdr0=''),
    12236 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=12236, CurrentID=0, Status='live', Symbol='Bub1b', Aliases=['AU045529', 'BUBR', 'BUBR1'], description='BUB1B, mitotic checkpoint serine/threonine kinase', other_designations='mitotic checkpoint serine/threonine-protein kinase BUB1 beta|MAD3/BUB1-related protein kinase|budding uninhibited by benzimidazoles 1 beta|budding uninhibited by benzimidazoles 1 homolog, beta|mitotic checkpoint kinase MAD3L', map_location='2 E5', chromosome='2', genomic_nucleotide_accession_version='NC_000068.7', start_position_on_the_genomic_accession=118598202, end_position_on_the_genomic_accession=118641592, orientation='plus', exon_count=23, OMIM=[], no_hdr0=''),
    12237 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=12237, CurrentID=0, Status='live', Symbol='Bub3', Aliases=['AU019800', 'AU021329', 'AU043350', 'AW146323', 'C78067'], description='BUB3 mitotic checkpoint protein', other_designations='mitotic checkpoint protein BUB3|WD repeat type I transmembrane protein A72.5|budding uninhibited by benzimidazoles 3 homolog', map_location='7 74.36 cM', chromosome='7', genomic_nucleotide_accession_version='NC_000073.6', start_position_on_the_genomic_accession=131560367, end_position_on_the_genomic_accession=131571895, orientation='plus', exon_count=10, OMIM=[], no_hdr0=''),
    12238 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=12238, CurrentID=0, Status='live', Symbol='Commd3', Aliases=['AW550818', 'Bu', 'Bup', 'D2Ertd542', 'D2Ertd542e'], description='COMM domain containing 3', other_designations='COMM domain-containing protein 3|Bmi1 upstream|bmi-1 upstream gene protein', map_location='2 12.9 cM', chromosome='2', genomic_nucleotide_accession_version='NC_000068.7', start_position_on_the_genomic_accession=18672435, end_position_on_the_genomic_accession=18676231, orientation='plus', exon_count=8, OMIM=[], no_hdr0=''),
    12257 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=12257, CurrentID=0, Status='live', Symbol='Tspo', Aliases=['Bz', 'Bzrp', 'IBP', 'P', 'PBR', 'Ts1', 'Tspo'], description='translocator protein', other_designations='translocator protein|PKBS|benzodiazepine receptor, peripheral|isoquinoline-binding protein|mitochondrial benzodiazepine receptor|peripheral-type benzodiazepine receptor', map_location='15 39.4 cM', chromosome='15', genomic_nucleotide_accession_version='NC_000081.6', start_position_on_the_genomic_accession=83563573, end_position_on_the_genomic_accession=83574203, orientation='plus', exon_count=4, OMIM=[], no_hdr0=''),
    12258 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=12258, CurrentID=0, Status='live', Symbol='Serping1', Aliases=['C1I', 'C1INH', 'C1n', 'C1nh'], description='serine (or cysteine) peptidase inhibitor, clade G, member 1', other_designations='plasma protease C1 inhibitor|C1 Inh|C1 esterase inhibitor|C1 inhibitor|C1-inhibiting factor|complement component 1 inhibitor|serine (or cysteine) proteinase inhibitor, clade G (C1 inhibitor), member 1|serine (or cysteine) proteinase inhibitor, clade G, member 1|serpin G1', map_location='2 D', chromosome='2', genomic_nucleotide_accession_version='NC_000068.7', start_position_on_the_genomic_accession=84765360, end_position_on_the_genomic_accession=84775444, orientation='minus', exon_count=8, OMIM=[], no_hdr0=''),
    12259 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=12259, CurrentID=0, Status='live', Symbol='C1qa', Aliases=['AI255395', 'Adic', 'C1q'], description='complement component 1, q subcomponent, alpha polypeptide', other_designations='complement C1q subcomponent subunit A|adiponectin c', map_location='4 69.05 cM', chromosome='4', genomic_nucleotide_accession_version='NC_000070.6', start_position_on_the_genomic_accession=136895916, end_position_on_the_genomic_accession=136898844, orientation='minus', exon_count=3, OMIM=[], no_hdr0=''),
    12260 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=12260, CurrentID=0, Status='live', Symbol='C1qb', Aliases=['Adia'], description='complement component 1, q subcomponent, beta polypeptide', other_designations='complement C1q subcomponent subunit B|adiponectin a', map_location='4 69.05 cM', chromosome='4', genomic_nucleotide_accession_version='NC_000070.6', start_position_on_the_genomic_accession=136880126, end_position_on_the_genomic_accession=136886200, orientation='minus', exon_count=3, OMIM=[], no_hdr0=''),
    12261 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=12261, CurrentID=0, Status='live', Symbol='C1qbp', Aliases=['AA407365', 'AA986492', 'D11Wsu182', 'D11Wsu182e', 'HAB', 'HABP1', 'P3', 'P32', 'gC1qBP'], description='complement component 1, q subcomponent binding protein', other_designations='complement component 1 Q subcomponent-binding protein, mitochondrial|GC1q-R protein|glycoprotein gC1qBP', map_location='11 43.21 cM', chromosome='11', genomic_nucleotide_accession_version='NC_000077.6', start_position_on_the_genomic_accession=70977846, end_position_on_the_genomic_accession=70983026, orientation='minus', exon_count=6, OMIM=[], no_hdr0=''),
    12262 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=12262, CurrentID=0, Status='live', Symbol='C1qc', Aliases=['AI385742', 'Adib', 'C1qg', 'Ciqc'], description='complement component 1, q subcomponent, C chain', other_designations='complement C1q subcomponent subunit C|adiponectin b|complement component 1, q subcomponent, c polypeptide|complement component 1, q subcomponent, gamma polypeptide', map_location='4 69.05 cM', chromosome='4', genomic_nucleotide_accession_version='NC_000070.6', start_position_on_the_genomic_accession=136889801, end_position_on_the_genomic_accession=136892936, orientation='minus', exon_count=3, OMIM=[], no_hdr0=''),
    12263 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=12263, CurrentID=0, Status='live', Symbol='C2', Aliases=[], description='complement component 2 (within H-2S)', other_designations='complement C2|MHC complement component C2|classical-complement pathway C3/C5 convertase|complement component C2|complement factor C2', map_location='17 18.41 cM', chromosome='17', genomic_nucleotide_accession_version='NC_000083.6', start_position_on_the_genomic_accession=34862602, end_position_on_the_genomic_accession=34882100, orientation='minus', exon_count=18, OMIM=[], no_hdr0=''),
    12265 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=12265, CurrentID=0, Status='live', Symbol='Ciita', Aliases=['C2t', 'C2ta', 'EG669998', 'Gm9475', 'Mhc2ta'], description='class II transactivator', other_designations='MHC class II transactivator', map_location='16 A1', chromosome='16', genomic_nucleotide_accession_version='NC_000082.6', start_position_on_the_genomic_accession=10480014, end_position_on_the_genomic_accession=10531064, orientation='plus', exon_count=24, OMIM=[], no_hdr0=''),
    12266 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=12266, CurrentID=0, Status='live', Symbol='C3', Aliases=['AI255234', 'ASP', 'HSE-MSF', 'Plp'], description='complement component 3', other_designations='complement C3|acylation stimulating protein|complement component 3d|complement factor 3', map_location='17 29.72 cM', chromosome='17', genomic_nucleotide_accession_version='NC_000083.6', start_position_on_the_genomic_accession=57203967, end_position_on_the_genomic_accession=57228136, orientation='minus', exon_count=42, OMIM=[], no_hdr0=''),
    12267 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=12267, CurrentID=0, Status='live', Symbol='C3ar1', Aliases=['AZ3B', 'C3', 'C3AR', 'HNFAG09'], description='complement component 3a receptor 1', other_designations='C3a anaphylatoxin chemotactic receptor|C3a-R|anaphylatoxin C3a receptor', map_location='6 F2', chromosome='6', genomic_nucleotide_accession_version='NC_000072.6', start_position_on_the_genomic_accession=122847140, end_position_on_the_genomic_accession=122856157, orientation='minus', exon_count=2, OMIM=[], no_hdr0=''),
    12268 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=12268, CurrentID=0, Status='live', Symbol='C4b', Aliases=['C4', 'Ss'], description='complement component 4B (Chido blood group)', other_designations='complement C4-B|complement component 4 (within H-2S)|complement component 4B (Childo blood group)', map_location='17 18.29 cM', chromosome='17', genomic_nucleotide_accession_version='NC_000083.6', start_position_on_the_genomic_accession=34728139, end_position_on_the_genomic_accession=34743902, orientation='minus', exon_count=42, OMIM=[], no_hdr0=''),
    12269 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=12269, CurrentID=0, Status='live', Symbol='C4bp', Aliases=['AI195242a', 'C4bp'], description='complement component 4 binding protein', other_designations='C4b-binding protein', map_location='1 56.89 cM', chromosome='1', genomic_nucleotide_accession_version='NC_000067.6', start_position_on_the_genomic_accession=130635921, end_position_on_the_genomic_accession=130661657, orientation='minus', exon_count=11, OMIM=[], no_hdr0=''),
    12273 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=12273, CurrentID=0, Status='live', Symbol='C5ar1', Aliases=['C5', 'C5aR', 'C5r', 'C5r1', 'Cd88', 'D7Msu', 'D7Msu1'], description='complement component 5a receptor 1', other_designations='C5a anaphylatoxin chemotactic receptor 1|C5a anaphylatoxin receptor|C5a ligand|C5a-R|complement component 5, receptor 1', map_location='7 8.77 cM', chromosome='7', genomic_nucleotide_accession_version='NC_000073.6', start_position_on_the_genomic_accession=16246743, end_position_on_the_genomic_accession=16259540, orientation='minus', exon_count=3, OMIM=[], no_hdr0=''),
    12274 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=12274, CurrentID=0, Status='live', Symbol='C6', Aliases=['AW111623'], description='complement component 6', other_designations='complement component C6', map_location='15 1.97 cM', chromosome='15', genomic_nucleotide_accession_version='NC_000081.6', start_position_on_the_genomic_accession=4727067, end_position_on_the_genomic_accession=4804045, orientation='plus', exon_count=18, OMIM=[], no_hdr0=''),
    12279 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=12279, CurrentID=0, Status='live', Symbol='C9', Aliases=[], description='complement component 9', other_designations='complement component C9', map_location='15 A1', chromosome='15', genomic_nucleotide_accession_version='NC_000081.6', start_position_on_the_genomic_accession=6445346, end_position_on_the_genomic_accession=6498825, orientation='plus', exon_count=12, OMIM=[], no_hdr0=''),
    12282 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=12282, CurrentID=0, Status='live', Symbol='Hyou1', Aliases=['AI415631', 'CBP-14', 'CBP-140', 'Cab14', 'Cab140', 'Grp1', 'Grp170', 'Orp', 'Orp150'], description='hypoxia up-regulated 1', other_designations='hypoxia up-regulated protein 1|140 kDa Ca(2+)-binding protein|150-kDa oxygen regulated protein|170 kDa glucose regulated protein GRP170|GRP-170|calcium binding protein 140|calcium binding protein, 140 kDa', map_location='9 A5.2', chromosome='9', genomic_nucleotide_accession_version='NC_000075.6', start_position_on_the_genomic_accession=44379490, end_position_on_the_genomic_accession=44392369, orientation='plus', exon_count=26, OMIM=[], no_hdr0=''),
    12283 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=12283, CurrentID=0, Status='live', Symbol='Cab39', Aliases=['39kD', 'AA408805', 'AA960512', 'C78372', 'MO25', 'MO25alpha'], description='calcium binding protein 39', other_designations='calcium-binding protein 39|calcium binding protein, 39 kDa', map_location='1 C5', chromosome='1', genomic_nucleotide_accession_version='NC_000067.6', start_position_on_the_genomic_accession=85793441, end_position_on_the_genomic_accession=85851577, orientation='plus', exon_count=11, OMIM=[], no_hdr0=''),
    12286 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=12286, CurrentID=0, Status='live', Symbol='Cacna1a', Aliases=['APCA', 'BI', 'Caca1a', 'Cacn', 'Cacnl1a4', 'Cav2.1', 'Ccha', 'Ccha1a', 'EA2', 'FHM', 'HPCA', 'MHP', 'MHP1', 'SC', 'SCA6', 'al', 'alpha1A', 'la', 'nmf35', 'nmf352', 'rkr', 's', 'smrl', 'tg'], description='calcium channel, voltage-dependent, P/Q type, alpha 1A subunit', other_designations='voltage-dependent P/Q-type calcium channel subunit alpha-1A|brain calcium channel I|calcium channel, L type, alpha-1 polypeptide|leaner|rocker|tottering|voltage-gated calcium channel subunit alpha Cav2.1', map_location='8 40.95 cM', chromosome='8', genomic_nucleotide_accession_version='NC_000074.6', start_position_on_the_genomic_accession=84338631, end_position_on_the_genomic_accession=84640251, orientation='plus', exon_count=53, OMIM=[], no_hdr0=''),
    12287 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=12287, CurrentID=0, Status='live', Symbol='Cacna1b', Aliases=['AW050276', 'AW060892', 'AW822256', 'BIII', 'Cav2', 'Cav2.2', 'Cchn', 'Cchn1a', 'alpha(1B)'], description='calcium channel, voltage-dependent, N type, alpha 1B subunit', other_designations='voltage-dependent N-type calcium channel subunit alpha-1B|brain calcium channel III|calcium channel, L type, alpha-1 polypeptide|calcium channel, voltage-dependent, L type, alpha 1B subunit|calcium channel, voltage-dependent, N type, alpha 1B subunit, BIII|voltage-gated calcium channel subunit alpha Cav2.2', map_location='2 16.58 cM', chromosome='2', genomic_nucleotide_accession_version='NC_000068.7', start_position_on_the_genomic_accession=24603860, end_position_on_the_genomic_accession=24763200, orientation='minus', exon_count=52, OMIM=[], no_hdr0=''),
    12288 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=12288, CurrentID=0, Status='live', Symbol='Cacna1c', Aliases=['Cav1', 'Cav1.2', 'Cchl1', 'Cchl1a1', 'D930026N18Rik', 'MBC', 'MELC-CC'], description='calcium channel, voltage-dependent, L type, alpha 1C subunit', other_designations='voltage-dependent L-type calcium channel subunit alpha-1C|brain class C|calcium channel voltage-dependent alpha1c subunit|neuronal voltage-gated calcium channel alpha 1C subunit|skeletal muscle-specific calcium channel|voltage-gated calcium channel subunit alpha Cav1.2', map_location='6 55.86 cM', chromosome='6', genomic_nucleotide_accession_version='NC_000072.6', start_position_on_the_genomic_accession=118587240, end_position_on_the_genomic_accession=119197384, orientation='minus', exon_count=53, OMIM=[], no_hdr0=''),
    12289 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=12289, CurrentID=0, Status='live', Symbol='Cacna1d', Aliases=['8430418G19Rik', 'C79217', 'Cach3', 'Cacn', 'Cacn4', 'Cacnl1a2', 'Cav1.3', 'Cchl', 'Cchl1', 'Cchl1a', 'Cchl1a2', 'D-LTC', 'D-LTCC'], description='calcium channel, voltage-dependent, L type, alpha 1D subunit', other_designations='voltage-dependent L-type calcium channel subunit alpha-1D|Cav1.3alpha1|alpha 1 E|calcium channel, L type, alpha-1 polypeptide|voltage-gated calcium channel subunit alpha Cav1.3', map_location='14 B', chromosome='14', genomic_nucleotide_accession_version='NC_000080.6', start_position_on_the_genomic_accession=30039941, end_position_on_the_genomic_accession=30491156, orientation='minus', exon_count=54, OMIM=[], no_hdr0=''),
    12290 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=12290, CurrentID=0, Status='live', Symbol='Cacna1e', Aliases=['A430040I15', 'BII', 'Cach6', 'Cacnl1a6', 'Cav2', 'Cav2.3', 'Cchr', 'Cchra1', 'alp', 'alpha1E'], description='calcium channel, voltage-dependent, R type, alpha 1E subunit', other_designations='voltage-dependent R-type calcium channel subunit alpha-1E|brain calcium channel II|calcium channel, L type, alpha-1 polypeptide|calcium channel, voltage-dependent, L type, alpha 1E subunit|voltage-gated calcium channel subunit alpha Cav2.3', map_location='1 66.14 cM', chromosome='1', genomic_nucleotide_accession_version='NC_000067.6', start_position_on_the_genomic_accession=154390806, end_position_on_the_genomic_accession=154884785, orientation='minus', exon_count=56, OMIM=[], no_hdr0=''),
    12291 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=12291, CurrentID=0, Status='live', Symbol='Cacna1g', Aliases=['Cav3.', 'Cav3.1d', '[a]1G', 'a1', 'a1G', 'alpha-1G', 'mKIAA1123'], description='calcium channel, voltage-dependent, T type, alpha 1G subunit', other_designations='voltage-dependent T-type calcium channel subunit alpha-1G', map_location='11 D', chromosome='11', genomic_nucleotide_accession_version='NC_000077.6', start_position_on_the_genomic_accession=94408391, end_position_on_the_genomic_accession=94474400, orientation='minus', exon_count=40, OMIM=[], no_hdr0=''),
    12292 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=12292, CurrentID=0, Status='live', Symbol='Cacna1s', Aliases=['AW493108', 'Cav1', 'Cav1.1', 'Cchl1', 'Cchl1a3', 'DHPR', 'DHPR alpha1s', 'fmd', 'mdg', 's', 'sj'], description='calcium channel, voltage-dependent, L type, alpha 1S subunit', other_designations='voltage-dependent L-type calcium channel subunit alpha-1S|dihydropyridine receptor alpha 1S|muscle dysgenesis|voltage-gated calcium channel subunit alpha Cav1.1', map_location='1 59.55 cM', chromosome='1', genomic_nucleotide_accession_version='NC_000067.6', start_position_on_the_genomic_accession=136052806, end_position_on_the_genomic_accession=136119822, orientation='plus', exon_count=44, OMIM=[], no_hdr0=''),
    12293 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=12293, CurrentID=0, Status='live', Symbol='Cacna2d1', Aliases=['Ca(v)alpha2delta1', 'Cac', 'Cacna2', 'Cchl', 'Cchl2a'], description='calcium channel, voltage-dependent, alpha2/delta subunit 1', other_designations='voltage-dependent calcium channel subunit alpha-2/delta-1|dihydropyridine-sensitive calcium channel alpha 2|voltage-dependent calcium channel alpha2/delta-1|voltage-gated calcium channel subunit alpha-2/delta-1', map_location='5 6.56 cM', chromosome='5', genomic_nucleotide_accession_version='NC_000071.6', start_position_on_the_genomic_accession=15934264, end_position_on_the_genomic_accession=16374511, orientation='plus', exon_count=44, OMIM=[], no_hdr0=''),
    12294 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=12294, CurrentID=0, Status='live', Symbol='Cacna2d3', Aliases=['Cacnad3', 'alapha2delta3'], description='calcium channel, voltage-dependent, alpha2/delta subunit 3', other_designations='voltage-dependent calcium channel subunit alpha-2/delta-3|alpha 2 delta-3|voltage-dependent calcium channel alpha2/delta-3 transcript|voltage-gated calcium channel subunit alpha-2/delta-3', map_location='14 A3', chromosome='14', genomic_nucleotide_accession_version='NC_000080.6', start_position_on_the_genomic_accession=28904943, end_position_on_the_genomic_accession=29722775, orientation='minus', exon_count=39, OMIM=[], no_hdr0=''),
    12295 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=12295, CurrentID=0, Status='live', Symbol='Cacnb1', Aliases=['CAB1', 'Cchb1', 'Cchlb', 'Cchlb1'], description='calcium channel, voltage-dependent, beta 1 subunit', other_designations='voltage-dependent L-type calcium channel subunit beta-1|calcium channel voltage-dependent subunit beta 1|voltage-dependent calcium channel beta1 subunit', map_location='11 61.5 cM', chromosome='11', genomic_nucleotide_accession_version='NC_000077.6', start_position_on_the_genomic_accession=98001508, end_position_on_the_genomic_accession=98023034, orientation='minus', exon_count=18, OMIM=[], no_hdr0=''),
    12296 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=12296, CurrentID=0, Status='live', Symbol='Cacnb2', Aliases=['AW060387', 'CAB2', 'Cavbe', 'Cavbeta2', 'Cchb2'], description='calcium channel, voltage-dependent, beta 2 subunit', other_designations='voltage-dependent L-type calcium channel subunit beta-2|voltage-gated calcium channel beta2 subunit transcript variant X13', map_location='2 10.7 cM', chromosome='2', genomic_nucleotide_accession_version='NC_000068.7', start_position_on_the_genomic_accession=14603861, end_position_on_the_genomic_accession=14988811, orientation='plus', exon_count=19, OMIM=[], no_hdr0=''),
    12297 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=12297, CurrentID=0, Status='live', Symbol='Cacnb3', Aliases=['Beta3', 'CAB3', 'Ca(v)beta3', 'Cchb3'], description='calcium channel, voltage-dependent, beta 3 subunit', other_designations='voltage-dependent L-type calcium channel subunit beta-3|calcium channel voltage-dependent subunit beta 3', map_location='15 54.64 cM', chromosome='15', genomic_nucleotide_accession_version='NC_000081.6', start_position_on_the_genomic_accession=98628436, end_position_on_the_genomic_accession=98644536, orientation='plus', exon_count=20, OMIM=[], no_hdr0=''),
    12298 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=12298, CurrentID=0, Status='live', Symbol='Cacnb4', Aliases=['3110038O15Rik', 'Cchb4', 'lh'], description='calcium channel, voltage-dependent, beta 4 subunit', other_designations='voltage-dependent L-type calcium channel subunit beta-4|CAB4|calcium channel voltage-dependent subunit beta 4', map_location='2 29.98 cM', chromosome='2', genomic_nucleotide_accession_version='NC_000068.7', start_position_on_the_genomic_accession=52428320, end_position_on_the_genomic_accession=52676609, orientation='minus', exon_count=16, OMIM=[], no_hdr0=''),
    12299 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=12299, CurrentID=0, Status='live', Symbol='Cacng1', Aliases=[], description='calcium channel, voltage-dependent, gamma subunit 1', other_designations='voltage-dependent calcium channel gamma-1 subunit|dihydropyridine receptor gamma 1|dihydropyridine-sensitive L-type, skeletal muscle calcium channel subunit gamma', map_location='11 E1', chromosome='11', genomic_nucleotide_accession_version='NC_000077.6', start_position_on_the_genomic_accession=107703218, end_position_on_the_genomic_accession=107716476, orientation='minus', exon_count=4, OMIM=[], no_hdr0=''),
    12300 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=12300, CurrentID=0, Status='live', Symbol='Cacng2', Aliases=['AW060990', 'B230105C07Rik', 'B930041E13Rik', 'sta', 'stargazer', 'stargazin', 'stg', 'wag', 'waggler'], description='calcium channel, voltage-dependent, gamma subunit 2', other_designations='voltage-dependent calcium channel gamma-2 subunit|TARP gamma-2|neuronal voltage-gated calcium channel gamma-2 subunit|transmembrane AMPAR regulatory protein gamma-2', map_location='15 36.92 cM', chromosome='15', genomic_nucleotide_accession_version='NC_000081.6', start_position_on_the_genomic_accession=77991919, end_position_on_the_genomic_accession=78120220, orientation='minus', exon_count=4, OMIM=[], no_hdr0=''),
    12301 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=12301, CurrentID=0, Status='live', Symbol='Cacybp', Aliases=['SIP'], description='calcyclin binding protein', other_designations='calcyclin-binding protein|siah-interacting protein', map_location='1 H2.1', chromosome='1', genomic_nucleotide_accession_version='NC_000067.6', start_position_on_the_genomic_accession=160202367, end_position_on_the_genomic_accession=160212892, orientation='minus', exon_count=6, OMIM=[], no_hdr0=''),
    12304 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=12304, CurrentID=0, Status='live', Symbol='Pdia4', Aliases=['AI987846', 'C', 'Cai', 'ERp', 'ERp-72', 'Erp72'], description='protein disulfide isomerase associated 4', other_designations='protein disulfide-isomerase A4|ER protein 72|calcium binding protein, intestinal|endoplasmic reticulum protein 72|endoplasmic reticulum resident protein 72', map_location='6 22.94 cM', chromosome='6', genomic_nucleotide_accession_version='NC_000072.6', start_position_on_the_genomic_accession=47796141, end_position_on_the_genomic_accession=47813512, orientation='minus', exon_count=11, OMIM=[], no_hdr0=''),
    12305 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=12305, CurrentID=0, Status='live', Symbol='Ddr1', Aliases=['6030432F18', 'AI323681', 'CD167', 'CD167a', 'Ca', 'Cak', 'Nep', 'PTK3A'], description='discoidin domain receptor family, member 1', other_designations='epithelial discoidin domain-containing receptor 1|CD167 antigen-like family member A|cell adhesion kinase|discoidin receptor tyrosine kinase|epithelial discoidin domain receptor 1|protein-tyrosine kinase MPK-6|tyrosine kinase DDR|tyrosine-protein kinase CAK', map_location='17 18.7 cM', chromosome='17', genomic_nucleotide_accession_version='NC_000083.6', start_position_on_the_genomic_accession=35681567, end_position_on_the_genomic_accession=35704741, orientation='minus', exon_count=26, OMIM=[], no_hdr0=''),
    12306 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=12306, CurrentID=0, Status='live', Symbol='Anxa2', Aliases=['AW215814', 'Cal', 'Cal1h'], description='annexin A2', other_designations='annexin A2|33-kDa calcimedin|33-kDa lymphocyte Ca<2+>- binding protein|33kDa lymphocyte Ca<2+>- binding protein|36-kDa calelectrin|PAP-IV|annexin II|annexin-2|calpactin I heavy chain|calpactin-1 heavy chain|chromobindin-8|lipocortin II|p36|placental anticoagulant protein IV|protein I', map_location='9 38.58 cM', chromosome='9', genomic_nucleotide_accession_version='NC_000075.6', start_position_on_the_genomic_accession=69453683, end_position_on_the_genomic_accession=69491792, orientation='plus', exon_count=14, OMIM=[], no_hdr0=''),
    12307 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=12307, CurrentID=0, Status='live', Symbol='Calb1', Aliases=['Bra', 'Brain-2', 'CB', 'Ca', 'Calb', 'Calb-1', 'cal'], description='calbindin 1', other_designations='calbindin|CalbindinD28K|D-28K|PCD-29|calbindin 1, 28kDa|calbindin D28|calbindin-28K|calbindin-D (28k)|spot 35 protein|vitamin D-dependent calcium-binding protein, avian-type', map_location='4 6.66 cM', chromosome='4', genomic_nucleotide_accession_version='NC_000070.6', start_position_on_the_genomic_accession=15881264, end_position_on_the_genomic_accession=15906709, orientation='plus', exon_count=11, OMIM=[], no_hdr0=''),
    12308 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=12308, CurrentID=0, Status='live', Symbol='Calb2', Aliases=['C', 'CR', 'cal'], description='calbindin 2', other_designations='calretinin', map_location='8 D3', chromosome='8', genomic_nucleotide_accession_version='NC_000074.6', start_position_on_the_genomic_accession=110142526, end_position_on_the_genomic_accession=110168212, orientation='minus', exon_count=11, OMIM=[], no_hdr0=''),
    12309 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=12309, CurrentID=0, Status='live', Symbol='S100g', Aliases=['AU042539', 'CAB', 'CABP1', 'CaBP-D', 'CaBP-D9K', 'Cabp9k', 'Cal', 'Calb3'], description='S100 calcium binding protein G', other_designations="protein S100-G|CABP|calbindin 3, (vitamin D-dependent calcium binding protein)|calbindin D9k|calbindin-D9K major form|cytidine 5'-triphosphate synthase 2|vitamin D-dependent calcium-binding protein, intestinal", map_location='X F4', chromosome='X', genomic_nucleotide_accession_version='NC_000086.7', start_position_on_the_genomic_accession=162961992, end_position_on_the_genomic_accession=162964599, orientation='minus', exon_count=3, OMIM=[], no_hdr0=''),
    12310 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=12310, CurrentID=0, Status='live', Symbol='Calca', Aliases=['C', 'CA', 'CGRP-1', 'CGRP1', 'Calc', 'Calc1', 'Cg', 'Cgrp', 'Ct', 'Ctn'], description='calcitonin/calcitonin-related polypeptide, alpha', other_designations='calcitonin gene-related peptide 1|alpha-type CGRP|calcitonin gene-related peptide I', map_location='7 59.99 cM', chromosome='7', genomic_nucleotide_accession_version='NC_000073.6', start_position_on_the_genomic_accession=114625981, end_position_on_the_genomic_accession=114636910, orientation='minus', exon_count=7, OMIM=[], no_hdr0=''),
    12311 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=12311, CurrentID=0, Status='live', Symbol='Calcr', Aliases=['C', 'Clr', 'Ct-r'], description='calcitonin receptor', other_designations='calcitonin receptor', map_location='6 1.81 cM', chromosome='6', genomic_nucleotide_accession_version='NC_000072.6', start_position_on_the_genomic_accession=3685678, end_position_on_the_genomic_accession=3764713, orientation='minus', exon_count=17, OMIM=[], no_hdr0=''),
    12313 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=12313, CurrentID=0, Status='live', Symbol='Calm1', Aliases=['AI256814', 'AI327027', 'AI461935', 'AL024000', 'CaM', 'Calm', 'Cam1'], description='calmodulin 1', other_designations='calmodulin-1', map_location='12 E', chromosome='12', genomic_nucleotide_accession_version='NC_000078.6', start_position_on_the_genomic_accession=100199435, end_position_on_the_genomic_accession=100209824, orientation='plus', exon_count=7, OMIM=[], no_hdr0=''),
    12314 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=12314, CurrentID=0, Status='live', Symbol='Calm2', Aliases=['1500001E21Rik', 'AL024017', 'Cam2', 'CamC'], description='calmodulin 2', other_designations='calmodulin-2|caM', map_location='17 E4', chromosome='17', genomic_nucleotide_accession_version='NC_000083.6', start_position_on_the_genomic_accession=87433401, end_position_on_the_genomic_accession=87446935, orientation='minus', exon_count=6, OMIM=[], no_hdr0=''),
    12315 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=12315, CurrentID=0, Status='live', Symbol='Calm3', Aliases=['CaMA', 'Cam3', 'Camc', 'R75142'], description='calmodulin 3', other_designations='calmodulin-3|caM', map_location='7 9.15 cM', chromosome='7', genomic_nucleotide_accession_version='NC_000073.6', start_position_on_the_genomic_accession=16915379, end_position_on_the_genomic_accession=16924032, orientation='minus', exon_count=6, OMIM=[], no_hdr0=''),
    12316 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=12316, CurrentID=0, Status='live', Symbol='Aspm', Aliases=['A', 'Calm', 'Calmbp1', 'D330028K02Rik', 'MCPH', 'MCPH5', 'Sh', 'Sha1'], description='abnormal spindle microtubule assembly', other_designations='abnormal spindle-like microcephaly-associated protein homolog|asp (abnormal spindle)-like, microcephaly associated|calmodulin-binding protein 1|calmodulin-binding protein Sha1|spindle and hydroxyurea checkpoint abnormal protein', map_location='1 E4-F', chromosome='1', genomic_nucleotide_accession_version='NC_000067.6', start_position_on_the_genomic_accession=139454188, end_position_on_the_genomic_accession=139494088, orientation='plus', exon_count=29, OMIM=[], no_hdr0=''),
    12317 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=12317, CurrentID=0, Status='live', Symbol='Calr', Aliases=['CR', 'CRTegulin', 'Calr'], description='calreticulin', other_designations='calreticulin|CRP55|ERp60|HACBP|endoplasmic reticulum resident protein 60', map_location='8 41.21 cM', chromosome='8', genomic_nucleotide_accession_version='NC_000074.6', start_position_on_the_genomic_accession=84842088, end_position_on_the_genomic_accession=84846931, orientation='minus', exon_count=9, OMIM=[], no_hdr0=''),
    12319 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=12319, CurrentID=0, Status='live', Symbol='Car8', Aliases=['AW546993', 'C', 'Ca', 'Ca8', 'Cals', 'Cals1', 'Carp', 'wd', 'wdl'], description='carbonic anhydrase 8', other_designations='carbonic anhydrase-related protein|CA-RP VIII|CA-VIII|carbonic anhydrase VIII|carbonic anhydrase-like sequence 1', map_location='4 3.53 cM', chromosome='4', genomic_nucleotide_accession_version='NC_000070.6', start_position_on_the_genomic_accession=8141493, end_position_on_the_genomic_accession=8239041, orientation='minus', exon_count=9, OMIM=[], no_hdr0=''),
    12321 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=12321, CurrentID=0, Status='live', Symbol='Calu', Aliases=['9530075H20Rik'], description='calumenin', other_designations='calumenin|crocalbin', map_location='6 A3.3', chromosome='6', genomic_nucleotide_accession_version='NC_000072.6', start_position_on_the_genomic_accession=29348106, end_position_on_the_genomic_accession=29376675, orientation='plus', exon_count=8, OMIM=[], no_hdr0=''),
    12322 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=12322, CurrentID=0, Status='live', Symbol='Camk2a', Aliases=['CaMKII', 'R74975', 'mKIAA0968'], description='calcium/calmodulin-dependent protein kinase II alpha', other_designations='calcium/calmodulin-dependent protein kinase type II subunit alpha|CaMK II|alpha-CaMKII|caM kinase II subunit alpha|caMK-II subunit alpha', map_location='18 34.41 cM', chromosome='18', genomic_nucleotide_accession_version='NC_000084.6', start_position_on_the_genomic_accession=60925307, end_position_on_the_genomic_accession=60988152, orientation='plus', exon_count=19, OMIM=[], no_hdr0=''),
    12323 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=12323, CurrentID=0, Status='live', Symbol='Camk2b', Aliases=['CaMKII'], description='calcium/calmodulin-dependent protein kinase II, beta', other_designations='calcium/calmodulin-dependent protein kinase type II subunit beta|CaMK II|caM kinase II subunit beta|caMK-II subunit beta', map_location='11 3.89 cM', chromosome='11', genomic_nucleotide_accession_version='NC_000077.6', start_position_on_the_genomic_accession=5969629, end_position_on_the_genomic_accession=6066357, orientation='minus', exon_count=26, OMIM=[], no_hdr0=''),
    12325 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=12325, CurrentID=0, Status='live', Symbol='Camk2g', Aliases=['Camk', 'Camkg'], description='calcium/calmodulin-dependent protein kinase II gamma', other_designations='calcium/calmodulin-dependent protein kinase type II subunit gamma|Ca2+/calmodulin-dependent protein kinase II|CaMK II|caMK-II subunit gamma', map_location='14 A3', chromosome='14', genomic_nucleotide_accession_version='NC_000080.6', start_position_on_the_genomic_accession=20734873, end_position_on_the_genomic_accession=20794157, orientation='minus', exon_count=24, OMIM=[], no_hdr0=''),
    12326 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=12326, CurrentID=0, Status='live', Symbol='Camk4', Aliases=['A430110E23Rik', 'AI666733', 'CaM', 'CaMKI', 'CaMKIV', 'CaMKIV/Gr', 'D18Bwg0362e'], description='calcium/calmodulin-dependent protein kinase IV', other_designations='calcium/calmodulin-dependent protein kinase type IV|CAM kinase-GR|Ca2+/calmodulin-dependent protein kinase type IV/Gr|caMK IV', map_location='18 18.15 cM', chromosome='18', genomic_nucleotide_accession_version='NC_000084.6', start_position_on_the_genomic_accession=32934941, end_position_on_the_genomic_accession=33195767, orientation='plus', exon_count=16, OMIM=[], no_hdr0=''),
    12328 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=12328, CurrentID=0, Status='live', Symbol='Caml', Aliases=['AI385748', 'Cag', 'Caml'], description='calcium modulating ligand', other_designations='calcium signal-modulating cyclophilin ligand', map_location='13 30.06 cM', chromosome='13', genomic_nucleotide_accession_version='NC_000079.6', start_position_on_the_genomic_accession=55623005, end_position_on_the_genomic_accession=55632416, orientation='plus', exon_count=4, OMIM=[], no_hdr0=''),
    12330 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=12330, CurrentID=0, Status='live', Symbol='Canx', Aliases=['1110069N15Rik', 'AI988026', 'CN', 'Cnx', 'D11Ertd153e'], description='calnexin', other_designations='calnexin', map_location='11 30.46 cM', chromosome='11', genomic_nucleotide_accession_version='NC_000077.6', start_position_on_the_genomic_accession=50293957, end_position_on_the_genomic_accession=50325673, orientation='minus', exon_count=15, OMIM=[], no_hdr0=''),
    12331 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=12331, CurrentID=0, Status='live', Symbol='Cap1', Aliases=[], description='CAP, adenylate cyclase-associated protein 1 (yeast)', other_designations='adenylyl cyclase-associated protein 1|adenylyl cyclase-associated CAP protein, yeast homolog 1', map_location='4 D2.2', chromosome='4', genomic_nucleotide_accession_version='NC_000070.6', start_position_on_the_genomic_accession=122859048, end_position_on_the_genomic_accession=122886076, orientation='minus', exon_count=13, OMIM=[], no_hdr0=''),
    12332 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=12332, CurrentID=0, Status='live', Symbol='Capg', Aliases=['gCap', 'gCap39', 'mbh1'], description='capping protein (actin filament), gelsolin-like', other_designations='macrophage-capping protein|actin regulatory protein CAP-G|actin-capping protein GCAP39|myc basic motif homolog 1', map_location='6 C1', chromosome='6', genomic_nucleotide_accession_version='NC_000072.6', start_position_on_the_genomic_accession=72538282, end_position_on_the_genomic_accession=72562983, orientation='plus', exon_count=15, OMIM=[], no_hdr0=''),
    12333 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=12333, CurrentID=0, Status='live', Symbol='Capn1', Aliases=['Ca', 'Cap', 'Capa-1', 'Capa1', 'mu-c', 'mu-calpin'], description='calpain 1', other_designations='calpain-1 catalytic subunit|CANP 1|calcium-activated neutral proteinase 1|calpain mu-type|calpain-1 large subunit|micromolar-calpain|mu-calpain|muCANP', map_location='19 4.34 cM', chromosome='19', genomic_nucleotide_accession_version='NC_000085.6', start_position_on_the_genomic_accession=5988545, end_position_on_the_genomic_accession=6015825, orientation='minus', exon_count=23, OMIM=[], no_hdr0=''),
    12334 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=12334, CurrentID=0, Status='live', Symbol='Capn2', Aliases=['AI326419', 'CALP80', 'Ca', 'Cap', 'Capa-2', 'Capa2', 'm-c', 'm-calpain', 'm-calpin'], description='calpain 2', other_designations='calpain-2 catalytic subunit|80 kDa M-calpain subunit|CANP 2|calcium-activated neutral proteinase 2|calpain M-type|calpain-2 large subunit|cysteine proteinase|m-calpain 80 kDa large subunit|m-calpain large subunit|millimolar-calpain', map_location='1 H5', chromosome='1', genomic_nucleotide_accession_version='NC_000067.6', start_position_on_the_genomic_accession=182467253, end_position_on_the_genomic_accession=182517610, orientation='minus', exon_count=21, OMIM=[], no_hdr0=''),
    12335 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=12335, CurrentID=0, Status='live', Symbol='Capn3', Aliases=['AI323605', 'Ca', 'Cap', 'Capa-3', 'Capa3', 'Lp', 'Lp82', 'p9', 'p94'], description='calpain 3', other_designations='calpain-3|CANP 3|calcium-activated neutral proteinase 3|calpain L3|calpain p94|muscle-specific calcium-activated neutral protease 3|skeletal muscle specific calpain p94', map_location='2 60.31 cM', chromosome='2', genomic_nucleotide_accession_version='NC_000068.7', start_position_on_the_genomic_accession=120463593, end_position_on_the_genomic_accession=120504919, orientation='plus', exon_count=25, OMIM=[], no_hdr0=''),
    12336 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=12336, CurrentID=0, Status='live', Symbol='Capns1', Aliases=['Ca', 'Cap', 'Capa-4', 'Capa4', 'Capn4', 'Cdps', 'Css1', 'D7Ertd146', 'D7Ertd146e'], description='calpain, small subunit 1', other_designations='calpain small subunit 1|CANP small subunit|calcium-activated neutral proteinase small subunit|calcium-dependent protease small subunit 1|calpain 4|calpain regulatory subunit', map_location='7 17.31 cM', chromosome='7', genomic_nucleotide_accession_version='NC_000073.6', start_position_on_the_genomic_accession=30186934, end_position_on_the_genomic_accession=30198883, orientation='minus', exon_count=14, OMIM=[], no_hdr0=''),
    12337 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=12337, CurrentID=0, Status='live', Symbol='Capn5', Aliases=['nCL-3'], description='calpain 5', other_designations='calpain-5|new calpain 3', map_location='7 E1', chromosome='7', genomic_nucleotide_accession_version='NC_000073.6', start_position_on_the_genomic_accession=98121559, end_position_on_the_genomic_accession=98178946, orientation='minus', exon_count=21, OMIM=[], no_hdr0=''),
    12338 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=12338, CurrentID=0, Status='live', Symbol='Capn6', Aliases=[], description='calpain 6', other_designations='calpain-6', map_location='X F2', chromosome='X', genomic_nucleotide_accession_version='NC_000086.7', start_position_on_the_genomic_accession=143802236, end_position_on_the_genomic_accession=143827412, orientation='minus', exon_count=13, OMIM=[], no_hdr0=''),
    12339 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=12339, CurrentID=0, Status='live', Symbol='Capn7', Aliases=['AU022319', 'Pa', 'PalBH'], description='calpain 7', other_designations='calpain-7|palB homolog', map_location='14 B', chromosome='14', genomic_nucleotide_accession_version='NC_000080.6', start_position_on_the_genomic_accession=31336622, end_position_on_the_genomic_accession=31371987, orientation='plus', exon_count=22, OMIM=[], no_hdr0=''),
    12340 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=12340, CurrentID=0, Status='live', Symbol='Capza1', Aliases=['CAPZ', 'CAZ1', 'Ca', 'Cappa1', 'capZ alpha-1'], description='capping protein (actin filament) muscle Z-line, alpha 1', other_designations='F-actin-capping protein subunit alpha-1|F-actin capping protein alpha-1 subunit|capping protein alpha 1', map_location='3 45.88 cM', chromosome='3', genomic_nucleotide_accession_version='NC_000069.6', start_position_on_the_genomic_accession=104822781, end_position_on_the_genomic_accession=104864505, orientation='minus', exon_count=10, OMIM=[], no_hdr0=''),
    12343 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=12343, CurrentID=0, Status='live', Symbol='Capza2', Aliases=['1110053K06Rik', 'AW208808', 'Ca', 'Cappa2'], description='capping protein (actin filament) muscle Z-line, alpha 2', other_designations='F-actin-capping protein subunit alpha-2|capZ alpha-2|capping protein alpha 2', map_location='6 7.96 cM', chromosome='6', genomic_nucleotide_accession_version='NC_000072.6', start_position_on_the_genomic_accession=17637010, end_position_on_the_genomic_accession=17666972, orientation='plus', exon_count=10, OMIM=[], no_hdr0=''),
    12344 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=12344, CurrentID=0, Status='live', Symbol='Capza3', Aliases=['510-4', 'Ca', 'Cappa3', 'Gsg', 'Gsg3', 'Tex8', 'rep', 'repro32'], description='capping protein (actin filament) muscle Z-line, alpha 3', other_designations='F-actin-capping protein subunit alpha-3|capZ alpha-3|capping protein alpha 3|cp alpha3|germ cell-specific protein 3', map_location='6 69.77 cM', chromosome='6', genomic_nucleotide_accession_version='NC_000072.6', start_position_on_the_genomic_accession=140041557, end_position_on_the_genomic_accession=140042837, orientation='plus', exon_count=1, OMIM=[], no_hdr0=''),
    12345 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=12345, CurrentID=0, Status='live', Symbol='Capzb', Aliases=['1700120C01Rik', 'AI325129', 'CPB', 'CPB1', 'CPB2', 'CPbeat2', 'CPbet', 'CPbeta1', 'CPbeta2', 'Cap', 'Cappb1'], description='capping protein (actin filament) muscle Z-line, beta', other_designations='F-actin-capping protein subunit beta|capZ beta|capping protein beta 1', map_location='4 70.59 cM', chromosome='4', genomic_nucleotide_accession_version='NC_000070.6', start_position_on_the_genomic_accession=139192899, end_position_on_the_genomic_accession=139291820, orientation='plus', exon_count=11, OMIM=[], no_hdr0=''),
    12346 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=12346, CurrentID=0, Status='live', Symbol='Car1', Aliases=['AW555628', 'Ca1', 'Car', 'Car-1'], description='carbonic anhydrase 1', other_designations='carbonic anhydrase 1|CA-I|carbonate dehydratase I|carbonic anhydrase I', map_location='3 3.18 cM', chromosome='3', genomic_nucleotide_accession_version='NC_000069.6', start_position_on_the_genomic_accession=14766214, end_position_on_the_genomic_accession=14808365, orientation='minus', exon_count=9, OMIM=[], no_hdr0=''),
    12348 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=12348, CurrentID=0, Status='live', Symbol='Car11', Aliases=['Ca11'], description='carbonic anhydrase 11', other_designations='carbonic anhydrase-related protein 11|CA-RP II|CA-RP XI|CA-XI|CARP XI|CARP-2|carbonic anhydrase-related protein 2', map_location='7 B3', chromosome='7', genomic_nucleotide_accession_version='NC_000073.6', start_position_on_the_genomic_accession=45699171, end_position_on_the_genomic_accession=45704687, orientation='plus', exon_count=8, OMIM=[], no_hdr0=''),
    12349 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=12349, CurrentID=0, Status='live', Symbol='Car2', Aliases=['AI131712', 'C', 'CAII', 'Ca2', 'Car', 'Car-2', 'Ltw-', 'Ltw-5', 'Lvtw', 'Lvtw-5'], description='carbonic anhydrase 2', other_designations='carbonic anhydrase 2|carbonate dehydratase II|carbonic anhydrase II', map_location='3 3.23 cM', chromosome='3', genomic_nucleotide_accession_version='NC_000069.6', start_position_on_the_genomic_accession=14886269, end_position_on_the_genomic_accession=14900770, orientation='plus', exon_count=7, OMIM=[], no_hdr0=''),
    12350 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=12350, CurrentID=0, Status='live', Symbol='Car3', Aliases=['BB219044', 'Ca3', 'Car', 'Car-3'], description='carbonic anhydrase 3', other_designations='carbonic anhydrase 3|CA-III|carbonate dehydratase III|carbonic anhydrase III', map_location='3 3.22 cM', chromosome='3', genomic_nucleotide_accession_version='NC_000069.6', start_position_on_the_genomic_accession=14863538, end_position_on_the_genomic_accession=14872381, orientation='plus', exon_count=7, OMIM=[], no_hdr0=''),
    12351 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=12351, CurrentID=0, Status='live', Symbol='Car4', Aliases=['AW456718', 'Ca4'], description='carbonic anhydrase 4', other_designations='carbonic anhydrase 4|CA-IV|carbonate dehydratase IV|carbonic anhydrase IV', map_location='11 C', chromosome='11', genomic_nucleotide_accession_version='NC_000077.6', start_position_on_the_genomic_accession=84957754, end_position_on_the_genomic_accession=84966054, orientation='plus', exon_count=8, OMIM=[], no_hdr0=''),
    12352 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=12352, CurrentID=0, Status='live', Symbol='Car5a', Aliases=['CAV', 'Ca', 'Ca5a', 'Car5'], description='carbonic anhydrase 5a, mitochondrial', other_designations='carbonic anhydrase 5A, mitochondrial|CA Y|CA-VA|carbonate dehydratase VA|carbonic anhydrase 5, mitochondrial|carbonic anhydrase 5b, mitochondrial|carbonic anhydrase VA', map_location='8 70.81 cM', chromosome='8', genomic_nucleotide_accession_version='NC_000074.6', start_position_on_the_genomic_accession=121916135, end_position_on_the_genomic_accession=121944912, orientation='minus', exon_count=7, OMIM=[], no_hdr0=''),
    12353 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=12353, CurrentID=0, Status='live', Symbol='Car6', Aliases=['Ca6', 'DOC', 'DOC1'], description='carbonic anhydrase 6', other_designations='carbonic anhydrase 6|CA-VI|carbonate dehydratase VI|carbonic anhydrase VI|salivary carbonic anhydrase|secreted carbonic anhydrase', map_location='4 E2', chromosome='4', genomic_nucleotide_accession_version='NC_000070.6', start_position_on_the_genomic_accession=150187015, end_position_on_the_genomic_accession=150201135, orientation='minus', exon_count=8, OMIM=[], no_hdr0=''),
    12354 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=12354, CurrentID=0, Status='live', Symbol='Car7', Aliases=['AV343731', 'Ca7'], description='carbonic anhydrase 7', other_designations='carbonic anhydrase 7|CA-VII|carbonate dehydratase VII|carbonic anhydrase VII', map_location='8 D3', chromosome='8', genomic_nucleotide_accession_version='NC_000074.6', start_position_on_the_genomic_accession=104534694, end_position_on_the_genomic_accession=104550347, orientation='plus', exon_count=13, OMIM=[], no_hdr0=''),
    12355 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=12355, CurrentID=0, Status='live', Symbol='Nr1i3', Aliases=['AA209988', 'AI551208', 'C', 'CA', 'CAR', 'CAR-beta', 'Care2', 'ESTM3', 'ESTM32', 'MB67', 'mC'], description='nuclear receptor subfamily 1, group I, member 3', other_designations='nuclear receptor subfamily 1 group I member 3|constitutive androstane receptor|constitutively transactivates RAREs|orphan nuclear receptor MB67', map_location='1 79.21 cM', chromosome='1', genomic_nucleotide_accession_version='NC_000067.6', start_position_on_the_genomic_accession=171213934, end_position_on_the_genomic_accession=171218845, orientation='plus', exon_count=9, OMIM=[], no_hdr0=''),
    12359 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=12359, CurrentID=0, Status='live', Symbol='Cat', Aliases=['2210418N07', 'Ca', 'Cas', 'Cas-1', 'Cas1', 'Cs-', 'Cs-1'], description='catalase', other_designations='catalase|catalase 1', map_location='2 54.43 cM', chromosome='2', genomic_nucleotide_accession_version='NC_000068.7', start_position_on_the_genomic_accession=103453904, end_position_on_the_genomic_accession=103485153, orientation='minus', exon_count=13, OMIM=[], no_hdr0=''),
    12361 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=12361, CurrentID=0, Status='live', Symbol='Cask', Aliases=['DXP', 'DXPri1', 'DXRi', 'DXRib1', 'LI', 'LIN-2', 'P', 'Pals3', 'mLi', 'mLin-2'], description='calcium/calmodulin-dependent serine protein kinase (MAGUK family)', other_designations='peripheral plasma membrane protein CASK', map_location='X 8.43 cM', chromosome='X', genomic_nucleotide_accession_version='NC_000086.7', start_position_on_the_genomic_accession=13517080, end_position_on_the_genomic_accession=13846783, orientation='minus', exon_count=28, OMIM=[], no_hdr0=''),
    12362 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=12362, CurrentID=0, Status='live', Symbol='Casp1', Aliases=['Casp', 'IC', 'ICE', 'Il1', 'Il1bc'], description='caspase 1', other_designations='caspase-1|CASP-1|IL-1 beta-converting enzyme|IL-1B converting enzyme|IL-1BC|interleukin-1 beta convertase|interleukin-1 beta-converting enzyme|p45', map_location='9 2.46 cM', chromosome='9', genomic_nucleotide_accession_version='NC_000075.6', start_position_on_the_genomic_accession=5298517, end_position_on_the_genomic_accession=5307281, orientation='plus', exon_count=10, OMIM=[], no_hdr0=''),
    12363 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=12363, CurrentID=0, Status='live', Symbol='Casp4', Aliases=['CASP-11', 'CASP-4', 'Cas', 'Casp11', 'Caspa', 'Caspl', 'ich-', 'ich-3'], description='caspase 4, apoptosis-related cysteine peptidase', other_designations='caspase-4|caspase 11, apoptosis-related cysteine peptidase|caspase 11, apoptosis-related cysteine protease|caspase 4, apoptosis-related cysteine protease|caspase-11 short form splicing|protease ICH-3', map_location='9 2.46 cM', chromosome='9', genomic_nucleotide_accession_version='NC_000075.6', start_position_on_the_genomic_accession=5308849, end_position_on_the_genomic_accession=5336791, orientation='plus', exon_count=9, OMIM=[], no_hdr0=''),
    12364 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=12364, CurrentID=0, Status='live', Symbol='Casp12', Aliases=[], description='caspase 12', other_designations='caspase-12|CASP-12', map_location='9 2.46 cM', chromosome='9', genomic_nucleotide_accession_version='NC_000075.6', start_position_on_the_genomic_accession=5345442, end_position_on_the_genomic_accession=5373034, orientation='plus', exon_count=11, OMIM=[], no_hdr0=''),
    12365 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=12365, CurrentID=0, Status='live', Symbol='Casp14', Aliases=['MIC', 'MICE', 'mini', 'mini-ICE'], description='caspase 14', other_designations='caspase-14|CASP-14', map_location='10 C1', chromosome='10', genomic_nucleotide_accession_version='NC_000076.6', start_position_on_the_genomic_accession=78711995, end_position_on_the_genomic_accession=78718347, orientation='minus', exon_count=7, OMIM=[], no_hdr0=''),
    12366 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=12366, CurrentID=0, Status='live', Symbol='Casp2', Aliases=['CASP-2', 'Casp', 'ICH-1', 'Ich-', 'NEDD-2', 'Nedd', 'Nedd2'], description='caspase 2', other_designations='caspase-2|neural precursor cell expressed developmentally down-regulated protein 2|protease ICH-1', map_location='6 20.54 cM', chromosome='6', genomic_nucleotide_accession_version='NC_000072.6', start_position_on_the_genomic_accession=42264902, end_position_on_the_genomic_accession=42282508, orientation='plus', exon_count=12, OMIM=[], no_hdr0=''),
    12367 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=12367, CurrentID=0, Status='live', Symbol='Casp3', Aliases=['A830040C14Rik', 'AC-', 'AC-3', 'CASP-3', 'CC3', 'CPP', 'CPP-32', 'CPP32', 'Casp', 'Caspase-3', 'Lice', 'SCA-1', 'Ya', 'Yama', 'mld', 'mldy'], description='caspase 3', other_designations='caspase-3|SREBP cleavage activity 1|apopain|caspase 3, apoptosis related cysteine protease|cysteine protease CPP32|protein Yama', map_location='8 26.39 cM', chromosome='8', genomic_nucleotide_accession_version='NC_000074.6', start_position_on_the_genomic_accession=46617291, end_position_on_the_genomic_accession=46639698, orientation='plus', exon_count=8, OMIM=[], no_hdr0=''),
    12368 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=12368, CurrentID=0, Status='live', Symbol='Casp6', Aliases=['CASP-6', 'Mch2', 'mCAS'], description='caspase 6', other_designations='caspase-6|apoptotic protease Mch-2', map_location='3 G3', chromosome='3', genomic_nucleotide_accession_version='NC_000069.6', start_position_on_the_genomic_accession=129901415, end_position_on_the_genomic_accession=129914112, orientation='plus', exon_count=7, OMIM=[], no_hdr0=''),
    12369 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=12369, CurrentID=0, Status='live', Symbol='Casp7', Aliases=['AI314680', 'CMH-1', 'ICE-', 'ICE-IAP3', 'Mch3', 'casp', 'caspase-7', 'mCASP-7'], description='caspase 7', other_designations='caspase-7|CASP-7|apoptotic protease Mch-3|cysteine protease LICE2', map_location='19 51.84 cM', chromosome='19', genomic_nucleotide_accession_version='NC_000085.6', start_position_on_the_genomic_accession=56396833, end_position_on_the_genomic_accession=56442348, orientation='plus', exon_count=8, OMIM=[], no_hdr0=''),
    12370 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=12370, CurrentID=0, Status='live', Symbol='Casp8', Aliases=['CASP-8', 'Casp', 'FLI', 'FLICE', 'MAC', 'MACH', 'Mch5'], description='caspase 8', other_designations='caspase-8|Fas-linked ICE-like protease', map_location='1 29.19 cM', chromosome='1', genomic_nucleotide_accession_version='NC_000067.6', start_position_on_the_genomic_accession=58795233, end_position_on_the_genomic_accession=58847503, orientation='plus', exon_count=11, OMIM=[], no_hdr0=''),
    12371 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=12371, CurrentID=0, Status='live', Symbol='Casp9', Aliases=['AI115399', 'APAF-3', 'AW493809', 'CASP-9', 'Casp', 'Caspase-9', 'ICE-', 'ICE-LAP6', 'Mch6'], description='caspase 9', other_designations='caspase-9|ICE-like apoptotic protease 6|apoptotic protease Mch-6|apoptotic protease-activating factor 3', map_location='4 E1', chromosome='4', genomic_nucleotide_accession_version='NC_000070.6', start_position_on_the_genomic_accession=141793612, end_position_on_the_genomic_accession=141815978, orientation='plus', exon_count=9, OMIM=[], no_hdr0=''),
    12372 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=12372, CurrentID=0, Status='live', Symbol='Casq1', Aliases=['CS', 'CSQ', 'CSQ-', 'CSQ-1', 'CSQ1', 'sC', 'sCSQ'], description='calsequestrin 1', other_designations='calsequestrin-1|calmitine', map_location='1 79.54 cM', chromosome='1', genomic_nucleotide_accession_version='NC_000067.6', start_position_on_the_genomic_accession=172209894, end_position_on_the_genomic_accession=172219895, orientation='minus', exon_count=11, OMIM=[], no_hdr0=''),
    12373 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=12373, CurrentID=0, Status='live', Symbol='Casq2', Aliases=['AA033488', 'AW146219', 'Csq', 'Csq2', 'ESTM5', 'ESTM52', 'cCS', 'cCSQ'], description='calsequestrin 2', other_designations='calsequestrin-2|cardiac calsequestrin', map_location='3 F2.2', chromosome='3', genomic_nucleotide_accession_version='NC_000069.6', start_position_on_the_genomic_accession=102086415, end_position_on_the_genomic_accession=102146514, orientation='plus', exon_count=12, OMIM=[], no_hdr0=''),
    12374 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=12374, CurrentID=0, Status='live', Symbol='Casr', Aliases=['C', 'CaR', 'Gpr', 'Gprc2a'], description='calcium-sensing receptor', other_designations='extracellular calcium-sensing receptor|G protein-coupled receptor, family C, group 2, member A|PCaR1|cation sensing receptor|parathyroid cell calcium-sensing receptor', map_location='16 25.57 cM', chromosome='16', genomic_nucleotide_accession_version='NC_000082.6', start_position_on_the_genomic_accession=36490585, end_position_on_the_genomic_accession=36562141, orientation='minus', exon_count=11, OMIM=[], no_hdr0=''),
    12380 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=12380, CurrentID=0, Status='live', Symbol='Cast', Aliases=[], description='calpastatin', other_designations='calpastatin|calpain inhibitor|calpastatin type III', map_location='13 C1', chromosome='13', genomic_nucleotide_accession_version='NC_000079.6', start_position_on_the_genomic_accession=74692366, end_position_on_the_genomic_accession=74808874, orientation='minus', exon_count=35, OMIM=[], no_hdr0=''),
    12385 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=12385, CurrentID=0, Status='live', Symbol='Ctnna1', Aliases=['2010010M04Rik', 'AA517462', 'AI988031', 'Cat', 'Catna1'], description='catenin (cadherin associated protein), alpha 1', other_designations='catenin alpha-1|102 kDa cadherin-associated protein|CAP102|alpha E-catenin|cadherin associated protein', map_location='18 18.89 cM', chromosome='18', genomic_nucleotide_accession_version='NC_000084.6', start_position_on_the_genomic_accession=35118902, end_position_on_the_genomic_accession=35254776, orientation='plus', exon_count=20, OMIM=[], no_hdr0=''),
    12386 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=12386, CurrentID=0, Status='live', Symbol='Ctnna2', Aliases=['AI481747', 'Ca', 'Cat', 'Catna', 'Catna2', 'cdf', 'ch', 'chp'], description='catenin (cadherin associated protein), alpha 2', other_designations='catenin alpha-2|alpha(N)-catenin|cadherin associated protein|cerebellar deficient folia', map_location='6 33.54 cM', chromosome='6', genomic_nucleotide_accession_version='NC_000072.6', start_position_on_the_genomic_accession=76881637, end_position_on_the_genomic_accession=77979815, orientation='minus', exon_count=21, OMIM=[], no_hdr0=''),
    12387 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=12387, CurrentID=0, Status='live', Symbol='Ctnnb1', Aliases=['Bfc', 'Cat', 'Catnb', 'Mesc'], description='catenin (cadherin associated protein), beta 1', other_designations='catenin beta-1|beta-catenin', map_location='9 72.19 cM', chromosome='9', genomic_nucleotide_accession_version='NC_000075.6', start_position_on_the_genomic_accession=120933400, end_position_on_the_genomic_accession=120960507, orientation='plus', exon_count=15, OMIM=[], no_hdr0=''),
    12388 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=12388, CurrentID=0, Status='live', Symbol='Ctnnd1', Aliases=['AA409437', 'AU019353', 'Ca', 'Catns', 'Ctn', 'Ctnnd', 'P12', 'P120', 'mKIAA0384'], description='catenin (cadherin associated protein), delta 1', other_designations='catenin delta-1|CAS|cadherin-associated Src substrate|catenin src|p120 catenin|p120(cas)|p120(ctn)', map_location='2 49.45 cM', chromosome='2', genomic_nucleotide_accession_version='NC_000068.7', start_position_on_the_genomic_accession=84587096, end_position_on_the_genomic_accession=84658977, orientation='minus', exon_count=24, OMIM=[], no_hdr0=''),
    12389 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=12389, CurrentID=0, Status='live', Symbol='Cav1', Aliases=['Cav', 'Cav-1', 'cave'], description='caveolin 1, caveolae protein', other_designations='caveolin-1|caveolin, caveolae protein 1|caveolin, caveolae protein, 22 kDa', map_location='6 A2', chromosome='6', genomic_nucleotide_accession_version='NC_000072.6', start_position_on_the_genomic_accession=17306335, end_position_on_the_genomic_accession=17341328, orientation='plus', exon_count=6, OMIM=[], no_hdr0=''),
    12390 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=12390, CurrentID=0, Status='live', Symbol='Cav2', Aliases=['AI447843'], description='caveolin 2', other_designations='caveolin-2', map_location='6 A2', chromosome='6', genomic_nucleotide_accession_version='NC_000072.6', start_position_on_the_genomic_accession=17281185, end_position_on_the_genomic_accession=17289130, orientation='plus', exon_count=3, OMIM=[], no_hdr0=''),
    12391 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=12391, CurrentID=0, Status='live', Symbol='Cav3', Aliases=['AI385751', 'Cav', 'Cav-3', 'M-ca', 'M-cav'], description='caveolin 3', other_designations='caveolin-3|M-caveolin', map_location='6 52.26 cM', chromosome='6', genomic_nucleotide_accession_version='NC_000072.6', start_position_on_the_genomic_accession=112459505, end_position_on_the_genomic_accession=112472872, orientation='plus', exon_count=2, OMIM=[], no_hdr0=''),
    12393 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=12393, CurrentID=0, Status='live', Symbol='Runx2', Aliases=['AM', 'AML3', 'Cbf', 'Cbfa', 'Cbfa-1', 'Cbfa1', 'LS3', 'Os', 'Osf2', 'PEB', 'PEBP2aA', 'Pebp2a1', 'Pebpa2a'], description='runt related transcription factor 2', other_designations='runt-related transcription factor 2|AKV core binding factor|CBF-alpha-1|PEA2-alpha A|PEBP2 alpha A|SL3-3 enhancer factor 1 alpha A subunit|acute myeloid leukemia 3 protein|core binding factor alpha 1|osteoblast-specific transcription factor 2|polyomavirus enhancer-binding protein 2 alpha A subunit|runt domain, alpha subunit 1', map_location='17 21.33 cM', chromosome='17', genomic_nucleotide_accession_version='NC_000083.6', start_position_on_the_genomic_accession=44495987, end_position_on_the_genomic_accession=44814797, orientation='minus', exon_count=10, OMIM=[], no_hdr0=''),
    12394 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=12394, CurrentID=0, Status='live', Symbol='Runx1', Aliases=['AM', 'AML1', 'CBF-alpha-2', 'Cbfa', 'Cbfa2', 'Pebp', 'Pebp2a2', 'Pebpa2b'], description='runt related transcription factor 1', other_designations='runt-related transcription factor 1|SL3-3 enhancer factor 1 alpha B subunit|SL3/AKV core-binding factor alpha B subunit|acute myeloid leukemia 1 protein|core binding factor alpha 2|core-binding factor subunit alpha-2|oncogene AML-1|polyomavirus enhancer-binding protein 2 alpha B subunit|runt domain, alpha subunit 2', map_location='16 53.7 cM', chromosome='16', genomic_nucleotide_accession_version='NC_000082.6', start_position_on_the_genomic_accession=92601466, end_position_on_the_genomic_accession=92826074, orientation='minus', exon_count=8, OMIM=[], no_hdr0=''),
    12395 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=12395, CurrentID=0, Status='live', Symbol='Runx1t1', Aliases=['Cbfa2t1', 'Cbfa2t1h', 'ET', 'ETO', 'MTG8'], description='RUNX1 translocation partner 1', other_designations='protein CBFA2T1|CBFA2T1 identified gene homolog|acute myelogenous leukemia 1 translocation 1 protein|runt-related transcription factor 1; translocated to, 1 (cyclin D-related)', map_location='4 5.88 cM', chromosome='4', genomic_nucleotide_accession_version='NC_000070.6', start_position_on_the_genomic_accession=13742628, end_position_on_the_genomic_accession=13895056, orientation='plus', exon_count=17, OMIM=[], no_hdr0=''),
    12396 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=12396, CurrentID=0, Status='live', Symbol='Cbfa2t2', Aliases=['A430091M07', 'C330013D05Rikh', 'MTGR', 'MTGR1', 'Cbfa2t2'], description='CBFA2/RUNX1 translocation partner 2', other_designations='protein CBFA2T2|CBFA2T2 identified gene homolog|MTG8-like protein|MTG8-related protein 1|core-binding factor, runt domain, alpha subunit 2, translocated to, 2 homolog', map_location='2 H1', chromosome='2', genomic_nucleotide_accession_version='NC_000068.7', start_position_on_the_genomic_accession=154436098, end_position_on_the_genomic_accession=154539356, orientation='plus', exon_count=12, OMIM=[], no_hdr0=''),
    12398 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=12398, CurrentID=0, Status='live', Symbol='Cbfa2t3', Aliases=['A630044F12Rik', 'AI465270', 'AW229127h', 'ETO-', 'ETO-2', 'Eto', 'Eto2', 'MTGR', 'MTGR2', 'Cbfa2t3'], description='CBFA2/RUNX1 translocation partner 3', other_designations='protein CBFA2T3|ETO/MTG8-related protein ETO-2|MTG8-related protein 2|eight twenty one protein 2|myeloid translocation gene-related protein 2', map_location='8 E1', chromosome='8', genomic_nucleotide_accession_version='NC_000074.6', start_position_on_the_genomic_accession=122625136, end_position_on_the_genomic_accession=122699332, orientation='minus', exon_count=15, OMIM=[], no_hdr0=''),
    12399 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=12399, CurrentID=0, Status='live', Symbol='Runx3', Aliases=['AM', 'AML2', 'Cbfa', 'Cbfa3', 'Pebp2a3', 'Rx', 'Rx3'], description='runt related transcription factor 3', other_designations='runt-related transcription factor 3|CBF-alpha-3|PEA2-alpha C|PEBP2-alpha C|SL3-3 enhancer factor 1 alpha C subunit|SL3/AKV core-binding factor alpha C subunit|acute myeloid leukemia 2 protein|core binding factor alpha 3|core-binding factor subunit alpha-3|oncogene AML-2|polyomavirus enhancer-binding protein 2 alpha C subunit|runt domain, alpha subunit 3|transcription factor AML2/CBFA3', map_location='4 67.19 cM', chromosome='4', genomic_nucleotide_accession_version='NC_000070.6', start_position_on_the_genomic_accession=135120645, end_position_on_the_genomic_accession=135177990, orientation='plus', exon_count=7, OMIM=[], no_hdr0=''),
    12400 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=12400, CurrentID=0, Status='live', Symbol='Cbfb', Aliases=['AI893578', 'PE', 'PEA2', 'PEBP2b', 'Peb', 'Pebp', 'Pebp2', 'Pebpb2'], description='core binding factor beta', other_designations='core-binding factor subunit beta|CBF-beta|PEA2-beta|PEBP2-beta|SL3-3 enhancer factor 1 subunit beta|SL3/AKV core-binding factor beta subunit|polyomavirus enhancer-binding protein 2 beta subunit', map_location='8 53.04 cM', chromosome='8', genomic_nucleotide_accession_version='NC_000074.6', start_position_on_the_genomic_accession=105170674, end_position_on_the_genomic_accession=105217989, orientation='plus', exon_count=6, OMIM=[], no_hdr0=''),
    12401 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=12401, CurrentID=0, Status='live', Symbol='Serpina6', Aliases=['Cbg'], description='serine (or cysteine) peptidase inhibitor, clade A, member 6', other_designations='corticosteroid-binding globulin|serine (or cysteine) proteinase inhibitor, clade A, member 6|serpin A6|transcortin', map_location='12 52.98 cM', chromosome='12', genomic_nucleotide_accession_version='NC_000078.6', start_position_on_the_genomic_accession=103646630, end_position_on_the_genomic_accession=103657218, orientation='minus', exon_count=5, OMIM=[], no_hdr0=''),
    12402 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=12402, CurrentID=0, Status='live', Symbol='Cbl', Aliases=['4732447J05Rik-', 'Cbl-2', 'c-Cb', 'c-Cbl', 'cbl', 'Cbl'], description='Casitas B-lineage lymphoma', other_designations='E3 ubiquitin-protein ligase CBL|RING-type E3 ubiquitin transferase CBL|casitas B-lineage lymphoma proto-oncogene|proto-oncogene c-CBL|signal transduction protein CBL', map_location='9 24.72 cM', chromosome='9', genomic_nucleotide_accession_version='NC_000075.6', start_position_on_the_genomic_accession=44142976, end_position_on_the_genomic_accession=44234259, orientation='minus', exon_count=17, OMIM=[], no_hdr0=''),
    12404 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=12404, CurrentID=0, Status='live', Symbol='Cbln1', Aliases=['AI323299'], description='cerebellin 1 precursor protein', other_designations='cerebellin-1|brain protein D3|precerebellin', map_location='8 42.16 cM', chromosome='8', genomic_nucleotide_accession_version='NC_000074.6', start_position_on_the_genomic_accession=87468853, end_position_on_the_genomic_accession=87472592, orientation='minus', exon_count=3, OMIM=[], no_hdr0=''),
    12405 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=12405, CurrentID=0, Status='live', Symbol='Cbln2', Aliases=['6330593N19Rik', 'A730004O05'], description='cerebellin 2 precursor protein', other_designations='cerebellin-2', map_location='18 58.63 cM', chromosome='18', genomic_nucleotide_accession_version='NC_000084.6', start_position_on_the_genomic_accession=86711061, end_position_on_the_genomic_accession=86718283, orientation='plus', exon_count=7, OMIM=[], no_hdr0=''),
    12406 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=12406, CurrentID=0, Status='live', Symbol='Serpinh1', Aliases=['BERF-1', 'Cbp', 'Cbp1', 'Cbp2', 'Hsp', 'Hsp47', 'J6', 'Ser', 'Serpinh2', 'co', 'gp4', 'gp46'], description='serine (or cysteine) peptidase inhibitor, clade H, member 1', other_designations='serpin H1|47 kDa heat shock protein|beta enolase repressor factor 1|collagen binding protein 1|colligin|serine (or cysteine) proteinase inhibitor, clade H (heat shock protein 47), member 1|serine (or cysteine) proteinase inhibitor, clade H (heat shock protein 47), member 2|serine protease inhibitor J6', map_location='7 E1', chromosome='7', genomic_nucleotide_accession_version='NC_000073.6', start_position_on_the_genomic_accession=99345375, end_position_on_the_genomic_accession=99353239, orientation='minus', exon_count=7, OMIM=[], no_hdr0=''),
    12408 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=12408, CurrentID=0, Status='live', Symbol='Cbr1', Aliases=['AW261796', 'C', 'CR', 'Cbr', 'PG-9-KR'], description='carbonyl reductase 1', other_designations='carbonyl reductase [NADPH] 1|15-hydroxyprostaglandin dehydrogenase|20-beta-hydroxysteroid dehydrogenase|Carbonyl reductase [NADPH] 1 (NADPH-dependent carbonyl reductase 1)|NADPH-dependent carbonyl reductase 1|prostaglandin 9-ketoreductase|prostaglandin-E(2) 9-reductase', map_location='16 54.53 cM', chromosome='16', genomic_nucleotide_accession_version='NC_000082.6', start_position_on_the_genomic_accession=93607837, end_position_on_the_genomic_accession=93610349, orientation='plus', exon_count=3, OMIM=[], no_hdr0=''),
    12409 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=12409, CurrentID=0, Status='live', Symbol='Cbr2', Aliases=['ML', 'MLCR'], description='carbonyl reductase 2', other_designations='carbonyl reductase [NADPH] 2|AP27|LCR|NADPH-dependent carbonyl reductase 2|adipocyte protein P27|lung carbonyl reductase', map_location='11 84.47 cM', chromosome='11', genomic_nucleotide_accession_version='NC_000077.6', start_position_on_the_genomic_accession=120729485, end_position_on_the_genomic_accession=120732025, orientation='minus', exon_count=8, OMIM=[], no_hdr0=''),
    12411 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=12411, CurrentID=0, Status='live', Symbol='Cbs', Aliases=['AI047524', 'AI303044', 'HI', 'HIP4'], description='cystathionine beta-synthase', other_designations='cystathionine beta-synthase|beta-thionase|serine sulfhydrase', map_location='17 16.93 cM', chromosome='17', genomic_nucleotide_accession_version='NC_000083.6', start_position_on_the_genomic_accession=31612623, end_position_on_the_genomic_accession=31637233, orientation='minus', exon_count=18, OMIM=[], no_hdr0=''),
    12412 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=12412, CurrentID=0, Status='live', Symbol='Cbx1', Aliases=['Cbx', 'Cbx-r', 'Cbx-rs2', 'E430007M08Rik', 'HP1', 'HP1B', 'Hp1be', 'Hp1beta', 'M31', 'MOD', 'MOD1'], description='chromobox 1', other_designations='chromobox protein homolog 1|chromobox homolog 1|heterochromatin protein 1 homolog beta|heterochromatin protein p25|modifier 1 protein', map_location='11 60.11 cM', chromosome='11', genomic_nucleotide_accession_version='NC_000077.6', start_position_on_the_genomic_accession=96788680, end_position_on_the_genomic_accession=96808982, orientation='plus', exon_count=7, OMIM=[], no_hdr0=''),
    12416 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=12416, CurrentID=0, Status='live', Symbol='Cbx2', Aliases=['M33', 'MOD2', 'pc'], description='chromobox 2', other_designations='chromobox protein homolog 2|M33 polycomb-like protein|chromobox homolog 2|modifier 3 protein|polycomb', map_location='11 83.33 cM', chromosome='11', genomic_nucleotide_accession_version='NC_000077.6', start_position_on_the_genomic_accession=119023019, end_position_on_the_genomic_accession=119031275, orientation='plus', exon_count=6, OMIM=[], no_hdr0=''),
    12417 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=12417, CurrentID=0, Status='live', Symbol='Cbx3', Aliases=['HP1', 'HP1g', 'M32'], description='chromobox 3', other_designations='chromobox protein homolog 3|HP1 gamma|heterochromatin protein 1 gamma|heterochromatin protein 1 homolog gamma|modifier 2 protein', map_location='6 24.89 cM', chromosome='6', genomic_nucleotide_accession_version='NC_000072.6', start_position_on_the_genomic_accession=51470154, end_position_on_the_genomic_accession=51483704, orientation='plus', exon_count=7, OMIM=[], no_hdr0=''),
    12418 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=12418, CurrentID=0, Status='live', Symbol='Cbx4', Aliases=['MPc', 'MPc2', 'PC', 'PC2'], description='chromobox 4', other_designations='E3 SUMO-protein ligase CBX4|E3 SUMO-protein transferase CBX4|chromobox homolog 4|chromobox protein homolog 4|polycomb 2 homolog', map_location='11 83.34 cM', chromosome='11', genomic_nucleotide_accession_version='NC_000077.6', start_position_on_the_genomic_accession=119077571, end_position_on_the_genomic_accession=119086237, orientation='minus', exon_count=5, OMIM=[], no_hdr0=''),
    12419 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=12419, CurrentID=0, Status='live', Symbol='Cbx5', Aliases=['2610029O15Rik', 'C75991', 'HP', 'HP1', 'Hp1a', 'Hp1alpha'], description='chromobox 5', other_designations='chromobox protein homolog 5|HP1 alpha|chromobox homolog 5|heterochromatin protein 1 alpha|heterochromatin protein 1 homolog alpha|mHP1(alpha)', map_location='15 F3', chromosome='15', genomic_nucleotide_accession_version='NC_000081.6', start_position_on_the_genomic_accession=103191546, end_position_on_the_genomic_accession=103239904, orientation='minus', exon_count=7, OMIM=[], no_hdr0=''),
    12421 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=12421, CurrentID=0, Status='live', Symbol='Rb1cc1', Aliases=['2900055E04Rik', '5930404L04Rik', 'Cc1', 'FIP200', 'Fip2', 'LaXp', 'LaXp180'], description='RB1-inducible coiled-coil 1', other_designations='RB1-inducible coiled-coil protein 1|200 kDa FAK family kinase-interacting protein|FAK family kinase-interacting protein of 200 kDa|coiled-coil-forming protein 1', map_location='1 A1', chromosome='1', genomic_nucleotide_accession_version='NC_000067.6', start_position_on_the_genomic_accession=6214634, end_position_on_the_genomic_accession=6276375, orientation='plus', exon_count=26, OMIM=[], no_hdr0=''),
    12424 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=12424, CurrentID=0, Status='live', Symbol='Cck', Aliases=[], description='cholecystokinin', other_designations='cholecystokinin', map_location='9 F4', chromosome='9', genomic_nucleotide_accession_version='NC_000075.6', start_position_on_the_genomic_accession=121489824, end_position_on_the_genomic_accession=121495694, orientation='minus', exon_count=5, OMIM=[], no_hdr0=''),
    12425 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=12425, CurrentID=0, Status='live', Symbol='Cckar', Aliases=['AW106902'], description='cholecystokinin A receptor', other_designations='cholecystokinin receptor type A|CCK-A receptor|CCK-AR|CCK1-R|cholecystokinin-1 receptor', map_location='5 29.52 cM', chromosome='5', genomic_nucleotide_accession_version='NC_000071.6', start_position_on_the_genomic_accession=53698485, end_position_on_the_genomic_accession=53707704, orientation='minus', exon_count=5, OMIM=[], no_hdr0=''),
    12426 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=12426, CurrentID=0, Status='live', Symbol='Cckbr', Aliases=['CCK-BR', 'CCK2', 'CCK2-R', 'CCK2R', 'CCKR-', 'CCKR-2'], description='cholecystokinin B receptor', other_designations='gastrin/cholecystokinin type B receptor|CCK-B receptor|CCK-B/gastrin receptor|CCK2/gastrin receptor|cholecystokinin-2 receptor', map_location='7 55.86 cM', chromosome='7', genomic_nucleotide_accession_version='NC_000073.6', start_position_on_the_genomic_accession=105425676, end_position_on_the_genomic_accession=105436339, orientation='plus', exon_count=5, OMIM=[], no_hdr0=''),
    12427 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=12427, CurrentID=0, Status='live', Symbol='Ccna1', Aliases=[], description='cyclin A1', other_designations='cyclin-A1', map_location='3 C', chromosome='3', genomic_nucleotide_accession_version='NC_000069.6', start_position_on_the_genomic_accession=55045469, end_position_on_the_genomic_accession=55057634, orientation='minus', exon_count=10, OMIM=[], no_hdr0=''),
    12428 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=12428, CurrentID=0, Status='live', Symbol='Ccna2', Aliases=['AA408589', 'Cc', 'Ccn', 'Ccn-', 'Ccn-1', 'Ccn1', 'Ccna', 'Cyc', 'CycA2', 'Cyca'], description='cyclin A2', other_designations='cyclin-A2|Cyclin A2 (Cyclin A)|cyclin-A', map_location='3 17.67 cM', chromosome='3', genomic_nucleotide_accession_version='NC_000069.6', start_position_on_the_genomic_accession=36564865, end_position_on_the_genomic_accession=36573038, orientation='minus', exon_count=9, OMIM=[], no_hdr0=''),
    12442 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=12442, CurrentID=0, Status='live', Symbol='Ccnb2', Aliases=['CycB2'], description='cyclin B2', other_designations='G2/mitotic-specific cyclin-B2', map_location='9 D', chromosome='9', genomic_nucleotide_accession_version='NC_000075.6', start_position_on_the_genomic_accession=70407689, end_position_on_the_genomic_accession=70421554, orientation='minus', exon_count=9, OMIM=[], no_hdr0=''),
    12443 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=12443, CurrentID=0, Status='live', Symbol='Ccnd1', Aliases=['AI327039', 'CycD1', 'Cyl-', 'Cyl-1', 'PR', 'PRAD1', 'bcl-', 'bcl-1', 'cD1'], description='cyclin D1', other_designations='G1/S-specific cyclin-D1', map_location='7 88.92 cM', chromosome='7', genomic_nucleotide_accession_version='NC_000073.6', start_position_on_the_genomic_accession=144929931, end_position_on_the_genomic_accession=144939831, orientation='minus', exon_count=5, OMIM=[], no_hdr0=''),
    12444 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=12444, CurrentID=0, Status='live', Symbol='Ccnd2', Aliases=['2600016F06Rik', 'AI256817', 'BF642806', 'C86853', 'V', 'Vi', 'Vin-1', 'Vin1', 'cD2'], description='cyclin D2', other_designations='G1/S-specific cyclin-D2', map_location='6 61.92 cM', chromosome='6', genomic_nucleotide_accession_version='NC_000072.6', start_position_on_the_genomic_accession=127125162, end_position_on_the_genomic_accession=127152188, orientation='minus', exon_count=7, OMIM=[], no_hdr0=''),
    12445 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=12445, CurrentID=0, Status='live', Symbol='Ccnd3', Aliases=['9230106B05Rik', 'AA682053', 'AL024085', 'AW146355', 'C78795'], description='cyclin D3', other_designations='G1/S-specific cyclin-D3', map_location='17 23.37 cM', chromosome='17', genomic_nucleotide_accession_version='NC_000083.6', start_position_on_the_genomic_accession=47505051, end_position_on_the_genomic_accession=47599689, orientation='plus', exon_count=9, OMIM=[], no_hdr0=''),
    12447 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=12447, CurrentID=0, Status='live', Symbol='Ccne1', Aliases=['AW538188', 'CycE1'], description='cyclin E1', other_designations='G1/S-specific cyclin-E1', map_location='7 25.35 cM', chromosome='7', genomic_nucleotide_accession_version='NC_000073.6', start_position_on_the_genomic_accession=38097984, end_position_on_the_genomic_accession=38107490, orientation='minus', exon_count=12, OMIM=[], no_hdr0=''),
    12448 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=12448, CurrentID=0, Status='live', Symbol='Ccne2', Aliases=[], description='cyclin E2', other_designations='G1/S-specific cyclin-E2', map_location='4 A1', chromosome='4', genomic_nucleotide_accession_version='NC_000070.6', start_position_on_the_genomic_accession=11190433, end_position_on_the_genomic_accession=11204779, orientation='plus', exon_count=14, OMIM=[], no_hdr0=''),
    12449 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=12449, CurrentID=0, Status='live', Symbol='Ccnf', Aliases=['CycF', 'Fbxo', 'Fbxo1'], description='cyclin F', other_designations='cyclin-F|G2/mitotic-specific cyclin-F', map_location='17 12.32 cM', chromosome='17', genomic_nucleotide_accession_version='NC_000083.6', start_position_on_the_genomic_accession=24223230, end_position_on_the_genomic_accession=24251409, orientation='minus', exon_count=17, OMIM=[], no_hdr0=''),
    12450 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=12450, CurrentID=0, Status='live', Symbol='Ccng1', Aliases=['AI314029'], description='cyclin G1', other_designations='cyclin-G1|cyclin-G', map_location='11 A5', chromosome='11', genomic_nucleotide_accession_version='NC_000077.6', start_position_on_the_genomic_accession=40748552, end_position_on_the_genomic_accession=40755309, orientation='minus', exon_count=6, OMIM=[], no_hdr0=''),
    12452 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=12452, CurrentID=0, Status='live', Symbol='Ccng2', Aliases=[], description='cyclin G2', other_designations='cyclin-G2', map_location='5 E2', chromosome='5', genomic_nucleotide_accession_version='NC_000071.6', start_position_on_the_genomic_accession=93267573, end_position_on_the_genomic_accession=93276231, orientation='plus', exon_count=8, OMIM=[], no_hdr0=''),
    12453 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=12453, CurrentID=0, Status='live', Symbol='Ccni', Aliases=[], description='cyclin I', other_designations='cyclin-I', map_location='5 E2', chromosome='5', genomic_nucleotide_accession_version='NC_000071.6', start_position_on_the_genomic_accession=93181933, end_position_on_the_genomic_accession=93206495, orientation='minus', exon_count=8, OMIM=[], no_hdr0=''),
    12454 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=12454, CurrentID=0, Status='live', Symbol='Ccnk', Aliases=['AW123198', 'AW413594', 'CP', 'CPR4', 'CycK'], description='cyclin K', other_designations='cyclin-K', map_location='12 59.23 cM', chromosome='12', genomic_nucleotide_accession_version='NC_000078.6', start_position_on_the_genomic_accession=108179308, end_position_on_the_genomic_accession=108203359, orientation='plus', exon_count=13, OMIM=[], no_hdr0=''),
    12455 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=12455, CurrentID=0, Status='live', Symbol='Ccnt1', Aliases=['2810478G24Rik', 'AI115585', 'CycT1'], description='cyclin T1', other_designations='cyclin-T1|cyclin-T', map_location='15 F1', chromosome='15', genomic_nucleotide_accession_version='NC_000081.6', start_position_on_the_genomic_accession=98538690, end_position_on_the_genomic_accession=98567736, orientation='minus', exon_count=10, OMIM=[], no_hdr0=''),
    12457 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=12457, CurrentID=0, Status='live', Symbol='Noct', Aliases=['AU043840', 'Ccr', 'Ccr4', 'Ccrn4l'], description='nocturnin', other_designations='nocturnin|CCR4 carbon catabolite repression 4-like|CCR4 protein homolog|carbon catabolite repression 4 homolog|carbon catabolite repression 4-like protein|circadian deadenylase NOC', map_location='3 C', chromosome='3', genomic_nucleotide_accession_version='NC_000069.6', start_position_on_the_genomic_accession=51224447, end_position_on_the_genomic_accession=51251654, orientation='plus', exon_count=4, OMIM=[], no_hdr0=''),
    12458 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=12458, CurrentID=0, Status='live', Symbol='Ccr6', Aliases=['CC-CKR-6', 'CCR-6', 'Cmkbr', 'Cmkbr6', 'KY411'], description='chemokine (C-C motif) receptor 6', other_designations='C-C chemokine receptor type 6', map_location='17 A1', chromosome='17', genomic_nucleotide_accession_version='NC_000083.6', start_position_on_the_genomic_accession=8236041, end_position_on_the_genomic_accession=8258519, orientation='plus', exon_count=9, OMIM=[], no_hdr0=''),
    12460 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=12460, CurrentID=0, Status='live', Symbol='Ccs', Aliases=['CCd', 'Ccs'], description='copper chaperone for superoxide dismutase', other_designations='copper chaperone for superoxide dismutase|superoxide dismutase copper chaperone', map_location='19 4.11 cM', chromosome='19', genomic_nucleotide_accession_version='NC_000085.6', start_position_on_the_genomic_accession=4825366, end_position_on_the_genomic_accession=4839356, orientation='minus', exon_count=8, OMIM=[], no_hdr0=''),
    12461 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=12461, CurrentID=0, Status='live', Symbol='Cct2', Aliases=['Cctb'], description='chaperonin containing Tcp1, subunit 2 (beta)', other_designations='T-complex protein 1 subunit beta|CCT-beta|TCP-1-beta|chaperonin subunit 2 (beta)', map_location='10 D2', chromosome='10', genomic_nucleotide_accession_version='NC_000076.6', start_position_on_the_genomic_accession=117050997, end_position_on_the_genomic_accession=117063852, orientation='minus', exon_count=17, OMIM=[], no_hdr0=''),
    12462 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=12462, CurrentID=0, Status='live', Symbol='Cct3', Aliases=['AL024092', 'Cctg', 'Tcp1-', 'Tcp1-rs3', 'TriC', 'TriC-P5'], description='chaperonin containing Tcp1, subunit 3 (gamma)', other_designations='T-complex protein 1 subunit gamma|CCT-gamma|TCP-1-gamma|chaperonin subunit 3 (gamma)|matricin', map_location='3 38.79 cM', chromosome='3', genomic_nucleotide_accession_version='NC_000069.6', start_position_on_the_genomic_accession=88297135, end_position_on_the_genomic_accession=88321766, orientation='plus', exon_count=14, OMIM=[], no_hdr0=''),
    12464 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=12464, CurrentID=0, Status='live', Symbol='Cct4', Aliases=['2610204B21Rik', 'A4', 'A45', 'C78323', 'Cctd'], description='chaperonin containing Tcp1, subunit 4 (delta)', other_designations='T-complex protein 1 subunit delta|CCT-delta|T complex protein 1, delta|TCP-1-delta|chaperonin subunit 4 (delta)', map_location='11 14.25 cM', chromosome='11', genomic_nucleotide_accession_version='NC_000077.6', start_position_on_the_genomic_accession=22990593, end_position_on_the_genomic_accession=23003336, orientation='plus', exon_count=14, OMIM=[], no_hdr0=''),
    12465 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=12465, CurrentID=0, Status='live', Symbol='Cct5', Aliases=['CCT-epsilon', 'Ccte', 'TCP', 'TCP-1-epsilon', 'TCPE', 'mKIAA0098'], description='chaperonin containing Tcp1, subunit 5 (epsilon)', other_designations='T-complex protein 1 subunit epsilon', map_location='15 B2', chromosome='15', genomic_nucleotide_accession_version='NC_000081.6', start_position_on_the_genomic_accession=31590800, end_position_on_the_genomic_accession=31601846, orientation='minus', exon_count=12, OMIM=[], no_hdr0=''),
    12466 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=12466, CurrentID=0, Status='live', Symbol='Cct6a', Aliases=['CCT-zeta', 'CCT-zeta-1', 'Cct6', 'Cctz-1', 'TCP-1-zeta'], description='chaperonin containing Tcp1, subunit 6a (zeta)', other_designations='T-complex protein 1 subunit zeta|chaperonin containing TCP-1|chaperonin subunit 6a (zeta)', map_location='5 G1.3', chromosome='5', genomic_nucleotide_accession_version='NC_000071.6', start_position_on_the_genomic_accession=129787356, end_position_on_the_genomic_accession=129846443, orientation='plus', exon_count=13, OMIM=[], no_hdr0=''),
    12467 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=12467, CurrentID=0, Status='live', Symbol='Cct6b', Aliases=['CCT-zeta-2', 'CCTzeta-', 'CCTzeta-2', 'Cctz-2', 'TCP-1-zeta-2'], description='chaperonin containing Tcp1, subunit 6b (zeta)', other_designations='T-complex protein 1 subunit zeta-2|chaperonin subunit 6b (zeta)', map_location='11 C', chromosome='11', genomic_nucleotide_accession_version='NC_000077.6', start_position_on_the_genomic_accession=82713112, end_position_on_the_genomic_accession=82764388, orientation='minus', exon_count=16, OMIM=[], no_hdr0=''),
    12468 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=12468, CurrentID=0, Status='live', Symbol='Cct7', Aliases=['AA408524', 'AL022769', 'Ccth', 'Cctz'], description='chaperonin containing Tcp1, subunit 7 (eta)', other_designations='T-complex protein 1 subunit eta|CCT-eta|TCP-1-eta|chaperonin containing t-complex subunit eta|chaperonin subunit 7 (eta)', map_location='6 C3', chromosome='6', genomic_nucleotide_accession_version='NC_000072.6', start_position_on_the_genomic_accession=85451505, end_position_on_the_genomic_accession=85468477, orientation='plus', exon_count=12, OMIM=[], no_hdr0=''),
    12469 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=12469, CurrentID=0, Status='live', Symbol='Cct8', Aliases=['AI132397', 'Cctq', 'Tcp', 'Tcpq'], description='chaperonin containing Tcp1, subunit 8 (theta)', other_designations='T-complex protein 1 subunit theta|CCT-theta|TCP-1-theta|chaperonin subunit 8 (theta)', map_location='16 C3.3', chromosome='16', genomic_nucleotide_accession_version='NC_000082.6', start_position_on_the_genomic_accession=87483325, end_position_on_the_genomic_accession=87495869, orientation='minus', exon_count=15, OMIM=[], no_hdr0=''),
    12475 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=12475, CurrentID=0, Status='live', Symbol='Cd14', Aliases=[], description='CD14 antigen', other_designations='monocyte differentiation antigen CD14|myeloid cell-specific leucine-rich glycoprotein', map_location='18 19.46 cM', chromosome='18', genomic_nucleotide_accession_version='NC_000084.6', start_position_on_the_genomic_accession=36725064, end_position_on_the_genomic_accession=36726815, orientation='minus', exon_count=2, OMIM=[], no_hdr0=''),
    12476 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=12476, CurrentID=0, Status='live', Symbol='Cd151', Aliases=['PETA', 'PETA-3', 'SFA', 'SFA-1', 'Tsp', 'Tspan24'], description='CD151 antigen', other_designations='CD151 antigen|GP27|membrane glycoprotein SFA-1|platelet-endothelial tetraspan antigen 3', map_location='7 86.82 cM', chromosome='7', genomic_nucleotide_accession_version='NC_000073.6', start_position_on_the_genomic_accession=141467362, end_position_on_the_genomic_accession=141471481, orientation='plus', exon_count=9, OMIM=[], no_hdr0=''),
    12477 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=12477, CurrentID=0, Status='live', Symbol='Ctla4', Aliases=['Cd152', 'Ctla', 'Ctla-4', 'Ly-5', 'Ly-56'], description='cytotoxic T-lymphocyte-associated protein 4', other_designations='cytotoxic T-lymphocyte protein 4|CD152 antigen|cytotoxic T-lymphocyte-associated antigen 4', map_location='1 30.58 cM', chromosome='1', genomic_nucleotide_accession_version='NC_000067.6', start_position_on_the_genomic_accession=60909025, end_position_on_the_genomic_accession=60915832, orientation='plus', exon_count=4, OMIM=[], no_hdr0=''),
    12478 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=12478, CurrentID=0, Status='live', Symbol='Cd19', Aliases=['AW495831'], description='CD19 antigen', other_designations='B-lymphocyte antigen CD19|differentiation antigen CD19', map_location='7 69.01 cM', chromosome='7', genomic_nucleotide_accession_version='NC_000073.6', start_position_on_the_genomic_accession=126408448, end_position_on_the_genomic_accession=126415148, orientation='minus', exon_count=14, OMIM=[], no_hdr0=''),
    12479 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=12479, CurrentID=0, Status='live', Symbol='Cd1d1', Aliases=['AI747460', 'CD1.1', 'Cd1', 'Cd1a', 'Cd1d', 'Ly-3', 'Ly-38'], description='CD1d1 antigen', other_designations='antigen-presenting glycoprotein CD1d1|T-cell surface glycoprotein CD1d1', map_location='3 37.91 cM', chromosome='3', genomic_nucleotide_accession_version='NC_000069.6', start_position_on_the_genomic_accession=86995834, end_position_on_the_genomic_accession=87012358, orientation='minus', exon_count=10, OMIM=[], no_hdr0=''),
    12480 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=12480, CurrentID=0, Status='live', Symbol='Cd1d2', Aliases=['CD1.2', 'Cd1b', 'Ly-38'], description='CD1d2 antigen', other_designations='antigen-presenting glycoprotein CD1d2|T-cell surface glycoprotein CD1d2', map_location='3 37.88 cM', chromosome='3', genomic_nucleotide_accession_version='NC_000069.6', start_position_on_the_genomic_accession=86986586, end_position_on_the_genomic_accession=86989533, orientation='plus', exon_count=6, OMIM=[], no_hdr0=''),
    12481 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=12481, CurrentID=0, Status='live', Symbol='Cd2', Aliases=['LFA', 'LFA-2', 'Ly-3', 'Ly-37', 'Ly3', 'Ly37'], description='CD2 antigen', other_designations='T-cell surface antigen CD2|LFA-3 receptor|T-cell surface antigen T11/Leu-5|lymphocyte antigen 37', map_location='3 44.17 cM', chromosome='3', genomic_nucleotide_accession_version='NC_000069.6', start_position_on_the_genomic_accession=101275908, end_position_on_the_genomic_accession=101287939, orientation='minus', exon_count=5, OMIM=[], no_hdr0=''),
    12482 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=12482, CurrentID=0, Status='live', Symbol='Ms4a1', Aliases=['AA960661', 'Cd20', 'Ly-4', 'Ly-44', 'Ms4a2'], description='membrane-spanning 4-domains, subfamily A, member 1', other_designations='B-lymphocyte antigen CD20|B-cell differentiation antigen Ly-44|CD20 antigen|lymphocyte antigen 44|membrane-spanning 4-domains, subfamily A, member 2', map_location='19 8.19 cM', chromosome='19', genomic_nucleotide_accession_version='NC_000085.6', start_position_on_the_genomic_accession=11249679, end_position_on_the_genomic_accession=11266149, orientation='minus', exon_count=7, OMIM=[], no_hdr0=''),
    12483 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=12483, CurrentID=0, Status='live', Symbol='Cd22', Aliases=['A530093D23', 'Lyb', 'Lyb-', 'Lyb-8', 'Lyb8'], description='CD22 antigen', other_designations='B-cell receptor CD22|B-lymphocyte cell adhesion molecule|BL-CAM|T-cell surface antigen Leu-14|sialic acid-binding Ig-like lectin 2|siglec-2', map_location='7 19.26 cM', chromosome='7', genomic_nucleotide_accession_version='NC_000073.6', start_position_on_the_genomic_accession=30865404, end_position_on_the_genomic_accession=30880342, orientation='minus', exon_count=17, OMIM=[], no_hdr0=''),
    12484 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=12484, CurrentID=0, Status='live', Symbol='Cd24a', Aliases=['Cd24', 'H', 'HSA', 'Ly-5', 'Ly-52', 'nect', 'nectadrin'], description='CD24a antigen', other_designations='signal transducer CD24|M1/69-J11D heat stable antigen|R13-Ag|X62 heat stable antigen|cluster of differentiation 24|heat stable antigen|lymphocyte antigen 52', map_location='10 23.01 cM', chromosome='10', genomic_nucleotide_accession_version='NC_000076.6', start_position_on_the_genomic_accession=43579169, end_position_on_the_genomic_accession=43584265, orientation='plus', exon_count=2, OMIM=[], no_hdr0=''),
    12487 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=12487, CurrentID=0, Status='live', Symbol='Cd28', Aliases=[], description='CD28 antigen', other_designations='T-cell-specific surface glycoprotein CD28', map_location='1 30.52 cM', chromosome='1', genomic_nucleotide_accession_version='NC_000067.6', start_position_on_the_genomic_accession=60746388, end_position_on_the_genomic_accession=60773359, orientation='plus', exon_count=4, OMIM=[], no_hdr0=''),
    12488 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=12488, CurrentID=0, Status='live', Symbol='Cd2ap', Aliases=['AL024079', 'C78928', 'METS-', 'METS-1', 'Mets', 'Mets1'], description='CD2-associated protein', other_designations='CD2-associated protein|SH3 domain-containing adapter protein|SH3 domain-containing adaptor protein METS-1|mesenchyme to epithelium transition protein, SH3 domains|mesenchyme-to-epithelium transition protein with SH3 domains 1', map_location='17 B3', chromosome='17', genomic_nucleotide_accession_version='NC_000083.6', start_position_on_the_genomic_accession=42748887, end_position_on_the_genomic_accession=42876707, orientation='minus', exon_count=21, OMIM=[], no_hdr0=''),
    12489 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=12489, CurrentID=0, Status='live', Symbol='Cd33', Aliases=['Sigle', 'Siglec-3', 'gp6', 'gp67'], description='CD33 antigen', other_designations='myeloid cell surface antigen CD33|sialic acid-binding Ig-like lectin 3', map_location='7 28.25 cM', chromosome='7', genomic_nucleotide_accession_version='NC_000073.6', start_position_on_the_genomic_accession=43527399, end_position_on_the_genomic_accession=43537424, orientation='minus', exon_count=9, OMIM=[], no_hdr0=''),
    12490 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=12490, CurrentID=0, Status='live', Symbol='Cd34', Aliases=['AU040960'], description='CD34 antigen', other_designations='hematopoietic progenitor cell antigen CD34|cluster designation 34', map_location='1 98.38 cM', chromosome='1', genomic_nucleotide_accession_version='NC_000067.6', start_position_on_the_genomic_accession=194938821, end_position_on_the_genomic_accession=194961292, orientation='plus', exon_count=8, OMIM=[], no_hdr0=''),
    12491 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=12491, CurrentID=0, Status='live', Symbol='Cd36', Aliases=['FA', 'FAT', 'GPIV', 'Sca', 'Scarb3'], description='CD36 molecule', other_designations='platelet glycoprotein 4|CD36 antigen|GPIIIB|PAS IV|PAS-4|fatty acid translocase|glycoprotein IIIb|platelet glycoprotein IV', map_location='5 8.11 cM', chromosome='5', genomic_nucleotide_accession_version='NC_000071.6', start_position_on_the_genomic_accession=17781690, end_position_on_the_genomic_accession=17888959, orientation='minus', exon_count=18, OMIM=[], no_hdr0=''),
    12492 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=12492, CurrentID=0, Status='live', Symbol='Scarb2', Aliases=['9330185J12Rik', 'Cd36l', 'Cd36l2', 'LGP', 'LGP85', 'LIM', 'LIMP II', 'LIMP-2', 'MLGP85'], description='scavenger receptor class B, member 2', other_designations='lysosome membrane protein 2|85 kDa lysosomal membrane sialoglycoprotein|CD36 antigen (collagen type I receptor, thrombospondin receptor)-like 2|lysosome membrane protein II', map_location='5 E2', chromosome='5', genomic_nucleotide_accession_version='NC_000071.6', start_position_on_the_genomic_accession=92441311, end_position_on_the_genomic_accession=92505657, orientation='minus', exon_count=12, OMIM=[], no_hdr0=''),
    12493 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=12493, CurrentID=0, Status='live', Symbol='Cd37', Aliases=['Tsp', 'Tspan26'], description='CD37 antigen', other_designations='leukocyte antigen CD37', map_location='7 29.2 cM', chromosome='7', genomic_nucleotide_accession_version='NC_000073.6', start_position_on_the_genomic_accession=45233632, end_position_on_the_genomic_accession=45239340, orientation='minus', exon_count=9, OMIM=[], no_hdr0=''),
    12494 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=12494, CurrentID=0, Status='live', Symbol='Cd38', Aliases=['ADPRC 1-r', 'Cd38-rs1', 'I-19', 'Cd38'], description='CD38 antigen', other_designations="ADP-ribosyl cyclase/cyclic ADP-ribose hydrolase 1|2'-phospho-ADP-ribosyl cyclase|2'-phospho-ADP-ribosyl cyclase/2'-phospho-cyclic-ADP-ribose transferase|2'-phospho-cyclic-ADP-ribose transferase|ADP-ribosyl cyclase 1|NIM-R5 antigen|cADPr hydrolase 1|cyclic ADP-ribose hydrolase 1", map_location='5 23.85 cM', chromosome='5', genomic_nucleotide_accession_version='NC_000071.6', start_position_on_the_genomic_accession=43868809, end_position_on_the_genomic_accession=43912374, orientation='plus', exon_count=8, OMIM=[], no_hdr0=''),
    12495 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=12495, CurrentID=0, Status='live', Symbol='Entpd1', Aliases=['2610206B08Rik', 'AA408691', 'Cd39', 'E130009M23Rik', 'NTPDa', 'NTPDase-1', 'ectoa'], description='ectonucleoside triphosphate diphosphohydrolase 1', other_designations='ectonucleoside triphosphate diphosphohydrolase 1|CD39 antigen|NTPDase 1|ecto-ATP diphosphohydrolase 1|ecto-ATPDase 1|ecto-ATPase 1|ectoapyrase|lymphoid cell activation antigen', map_location='19 34.25 cM', chromosome='19', genomic_nucleotide_accession_version='NC_000085.6', start_position_on_the_genomic_accession=40612366, end_position_on_the_genomic_accession=40741602, orientation='plus', exon_count=13, OMIM=[], no_hdr0=''),
    12496 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=12496, CurrentID=0, Status='live', Symbol='Entpd2', Aliases=['Cd39l', 'Cd39l1', 'NTPD', 'NTPDase2'], description='ectonucleoside triphosphate diphosphohydrolase 2', other_designations='ectonucleoside triphosphate diphosphohydrolase 2|CD39 antigen-like 1|NTPDase 2|ecto-ATP diphosphohydrolase 2|ecto-ATPDase 2|ecto-ATPase 2', map_location='2 A3', chromosome='2', genomic_nucleotide_accession_version='NC_000068.7', start_position_on_the_genomic_accession=25395874, end_position_on_the_genomic_accession=25401323, orientation='plus', exon_count=9, OMIM=[], no_hdr0=''),
    12497 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=12497, CurrentID=0, Status='live', Symbol='Entpd6', Aliases=['2700026H11Rik', 'Cd39l', 'Cd39l2', 'NTPDa', 'NTPDase-6'], description='ectonucleoside triphosphate diphosphohydrolase 6', other_designations='ectonucleoside triphosphate diphosphohydrolase 6|CD39 antigen-like 2', map_location='2 G3', chromosome='2', genomic_nucleotide_accession_version='NC_000068.7', start_position_on_the_genomic_accession=150748980, end_position_on_the_genomic_accession=150771675, orientation='plus', exon_count=17, OMIM=[], no_hdr0=''),
    12499 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=12499, CurrentID=0, Status='live', Symbol='Entpd5', Aliases=['AI196558', 'AI987697', 'Cd39l', 'Cd39l4', 'ER-UD', 'ER-UDPase', 'NTPD', 'NTPDa', 'NTPDase-5', 'NTPDase5', 'Pc', 'Pcph', 'mNT', 'mNTPase'], description='ectonucleoside triphosphate diphosphohydrolase 5', other_designations='ectonucleoside triphosphate diphosphohydrolase 5|CD39 antigen-like 4|GDPase ENTPD5|NTPDase 5|UDPase ENTPD5|guanosine-diphosphatase ENTPD5|nucleoside diphosphatase|uridine-diphosphatase ENTPD5', map_location='12 39.18 cM', chromosome='12', genomic_nucleotide_accession_version='NC_000078.6', start_position_on_the_genomic_accession=84373875, end_position_on_the_genomic_accession=84409029, orientation='minus', exon_count=17, OMIM=[], no_hdr0=''),
    12500 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=12500, CurrentID=0, Status='live', Symbol='Cd3d', Aliases=['T3d'], description='CD3 antigen, delta polypeptide', other_designations='T-cell surface glycoprotein CD3 delta chain|T-cell receptor T3 delta chain', map_location='9 24.84 cM', chromosome='9', genomic_nucleotide_accession_version='NC_000075.6', start_position_on_the_genomic_accession=44981769, end_position_on_the_genomic_accession=44987052, orientation='plus', exon_count=6, OMIM=[], no_hdr0=''),
    12501 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=12501, CurrentID=0, Status='live', Symbol='Cd3e', Aliases=['AI504783', 'CD3', 'CD3epsilon', 'T3e'], description='CD3 antigen, epsilon polypeptide', other_designations='T-cell surface glycoprotein CD3 epsilon chain|T-cell surface antigen T3/Leu-4 epsilon chain', map_location='9 24.84 cM', chromosome='9', genomic_nucleotide_accession_version='NC_000075.6', start_position_on_the_genomic_accession=44998735, end_position_on_the_genomic_accession=45009663, orientation='minus', exon_count=8, OMIM=[], no_hdr0=''),
    12502 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=12502, CurrentID=0, Status='live', Symbol='Cd3g', Aliases=['Ctg-3', 'Ctg3', 'T3g'], description='CD3 antigen, gamma polypeptide', other_designations='T-cell surface glycoprotein CD3 gamma chain|T-cell receptor T3 gamma chain', map_location='9 24.84 cM', chromosome='9', genomic_nucleotide_accession_version='NC_000075.6', start_position_on_the_genomic_accession=44969572, end_position_on_the_genomic_accession=44980431, orientation='minus', exon_count=7, OMIM=[], no_hdr0=''),
    12503 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=12503, CurrentID=0, Status='live', Symbol='Cd247', Aliases=['4930549J05Rik', 'A430104F18', 'A430104F18Rik', 'AW552088', 'CD3-et', 'CD3-zet', 'CD3zet', 'Cd3', 'Cd3-eta', 'Cd3-zeta', 'Cd3h', 'Cd3z', 'Cd3zeta', 'T3z', 'TCR', 'Tcrk', 'Tcrz'], description='CD247 antigen', other_designations='CD247 antigen|CD3 antigen, zeta polypeptide|CD3-zeta/eta|T-cell receptor T3 eta chain|T-cell surface glycoprotein CD3 zeta chain', map_location='1 73.14 cM', chromosome='1', genomic_nucleotide_accession_version='NC_000067.6', start_position_on_the_genomic_accession=165779952, end_position_on_the_genomic_accession=165871153, orientation='plus', exon_count=15, OMIM=[], no_hdr0=''),
    12504 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=12504, CurrentID=0, Status='live', Symbol='Cd4', Aliases=['L3T', 'L3T4', 'Ly-', 'Ly-4'], description='CD4 antigen', other_designations='T-cell surface glycoprotein CD4|T-cell differentiation antigen L3T4|T-cell surface antigen T4/Leu-3', map_location='6 59.17 cM', chromosome='6', genomic_nucleotide_accession_version='NC_000072.6', start_position_on_the_genomic_accession=124864693, end_position_on_the_genomic_accession=124888247, orientation='minus', exon_count=10, OMIM=[], no_hdr0=''),
    12505 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=12505, CurrentID=0, Status='live', Symbol='Cd44', Aliases=['AU023126', 'AW121933', 'AW146109', 'HERM', 'HERMES', 'Ly-2', 'Ly-24', 'Pgp', 'Pgp-1'], description='CD44 antigen', other_designations='CD44 antigen|ECMR-III|GP90 lymphocyte homing/adhesion receptor|HUTCH-I|PGP-I|extracellular matrix receptor III|hermes antigen|hyaluronate receptor|lymphocyte antigen 24|phagocytic glycoprotein 1|phagocytic glycoprotein I', map_location='2 54.13 cM', chromosome='2', genomic_nucleotide_accession_version='NC_000068.7', start_position_on_the_genomic_accession=102811141, end_position_on_the_genomic_accession=102901669, orientation='minus', exon_count=20, OMIM=[], no_hdr0=''),
    12506 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=12506, CurrentID=0, Status='live', Symbol='Cd48', Aliases=['AI449234', 'AW610730', 'BCM1', 'BLAS', 'BLAST', 'BLAST-1', 'BLAST1', 'Bcm-1', 'MEM-102', 'SLAMF2', 'Sgp-', 'Sgp-60'], description='CD48 antigen', other_designations='CD48 antigen|BCM1 surface antigen|HM48-1|MRC OX-45 surface antigen|SLAM family member 2|signaling lymphocytic activation molecule 2', map_location='1 79.54 cM', chromosome='1', genomic_nucleotide_accession_version='NC_000067.6', start_position_on_the_genomic_accession=171681245, end_position_on_the_genomic_accession=171705258, orientation='plus', exon_count=7, OMIM=[], no_hdr0=''),
    12507 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=12507, CurrentID=0, Status='live', Symbol='Cd5', Aliases=['Ly', 'Ly-', 'Ly-1', 'Ly-12', 'Ly-A', 'Lyt-', 'Lyt-1'], description='CD5 antigen', other_designations='T-cell surface glycoprotein CD5|lymphocyte antigen 1', map_location='19 7.16 cM', chromosome='19', genomic_nucleotide_accession_version='NC_000085.6', start_position_on_the_genomic_accession=10718107, end_position_on_the_genomic_accession=10739026, orientation='minus', exon_count=12, OMIM=[], no_hdr0=''),
    12508 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=12508, CurrentID=0, Status='live', Symbol='Cd53', Aliases=['AI323659', 'Ox-4', 'Ox-44', 'Tsp', 'Tspan25'], description='CD53 antigen', other_designations='leukocyte surface antigen CD53|cell surface glycoprotein CD53', map_location='3 46.53 cM', chromosome='3', genomic_nucleotide_accession_version='NC_000069.6', start_position_on_the_genomic_accession=106758861, end_position_on_the_genomic_accession=106790149, orientation='minus', exon_count=8, OMIM=[], no_hdr0=''),
    12509 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=12509, CurrentID=0, Status='live', Symbol='Cd59a', Aliases=['AA987121', 'Cd59', 'prot', 'protectin'], description='CD59a antigen', other_designations='CD59A glycoprotein|CD59 antigen|MAC-IP|MAC-inhibitory protein|MACIF|membrane attack complex inhibition factor', map_location='2 54.53 cM', chromosome='2', genomic_nucleotide_accession_version='NC_000068.7', start_position_on_the_genomic_accession=104095753, end_position_on_the_genomic_accession=104115410, orientation='plus', exon_count=6, OMIM=[], no_hdr0=''),
    12511 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=12511, CurrentID=0, Status='live', Symbol='Cd6', Aliases=[], description='CD6 antigen', other_designations='T-cell differentiation antigen CD6', map_location='19 7.16 cM', chromosome='19', genomic_nucleotide_accession_version='NC_000085.6', start_position_on_the_genomic_accession=10789339, end_position_on_the_genomic_accession=10830062, orientation='minus', exon_count=13, OMIM=[], no_hdr0=''),
    12512 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=12512, CurrentID=0, Status='live', Symbol='Cd63', Aliases=['C75951', 'ME491', 'Tsp', 'Tspan30'], description='CD63 antigen', other_designations='CD63 antigen|melanoma 1 antigen', map_location='10 77.19 cM', chromosome='10', genomic_nucleotide_accession_version='NC_000076.6', start_position_on_the_genomic_accession=128896231, end_position_on_the_genomic_accession=128912822, orientation='plus', exon_count=11, OMIM=[], no_hdr0=''),
    12514 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=12514, CurrentID=0, Status='live', Symbol='Cd68', Aliases=['La', 'Lamp4', 'Sca', 'Scard1', 'gp11', 'gp110', 'ma'], description='CD68 antigen', other_designations='macrosialin', map_location='11 42.86 cM', chromosome='11', genomic_nucleotide_accession_version='NC_000077.6', start_position_on_the_genomic_accession=69664213, end_position_on_the_genomic_accession=69666170, orientation='minus', exon_count=6, OMIM=[], no_hdr0=''),
    12515 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=12515, CurrentID=0, Status='live', Symbol='Cd69', Aliases=['5830438K24Rik', 'A', 'AI452015', 'AIM', 'V', 'VEA'], description='CD69 antigen', other_designations='early activation antigen CD69|Very Early Activation Antigen', map_location='6 63.21 cM', chromosome='6', genomic_nucleotide_accession_version='NC_000072.6', start_position_on_the_genomic_accession=129267324, end_position_on_the_genomic_accession=129275375, orientation='minus', exon_count=5, OMIM=[], no_hdr0=''),
    12516 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=12516, CurrentID=0, Status='live', Symbol='Cd7', Aliases=[], description='CD7 antigen', other_designations='T-cell antigen CD7', map_location='11 84.85 cM', chromosome='11', genomic_nucleotide_accession_version='NC_000077.6', start_position_on_the_genomic_accession=121036747, end_position_on_the_genomic_accession=121039478, orientation='minus', exon_count=4, OMIM=[], no_hdr0=''),
    12517 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=12517, CurrentID=0, Status='live', Symbol='Cd72', Aliases=['CD72c', 'Ly-1', 'Ly-19', 'Ly-3', 'Ly-32', 'Ly-m1', 'Ly-m19', 'Lyb-', 'Lyb-2'], description='CD72 antigen', other_designations='B-cell differentiation antigen CD72|lymphocyte antigen 32', map_location='4 23.04 cM', chromosome='4', genomic_nucleotide_accession_version='NC_000070.6', start_position_on_the_genomic_accession=43447724, end_position_on_the_genomic_accession=43455102, orientation='minus', exon_count=9, OMIM=[], no_hdr0=''),
    12518 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=12518, CurrentID=0, Status='live', Symbol='Cd79a', Aliases=['Cd79', 'I', 'Ig', 'Ig-', 'Ig-alpha', 'Iga', 'Igalpha', 'Ly-5', 'Ly-54', 'Ly5', 'Ly54', 'mb-1'], description='CD79A antigen (immunoglobulin-associated alpha)', other_designations='B-cell antigen receptor complex-associated protein alpha chain|MB-1 membrane glycoprotein|membrane-bound immunoglobulin-associated protein|surface IgM-associated protein', map_location='7 13.49 cM', chromosome='7', genomic_nucleotide_accession_version='NC_000073.6', start_position_on_the_genomic_accession=24897497, end_position_on_the_genomic_accession=24901858, orientation='plus', exon_count=5, OMIM=[], no_hdr0=''),
    12519 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=12519, CurrentID=0, Status='live', Symbol='Cd80', Aliases=['B71', 'Cd28', 'Cd28l', 'Ly-5', 'Ly-53', 'Ly5', 'Ly53', 'MIC17', 'TSA1'], description='CD80 antigen', other_designations='T-lymphocyte activation antigen CD80|B7 protein|activation B7-1 antigen', map_location='16 26.86 cM', chromosome='16', genomic_nucleotide_accession_version='NC_000082.6', start_position_on_the_genomic_accession=38457430, end_position_on_the_genomic_accession=38495958, orientation='plus', exon_count=7, OMIM=[], no_hdr0=''),
    12520 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=12520, CurrentID=0, Status='live', Symbol='Cd81', Aliases=['Ta', 'Tap', 'Tapa-1', 'Tapa1', 'Tsp', 'Tspan28'], description='CD81 antigen', other_designations='CD81 antigen|26 kDa cell surface protein TAPA-1|target of the antiproliferative antibody 1', map_location='7 88.1 cM', chromosome='7', genomic_nucleotide_accession_version='NC_000073.6', start_position_on_the_genomic_accession=143052750, end_position_on_the_genomic_accession=143067930, orientation='plus', exon_count=8, OMIM=[], no_hdr0=''),
    12521 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=12521, CurrentID=0, Status='live', Symbol='Cd82', Aliases=['AA682076', 'AL023070', 'C33', 'IA4', 'Ka', 'Kai1', 'Tsp', 'Tspan27'], description='CD82 antigen', other_designations='CD82 antigen|C33 antigen|inducible membrane protein R2|kangai 1 (suppression of tumorigenicity 6, prostate)|metastasis suppressor Kangai-1 homolog', map_location='2 51.62 cM', chromosome='2', genomic_nucleotide_accession_version='NC_000068.7', start_position_on_the_genomic_accession=93419102, end_position_on_the_genomic_accession=93462950, orientation='minus', exon_count=15, OMIM=[], no_hdr0=''),
    12522 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=12522, CurrentID=0, Status='live', Symbol='Cd83', Aliases=[], description='CD83 antigen', other_designations='CD83 antigen|mCD83', map_location='13 21.6 cM', chromosome='13', genomic_nucleotide_accession_version='NC_000079.6', start_position_on_the_genomic_accession=43785112, end_position_on_the_genomic_accession=43803133, orientation='plus', exon_count=5, OMIM=[], no_hdr0=''),
    12523 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=12523, CurrentID=0, Status='live', Symbol='Cd84', Aliases=['A130013D22Rik', 'CDw84', 'SLA', 'SLAMF5'], description='CD84 antigen', other_designations='SLAM family member 5|leukocyte differentiation antigen CD84|signaling lymphocytic activation molecule 5', map_location='1 79.54 cM', chromosome='1', genomic_nucleotide_accession_version='NC_000067.6', start_position_on_the_genomic_accession=171839697, end_position_on_the_genomic_accession=171890718, orientation='plus', exon_count=11, OMIM=[], no_hdr0=''),
    12524 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=12524, CurrentID=0, Status='live', Symbol='Cd86', Aliases=['B7', 'B7-2', 'B7.2', 'B70', 'CLS1', 'Cd28l', 'Cd28l2', 'ETC-1', 'Ly-5', 'Ly-58', 'Ly5', 'Ly58', 'MB7', 'MB7-2', 'TS/A-2'], description='CD86 antigen', other_designations='T-lymphocyte activation antigen CD86|activation B7-2 antigen|early T cell costimulatory molecule-1', map_location='16 25.72 cM', chromosome='16', genomic_nucleotide_accession_version='NC_000082.6', start_position_on_the_genomic_accession=36568956, end_position_on_the_genomic_accession=36666158, orientation='minus', exon_count=13, OMIM=[], no_hdr0=''),
    12525 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=12525, CurrentID=0, Status='live', Symbol='Cd8a', Aliases=['BB154331', 'Ly-', 'Ly-2', 'Ly-3', 'Ly-35', 'Ly-B', 'Lyt-', 'Lyt-2'], description='CD8 antigen, alpha chain', other_designations='T-cell surface glycoprotein CD8 alpha chain|Lyt-2.1 lymphocyte differentiation antigen (AA at 100)|T-cell surface glycoprotein Lyt-2', map_location='6 32.14 cM', chromosome='6', genomic_nucleotide_accession_version='NC_000072.6', start_position_on_the_genomic_accession=71373427, end_position_on_the_genomic_accession=71379171, orientation='plus', exon_count=5, OMIM=[], no_hdr0=''),
    12526 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=12526, CurrentID=0, Status='live', Symbol='Cd8b1', Aliases=['Cd8b', 'Ly-', 'Ly-3', 'Ly-C', 'Lyt-', 'Lyt-3'], description='CD8 antigen, beta chain 1', other_designations='T-cell surface glycoprotein CD8 beta chain|T-cell membrane glycoprotein Ly-3|T-cell surface glycoprotein Lyt-3|lymphocyte antigen 3', map_location='6 32.14 cM', chromosome='6', genomic_nucleotide_accession_version='NC_000072.6', start_position_on_the_genomic_accession=71322788, end_position_on_the_genomic_accession=71337492, orientation='plus', exon_count=6, OMIM=[], no_hdr0=''),
    12527 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=12527, CurrentID=0, Status='live', Symbol='Cd9', Aliases=['Tsp', 'Tspan29'], description='CD9 antigen', other_designations='CD9 antigen', map_location='6 59.32 cM', chromosome='6', genomic_nucleotide_accession_version='NC_000072.6', start_position_on_the_genomic_accession=125460266, end_position_on_the_genomic_accession=125494760, orientation='minus', exon_count=8, OMIM=[], no_hdr0=''),
    12530 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=12530, CurrentID=0, Status='live', Symbol='Cdc25a', Aliases=['D9Ertd393', 'D9Ertd393e'], description='cell division cycle 25A', other_designations='M-phase inducer phosphatase 1|dual specificity phosphatase Cdc25A', map_location='9 59.81 cM', chromosome='9', genomic_nucleotide_accession_version='NC_000075.6', start_position_on_the_genomic_accession=109875518, end_position_on_the_genomic_accession=109893895, orientation='plus', exon_count=15, OMIM=[], no_hdr0=''),
    12531 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=12531, CurrentID=0, Status='live', Symbol='Cdc25b', Aliases=['AI604853'], description='cell division cycle 25B', other_designations='M-phase inducer phosphatase 2|dual specificity phosphatase Cdc25B', map_location='2 63.29 cM', chromosome='2', genomic_nucleotide_accession_version='NC_000068.7', start_position_on_the_genomic_accession=131186436, end_position_on_the_genomic_accession=131198511, orientation='plus', exon_count=16, OMIM=[], no_hdr0=''),
    12532 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=12532, CurrentID=0, Status='live', Symbol='Cdc25c', Aliases=['Cdc25'], description='cell division cycle 25C', other_designations='M-phase inducer phosphatase 3|cell cycle phosphatase CDC25C|cell division cycle control protein 25C|dual specificity phosphatase Cdc25C', map_location='18 18.71 cM', chromosome='18', genomic_nucleotide_accession_version='NC_000084.6', start_position_on_the_genomic_accession=34732993, end_position_on_the_genomic_accession=34751564, orientation='minus', exon_count=15, OMIM=[], no_hdr0=''),
    12534 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=12534, CurrentID=0, Status='live', Symbol='Cdk1', Aliases=['Cdc2', 'Cdc2a', 'p34<CDC2', 'p34<CDC2>'], description='cyclin-dependent kinase 1', other_designations='cyclin-dependent kinase 1|cell cycle p34 CDC2 kinase protein|cell division control protein 2 homolog|cell division cycle 2 homolog A|cell division cycle control protein 2a|cell division protein kinase 1|p34 protein kinase', map_location='10 36.07 cM', chromosome='10', genomic_nucleotide_accession_version='NC_000076.6', start_position_on_the_genomic_accession=69335146, end_position_on_the_genomic_accession=69352912, orientation='minus', exon_count=8, OMIM=[], no_hdr0=''),
    12537 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=12537, CurrentID=0, Status='live', Symbol='Cdk11b', Aliases=['AA989746', 'CDK11-p11', 'CDK11-p110', 'CDK11-p4', 'CDK11-p46', 'CDK11-p5', 'CDK11-p58', 'Cdc11b', 'Cdc2l', 'Cdc2l1', 'Cdc2l2', 'Cdk11', 'p58'], description='cyclin-dependent kinase 11B', other_designations='cyclin-dependent kinase 11B|PITSLRE proteins|PITSLRE serine/threonine-protein kinase CDC2L1|cell division cycle 2 homolog-like 1|cell division cycle 2 homolog-like 2|cell division cycle 2-like 1|cell division cycle 2-like 2|cell division cycle 2-like protein kinase 1|cell division protein kinase 11|cyclin-dependent kinase 11|galactosyltransferase-associated protein kinase p58/GTA', map_location='4 86.73 cM', chromosome='4', genomic_nucleotide_accession_version='NC_000070.6', start_position_on_the_genomic_accession=155624841, end_position_on_the_genomic_accession=155649935, orientation='plus', exon_count=24, OMIM=[], no_hdr0=''),
    12539 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=12539, CurrentID=0, Status='live', Symbol='Cdc37', Aliases=['p50', 'p50Cdc3', 'p50Cdc37'], description='cell division cycle 37', other_designations='hsp90 co-chaperone Cdc37|cell division cycle 37 homolog|hsp90 chaperone protein kinase-targeting subunit', map_location='9 A3', chromosome='9', genomic_nucleotide_accession_version='NC_000075.6', start_position_on_the_genomic_accession=21139431, end_position_on_the_genomic_accession=21149934, orientation='minus', exon_count=8, OMIM=[], no_hdr0=''),
    12540 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=12540, CurrentID=0, Status='live', Symbol='Cdc42', Aliases=['AI747189', 'AU018915'], description='cell division cycle 42', other_designations='cell division control protein 42 homolog|G25K GTP-binding protein|cell division cycle 42 homolog', map_location='4 69.83 cM', chromosome='4', genomic_nucleotide_accession_version='NC_000070.6', start_position_on_the_genomic_accession=137319696, end_position_on_the_genomic_accession=137357759, orientation='minus', exon_count=9, OMIM=[], no_hdr0=''),
    12544 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=12544, CurrentID=0, Status='live', Symbol='Cdc45', Aliases=['Cdc45l'], description='cell division cycle 45', other_designations='cell division control protein 45 homolog|CDC45-related protein|PORC-PI-1|cell division cycle 45 homolog', map_location='16 11.63 cM', chromosome='16', genomic_nucleotide_accession_version='NC_000082.6', start_position_on_the_genomic_accession=18780447, end_position_on_the_genomic_accession=18811972, orientation='minus', exon_count=19, OMIM=[], no_hdr0=''),
    12545 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=12545, CurrentID=0, Status='live', Symbol='Cdc7', Aliases=['AI597260l', 'Cdc7l1', 'muCdc7', 'Cdc7'], description='cell division cycle 7 (S. cerevisiae)', other_designations='cell division cycle 7-related protein kinase|CDC7-related kinase|cell division cycle 7-like 1', map_location='5 E5', chromosome='5', genomic_nucleotide_accession_version='NC_000071.6', start_position_on_the_genomic_accession=106964315, end_position_on_the_genomic_accession=106984440, orientation='plus', exon_count=13, OMIM=[], no_hdr0=''),
    12549 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=12549, CurrentID=0, Status='live', Symbol='Arhgap31', Aliases=['5830477L08Rik', 'AU041750', 'CdG', 'Cdgap', 'D330026I07Rik'], description='Rho GTPase activating protein 31', other_designations='rho GTPase-activating protein 31|CDC42 GTPase-activating protein', map_location='16 B4', chromosome='16', genomic_nucleotide_accession_version='NC_000082.6', start_position_on_the_genomic_accession=38598343, end_position_on_the_genomic_accession=38713035, orientation='minus', exon_count=12, OMIM=[], no_hdr0=''),
    12550 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=12550, CurrentID=0, Status='live', Symbol='Cdh1', Aliases=['AA960649', 'ARC-1', 'E-ca', 'E-cad', 'E-cadh', 'Eca', 'Ecad', 'L-C', 'L-CAM', 'UVO', 'Um'], description='cadherin 1', other_designations='cadherin-1|E-cadherin|epithelial cadherin|uvomorulin', map_location='8 53.18 cM', chromosome='8', genomic_nucleotide_accession_version='NC_000074.6', start_position_on_the_genomic_accession=106603350, end_position_on_the_genomic_accession=106670247, orientation='plus', exon_count=16, OMIM=[], no_hdr0=''),
    12552 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=12552, CurrentID=0, Status='live', Symbol='Cdh11', Aliases=['Cad1', 'Cad11', 'OB-cad', 'OSF-4'], description='cadherin 11', other_designations='cadherin-11|OB-cadherin|osteoblast cadherin', map_location='8 50.44 cM', chromosome='8', genomic_nucleotide_accession_version='NC_000074.6', start_position_on_the_genomic_accession=102632095, end_position_on_the_genomic_accession=102785493, orientation='minus', exon_count=15, OMIM=[], no_hdr0=''),
    12554 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=12554, CurrentID=0, Status='live', Symbol='Cdh13', Aliases=['4932416G01Rik', 'Cdht', 'T-cadh', 'Tca', 'Tcad'], description='cadherin 13', other_designations='cadherin-13|H-cadherin|T-cadherin|heart cadherin', map_location='8 65.97 cM', chromosome='8', genomic_nucleotide_accession_version='NC_000074.6', start_position_on_the_genomic_accession=118140017, end_position_on_the_genomic_accession=119324929, orientation='plus', exon_count=17, OMIM=[], no_hdr0=''),
    12555 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=12555, CurrentID=0, Status='live', Symbol='Cdh15', Aliases=['AI323380', 'Cdh14', 'Mca', 'Mcad'], description='cadherin 15', other_designations='cadherin-15|M-cadherin|cadherin-14|muscle cadherin', map_location='8 71.99 cM', chromosome='8', genomic_nucleotide_accession_version='NC_000074.6', start_position_on_the_genomic_accession=122848374, end_position_on_the_genomic_accession=122867397, orientation='plus', exon_count=14, OMIM=[], no_hdr0=''),
    12556 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=12556, CurrentID=0, Status='live', Symbol='Cdh16', Aliases=[], description='cadherin 16', other_designations='cadherin-16|KSP-cadherin|kidney-specific cadherin', map_location='8 53.04 cM', chromosome='8', genomic_nucleotide_accession_version='NC_000074.6', start_position_on_the_genomic_accession=104601915, end_position_on_the_genomic_accession=104624396, orientation='minus', exon_count=19, OMIM=[], no_hdr0=''),
    12557 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=12557, CurrentID=0, Status='live', Symbol='Cdh17', Aliases=['HPT-', 'HPT-1', 'HPT-1/LI', 'LI-ca'], description='cadherin 17', other_designations='cadherin-17|BILL-cadherin|LI-cadherin|P130|liver-intestine cadherin', map_location='4 A1', chromosome='4', genomic_nucleotide_accession_version='NC_000070.6', start_position_on_the_genomic_accession=11758157, end_position_on_the_genomic_accession=11817905, orientation='plus', exon_count=20, OMIM=[], no_hdr0=''),
    12558 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=12558, CurrentID=0, Status='live', Symbol='Cdh2', Aliases=['CDHN', 'N-C', 'N-CAD', 'Nc', 'Ncad'], description='cadherin 2', other_designations='cadherin-2|N-cadherin|neural cadherin', map_location='18 10.1 cM', chromosome='18', genomic_nucleotide_accession_version='NC_000084.6', start_position_on_the_genomic_accession=16588877, end_position_on_the_genomic_accession=16809246, orientation='minus', exon_count=17, OMIM=[], no_hdr0=''),
    12560 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=12560, CurrentID=0, Status='live', Symbol='Cdh3', Aliases=['AI385538', 'Ca', 'Cadp', 'Cdhp', 'P-cad', 'P-cadherin', 'Pc', 'Pcad'], description='cadherin 3', other_designations='cadherin-3|RPE-specific cadherin|placental cadherin', map_location='8 53.16 cM', chromosome='8', genomic_nucleotide_accession_version='NC_000074.6', start_position_on_the_genomic_accession=106510852, end_position_on_the_genomic_accession=106556911, orientation='plus', exon_count=16, OMIM=[], no_hdr0=''),
    12561 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=12561, CurrentID=0, Status='live', Symbol='Cdh4', Aliases=['AW120700', 'R-CAD', 'R-Ca', 'R-Cadh', 'Rc', 'Rcad'], description='cadherin 4', other_designations='cadherin-4|R-cadherin|retina cadherin|retinal cadherin', map_location='2 101.86 cM', chromosome='2', genomic_nucleotide_accession_version='NC_000068.7', start_position_on_the_genomic_accession=179442423, end_position_on_the_genomic_accession=179899377, orientation='plus', exon_count=19, OMIM=[], no_hdr0=''),
    12562 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=12562, CurrentID=0, Status='live', Symbol='Cdh5', Aliases=['7B4', 'AA408225', 'Cd144', 'VE', 'VE-C', 'VE-Cad', 'VECD', 'VEcad', 'Vec'], description='cadherin 5', other_designations='cadherin-5|7B4/cadherin-5|VE-cadherin|vascular endothelial cadherin', map_location='8 53.04 cM', chromosome='8', genomic_nucleotide_accession_version='NC_000074.6', start_position_on_the_genomic_accession=104101613, end_position_on_the_genomic_accession=104144504, orientation='plus', exon_count=13, OMIM=[], no_hdr0=''),
    12563 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=12563, CurrentID=0, Status='live', Symbol='Cdh6', Aliases=['K-cadh', 'cad', 'cad6'], description='cadherin 6', other_designations='cadherin-6|K-cadherin|kidney cadherin', map_location='15 A1', chromosome='15', genomic_nucleotide_accession_version='NC_000081.6', start_position_on_the_genomic_accession=13028699, end_position_on_the_genomic_accession=13176407, orientation='minus', exon_count=13, OMIM=[], no_hdr0=''),
    12564 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=12564, CurrentID=0, Status='live', Symbol='Cdh8', Aliases=['AI851472', 'cad', 'cad8'], description='cadherin 8', other_designations='cadherin-8', map_location='8 49.4 cM', chromosome='8', genomic_nucleotide_accession_version='NC_000074.6', start_position_on_the_genomic_accession=99024471, end_position_on_the_genomic_accession=99417666, orientation='minus', exon_count=17, OMIM=[], no_hdr0=''),
    12565 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=12565, CurrentID=0, Status='live', Symbol='Cdh9', Aliases=['T1-cadh'], description='cadherin 9', other_designations='cadherin-9|T1-cadherin', map_location='15 A2', chromosome='15', genomic_nucleotide_accession_version='NC_000081.6', start_position_on_the_genomic_accession=16728550, end_position_on_the_genomic_accession=16857138, orientation='plus', exon_count=14, OMIM=[], no_hdr0=''),
    12566 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=12566, CurrentID=0, Status='live', Symbol='Cdk2', Aliases=['A630093N05Rik'], description='cyclin-dependent kinase 2', other_designations='cyclin-dependent kinase 2|cell division protein kinase 2', map_location='10 D3', chromosome='10', genomic_nucleotide_accession_version='NC_000076.6', start_position_on_the_genomic_accession=128697938, end_position_on_the_genomic_accession=128705051, orientation='minus', exon_count=9, OMIM=[], no_hdr0=''),
    12567 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=12567, CurrentID=0, Status='live', Symbol='Cdk4', Aliases=['Crk', 'Crk3'], description='cyclin-dependent kinase 4', other_designations='cyclin-dependent kinase 4|PSK-J3|cell division protein kinase 4|p34<PSK-J3>/cdk4|serine/threonine kinase', map_location='10 D3', chromosome='10', genomic_nucleotide_accession_version='NC_000076.6', start_position_on_the_genomic_accession=127063535, end_position_on_the_genomic_accession=127067288, orientation='plus', exon_count=8, OMIM=[], no_hdr0=''),
    12568 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=12568, CurrentID=0, Status='live', Symbol='Cdk5', Aliases=['AW048668', 'Crk', 'Crk6'], description='cyclin-dependent kinase 5', other_designations='cyclin-dependent-like kinase 5|CR6 protein kinase|TPKII catalytic subunit|cell division protein kinase 5|serine/threonine-protein kinase PSSALRE|tau protein kinase II catalytic subunit', map_location='5 11.73 cM', chromosome='5', genomic_nucleotide_accession_version='NC_000071.6', start_position_on_the_genomic_accession=24407597, end_position_on_the_genomic_accession=24423587, orientation='minus', exon_count=13, OMIM=[], no_hdr0=''),
    12569 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=12569, CurrentID=0, Status='live', Symbol='Cdk5r1', Aliases=['Cdk5r', 'D11Bwg0379e', 'p2', 'p25', 'p3', 'p35'], description='cyclin-dependent kinase 5, regulatory subunit 1 (p35)', other_designations='cyclin-dependent kinase 5 activator 1|CDK5 activator 1|TPKII regulatory subunit|cyclin-dependent kinase 5 regulatory subunit 1|cyclin-dependent kinase 5, regulatory subunit (p35) 1', map_location='11 47.94 cM', chromosome='11', genomic_nucleotide_accession_version='NC_000077.6', start_position_on_the_genomic_accession=80477023, end_position_on_the_genomic_accession=80481184, orientation='plus', exon_count=1, OMIM=[], no_hdr0=''),
    12570 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=12570, CurrentID=0, Status='live', Symbol='Cdk5r2', Aliases=['B230310J22Rik', 'p3', 'p39'], description='cyclin-dependent kinase 5, regulatory subunit 2 (p39)', other_designations='cyclin-dependent kinase 5 activator 2|CDK5 activator 2|cyclin-dependent kinase 5 regulatory subunit 2|p39I', map_location='1 C4', chromosome='1', genomic_nucleotide_accession_version='NC_000067.6', start_position_on_the_genomic_accession=74855029, end_position_on_the_genomic_accession=74857732, orientation='plus', exon_count=1, OMIM=[], no_hdr0=''),
    12571 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=12571, CurrentID=0, Status='live', Symbol='Cdk6', Aliases=['AI504062', 'Crk', 'Crk2'], description='cyclin-dependent kinase 6', other_designations='cyclin-dependent kinase 6|CR2 protein kinase|cell division protein kinase 6|serine/threonine-protein kinase PLSTIRE', map_location='5 2.04 cM', chromosome='5', genomic_nucleotide_accession_version='NC_000071.6', start_position_on_the_genomic_accession=3341004, end_position_on_the_genomic_accession=3531008, orientation='plus', exon_count=9, OMIM=[], no_hdr0=''),
    12572 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=12572, CurrentID=0, Status='live', Symbol='Cdk7', Aliases=['AI323415', 'AI528512', 'C230069N13', 'Cdkn', 'Cdkn7', 'Crk', 'Crk4'], description='cyclin-dependent kinase 7', other_designations='cyclin-dependent kinase 7|39 kDa protein kinase|CAK|CDK-activating kinase|CR4 protein kinase|CRK4 PK (CDC2-related-kinase-4 protein kinase)|P39 Mo15|TFIIH basal transcription factor complex kinase subunit|cell division protein kinase 7|cyclin-dependent kinase 7 (homolog of Xenopus MO15 cdk-activating kinase)|protein-tyrosine kinase MPK-7', map_location='13 53.23 cM', chromosome='13', genomic_nucleotide_accession_version='NC_000079.6', start_position_on_the_genomic_accession=100697024, end_position_on_the_genomic_accession=100730942, orientation='minus', exon_count=12, OMIM=[], no_hdr0=''),
    12575 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=12575, CurrentID=0, Status='live', Symbol='Cdkn1a', Aliases=['CAP', 'CAP20', 'CDK', 'CDKI', 'CI', 'CIP1', 'Cdkn', 'Cdkn1', 'P2', 'P21', 'SD', 'SDI1', 'Waf', 'Waf1', 'mda', 'mda6', 'p21C', 'p21Cip1', 'p21W', 'p21WAF'], description='cyclin-dependent kinase inhibitor 1A (P21)', other_designations='cyclin-dependent kinase inhibitor 1|CDK-interacting protein 1|melanoma differentiation-associated protein', map_location='17 15.12 cM', chromosome='17', genomic_nucleotide_accession_version='NC_000083.6', start_position_on_the_genomic_accession=29090979, end_position_on_the_genomic_accession=29100722, orientation='plus', exon_count=4, OMIM=[], no_hdr0=''),
    12576 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=12576, CurrentID=0, Status='live', Symbol='Cdkn1b', Aliases=['AA408329', 'AI843786', 'Kip1', 'p2', 'p27', 'p27K', 'p27Kip1'], description='cyclin-dependent kinase inhibitor 1B', other_designations='cyclin-dependent kinase inhibitor 1B|cyclin-dependent kinase inhibitor p27', map_location='6 65.77 cM', chromosome='6', genomic_nucleotide_accession_version='NC_000072.6', start_position_on_the_genomic_accession=134920401, end_position_on_the_genomic_accession=134925525, orientation='plus', exon_count=3, OMIM=[], no_hdr0=''),
    12577 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=12577, CurrentID=0, Status='live', Symbol='Cdkn1c', Aliases=['AL024410', 'CDK', 'CDKI', 'Ki', 'Kip2', 'p57(kip2)', 'p57K', 'p57Kip2'], description='cyclin-dependent kinase inhibitor 1C (P57)', other_designations='cyclin-dependent kinase inhibitor 1C|cyclin-dependent kinase inhibitor p57', map_location='7 88.22 cM', chromosome='7', genomic_nucleotide_accession_version='NC_000073.6', start_position_on_the_genomic_accession=143458339, end_position_on_the_genomic_accession=143461059, orientation='minus', exon_count=4, OMIM=[], no_hdr0=''),
    12578 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=12578, CurrentID=0, Status='live', Symbol='Cdkn2a', Aliases=['A', 'ARF-', 'ARF-INK4a', 'Arf', 'INK4', 'INK4a-ARF', 'Ink4a/Arf', 'MTS', 'MTS1', 'Pct', 'Pctr1', 'p1', 'p16', 'p16(INK4a)', 'p16I', 'p16INK4a', 'p19', 'p19<A', 'p19<ARF>', 'p19ARF'], description='cyclin dependent kinase inhibitor 2A', other_designations='cyclin-dependent kinase inhibitor 2A|CDK4I|alternative reading frame|cyclin-dependent kinase 4 inhibitor A|cyclin-dependent kinase inhibitor 2A (p16, inhibits CDK4)|cyclin-dependent kinase inhibitor protein|mitochondrial smARF|p16-INK4|p16-INK4a', map_location='4 42.15 cM', chromosome='4', genomic_nucleotide_accession_version='NC_000070.6', start_position_on_the_genomic_accession=89274473, end_position_on_the_genomic_accession=89294619, orientation='minus', exon_count=4, OMIM=[], no_hdr0=''),
    12579 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=12579, CurrentID=0, Status='live', Symbol='Cdkn2b', Aliases=['AV083695', 'INK4b', 'MTS', 'MTS2', 'p1', 'p15', 'p15(INK4b)', 'p15IN', 'p15INK4b'], description='cyclin dependent kinase inhibitor 2B', other_designations='cyclin-dependent kinase 4 inhibitor B|cyclin-dependent kinase inhibitor 2B (p15, inhibits CDK4)|cyclin-dependent kinase inhibitor p15|cyclin-dependent kinase inhibitor p15INK4b|cyclin-dependent kinase inhibitor protein|p14-INK4b|p15-INK4b', map_location='4 42.15 cM', chromosome='4', genomic_nucleotide_accession_version='NC_000070.6', start_position_on_the_genomic_accession=89306289, end_position_on_the_genomic_accession=89311032, orientation='minus', exon_count=2, OMIM=[], no_hdr0=''),
    12580 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=12580, CurrentID=0, Status='live', Symbol='Cdkn2c', Aliases=['C77269', 'INK', 'INK4c', 'p1', 'p18', 'p18-INK4c', 'p18-INK6', 'p18IN', 'p18INK4c'], description='cyclin dependent kinase inhibitor 2C', other_designations='cyclin-dependent kinase 4 inhibitor C|cyclin-dependent kinase 6 inhibitor|cyclin-dependent kinase inhibitor 2C (p18, inhibits CDK4)', map_location='4 51.32 cM', chromosome='4', genomic_nucleotide_accession_version='NC_000070.6', start_position_on_the_genomic_accession=109660876, end_position_on_the_genomic_accession=109666756, orientation='minus', exon_count=3, OMIM=[], no_hdr0=''),
    12581 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=12581, CurrentID=0, Status='live', Symbol='Cdkn2d', Aliases=['INK', 'INK4d', 'p1', 'p19', 'p19IN', 'p19INK4d'], description='cyclin dependent kinase inhibitor 2D', other_designations='cyclin-dependent kinase 4 inhibitor D|cyclin-dependent kinase inhibitor 2D (p19, inhibits CDK4)|p19-INK4d', map_location='9 A3', chromosome='9', genomic_nucleotide_accession_version='NC_000075.6', start_position_on_the_genomic_accession=21288459, end_position_on_the_genomic_accession=21291421, orientation='minus', exon_count=3, OMIM=[], no_hdr0=''),
    12583 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=12583, CurrentID=0, Status='live', Symbol='Cdo1', Aliases=['1300002L19Rik', 'Cd', 'Cdo', 'D18Ucl', 'D18Ucla3'], description='cysteine dioxygenase 1, cytosolic', other_designations='cysteine dioxygenase type 1|CDO-I|cysteine dioxygenase type I', map_location='18 24.75 cM', chromosome='18', genomic_nucleotide_accession_version='NC_000084.6', start_position_on_the_genomic_accession=46713193, end_position_on_the_genomic_accession=46728502, orientation='minus', exon_count=5, OMIM=[], no_hdr0=''),
    12585 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=12585, CurrentID=0, Status='live', Symbol='Cdr2', Aliases=['AA617262'], description='cerebellar degeneration-related 2', other_designations='cerebellar degeneration-related protein 2', map_location='7 65.04 cM', chromosome='7', genomic_nucleotide_accession_version='NC_000073.6', start_position_on_the_genomic_accession=120957036, end_position_on_the_genomic_accession=120982312, orientation='minus', exon_count=5, OMIM=[], no_hdr0=''),
    12587 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=12587, CurrentID=0, Status='live', Symbol='Mia', Aliases=['CD-RAP', 'Cd', 'Cdrap', 'Mi1', 'Mia'], description='melanoma inhibitory activity', other_designations='melanoma-derived growth regulatory protein|cartilage-derived retinoic acid-sensitive protein|melanoma inhibitory activity 1|melanoma inhibitory activity protein', map_location='7 15.84 cM', chromosome='7', genomic_nucleotide_accession_version='NC_000073.6', start_position_on_the_genomic_accession=27179741, end_position_on_the_genomic_accession=27181149, orientation='minus', exon_count=4, OMIM=[], no_hdr0=''),
    12589 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=12589, CurrentID=0, Status='live', Symbol='Ift81', Aliases=['AW060663', 'CDV-', 'Cdv', 'Cdv-1', 'Cdv-1r', 'Cdv1'], description='intraflagellar transport 81', other_designations='intraflagellar transport protein 81 homolog|carnitine deficiency-associated gene expressed in ventricle 1|carnitine deficiency-associated protein expressed in ventricle 1|intraflagellar transport 81 homolog', map_location='5 62.44 cM', chromosome='5', genomic_nucleotide_accession_version='NC_000071.6', start_position_on_the_genomic_accession=122540265, end_position_on_the_genomic_accession=122614546, orientation='minus', exon_count=21, OMIM=[], no_hdr0=''),
    12590 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=12590, CurrentID=0, Status='live', Symbol='Cdx1', Aliases=['Cdx', 'Cdx-1'], description='caudal type homeobox 1', other_designations='homeobox protein CDX-1|caudal type homeo box 1|caudal type homeobox transcription factor 1|caudal-type homeobox protein 1', map_location='18 34.41 cM', chromosome='18', genomic_nucleotide_accession_version='NC_000084.6', start_position_on_the_genomic_accession=61018862, end_position_on_the_genomic_accession=61036199, orientation='minus', exon_count=3, OMIM=[], no_hdr0=''),
    12591 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=12591, CurrentID=0, Status='live', Symbol='Cdx2', Aliases=['Cdx-2'], description='caudal type homeobox 2', other_designations='homeobox protein CDX-2|caudal type homeo box 2|caudal-type homeobox protein 2', map_location='5 86.86 cM', chromosome='5', genomic_nucleotide_accession_version='NC_000071.6', start_position_on_the_genomic_accession=147300900, end_position_on_the_genomic_accession=147307249, orientation='minus', exon_count=3, OMIM=[], no_hdr0=''),
    12592 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=12592, CurrentID=0, Status='live', Symbol='Cdx4', Aliases=['Cdx-3', 'Cdx-4', 'Cdx3'], description='caudal type homeobox 4', other_designations='homeobox protein CDX-4|caudal type homeo box 4|caudal-type homeobox protein 4', map_location='X 46.06 cM', chromosome='X', genomic_nucleotide_accession_version='NC_000086.7', start_position_on_the_genomic_accession=103321398, end_position_on_the_genomic_accession=103330224, orientation='plus', exon_count=3, OMIM=[], no_hdr0=''),
    12593 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=12593, CurrentID=0, Status='live', Symbol='Cdyl', Aliases=['AI325931'], description='chromodomain protein, Y chromosome-like', other_designations='chromodomain Y-like protein|CDY-like|crotonyl-CoA hydratase|putative histone acetyltransferase Cdyl', map_location='13 14.39 cM', chromosome='13', genomic_nucleotide_accession_version='NC_000079.6', start_position_on_the_genomic_accession=35659818, end_position_on_the_genomic_accession=35874064, orientation='plus', exon_count=11, OMIM=[], no_hdr0=''),
    12606 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=12606, CurrentID=0, Status='live', Symbol='Cebpa', Aliases=['C/ebp', 'C/ebpalpha', 'CBF-A', 'Ceb', 'Cebp'], description='CCAAT/enhancer binding protein (C/EBP), alpha', other_designations='CCAAT/enhancer-binding protein alpha|C/EBP alpha', map_location='7 21.02 cM', chromosome='7', genomic_nucleotide_accession_version='NC_000073.6', start_position_on_the_genomic_accession=35119293, end_position_on_the_genomic_accession=35121928, orientation='plus', exon_count=1, OMIM=[], no_hdr0=''),
    12607 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=12607, CurrentID=0, Status='live', Symbol='Cebpz', Aliases=['AI848081', 'CBF2', 'Cbf', 'Cebpa', 'Cebpa-rs1'], description='CCAAT/enhancer binding protein zeta', other_designations='CCAAT/enhancer-binding protein zeta|CCAAT-binding factor|CCAAT-box-binding transcription factor|CCAAT/enhancer binding protein alpha (C/EBP) related sequence 1', map_location='17 E3', chromosome='17', genomic_nucleotide_accession_version='NC_000083.6', start_position_on_the_genomic_accession=78919003, end_position_on_the_genomic_accession=78937070, orientation='minus', exon_count=16, OMIM=[], no_hdr0=''),
    12608 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=12608, CurrentID=0, Status='live', Symbol='Cebpb', Aliases=['C/EBPbe', 'C/EBPbeta', 'CR', 'CRP2', 'IL-6', 'IL-6DBP', 'LAP', 'LIP', 'NF-', 'NF-IL6', 'NF-M', 'Nf', 'Nfil6'], description='CCAAT/enhancer binding protein (C/EBP), beta', other_designations='CCAAT/enhancer-binding protein beta|AGP/EBP|C/EBP BETA|interleukin-6-dependent-binding protein|liver-enriched transcriptional activator|nuclear protein Il6', map_location='2 87.58 cM', chromosome='2', genomic_nucleotide_accession_version='NC_000068.7', start_position_on_the_genomic_accession=167688915, end_position_on_the_genomic_accession=167690432, orientation='plus', exon_count=1, OMIM=[], no_hdr0=''),
    12609 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=12609, CurrentID=0, Status='live', Symbol='Cebpd', Aliases=['c/EBPdelta'], description='CCAAT/enhancer binding protein (C/EBP), delta', other_designations='CCAAT/enhancer-binding protein delta|C/EBP delta|c/EBP-related protein 3', map_location='16 10.09 cM', chromosome='16', genomic_nucleotide_accession_version='NC_000082.6', start_position_on_the_genomic_accession=15887286, end_position_on_the_genomic_accession=15889545, orientation='plus', exon_count=1, OMIM=[], no_hdr0=''),
    12611 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=12611, CurrentID=0, Status='live', Symbol='Cebpg', Aliases=['C/EBP[g]', 'C/EBPga', 'C/EBPgamma', 'GPE1-', 'GPE1-BP', 'Gpe1', 'Gpe1bp', 'Ig/E', 'Ig/EBP'], description='CCAAT/enhancer binding protein (C/EBP), gamma', other_designations='CCAAT/enhancer-binding protein gamma|G-CSF promoter element 1 binding protein|GPE1-BP (C/EBP gamma)|GPE1-binding protein|IG/EBP-1|c/EBP gamma|granulocyte colony-stimulating factor promoter element 1-binding protein|immunoglobulin enhancer-binding protein 1', map_location='7 B2', chromosome='7', genomic_nucleotide_accession_version='NC_000073.6', start_position_on_the_genomic_accession=35046422, end_position_on_the_genomic_accession=35056566, orientation='minus', exon_count=2, OMIM=[], no_hdr0=''),
    12613 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=12613, CurrentID=0, Status='live', Symbol='Cel', Aliases=['1810036E18Rik', 'B', 'BAL', 'BSSL'], description='carboxyl ester lipase', other_designations='bile salt-activated lipase|bile salt-stimulated lipase|cholesterol esterase|pancreatic lysophospholipase|sterol esterase', map_location='2 19.38 cM', chromosome='2', genomic_nucleotide_accession_version='NC_000068.7', start_position_on_the_genomic_accession=28555819, end_position_on_the_genomic_accession=28563403, orientation='minus', exon_count=11, OMIM=[], no_hdr0=''),
    12614 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=12614, CurrentID=0, Status='live', Symbol='Celsr1', Aliases=['Adgr', 'Adgrc1', 'Cr', 'Crsh', 'Sc', 'Scy', 'crash'], description='cadherin, EGF LAG seven-pass G-type receptor 1', other_designations='cadherin EGF LAG seven-pass G-type receptor 1|cadherin, EGF LAG seven-pass G-type receptor 1 (flamingo homolog, Drosophila)|seven-pass transmembrane receptor', map_location='15 40.42 cM', chromosome='15', genomic_nucleotide_accession_version='NC_000081.6', start_position_on_the_genomic_accession=85898758, end_position_on_the_genomic_accession=86034223, orientation='minus', exon_count=37, OMIM=[], no_hdr0=''),
    12615 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=12615, CurrentID=0, Status='live', Symbol='Cenpa', Aliases=['Cen', 'Cenp-A'], description='centromere protein A', other_designations='histone H3-like centromeric protein A|centromere autoantigen A|centrosomin A', map_location='5 16.76 cM', chromosome='5', genomic_nucleotide_accession_version='NC_000071.6', start_position_on_the_genomic_accession=30666877, end_position_on_the_genomic_accession=30674837, orientation='plus', exon_count=8, OMIM=[], no_hdr0=''),
    12616 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=12616, CurrentID=0, Status='live', Symbol='Cenpb', Aliases=['CENP-B'], description='centromere protein B', other_designations='major centromere autoantigen B|centromere autoantigen B', map_location='2 63.29 cM', chromosome='2', genomic_nucleotide_accession_version='NC_000068.7', start_position_on_the_genomic_accession=131177289, end_position_on_the_genomic_accession=131180067, orientation='minus', exon_count=1, OMIM=[], no_hdr0=''),
    12617 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=12617, CurrentID=0, Status='live', Symbol='Cenpc1', Aliases=['CENP-C', 'Cenpc'], description='centromere protein C1', other_designations='centromere protein C|centromere autoantigen C1', map_location='5 E1', chromosome='5', genomic_nucleotide_accession_version='NC_000071.6', start_position_on_the_genomic_accession=86012018, end_position_on_the_genomic_accession=86065962, orientation='minus', exon_count=21, OMIM=[], no_hdr0=''),
    12622 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=12622, CurrentID=0, Status='live', Symbol='Cer1', Aliases=['Ce', 'Cer', 'Cerl', 'Cerl1', 'Cerr1', 'cer-', 'cer-1'], description='cerberus 1, DAN family BMP antagonist', other_designations='cerberus|cer-l|cerberus 1 homolog|cerberus homolog|cerberus-like protein|cerberus-related protein', map_location='4 39.4 cM', chromosome='4', genomic_nucleotide_accession_version='NC_000070.6', start_position_on_the_genomic_accession=82881751, end_position_on_the_genomic_accession=82885151, orientation='minus', exon_count=2, OMIM=[], no_hdr0=''),
    12623 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=12623, CurrentID=0, Status='live', Symbol='Ces1g', Aliases=['CEH', 'Ces', 'Ces-', 'Ces-1', 'Ces1', 'Ses', 'Ses-1'], description='carboxylesterase 1G', other_designations='liver carboxylesterase 1|ES-x|acyl-coenzyme A:cholesterol acyltransferase|carboxylesterase 1|cholesteryl ester hydrolase', map_location='8 45.29 cM', chromosome='8', genomic_nucleotide_accession_version='NC_000074.6', start_position_on_the_genomic_accession=93302369, end_position_on_the_genomic_accession=93337209, orientation='minus', exon_count=14, OMIM=[], no_hdr0=''),
    12626 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=12626, CurrentID=0, Status='live', Symbol='Cetn3', Aliases=['MmCEN', 'MmCEN3'], description='centrin 3', other_designations='centrin-3', map_location='13 C3', chromosome='13', genomic_nucleotide_accession_version='NC_000079.6', start_position_on_the_genomic_accession=81780636, end_position_on_the_genomic_accession=81797155, orientation='plus', exon_count=6, OMIM=[], no_hdr0=''),
    12627 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=12627, CurrentID=0, Status='live', Symbol='Cfc1', Aliases=['AV265756', 'b2b970C', 'b2b970Clo', 'cryp', 'cryptic'], description='cripto, FRL-1, cryptic family 1', other_designations='cryptic protein', map_location='1 B', chromosome='1', genomic_nucleotide_accession_version='NC_000067.6', start_position_on_the_genomic_accession=34535648, end_position_on_the_genomic_accession=34544311, orientation='plus', exon_count=6, OMIM=[], no_hdr0=''),
    12628 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=12628, CurrentID=0, Status='live', Symbol='Cfh', Aliases=['Mud-1', 'NOM', 'S', 'Sa', 'Sas-1', 'Sas1'], description='complement component factor h', other_designations='complement factor H|complement factor H related protein 3A4/5G4|protein beta-1-H', map_location='1 F', chromosome='1', genomic_nucleotide_accession_version='NC_000067.6', start_position_on_the_genomic_accession=140085855, end_position_on_the_genomic_accession=140183411, orientation='minus', exon_count=22, OMIM=[], no_hdr0=''),
    12630 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=12630, CurrentID=0, Status='live', Symbol='Cfi', Aliases=[], description='complement component factor i', other_designations='complement factor I|C3B/C4B inactivator', map_location='3 59.21 cM', chromosome='3', genomic_nucleotide_accession_version='NC_000069.6', start_position_on_the_genomic_accession=129836727, end_position_on_the_genomic_accession=129875332, orientation='plus', exon_count=14, OMIM=[], no_hdr0=''),
    12631 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=12631, CurrentID=0, Status='live', Symbol='Cfl1', Aliases=['AA959946', 'Cof', 'co', 'n-c'], description='cofilin 1, non-muscle', other_designations='cofilin-1|n-cofilin', map_location='19 A', chromosome='19', genomic_nucleotide_accession_version='NC_000085.6', start_position_on_the_genomic_accession=5490455, end_position_on_the_genomic_accession=5494031, orientation='plus', exon_count=4, OMIM=[], no_hdr0=''),
    12632 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=12632, CurrentID=0, Status='live', Symbol='Cfl2', Aliases=[], description='cofilin 2, muscle', other_designations='cofilin-2', map_location='12 C1', chromosome='12', genomic_nucleotide_accession_version='NC_000078.6', start_position_on_the_genomic_accession=54858815, end_position_on_the_genomic_accession=54862877, orientation='minus', exon_count=4, OMIM=[], no_hdr0=''),
    12633 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=12633, CurrentID=0, Status='live', Symbol='Cflar', Aliases=['2310024N18Rik', 'A430105C05Rik', 'CLARP', 'Ca', 'Cash', 'Casper', 'F', 'FLAME', 'FLAME-1', 'Flip', 'Gm9845', 'I-FLICE', 'MRIT', 'c-F', 'c-Flip'], description='CASP8 and FADD-like apoptosis regulator', other_designations='CASP8 and FADD-like apoptosis regulator|FADD-like antiapoptotic molecule 1|MACH-related inducer of toxicity|caspase homolog|caspase-eight-related protein|caspase-like apoptosis regulatory protein|cellular FLICE-like inhibitory protein|inhibitor of FLICE|usurpin', map_location='1 29.16 cM', chromosome='1', genomic_nucleotide_accession_version='NC_000067.6', start_position_on_the_genomic_accession=58711311, end_position_on_the_genomic_accession=58758884, orientation='plus', exon_count=16, OMIM=[], no_hdr0=''),
    12638 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=12638, CurrentID=0, Status='live', Symbol='Cftr', Aliases=['AW495489', 'Abcc', 'Abcc7'], description='cystic fibrosis transmembrane conductance regulator', other_designations='cystic fibrosis transmembrane conductance regulator|ATP-binding cassette sub-family C member 7|ATP-binding cassette transporter sub-family C member 7|ATP-binding cassette, subfamily c, member 7|cAMP-dependent chloride channel|channel conductance-controlling ATPase|cystic fibrosis transmembrane conductance regulator homolog|cystic fibrosis transmembrane conductance regulator homolog; ATP-binding cassette, subfamily c, member 7', map_location='6 8.1 cM', chromosome='6', genomic_nucleotide_accession_version='NC_000072.6', start_position_on_the_genomic_accession=18170687, end_position_on_the_genomic_accession=18322770, orientation='plus', exon_count=27, OMIM=[], no_hdr0=''),
    12640 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=12640, CurrentID=0, Status='live', Symbol='Cga', Aliases=['CG-alpha', 'FSHA', 'GPH', 'GPHA1', 'GPHalpha', 'HCG', 'LHA', 'Ts', 'Tsha', 'aG', 'aGSU', 'al', 'alp', 'alph', 'alpha-GSU', 'alphaGSU', 'alphaSU'], description='glycoprotein hormones, alpha subunit', other_designations='glycoprotein hormones alpha chain|FSH-alpha|LSH-alpha|TSH-alpha|anterior pituitary glycoprotein hormones common subunit alpha|follicle-stimulating hormone alpha chain|follitropin alpha chain|luteinizing hormone alpha chain|lutropin alpha chain|thyroid-stimulating hormone alpha chain|thyrotropin alpha chain', map_location='4 16.86 cM', chromosome='4', genomic_nucleotide_accession_version='NC_000070.6', start_position_on_the_genomic_accession=34893779, end_position_on_the_genomic_accession=34907374, orientation='plus', exon_count=5, OMIM=[], no_hdr0=''),
    12642 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=12642, CurrentID=0, Status='live', Symbol='Ch25h', Aliases=['AI462618', 'm25O', 'm25OH'], description='cholesterol 25-hydroxylase', other_designations='cholesterol 25-hydroxylase|cholesterol 25-monooxygenase', map_location='19 C1', chromosome='19', genomic_nucleotide_accession_version='NC_000085.6', start_position_on_the_genomic_accession=34473783, end_position_on_the_genomic_accession=34475148, orientation='minus', exon_count=1, OMIM=[], no_hdr0=''),
    12643 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=12643, CurrentID=0, Status='live', Symbol='Chad', Aliases=['S', 'SLRR4A'], description='chondroadherin', other_designations='chondroadherin|cartilage leucine-rich protein', map_location='11 58.9 cM', chromosome='11', genomic_nucleotide_accession_version='NC_000077.6', start_position_on_the_genomic_accession=94565047, end_position_on_the_genomic_accession=94569127, orientation='plus', exon_count=4, OMIM=[], no_hdr0=''),
    12647 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=12647, CurrentID=0, Status='live', Symbol='Chat', Aliases=['B230380D24Rik', 'CHOACTase'], description='choline acetyltransferase', other_designations='choline O-acetyltransferase|choline acetylase', map_location='14 19.4 cM', chromosome='14', genomic_nucleotide_accession_version='NC_000080.6', start_position_on_the_genomic_accession=32408203, end_position_on_the_genomic_accession=32465909, orientation='minus', exon_count=16, OMIM=[], no_hdr0=''),
    12648 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=12648, CurrentID=0, Status='live', Symbol='Chd1', Aliases=['4930525N21Rik', 'AI851787', 'AW555109'], description='chromodomain helicase DNA binding protein 1', other_designations='chromodomain-helicase-DNA-binding protein 1|ATP-dependent helicase CHD1|CHD-1', map_location='17 8.95 cM', chromosome='17', genomic_nucleotide_accession_version='NC_000083.6', start_position_on_the_genomic_accession=15704967, end_position_on_the_genomic_accession=15772612, orientation='plus', exon_count=36, OMIM=[], no_hdr0=''),
    12649 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=12649, CurrentID=0, Status='live', Symbol='Chek1', Aliases=['C85740', 'Chk1', 'rad27'], description='checkpoint kinase 1', other_designations='serine/threonine-protein kinase Chk1|CHK1 checkpoint homolog|checkpoint kinase 1 homolog|rad27 homolog', map_location='9 A4', chromosome='9', genomic_nucleotide_accession_version='NC_000075.6', start_position_on_the_genomic_accession=36708482, end_position_on_the_genomic_accession=36726658, orientation='minus', exon_count=14, OMIM=[], no_hdr0=''),
    12651 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=12651, CurrentID=0, Status='live', Symbol='Chkb', Aliases=['CK/EK-bet', 'Chetk', 'Chk', 'Chkl', 'Ck', 'Ck/Ek', 'Ck/Ek-beta', 'Ckb', 'Ckekb', 'Ek'], description='choline kinase beta', other_designations='choline/ethanolamine kinase|choline/ethanolamine kinase-b|choline/ethanolaminekinase|ethanolamine kinase', map_location='15 E3', chromosome='15', genomic_nucleotide_accession_version='NC_000081.6', start_position_on_the_genomic_accession=89426349, end_position_on_the_genomic_accession=89429927, orientation='minus', exon_count=10, OMIM=[], no_hdr0=''),
    12652 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=12652, CurrentID=0, Status='live', Symbol='Chga', Aliases=['Ch', 'ChrA', 'cgA'], description='chromogranin A', other_designations='chromogranin-A', map_location='12 51.66 cM', chromosome='12', genomic_nucleotide_accession_version='NC_000078.6', start_position_on_the_genomic_accession=102554941, end_position_on_the_genomic_accession=102565027, orientation='plus', exon_count=8, OMIM=[], no_hdr0=''),
    12653 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=12653, CurrentID=0, Status='live', Symbol='Chgb', Aliases=['Scg-', 'Scg-1', 'cgB', 'sgI'], description='chromogranin B', other_designations='secretogranin-1|secretogranin I', map_location='2 64.74 cM', chromosome='2', genomic_nucleotide_accession_version='NC_000068.7', start_position_on_the_genomic_accession=132781642, end_position_on_the_genomic_accession=132795079, orientation='plus', exon_count=5, OMIM=[], no_hdr0=''),
    12654 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=12654, CurrentID=0, Status='live', Symbol='Chil1', Aliases=['AW208766', 'Brp', 'Brp39', 'Chi3', 'Chi3l1', 'Gp3', 'Gp39'], description='chitinase-like 1', other_designations='chitinase-3-like protein 1|CGP-39|GP-39|breast regression protein 39|cartilage glycoprotein 39|chitinase 3-like 1', map_location='1 58.15 cM', chromosome='1', genomic_nucleotide_accession_version='NC_000067.6', start_position_on_the_genomic_accession=134182156, end_position_on_the_genomic_accession=134190031, orientation='plus', exon_count=11, OMIM=[], no_hdr0=''),
    12655 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=12655, CurrentID=0, Status='live', Symbol='Chil3', Aliases=['AI505981', 'Chi3', 'Chi3l3', 'ECF-L', 'Ym1'], description='chitinase-like 3', other_designations='chitinase-like protein 3|beta-N-acetylhexosaminidase Ym1|eosinophil chemotactic cytokine|eosinophil chemotactic factor-L|secreted protein Ym1', map_location='3 46.49 cM', chromosome='3', genomic_nucleotide_accession_version='NC_000069.6', start_position_on_the_genomic_accession=106147554, end_position_on_the_genomic_accession=106167564, orientation='minus', exon_count=11, OMIM=[], no_hdr0=''),
    12659 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=12659, CurrentID=0, Status='live', Symbol='Ovgp1', Aliases=['120kDa', 'AU016433', 'AU019448', 'Chit', 'Chit5', 'MO', 'MOGP', 'O', 'OGP', 'muc9', 'ovid'], description='oviductal glycoprotein 1', other_designations='oviduct-specific glycoprotein|chitinase 5|estrogen-dependent oviduct protein|mucin 9|oviduct glycoprotein OGP|oviductal glycoprotein 1, 120kD|oviductin', map_location='3 F2.2', chromosome='3', genomic_nucleotide_accession_version='NC_000069.6', start_position_on_the_genomic_accession=105973802, end_position_on_the_genomic_accession=105987423, orientation='plus', exon_count=11, OMIM=[], no_hdr0=''),
    12660 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=12660, CurrentID=0, Status='live', Symbol='Chka', Aliases=['CK', 'CK/EK-a', 'CK/EK-alpha', 'Chetk-alpha', 'Chk', 'Cho', 'ChoK', 'EK', 'EtnK-', 'EtnK-alpha'], description='choline kinase alpha', other_designations='choline kinase alpha|choline/ethanolamine kinase alpha|ethanolamine kinase', map_location='19 3.57 cM', chromosome='19', genomic_nucleotide_accession_version='NC_000085.6', start_position_on_the_genomic_accession=3851585, end_position_on_the_genomic_accession=3894369, orientation='plus', exon_count=16, OMIM=[], no_hdr0=''),
    12661 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=12661, CurrentID=0, Status='live', Symbol='Chl1', Aliases=['A530023M13Rik', 'AI465420', 'C', 'CALL', 'LIC', 'LICAM2'], description='cell adhesion molecule L1-like', other_designations='neural cell adhesion molecule L1-like protein|cell adhesion molecule with homology to L1CAM|chl1-like protein|close homolog of L1', map_location='6 E1', chromosome='6', genomic_nucleotide_accession_version='NC_000072.6', start_position_on_the_genomic_accession=103510584, end_position_on_the_genomic_accession=103733038, orientation='plus', exon_count=30, OMIM=[], no_hdr0=''),
    12662 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=12662, CurrentID=0, Status='live', Symbol='Chm', Aliases=['Rep', 'Rep-1'], description='choroidermia (RAB escort protein 1)', other_designations='rab proteins geranylgeranyltransferase component A 1|choroideraemia protein homolog|choroideremia protein homolog|rab escort protein 1', map_location='X E1', chromosome='X', genomic_nucleotide_accession_version='NC_000086.7', start_position_on_the_genomic_accession=113040592, end_position_on_the_genomic_accession=113185539, orientation='minus', exon_count=18, OMIM=[], no_hdr0=''),
    12663 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=12663, CurrentID=0, Status='live', Symbol='Chml', Aliases=['AI450814', 'E030003F13Rik', 'REP-2', 'Re', 'Rep2'], description='choroideremia-like', other_designations='rab proteins geranylgeranyltransferase component A 2|choroideraemia-like protein|choroideremia-like protein|rab escort protein-2', map_location='1 81.7 cM', chromosome='1', genomic_nucleotide_accession_version='NC_000067.6', start_position_on_the_genomic_accession=175682237, end_position_on_the_genomic_accession=175688353, orientation='minus', exon_count=1, OMIM=[], no_hdr0=''),
    12667 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=12667, CurrentID=0, Status='live', Symbol='Chrd', Aliases=['Chd'], description='chordin', other_designations='chordin', map_location='16 12.51 cM', chromosome='16', genomic_nucleotide_accession_version='NC_000082.6', start_position_on_the_genomic_accession=20731425, end_position_on_the_genomic_accession=20742384, orientation='plus', exon_count=24, OMIM=[], no_hdr0=''),
    12669 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=12669, CurrentID=0, Status='live', Symbol='Chrm1', Aliases=['AW49504', 'Chrm-', 'Chrm-1', 'M1', 'M1R'], description='cholinergic receptor, muscarinic 1, CNS', other_designations='muscarinic acetylcholine receptor M1|AChR M1|m1 muscarinic acetylcholine receptor protein', map_location='19 A', chromosome='19', genomic_nucleotide_accession_version='NC_000085.6', start_position_on_the_genomic_accession=8664005, end_position_on_the_genomic_accession=8683606, orientation='plus', exon_count=3, OMIM=[], no_hdr0=''),
    12671 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=12671, CurrentID=0, Status='live', Symbol='Chrm3', Aliases=['Chrm-', 'Chrm-3', 'M3', 'M3R'], description='cholinergic receptor, muscarinic 3, cardiac', other_designations='muscarinic acetylcholine receptor M3|AChR M3|mm3 mAChR|muscarinic acetylcholine receptor 3', map_location='13 3.72 cM', chromosome='13', genomic_nucleotide_accession_version='NC_000079.6', start_position_on_the_genomic_accession=9875486, end_position_on_the_genomic_accession=10361062, orientation='minus', exon_count=5, OMIM=[], no_hdr0=''),
    12672 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=12672, CurrentID=0, Status='live', Symbol='Chrm4', Aliases=['Chrm-', 'Chrm-4', 'M4'], description='cholinergic receptor, muscarinic 4', other_designations='muscarinic acetylcholine receptor M4|AChR M4|mm4 mAChR|muscarinic acetylcholine receptor 4', map_location='2 50.63 cM', chromosome='2', genomic_nucleotide_accession_version='NC_000068.7', start_position_on_the_genomic_accession=91922189, end_position_on_the_genomic_accession=91929835, orientation='plus', exon_count=3, OMIM=[], no_hdr0=''),
    12675 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=12675, CurrentID=0, Status='live', Symbol='Chuk', Aliases=['AI2566581', 'Fbx24', 'Fbxo24', 'IKBKA', 'IKK', 'IKK alpha', 'IKK-', 'IKK1', 'IKK[', 'Ikka', 'NFKBIKA', 'Chuk'], description='conserved helix-loop-helix ubiquitous kinase', other_designations='inhibitor of nuclear factor kappa-B kinase subunit alpha|I kappa B kinase 1|I-kappa-B kinase alpha|IkappaB kinase alpha|nuclear factor NF-kappa-B inhibitor kinase alpha', map_location='19 36.71 cM', chromosome='19', genomic_nucleotide_accession_version='NC_000085.6', start_position_on_the_genomic_accession=44073334, end_position_on_the_genomic_accession=44107505, orientation='minus', exon_count=21, OMIM=[], no_hdr0=''),
    12677 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=12677, CurrentID=0, Status='live', Symbol='Vsx2', Aliases=['Chx10', 'Hox-1', 'Hox-10', 'Hox1', 'Hox10', 'or'], description='visual system homeobox 2', other_designations='visual system homeobox 2|C. elegans ceh-10 homeo domain containing homolog|ceh-10 homeodomain-containing homolog|homeobox protein CHX10|ocular retardation', map_location='12 39.28 cM', chromosome='12', genomic_nucleotide_accession_version='NC_000078.6', start_position_on_the_genomic_accession=84569828, end_position_on_the_genomic_accession=84595457, orientation='plus', exon_count=5, OMIM=[], no_hdr0=''),
    12683 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=12683, CurrentID=0, Status='live', Symbol='Cidea', Aliases=['AW212747'], description='cell death-inducing DNA fragmentation factor, alpha subunit-like effector A', other_designations='cell death activator CIDE-A|cell death-inducing DFFA-like effector A', map_location='18 E1', chromosome='18', genomic_nucleotide_accession_version='NC_000084.6', start_position_on_the_genomic_accession=67343564, end_position_on_the_genomic_accession=67367794, orientation='plus', exon_count=5, OMIM=[], no_hdr0=''),
    12684 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=12684, CurrentID=0, Status='live', Symbol='Cideb', Aliases=['1110030C18Rik', 'AI790179', 'CIDE-', 'CIDE-B'], description='cell death-inducing DNA fragmentation factor, alpha subunit-like effector B', other_designations='cell death activator CIDE-B|DFFA-like B|cell death-inducing DFFA-like effector B', map_location='14 C3', chromosome='14', genomic_nucleotide_accession_version='NC_000080.6', start_position_on_the_genomic_accession=55754052, end_position_on_the_genomic_accession=55758424, orientation='minus', exon_count=5, OMIM=[], no_hdr0=''),
    12686 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=12686, CurrentID=0, Status='live', Symbol='Elovl3', Aliases=['CIN', 'CIN-2', 'Cig3', 'Cig30'], description='elongation of very long chain fatty acids (FEN1/Elo2, SUR4/Elo3, yeast)-like 3', other_designations='elongation of very long chain fatty acids protein 3|3-keto acyl-CoA synthase Elovl3|ELOVL FA elongase 3|ELOVL fatty acid elongase 3|cold inducible glycoprotein 30|cold-inducible glycoprotein of 30 kDa|elongation of very long chain fatty acids-like 3|very long chain 3-ketoacyl-CoA synthase 3|very long chain 3-oxoacyl-CoA synthase 3', map_location='19 38.75 cM', chromosome='19', genomic_nucleotide_accession_version='NC_000085.6', start_position_on_the_genomic_accession=46131897, end_position_on_the_genomic_accession=46135694, orientation='plus', exon_count=4, OMIM=[], no_hdr0=''),
    12695 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=12695, CurrentID=0, Status='live', Symbol='Patj', Aliases=['C', 'Cipp', 'I', 'Inadl'], description='PATJ, crumbs cell polarity complex component', other_designations='inaD-like protein|PALS1-associated tight junction protein|channel-interacting PDZ domain protein|channel-interacting PDZ domain-containing protein|inactivation no after-potential D-like protein|novel ankyrin-repeat protein|protein associated to tight junctions', map_location='4 C6', chromosome='4', genomic_nucleotide_accession_version='NC_000070.6', start_position_on_the_genomic_accession=98395560, end_position_on_the_genomic_accession=98719603, orientation='plus', exon_count=49, OMIM=[], no_hdr0=''),
    12696 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=12696, CurrentID=0, Status='live', Symbol='Cirbp', Aliases=['C', 'Cirp', 'R74941'], description='cold inducible RNA binding protein', other_designations='cold-inducible RNA-binding protein|A18 hnRNP|glycine-rich RNA-binding protein CIRP', map_location='10 39.72 cM', chromosome='10', genomic_nucleotide_accession_version='NC_000076.6', start_position_on_the_genomic_accession=80165990, end_position_on_the_genomic_accession=80172786, orientation='plus', exon_count=10, OMIM=[], no_hdr0=''),
    12700 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=12700, CurrentID=0, Status='live', Symbol='Cish', Aliases=['C', 'CI', 'CIS-1', 'CIS1', 'Cis', 'F17', 'F23', 'SOCS'], description='cytokine inducible SH2-containing protein', other_designations='cytokine-inducible SH2-containing protein|cytokine-inducible SH2 protein|suppressor of cytokine signaling', map_location='9 57.99 cM', chromosome='9', genomic_nucleotide_accession_version='NC_000075.6', start_position_on_the_genomic_accession=107296659, end_position_on_the_genomic_accession=107302784, orientation='plus', exon_count=4, OMIM=[], no_hdr0=''),
    12702 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=12702, CurrentID=0, Status='live', Symbol='Socs3', Aliases=['CI', 'Cis', 'Cis3', 'Cish3', 'EF-10', 'Ef10', 'SOC', 'SS', 'SSI-3', 'Ssi3'], description='suppressor of cytokine signaling 3', other_designations='suppressor of cytokine signaling 3|CIS-3|E2a-Pbx1 target gene in fibroblasts 10|STAT-induced STAT inhibitor 3|cytokine inducible SH2-containing protein 3', map_location='11 E2', chromosome='11', genomic_nucleotide_accession_version='NC_000077.6', start_position_on_the_genomic_accession=117966079, end_position_on_the_genomic_accession=117970336, orientation='minus', exon_count=3, OMIM=[], no_hdr0=''),
    12703 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=12703, CurrentID=0, Status='live', Symbol='Socs1', Aliases=['Cis', 'Cish1', 'Cish7', 'JA', 'JAB', 'SOC', 'SOCS-1', 'SS', 'SSI-1'], description='suppressor of cytokine signaling 1', other_designations='suppressor of cytokine signaling 1|JAK2-binding protein|STAT-induced STAT inhibitor 1|cytokine inducible SH2-containing protein 1|cytokine inducible SH2-containing protein 7', map_location='16 5.81 cM', chromosome='16', genomic_nucleotide_accession_version='NC_000082.6', start_position_on_the_genomic_accession=10783808, end_position_on_the_genomic_accession=10785536, orientation='minus', exon_count=2, OMIM=[], no_hdr0=''),
    12704 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=12704, CurrentID=0, Status='live', Symbol='Cit', Aliases=['C030025P15Rik', 'CRIK', 'CRIK-SK-', 'Cit-k', 'Cit'], description='citron', other_designations='citron Rho-interacting kinase|citron kinase|citron-N|rho-interacting, serine/threonine-protein kinase 21', map_location='5 F', chromosome='5', genomic_nucleotide_accession_version='NC_000071.6', start_position_on_the_genomic_accession=115845224, end_position_on_the_genomic_accession=116008953, orientation='plus', exon_count=54, OMIM=[], no_hdr0=''),
    12705 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=12705, CurrentID=0, Status='live', Symbol='Cited1', Aliases=['AI316840', 'AU019144', 'Msg', 'Msg1'], description='Cbp/p300-interacting transactivator with Glu/Asp-rich carboxy-terminal domain 1', other_designations='cbp/p300-interacting transactivator 1|melanocyte-specific protein 1', map_location='X 45.25 cM', chromosome='X', genomic_nucleotide_accession_version='NC_000086.7', start_position_on_the_genomic_accession=102247378, end_position_on_the_genomic_accession=102252181, orientation='minus', exon_count=5, OMIM=[], no_hdr0=''),
    12709 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=12709, CurrentID=0, Status='live', Symbol='Ckb', Aliases=['B-CK', 'Bck', 'CPK-B', 'Ck-3', 'Ck3b', 'Ckb'], description='creatine kinase, brain', other_designations='creatine kinase B-type|creatine kinase B chain|creatine phosphokinase B-type', map_location='12 61.09 cM', chromosome='12', genomic_nucleotide_accession_version='NC_000078.6', start_position_on_the_genomic_accession=111669355, end_position_on_the_genomic_accession=111672338, orientation='minus', exon_count=8, OMIM=[], no_hdr0=''),
    12715 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=12715, CurrentID=0, Status='live', Symbol='Ckm', Aliases=['CPK-Mm', 'M-CK', 'MCK', 'Ckm'], description='creatine kinase, muscle', other_designations='creatine kinase M-type|creatine kinase M chain|creatine phosphokinase M-type', map_location='7 9.67 cM', chromosome='7', genomic_nucleotide_accession_version='NC_000073.6', start_position_on_the_genomic_accession=19411094, end_position_on_the_genomic_accession=19421583, orientation='plus', exon_count=8, OMIM=[], no_hdr0=''),
    12716 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=12716, CurrentID=0, Status='live', Symbol='Ckmt1', Aliases=['Mt-CK', 'ScCKmit', 'U-MtCK', 'UbCKmi', 'UbCKmit', 'mi-C', 'mi-CK', 'mia-CK'], description='creatine kinase, mitochondrial 1, ubiquitous', other_designations='creatine kinase U-type, mitochondrial|acidic-type mitochondrial creatine kinase|ubiquitous mitochondrial creatine kinase', map_location='2 60.37 cM', chromosome='2', genomic_nucleotide_accession_version='NC_000068.7', start_position_on_the_genomic_accession=121357773, end_position_on_the_genomic_accession=121363737, orientation='plus', exon_count=10, OMIM=[], no_hdr0=''),
    12721 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=12721, CurrentID=0, Status='live', Symbol='Coro1a', Aliases=['Cl', 'Clabp', 'Lmb', 'Lmb3', 'TACO', 'p5', 'p57'], description='coronin, actin binding protein 1A', other_designations='coronin-1A|clipin-A|coronin 1|coronin-like actin binding protein|coronin-like protein A|coronin-like protein p57|tryptophan aspartate-containing coat protein', map_location='7 F3', chromosome='7', genomic_nucleotide_accession_version='NC_000073.6', start_position_on_the_genomic_accession=126699774, end_position_on_the_genomic_accession=126704816, orientation='minus', exon_count=12, OMIM=[], no_hdr0=''),
    12722 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=12722, CurrentID=0, Status='live', Symbol='Clca3a1', Aliases=['Cacc', 'Clc', 'Clca1'], description='chloride channel accessory 3A1', other_designations='calcium-activated chloride channel regulator 3A-1|chloride channel calcium activated 1|chloride channel calcium activated 3A1', map_location='3 69.06 cM', chromosome='3', genomic_nucleotide_accession_version='NC_000069.6', start_position_on_the_genomic_accession=144729677, end_position_on_the_genomic_accession=144760977, orientation='minus', exon_count=16, OMIM=[], no_hdr0=''),
    12723 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=12723, CurrentID=0, Status='live', Symbol='Clcn1', Aliases=['Clc', 'Clc-', 'Clc-1', 'Clc1', 'NMF35', 'SMCC', 'SMCC1', 'adr', 'mto', 'myotonia', 'nmf355'], description='chloride channel, voltage-sensitive 1', other_designations='chloride channel protein 1|arrested development of righting response|chloride channel protein, skeletal muscle', map_location='6 20.57 cM', chromosome='6', genomic_nucleotide_accession_version='NC_000072.6', start_position_on_the_genomic_accession=42284851, end_position_on_the_genomic_accession=42315764, orientation='plus', exon_count=25, OMIM=[], no_hdr0=''),
    12724 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=12724, CurrentID=0, Status='live', Symbol='Clcn2', Aliases=['AL118368', 'ClC-', 'ClC-2', 'Clc', 'Clc2', 'nmf24', 'nmf240'], description='chloride channel, voltage-sensitive 2', other_designations='chloride channel protein 2|chloride channel 2', map_location='16 12.5 cM', chromosome='16', genomic_nucleotide_accession_version='NC_000082.6', start_position_on_the_genomic_accession=20702435, end_position_on_the_genomic_accession=20717746, orientation='minus', exon_count=25, OMIM=[], no_hdr0=''),
    12725 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=12725, CurrentID=0, Status='live', Symbol='Clcn3', Aliases=['Clc', 'Clc3'], description='chloride channel, voltage-sensitive 3', other_designations='H(+)/Cl(-) exchange transporter 3|chloride channel 3|chloride channel protein 3|chloride transporter ClC-3|clC-3', map_location='8 30.9 cM', chromosome='8', genomic_nucleotide_accession_version='NC_000074.6', start_position_on_the_genomic_accession=60910389, end_position_on_the_genomic_accession=60983317, orientation='minus', exon_count=17, OMIM=[], no_hdr0=''),
    12727 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=12727, CurrentID=0, Status='live', Symbol='Clcn4', Aliases=['Clc4-', 'Clc4-2-2', 'clC-4', 'Clcn4'], description='chloride channel, voltage-sensitive 4', other_designations='H(+)/Cl(-) exchange transporter 4|chloride channel 4-2|chloride channel protein 4|chloride transporter ClC-4|voltage-gated chloride channel ClC-4A', map_location='7 4.23 cM', chromosome='7', genomic_nucleotide_accession_version='NC_000073.6', start_position_on_the_genomic_accession=7282309, end_position_on_the_genomic_accession=7300916, orientation='minus', exon_count=15, OMIM=[], no_hdr0=''),
    12728 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=12728, CurrentID=0, Status='live', Symbol='Clcn5', Aliases=['5430408K11Rik', 'ClC-', 'ClC-5', 'Clc', 'Clc4-', 'Clc4-1', 'Clc5', 'Clcn4', 'Clcn4-1', 'D930009B12Rik', 'DXImx42', 'DXImx42e', 'Sfc1', 'Sfc13', 'T25545'], description='chloride channel, voltage-sensitive 5', other_designations='H(+)/Cl(-) exchange transporter 5|chloride channel 4-1|chloride channel 5|chloride channel protein 5|chloride transporter ClC-5', map_location='X 3.21 cM', chromosome='X', genomic_nucleotide_accession_version='NC_000086.7', start_position_on_the_genomic_accession=7153810, end_position_on_the_genomic_accession=7319358, orientation='minus', exon_count=19, OMIM=[], no_hdr0=''),
    12729 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=12729, CurrentID=0, Status='live', Symbol='Clns1a', Aliases=['2610036D06Rik', '2610100O04Rik', 'Cl', 'Clci', 'Clcni', 'I', 'ICLN'], description='chloride channel, nucleotide-sensitive, 1A', other_designations='methylosome subunit pICln|chloride channel current inducer|chloride channel regulator|chloride conductance regulatory protein ICln|chloride ion current inducer protein|i(Cln)', map_location='7 53.57 cM', chromosome='7', genomic_nucleotide_accession_version='NC_000073.6', start_position_on_the_genomic_accession=97696657, end_position_on_the_genomic_accession=97720793, orientation='plus', exon_count=7, OMIM=[], no_hdr0=''),
    12733 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=12733, CurrentID=0, Status='live', Symbol='Clcnka', Aliases=['C75963', 'CLC-K', 'CLC-K1', 'Clcn', 'Clcnk1'], description='chloride channel, voltage-sensitive Ka', other_designations='chloride channel protein ClC-Ka|chloride channel K1|chloride channel Ka|putative basolateral cTAL chloride channel ClC-Ka', map_location='4 D3', chromosome='4', genomic_nucleotide_accession_version='NC_000070.6', start_position_on_the_genomic_accession=141384611, end_position_on_the_genomic_accession=141398706, orientation='minus', exon_count=20, OMIM=[], no_hdr0=''),
    12737 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=12737, CurrentID=0, Status='live', Symbol='Cldn1', Aliases=['AI596271'], description='claudin 1', other_designations='claudin-1', map_location='16 B2', chromosome='16', genomic_nucleotide_accession_version='NC_000082.6', start_position_on_the_genomic_accession=26356645, end_position_on_the_genomic_accession=26371839, orientation='minus', exon_count=4, OMIM=[], no_hdr0=''),
    12738 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=12738, CurrentID=0, Status='live', Symbol='Cldn2', Aliases=['AL022813'], description='claudin 2', other_designations='claudin-2', map_location='X F1', chromosome='X', genomic_nucleotide_accession_version='NC_000086.7', start_position_on_the_genomic_accession=139800808, end_position_on_the_genomic_accession=139811386, orientation='plus', exon_count=4, OMIM=[], no_hdr0=''),
    12739 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=12739, CurrentID=0, Status='live', Symbol='Cldn3', Aliases=['AI182374', 'Cpet', 'Cpetr2', 'mRVP1'], description='claudin 3', other_designations='claudin-3|CPE-R 2|CPE-receptor 2|clostridium perfringens enterotoxin receptor 2', map_location='5 74.93 cM', chromosome='5', genomic_nucleotide_accession_version='NC_000071.6', start_position_on_the_genomic_accession=134986214, end_position_on_the_genomic_accession=134987476, orientation='plus', exon_count=1, OMIM=[], no_hdr0=''),
    12740 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=12740, CurrentID=0, Status='live', Symbol='Cldn4', Aliases=['Cep-r', 'Cpe', 'Cpet', 'Cpetr', 'Cpetr1'], description='claudin 4', other_designations='claudin-4|CPE-R|CPE-receptor|clostridium perfringens enterotoxin receptor', map_location='5 74.9 cM', chromosome='5', genomic_nucleotide_accession_version='NC_000071.6', start_position_on_the_genomic_accession=134945123, end_position_on_the_genomic_accession=134946934, orientation='minus', exon_count=1, OMIM=[], no_hdr0=''),
    12741 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=12741, CurrentID=0, Status='live', Symbol='Cldn5', Aliases=['AI854493', 'MBEC1', 'Tmvc', 'Tmvcf'], description='claudin 5', other_designations='claudin-5|brain endothelial cell clone 1 protein|lung-specific membrane protein|transmembrane protein deleted in VCFS', map_location='16 11.63 cM', chromosome='16', genomic_nucleotide_accession_version='NC_000082.6', start_position_on_the_genomic_accession=18776847, end_position_on_the_genomic_accession=18778262, orientation='plus', exon_count=1, OMIM=[], no_hdr0=''),
    12745 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=12745, CurrentID=0, Status='live', Symbol='Clgn', Aliases=['4930459O04Rik', 'A2/', 'A2/6', 'AI528775', 'C', 'Cln', 'calne'], description='calmegin', other_designations='calmegin|MEG 1 antigen|calnexin-T', map_location='8 39.97 cM', chromosome='8', genomic_nucleotide_accession_version='NC_000074.6', start_position_on_the_genomic_accession=83389790, end_position_on_the_genomic_accession=83428552, orientation='plus', exon_count=17, OMIM=[], no_hdr0=''),
    12747 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=12747, CurrentID=0, Status='live', Symbol='Clk1', Aliases=['Clk', 'ST', 'STY'], description='CDC-like kinase 1', other_designations='dual specificity protein kinase CLK1|protein kinase STY', map_location='1 29.09 cM', chromosome='1', genomic_nucleotide_accession_version='NC_000067.6', start_position_on_the_genomic_accession=58411988, end_position_on_the_genomic_accession=58424088, orientation='minus', exon_count=13, OMIM=[], no_hdr0=''),
    12748 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=12748, CurrentID=0, Status='live', Symbol='Clk2', Aliases=['AU041688'], description='CDC-like kinase 2', other_designations='dual specificity protein kinase CLK2', map_location='3 F1', chromosome='3', genomic_nucleotide_accession_version='NC_000069.6', start_position_on_the_genomic_accession=89164795, end_position_on_the_genomic_accession=89177087, orientation='plus', exon_count=13, OMIM=[], no_hdr0=''),
    12750 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=12750, CurrentID=0, Status='live', Symbol='Clk4', Aliases=['AI987988', 'C85119'], description='CDC like kinase 4', other_designations='dual specificity protein kinase CLK4', map_location='11 B1.3', chromosome='11', genomic_nucleotide_accession_version='NC_000077.6', start_position_on_the_genomic_accession=51263114, end_position_on_the_genomic_accession=51281770, orientation='plus', exon_count=16, OMIM=[], no_hdr0=''),
    12751 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=12751, CurrentID=0, Status='live', Symbol='Tpp1', Aliases=['Cl', 'Cln2', 'LPIC', 'TPP-1', 'TPP-I'], description='tripeptidyl peptidase I', other_designations='tripeptidyl-peptidase 1|ceroid-lipofuscinosis, neuronal 2|lysosomal pepstatin-insensitive protease|tripeptidyl aminopeptidase', map_location='7 55.97 cM', chromosome='7', genomic_nucleotide_accession_version='NC_000073.6', start_position_on_the_genomic_accession=105744811, end_position_on_the_genomic_accession=105752282, orientation='minus', exon_count=14, OMIM=[], no_hdr0=''),
    12752 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=12752, CurrentID=0, Status='live', Symbol='Cln3', Aliases=['AI323623', 'batt'], description='ceroid lipofuscinosis, neuronal 3, juvenile (Batten, Spielmeyer-Vogt disease)', other_designations='battenin', map_location='7 69.16 cM', chromosome='7', genomic_nucleotide_accession_version='NC_000073.6', start_position_on_the_genomic_accession=126571207, end_position_on_the_genomic_accession=126585817, orientation='minus', exon_count=21, OMIM=[], no_hdr0=''),
    12753 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=12753, CurrentID=0, Status='live', Symbol='Clock', Aliases=['5330400M04Rik', 'KAT13', 'KAT13D', 'bHLHe'], description='circadian locomotor output cycles kaput', other_designations='circadian locomoter output cycles protein kaput', map_location='5 40.63 cM', chromosome='5', genomic_nucleotide_accession_version='NC_000071.6', start_position_on_the_genomic_accession=76209868, end_position_on_the_genomic_accession=76305603, orientation='minus', exon_count=25, OMIM=[], no_hdr0=''),
    12757 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=12757, CurrentID=0, Status='live', Symbol='Clta', Aliases=['AV026556', 'Lca'], description='clathrin, light polypeptide (Lca)', other_designations='clathrin light chain A|clathryn light chain (LCA2)', map_location='4 B1', chromosome='4', genomic_nucleotide_accession_version='NC_000070.6', start_position_on_the_genomic_accession=44003816, end_position_on_the_genomic_accession=44032846, orientation='plus', exon_count=9, OMIM=[], no_hdr0=''),
    12759 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=12759, CurrentID=0, Status='live', Symbol='Clu', Aliases=['A', 'AI893575', 'ApoJ', 'C', 'Cli', 'D14Ucl', 'D14Ucla3', 'SP-', 'SP-40', 'Sg', 'Sgp', 'Sgp-2', 'Sgp2', 'Sugp', 'Sugp-2'], description='clusterin', other_designations='clusterin|Apolipoprotein J|clustrin|complement lysis inhibitor|sulfated glycoprotein 2|testosterone repressed prostate message|testosterone repressed prostate message-2', map_location='14 34.36 cM', chromosome='14', genomic_nucleotide_accession_version='NC_000080.6', start_position_on_the_genomic_accession=65968483, end_position_on_the_genomic_accession=65981548, orientation='plus', exon_count=11, OMIM=[], no_hdr0=''),
    12763 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=12763, CurrentID=0, Status='live', Symbol='Cmah', Aliases=[], description='cytidine monophospho-N-acetylneuraminic acid hydroxylase', other_designations='cytidine monophosphate-N-acetylneuraminic acid hydroxylase|CMP-N-acetylneuraminate monooxygenase|CMP-N-acetylneuraminic acid hydroxylase|CMP-Neu5Ac hydroxylase|CMP-NeuAc hydroxylase', map_location='13 A3.1', chromosome='13', genomic_nucleotide_accession_version='NC_000079.6', start_position_on_the_genomic_accession=24327404, end_position_on_the_genomic_accession=24477289, orientation='plus', exon_count=20, OMIM=[], no_hdr0=''),
    12764 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=12764, CurrentID=0, Status='live', Symbol='Cmas', Aliases=['AW208911', 'CMPNeu5Ac', 'D6Bwg0250e'], description='cytidine monophospho-N-acetylneuraminic acid synthetase', other_designations='N-acylneuraminate cytidylyltransferase|CMP-N-acetylneuraminic acid synthase|CMP-N-acetylneuraminic acid synthetase|CMP-Neu5Ac synthase|CMP-NeuNAc synthase|CMP-NeuNAc synthetase|CMP-sialic acid synthetase', map_location='6 74.66 cM', chromosome='6', genomic_nucleotide_accession_version='NC_000072.6', start_position_on_the_genomic_accession=142756686, end_position_on_the_genomic_accession=142775714, orientation='plus', exon_count=9, OMIM=[], no_hdr0=''),
    12765 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=12765, CurrentID=0, Status='live', Symbol='Cxcr2', Aliases=['CD128', 'CDw128', 'Cmka', 'Cmkar2', 'Gpcr', 'Gpcr16', 'I', 'IL-', 'IL-8Rh', 'IL-8rb', 'IL8RA', 'Il', 'Il8rb', 'mIL-8RH'], description='chemokine (C-X-C motif) receptor 2', other_designations='C-X-C chemokine receptor type 2|CXC-R2|CXCR-2|GRO/MGSA receptor|IL-8 receptor alpha chain|IL-8R B|chemokine (C-X-C) receptor 2|high affinity interleukin-8 receptor B|interleukin 8 receptor, beta|interleukin-8 receptor type B', map_location='1 38.41 cM', chromosome='1', genomic_nucleotide_accession_version='NC_000067.6', start_position_on_the_genomic_accession=74153994, end_position_on_the_genomic_accession=74161246, orientation='plus', exon_count=3, OMIM=[], no_hdr0=''),
    12766 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=12766, CurrentID=0, Status='live', Symbol='Cxcr3', Aliases=['Cd183', 'Cmka', 'Cmkar3', 'Cxcr'], description='chemokine (C-X-C motif) receptor 3', other_designations='C-X-C chemokine receptor type 3|IP-10 receptor|interferon-inducible protein 10 receptor', map_location='X 44.58 cM', chromosome='X', genomic_nucleotide_accession_version='NC_000086.7', start_position_on_the_genomic_accession=101731535, end_position_on_the_genomic_accession=101734147, orientation='minus', exon_count=2, OMIM=[], no_hdr0=''),
    12767 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=12767, CurrentID=0, Status='live', Symbol='Cxcr4', Aliases=['CD184', 'CXC-R4', 'CXCR-4', 'Cmka', 'Cmkar4', 'LESTR', 'PB-C', 'PB-CKR', 'PBSF/SDF-1', 'Sdf', 'Sdf1r', 'b2b220C', 'b2b220Clo', 'fu'], description='chemokine (C-X-C motif) receptor 4', other_designations='C-X-C chemokine receptor type 4|SDF-1 receptor|chemokine (C-X-C) receptor 4|chemokine receptor 4|fusin|leukocyte-derived seven transmembrane domain receptor|leukocyte-expressed seven-transmembrane-domain|pre-B-cell-derived chemokine receptor|stromal cell-derived factor 1 receptor', map_location='1 56.43 cM', chromosome='1', genomic_nucleotide_accession_version='NC_000067.6', start_position_on_the_genomic_accession=128588199, end_position_on_the_genomic_accession=128592299, orientation='minus', exon_count=3, OMIM=[], no_hdr0=''),
    12768 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=12768, CurrentID=0, Status='live', Symbol='Ccr1', Aliases=['Cmkbr', 'Cmkbr1', 'Mip-1a-R'], description='chemokine (C-C motif) receptor 1', other_designations='C-C chemokine receptor type 1|C-C CKR-1|CC-CKR-1|CCR-1|MIP-1 alpha R|MIP-1 alphaR|MIP-1alpha-R|RANTES-R|chemokine (C-C) receptor 1|macrophage inflammatory protein 1-alpha receptor', map_location='9 75.05 cM', chromosome='9', genomic_nucleotide_accession_version='NC_000075.6', start_position_on_the_genomic_accession=123962126, end_position_on_the_genomic_accession=123968692, orientation='minus', exon_count=2, OMIM=[], no_hdr0=''),
    12769 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=12769, CurrentID=0, Status='live', Symbol='Ccr9', Aliases=['A130091K22Rik', 'Cmkbr1', 'Cmkbr10', 'GPR-9', 'GPR-9-6'], description='chemokine (C-C motif) receptor 9', other_designations='C-C chemokine receptor type 9|C-C CKR-9|CC-CKR-9|CCR-9|chemokine C-C receptor 10', map_location='9 74.33 cM', chromosome='9', genomic_nucleotide_accession_version='NC_000075.6', start_position_on_the_genomic_accession=123767211, end_position_on_the_genomic_accession=123783457, orientation='plus', exon_count=4, OMIM=[], no_hdr0=''),
    12770 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=12770, CurrentID=0, Status='live', Symbol='Ccr1l1', Aliases=['Cmkbr1', 'Cmkbr1l1'], description='chemokine (C-C motif) receptor 1-like 1', other_designations='C-C chemokine receptor 1-like protein 1|MIP-1 alphaRL1|chemokine (C-C) receptor 1-like 1|macrophage inflammatory protein-1 alpha receptor-like 1', map_location='9 75.05 cM', chromosome='9', genomic_nucleotide_accession_version='NC_000075.6', start_position_on_the_genomic_accession=123976430, end_position_on_the_genomic_accession=123986715, orientation='minus', exon_count=2, OMIM=[], no_hdr0=''),
    12771 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=12771, CurrentID=0, Status='live', Symbol='Ccr3', Aliases=['CC-CKR', 'CC-CKR3', 'CKR', 'CKR3', 'Cmkbr', 'Cmkbr1l2', 'Cmkbr3'], description='chemokine (C-C motif) receptor 3', other_designations='probable C-C chemokine receptor type 3|C-C CKR-3|CC chemokine receptor 3|CC-CKR-3|CCR-3|MIP-1 alpha RL2|MIP-1 alphaRL2|chemokine (C-C) receptor 1,-like 2|chemokine (C-C) receptor 3|macrophage inflammatory protein 1-alpha receptor-like 2', map_location='9 75.05 cM', chromosome='9', genomic_nucleotide_accession_version='NC_000075.6', start_position_on_the_genomic_accession=124017825, end_position_on_the_genomic_accession=124031692, orientation='plus', exon_count=3, OMIM=[], no_hdr0=''),
    12772 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=12772, CurrentID=0, Status='live', Symbol='Ccr2', Aliases=['CC-CKR-', 'CCR', 'CKR', 'Cc-ckr-2a', 'Ccr2b', 'Ckr2', 'Ckr2a', 'Ckr2b', 'Cmkbr', 'Cmkbr2', 'mJe-r', 'Ccr2'], description='chemokine (C-C motif) receptor 2', other_designations='C-C chemokine receptor type 2|C-C CHEMOKINE RECEPTOR TYPE 2 (C-C CKR-2) (CC-CKR-2) (CCR-2) (CCR2) (JE/FIC RECEPTOR) (MCP-1 RECEPTOR)|C-C CKR-2|CCR-2|JE/FIC receptor|MCP-1 receptor|MIP-1 alphaR|chemoattractant protein-1 receptor|chemokine (C-C) receptor 2', map_location='9 75.05 cM', chromosome='9', genomic_nucleotide_accession_version='NC_000075.6', start_position_on_the_genomic_accession=124101918, end_position_on_the_genomic_accession=124109140, orientation='plus', exon_count=5, OMIM=[], no_hdr0=''),
    12773 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=12773, CurrentID=0, Status='live', Symbol='Ccr4', Aliases=['C-C CKR-4', 'CHEMR1', 'Cmkbr', 'Cmkbr4', 'LESTR', 'Sdf1r'], description='chemokine (C-C motif) receptor 4', other_designations='C-C chemokine receptor type 4|chemokine (C-C) receptor 4|fusin|leukocyte-expressed seven-transmembrane-domain receptor', map_location='9 64.49 cM', chromosome='9', genomic_nucleotide_accession_version='NC_000075.6', start_position_on_the_genomic_accession=114490316, end_position_on_the_genomic_accession=114505476, orientation='minus', exon_count=6, OMIM=[], no_hdr0=''),
    12774 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=12774, CurrentID=0, Status='live', Symbol='Ccr5', Aliases=['AM4-7', 'CD195', 'Cmkbr', 'Cmkbr5'], description='chemokine (C-C motif) receptor 5', other_designations='C-C chemokine receptor type 5|C-C CKR-5|CC-CKR-5|CCR-5|MIP-1 alpha receptor|chemokine (C-C) receptor 5', map_location='9 75.05 cM', chromosome='9', genomic_nucleotide_accession_version='NC_000075.6', start_position_on_the_genomic_accession=124121543, end_position_on_the_genomic_accession=124127183, orientation='plus', exon_count=2, OMIM=[], no_hdr0=''),
    12775 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=12775, CurrentID=0, Status='live', Symbol='Ccr7', Aliases=['CC-CKR-7', 'CCR-7', 'CD197', 'Cdw197', 'Cmkbr', 'Cmkbr7', 'EBI', 'EBI1', 'Ebi1h'], description='chemokine (C-C motif) receptor 7', other_designations='C-C chemokine receptor type 7|EBV-induced G-protein coupled receptor 1|MIP-3 beta receptor|chemokine (C-C) receptor 7|epstein-Barr virus-induced G-protein coupled receptor 1', map_location='11 D', chromosome='11', genomic_nucleotide_accession_version='NC_000077.6', start_position_on_the_genomic_accession=99144199, end_position_on_the_genomic_accession=99155077, orientation='minus', exon_count=3, OMIM=[], no_hdr0=''),
    12776 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=12776, CurrentID=0, Status='live', Symbol='Ccr8', Aliases=['C-C', 'C-C CKR-8', 'CC-CKR-8', 'CCR-8', 'CKR-8', 'Cmkbr', 'Cmkbr8', 'mCCR8'], description='chemokine (C-C motif) receptor 8', other_designations='C-C chemokine receptor type 8|C-C motif chemokine receptor 8', map_location='9 F4', chromosome='9', genomic_nucleotide_accession_version='NC_000075.6', start_position_on_the_genomic_accession=120092133, end_position_on_the_genomic_accession=120094906, orientation='plus', exon_count=2, OMIM=[], no_hdr0=''),
    12777 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=12777, CurrentID=0, Status='live', Symbol='Ccr10', Aliases=['C-C CKR-10', 'CC-CKR-10', 'CCR-10', 'CCR1', 'Cmkbr', 'Cmkbr9', 'GP', 'Gpr2'], description='chemokine (C-C motif) receptor 10', other_designations='C-C chemokine receptor type 10|G protein-coupled receptor 2|chemokine C-C receptor 9', map_location='11 64.34 cM', chromosome='11', genomic_nucleotide_accession_version='NC_000077.6', start_position_on_the_genomic_accession=101172998, end_position_on_the_genomic_accession=101175443, orientation='minus', exon_count=2, OMIM=[], no_hdr0=''),
    12778 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=12778, CurrentID=0, Status='live', Symbol='Ackr3', Aliases=['AW541270', 'CXC-R7', 'CXCR-7', 'Cmko', 'Cmkor1', 'Cxcr', 'Cxcr7', 'RDC-1', 'Rdc', 'Rdc1'], description='atypical chemokine receptor 3', other_designations='atypical chemokine receptor 3|C-X-C chemokine receptor type 7|G-protein coupled receptor RDC1 homolog|chemokine (C-X-C motif) receptor 7|chemokine orphan receptor 1', map_location='1 45.28 cM', chromosome='1', genomic_nucleotide_accession_version='NC_000067.6', start_position_on_the_genomic_accession=90203980, end_position_on_the_genomic_accession=90215724, orientation='plus', exon_count=3, OMIM=[], no_hdr0=''),
    12780 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=12780, CurrentID=0, Status='live', Symbol='Abcc2', Aliases=['AI173996', 'Abc30', 'Cmo', 'Cmoat', 'Mr', 'Mrp2', 'cMRP'], description='ATP-binding cassette, sub-family C (CFTR/MRP), member 2', other_designations='canalicular multispecific organic anion transporter 1|ATP-binding cassette sub-family C member 2|multidrug resistance protein 2|multidrug resistance-associated protein 2', map_location='19 36.67 cM', chromosome='19', genomic_nucleotide_accession_version='NC_000085.6', start_position_on_the_genomic_accession=43782308, end_position_on_the_genomic_accession=43838332, orientation='plus', exon_count=33, OMIM=[], no_hdr0=''),
    12785 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=12785, CurrentID=0, Status='live', Symbol='Cnbp', Aliases=['AA4087101', 'Znf', 'Znf9', 'Cnbp'], description='cellular nucleic acid binding protein', other_designations='cellular nucleic acid-binding protein|cellular nucleic acid binding protein 1|zinc finger protein 9', map_location='6 D1', chromosome='6', genomic_nucleotide_accession_version='NC_000072.6', start_position_on_the_genomic_accession=87842615, end_position_on_the_genomic_accession=87851106, orientation='minus', exon_count=5, OMIM=[], no_hdr0=''),
    12788 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=12788, CurrentID=0, Status='live', Symbol='Cnga1', Aliases=['Cnc', 'Cncg'], description='cyclic nucleotide gated channel alpha 1', other_designations='cGMP-gated cation channel alpha-1|CNG channel alpha-1|CNG-1|CNG1|cyclic nucleotide gated channel, cGMP gated|cyclic nucleotide-gated cation channel 1|cyclic nucleotide-gated channel, photoreceptor|rod photoreceptor cGMP-gated channel subunit alpha', map_location='5 38.44 cM', chromosome='5', genomic_nucleotide_accession_version='NC_000071.6', start_position_on_the_genomic_accession=72603696, end_position_on_the_genomic_accession=72642752, orientation='minus', exon_count=10, OMIM=[], no_hdr0=''),
    12789 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=12789, CurrentID=0, Status='live', Symbol='Cnga2', Aliases=['CNG2', 'Cn', 'Cnca', 'Cncg', 'Cncg4', 'OCN', 'OCNC1'], description='cyclic nucleotide gated channel alpha 2', other_designations='cyclic nucleotide-gated olfactory channel|CNG channel alpha-2|cyclic nucleotide gated channel 4|cyclic nucleotide-gated cation channel 2', map_location='X A7.3', chromosome='X', genomic_nucleotide_accession_version='NC_000086.7', start_position_on_the_genomic_accession=71991849, end_position_on_the_genomic_accession=72010218, orientation='plus', exon_count=9, OMIM=[], no_hdr0=''),
    12790 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=12790, CurrentID=0, Status='live', Symbol='Cnga3', Aliases=['CNG', 'CNG3'], description='cyclic nucleotide gated channel alpha 3', other_designations='cyclic nucleotide-gated cation channel alpha-3|CNG channel alpha-3|CNG-3|cone photoreceptor cGMP-gated channel subunit alpha|cyclic nucleotide-gated channel subunit alpha 3', map_location='1 B', chromosome='1', genomic_nucleotide_accession_version='NC_000067.6', start_position_on_the_genomic_accession=37218241, end_position_on_the_genomic_accession=37263384, orientation='plus', exon_count=8, OMIM=[], no_hdr0=''),
    12793 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=12793, CurrentID=0, Status='live', Symbol='Cnih1', Aliases=['0610007J15', 'CNIH-1', 'Cn', 'Cnih'], description='cornichon family AMPA receptor auxiliary protein 1', other_designations='protein cornichon homolog 1|cornichon homolog 1', map_location='14 C1', chromosome='14', genomic_nucleotide_accession_version='NC_000080.6', start_position_on_the_genomic_accession=46775567, end_position_on_the_genomic_accession=46788357, orientation='minus', exon_count=6, OMIM=[], no_hdr0=''),
    12794 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=12794, CurrentID=0, Status='live', Symbol='Cnih2', Aliases=['C', 'CNIH-2', 'Cnil'], description='cornichon family AMPA receptor auxiliary protein 2', other_designations='protein cornichon homolog 2|cornichon homolog 2|cornichon-like protein', map_location='19 A', chromosome='19', genomic_nucleotide_accession_version='NC_000085.6', start_position_on_the_genomic_accession=5092868, end_position_on_the_genomic_accession=5098521, orientation='minus', exon_count=6, OMIM=[], no_hdr0=''),
    12795 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=12795, CurrentID=0, Status='live', Symbol='Plk3', Aliases=['Cn', 'Cnk', 'Fnk', 'PLK-3', 'PRK'], description='polo like kinase 3', other_designations='serine/threonine-protein kinase PLK3|FGF-inducible kinase|cytokine-inducible serine/threonine-protein kinase', map_location='4 D1', chromosome='4', genomic_nucleotide_accession_version='NC_000070.6', start_position_on_the_genomic_accession=117128655, end_position_on_the_genomic_accession=117133963, orientation='minus', exon_count=15, OMIM=[], no_hdr0=''),
    12796 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=12796, CurrentID=0, Status='live', Symbol='Camp', Aliases=['C', 'CAP', 'CAP18', 'CLP', 'Cnlp', 'Cr', 'Cramp', 'FAL', 'FALL39', 'MC', 'MCLP'], description='cathelicidin antimicrobial peptide', other_designations='cathelicidin antimicrobial peptide|cathelin-like protein|cathelin-related antimicrobial peptide', map_location='9 59.8 cM', chromosome='9', genomic_nucleotide_accession_version='NC_000075.6', start_position_on_the_genomic_accession=109847377, end_position_on_the_genomic_accession=109849456, orientation='minus', exon_count=4, OMIM=[], no_hdr0=''),
    12797 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=12797, CurrentID=0, Status='live', Symbol='Cnn1', Aliases=['C', 'CN', 'CnnI'], description='calponin 1', other_designations='calponin-1|basic calponin|calponin H1, smooth muscle', map_location='9 A3', chromosome='9', genomic_nucleotide_accession_version='NC_000075.6', start_position_on_the_genomic_accession=22099221, end_position_on_the_genomic_accession=22109221, orientation='plus', exon_count=8, OMIM=[], no_hdr0=''),
    12798 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=12798, CurrentID=0, Status='live', Symbol='Cnn2', Aliases=['AA408047', 'AI324678', 'Ca', 'Calpo2', 'h2-c'], description='calponin 2', other_designations='calponin-2|calponin H2, smooth muscle|h2-calponin|neutral calponin', map_location='10 C1', chromosome='10', genomic_nucleotide_accession_version='NC_000076.6', start_position_on_the_genomic_accession=79988600, end_position_on_the_genomic_accession=79995400, orientation='plus', exon_count=7, OMIM=[], no_hdr0=''),
    12799 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=12799, CurrentID=0, Status='live', Symbol='Cnp', Aliases=['CN', 'CNPase-1', 'Cnp1', 'Cnp'], description="2',3'-cyclic nucleotide 3' phosphodiesterase", other_designations="2',3'-cyclic-nucleotide 3'-phosphodiesterase|cyclic nucleotide phosphodiesterase 1", map_location='11 63.47 cM', chromosome='11', genomic_nucleotide_accession_version='NC_000077.6', start_position_on_the_genomic_accession=100574909, end_position_on_the_genomic_accession=100591875, orientation='plus', exon_count=6, OMIM=[], no_hdr0=''),
    12801 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=12801, CurrentID=0, Status='live', Symbol='Cnr1', Aliases=['CB-R', 'CB1', 'CB1A', 'CB1B', 'CB1R'], description='cannabinoid receptor 1 (brain)', other_designations='cannabinoid receptor 1|brain-type cannabinoid receptor|striatal cannabinoid receptor type 1 protein', map_location='4 16.28 cM', chromosome='4', genomic_nucleotide_accession_version='NC_000070.6', start_position_on_the_genomic_accession=33923171, end_position_on_the_genomic_accession=33948831, orientation='plus', exon_count=11, OMIM=[], no_hdr0=''),
    12802 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=12802, CurrentID=0, Status='live', Symbol='Cnr2', Aliases=['CB-2', 'CB2', 'CB2-', 'CB2-R'], description='cannabinoid receptor 2 (macrophage)', other_designations='cannabinoid receptor 2|cannabinoid receptor 2 (spleen)', map_location='4 D3', chromosome='4', genomic_nucleotide_accession_version='NC_000070.6', start_position_on_the_genomic_accession=135895189, end_position_on_the_genomic_accession=135920219, orientation='plus', exon_count=3, OMIM=[], no_hdr0=''),
    12803 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=12803, CurrentID=0, Status='live', Symbol='Cntf', Aliases=['AI429687'], description='ciliary neurotrophic factor', other_designations='ciliary neurotrophic factor', map_location='19 8.73 cM', chromosome='19', genomic_nucleotide_accession_version='NC_000085.6', start_position_on_the_genomic_accession=12763528, end_position_on_the_genomic_accession=12765632, orientation='minus', exon_count=2, OMIM=[], no_hdr0=''),
    12804 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=12804, CurrentID=0, Status='live', Symbol='Cntfr', Aliases=['Cntfalpha', 'Cntfr'], description='ciliary neurotrophic factor receptor', other_designations='ciliary neurotrophic factor receptor subunit alpha|CNTF receptor subunit alpha', map_location='4 21.81 cM', chromosome='4', genomic_nucleotide_accession_version='NC_000070.6', start_position_on_the_genomic_accession=41657498, end_position_on_the_genomic_accession=41697091, orientation='minus', exon_count=18, OMIM=[], no_hdr0=''),
    12805 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=12805, CurrentID=0, Status='live', Symbol='Cntn1', Aliases=['AW495098', 'CN', 'CNTN', 'F3ca', 'F3cam', 'u', 'usl'], description='contactin 1', other_designations='contactin-1|neural cell surface protein F3', map_location='15 46.39 cM', chromosome='15', genomic_nucleotide_accession_version='NC_000081.6', start_position_on_the_genomic_accession=92051152, end_position_on_the_genomic_accession=92341967, orientation='plus', exon_count=29, OMIM=[], no_hdr0=''),
    12807 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=12807, CurrentID=0, Status='live', Symbol='Hps3', Aliases=['coa'], description='HPS3, biogenesis of lysosomal organelles complex 2 subunit 1', other_designations='Hermansky-Pudlak syndrome 3 protein homolog|Hermansky-Pudlak syndrome 3 homolog|cocoa protein', map_location='3 6.12 cM', chromosome='3', genomic_nucleotide_accession_version='NC_000069.6', start_position_on_the_genomic_accession=19995945, end_position_on_the_genomic_accession=20035334, orientation='minus', exon_count=17, OMIM=[], no_hdr0=''),
    12808 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=12808, CurrentID=0, Status='live', Symbol='Cobl', Aliases=[], description='cordon-bleu WH2 repeat', other_designations='protein cordon-bleu', map_location='11 7.3 cM', chromosome='11', genomic_nucleotide_accession_version='NC_000077.6', start_position_on_the_genomic_accession=12236676, end_position_on_the_genomic_accession=12465022, orientation='minus', exon_count=20, OMIM=[], no_hdr0=''),
    12810 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=12810, CurrentID=0, Status='live', Symbol='Coch', Aliases=['AW122937-5B', 'Coch-5B2', 'D12H14S564', 'D12H14S564E', 'Coch'], description='cochlin', other_designations='cochlin|coagulation factor C homolog (Limulus polyphemus)', map_location='12 22.11 cM', chromosome='12', genomic_nucleotide_accession_version='NC_000078.6', start_position_on_the_genomic_accession=51593283, end_position_on_the_genomic_accession=51606619, orientation='plus', exon_count=12, OMIM=[], no_hdr0=''),
    12812 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=12812, CurrentID=0, Status='live', Symbol='Coil', Aliases=['C79982', 'Cln', 'Cln80', 'p80', 'p80-', 'p80-coilin'], description='coilin', other_designations='coilin|nuclear phosphoprotein of Cajal body', map_location='11 54.34 cM', chromosome='11', genomic_nucleotide_accession_version='NC_000077.6', start_position_on_the_genomic_accession=88973935, end_position_on_the_genomic_accession=88991613, orientation='plus', exon_count=7, OMIM=[], no_hdr0=''),
    12813 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=12813, CurrentID=0, Status='live', Symbol='Col10a1', Aliases=['Col', 'Col10', 'Col10a-1'], description='collagen, type X, alpha 1', other_designations='collagen alpha-1(X) chain|procollagen, type X, alpha 1', map_location='10 18.85 cM', chromosome='10', genomic_nucleotide_accession_version='NC_000076.6', start_position_on_the_genomic_accession=34389981, end_position_on_the_genomic_accession=34397085, orientation='plus', exon_count=3, OMIM=[], no_hdr0=''),
    12814 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=12814, CurrentID=0, Status='live', Symbol='Col11a1', Aliases=['C530001D20Rik', 'cho'], description='collagen, type XI, alpha 1', other_designations='collagen alpha-1(XI) chain|a1(XI) collagen|pro-alpha1(XI) collagen|procollagen, type XI, alpha 1', map_location='3 49.35 cM', chromosome='3', genomic_nucleotide_accession_version='NC_000069.6', start_position_on_the_genomic_accession=114030479, end_position_on_the_genomic_accession=114220756, orientation='plus', exon_count=69, OMIM=[], no_hdr0=''),
    12815 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=12815, CurrentID=0, Status='live', Symbol='Col11a2', Aliases=[], description='collagen, type XI, alpha 2', other_designations='collagen alpha-2(XI) chain|procollagen, type XI, alpha 2', map_location='17 17.98 cM', chromosome='17', genomic_nucleotide_accession_version='NC_000083.6', start_position_on_the_genomic_accession=34038919, end_position_on_the_genomic_accession=34066684, orientation='plus', exon_count=68, OMIM=[], no_hdr0=''),
    12816 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=12816, CurrentID=0, Status='live', Symbol='Col12a1', Aliases=[], description='collagen, type XII, alpha 1', other_designations='collagen alpha-1(XII) chain|procollagen, type XII, alpha 1', map_location='9 43.82 cM', chromosome='9', genomic_nucleotide_accession_version='NC_000075.6', start_position_on_the_genomic_accession=79598987, end_position_on_the_genomic_accession=79721141, orientation='minus', exon_count=66, OMIM=[], no_hdr0=''),
    12817 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=12817, CurrentID=0, Status='live', Symbol='Col13a1', Aliases=[], description='collagen, type XIII, alpha 1', other_designations='collagen alpha-1(XIII) chain|procollagen, type XIII, alpha 1|type XIII collagen', map_location='10 B4', chromosome='10', genomic_nucleotide_accession_version='NC_000076.6', start_position_on_the_genomic_accession=61838234, end_position_on_the_genomic_accession=61979206, orientation='minus', exon_count=45, OMIM=[], no_hdr0=''),
    12818 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=12818, CurrentID=0, Status='live', Symbol='Col14a1', Aliases=['5730412L22Rik', 'AW108078'], description='collagen, type XIV, alpha 1', other_designations='collagen alpha-1(XIV) chain|procollagen, type XIV, alpha 1', map_location='15 D1', chromosome='15', genomic_nucleotide_accession_version='NC_000081.6', start_position_on_the_genomic_accession=55307644, end_position_on_the_genomic_accession=55520803, orientation='plus', exon_count=49, OMIM=[], no_hdr0=''),
    12819 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=12819, CurrentID=0, Status='live', Symbol='Col15a1', Aliases=[], description='collagen, type XV, alpha 1', other_designations='collagen alpha-1(XV) chain|procollagen type XV|type XV collagen', map_location='4 B1', chromosome='4', genomic_nucleotide_accession_version='NC_000070.6', start_position_on_the_genomic_accession=47207655, end_position_on_the_genomic_accession=47313167, orientation='plus', exon_count=42, OMIM=[], no_hdr0=''),
    12821 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=12821, CurrentID=0, Status='live', Symbol='Col17a1', Aliases=['BP18', 'BP180', 'BPA', 'Bp', 'Bpag', 'Bpag2'], description='collagen, type XVII, alpha 1', other_designations='collagen alpha-1(XVII) chain|180 kDa bullous pemphigoid antigen 2|bullous pemphigoid antigen 2|procollagen, type XVII, alpha 1', map_location='19 40.07 cM', chromosome='19', genomic_nucleotide_accession_version='NC_000085.6', start_position_on_the_genomic_accession=47646341, end_position_on_the_genomic_accession=47692042, orientation='minus', exon_count=54, OMIM=[], no_hdr0=''),
    12822 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=12822, CurrentID=0, Status='live', Symbol='Col18a1', Aliases=['endo'], description='collagen, type XVIII, alpha 1', other_designations='collagen alpha-1(XVIII) chain|alpha-1(XVIII) collagen|endostatin|procollagen, type XVIII, alpha 1', map_location='10 39.72 cM', chromosome='10', genomic_nucleotide_accession_version='NC_000076.6', start_position_on_the_genomic_accession=77052178, end_position_on_the_genomic_accession=77166530, orientation='minus', exon_count=44, OMIM=[], no_hdr0=''),
    12823 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=12823, CurrentID=0, Status='live', Symbol='Col19a1', Aliases=[], description='collagen, type XIX, alpha 1', other_designations='collagen alpha-1(XIX) chain|collagen alpha-1(Y) chain|procollagen, type XIX, alpha 1', map_location='1 A5', chromosome='1', genomic_nucleotide_accession_version='NC_000067.6', start_position_on_the_genomic_accession=24257683, end_position_on_the_genomic_accession=24587922, orientation='minus', exon_count=51, OMIM=[], no_hdr0=''),
    12824 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=12824, CurrentID=0, Status='live', Symbol='Col2a1', Aliases=['Co', 'Col2', 'Col2a', 'Col2a-1', 'Del', 'Del1', 'Dmm', 'L', 'Lpk', 'M100413', 'Rgsc4', 'Rgsc413', 'Rgsc8', 'Rgsc856'], description='collagen, type II, alpha 1', other_designations='collagen alpha-1(II) chain|alpha-1 type II collagen|chondrocalcin|procollagen, type II, alpha 1', map_location='15 53.97 cM', chromosome='15', genomic_nucleotide_accession_version='NC_000081.6', start_position_on_the_genomic_accession=97975602, end_position_on_the_genomic_accession=98004724, orientation='minus', exon_count=55, OMIM=[], no_hdr0=''),
    12825 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=12825, CurrentID=0, Status='live', Symbol='Col3a1', Aliases=['AW550625', 'Col3', 'Col3a-1', 'Tsk', 'Tsk-', 'Tsk-2', 'Tsk2'], description='collagen, type III, alpha 1', other_designations='collagen alpha-1(III) chain|procollagen, type III, alpha 1', map_location='1 23.67 cM', chromosome='1', genomic_nucleotide_accession_version='NC_000067.6', start_position_on_the_genomic_accession=45311538, end_position_on_the_genomic_accession=45349706, orientation='plus', exon_count=51, OMIM=[], no_hdr0=''),
    12826 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=12826, CurrentID=0, Status='live', Symbol='Col4a1', Aliases=['Br', 'Bru', 'Col4', 'Col4a-1', 'Del(8)44', 'R', 'Raw', 'S', 'Svc'], description='collagen, type IV, alpha 1', other_designations='collagen alpha-1(IV) chain|alpha-1 type IV collagen|alpha1(IV) collagen|procollagen, type IV, alpha 1', map_location='8 5.53 cM', chromosome='8', genomic_nucleotide_accession_version='NC_000074.6', start_position_on_the_genomic_accession=11198423, end_position_on_the_genomic_accession=11312889, orientation='minus', exon_count=53, OMIM=[], no_hdr0=''),
    12827 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=12827, CurrentID=0, Status='live', Symbol='Col4a2', Aliases=['Col4', 'Col4a-2'], description='collagen, type IV, alpha 2', other_designations='collagen alpha-2(IV) chain|canstatin|procollagen, type IV, alpha 2', map_location='8 5.62 cM', chromosome='8', genomic_nucleotide_accession_version='NC_000074.6', start_position_on_the_genomic_accession=11312805, end_position_on_the_genomic_accession=11449287, orientation='plus', exon_count=48, OMIM=[], no_hdr0=''),
    12828 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=12828, CurrentID=0, Status='live', Symbol='Col4a3', Aliases=['[a]3(IV)', 'alph', 'alpha3(IV)', 'tumst'], description='collagen, type IV, alpha 3', other_designations='collagen alpha-3(IV) chain|collagen type IV alpha3 chain|procollagen, type IV, alpha 3|tumstatin', map_location='1 C5', chromosome='1', genomic_nucleotide_accession_version='NC_000067.6', start_position_on_the_genomic_accession=82586921, end_position_on_the_genomic_accession=82722059, orientation='plus', exon_count=52, OMIM=[], no_hdr0=''),
    12829 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=12829, CurrentID=0, Status='live', Symbol='Col4a4', Aliases=['E130010M05Rik', '[a]4(', '[a]4(IV)'], description='collagen, type IV, alpha 4', other_designations='collagen alpha-4(IV) chain|procollagen, type IV, alpha 4', map_location='1 C5', chromosome='1', genomic_nucleotide_accession_version='NC_000067.6', start_position_on_the_genomic_accession=82448419, end_position_on_the_genomic_accession=82587034, orientation='minus', exon_count=51, OMIM=[], no_hdr0=''),
    12830 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=12830, CurrentID=0, Status='live', Symbol='Col4a5', Aliases=[], description='collagen, type IV, alpha 5', other_designations='collagen alpha-5(IV) chain|collagen type IV alpha5 chain|procollagen type IV alpha 5', map_location='X 62.16 cM', chromosome='X', genomic_nucleotide_accession_version='NC_000086.7', start_position_on_the_genomic_accession=141475370, end_position_on_the_genomic_accession=141689236, orientation='plus', exon_count=53, OMIM=[], no_hdr0=''),
    12831 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=12831, CurrentID=0, Status='live', Symbol='Col5a1', Aliases=['AI413331'], description='collagen, type V, alpha 1', other_designations='collagen alpha-1(V) chain|alpha1(V) collagen|pro-alpha1(V) collagen|procollagen type V alpha 1', map_location='2 19.38 cM', chromosome='2', genomic_nucleotide_accession_version='NC_000068.7', start_position_on_the_genomic_accession=27886381, end_position_on_the_genomic_accession=28039510, orientation='plus', exon_count=67, OMIM=[], no_hdr0=''),
    12832 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=12832, CurrentID=0, Status='live', Symbol='Col5a2', Aliases=['1110014L14Rik'], description='collagen, type V, alpha 2', other_designations='collagen alpha-2(V) chain|procollagen, type V, alpha 2', map_location='1 C1.1', chromosome='1', genomic_nucleotide_accession_version='NC_000067.6', start_position_on_the_genomic_accession=45374331, end_position_on_the_genomic_accession=45503282, orientation='minus', exon_count=54, OMIM=[], no_hdr0=''),
    12833 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=12833, CurrentID=0, Status='live', Symbol='Col6a1', Aliases=['AI747156', 'Col6', 'Col6a-1'], description='collagen, type VI, alpha 1', other_designations='collagen alpha-1(VI) chain|procollagen, type VI, alpha 1', map_location='10 39.71 cM', chromosome='10', genomic_nucleotide_accession_version='NC_000076.6', start_position_on_the_genomic_accession=76708792, end_position_on_the_genomic_accession=76726044, orientation='minus', exon_count=35, OMIM=[], no_hdr0=''),
    12834 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=12834, CurrentID=0, Status='live', Symbol='Col6a2', Aliases=['Col6', 'Col6a-2'], description='collagen, type VI, alpha 2', other_designations='collagen alpha-2(VI) chain|procollagen, type VI, alpha 2', map_location='10 39.32 cM', chromosome='10', genomic_nucleotide_accession_version='NC_000076.6', start_position_on_the_genomic_accession=76595756, end_position_on_the_genomic_accession=76623630, orientation='minus', exon_count=29, OMIM=[], no_hdr0=''),
    12835 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=12835, CurrentID=0, Status='live', Symbol='Col6a3', Aliases=['AI507288', 'Col6', 'Col6a-3'], description='collagen, type VI, alpha 3', other_designations='collagen alpha-3(VI) chain|collagen alpha 3 chain type VI|collagen alpha3(VI)|procollagen, type VI, alpha 3|type VI collagen alpha 3 subunit', map_location='1 45.53 cM', chromosome='1', genomic_nucleotide_accession_version='NC_000067.6', start_position_on_the_genomic_accession=90766860, end_position_on_the_genomic_accession=90844001, orientation='minus', exon_count=44, OMIM=[], no_hdr0=''),
    12836 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=12836, CurrentID=0, Status='live', Symbol='Col7a1', Aliases=['AW209154'], description='collagen, type VII, alpha 1', other_designations='collagen alpha-1(VII) chain|LC collagen|long-chain collagen|procollagen, type VII, alpha 1', map_location='9 59.63 cM', chromosome='9', genomic_nucleotide_accession_version='NC_000075.6', start_position_on_the_genomic_accession=108953586, end_position_on_the_genomic_accession=108984875, orientation='plus', exon_count=119, OMIM=[], no_hdr0=''),
    12837 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=12837, CurrentID=0, Status='live', Symbol='Col8a1', Aliases=['Col8', 'Col8a-1'], description='collagen, type VIII, alpha 1', other_designations='collagen alpha-1(VIII) chain|procollagen type VIII alpha 1', map_location='16 C1.1', chromosome='16', genomic_nucleotide_accession_version='NC_000082.6', start_position_on_the_genomic_accession=57624256, end_position_on_the_genomic_accession=57754737, orientation='minus', exon_count=4, OMIM=[], no_hdr0=''),
    12839 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=12839, CurrentID=0, Status='live', Symbol='Col9a1', Aliases=['Col9', 'Col9a-1'], description='collagen, type IX, alpha 1', other_designations='collagen alpha-1(IX) chain|alpha 1 type IX collagen|procollagen, type IX, alpha 1', map_location='1 9.95 cM', chromosome='1', genomic_nucleotide_accession_version='NC_000067.6', start_position_on_the_genomic_accession=24177589, end_position_on_the_genomic_accession=24252738, orientation='plus', exon_count=40, OMIM=[], no_hdr0=''),
    12840 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=12840, CurrentID=0, Status='live', Symbol='Col9a2', Aliases=['AI427499', 'Col9', 'Col9a-2'], description='collagen, type IX, alpha 2', other_designations='collagen alpha-2(IX) chain|procollagen, type IX, alpha 2', map_location='4 56.78 cM', chromosome='4', genomic_nucleotide_accession_version='NC_000070.6', start_position_on_the_genomic_accession=121039566, end_position_on_the_genomic_accession=121055325, orientation='plus', exon_count=32, OMIM=[], no_hdr0=''),
    12841 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=12841, CurrentID=0, Status='live', Symbol='Col9a3', Aliases=['AV006866'], description='collagen, type IX, alpha 3', other_designations='collagen alpha-3(IX) chain|procollagen, type IX, alpha 3', map_location='2 103.14 cM', chromosome='2', genomic_nucleotide_accession_version='NC_000068.7', start_position_on_the_genomic_accession=180598102, end_position_on_the_genomic_accession=180622192, orientation='plus', exon_count=32, OMIM=[], no_hdr0=''),
    12842 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=12842, CurrentID=0, Status='live', Symbol='Col1a1', Aliases=['Co', 'Col', 'Col1', 'Col1a-1', 'Cola-1', 'Cola1', 'Mov-', 'Mov-13', 'Mov13'], description='collagen, type I, alpha 1', other_designations='collagen alpha-1(I) chain|alpha-1 type 1 collagen|alpha-1 type I collagen|procollagen, type I, alpha 1', map_location='11 D', chromosome='11', genomic_nucleotide_accession_version='NC_000077.6', start_position_on_the_genomic_accession=94936224, end_position_on_the_genomic_accession=94953042, orientation='plus', exon_count=51, OMIM=[], no_hdr0=''),
    12843 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=12843, CurrentID=0, Status='live', Symbol='Col1a2', Aliases=['AA960264', 'AI325291', 'Co', 'Col', 'Col1', 'Col1a-2', 'Cola-2', 'Cola2', 'oim'], description='collagen, type I, alpha 2', other_designations='collagen alpha-2(I) chain|alpha-2 type I collagen|collagen COL1A2|procollagen, type I, alpha 2', map_location='6 1.81 cM', chromosome='6', genomic_nucleotide_accession_version='NC_000072.6', start_position_on_the_genomic_accession=4505618, end_position_on_the_genomic_accession=4541543, orientation='plus', exon_count=52, OMIM=[], no_hdr0=''),
    12845 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=12845, CurrentID=0, Status='live', Symbol='Comp', Aliases=['TS', 'TSP5'], description='cartilage oligomeric matrix protein', other_designations='cartilage oligomeric matrix protein|thrombospondin-5', map_location='8 34.15 cM', chromosome='8', genomic_nucleotide_accession_version='NC_000074.6', start_position_on_the_genomic_accession=70373548, end_position_on_the_genomic_accession=70382066, orientation='plus', exon_count=20, OMIM=[], no_hdr0=''),
    12846 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=12846, CurrentID=0, Status='live', Symbol='Comt', Aliases=['Comt1', 'D16Wsu103', 'D16Wsu103e', 'D330014B15Rik'], description='catechol-O-methyltransferase', other_designations='catechol O-methyltransferase|catechol-O-methyltransferase 1', map_location='16 11.4 cM', chromosome='16', genomic_nucleotide_accession_version='NC_000082.6', start_position_on_the_genomic_accession=18406882, end_position_on_the_genomic_accession=18426716, orientation='minus', exon_count=7, OMIM=[], no_hdr0=''),
    12847 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=12847, CurrentID=0, Status='live', Symbol='Copa', Aliases=['AU040324', 'xe', 'xenin'], description='coatomer protein complex subunit alpha', other_designations='coatomer subunit alpha|alpha-COP|alpha-coat protein', map_location='1 79.54 cM', chromosome='1', genomic_nucleotide_accession_version='NC_000067.6', start_position_on_the_genomic_accession=172082529, end_position_on_the_genomic_accession=172122332, orientation='plus', exon_count=34, OMIM=[], no_hdr0=''),
    12848 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=12848, CurrentID=0, Status='live', Symbol='Cops2', Aliases=['AI315723', 'C85265', 'Cs', 'Csn2', 'Sg', 'Sgn2', 'TRIP-15', 'Tri', 'Trip15', 'alie'], description='COP9 signalosome subunit 2', other_designations='COP9 signalosome complex subunit 2|COP9 (constitutive photomorphogenic) homolog, subunit 2|JAB1-containing signalosome subunit 2|TR-interacting protein 15|alien homolog|alien-like|thyroid receptor-interacting protein 15', map_location='2 61.76 cM', chromosome='2', genomic_nucleotide_accession_version='NC_000068.7', start_position_on_the_genomic_accession=125830302, end_position_on_the_genomic_accession=125859082, orientation='minus', exon_count=13, OMIM=[], no_hdr0=''),
    12850 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=12850, CurrentID=0, Status='live', Symbol='Coq7', Aliases=['clk-', 'clk-1'], description='demethyl-Q 7', other_designations='5-demethoxyubiquinone hydroxylase, mitochondrial|DMQ hydroxylase|coenzyme Q biosynthesis protein 7 homolog|timing protein clk-1 homolog|ubiquinone biosynthesis monooxygenase COQ7|ubiquinone biosynthesis protein COQ7 homolog', map_location='7 63.44 cM', chromosome='7', genomic_nucleotide_accession_version='NC_000073.6', start_position_on_the_genomic_accession=118509659, end_position_on_the_genomic_accession=118533356, orientation='minus', exon_count=9, OMIM=[], no_hdr0=''),
    12854 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=12854, CurrentID=0, Status='live', Symbol='Cort', Aliases=['CS', 'CST', 'PC', 'PCST'], description='cortistatin', other_designations='cortistatin', map_location='4 78.89 cM', chromosome='4', genomic_nucleotide_accession_version='NC_000070.6', start_position_on_the_genomic_accession=149125034, end_position_on_the_genomic_accession=149126763, orientation='minus', exon_count=2, OMIM=[], no_hdr0=''),
    12856 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=12856, CurrentID=0, Status='live', Symbol='Cox17', Aliases=['AI037035', 'COX1'], description='cytochrome c oxidase assembly protein 17, copper chaperone', other_designations='cytochrome c oxidase copper chaperone|cytochrome c oxidase, subunit XVII assembly protein homolog', map_location='16 B3-B4', chromosome='16', genomic_nucleotide_accession_version='NC_000082.6', start_position_on_the_genomic_accession=38346983, end_position_on_the_genomic_accession=38352763, orientation='plus', exon_count=4, OMIM=[], no_hdr0=''),
    12857 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=12857, CurrentID=0, Status='live', Symbol='Cox4i1', Aliases=['AL024441', 'CO', 'COX', 'COX IV-1', 'COXIV', 'Cox4', 'Cox4a', 'IV-1'], description='cytochrome c oxidase subunit 4I1', other_designations='cytochrome c oxidase subunit 4 isoform 1, mitochondrial|cytochrome c oxidase polypeptide IV|cytochrome c oxidase subunit IV|cytochrome c oxidase, subunit IVa', map_location='8 69.99 cM', chromosome='8', genomic_nucleotide_accession_version='NC_000074.6', start_position_on_the_genomic_accession=120668225, end_position_on_the_genomic_accession=120674209, orientation='plus', exon_count=5, OMIM=[], no_hdr0=''),
    12858 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=12858, CurrentID=0, Status='live', Symbol='Cox5a', Aliases=['AA959768', 'CcO', 'CcOX'], description='cytochrome c oxidase subunit 5A', other_designations='cytochrome c oxidase subunit 5A, mitochondrial|cytochrome c oxidase polypeptide Va|cytochrome c oxidase subunit Va', map_location='9 B', chromosome='9', genomic_nucleotide_accession_version='NC_000075.6', start_position_on_the_genomic_accession=57517328, end_position_on_the_genomic_accession=57532427, orientation='plus', exon_count=6, OMIM=[], no_hdr0=''),
    12859 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=12859, CurrentID=0, Status='live', Symbol='Cox5b', Aliases=[], description='cytochrome c oxidase subunit 5B', other_designations='cytochrome c oxidase subunit 5B, mitochondrial|cytochrome c oxidase polypeptide Vb|cytochrome c oxidase subunit Vb', map_location='1 B', chromosome='1', genomic_nucleotide_accession_version='NC_000067.6', start_position_on_the_genomic_accession=36691487, end_position_on_the_genomic_accession=36693388, orientation='plus', exon_count=4, OMIM=[], no_hdr0=''),
    12861 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=12861, CurrentID=0, Status='live', Symbol='Cox6a1', Aliases=['VIaL'], description='cytochrome c oxidase subunit 6A1', other_designations='cytochrome c oxidase subunit 6A1, mitochondrial|cytochrome c oxidase polypeptide VIa-liver|cytochrome c oxidase subunit VIa polypeptide 1|subunit VIaL (liver-type)', map_location='5 56.06 cM', chromosome='5', genomic_nucleotide_accession_version='NC_000071.6', start_position_on_the_genomic_accession=115345652, end_position_on_the_genomic_accession=115348958, orientation='minus', exon_count=3, OMIM=[], no_hdr0=''),
    12862 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=12862, CurrentID=0, Status='live', Symbol='Cox6a2', Aliases=['COX', 'CoxVIaH', 'V', 'VIaH'], description='cytochrome c oxidase subunit 6A2', other_designations='cytochrome c oxidase subunit 6A2, mitochondrial|cytochrome c oxidase polypeptide VIa-heart|cytochrome c oxidase subunit VIa polypeptide 2|subunit VIaH (heart-type)', map_location='7 70.04 cM', chromosome='7', genomic_nucleotide_accession_version='NC_000073.6', start_position_on_the_genomic_accession=128205435, end_position_on_the_genomic_accession=128206366, orientation='minus', exon_count=3, OMIM=[], no_hdr0=''),
    12864 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=12864, CurrentID=0, Status='live', Symbol='Cox6c', Aliases=[], description='cytochrome c oxidase subunit 6C', other_designations='cytochrome c oxidase subunit 6C|cytochrome c oxidase polypeptide VIc|cytochrome c oxidase subunit VIc', map_location='15 B3.1', chromosome='15', genomic_nucleotide_accession_version='NC_000081.6', start_position_on_the_genomic_accession=35931976, end_position_on_the_genomic_accession=35938246, orientation='minus', exon_count=4, OMIM=[], no_hdr0=''),
    12865 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=12865, CurrentID=0, Status='live', Symbol='Cox7a1', Aliases=['COX', 'COX7', 'COX7A', 'COX7AH', 'COX7AM'], description='cytochrome c oxidase subunit 7A1', other_designations='cytochrome c oxidase subunit 7A1, mitochondrial|cytochrome c oxidase subunit VIIa 1|cytochrome c oxidase subunit VIIa-H|cytochrome c oxidase subunit VIIa-M|cytochrome c oxidase subunit VIIa-heart|cytochrome c oxidase subunit VIIa-muscle', map_location='7 17.31 cM', chromosome='7', genomic_nucleotide_accession_version='NC_000073.6', start_position_on_the_genomic_accession=30184171, end_position_on_the_genomic_accession=30186030, orientation='plus', exon_count=4, OMIM=[], no_hdr0=''),
    12866 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=12866, CurrentID=0, Status='live', Symbol='Cox7a2', Aliases=['COX', 'COX7AL', 'Cox7', 'Cox7a3', 'CoxVIIa-L'], description='cytochrome c oxidase subunit 7A2', other_designations='cytochrome c oxidase subunit 7A2, mitochondrial|cytochrome c oxidase subunit VIIa 2|cytochrome c oxidase subunit VIIa 3|cytochrome c oxidase subunit VIIa-L|cytochrome c oxidase subunit VIIa-liver/heart', map_location='9 43.82 cM', chromosome='9', genomic_nucleotide_accession_version='NC_000075.6', start_position_on_the_genomic_accession=79755241, end_position_on_the_genomic_accession=79771422, orientation='minus', exon_count=5, OMIM=[], no_hdr0=''),
    12867 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=12867, CurrentID=0, Status='live', Symbol='Cox7c', Aliases=['COX', 'COXVIIc1', 'Cox7c'], description='cytochrome c oxidase subunit 7C', other_designations='cytochrome c oxidase subunit 7C, mitochondrial|cytochrome c oxidase polypeptide VIIc|cytochrome c oxidase subunit VIIc', map_location='13 C3', chromosome='13', genomic_nucleotide_accession_version='NC_000079.6', start_position_on_the_genomic_accession=86044798, end_position_on_the_genomic_accession=86046795, orientation='minus', exon_count=3, OMIM=[], no_hdr0=''),
    12868 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=12868, CurrentID=0, Status='live', Symbol='Cox8a', Aliases=['COX', 'COX8L'], description='cytochrome c oxidase subunit 8A', other_designations='cytochrome c oxidase subunit 8A, mitochondrial|COX VIII-L|cytochrome c oxidase polypeptide VIII-liver|cytochrome c oxidase subunit 8-2|cytochrome c oxidase subunit VIIIa', map_location='19 A', chromosome='19', genomic_nucleotide_accession_version='NC_000085.6', start_position_on_the_genomic_accession=7215158, end_position_on_the_genomic_accession=7217616, orientation='minus', exon_count=2, OMIM=[], no_hdr0=''),
    12869 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=12869, CurrentID=0, Status='live', Symbol='Cox8b', Aliases=['COX8', 'Cox8h', 'CoxVIII-H'], description='cytochrome c oxidase subunit 8B', other_designations='cytochrome c oxidase subunit 8B, mitochondrial|COX VIII-H|cytochrome c oxidase polypeptide VIII-heart|cytochrome c oxidase subunit 8-1|cytochrome c oxidase subunit 8H|cytochrome c oxidase subunit VIII-H|cytochrome c oxidase subunit VIIIb', map_location='7 86.11 cM', chromosome='7', genomic_nucleotide_accession_version='NC_000073.6', start_position_on_the_genomic_accession=140898942, end_position_on_the_genomic_accession=140900446, orientation='minus', exon_count=2, OMIM=[], no_hdr0=''),
    12870 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=12870, CurrentID=0, Status='live', Symbol='Cp', Aliases=['D3Ertd555', 'D3Ertd555e'], description='ceruloplasmin', other_designations='ceruloplasmin|ferroxidase', map_location='3 A2', chromosome='3', genomic_nucleotide_accession_version='NC_000069.6', start_position_on_the_genomic_accession=19956933, end_position_on_the_genomic_accession=20009750, orientation='plus', exon_count=21, OMIM=[], no_hdr0=''),
    12873 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=12873, CurrentID=0, Status='live', Symbol='Cpa3', Aliases=['MC-C', 'MC-CPA', 'mMC-C'], description='carboxypeptidase A3, mast cell', other_designations='mast cell carboxypeptidase A', map_location='3 6.25 cM', chromosome='3', genomic_nucleotide_accession_version='NC_000069.6', start_position_on_the_genomic_accession=20215616, end_position_on_the_genomic_accession=20242209, orientation='minus', exon_count=11, OMIM=[], no_hdr0=''),
    12874 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=12874, CurrentID=0, Status='live', Symbol='Cpd', Aliases=['AA960140', 'AW322530', 'D830034L15Rik'], description='carboxypeptidase D', other_designations='carboxypeptidase D|gp180|metallocarboxypeptidase D', map_location='11 46.05 cM', chromosome='11', genomic_nucleotide_accession_version='NC_000077.6', start_position_on_the_genomic_accession=76777208, end_position_on_the_genomic_accession=76847008, orientation='minus', exon_count=21, OMIM=[], no_hdr0=''),
    12876 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=12876, CurrentID=0, Status='live', Symbol='Cpe', Aliases=['CP', 'CPH', 'Cph-', 'Cph-1', 'Cph1', 'NF-a', 'NF-alpha1', 'R74677', 'fat'], description='carboxypeptidase E', other_designations='carboxypeptidase E|carboxypeptidase H|enkephalin convertase|prohormone-processing carboxypeptidase', map_location='8 32.3 cM', chromosome='8', genomic_nucleotide_accession_version='NC_000074.6', start_position_on_the_genomic_accession=64592542, end_position_on_the_genomic_accession=64693109, orientation='minus', exon_count=9, OMIM=[], no_hdr0=''),
    12877 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=12877, CurrentID=0, Status='live', Symbol='Cpeb1', Aliases=['AU024112', 'Cpe-bp1', 'Cpeb', 'mCPEB', 'mCpeb-1'], description='cytoplasmic polyadenylation element binding protein 1', other_designations='cytoplasmic polyadenylation element-binding protein 1|CPE-binding protein 1', map_location='7 D3', chromosome='7', genomic_nucleotide_accession_version='NC_000073.6', start_position_on_the_genomic_accession=81347026, end_position_on_the_genomic_accession=81458001, orientation='minus', exon_count=16, OMIM=[], no_hdr0=''),
    12879 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=12879, CurrentID=0, Status='live', Symbol='Cys1', Aliases=['2900006B19Rik', 'AV218859', 'Ccap', 'ck', 'cpk'], description='cystin 1', other_designations='cystin-1|cilia-associated protein|congenital polycystic kidneys|cystin cilia associated protein', map_location='12 8.49 cM', chromosome='12', genomic_nucleotide_accession_version='NC_000078.6', start_position_on_the_genomic_accession=24665833, end_position_on_the_genomic_accession=24681886, orientation='minus', exon_count=5, OMIM=[], no_hdr0=''),
    12889 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=12889, CurrentID=0, Status='live', Symbol='Cplx1', Aliases=['921-', '921-S'], description='complexin 1', other_designations='complexin-1|CPX I|complexin I|synaphin-2', map_location='5 F', chromosome='5', genomic_nucleotide_accession_version='NC_000071.6', start_position_on_the_genomic_accession=108518554, end_position_on_the_genomic_accession=108550027, orientation='minus', exon_count=4, OMIM=[], no_hdr0=''),
    12890 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=12890, CurrentID=0, Status='live', Symbol='Cplx2', Aliases=['921-', '921-L', 'AI413745', 'AW492120', 'Gm34843'], description='complexin 2', other_designations='complexin-2|CPX II|complexin II|synaphin-1', map_location='13 B1', chromosome='13', genomic_nucleotide_accession_version='NC_000079.6', start_position_on_the_genomic_accession=54301964, end_position_on_the_genomic_accession=54383923, orientation='plus', exon_count=8, OMIM=[], no_hdr0=''),
    12891 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=12891, CurrentID=0, Status='live', Symbol='Cpne6', Aliases=['AU067659', 'BB076446'], description='copine VI', other_designations='copine-6|N-copine|neuronal-copine', map_location='14 C3', chromosome='14', genomic_nucleotide_accession_version='NC_000080.6', start_position_on_the_genomic_accession=55510445, end_position_on_the_genomic_accession=55517435, orientation='plus', exon_count=18, OMIM=[], no_hdr0=''),
    12892 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=12892, CurrentID=0, Status='live', Symbol='Cpox', Aliases=['C', 'CPX', 'Cpo', 'HCP', 'ca', 'cac', 'nc', 'nct'], description='coproporphyrinogen oxidase', other_designations='oxygen-dependent coproporphyrinogen-III oxidase, mitochondrial|COX|Coproporphyrinogen III oxidase, mitochondrial precursor (Coproporphyrinogenase) (Coprogen oxidase) (COX)|clone 560|coprogen oxidase|coproporphyrinogen-III oxidase, mitochondrial|coproporphyrinogenase', map_location='16 C1.2', chromosome='16', genomic_nucleotide_accession_version='NC_000082.6', start_position_on_the_genomic_accession=58670208, end_position_on_the_genomic_accession=58680391, orientation='plus', exon_count=7, OMIM=[], no_hdr0=''),
    12894 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=12894, CurrentID=0, Status='live', Symbol='Cpt1a', Aliases=['C730027G07', 'CP', 'CPTI', 'Cpt', 'Cpt1'], description='carnitine palmitoyltransferase 1a, liver', other_designations='carnitine O-palmitoyltransferase 1, liver isoform|CPT I|CPT1-L|CPTI-L|L-CPT I|carnitine palmitoyltransferase 1, liver', map_location='19 3.08 cM', chromosome='19', genomic_nucleotide_accession_version='NC_000085.6', start_position_on_the_genomic_accession=3322326, end_position_on_the_genomic_accession=3385735, orientation='plus', exon_count=24, OMIM=[], no_hdr0=''),
    12895 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=12895, CurrentID=0, Status='live', Symbol='Cpt1b', Aliases=['Cpt', 'Cpt1', 'Cpt1-m', 'Cpti', 'Cpti-m', 'M-CP', 'M-cpti'], description='carnitine palmitoyltransferase 1b, muscle', other_designations='carnitine O-palmitoyltransferase 1, muscle isoform|muscle-type carnitine palmitoyltransferase I', map_location='15 44.89 cM', chromosome='15', genomic_nucleotide_accession_version='NC_000081.6', start_position_on_the_genomic_accession=89416405, end_position_on_the_genomic_accession=89425862, orientation='minus', exon_count=19, OMIM=[], no_hdr0=''),
    12896 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=12896, CurrentID=0, Status='live', Symbol='Cpt2', Aliases=['AI323697', 'CP', 'CPTII'], description='carnitine palmitoyltransferase 2', other_designations='carnitine O-palmitoyltransferase 2, mitochondrial|CPT II|carnitine palmitoyltransferase II', map_location='4 50.18 cM', chromosome='4', genomic_nucleotide_accession_version='NC_000070.6', start_position_on_the_genomic_accession=107903982, end_position_on_the_genomic_accession=107923589, orientation='minus', exon_count=5, OMIM=[], no_hdr0=''),
    12902 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=12902, CurrentID=0, Status='live', Symbol='Cr2', Aliases=['C3D', 'C3DR', 'CD21', 'CD35', 'Cr', 'Cr-', 'Cr-1', 'Cr-2', 'Cr1'], description='complement receptor 2', other_designations='complement receptor type 2|complement C3d receptor|complement receptor type 1|expressed in B lymphocytes', map_location='1 98.44 cM', chromosome='1', genomic_nucleotide_accession_version='NC_000067.6', start_position_on_the_genomic_accession=195136811, end_position_on_the_genomic_accession=195176880, orientation='minus', exon_count=26, OMIM=[], no_hdr0=''),
    12903 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=12903, CurrentID=0, Status='live', Symbol='Crabp1', Aliases=['AI326249', 'CRABP-I', 'Cr', 'Crab', 'Crabp-1', 'CrabpI', 'Rbp', 'Rbp-5'], description='cellular retinoic acid binding protein I', other_designations='cellular retinoic acid-binding protein 1', map_location='9 29.76 cM', chromosome='9', genomic_nucleotide_accession_version='NC_000075.6', start_position_on_the_genomic_accession=54764748, end_position_on_the_genomic_accession=54773110, orientation='plus', exon_count=4, OMIM=[], no_hdr0=''),
    12904 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=12904, CurrentID=0, Status='live', Symbol='Crabp2', Aliases=['AI893628', 'Cr', 'Crab', 'Crabp-2', 'CrabpII'], description='cellular retinoic acid binding protein II', other_designations='cellular retinoic acid-binding protein 2|CRABP-II', map_location='3', chromosome='3', genomic_nucleotide_accession_version='NC_000069.6', start_position_on_the_genomic_accession=87948693, end_position_on_the_genomic_accession=87953372, orientation='plus', exon_count=4, OMIM=[], no_hdr0=''),
    12905 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=12905, CurrentID=0, Status='live', Symbol='Cradd', Aliases=['RA', 'RAIDD'], description='CASP2 and RIPK1 domain containing adaptor with death domain', other_designations='death domain-containing protein CRADD|RIP-associated protein with a death domain|caspase and RIP adapter with death domain', map_location='10 49.26 cM', chromosome='10', genomic_nucleotide_accession_version='NC_000076.6', start_position_on_the_genomic_accession=95174739, end_position_on_the_genomic_accession=95324138, orientation='minus', exon_count=5, OMIM=[], no_hdr0=''),
    12908 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=12908, CurrentID=0, Status='live', Symbol='Crat', Aliases=['AW107812', 'CA', 'CARAT'], description='carnitine acetyltransferase', other_designations='carnitine O-acetyltransferase|CAT|carnitine acetylase', map_location='2 21.69 cM', chromosome='2', genomic_nucleotide_accession_version='NC_000068.7', start_position_on_the_genomic_accession=30400476, end_position_on_the_genomic_accession=30416017, orientation='minus', exon_count=17, OMIM=[], no_hdr0=''),
    12909 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=12909, CurrentID=0, Status='live', Symbol='Crcp', Aliases=['AL022669'], description='calcitonin gene-related peptide-receptor component protein', other_designations='DNA-directed RNA polymerase III subunit RPC9|CGRP-RCP|CGRP-receptor component protein|CGRPRCP|RNA polymerase III subunit C9', map_location='5 G1.3', chromosome='5', genomic_nucleotide_accession_version='NC_000071.6', start_position_on_the_genomic_accession=130029306, end_position_on_the_genomic_accession=130060787, orientation='plus', exon_count=6, OMIM=[], no_hdr0=''),
    12912 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=12912, CurrentID=0, Status='live', Symbol='Creb1', Aliases=['2310001E10Rik', '3526402H21Rik', 'AV083133', 'Cre', 'Creb', 'Creb-', 'Creb-1'], description='cAMP responsive element binding protein 1', other_designations='cyclic AMP-responsive element-binding protein 1', map_location='1 32.74 cM', chromosome='1', genomic_nucleotide_accession_version='NC_000067.6', start_position_on_the_genomic_accession=64532794, end_position_on_the_genomic_accession=64604548, orientation='plus', exon_count=12, OMIM=[], no_hdr0=''),
    12913 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=12913, CurrentID=0, Status='live', Symbol='Creb3', Aliases=['AU044960', 'AW538053', 'C80076', 'L', 'LZI', 'LZIP', 'LZIP-1', 'LZIP-2', 'Lu', 'Luman'], description='cAMP responsive element binding protein 3', other_designations='cyclic AMP-responsive element-binding protein 3|CREB-3|transcription factor LZIP', map_location='4 23.05 cM', chromosome='4', genomic_nucleotide_accession_version='NC_000070.6', start_position_on_the_genomic_accession=43562658, end_position_on_the_genomic_accession=43567061, orientation='plus', exon_count=9, OMIM=[], no_hdr0=''),
    12914 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=12914, CurrentID=0, Status='live', Symbol='Crebbp', Aliases=['AW558298', 'CB', 'CBP', 'CBP/p300', 'KAT', 'KAT3A', 'p300/CBP'], description='CREB binding protein', other_designations='histone lysine acetyltransferase CREBBP|protein-lysine acetyltransferase CREBBP', map_location='16 2.4 cM', chromosome='16', genomic_nucleotide_accession_version='NC_000082.6', start_position_on_the_genomic_accession=4081334, end_position_on_the_genomic_accession=4213957, orientation='minus', exon_count=31, OMIM=[], no_hdr0=''),
    12915 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=12915, CurrentID=0, Status='live', Symbol='Atf6b', Aliases=['AA617266', 'ATF6be', 'ATF6beta', 'Creb', 'Creb-rp', 'Crebl1'], description='activating transcription factor 6 beta', other_designations='cyclic AMP-dependent transcription factor ATF-6 beta|ATF6-beta|cAMP response element binding protein-related protein|cAMP-dependent transcription factor ATF-6 beta|cAMP-responsive element-binding protein-like 1', map_location='17 18.22 cM', chromosome='17', genomic_nucleotide_accession_version='NC_000083.6', start_position_on_the_genomic_accession=34647146, end_position_on_the_genomic_accession=34655074, orientation='plus', exon_count=18, OMIM=[], no_hdr0=''),
    12916 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=12916, CurrentID=0, Status='live', Symbol='Crem', Aliases=['IC', 'ICER', 'ICERI'], description='cAMP responsive element modulator', other_designations='cAMP-responsive element modulator|cAMP responsive element moderator|inducible cAMP early repressor', map_location='18 A1', chromosome='18', genomic_nucleotide_accession_version='NC_000084.6', start_position_on_the_genomic_accession=3266354, end_position_on_the_genomic_accession=3337773, orientation='minus', exon_count=16, OMIM=[], no_hdr0=''),
    12918 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=12918, CurrentID=0, Status='live', Symbol='Crh', Aliases=['CR', 'CRF', 'Gm1347'], description='corticotropin releasing hormone', other_designations='corticoliberin|corticotropin releasing factor', map_location='3 5.75 cM', chromosome='3', genomic_nucleotide_accession_version='NC_000069.6', start_position_on_the_genomic_accession=19693401, end_position_on_the_genomic_accession=19695396, orientation='minus', exon_count=2, OMIM=[], no_hdr0=''),
    12919 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=12919, CurrentID=0, Status='live', Symbol='Crhbp', Aliases=['CRH-', 'CRH-BP'], description='corticotropin releasing hormone binding protein', other_designations='corticotropin-releasing factor-binding protein|CRF-BP|CRF-binding protein', map_location='13 49.5 cM', chromosome='13', genomic_nucleotide_accession_version='NC_000079.6', start_position_on_the_genomic_accession=95431376, end_position_on_the_genomic_accession=95444831, orientation='minus', exon_count=7, OMIM=[], no_hdr0=''),
    12921 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=12921, CurrentID=0, Status='live', Symbol='Crhr1', Aliases=['CRF', 'CRF-R', 'CRF1R', 'CRFR1', 'Crhr'], description='corticotropin releasing hormone receptor 1', other_designations='corticotropin-releasing factor receptor 1|CRF 1 receptor|CRF-R-1|CRF-R1|CRF-R1alpha|CRFR-1|CRH-R-1|CRH-R1', map_location='11 67.77 cM', chromosome='11', genomic_nucleotide_accession_version='NC_000077.6', start_position_on_the_genomic_accession=104130463, end_position_on_the_genomic_accession=104175523, orientation='plus', exon_count=14, OMIM=[], no_hdr0=''),
    12922 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=12922, CurrentID=0, Status='live', Symbol='Crhr2', Aliases=['CRF-', 'CRF-R2', 'CRFR', 'CRFR2alpha', 'CRFR2b', 'CRFR2beta', 'CRH-', 'Crf', 'Crfr2'], description='corticotropin releasing hormone receptor 2', other_designations='corticotropin-releasing factor receptor 2|CRF 2 receptor|CRF-R-2|CRF-RB|CRFR-2|CRH-R-2|CRH-R2|corticotropin releasing factor receptor type 2 beta|corticotropin-releasing factor 2', map_location='6 27.33 cM', chromosome='6', genomic_nucleotide_accession_version='NC_000072.6', start_position_on_the_genomic_accession=55090048, end_position_on_the_genomic_accession=55133016, orientation='minus', exon_count=14, OMIM=[], no_hdr0=''),
    12925 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=12925, CurrentID=0, Status='live', Symbol='Crip1', Aliases=['C', 'CR', 'CRHP', 'CRP1', 'Crip'], description='cysteine-rich protein 1 (intestinal)', other_designations='cysteine-rich protein 1|CRP-1|cysteine-rich intestinal protein', map_location='12 61.59 cM', chromosome='12', genomic_nucleotide_accession_version='NC_000078.6', start_position_on_the_genomic_accession=113152012, end_position_on_the_genomic_accession=113153879, orientation='plus', exon_count=5, OMIM=[], no_hdr0=''),
    12927 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=12927, CurrentID=0, Status='live', Symbol='Bcar1', Aliases=['AI385681', 'C', 'Cas', 'Cr', 'Crkas', 'p130'], description='breast cancer anti-estrogen resistance 1', other_designations='breast cancer anti-estrogen resistance protein 1|CRK-associated substrate|p130 Cas|p130cas|v-crk-associated tyrosine kinase substrate', map_location='8 E1', chromosome='8', genomic_nucleotide_accession_version='NC_000074.6', start_position_on_the_genomic_accession=111710474, end_position_on_the_genomic_accession=111743849, orientation='minus', exon_count=8, OMIM=[], no_hdr0=''),
    12928 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=12928, CurrentID=0, Status='live', Symbol='Crk', Aliases=['Cr-I', 'Crk-II', 'Crk-III', 'Crk3', 'CrkIII', 'Crko', 'c-Crk', 'p38', 'Crk'], description='v-crk avian sarcoma virus CT10 oncogene homolog', other_designations='adapter molecule crk|CT-10 related kinase 3|avian sarcoma virus CT10 (v-crk) oncogene homolog|proto-oncogene c-crk|v-crk sarcoma virus CT10 oncogene-like protein', map_location='11 45.92 cM', chromosome='11', genomic_nucleotide_accession_version='NC_000077.6', start_position_on_the_genomic_accession=75679194, end_position_on_the_genomic_accession=75708428, orientation='plus', exon_count=4, OMIM=[], no_hdr0=''),
    12929 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=12929, CurrentID=0, Status='live', Symbol='Crkl', Aliases=['1110025F07Rik', 'AA589403', 'AI325100', 'Cr', 'Crkol', 'snoop'], description='v-crk avian sarcoma virus CT10 oncogene homolog-like', other_designations='crk-like protein|v-crk sarcoma virus CT10 oncogene homolog-like', map_location='16 A3', chromosome='16', genomic_nucleotide_accession_version='NC_000082.6', start_position_on_the_genomic_accession=17451985, end_position_on_the_genomic_accession=17487440, orientation='plus', exon_count=3, OMIM=[], no_hdr0=''),
    12931 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=12931, CurrentID=0, Status='live', Symbol='Crlf1', Aliases=['CLF-', 'CLF-1', 'CRL', 'CRLM-3', 'CRLM3', 'NR6', 'NR6.1'], description='cytokine receptor-like factor 1', other_designations='cytokine receptor-like factor 1|cytokine receptor-like molecule 3|cytokine-like factor 1|novel cytokine receptor 6', map_location='8 34.15 cM', chromosome='8', genomic_nucleotide_accession_version='NC_000074.6', start_position_on_the_genomic_accession=70493097, end_position_on_the_genomic_accession=70504078, orientation='plus', exon_count=10, OMIM=[], no_hdr0=''),
    12933 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=12933, CurrentID=0, Status='live', Symbol='Crmp1', Aliases=['CRMP-1', 'DRP', 'DRP-1', 'Dpysl1', 'ULIP-3', 'Ul', 'Ulip3'], description='collapsin response mediator protein 1', other_designations='dihydropyrimidinase-related protein 1|inactive dihydropyrimidinase|unc-33-like phosphoprotein 3', map_location='5 19.96 cM', chromosome='5', genomic_nucleotide_accession_version='NC_000071.6', start_position_on_the_genomic_accession=37242058, end_position_on_the_genomic_accession=37292163, orientation='plus', exon_count=15, OMIM=[], no_hdr0=''),
    12934 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=12934, CurrentID=0, Status='live', Symbol='Dpysl2', Aliases=['AI851130', 'Crm', 'Crmp2', 'DR', 'DRP2', 'Musunc33', 'TOAD-', 'TOAD-64', 'Ul', 'Ulip2'], description='dihydropyrimidinase-like 2', other_designations='dihydropyrimidinase-related protein 2|DRP-2|ULIP-2|collapsin response mediator protein 2|unc-33-like phosphoprotein 2', map_location='14 34.6 cM', chromosome='14', genomic_nucleotide_accession_version='NC_000080.6', start_position_on_the_genomic_accession=66802864, end_position_on_the_genomic_accession=66911041, orientation='minus', exon_count=15, OMIM=[], no_hdr0=''),
    12936 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=12936, CurrentID=0, Status='live', Symbol='Pcdha4', Aliases=['Cn', 'Cnr1', 'Cr', 'Crnr1', 'R75250'], description='protocadherin alpha 4', other_designations='protocadherin alpha-4|PCDH-alpha-4|cadherin-related neuronal receptor 1', map_location='18 B2-B3', chromosome='18', genomic_nucleotide_accession_version='NC_000084.6', start_position_on_the_genomic_accession=36952689, end_position_on_the_genomic_accession=37187657, orientation='plus', exon_count=4, OMIM=[], no_hdr0=''),
    12937 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=12937, CurrentID=0, Status='live', Symbol='Pcdha6', Aliases=['CNR', 'Cn', 'Cnr2', 'Cr', 'Crnr2'], description='protocadherin alpha 6', other_designations='protocadherin alpha-6|cadherin-related neuronal receptor 2', map_location='18 B2-B3', chromosome='18', genomic_nucleotide_accession_version='NC_000084.6', start_position_on_the_genomic_accession=36967625, end_position_on_the_genomic_accession=37188897, orientation='plus', exon_count=4, OMIM=[], no_hdr0=''),
    12939 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=12939, CurrentID=0, Status='live', Symbol='Pcdha7', Aliases=['Cn', 'Cnr4', 'Cr', 'Crnr4'], description='protocadherin alpha 7', other_designations='protocadherin alpha-7|PCDH-alpha-7|cadherin-related neuronal receptor 4', map_location='18 B2-B3', chromosome='18', genomic_nucleotide_accession_version='NC_000084.6', start_position_on_the_genomic_accession=36973811, end_position_on_the_genomic_accession=37187663, orientation='plus', exon_count=4, OMIM=[], no_hdr0=''),
    12941 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=12941, CurrentID=0, Status='live', Symbol='Pcdha5', Aliases=['Cn', 'Cnr6', 'Cr', 'Crnr6'], description='protocadherin alpha 5', other_designations='protocadherin alpha-5|cadherin-related neuronal receptor 6', map_location='18 B2-B3', chromosome='18', genomic_nucleotide_accession_version='NC_000084.6', start_position_on_the_genomic_accession=36960276, end_position_on_the_genomic_accession=37187663, orientation='plus', exon_count=4, OMIM=[], no_hdr0=''),
    12942 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=12942, CurrentID=0, Status='live', Symbol='Pcdha11', Aliases=['A830022B16Rik', 'Cn', 'Cnr7', 'Cr', 'Crnr7'], description='protocadherin alpha 11', other_designations='protocadherin alpha-11|cadherin-related neuronal receptor 7', map_location='18 B2-B3', chromosome='18', genomic_nucleotide_accession_version='NC_000084.6', start_position_on_the_genomic_accession=37010858, end_position_on_the_genomic_accession=37187657, orientation='plus', exon_count=4, OMIM=[], no_hdr0=''),
    12943 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=12943, CurrentID=0, Status='live', Symbol='Pcdha10', Aliases=['Cn', 'Cnr3', 'Cnr8', 'Cr', 'Crnr3', 'Crnr8', 'Pcdha', 'Pcdha14'], description='protocadherin alpha 10', other_designations='protocadherin alpha-10|PCDH-alpha-10|cadherin-related neuronal receptor 3|protocadherin alpha 14', map_location='18 B2-B3', chromosome='18', genomic_nucleotide_accession_version='NC_000084.6', start_position_on_the_genomic_accession=37005320, end_position_on_the_genomic_accession=37187657, orientation='plus', exon_count=4, OMIM=[], no_hdr0=''),
    12944 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=12944, CurrentID=0, Status='live', Symbol='Crp', Aliases=['AI255847'], description='C-reactive protein, pentraxin-related', other_designations='C-reactive protein|C-reactive protein, petaxin related', map_location='1 80.13 cM', chromosome='1', genomic_nucleotide_accession_version='NC_000067.6', start_position_on_the_genomic_accession=172698056, end_position_on_the_genomic_accession=172699966, orientation='plus', exon_count=2, OMIM=[], no_hdr0=''),
    12945 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=12945, CurrentID=0, Status='live', Symbol='Dmbt1', Aliases=['CRP', 'CRP-', 'CRP-[', 'CRP-[a]', 'CRP-[b]', 'Cr', 'Crpd', 'DBMT1', 'MUC', 'ebn', 'gp30', 'gp300', 'he', 'p80'], description='deleted in malignant brain tumors 1', other_designations='deleted in malignant brain tumors 1 protein|apactin|crp-ductin|deleted in malignant brain tumors 1 pseudogene|ebnerin|glycoprotein 300|hensin|mucin-like glycoprotein|muclin|vomeroglandin', map_location='7 F3', chromosome='7', genomic_nucleotide_accession_version='NC_000073.6', start_position_on_the_genomic_accession=131032057, end_position_on_the_genomic_accession=131121628, orientation='plus', exon_count=51, OMIM=[], no_hdr0=''),
    12946 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=12946, CurrentID=0, Status='live', Symbol='Cr1l', Aliases=['Cr', 'Crry', 'Mcp', 'mCR', 'mCRY'], description='complement component (3b/4b) receptor 1-like', other_designations='complement component receptor 1-like protein|complement receptor related protein|complement regulatory protein Crry|protein p65', map_location='1 98.43 cM', chromosome='1', genomic_nucleotide_accession_version='NC_000067.6', start_position_on_the_genomic_accession=195098711, end_position_on_the_genomic_accession=195131570, orientation='minus', exon_count=11, OMIM=[], no_hdr0=''),
    12950 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=12950, CurrentID=0, Status='live', Symbol='Hapln1', Aliases=['BB099155', 'C', 'CLP', 'Crt', 'Crtl1', 'Crtl1l', 'LP', 'LP-1'], description='hyaluronan and proteoglycan link protein 1', other_designations='hyaluronan and proteoglycan link protein 1|cartilage link protein 1|cartilage-link protein|cartilage-linking protein 1|link protein|proteoglycan link protein', map_location='13 45.5 cM', chromosome='13', genomic_nucleotide_accession_version='NC_000079.6', start_position_on_the_genomic_accession=89540529, end_position_on_the_genomic_accession=89611832, orientation='plus', exon_count=5, OMIM=[], no_hdr0=''),
    12951 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=12951, CurrentID=0, Status='live', Symbol='Crx', Aliases=['Crx1'], description='cone-rod homeobox', other_designations='cone-rod homeobox protein|cone-rod homeobox containing', map_location='7 8.6 cM', chromosome='7', genomic_nucleotide_accession_version='NC_000073.6', start_position_on_the_genomic_accession=15865947, end_position_on_the_genomic_accession=15879955, orientation='minus', exon_count=5, OMIM=[], no_hdr0=''),
    12952 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=12952, CurrentID=0, Status='live', Symbol='Cry1', Aliases=['AU020726', 'AU021000', 'Ph', 'Phll1'], description='cryptochrome 1 (photolyase-like)', other_designations='cryptochrome-1', map_location='10 41.63 cM', chromosome='10', genomic_nucleotide_accession_version='NC_000076.6', start_position_on_the_genomic_accession=85131700, end_position_on_the_genomic_accession=85185054, orientation='minus', exon_count=15, OMIM=[], no_hdr0=''),
    12953 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=12953, CurrentID=0, Status='live', Symbol='Cry2', Aliases=['AV006279', 'D130054K12Rik'], description='cryptochrome 2 (photolyase-like)', other_designations='cryptochrome-2', map_location='2 E1', chromosome='2', genomic_nucleotide_accession_version='NC_000068.7', start_position_on_the_genomic_accession=92403646, end_position_on_the_genomic_accession=92434085, orientation='minus', exon_count=14, OMIM=[], no_hdr0=''),
    12954 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=12954, CurrentID=0, Status='live', Symbol='Cryaa', Aliases=['Acry', 'Acry-1', 'Cry', 'Crya', 'Crya-1', 'Crya1', 'DAcry', 'DAcry-1', 'lop18'], description='crystallin, alpha A', other_designations='alpha-crystallin A chain|crystallin, alpha 1|lens opacity 18', map_location='17 17.09 cM', chromosome='17', genomic_nucleotide_accession_version='NC_000083.6', start_position_on_the_genomic_accession=31677931, end_position_on_the_genomic_accession=31681730, orientation='plus', exon_count=4, OMIM=[], no_hdr0=''),
    12955 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=12955, CurrentID=0, Status='live', Symbol='Cryab', Aliases=['Cry', 'Crya', 'Crya-2', 'Crya2', 'Hsp', 'HspB5', 'P23'], description='crystallin, alpha B', other_designations='alpha-crystallin B chain|alpha(B)-crystallin|crystallin, alpha 2|heat shock protein CryAB|heat shock protein HspB5', map_location='9 27.75 cM', chromosome='9', genomic_nucleotide_accession_version='NC_000075.6', start_position_on_the_genomic_accession=50745951, end_position_on_the_genomic_accession=50756636, orientation='plus', exon_count=6, OMIM=[], no_hdr0=''),
    12957 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=12957, CurrentID=0, Status='live', Symbol='Cryba1', Aliases=['BA3/', 'BA3/A1', 'Cry', 'Cryb'], description='crystallin, beta A1', other_designations='beta-crystallin A1|beta-A1-crystallin|beta-A3/A1-crystallin', map_location='11 46.74 cM', chromosome='11', genomic_nucleotide_accession_version='NC_000077.6', start_position_on_the_genomic_accession=77718614, end_position_on_the_genomic_accession=77725293, orientation='minus', exon_count=6, OMIM=[], no_hdr0=''),
    12958 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=12958, CurrentID=0, Status='live', Symbol='Cryba2', Aliases=['E130107M19Rik'], description='crystallin, beta A2', other_designations='beta-crystallin A2|beta-A2 crystallin|betaA2-crystallin|lens structural protein', map_location='1 38.54 cM', chromosome='1', genomic_nucleotide_accession_version='NC_000067.6', start_position_on_the_genomic_accession=74889934, end_position_on_the_genomic_accession=74898842, orientation='minus', exon_count=6, OMIM=[], no_hdr0=''),
    12959 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=12959, CurrentID=0, Status='live', Symbol='Cryba4', Aliases=[], description='crystallin, beta A4', other_designations='beta-crystallin A4|beta-A4 crystallin', map_location='5 F', chromosome='5', genomic_nucleotide_accession_version='NC_000071.6', start_position_on_the_genomic_accession=112246492, end_position_on_the_genomic_accession=112263625, orientation='minus', exon_count=8, OMIM=[], no_hdr0=''),
    12960 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=12960, CurrentID=0, Status='live', Symbol='Crybb1', Aliases=['3110006K12Rik', 'BB1CRY'], description='crystallin, beta B1', other_designations='beta-crystallin B1', map_location='5 54.63 cM', chromosome='5', genomic_nucleotide_accession_version='NC_000071.6', start_position_on_the_genomic_accession=112254563, end_position_on_the_genomic_accession=112269585, orientation='plus', exon_count=11, OMIM=[], no_hdr0=''),
    12961 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=12961, CurrentID=0, Status='live', Symbol='Crybb2', Aliases=['Aey', 'Cryb-', 'Cryb-2'], description='crystallin, beta B2', other_designations='beta-crystallin B2|beta-crystallin Bp', map_location='5 55.38 cM', chromosome='5', genomic_nucleotide_accession_version='NC_000071.6', start_position_on_the_genomic_accession=113058258, end_position_on_the_genomic_accession=113070117, orientation='minus', exon_count=9, OMIM=[], no_hdr0=''),
    12962 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=12962, CurrentID=0, Status='live', Symbol='Crybb3', Aliases=['AI852419'], description='crystallin, beta B3', other_designations='beta-crystallin B3|beta-B3 crystallin', map_location='5 55.38 cM', chromosome='5', genomic_nucleotide_accession_version='NC_000071.6', start_position_on_the_genomic_accession=113075839, end_position_on_the_genomic_accession=113082236, orientation='minus', exon_count=7, OMIM=[], no_hdr0=''),
    12964 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=12964, CurrentID=0, Status='live', Symbol='Cryga', Aliases=['Cryg-', 'Cryg-4', 'DGcry-', 'DGcry-4', 'Sec', 'Secc'], description='crystallin, gamma A', other_designations='gamma-crystallin A|gamma-A-crystallin|gamma-crystallin 4', map_location='1 32.84 cM', chromosome='1', genomic_nucleotide_accession_version='NC_000067.6', start_position_on_the_genomic_accession=65100389, end_position_on_the_genomic_accession=65103363, orientation='minus', exon_count=3, OMIM=[], no_hdr0=''),
    12965 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=12965, CurrentID=0, Status='live', Symbol='Crygb', Aliases=['Cryg-', 'Cryg-3', 'DGcry-', 'DGcry-3', 'Nop'], description='crystallin, gamma B', other_designations='gamma-crystallin B|gamma-B-crystallin|gamma-crystallin 3|gammaB-crystallin|nuclear opacity', map_location='1 32.82 cM', chromosome='1', genomic_nucleotide_accession_version='NC_000067.6', start_position_on_the_genomic_accession=65080222, end_position_on_the_genomic_accession=65082290, orientation='minus', exon_count=3, OMIM=[], no_hdr0=''),
    12966 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=12966, CurrentID=0, Status='live', Symbol='Crygc', Aliases=['Cryg-', 'Cryg-5'], description='crystallin, gamma C', other_designations='gamma-crystallin C|gamma-C-crystallin|gammaC-crystallin', map_location='1 32.81 cM', chromosome='1', genomic_nucleotide_accession_version='NC_000067.6', start_position_on_the_genomic_accession=65071525, end_position_on_the_genomic_accession=65073532, orientation='minus', exon_count=3, OMIM=[], no_hdr0=''),
    12967 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=12967, CurrentID=0, Status='live', Symbol='Crygd', Aliases=['Aey', 'Aey4', 'Cryg-', 'Cryg-1', 'DGcry-', 'DGcry-1', 'Lop12'], description='crystallin, gamma D', other_designations='gamma-crystallin D|gamma-D-crystallin|gamma-crystallin 1|lens opacity 12', map_location='1 32.8 cM', chromosome='1', genomic_nucleotide_accession_version='NC_000067.6', start_position_on_the_genomic_accession=65061838, end_position_on_the_genomic_accession=65063440, orientation='minus', exon_count=3, OMIM=[], no_hdr0=''),
    12968 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=12968, CurrentID=0, Status='live', Symbol='Cryge', Aliases=['Cryg-', 'Cryg-2', 'Cryg-6', 'DGcry-2', 'Elo'], description='crystallin, gamma E', other_designations='gamma-crystallin E|eye lens obsolescence|gamma-E-crystallin', map_location='1 32.8 cM', chromosome='1', genomic_nucleotide_accession_version='NC_000067.6', start_position_on_the_genomic_accession=65048555, end_position_on_the_genomic_accession=65051816, orientation='minus', exon_count=4, OMIM=[], no_hdr0=''),
    12969 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=12969, CurrentID=0, Status='live', Symbol='Crygf', Aliases=['3110001K11Rik', 'Cryg-', 'Cryg-2', 'DGcry-', 'DGcry-2', 'Len', 'Len-2'], description='crystallin, gamma F', other_designations='gamma-crystallin F|gamma-F-crystallin', map_location='1 33.31 cM', chromosome='1', genomic_nucleotide_accession_version='NC_000067.6', start_position_on_the_genomic_accession=65926522, end_position_on_the_genomic_accession=65928311, orientation='plus', exon_count=3, OMIM=[], no_hdr0=''),
    12970 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=12970, CurrentID=0, Status='live', Symbol='Crygs', Aliases=['AI327013', 'O', 'Opj', 'rncat'], description='crystallin, gamma S', other_designations='gamma-crystallin S|beta-crystallin S|opacity due to poor secondary fiber cell junction|recessive nuclear cataract', map_location='16 13.66 cM', chromosome='16', genomic_nucleotide_accession_version='NC_000082.6', start_position_on_the_genomic_accession=22805203, end_position_on_the_genomic_accession=22811410, orientation='minus', exon_count=4, OMIM=[], no_hdr0=''),
    12971 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=12971, CurrentID=0, Status='live', Symbol='Crym', Aliases=[], description='crystallin, mu', other_designations='ketimine reductase mu-crystallin|NADP-regulated thyroid-hormone-binding protein|mu-crystallin homolog|thiomorpholine-carboxylate dehydrogenase', map_location='7 64.47 cM', chromosome='7', genomic_nucleotide_accession_version='NC_000073.6', start_position_on_the_genomic_accession=120186380, end_position_on_the_genomic_accession=120201989, orientation='minus', exon_count=8, OMIM=[], no_hdr0=''),
    12972 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=12972, CurrentID=0, Status='live', Symbol='Cryz', Aliases=['SEZ', 'Sez9'], description='crystallin, zeta', other_designations='quinone oxidoreductase|NADPH:quinone reductase|quinone reductase|zeta-crystallin', map_location='3 H4', chromosome='3', genomic_nucleotide_accession_version='NC_000069.6', start_position_on_the_genomic_accession=154596711, end_position_on_the_genomic_accession=154623182, orientation='plus', exon_count=9, OMIM=[], no_hdr0=''),
    12974 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=12974, CurrentID=0, Status='live', Symbol='Cs', Aliases=['2610511A05Rik', '9030605P22Rik', 'Ahl4', 'BB234005', 'C', 'Cis', 'ah'], description='citrate synthase', other_designations='citrate synthase, mitochondrial|citrate (Si)-synthase', map_location='10 D3', chromosome='10', genomic_nucleotide_accession_version='NC_000076.6', start_position_on_the_genomic_accession=128337727, end_position_on_the_genomic_accession=128362482, orientation='plus', exon_count=12, OMIM=[], no_hdr0=''),
    12977 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=12977, CurrentID=0, Status='live', Symbol='Csf1', Aliases=['C87615', 'CSF-', 'Csf', 'Csfm', 'M-CS', 'MCSF', 'op'], description='colony stimulating factor 1 (macrophage)', other_designations='macrophage colony-stimulating factor 1|osteopetrosis', map_location='3 46.83 cM', chromosome='3', genomic_nucleotide_accession_version='NC_000069.6', start_position_on_the_genomic_accession=107741048, end_position_on_the_genomic_accession=107760469, orientation='minus', exon_count=10, OMIM=[], no_hdr0=''),
    12978 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=12978, CurrentID=0, Status='live', Symbol='Csf1r', Aliases=['AI323359', 'CD115', 'CSF-', 'CSF-1R', 'Csf', 'Csfmr', 'Fim', 'Fim-', 'Fim-2', 'Fim2', 'Fm', 'Fms', 'M-CS', 'M-CSF-R', 'M-CSFR'], description='colony stimulating factor 1 receptor', other_designations='macrophage colony-stimulating factor 1 receptor|CSF-1 receptor|CSF-1-R|c-fms|proto-oncogene c-Fms|proto-oncogene fms', map_location='18 34.41 cM', chromosome='18', genomic_nucleotide_accession_version='NC_000084.6', start_position_on_the_genomic_accession=61105572, end_position_on_the_genomic_accession=61131139, orientation='plus', exon_count=22, OMIM=[], no_hdr0=''),
    12981 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=12981, CurrentID=0, Status='live', Symbol='Csf2', Aliases=['CSF', 'Csfg', 'Csfgm', 'GMCS', 'GMCSF', 'Gm-CS', 'Gm-CSf', 'MGI-I', 'MGI-IGM'], description='colony stimulating factor 2 (granulocyte-macrophage)', other_designations='granulocyte-macrophage colony-stimulating factor|colony-stimulating factor|granulocyte-macrophage colony stimulating factor 2|put. GM-CSF', map_location='11 32.13 cM', chromosome='11', genomic_nucleotide_accession_version='NC_000077.6', start_position_on_the_genomic_accession=54247270, end_position_on_the_genomic_accession=54249899, orientation='minus', exon_count=5, OMIM=[], no_hdr0=''),
    12982 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=12982, CurrentID=0, Status='live', Symbol='Csf2ra', Aliases=['CD116', 'Csfg', 'Csfgmra', 'GM-CSF', 'GM-CSF-Ra', 'GM-CSFR'], description='colony stimulating factor 2 receptor, alpha, low-affinity (granulocyte-macrophage)', other_designations='granulocyte-macrophage colony-stimulating factor receptor subunit alpha|GM-CSF-R-alpha|GM-CSFRalpha|GMCSFR-alpha|GMR-alpha|colony stimulating factor 2 receptor alpha chain', map_location='19 56.89 cM', chromosome='19', genomic_nucleotide_accession_version='NC_000085.6', start_position_on_the_genomic_accession=61217191, end_position_on_the_genomic_accession=61228461, orientation='minus', exon_count=12, OMIM=[], no_hdr0=''),
    12983 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=12983, CurrentID=0, Status='live', Symbol='Csf2rb', Aliases=['AI848964', 'AIC', 'AIC2B', 'Bc', 'CDw131', 'Csf2r1', 'Csfgmrb', 'I', 'Il', 'Il3', 'Il3r', 'Il3rb', 'Il3rb1', 'Il5rb', 'Csf2rb'], description='colony stimulating factor 2 receptor, beta, low-affinity (granulocyte-macrophage)', other_designations='cytokine receptor common subunit beta|CD131 antigen|GM-CSF/IL-3/IL-5 receptor common beta subunit|GM-CSF/IL-3/IL-5 receptor common beta-chain|beta c|colony stimulating factor 2 receptor, beta 1, low-affinity (granulocyte-macrophage)|common beta chain', map_location='15 37.36 cM', chromosome='15', genomic_nucleotide_accession_version='NC_000081.6', start_position_on_the_genomic_accession=78325800, end_position_on_the_genomic_accession=78351001, orientation='plus', exon_count=15, OMIM=[], no_hdr0=''),
    12984 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=12984, CurrentID=0, Status='live', Symbol='Csf2rb2', Aliases=['AI', 'AIC2A', 'BetaIl3', 'Bi', 'Bil3', 'Csfgmrb', 'I', 'Il3', 'Il3r', 'Il3rb', 'Il3rb2'], description='colony stimulating factor 2 receptor, beta 2, low-affinity (granulocyte-macrophage)', other_designations='interleukin-3 receptor class 2 subunit beta|IL-3 receptor class 2 subunit beta|IL-3R class 2 subunit beta|colony-stimulating factor 2 receptor subunit beta-2|interleukin-3 receptor class II beta chain', map_location='15 37.22 cM', chromosome='15', genomic_nucleotide_accession_version='NC_000081.6', start_position_on_the_genomic_accession=78282507, end_position_on_the_genomic_accession=78305721, orientation='minus', exon_count=14, OMIM=[], no_hdr0=''),
    12985 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=12985, CurrentID=0, Status='live', Symbol='Csf3', Aliases=['Csf', 'Csfg', 'G-CS', 'G-CSF', 'MGI-', 'MGI-IG'], description='colony stimulating factor 3 (granulocyte)', other_designations='granulocyte colony-stimulating factor', map_location='11 62.45 cM', chromosome='11', genomic_nucleotide_accession_version='NC_000077.6', start_position_on_the_genomic_accession=98700183, end_position_on_the_genomic_accession=98703631, orientation='plus', exon_count=6, OMIM=[], no_hdr0=''),
    12986 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=12986, CurrentID=0, Status='live', Symbol='Csf3r', Aliases=['Cd114', 'Csf', 'Csfgr', 'G-CS', 'G-CSF-R', 'G-CSFR'], description='colony stimulating factor 3 receptor (granulocyte)', other_designations='granulocyte colony-stimulating factor receptor|G-CSF receptor', map_location='4 59.77 cM', chromosome='4', genomic_nucleotide_accession_version='NC_000070.6', start_position_on_the_genomic_accession=126023441, end_position_on_the_genomic_accession=126044975, orientation='plus', exon_count=19, OMIM=[], no_hdr0=''),
    12988 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=12988, CurrentID=0, Status='live', Symbol='Csk', Aliases=['AW212630', 'p50CSK'], description='c-src tyrosine kinase', other_designations='tyrosine-protein kinase CSK|C-Src kinase|protein-tyrosine kinase MPK-2', map_location='9 31.18 cM', chromosome='9', genomic_nucleotide_accession_version='NC_000075.6', start_position_on_the_genomic_accession=57626646, end_position_on_the_genomic_accession=57653631, orientation='minus', exon_count=18, OMIM=[], no_hdr0=''),
    12990 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=12990, CurrentID=0, Status='live', Symbol='Csn1s1', Aliases=['AA959832', 'AW212882', 'C', 'Csna'], description='casein alpha s1', other_designations='alpha-S1-casein|alpha-casein', map_location='5 43.56 cM', chromosome='5', genomic_nucleotide_accession_version='NC_000071.6', start_position_on_the_genomic_accession=87666208, end_position_on_the_genomic_accession=87682578, orientation='plus', exon_count=34, OMIM=[], no_hdr0=''),
    12991 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=12991, CurrentID=0, Status='live', Symbol='Csn2', Aliases=['CS', 'Csnb'], description='casein beta', other_designations='beta-casein', map_location='5 43.56 cM', chromosome='5', genomic_nucleotide_accession_version='NC_000071.6', start_position_on_the_genomic_accession=87692619, end_position_on_the_genomic_accession=87699429, orientation='minus', exon_count=9, OMIM=[], no_hdr0=''),
    12992 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=12992, CurrentID=0, Status='live', Symbol='Csn1s2b', Aliases=['AW987150', 'Cs', 'Csnd', 'Csne'], description='casein alpha s2-like B', other_designations='alpha-S2-casein-like B|casein delta|epsilon-casein', map_location='5 43.56 cM', chromosome='5', genomic_nucleotide_accession_version='NC_000071.6', start_position_on_the_genomic_accession=87808121, end_position_on_the_genomic_accession=87824421, orientation='plus', exon_count=12, OMIM=[], no_hdr0=''),
    12993 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=12993, CurrentID=0, Status='live', Symbol='Csn1s2a', Aliases=['Cs', 'Csn', 'Csng', 'PP22'], description='casein alpha s2-like A', other_designations='alpha-S2-casein-like A|gamma casein|milk protein', map_location='5 43.56 cM', chromosome='5', genomic_nucleotide_accession_version='NC_000071.6', start_position_on_the_genomic_accession=87774450, end_position_on_the_genomic_accession=87788798, orientation='plus', exon_count=14, OMIM=[], no_hdr0=''),
    12994 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=12994, CurrentID=0, Status='live', Symbol='Csn3', Aliases=['AW208918', 'CSN', 'CSN10', 'Cs', 'Csnk'], description='casein kappa', other_designations='kappa-casein', map_location='5 43.56 cM', chromosome='5', genomic_nucleotide_accession_version='NC_000071.6', start_position_on_the_genomic_accession=87925579, end_position_on_the_genomic_accession=87932550, orientation='plus', exon_count=6, OMIM=[], no_hdr0=''),
    12995 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=12995, CurrentID=0, Status='live', Symbol='Csnk2a1', Aliases=['CK2', 'Csnk2a-rs4', 'Csnk2a1'], description='casein kinase 2, alpha 1 polypeptide', other_designations='casein kinase II subunit alpha|CK II alpha|casein kinase II, alpha 1 polypeptide|casein kinase II, alpha 1 related sequence 4', map_location='2 G3', chromosome='2', genomic_nucleotide_accession_version='NC_000068.7', start_position_on_the_genomic_accession=152226535, end_position_on_the_genomic_accession=152281856, orientation='plus', exon_count=16, OMIM=[], no_hdr0=''),
    12998 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=12998, CurrentID=0, Status='live', Symbol='Csnk2a1-rs3', Aliases=[], description='casein kinase 2, alpha 1, related sequence 3', other_designations='casein kinase II, alpha 1 related sequence 3', map_location='', chromosome='', genomic_nucleotide_accession_version='', start_position_on_the_genomic_accession='', end_position_on_the_genomic_accession='', orientation='', exon_count='', OMIM=[], no_hdr0=''),
    13000 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=13000, CurrentID=0, Status='live', Symbol='Csnk2a2', Aliases=['1110035J23Rik', 'C77789', 'CK2'], description='casein kinase 2, alpha prime polypeptide', other_designations="casein kinase II subunit alpha'|CK II alpha'|casein kinase II, alpha 2, polypeptide", map_location='8 47.12 cM', chromosome='8', genomic_nucleotide_accession_version='NC_000074.6', start_position_on_the_genomic_accession=95446096, end_position_on_the_genomic_accession=95488868, orientation='minus', exon_count=12, OMIM=[], no_hdr0=''),
    13001 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=13001, CurrentID=0, Status='live', Symbol='Csnk2b', Aliases=['CK II beta'], description='casein kinase 2, beta polypeptide', other_designations='casein kinase II subunit beta|phosvitin', map_location='17 18.59 cM', chromosome='17', genomic_nucleotide_accession_version='NC_000083.6', start_position_on_the_genomic_accession=35116195, end_position_on_the_genomic_accession=35122053, orientation='minus', exon_count=9, OMIM=[], no_hdr0=''),
    13002 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=13002, CurrentID=0, Status='live', Symbol='Dnajc5', Aliases=['2610314I24Rik', 'AU018536', 'C', 'Csp'], description='DnaJ heat shock protein family (Hsp40) member C5', other_designations='dnaJ homolog subfamily C member 5|DnaJ (Hsp40) homolog, subfamily C, member 5|cysteine string protein', map_location='2 103.63 cM', chromosome='2', genomic_nucleotide_accession_version='NC_000068.7', start_position_on_the_genomic_accession=181518858, end_position_on_the_genomic_accession=181552886, orientation='plus', exon_count=10, OMIM=[], no_hdr0=''),
    13003 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=13003, CurrentID=0, Status='live', Symbol='Vcan', Aliases=['5430420N07Rik', '9430051N09', 'Csp', 'Cspg2', 'DPE', 'DPEAAE', 'NG2', 'PG-', 'PG-M', 'PG-M(V0)', 'PG-M(V1)', 'hdf'], description='versican', other_designations='versican core protein|PG-M core protein|chondroitin sulfate proteoglycan core protein 2|large fibroblast proteoglycan', map_location='13 45.5 cM', chromosome='13', genomic_nucleotide_accession_version='NC_000079.6', start_position_on_the_genomic_accession=89655309, end_position_on_the_genomic_accession=89743027, orientation='minus', exon_count=17, OMIM=[], no_hdr0=''),
    13004 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=13004, CurrentID=0, Status='live', Symbol='Ncan', Aliases=['C230035B04', 'Csp', 'Cspg', 'Cspg3', 'Cspg3-rs', 'Tgfbi', 'Tgfbit'], description='neurocan', other_designations='neurocan core protein|TGFbeta-induced transcript, brain|chondroitin sulfate proteoglycan 3, related sequence', map_location='8 34.15 cM', chromosome='8', genomic_nucleotide_accession_version='NC_000074.6', start_position_on_the_genomic_accession=70093085, end_position_on_the_genomic_accession=70120863, orientation='minus', exon_count=15, OMIM=[], no_hdr0=''),
    13006 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=13006, CurrentID=0, Status='live', Symbol='Smc3', Aliases=['Bam', 'Bamacan', 'Csp', 'Cspg6', 'HCAP', 'Mmi', 'Mmip1', 'SMC-3', 'Smc', 'SmcD'], description='structural maintenance of chromosomes 3', other_designations='structural maintenance of chromosomes protein 3|SMC protein 3|basement membrane-associated chondroitin proteoglycan|chondroitin sulfate proteoglycan 6|chromosome segregation protein SmcD|mad member-interacting protein 1|structural maintenace of chromosomes 3', map_location='19 D2', chromosome='19', genomic_nucleotide_accession_version='NC_000085.6', start_position_on_the_genomic_accession=53600396, end_position_on_the_genomic_accession=53645831, orientation='plus', exon_count=29, OMIM=[], no_hdr0=''),
    13007 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=13007, CurrentID=0, Status='live', Symbol='Csrp1', Aliases=['AA408841', 'AA959891', 'AW545626', 'CR', 'CRP1', 'Csrp'], description='cysteine and glycine-rich protein 1', other_designations='cysteine and glycine-rich protein 1|CRP|cysteine rich protein 1', map_location='1 E4', chromosome='1', genomic_nucleotide_accession_version='NC_000067.6', start_position_on_the_genomic_accession=135720063, end_position_on_the_genomic_accession=135752229, orientation='plus', exon_count=7, OMIM=[], no_hdr0=''),
    13008 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=13008, CurrentID=0, Status='live', Symbol='Csrp2', Aliases=['AW551867', 'Cr', 'Crp2', 'Sm', 'SmLim'], description='cysteine and glycine-rich protein 2', other_designations='cysteine and glycine-rich protein 2|DLP-1|cysteine-rich protein 2|double LIM protein 1', map_location='10 D1', chromosome='10', genomic_nucleotide_accession_version='NC_000076.6', start_position_on_the_genomic_accession=110920176, end_position_on_the_genomic_accession=110939514, orientation='plus', exon_count=6, OMIM=[], no_hdr0=''),
    13009 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=13009, CurrentID=0, Status='live', Symbol='Csrp3', Aliases=['CR', 'CRP3', 'M', 'MLP', 'MMLP'], description='cysteine and glycine-rich protein 3', other_designations='cysteine and glycine-rich protein 3|LIM domain protein, cardiac|cardiac LIM protein|cysteine-rich protein 3|muscle LIM protein', map_location='7 B4', chromosome='7', genomic_nucleotide_accession_version='NC_000073.6', start_position_on_the_genomic_accession=48830398, end_position_on_the_genomic_accession=48848051, orientation='minus', exon_count=7, OMIM=[], no_hdr0=''),
    13010 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=13010, CurrentID=0, Status='live', Symbol='Cst3', Aliases=['Cys', 'CysC'], description='cystatin C', other_designations='cystatin-C|cystatin-3', map_location='2 73.6 cM', chromosome='2', genomic_nucleotide_accession_version='NC_000068.7', start_position_on_the_genomic_accession=148871722, end_position_on_the_genomic_accession=148875512, orientation='minus', exon_count=3, OMIM=[], no_hdr0=''),
    13011 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=13011, CurrentID=0, Status='live', Symbol='Cst7', Aliases=['CM', 'Cmap'], description='cystatin F (leukocystatin)', other_designations='cystatin-F|cystatin-7|cystatin-like metastasis-associated protein', map_location='2 G3', chromosome='2', genomic_nucleotide_accession_version='NC_000068.7', start_position_on_the_genomic_accession=150570415, end_position_on_the_genomic_accession=150578944, orientation='plus', exon_count=4, OMIM=[], no_hdr0=''),
    13012 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=13012, CurrentID=0, Status='live', Symbol='Cst8', Aliases=['Cr', 'Cres', 'Cst-', 'Cst-rs1'], description='cystatin 8 (cystatin-related epididymal spermatogenic)', other_designations='cystatin-8|cystatin-related epididymal spermatogenic protein|cystatin-related epididymal-specific protein', map_location='2 73.56 cM', chromosome='2', genomic_nucleotide_accession_version='NC_000068.7', start_position_on_the_genomic_accession=148798839, end_position_on_the_genomic_accession=148805596, orientation='plus', exon_count=6, OMIM=[], no_hdr0=''),
    13013 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=13013, CurrentID=0, Status='live', Symbol='Cst9', Aliases=['M12', 'cr', 'cresp', 'testatin'], description='cystatin 9', other_designations='cystatin-9', map_location='2 G3', chromosome='2', genomic_nucleotide_accession_version='NC_000068.7', start_position_on_the_genomic_accession=148835147, end_position_on_the_genomic_accession=148838737, orientation='plus', exon_count=3, OMIM=[], no_hdr0=''),
    13014 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=13014, CurrentID=0, Status='live', Symbol='Cstb', Aliases=['AA960480', 'Stf', 'Stfb'], description='cystatin B', other_designations='cystatin-B|stefin-B', map_location='10 39.72 cM', chromosome='10', genomic_nucleotide_accession_version='NC_000076.6', start_position_on_the_genomic_accession=78425670, end_position_on_the_genomic_accession=78427622, orientation='plus', exon_count=3, OMIM=[], no_hdr0=''),
    13016 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=13016, CurrentID=0, Status='live', Symbol='Ctbp1', Aliases=['B', 'BARS', 'CtBP3/', 'CtBP3/BARS', 'D4S115', 'D4S115h', 'D5H4S11', 'D5H4S115', 'D5H4S115E'], description='C-terminal binding protein 1', other_designations='C-terminal-binding protein 1', map_location='5 17.52 cM', chromosome='5', genomic_nucleotide_accession_version='NC_000071.6', start_position_on_the_genomic_accession=33247723, end_position_on_the_genomic_accession=33275004, orientation='minus', exon_count=10, OMIM=[], no_hdr0=''),
    13017 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=13017, CurrentID=0, Status='live', Symbol='Ctbp2', Aliases=['AA407280', 'D7Ertd45', 'D7Ertd45e', 'Gtrge', 'Gtrgeo6', 'Ribe', 'Ribeye'], description='C-terminal binding protein 2', other_designations='C-terminal-binding protein 2|gene trap ROSA b-geo 6', map_location='7 76.32 cM', chromosome='7', genomic_nucleotide_accession_version='NC_000073.6', start_position_on_the_genomic_accession=132986998, end_position_on_the_genomic_accession=133124009, orientation='minus', exon_count=17, OMIM=[], no_hdr0=''),
    13018 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=13018, CurrentID=0, Status='live', Symbol='Ctcf', Aliases=['AW108038'], description='CCCTC-binding factor', other_designations='transcriptional repressor CTCF|11-zinc finger protein|CTCFL paralog', map_location='8 D3', chromosome='8', genomic_nucleotide_accession_version='NC_000074.6', start_position_on_the_genomic_accession=105636474, end_position_on_the_genomic_accession=105682922, orientation='plus', exon_count=14, OMIM=[], no_hdr0=''),
    13019 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=13019, CurrentID=0, Status='live', Symbol='Ctf1', Aliases=['CT-1'], description='cardiotrophin 1', other_designations='cardiotrophin-1', map_location='7 F3', chromosome='7', genomic_nucleotide_accession_version='NC_000073.6', start_position_on_the_genomic_accession=127712676, end_position_on_the_genomic_accession=127718188, orientation='plus', exon_count=4, OMIM=[], no_hdr0=''),
    13024 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=13024, CurrentID=0, Status='live', Symbol='Ctla2a', Aliases=['Ctla', 'Ctla-2a'], description='cytotoxic T lymphocyte-associated protein 2 alpha', other_designations='protein CTLA-2-alpha', map_location='13 32.56 cM', chromosome='13', genomic_nucleotide_accession_version='NC_000079.6', start_position_on_the_genomic_accession=60934155, end_position_on_the_genomic_accession=60936625, orientation='minus', exon_count=5, OMIM=[], no_hdr0=''),
    13025 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=13025, CurrentID=0, Status='live', Symbol='Ctla2b', Aliases=['AW545568', 'Ctla-', 'Ctla-2b'], description='cytotoxic T lymphocyte-associated protein 2 beta', other_designations='protein CTLA-2-beta', map_location='13', chromosome='13', genomic_nucleotide_accession_version='NC_000079.6', start_position_on_the_genomic_accession=60895351, end_position_on_the_genomic_accession=60897934, orientation='minus', exon_count=5, OMIM=[], no_hdr0=''),
    13026 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=13026, CurrentID=0, Status='live', Symbol='Pcyt1a', Aliases=['CTa', 'CTalpha', 'Ccta', 'Cctalpha', 'Ctpc', 'Ctpct', 'Ctta', 'Cttalpha'], description='phosphate cytidylyltransferase 1, choline, alpha isoform', other_designations='choline-phosphate cytidylyltransferase A|CCT A|CCT-alpha|CT A|CTP phosphocholine cytidylyl transferase|CTP:phosphocholine cytidylyltransferase A|CTP:phosphocholine cytidylyltransferase alpha|phosphorylcholine transferase A', map_location='16 22.69 cM', chromosome='16', genomic_nucleotide_accession_version='NC_000082.6', start_position_on_the_genomic_accession=32430921, end_position_on_the_genomic_accession=32475065, orientation='plus', exon_count=9, OMIM=[], no_hdr0=''),
    13030 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=13030, CurrentID=0, Status='live', Symbol='Ctsb', Aliases=['CB'], description='cathepsin B', other_designations='cathepsin B|cathepsin B1', map_location='14 33.24 cM', chromosome='14', genomic_nucleotide_accession_version='NC_000080.6', start_position_on_the_genomic_accession=63122462, end_position_on_the_genomic_accession=63145923, orientation='plus', exon_count=10, OMIM=[], no_hdr0=''),
    13032 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=13032, CurrentID=0, Status='live', Symbol='Ctsc', Aliases=['AI047818', 'CatC', 'D', 'DP', 'DPP1', 'DPPI'], description='cathepsin C', other_designations='dipeptidyl peptidase 1|cathepsin J|dipeptidyl peptidase I|dipeptidyl transferase', map_location='7 D3', chromosome='7', genomic_nucleotide_accession_version='NC_000073.6', start_position_on_the_genomic_accession=88278024, end_position_on_the_genomic_accession=88315861, orientation='plus', exon_count=10, OMIM=[], no_hdr0=''),
    13033 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=13033, CurrentID=0, Status='live', Symbol='Ctsd', Aliases=['CD', 'Cat', 'CatD'], description='cathepsin D', other_designations='cathepsin D', map_location='7 F5', chromosome='7', genomic_nucleotide_accession_version='NC_000073.6', start_position_on_the_genomic_accession=142375910, end_position_on_the_genomic_accession=142387827, orientation='minus', exon_count=9, OMIM=[], no_hdr0=''),
    13034 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=13034, CurrentID=0, Status='live', Symbol='Ctse', Aliases=['A430072O03Rik', 'C920004C08Rik', 'CE', 'Cat', 'CatE'], description='cathepsin E', other_designations='cathepsin E', map_location='1 57.14 cM', chromosome='1', genomic_nucleotide_accession_version='NC_000067.6', start_position_on_the_genomic_accession=131638314, end_position_on_the_genomic_accession=131675507, orientation='plus', exon_count=10, OMIM=[], no_hdr0=''),
    13035 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=13035, CurrentID=0, Status='live', Symbol='Ctsg', Aliases=['CatG', 'VSP'], description='cathepsin G', other_designations='cathepsin G|vimentin-specific protease', map_location='14 28.19 cM', chromosome='14', genomic_nucleotide_accession_version='NC_000080.6', start_position_on_the_genomic_accession=56099885, end_position_on_the_genomic_accession=56102574, orientation='minus', exon_count=5, OMIM=[], no_hdr0=''),
    13036 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=13036, CurrentID=0, Status='live', Symbol='Ctsh', Aliases=['AL022844'], description='cathepsin H', other_designations='pro-cathepsin H|Cat H|cathepsin B3|cathepsin BA', map_location='9 47.4 cM', chromosome='9', genomic_nucleotide_accession_version='NC_000075.6', start_position_on_the_genomic_accession=90054267, end_position_on_the_genomic_accession=90076095, orientation='plus', exon_count=13, OMIM=[], no_hdr0=''),
    13038 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=13038, CurrentID=0, Status='live', Symbol='Ctsk', Aliases=['AI323530', 'MMS10-Q', 'Ms10q', 'cat', 'catK'], description='cathepsin K', other_designations='cathepsin K|Cat K', map_location='3 40.74 cM', chromosome='3', genomic_nucleotide_accession_version='NC_000069.6', start_position_on_the_genomic_accession=95499210, end_position_on_the_genomic_accession=95509387, orientation='plus', exon_count=9, OMIM=[], no_hdr0=''),
    13039 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=13039, CurrentID=0, Status='live', Symbol='Ctsl', Aliases=['1190035F06Rik', 'CatL1', 'ME', 'MEP', 'fs', 'nkt', 'Ctsl'], description='cathepsin L', other_designations='cathepsin L1|Cat L|major excreted protein|p39 cysteine proteinase', map_location='13 33.26 cM', chromosome='13', genomic_nucleotide_accession_version='NC_000079.6', start_position_on_the_genomic_accession=64361890, end_position_on_the_genomic_accession=64370772, orientation='minus', exon_count=9, OMIM=[], no_hdr0=''),
    13040 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=13040, CurrentID=0, Status='live', Symbol='Ctss', Aliases=['Cats'], description='cathepsin S', other_designations='cathepsin S|Cat S', map_location='3 40.74 cM', chromosome='3', genomic_nucleotide_accession_version='NC_000069.6', start_position_on_the_genomic_accession=95526786, end_position_on_the_genomic_accession=95556405, orientation='plus', exon_count=9, OMIM=[], no_hdr0=''),
    13041 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=13041, CurrentID=0, Status='live', Symbol='Ctsw', Aliases=['lym', 'lymphopain'], description='cathepsin W', other_designations='cathepsin W', map_location='19 A', chromosome='19', genomic_nucleotide_accession_version='NC_000085.6', start_position_on_the_genomic_accession=5465043, end_position_on_the_genomic_accession=5468628, orientation='minus', exon_count=10, OMIM=[], no_hdr0=''),
    13043 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=13043, CurrentID=0, Status='live', Symbol='Cttn', Aliases=['1110020L01Rik', 'Ems', 'Ems1'], description='cortactin', other_designations='src substrate cortactin|mammary tumor and squamous cell carcinoma associated (p80/85 src substrate)', map_location='7 F5', chromosome='7', genomic_nucleotide_accession_version='NC_000073.6', start_position_on_the_genomic_accession=144435724, end_position_on_the_genomic_accession=144471560, orientation='minus', exon_count=18, OMIM=[], no_hdr0=''),
    13046 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=13046, CurrentID=0, Status='live', Symbol='Celf1', Aliases=['1600010O03Rik', 'AA407467', 'Bru', 'Brunol2', 'CUG-B', 'CUG-BP', 'CUG-BP1', 'CUGBP', 'Cugbp1', 'D2Wsu101', 'D2Wsu101e', 'HNAB50', 'NAB50'], description='CUGBP, Elav-like family member 1', other_designations='CUGBP Elav-like family member 1|50 kDa nuclear polyadenylated RNA-binding protein|CELF-1|CUG triplet repeat RNA-binding protein 1|CUG-BP- and ETR-3-like factor 1|EDEN-BP homolog|RNA-binding protein BRUNOL-2|brain protein F41|bruno-like protein 2|deadenylation factor CUG-BP|deadenylation factor EDEN-BP|embryo deadenylation element-binding protein homolog', map_location='2 50.44 cM', chromosome='2', genomic_nucleotide_accession_version='NC_000068.7', start_position_on_the_genomic_accession=90940259, end_position_on_the_genomic_accession=91019497, orientation='plus', exon_count=16, OMIM=[], no_hdr0=''),
    13047 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=13047, CurrentID=0, Status='live', Symbol='Cux1', Aliases=['CD', 'CDP', 'Cutl', 'Cutl1', 'Cux', 'Cux-1'], description='cut-like homeobox 1', other_designations='protein CASP|CCAAT displacement protein|Cux/CDP homeoprotein|cut-like 1|homeobox protein cut-like 1|homeobox protein cux-1', map_location='5 75.96 cM', chromosome='5', genomic_nucleotide_accession_version='NC_000071.6', start_position_on_the_genomic_accession=136248135, end_position_on_the_genomic_accession=136567590, orientation='minus', exon_count=34, OMIM=[], no_hdr0=''),
    13048 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=13048, CurrentID=0, Status='live', Symbol='Cux2', Aliases=['1700051K22Rik', 'Cutl', 'Cutl2', 'Cux-2'], description='cut-like homeobox 2', other_designations='homeobox protein cut-like 2|homeobox protein Cux-2', map_location='5 62.02 cM', chromosome='5', genomic_nucleotide_accession_version='NC_000071.6', start_position_on_the_genomic_accession=121857962, end_position_on_the_genomic_accession=122050415, orientation='minus', exon_count=30, OMIM=[], no_hdr0=''),
    13051 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=13051, CurrentID=0, Status='live', Symbol='Cx3cr1', Aliases=[], description='chemokine (C-X3-C motif) receptor 1', other_designations='CX3C chemokine receptor 1|C-X3-C CKR-1|chemokine (C-X3-C) receptor 1|fractalkine receptor', map_location='9 F4', chromosome='9', genomic_nucleotide_accession_version='NC_000075.6', start_position_on_the_genomic_accession=120048683, end_position_on_the_genomic_accession=120068296, orientation='minus', exon_count=2, OMIM=[], no_hdr0=''),
    13052 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=13052, CurrentID=0, Status='live', Symbol='Cxadr', Aliases=['2610206D03Rik', 'AU016810', 'AW553441', 'C', 'CAR', 'MC', 'MCAR', 'MCV', 'MCVADR'], description='coxsackie virus and adenovirus receptor', other_designations='coxsackievirus and adenovirus receptor homolog', map_location='16 C3.1', chromosome='16', genomic_nucleotide_accession_version='NC_000082.6', start_position_on_the_genomic_accession=78301226, end_position_on_the_genomic_accession=78359785, orientation='plus', exon_count=11, OMIM=[], no_hdr0=''),
    13056 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=13056, CurrentID=0, Status='live', Symbol='Cyb561', Aliases=[], description='cytochrome b-561', other_designations='cytochrome b561', map_location='11 68.81 cM', chromosome='11', genomic_nucleotide_accession_version='NC_000077.6', start_position_on_the_genomic_accession=105933702, end_position_on_the_genomic_accession=105945019, orientation='minus', exon_count=10, OMIM=[], no_hdr0=''),
    13057 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=13057, CurrentID=0, Status='live', Symbol='Cyba', Aliases=['b558', 'nmf333', 'p22-phox', 'p22phox'], description='cytochrome b-245, alpha polypeptide', other_designations='cytochrome b-245 light chain|cytochrome b(558) alpha chain|cytochrome b558 subunit alpha|cytochrome beta-558|neutrophil cytochrome b 22 kDa polypeptide|p22 phagocyte B-cytochrome|p22 phox|superoxide-generating NADPH oxidase light chain subunit', map_location='8 E1', chromosome='8', genomic_nucleotide_accession_version='NC_000074.6', start_position_on_the_genomic_accession=122424771, end_position_on_the_genomic_accession=122432940, orientation='minus', exon_count=6, OMIM=[], no_hdr0=''),
    13058 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=13058, CurrentID=0, Status='live', Symbol='Cybb', Aliases=['C88302', 'CGD91-phox', 'Cgd', 'Cyd', 'No', 'Nox2', 'gp91-1', 'gp91<ph', 'gp91p', 'gp91phox'], description='cytochrome b-245, beta polypeptide', other_designations='cytochrome b-245 heavy chain|NADPH oxidase 2|cytochrome b558 subunit beta|heme-binding membrane glycoprotein gp91phox|neutrophil cytochrome b 91 kDa polypeptide|p22 phagocyte B-cytochrome', map_location='X A1.1', chromosome='X', genomic_nucleotide_accession_version='NC_000086.7', start_position_on_the_genomic_accession=9435252, end_position_on_the_genomic_accession=9487766, orientation='minus', exon_count=14, OMIM=[], no_hdr0=''),
    13063 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=13063, CurrentID=0, Status='live', Symbol='Cycs', Aliases=[], description='cytochrome c, somatic', other_designations='cytochrome c, somatic', map_location='6 24.32 cM', chromosome='6', genomic_nucleotide_accession_version='NC_000072.6', start_position_on_the_genomic_accession=50562563, end_position_on_the_genomic_accession=50566569, orientation='minus', exon_count=3, OMIM=[], no_hdr0=''),
    13067 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=13067, CurrentID=0, Status='live', Symbol='Cyct', Aliases=['T-Cc'], description='cytochrome c, testis', other_designations='cytochrome c, testis-specific', map_location='2 44.94 cM', chromosome='2', genomic_nucleotide_accession_version='NC_000068.7', start_position_on_the_genomic_accession=76353942, end_position_on_the_genomic_accession=76360453, orientation='minus', exon_count=5, OMIM=[], no_hdr0=''),
    13070 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=13070, CurrentID=0, Status='live', Symbol='Cyp11a1', Aliases=['Cyp1', 'Cyp11a', 'Cypxia1', 'D9Ertd411', 'D9Ertd411e', 'P450s', 'P450scc', 'Sc', 'Scc', 'csc', 'cscc'], description='cytochrome P450, family 11, subfamily a, polypeptide 1', other_designations='cholesterol side-chain cleavage enzyme, mitochondrial|cholesterol desmolase|cytochrome P450 11A1|cytochrome P450 side-chain cleavage enzyme|cytochrome P450(scc)|cytochrome P450, 11a, cholesterol side-chain cleavage', map_location='9 31.63 cM', chromosome='9', genomic_nucleotide_accession_version='NC_000075.6', start_position_on_the_genomic_accession=57998024, end_position_on_the_genomic_accession=58027031, orientation='plus', exon_count=11, OMIM=[], no_hdr0=''),
    13072 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=13072, CurrentID=0, Status='live', Symbol='Cyp11b2', Aliases=['ALDOS', 'Cpn2', 'Cyp11', 'Cyp11b', 'Cyp11b-', 'Cyp11b-2'], description='cytochrome P450, family 11, subfamily b, polypeptide 2', other_designations='cytochrome P450 11B2, mitochondrial|aldosterone synthase|aldosterone-synthesizing enzyme|corticosterone 18-monooxygenase, CYP11B2|cytochrome P-450Aldo|cytochrome P-450C18|cytochrome P450C11|steroid 11-beta-hydroxylase, CYP11B2|steroid 18-hydroxylase|steroid-11-beta-hydroxylase', map_location='15 34.29 cM', chromosome='15', genomic_nucleotide_accession_version='NC_000081.6', start_position_on_the_genomic_accession=74850618, end_position_on_the_genomic_accession=74856231, orientation='minus', exon_count=9, OMIM=[], no_hdr0=''),
    13074 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=13074, CurrentID=0, Status='live', Symbol='Cyp17a1', Aliases=['Cyp1', 'Cyp17', 'p450c1', 'p450c17'], description='cytochrome P450, family 17, subfamily a, polypeptide 1', other_designations='steroid 17-alpha-hydroxylase/17,20 lyase|17-alpha-hydroxyprogesterone aldolase|CYPXVII|cytochrome P450 17A1|cytochrome P450, 17|cytochrome P450, 17a1|cytochrome P450-C17|cytochrome P450c17|steroid 17-alpha hydroxylase|steroid 17-alpha-monooxygenase', map_location='19 38.97 cM', chromosome='19', genomic_nucleotide_accession_version='NC_000085.6', start_position_on_the_genomic_accession=46667165, end_position_on_the_genomic_accession=46673000, orientation='minus', exon_count=8, OMIM=[], no_hdr0=''),
    13075 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=13075, CurrentID=0, Status='live', Symbol='Cyp19a1', Aliases=['A', 'Ar', 'ArKO', 'Cyp1', 'Cyp19', 'In', 'Int', 'Int-5', 'Int5', 'aro', 'p450', 'p450arom'], description='cytochrome P450, family 19, subfamily a, polypeptide 1', other_designations='aromatase|CYPXIX|cytochrome P-450AROM|cytochrome P450 19A1|cytochrome P450, 19, aromatase|estrogen synthase', map_location='9 29.49 cM', chromosome='9', genomic_nucleotide_accession_version='NC_000075.6', start_position_on_the_genomic_accession=54165937, end_position_on_the_genomic_accession=54268164, orientation='minus', exon_count=12, OMIM=[], no_hdr0=''),
    13076 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=13076, CurrentID=0, Status='live', Symbol='Cyp1a1', Aliases=['AHH', 'AHRR', 'CP11', 'CYPIA1', 'P450-', 'P450-1'], description='cytochrome P450, family 1, subfamily a, polypeptide 1', other_designations='cytochrome P450 1A1|cytochrome P450 form 6|cytochrome P450 subfamily I, polypeptide 1|cytochrome P450, 1a1, aromatic compound inducible|cytochrome P450-C|cytochrome P450-P1|hydroperoxy icosatetraenoate dehydratase', map_location='9 31.34 cM', chromosome='9', genomic_nucleotide_accession_version='NC_000075.6', start_position_on_the_genomic_accession=57687928, end_position_on_the_genomic_accession=57703824, orientation='plus', exon_count=8, OMIM=[], no_hdr0=''),
    13077 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=13077, CurrentID=0, Status='live', Symbol='Cyp1a2', Aliases=['CP1', 'CP12', 'CYPIA2', 'P450-', 'P450-3'], description='cytochrome P450, family 1, subfamily a, polypeptide 2', other_designations='cytochrome P450 1A2|cholesterol 25-hydroxylase|cytochrome P450 family 1 subfamily a polypeptide 1|cytochrome P450, 1a2, aromatic compound inducible|cytochrome P450-P2|cytochrome P450-P3|hydroperoxy icosatetraenoate dehydratase', map_location='9 31.3 cM', chromosome='9', genomic_nucleotide_accession_version='NC_000075.6', start_position_on_the_genomic_accession=57676937, end_position_on_the_genomic_accession=57683655, orientation='minus', exon_count=7, OMIM=[], no_hdr0=''),
    13078 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=13078, CurrentID=0, Status='live', Symbol='Cyp1b1', Aliases=['CP1B', 'CYPIB1', 'P4501b1'], description='cytochrome P450, family 1, subfamily b, polypeptide 1', other_designations='cytochrome P450 1B1|cytochrome P450, 1b1, benz[a]anthracene inducible|cytochrome P450CMEF|cytochrome P450EF|hydroperoxy icosatetraenoate dehydratase', map_location='17 E3', chromosome='17', genomic_nucleotide_accession_version='NC_000083.6', start_position_on_the_genomic_accession=79706940, end_position_on_the_genomic_accession=79715061, orientation='minus', exon_count=3, OMIM=[], no_hdr0=''),
    13079 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=13079, CurrentID=0, Status='live', Symbol='Cyp21a1', Aliases=['21-O', '21-OH', '21O', '21OH', '21OHA', '21OHB', 'CYP21OH-A', 'Cyp2', 'Cyp21', 'Cyp21-ps1', 'Cyp21B', 'Cyp21a2-ps', 'Cyp21a2ps', 'Oh21-', 'Oh21-1', 'Oh21-2'], description='cytochrome P450, family 21, subfamily a, polypeptide 1', other_designations='steroid 21-hydroxylase|21-OHase|21-hydroxylase|cytochrome P-450|cytochrome P-450c21|cytochrome P450 21|cytochrome P450 XXI|cytochrome P450 hydroxylase A|cytochrome P450, 21, pseudogene|cytochrome P450, 21, steroid 21 hydroxylase|cytochrome P450, family 21, subfamily a, polypeptide 2, pseudogene|cytochrome P450-C21', map_location='17 18.36 cM', chromosome='17', genomic_nucleotide_accession_version='NC_000083.6', start_position_on_the_genomic_accession=34801348, end_position_on_the_genomic_accession=34804426, orientation='minus', exon_count=10, OMIM=[], no_hdr0=''),
    13081 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=13081, CurrentID=0, Status='live', Symbol='Cyp24a1', Aliases=['24-OH', '24-OHase', 'CP2', 'CP24', 'Cyp2', 'Cyp24'], description='cytochrome P450, family 24, subfamily a, polypeptide 1', other_designations='1,25-dihydroxyvitamin D(3) 24-hydroxylase, mitochondrial|25-hydroxyvitamin D-24-hydroxylase|cytochrome P450 24A1|cytochrome P450, 24|cytochrome P450, 24a1|cytochrome P450-CC24|vitamin D(3) 24-hydroxylase', map_location='2 91.91 cM', chromosome='2', genomic_nucleotide_accession_version='NC_000068.7', start_position_on_the_genomic_accession=170482957, end_position_on_the_genomic_accession=170497145, orientation='minus', exon_count=12, OMIM=[], no_hdr0=''),
    13082 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=13082, CurrentID=0, Status='live', Symbol='Cyp26a1', Aliases=['Cyp2', 'Cyp26', 'P45', 'P450RA', 'P450RAI', 'R', 'RAH'], description='cytochrome P450, family 26, subfamily a, polypeptide 1', other_designations='cytochrome P450 26A1|cytochrome P450, 26, retinoic acid A1|cytochrome P450RAI|retinoic acid 4-hydroxylase|retinoic acid hydrolase|retinoic acid-metabolizing cytochrome', map_location='19 C2', chromosome='19', genomic_nucleotide_accession_version='NC_000085.6', start_position_on_the_genomic_accession=37697738, end_position_on_the_genomic_accession=37701536, orientation='plus', exon_count=7, OMIM=[], no_hdr0=''),
    13085 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=13085, CurrentID=0, Status='live', Symbol='Cyp2a12', Aliases=[], description='cytochrome P450, family 2, subfamily a, polypeptide 12', other_designations='cytochrome P450 2A12|CYPIIA12|cytochrome P450, 2a12|steroid hormones 7-alpha-hydroxylase|testosterone 7-alpha-hydroxylase', map_location='7 A3', chromosome='7', genomic_nucleotide_accession_version='NC_000073.6', start_position_on_the_genomic_accession=27029090, end_position_on_the_genomic_accession=27036818, orientation='plus', exon_count=9, OMIM=[], no_hdr0=''),
    13086 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=13086, CurrentID=0, Status='live', Symbol='Cyp2a4', Aliases=['AI893559', 'Cyp15', 'Cyp15a1', 'D7Ucl', 'D7Ucla4'], description='cytochrome P450, family 2, subfamily a, polypeptide 4', other_designations='cytochrome P450 2A4|CYPIIA4|cytochrome P450, 2a4|cytochrome P450-15-alpha|cytochrome P450-IIA3.1|testosterone 15-alpha-hydroxylase|testosterone 15alpha-hydroxylase', map_location='7 14.39 cM', chromosome='7', genomic_nucleotide_accession_version='NC_000073.6', start_position_on_the_genomic_accession=26307192, end_position_on_the_genomic_accession=26315088, orientation='plus', exon_count=9, OMIM=[], no_hdr0=''),
    13087 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=13087, CurrentID=0, Status='live', Symbol='Cyp2a5', Aliases=['CYPIIA5', 'Co', 'Coh', 'Cyp15a2'], description='cytochrome P450, family 2, subfamily a, polypeptide 5', other_designations='cytochrome P450 2A5|coumarin 7-hydroxylase|cytochrome P450, 2a5|cytochrome P450-15-COH|cytochrome P450-IIA3.2', map_location='7 15.54 cM', chromosome='7', genomic_nucleotide_accession_version='NC_000073.6', start_position_on_the_genomic_accession=26835339, end_position_on_the_genomic_accession=26843264, orientation='plus', exon_count=9, OMIM=[], no_hdr0=''),
    13088 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=13088, CurrentID=0, Status='live', Symbol='Cyp2b10', Aliases=['Cyp2', 'Cyp2b', 'Cyp2b2', 'Cyp2b20', 'p1', 'p16'], description='cytochrome P450, family 2, subfamily b, polypeptide 10', other_designations='cytochrome P450 2B10|CYPIIB10|CYPIIB20|P24|cytochrome P450 2B20|cytochrome P450 clone PF3/46|cytochrome P450, 2b10, phenobarbitol inducible, type b|cytochrome P450, 2b20|cytochrome P450, family 2, subfamily b, polypeptide 20|cytochrome P450-16-alpha|phenobarbitol inducible, type b|testosterone 16-alpha hydroxylase', map_location='7 14.11 cM', chromosome='7', genomic_nucleotide_accession_version='NC_000073.6', start_position_on_the_genomic_accession=25897658, end_position_on_the_genomic_accession=25926624, orientation='plus', exon_count=9, OMIM=[], no_hdr0=''),
    13089 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=13089, CurrentID=0, Status='live', Symbol='Cyp2b13', Aliases=[], description='cytochrome P450, family 2, subfamily b, polypeptide 13', other_designations='cytochrome P450, family 2, subfamily b, polypeptide 13|cytochrome P450, 2b13, phenobarbitol inducible, type c|phenobarbital inducible, type c', map_location='7 14.11 cM', chromosome='7', genomic_nucleotide_accession_version='NC_000073.6', start_position_on_the_genomic_accession=26061388, end_position_on_the_genomic_accession=26096197, orientation='plus', exon_count=12, OMIM=[], no_hdr0=''),
    13090 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=13090, CurrentID=0, Status='live', Symbol='Cyp2b19', Aliases=['CYPIIB19'], description='cytochrome P450, family 2, subfamily b, polypeptide 19', other_designations='cytochrome P450 2B19|cytochrome P450, 2b19', map_location='7 15.44 cM', chromosome='7', genomic_nucleotide_accession_version='NC_000073.6', start_position_on_the_genomic_accession=26757142, end_position_on_the_genomic_accession=26772630, orientation='plus', exon_count=9, OMIM=[], no_hdr0=''),
    13094 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=13094, CurrentID=0, Status='live', Symbol='Cyp2b9', Aliases=['Cyp2', 'Cyp2b'], description='cytochrome P450, family 2, subfamily b, polypeptide 9', other_designations='cytochrome P450 2B9|16alphaoh-a|CYPIIB9|cytochrome P450 clone PF26|cytochrome P450, 2b9, phenobarbitol inducible, type a|cytochrome P450-16-alpha|phenobarbitol inducible, type a|testosterone 16-alpha hydroxylase', map_location='7 14.11 cM', chromosome='7', genomic_nucleotide_accession_version='NC_000073.6', start_position_on_the_genomic_accession=26173350, end_position_on_the_genomic_accession=26210661, orientation='plus', exon_count=11, OMIM=[], no_hdr0=''),
    13095 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=13095, CurrentID=0, Status='live', Symbol='Cyp2c29', Aliases=['AH', 'AHO', 'AHOH', 'AHOHase', 'AI159681', 'AI196010', 'Ah-', 'Ah-2', 'Ahh-', 'Ahh-1', 'Cyp2', 'Cyp2c', 'P450-2', 'P450-2C'], description='cytochrome P450, family 2, subfamily c, polypeptide 29', other_designations='cytochrome P450 2C29|CYPIIC29|aldehyde oxygenase|cytochrome P-450 MUT-2|cytochrome P450, 2c29', map_location='19 33.91 cM', chromosome='19', genomic_nucleotide_accession_version='NC_000085.6', start_position_on_the_genomic_accession=39287044, end_position_on_the_genomic_accession=39330713, orientation='plus', exon_count=9, OMIM=[], no_hdr0=''),
    13096 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=13096, CurrentID=0, Status='live', Symbol='Cyp2c37', Aliases=[], description='cytochrome P450, family 2. subfamily c, polypeptide 37', other_designations='cytochrome P450 2C37|CYPIIC37|cytochrome P450, 2c37', map_location='19 C3', chromosome='19', genomic_nucleotide_accession_version='NC_000085.6', start_position_on_the_genomic_accession=39992424, end_position_on_the_genomic_accession=40012243, orientation='plus', exon_count=9, OMIM=[], no_hdr0=''),
    13097 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=13097, CurrentID=0, Status='live', Symbol='Cyp2c38', Aliases=[], description='cytochrome P450, family 2, subfamily c, polypeptide 38', other_designations='cytochrome P450 2C38|CYPIIC38|cytochrome P450, 2c38', map_location='19 C3', chromosome='19', genomic_nucleotide_accession_version='NC_000085.6', start_position_on_the_genomic_accession=39389556, end_position_on_the_genomic_accession=39463103, orientation='minus', exon_count=9, OMIM=[], no_hdr0=''),
    13098 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=13098, CurrentID=0, Status='live', Symbol='Cyp2c39', Aliases=['CYPIIC39'], description='cytochrome P450, family 2, subfamily c, polypeptide 39', other_designations='cytochrome P450 2C39|cytochrome P450, 2c39', map_location='19 C3', chromosome='19', genomic_nucleotide_accession_version='NC_000085.6', start_position_on_the_genomic_accession=39347346, end_position_on_the_genomic_accession=39569568, orientation='plus', exon_count=10, OMIM=[], no_hdr0=''),
    13099 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=13099, CurrentID=0, Status='live', Symbol='Cyp2c40', Aliases=['AI265721', 'AI662255'], description='cytochrome P450, family 2, subfamily c, polypeptide 40', other_designations='cytochrome P450 2C40|CYPIIC40|cytochrome P450, 2c40', map_location='19 C3', chromosome='19', genomic_nucleotide_accession_version='NC_000085.6', start_position_on_the_genomic_accession=39767073, end_position_on_the_genomic_accession=39812814, orientation='minus', exon_count=9, OMIM=[], no_hdr0=''),
    13101 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=13101, CurrentID=0, Status='live', Symbol='Cyp2d10', Aliases=['AI303445', 'Cyp2', 'Cyp2d', 'P450-2', 'P450-2D'], description='cytochrome P450, family 2, subfamily d, polypeptide 10', other_designations='cytochrome P450 2D10|CYPIID10|cytochrome P450, 2d10|cytochrome P450-16-alpha|cytochrome P450CB|testosterone 16-alpha hydroxylase', map_location='15 38.58 cM', chromosome='15', genomic_nucleotide_accession_version='NC_000081.6', start_position_on_the_genomic_accession=82402845, end_position_on_the_genomic_accession=82407253, orientation='minus', exon_count=9, OMIM=[], no_hdr0=''),
    13105 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=13105, CurrentID=0, Status='live', Symbol='Cyp2d9', Aliases=['Cyp2', 'Cyp2d', 'P450-2', 'P450-2D'], description='cytochrome P450, family 2, subfamily d, polypeptide 9', other_designations='cytochrome P450 2D9|CYPIID9|cytochrome P450, 2d9|cytochrome P450-16-alpha|cytochrome P450CA|testosterone 16-alpha hydroxylase|testosterone 16alpha-hydroxylase', map_location='15 38.6 cM', chromosome='15', genomic_nucleotide_accession_version='NC_000081.6', start_position_on_the_genomic_accession=82452377, end_position_on_the_genomic_accession=82456827, orientation='plus', exon_count=9, OMIM=[], no_hdr0=''),
    13106 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=13106, CurrentID=0, Status='live', Symbol='Cyp2e1', Aliases=['CYPIIE1', 'Cyp2', 'Cyp2e'], description='cytochrome P450, family 2, subfamily e, polypeptide 1', other_designations='cytochrome P450 2E1|4-nitrophenol 2-hydroxylase|cytochrome P450, 2e1, ethanol inducible|cytochrome P450-ALC|cytochrome P450-J', map_location='7 85.94 cM', chromosome='7', genomic_nucleotide_accession_version='NC_000073.6', start_position_on_the_genomic_accession=140763819, end_position_on_the_genomic_accession=140774990, orientation='plus', exon_count=9, OMIM=[], no_hdr0=''),
    13107 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=13107, CurrentID=0, Status='live', Symbol='Cyp2f2', Aliases=['Cyp2', 'Cyp2f'], description='cytochrome P450, family 2, subfamily f, polypeptide 2', other_designations='cytochrome P450 2F2|CYPIIF2|cytochrome P450, 2f2|cytochrome P450-NAH-2|naphthalene dehydrogenase|naphthalene hydroxylase', map_location='7 A3', chromosome='7', genomic_nucleotide_accession_version='NC_000073.6', start_position_on_the_genomic_accession=27119955, end_position_on_the_genomic_accession=27133660, orientation='plus', exon_count=10, OMIM=[], no_hdr0=''),
    13108 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=13108, CurrentID=0, Status='live', Symbol='Cyp2g1', Aliases=[], description='cytochrome P450, family 2, subfamily g, polypeptide 1', other_designations='cytochrome P450, family 2, subfamily g, polypeptide 1|cytochrome P450, 2g1', map_location='7 A3', chromosome='7', genomic_nucleotide_accession_version='NC_000073.6', start_position_on_the_genomic_accession=26808927, end_position_on_the_genomic_accession=26821197, orientation='plus', exon_count=9, OMIM=[], no_hdr0=''),
    13109 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=13109, CurrentID=0, Status='live', Symbol='Cyp2j5', Aliases=[], description='cytochrome P450, family 2, subfamily j, polypeptide 5', other_designations='cytochrome P450 2J5|CYPIIJ5|arachidonic acid epoxygenase|cytochrome P450, 2j5', map_location='4 44.71 cM', chromosome='4', genomic_nucleotide_accession_version='NC_000070.6', start_position_on_the_genomic_accession=96627432, end_position_on_the_genomic_accession=96664171, orientation='minus', exon_count=9, OMIM=[], no_hdr0=''),
    13110 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=13110, CurrentID=0, Status='live', Symbol='Cyp2j6', Aliases=[], description='cytochrome P450, family 2, subfamily j, polypeptide 6', other_designations='cytochrome P450 2J6|CYPIIJ6|arachidonic acid epoxygenase|cytochrome P450, 2j6', map_location='4 44.62 cM', chromosome='4', genomic_nucleotide_accession_version='NC_000070.6', start_position_on_the_genomic_accession=96516138, end_position_on_the_genomic_accession=96564305, orientation='minus', exon_count=12, OMIM=[], no_hdr0=''),
    13112 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=13112, CurrentID=0, Status='live', Symbol='Cyp3a11', Aliases=['AI256190', 'Cyp', 'Cyp3a', 'II', 'IIIAm1', 'P', 'Pcn'], description='cytochrome P450, family 3, subfamily a, polypeptide 11', other_designations='cytochrome P450 3A11|CYPIIIA11|cytochrome P-450IIIAM1|cytochrome P-450UT|cytochrome P450, steroid inducible 3a11|steroid inducible', map_location='5 85.17 cM', chromosome='5', genomic_nucleotide_accession_version='NC_000071.6', start_position_on_the_genomic_accession=145854607, end_position_on_the_genomic_accession=145879854, orientation='minus', exon_count=13, OMIM=[], no_hdr0=''),
    13113 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=13113, CurrentID=0, Status='live', Symbol='Cyp3a13', Aliases=['II', 'IIIAm2'], description='cytochrome P450, family 3, subfamily a, polypeptide 13', other_designations='cytochrome P450 3A13|CYPIIIA13|cytochrome P450, steroid inducible 3a13', map_location='5 76.89 cM', chromosome='5', genomic_nucleotide_accession_version='NC_000071.6', start_position_on_the_genomic_accession=137892933, end_position_on_the_genomic_accession=137925610, orientation='minus', exon_count=14, OMIM=[], no_hdr0=''),
    13114 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=13114, CurrentID=0, Status='live', Symbol='Cyp3a16', Aliases=[], description='cytochrome P450, family 3, subfamily a, polypeptide 16', other_designations='cytochrome P450 3A16|CYPIIIA16|cytochrome P450, 3a16', map_location='5 85.17 cM', chromosome='5', genomic_nucleotide_accession_version='NC_000071.6', start_position_on_the_genomic_accession=145436309, end_position_on_the_genomic_accession=145469740, orientation='minus', exon_count=14, OMIM=[], no_hdr0=''),
    13115 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=13115, CurrentID=0, Status='live', Symbol='Cyp27b1', Aliases=['Cp2', 'Cp2b', 'Cyp', 'Cyp1', 'Cyp27', 'Cyp27b', 'Cyp4', 'Cyp40', 'P450c', 'P450c1', 'Pd', 'Pddr', 'Vd', 'Vdd', 'Vdd1', 'Vddr', 'VddrI', 'Vdr'], description='cytochrome P450, family 27, subfamily b, polypeptide 1', other_designations='25-hydroxyvitamin D-1 alpha hydroxylase, mitochondrial|1alpha(OH)ase|25(OH)D 1alpha-hydroxylase|25-OHD-1 alpha-hydroxylase|25-hydroxyvitamin D(3) 1-alpha-hydroxylase|25-hydroxyvitamin D-1 alpha hydroxylase, mitochondrial precursor (25-OHD-1 alpha-hydroxylase) (25-hydroxyvitamin D3 1-alpha-hydroxylase) (VD3 1A hydroxylase) (P450C1 alpha) (P450VD1-alpha)|25-hydroxyvitamin D3 1alpha-hydroxylase|P450VD1alpha|VD3 1A hydroxylase|calcidiol 1-monooxygenase|cytochrome P450 subfamily XXVIIB polypeptide 1|cytochrome P450, 27b1|cytochrome P450, 40 (25-hydroxyvitamin D3 1 alpha-hydroxylase)|cytochrome P450C1 alpha|cytochrome P450VD1-alpha|cytochrome p450 27B1', map_location='10 D3', chromosome='10', genomic_nucleotide_accession_version='NC_000076.6', start_position_on_the_genomic_accession=127048246, end_position_on_the_genomic_accession=127054884, orientation='plus', exon_count=9, OMIM=[], no_hdr0=''),
    13116 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=13116, CurrentID=0, Status='live', Symbol='Cyp46a1', Aliases=['CH24H', 'Cyp4', 'Cyp46'], description='cytochrome P450, family 46, subfamily a, polypeptide 1', other_designations='cholesterol 24-hydroxylase|cholesterol 24-monooxygenase|cholesterol 24S-hydroxylase|cholestrol 24-hydroxylase|cytochrome P450, 46a1 (cholesterol 24-hydroxylase)', map_location='12 F1', chromosome='12', genomic_nucleotide_accession_version='NC_000078.6', start_position_on_the_genomic_accession=108334268, end_position_on_the_genomic_accession=108362234, orientation='plus', exon_count=16, OMIM=[], no_hdr0=''),
    13117 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=13117, CurrentID=0, Status='live', Symbol='Cyp4a10', Aliases=['AI647584', 'Cyp', 'Cyp4a', 'D4R', 'D4Rp1', 'Msp', 'Msp-3', 'R', 'RP1'], description='cytochrome P450, family 4, subfamily a, polypeptide 10', other_designations='cytochrome P450 4A10|CYPIVA10|cytochrome P450, 4a10|cytochrome P450-LA-omega 1|cytochrome P452|lauric acid omega-hydroxylase|long-chain fatty acid omega-monooxygenase', map_location='4 53.05 cM', chromosome='4', genomic_nucleotide_accession_version='NC_000070.6', start_position_on_the_genomic_accession=115518287, end_position_on_the_genomic_accession=115533649, orientation='plus', exon_count=13, OMIM=[], no_hdr0=''),
    13118 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=13118, CurrentID=0, Status='live', Symbol='Cyp4a12b', Aliases=['BC060945', 'Cyp4a12'], description='cytochrome P450, family 4, subfamily a, polypeptide 12B', other_designations='cytochrome P450 4A12B|cytochrome P450, family 4, subfamily a family|cytochrome P450, family 4, subfamily a, polypeptide 12', map_location='4 D1', chromosome='4', genomic_nucleotide_accession_version='NC_000070.6', start_position_on_the_genomic_accession=115411624, end_position_on_the_genomic_accession=115439034, orientation='plus', exon_count=12, OMIM=[], no_hdr0=''),
    13119 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=13119, CurrentID=0, Status='live', Symbol='Cyp4a14', Aliases=['AI314743'], description='cytochrome P450, family 4, subfamily a, polypeptide 14', other_designations='cytochrome P450 4A14|CYPIVA14|cytochrome P450, 4a14|cytochrome P450-LA-omega 3|lauric acid hydroxylase|lauric acid omega-hydroxylase 3|long-chain fatty acid omega-monooxygenase', map_location='4 53.04 cM', chromosome='4', genomic_nucleotide_accession_version='NC_000070.6', start_position_on_the_genomic_accession=115486200, end_position_on_the_genomic_accession=115496158, orientation='minus', exon_count=13, OMIM=[], no_hdr0=''),
    13120 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=13120, CurrentID=0, Status='live', Symbol='Cyp4b1', Aliases=['CYPIVB1'], description='cytochrome P450, family 4, subfamily b, polypeptide 1', other_designations='cytochrome P450 4B1|cytochrome P450, subfamily IV B, polypeptide 1', map_location='4 53.06 cM', chromosome='4', genomic_nucleotide_accession_version='NC_000070.6', start_position_on_the_genomic_accession=115624698, end_position_on_the_genomic_accession=115647721, orientation='minus', exon_count=12, OMIM=[], no_hdr0=''),
    13121 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=13121, CurrentID=0, Status='live', Symbol='Cyp51', Aliases=['AI426508', 'CYPLIa1', 'Ldm', 'P450-14DM', 'P450LI', 'Cyp51'], description='cytochrome P450, family 51', other_designations='lanosterol 14-alpha demethylase|cytochrome P450 51A1|cytochrome P450, 51|cytochrome P450-14DM|cytochrome P45014DM|cytochrome P450LI|sterol 14-alpha demethylase', map_location='5 2.3 cM', chromosome='5', genomic_nucleotide_accession_version='NC_000071.6', start_position_on_the_genomic_accession=4080674, end_position_on_the_genomic_accession=4104697, orientation='minus', exon_count=10, OMIM=[], no_hdr0=''),
    13122 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=13122, CurrentID=0, Status='live', Symbol='Cyp7a1', Aliases=['CYPVII', 'CYPVIIc'], description='cytochrome P450, family 7, subfamily a, polypeptide 1', other_designations='cytochrome P450 7A1|24-hydroxycholesterol 7-alpha-hydroxylase|cholesterol 7-alpha-hydroxylase|cholesterol 7-alpha-monooxygenase|cytochrome P450, 7a1', map_location='4 A1', chromosome='4', genomic_nucleotide_accession_version='NC_000070.6', start_position_on_the_genomic_accession=6265612, end_position_on_the_genomic_accession=6275632, orientation='minus', exon_count=6, OMIM=[], no_hdr0=''),
    13123 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=13123, CurrentID=0, Status='live', Symbol='Cyp7b1', Aliases=['AW261589', 'D3Ertd552', 'D3Ertd552e', 'hct-1'], description='cytochrome P450, family 7, subfamily b, polypeptide 1', other_designations='cytochrome P450 7B1|24-hydroxycholesterol 7-alpha-hydroxylase|25-hydroxycholesterol 7-alpha-hydroxylase|25/26-hydroxycholesterol 7-alpha-hydroxylase|3-hydroxysteroid 7-alpha hydroxylase|cytochrome P450, 7b1|hippocampal transcript 1 protein|oxysterol 7-alpha-hydroxylase', map_location='3 4.98 cM', chromosome='3', genomic_nucleotide_accession_version='NC_000069.6', start_position_on_the_genomic_accession=18071944, end_position_on_the_genomic_accession=18243890, orientation='minus', exon_count=7, OMIM=[], no_hdr0=''),
    13124 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=13124, CurrentID=0, Status='live', Symbol='Cyp8b1', Aliases=[], description='cytochrome P450, family 8, subfamily b, polypeptide 1', other_designations='7-alpha-hydroxycholest-4-en-3-one 12-alpha-hydroxylase|7-alpha-hydroxy-4-cholesten-3-one 12-alpha-hydroxylase|CYPVIIIB1|cytochrome P450 8B1|cytochrome P450, 8b1, sterol 12 alpha-hydrolase|sterol 12-alpha-hydrolase|sterol 12-alpha-hydroxylase', map_location='9 F4', chromosome='9', genomic_nucleotide_accession_version='NC_000075.6', start_position_on_the_genomic_accession=121914356, end_position_on_the_genomic_accession=121916305, orientation='minus', exon_count=1, OMIM=[], no_hdr0=''),
    13131 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=13131, CurrentID=0, Status='live', Symbol='Dab1', Aliases=['AI956902', 'C630028C02Rik', 'scm', 'scr', 'scrambler', 'yot'], description='disabled 1', other_designations='disabled homolog 1|yotari', map_location='4 47.79 cM', chromosome='4', genomic_nucleotide_accession_version='NC_000070.6', start_position_on_the_genomic_accession=103619500, end_position_on_the_genomic_accession=104744844, orientation='plus', exon_count=29, OMIM=[], no_hdr0=''),
    13132 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=13132, CurrentID=0, Status='live', Symbol='Dab2', Aliases=['5730435J12Rik', 'AA960054', 'AI957090', 'D15Wsu122', 'D15Wsu122e', 'D630005B22Rik', 'Doc-2', 'Doc2', 'p9', 'p96'], description='disabled 2, mitogen-responsive phosphoprotein', other_designations='disabled homolog 2|adaptor molecule disabled-2|differentially expressed in ovarian carcinoma 2|mitogen-responsive phosphoprotein', map_location='15 2.15 cM', chromosome='15', genomic_nucleotide_accession_version='NC_000081.6', start_position_on_the_genomic_accession=6299788, end_position_on_the_genomic_accession=6440715, orientation='plus', exon_count=18, OMIM=[], no_hdr0=''),
    13134 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=13134, CurrentID=0, Status='live', Symbol='Dach1', Aliases=['Da', 'Dac', 'Dach'], description='dachshund family transcription factor 1', other_designations='dachshund homolog 1|dachshund 1', map_location='14 48.25 cM', chromosome='14', genomic_nucleotide_accession_version='NC_000080.6', start_position_on_the_genomic_accession=97786846, end_position_on_the_genomic_accession=98169765, orientation='minus', exon_count=12, OMIM=[], no_hdr0=''),
    13135 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=13135, CurrentID=0, Status='live', Symbol='Dad1', Aliases=['AI323713'], description='defender against cell death 1', other_designations='dolichyl-diphosphooligosaccharide--protein glycosyltransferase subunit DAD1|DAD-1|oligosaccharyl transferase subunit DAD1', map_location='14 27.7 cM', chromosome='14', genomic_nucleotide_accession_version='NC_000080.6', start_position_on_the_genomic_accession=54235485, end_position_on_the_genomic_accession=54253929, orientation='minus', exon_count=3, OMIM=[], no_hdr0=''),
    13136 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=13136, CurrentID=0, Status='live', Symbol='Cd55', Aliases=['Daf', 'Daf-', 'Daf-GPI', 'Daf1', 'GPI-', 'GPI-DAF'], description='CD55 molecule, decay accelerating factor for complement', other_designations='complement decay-accelerating factor, GPI-anchored|CD55 antigen|Cromer blood group|GPI anchor addition signal|complement-glycosylphosphatidylinositol|decay accelerating factor 1', map_location='1 56.89 cM', chromosome='1', genomic_nucleotide_accession_version='NC_000067.6', start_position_on_the_genomic_accession=130429798, end_position_on_the_genomic_accession=130465009, orientation='minus', exon_count=13, OMIM=[], no_hdr0=''),
    13137 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=13137, CurrentID=0, Status='live', Symbol='Cd55b', Aliases=['AI323748', 'Daf', 'Daf-T', 'Daf-TM', 'Daf2', 'TM-DA', 'TM-DAF'], description='CD55 molecule, decay accelerating factor for complement B', other_designations='complement decay-accelerating factor transmembrane isoform|complement-transmembrane|decay accelerating factor 2', map_location='1 56.89 cM', chromosome='1', genomic_nucleotide_accession_version='NC_000067.6', start_position_on_the_genomic_accession=130388526, end_position_on_the_genomic_accession=130423097, orientation='minus', exon_count=13, OMIM=[], no_hdr0=''),
    13138 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=13138, CurrentID=0, Status='live', Symbol='Dag1', Aliases=['D9Wsu13', 'D9Wsu13e', 'DG', 'Dp427', 'Dp71'], description='dystroglycan 1', other_designations='dystroglycan|dystrophin associated glycoprotein 1', map_location='9 59.08 cM', chromosome='9', genomic_nucleotide_accession_version='NC_000075.6', start_position_on_the_genomic_accession=108204861, end_position_on_the_genomic_accession=108263977, orientation='minus', exon_count=5, OMIM=[], no_hdr0=''),
    13139 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=13139, CurrentID=0, Status='live', Symbol='Dgka', Aliases=['80kDa', 'AW146112', 'Dagk', 'Dagk1'], description='diacylglycerol kinase, alpha', other_designations='diacylglycerol kinase alpha|80 kDa diacylglycerol kinase|DAG kinase alpha|DGK-alpha|diacylglycerol kinase alpha Flt2-Pr2|diglyceride kinase alpha|truncated diacylglycerol kinase alpha Flt1-Pr1|truncated diacylglycerol kinase alpha Flt1-Pr2', map_location='10 77.14 cM', chromosome='10', genomic_nucleotide_accession_version='NC_000076.6', start_position_on_the_genomic_accession=128720131, end_position_on_the_genomic_accession=128745084, orientation='minus', exon_count=29, OMIM=[], no_hdr0=''),
    13142 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=13142, CurrentID=0, Status='live', Symbol='Dao', Aliases=['AI987963', 'D', 'DAAO', 'DAMOX', 'Da-1', 'Dao1', 'Dao'], description='D-amino acid oxidase', other_designations='D-amino-acid oxidase|D-amino acid oxidase 1', map_location='5 55.93 cM', chromosome='5', genomic_nucleotide_accession_version='NC_000071.6', start_position_on_the_genomic_accession=113999635, end_position_on_the_genomic_accession=114025675, orientation='plus', exon_count=13, OMIM=[], no_hdr0=''),
    13143 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=13143, CurrentID=0, Status='live', Symbol='Dapk2', Aliases=[], description='death-associated protein kinase 2', other_designations='death-associated protein kinase 2|DAP kinase 2|DRP-1|death-associated kinase 2', map_location='9 35.75 cM', chromosome='9', genomic_nucleotide_accession_version='NC_000075.6', start_position_on_the_genomic_accession=66158226, end_position_on_the_genomic_accession=66272242, orientation='plus', exon_count=12, OMIM=[], no_hdr0=''),
    13144 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=13144, CurrentID=0, Status='live', Symbol='Dapk3', Aliases=['ZIPK', 'dlk'], description='death-associated protein kinase 3', other_designations='death-associated protein kinase 3|DAP kinase 3|DAP-like kinase|MYPT1 kinase|ZIP-kinase|death-associated kinase 3', map_location='10 39.72 cM', chromosome='10', genomic_nucleotide_accession_version='NC_000076.6', start_position_on_the_genomic_accession=81182987, end_position_on_the_genomic_accession=81193197, orientation='plus', exon_count=10, OMIM=[], no_hdr0=''),
    13162 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=13162, CurrentID=0, Status='live', Symbol='Slc6a3', Aliases=['DA', 'DAT', 'Dat1'], description='solute carrier family 6 (neurotransmitter transporter, dopamine), member 3', other_designations='sodium-dependent dopamine transporter|DA transporter|dopamine transporter 1', map_location='13 40.1 cM', chromosome='13', genomic_nucleotide_accession_version='NC_000079.6', start_position_on_the_genomic_accession=73536128, end_position_on_the_genomic_accession=73578672, orientation='plus', exon_count=16, OMIM=[], no_hdr0=''),
    13163 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=13163, CurrentID=0, Status='live', Symbol='Daxx', Aliases=[], description='Fas death domain-associated protein', other_designations='death domain-associated protein 6|death-domain associated protein', map_location='17 17.98 cM', chromosome='17', genomic_nucleotide_accession_version='NC_000083.6', start_position_on_the_genomic_accession=33909404, end_position_on_the_genomic_accession=33915590, orientation='plus', exon_count=9, OMIM=[], no_hdr0=''),
    13164 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=13164, CurrentID=0, Status='live', Symbol='Dazl', Aliases=['Da', 'Daz-l', 'Daz-like', 'Dazh1', 'Dazla', 'Tpx', 'Tpx-', 'Tpx-2', 'Tpx2', 'Dazl'], description='deleted in azoospermia-like', other_designations='deleted in azoospermia-like|DAZ-like autosomal|deleted in azoospermia-like 1', map_location='17 25.86 cM', chromosome='17', genomic_nucleotide_accession_version='NC_000083.6', start_position_on_the_genomic_accession=50279393, end_position_on_the_genomic_accession=50293620, orientation='minus', exon_count=12, OMIM=[], no_hdr0=''),
    13166 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=13166, CurrentID=0, Status='live', Symbol='Dbh', Aliases=[], description='dopamine beta hydroxylase', other_designations='dopamine beta-hydroxylase|dopamine beta-monooxygenase', map_location='2 19.29 cM', chromosome='2', genomic_nucleotide_accession_version='NC_000068.7', start_position_on_the_genomic_accession=27165507, end_position_on_the_genomic_accession=27183204, orientation='plus', exon_count=12, OMIM=[], no_hdr0=''),
    13167 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=13167, CurrentID=0, Status='live', Symbol='Dbi', Aliases=['ACBD1', 'Ac', 'Acbp', 'E', 'EP', 'endoz', 'endozepine'], description='diazepam binding inhibitor', other_designations='acyl-CoA-binding protein|diazepam binding inhibitor, splice form 1b', map_location='1 E2.3', chromosome='1', genomic_nucleotide_accession_version='NC_000067.6', start_position_on_the_genomic_accession=120113280, end_position_on_the_genomic_accession=120121096, orientation='minus', exon_count=5, OMIM=[], no_hdr0=''),
    13168 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=13168, CurrentID=0, Status='live', Symbol='Dbil5', Aliases=['E', 'ELP'], description='diazepam binding inhibitor-like 5', other_designations='diazepam-binding inhibitor-like 5|endozepine-like peptide', map_location='11 B5', chromosome='11', genomic_nucleotide_accession_version='NC_000077.6', start_position_on_the_genomic_accession=76217613, end_position_on_the_genomic_accession=76218665, orientation='plus', exon_count=2, OMIM=[], no_hdr0=''),
    13169 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=13169, CurrentID=0, Status='live', Symbol='Dbnl', Aliases=['AB', 'Abp1', 'SH3', 'SH3P7', 'mAb', 'mAbp1'], description='drebrin-like', other_designations='drebrin-like protein|SH3 domain-containing protein 7|actin-binding protein 1', map_location='11 3.87 cM', chromosome='11', genomic_nucleotide_accession_version='NC_000077.6', start_position_on_the_genomic_accession=5788483, end_position_on_the_genomic_accession=5800980, orientation='plus', exon_count=13, OMIM=[], no_hdr0=''),
    13170 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=13170, CurrentID=0, Status='live', Symbol='Dbp', Aliases=[], description='D site albumin promoter binding protein', other_designations='D site-binding protein|albumin D box-binding protein|albumin D-element-binding protein', map_location='7 29.45 cM', chromosome='7', genomic_nucleotide_accession_version='NC_000073.6', start_position_on_the_genomic_accession=45705100, end_position_on_the_genomic_accession=45710203, orientation='plus', exon_count=4, OMIM=[], no_hdr0=''),
    13171 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=13171, CurrentID=0, Status='live', Symbol='Dbt', Aliases=['BCKAD-E2', 'D3Wsu60', 'D3Wsu60e'], description='dihydrolipoamide branched chain transacylase E2', other_designations='lipoamide acyltransferase component of branched-chain alpha-keto acid dehydrogenase complex, mitochondrial|BCKAD E2|branched-chain alpha-keto acid dehydrogenase complex component E2|branched-chain alpha-ketoacid dehydrogenase, E2 subunit|dihydrolipoamide acetyltransferase component of branched-chain alpha-keto acid dehydrogenase complex|dihydrolipoyl transacylase|dihydrolipoyllysine-residue (2-methylpropanoyl)transferase|part of the BCKAD complex', map_location='3 50.37 cM', chromosome='3', genomic_nucleotide_accession_version='NC_000069.6', start_position_on_the_genomic_accession=116513070, end_position_on_the_genomic_accession=116549981, orientation='plus', exon_count=11, OMIM=[], no_hdr0=''),
    13172 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=13172, CurrentID=0, Status='live', Symbol='Dbx1', Aliases=['AI426026', 'Dbx'], description='developing brain homeobox 1', other_designations='homeobox protein DBX1|Mmox C|developing brain homeobox protein 1', map_location='7 31.44 cM', chromosome='7', genomic_nucleotide_accession_version='NC_000073.6', start_position_on_the_genomic_accession=49631499, end_position_on_the_genomic_accession=49636835, orientation='minus', exon_count=4, OMIM=[], no_hdr0=''),
    13175 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=13175, CurrentID=0, Status='live', Symbol='Dclk1', Aliases=['1700113D08Rik', '2810480F11Rik', 'AI836758', 'CPG1', 'Clic', 'Click-I', 'Cpg16', 'Dc', 'Dcamk', 'Dcamkl1', 'Dcl', 'Dclk', 'mKIAA0369'], description='doublecortin-like kinase 1', other_designations='serine/threonine-protein kinase DCLK1|CLICK-I beta|doublecortin and calcium/calmodulin-dependent protein kinase-like 1|doublecortin-like and CAM kinase-like 1', map_location='3 C', chromosome='3', genomic_nucleotide_accession_version='NC_000069.6', start_position_on_the_genomic_accession=55242303, end_position_on_the_genomic_accession=55539068, orientation='plus', exon_count=21, OMIM=[], no_hdr0=''),
    13176 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=13176, CurrentID=0, Status='live', Symbol='Dcc', Aliases=['C030036D22Rik', 'Igdcc', 'Igdcc1'], description='deleted in colorectal carcinoma', other_designations='netrin receptor DCC|tumor suppressor protein DCC', map_location='18 45.24 cM', chromosome='18', genomic_nucleotide_accession_version='NC_000084.6', start_position_on_the_genomic_accession=71253613, end_position_on_the_genomic_accession=72351228, orientation='minus', exon_count=29, OMIM=[], no_hdr0=''),
    13177 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=13177, CurrentID=0, Status='live', Symbol='Eci1', Aliases=['Dc', 'Dci', 'ec', 'eci'], description='enoyl-Coenzyme A delta isomerase 1', other_designations='enoyl-CoA delta isomerase 1, mitochondrial|3,2 trans-enoyl-Coenyme A isomerase|3,2-trans-enoyl-CoA isomerase, mitochondrial|D3,D2-enoyl-CoA isomerase|delta(3),Delta(2)-enoyl-CoA isomerase|dodecenoyl-CoA isomerase|dodecenoyl-Coenzyme A delta isomerase (3,2 trans-enoyl-Coenyme A isomerase)', map_location='17 A3.3', chromosome='17', genomic_nucleotide_accession_version='NC_000083.6', start_position_on_the_genomic_accession=24426683, end_position_on_the_genomic_accession=24439316, orientation='plus', exon_count=7, OMIM=[], no_hdr0=''),
    13178 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=13178, CurrentID=0, Status='live', Symbol='Dck', Aliases=[], description='deoxycytidine kinase', other_designations='deoxycytidine kinase|deoxyadenosine kinase|deoxyguanosine kinase', map_location='5 E1', chromosome='5', genomic_nucleotide_accession_version='NC_000071.6', start_position_on_the_genomic_accession=88765013, end_position_on_the_genomic_accession=88783277, orientation='plus', exon_count=7, OMIM=[], no_hdr0=''),
    13179 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=13179, CurrentID=0, Status='live', Symbol='Dcn', Aliases=['DC', 'DSPG2', 'PG40', 'PGII', 'PGS2', 'SL', 'SLRR1B'], description='decorin', other_designations='decorin|bone proteoglycan II', map_location='10 50.27 cM', chromosome='10', genomic_nucleotide_accession_version='NC_000076.6', start_position_on_the_genomic_accession=97479500, end_position_on_the_genomic_accession=97518163, orientation='plus', exon_count=9, OMIM=[], no_hdr0=''),
    13180 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=13180, CurrentID=0, Status='live', Symbol='Pcbd1', Aliases=['Dco', 'Dcoh', 'Pcb', 'Pcbd', 'Pcd', 'Phs'], description='pterin 4 alpha carbinolamine dehydratase/dimerization cofactor of hepatocyte nuclear factor 1 alpha (TCF1) 1', other_designations='pterin-4-alpha-carbinolamine dehydratase|4-alpha-hydroxy-tetrahydropterin dehydratase|6-pyruvoyl-tetrahydropterin synthase/dimerization cofactor of hepatocyte nuclear factor 1 alpha (TCF1)|dimerization cofactor of HNF1|phenylalanine hydroxylase-stimulating protein|pterin carbinolamine dehydratase', map_location='10 32.14 cM', chromosome='10', genomic_nucleotide_accession_version='NC_000076.6', start_position_on_the_genomic_accession=61089331, end_position_on_the_genomic_accession=61094329, orientation='plus', exon_count=4, OMIM=[], no_hdr0=''),
    13184 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=13184, CurrentID=0, Status='live', Symbol='Dcpp1', Aliases=['BC005655', 'C86550', 'Dc', 'Dcpp', 'Dcpp-1', 'p2', 'p20'], description='demilune cell and parotid protein 1', other_designations='demilune cell and parotid protein|common salivary protein 1', map_location='17 12.11 cM', chromosome='17', genomic_nucleotide_accession_version='NC_000083.6', start_position_on_the_genomic_accession=23880669, end_position_on_the_genomic_accession=23882853, orientation='plus', exon_count=3, OMIM=[], no_hdr0=''),
    13185 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=13185, CurrentID=0, Status='live', Symbol='Vps26c', Aliases=['AW538125', 'Dc', 'Dcra', 'Dsc', 'Dscr3'], description='VPS26 endosomal protein sorting factor C', other_designations='vacuolar protein sorting-associated protein 26C|DSCR3 arrestin fold containing|Down syndrome critical region gene 3|Down syndrome critical region gene A|Down syndrome critical region protein 3 homolog|Down syndrome critical region protein A homolog', map_location='16 C4', chromosome='16', genomic_nucleotide_accession_version='NC_000082.6', start_position_on_the_genomic_accession=94497724, end_position_on_the_genomic_accession=94526629, orientation='minus', exon_count=8, OMIM=[], no_hdr0=''),
    13190 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=13190, CurrentID=0, Status='live', Symbol='Dct', Aliases=['DT', 'TR', 'TRP', 'TRP-2', 'TRP2', 'Tyr', 'Tyrp', 'Tyrp-2', 'Tyrp2', 'slaty', 'slt'], description='dopachrome tautomerase', other_designations='L-dopachrome tautomerase|DOPAchrome conversion factor|DOPAchrome isomerase|DOPAchrome oxidoreductase|L-dopachrome Delta-isomerase|SLATY locus protein|tyrosinase-related protein 2', map_location='14 61.6 cM', chromosome='14', genomic_nucleotide_accession_version='NC_000080.6', start_position_on_the_genomic_accession=118012790, end_position_on_the_genomic_accession=118052246, orientation='minus', exon_count=9, OMIM=[], no_hdr0=''),
    13191 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=13191, CurrentID=0, Status='live', Symbol='Dctn1', Aliases=['AL022633', 'DAP-150', 'DP-150', 'Glue', 'Glued', 'p15', 'p150', 'p150-glued', 'p150<glue', 'p150<glued>'], description='dynactin 1', other_designations='dynactin subunit 1|150 kDa dynein-associated polypeptide|dynactin 1, retrograde axonal transport', map_location='6 35.94 cM', chromosome='6', genomic_nucleotide_accession_version='NC_000072.6', start_position_on_the_genomic_accession=83165909, end_position_on_the_genomic_accession=83200118, orientation='plus', exon_count=35, OMIM=[], no_hdr0=''),
    13193 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=13193, CurrentID=0, Status='live', Symbol='Dcx', Aliases=['Dbct'], description='doublecortin', other_designations='neuronal migration protein doublecortin|doublecortex|doublin|lis-X|lissencephalin-X|lissencephaly, X-linked (doublecortin)', map_location='X F2', chromosome='X', genomic_nucleotide_accession_version='NC_000086.7', start_position_on_the_genomic_accession=143855842, end_position_on_the_genomic_accession=143933396, orientation='minus', exon_count=7, OMIM=[], no_hdr0=''),
    13194 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=13194, CurrentID=0, Status='live', Symbol='Ddb1', Aliases=['127kDa', 'AA408517', 'p127-Ddb', 'p127-Ddb1'], description='damage specific DNA binding protein 1', other_designations='DNA damage-binding protein 1|DDB p127 subunit|UV-damaged DNA-binding factor|damage-specific DNA-binding protein, DNA repair|damaged-DNA recognition protein 1', map_location='19 6.66 cM', chromosome='19', genomic_nucleotide_accession_version='NC_000085.6', start_position_on_the_genomic_accession=10605568, end_position_on_the_genomic_accession=10629828, orientation='plus', exon_count=28, OMIM=[], no_hdr0=''),
    13195 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=13195, CurrentID=0, Status='live', Symbol='Ddc', Aliases=['Aa', 'Aadc'], description='dopa decarboxylase', other_designations='aromatic-L-amino-acid decarboxylase', map_location='11 7.09 cM', chromosome='11', genomic_nucleotide_accession_version='NC_000077.6', start_position_on_the_genomic_accession=11814101, end_position_on_the_genomic_accession=11898144, orientation='minus', exon_count=19, OMIM=[], no_hdr0=''),
    13196 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=13196, CurrentID=0, Status='live', Symbol='Asap1', Aliases=['AV239055', 'DEF-1', 'Ddef1', 'PAP', 'mKIAA1249', 's19'], description='ArfGAP with SH3 domain, ankyrin repeat and PH domain1', other_designations='arf-GAP with SH3 domain, ANK repeat and PH domain-containing protein 1|130 kDa phosphatidylinositol 4,5-biphosphate-dependent ARF1 GTPase-activating protein|130 kDa phosphatidylinositol 4,5-bisphosphate-dependent ARF1 GTPase-activating protein|ADP-ribosylation factor-directed GTPase-activating protein 1|ARF GTPase-activating protein 1|PIP2-dependent ARF1 GAP|development and differentiation-enhancing factor 1', map_location='15 D1', chromosome='15', genomic_nucleotide_accession_version='NC_000081.6', start_position_on_the_genomic_accession=64086840, end_position_on_the_genomic_accession=64382941, orientation='minus', exon_count=35, OMIM=[], no_hdr0=''),
    13197 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=13197, CurrentID=0, Status='live', Symbol='Gadd45a', Aliases=['AA545191', 'Ddit', 'Ddit1', 'GADD45'], description='growth arrest and DNA-damage-inducible 45 alpha', other_designations='growth arrest and DNA damage-inducible protein GADD45 alpha|DDIT-1|DNA damage-inducible transcript 1 protein|DNA-damage-inducible transcript 1|Gadd45alpha|growth arrest and DNA-damage-inducible, alpha', map_location='6 C1', chromosome='6', genomic_nucleotide_accession_version='NC_000072.6', start_position_on_the_genomic_accession=67035096, end_position_on_the_genomic_accession=67037407, orientation='minus', exon_count=4, OMIM=[], no_hdr0=''),
    13198 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=13198, CurrentID=0, Status='live', Symbol='Ddit3', Aliases=['AltDDIT3', 'CHOP-', 'CHOP-10', 'CHOP10', 'ch', 'chop', 'gadd15', 'gadd153'], description='DNA-damage inducible transcript 3', other_designations='DNA damage-inducible transcript 3 protein|C/EBP homoologous protein 10|C/EBP zeta|CCAAT/enhancer-binding protein homologous protein|DDIT-3|alternative DDIT3 proteins|c/EBP-homologous protein 10|growth arrest and DNA-damage-inducible protein GADD153', map_location='10 D3', chromosome='10', genomic_nucleotide_accession_version='NC_000076.6', start_position_on_the_genomic_accession=127290793, end_position_on_the_genomic_accession=127296291, orientation='plus', exon_count=4, OMIM=[], no_hdr0=''),
    13199 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=13199, CurrentID=0, Status='live', Symbol='Ddn', Aliases=['Gm748'], description='dendrin', other_designations='dendrin', map_location='15 54.69 cM', chromosome='15', genomic_nucleotide_accession_version='NC_000081.6', start_position_on_the_genomic_accession=98803782, end_position_on_the_genomic_accession=98807925, orientation='minus', exon_count=2, OMIM=[], no_hdr0=''),
    13200 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=13200, CurrentID=0, Status='live', Symbol='Ddost', Aliases=[], description='dolichyl-di-phosphooligosaccharide-protein glycotransferase', other_designations='dolichyl-diphosphooligosaccharide--protein glycosyltransferase 48 kDa subunit|DDOST 48 kDa subunit|oligosaccharyl transferase 48 kDa subunit', map_location='4 D3', chromosome='4', genomic_nucleotide_accession_version='NC_000070.6', start_position_on_the_genomic_accession=138304738, end_position_on_the_genomic_accession=138312619, orientation='plus', exon_count=11, OMIM=[], no_hdr0=''),
    13202 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=13202, CurrentID=0, Status='live', Symbol='Ddt', Aliases=['C78655'], description='D-dopachrome tautomerase', other_designations='D-dopachrome decarboxylase', map_location='10 38.58 cM', chromosome='10', genomic_nucleotide_accession_version='NC_000076.6', start_position_on_the_genomic_accession=75771233, end_position_on_the_genomic_accession=75773374, orientation='minus', exon_count=3, OMIM=[], no_hdr0=''),
    13204 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=13204, CurrentID=0, Status='live', Symbol='Dhx15', Aliases=['DBP', 'DBP1', 'DEAH9', 'Ddx15', 'HRH', 'HRH2', 'mDEAH', 'mDEAH9'], description='DEAH (Asp-Glu-Ala-His) box polypeptide 15', other_designations='pre-mRNA-splicing factor ATP-dependent RNA helicase DHX15|DEAD/H (Asp-Glu-Ala-Asp/His) box polypeptide 15 (RNA helicase A)|DEAH box protein 15|putative pre-mRNA-splicing factor ATP-dependent RNA helicase DHX15', map_location='5 C1', chromosome='5', genomic_nucleotide_accession_version='NC_000071.6', start_position_on_the_genomic_accession=52150203, end_position_on_the_genomic_accession=52190546, orientation='minus', exon_count=14, OMIM=[], no_hdr0=''),
    13205 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=13205, CurrentID=0, Status='live', Symbol='Ddx3x', Aliases=['D1Pas', 'D1Pas1-rs2', 'Ddx3', 'Fin', 'Fin14'], description='DEAD box helicase 3, X-linked', other_designations='ATP-dependent RNA helicase DDX3X|D-E-A-D (aspartate-glutamate-alanine-aspartate) box polypeptide 3|D1Pas1-related sequence 2|DEAD (aspartate-glutamate-alanine-aspartate) box polypeptide 3|DEAD box RNA helicase DEAD3|DEAD box protein 3, X-chromosomal|DEAD-box protein 3 (DEAD-box RNA helicase DEAD3) (mDEAD3) (Embryonic RNA helicase) (D1PAS1 related sequence 2)|DEAD/H (Asp-Glu-Ala-Asp/His) box polypeptide 3, X-linked|embryonic RNA helicase|fibroblast growth factor inducible 14|mDEAD3', map_location='X 8.17 cM', chromosome='X', genomic_nucleotide_accession_version='NC_000086.7', start_position_on_the_genomic_accession=13280496, end_position_on_the_genomic_accession=13293988, orientation='plus', exon_count=17, OMIM=[], no_hdr0=''),
    13206 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=13206, CurrentID=0, Status='live', Symbol='Ddx4', Aliases=['AV206478', 'Mv', 'Mvh', 'VASA'], description='DEAD box helicase 4', other_designations="ATP-dependent RNA helicase DDX4|D-E-A-D (aspartate-glutamate-alanine-aspartate) box polypeptide 4|DEAD (Asp-Glu-Ala-Asp) box polypeptide 4|DEAD (aspartate-glutamate-alanine-aspartate) box polypeptide 4|DEAD box polypeptide 4|DEAD box protein 4|DEAD/H (Asp-Glu-Ala-Asp/His) box polypeptide 4|mvh / m'vasa|probable ATP-dependent RNA helicase DDX4|vasa homolog", map_location='13 63.87 cM', chromosome='13', genomic_nucleotide_accession_version='NC_000079.6', start_position_on_the_genomic_accession=112598333, end_position_on_the_genomic_accession=112652633, orientation='minus', exon_count=23, OMIM=[], no_hdr0=''),
    13207 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=13207, CurrentID=0, Status='live', Symbol='Ddx5', Aliases=['2600009A06Rik', 'G17P1', 'HUMP68', 'Hl', 'Hlr1', 'p6', 'p68'], description='DEAD box helicase 5', other_designations='probable ATP-dependent RNA helicase DDX5|DEAD (Asp-Glu-Ala-Asp) box polypeptide 5|DEAD (aspartate-glutamate-alanine-aspartate) box polypeptide 5|DEAD box RNA helicase DEAD1|DEAD box protein 5|DEAD/H (Asp-Glu-Ala-Asp/His) box polypeptide 5|RNA helicase p68|mDEAD1', map_location='11 70.01 cM', chromosome='11', genomic_nucleotide_accession_version='NC_000077.6', start_position_on_the_genomic_accession=106780355, end_position_on_the_genomic_accession=106789185, orientation='minus', exon_count=15, OMIM=[], no_hdr0=''),
    13209 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=13209, CurrentID=0, Status='live', Symbol='Ddx6', Aliases=['1110001P04Rik', 'C430015D01Rik', 'E230023J21Rik', 'HL', 'HLR2', 'mRCK/P', 'mRCK/P54', 'p5', 'p54', 'rc', 'rck'], description='DEAD (Asp-Glu-Ala-Asp) box polypeptide 6', other_designations='probable ATP-dependent RNA helicase DDX6|ATP-dependent RNA helicase p54|D-E-A-D (aspartate-glutamate-alanine-aspartate) box polypeptide 6|DEAD (aspartate-glutamate-alanine-aspartate) box polypeptide 6|DEAD box protein 6|DEAD/H (Asp-Glu-Ala-Asp/His) box polypeptide 6|oncogene RCK homolog', map_location='9 24.84 cM', chromosome='9', genomic_nucleotide_accession_version='NC_000075.6', start_position_on_the_genomic_accession=44602983, end_position_on_the_genomic_accession=44640731, orientation='plus', exon_count=16, OMIM=[], no_hdr0=''),
    13211 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=13211, CurrentID=0, Status='live', Symbol='Dhx9', Aliases=['AI326842', 'Ddx9', 'HEL-5', 'ND', 'NDHII', 'R', 'RHA', 'leuko', 'mHEL-5'], description='DEAH (Asp-Glu-Ala-His) box polypeptide 9', other_designations='ATP-dependent RNA helicase A|D-E-A-D (aspartate-glutamate-alanine-aspartate) box polypeptide 9|DEAD (aspartate-glutamate-alanine-aspartate) box polypeptide 9|DEAD/H (Asp-Glu-Ala-Asp/His) box polypeptide 9|DEAH box protein 9|RNA helicase A|leukophysin|nuclear DNA helicase II', map_location='1 65.37 cM', chromosome='1', genomic_nucleotide_accession_version='NC_000067.6', start_position_on_the_genomic_accession=153455756, end_position_on_the_genomic_accession=153487688, orientation='minus', exon_count=29, OMIM=[], no_hdr0=''),
    13214 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=13214, CurrentID=0, Status='live', Symbol='Defb1', Aliases=['AW260221', 'BD-1'], description='defensin beta 1', other_designations='beta-defensin 1', map_location='8 10.35 cM', chromosome='8', genomic_nucleotide_accession_version='NC_000074.6', start_position_on_the_genomic_accession=21776555, end_position_on_the_genomic_accession=21795185, orientation='plus', exon_count=2, OMIM=[], no_hdr0=''),
    13215 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=13215, CurrentID=0, Status='live', Symbol='Defb2', Aliases=['BD-2'], description='defensin beta 2', other_designations='beta-defensin 2', map_location='8 10.45 cM', chromosome='8', genomic_nucleotide_accession_version='NC_000074.6', start_position_on_the_genomic_accession=21839926, end_position_on_the_genomic_accession=21843482, orientation='plus', exon_count=2, OMIM=[], no_hdr0=''),
    13216 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=13216, CurrentID=0, Status='live', Symbol='Defa1', Aliases=['Defcr', 'Defcr1', 'cryptd'], description='defensin, alpha 1', other_designations='alpha-defensin 1|cryptdin-1|defensin related cryptdin peptide 1|defensin-1|defensin-related cryptdin peptide', map_location='8', chromosome='8', genomic_nucleotide_accession_version='', start_position_on_the_genomic_accession='', end_position_on_the_genomic_accession='', orientation='', exon_count='', OMIM=[], no_hdr0=''),
    13218 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=13218, CurrentID=0, Status='live', Symbol='Defa29', Aliases=['2010300L12Rik', '2010319H24Rik', 'CRS1C', 'CRS1C-2', 'CRS1C-4', 'CRS1C-5', 'Defa-', 'Defa-rs1', 'Defcr-', 'Defcr-rs1'], description='defensin, alpha, 29', other_designations='alpha-defensin-related sequence 1|cryptdin-related protein 1C|defensin related sequence cryptdin peptide (paneth cells)|defensin, alpha, related sequence 1|defensin-related cryptdin-related sequence 1|testis defensin', map_location='8 10.35 cM', chromosome='8', genomic_nucleotide_accession_version='NC_000074.6', start_position_on_the_genomic_accession=21325888, end_position_on_the_genomic_accession=21327020, orientation='minus', exon_count=2, OMIM=[], no_hdr0=''),
    13219 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=13219, CurrentID=0, Status='live', Symbol='Defa-rs10', Aliases=['CRS4C', 'CRS4C-4', 'Defcr-r', 'Defcr-rs10'], description='defensin, alpha, related sequence 10', other_designations='alpha-defensin-related sequence 10|cryptdin-related protein 4C-4|defensin related cryptdin, related sequence 10', map_location='', chromosome='8', genomic_nucleotide_accession_version='', start_position_on_the_genomic_accession='', end_position_on_the_genomic_accession='', orientation='', exon_count='', OMIM=[], no_hdr0=''),
    13221 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=13221, CurrentID=0, Status='live', Symbol='Defa-rs12', Aliases=['CRS4C-5', 'Defcr-r', 'Defcr-rs12'], description='defensin, alpha, related sequence 12', other_designations='alpha-defensin-related sequence 12|cryptdin-related protein 4C-5|cysteine-rich cryptdin-1-like protein|defensin related cryptdin, related sequence 12', map_location='8 A2', chromosome='8', genomic_nucleotide_accession_version='', start_position_on_the_genomic_accession='', end_position_on_the_genomic_accession='', orientation='', exon_count='', OMIM=[], no_hdr0=''),
    13222 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=13222, CurrentID=0, Status='live', Symbol='Defa-rs2', Aliases=['CRS', 'CRS4C', 'CRS4C-1', 'CRS4C1d', 'CRS4C1e', 'CRS4C1f', 'CRS4C1g', 'CRS4C1h', 'CRS4C1i', 'CRS4C1j', 'Defcr-', 'Defcr-rs2', 'Defcr-rs3'], description='defensin, alpha, related sequence 2', other_designations='alpha-defensin-related sequence 2|cryptdin related sequence peptide|cryptdin-related protein 4C-1|defensin related cryptdin, related sequence 2', map_location='', chromosome='8', genomic_nucleotide_accession_version='', start_position_on_the_genomic_accession='', end_position_on_the_genomic_accession='', orientation='', exon_count='', OMIM=[], no_hdr0=''),
    13223 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=13223, CurrentID=0, Status='live', Symbol='Defa-rs4', Aliases=['CRS4', 'CRS4C', 'CRS4C-1a', 'CRS4C1a', 'Defcr-', 'Defcr-rs4'], description='defensin, alpha,, related sequence 4', other_designations='alpha-defensin,, related sequence 4|defensin related cryptdin, related sequence 4', map_location='', chromosome='8', genomic_nucleotide_accession_version='', start_position_on_the_genomic_accession='', end_position_on_the_genomic_accession='', orientation='', exon_count='', OMIM=[], no_hdr0=''),
    13226 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=13226, CurrentID=0, Status='live', Symbol='Defa31', Aliases=['CRS4C', 'CRS4C-2', 'CRS4C2', 'CRS4C2b', 'CRS4C2c', 'CRS4C2d', 'CRS4C3a', 'CRS4C3a2', 'CRS4C3b', 'CRS4C3c', 'CRS4C3d', 'CRS4C3e', 'Defa-', 'Defa-rs7', 'Defa23', 'Defcr-', 'Defcr-rs7', 'Defcr23'], description='defensin, alpha, 31', other_designations='alpha-defensin-related sequence 7|Alpha-defensin 23|cryptdin related sequence peptide|cryptdin-related protein 4C-2|defensin, alpha, related sequence 7|defensin-related cryptdin-related sequence 7', map_location='8 A2', chromosome='8', genomic_nucleotide_accession_version='NC_000074.6', start_position_on_the_genomic_accession=21191573, end_position_on_the_genomic_accession=21192550, orientation='plus', exon_count=2, OMIM=[], no_hdr0=''),
    13229 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=13229, CurrentID=0, Status='live', Symbol='Defa10', Aliases=['Defcr1', 'Defcr10'], description='defensin, alpha, 10', other_designations='alpha-defensin 10|alpha-defensin, 10|defensin-related cryptdin-10', map_location='', chromosome='8', genomic_nucleotide_accession_version='', start_position_on_the_genomic_accession='', end_position_on_the_genomic_accession='', orientation='', exon_count='', OMIM=[], no_hdr0=''),
    13230 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=13230, CurrentID=0, Status='live', Symbol='Defa11', Aliases=['Defcr1', 'Defcr11'], description='defensin, alpha, 11', other_designations='alpha-defensin 11|alpha-defensin, 11|defensin-related cryptdin-11', map_location='', chromosome='8', genomic_nucleotide_accession_version='', start_position_on_the_genomic_accession='', end_position_on_the_genomic_accession='', orientation='', exon_count='', OMIM=[], no_hdr0=''),
    13231 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=13231, CurrentID=0, Status='live', Symbol='Defa12', Aliases=['Defcr1', 'Defcr12'], description='defensin, alpha, 12', other_designations='alpha-defensin 6/12|alpha-defensin, 12|cryptdin-2|defensin related cryptdin 12|defensin-related cryptdin-6/12', map_location='', chromosome='8', genomic_nucleotide_accession_version='', start_position_on_the_genomic_accession='', end_position_on_the_genomic_accession='', orientation='', exon_count='', OMIM=[], no_hdr0=''),
    13232 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=13232, CurrentID=0, Status='live', Symbol='Defa13', Aliases=['Defcr1', 'Defcr13'], description='defensin, alpha, 13', other_designations='alpha-defensin 13|alpha-defensin, 13|defensin-related cryptdin-13', map_location='', chromosome='8', genomic_nucleotide_accession_version='', start_position_on_the_genomic_accession='', end_position_on_the_genomic_accession='', orientation='', exon_count='', OMIM=[], no_hdr0=''),
    13233 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=13233, CurrentID=0, Status='live', Symbol='Defa14', Aliases=['Defcr1', 'Defcr14'], description='defensin, alpha, 14', other_designations='alpha-defensin 14|alpha-defensin, 14|defensin-related cryptdin-14', map_location='', chromosome='8', genomic_nucleotide_accession_version='', start_position_on_the_genomic_accession='', end_position_on_the_genomic_accession='', orientation='', exon_count='', OMIM=[], no_hdr0=''),
    13234 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=13234, CurrentID=0, Status='live', Symbol='Defa15', Aliases=['Defcr1', 'Defcr15'], description='defensin, alpha, 15', other_designations='alpha-defensin 15|alpha-defensin, 15|defensin-related cryptdin-15', map_location='', chromosome='8', genomic_nucleotide_accession_version='', start_position_on_the_genomic_accession='', end_position_on_the_genomic_accession='', orientation='', exon_count='', OMIM=[], no_hdr0=''),
    13235 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=13235, CurrentID=0, Status='live', Symbol='Defa16', Aliases=['Defcr1', 'Defcr16'], description='defensin, alpha, 16', other_designations='alpha-defensin 16|defensin-related cryptdin-16', map_location='', chromosome='8', genomic_nucleotide_accession_version='', start_position_on_the_genomic_accession='', end_position_on_the_genomic_accession='', orientation='', exon_count='', OMIM=[], no_hdr0=''),
    13236 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=13236, CurrentID=0, Status='live', Symbol='Defa25', Aliases=['Defcr-2', 'Defcr2', 'Defcr25'], description='defensin, alpha, 25', other_designations='alpha-defensin 25|defensin related cryptdin 2|defensin-related cryptdin-25', map_location='8', chromosome='8', genomic_nucleotide_accession_version='NC_000074.6', start_position_on_the_genomic_accession=21084442, end_position_on_the_genomic_accession=21085285, orientation='plus', exon_count=2, OMIM=[], no_hdr0=''),
    13237 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=13237, CurrentID=0, Status='live', Symbol='Defa3', Aliases=['Defa27', 'Defcr', 'Defcr-', 'Defcr-3', 'Defcr3'], description='defensin, alpha, 3', other_designations='alpha-defensin 3|defensin, alpha, 27|defensin-related cryptdin-3', map_location='8 A2', chromosome='8', genomic_nucleotide_accession_version='NC_000074.6', start_position_on_the_genomic_accession=21287409, end_position_on_the_genomic_accession=21288377, orientation='plus', exon_count=2, OMIM=[], no_hdr0=''),
    13238 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=13238, CurrentID=0, Status='live', Symbol='Defa4', Aliases=['Cr', 'Crp4', 'Defa28', 'Defcr', 'Defcr4'], description='defensin, alpha, 4', other_designations='alpha-defensin 4|alpha-defensin, 28|defensin related cryptdin 4', map_location='8 A2', chromosome='8', genomic_nucleotide_accession_version='', start_position_on_the_genomic_accession='', end_position_on_the_genomic_accession='', orientation='', exon_count='', OMIM=[], no_hdr0=''),
    13239 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=13239, CurrentID=0, Status='live', Symbol='Defa5', Aliases=['Defa29', 'Defcr', 'Defcr29', 'Defcr5'], description='defensin, alpha, 5', other_designations='alpha-defensin 5|defensin, alpha, 29|defensin-related cryptdin-5', map_location='8 A2', chromosome='8', genomic_nucleotide_accession_version='NC_000074.6', start_position_on_the_genomic_accession=21297394, end_position_on_the_genomic_accession=21298375, orientation='plus', exon_count=2, OMIM=[], no_hdr0=''),
    13240 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=13240, CurrentID=0, Status='live', Symbol='Defa6', Aliases=['Defcr', 'Defcr6'], description='defensin, alpha, 6', other_designations='alpha-defensin 6/12|alpha-defensin, 6|cryptdin-2|defensin related cryptdin 6|defensin-related cryptdin-6/12', map_location='8 A2', chromosome='8', genomic_nucleotide_accession_version='', start_position_on_the_genomic_accession='', end_position_on_the_genomic_accession='', orientation='', exon_count='', OMIM=[], no_hdr0=''),
    13241 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=13241, CurrentID=0, Status='live', Symbol='Defa7', Aliases=['Defa30', 'Defcr', 'Defcr7'], description='defensin, alpha, 7', other_designations='alpha-defensin 7|alpha-defensin, 30|defensin, alpha, 30|defensin-related cryptdin-7', map_location='', chromosome='8', genomic_nucleotide_accession_version='', start_position_on_the_genomic_accession='', end_position_on_the_genomic_accession='', orientation='', exon_count='', OMIM=[], no_hdr0=''),
    13242 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=13242, CurrentID=0, Status='live', Symbol='Defa8', Aliases=['Defa31', 'Defcr', 'Defcr8'], description='defensin, alpha, 8', other_designations='alpha-defensin 8|alpha-defensin, 31|defensin, alpha, 31|defensin-related cryptdin-8', map_location='', chromosome='8', genomic_nucleotide_accession_version='', start_position_on_the_genomic_accession='', end_position_on_the_genomic_accession='', orientation='', exon_count='', OMIM=[], no_hdr0=''),
    13243 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=13243, CurrentID=0, Status='live', Symbol='Defa9', Aliases=['Defa32', 'Defcr', 'Defcr9'], description='defensin, alpha, 9', other_designations='alpha-defensin 9|alpha-defensin, 32|defensin, alpha, 32|defensin-related cryptdin-9', map_location='', chromosome='8', genomic_nucleotide_accession_version='', start_position_on_the_genomic_accession='', end_position_on_the_genomic_accession='', orientation='', exon_count='', OMIM=[], no_hdr0=''),
    13244 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=13244, CurrentID=0, Status='live', Symbol='Degs1', Aliases=['AA536663', 'Degs', 'Des', 'Des1', 'Mde', 'Mdes'], description='delta(4)-desaturase, sphingolipid 1', other_designations='sphingolipid delta(4)-desaturase DES1|degenerative spermatocyte homolog 1|dihydroceramide desaturase|dihydroceramide desaturase-1', map_location='1 H5', chromosome='1', genomic_nucleotide_accession_version='NC_000067.6', start_position_on_the_genomic_accession=182275964, end_position_on_the_genomic_accession=182282854, orientation='minus', exon_count=4, OMIM=[], no_hdr0=''),
    13340 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=13340, CurrentID=0, Status='live', Symbol='Slc29a2', Aliases=['Der1', 'Der12', 'ENT', 'Ent2', 'HNP', 'Hnp36'], description='solute carrier family 29 (nucleoside transporters), member 2', other_designations='equilibrative nucleoside transporter 2|36 kDa hydrophobic nucleolar protein|36 kDa nucleolar protein HNP36|delayed early response gene 12|delayed-early response protein 12|equilibrative NBMPR-insensitive nucleoside transporter|equilibrative nitrobenzylmercaptopurine riboside-insensitive nucleoside transporter|nucleoside transporter, ei-type|solute carrier family 29 member 2', map_location='19 A', chromosome='19', genomic_nucleotide_accession_version='NC_000085.6', start_position_on_the_genomic_accession=5019057, end_position_on_the_genomic_accession=5031972, orientation='plus', exon_count=13, OMIM=[], no_hdr0=''),
    13345 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=13345, CurrentID=0, Status='live', Symbol='Twist2', Aliases=['Derm', 'Dermo1', 'bHLHa', 'bHLHa39'], description='twist basic helix-loop-helix transcription factor 2', other_designations='twist-related protein 2|dermis-expressed protein 1|twist homolog 2', map_location='1 D', chromosome='1', genomic_nucleotide_accession_version='NC_000067.6', start_position_on_the_genomic_accession=91801461, end_position_on_the_genomic_accession=91848034, orientation='plus', exon_count=2, OMIM=[], no_hdr0=''),
    13346 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=13346, CurrentID=0, Status='live', Symbol='Des', Aliases=[], description='desmin', other_designations='desmin', map_location='1 38.85 cM', chromosome='1', genomic_nucleotide_accession_version='NC_000067.6', start_position_on_the_genomic_accession=75360292, end_position_on_the_genomic_accession=75368579, orientation='plus', exon_count=9, OMIM=[], no_hdr0=''),
    13347 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=13347, CurrentID=0, Status='live', Symbol='Dffa', Aliases=['A330085O09Rik', 'DFF35', 'Dff45', 'ICA', 'ICAD', 'ICAD-L', 'ICAD-S'], description='DNA fragmentation factor, alpha subunit', other_designations='DNA fragmentation factor subunit alpha|DNA fragmentation factor 45 kDa subunit|inhibitor of CAD', map_location='4 E2', chromosome='4', genomic_nucleotide_accession_version='NC_000070.6', start_position_on_the_genomic_accession=149104142, end_position_on_the_genomic_accession=149120653, orientation='plus', exon_count=6, OMIM=[], no_hdr0=''),
    13349 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=13349, CurrentID=0, Status='live', Symbol='Ackr1', Aliases=['AA162249', 'CCBP', 'CCBP1', 'CD234', 'Da', 'Darc', 'Dfy', 'ESTM3', 'ESTM35', 'FY', 'GPD'], description='atypical chemokine receptor 1 (Duffy blood group)', other_designations='atypical chemokine receptor 1|Duffy antigen receptor for chemokines|Duffy blood group, chemokine receptor|duffy antigen/chemokine receptor|glycoprotein D', map_location='1 80.33 cM', chromosome='1', genomic_nucleotide_accession_version='NC_000067.6', start_position_on_the_genomic_accession=173331886, end_position_on_the_genomic_accession=173333503, orientation='minus', exon_count=2, OMIM=[], no_hdr0=''),
    13350 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=13350, CurrentID=0, Status='live', Symbol='Dgat1', Aliases=['ARAT', 'C75990', 'D15Ertd23', 'D15Ertd23e', 'Dgat'], description='diacylglycerol O-acyltransferase 1', other_designations='diacylglycerol O-acyltransferase 1|acyl-CoA retinol O-fatty-acyltransferase|diglyceride acyltransferase', map_location='15 35.99 cM', chromosome='15', genomic_nucleotide_accession_version='NC_000081.6', start_position_on_the_genomic_accession=76502012, end_position_on_the_genomic_accession=76512021, orientation='minus', exon_count=18, OMIM=[], no_hdr0=''),
    13353 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=13353, CurrentID=0, Status='live', Symbol='Dgcr6', Aliases=[], description='DiGeorge syndrome critical region gene 6', other_designations='protein DGCR6|DiGeorge syndrome chromosome region 6|diGeorge syndrome critical region 6 homolog', map_location='16 11.19 cM', chromosome='16', genomic_nucleotide_accession_version='NC_000082.6', start_position_on_the_genomic_accession=18052860, end_position_on_the_genomic_accession=18071633, orientation='plus', exon_count=7, OMIM=[], no_hdr0=''),
    13356 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=13356, CurrentID=0, Status='live', Symbol='Dgcr2', Aliases=['9930034O06Rik', 'DGS-', 'DGS-C', 'Dgcr', 'Dgs', 'Dgsc', 'Id', 'Idd', 'Lan', 'Sez1', 'Sez12', 'mKIAA0163'], description='DiGeorge syndrome critical region gene 2', other_designations='integral membrane protein DGCR2/IDD|DiGeorge syndrome gene c|DiGeorge syndrome protein C|seizure-related membrane-bound adhesion protein', map_location='16 11.05 cM', chromosome='16', genomic_nucleotide_accession_version='NC_000082.6', start_position_on_the_genomic_accession=17840355, end_position_on_the_genomic_accession=17891728, orientation='minus', exon_count=10, OMIM=[], no_hdr0=''),
    13358 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=13358, CurrentID=0, Status='live', Symbol='Slc25a1', Aliases=['1300019P08Rik', '2610100G11Rik', 'AI194714', 'Ctp', 'Dgs', 'Dgsj', 'Slc2', 'Slc20a3'], description='solute carrier family 25 (mitochondrial carrier, citrate transporter), member 1', other_designations='tricarboxylate transport protein, mitochondrial|DiGeorge syndrome gene j|citrate transport protein|solute carrier family 25 member 1|tricarboxylate carrier protein', map_location='16 11.11 cM', chromosome='16', genomic_nucleotide_accession_version='NC_000082.6', start_position_on_the_genomic_accession=17925211, end_position_on_the_genomic_accession=17928219, orientation='minus', exon_count=9, OMIM=[], no_hdr0=''),
    13360 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=13360, CurrentID=0, Status='live', Symbol='Dhcr7', Aliases=['AA409147'], description='7-dehydrocholesterol reductase', other_designations='7-dehydrocholesterol reductase|7-DHC reductase|sterol Delta(7)-reductase', map_location='7 F5', chromosome='7', genomic_nucleotide_accession_version='NC_000073.6', start_position_on_the_genomic_accession=143823167, end_position_on_the_genomic_accession=143848410, orientation='plus', exon_count=13, OMIM=[], no_hdr0=''),
    13361 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=13361, CurrentID=0, Status='live', Symbol='Dhfr', Aliases=['8430436I03Rik', 'AA607882', 'AI662710', 'AW555094'], description='dihydrofolate reductase', other_designations='dihydrofolate reductase', map_location='13 47.64 cM', chromosome='13', genomic_nucleotide_accession_version='NC_000079.6', start_position_on_the_genomic_accession=92354783, end_position_on_the_genomic_accession=92389053, orientation='plus', exon_count=6, OMIM=[], no_hdr0=''),
    13363 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=13363, CurrentID=0, Status='live', Symbol='Dhh', Aliases=['C78960'], description='desert hedgehog', other_designations='desert hedgehog protein|HHG-3', map_location='15 55.05 cM', chromosome='15', genomic_nucleotide_accession_version='NC_000081.6', start_position_on_the_genomic_accession=98881615, end_position_on_the_genomic_accession=98898562, orientation='minus', exon_count=6, OMIM=[], no_hdr0=''),
    13367 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=13367, CurrentID=0, Status='live', Symbol='Diaph1', Aliases=['D18Wsu154', 'D18Wsu154e', 'Di', 'Dia1', 'Diap1', 'Drf', 'Drf1', 'mDi', 'p140m', 'p140mDia'], description='diaphanous related formin 1', other_designations='protein diaphanous homolog 1', map_location='18 19.71 cM', chromosome='18', genomic_nucleotide_accession_version='NC_000084.6', start_position_on_the_genomic_accession=37843601, end_position_on_the_genomic_accession=37935622, orientation='minus', exon_count=30, OMIM=[], no_hdr0=''),
    13368 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=13368, CurrentID=0, Status='live', Symbol='Dffb', Aliases=['40kD', '40kDa', '5730477D02Rik', 'C', 'CA', 'CAD', 'CPAN', 'DFF40', 'Didf', 'Didff'], description='DNA fragmentation factor, beta subunit', other_designations='DNA fragmentation factor subunit beta|DFF-40|DNA fragmentation factor 40 kDa subunit|DNA fragmentation factor, 40 kD, beta subunit|DNase inhibited by DNA fragmentation factor|caspase-activated DNase|caspase-activated deoxyribonuclease', map_location='4 E2', chromosome='4', genomic_nucleotide_accession_version='NC_000070.6', start_position_on_the_genomic_accession=153964447, end_position_on_the_genomic_accession=153975121, orientation='minus', exon_count=10, OMIM=[], no_hdr0=''),
    13370 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=13370, CurrentID=0, Status='live', Symbol='Dio1', Aliases=['5DI', 'D1', 'ITDI1', 'TXDI1'], description='deiodinase, iodothyronine, type I', other_designations="type I iodothyronine deiodinase|DIOI|type 1 DI|type-I 5'-deiodinase", map_location='4 50.18 cM', chromosome='4', genomic_nucleotide_accession_version='NC_000070.6', start_position_on_the_genomic_accession=107291465, end_position_on_the_genomic_accession=107307168, orientation='minus', exon_count=4, OMIM=[], no_hdr0=''),
    13371 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=13371, CurrentID=0, Status='live', Symbol='Dio2', Aliases=['5DII', 'AI324267', 'DIOII'], description='deiodinase, iodothyronine, type II', other_designations="type II iodothyronine deiodinase|iodothyronine type II deiodinase|type 2 DI|type-II 5' deiodinase", map_location='12 D3', chromosome='12', genomic_nucleotide_accession_version='NC_000078.6', start_position_on_the_genomic_accession=90724552, end_position_on_the_genomic_accession=90739038, orientation='minus', exon_count=2, OMIM=[], no_hdr0=''),
    13380 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=13380, CurrentID=0, Status='live', Symbol='Dkk1', Aliases=['mdkk-1'], description='dickkopf WNT signaling pathway inhibitor 1', other_designations='dickkopf-related protein 1|dickkopf homolog 1|dickkopf-1|dickkopf-like protein 1|dkk-1', map_location='19 C1', chromosome='19', genomic_nucleotide_accession_version='NC_000085.6', start_position_on_the_genomic_accession=30545876, end_position_on_the_genomic_accession=30549496, orientation='minus', exon_count=4, OMIM=[], no_hdr0=''),
    13382 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=13382, CurrentID=0, Status='live', Symbol='Dld', Aliases=[], description='dihydrolipoamide dehydrogenase', other_designations='dihydrolipoyl dehydrogenase, mitochondrial|branched chain alpha-keto acid dehydrogenase complex subunit E3', map_location='12 13.43 cM', chromosome='12', genomic_nucleotide_accession_version='NC_000078.6', start_position_on_the_genomic_accession=31331562, end_position_on_the_genomic_accession=31351471, orientation='minus', exon_count=14, OMIM=[], no_hdr0=''),
    13383 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=13383, CurrentID=0, Status='live', Symbol='Dlg1', Aliases=['B130052P05Rik', 'Dlgh', 'Dlgh1', 'E-dlg/SAP97', 'SA', 'SAP-97', 'SAP97', 'mKIAA4187'], description='discs large MAGUK scaffold protein 1', other_designations='disks large homolog 1|discs, large homolog 1|embryo-dlg/synapse-associated protein 97', map_location='16 22.4 cM', chromosome='16', genomic_nucleotide_accession_version='NC_000082.6', start_position_on_the_genomic_accession=31663443, end_position_on_the_genomic_accession=31873356, orientation='plus', exon_count=31, OMIM=[], no_hdr0=''),
    13384 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=13384, CurrentID=0, Status='live', Symbol='Mpp3', Aliases=['6430514B01', 'Dlgh', 'Dlgh3'], description='membrane protein, palmitoylated 3 (MAGUK p55 subfamily member 3)', other_designations='MAGUK p55 subfamily member 3|Mpp3 membrane protein, palmitoylated 3|discs large homolog 3', map_location='11 65.48 cM', chromosome='11', genomic_nucleotide_accession_version='NC_000077.6', start_position_on_the_genomic_accession=101999652, end_position_on_the_genomic_accession=102027045, orientation='minus', exon_count=20, OMIM=[], no_hdr0=''),
    13385 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=13385, CurrentID=0, Status='live', Symbol='Dlg4', Aliases=['Dlgh', 'Dlgh4', 'PSD', 'PSD-', 'PSD-95', 'PSD95', 'SA', 'SAP90', 'SAP90A'], description='discs large MAGUK scaffold protein 4', other_designations='disks large homolog 4|PSD-95 alpha 2b|PSD-95 beta|SAP-90|discs large homolog 4|discs, large homolog 4|postsynaptic density protein 95|synapse-associated protein 90', map_location='11 B3', chromosome='11', genomic_nucleotide_accession_version='NC_000077.6', start_position_on_the_genomic_accession=70017203, end_position_on_the_genomic_accession=70045535, orientation='plus', exon_count=26, OMIM=[], no_hdr0=''),
    13386 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=13386, CurrentID=0, Status='live', Symbol='Dlk1', Aliases=['AW742678', 'DLK-1', 'Dl', 'DlkI', 'FA', 'FA1', 'Ly107', 'Peg', 'Peg9', 'SC', 'SCP1', 'ZO', 'ZOG', 'pG', 'pG2', 'pref', 'pref-1'], description='delta like non-canonical Notch ligand 1', other_designations='protein delta homolog 1|adipocyte differentiation inhibitor protein|delta-like 1 homolog|fetal antigen 1|preadipocyte factor 1|stromal cell derived protein 1', map_location='12 60.17 cM', chromosome='12', genomic_nucleotide_accession_version='NC_000078.6', start_position_on_the_genomic_accession=109452485, end_position_on_the_genomic_accession=109463336, orientation='plus', exon_count=8, OMIM=[], no_hdr0=''),
    13388 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=13388, CurrentID=0, Status='live', Symbol='Dll1', Aliases=['Delt', 'Delta1'], description='delta like canonical Notch ligand 1', other_designations='delta-like protein 1|delta like-1|delta-like 1|drosophila Delta homolog 1', map_location='17 8.95 cM', chromosome='17', genomic_nucleotide_accession_version='NC_000083.6', start_position_on_the_genomic_accession=15367354, end_position_on_the_genomic_accession=15376932, orientation='minus', exon_count=11, OMIM=[], no_hdr0=''),
    13389 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=13389, CurrentID=0, Status='live', Symbol='Dll3', Aliases=['pu', 'pudgy'], description='delta like canonical Notch ligand 3', other_designations='delta-like protein 3|M-Delta-3|delta-like 3|delta3|drosophila Delta homolog 3', map_location='7 16.67 cM', chromosome='7', genomic_nucleotide_accession_version='NC_000073.6', start_position_on_the_genomic_accession=28293555, end_position_on_the_genomic_accession=28301785, orientation='minus', exon_count=9, OMIM=[], no_hdr0=''),
    13390 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=13390, CurrentID=0, Status='live', Symbol='Dlx1', Aliases=['Dl', 'Dlx', 'Dlx-', 'Dlx-1'], description='distal-less homeobox 1', other_designations='homeobox protein DLX-1|DII B', map_location='2 42.61 cM', chromosome='2', genomic_nucleotide_accession_version='NC_000068.7', start_position_on_the_genomic_accession=71528113, end_position_on_the_genomic_accession=71533981, orientation='plus', exon_count=5, OMIM=[], no_hdr0=''),
    13392 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=13392, CurrentID=0, Status='live', Symbol='Dlx2', Aliases=['AW121999', 'Dlx-', 'Dlx-2', 'Tes-', 'Tes-1'], description='distal-less homeobox 2', other_designations='homeobox protein DLX-2|DII A|homeobox protein TES-1', map_location='2 42.65 cM', chromosome='2', genomic_nucleotide_accession_version='NC_000068.7', start_position_on_the_genomic_accession=71543408, end_position_on_the_genomic_accession=71546754, orientation='minus', exon_count=3, OMIM=[], no_hdr0=''),
    13393 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=13393, CurrentID=0, Status='live', Symbol='Dlx3', Aliases=['AV237891', 'Dlx-', 'Dlx-3'], description='distal-less homeobox 3', other_designations='homeobox protein DLX-3|DII C', map_location='11 59.01 cM', chromosome='11', genomic_nucleotide_accession_version='NC_000077.6', start_position_on_the_genomic_accession=95120117, end_position_on_the_genomic_accession=95125296, orientation='plus', exon_count=3, OMIM=[], no_hdr0=''),
    13394 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=13394, CurrentID=0, Status='live', Symbol='Dlx4', Aliases=['Dlx', 'Dlx-', 'Dlx-4', 'Dlx7'], description='distal-less homeobox 4', other_designations='homeobox protein DLX-4|DII D|distal-less homeo box 7|homeobox protein DLX-7', map_location='11 59.01 cM', chromosome='11', genomic_nucleotide_accession_version='NC_000077.6', start_position_on_the_genomic_accession=95140447, end_position_on_the_genomic_accession=95146294, orientation='minus', exon_count=4, OMIM=[], no_hdr0=''),
    13395 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=13395, CurrentID=0, Status='live', Symbol='Dlx5', Aliases=['AI385752'], description='distal-less homeobox 5', other_designations='homeobox protein DLX-5', map_location='6 2.83 cM', chromosome='6', genomic_nucleotide_accession_version='NC_000072.6', start_position_on_the_genomic_accession=6877801, end_position_on_the_genomic_accession=6882068, orientation='minus', exon_count=5, OMIM=[], no_hdr0=''),
    13396 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=13396, CurrentID=0, Status='live', Symbol='Dlx6', Aliases=[], description='distal-less homeobox 6', other_designations='homeobox protein DLX-6', map_location='6 2.83 cM', chromosome='6', genomic_nucleotide_accession_version='NC_000072.6', start_position_on_the_genomic_accession=6863334, end_position_on_the_genomic_accession=6867970, orientation='plus', exon_count=4, OMIM=[], no_hdr0=''),
    13400 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=13400, CurrentID=0, Status='live', Symbol='Dmpk', Aliases=['DM', 'DMK', 'Dm15', 'MDPK', 'MT-PK'], description='dystrophia myotonica-protein kinase', other_designations='myotonin-protein kinase|DM-kinase|dystrophia myotonica kinase, B15|myotonic dystrophy protein kinase', map_location='7 9.46 cM', chromosome='7', genomic_nucleotide_accession_version='NC_000073.6', start_position_on_the_genomic_accession=19083646, end_position_on_the_genomic_accession=19093821, orientation='plus', exon_count=15, OMIM=[], no_hdr0=''),
    13401 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=13401, CurrentID=0, Status='live', Symbol='Dmwd', Aliases=['DMR-', 'DMR-N9', 'Dm9'], description='dystrophia myotonica-containing WD repeat motif', other_designations='dystrophia myotonica WD repeat-containing protein|dystrophia myotonica linked gene, N9|dystrophia myotonica-containing WD repeat motif protein', map_location='7 9.46 cM', chromosome='7', genomic_nucleotide_accession_version='NC_000073.6', start_position_on_the_genomic_accession=19076112, end_position_on_the_genomic_accession=19082778, orientation='plus', exon_count=6, OMIM=[], no_hdr0=''),
    13404 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=13404, CurrentID=0, Status='live', Symbol='Dmc1', Aliases=['Dmc1h', 'Lim15', 'Mei1', 'Mei11', 'sg', 'sgdp'], description='DNA meiotic recombinase 1', other_designations='meiotic recombination protein DMC1/LIM15 homolog|DMC1 dosage suppressor of mck1 homolog, meiosis-specific homologous recombination|disrupted meiotic cDNA 1 homolog', map_location='15 37.79 cM', chromosome='15', genomic_nucleotide_accession_version='NC_000081.6', start_position_on_the_genomic_accession=79561497, end_position_on_the_genomic_accession=79605159, orientation='minus', exon_count=14, OMIM=[], no_hdr0=''),
    13405 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=13405, CurrentID=0, Status='live', Symbol='Dmd', Aliases=['DXSmh7', 'DXSmh9', 'Dp42', 'Dp427', 'Dp7', 'Dp71', 'dy', 'dys', 'mdx', 'pk', 'pke'], description='dystrophin, muscular dystrophy', other_designations='dystrophin|X-linked muscular dystrophy|dystrophin Dp71d(delta71,73-74)', map_location='X 38.38 cM', chromosome='X', genomic_nucleotide_accession_version='NC_000086.7', start_position_on_the_genomic_accession=82814664, end_position_on_the_genomic_accession=85205050, orientation='plus', exon_count=85, OMIM=[], no_hdr0=''),
    13406 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=13406, CurrentID=0, Status='live', Symbol='Dmp1', Aliases=['AG1', 'AV020965', 'DMP-1', 'Dmp', 'PP'], description='dentin matrix protein 1', other_designations='dentin matrix acidic phosphoprotein 1|serine rich acidic phosphoprotein', map_location='5 50.61 cM', chromosome='5', genomic_nucleotide_accession_version='NC_000071.6', start_position_on_the_genomic_accession=104197575, end_position_on_the_genomic_accession=104214102, orientation='plus', exon_count=7, OMIM=[], no_hdr0=''),
    13409 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=13409, CurrentID=0, Status='live', Symbol='Tmc1', Aliases=['4933416G09Rik', 'Beetho', 'Beethoven', 'Bth', 'CWEA1', 'TMC1ex1', 'dn'], description='transmembrane channel-like gene family 1', other_designations='transmembrane channel-like protein 1|deafness protein|transmembrane cochlear-expressed protein 1|transmembrane, cochlear expressed 1', map_location='19 13.98 cM', chromosome='19', genomic_nucleotide_accession_version='NC_000085.6', start_position_on_the_genomic_accession=20783456, end_position_on_the_genomic_accession=21037126, orientation='minus', exon_count=23, OMIM=[], no_hdr0=''),
    13411 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=13411, CurrentID=0, Status='live', Symbol='Dnah11', Aliases=['Dnahc', 'Dnahc11', 'av', 'avc4', 'b2b1203C', 'b2b1203Clo', 'b2b1279C', 'b2b1279Clo', 'b2b1289C', 'b2b1289Clo', 'b2b1727C', 'b2b1727Clo', 'b2b598C', 'b2b598Clo', 'iv', 'l', 'lrd'], description='dynein, axonemal, heavy chain 11', other_designations='dynein heavy chain 11, axonemal|dynein, axon, heavy chain 11|situs inversus viscerum', map_location='12 63.25 cM', chromosome='12', genomic_nucleotide_accession_version='NC_000078.6', start_position_on_the_genomic_accession=117877982, end_position_on_the_genomic_accession=118199043, orientation='minus', exon_count=87, OMIM=[], no_hdr0=''),
    13417 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=13417, CurrentID=0, Status='live', Symbol='Dnah8', Aliases=['ATPase', 'Dnah', 'Dnahc8', 'Hst6.7', 'Hst6.7b', 'P1', 'P1-Loop'], description='dynein, axonemal, heavy chain 8', other_designations='dynein heavy chain 8, axonemal|axonemal beta dynein heavy chain 8|axonemal dynein heavy chain 8 Dnahc8|ciliary dynein heavy chain 8|dynein, axon, heavy chain 8', map_location='17 A3.3', chromosome='17', genomic_nucleotide_accession_version='NC_000083.6', start_position_on_the_genomic_accession=30626935, end_position_on_the_genomic_accession=30875762, orientation='plus', exon_count=95, OMIM=[], no_hdr0=''),
    13418 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=13418, CurrentID=0, Status='live', Symbol='Dnajc1', Aliases=['4733401K02Rik', 'AA960110', 'D230036H06Rik', 'Dna', 'Dnajl1', 'ERdj', 'ERdj1', 'ERj1p', 'MTJ1'], description='DnaJ heat shock protein family (Hsp40) member C1', other_designations='dnaJ homolog subfamily C member 1|DnaJ (Hsp40) homolog, subfamily C, member 1|DnaJ-like protein 1|dnaJ protein homolog MTJ1', map_location='2 A3', chromosome='2', genomic_nucleotide_accession_version='NC_000068.7', start_position_on_the_genomic_accession=18205634, end_position_on_the_genomic_accession=18394099, orientation='minus', exon_count=13, OMIM=[], no_hdr0=''),
    13419 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=13419, CurrentID=0, Status='live', Symbol='Dnase1', Aliases=['AI788650', 'DN', 'DNaseI', 'Dnl1'], description='deoxyribonuclease I', other_designations='deoxyribonuclease-1', map_location='16 2.37 cM', chromosome='16', genomic_nucleotide_accession_version='NC_000082.6', start_position_on_the_genomic_accession=4036958, end_position_on_the_genomic_accession=4040024, orientation='plus', exon_count=10, OMIM=[], no_hdr0=''),
    13421 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=13421, CurrentID=0, Status='live', Symbol='Dnase1l3', Aliases=['DNase', 'DNasegamma', 'Dhp2', 'Lsd'], description='deoxyribonuclease 1-like 3', other_designations='deoxyribonuclease gamma|DNase I homolog protein DHP2|DNase I-like 3|DNase gamma|LS-DNase|deoxyribonuclease I-like 3|liver and spleen DNase|macrophage specific DNase I', map_location='14 A1', chromosome='14', genomic_nucleotide_accession_version='NC_000080.6', start_position_on_the_genomic_accession=7965187, end_position_on_the_genomic_accession=7994760, orientation='minus', exon_count=9, OMIM=[], no_hdr0=''),
    13423 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=13423, CurrentID=0, Status='live', Symbol='Dnase2a', Aliases=['Dnase2'], description='deoxyribonuclease II alpha', other_designations='deoxyribonuclease-2-alpha|DNase II alpha|acid DNase|lysosomal DNase II', map_location='8 41.31 cM', chromosome='8', genomic_nucleotide_accession_version='NC_000074.6', start_position_on_the_genomic_accession=84908755, end_position_on_the_genomic_accession=84911703, orientation='plus', exon_count=6, OMIM=[], no_hdr0=''),
    13424 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=13424, CurrentID=0, Status='live', Symbol='Dync1h1', Aliases=['9930018I23Rik', 'AI894280', 'DHC1', 'DHC1a', 'DNCL', 'Dnchc', 'Dnchc1', 'Dnec', 'Dnec1', 'Dnecl', 'Loa', 'MAP', 'MAP1C', 'P22', 'S', 'Swl', 'mKIAA0325'], description='dynein cytoplasmic 1 heavy chain 1', other_designations='cytoplasmic dynein 1 heavy chain 1|cytoplasmic dynein heavy chain 1|dynein heavy chain, cytosolic|dynein heavy chain, retrograde transport|dynein, cytoplasmic, heavy chain 1|legs at odd angle|sprawling', map_location='12 60.7 cM', chromosome='12', genomic_nucleotide_accession_version='NC_000078.6', start_position_on_the_genomic_accession=110601395, end_position_on_the_genomic_accession=110666944, orientation='plus', exon_count=77, OMIM=[], no_hdr0=''),
    13426 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=13426, CurrentID=0, Status='live', Symbol='Dync1i1', Aliases=['DH IC-1', 'DHIC-1', 'DI', 'DIC', 'Dnci', 'Dncic1', 'IC7', 'IC74'], description='dynein cytoplasmic 1 intermediate chain 1', other_designations='cytoplasmic dynein 1 intermediate chain 1|Dynein intermediate chain 1, cytosolic (DH IC-1) (Cytoplasmic dynein intermediate chain 1)|dynein, cytoplasmic, intermediate chain 1', map_location='6 2.26 cM', chromosome='6', genomic_nucleotide_accession_version='NC_000072.6', start_position_on_the_genomic_accession=5725600, end_position_on_the_genomic_accession=6028039, orientation='plus', exon_count=18, OMIM=[], no_hdr0=''),
    13427 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=13427, CurrentID=0, Status='live', Symbol='Dync1i2', Aliases=['3110079H08Rik', 'AW554389', 'Dnci', 'Dncic2'], description='dynein cytoplasmic 1 intermediate chain 2', other_designations='cytoplasmic dynein 1 intermediate chain 2|DH IC-2|dynein intermediate chain 2, cytosolic|dynein, cytoplasmic, intermediate chain 2', map_location='2 42.38 cM', chromosome='2', genomic_nucleotide_accession_version='NC_000068.7', start_position_on_the_genomic_accession=71211676, end_position_on_the_genomic_accession=71263303, orientation='plus', exon_count=20, OMIM=[], no_hdr0=''),
    13429 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=13429, CurrentID=0, Status='live', Symbol='Dnm1', Aliases=['AI838169', 'Dnm', 'Ftf', 'Ftfl', 'mKIAA4093'], description='dynamin 1', other_designations='dynamin-1', map_location='2 22.09 cM', chromosome='2', genomic_nucleotide_accession_version='NC_000068.7', start_position_on_the_genomic_accession=32308471, end_position_on_the_genomic_accession=32353349, orientation='minus', exon_count=27, OMIM=[], no_hdr0=''),
    13430 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=13430, CurrentID=0, Status='live', Symbol='Dnm2', Aliases=['Dyn', 'Dyn2', 'Udnm', 'b2b2159C', 'b2b2159Clo'], description='dynamin 2', other_designations='dynamin-2', map_location='9 7.79 cM', chromosome='9', genomic_nucleotide_accession_version='NC_000075.6', start_position_on_the_genomic_accession=21424908, end_position_on_the_genomic_accession=21507759, orientation='plus', exon_count=25, OMIM=[], no_hdr0=''),
    13433 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=13433, CurrentID=0, Status='live', Symbol='Dnmt1', Aliases=['Cxxc9', 'Dnmto', 'MCMT', 'MTa', 'MTase', 'Met-1', 'Met1', 'MommeD', 'MommeD2', 'm.MmuI', 'Dnmt1'], description='DNA methyltransferase (cytosine-5) 1', other_designations='DNA (cytosine-5)-methyltransferase 1|DNA MTase MmuI|DNA methyltransferase MmuI', map_location='9 7.66 cM', chromosome='9', genomic_nucleotide_accession_version='NC_000075.6', start_position_on_the_genomic_accession=20907206, end_position_on_the_genomic_accession=20959888, orientation='minus', exon_count=41, OMIM=[], no_hdr0=''),
    13434 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=13434, CurrentID=0, Status='live', Symbol='Trdmt1', Aliases=['Dnmt', 'Dnmt2', 'Rnm', 'Rnmt2'], description='tRNA aspartic acid methyltransferase 1', other_designations='tRNA (cytosine(38)-C(5))-methyltransferase|DNA (cytosine-5)-methyltransferase-like protein 2|DNA MTase homolog MmuIIP|DNA methyltransferase 2|DNA methyltransferase homolog MmuIIP|m.MmuIIP|met-2|tRNA (cytosine-5-)-methyltransferase', map_location='2 A1', chromosome='2', genomic_nucleotide_accession_version='NC_000068.7', start_position_on_the_genomic_accession=13504879, end_position_on_the_genomic_accession=13544797, orientation='minus', exon_count=13, OMIM=[], no_hdr0=''),
    13435 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=13435, CurrentID=0, Status='live', Symbol='Dnmt3a', Aliases=['MmuIIIA'], description='DNA methyltransferase 3A', other_designations='DNA (cytosine-5)-methyltransferase 3A|DNA MTase MmuIIIA|DNA methyltransferase MmuIIIA', map_location='12 A1.1', chromosome='12', genomic_nucleotide_accession_version='NC_000078.6', start_position_on_the_genomic_accession=3801559, end_position_on_the_genomic_accession=3914443, orientation='plus', exon_count=30, OMIM=[], no_hdr0=''),
    13436 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=13436, CurrentID=0, Status='live', Symbol='Dnmt3b', Aliases=['MmuIIIB'], description='DNA methyltransferase 3B', other_designations='DNA (cytosine-5)-methyltransferase 3B|DNA MTase MmuIIIB|DNA methyltransferase MmuIIIB', map_location='2 H1', chromosome='2', genomic_nucleotide_accession_version='NC_000068.7', start_position_on_the_genomic_accession=153649411, end_position_on_the_genomic_accession=153687730, orientation='plus', exon_count=25, OMIM=[], no_hdr0=''),
    13437 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=13437, CurrentID=0, Status='live', Symbol='Dnpep', Aliases=['AA407814'], description='aspartyl aminopeptidase', other_designations='aspartyl aminopeptidase', map_location='1 C4', chromosome='1', genomic_nucleotide_accession_version='NC_000067.6', start_position_on_the_genomic_accession=75308565, end_position_on_the_genomic_accession=75317654, orientation='minus', exon_count=16, OMIM=[], no_hdr0=''),
    13445 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=13445, CurrentID=0, Status='live', Symbol='Cdk2ap1', Aliases=['Apc10', 'Cdkap1', 'DOR', 'DORC1', 'Doc', 'Doc1', 'ST1', 'ST19', 'doc-1', 'p1', 'p12'], description='CDK2 (cyclin-dependent kinase 2)-associated protein 1', other_designations='cyclin-dependent kinase 2-associated protein 1|CDK2-associated protein 1|deleted in oral cancer 1|putative oral cancer suppressor', map_location='5 F', chromosome='5', genomic_nucleotide_accession_version='NC_000071.6', start_position_on_the_genomic_accession=124345439, end_position_on_the_genomic_accession=124354628, orientation='minus', exon_count=4, OMIM=[], no_hdr0=''),
    13446 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=13446, CurrentID=0, Status='live', Symbol='Doc2a', Aliases=[], description='double C2, alpha', other_designations='double C2-like domain-containing protein alpha|doc2-alpha', map_location='7 F3', chromosome='7', genomic_nucleotide_accession_version='NC_000073.6', start_position_on_the_genomic_accession=126846983, end_position_on_the_genomic_accession=126852705, orientation='plus', exon_count=11, OMIM=[], no_hdr0=''),
    13447 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=13447, CurrentID=0, Status='live', Symbol='Doc2b', Aliases=[], description='double C2, beta', other_designations='double C2-like domain-containing protein beta|doc2-beta|double C2 protein beta', map_location='11 B5', chromosome='11', genomic_nucleotide_accession_version='NC_000077.6', start_position_on_the_genomic_accession=75768270, end_position_on_the_genomic_accession=75796060, orientation='minus', exon_count=9, OMIM=[], no_hdr0=''),
    13448 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=13448, CurrentID=0, Status='live', Symbol='Dok1', Aliases=['AW557123', 'p62D', 'p62DOK'], description='docking protein 1', other_designations='docking protein 1|downstream of tyrosine kinase 1|p62(dok)', map_location='6 35.94 cM', chromosome='6', genomic_nucleotide_accession_version='NC_000072.6', start_position_on_the_genomic_accession=83030932, end_position_on_the_genomic_accession=83033495, orientation='minus', exon_count=5, OMIM=[], no_hdr0=''),
    13449 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=13449, CurrentID=0, Status='live', Symbol='Dok2', Aliases=['Do', 'DokR', 'F', 'Frip', 'dok-R'], description='docking protein 2', other_designations='docking protein 2|IL-four receptor-interacting protein|dok-related protein|downstream of tyrosine kinase 2|p56(dok-2)', map_location='14 36.71 cM', chromosome='14', genomic_nucleotide_accession_version='NC_000080.6', start_position_on_the_genomic_accession=70765889, end_position_on_the_genomic_accession=70778494, orientation='plus', exon_count=8, OMIM=[], no_hdr0=''),
    13476 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=13476, CurrentID=0, Status='live', Symbol='Reep5', Aliases=['AI324241', 'AU022809', 'AW495741', 'DP1/TB', 'DP1/TB2', 'Dp', 'Dp1', 'R74856', 'TB2/DP', 'TB2/DP1'], description='receptor accessory protein 5', other_designations='receptor expression-enhancing protein 5|GP106|deleted in polyposis 1|polyposis locus protein 1 homolog|protein TB2 homolog', map_location='18 B1', chromosome='18', genomic_nucleotide_accession_version='NC_000084.6', start_position_on_the_genomic_accession=34344885, end_position_on_the_genomic_accession=34374991, orientation='minus', exon_count=5, OMIM=[], no_hdr0=''),
    13478 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=13478, CurrentID=0, Status='live', Symbol='Dpagt1', Aliases=['AU021132', 'Dpag', 'Dpagt2', 'G1PT', 'GP', 'GPT', 'Gn', 'Gnpta'], description='dolichyl-phosphate (UDP-N-acetylglucosamine) acetylglucosaminephosphotransferase 1 (GlcNAc-1-P transferase)', other_designations='UDP-N-acetylglucosamine--dolichyl-phosphate N-acetylglucosaminephosphotransferase|N-acetylglucosamine-1-phosphate transferase|UDP-N-acetylglucosamine lysosomal enzyme N-acetylglucosamine phosphotransferase|dolichyl-phosphate alpha-N-acetylglucosaminephosphotransferase 2', map_location='9 24.84 cM', chromosome='9', genomic_nucleotide_accession_version='NC_000075.6', start_position_on_the_genomic_accession=44325857, end_position_on_the_genomic_accession=44333895, orientation='plus', exon_count=11, OMIM=[], no_hdr0=''),
    13479 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=13479, CurrentID=0, Status='live', Symbol='Dpep1', Aliases=['AI327012', 'DPEP-1', 'MBD'], description='dipeptidase 1', other_designations='dipeptidase 1|MBD-1|beta-lactamase|dipeptidase 1 (renal)|membrane bound dipeptidase type II|membrane-bound dipeptidase 1|microsomal dipeptidase|renal dipeptidase', map_location='8 72.08 cM', chromosome='8', genomic_nucleotide_accession_version='NC_000074.6', start_position_on_the_genomic_accession=123186235, end_position_on_the_genomic_accession=123201812, orientation='plus', exon_count=11, OMIM=[], no_hdr0=''),
    13480 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=13480, CurrentID=0, Status='live', Symbol='Dpm1', Aliases=['AI118379', 'AI194292'], description='dolichol-phosphate (beta-D) mannosyltransferase 1', other_designations='dolichol-phosphate mannosyltransferase subunit 1|DPM synthase subunit 1|MPD synthase|dolichol-phosphate mannose synthase subunit 1|dolichyl-phosphate beta-D-mannosyltransferase subunit 1|mannose-P-dolichol synthase subunit 1', map_location='2 H3', chromosome='2', genomic_nucleotide_accession_version='NC_000068.7', start_position_on_the_genomic_accession=168209048, end_position_on_the_genomic_accession=168230379, orientation='minus', exon_count=9, OMIM=[], no_hdr0=''),
    13481 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=13481, CurrentID=0, Status='live', Symbol='Dpm2', Aliases=['AW557993', 'R75484'], description='dolichol-phosphate (beta-D) mannosyltransferase 2', other_designations='dolichol phosphate-mannose biosynthesis regulatory protein|DPM synthase subunit 2|dolichol-phosphate mannose synthase subunit 2', map_location='2 B', chromosome='2', genomic_nucleotide_accession_version='NC_000068.7', start_position_on_the_genomic_accession=32570858, end_position_on_the_genomic_accession=32573571, orientation='plus', exon_count=4, OMIM=[], no_hdr0=''),
    13482 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=13482, CurrentID=0, Status='live', Symbol='Dpp4', Aliases=['Cd26', 'Dpp', 'Dpp-4', 'THA', 'THAM'], description='dipeptidylpeptidase 4', other_designations='dipeptidyl peptidase 4|DPP IV|T-cell activation antigen CD26|dipeptidyl peptidase IV|thymocyte-activating molecule', map_location='2 35.85 cM', chromosome='2', genomic_nucleotide_accession_version='NC_000068.7', start_position_on_the_genomic_accession=62330073, end_position_on_the_genomic_accession=62412315, orientation='minus', exon_count=30, OMIM=[], no_hdr0=''),
    13483 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=13483, CurrentID=0, Status='live', Symbol='Dpp6', Aliases=['B930011P16Rik', 'D5Buc3', 'D5Buc4', 'D5Buc5', 'DPP VI', 'Dpp', 'Dpp-6', 'Gm1377', 'In(5)6', 'In(5)6H-p', 'Pe', 'Peplb', 'R', 'Rw'], description='dipeptidylpeptidase 6', other_designations='dipeptidyl aminopeptidase-like protein 6|DPPX|dipeptidyl aminopeptidase-related protein|dipeptidyl peptidase IV-like protein|dipeptidyl peptidase VI|dipeptidylpeptidase VI|inversion, Chr 5, Harwell 6, proximal', map_location='5 12.92 cM', chromosome='5', genomic_nucleotide_accession_version='NC_000071.6', start_position_on_the_genomic_accession=26817357, end_position_on_the_genomic_accession=27727500, orientation='plus', exon_count=29, OMIM=[], no_hdr0=''),
    13486 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=13486, CurrentID=0, Status='live', Symbol='Dr1', Aliases=['1700121L09Rik', 'Drl', 'NC', 'NC2', 'NC2be', 'NC2beta', 'Dr1'], description='down-regulator of transcription 1', other_designations='protein Dr1|NC2-beta|TATA-binding protein-associated phosphoprotein|negative cofactor 2-beta', map_location='5 52.82 cM', chromosome='5', genomic_nucleotide_accession_version='NC_000071.6', start_position_on_the_genomic_accession=108268897, end_position_on_the_genomic_accession=108280521, orientation='plus', exon_count=3, OMIM=[], no_hdr0=''),
    13487 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=13487, CurrentID=0, Status='live', Symbol='Slc26a3', Aliases=['9030623B18Rik', '9130013M11Rik', 'AV376035', 'D', 'Dra'], description='solute carrier family 26, member 3', other_designations='chloride anion exchanger|down-regulated in adenoma', map_location='12 13.45 cM', chromosome='12', genomic_nucleotide_accession_version='NC_000078.6', start_position_on_the_genomic_accession=31433142, end_position_on_the_genomic_accession=31473922, orientation='plus', exon_count=23, OMIM=[], no_hdr0=''),
    13488 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=13488, CurrentID=0, Status='live', Symbol='Drd1', Aliases=['C030036C15Rik', 'Drd', 'Drd-', 'Drd-1a', 'Gpcr', 'Gpcr15', 'Drd1'], description='dopamine receptor D1', other_designations='D(1A) dopamine receptor|D1 receptor|D1A dopamine receptor|G protein-coupled receptor DRD1|dopamine D1 receptor|dopamine receptor D1A', map_location='13 28.4 cM', chromosome='13', genomic_nucleotide_accession_version='NC_000079.6', start_position_on_the_genomic_accession=54051183, end_position_on_the_genomic_accession=54055658, orientation='minus', exon_count=3, OMIM=[], no_hdr0=''),
    13489 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=13489, CurrentID=0, Status='live', Symbol='Drd2', Aliases=['D2', 'D2R', 'Drd-', 'Drd-2'], description='dopamine receptor D2', other_designations='D(2) dopamine receptor|dopamine receptor 2', map_location='9 26.72 cM', chromosome='9', genomic_nucleotide_accession_version='NC_000075.6', start_position_on_the_genomic_accession=49340360, end_position_on_the_genomic_accession=49408177, orientation='plus', exon_count=8, OMIM=[], no_hdr0=''),
    13490 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=13490, CurrentID=0, Status='live', Symbol='Drd3', Aliases=['D3', 'D3R'], description='dopamine receptor D3', other_designations='D(3) dopamine receptor|dopamine D3 receptor|dopamine receptor 3', map_location='16 28.44 cM', chromosome='16', genomic_nucleotide_accession_version='NC_000082.6', start_position_on_the_genomic_accession=43754015, end_position_on_the_genomic_accession=43825982, orientation='plus', exon_count=8, OMIM=[], no_hdr0=''),
    13491 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=13491, CurrentID=0, Status='live', Symbol='Drd4', Aliases=['AW125663', 'D4', 'D4R', 'Drd-', 'Drd-4'], description='dopamine receptor D4', other_designations='D(4) dopamine receptor|d(2C) dopamine receptor|dopamine receptor 4', map_location='7 86.6 cM', chromosome='7', genomic_nucleotide_accession_version='NC_000073.6', start_position_on_the_genomic_accession=141291974, end_position_on_the_genomic_accession=141296464, orientation='plus', exon_count=6, OMIM=[], no_hdr0=''),
    13492 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=13492, CurrentID=0, Status='live', Symbol='Drd5', Aliases=['D5', 'D5R', 'DRD1', 'Drd-', 'Drd-5', 'Drd1b', 'Gpc', 'Gpcr1'], description='dopamine receptor D5', other_designations='D(1B) dopamine receptor|d(5) dopamine receptor|dopamine D5 receptor|dopamine receptor 5', map_location='5 20.4 cM', chromosome='5', genomic_nucleotide_accession_version='NC_000071.6', start_position_on_the_genomic_accession=38319509, end_position_on_the_genomic_accession=38322523, orientation='plus', exon_count=1, OMIM=[], no_hdr0=''),
    13494 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=13494, CurrentID=0, Status='live', Symbol='Drg1', Aliases=['AA408859', 'AI132520', 'DRG-1', 'NEDD-3', 'Nedd', 'Nedd3'], description='developmentally regulated GTP binding protein 1', other_designations='developmentally-regulated GTP-binding protein 1|GTP-binding protein|TRAFAC GTPase DRG1|neural precursor cell expressed developmentally down-regulated protein 3|translation factor GTPase DRG1', map_location='11 A1', chromosome='11', genomic_nucleotide_accession_version='NC_000077.6', start_position_on_the_genomic_accession=3249907, end_position_on_the_genomic_accession=3266464, orientation='minus', exon_count=9, OMIM=[], no_hdr0=''),
    13495 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=13495, CurrentID=0, Status='live', Symbol='Drg2', Aliases=['AI255295', 'AI461605', 'DRG-2'], description='developmentally regulated GTP binding protein 2', other_designations='developmentally-regulated GTP-binding protein 2|TRAFAC GTPase DRG2|translation factor GTPase DRG2', map_location='11 37.81 cM', chromosome='11', genomic_nucleotide_accession_version='NC_000077.6', start_position_on_the_genomic_accession=60454587, end_position_on_the_genomic_accession=60468754, orientation='plus', exon_count=13, OMIM=[], no_hdr0=''),
    13496 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=13496, CurrentID=0, Status='live', Symbol='Arid3a', Aliases=['Brig', 'Bright', 'Dr', 'Dri1', 'Dril1'], description='AT rich interactive domain 3A (BRIGHT-like)', other_designations='AT-rich interactive domain-containing protein 3A|ARID domain-containing protein 3A|AT rich interactive domain 3A (Bright like)|B-cell regulator of IgH transcription|dead ringer homolog 1|dead ringer-like protein 1', map_location='10 C1', chromosome='10', genomic_nucleotide_accession_version='NC_000076.6', start_position_on_the_genomic_accession=79927043, end_position_on_the_genomic_accession=79955018, orientation='plus', exon_count=11, OMIM=[], no_hdr0=''),
    13497 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=13497, CurrentID=0, Status='live', Symbol='Drp2', Aliases=['AW495265', 'DRP-2'], description='dystrophin related protein 2', other_designations='dystrophin-related protein 2', map_location='X E3', chromosome='X', genomic_nucleotide_accession_version='NC_000086.7', start_position_on_the_genomic_accession=134404124, end_position_on_the_genomic_accession=134456574, orientation='plus', exon_count=24, OMIM=[], no_hdr0=''),
    13498 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=13498, CurrentID=0, Status='live', Symbol='Atn1', Aliases=['At', 'Atr1', 'D', 'Drpla', 'atro', 'atrophin-1'], description='atrophin 1', other_designations='atrophin-1|dentatorubral pallidoluysian atrophy|dentatorubral-pallidoluysian atrophy protein homolog', map_location='6 59.17 cM', chromosome='6', genomic_nucleotide_accession_version='NC_000072.6', start_position_on_the_genomic_accession=124742544, end_position_on_the_genomic_accession=124756487, orientation='minus', exon_count=10, OMIM=[], no_hdr0=''),
    13505 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=13505, CurrentID=0, Status='live', Symbol='Dsc1', Aliases=['1110020A10Rik', 'AI507491', 'Dsc'], description='desmocollin 1', other_designations='desmocollin-1', map_location='18 A2', chromosome='18', genomic_nucleotide_accession_version='NC_000084.6', start_position_on_the_genomic_accession=20083471, end_position_on_the_genomic_accession=20114773, orientation='minus', exon_count=17, OMIM=[], no_hdr0=''),
    13506 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=13506, CurrentID=0, Status='live', Symbol='Dsc2', Aliases=['AW228162', 'Dsc'], description='desmocollin 2', other_designations='desmocollin-2|epithelial type 2 desmocollin', map_location='18 11.14 cM', chromosome='18', genomic_nucleotide_accession_version='NC_000084.6', start_position_on_the_genomic_accession=20030633, end_position_on_the_genomic_accession=20059554, orientation='minus', exon_count=18, OMIM=[], no_hdr0=''),
    13507 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=13507, CurrentID=0, Status='live', Symbol='Dsc3', Aliases=['5430426I24Rik'], description='desmocollin 3', other_designations='desmocollin-3', map_location='18 11.11 cM', chromosome='18', genomic_nucleotide_accession_version='NC_000084.6', start_position_on_the_genomic_accession=19960930, end_position_on_the_genomic_accession=20002410, orientation='minus', exon_count=18, OMIM=[], no_hdr0=''),
    13508 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=13508, CurrentID=0, Status='live', Symbol='Dscam', Aliases=['4932410A21Rik'], description='DS cell adhesion molecule', other_designations='Down syndrome cell adhesion molecule homolog', map_location='16 57.02 cM', chromosome='16', genomic_nucleotide_accession_version='NC_000082.6', start_position_on_the_genomic_accession=96587452, end_position_on_the_genomic_accession=97171113, orientation='minus', exon_count=34, OMIM=[], no_hdr0=''),
    13510 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=13510, CurrentID=0, Status='live', Symbol='Dsg1a', Aliases=['DG1', 'DGI', 'Dsg', 'Dsg1', 'dsg1-alpha'], description='desmoglein 1 alpha', other_designations='desmoglein-1-alpha|desmosomal glycoprotein I', map_location='18 11.29 cM', chromosome='18', genomic_nucleotide_accession_version='NC_000084.6', start_position_on_the_genomic_accession=20310873, end_position_on_the_genomic_accession=20343353, orientation='plus', exon_count=15, OMIM=[], no_hdr0=''),
    13511 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=13511, CurrentID=0, Status='live', Symbol='Dsg2', Aliases=['AA408168', 'D18Ertd293', 'D18Ertd293e'], description='desmoglein 2', other_designations='desmoglein-2', map_location='18 11.42 cM', chromosome='18', genomic_nucleotide_accession_version='NC_000084.6', start_position_on_the_genomic_accession=20558074, end_position_on_the_genomic_accession=20604526, orientation='plus', exon_count=15, OMIM=[], no_hdr0=''),
    13512 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=13512, CurrentID=0, Status='live', Symbol='Dsg3', Aliases=['bal'], description='desmoglein 3', other_designations='desmoglein-3|130 kDa pemphigus vulgaris antigen homolog', map_location='18 11.39 cM', chromosome='18', genomic_nucleotide_accession_version='NC_000084.6', start_position_on_the_genomic_accession=20510274, end_position_on_the_genomic_accession=20541310, orientation='plus', exon_count=16, OMIM=[], no_hdr0=''),
    13516 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=13516, CurrentID=0, Status='live', Symbol='Epyc', Aliases=['Dsp', 'Dspg3', 'PG-', 'PG-Lb', 'SL', 'SLRR3B', 'epip'], description='epiphycan', other_designations='epiphycan|dermatan sulfate proteoglycan 3|dermatan sulphate proteoglycan 3|proteoglycan-Lb|small chondroitin/dermatan sulfate proteoglycan', map_location='10 50.35 cM', chromosome='10', genomic_nucleotide_accession_version='NC_000076.6', start_position_on_the_genomic_accession=97644068, end_position_on_the_genomic_accession=97681908, orientation='plus', exon_count=8, OMIM=[], no_hdr0=''),
    13518 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=13518, CurrentID=0, Status='live', Symbol='Dst', Aliases=['2310001O04Rik', 'A830042E19Rik', 'AW554249', 'BP230', 'BPAG1-n', 'Bp', 'Bpag', 'Bpag1', 'Macf', 'Macf2', 'a', 'ah', 'athet', 'athetoid', 'dt', 'mKIAA0728', 'nmf20', 'nmf203', 'nmf33', 'nmf339'], description='dystonin', other_designations='dystonin|BPA|dystonia musculorum protein|hemidesmosomal plaque protein|microtubule actin cross-linking factor 2', map_location='1 12.91 cM', chromosome='1', genomic_nucleotide_accession_version='NC_000067.6', start_position_on_the_genomic_accession=33907888, end_position_on_the_genomic_accession=34308662, orientation='plus', exon_count=113, OMIM=[], no_hdr0=''),
    13521 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=13521, CurrentID=0, Status='live', Symbol='Slc26a2', Aliases=['Dtd', 'ST-', 'ST-OB'], description='solute carrier family 26 (sulfate transporter), member 2', other_designations='sulfate transporter|diastrophic dysplasia protein homolog|solute carrier family 26 member 2', map_location='18 E1', chromosome='18', genomic_nucleotide_accession_version='NC_000084.6', start_position_on_the_genomic_accession=61196854, end_position_on_the_genomic_accession=61211596, orientation='minus', exon_count=4, OMIM=[], no_hdr0=''),
    13522 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=13522, CurrentID=0, Status='live', Symbol='Adam28', Aliases=['C130072N01Rik', 'D430033C21Rik', 'Dtgn', 'Dtgn1', 'MDC-', 'MDC-L', 'MDCL', 'TECADAM', 'eMDCII'], description='a disintegrin and metallopeptidase domain 28', other_designations='disintegrin and metalloproteinase domain-containing protein 28|ADAM 28|a disintegrin and metalloprotease domain 28|a disintegrin and metalloproteinase domain 28|disintegrin 1|metalloproteinase-disintegrin domain containing protein TECADAM|thymic epithelial cell-ADAM', map_location='14 D1', chromosome='14', genomic_nucleotide_accession_version='NC_000080.6', start_position_on_the_genomic_accession=68604998, end_position_on_the_genomic_accession=68655889, orientation='minus', exon_count=24, OMIM=[], no_hdr0=''),
    13524 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=13524, CurrentID=0, Status='live', Symbol='Adam18', Aliases=['Adam', 'Adam27', 'Dtgn', 'Dtgn3', 'Tmdc3', 'tMDCIII'], description='a disintegrin and metallopeptidase domain 18', other_designations='disintegrin and metalloproteinase domain-containing protein 18|disintegrin 3|disintegrin and metalloproteinase domain-containing protein 27|transmembrane metalloproteinase-like, disintegrin-like, and cysteine-rich protein III', map_location='8 A2', chromosome='8', genomic_nucleotide_accession_version='NC_000074.6', start_position_on_the_genomic_accession=24602246, end_position_on_the_genomic_accession=24674755, orientation='minus', exon_count=20, OMIM=[], no_hdr0=''),
    13525 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=13525, CurrentID=0, Status='live', Symbol='Adam26a', Aliases=['Adam', 'Adam26', 'Dtgn', 'Dtgn4'], description='a disintegrin and metallopeptidase domain 26A (testase 3)', other_designations='disintegrin and metalloproteinase domain-containing protein 26A|a disintegrin and metalloprotease domain 26|disintegrin 4|testase 3', map_location='8 A4', chromosome='8', genomic_nucleotide_accession_version='NC_000074.6', start_position_on_the_genomic_accession=43568273, end_position_on_the_genomic_accession=43576707, orientation='minus', exon_count=2, OMIM=[], no_hdr0=''),
    13526 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=13526, CurrentID=0, Status='live', Symbol='Adam24', Aliases=['Dtgn', 'Dtgn5'], description='a disintegrin and metallopeptidase domain 24 (testase 1)', other_designations='disintegrin and metalloproteinase domain-containing protein 24|a disintegrin and metalloproteinase domain 24 (testase 1)|disintegrin 5', map_location='8 A4', chromosome='8', genomic_nucleotide_accession_version='NC_000074.6', start_position_on_the_genomic_accession=40675077, end_position_on_the_genomic_accession=40682199, orientation='plus', exon_count=3, OMIM=[], no_hdr0=''),
    13527 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=13527, CurrentID=0, Status='live', Symbol='Dtna', Aliases=['2210407P21Rik', 'A', 'DTN-A', 'Dt', 'Dtn', 'Gm19389', 'a-DB-', 'a-DB-1', 'ad', 'adbn'], description='dystrobrevin alpha', other_designations='dystrobrevin alpha|alpha-dystrobrevin', map_location='18 12.08 cM', chromosome='18', genomic_nucleotide_accession_version='NC_000084.6', start_position_on_the_genomic_accession=23310006, end_position_on_the_genomic_accession=23659719, orientation='plus', exon_count=32, OMIM=[], no_hdr0=''),
    13528 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=13528, CurrentID=0, Status='live', Symbol='Dtnb', Aliases=[], description='dystrobrevin, beta', other_designations='dystrobrevin beta|DTN-B|beta-dystrobrevin|mDTN-B', map_location='12 1.88 cM', chromosome='12', genomic_nucleotide_accession_version='NC_000078.6', start_position_on_the_genomic_accession=3572372, end_position_on_the_genomic_accession=3785486, orientation='plus', exon_count=23, OMIM=[], no_hdr0=''),
    13529 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=13529, CurrentID=0, Status='live', Symbol='Prl8a2', Aliases=['D', 'D/t', 'D/tPRP', 'DPRP', 'Dt', 'Dtprp', 'Ghd11', 'md', 'mdPRP'], description='prolactin family 8, subfamily a, member 2', other_designations='prolactin family 8, subfamily a, member 2|decidual/trophoblast prolactin-related protein|growth hormone d11', map_location='13 12.41 cM', chromosome='13', genomic_nucleotide_accession_version='NC_000079.6', start_position_on_the_genomic_accession=27345673, end_position_on_the_genomic_accession=27354216, orientation='plus', exon_count=6, OMIM=[], no_hdr0=''),
    13531 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=13531, CurrentID=0, Status='live', Symbol='Usp17la', Aliases=['Dub1', 'USP17-A'], description='ubiquitin specific peptidase 17-like A', other_designations='ubiquitin carboxyl-terminal hydrolase 17-like protein A|deubiquitinating enzyme 1|ubiquitin carboxyl-terminal hydrolase DUB-1|ubiquitin thioesterase DUB-1|ubiquitin thiolesterase DUB-1|ubiquitin-specific-processing protease DUB-1', map_location='7 55.69 cM', chromosome='7', genomic_nucleotide_accession_version='NC_000073.6', start_position_on_the_genomic_accession=104857016, end_position_on_the_genomic_accession=104862667, orientation='plus', exon_count=3, OMIM=[], no_hdr0=''),
    13532 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=13532, CurrentID=0, Status='live', Symbol='Usp17lc', Aliases=['Dub-2', 'Dub2', 'Dub2b', 'Usp1', 'Usp17l5'], description='ubiquitin specific peptidase 17-like C', other_designations='ubiquitin carboxyl-terminal hydrolase 17-like protein C|deubiquitinating enzyme 2|ubiquitin specific peptidase 17-like 5', map_location='7 54.85 cM', chromosome='7', genomic_nucleotide_accession_version='NC_000073.6', start_position_on_the_genomic_accession=103416696, end_position_on_the_genomic_accession=103419174, orientation='plus', exon_count=2, OMIM=[], no_hdr0=''),
    13537 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=13537, CurrentID=0, Status='live', Symbol='Dusp2', Aliases=['PA', 'PAC1'], description='dual specificity phosphatase 2', other_designations='dual specificity protein phosphatase 2|dual specificity protein phosphatase PAC-1', map_location='2 F1', chromosome='2', genomic_nucleotide_accession_version='NC_000068.7', start_position_on_the_genomic_accession=127336159, end_position_on_the_genomic_accession=127338377, orientation='plus', exon_count=4, OMIM=[], no_hdr0=''),
    13542 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=13542, CurrentID=0, Status='live', Symbol='Dvl1', Aliases=['Dvl', 'mKIAA4029'], description='dishevelled segment polarity protein 1', other_designations='segment polarity protein dishevelled homolog DVL-1|DSH homolog 1|dishevelled, dsh homolog 1|dishevelled-1', map_location='4 87.61 cM', chromosome='4', genomic_nucleotide_accession_version='NC_000070.6', start_position_on_the_genomic_accession=155847402, end_position_on_the_genomic_accession=155859303, orientation='plus', exon_count=17, OMIM=[], no_hdr0=''),
    13543 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=13543, CurrentID=0, Status='live', Symbol='Dvl2', Aliases=[], description='dishevelled segment polarity protein 2', other_designations='segment polarity protein dishevelled homolog DVL-2|DSH homolog 2|dishevelled 2, dsh homolog|dishevelled-2', map_location='11 42.96 cM', chromosome='11', genomic_nucleotide_accession_version='NC_000077.6', start_position_on_the_genomic_accession=70000592, end_position_on_the_genomic_accession=70010109, orientation='plus', exon_count=15, OMIM=[], no_hdr0=''),
    13544 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=13544, CurrentID=0, Status='live', Symbol='Dvl3', Aliases=['b2b2866C', 'b2b2866Clo'], description='dishevelled segment polarity protein 3', other_designations='segment polarity protein dishevelled homolog DVL-3|dishevelled 3, dsh homolog', map_location='16 12.46 cM', chromosome='16', genomic_nucleotide_accession_version='NC_000082.6', start_position_on_the_genomic_accession=20516949, end_position_on_the_genomic_accession=20534013, orientation='plus', exon_count=15, OMIM=[], no_hdr0=''),
    13548 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=13548, CurrentID=0, Status='live', Symbol='Dyrk1a', Aliases=['2310043O08Rik', 'D16Ertd272', 'D16Ertd272e', 'D16Ertd493', 'D16Ertd493e', 'Dyr', 'Dyrk', 'Gm10783', 'Mnb', 'Mnbh', 'Mp86', 'mmb'], description='dual-specificity tyrosine-(Y)-phosphorylation regulated kinase 1a', other_designations='dual specificity tyrosine-phosphorylation-regulated kinase 1A|dual specificity YAK1-related kinase|protein kinase minibrain homolog', map_location='16 55.3 cM', chromosome='16', genomic_nucleotide_accession_version='NC_000082.6', start_position_on_the_genomic_accession=94569947, end_position_on_the_genomic_accession=94695519, orientation='plus', exon_count=15, OMIM=[], no_hdr0=''),
    13549 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=13549, CurrentID=0, Status='live', Symbol='Dyrk1b', Aliases=['Mi', 'Mirk'], description='dual-specificity tyrosine-(Y)-phosphorylation regulated kinase 1b', other_designations='dual specificity tyrosine-phosphorylation-regulated kinase 1B', map_location='7 A3', chromosome='7', genomic_nucleotide_accession_version='NC_000073.6', start_position_on_the_genomic_accession=28179447, end_position_on_the_genomic_accession=28197910, orientation='plus', exon_count=13, OMIM=[], no_hdr0=''),
    13555 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=13555, CurrentID=0, Status='live', Symbol='E2f1', Aliases=['E2F-1', 'Tg(Wnt1-cre)2Sor', 'mKIAA4009'], description='E2F transcription factor 1', other_designations='transcription factor E2F1', map_location='2 76.79 cM', chromosome='2', genomic_nucleotide_accession_version='NC_000068.7', start_position_on_the_genomic_accession=154559400, end_position_on_the_genomic_accession=154569892, orientation='minus', exon_count=8, OMIM=[], no_hdr0=''),
    13557 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=13557, CurrentID=0, Status='live', Symbol='E2f3', Aliases=['E2F3ba', 'E2f3'], description='E2F transcription factor 3', other_designations='transcription factor E2F3', map_location='13 A3.2', chromosome='13', genomic_nucleotide_accession_version='NC_000079.6', start_position_on_the_genomic_accession=29906575, end_position_on_the_genomic_accession=29986064, orientation='minus', exon_count=8, OMIM=[], no_hdr0=''),
    13559 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=13559, CurrentID=0, Status='live', Symbol='E2f5', Aliases=['AU024671', 'E2F-5'], description='E2F transcription factor 5', other_designations='transcription factor E2F5', map_location='3 A1', chromosome='3', genomic_nucleotide_accession_version='NC_000069.6', start_position_on_the_genomic_accession=14578602, end_position_on_the_genomic_accession=14606309, orientation='plus', exon_count=9, OMIM=[], no_hdr0=''),
    13560 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=13560, CurrentID=0, Status='live', Symbol='E4f1', Aliases=['p120E4F', 'phi-AP3'], description='E4F transcription factor 1', other_designations='transcription factor E4F1|RING-type E3 ubiquitin transferase E4F1|putative E3 ubiquitin-protein ligase E4F1|transcription factor E4F|transcription factor phi AP3', map_location='17 12.39 cM', chromosome='17', genomic_nucleotide_accession_version='NC_000083.6', start_position_on_the_genomic_accession=24443778, end_position_on_the_genomic_accession=24455392, orientation='minus', exon_count=14, OMIM=[], no_hdr0=''),
    13586 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=13586, CurrentID=0, Status='live', Symbol='Ear1', Aliases=['EAR-1', 'ECP 1', 'Raf1'], description='eosinophil-associated, ribonuclease A family, member 1', other_designations='eosinophil cationic protein 1|RNase 3-1|eosinophil secondary granule ribonuclease 1|eosinophil-associated ribonuclease 1|ribonuclease 3-1|ribonuclease A f1', map_location='14 C1', chromosome='14', genomic_nucleotide_accession_version='NC_000080.6', start_position_on_the_genomic_accession=43818765, end_position_on_the_genomic_accession=43819639, orientation='minus', exon_count=2, OMIM=[], no_hdr0=''),
    13587 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=13587, CurrentID=0, Status='live', Symbol='Ear2', Aliases=['EAR-13', 'EAR-2', 'ECP', 'ECP 2', 'Raf3', 'Rn', 'Rnase2'], description='eosinophil-associated, ribonuclease A family, member 2', other_designations='eosinophil cationic protein 2|RNase 3-2|eosinophil secondary granule ribonuclease 2|eosinophil-associated ribonuclease 13|eosinophil-associated ribonuclease 2|eosinophil-derived neurotoxin, liver|ribonuclease 3-2|ribonuclease A f3', map_location='14 C1', chromosome='14', genomic_nucleotide_accession_version='NC_000080.6', start_position_on_the_genomic_accession=44102654, end_position_on_the_genomic_accession=44103531, orientation='plus', exon_count=2, OMIM=[], no_hdr0=''),
    13589 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=13589, CurrentID=0, Status='live', Symbol='Mapre1', Aliases=['5530600P05Rik', 'AI462499', 'AI504412', 'AW260097', 'BIM', 'BIM1p', 'D2Ertd459', 'D2Ertd459e', 'Eb1'], description='microtubule-associated protein, RP/EB family, member 1', other_designations='microtubule-associated protein RP/EB family member 1|APC-binding protein EB1|adenomatosis polyposis coli binding protein Eb1|end-binding protein 1', map_location='2 75.95 cM', chromosome='2', genomic_nucleotide_accession_version='NC_000068.7', start_position_on_the_genomic_accession=153741287, end_position_on_the_genomic_accession=153773317, orientation='plus', exon_count=7, OMIM=[], no_hdr0=''),
    13590 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=13590, CurrentID=0, Status='live', Symbol='Lefty1', Aliases=['AI450052', 'Eba', 'Ebaf', 'Left', 'Leftb', 'St', 'Stra3', 'Tgfb4', 'lefty', 'lefty-', 'lefty-1'], description='left right determination factor 1', other_designations='left-right determination factor 1|TGF-beta-4|left-right determination, factor B|protein lefty-1|stimulated by retinoic acid gene 3 protein|transforming growth factor beta-4', map_location='1 H4', chromosome='1', genomic_nucleotide_accession_version='NC_000067.6', start_position_on_the_genomic_accession=180935022, end_position_on_the_genomic_accession=180938401, orientation='plus', exon_count=4, OMIM=[], no_hdr0=''),
    13591 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=13591, CurrentID=0, Status='live', Symbol='Ebf1', Aliases=['Ebf', 'O/E-', 'O/E-1', 'OE-1', 'Ol', 'Olf', 'Olf-1', 'Olf1'], description='early B cell factor 1', other_designations='transcription factor COE1|early B-cell factor', map_location='11 26.45 cM', chromosome='11', genomic_nucleotide_accession_version='NC_000077.6', start_position_on_the_genomic_accession=44618100, end_position_on_the_genomic_accession=45008096, orientation='plus', exon_count=18, OMIM=[], no_hdr0=''),
    13592 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=13592, CurrentID=0, Status='live', Symbol='Ebf2', Aliases=['D14Ggc1e', 'EBF-2', 'Mmot', 'Mmot1', 'O/E-', 'O/E-3', 'OE-3'], description='early B cell factor 2', other_designations='transcription factor COE2|MET-mesencephalon-olfactory TF1|MET-mesencephalon-olfactory transcription factor 1|Olf-1/EBF-like 3|metencephalon-mesencephalon-olfactory transcription factor 1', map_location='14 D1', chromosome='14', genomic_nucleotide_accession_version='NC_000080.6', start_position_on_the_genomic_accession=67233292, end_position_on_the_genomic_accession=67430952, orientation='plus', exon_count=17, OMIM=[], no_hdr0=''),
    13593 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=13593, CurrentID=0, Status='live', Symbol='Ebf3', Aliases=['3110018A08Rik', 'O/E-', 'O/E-2', 'mKIAA4201'], description='early B cell factor 3', other_designations='transcription factor COE3|EBF-3|OE-2|Olf-1/EBF-like 2', map_location='7 F3', chromosome='7', genomic_nucleotide_accession_version='NC_000073.6', start_position_on_the_genomic_accession=137193671, end_position_on_the_genomic_accession=137322805, orientation='minus', exon_count=19, OMIM=[], no_hdr0=''),
    13595 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=13595, CurrentID=0, Status='live', Symbol='Ebp', Aliases=['AI255399', 'P', 'Pabp', 'SI', 'Td', 'm', 'mSI'], description='phenylalkylamine Ca2+ antagonist (emopamil) binding protein', other_designations='3-beta-hydroxysteroid-Delta(8),Delta(7)-isomerase|D8-D7 sterol isomerase|cholestenol Delta-isomerase|delta(8)-Delta(7) sterol isomerase|tattered', map_location='X 3.7 cM', chromosome='X', genomic_nucleotide_accession_version='NC_000086.7', start_position_on_the_genomic_accession=8185329, end_position_on_the_genomic_accession=8193512, orientation='minus', exon_count=5, OMIM=[], no_hdr0=''),
    13599 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=13599, CurrentID=0, Status='live', Symbol='Ecel1', Aliases=['DI', 'DINE', 'xce'], description='endothelin converting enzyme-like 1', other_designations='endothelin-converting enzyme-like 1|damage-induced neuronal endopeptidase', map_location='1 C5', chromosome='1', genomic_nucleotide_accession_version='NC_000067.6', start_position_on_the_genomic_accession=87142874, end_position_on_the_genomic_accession=87157085, orientation='minus', exon_count=24, OMIM=[], no_hdr0=''),
    13601 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=13601, CurrentID=0, Status='live', Symbol='Ecm1', Aliases=['AI663821', 'p8', 'p85'], description='extracellular matrix protein 1', other_designations='extracellular matrix protein 1|secretory component p85', map_location='3 40.91 cM', chromosome='3', genomic_nucleotide_accession_version='NC_000069.6', start_position_on_the_genomic_accession=95734147, end_position_on_the_genomic_accession=95739876, orientation='minus', exon_count=11, OMIM=[], no_hdr0=''),
    13602 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=13602, CurrentID=0, Status='live', Symbol='Sparcl1', Aliases=['Ecm2', 'Sc', 'Sc1', 'he', 'hevin', 'mas', 'mast9'], description='SPARC-like 1', other_designations='SPARC-like protein 1|SPARC-like 1 (mast9, hevin)|extracellular matrix protein 2|matrix glycoprotein Sc1', map_location='5 50.55 cM', chromosome='5', genomic_nucleotide_accession_version='NC_000071.6', start_position_on_the_genomic_accession=104079108, end_position_on_the_genomic_accession=104114088, orientation='minus', exon_count=13, OMIM=[], no_hdr0=''),
    13603 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=13603, CurrentID=0, Status='live', Symbol='Opn3', Aliases=['E', 'ERO', 'Ec', 'Ecpn'], description='opsin 3', other_designations='opsin-3|encephalopsin|opsin (encephalopsin)|panopsin', map_location='1 H3', chromosome='1', genomic_nucleotide_accession_version='NC_000067.6', start_position_on_the_genomic_accession=175662421, end_position_on_the_genomic_accession=175692901, orientation='minus', exon_count=5, OMIM=[], no_hdr0=''),
    13605 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=13605, CurrentID=0, Status='live', Symbol='Ect2', Aliases=['AI528536'], description='ect2 oncogene', other_designations='protein ECT2|epithelial cell-transforming sequence 2 oncogene', map_location='3 A3', chromosome='3', genomic_nucleotide_accession_version='NC_000069.6', start_position_on_the_genomic_accession=27097222, end_position_on_the_genomic_accession=27154253, orientation='minus', exon_count=25, OMIM=[], no_hdr0=''),
    13607 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=13607, CurrentID=0, Status='live', Symbol='Eda', Aliases=['EDA1', 'Ed1-', 'Eda-A1', 'Eda-A2', 'HED', 'Ta', 'Tnlg7c', 'XLHED', 'tabby', 'Eda'], description='ectodysplasin-A', other_designations='ectodysplasin-A|EDA protein homolog|tumor necrosis factor ligand 7c', map_location='X 43.59 cM', chromosome='X', genomic_nucleotide_accession_version='NC_000086.7', start_position_on_the_genomic_accession=99975606, end_position_on_the_genomic_accession=100400760, orientation='plus', exon_count=9, OMIM=[], no_hdr0=''),
    13608 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=13608, CurrentID=0, Status='live', Symbol='Edar', Aliases=['ED1R', 'ED3', 'ED5', 'EDA-A1R', 'EDA3', 'dl'], description='ectodysplasin-A receptor', other_designations='tumor necrosis factor receptor superfamily member EDAR|anhidrotic ectodysplasin receptor 1|downless|ectodermal dysplasia receptor', map_location='10 29.37 cM', chromosome='10', genomic_nucleotide_accession_version='NC_000076.6', start_position_on_the_genomic_accession=58600780, end_position_on_the_genomic_accession=58675696, orientation='minus', exon_count=13, OMIM=[], no_hdr0=''),
    13609 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=13609, CurrentID=0, Status='live', Symbol='S1pr1', Aliases=['AI849002', 'Edg1', 'Lpb1', 'S', 'S1', 'S1p', 'S1p1'], description='sphingosine-1-phosphate receptor 1', other_designations='sphingosine 1-phosphate receptor 1|S1P receptor 1|S1P receptor Edg-1|endothelial differentiation G-protein coupled receptor 1|endothelial differentiation sphingolipid G-protein-coupled receptor 1|lysophospholipid receptor B1|sphingosine 1-phosphate receptor Edg-1', map_location='3 G1', chromosome='3', genomic_nucleotide_accession_version='NC_000069.6', start_position_on_the_genomic_accession=115710433, end_position_on_the_genomic_accession=115715055, orientation='minus', exon_count=2, OMIM=[], no_hdr0=''),
    13610 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=13610, CurrentID=0, Status='live', Symbol='S1pr3', Aliases=['AI132464', 'Edg3', 'LP', 'Lpb3', 'S1', 'S1p3'], description='sphingosine-1-phosphate receptor 3', other_designations='sphingosine 1-phosphate receptor 3|S1P receptor Edg-3|S1p receptor 3|endothelial differentiation G-protein coupled receptor 3|endothelial differentiation sphingolipid G-protein-coupled receptor 3|lysophospholipid receptor B3|sphingosine 1-phosphate receptor Edg-3', map_location='13 A5', chromosome='13', genomic_nucleotide_accession_version='NC_000079.6', start_position_on_the_genomic_accession=51408618, end_position_on_the_genomic_accession=51422797, orientation='plus', exon_count=2, OMIM=[], no_hdr0=''),
    13611 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=13611, CurrentID=0, Status='live', Symbol='S1pr4', Aliases=['Edg6', 'Lpc1', 'S1', 'S1p4', 'lp'], description='sphingosine-1-phosphate receptor 4', other_designations='sphingosine 1-phosphate receptor 4|S1P receptor Edg-6|S1p receptor 4|endothelial differentiation G-protein-coupled receptor 6|lysophospholipid receptor C1|sphingosine 1-phosphate receptor Edg-6', map_location='10 C1', chromosome='10', genomic_nucleotide_accession_version='NC_000076.6', start_position_on_the_genomic_accession=81497745, end_position_on_the_genomic_accession=81500137, orientation='minus', exon_count=1, OMIM=[], no_hdr0=''),
    13612 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=13612, CurrentID=0, Status='live', Symbol='Edil3', Aliases=['Del', 'Del-', 'Del-1', 'Del1', 'Sox2-cre', 'Sox2Cre', 'Tg(Sox2-cre)1Amc'], description='EGF-like repeats and discoidin I-like domains 3', other_designations='EGF-like repeat and discoidin I-like domain-containing protein 3|developmental endothelial locus-1|developmentally-regulated endothelial cell locus 1 protein|integrin-binding protein DEL1', map_location='13 C3', chromosome='13', genomic_nucleotide_accession_version='NC_000079.6', start_position_on_the_genomic_accession=88821472, end_position_on_the_genomic_accession=89323225, orientation='plus', exon_count=11, OMIM=[], no_hdr0=''),
    13614 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=13614, CurrentID=0, Status='live', Symbol='Edn1', Aliases=['ET-1', 'PPET1', 'preproET'], description='endothelin 1', other_designations='endothelin-1|preproendothelin-1', map_location='13 20.82 cM', chromosome='13', genomic_nucleotide_accession_version='NC_000079.6', start_position_on_the_genomic_accession=42301476, end_position_on_the_genomic_accession=42307990, orientation='plus', exon_count=5, OMIM=[], no_hdr0=''),
    13615 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=13615, CurrentID=0, Status='live', Symbol='Edn2', Aliases=['ET-2', 'PPET2', 'V', 'VIC'], description='endothelin 2', other_designations='endothelin-2|preproendothelin-2|vasoactive intestinal contractor peptide', map_location='4 D2.1', chromosome='4', genomic_nucleotide_accession_version='NC_000070.6', start_position_on_the_genomic_accession=120161206, end_position_on_the_genomic_accession=120167360, orientation='plus', exon_count=5, OMIM=[], no_hdr0=''),
    13616 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=13616, CurrentID=0, Status='live', Symbol='Edn3', Aliases=['ET-3', 'PPET3', 'ls', 'tmgc48'], description='endothelin 3', other_designations='endothelin-3|preproendothelin-3', map_location='2 98.1 cM', chromosome='2', genomic_nucleotide_accession_version='NC_000068.7', start_position_on_the_genomic_accession=174760619, end_position_on_the_genomic_accession=174784042, orientation='plus', exon_count=5, OMIM=[], no_hdr0=''),
    13617 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=13617, CurrentID=0, Status='live', Symbol='Ednra', Aliases=['AEA0', 'AEA001', 'ET', 'ET-', 'ET-AR', 'ETa', 'Gpcr', 'Gpcr10', 'Mhdaa', 'Mhdaaea1'], description='endothelin receptor type A', other_designations='endothelin-1 receptor|ET-A|G-protein coupled receptor 10|endothelin A receptor', map_location='8 C1', chromosome='8', genomic_nucleotide_accession_version='NC_000074.6', start_position_on_the_genomic_accession=77663029, end_position_on_the_genomic_accession=77724452, orientation='minus', exon_count=8, OMIM=[], no_hdr0=''),
    13618 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=13618, CurrentID=0, Status='live', Symbol='Ednrb', Aliases=['ET-B', 'ET-BR', 'ETR-', 'ETR-b', 'ETb', 'Sox10', 'Sox10m1'], description='endothelin receptor type B', other_designations='endothelin receptor type B|endothelin B receptor|endothelin receptor non-selective type|piebald', map_location='14 53.05 cM', chromosome='14', genomic_nucleotide_accession_version='NC_000080.6', start_position_on_the_genomic_accession=103814615, end_position_on_the_genomic_accession=103844508, orientation='minus', exon_count=9, OMIM=[], no_hdr0=''),
    13619 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=13619, CurrentID=0, Status='live', Symbol='Phc1', Aliases=['AW557034', 'Edr', 'Edr1', 'Mph', 'Mph1', 'Rae-', 'Rae-28', 'rae', 'rae28'], description='polyhomeotic 1', other_designations='polyhomeotic-like protein 1|early development regulator1 (homolog of polyhomeotic 1)|early development regulatory protein 1|polyhomeotic-like 1', map_location='6 57.52 cM', chromosome='6', genomic_nucleotide_accession_version='NC_000072.6', start_position_on_the_genomic_accession=122317731, end_position_on_the_genomic_accession=122340227, orientation='minus', exon_count=19, OMIM=[], no_hdr0=''),
    13626 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=13626, CurrentID=0, Status='live', Symbol='Eed', Aliases=['l(7)', 'l(7)5Rn', 'l7', 'l7Rn5', 'lusk'], description='embryonic ectoderm development', other_designations='polycomb protein EED|lethal, Chr 7, Rinchik 5', map_location='7', chromosome='7', genomic_nucleotide_accession_version='NC_000073.6', start_position_on_the_genomic_accession=89954654, end_position_on_the_genomic_accession=89980976, orientation='minus', exon_count=12, OMIM=[], no_hdr0=''),
    13627 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=13627, CurrentID=0, Status='live', Symbol='Eef1a1', Aliases=[], description='eukaryotic translation elongation factor 1 alpha 1', other_designations='elongation factor 1-alpha 1|EF-1-alpha-1|EF-Tu|eEF1A-1|elongation factor 1 A-1|elongation factor Tu|eukaryotic elongation factor 1 A-1', map_location='9 E1', chromosome='9', genomic_nucleotide_accession_version='NC_000075.6', start_position_on_the_genomic_accession=78478453, end_position_on_the_genomic_accession=78481724, orientation='minus', exon_count=8, OMIM=[], no_hdr0=''),
    13628 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=13628, CurrentID=0, Status='live', Symbol='Eef1a2', Aliases=['EEF1AL', 'EF-1-alpha-2', 'Eef1', 'Eef1a', 'S', 'S1', 'STN', 'wasted', 'wst'], description='eukaryotic translation elongation factor 1 alpha 2', other_designations='elongation factor 1-alpha 2|eukaryotic elongation factor 1 A-2|statin-S1', map_location='2 103.6 cM', chromosome='2', genomic_nucleotide_accession_version='NC_000068.7', start_position_on_the_genomic_accession=181141758, end_position_on_the_genomic_accession=181157015, orientation='minus', exon_count=8, OMIM=[], no_hdr0=''),
    13629 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=13629, CurrentID=0, Status='live', Symbol='Eef2', Aliases=['Ef-2'], description='eukaryotic translation elongation factor 2', other_designations='elongation factor 2', map_location='10 C1', chromosome='10', genomic_nucleotide_accession_version='NC_000076.6', start_position_on_the_genomic_accession=81176631, end_position_on_the_genomic_accession=81182509, orientation='plus', exon_count=14, OMIM=[], no_hdr0=''),
    13631 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=13631, CurrentID=0, Status='live', Symbol='Eef2k', Aliases=['C86191', 'eEF-2K'], description='eukaryotic elongation factor-2 kinase', other_designations='eukaryotic elongation factor 2 kinase|calcium/calmodulin-dependent eukaryotic elongation factor 2 kinase|eEF-2 kinase|eukaroytic elongation factor 2 kinase', map_location='7 F2', chromosome='7', genomic_nucleotide_accession_version='NC_000073.6', start_position_on_the_genomic_accession=120842642, end_position_on_the_genomic_accession=120907219, orientation='plus', exon_count=21, OMIM=[], no_hdr0=''),
    13636 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=13636, CurrentID=0, Status='live', Symbol='Efna1', Aliases=['AI325262', 'B61', 'EFL-', 'Efl1', 'Ep', 'Epl', 'Epl1', 'Eplg1', 'LERK', 'Ler', 'Lerk1'], description='ephrin A1', other_designations='ephrin-A1|EPH-related receptor tyrosine kinase ligand 1|immediate early response protein B61', map_location='3 39.04 cM', chromosome='3', genomic_nucleotide_accession_version='NC_000069.6', start_position_on_the_genomic_accession=89271730, end_position_on_the_genomic_accession=89280951, orientation='minus', exon_count=6, OMIM=[], no_hdr0=''),
    13637 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=13637, CurrentID=0, Status='live', Symbol='Efna2', Aliases=['CEK7L', 'Cek7-', 'Elf-', 'Elf1', 'Ep', 'Ephr', 'Epl6', 'Eplg6', 'LERK', 'Lerk6'], description='ephrin A2', other_designations='ephrin-A2|CEK7-ligand|EPH related receptor tyrosine kinase ligand 6|ephrin A6', map_location='10 39.72 cM', chromosome='10', genomic_nucleotide_accession_version='NC_000076.6', start_position_on_the_genomic_accession=80179482, end_position_on_the_genomic_accession=80190010, orientation='plus', exon_count=4, OMIM=[], no_hdr0=''),
    13638 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=13638, CurrentID=0, Status='live', Symbol='Efna3', Aliases=['AW494418', 'EFL-', 'EFL-2', 'Ehk1-', 'Ehk1-L', 'Ep', 'Epl3', 'LERK', 'LERK-3'], description='ephrin A3', other_designations='ephrin-A3|EHK1 ligand|EPH-related receptor tyrosine kinase ligand 3', map_location='3 39.06 cM', chromosome='3', genomic_nucleotide_accession_version='NC_000069.6', start_position_on_the_genomic_accession=89313899, end_position_on_the_genomic_accession=89322939, orientation='minus', exon_count=6, OMIM=[], no_hdr0=''),
    13639 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=13639, CurrentID=0, Status='live', Symbol='Efna4', Aliases=['EFL-', 'EFL-4', 'Ep', 'Epl4', 'LERK', 'LERK-4'], description='ephrin A4', other_designations='ephrin-A4|EPH-related receptor tyrosine kinase ligand 4', map_location='3 39.07 cM', chromosome='3', genomic_nucleotide_accession_version='NC_000069.6', start_position_on_the_genomic_accession=89333393, end_position_on_the_genomic_accession=89338028, orientation='minus', exon_count=4, OMIM=[], no_hdr0=''),
    13640 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=13640, CurrentID=0, Status='live', Symbol='Efna5', Aliases=['AL', 'AL-1', 'AV158822', 'EFL-', 'EFL-5', 'Ep', 'Ephr', 'Ephrin-A5', 'Epl7', 'LERK', 'LERK-7', 'R', 'RAGS'], description='ephrin A5', other_designations='ephrin-A5|EPH-related receptor tyrosine kinase ligand 7', map_location='17 32.57 cM', chromosome='17', genomic_nucleotide_accession_version='NC_000083.6', start_position_on_the_genomic_accession=62602957, end_position_on_the_genomic_accession=62881317, orientation='minus', exon_count=8, OMIM=[], no_hdr0=''),
    13641 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=13641, CurrentID=0, Status='live', Symbol='Efnb1', Aliases=['Cek5-', 'Cek5-L', 'EFL-', 'EFL-3', 'Elk', 'Elk-L', 'Ep', 'Epl', 'Epl2', 'Eplg2', 'LERK', 'LERK-2', 'Ler', 'Lerk2', 'St', 'Stra1'], description='ephrin B1', other_designations='ephrin-B1|CEK5 receptor ligand|Cek ligand|ELK ligand|EPH-related receptor tyrosine kinase ligand 2|stimulated by retinoic acid gene 1 protein', map_location='X 43.22 cM', chromosome='X', genomic_nucleotide_accession_version='NC_000086.7', start_position_on_the_genomic_accession=99136061, end_position_on_the_genomic_accession=99149022, orientation='plus', exon_count=5, OMIM=[], no_hdr0=''),
    13642 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=13642, CurrentID=0, Status='live', Symbol='Efnb2', Aliases=['ELF-', 'ELF-2', 'Ep', 'Epl', 'Epl5', 'Eplg5', 'Htk-', 'Htk-L', 'LERK', 'LERK-5', 'Ler', 'Lerk5', 'NLER', 'NLERK-1'], description='ephrin B2', other_designations='ephrin-B2|EPH-related receptor tyrosine kinase ligand 5|HTK ligand', map_location='8 3.42 cM', chromosome='8', genomic_nucleotide_accession_version='NC_000074.6', start_position_on_the_genomic_accession=8617235, end_position_on_the_genomic_accession=8661242, orientation='minus', exon_count=6, OMIM=[], no_hdr0=''),
    13643 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=13643, CurrentID=0, Status='live', Symbol='Efnb3', Aliases=['EFL-', 'EFL-6', 'ELF-', 'ELF-3', 'Elk-', 'Elk-L3', 'Ep', 'Epl8', 'LERK', 'LERK-8', 'NLER', 'NLERK-2'], description='ephrin B3', other_designations='ephrin-B3', map_location='11 42.8 cM', chromosome='11', genomic_nucleotide_accession_version='NC_000077.6', start_position_on_the_genomic_accession=69554092, end_position_on_the_genomic_accession=69561150, orientation='minus', exon_count=6, OMIM=[], no_hdr0=''),
    13644 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=13644, CurrentID=0, Status='live', Symbol='Efs', Aliases=[], description='embryonal Fyn-associated substrate', other_designations='embryonal Fyn-associated substrate|SRC-interacting protein|signal-integrating protein', map_location='14 C2', chromosome='14', genomic_nucleotide_accession_version='NC_000080.6', start_position_on_the_genomic_accession=54916543, end_position_on_the_genomic_accession=54926788, orientation='minus', exon_count=6, OMIM=[], no_hdr0=''),
    13645 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=13645, CurrentID=0, Status='live', Symbol='Egf', Aliases=['AI790464'], description='epidermal growth factor', other_designations='pro-epidermal growth factor|Pro-epidermal growth factor precursor (EGF)', map_location='3 58.5 cM', chromosome='3', genomic_nucleotide_accession_version='NC_000069.6', start_position_on_the_genomic_accession=129677574, end_position_on_the_genomic_accession=129755322, orientation='minus', exon_count=25, OMIM=[], no_hdr0=''),
    13646 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=13646, CurrentID=0, Status='live', Symbol='Klk1b22', Aliases=['EGF-BP A', 'Egfbp', 'Egfbp-', 'Egfbp-1', 'Egfbp1', 'Klk2', 'Klk22', 'mGk-22'], description='kallikrein 1-related peptidase b22', other_designations='kallikrein 1-related peptidase b22|beta-NGF-endopeptidase|epidermal growth factor-binding protein type A|glandular kallikrein K22|nerve growth factor beta chain endopeptidase|tissue kallikrein 22', map_location='7 28.61 cM', chromosome='7', genomic_nucleotide_accession_version='NC_000073.6', start_position_on_the_genomic_accession=44112673, end_position_on_the_genomic_accession=44116922, orientation='plus', exon_count=5, OMIM=[], no_hdr0=''),
    13647 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=13647, CurrentID=0, Status='live', Symbol='Egfbp2', Aliases=['Egfbp-', 'Egfbp-2', 'Klk1b26', 'PRECE-1', 'mGk-13'], description='epidermal growth factor binding protein type B', other_designations='epidermal growth factor-binding protein type B|EGF-BP B|glandular kallikrein K13|kallikrein 1b26|prorenin-converting enzyme 1|tissue kallikrein 13', map_location='7', chromosome='7', genomic_nucleotide_accession_version='', start_position_on_the_genomic_accession='', end_position_on_the_genomic_accession='', orientation='', exon_count='', OMIM=[], no_hdr0=''),
    13648 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=13648, CurrentID=0, Status='live', Symbol='Klk1b9', Aliases=['EGF-BP C', 'Egfbp', 'Egfbp-', 'Egfbp-3', 'Egfbp3', 'KAL', 'Klk', 'Klk9', 'kallikrein', 'mGk-9'], description='kallikrein 1-related peptidase b9', other_designations='kallikrein 1-related peptidase b9|epidermal growth factor-binding protein type C|glandular kallikrein K9|tissue kallikrein-9', map_location='7 28.45 cM', chromosome='7', genomic_nucleotide_accession_version='NC_000073.6', start_position_on_the_genomic_accession=43976061, end_position_on_the_genomic_accession=43980376, orientation='plus', exon_count=5, OMIM=[], no_hdr0=''),
    13649 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=13649, CurrentID=0, Status='live', Symbol='Egfr', Aliases=['9030024J15Rik', 'AI552599', 'Erb', 'Erbb', 'Err', 'Errb1', 'Errp', 'Wa', 'Wa5', 'wa-2', 'wa2'], description='epidermal growth factor receptor', other_designations='epidermal growth factor receptor|avian erythroblastic leukemia viral (v-erb-b) oncogene homolog|waved 2', map_location='11 9.41 cM', chromosome='11', genomic_nucleotide_accession_version='NC_000077.6', start_position_on_the_genomic_accession=16752203, end_position_on_the_genomic_accession=16913907, orientation='plus', exon_count=28, OMIM=[], no_hdr0=''),
    13650 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=13650, CurrentID=0, Status='live', Symbol='Rhbdf1', Aliases=['C16ORF8', 'Di', 'Dis', 'Dist', 'Dist1', 'Egfr', 'Egfr-rs', 'mKIAA4242'], description='rhomboid 5 homolog 1', other_designations='inactive rhomboid protein 1|epidermal growth factor receptor related sequence|epidermal growth factor receptor-related protein|iRhom1|rhomboid family 1|rhomboid family member 1', map_location='11 18.83 cM', chromosome='11', genomic_nucleotide_accession_version='NC_000077.6', start_position_on_the_genomic_accession=32209585, end_position_on_the_genomic_accession=32222331, orientation='minus', exon_count=21, OMIM=[], no_hdr0=''),
    13653 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=13653, CurrentID=0, Status='live', Symbol='Egr1', Aliases=['A530045N19Rik', 'ETR10', 'ETR103', 'Egr-', 'Egr-1', 'Krox', 'Krox-', 'Krox-1', 'Krox-24', 'Krox24', 'NG', 'NGF', 'NGF1', 'NGF1-A', 'NGFI-A', 'NGFIA', 'TI', 'TIS8', 'Zen', 'Zenk', 'Zfp-', 'Zfp-6', 'Zif26', 'Zif268', 'egr'], description='early growth response 1', other_designations='early growth response protein 1|Krox-24 nuclear protein|nerve growth factor-induced protein A|transcription factor Zif268|zinc finger protein Krox-24', map_location='18 18.76 cM', chromosome='18', genomic_nucleotide_accession_version='NC_000084.6', start_position_on_the_genomic_accession=34861207, end_position_on_the_genomic_accession=34864956, orientation='plus', exon_count=2, OMIM=[], no_hdr0=''),
    13654 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=13654, CurrentID=0, Status='live', Symbol='Egr2', Aliases=['Egr-', 'Egr-2', 'Krox', 'Krox-', 'Krox-20', 'Krox20', 'NGF1-', 'NGF1-B', 'Zfp-2', 'Zfp-25', 'Zfp-6'], description='early growth response 2', other_designations='E3 SUMO-protein ligase EGR2|E3 SUMO-protein transferase ERG2|early growth response protein 2|zinc finger protein Krox-20', map_location='10 34.96 cM', chromosome='10', genomic_nucleotide_accession_version='NC_000076.6', start_position_on_the_genomic_accession=67534469, end_position_on_the_genomic_accession=67542188, orientation='plus', exon_count=9, OMIM=[], no_hdr0=''),
    13655 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=13655, CurrentID=0, Status='live', Symbol='Egr3', Aliases=['P', 'Pilot'], description='early growth response 3', other_designations='early growth response protein 3|EGR-3', map_location='14 D2', chromosome='14', genomic_nucleotide_accession_version='NC_000080.6', start_position_on_the_genomic_accession=70077317, end_position_on_the_genomic_accession=70082613, orientation='plus', exon_count=4, OMIM=[], no_hdr0=''),
    13656 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=13656, CurrentID=0, Status='live', Symbol='Egr4', Aliases=['NGF1-', 'NGF1-C', 'NGFI', 'NGFI-C', 'NGFIC', 'pAT1', 'pAT133'], description='early growth response 4', other_designations='early growth response protein 4|EGR-4', map_location='6 37.48 cM', chromosome='6', genomic_nucleotide_accession_version='NC_000072.6', start_position_on_the_genomic_accession=85511121, end_position_on_the_genomic_accession=85513589, orientation='minus', exon_count=2, OMIM=[], no_hdr0=''),
    13660 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=13660, CurrentID=0, Status='live', Symbol='Ehd1', Aliases=['AA409636', 'Pa', 'Past1', 'RME-', 'RME-1'], description='EH-domain containing 1', other_designations='EH domain-containing protein 1|PAST homolog 1|mPAST1', map_location='19 4.4 cM', chromosome='19', genomic_nucleotide_accession_version='NC_000085.6', start_position_on_the_genomic_accession=6276896, end_position_on_the_genomic_accession=6300096, orientation='plus', exon_count=5, OMIM=[], no_hdr0=''),
    13661 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=13661, CurrentID=0, Status='live', Symbol='Ehf', Aliases=['9030625L19Rik', 'AU019492'], description='ets homologous factor', other_designations='ETS homologous factor|ETS domain-containing transcription factor|ehf', map_location='2 E2', chromosome='2', genomic_nucleotide_accession_version='NC_000068.7', start_position_on_the_genomic_accession=103263431, end_position_on_the_genomic_accession=103303275, orientation='minus', exon_count=16, OMIM=[], no_hdr0=''),
    13663 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=13663, CurrentID=0, Status='live', Symbol='Ei24', Aliases=['AA536736', 'AI115355', 'PI', 'PIG8'], description='etoposide induced 2.4 mRNA', other_designations='etoposide-induced protein 2.4|p53-induced gene 8 protein', map_location='9 20.68 cM', chromosome='9', genomic_nucleotide_accession_version='NC_000075.6', start_position_on_the_genomic_accession=36779153, end_position_on_the_genomic_accession=36797334, orientation='minus', exon_count=11, OMIM=[], no_hdr0=''),
    13664 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=13664, CurrentID=0, Status='live', Symbol='Eif1a', Aliases=['C76390', 'Ef1', 'Ef1a', 'Eftu', 'Eif4', 'Eif4c', 'eIF-', 'eIF-1A', 'eIF-4C'], description='eukaryotic translation initiation factor 1A', other_designations='eukaryotic translation initiation factor 1A|eukaryotic translation initiation factor 4C', map_location='18 C', chromosome='18', genomic_nucleotide_accession_version='NC_000084.6', start_position_on_the_genomic_accession=46597704, end_position_on_the_genomic_accession=46610225, orientation='plus', exon_count=3, OMIM=[], no_hdr0=''),
    13665 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=13665, CurrentID=0, Status='live', Symbol='Eif2s1', Aliases=['0910001O23Rik', '2410026C18Rik', '35kDa', 'Eif', 'Eif2a', 'eIF2', 'eIF2alpha'], description='eukaryotic translation initiation factor 2, subunit 1 alpha', other_designations='eukaryotic translation initiation factor 2 subunit 1|eIF-2-alpha|eIF-2A|eIF-2alpha|eukaryotic translation initiation factor 2 subunit alpha|eukaryotic translation initiation factor 2A', map_location='12 C3', chromosome='12', genomic_nucleotide_accession_version='NC_000078.6', start_position_on_the_genomic_accession=78862072, end_position_on_the_genomic_accession=78887010, orientation='plus', exon_count=8, OMIM=[], no_hdr0=''),
    13666 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=13666, CurrentID=0, Status='live', Symbol='Eif2ak3', Aliases=['PE', 'Pek', 'Perk'], description='eukaryotic translation initiation factor 2 alpha kinase 3', other_designations='eukaryotic translation initiation factor 2-alpha kinase 3|PRKR-like endoplasmic reticulum kinase|pancreatic eIF2-alpha kinase', map_location='6 C1', chromosome='6', genomic_nucleotide_accession_version='NC_000072.6', start_position_on_the_genomic_accession=70844484, end_position_on_the_genomic_accession=70905241, orientation='plus', exon_count=18, OMIM=[], no_hdr0=''),
    13667 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=13667, CurrentID=0, Status='live', Symbol='Eif2b4', Aliases=['Eif2', 'Eif2b'], description='eukaryotic translation initiation factor 2B, subunit 4 delta', other_designations='translation initiation factor eIF-2B subunit delta|eIF-2B GDP-GTP exchange factor subunit delta', map_location='5 B1', chromosome='5', genomic_nucleotide_accession_version='NC_000071.6', start_position_on_the_genomic_accession=31187558, end_position_on_the_genomic_accession=31193139, orientation='minus', exon_count=13, OMIM=[], no_hdr0=''),
    13669 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=13669, CurrentID=0, Status='live', Symbol='Eif3a', Aliases=['A830012B05Rik', 'Cs', 'Csma', 'Eif', 'Eif3', 'Eif3s', 'Eif3s10', 'mKIAA0139'], description='eukaryotic translation initiation factor 3, subunit A', other_designations='eukaryotic translation initiation factor 3 subunit A|EUKARYOTIC TRANSLATION INITIATION FACTOR 3 SUBUNIT 10 (EIF-3 THETA) (EIF3 P167) (EIF3 P180) (EIF3 P185) (P162 PROTEIN) (CENTROSOMIN)|centrosomin|eIF-3-theta|eIF3 p167|eIF3 p180|eIF3 p185|eukaryotic translation initiation factor 3, subunit 10 (theta)|p162', map_location='19 D3', chromosome='19', genomic_nucleotide_accession_version='NC_000085.6', start_position_on_the_genomic_accession=60761116, end_position_on_the_genomic_accession=60790693, orientation='minus', exon_count=22, OMIM=[], no_hdr0=''),
    13680 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=13680, CurrentID=0, Status='live', Symbol='Ddx19a', Aliases=['DBP', 'DBP5', 'Ddx19', 'Eif4a', 'Eif4a-rs1'], description='DEAD box helicase 19a', other_designations='ATP-dependent RNA helicase DDX19A|DEAD (Asp-Glu-Ala-Asp) box polypeptide 19a|DEAD box RNA helicase DEAD5|DEAD box protein 19A|DEAD/H (Asp-Glu-Ala-Asp/His) box polypeptide 19|Ddx19-like protein|eukaryotic translation initiation factor 4A-related sequence 1|mDEAD5', map_location='8 E1', chromosome='8', genomic_nucleotide_accession_version='NC_000074.6', start_position_on_the_genomic_accession=110974991, end_position_on_the_genomic_accession=110997823, orientation='minus', exon_count=13, OMIM=[], no_hdr0=''),
    13681 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=13681, CurrentID=0, Status='live', Symbol='Eif4a1', Aliases=['BM-010', 'Ddx2a', 'Eif', 'Eif4'], description='eukaryotic translation initiation factor 4A1', other_designations='eukaryotic initiation factor 4A-I|ATP-dependent RNA helicase eIF4A-1|eIF-4A-I|eIF4A-I|initiation factor eIF-4A long form', map_location='11 42.86 cM', chromosome='11', genomic_nucleotide_accession_version='NC_000077.6', start_position_on_the_genomic_accession=69666936, end_position_on_the_genomic_accession=69672423, orientation='minus', exon_count=11, OMIM=[], no_hdr0=''),
    13682 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=13682, CurrentID=0, Status='live', Symbol='Eif4a2', Aliases=['4833432N07Rik', 'BM-010', 'Ddx2b', 'Eif', 'Eif4', 'eIF-4A-II', 'eIF4A-II'], description='eukaryotic translation initiation factor 4A2', other_designations='eukaryotic initiation factor 4A-II|ATP-dependent RNA helicase eIF4A-2', map_location='16 13.93 cM', chromosome='16', genomic_nucleotide_accession_version='NC_000082.6', start_position_on_the_genomic_accession=23107468, end_position_on_the_genomic_accession=23114132, orientation='plus', exon_count=12, OMIM=[], no_hdr0=''),
    13684 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=13684, CurrentID=0, Status='live', Symbol='Eif4e', Aliases=['EG668879-ps', 'If4', 'If4e', 'eIF-4', 'eIF-4E', 'Eif4e'], description='eukaryotic translation initiation factor 4E', other_designations='eukaryotic translation initiation factor 4E|eIF-4F 25 kDa subunit|mRNA cap-binding protein', map_location='3 64.3 cM', chromosome='3', genomic_nucleotide_accession_version='NC_000069.6', start_position_on_the_genomic_accession=138526191, end_position_on_the_genomic_accession=138559696, orientation='plus', exon_count=10, OMIM=[], no_hdr0=''),
    13685 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=13685, CurrentID=0, Status='live', Symbol='Eif4ebp1', Aliases=['4e-bp', '4e-bp1', 'AA959816', 'PH', 'PHAS-I'], description='eukaryotic translation initiation factor 4E binding protein 1', other_designations='eukaryotic translation initiation factor 4E-binding protein 1|eIF4E-binding protein 1|phosphorylated heat- and acid-stable protein regulated by insulin 1', map_location='8 15.95 cM', chromosome='8', genomic_nucleotide_accession_version='NC_000074.6', start_position_on_the_genomic_accession=27260327, end_position_on_the_genomic_accession=27275656, orientation='plus', exon_count=3, OMIM=[], no_hdr0=''),
    13688 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=13688, CurrentID=0, Status='live', Symbol='Eif4ebp2', Aliases=['2810011I19Rik', '4E-BP', '4E-BP2', 'AA792569', 'BC010348', 'PH', 'PHAS-II'], description='eukaryotic translation initiation factor 4E binding protein 2', other_designations='eukaryotic translation initiation factor 4E-binding protein 2|eIF4E-binding protein 2|phosphorylated heat- and acid-stable protein regulated by insulin 2', map_location='10 32.21 cM', chromosome='10', genomic_nucleotide_accession_version='NC_000076.6', start_position_on_the_genomic_accession=61428491, end_position_on_the_genomic_accession=61452790, orientation='minus', exon_count=5, OMIM=[], no_hdr0=''),
    13690 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=13690, CurrentID=0, Status='live', Symbol='Eif4g2', Aliases=['DAP', 'DAP-5', 'E130105L11Rik', 'Na', 'Nat', 'Nat1', 'Natm1', 'p97'], description='eukaryotic translation initiation factor 4, gamma 2', other_designations='eukaryotic translation initiation factor 4 gamma 2|eIF-4-gamma 2|eIF-4G 2|eIF4G 2|novel APOBEC-1 target 1|translation repressor Nat1', map_location='7 58.0 cM', chromosome='7', genomic_nucleotide_accession_version='NC_000073.6', start_position_on_the_genomic_accession=111067985, end_position_on_the_genomic_accession=111083030, orientation='minus', exon_count=22, OMIM=[], no_hdr0=''),
    13706 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=13706, CurrentID=0, Status='live', Symbol='Cela2a', Aliases=['El', 'Ela', 'Ela-2', 'Ela2', 'Ela2a'], description='chymotrypsin-like elastase family, member 2A', other_designations='chymotrypsin-like elastase family member 2A|elastase 2A', map_location='4 74.75 cM', chromosome='4', genomic_nucleotide_accession_version='NC_000070.6', start_position_on_the_genomic_accession=141814954, end_position_on_the_genomic_accession=141826005, orientation='minus', exon_count=8, OMIM=[], no_hdr0=''),
    13709 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=13709, CurrentID=0, Status='live', Symbol='Elf1', Aliases=['Elf-', 'Elf-1', 'Sts1', 'mElf-1', 'p70'], description='E74-like factor 1', other_designations='ETS-related transcription factor Elf-1', map_location='14 D3', chromosome='14', genomic_nucleotide_accession_version='NC_000080.6', start_position_on_the_genomic_accession=79481174, end_position_on_the_genomic_accession=79582491, orientation='plus', exon_count=15, OMIM=[], no_hdr0=''),
    13710 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=13710, CurrentID=0, Status='live', Symbol='Elf3', Aliases=['ES', 'ESE-', 'ESE-1', 'ESX', 'je', 'jen'], description='E74-like factor 3', other_designations='ETS-related transcription factor Elf-3|epithelial-restricted with serine box|epithelium-restricted Ets protein ESX|epithelium-specific Ets transcription factor 1', map_location='1 E4', chromosome='1', genomic_nucleotide_accession_version='NC_000067.6', start_position_on_the_genomic_accession=135253574, end_position_on_the_genomic_accession=135258472, orientation='minus', exon_count=9, OMIM=[], no_hdr0=''),
    13711 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=13711, CurrentID=0, Status='live', Symbol='Elf5', Aliases=['ESE-', 'ESE-2', 'ESE-5', 'ESE-5.'], description='E74-like factor 5', other_designations='ETS-related transcription factor Elf-5|Epithelium specific Ets-2', map_location='2 E2', chromosome='2', genomic_nucleotide_accession_version='NC_000068.7', start_position_on_the_genomic_accession=103412098, end_position_on_the_genomic_accession=103450989, orientation='plus', exon_count=9, OMIM=[], no_hdr0=''),
    13712 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=13712, CurrentID=0, Status='live', Symbol='Elk1', Aliases=['Elk-', 'Elk-1'], description='ELK1, member of ETS oncogene family', other_designations='ETS domain-containing protein Elk-1', map_location='X 16.45 cM', chromosome='X', genomic_nucleotide_accession_version='NC_000086.7', start_position_on_the_genomic_accession=20933395, end_position_on_the_genomic_accession=20950608, orientation='minus', exon_count=6, OMIM=[], no_hdr0=''),
    13713 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=13713, CurrentID=0, Status='live', Symbol='Elk3', Aliases=['D430049E23Rik', 'E', 'Erp', 'Etrp', 'Ne', 'Net', 'Sa', 'Sap-2'], description='ELK3, member of ETS oncogene family', other_designations='ETS domain-containing protein Elk-3|ETS-domain protein ELK-3|ETS-related protein ERP|ETS-related protein NET', map_location='10 48.04 cM', chromosome='10', genomic_nucleotide_accession_version='NC_000076.6', start_position_on_the_genomic_accession=93247415, end_position_on_the_genomic_accession=93311159, orientation='minus', exon_count=7, OMIM=[], no_hdr0=''),
    13714 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=13714, CurrentID=0, Status='live', Symbol='Elk4', Aliases=['2310011G17Rik', 'A130026I01Rik', 'BB162516', 'S', 'SAP-1', 'Sap1'], description='ELK4, member of ETS oncogene family', other_designations='ETS domain-containing protein Elk-4|SRF accessory protein 1|serum response factor accessory protein 1', map_location='1 E4', chromosome='1', genomic_nucleotide_accession_version='NC_000067.6', start_position_on_the_genomic_accession=132007577, end_position_on_the_genomic_accession=132026448, orientation='plus', exon_count=8, OMIM=[], no_hdr0=''),
    13716 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=13716, CurrentID=0, Status='live', Symbol='Ell', Aliases=['El1', 'Me', 'Men', 'Ell'], description='elongation factor RNA polymerase II', other_designations='RNA polymerase II elongation factor ELL|RNA POLYMERASE II ELONGATION FACTOR ELL (ELEVEN-NINETEEN LYSINE-RICH LEUKEMIA PROTEIN)|eleven-nineteen lysine-rich leukemia protein', map_location='8 B3.3', chromosome='8', genomic_nucleotide_accession_version='NC_000074.6', start_position_on_the_genomic_accession=70539675, end_position_on_the_genomic_accession=70592858, orientation='plus', exon_count=12, OMIM=[], no_hdr0=''),
    13717 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=13717, CurrentID=0, Status='live', Symbol='Eln', Aliases=['AI385707', 'AI480567', 'E030024M20Rik'], description='elastin', other_designations='elastin|tropoelastin', map_location='5 74.76 cM', chromosome='5', genomic_nucleotide_accession_version='NC_000071.6', start_position_on_the_genomic_accession=134702595, end_position_on_the_genomic_accession=134747368, orientation='minus', exon_count=38, OMIM=[], no_hdr0=''),
    13722 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=13722, CurrentID=0, Status='live', Symbol='Aimp1', Aliases=['9830137A06Rik', 'AIMP1/p43', 'EM', 'EMAPII', 'Ema', 'Emap2', 'Scye', 'Scye1', 'p43'], description='aminoacyl tRNA synthetase complex-interacting multifunctional protein 1', other_designations='aminoacyl tRNA synthase complex-interacting multifunctional protein 1|ARS inducible multifunctional protein 1|endothelial monocyte activating polypeptide 2|multisynthase complex auxiliary component p43|multisynthetase complex auxiliary component p43|small inducible cytokine subfamily E, member 1', map_location='3 G3', chromosome='3', genomic_nucleotide_accession_version='NC_000069.6', start_position_on_the_genomic_accession=132660498, end_position_on_the_genomic_accession=132684390, orientation='minus', exon_count=8, OMIM=[], no_hdr0=''),
    13723 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=13723, CurrentID=0, Status='live', Symbol='Emb', Aliases=['AL022799', 'Gp7', 'Gp70'], description='embigin', other_designations='embigin|glycoprotein 70|teratocarcinoma glycoprotein Gp-70', map_location='13 D2.3', chromosome='13', genomic_nucleotide_accession_version='NC_000079.6', start_position_on_the_genomic_accession=117220573, end_position_on_the_genomic_accession=117274415, orientation='plus', exon_count=9, OMIM=[], no_hdr0=''),
    13726 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=13726, CurrentID=0, Status='live', Symbol='Emd', Aliases=['AW550900', 'Sta'], description='emerin', other_designations='emerin', map_location='X 37.92 cM', chromosome='X', genomic_nucleotide_accession_version='NC_000086.7', start_position_on_the_genomic_accession=74254674, end_position_on_the_genomic_accession=74261563, orientation='plus', exon_count=7, OMIM=[], no_hdr0=''),
    13728 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=13728, CurrentID=0, Status='live', Symbol='Mark2', Aliases=['EMK-1', 'Emk', 'Pa', 'Par-1', 'Par-1b'], description='MAP/microtubule affinity regulating kinase 2', other_designations='serine/threonine-protein kinase MARK2|ELKL motif kinase 1|PAR1 homolog b', map_location='19 5.32 cM', chromosome='19', genomic_nucleotide_accession_version='NC_000085.6', start_position_on_the_genomic_accession=7275396, end_position_on_the_genomic_accession=7341860, orientation='minus', exon_count=23, OMIM=[], no_hdr0=''),
    13730 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=13730, CurrentID=0, Status='live', Symbol='Emp1', Aliases=['I-8-09', 'TMP'], description='epithelial membrane protein 1', other_designations='epithelial membrane protein 1|EMP-1|tumor-associated membrane protein', map_location='6 66.25 cM', chromosome='6', genomic_nucleotide_accession_version='NC_000072.6', start_position_on_the_genomic_accession=135362550, end_position_on_the_genomic_accession=135383173, orientation='plus', exon_count=8, OMIM=[], no_hdr0=''),
    13731 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=13731, CurrentID=0, Status='live', Symbol='Emp2', Aliases=['XMP', 'Xm'], description='epithelial membrane protein 2', other_designations='epithelial membrane protein 2|EMP-2', map_location='16 5.54 cM', chromosome='16', genomic_nucleotide_accession_version='NC_000082.6', start_position_on_the_genomic_accession=10281749, end_position_on_the_genomic_accession=10313968, orientation='minus', exon_count=5, OMIM=[], no_hdr0=''),
    13732 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=13732, CurrentID=0, Status='live', Symbol='Emp3', Aliases=['H-4', 'H4', 'HNMP', 'HNMP-1', 'MI-3', 'MI-35', 'Ym', 'Ymp'], description='epithelial membrane protein 3', other_designations='epithelial membrane protein 3|EMP-3|hematopoietic neural membrane protein 1', map_location='7 29.6 cM', chromosome='7', genomic_nucleotide_accession_version='NC_000073.6', start_position_on_the_genomic_accession=45918023, end_position_on_the_genomic_accession=45921426, orientation='minus', exon_count=6, OMIM=[], no_hdr0=''),
    13733 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=13733, CurrentID=0, Status='live', Symbol='Adgre1', Aliases=['DD7A5-', 'DD7A5-7', 'EGF-TM7', 'Emr', 'Emr1', 'F4/80', 'Gpf480', 'Ly7', 'Ly71', 'TM7L', 'TM7LN3'], description='adhesion G protein-coupled receptor E1', other_designations='adhesion G protein-coupled receptor E1|EGF-like module containing, mucin-like, hormone receptor-like sequence 1|EGF-like module receptor 1|EGF-like module-containing mucin-like hormone receptor-like 1|EMR1 hormone receptor|cell surface glycoprotein F4/80', map_location='17 29.8 cM', chromosome='17', genomic_nucleotide_accession_version='NC_000083.6', start_position_on_the_genomic_accession=57358581, end_position_on_the_genomic_accession=57483529, orientation='plus', exon_count=22, OMIM=[], no_hdr0=''),
    13796 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=13796, CurrentID=0, Status='live', Symbol='Emx1', Aliases=[], description='empty spiracles homeobox 1', other_designations='homeobox protein EMX1|empty spiracles homolog 1|empty spiracles-like protein 1', map_location='6 37.21 cM', chromosome='6', genomic_nucleotide_accession_version='NC_000072.6', start_position_on_the_genomic_accession=85187931, end_position_on_the_genomic_accession=85204463, orientation='plus', exon_count=3, OMIM=[], no_hdr0=''),
    13797 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=13797, CurrentID=0, Status='live', Symbol='Emx2', Aliases=['P', 'Pdo'], description='empty spiracles homeobox 2', other_designations='homeobox protein EMX2|empty spiracles homolog 2|empty spiracles-like protein 2', map_location='19 56.28 cM', chromosome='19', genomic_nucleotide_accession_version='NC_000085.6', start_position_on_the_genomic_accession=59458690, end_position_on_the_genomic_accession=59465357, orientation='plus', exon_count=3, OMIM=[], no_hdr0=''),
    13798 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=13798, CurrentID=0, Status='live', Symbol='En1', Aliases=['En-', 'En-1', 'Mo-en', 'Mo-en.1', 'engrai', 'engrailed-1'], description='engrailed 1', other_designations='homeobox protein engrailed-1|homeobox protein en-1|mo-En-1', map_location='1 52.74 cM', chromosome='1', genomic_nucleotide_accession_version='NC_000067.6', start_position_on_the_genomic_accession=120602487, end_position_on_the_genomic_accession=120607991, orientation='plus', exon_count=2, OMIM=[], no_hdr0=''),
    13799 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=13799, CurrentID=0, Status='live', Symbol='En2', Aliases=['BB131122', 'En-', 'En-2', 'mo-En-2'], description='engrailed 2', other_designations='homeobox protein engrailed-2|homeobox protein en-2', map_location='5 13.94 cM', chromosome='5', genomic_nucleotide_accession_version='NC_000071.6', start_position_on_the_genomic_accession=28165696, end_position_on_the_genomic_accession=28172190, orientation='plus', exon_count=2, OMIM=[], no_hdr0=''),
    13800 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=13800, CurrentID=0, Status='live', Symbol='Enah', Aliases=['Me', 'Mena', 'NDPP-1', 'Nd', 'Ndpp1', 'WBP8'], description='ENAH actin regulator', other_designations='protein enabled homolog|NPC derived proline rich protein 1|enabled homolog', map_location='1 84.93 cM', chromosome='1', genomic_nucleotide_accession_version='NC_000067.6', start_position_on_the_genomic_accession=181896384, end_position_on_the_genomic_accession=182027556, orientation='minus', exon_count=19, OMIM=[], no_hdr0=''),
    13801 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=13801, CurrentID=0, Status='live', Symbol='Enam', Aliases=['abt', 'abte'], description='enamelin', other_designations='enamelin', map_location='5 E1', chromosome='5', genomic_nucleotide_accession_version='NC_000071.6', start_position_on_the_genomic_accession=88487975, end_position_on_the_genomic_accession=88506049, orientation='plus', exon_count=11, OMIM=[], no_hdr0=''),
    13803 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=13803, CurrentID=0, Status='live', Symbol='Enc1', Aliases=['N', 'Nrpb', 'PIG', 'PIG10'], description='ectodermal-neural cortex 1', other_designations='ectoderm-neural cortex protein 1|ENC-1', map_location='13 D1', chromosome='13', genomic_nucleotide_accession_version='NC_000079.6', start_position_on_the_genomic_accession=97241105, end_position_on_the_genomic_accession=97253040, orientation='plus', exon_count=5, OMIM=[], no_hdr0=''),
    13804 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=13804, CurrentID=0, Status='live', Symbol='Endog', Aliases=[], description='endonuclease G', other_designations='endonuclease G, mitochondrial|endo G', map_location='2 B', chromosome='2', genomic_nucleotide_accession_version='NC_000068.7', start_position_on_the_genomic_accession=30171408, end_position_on_the_genomic_accession=30174069, orientation='plus', exon_count=4, OMIM=[], no_hdr0=''),
    13805 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=13805, CurrentID=0, Status='live', Symbol='Eng', Aliases=['AI528660', 'AI662476', 'CD105', 'En', 'Endo', 'S-endoglin'], description='endoglin', other_designations='endoglin|cell surface MJ7/18 antigen|transmembrane glycoprotein', map_location='2 22.09 cM', chromosome='2', genomic_nucleotide_accession_version='NC_000068.7', start_position_on_the_genomic_accession=32646595, end_position_on_the_genomic_accession=32682669, orientation='plus', exon_count=15, OMIM=[], no_hdr0=''),
    13806 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=13806, CurrentID=0, Status='live', Symbol='Eno1', Aliases=['0610008I15', 'AL022784', 'Eno', 'Eno-1', 'MBP-', 'MBP-1'], description='enolase 1, alpha non-neuron', other_designations='alpha-enolase|2-phospho-D-glycerate hydro-lyase|2-phospho-D-glycerate hydrolase|NNE|c-Myc promoter binding protein|non-neural enolase', map_location='4 81.24 cM', chromosome='4', genomic_nucleotide_accession_version='NC_000070.6', start_position_on_the_genomic_accession=150236708, end_position_on_the_genomic_accession=150248879, orientation='plus', exon_count=14, OMIM=[], no_hdr0=''),
    13807 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=13807, CurrentID=0, Status='live', Symbol='Eno2', Aliases=['AI837106', 'D6Ertd375', 'D6Ertd375e', 'Eno', 'Eno-2', 'N', 'NSE'], description='enolase 2, gamma neuronal', other_designations='gamma-enolase|2-phospho-D-glycerate hydro-lyase|neural enolase|neuron-specific enolase', map_location='6 59.17 cM', chromosome='6', genomic_nucleotide_accession_version='NC_000072.6', start_position_on_the_genomic_accession=124760053, end_position_on_the_genomic_accession=124769673, orientation='minus', exon_count=12, OMIM=[], no_hdr0=''),
    13808 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=13808, CurrentID=0, Status='live', Symbol='Eno3', Aliases=['Eno', 'Eno-3', 'MSE'], description='enolase 3, beta muscle', other_designations='beta-enolase|2-phospho-D-glycerate hydro-lyase|muscle-specific enolase|skeletal muscle enolase', map_location='11 43.21 cM', chromosome='11', genomic_nucleotide_accession_version='NC_000077.6', start_position_on_the_genomic_accession=70653125, end_position_on_the_genomic_accession=70662513, orientation='plus', exon_count=13, OMIM=[], no_hdr0=''),
    13809 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=13809, CurrentID=0, Status='live', Symbol='Enpep', Aliases=['6030431M22Rik', 'APA', 'Bp-1/6C', 'Bp-1/6C3', 'Ly-5', 'Ly-51', 'Ly5', 'Ly51'], description='glutamyl aminopeptidase', other_designations='glutamyl aminopeptidase|AP-A|BP-1/6C3 antigen|EAP|aminopeptidase A', map_location='3 57.92 cM', chromosome='3', genomic_nucleotide_accession_version='NC_000069.6', start_position_on_the_genomic_accession=129269177, end_position_on_the_genomic_accession=129332749, orientation='minus', exon_count=20, OMIM=[], no_hdr0=''),
    13813 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=13813, CurrentID=0, Status='live', Symbol='Eomes', Aliases=['C77258', 'TBR-2', 'Tbr', 'Tbr2'], description='eomesodermin', other_designations='eomesodermin homolog|T-box brain protein 2|T-brain-2', map_location='9 F3', chromosome='9', genomic_nucleotide_accession_version='NC_000075.6', start_position_on_the_genomic_accession=118478186, end_position_on_the_genomic_accession=118486132, orientation='plus', exon_count=6, OMIM=[], no_hdr0=''),
    13819 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=13819, CurrentID=0, Status='live', Symbol='Epas1', Aliases=['HIF', 'HIF-2', 'HIF-2alpha', 'HIF2A', 'HL', 'HLF', 'HR', 'HRF', 'MO', 'MOP2', 'bHLHe7', 'bHLHe73'], description='endothelial PAS domain protein 1', other_designations='endothelial PAS domain-containing protein 1|EPAS-1|HIF-1-alpha-like factor|HIF-2-alpha|HIF-related factor|HIF1 alpha-like factor|HIF1alpha-like factor|HIF2-alpha|HLF (HIF1alpha-like factor)|Hif like protein|hypoxia inducible transcription factor 2alpha|hypoxia-inducible factor 2-alpha|mHLF', map_location='17 E4', chromosome='17', genomic_nucleotide_accession_version='NC_000083.6', start_position_on_the_genomic_accession=86753864, end_position_on_the_genomic_accession=86833410, orientation='plus', exon_count=17, OMIM=[], no_hdr0=''),
    13821 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=13821, CurrentID=0, Status='live', Symbol='Epb41l1', Aliases=['4.1', '4.1N', 'Epb4.1', 'Epb4.1l1', 'NBL1', 'mKIAA0338'], description='erythrocyte membrane protein band 4.1 like 1', other_designations='band 4.1-like protein 1|erythrocyte protein band 4.1 like 1|neuronal protein 4.1', map_location='2 77.39 cM', chromosome='2', genomic_nucleotide_accession_version='NC_000068.7', start_position_on_the_genomic_accession=156417595, end_position_on_the_genomic_accession=156543214, orientation='plus', exon_count=29, OMIM=[], no_hdr0=''),
    13822 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=13822, CurrentID=0, Status='live', Symbol='Epb41l2', Aliases=['4.1G', 'AW555191', 'D10Ertd398', 'D10Ertd398e', 'Epb4.1', 'Epb4.1l2', 'NB', 'NBL2'], description='erythrocyte membrane protein band 4.1 like 2', other_designations='band 4.1-like protein 2|erythrocyte membrane protein band 4.1-like 2 retinal|erythrocyte protein band 4.1 like 2|erythrocyte protein band 4.1l2 long|erythrocyte protein band 4.1l2 middle|generally expressed protein 4.1', map_location='10 12.26 cM', chromosome='10', genomic_nucleotide_accession_version='NC_000076.6', start_position_on_the_genomic_accession=25359782, end_position_on_the_genomic_accession=25523519, orientation='plus', exon_count=26, OMIM=[], no_hdr0=''),
    13823 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=13823, CurrentID=0, Status='live', Symbol='Epb41l3', Aliases=['4.1B', 'DA', 'DAL1P', 'Dal1', 'Epb4.1', 'Epb4.1l3', 'NB', 'NBL3'], description='erythrocyte membrane protein band 4.1 like 3', other_designations='band 4.1-like protein 3|DAL-1|differentially expressed in adenocarcinoma of the lung protein 1', map_location='17 40.15 cM', chromosome='17', genomic_nucleotide_accession_version='NC_000083.6', start_position_on_the_genomic_accession=69075647, end_position_on_the_genomic_accession=69289991, orientation='plus', exon_count=33, OMIM=[], no_hdr0=''),
    13824 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=13824, CurrentID=0, Status='live', Symbol='Epb41l4a', Aliases=['Epb4.1', 'Epb4.1l4', 'Epb4.1l4a', 'NB', 'NBL4'], description='erythrocyte membrane protein band 4.1 like 4a', other_designations='band 4.1-like protein 4A|erythrocyte protein band 4.1-like 4|erythrocyte protein band 4.1-like 4a', map_location='18 B1', chromosome='18', genomic_nucleotide_accession_version='NC_000084.6', start_position_on_the_genomic_accession=33796327, end_position_on_the_genomic_accession=34007484, orientation='minus', exon_count=28, OMIM=[], no_hdr0=''),
    13828 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=13828, CurrentID=0, Status='live', Symbol='Epb42', Aliases=['Epb4.', 'Epb4.2'], description='erythrocyte membrane protein band 4.2', other_designations='erythrocyte membrane protein band 4.2|P4.2|erythrocyte protein 4.2|erythrocyte protein band 4.2', map_location='2 60.37 cM', chromosome='2', genomic_nucleotide_accession_version='NC_000068.7', start_position_on_the_genomic_accession=121017891, end_position_on_the_genomic_accession=121036877, orientation='minus', exon_count=14, OMIM=[], no_hdr0=''),
    13829 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=13829, CurrentID=0, Status='live', Symbol='Dmtn', Aliases=['AI325486', 'Epb4.', 'Epb4.9', 'Epb49', 'dema', 'dematin'], description='dematin actin binding protein', other_designations='dematin|erythrocyte membrane protein band 4.9|erythrocyte protein band 4.9', map_location='14 36.32 cM', chromosome='14', genomic_nucleotide_accession_version='NC_000080.6', start_position_on_the_genomic_accession=70602184, end_position_on_the_genomic_accession=70636048, orientation='minus', exon_count=19, OMIM=[], no_hdr0=''),
    13830 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=13830, CurrentID=0, Status='live', Symbol='Stom', Aliases=['Epb7.', 'Epb7.2', 'sto'], description='stomatin', other_designations='erythrocyte band 7 integral membrane protein|erythrocyte protein band 7.2|erythrocyte protein band 7.2; protein 7.2b|protein 7.2b', map_location='2 23.53 cM', chromosome='2', genomic_nucleotide_accession_version='NC_000068.7', start_position_on_the_genomic_accession=35313990, end_position_on_the_genomic_accession=35337009, orientation='minus', exon_count=7, OMIM=[], no_hdr0=''),
    13831 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=13831, CurrentID=0, Status='live', Symbol='Epc1', Aliases=['2400007E14Rik', '5730566F07Rik', 'A930032N02Rik', 'mir-1893'], description='enhancer of polycomb homolog 1', other_designations='enhancer of polycomb homolog 1', map_location='18 A1', chromosome='18', genomic_nucleotide_accession_version='NC_000084.6', start_position_on_the_genomic_accession=6435951, end_position_on_the_genomic_accession=6516108, orientation='minus', exon_count=16, OMIM=[], no_hdr0=''),
    13835 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=13835, CurrentID=0, Status='live', Symbol='Epha1', Aliases=['5730453L17Rik', 'AL033318', 'Ep', 'Eph', 'Es', 'Esk'], description='Eph receptor A1', other_designations='ephrin type-A receptor 1|embryonic stem cell kinase|mEpha1|tyrosine-protein kinase receptor ESK', map_location='6 B2.1', chromosome='6', genomic_nucleotide_accession_version='NC_000072.6', start_position_on_the_genomic_accession=42358487, end_position_on_the_genomic_accession=42373314, orientation='minus', exon_count=18, OMIM=[], no_hdr0=''),
    13836 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=13836, CurrentID=0, Status='live', Symbol='Epha2', Aliases=['AW545284', 'Eck', 'Myk2', 'Sek', 'Sek-', 'Sek-2', 'Sek2'], description='Eph receptor A2', other_designations='ephrin type-A receptor 2|epithelial cell kinase|tyrosine-protein kinase receptor ECK|tyrosine-protein kinase receptor MPK-5|tyrosine-protein kinase receptor SEK-2', map_location='4 73.67 cM', chromosome='4', genomic_nucleotide_accession_version='NC_000070.6', start_position_on_the_genomic_accession=141301221, end_position_on_the_genomic_accession=141329384, orientation='plus', exon_count=18, OMIM=[], no_hdr0=''),
    13837 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=13837, CurrentID=0, Status='live', Symbol='Epha3', Aliases=['AW492086', 'Cek4', 'EK4', 'ETK1', 'End', 'End3', 'Hek', 'Hek4', 'Mek4', 'Tyr', 'Tyro4'], description='Eph receptor A3', other_designations='ephrin type-A receptor 3|EPH-like kinase 4|tyrosine-protein kinase TYRO4|tyrosine-protein kinase receptor ETK1', map_location='16 C1.3', chromosome='16', genomic_nucleotide_accession_version='NC_000082.6', start_position_on_the_genomic_accession=63543532, end_position_on_the_genomic_accession=63864175, orientation='minus', exon_count=17, OMIM=[], no_hdr0=''),
    13838 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=13838, CurrentID=0, Status='live', Symbol='Epha4', Aliases=['2900005C20Rik', 'AI385584', 'Cek8', 'Hek8', 'Se', 'Sek', 'Sek1', 'Tyr', 'Tyro1', 'r', 'rb'], description='Eph receptor A4', other_designations='ephrin type-A receptor 4|tyrosine-protein kinase receptor MPK-3|tyrosine-protein kinase receptor SEK-1', map_location='1 39.55 cM', chromosome='1', genomic_nucleotide_accession_version='NC_000067.6', start_position_on_the_genomic_accession=77367182, end_position_on_the_genomic_accession=77515107, orientation='minus', exon_count=18, OMIM=[], no_hdr0=''),
    13839 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=13839, CurrentID=0, Status='live', Symbol='Epha5', Aliases=['AI854630', 'AW125296', 'Cek7', 'Ehk1', 'El', 'Els1', 'Hek7', 'Rek', 'Rek7', 'bs', 'bsk'], description='Eph receptor A5', other_designations='ephrin type-A receptor 5|EPH homology kinase 1|brain-specific kinase|eck-like sequence 1', map_location='5 43.0 cM', chromosome='5', genomic_nucleotide_accession_version='NC_000071.6', start_position_on_the_genomic_accession=84054761, end_position_on_the_genomic_accession=84417818, orientation='minus', exon_count=20, OMIM=[], no_hdr0=''),
    13840 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=13840, CurrentID=0, Status='live', Symbol='Epha6', Aliases=['Ehk2', 'Hek12', 'm-ehk2'], description='Eph receptor A6', other_designations='ephrin type-A receptor 6|EHK-2|EPH homology kinase 2', map_location='16 C1.3', chromosome='16', genomic_nucleotide_accession_version='NC_000082.6', start_position_on_the_genomic_accession=59641433, end_position_on_the_genomic_accession=60610911, orientation='minus', exon_count=20, OMIM=[], no_hdr0=''),
    13841 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=13841, CurrentID=0, Status='live', Symbol='Epha7', Aliases=['Cek11', 'Ebk', 'Ehk3', 'Hek11', 'Mdk1'], description='Eph receptor A7', other_designations='ephrin type-A receptor 7|EPH homology kinase 3|developmental kinase 1|embryonic brain kinase', map_location='4 12.42 cM', chromosome='4', genomic_nucleotide_accession_version='NC_000070.6', start_position_on_the_genomic_accession=28813066, end_position_on_the_genomic_accession=28967503, orientation='plus', exon_count=20, OMIM=[], no_hdr0=''),
    13842 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=13842, CurrentID=0, Status='live', Symbol='Epha8', Aliases=['AW047546', 'Eek', 'Eph', 'Hek3', 'mKIAA1459'], description='Eph receptor A8', other_designations='ephrin type-A receptor 8|EPH- and ELK-related kinase|Ephrin type-A receptor 8 precursor (Tyrosine-protein kinase receptor EEK) (EPH-and ELK-related kinase)|tyrosine-protein kinase receptor EEK', map_location='4 D3', chromosome='4', genomic_nucleotide_accession_version='NC_000070.6', start_position_on_the_genomic_accession=136929419, end_position_on_the_genomic_accession=136956859, orientation='minus', exon_count=18, OMIM=[], no_hdr0=''),
    13844 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=13844, CurrentID=0, Status='live', Symbol='Ephb2', Aliases=['Cek5', 'Dr', 'Drt', 'ETECK', 'Er', 'Erk', 'Hek5', 'Nu', 'Nuk', 'Prk', 'Prkm5', 'Qek5', 'Sek', 'Sek3', 'Tyr', 'Tyro5'], description='Eph receptor B2', other_designations='ephrin type-B receptor 2|neural kinase|nuk receptor tyrosine kinase|tyrosine-protein kinase receptor EPH-3|tyrosine-protein kinase receptor SEK-3', map_location='4 69.0 cM', chromosome='4', genomic_nucleotide_accession_version='NC_000070.6', start_position_on_the_genomic_accession=136647536, end_position_on_the_genomic_accession=136836326, orientation='minus', exon_count=17, OMIM=[], no_hdr0=''),
    13845 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=13845, CurrentID=0, Status='live', Symbol='Ephb3', Aliases=['AW456895', 'Cek10', 'Etk2', 'HEK2', 'MDK5', 'Sek', 'Sek4', 'Tyr', 'Tyro6'], description='Eph receptor B3', other_designations='ephrin type-B receptor 3|developmental kinase 5|mDK-5|tyrosine-protein kinase receptor SEK-4', map_location='16 B1', chromosome='16', genomic_nucleotide_accession_version='NC_000082.6', start_position_on_the_genomic_accession=21204620, end_position_on_the_genomic_accession=21223309, orientation='plus', exon_count=17, OMIM=[], no_hdr0=''),
    13846 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=13846, CurrentID=0, Status='live', Symbol='Ephb4', Aliases=['AI042935', 'Htk', 'MDK2', 'Myk1', 'Tyro', 'Tyro11', 'b2b2412C', 'b2b2412Clo'], description='Eph receptor B4', other_designations='ephrin type-B receptor 4|developmental kinase 2|hepatoma transmembrane kinase|mDK-2|tyrosine kinase MYK-1', map_location='5 G2', chromosome='5', genomic_nucleotide_accession_version='NC_000071.6', start_position_on_the_genomic_accession=137350109, end_position_on_the_genomic_accession=137374522, orientation='plus', exon_count=17, OMIM=[], no_hdr0=''),
    13848 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=13848, CurrentID=0, Status='live', Symbol='Ephb6', Aliases=['Cek', 'Cekl', 'Me', 'Mep'], description='Eph receptor B6', other_designations='ephrin type-B receptor 6|chicken eph/elk receptor-like protein|ephrin type A receptor|tyrosine-protein kinase-defective receptor EPH-6', map_location='6 B2.1', chromosome='6', genomic_nucleotide_accession_version='NC_000072.6', start_position_on_the_genomic_accession=41603834, end_position_on_the_genomic_accession=41620509, orientation='plus', exon_count=18, OMIM=[], no_hdr0=''),
    13849 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=13849, CurrentID=0, Status='live', Symbol='Ephx1', Aliases=['EH', 'Eph', 'Eph-', 'Eph-1', 'Eph1', 'Epxh1', 'mEH'], description='epoxide hydrolase 1, microsomal', other_designations='epoxide hydrolase 1|epoxide hydratase|microsomal epoxide hydrolase', map_location='1 84.48 cM', chromosome='1', genomic_nucleotide_accession_version='NC_000067.6', start_position_on_the_genomic_accession=180989556, end_position_on_the_genomic_accession=181017569, orientation='minus', exon_count=9, OMIM=[], no_hdr0=''),
    13850 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=13850, CurrentID=0, Status='live', Symbol='Ephx2', Aliases=['CEH', 'Eph', 'Eph2', 'SEH', 's', 'sE', 'sEP'], description='epoxide hydrolase 2, cytoplasmic', other_designations='bifunctional epoxide hydrolase 2|cytosolic epoxide hydrolase|epoxide hydratase|epoxide hydrolase 2C|soluble epoxide hydrolase', map_location='14 34.36 cM', chromosome='14', genomic_nucleotide_accession_version='NC_000080.6', start_position_on_the_genomic_accession=66084372, end_position_on_the_genomic_accession=66124522, orientation='minus', exon_count=21, OMIM=[], no_hdr0=''),
    13852 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=13852, CurrentID=0, Status='live', Symbol='Stx2', Aliases=['AW538950', 'Ep', 'Epim', 'G1-536-1', 'Syn', 'Syn-2', 'rep', 'repro34'], description='syntaxin 2', other_designations='syntaxin-2|epimorphin', map_location='5 67.99 cM', chromosome='5', genomic_nucleotide_accession_version='NC_000071.6', start_position_on_the_genomic_accession=128984557, end_position_on_the_genomic_accession=129008600, orientation='minus', exon_count=12, OMIM=[], no_hdr0=''),
    13853 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=13853, CurrentID=0, Status='live', Symbol='Epm2a', Aliases=['TG-B', 'Tg(TcraK', 'TcrbK)TG-BFlv', 'l'], description='epilepsy, progressive myoclonic epilepsy, type 2 gene alpha', other_designations='laforin|LAFPTPase|glucan phosphatase|lafora PTPase', map_location='10 A1', chromosome='10', genomic_nucleotide_accession_version='NC_000076.6', start_position_on_the_genomic_accession=11342691, end_position_on_the_genomic_accession=11459664, orientation='plus', exon_count=5, OMIM=[], no_hdr0=''),
    13854 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=13854, CurrentID=0, Status='live', Symbol='Epn1', Aliases=['AA269831', 'Ib', 'Ibp1'], description='epsin 1', other_designations='epsin-1|EPS-15-interacting protein 1|intersectin-EH-binding protein 1', map_location='7 A1', chromosome='7', genomic_nucleotide_accession_version='NC_000073.6', start_position_on_the_genomic_accession=5080137, end_position_on_the_genomic_accession=5098179, orientation='plus', exon_count=13, OMIM=[], no_hdr0=''),
    13855 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=13855, CurrentID=0, Status='live', Symbol='Epn2', Aliases=['9530051D10Rik', 'AA536924', 'Ib', 'Ibp2'], description='epsin 2', other_designations='epsin-2|EPS-15-interacting protein 2|intersectin-EH-binding protein 2', map_location='11 B2', chromosome='11', genomic_nucleotide_accession_version='NC_000077.6', start_position_on_the_genomic_accession=61515883, end_position_on_the_genomic_accession=61579717, orientation='minus', exon_count=17, OMIM=[], no_hdr0=''),
    13856 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=13856, CurrentID=0, Status='live', Symbol='Epo', Aliases=[], description='erythropoietin', other_designations='erythropoietin', map_location='5 76.5 cM', chromosome='5', genomic_nucleotide_accession_version='NC_000071.6', start_position_on_the_genomic_accession=137483020, end_position_on_the_genomic_accession=137485816, orientation='minus', exon_count=5, OMIM=[], no_hdr0=''),
    13857 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=13857, CurrentID=0, Status='live', Symbol='Epor', Aliases=[], description='erythropoietin receptor', other_designations='erythropoietin receptor|EPO-R', map_location='9 7.93 cM', chromosome='9', genomic_nucleotide_accession_version='NC_000075.6', start_position_on_the_genomic_accession=21958897, end_position_on_the_genomic_accession=21963576, orientation='minus', exon_count=8, OMIM=[], no_hdr0=''),
    13858 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=13858, CurrentID=0, Status='live', Symbol='Eps15', Aliases=['2410112D09Rik'], description='epidermal growth factor receptor pathway substrate 15', other_designations='epidermal growth factor receptor substrate 15|epidermal growth factor pathway substrate 15|protein AF-1p', map_location='4 C7', chromosome='4', genomic_nucleotide_accession_version='NC_000070.6', start_position_on_the_genomic_accession=109280175, end_position_on_the_genomic_accession=109387817, orientation='plus', exon_count=25, OMIM=[], no_hdr0=''),
    13859 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=13859, CurrentID=0, Status='live', Symbol='Eps15l1', Aliases=['9830147J04Rik', 'AI593686', 'Eps', 'Eps1', 'Eps15-rs', 'Eps15R'], description='epidermal growth factor receptor pathway substrate 15-like 1', other_designations='epidermal growth factor receptor substrate 15-like 1|epidermal growth factor receptor pathway substrate 15-related sequence|eps15-related protein', map_location='8 B3.3', chromosome='8', genomic_nucleotide_accession_version='NC_000074.6', start_position_on_the_genomic_accession=72340990, end_position_on_the_genomic_accession=72421576, orientation='minus', exon_count=27, OMIM=[], no_hdr0=''),
    13860 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=13860, CurrentID=0, Status='live', Symbol='Eps8', Aliases=['AW261790'], description='epidermal growth factor receptor pathway substrate 8', other_designations='epidermal growth factor receptor kinase substrate 8', map_location='6 66.78 cM', chromosome='6', genomic_nucleotide_accession_version='NC_000072.6', start_position_on_the_genomic_accession=137477245, end_position_on_the_genomic_accession=137649397, orientation='minus', exon_count=26, OMIM=[], no_hdr0=''),
    13861 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=13861, CurrentID=0, Status='live', Symbol='Epx', Aliases=['E', 'EPO'], description='eosinophil peroxidase', other_designations='eosinophil peroxidase', map_location='11 52.25 cM', chromosome='11', genomic_nucleotide_accession_version='NC_000077.6', start_position_on_the_genomic_accession=87863997, end_position_on_the_genomic_accession=87875536, orientation='minus', exon_count=14, OMIM=[], no_hdr0=''),
    13863 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=13863, CurrentID=0, Status='live', Symbol='Lcn5', Aliases=['E-RABP', 'Er', 'Erabp', 'MEP1', 'MEP10', 'mE-R'], description='lipocalin 5', other_designations='epididymal-specific lipocalin-5|epididymal retinoic acid binding protein|epididymal secretory protein 10', map_location='2 A3', chromosome='2', genomic_nucleotide_accession_version='NC_000068.7', start_position_on_the_genomic_accession=25657932, end_position_on_the_genomic_accession=25662230, orientation='plus', exon_count=8, OMIM=[], no_hdr0=''),
    13864 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=13864, CurrentID=0, Status='live', Symbol='Nr2f6', Aliases=['AV090102', 'COUP-T', 'COUP-TF3', 'EA', 'EAR2', 'Erb', 'Erbal2'], description='nuclear receptor subfamily 2, group F, member 6', other_designations='nuclear receptor subfamily 2 group F member 6|COUP transcription factor 3|EAR-2|V-erbA-related protein 2|avian erythroblastic leukemia viral (v-erb-a) oncogene homolog-like 2', map_location='8 34.43 cM', chromosome='8', genomic_nucleotide_accession_version='NC_000074.6', start_position_on_the_genomic_accession=71374118, end_position_on_the_genomic_accession=71381967, orientation='minus', exon_count=7, OMIM=[], no_hdr0=''),
    13865 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=13865, CurrentID=0, Status='live', Symbol='Nr2f1', Aliases=['COUP-', 'COUP-T', 'COUP-TF1', 'COUP-TFI', 'COUPTFA', 'EAR-3', 'EAR3', 'Erb', 'Erbal3', 'SVP44', 'Tcfcou', 'Tcfcoup1'], description='nuclear receptor subfamily 2, group F, member 1', other_designations='COUP transcription factor 1|COUP transcription factor I|V-erbA-related protein 3|avian erythroblastic leukemia viral (v-erb-a) oncogene homolog-like 3', map_location='13 41.38 cM', chromosome='13', genomic_nucleotide_accession_version='NC_000079.6', start_position_on_the_genomic_accession=78188971, end_position_on_the_genomic_accession=78198873, orientation='minus', exon_count=6, OMIM=[], no_hdr0=''),
    13866 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=13866, CurrentID=0, Status='live', Symbol='Erbb2', Aliases=['ErbB-', 'Erbb-2', 'HER', 'HER-', 'HER-2', 'HER2', 'Ne', 'Neu', 'c-erbB', 'c-erbB2', 'c-ne', 'c-neu', 'l11Ju', 'l11Jus8', 'mKIAA3023'], description='erb-b2 receptor tyrosine kinase 2', other_designations='receptor tyrosine-protein kinase erbB-2|Neu oncogene|avian erythroblastosis oncogene B 2|c-erbB-2|p185erbB2|proto-oncogene NEU|proto-oncogene c-ErbB-2|v-erb-b2 erythroblastic leukemia viral oncogene homolog 2, neuro/glioblastoma derived oncogene homolog', map_location='11 D', chromosome='11', genomic_nucleotide_accession_version='NC_000077.6', start_position_on_the_genomic_accession=98412484, end_position_on_the_genomic_accession=98437716, orientation='plus', exon_count=27, OMIM=[], no_hdr0=''),
    13867 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=13867, CurrentID=0, Status='live', Symbol='Erbb3', Aliases=['C76256', 'Erbb', 'Erbb-', 'Erbb-3r', 'HER', 'Her3', 'Erbb3'], description='erb-b2 receptor tyrosine kinase 3', other_designations='receptor tyrosine-protein kinase erbB-3|avian erythroblastosis oncogene B 3 receptor|c-erbB-3|glial growth factor receptor|proto-oncogene-like protein c-ErbB-3|v-erb-b2 erythroblastic leukemia viral oncogene homolog 3', map_location='10 77.1 cM', chromosome='10', genomic_nucleotide_accession_version='NC_000076.6', start_position_on_the_genomic_accession=128567523, end_position_on_the_genomic_accession=128589635, orientation='minus', exon_count=28, OMIM=[], no_hdr0=''),
    13869 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=13869, CurrentID=0, Status='live', Symbol='Erbb4', Aliases=['ErbB', 'Her', 'Her4', 'c-erbB-4'], description='erb-b2 receptor tyrosine kinase 4', other_designations='receptor tyrosine-protein kinase erbB-4|avian erythroblastosis oncogene B 4|proto-oncogene-like protein c-ErbB-4|v-erb-a erythroblastic leukemia viral oncogene homolog 4', map_location='1 33.8 cM', chromosome='1', genomic_nucleotide_accession_version='NC_000067.6', start_position_on_the_genomic_accession=68031884, end_position_on_the_genomic_accession=69108576, orientation='minus', exon_count=30, OMIM=[], no_hdr0=''),
    13870 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=13870, CurrentID=0, Status='live', Symbol='Ercc1', Aliases=['Ercc-', 'Ercc-1'], description='excision repair cross-complementing rodent repair deficiency, complementation group 1', other_designations='DNA excision repair protein ERCC-1', map_location='7 9.6 cM', chromosome='7', genomic_nucleotide_accession_version='NC_000073.6', start_position_on_the_genomic_accession=19344067, end_position_on_the_genomic_accession=19356524, orientation='plus', exon_count=10, OMIM=[], no_hdr0=''),
    13871 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=13871, CurrentID=0, Status='live', Symbol='Ercc2', Aliases=['AA407812', 'AU020867', 'AW240756', 'CXPD', 'Ercc-', 'Ercc-2', 'Mhdarc', 'Mhdarco15', 'RCO0', 'RCO015', 'XP', 'XPD'], description='excision repair cross-complementing rodent repair deficiency, complementation group 2', other_designations='general transcription and DNA repair factor IIH helicase subunit XPD|DNA excision repair protein ERCC-2|DNA repair protein complementing XP-D cells|TFIIH basal transcription factor complex helicase XPD subunit|xeroderma pigmentosum group D-complementing protein', map_location='7 9.62 cM', chromosome='7', genomic_nucleotide_accession_version='NC_000073.6', start_position_on_the_genomic_accession=19382017, end_position_on_the_genomic_accession=19395694, orientation='plus', exon_count=23, OMIM=[], no_hdr0=''),
    13872 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=13872, CurrentID=0, Status='live', Symbol='Ercc3', Aliases=['BTF2 p89', 'Ercc-3', 'XP', 'XPB'], description='excision repair cross-complementing rodent repair deficiency, complementation group 3', other_designations='general transcription and DNA repair factor IIH helicase subunit XPB|DNA excision repair protein ERCC-3|DNA repair protein complementing XP-B cells|TFIIH 89 kDa subunit|TFIIH basal transcription factor complex helicase XPB subunit|basic transcription factor 2 89 kDa subunit|xeroderma pigmentosum group B-complementing protein', map_location='18 B1', chromosome='18', genomic_nucleotide_accession_version='NC_000084.6', start_position_on_the_genomic_accession=32240304, end_position_on_the_genomic_accession=32270151, orientation='plus', exon_count=15, OMIM=[], no_hdr0=''),
    13874 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=13874, CurrentID=0, Status='live', Symbol='Ereg', Aliases=['E', 'EPR'], description='epiregulin', other_designations='proepiregulin', map_location='5 E1', chromosome='5', genomic_nucleotide_accession_version='NC_000071.6', start_position_on_the_genomic_accession=91074617, end_position_on_the_genomic_accession=91093649, orientation='plus', exon_count=5, OMIM=[], no_hdr0=''),
    13875 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=13875, CurrentID=0, Status='live', Symbol='Erf', Aliases=[], description='Ets2 repressor factor', other_designations='ETS domain-containing transcription factor ERF|Est2 repressor factor', map_location='7 13.73 cM', chromosome='7', genomic_nucleotide_accession_version='NC_000073.6', start_position_on_the_genomic_accession=25242560, end_position_on_the_genomic_accession=25251104, orientation='minus', exon_count=7, OMIM=[], no_hdr0=''),
    13876 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=13876, CurrentID=0, Status='live', Symbol='Erg', Aliases=['D030036I24Rik'], description='ETS transcription factor', other_designations='transcriptional regulator ERG|avian erythroblastosis virus E-26 (v-ets) oncogene related', map_location='16 56.04 cM', chromosome='16', genomic_nucleotide_accession_version='NC_000082.6', start_position_on_the_genomic_accession=95359169, end_position_on_the_genomic_accession=95586600, orientation='minus', exon_count=17, OMIM=[], no_hdr0=''),
    13877 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=13877, CurrentID=0, Status='live', Symbol='Erh', Aliases=['Me', 'Mer', 'Pr', 'Prei1'], description='ERH mRNA splicing and mitosis factor', other_designations='enhancer of rudimentary homolog|preimplantation protein 1', map_location='12 C3', chromosome='12', genomic_nucleotide_accession_version='NC_000078.6', start_position_on_the_genomic_accession=80634021, end_position_on_the_genomic_accession=80644111, orientation='minus', exon_count=6, OMIM=[], no_hdr0=''),
    13884 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=13884, CurrentID=0, Status='live', Symbol='Ces1c', Aliases=['Ces', 'Ces-N', 'Ee-1', 'Ee1', 'Es', 'Es-', 'Es-4', 'Es-N', 'Es1', 'Es4', 'EsN', 'PESN'], description='carboxylesterase 1C', other_designations='carboxylesterase 1C|PES-N|esterase 1|liver carboxylesterase N|lung surfactant convertase', map_location='8 44.99 cM', chromosome='8', genomic_nucleotide_accession_version='NC_000074.6', start_position_on_the_genomic_accession=93099015, end_position_on_the_genomic_accession=93131283, orientation='minus', exon_count=13, OMIM=[], no_hdr0=''),
    13885 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=13885, CurrentID=0, Status='live', Symbol='Esd', Aliases=['Es', 'Es-1', 'Es-10', 'Es1', 'Es10', 'FGH', 'sid478'], description='esterase D/formylglutathione hydrolase', other_designations='S-formylglutathione hydrolase|Sid 478|esterase 10|esterase D', map_location='14 39.38 cM', chromosome='14', genomic_nucleotide_accession_version='NC_000080.6', start_position_on_the_genomic_accession=74732151, end_position_on_the_genomic_accession=74750765, orientation='plus', exon_count=9, OMIM=[], no_hdr0=''),
    13897 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=13897, CurrentID=0, Status='live', Symbol='Ces1e', Aliases=['Eg', 'Es-2', 'Es-22', 'Es2', 'Es22', 'ega', 'egasyn'], description='carboxylesterase 1E', other_designations='carboxylesterase 1E|esterase-22|liver carboxylesterase 22', map_location='8 45.11 cM', chromosome='8', genomic_nucleotide_accession_version='NC_000074.6', start_position_on_the_genomic_accession=93201218, end_position_on_the_genomic_accession=93229631, orientation='minus', exon_count=14, OMIM=[], no_hdr0=''),
    13909 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=13909, CurrentID=0, Status='live', Symbol='Ces3b', Aliases=['Ces31L', 'Ces3L', 'EG13909', 'ES3', 'ES31L', 'Es31', 'Gm4738'], description='carboxylesterase 3B', other_designations='carboxylesterase 3B', map_location='8 D3', chromosome='8', genomic_nucleotide_accession_version='NC_000074.6', start_position_on_the_genomic_accession=105083733, end_position_on_the_genomic_accession=105093929, orientation='plus', exon_count=16, OMIM=[], no_hdr0=''),
    13924 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=13924, CurrentID=0, Status='live', Symbol='Ptprv', Aliases=['E', 'Esp', 'O', 'OST', 'OST-PTP', 'mOST'], description='protein tyrosine phosphatase, receptor type, V', other_designations='receptor-type tyrosine-protein phosphatase V|ES cell phosphatase|R-PTP-V|embryonic stem cell protein-tyrosine phosphatase|tyrosine phosphatase', map_location='1 E4', chromosome='1', genomic_nucleotide_accession_version='NC_000067.6', start_position_on_the_genomic_accession=135108498, end_position_on_the_genomic_accession=135132575, orientation='minus', exon_count=37, OMIM=[], no_hdr0=''),
    13927 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=13927, CurrentID=0, Status='live', Symbol='X83325', Aliases=['ESTM1', 'ESTM10'], description='EST X83325', other_designations='uncharacterized protein LOC13927', map_location='', chromosome='11', genomic_nucleotide_accession_version='', start_position_on_the_genomic_accession='', end_position_on_the_genomic_accession='', orientation='', exon_count='', OMIM=[], no_hdr0=''),
    13929 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=13929, CurrentID=0, Status='live', Symbol='Amz2', Aliases=['AA408420', 'ESTM1', 'ESTM12', 'X83328'], description='archaelysin family metallopeptidase 2', other_designations='archaemetzincin-2|archeobacterial metalloproteinase-like protein 2', map_location='11 71.89 cM', chromosome='11', genomic_nucleotide_accession_version='NC_000077.6', start_position_on_the_genomic_accession=109425946, end_position_on_the_genomic_accession=109438148, orientation='plus', exon_count=9, OMIM=[], no_hdr0=''),
    13935 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=13935, CurrentID=0, Status='live', Symbol='X83348', Aliases=['ESTM1', 'ESTM18'], description='EST X83348', other_designations='uncharacterized protein LOC13935', map_location='', chromosome='5', genomic_nucleotide_accession_version='', start_position_on_the_genomic_accession='', end_position_on_the_genomic_accession='', orientation='', exon_count='', OMIM=[], no_hdr0=''),
    13972 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=13972, CurrentID=0, Status='live', Symbol='Gnb1l', Aliases=['ESTM5', 'ESTM55', 'Gm16314', 'Me49f07', 'Wdr1', 'Wdr14', 'Wdvc', 'Wdvcf'], description='guanine nucleotide binding protein (G protein), beta polypeptide 1-like', other_designations='guanine nucleotide-binding protein subunit beta-like protein 1|WD repeat-containing protein 14|WD40 repeat-containing protein deleted in VCFS|g protein subunit beta-like protein 1', map_location='16 11.46 cM', chromosome='16', genomic_nucleotide_accession_version='NC_000082.6', start_position_on_the_genomic_accession=18497386, end_position_on_the_genomic_accession=18566680, orientation='plus', exon_count=13, OMIM=[], no_hdr0=''),
    13980 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=13980, CurrentID=0, Status='live', Symbol='X83319', Aliases=['ESTM', 'ESTM8'], description='EST X83319', other_designations='uncharacterized protein LOC13980', map_location='', chromosome='5', genomic_nucleotide_accession_version='', start_position_on_the_genomic_accession='', end_position_on_the_genomic_accession='', orientation='', exon_count='', OMIM=[], no_hdr0=''),
    13982 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=13982, CurrentID=0, Status='live', Symbol='Esr1', Aliases=['E', 'ER', 'ER-', 'ER-alpha', 'ER[', 'ERa', 'ERalpha', 'ESR', 'Es', 'Estr', 'Estra', 'Nr', 'Nr3a1'], description='estrogen receptor 1 (alpha)', other_designations='estrogen receptor|C-terminally-truncated estrogen receptor alpha product-4|C-terminally-truncated estrogen receptor alpha product-5|C-terminally-truncated estrogen receptor alpha product-6|C-terminally-truncated estrogen receptor alpha product-7|estradiol receptor|nuclear receptor subfamily 3 group A member 1', map_location='10 2.03 cM', chromosome='10', genomic_nucleotide_accession_version='NC_000076.6', start_position_on_the_genomic_accession=4611989, end_position_on_the_genomic_accession=5005633, orientation='plus', exon_count=21, OMIM=[], no_hdr0=''),
    13983 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=13983, CurrentID=0, Status='live', Symbol='Esr2', Aliases=['ER[b]', 'ERbe', 'ERbeta', 'Est', 'Estrb'], description='estrogen receptor 2 (beta)', other_designations='estrogen receptor beta|ER-beta|nuclear receptor subfamily 3 group A member 2|oestrogen receptor beta', map_location='12 33.52 cM', chromosome='12', genomic_nucleotide_accession_version='NC_000078.6', start_position_on_the_genomic_accession=76120419, end_position_on_the_genomic_accession=76177259, orientation='minus', exon_count=10, OMIM=[], no_hdr0=''),
    13984 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=13984, CurrentID=0, Status='live', Symbol='Esx1', Aliases=['Sp', 'Spx1'], description='extraembryonic, spermatogenesis, homeobox 1', other_designations='homeobox protein ESX1', map_location='X 59.1 cM', chromosome='X', genomic_nucleotide_accession_version='NC_000086.7', start_position_on_the_genomic_accession=137115397, end_position_on_the_genomic_accession=137122131, orientation='minus', exon_count=6, OMIM=[], no_hdr0=''),
    13990 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=13990, CurrentID=0, Status='live', Symbol='Smarcad1', Aliases=['AV081750', 'AW226546', 'D6P', 'D6Pas1', 'Etl', 'Etl1', 'etl-1', 'mKIAA1122'], description='SWI/SNF-related, matrix-associated actin-dependent regulator of chromatin, subfamily a, containing DEAD/H box 1', other_designations='SWI/SNF-related matrix-associated actin-dependent regulator of chromatin subfamily A containing DEAD/H box 1|ATP-dependent helicase SMARCAD1|enhancer trap locus 1|enhancer trap locus homolog 1', map_location='6 30.11 cM', chromosome='6', genomic_nucleotide_accession_version='NC_000072.6', start_position_on_the_genomic_accession=65042591, end_position_on_the_genomic_accession=65116061, orientation='plus', exon_count=31, OMIM=[], no_hdr0=''),
    13992 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=13992, CurrentID=0, Status='live', Symbol='Khdrbs3', Aliases=['Etl', 'Etle', 'SLM', 'SLM-2', 'Salp', 'Slm2', 'T-S', 'T-STAR'], description='KH domain containing, RNA binding, signal transduction associated 3', other_designations='KH domain-containing, RNA-binding, signal transduction-associated protein 3|RNA-binding protein Etoile|etoile|sam68-like mammalian protein 2', map_location='15 30.36 cM', chromosome='15', genomic_nucleotide_accession_version='NC_000081.6', start_position_on_the_genomic_accession=68928392, end_position_on_the_genomic_accession=69101794, orientation='plus', exon_count=12, OMIM=[], no_hdr0=''),
    13995 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=13995, CurrentID=0, Status='live', Symbol='Etohd1', Aliases=[], description='ethanol decreased 1', other_designations='ethanol decreased 1', map_location='', chromosome='', genomic_nucleotide_accession_version='', start_position_on_the_genomic_accession='', end_position_on_the_genomic_accession='', orientation='', exon_count='', OMIM=[], no_hdr0=''),
    13997 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=13997, CurrentID=0, Status='live', Symbol='Etohd3', Aliases=[], description='ethanol decreased 3', other_designations='ethanol decreased 3', map_location='', chromosome='7', genomic_nucleotide_accession_version='', start_position_on_the_genomic_accession='', end_position_on_the_genomic_accession='', orientation='', exon_count='', OMIM=[], no_hdr0=''),
    13998 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=13998, CurrentID=0, Status='live', Symbol='Fgd6', Aliases=['AA123052', 'Etohd', 'Etohd4', 'ZFYVE2', 'ZFYVE24'], description='FYVE, RhoGEF and PH domain containing 6', other_designations='FYVE, RhoGEF and PH domain-containing protein 6|ethanol decreased 4', map_location='10 C2', chromosome='10', genomic_nucleotide_accession_version='NC_000076.6', start_position_on_the_genomic_accession=94035979, end_position_on_the_genomic_accession=94145339, orientation='plus', exon_count=22, OMIM=[], no_hdr0=''),
    13999 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=13999, CurrentID=0, Status='live', Symbol='Gm14288', Aliases=[], description='predicted gene 14288', other_designations='uncharacterized protein LOC13999', map_location='2 H4', chromosome='2', genomic_nucleotide_accession_version='NC_000068.7', start_position_on_the_genomic_accession=175790548, end_position_on_the_genomic_accession=175801038, orientation='minus', exon_count=4, OMIM=[], no_hdr0=''),
    14000 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=14000, CurrentID=0, Status='live', Symbol='Drosha', Aliases=['1110013A17Rik', 'AI874853', 'Etoh', 'Etohi2', 'R', 'Rn3', 'Rnasen'], description='drosha, ribonuclease type III', other_designations='ribonuclease 3|RNase III|ethanol induced 2|protein Drosha|ribonuclease III, nuclear', map_location='15 A1', chromosome='15', genomic_nucleotide_accession_version='NC_000081.6', start_position_on_the_genomic_accession=12824804, end_position_on_the_genomic_accession=12935291, orientation='plus', exon_count=36, OMIM=[], no_hdr0=''),
    14001 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=14001, CurrentID=0, Status='live', Symbol='Etohi3', Aliases=[], description='ethanol induced 3', other_designations='ethanol induced 3', map_location='', chromosome='', genomic_nucleotide_accession_version='', start_position_on_the_genomic_accession='', end_position_on_the_genomic_accession='', orientation='', exon_count='', OMIM=[], no_hdr0=''),
    14003 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=14003, CurrentID=0, Status='live', Symbol='Etohi5', Aliases=[], description='ethanol induced 5', other_designations='ethanol induced 5', map_location='', chromosome='', genomic_nucleotide_accession_version='', start_position_on_the_genomic_accession='', end_position_on_the_genomic_accession='', orientation='', exon_count='', OMIM=[], no_hdr0=''),
    14004 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=14004, CurrentID=0, Status='live', Symbol='Chchd2', Aliases=['AL033347', 'Etoh', 'Etohi6'], description='coiled-coil-helix-coiled-coil-helix domain containing 2', other_designations='coiled-coil-helix-coiled-coil-helix domain-containing protein 2|coiled-coil-helix-coiled-coil-helix domain-containing protein 2, mitochondrial|ethanol induced 6', map_location='5 G1.3', chromosome='5', genomic_nucleotide_accession_version='NC_000071.6', start_position_on_the_genomic_accession=129881161, end_position_on_the_genomic_accession=129887470, orientation='minus', exon_count=4, OMIM=[], no_hdr0=''),
    14005 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=14005, CurrentID=0, Status='live', Symbol='Etohi7', Aliases=[], description='ethanol induced 7', other_designations='ethanol induced 7', map_location='', chromosome='', genomic_nucleotide_accession_version='', start_position_on_the_genomic_accession='', end_position_on_the_genomic_accession='', orientation='', exon_count='', OMIM=[], no_hdr0=''),
    14007 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=14007, CurrentID=0, Status='live', Symbol='Celf2', Aliases=['B230218O03', 'B230345P09Rik', 'C88023', 'CELF-2', 'CUG-BP2', 'Cugbp', 'Cugbp2', 'D230046B21Rik', 'ETR-', 'Etr-3', 'Na', 'Napor', 'Napor-2', 'mETR-3'], description='CUGBP, Elav-like family member 2', other_designations='CUGBP Elav-like family member 2|CUG triplet repeat, RNA binding protein 2|CUG-BP- and ETR-3-like factor 2|RNA-binding protein BRUNOL-3|bruno-like protein 3|elav-type RNA-binding protein 3|mNapor|neuroblastoma apoptosis-related RNA-binding protein', map_location='2 A1', chromosome='2', genomic_nucleotide_accession_version='NC_000068.7', start_position_on_the_genomic_accession=6539694, end_position_on_the_genomic_accession=7396341, orientation='minus', exon_count=23, OMIM=[], no_hdr0=''),
    14008 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=14008, CurrentID=0, Status='live', Symbol='Etv2', Aliases=['Etsr', 'Etsrp71'], description='ets variant 2', other_designations='ETS translocation variant 2|ets variant gene 2|ets-related protein 71', map_location='7 B1', chromosome='7', genomic_nucleotide_accession_version='NC_000073.6', start_position_on_the_genomic_accession=30633616, end_position_on_the_genomic_accession=30636509, orientation='minus', exon_count=7, OMIM=[], no_hdr0=''),
    14009 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=14009, CurrentID=0, Status='live', Symbol='Etv1', Aliases=['ER8', 'ER81', 'Etsr', 'Etsrp81'], description='ets variant 1', other_designations='ETS translocation variant 1|ets variant gene 1|ets-related protein 81', map_location='12 17.99 cM', chromosome='12', genomic_nucleotide_accession_version='NC_000078.6', start_position_on_the_genomic_accession=38780082, end_position_on_the_genomic_accession=38870483, orientation='plus', exon_count=18, OMIM=[], no_hdr0=''),
    14011 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=14011, CurrentID=0, Status='live', Symbol='Etv6', Aliases=['AW123102', 'AW557856', 'Te', 'Tel'], description='ets variant 6', other_designations='transcription factor ETV6|ETS translocation variant 6|ETS-related protein Tel1|ets variant gene 6 (TEL oncogene)|translocation-ets-leukemia', map_location='6 64.58 cM', chromosome='6', genomic_nucleotide_accession_version='NC_000072.6', start_position_on_the_genomic_accession=134035700, end_position_on_the_genomic_accession=134270158, orientation='plus', exon_count=11, OMIM=[], no_hdr0=''),
    14012 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=14012, CurrentID=0, Status='live', Symbol='Mpzl2', Aliases=['E', 'Ev', 'Eva', 'Eva1'], description='myelin protein zero-like 2', other_designations='myelin protein zero-like protein 2|epithelial V-like antigen 1', map_location='9 24.84 cM', chromosome='9', genomic_nucleotide_accession_version='NC_000075.6', start_position_on_the_genomic_accession=45042344, end_position_on_the_genomic_accession=45054043, orientation='plus', exon_count=6, OMIM=[], no_hdr0=''),
    14013 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=14013, CurrentID=0, Status='live', Symbol='Mecom', Aliases=['D630039M04Rik', 'Ev', 'Evi', 'Evi-1', 'Evi1', 'Jb', 'Jbo', 'MDS1-E', 'Mds', 'Mds1', 'Mds1-Evi1', 'Prd', 'Prdm3', 'ZNFPR', 'Znfpr1b1'], description='MDS1 and EVI1 complex locus', other_designations='histone-lysine N-methyltransferase MECOM|MDS1 and EVI1 complex locus protein EVI1|MDS1 and EVI1 complex locus protein MDS1|ecotropic viral integration site 1|ecotropic virus integration site 1 protein|myelodysplasia syndrome 1 protein homolog', map_location='3 12.66 cM', chromosome='3', genomic_nucleotide_accession_version='NC_000069.6', start_position_on_the_genomic_accession=29951296, end_position_on_the_genomic_accession=30509759, orientation='minus', exon_count=21, OMIM=[], no_hdr0=''),
    14016 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=14016, CurrentID=0, Status='live', Symbol='Evi12', Aliases=[], description='ecotropic viral integration site 12', other_designations='ecotropic viral integration site 12', map_location='', chromosome='10', genomic_nucleotide_accession_version='', start_position_on_the_genomic_accession='', end_position_on_the_genomic_accession='', orientation='', exon_count='', OMIM=[], no_hdr0=''),
    14017 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=14017, CurrentID=0, Status='live', Symbol='Evi2a', Aliases=['AW491894', 'Ev', 'Evi', 'Evi-2', 'Evi2'], description='ecotropic viral integration site 2a', other_designations='protein EVI2A|EVI-2A|ecotropic viral integration site 2A protein', map_location='11 46.81 cM', chromosome='11', genomic_nucleotide_accession_version='NC_000077.6', start_position_on_the_genomic_accession=79526560, end_position_on_the_genomic_accession=79530609, orientation='minus', exon_count=2, OMIM=[], no_hdr0=''),
    14020 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=14020, CurrentID=0, Status='live', Symbol='Evi5', Aliases=['NB', 'NB4S'], description='ecotropic viral integration site 5', other_designations='ecotropic viral integration site 5 protein|EVI-5', map_location='5 52.23 cM', chromosome='5', genomic_nucleotide_accession_version='NC_000071.6', start_position_on_the_genomic_accession=107744795, end_position_on_the_genomic_accession=107875107, orientation='minus', exon_count=28, OMIM=[], no_hdr0=''),
    14025 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=14025, CurrentID=0, Status='live', Symbol='Bcl11a', Aliases=['2810047E18Rik', 'BCL-11A', 'CTI', 'Ctip1', 'D930021L15Rik', 'Ev', 'Evi', 'Evi9', 'Evi9a', 'Evi9b', 'Evi9c', 'mKIAA1809'], description='B cell CLL/lymphoma 11A (zinc finger protein)', other_designations='B-cell lymphoma/leukemia 11A|B-cell CLL/lymphoma 11A|COUP-TF interacting protein 1|EVI-9|ecotropic viral integration site 9 protein|myeloid leukemia', map_location='11 A3.2', chromosome='11', genomic_nucleotide_accession_version='NC_000077.6', start_position_on_the_genomic_accession=24076564, end_position_on_the_genomic_accession=24173558, orientation='plus', exon_count=9, OMIM=[], no_hdr0=''),
    14026 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=14026, CurrentID=0, Status='live', Symbol='Evl', Aliases=['AI528774', 'b2b2600C', 'b2b2600Clo'], description='Ena-vasodilator stimulated phosphoprotein', other_designations='ena/VASP-like protein', map_location='12 F1', chromosome='12', genomic_nucleotide_accession_version='NC_000078.6', start_position_on_the_genomic_accession=108554681, end_position_on_the_genomic_accession=108688516, orientation='plus', exon_count=17, OMIM=[], no_hdr0=''),
    14027 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=14027, CurrentID=0, Status='live', Symbol='Evpl', Aliases=[], description='envoplakin', other_designations='envoplakin|210 kDa cornified envelope precursor protein|210-kD protein|210kDa protein|p210', map_location='11 E2', chromosome='11', genomic_nucleotide_accession_version='NC_000077.6', start_position_on_the_genomic_accession=116220559, end_position_on_the_genomic_accession=116238165, orientation='minus', exon_count=21, OMIM=[], no_hdr0=''),
    14028 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=14028, CurrentID=0, Status='live', Symbol='Evx1', Aliases=['Evx-', 'Evx-1'], description='even-skipped homeobox 1', other_designations='homeobox even-skipped homolog protein 1|even skipped homeotic gene 1 homolog', map_location='6 B3', chromosome='6', genomic_nucleotide_accession_version='NC_000072.6', start_position_on_the_genomic_accession=52313498, end_position_on_the_genomic_accession=52318389, orientation='plus', exon_count=3, OMIM=[], no_hdr0=''),
    14029 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=14029, CurrentID=0, Status='live', Symbol='Evx2', Aliases=['Evx-', 'Evx-2'], description='even-skipped homeobox 2', other_designations='homeobox even-skipped homolog protein 2|even skipped homeotic gene 2 homolog', map_location='2 44.13 cM', chromosome='2', genomic_nucleotide_accession_version='NC_000068.7', start_position_on_the_genomic_accession=74652989, end_position_on_the_genomic_accession=74661520, orientation='minus', exon_count=4, OMIM=[], no_hdr0=''),
    14030 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=14030, CurrentID=0, Status='live', Symbol='Ewsr1', Aliases=['Ew', 'Ews', 'Ewsh'], description='Ewing sarcoma breakpoint region 1', other_designations='RNA-binding protein EWS|Ewing sarcoma homolog', map_location='11 A1', chromosome='11', genomic_nucleotide_accession_version='NC_000077.6', start_position_on_the_genomic_accession=5069687, end_position_on_the_genomic_accession=5099107, orientation='minus', exon_count=18, OMIM=[], no_hdr0=''),
    14038 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=14038, CurrentID=0, Status='live', Symbol='Wfdc18', Aliases=['Ex', 'Expi', 'Ka', 'Kal1', 'WDNM', 'WDNM1'], description='WAP four-disulfide core domain 18', other_designations='WAP four-disulfide core domain protein 18|Kallmann syndrome 1 sequence|extracellular peptidase inhibitor|extracellular proteinase inhibitor', map_location='11 C', chromosome='11', genomic_nucleotide_accession_version='NC_000077.6', start_position_on_the_genomic_accession=83709004, end_position_on_the_genomic_accession=83711360, orientation='plus', exon_count=3, OMIM=[], no_hdr0=''),
    14042 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=14042, CurrentID=0, Status='live', Symbol='Ext1', Aliases=['AA409028'], description='exostosin glycosyltransferase 1', other_designations='exostosin-1|exostoses (multiple) 1|glucuronosyl-N-acetylglucosaminyl-proteoglycan/N-acetylglucosaminyl-proteoglycan 4-alpha-N-acetylglucosaminyltransferase|multiple exostoses protein 1 homolog', map_location='15 20.0 cM', chromosome='15', genomic_nucleotide_accession_version='NC_000081.6', start_position_on_the_genomic_accession=53068261, end_position_on_the_genomic_accession=53346183, orientation='minus', exon_count=11, OMIM=[], no_hdr0=''),
    14043 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=14043, CurrentID=0, Status='live', Symbol='Ext2', Aliases=['AI893565'], description='exostosin glycosyltransferase 2', other_designations='exostosin-2|exostoses (multiple) 2|glucuronosyl-N-acetylglucosaminyl-proteoglycan/N-acetylglucosaminyl-proteoglycan 4-alpha-N-acetylglucosaminyltransferase|multiple exostoses protein 2 homolog', map_location='2 51.62 cM', chromosome='2', genomic_nucleotide_accession_version='NC_000068.7', start_position_on_the_genomic_accession=93695631, end_position_on_the_genomic_accession=93822568, orientation='minus', exon_count=17, OMIM=[], no_hdr0=''),
    14048 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=14048, CurrentID=0, Status='live', Symbol='Eya1', Aliases=['b', 'bor'], description='EYA transcriptional coactivator and phosphatase 1', other_designations='eyes absent homolog 1|eyes absent 1 homolog', map_location='1 4.31 cM', chromosome='1', genomic_nucleotide_accession_version='NC_000067.6', start_position_on_the_genomic_accession=14168953, end_position_on_the_genomic_accession=14311035, orientation='minus', exon_count=19, OMIM=[], no_hdr0=''),
    14049 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=14049, CurrentID=0, Status='live', Symbol='Eya2', Aliases=['Eab1'], description='EYA transcriptional coactivator and phosphatase 2', other_designations='eyes absent homolog 2|eyes absent 2 homolog', map_location='2 85.83 cM', chromosome='2', genomic_nucleotide_accession_version='NC_000068.7', start_position_on_the_genomic_accession=165595028, end_position_on_the_genomic_accession=165771727, orientation='plus', exon_count=19, OMIM=[], no_hdr0=''),
    14050 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=14050, CurrentID=0, Status='live', Symbol='Eya3', Aliases=['AI844637'], description='EYA transcriptional coactivator and phosphatase 3', other_designations='eyes absent homolog 3|eyes absent 3 homolog', map_location='4 65.68 cM', chromosome='4', genomic_nucleotide_accession_version='NC_000070.6', start_position_on_the_genomic_accession=132639025, end_position_on_the_genomic_accession=132724765, orientation='plus', exon_count=20, OMIM=[], no_hdr0=''),
    14051 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=14051, CurrentID=0, Status='live', Symbol='Eya4', Aliases=['B130023L16Rik'], description='EYA transcriptional coactivator and phosphatase 4', other_designations='eyes absent homolog 4|eyes absent 4 homolog', map_location='10 10.44 cM', chromosome='10', genomic_nucleotide_accession_version='NC_000076.6', start_position_on_the_genomic_accession=23102962, end_position_on_the_genomic_accession=23350838, orientation='minus', exon_count=27, OMIM=[], no_hdr0=''),
    14055 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=14055, CurrentID=0, Status='live', Symbol='Ezh1', Aliases=['ENX-2'], description='enhancer of zeste 1 polycomb repressive complex 2 subunit', other_designations='histone-lysine N-methyltransferase EZH1|enhancer of zeste homolog 1', map_location='11 64.37 cM', chromosome='11', genomic_nucleotide_accession_version='NC_000077.6', start_position_on_the_genomic_accession=101191115, end_position_on_the_genomic_accession=101226463, orientation='minus', exon_count=21, OMIM=[], no_hdr0=''),
    14056 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=14056, CurrentID=0, Status='live', Symbol='Ezh2', Aliases=['Enx-', 'Enx-1', 'Enx1', 'Enx1h', 'KMT6', 'mKIAA4065'], description='enhancer of zeste 2 polycomb repressive complex 2 subunit', other_designations='histone-lysine N-methyltransferase EZH2|enhancer of zeste homolog 2', map_location='6 22.92 cM', chromosome='6', genomic_nucleotide_accession_version='NC_000072.6', start_position_on_the_genomic_accession=47530274, end_position_on_the_genomic_accession=47595270, orientation='minus', exon_count=21, OMIM=[], no_hdr0=''),
    14057 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=14057, CurrentID=0, Status='live', Symbol='Sfxn1', Aliases=['2810002O05Rik', 'A930015P12Rik', 'f'], description='sideroflexin 1', other_designations='sideroflexin-1|flexed tail', map_location='13 28.4 cM', chromosome='13', genomic_nucleotide_accession_version='NC_000079.6', start_position_on_the_genomic_accession=54071656, end_position_on_the_genomic_accession=54108346, orientation='plus', exon_count=12, OMIM=[], no_hdr0=''),
    14058 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=14058, CurrentID=0, Status='live', Symbol='F10', Aliases=['AI1947', 'Cf10', 'fX'], description='coagulation factor X', other_designations='coagulation factor X|stuart factor', map_location='8 5.73 cM', chromosome='8', genomic_nucleotide_accession_version='NC_000074.6', start_position_on_the_genomic_accession=13037308, end_position_on_the_genomic_accession=13056676, orientation='plus', exon_count=9, OMIM=[], no_hdr0=''),
    14060 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=14060, CurrentID=0, Status='live', Symbol='F13b', Aliases=['Cf-13b', 'Cf13b'], description='coagulation factor XIII, beta subunit', other_designations='coagulation factor XIII B chain|protein-glutamine gamma-glutamyltransferase B chain|transglutaminase B chain', map_location='1 F', chromosome='1', genomic_nucleotide_accession_version='NC_000067.6', start_position_on_the_genomic_accession=139501547, end_position_on_the_genomic_accession=139523758, orientation='plus', exon_count=12, OMIM=[], no_hdr0=''),
    14061 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=14061, CurrentID=0, Status='live', Symbol='F2', Aliases=['Cf-2', 'Cf2', 'F', 'FII', 'prot', 'thro'], description='coagulation factor II', other_designations='prothrombin|thrombin', map_location='2 50.63 cM', chromosome='2', genomic_nucleotide_accession_version='NC_000068.7', start_position_on_the_genomic_accession=91612397, end_position_on_the_genomic_accession=91636457, orientation='minus', exon_count=16, OMIM=[], no_hdr0=''),
    14062 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=14062, CurrentID=0, Status='live', Symbol='F2r', Aliases=['AI482343', 'Cf2', 'Cf2r', 'P', 'Par1', 'Th', 'ThrR'], description='coagulation factor II (thrombin) receptor', other_designations='proteinase-activated receptor 1', map_location='13 50.21 cM', chromosome='13', genomic_nucleotide_accession_version='NC_000079.6', start_position_on_the_genomic_accession=95601780, end_position_on_the_genomic_accession=95618466, orientation='minus', exon_count=2, OMIM=[], no_hdr0=''),
    14063 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=14063, CurrentID=0, Status='live', Symbol='F2rl1', Aliases=['Gpcr', 'Gpcr11', 'P', 'PA', 'PAR-2', 'Par2'], description='coagulation factor II (thrombin) receptor-like 1', other_designations='proteinase-activated receptor 2|G-protein coupled receptor 11|Protease-activated receptor-2|coagulation factor II receptor-like 1|thrombin receptor-like 1', map_location='13 49.53 cM', chromosome='13', genomic_nucleotide_accession_version='NC_000079.6', start_position_on_the_genomic_accession=95511718, end_position_on_the_genomic_accession=95525240, orientation='minus', exon_count=2, OMIM=[], no_hdr0=''),
    14064 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=14064, CurrentID=0, Status='live', Symbol='F2rl2', Aliases=['F730031A08', 'P', 'PA', 'PAR3'], description='coagulation factor II (thrombin) receptor-like 2', other_designations='proteinase-activated receptor 3|PAR-3|Proteinase activated receptor 3 precursor (PAR-3) (Thrombin receptor-like 2) (Coagulation factor II receptor-like 2)|coagulation factor II receptor-like 2|protease-activated receptor 3|thrombin receptor-like 2', map_location='13 50.38 cM', chromosome='13', genomic_nucleotide_accession_version='NC_000079.6', start_position_on_the_genomic_accession=95696920, end_position_on_the_genomic_accession=95702768, orientation='plus', exon_count=2, OMIM=[], no_hdr0=''),
    14065 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=14065, CurrentID=0, Status='live', Symbol='F2rl3', Aliases=['P', 'PAR4'], description='coagulation factor II (thrombin) receptor-like 3', other_designations='proteinase-activated receptor 4|PAR-4|coagulation factor II receptor-like 3|thrombin receptor-like 3', map_location='8 B3.3', chromosome='8', genomic_nucleotide_accession_version='NC_000074.6', start_position_on_the_genomic_accession=72761659, end_position_on_the_genomic_accession=72763898, orientation='plus', exon_count=2, OMIM=[], no_hdr0=''),
    14066 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=14066, CurrentID=0, Status='live', Symbol='F3', Aliases=['AA409063', 'CD142', 'Cf-3', 'Cf3', 'TF'], description='coagulation factor III', other_designations='tissue factor', map_location='3 52.94 cM', chromosome='3', genomic_nucleotide_accession_version='NC_000069.6', start_position_on_the_genomic_accession=121723537, end_position_on_the_genomic_accession=121735052, orientation='plus', exon_count=6, OMIM=[], no_hdr0=''),
    14067 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=14067, CurrentID=0, Status='live', Symbol='F5', Aliases=['AI173222', 'Cf-5', 'Cf5'], description='coagulation factor V', other_designations='coagulation factor V|activated protein C cofactor', map_location='1 71.46 cM', chromosome='1', genomic_nucleotide_accession_version='NC_000067.6', start_position_on_the_genomic_accession=164151835, end_position_on_the_genomic_accession=164220277, orientation='plus', exon_count=25, OMIM=[], no_hdr0=''),
    14068 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=14068, CurrentID=0, Status='live', Symbol='F7', Aliases=['AI132620', 'Cf7', 'F', 'FVII'], description='coagulation factor VII', other_designations='coagulation factor VII|serum prothrombin conversion accelerator', map_location='8 5.73 cM', chromosome='8', genomic_nucleotide_accession_version='NC_000074.6', start_position_on_the_genomic_accession=13025506, end_position_on_the_genomic_accession=13035809, orientation='plus', exon_count=8, OMIM=[], no_hdr0=''),
    14069 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=14069, CurrentID=0, Status='live', Symbol='F8', Aliases=['Cf-8', 'Cf8', 'F', 'FVIII'], description='coagulation factor VIII', other_designations='coagulation factor VIII|Factor VIII|procoagulant component', map_location='X 38.17 cM', chromosome='X', genomic_nucleotide_accession_version='NC_000086.7', start_position_on_the_genomic_accession=75170344, end_position_on_the_genomic_accession=75382738, orientation='minus', exon_count=28, OMIM=[], no_hdr0=''),
    14070 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=14070, CurrentID=0, Status='live', Symbol='F8a', Aliases=['AI852759', 'DXUcsf', 'DXUcsf11', 'F8a'], description='factor 8-associated gene A', other_designations='40-kDa huntingtin-associated protein|Factor VIII associated protein|cpG island protein|factor VIII intron 22 protein', map_location='X 37.29 cM', chromosome='X', genomic_nucleotide_accession_version='NC_000086.7', start_position_on_the_genomic_accession=73228306, end_position_on_the_genomic_accession=73230795, orientation='plus', exon_count=1, OMIM=[], no_hdr0=''),
    14071 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=14071, CurrentID=0, Status='live', Symbol='F9', Aliases=['AW111646', 'Cf-9', 'Cf9'], description='coagulation factor IX', other_designations='coagulation factor IX|christmas factor', map_location='X 33.5 cM', chromosome='X', genomic_nucleotide_accession_version='NC_000086.7', start_position_on_the_genomic_accession=59999329, end_position_on_the_genomic_accession=60030760, orientation='plus', exon_count=8, OMIM=[], no_hdr0=''),
    14073 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=14073, CurrentID=0, Status='live', Symbol='Faah', Aliases=['AW412498'], description='fatty acid amide hydrolase', other_designations='fatty-acid amide hydrolase 1|amide hydrolase|anandamide amidohydrolase 1|fatty acid amide hydrolase protein|fatty acid ester hydrolase|oleamide hydrolase 1', map_location='4 53.08 cM', chromosome='4', genomic_nucleotide_accession_version='NC_000070.6', start_position_on_the_genomic_accession=115996668, end_position_on_the_genomic_accession=116018837, orientation='minus', exon_count=15, OMIM=[], no_hdr0=''),
    14077 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=14077, CurrentID=0, Status='live', Symbol='Fabp3', Aliases=['Fab', 'Fabp', 'Fabph', 'Fabph-1', 'Fabph-4', 'Fabph1', 'Fabph4', 'H-FA', 'H-FABP', 'Mdg', 'Mdgi'], description='fatty acid binding protein 3, muscle and heart', other_designations='fatty acid-binding protein, heart|fatty acid binding protein heart 1|fatty acid binding protein heart 4|fatty acid-binding protein 3|heart-type fatty acid-binding protein|mammary-derived growth inhibitor', map_location='4 63.43 cM', chromosome='4', genomic_nucleotide_accession_version='NC_000070.6', start_position_on_the_genomic_accession=130308738, end_position_on_the_genomic_accession=130315463, orientation='plus', exon_count=4, OMIM=[], no_hdr0=''),
    14079 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=14079, CurrentID=0, Status='live', Symbol='Fabp2', Aliases=['Fa', 'Fabpi', 'I-F', 'I-FABP'], description='fatty acid binding protein 2, intestinal', other_designations='fatty acid-binding protein, intestinal|intestinal fatty acid binding protein 2|intestinal-type fatty acid-binding protein', map_location='3 53.74 cM', chromosome='3', genomic_nucleotide_accession_version='NC_000069.6', start_position_on_the_genomic_accession=122895072, end_position_on_the_genomic_accession=122899506, orientation='plus', exon_count=4, OMIM=[], no_hdr0=''),
    14080 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=14080, CurrentID=0, Status='live', Symbol='Fabp1', Aliases=['Fa', 'Fabpl', 'L-F', 'L-FABP'], description='fatty acid binding protein 1, liver', other_designations='fatty acid-binding protein, liver|14 kDa selenium-binding protein|fatty acid-binding protein 1|liver-type fatty acid-binding protein', map_location='6 32.14 cM', chromosome='6', genomic_nucleotide_accession_version='NC_000072.6', start_position_on_the_genomic_accession=71199879, end_position_on_the_genomic_accession=71205034, orientation='plus', exon_count=4, OMIM=[], no_hdr0=''),
    14081 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=14081, CurrentID=0, Status='live', Symbol='Acsl1', Aliases=['Ac', 'Acas', 'Acas1', 'Acs', 'FACS', 'Fac', 'Facl2', 'LACS 1', 'LACS1'], description='acyl-CoA synthetase long-chain family member 1', other_designations='long-chain-fatty-acid--CoA ligase 1|acetate-CoA ligase|acetyl-CoA synthetase|acetyl-Coenzyme A synthetase 1 (ADP forming)|arachidonate--CoA ligase|fatty acid Coenzyme A ligase, long chain 2|long-chain acyl-CoA synthetase 1|phytanate--CoA ligase', map_location='8 B1.1', chromosome='8', genomic_nucleotide_accession_version='NC_000074.6', start_position_on_the_genomic_accession=46471037, end_position_on_the_genomic_accession=46536051, orientation='plus', exon_count=27, OMIM=[], no_hdr0=''),
    14082 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=14082, CurrentID=0, Status='live', Symbol='Fadd', Aliases=['Mort1/F', 'Mort1/FADD'], description='Fas (TNFRSF6)-associated via death domain', other_designations='FAS-associated death domain protein|FAS-associating death domain-containing protein|Fas-associating protein with death domain|mediator of receptor induced toxicity|protein FADD', map_location='7 88.85 cM', chromosome='7', genomic_nucleotide_accession_version='NC_000073.6', start_position_on_the_genomic_accession=144578323, end_position_on_the_genomic_accession=144582441, orientation='minus', exon_count=2, OMIM=[], no_hdr0=''),
    14083 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=14083, CurrentID=0, Status='live', Symbol='Ptk2', Aliases=['FA', 'FADK 1', 'FAK', 'FR', 'FRNK', 'Fad', 'Fadk', 'p125FAK'], description='PTK2 protein tyrosine kinase 2', other_designations='focal adhesion kinase 1|focal adhesion kinase-related nonkinase|focal ashension kinase 1|pp125FAK|protein-tyrosine kinase 2', map_location='15 33.94 cM', chromosome='15', genomic_nucleotide_accession_version='NC_000081.6', start_position_on_the_genomic_accession=73205102, end_position_on_the_genomic_accession=73423820, orientation='minus', exon_count=43, OMIM=[], no_hdr0=''),
    14084 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=14084, CurrentID=0, Status='live', Symbol='Faf1', Aliases=['AA408698', 'Dffr', 'Dffrx', 'Fa', 'Fam'], description='Fas-associated factor 1', other_designations='FAS-associated factor 1', map_location='4 51.33 cM', chromosome='4', genomic_nucleotide_accession_version='NC_000070.6', start_position_on_the_genomic_accession=109676627, end_position_on_the_genomic_accession=109963960, orientation='plus', exon_count=19, OMIM=[], no_hdr0=''),
    14085 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=14085, CurrentID=0, Status='live', Symbol='Fah', Aliases=['sw', 'swst'], description='fumarylacetoacetate hydrolase', other_designations='fumarylacetoacetase|FAA|beta-diketonase', map_location='7 48.36 cM', chromosome='7', genomic_nucleotide_accession_version='NC_000073.6', start_position_on_the_genomic_accession=84585159, end_position_on_the_genomic_accession=84605942, orientation='minus', exon_count=14, OMIM=[], no_hdr0=''),
    14086 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=14086, CurrentID=0, Status='live', Symbol='Fscn1', Aliases=['AI663989', 'Fa', 'Fan1', 'fasc', 'fascin-1'], description='fascin actin-bundling protein 1', other_designations='fascin|fascin 1|singed-like protein', map_location='5 81.84 cM', chromosome='5', genomic_nucleotide_accession_version='NC_000071.6', start_position_on_the_genomic_accession=142960355, end_position_on_the_genomic_accession=142973189, orientation='plus', exon_count=5, OMIM=[], no_hdr0=''),
    14087 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=14087, CurrentID=0, Status='live', Symbol='Fanca', Aliases=['AW208693', 'FACA'], description='Fanconi anemia, complementation group A', other_designations='Fanconi anemia group A protein homolog', map_location='8 72.1 cM', chromosome='8', genomic_nucleotide_accession_version='NC_000074.6', start_position_on_the_genomic_accession=123266294, end_position_on_the_genomic_accession=123318651, orientation='minus', exon_count=46, OMIM=[], no_hdr0=''),
    14088 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=14088, CurrentID=0, Status='live', Symbol='Fancc', Aliases=['Fac', 'Facc'], description='Fanconi anemia, complementation group C', other_designations='Fanconi anemia group C protein homolog', map_location='13 32.8 cM', chromosome='13', genomic_nucleotide_accession_version='NC_000079.6', start_position_on_the_genomic_accession=63301334, end_position_on_the_genomic_accession=63497292, orientation='minus', exon_count=22, OMIM=[], no_hdr0=''),
    14089 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=14089, CurrentID=0, Status='live', Symbol='Fap', Aliases=['SIMP'], description='fibroblast activation protein', other_designations='prolyl endopeptidase FAP|FAPalpha|dipeptidyl peptidase FAP|fibroblast activation protein alpha|gelatine degradation protease FAP|integral membrane serine protease|post-proline cleaving enzyme|seprase|serine integral membrane protease|surface-expressed protease', map_location='2 35.85 cM', chromosome='2', genomic_nucleotide_accession_version='NC_000068.7', start_position_on_the_genomic_accession=62500936, end_position_on_the_genomic_accession=62575509, orientation='minus', exon_count=28, OMIM=[], no_hdr0=''),
    14102 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=14102, CurrentID=0, Status='live', Symbol='Fas', Aliases=['AI196731', 'AP', 'APO1', 'APT1', 'CD95', 'TNF', 'TNFR6', 'Tnfr', 'Tnfrsf6', 'lpr'], description='Fas (TNF receptor superfamily member 6)', other_designations='tumor necrosis factor receptor superfamily member 6|FASLG receptor|Fas (TNF receptor superfamily member)|Fas antigen|apo-1 antigen|apoptosis-mediating surface antigen FAS|lymphoproliferation', map_location='19 29.48 cM', chromosome='19', genomic_nucleotide_accession_version='NC_000085.6', start_position_on_the_genomic_accession=34290647, end_position_on_the_genomic_accession=34327775, orientation='plus', exon_count=13, OMIM=[], no_hdr0=''),
    14103 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=14103, CurrentID=0, Status='live', Symbol='Fasl', Aliases=['APT1', 'APT1LG1', 'CD178', 'CD95', 'CD95-L', 'CD95L', 'F', 'Fa', 'Fas-Lg', 'Tnfs', 'Tnfsf6', 'Tnlg1a', 'gld', 'Fasl'], description='Fas ligand (TNF superfamily, member 6)', other_designations='tumor necrosis factor ligand superfamily member 6|CD95 ligand|Fas antigen ligand|generalized lymphoproliferative disease|tumor necrosis factor ligand 1a', map_location='1 69.95 cM', chromosome='1', genomic_nucleotide_accession_version='NC_000067.6', start_position_on_the_genomic_accession=161780691, end_position_on_the_genomic_accession=161788495, orientation='minus', exon_count=4, OMIM=[], no_hdr0=''),
    14104 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=14104, CurrentID=0, Status='live', Symbol='Fasn', Aliases=['A630082H08Rik', 'F', 'FAS'], description='fatty acid synthase', other_designations='fatty acid synthase|type I Fatty Acid Synthase', map_location='11 84.56 cM', chromosome='11', genomic_nucleotide_accession_version='NC_000077.6', start_position_on_the_genomic_accession=120805958, end_position_on_the_genomic_accession=120825166, orientation='minus', exon_count=44, OMIM=[], no_hdr0=''),
    14105 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=14105, CurrentID=0, Status='live', Symbol='Srsf10', Aliases=['FUS', 'FUSIP2', 'Fusip1', 'N', 'NSSR1', 'NSSR2', 'Nssr', 'SR', 'SRrp40', 'Sfr', 'Sfrs13a', 'Srs', 'Srsf13a', 'TA', 'TASR', 'TASR1', 'TASR2'], description='serine and arginine-rich splicing factor 10', other_designations='serine/arginine-rich splicing factor 10|FUS-interacting serine-arginine-rich protein 1|Fus-associated protein with serine-arginine repeats|TLS-associated SR protein|TLS-associated protein with SR repeats|TLS-associated protein with Ser-Arg repeats|TLS-associated serine-arginine protein|neural-salient serine/arginine-rich protein|neural-specific SR protein|serine/arginine-rich splicing factor 13A', map_location='4 D3', chromosome='4', genomic_nucleotide_accession_version='NC_000070.6', start_position_on_the_genomic_accession=135855752, end_position_on_the_genomic_accession=135869908, orientation='plus', exon_count=7, OMIM=[], no_hdr0=''),
    14106 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=14106, CurrentID=0, Status='live', Symbol='Foxh1', Aliases=['Fas', 'Fast1', 'Fast2', 'fast-1', 'fast-2'], description='forkhead box H1', other_designations='forkhead box protein H1|FAST1 transcription factor|forkhead activin signal transducer 1|forkhead activin signal transducer 2', map_location='15 D3', chromosome='15', genomic_nucleotide_accession_version='NC_000081.6', start_position_on_the_genomic_accession=76667829, end_position_on_the_genomic_accession=76671614, orientation='minus', exon_count=3, OMIM=[], no_hdr0=''),
    14107 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=14107, CurrentID=0, Status='live', Symbol='Fat1', Aliases=['2310038E12Rik', 'AU023433', 'Fat', 'Fath', 'mFat', 'mFat1'], description='FAT atypical cadherin 1', other_designations='protocadherin Fat 1|FAT tumor suppressor homolog 1|fat 1 cadherin', map_location='8 24.81 cM', chromosome='8', genomic_nucleotide_accession_version='NC_000074.6', start_position_on_the_genomic_accession=44933100, end_position_on_the_genomic_accession=45052257, orientation='plus', exon_count=34, OMIM=[], no_hdr0=''),
    14109 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=14109, CurrentID=0, Status='live', Symbol='Fau', Aliases=['MNSFb', 'MNSFbeta'], description='Finkel-Biskis-Reilly murine sarcoma virus (FBR-MuSV) ubiquitously expressed (fox derived)', other_designations='40S ribosomal protein S30|MNSF-beta|monoclonal non-specific suppressor factor beta|monoclonal nonspecific suppressor factor beta|monoclonal nonspecific suppressor factor betamonoclonal nonspecific suppressor factor beta|ubiquitin-like protein FUBI', map_location='19 4.34 cM', chromosome='19', genomic_nucleotide_accession_version='NC_000085.6', start_position_on_the_genomic_accession=6057947, end_position_on_the_genomic_accession=6059524, orientation='plus', exon_count=5, OMIM=[], no_hdr0=''),
    14113 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=14113, CurrentID=0, Status='live', Symbol='Fbl', Aliases=['AL022665', 'FIB', 'FLRN', 'RNU', 'RNU3IP1'], description='fibrillarin', other_designations="rRNA 2'-O-methyltransferase fibrillarin|U6 snRNA 2'-O-methyltransferase fibrillarin|histone-glutamine methyltransferase|nucleolar protein 1", map_location='7 A3', chromosome='7', genomic_nucleotide_accession_version='NC_000073.6', start_position_on_the_genomic_accession=28168893, end_position_on_the_genomic_accession=28179269, orientation='plus', exon_count=10, OMIM=[], no_hdr0=''),
    14114 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=14114, CurrentID=0, Status='live', Symbol='Fbln1', Aliases=[], description='fibulin 1', other_designations='fibulin-1|BM-90|BM-90/fibulin extracellular matrix glyroprotein|FIBL-1|basement-membrane protein 90', map_location='15 E2', chromosome='15', genomic_nucleotide_accession_version='NC_000081.6', start_position_on_the_genomic_accession=85205949, end_position_on_the_genomic_accession=85286294, orientation='plus', exon_count=18, OMIM=[], no_hdr0=''),
    14115 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=14115, CurrentID=0, Status='live', Symbol='Fbln2', Aliases=['5730577E14Rik', 'FIBL-2'], description='fibulin 2', other_designations='fibulin-2', map_location='6 40.42 cM', chromosome='6', genomic_nucleotide_accession_version='NC_000072.6', start_position_on_the_genomic_accession=91212460, end_position_on_the_genomic_accession=91272540, orientation='plus', exon_count=19, OMIM=[], no_hdr0=''),
    14118 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=14118, CurrentID=0, Status='live', Symbol='Fbn1', Aliases=['AI536462', 'B430209H23', 'Fib-', 'Fib-1', 'Tsk'], description='fibrillin 1', other_designations='fibrillin-1|tight skin', map_location='2 61.38 cM', chromosome='2', genomic_nucleotide_accession_version='NC_000068.7', start_position_on_the_genomic_accession=125300594, end_position_on_the_genomic_accession=125506485, orientation='minus', exon_count=69, OMIM=[], no_hdr0=''),
    14119 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=14119, CurrentID=0, Status='live', Symbol='Fbn2', Aliases=['BC063774', 'Fib-', 'Fib-2', 'mKIAA4226', 's', 'sne', 'sy'], description='fibrillin 2', other_designations='fibrillin-2|syndatyly ems', map_location='18 32.15 cM', chromosome='18', genomic_nucleotide_accession_version='NC_000084.6', start_position_on_the_genomic_accession=58008623, end_position_on_the_genomic_accession=58210572, orientation='minus', exon_count=66, OMIM=[], no_hdr0=''),
    14120 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=14120, CurrentID=0, Status='live', Symbol='Fbp2', Aliases=['Fbp-', 'Fbp-1', 'Fbp1', 'Rae-30'], description='fructose bisphosphatase 2', other_designations='fructose-1,6-bisphosphatase isozyme 2|D-fructose-1,6-bisphosphate 1-phosphohydrolase 2|FBPase 2|FBPase muscle|muscle FBPase', map_location='13 B3', chromosome='13', genomic_nucleotide_accession_version='NC_000079.6', start_position_on_the_genomic_accession=62836884, end_position_on_the_genomic_accession=62858400, orientation='minus', exon_count=7, OMIM=[], no_hdr0=''),
    14121 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=14121, CurrentID=0, Status='live', Symbol='Fbp1', Aliases=['Fbp', 'Fbp-', 'Fbp-2', 'Fbp2', 'Fbp3'], description='fructose bisphosphatase 1', other_designations='fructose-1,6-bisphosphatase 1|D-fructose-1,6-bisphosphate 1-phosphohydrolase 1|D-fructose-1,6-bisphosphate 1-phosphohydrolase 3|FBPase liver|fructose-1,6-bisphosphatase isozyme 3|liver FBPase', map_location='13 B3', chromosome='13', genomic_nucleotide_accession_version='NC_000079.6', start_position_on_the_genomic_accession=62864753, end_position_on_the_genomic_accession=62888298, orientation='minus', exon_count=7, OMIM=[], no_hdr0=''),
    14123 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=14123, CurrentID=0, Status='live', Symbol='Fbrs', Aliases=['Fbs', 'Fbs1'], description='fibrosin', other_designations='probable fibrosin-1|fibrosin-1|probable fibrosin-1 long transcript protein', map_location='7 F3', chromosome='7', genomic_nucleotide_accession_version='NC_000073.6', start_position_on_the_genomic_accession=127478415, end_position_on_the_genomic_accession=127491513, orientation='plus', exon_count=18, OMIM=[], no_hdr0=''),
    14125 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=14125, CurrentID=0, Status='live', Symbol='Fcer1a', Aliases=['FcE', 'FcERI', 'Fce1', 'Fce1a', 'Fcr-', 'Fcr-5', 'fcepsilonri'], description='Fc receptor, IgE, high affinity I, alpha polypeptide', other_designations='high affinity immunoglobulin epsilon receptor subunit alpha|fc-epsilon RI-alpha|igE Fc receptor subunit alpha', map_location='1 80.33 cM', chromosome='1', genomic_nucleotide_accession_version='NC_000067.6', start_position_on_the_genomic_accession=173221269, end_position_on_the_genomic_accession=173227232, orientation='minus', exon_count=5, OMIM=[], no_hdr0=''),
    14126 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=14126, CurrentID=0, Status='live', Symbol='Ms4a2', Aliases=['FcR', 'FcRB', 'Fce1b', 'Fcer1', 'Fcer1b', 'Fcrbe', 'Fcrbeta', 'Ms4a1', 'fcERI'], description='membrane-spanning 4-domains, subfamily A, member 2', other_designations='high affinity immunoglobulin epsilon receptor subunit beta|Fc receptor, IgE, high affinity I, beta polypeptide|fc epsilon receptor I beta-chain|membrane-spanning 4-domains, subfamily A, member 1', map_location='19 8.46 cM', chromosome='19', genomic_nucleotide_accession_version='NC_000085.6', start_position_on_the_genomic_accession=11615517, end_position_on_the_genomic_accession=11623790, orientation='minus', exon_count=8, OMIM=[], no_hdr0=''),
    14127 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=14127, CurrentID=0, Status='live', Symbol='Fcer1g', Aliases=['AI573376', 'CD23', 'FcR-ga', 'FcR-gamma', 'FcR[g', 'FcR[g]', 'FcRga', 'FcRgamma', 'Fce', 'Fce1g', 'FcepsilonRI', 'Ly-5', 'Ly-50'], description='Fc receptor, IgE, high affinity I, gamma polypeptide', other_designations='high affinity immunoglobulin epsilon receptor subunit gamma|Fc receptor gamma-chain|fc-epsilon RI-gamma|fceRI gamma|igE Fc receptor subunit gamma', map_location='1 79.23 cM', chromosome='1', genomic_nucleotide_accession_version='NC_000067.6', start_position_on_the_genomic_accession=171229572, end_position_on_the_genomic_accession=171234349, orientation='minus', exon_count=5, OMIM=[], no_hdr0=''),
    14128 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=14128, CurrentID=0, Status='live', Symbol='Fcer2a', Aliases=['CD23', 'Fce2', 'Fcer2', 'Ly-4', 'Ly-42'], description='Fc receptor, IgE, low affinity II, alpha polypeptide', other_designations='low affinity immunoglobulin epsilon Fc receptor|FC epsilon RII|fc-epsilon-RII|low-affinity IgE receptor|lymphocyte IgE receptor', map_location='8 1.92 cM', chromosome='8', genomic_nucleotide_accession_version='NC_000074.6', start_position_on_the_genomic_accession=3680280, end_position_on_the_genomic_accession=3694174, orientation='minus', exon_count=13, OMIM=[], no_hdr0=''),
    14129 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=14129, CurrentID=0, Status='live', Symbol='Fcgr1', Aliases=['AI323638', 'AV092959', 'CD64', 'Fcgam', 'FcgammaRI', 'IGGHAFC'], description='Fc receptor, IgG, high affinity I', other_designations='high affinity immunoglobulin gamma Fc receptor I|IgG high affinity Fc receptor|fc-gamma RI|fcRI|igG Fc receptor I', map_location='3 41.72 cM', chromosome='3', genomic_nucleotide_accession_version='NC_000069.6', start_position_on_the_genomic_accession=96282909, end_position_on_the_genomic_accession=96293969, orientation='minus', exon_count=6, OMIM=[], no_hdr0=''),
    14130 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=14130, CurrentID=0, Status='live', Symbol='Fcgr2b', Aliases=['AI528646', 'CD32', 'F630109E10Rik', 'Fc[g]', 'Fc[g]RII', 'Fcg', 'FcgRII', 'Fcgamm', 'Fcgr', 'Fcgr2', 'Fcgr2a', 'Fcr-', 'Fcr-2', 'Fcr-3', 'Ly-1', 'Ly-17', 'Ly-m2', 'Ly-m20', 'LyM-', 'LyM-1', 'Lym-1', 'fcRII'], description='Fc receptor, IgG, low affinity IIb', other_designations='low affinity immunoglobulin gamma Fc region receptor II-b|Fc gamma RIIB|Fc-gamma-RII|FcgammaRIIB|fc gamma receptor IIB|fc-gamma RII|fc-gamma-RIIB|igG Fc receptor II beta|low affinity immunoglobulin gamma Fc region receptor II|lymphocyte antigen 17', map_location='1 78.02 cM', chromosome='1', genomic_nucleotide_accession_version='NC_000067.6', start_position_on_the_genomic_accession=170960558, end_position_on_the_genomic_accession=170976071, orientation='minus', exon_count=8, OMIM=[], no_hdr0=''),
    14131 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=14131, CurrentID=0, Status='live', Symbol='Fcgr3', Aliases=['CD16', 'Fcgam'], description='Fc receptor, IgG, low affinity III', other_designations='low affinity immunoglobulin gamma Fc region receptor III|Fc gamma receptor III|Fcg receptor III|FcgammaRIII|fc-gamma RIII|fcRIII|igG Fc receptor III', map_location='1 78.8 cM', chromosome='1', genomic_nucleotide_accession_version='NC_000067.6', start_position_on_the_genomic_accession=171051169, end_position_on_the_genomic_accession=171065915, orientation='minus', exon_count=10, OMIM=[], no_hdr0=''),
    14132 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=14132, CurrentID=0, Status='live', Symbol='Fcgrt', Aliases=['Fc', 'FcRn'], description='Fc receptor, IgG, alpha chain transporter', other_designations='IgG receptor FcRn large subunit p51|igG Fc fragment receptor transporter alpha chain|neonatal Fc receptor', map_location='7 29.12 cM', chromosome='7', genomic_nucleotide_accession_version='NC_000073.6', start_position_on_the_genomic_accession=45092993, end_position_on_the_genomic_accession=45103822, orientation='minus', exon_count=7, OMIM=[], no_hdr0=''),
    14133 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=14133, CurrentID=0, Status='live', Symbol='Fcna', Aliases=['Fcn', 'Fcn1'], description='ficolin A', other_designations='ficolin-1|M-ficolin|collagen/fibrinogen domain-containing protein 1|ficolin-alpha', map_location='2 A3', chromosome='2', genomic_nucleotide_accession_version='NC_000068.7', start_position_on_the_genomic_accession=25624665, end_position_on_the_genomic_accession=25635440, orientation='minus', exon_count=12, OMIM=[], no_hdr0=''),
    14134 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=14134, CurrentID=0, Status='live', Symbol='Fcnb', Aliases=['Fcn2'], description='ficolin B', other_designations='ficolin-2|L-ficolin|collagen/fibrinogen domain-containing protein 2|ficolin-beta', map_location='2 A3', chromosome='2', genomic_nucleotide_accession_version='NC_000068.7', start_position_on_the_genomic_accession=28076479, end_position_on_the_genomic_accession=28084910, orientation='minus', exon_count=10, OMIM=[], no_hdr0=''),
    14137 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=14137, CurrentID=0, Status='live', Symbol='Fdft1', Aliases=['S', 'SQS', 'SS'], description='farnesyl diphosphate farnesyl transferase 1', other_designations='squalene synthase|FPP:FPP farnesyltransferase|farnesyl-diphosphate farnesyltransferase', map_location='14 33.24 cM', chromosome='14', genomic_nucleotide_accession_version='NC_000080.6', start_position_on_the_genomic_accession=63145150, end_position_on_the_genomic_accession=63181687, orientation='minus', exon_count=10, OMIM=[], no_hdr0=''),
    14148 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=14148, CurrentID=0, Status='live', Symbol='Fdx1', Aliases=['ADRE'], description='ferredoxin 1', other_designations='adrenodoxin, mitochondrial|adrenal ferredoxin', map_location='9 A5.3', chromosome='9', genomic_nucleotide_accession_version='NC_000075.6', start_position_on_the_genomic_accession=51943023, end_position_on_the_genomic_accession=51963602, orientation='minus', exon_count=5, OMIM=[], no_hdr0=''),
    14149 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=14149, CurrentID=0, Status='live', Symbol='Fdxr', Aliases=['AR'], description='ferredoxin reductase', other_designations='NADPH:adrenodoxin oxidoreductase, mitochondrial|adrenodoxin reductase|ferredoxin--NADP(+) reductase', map_location='11 E2', chromosome='11', genomic_nucleotide_accession_version='NC_000077.6', start_position_on_the_genomic_accession=115268024, end_position_on_the_genomic_accession=115277101, orientation='minus', exon_count=12, OMIM=[], no_hdr0=''),
    14151 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=14151, CurrentID=0, Status='live', Symbol='Fech', Aliases=['AI894116', 'Fc', 'Fcl', 'fch'], description='ferrochelatase', other_designations='ferrochelatase, mitochondrial|heme synthase|heme synthetase|protoheme ferro-lyase', map_location='18 37.43 cM', chromosome='18', genomic_nucleotide_accession_version='NC_000084.6', start_position_on_the_genomic_accession=64456542, end_position_on_the_genomic_accession=64489098, orientation='minus', exon_count=11, OMIM=[], no_hdr0=''),
    14154 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=14154, CurrentID=0, Status='live', Symbol='Fem1a', Aliases=['AW611390a', 'Fem1a'], description='fem 1 homolog a', other_designations='protein fem-1 homolog A-A|FEM1-alpha-A|FEM1a-A|feminization 1 homolog a', map_location='17 29.24 cM', chromosome='17', genomic_nucleotide_accession_version='NC_000083.6', start_position_on_the_genomic_accession=56256793, end_position_on_the_genomic_accession=56263608, orientation='plus', exon_count=1, OMIM=[], no_hdr0=''),
    14155 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=14155, CurrentID=0, Status='live', Symbol='Fem1b', Aliases=['mKIAA0396'], description='fem 1 homolog b', other_designations='protein fem-1 homolog B|F1A-alpha|FEM1-beta|fem-1-like death receptor-binding protein alpha|fem-1-like in apoptotic pathway protein alpha|feminization 1 homolog b|mt-Fem', map_location='9 33.87 cM', chromosome='9', genomic_nucleotide_accession_version='NC_000075.6', start_position_on_the_genomic_accession=62791824, end_position_on_the_genomic_accession=62811648, orientation='minus', exon_count=2, OMIM=[], no_hdr0=''),
    14156 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=14156, CurrentID=0, Status='live', Symbol='Fen1', Aliases=['AW538437', 'FEN-1'], description='flap structure specific endonuclease 1', other_designations='flap endonuclease 1', map_location='19 A', chromosome='19', genomic_nucleotide_accession_version='NC_000085.6', start_position_on_the_genomic_accession=10199132, end_position_on_the_genomic_accession=10204393, orientation='minus', exon_count=3, OMIM=[], no_hdr0=''),
    14158 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=14158, CurrentID=0, Status='live', Symbol='Fer', Aliases=['AV082135', 'C330004K01Rikt', 'Fert2', 'Fer'], description='fer (fms/fps related) protein kinase', other_designations='tyrosine-protein kinase Fer|fer (fms/fps related) protein kinase, testis specific 2|p94-Fer|proto-oncogene c-Fer|proto-oncogene tyrosine-protein kinase Fer', map_location='17 E1.1', chromosome='17', genomic_nucleotide_accession_version='NC_000083.6', start_position_on_the_genomic_accession=63862073, end_position_on_the_genomic_accession=64146519, orientation='plus', exon_count=26, OMIM=[], no_hdr0=''),
    14159 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=14159, CurrentID=0, Status='live', Symbol='Fes', Aliases=['AI586313', 'BB137047', 'FPS', 'c-fe', 'c-fes'], description='feline sarcoma oncogene', other_designations='tyrosine-protein kinase Fes/Fps|proto-oncogene c-Fes|proto-oncogene tyrosine-protein kinase Fes/Fps|tyrosine kinase Fps/Fes', map_location='7 45.65 cM', chromosome='7', genomic_nucleotide_accession_version='NC_000073.6', start_position_on_the_genomic_accession=80377758, end_position_on_the_genomic_accession=80387954, orientation='minus', exon_count=19, OMIM=[], no_hdr0=''),
    14160 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=14160, CurrentID=0, Status='live', Symbol='Lgr5', Aliases=['FEX', 'Gpr', 'Gpr49'], description='leucine rich repeat containing G protein coupled receptor 5', other_designations='leucine-rich repeat-containing G-protein coupled receptor 5|G protein-coupled receptor 49|follicle expressed hormone|orphan G-protein coupled receptor FEX', map_location='10 D2', chromosome='10', genomic_nucleotide_accession_version='NC_000076.6', start_position_on_the_genomic_accession=115450314, end_position_on_the_genomic_accession=115587780, orientation='minus', exon_count=18, OMIM=[], no_hdr0=''),
    14161 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=14161, CurrentID=0, Status='live', Symbol='Fga', Aliases=['Fi', 'Fib'], description='fibrinogen alpha chain', other_designations='fibrinogen alpha chain|fibrinogen, A alpha polypeptide', map_location='3 36.96 cM', chromosome='3', genomic_nucleotide_accession_version='NC_000069.6', start_position_on_the_genomic_accession=83026153, end_position_on_the_genomic_accession=83033627, orientation='plus', exon_count=6, OMIM=[], no_hdr0=''),
    14163 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=14163, CurrentID=0, Status='live', Symbol='Fgd1', Aliases=['ZFYVE', 'ZFYVE3'], description='FYVE, RhoGEF and PH domain containing 1', other_designations='FYVE, RhoGEF and PH domain-containing protein 1|faciogenital dysplasia 1 protein homolog|rho/Rac GEF|rho/Rac guanine nucleotide exchange factor FGD1|zinc finger FYVE domain-containing protein 3', map_location='X 68.46 cM', chromosome='X', genomic_nucleotide_accession_version='NC_000086.7', start_position_on_the_genomic_accession=151046141, end_position_on_the_genomic_accession=151089686, orientation='plus', exon_count=19, OMIM=[], no_hdr0=''),
    14164 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=14164, CurrentID=0, Status='live', Symbol='Fgf1', Aliases=['Dffrx', 'Fam', 'Fgf', 'Fgf-1', 'Fgfa'], description='fibroblast growth factor 1', other_designations='fibroblast growth factor 1|HBGF-1|aFGF|acidic fibroblast growth factor|fibroblast growth factor 1 (acidic)|heparin-binding growth factor 1', map_location='18 20.74 cM', chromosome='18', genomic_nucleotide_accession_version='NC_000084.6', start_position_on_the_genomic_accession=38838672, end_position_on_the_genomic_accession=38929470, orientation='minus', exon_count=12, OMIM=[], no_hdr0=''),
    14165 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=14165, CurrentID=0, Status='live', Symbol='Fgf10', Aliases=['AEY1', 'AEY17', 'BB213776', 'Fgf-10', 'Gsfaey', 'Gsfaey17'], description='fibroblast growth factor 10', other_designations='fibroblast growth factor 10|keratinocyte growth factor 2', map_location='13 67.14 cM', chromosome='13', genomic_nucleotide_accession_version='NC_000079.6', start_position_on_the_genomic_accession=118714699, end_position_on_the_genomic_accession=118792573, orientation='plus', exon_count=3, OMIM=[], no_hdr0=''),
    14166 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=14166, CurrentID=0, Status='live', Symbol='Fgf11', Aliases=['Fgf-11', 'Fhf-3', 'Fhf3'], description='fibroblast growth factor 11', other_designations='fibroblast growth factor 11|fibroblast growth factor homologous factor 3', map_location='11 B3', chromosome='11', genomic_nucleotide_accession_version='NC_000077.6', start_position_on_the_genomic_accession=69796068, end_position_on_the_genomic_accession=69802944, orientation='minus', exon_count=6, OMIM=[], no_hdr0=''),
    14167 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=14167, CurrentID=0, Status='live', Symbol='Fgf12', Aliases=['AV114868', 'B230343J05R', 'B230343J05Rik', 'FGF-12', 'FHF-1', 'Fhf1'], description='fibroblast growth factor 12', other_designations='fibroblast growth factor 12|fibroblast growth factor homologous factor 1|myocyte-activating factor', map_location='16 19.38 cM', chromosome='16', genomic_nucleotide_accession_version='NC_000082.6', start_position_on_the_genomic_accession=28157783, end_position_on_the_genomic_accession=28753243, orientation='minus', exon_count=9, OMIM=[], no_hdr0=''),
    14168 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=14168, CurrentID=0, Status='live', Symbol='Fgf13', Aliases=['Fhf2'], description='fibroblast growth factor 13', other_designations='fibroblast growth factor 13|fibroblast growth factor homologous factor 2', map_location='X 33.31 cM', chromosome='X', genomic_nucleotide_accession_version='NC_000086.7', start_position_on_the_genomic_accession=59062139, end_position_on_the_genomic_accession=59585572, orientation='minus', exon_count=12, OMIM=[], no_hdr0=''),
    14169 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=14169, CurrentID=0, Status='live', Symbol='Fgf14', Aliases=['FHF-4', 'Fhf4', 'Tg(tetO-MAPT*P301L)4510Kha', 'mFHF-4(1B)'], description='fibroblast growth factor 14', other_designations='fibroblast growth factor 14|FGF-14|fibroblast growth factor homologous factor 4', map_location='14 66.18 cM', chromosome='14', genomic_nucleotide_accession_version='NC_000080.6', start_position_on_the_genomic_accession=123974441, end_position_on_the_genomic_accession=124677686, orientation='minus', exon_count=8, OMIM=[], no_hdr0=''),
    14170 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=14170, CurrentID=0, Status='live', Symbol='Fgf15', Aliases=['FGF19'], description='fibroblast growth factor 15', other_designations='fibroblast growth factor 15|FGF-15', map_location='7 F5', chromosome='7', genomic_nucleotide_accession_version='NC_000073.6', start_position_on_the_genomic_accession=144896532, end_position_on_the_genomic_accession=144900953, orientation='plus', exon_count=3, OMIM=[], no_hdr0=''),
    14171 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=14171, CurrentID=0, Status='live', Symbol='Fgf17', Aliases=[], description='fibroblast growth factor 17', other_designations='fibroblast growth factor 17|FGF-17', map_location='14 36.4 cM', chromosome='14', genomic_nucleotide_accession_version='NC_000080.6', start_position_on_the_genomic_accession=70636203, end_position_on_the_genomic_accession=70642268, orientation='minus', exon_count=5, OMIM=[], no_hdr0=''),
    14172 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=14172, CurrentID=0, Status='live', Symbol='Fgf18', Aliases=['D130055P09Rik', 'FGF-18'], description='fibroblast growth factor 18', other_designations='fibroblast growth factor 18|zFGF5', map_location='11 A4', chromosome='11', genomic_nucleotide_accession_version='NC_000077.6', start_position_on_the_genomic_accession=33116970, end_position_on_the_genomic_accession=33147400, orientation='minus', exon_count=5, OMIM=[], no_hdr0=''),
    14173 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=14173, CurrentID=0, Status='live', Symbol='Fgf2', Aliases=['Fgf-2', 'Fgfb', 'bFGF'], description='fibroblast growth factor 2', other_designations='fibroblast growth factor 2|HBGF-2|basic fibroblast growth factor|heparin-binding growth factor 2', map_location='3 18.41 cM', chromosome='3', genomic_nucleotide_accession_version='NC_000069.6', start_position_on_the_genomic_accession=37348477, end_position_on_the_genomic_accession=37410106, orientation='plus', exon_count=3, OMIM=[], no_hdr0=''),
    14174 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=14174, CurrentID=0, Status='live', Symbol='Fgf3', Aliases=['Fgf-3', 'In', 'Int', 'Int-2', 'Int-P'], description='fibroblast growth factor 3', other_designations='fibroblast growth factor 3|HBGF-3|INT-2 proto-oncogene protein|heparin-binding growth factor 3|proto-oncogene Int-2', map_location='7 88.85 cM', chromosome='7', genomic_nucleotide_accession_version='NC_000073.6', start_position_on_the_genomic_accession=144838612, end_position_on_the_genomic_accession=144843348, orientation='plus', exon_count=3, OMIM=[], no_hdr0=''),
    14175 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=14175, CurrentID=0, Status='live', Symbol='Fgf4', Aliases=['Fgf-4', 'Fgfk', 'HBGF-4', 'Hst1', 'Hstf-', 'Hstf-1', 'KS3', 'hst', 'hst-1', 'kFGF'], description='fibroblast growth factor 4', other_designations='fibroblast growth factor 4|K-fibroblast growth factor|heparin-binding growth factor 4', map_location='7 88.88 cM', chromosome='7', genomic_nucleotide_accession_version='NC_000073.6', start_position_on_the_genomic_accession=144861386, end_position_on_the_genomic_accession=144865245, orientation='plus', exon_count=3, OMIM=[], no_hdr0=''),
    14176 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=14176, CurrentID=0, Status='live', Symbol='Fgf5', Aliases=['Fgf-5', 'HBGF-5', 'angora', 'go'], description='fibroblast growth factor 5', other_designations='fibroblast growth factor 5|heparin-binding growth factor 5', map_location='5 47.77 cM', chromosome='5', genomic_nucleotide_accession_version='NC_000071.6', start_position_on_the_genomic_accession=98254184, end_position_on_the_genomic_accession=98277033, orientation='plus', exon_count=3, OMIM=[], no_hdr0=''),
    14177 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=14177, CurrentID=0, Status='live', Symbol='Fgf6', Aliases=['Fgf-6', 'HSTF-2'], description='fibroblast growth factor 6', other_designations='fibroblast growth factor 6|HBGF-6|HST-2|heparin secretory-transforming protein 2|heparin-binding growth factor 6', map_location='6 61.92 cM', chromosome='6', genomic_nucleotide_accession_version='NC_000072.6', start_position_on_the_genomic_accession=127015542, end_position_on_the_genomic_accession=127024718, orientation='plus', exon_count=3, OMIM=[], no_hdr0=''),
    14178 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=14178, CurrentID=0, Status='live', Symbol='Fgf7', Aliases=['Kgf'], description='fibroblast growth factor 7', other_designations='fibroblast growth factor 7|FGF-7|HBGF-7|Keratinocyte growth factor|heparin-binding growth factor 7', map_location='2 F1', chromosome='2', genomic_nucleotide_accession_version='NC_000068.7', start_position_on_the_genomic_accession=126034658, end_position_on_the_genomic_accession=126091185, orientation='plus', exon_count=4, OMIM=[], no_hdr0=''),
    14179 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=14179, CurrentID=0, Status='live', Symbol='Fgf8', Aliases=['Ai', 'Aigf', 'Fgf-8'], description='fibroblast growth factor 8', other_designations='fibroblast growth factor 8|HBGF-8|androgen-induced growth factor|heparin-binding growth factor 8', map_location='19 38.75 cM', chromosome='19', genomic_nucleotide_accession_version='NC_000085.6', start_position_on_the_genomic_accession=45736491, end_position_on_the_genomic_accession=45742941, orientation='minus', exon_count=6, OMIM=[], no_hdr0=''),
    14180 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=14180, CurrentID=0, Status='live', Symbol='Fgf9', Aliases=['Ek', 'Eks'], description='fibroblast growth factor 9', other_designations='fibroblast growth factor 9|FGF-9|GAF|HBGF-9|elbow knee synostosis|glia-activating factor', map_location='14 30.51 cM', chromosome='14', genomic_nucleotide_accession_version='NC_000080.6', start_position_on_the_genomic_accession=58070671, end_position_on_the_genomic_accession=58112854, orientation='plus', exon_count=5, OMIM=[], no_hdr0=''),
    14181 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=14181, CurrentID=0, Status='live', Symbol='Fgfbp1', Aliases=['FGF-B', 'FGF-BP', 'FGF-BP1', 'FGFBP-1'], description='fibroblast growth factor binding protein 1', other_designations='fibroblast growth factor-binding protein 1|FGF-binding protein 1', map_location='5 B3', chromosome='5', genomic_nucleotide_accession_version='NC_000071.6', start_position_on_the_genomic_accession=43978858, end_position_on_the_genomic_accession=43981828, orientation='minus', exon_count=4, OMIM=[], no_hdr0=''),
    14182 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=14182, CurrentID=0, Status='live', Symbol='Fgfr1', Aliases=['AW208770', 'Ea', 'Eask', 'FGFR', 'FGFR-I', 'FLG', 'Fgfr-', 'Fgfr-1', 'Flt-', 'Flt-2', 'Fr', 'Fr1', 'Hs', 'Hspy', 'MFR', 'bFGF-R-1', 'c-fgr'], description='fibroblast growth factor receptor 1', other_designations='fibroblast growth factor receptor 1|basic fibroblast growth factor receptor 1|proto-oncogene c-Fgr', map_location='8 14.12 cM', chromosome='8', genomic_nucleotide_accession_version='NC_000074.6', start_position_on_the_genomic_accession=25518759, end_position_on_the_genomic_accession=25575718, orientation='plus', exon_count=18, OMIM=[], no_hdr0=''),
    14183 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=14183, CurrentID=0, Status='live', Symbol='Fgfr2', Aliases=['AU043015', 'AW556123', 'Bek', 'Fgfr', 'Fgfr-', 'Fgfr-2', 'Fgfr-7', 'Fgfr7', 'KGFR', 'KGFRTr', 'svs'], description='fibroblast growth factor receptor 2', other_designations='fibroblast growth factor receptor 2|keratinocyte growth factor receptor', map_location='7 F3', chromosome='7', genomic_nucleotide_accession_version='NC_000073.6', start_position_on_the_genomic_accession=130162451, end_position_on_the_genomic_accession=130266808, orientation='minus', exon_count=19, OMIM=[], no_hdr0=''),
    14184 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=14184, CurrentID=0, Status='live', Symbol='Fgfr3', Aliases=['CD333', 'FR3', 'Fgfr-', 'Fgfr-3', 'Flg-2', 'HBGF', 'HBGFR', 'Mfr3', 'sa', 'sam3'], description='fibroblast growth factor receptor 3', other_designations='fibroblast growth factor receptor 3|heparin-binding growth factor receptor', map_location='5 17.83 cM', chromosome='5', genomic_nucleotide_accession_version='NC_000071.6', start_position_on_the_genomic_accession=33721724, end_position_on_the_genomic_accession=33737068, orientation='plus', exon_count=20, OMIM=[], no_hdr0=''),
    14186 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=14186, CurrentID=0, Status='live', Symbol='Fgfr4', Aliases=['Fgfr-', 'Fgfr-4'], description='fibroblast growth factor receptor 4', other_designations='fibroblast growth factor receptor 4|CTLA-2-beta protein|fibroblast growth factor receptor 4 16 minus form|protein-tyrosine kinase receptor MPK-11', map_location='13 29.8 cM', chromosome='13', genomic_nucleotide_accession_version='NC_000079.6', start_position_on_the_genomic_accession=55152818, end_position_on_the_genomic_accession=55168759, orientation='plus', exon_count=19, OMIM=[], no_hdr0=''),
    14187 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=14187, CurrentID=0, Status='live', Symbol='Akr1b8', Aliases=['FR-1', 'Fg', 'Fgf', 'Fgfrp', 'Fgrp'], description='aldo-keto reductase family 1, member B8', other_designations='aldose reductase-related protein 2|AR|aldehyde reductase|fibroblast growth factor-regulated protein|protein FR-1', map_location='6 14.91 cM', chromosome='6', genomic_nucleotide_accession_version='NC_000072.6', start_position_on_the_genomic_accession=34354146, end_position_on_the_genomic_accession=34368461, orientation='plus', exon_count=10, OMIM=[], no_hdr0=''),
    14190 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=14190, CurrentID=0, Status='live', Symbol='Fgl2', Aliases=['AI385601', 'musfiblp'], description='fibrinogen-like protein 2', other_designations='fibroleukin|associated with MHV-3 induced prothrombinase activity|cytotoxic T-lymphocyte-specific protein|prothrombinase', map_location='5 9.83 cM', chromosome='5', genomic_nucleotide_accession_version='NC_000071.6', start_position_on_the_genomic_accession=21372673, end_position_on_the_genomic_accession=21378386, orientation='plus', exon_count=2, OMIM=[], no_hdr0=''),
    14191 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=14191, CurrentID=0, Status='live', Symbol='Fgr', Aliases=['Al', 'Ali18', 'Mhdaa', 'Mhdaali18'], description='FGR proto-oncogene, Src family tyrosine kinase', other_designations='tyrosine-protein kinase Fgr|Gardner-Rasheed feline sarcoma viral (Fgr) oncogene homolog|p55-Fgr|proto-oncogene c-Fgr|proto-oncogene tyrosine-protein kinase Fgr', map_location='4 66.11 cM', chromosome='4', genomic_nucleotide_accession_version='NC_000070.6', start_position_on_the_genomic_accession=132974095, end_position_on_the_genomic_accession=133001893, orientation='plus', exon_count=15, OMIM=[], no_hdr0=''),
    14194 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=14194, CurrentID=0, Status='live', Symbol='Fh1', Aliases=['Fh', 'Fh-1', 'fuma'], description='fumarate hydratase 1', other_designations='fumarate hydratase, mitochondrial|EF-3|fumarase', map_location='1 H3', chromosome='1', genomic_nucleotide_accession_version='NC_000067.6', start_position_on_the_genomic_accession=175601378, end_position_on_the_genomic_accession=175625635, orientation='minus', exon_count=10, OMIM=[], no_hdr0=''),
    14198 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=14198, CurrentID=0, Status='live', Symbol='Fhit', Aliases=['AW045638', 'Fra1', 'Fra14A2'], description='fragile histidine triad gene', other_designations="bis(5'-adenosyl)-triphosphatase|AP3A hydrolase|AP3Aase|diadenosine 5',5'''-P1,P3-triphosphate hydrolase|dinucleosidetriphosphatase|fragile histidine triad protein", map_location='14 5.61 cM', chromosome='14', genomic_nucleotide_accession_version='NC_000080.6', start_position_on_the_genomic_accession=9550092, end_position_on_the_genomic_accession=11162061, orientation='minus', exon_count=14, OMIM=[], no_hdr0=''),
    14199 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=14199, CurrentID=0, Status='live', Symbol='Fhl1', Aliases=['FHL-1', 'Kyo', 'KyoT', 'RAM14-1', 'SLIM', 'SLIM-1'], description='four and a half LIM domains 1', other_designations='four and a half LIM domains protein 1|RBP-associated molecule 14-1|skeletal muscle LIM-protein 1', map_location='X A6', chromosome='X', genomic_nucleotide_accession_version='NC_000086.7', start_position_on_the_genomic_accession=56731209, end_position_on_the_genomic_accession=56793346, orientation='plus', exon_count=13, OMIM=[], no_hdr0=''),
    14200 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=14200, CurrentID=0, Status='live', Symbol='Fhl2', Aliases=['FHL-2', 'SL', 'SLIM-3', 'SLIM3'], description='four and a half LIM domains 2', other_designations='four and a half LIM domains protein 2|skeletal muscle LIM-protein 3', map_location='1 B', chromosome='1', genomic_nucleotide_accession_version='NC_000067.6', start_position_on_the_genomic_accession=43123071, end_position_on_the_genomic_accession=43198343, orientation='minus', exon_count=8, OMIM=[], no_hdr0=''),
    14201 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=14201, CurrentID=0, Status='live', Symbol='Fhl3', Aliases=['SLIM2'], description='four and a half LIM domains 3', other_designations='four and a half LIM domains protein 3|skeletal muscle LIM-protein 2', map_location='4 D2.2', chromosome='4', genomic_nucleotide_accession_version='NC_000070.6', start_position_on_the_genomic_accession=124695964, end_position_on_the_genomic_accession=124708611, orientation='plus', exon_count=8, OMIM=[], no_hdr0=''),
    14202 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=14202, CurrentID=0, Status='live', Symbol='Fhl4', Aliases=[], description='four and a half LIM domains 4', other_designations='four and a half LIM domains 4', map_location='10 C1', chromosome='10', genomic_nucleotide_accession_version='NC_000076.6', start_position_on_the_genomic_accession=85097019, end_position_on_the_genomic_accession=85102495, orientation='minus', exon_count=2, OMIM=[], no_hdr0=''),
    14204 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=14204, CurrentID=0, Status='live', Symbol='Il4i1', Aliases=['Fig', 'Fig1', 'Fig1-ps', 'H-4', 'H-46', 'H4', 'H46', 'LAAO', 'LAO'], description='interleukin 4 induced 1', other_designations='L-amino-acid oxidase|IL4-induced protein 1|histocompatibility 46|interleukin-4-induced protein 1|interleukin-four induced gene 1|interleukin-four induced gene-1 protein|interleukin-four induced protein-1|protein Fig-1', map_location='7 28.93 cM', chromosome='7', genomic_nucleotide_accession_version='NC_000073.6', start_position_on_the_genomic_accession=44836288, end_position_on_the_genomic_accession=44840809, orientation='plus', exon_count=8, OMIM=[], no_hdr0=''),
    14205 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=14205, CurrentID=0, Status='live', Symbol='Vegfd', Aliases=['AI325264', 'Fig', 'Figf', 'VEGF-', 'VEGF-D'], description='vascular endothelial growth factor D', other_designations='vascular endothelial growth factor D|c-fos induced growth factor', map_location='X 76.35 cM', chromosome='X', genomic_nucleotide_accession_version='NC_000086.7', start_position_on_the_genomic_accession=164373522, end_position_on_the_genomic_accession=164402650, orientation='plus', exon_count=7, OMIM=[], no_hdr0=''),
    14208 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=14208, CurrentID=0, Status='live', Symbol='Ppm1g', Aliases=['AI385652', 'Fin', 'Fin13'], description='protein phosphatase 1G (formerly 2C), magnesium-dependent, gamma isoform', other_designations='protein phosphatase 1G|PP2C-gamma|fibroblast growth factor inducible 13|fibroblast growth factor-inducible protein 13|protein phosphatase 1C|protein phosphatase magnesium-dependent 1 gamma', map_location='5 17.27 cM', chromosome='5', genomic_nucleotide_accession_version='NC_000071.6', start_position_on_the_genomic_accession=31202668, end_position_on_the_genomic_accession=31220545, orientation='minus', exon_count=10, OMIM=[], no_hdr0=''),
    14211 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=14211, CurrentID=0, Status='live', Symbol='Smc2', Aliases=['5730502P04Rik', 'AI255214', 'AW545314', 'CAP', 'CAP-E', 'CAPE', 'Fin', 'Fin16', 'SMC-2l1', 'Smc2'], description='structural maintenance of chromosomes 2', other_designations='structural maintenance of chromosomes protein 2|FGF-inducible protein 16|SMC protein 2|SMC2 structural maintenance of chromosomes 2-like 1|XCAP-E homolog|chromosome-associated protein E|fibroblast growth factor inducible 16', map_location='4 28.31 cM', chromosome='4', genomic_nucleotide_accession_version='NC_000070.6', start_position_on_the_genomic_accession=52439221, end_position_on_the_genomic_accession=52488365, orientation='plus', exon_count=25, OMIM=[], no_hdr0=''),
    14218 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=14218, CurrentID=0, Status='live', Symbol='Sh3pxd2a', Aliases=['2310014D11Rik', 'AA589508', 'AI256723', 'AI413738', 'C230050L11', 'EG329070', 'Fi', 'Fish', 'Gm5098', 'Sh3md', 'Sh3md1', 'TSK5', 'Tks', 'Tks5'], description='SH3 and PX domains 2A', other_designations='SH3 and PX domain-containing protein 2A|SH3 multiple domains 1|SH3 multiple domains protein 1|five SH3 domain-containing protein|five SH3 domains|tyrosine kinase substrate with five SH3 domains', map_location='19 C3', chromosome='19', genomic_nucleotide_accession_version='NC_000085.6', start_position_on_the_genomic_accession=47260174, end_position_on_the_genomic_accession=47464612, orientation='minus', exon_count=16, OMIM=[], no_hdr0=''),
    14219 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=14219, CurrentID=0, Status='live', Symbol='Ccn2', Aliases=['Ccn', 'Ctgf', 'Fis', 'Fisp12', 'Hcs2', 'Hcs24', 'fisp-12'], description='cellular communication network factor 2', other_designations='CCN family member 2|Connective tissue growth factor precursor (CTGF) (FISP-12 protein) (Hypertrophic chondrocyte-specific protein 24)|cellular communication network factor 1|fibroblast inducible secreated protein|fibroblast inducible secreted protein|hypertrophic chondrocyte-specific gene product 24|hypertrophic chondrocyte-specific protein 24', map_location='10 11.84 cM', chromosome='10', genomic_nucleotide_accession_version='NC_000076.6', start_position_on_the_genomic_accession=24595442, end_position_on_the_genomic_accession=24598683, orientation='plus', exon_count=5, OMIM=[], no_hdr0=''),
    14221 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=14221, CurrentID=0, Status='live', Symbol='Fjx1', Aliases=[], description='four jointed box 1', other_designations='four-jointed box protein 1|four-jointed protein homolog|four-jointed protein x1', map_location='2 E2', chromosome='2', genomic_nucleotide_accession_version='NC_000068.7', start_position_on_the_genomic_accession=102449366, end_position_on_the_genomic_accession=102451792, orientation='minus', exon_count=1, OMIM=[], no_hdr0=''),
    14225 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=14225, CurrentID=0, Status='live', Symbol='Fkbp1a', Aliases=['FKBP12', 'Fkb', 'Fkbp', 'Fkbp1'], description='FK506 binding protein 1a', other_designations='peptidyl-prolyl cis-trans isomerase FKBP1A|FK506 binding protein 12|PPIase FKBP1A|calstabin-1|immunophilin FKBP12', map_location='2 G3', chromosome='2', genomic_nucleotide_accession_version='NC_000068.7', start_position_on_the_genomic_accession=151542483, end_position_on_the_genomic_accession=151561691, orientation='plus', exon_count=7, OMIM=[], no_hdr0=''),
    14226 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=14226, CurrentID=0, Status='live', Symbol='Fkbp1b', Aliases=['12.6kD', '12.6kDa', 'AW494148', 'FKBP12.', 'FKBP12.6', 'cals', 'calstabin2'], description='FK506 binding protein 1b', other_designations='peptidyl-prolyl cis-trans isomerase FKBP1B|12.6 kDa FK506-binding protein|12.6 kDa FKBP|FK506-binding protein 12.6|FK506-binding protein 1B|FKBP-12.6|FKBP-1B|PPIase FKBP1B|immunophilin FKBP12.6|rotamase', map_location='12 A1.1', chromosome='12', genomic_nucleotide_accession_version='NC_000078.6', start_position_on_the_genomic_accession=4833176, end_position_on_the_genomic_accession=4841573, orientation='minus', exon_count=5, OMIM=[], no_hdr0=''),
    14227 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=14227, CurrentID=0, Status='live', Symbol='Fkbp2', Aliases=['13kD', 'mFKBP', 'mFKBP1', 'mFKBP13', 'mFKBP2'], description='FK506 binding protein 2', other_designations='peptidyl-prolyl cis-trans isomerase FKBP2|13 kDa FK506-binding protein|13 kDa FKBP|PPIase FKBP2|immunophilin FKBP13|rotamase', map_location='19 A', chromosome='19', genomic_nucleotide_accession_version='NC_000085.6', start_position_on_the_genomic_accession=6977737, end_position_on_the_genomic_accession=6980464, orientation='minus', exon_count=8, OMIM=[], no_hdr0=''),
    14228 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=14228, CurrentID=0, Status='live', Symbol='Fkbp4', Aliases=['AL022792', 'AW208983', 'FKBP-4', 'FKBP-5', 'FKBP-52', 'FKBP5', 'FKBP52', 'FKPB52', 'p59'], description='FK506 binding protein 4', other_designations='peptidyl-prolyl cis-trans isomerase FKBP4|52 kDa FK506-binding protein|52 kDa FKBP|59 kDa immunophilin|FKBP59|HBI|HSP-binding immunophilin|PPIase FKBP4|immunophilin FKBP52|rotamase', map_location='6 F3', chromosome='6', genomic_nucleotide_accession_version='NC_000072.6', start_position_on_the_genomic_accession=128430103, end_position_on_the_genomic_accession=128438656, orientation='minus', exon_count=10, OMIM=[], no_hdr0=''),
    14229 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=14229, CurrentID=0, Status='live', Symbol='Fkbp5', Aliases=['D17Ertd592', 'D17Ertd592e', 'Dit', 'Dit1', 'FKBP-5', 'FKBP51'], description='FK506 binding protein 5', other_designations='peptidyl-prolyl cis-trans isomerase FKBP5|51 kDa FK506-binding protein|51 kDa FKBP|PPIase FKBP5|rotamase', map_location='17 14.66 cM', chromosome='17', genomic_nucleotide_accession_version='NC_000083.6', start_position_on_the_genomic_accession=28398753, end_position_on_the_genomic_accession=28486149, orientation='minus', exon_count=11, OMIM=[], no_hdr0=''),
    14230 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=14230, CurrentID=0, Status='live', Symbol='Fkbp10', Aliases=['65kD', 'AI325255', 'FKBP-10', 'FKBP-65', 'FKBP65', 'Fkbp', 'Fkbp-', 'Fkbp-rs1', 'Fkbp1', 'Fkbp1-rs', 'Fkbp6', 'Fkbprp'], description='FK506 binding protein 10', other_designations='peptidyl-prolyl cis-trans isomerase FKBP10|65 kDa FK506-binding protein|65 kDa FKBP|FK506 binding protein 6 (65 kDa)|PPIase FKBP10|immunophilin FKBP65|rotamase', map_location='11 63.47 cM', chromosome='11', genomic_nucleotide_accession_version='NC_000077.6', start_position_on_the_genomic_accession=100415694, end_position_on_the_genomic_accession=100424840, orientation='plus', exon_count=10, OMIM=[], no_hdr0=''),
    14231 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=14231, CurrentID=0, Status='live', Symbol='Fkbp7', Aliases=['23kDa', 'FKBP-7', 'FKBP2', 'FKBP23'], description='FK506 binding protein 7', other_designations='peptidyl-prolyl cis-trans isomerase FKBP7|23 kDa FK506-binding protein|23 kDa FKBP|FKBP-23|PPIase FKBP7|rotamase', map_location='2 45.09 cM', chromosome='2', genomic_nucleotide_accession_version='NC_000068.7', start_position_on_the_genomic_accession=76663034, end_position_on_the_genomic_accession=76673098, orientation='minus', exon_count=5, OMIM=[], no_hdr0=''),
    14232 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=14232, CurrentID=0, Status='live', Symbol='Fkbp8', Aliases=['38kD', '38kDa', 'FKBP-38', 'FKBP-8', 'FKBPR38', 'Fkbp3', 'Fkbp38', 'mFKBP38'], description='FK506 binding protein 8', other_designations='peptidyl-prolyl cis-trans isomerase FKBP8|38 kDa FK506-binding protein|38 kDa FKBP|FK506-binding protein 38|PPIase FKBP8|rotamase', map_location='8 B3.3', chromosome='8', genomic_nucleotide_accession_version='NC_000074.6', start_position_on_the_genomic_accession=70527721, end_position_on_the_genomic_accession=70535328, orientation='plus', exon_count=10, OMIM=[], no_hdr0=''),
    14233 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=14233, CurrentID=0, Status='live', Symbol='Foxi1', Aliases=['5830401E05Rik', 'FREAC6', 'Fkh10', 'HFH-3', 'Hfh3'], description='forkhead box I1', other_designations='forkhead box protein I1|HNF-3/forkhead homolog 3|forkhead homolog 10', map_location='11 19.65 cM', chromosome='11', genomic_nucleotide_accession_version='NC_000077.6', start_position_on_the_genomic_accession=34204341, end_position_on_the_genomic_accession=34208089, orientation='minus', exon_count=2, OMIM=[], no_hdr0=''),
    14234 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=14234, CurrentID=0, Status='live', Symbol='Foxc2', Aliases=['Fkh14', 'Hfhbf3', 'MFH-1', 'Mfh1'], description='forkhead box C2', other_designations='forkhead box protein C2|BF-3|brain factor 3|forkhead homolog 14|forkhead-related protein FKHL14|mesenchyme fork head protein 1|transcription factor FKH-14', map_location='8 70.33 cM', chromosome='8', genomic_nucleotide_accession_version='NC_000074.6', start_position_on_the_genomic_accession=121116171, end_position_on_the_genomic_accession=121118895, orientation='plus', exon_count=1, OMIM=[], no_hdr0=''),
    14235 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=14235, CurrentID=0, Status='live', Symbol='Foxm1', Aliases=['AA408308', 'AW554517', 'BB238854', 'D1Mgi5', 'Fkh16b', 'HFH-11B', 'MPHOSPH2', 'Mpm', 'Mpm2', 'Trid', 'W', 'WIN', 'Foxm1'], description='forkhead box M1', other_designations='forkhead box protein M1|forkhead homolog 16|trident|winged-helix transcription factor Trident', map_location='6 62.98 cM', chromosome='6', genomic_nucleotide_accession_version='NC_000072.6', start_position_on_the_genomic_accession=128362994, end_position_on_the_genomic_accession=128375886, orientation='plus', exon_count=8, OMIM=[], no_hdr0=''),
    14236 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=14236, CurrentID=0, Status='live', Symbol='Foxn2', Aliases=['3230402J05Rik', '6030465J18Rik', 'Fkh19', 'Foxn1', 'HTL', 'HTLF'], description='forkhead box N2', other_designations='forkhead box protein N2|forkhead box N1|forkhead homolog 19', map_location='17 E4', chromosome='17', genomic_nucleotide_accession_version='NC_000083.6', start_position_on_the_genomic_accession=88440704, end_position_on_the_genomic_accession=88490533, orientation='plus', exon_count=10, OMIM=[], no_hdr0=''),
    14237 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=14237, CurrentID=0, Status='live', Symbol='Foxd4', Aliases=['FREA', 'FREAC5', 'Fkh2'], description='forkhead box D4', other_designations='forkhead box protein D4|FREAC-5|forkhead homolog 2|forkhead-related protein FKHL9|forkhead-related transcription factor 5|transcription factor FKH-2', map_location='19 19.86 cM', chromosome='19', genomic_nucleotide_accession_version='NC_000085.6', start_position_on_the_genomic_accession=24898943, end_position_on_the_genomic_accession=24901016, orientation='minus', exon_count=1, OMIM=[], no_hdr0=''),
    14238 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=14238, CurrentID=0, Status='live', Symbol='Foxf2', Aliases=['FREA', 'FREAC2', 'Fkh20', 'L', 'LUN'], description='forkhead box F2', other_designations='forkhead box protein F2|forkhead homolog 20', map_location='13 A3.2', chromosome='13', genomic_nucleotide_accession_version='NC_000079.6', start_position_on_the_genomic_accession=31625816, end_position_on_the_genomic_accession=31631406, orientation='plus', exon_count=2, OMIM=[], no_hdr0=''),
    14239 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=14239, CurrentID=0, Status='live', Symbol='Foxs1', Aliases=['FREAC', 'FREAC10', 'Fkh3', 'Fkhl1', 'Fkhl18'], description='forkhead box S1', other_designations='forkhead box protein S1|FREAC-10|forkhead-like 18 protein|forkhead-related transcription factor 10|transcription factor FKH-3', map_location='2 H1', chromosome='2', genomic_nucleotide_accession_version='NC_000068.7', start_position_on_the_genomic_accession=152931898, end_position_on_the_genomic_accession=152933208, orientation='minus', exon_count=1, OMIM=[], no_hdr0=''),
    14240 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=14240, CurrentID=0, Status='live', Symbol='Foxb2', Aliases=['Fkh4'], description='forkhead box B2', other_designations='forkhead box protein B2|forkhead homolog 4|transcription factor FKH-4', map_location='19 12.26 cM', chromosome='19', genomic_nucleotide_accession_version='NC_000085.6', start_position_on_the_genomic_accession=16872316, end_position_on_the_genomic_accession=16873830, orientation='minus', exon_count=1, OMIM=[], no_hdr0=''),
    14241 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=14241, CurrentID=0, Status='live', Symbol='Foxl1', Aliases=['FREA', 'FREAC7', 'Fkh6', 'fkh-6'], description='forkhead box L1', other_designations='forkhead box protein L1|forkhead homolog 6|forkhead-related protein FKHL11|transcription factor FKH-6', map_location='8 70.34 cM', chromosome='8', genomic_nucleotide_accession_version='NC_000074.6', start_position_on_the_genomic_accession=121127685, end_position_on_the_genomic_accession=121130644, orientation='plus', exon_count=1, OMIM=[], no_hdr0=''),
    14245 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=14245, CurrentID=0, Status='live', Symbol='Lpin1', Aliases=['L', 'Lipin1', 'fld'], description='lipin 1', other_designations='phosphatidate phosphatase LPIN1|fatty liver dystrophy protein', map_location='12 7.9 cM', chromosome='12', genomic_nucleotide_accession_version='NC_000078.6', start_position_on_the_genomic_accession=16535669, end_position_on_the_genomic_accession=16653903, orientation='minus', exon_count=27, OMIM=[], no_hdr0=''),
    14246 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=14246, CurrentID=0, Status='live', Symbol='Flg', Aliases=['AW107830', 'fi', 'ft'], description='filaggrin', other_designations='filaggrin|LOW QUALITY PROTEIN: filaggrin|fillagrin|keratin intermediate filament-associated protein|profilaggrin', map_location='3 40.16 cM', chromosome='3', genomic_nucleotide_accession_version='NC_000069.6', start_position_on_the_genomic_accession=93273546, end_position_on_the_genomic_accession=93293689, orientation='plus', exon_count=5, OMIM=[], no_hdr0=''),
    14247 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=14247, CurrentID=0, Status='live', Symbol='Fli1', Aliases=['EWS', 'EWSR2', 'Fli', 'Fli-1', 'SIC', 'SIC-1', 'Si', 'Sic1'], description='Friend leukemia integration 1', other_designations='Friend leukemia integration 1 transcription factor|retroviral integration site protein Fli-1', map_location='9 17.74 cM', chromosome='9', genomic_nucleotide_accession_version='NC_000075.6', start_position_on_the_genomic_accession=32422204, end_position_on_the_genomic_accession=32543432, orientation='minus', exon_count=12, OMIM=[], no_hdr0=''),
    14248 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=14248, CurrentID=0, Status='live', Symbol='Flii', Aliases=['3632430F08Rik', 'Flh', 'Flii'], description='flightless I actin binding protein', other_designations='protein flightless-1 homolog|cytoskeletal actin-modulating protein|flightless I homolog', map_location='11 37.81 cM', chromosome='11', genomic_nucleotide_accession_version='NC_000077.6', start_position_on_the_genomic_accession=60714143, end_position_on_the_genomic_accession=60727263, orientation='minus', exon_count=30, OMIM=[], no_hdr0=''),
    14251 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=14251, CurrentID=0, Status='live', Symbol='Flot1', Aliases=['reggie', 'reggie-2'], description='flotillin 1', other_designations='flotillin-1', map_location='17 B1', chromosome='17', genomic_nucleotide_accession_version='NC_000083.6', start_position_on_the_genomic_accession=35823320, end_position_on_the_genomic_accession=35832789, orientation='plus', exon_count=14, OMIM=[], no_hdr0=''),
    14252 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=14252, CurrentID=0, Status='live', Symbol='Flot2', Aliases=['AI573412', 'E', 'Esa', 'reggie', 'reggie-2'], description='flotillin 2', other_designations='flotillin-2|epidermal surface antigen|membrane component chromosome 17 surface marker 1 homolog', map_location='11 46.74 cM', chromosome='11', genomic_nucleotide_accession_version='NC_000077.6', start_position_on_the_genomic_accession=78037931, end_position_on_the_genomic_accession=78060434, orientation='plus', exon_count=14, OMIM=[], no_hdr0=''),
    14254 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=14254, CurrentID=0, Status='live', Symbol='Flt1', Aliases=['AI323757', 'Flt-', 'Flt-1', 'VEGF', 'VEGFR', 'VEGFR-1', 'VEGFR1', 'sFl', 'sFlt1'], description='FMS-like tyrosine kinase 1', other_designations='vascular endothelial growth factor receptor 1|embryonic receptor kinase 2|tyrosine-protein kinase receptor FLT|vascular permeability factor receptor', map_location='5 87.01 cM', chromosome='5', genomic_nucleotide_accession_version='NC_000071.6', start_position_on_the_genomic_accession=147561604, end_position_on_the_genomic_accession=147726438, orientation='minus', exon_count=34, OMIM=[], no_hdr0=''),
    14255 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=14255, CurrentID=0, Status='live', Symbol='Flt3', Aliases=['B230315G04', 'CD135', 'Flk', 'Flk-', 'Flk-2', 'Flk2', 'Flt-', 'Flt-3', 'Ly72', 'wmf', 'wmfl'], description='FMS-like tyrosine kinase 3', other_designations='receptor-type tyrosine-protein kinase FLT3|FL cytokine receptor|fetal liver kinase 2|tyrosine-protein kinase FLT3|tyrosine-protein kinase receptor flk-2', map_location='5 G3', chromosome='5', genomic_nucleotide_accession_version='NC_000071.6', start_position_on_the_genomic_accession=147330741, end_position_on_the_genomic_accession=147400489, orientation='minus', exon_count=26, OMIM=[], no_hdr0=''),
    14256 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=14256, CurrentID=0, Status='live', Symbol='Flt3l', Aliases=['Flt3lg', 'Ly72L'], description='FMS-like tyrosine kinase 3 ligand', other_designations='fms-related tyrosine kinase 3 ligand|flt3 ligand', map_location='7 29.14 cM', chromosome='7', genomic_nucleotide_accession_version='NC_000073.6', start_position_on_the_genomic_accession=45131183, end_position_on_the_genomic_accession=45136490, orientation='minus', exon_count=8, OMIM=[], no_hdr0=''),
    14257 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=14257, CurrentID=0, Status='live', Symbol='Flt4', Aliases=['AI323512', 'Chy', 'Flt-', 'Flt-4', 'VEGF', 'VEGFR', 'VEGFR-3', 'VEGFR3'], description='FMS-like tyrosine kinase 4', other_designations='vascular endothelial growth factor receptor 3|chylous ascites|receptor protein tyrosine kinase|tyrosine-protein kinase receptor FLT4', map_location='11 29.69 cM', chromosome='11', genomic_nucleotide_accession_version='NC_000077.6', start_position_on_the_genomic_accession=49609679, end_position_on_the_genomic_accession=49652739, orientation='plus', exon_count=30, OMIM=[], no_hdr0=''),
    14260 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=14260, CurrentID=0, Status='live', Symbol='Fmn1', Aliases=['Fm', 'Fmn', 'form', 'formin-1', 'ld'], description='formin 1', other_designations='formin-1|limb deformity protein', map_location='2 57.3 cM', chromosome='2', genomic_nucleotide_accession_version='NC_000068.7', start_position_on_the_genomic_accession=113327664, end_position_on_the_genomic_accession=113716768, orientation='plus', exon_count=25, OMIM=[], no_hdr0=''),
    14261 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=14261, CurrentID=0, Status='live', Symbol='Fmo1', Aliases=[], description='flavin containing monooxygenase 1', other_designations='dimethylaniline monooxygenase [N-oxide-forming] 1|dimethylaniline oxidase 1|hepatic flavin-containing monooxygenase 1', map_location='1 70.34 cM', chromosome='1', genomic_nucleotide_accession_version='NC_000067.6', start_position_on_the_genomic_accession=162829561, end_position_on_the_genomic_accession=162866610, orientation='minus', exon_count=11, OMIM=[], no_hdr0=''),
    14262 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=14262, CurrentID=0, Status='live', Symbol='Fmo3', Aliases=['AW111792'], description='flavin containing monooxygenase 3', other_designations='dimethylaniline monooxygenase [N-oxide-forming] 3|dimethylaniline oxidase 3|hepatic flavin-containing monooxygenase 3|trimethylamine monooxygenase', map_location='1 70.34 cM', chromosome='1', genomic_nucleotide_accession_version='NC_000067.6', start_position_on_the_genomic_accession=162953799, end_position_on_the_genomic_accession=162984528, orientation='minus', exon_count=9, OMIM=[], no_hdr0=''),
    14263 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=14263, CurrentID=0, Status='live', Symbol='Fmo5', Aliases=['5033418D19Rik', 'AI195026'], description='flavin containing monooxygenase 5', other_designations='flavin-containing monooxygenase 5|NAPDH oxidase|dimethylaniline monooxygenase [N-oxide-forming] 5|dimethylaniline oxidase 5|hepatic flavin-containing monooxygenase 5', map_location='3 F2.2', chromosome='3', genomic_nucleotide_accession_version='NC_000069.6', start_position_on_the_genomic_accession=97609938, end_position_on_the_genomic_accession=97655287, orientation='plus', exon_count=13, OMIM=[], no_hdr0=''),
    14264 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=14264, CurrentID=0, Status='live', Symbol='Fmod', Aliases=['AI131919', 'AU041740', 'FM', 'SL', 'SLRR2E'], description='fibromodulin', other_designations='fibromodulin|KSPG fibromodulin|collagen-binding 59 kDa protein|keratan sulfate proteoglycan fibromodulin', map_location='1 58.09 cM', chromosome='1', genomic_nucleotide_accession_version='NC_000067.6', start_position_on_the_genomic_accession=134037254, end_position_on_the_genomic_accession=134048280, orientation='plus', exon_count=3, OMIM=[], no_hdr0=''),
    14265 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=14265, CurrentID=0, Status='live', Symbol='Fmr1', Aliases=['FM', 'FMRP', 'Fmr-', 'Fmr-1'], description='FMRP translational regulator 1', other_designations='synaptic functional regulator FMR1|fragile X mental retardation 1|fragile X mental retardation protein 1 homolog', map_location='X 34.83 cM', chromosome='X', genomic_nucleotide_accession_version='NC_000086.7', start_position_on_the_genomic_accession=68678536, end_position_on_the_genomic_accession=68717963, orientation='plus', exon_count=17, OMIM=[], no_hdr0=''),
    14266 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=14266, CurrentID=0, Status='live', Symbol='Aff2', Aliases=['FMR2P', 'Fmr', 'Fmr2', 'Ox', 'Ox1', 'Ox19', 'Oxh'], description='AF4/FMR2 family, member 2', other_designations='AF4/FMR2 family member 2|Ox19 homolog|fragile X mental retardation 2 homolog|fragile X mental retardation protein 2 homolog|protein FMR-2', map_location='X A7.1-A7.2', chromosome='X', genomic_nucleotide_accession_version='NC_000086.7', start_position_on_the_genomic_accession=69360190, end_position_on_the_genomic_accession=69872054, orientation='plus', exon_count=21, OMIM=[], no_hdr0=''),
    14268 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=14268, CurrentID=0, Status='live', Symbol='Fn1', Aliases=['E330027I09', 'F', 'Fn', 'Fn-', 'Fn-1'], description='fibronectin 1', other_designations='fibronectin', map_location='1 36.05 cM', chromosome='1', genomic_nucleotide_accession_version='NC_000067.6', start_position_on_the_genomic_accession=71585473, end_position_on_the_genomic_accession=71653280, orientation='minus', exon_count=46, OMIM=[], no_hdr0=''),
    14269 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=14269, CurrentID=0, Status='live', Symbol='Fnbp1', Aliases=['1110057E06Rik', '2210010H06Rik', 'FBP', 'FBP1', 'Fbp17'], description='formin binding protein 1', other_designations='formin-binding protein 1|formin binding protein 17', map_location='2 B', chromosome='2', genomic_nucleotide_accession_version='NC_000068.7', start_position_on_the_genomic_accession=31026206, end_position_on_the_genomic_accession=31145454, orientation='minus', exon_count=19, OMIM=[], no_hdr0=''),
    14270 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=14270, CurrentID=0, Status='live', Symbol='Srgap2', Aliases=['9930124L22Rik', 'AI448945', 'FBP', 'FBP2', 'Fnb', 'Fnbp2', 'srGAP3'], description='SLIT-ROBO Rho GTPase activating protein 2', other_designations='SLIT-ROBO Rho GTPase-activating protein 2|FBP-27|formin binding protein 2|formin-binding protein 27', map_location='1 E4', chromosome='1', genomic_nucleotide_accession_version='NC_000067.6', start_position_on_the_genomic_accession=131285251, end_position_on_the_genomic_accession=131527531, orientation='minus', exon_count=24, OMIM=[], no_hdr0=''),
    14272 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=14272, CurrentID=0, Status='live', Symbol='Fnta', Aliases=['FT', 'FTA'], description='farnesyltransferase, CAAX box, alpha', other_designations='protein farnesyltransferase/geranylgeranyltransferase type-1 subunit alpha|CAAX farnesyltransferase subunit alpha|FTase-alpha|GGTase-I-alpha|ras proteins prenyltransferase subunit alpha|type I protein geranyl-geranyltransferase subunit alpha', map_location='8 14.27 cM', chromosome='8', genomic_nucleotide_accession_version='NC_000074.6', start_position_on_the_genomic_accession=25998688, end_position_on_the_genomic_accession=26015610, orientation='minus', exon_count=9, OMIM=[], no_hdr0=''),
    14275 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=14275, CurrentID=0, Status='live', Symbol='Folr1', Aliases=['FBP', 'FBP1', 'Fol', 'Folb', 'Folbp-1', 'Folbp1'], description='folate receptor 1 (adult)', other_designations='folate receptor alpha|FR-alpha|folate-binding protein 1', map_location='7 E2', chromosome='7', genomic_nucleotide_accession_version='NC_000073.6', start_position_on_the_genomic_accession=101858331, end_position_on_the_genomic_accession=101870788, orientation='minus', exon_count=10, OMIM=[], no_hdr0=''),
    14276 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=14276, CurrentID=0, Status='live', Symbol='Folr2', Aliases=['FBP', 'FBP2', 'FR-', 'FR-P3', 'FR-beta', 'Fol', 'Folb', 'Folbp-2', 'Folbp2'], description='folate receptor 2 (fetal)', other_designations='folate receptor beta|folate binding protein 2', map_location='7 E2', chromosome='7', genomic_nucleotide_accession_version='NC_000073.6', start_position_on_the_genomic_accession=101839988, end_position_on_the_genomic_accession=101857190, orientation='minus', exon_count=7, OMIM=[], no_hdr0=''),
    14281 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=14281, CurrentID=0, Status='live', Symbol='Fos', Aliases=['D12Rfj', 'D12Rfj1', 'c-f', 'c-fos', 'cF', 'cFos'], description='FBJ osteosarcoma oncogene', other_designations='proto-oncogene c-Fos|cellular oncogene fos|proto-oncogene protein c-fos', map_location='12 39.7 cM', chromosome='12', genomic_nucleotide_accession_version='NC_000078.6', start_position_on_the_genomic_accession=85473890, end_position_on_the_genomic_accession=85477274, orientation='plus', exon_count=4, OMIM=[], no_hdr0=''),
    14282 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=14282, CurrentID=0, Status='live', Symbol='Fosb', Aliases=[], description='FBJ osteosarcoma oncogene B', other_designations='protein fosB|osteosarcoma oncoprotein B FosB', map_location='7 9.56 cM', chromosome='7', genomic_nucleotide_accession_version='NC_000073.6', start_position_on_the_genomic_accession=19302696, end_position_on_the_genomic_accession=19310118, orientation='minus', exon_count=5, OMIM=[], no_hdr0=''),
    14283 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=14283, CurrentID=0, Status='live', Symbol='Fosl1', Aliases=['AW538199', 'Fr', 'Fra1', 'fra', 'fra-1'], description='fos-like antigen 1', other_designations='fos-related antigen 1', map_location='19 4.33 cM', chromosome='19', genomic_nucleotide_accession_version='NC_000085.6', start_position_on_the_genomic_accession=5447698, end_position_on_the_genomic_accession=5455938, orientation='plus', exon_count=4, OMIM=[], no_hdr0=''),
    14284 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=14284, CurrentID=0, Status='live', Symbol='Fosl2', Aliases=['Fra', 'Fra-2'], description='fos-like antigen 2', other_designations='fos-related antigen 2', map_location='5 17.33 cM', chromosome='5', genomic_nucleotide_accession_version='NC_000071.6', start_position_on_the_genomic_accession=32136472, end_position_on_the_genomic_accession=32157840, orientation='plus', exon_count=4, OMIM=[], no_hdr0=''),
    14287 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=14287, CurrentID=0, Status='live', Symbol='Fpgs', Aliases=['AA408187'], description='folylpolyglutamyl synthetase', other_designations='folylpolyglutamate synthase, mitochondrial|folylpoly-gamma-glutamate synthetase|tetrahydrofolate synthase|tetrahydrofolylpolyglutamate synthase', map_location='2 22.09 cM', chromosome='2', genomic_nucleotide_accession_version='NC_000068.7', start_position_on_the_genomic_accession=32682609, end_position_on_the_genomic_accession=32704196, orientation='minus', exon_count=19, OMIM=[], no_hdr0=''),
    14289 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=14289, CurrentID=0, Status='live', Symbol='Fpr2', Aliases=['E330010I07Rik', 'Fpr', 'Fpr-rs2'], description='formyl peptide receptor 2', other_designations='formyl peptide receptor 2|N-formylpeptide receptor-like 2|formyl peptide receptor, related sequence 2|formylpeptide receptor-related sequence 2|lipoxin A4 receptor-like protein', map_location='17 A3.2', chromosome='17', genomic_nucleotide_accession_version='NC_000083.6', start_position_on_the_genomic_accession=17887824, end_position_on_the_genomic_accession=17893952, orientation='plus', exon_count=2, OMIM=[], no_hdr0=''),
    14290 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=14290, CurrentID=0, Status='live', Symbol='Fpr-rs3', Aliases=[], description='formyl peptide receptor, related sequence 3', other_designations='formyl peptide receptor-related sequence 3|N-formylpeptide receptor-like 3', map_location='17 A3.2', chromosome='17', genomic_nucleotide_accession_version='NC_000083.6', start_position_on_the_genomic_accession=20623846, end_position_on_the_genomic_accession=20624877, orientation='minus', exon_count=1, OMIM=[], no_hdr0=''),
    14291 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=14291, CurrentID=0, Status='live', Symbol='Fpr-rs4', Aliases=[], description='formyl peptide receptor, related sequence 4', other_designations='formyl peptide receptor-related sequence 4|N-formylpeptide receptor-like 4', map_location='17 A3.2', chromosome='17', genomic_nucleotide_accession_version='NC_000083.6', start_position_on_the_genomic_accession=18021733, end_position_on_the_genomic_accession=18022704, orientation='plus', exon_count=1, OMIM=[], no_hdr0=''),
    14293 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=14293, CurrentID=0, Status='live', Symbol='Fpr1', Aliases=['F', 'FPR', 'LXA4R', 'fMLF', 'fMLF-R'], description='formyl peptide receptor 1', other_designations='fMet-Leu-Phe receptor|N-formyl peptide receptor|N-formylpeptide chemoattractant receptor|fMLP receptor|lipoxin A4 receptor', map_location='17 10.63 cM', chromosome='17', genomic_nucleotide_accession_version='NC_000083.6', start_position_on_the_genomic_accession=17876471, end_position_on_the_genomic_accession=17883939, orientation='minus', exon_count=2, OMIM=[], no_hdr0=''),
    14294 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=14294, CurrentID=0, Status='live', Symbol='Fpr3', Aliases=['ALX', 'Fp', 'Fpr', 'Fpr-rs1', 'Fpr-s1', 'Fprl1', 'LXA', 'LXA4-R', 'Lx', 'Lxa4r'], description='formyl peptide receptor 3', other_designations='formyl peptide receptor-related sequence 1|FMLP-R-I|FMLP-related receptor I|LXA4 receptor|N-formyl peptide receptor 2|N-formyl peptide receptor 3|N-formylpeptide receptor-like 1|formyl peptide receptor-like 1|lipoxin A4 receptor', map_location='17 A3.2', chromosome='17', genomic_nucleotide_accession_version='NC_000083.6', start_position_on_the_genomic_accession=17970458, end_position_on_the_genomic_accession=17971677, orientation='plus', exon_count=1, OMIM=[], no_hdr0=''),
    14296 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=14296, CurrentID=0, Status='live', Symbol='Frat1', Aliases=['AW060382'], description='frequently rearranged in advanced T cell lymphomas', other_designations='proto-oncogene FRAT1|frequently rearranged in advanced T-cell lymphomas 1', map_location='19 35.3 cM', chromosome='19', genomic_nucleotide_accession_version='NC_000085.6', start_position_on_the_genomic_accession=41829970, end_position_on_the_genomic_accession=41832583, orientation='plus', exon_count=1, OMIM=[], no_hdr0=''),
    14297 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=14297, CurrentID=0, Status='live', Symbol='Fxn', Aliases=['FA', 'FARR', 'Fr', 'Frda', 'X25'], description='frataxin', other_designations='frataxin, mitochondrial|Friedreich ataxia', map_location='19 B', chromosome='19', genomic_nucleotide_accession_version='NC_000085.6', start_position_on_the_genomic_accession=24259545, end_position_on_the_genomic_accession=24280590, orientation='minus', exon_count=5, OMIM=[], no_hdr0=''),
    14299 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=14299, CurrentID=0, Status='live', Symbol='Ncs1', Aliases=['9430075O15Rik', 'A730032G13Rik', 'AI836659', 'Fre', 'Freq', 'Mfreq', 'NCS', 'NCS-1'], description='neuronal calcium sensor 1', other_designations='neuronal calcium sensor 1|frequenin homolog', map_location='2 B', chromosome='2', genomic_nucleotide_accession_version='NC_000068.7', start_position_on_the_genomic_accession=31245708, end_position_on_the_genomic_accession=31295989, orientation='plus', exon_count=9, OMIM=[], no_hdr0=''),
    14300 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=14300, CurrentID=0, Status='live', Symbol='Frg1', Aliases=[], description='FSHD region gene 1', other_designations='protein FRG1|FSHD region gene 1 protein', map_location='8 23.89 cM', chromosome='8', genomic_nucleotide_accession_version='NC_000074.6', start_position_on_the_genomic_accession=41389181, end_position_on_the_genomic_accession=41417138, orientation='minus', exon_count=11, OMIM=[], no_hdr0=''),
    14302 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=14302, CurrentID=0, Status='live', Symbol='Frk', Aliases=['BSK', 'BSK/I', 'BSK/IYK', 'C85044', 'GTK', 'RAK'], description='fyn-related kinase', other_designations='tyrosine-protein kinase FRK|B-cell src-homology tyrosine kinase|beta-cell Src-homology tyrosine kinase|intestine tyrosine kinase', map_location='10 B1', chromosome='10', genomic_nucleotide_accession_version='NC_000076.6', start_position_on_the_genomic_accession=34483400, end_position_on_the_genomic_accession=34611232, orientation='plus', exon_count=9, OMIM=[], no_hdr0=''),
    14308 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=14308, CurrentID=0, Status='live', Symbol='Fshb', Aliases=['FS', 'FSH', 'FSH-B', 'FSH-betae', 'Fshbeta', 'Fshb'], description='follicle stimulating hormone beta', other_designations='follitropin subunit beta|follicle-stimulating hormone beta subunit|follitropin beta chain', map_location='2 56.02 cM', chromosome='2', genomic_nucleotide_accession_version='NC_000068.7', start_position_on_the_genomic_accession=107055986, end_position_on_the_genomic_accession=107059651, orientation='minus', exon_count=3, OMIM=[], no_hdr0=''),
    14309 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=14309, CurrentID=0, Status='live', Symbol='Fshr', Aliases=['FSH'], description='follicle stimulating hormone receptor', other_designations='follicle-stimulating hormone receptor|follitropin receptor', map_location='17 E5', chromosome='17', genomic_nucleotide_accession_version='NC_000083.6', start_position_on_the_genomic_accession=88984952, end_position_on_the_genomic_accession=89200675, orientation='minus', exon_count=10, OMIM=[], no_hdr0=''),
    14311 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=14311, CurrentID=0, Status='live', Symbol='Cidec', Aliases=['CIDE-', 'CIDE-3', 'Fsp', 'Fsp27'], description='cell death-inducing DFFA-like effector c', other_designations='cell death activator CIDE-3|CIDE-3alpha|cell death-inducing DFFA-like effector protein C|fat specific gene 27|fat-specific protein FSP27', map_location='6 E3', chromosome='6', genomic_nucleotide_accession_version='NC_000072.6', start_position_on_the_genomic_accession=113424634, end_position_on_the_genomic_accession=113435760, orientation='minus', exon_count=7, OMIM=[], no_hdr0=''),
    14312 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=14312, CurrentID=0, Status='live', Symbol='Brd2', Aliases=['AW228947', 'D17H6S113', 'D17H6S113E', 'Frg-', 'Frg-1', 'Fsr', 'Fsrg-1', 'Fsrg1', 'Nat', 'Ri', 'Ring3', 'Rn', 'Rnf3', 'mKIAA4005'], description='bromodomain containing 2', other_designations='bromodomain-containing protein 2|female sterile homeotic-related gene 1', map_location='17 17.98 cM', chromosome='17', genomic_nucleotide_accession_version='NC_000083.6', start_position_on_the_genomic_accession=34112019, end_position_on_the_genomic_accession=34122814, orientation='minus', exon_count=17, OMIM=[], no_hdr0=''),
    14313 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=14313, CurrentID=0, Status='live', Symbol='Fst', Aliases=['AL033346', 'D2Mgi5', 'FS'], description='follistatin', other_designations='follistatin|activin-binding protein', map_location='13 D2.2', chromosome='13', genomic_nucleotide_accession_version='NC_000079.6', start_position_on_the_genomic_accession=114452262, end_position_on_the_genomic_accession=114458989, orientation='minus', exon_count=6, OMIM=[], no_hdr0=''),
    14314 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=14314, CurrentID=0, Status='live', Symbol='Fstl1', Aliases=['AI316791', 'AW107808', 'Fstl', 'TSC-3', 'TSC-36'], description='follistatin-like 1', other_designations='follistatin-related protein 1|TGF-beta-inducible protein TSC-36|follistatin-like protein 1', map_location='16 26.48 cM', chromosome='16', genomic_nucleotide_accession_version='NC_000082.6', start_position_on_the_genomic_accession=37777055, end_position_on_the_genomic_accession=37836516, orientation='plus', exon_count=11, OMIM=[], no_hdr0=''),
    14317 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=14317, CurrentID=0, Status='live', Symbol='Ftcd', Aliases=[], description='formiminotransferase cyclodeaminase', other_designations='formimidoyltransferase-cyclodeaminase|glutamate formiminotransferase', map_location='10 39.25 cM', chromosome='10', genomic_nucleotide_accession_version='NC_000076.6', start_position_on_the_genomic_accession=76575648, end_position_on_the_genomic_accession=76590338, orientation='plus', exon_count=15, OMIM=[], no_hdr0=''),
    14319 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=14319, CurrentID=0, Status='live', Symbol='Fth1', Aliases=['FHC', 'Fth', 'H-fer', 'HFt', 'MFH'], description='ferritin heavy polypeptide 1', other_designations='ferritin heavy chain|H-ferritin|ferritin H subunit|ferritin heavy chain 1', map_location='19 6.23 cM', chromosome='19', genomic_nucleotide_accession_version='NC_000085.6', start_position_on_the_genomic_accession=9980600, end_position_on_the_genomic_accession=9985111, orientation='plus', exon_count=5, OMIM=[], no_hdr0=''),
    14325 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=14325, CurrentID=0, Status='live', Symbol='Ftl1', Aliases=['Ft', 'Ftl', 'Ftl-1', 'L-fe', 'L-ferritin'], description='ferritin light polypeptide 1', other_designations='ferritin light chain 1|ferritin L subunit 1', map_location='7 B3', chromosome='7', genomic_nucleotide_accession_version='NC_000073.6', start_position_on_the_genomic_accession=45457944, end_position_on_the_genomic_accession=45459886, orientation='minus', exon_count=4, OMIM=[], no_hdr0=''),
    14339 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=14339, CurrentID=0, Status='live', Symbol='Aktip', Aliases=['AL023020', 'Fif', 'Ft', 'Ft1', 'Fts'], description='thymoma viral proto-oncogene 1 interacting protein', other_designations='AKT-interacting protein|fused toes protein', map_location='8 44.25 cM', chromosome='8', genomic_nucleotide_accession_version='NC_000074.6', start_position_on_the_genomic_accession=91111781, end_position_on_the_genomic_accession=91135494, orientation='minus', exon_count=16, OMIM=[], no_hdr0=''),
    14343 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=14343, CurrentID=0, Status='live', Symbol='Fut1', Aliases=['MFUT-1'], description='fucosyltransferase 1', other_designations='galactoside alpha-(1,2)-fucosyltransferase 1|GDP-L-fucose:beta-D-galactoside 2-alpha-L-fucosyltransferase 1|H transferase|alpha(1,2)FT 1|beta-galactoside alpha-1,2-fucosyltransferase|galactoside 2-alpha-L-fucosyltransferase 1|type 1 galactoside alpha-(1,2)-fucosyltransferase FUT1|type 2 galactoside alpha-(1,2)-fucosyltransferase FUT1', map_location='7 29.39 cM', chromosome='7', genomic_nucleotide_accession_version='NC_000073.6', start_position_on_the_genomic_accession=45617606, end_position_on_the_genomic_accession=45621059, orientation='plus', exon_count=2, OMIM=[], no_hdr0=''),
    14344 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=14344, CurrentID=0, Status='live', Symbol='Fut2', Aliases=['MFUT-II'], description='fucosyltransferase 2', other_designations='galactoside alpha-(1,2)-fucosyltransferase 2|galactoside 2-alpha-L-fucosyltransferase 2|GDP-L-fucose:beta-D-galactoside 2-alpha-L-fucosyltransferase 2|GDP-fucose: beta-galactoside alpha1,2-fucosyltransferase|alpha(1,2)FT 2|secretory blood group protein 2|type 1 galactoside alpha-(1,2)-fucosyltransferase FUT2|type 2 galactoside alpha-(1,2)-fucosyltransferase FUT2', map_location='7 29.41 cM', chromosome='7', genomic_nucleotide_accession_version='NC_000073.6', start_position_on_the_genomic_accession=45648591, end_position_on_the_genomic_accession=45666394, orientation='minus', exon_count=4, OMIM=[], no_hdr0=''),
    14345 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=14345, CurrentID=0, Status='live', Symbol='Fut4', Aliases=['AI451562', 'CD15', 'F', 'FAL', 'FucT-', 'FucT-IV', 'LeX', 'SSE', 'SSEA-1', 'Ss', 'Ssea1'], description='fucosyltransferase 4', other_designations='alpha-(1,3)-fucosyltransferase 4|3-fucosyl-N-acetyl-lactosamine epitope|Lewis x|alpha (1,3) fucosyltransferase, myeloid specific|alpha 1,3-fucosyltransferase|fuc-TIV|fucosyltransferase IV|galactoside 3-L-fucosyltransferase|stage-specific embryonic antigen 1', map_location='9 4.3 cM', chromosome='9', genomic_nucleotide_accession_version='NC_000075.6', start_position_on_the_genomic_accession=14748459, end_position_on_the_genomic_accession=14752122, orientation='minus', exon_count=1, OMIM=[], no_hdr0=''),
    14347 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=14347, CurrentID=0, Status='live', Symbol='Fut7', Aliases=['AI853193', 'FT', 'FTVII', 'Fuc-T', 'Fuc-TVII', 'FucT-', 'FucT-VII'], description='fucosyltransferase 7', other_designations='alpha-(1,3)-fucosyltransferase 7|fucosyltransferase VII|galactoside 3-L-fucosyltransferase', map_location='2 A3', chromosome='2', genomic_nucleotide_accession_version='NC_000068.7', start_position_on_the_genomic_accession=25422351, end_position_on_the_genomic_accession=25426374, orientation='plus', exon_count=4, OMIM=[], no_hdr0=''),
    14348 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=14348, CurrentID=0, Status='live', Symbol='Fut9', Aliases=['AI746471', 'AU067636', 'mFUT9', 'mFuc-TI', 'mFuc-TIX'], description='fucosyltransferase 9', other_designations='4-galactosyl-N-acetylglucosaminide 3-alpha-L-fucosyltransferase 9|alpha-(1,3)-fucosyltransferase 9|fuc-TIX|fucT-IX|fucosyltransferase IX|galactoside 3-L-fucosyltransferase', map_location='4 10.59 cM', chromosome='4', genomic_nucleotide_accession_version='NC_000070.6', start_position_on_the_genomic_accession=25609333, end_position_on_the_genomic_accession=25800003, orientation='minus', exon_count=3, OMIM=[], no_hdr0=''),
    14349 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=14349, CurrentID=0, Status='live', Symbol='Fv1', Aliases=['Fv-', 'Fv-1d', 'R', 'Rv', 'Rv-1', 'Rv1', 'Fv1'], description='Friend virus susceptibility 1', other_designations='Friend virus susceptibility protein 1|Fv1 gammaretrovirus restriction factor|Fv1 restriction factor|Rauscher leukemia virus susceptibility 1|retrovirus restriction protein', map_location='4 78.56 cM', chromosome='4', genomic_nucleotide_accession_version='NC_000070.6', start_position_on_the_genomic_accession=147868979, end_position_on_the_genomic_accession=147870358, orientation='plus', exon_count=1, OMIM=[], no_hdr0=''),
    14356 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=14356, CurrentID=0, Status='live', Symbol='Timm10b', Aliases=['Fxc1', 'Tim10', 'Tim10b', 'Tim9', 'Tim9b'], description='translocase of inner mitochondrial membrane 10B', other_designations='mitochondrial import inner membrane translocase subunit Tim10 B|Fracture Callus 1|fractured callus 1|fractured callus expressed transcript 1|mitochondrial import inner membrane translocase subunit Tim9 B|small zinc finger-like protein', map_location='7 E3', chromosome='7', genomic_nucleotide_accession_version='NC_000073.6', start_position_on_the_genomic_accession=105640445, end_position_on_the_genomic_accession=105655748, orientation='plus', exon_count=8, OMIM=[], no_hdr0=''),
    14357 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=14357, CurrentID=0, Status='live', Symbol='Dtx1', Aliases=['Fxit', 'Fxit1', 'mKIAA4160'], description='deltex 1, E3 ubiquitin ligase', other_designations='E3 ubiquitin-protein ligase DTX1|FXI-T1|RING-type E3 ubiquitin transferase DTX1|deltex 1 homolog|deltex1|fractionated x-irradiation induced transcript 1|mDTX1|protein deltex-1', map_location='5 60.64 cM', chromosome='5', genomic_nucleotide_accession_version='NC_000071.6', start_position_on_the_genomic_accession=120680203, end_position_on_the_genomic_accession=120711867, orientation='minus', exon_count=11, OMIM=[], no_hdr0=''),
    14359 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=14359, CurrentID=0, Status='live', Symbol='Fxr1', Aliases=['1110050J02Rik', '9530073J07Rik', 'AI851072', 'Fxrh', 'Fxr1p', 'Fxr1'], description='fragile X mental retardation gene 1, autosomal homolog', other_designations='fragile X mental retardation syndrome-related protein 1|fragile X mental retardation gene, autosomal homolog', map_location='3 A3', chromosome='3', genomic_nucleotide_accession_version='NC_000069.6', start_position_on_the_genomic_accession=34020058, end_position_on_the_genomic_accession=34069980, orientation='plus', exon_count=17, OMIM=[], no_hdr0=''),
    14360 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=14360, CurrentID=0, Status='live', Symbol='Fyn', Aliases=['AI448320', 'AW552119'], description='Fyn proto-oncogene', other_designations='tyrosine-protein kinase Fyn|Src Kinase p59|p59-Fyn|proto-oncogene c-Fyn|proto-oncogene tyrosine-protein kinase Fyn', map_location='10 20.51 cM', chromosome='10', genomic_nucleotide_accession_version='NC_000076.6', start_position_on_the_genomic_accession=39369743, end_position_on_the_genomic_accession=39565381, orientation='plus', exon_count=18, OMIM=[], no_hdr0=''),
    14362 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=14362, CurrentID=0, Status='live', Symbol='Fzd1', Aliases=['AW227548', 'FZ-1', 'Fz1'], description='frizzled class receptor 1', other_designations='frizzled-1|frizzled homolog 1|mFz1', map_location='5 2.61 cM', chromosome='5', genomic_nucleotide_accession_version='NC_000071.6', start_position_on_the_genomic_accession=4753839, end_position_on_the_genomic_accession=4758216, orientation='minus', exon_count=1, OMIM=[], no_hdr0=''),
    14365 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=14365, CurrentID=0, Status='live', Symbol='Fzd3', Aliases=['AU020229', 'D930050A07Rik', 'Fz3'], description='frizzled class receptor 3', other_designations='frizzled-3|frizzled homolog 3|fz-3|mFz3', map_location='14 34.09 cM', chromosome='14', genomic_nucleotide_accession_version='NC_000080.6', start_position_on_the_genomic_accession=65192441, end_position_on_the_genomic_accession=65262463, orientation='minus', exon_count=7, OMIM=[], no_hdr0=''),
    14366 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=14366, CurrentID=0, Status='live', Symbol='Fzd4', Aliases=['Fz4'], description='frizzled class receptor 4', other_designations='frizzled-4|frizzled homolog 4|fz-4|mFz4', map_location='7 49.32 cM', chromosome='7', genomic_nucleotide_accession_version='NC_000073.6', start_position_on_the_genomic_accession=89404366, end_position_on_the_genomic_accession=89410110, orientation='plus', exon_count=2, OMIM=[], no_hdr0=''),
    14367 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=14367, CurrentID=0, Status='live', Symbol='Fzd5', Aliases=['5330434N09Rik', 'AI427138', 'Fz-5', 'Fz5', 'mFz5'], description='frizzled class receptor 5', other_designations='frizzled-5|frizzled homolog 5', map_location='1 32.74 cM', chromosome='1', genomic_nucleotide_accession_version='NC_000067.6', start_position_on_the_genomic_accession=64730558, end_position_on_the_genomic_accession=64737750, orientation='minus', exon_count=2, OMIM=[], no_hdr0=''),
    14368 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=14368, CurrentID=0, Status='live', Symbol='Fzd6', Aliases=['Fz6'], description='frizzled class receptor 6', other_designations='frizzled-6|frizzled homolog 6|fz-6|mFz6', map_location='15 15.22 cM', chromosome='15', genomic_nucleotide_accession_version='NC_000081.6', start_position_on_the_genomic_accession=39006149, end_position_on_the_genomic_accession=39038192, orientation='plus', exon_count=8, OMIM=[], no_hdr0=''),
    14369 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=14369, CurrentID=0, Status='live', Symbol='Fzd7', Aliases=['Fz7'], description='frizzled class receptor 7', other_designations='frizzled-7|frizzled homolog 7|fz-7|mFz7', map_location='1 30.08 cM', chromosome='1', genomic_nucleotide_accession_version='NC_000067.6', start_position_on_the_genomic_accession=59482147, end_position_on_the_genomic_accession=59486955, orientation='plus', exon_count=1, OMIM=[], no_hdr0=''),
    14370 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=14370, CurrentID=0, Status='live', Symbol='Fzd8', Aliases=['Fz8'], description='frizzled class receptor 8', other_designations='frizzled-8|frizzled homolog 8|fz-8', map_location='18 4.91 cM', chromosome='18', genomic_nucleotide_accession_version='NC_000084.6', start_position_on_the_genomic_accession=9212856, end_position_on_the_genomic_accession=9216201, orientation='plus', exon_count=1, OMIM=[], no_hdr0=''),
    14371 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=14371, CurrentID=0, Status='live', Symbol='Fzd9', Aliases=['Fz9', 'mfz9'], description='frizzled class receptor 9', other_designations='frizzled-9|frizzled homolog 9|fz-9|mFz3', map_location='5 75.08 cM', chromosome='5', genomic_nucleotide_accession_version='NC_000071.6', start_position_on_the_genomic_accession=135248938, end_position_on_the_genomic_accession=135251047, orientation='minus', exon_count=1, OMIM=[], no_hdr0=''),
    14373 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=14373, CurrentID=0, Status='live', Symbol='G0s2', Aliases=['AI255151', 'AV006465'], description='G0/G1 switch gene 2', other_designations='G0/G1 switch protein 2|G0S2-like protein|putative lymphocyte G0/G1 switch protein 2', map_location='1 97.69 cM', chromosome='1', genomic_nucleotide_accession_version='NC_000067.6', start_position_on_the_genomic_accession=193272160, end_position_on_the_genomic_accession=193273188, orientation='minus', exon_count=2, OMIM=[], no_hdr0=''),
    14375 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=14375, CurrentID=0, Status='live', Symbol='Xrcc6', Aliases=['70kDa', 'G22p', 'G22p1', 'Ku70'], description='X-ray repair complementing defective repair in Chinese hamster cells 6', other_designations="X-ray repair cross-complementing protein 6|5'-dRP/AP lyase Ku70|5'-deoxyribose-5-phosphate lyase Ku70|ATP-dependent DNA helicase 2 subunit 1|ATP-dependent DNA helicase II 70 kDa subunit|CTC box-binding factor 75 kDa subunit|CTC75|CTCBF|DNA repair protein XRCC6|Ku p70|ku autoantigen protein p70 homolog|thyroid autoantigen 70 kDa", map_location='15 38.33 cM', chromosome='15', genomic_nucleotide_accession_version='NC_000081.6', start_position_on_the_genomic_accession=81987833, end_position_on_the_genomic_accession=82040085, orientation='plus', exon_count=17, OMIM=[], no_hdr0=''),
    14376 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=14376, CurrentID=0, Status='live', Symbol='Ganab', Aliases=['AU042638', 'G2', 'G2an', 'Gl', 'GluII', 'mKIAA0088'], description='alpha glucosidase 2 alpha neutral subunit', other_designations='neutral alpha-glucosidase AB|alpha-glucosidase 2|carbohydrate processing enzyme of the endoplasmic reticulum|glucosidase II alpha-subunit|glucosidase II subunit alpha', map_location='19 A', chromosome='19', genomic_nucleotide_accession_version='NC_000085.6', start_position_on_the_genomic_accession=8898057, end_position_on_the_genomic_accession=8916742, orientation='plus', exon_count=26, OMIM=[], no_hdr0=''),
    14377 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=14377, CurrentID=0, Status='live', Symbol='G6pc', Aliases=['AW107337', 'G6P', 'G6Pase', 'G6pt', 'Glc-6-', 'Glc-6-Pase'], description='glucose-6-phosphatase, catalytic', other_designations='glucose-6-phosphatase|Glc-6-Pase-alpha', map_location='11 D', chromosome='11', genomic_nucleotide_accession_version='NC_000077.6', start_position_on_the_genomic_accession=101367716, end_position_on_the_genomic_accession=101377903, orientation='plus', exon_count=5, OMIM=[], no_hdr0=''),
    14378 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=14378, CurrentID=0, Status='live', Symbol='G6pc2', Aliases=['G6pc', 'G6pc-rs', 'I', 'IGRP'], description='glucose-6-phosphatase, catalytic, 2', other_designations='glucose-6-phosphatase 2|G-6-Pase 2|glucose-6-phosphatase, catalytic, related sequence|islet-specific glucose-6-phosphatase catalytic subunit-related protein', map_location='2 39.66 cM', chromosome='2', genomic_nucleotide_accession_version='NC_000068.7', start_position_on_the_genomic_accession=69211073, end_position_on_the_genomic_accession=69227993, orientation='plus', exon_count=6, OMIM=[], no_hdr0=''),
    14380 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=14380, CurrentID=0, Status='live', Symbol='G6pd2', Aliases=['G6pdx-', 'G6pdx-ps1', 'Gpd', 'Gpd-', 'Gpd-2', 'Gpd2'], description='glucose-6-phosphate dehydrogenase 2', other_designations='glucose-6-phosphate 1-dehydrogenase 2|G6PD|glucose-6-phosphate dehydrogenase X-linked, pseudogene 1', map_location='5 31.99 cM', chromosome='5', genomic_nucleotide_accession_version='NC_000071.6', start_position_on_the_genomic_accession=61808843, end_position_on_the_genomic_accession=61810477, orientation='plus', exon_count=1, OMIM=[], no_hdr0=''),
    14381 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=14381, CurrentID=0, Status='live', Symbol='G6pdx', Aliases=['G28', 'G28A', 'G6p', 'G6pd', 'Gpd', 'Gpdx'], description='glucose-6-phosphate dehydrogenase X-linked', other_designations='glucose-6-phosphate 1-dehydrogenase X', map_location='X 38.0 cM', chromosome='X', genomic_nucleotide_accession_version='NC_000086.7', start_position_on_the_genomic_accession=74409483, end_position_on_the_genomic_accession=74428880, orientation='minus', exon_count=13, OMIM=[], no_hdr0=''),
    14385 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=14385, CurrentID=0, Status='live', Symbol='Slc37a4', Aliases=['100043178', 'G6P', 'G6PT', 'G6pt1', 'GSD-1b', 'mG6PT'], description='solute carrier family 37 (glucose-6-phosphate transporter), member 4', other_designations='glucose-6-phosphate exchanger SLC37A4|glucose 6-phosphate transporter|glucose-6-phosphatase, transport protein 1|solute carrier family 37 (glycerol-6-phosphate transporter), member 4', map_location='9 A5.2', chromosome='9', genomic_nucleotide_accession_version='NC_000075.6', start_position_on_the_genomic_accession=44396946, end_position_on_the_genomic_accession=44402966, orientation='plus', exon_count=12, OMIM=[], no_hdr0=''),
    14387 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=14387, CurrentID=0, Status='live', Symbol='Gaa', Aliases=['E430018M07Rik'], description='glucosidase, alpha, acid', other_designations='lysosomal alpha-glucosidase|acid maltase', map_location='11 83.35 cM', chromosome='11', genomic_nucleotide_accession_version='NC_000077.6', start_position_on_the_genomic_accession=119267963, end_position_on_the_genomic_accession=119285458, orientation='plus', exon_count=20, OMIM=[], no_hdr0=''),
    14388 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=14388, CurrentID=0, Status='live', Symbol='Gab1', Aliases=['AA408973', 'AW107238'], description='growth factor receptor bound protein 2-associated protein 1', other_designations='GRB2-associated-binding protein 1|GRB2-associated binder 1', map_location='8 C2', chromosome='8', genomic_nucleotide_accession_version='NC_000074.6', start_position_on_the_genomic_accession=80764431, end_position_on_the_genomic_accession=80880519, orientation='minus', exon_count=16, OMIM=[], no_hdr0=''),
    14389 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=14389, CurrentID=0, Status='live', Symbol='Gab2', Aliases=['AI463667', 'D130058I17Rik', 'p9', 'p97'], description='growth factor receptor bound protein 2-associated protein 2', other_designations='GRB2-associated-binding protein 2|GRB2-associated binder 2|Grb2 associated binder 2|PH domain-containing adaptor molecule p97', map_location='7 E1', chromosome='7', genomic_nucleotide_accession_version='NC_000073.6', start_position_on_the_genomic_accession=97081751, end_position_on_the_genomic_accession=97308951, orientation='plus', exon_count=10, OMIM=[], no_hdr0=''),
    14390 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=14390, CurrentID=0, Status='live', Symbol='Gabpa', Aliases=['GAB', 'GABPalpha'], description='GA repeat binding protein, alpha', other_designations='GA-binding protein alpha chain|GA-binding protein alpha-subunit|GABP subunit alpha', map_location='16 46.92 cM', chromosome='16', genomic_nucleotide_accession_version='NC_000082.6', start_position_on_the_genomic_accession=84834891, end_position_on_the_genomic_accession=84863783, orientation='plus', exon_count=11, OMIM=[], no_hdr0=''),
    14391 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=14391, CurrentID=0, Status='live', Symbol='Gabpb1', Aliases=['BABP', 'BABPB2', 'E4TF1', 'E4TF1-47', 'E4TF1-53', 'E4Tf1B', 'GABPB', 'GABPB-1', 'GABPB-2', 'GABPB1-1', 'GABPB1-2', 'NRF2', 'NRF2B1', 'NRF2B2'], description='GA repeat binding protein, beta 1', other_designations='GA-binding protein subunit beta-1|GA binding protein subunit beta1|GABP subunit beta-1|GABP subunit beta-2|Gabp beta1', map_location='2 61.76 cM', chromosome='2', genomic_nucleotide_accession_version='NC_000068.7', start_position_on_the_genomic_accession=126628907, end_position_on_the_genomic_accession=126684435, orientation='minus', exon_count=12, OMIM=[], no_hdr0=''),
    14394 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=14394, CurrentID=0, Status='live', Symbol='Gabra1', Aliases=['GABAA-alpha1', 'GABAAR-alpha1', 'Gabr', 'Gabra-1'], description='gamma-aminobutyric acid (GABA) A receptor, subunit alpha 1', other_designations='gamma-aminobutyric acid receptor subunit alpha-1|GABA(A) receptor subunit alpha-1|GABAA alpha 1|GABAAR alpha1', map_location='11 24.97 cM', chromosome='11', genomic_nucleotide_accession_version='NC_000077.6', start_position_on_the_genomic_accession=42130939, end_position_on_the_genomic_accession=42183066, orientation='minus', exon_count=12, OMIM=[], no_hdr0=''),
    14395 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=14395, CurrentID=0, Status='live', Symbol='Gabra2', Aliases=['C630048P16Rik', 'Gabr', 'Gabra-2'], description='gamma-aminobutyric acid (GABA) A receptor, subunit alpha 2', other_designations='gamma-aminobutyric acid receptor subunit alpha-2', map_location='5 37.59 cM', chromosome='5', genomic_nucleotide_accession_version='NC_000071.6', start_position_on_the_genomic_accession=70958392, end_position_on_the_genomic_accession=71095849, orientation='minus', exon_count=11, OMIM=[], no_hdr0=''),
    14396 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=14396, CurrentID=0, Status='live', Symbol='Gabra3', Aliases=['Gabr', 'Gabra-3'], description='gamma-aminobutyric acid (GABA) A receptor, subunit alpha 3', other_designations='gamma-aminobutyric acid receptor subunit alpha-3|GABA(A) receptor subunit alpha-3', map_location='X 37.24 cM', chromosome='X', genomic_nucleotide_accession_version='NC_000086.7', start_position_on_the_genomic_accession=72432676, end_position_on_the_genomic_accession=72656919, orientation='minus', exon_count=12, OMIM=[], no_hdr0=''),
    14397 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=14397, CurrentID=0, Status='live', Symbol='Gabra4', Aliases=['Gabr', 'Gabra-4'], description='gamma-aminobutyric acid (GABA) A receptor, subunit alpha 4', other_designations='gamma-aminobutyric acid receptor subunit alpha-4|GABA(A) receptor subunit alpha-4', map_location='5 C3.1-C3.2', chromosome='5', genomic_nucleotide_accession_version='NC_000071.6', start_position_on_the_genomic_accession=71569734, end_position_on_the_genomic_accession=71658308, orientation='minus', exon_count=9, OMIM=[], no_hdr0=''),
    14399 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=14399, CurrentID=0, Status='live', Symbol='Gabra6', Aliases=['GABA-ARalpha6', 'Gabr', 'Gabra-6', 'al', 'alpha6'], description='gamma-aminobutyric acid (GABA) A receptor, subunit alpha 6', other_designations='gamma-aminobutyric acid receptor subunit alpha-6|GABA(A) receptor subunit alpha-6|GABAA receptor alpha 6 subunit|subunit alpha 6 gamma-aminobutyric acid (GABA-A) receptor', map_location='11 25.03 cM', chromosome='11', genomic_nucleotide_accession_version='NC_000077.6', start_position_on_the_genomic_accession=42306437, end_position_on_the_genomic_accession=42321072, orientation='minus', exon_count=10, OMIM=[], no_hdr0=''),
    14400 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=14400, CurrentID=0, Status='live', Symbol='Gabrb1', Aliases=['AW061132', 'B230208N19Rik', 'Gabrb', 'Gabrb-1'], description='gamma-aminobutyric acid (GABA) A receptor, subunit beta 1', other_designations='gamma-aminobutyric acid receptor subunit beta-1|GABA(A) receptor subunit beta-1', map_location='5 38.18 cM', chromosome='5', genomic_nucleotide_accession_version='NC_000071.6', start_position_on_the_genomic_accession=71657921, end_position_on_the_genomic_accession=72149572, orientation='plus', exon_count=11, OMIM=[], no_hdr0=''),
    14401 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=14401, CurrentID=0, Status='live', Symbol='Gabrb2', Aliases=['AI834970', 'C030002O17Rik', 'C030021G16Rik', 'Gabrab2', 'Gabrb', 'Gabrb-2'], description='gamma-aminobutyric acid (GABA) A receptor, subunit beta 2', other_designations='gamma-aminobutyric acid receptor subunit beta-2|GABA(A) receptor subunit beta-2|gamma-aminobutyric acid A receptor, subunit beta 2|gamma-aminobutyric acid receptor beta-2 subunit', map_location='11 25.08 cM', chromosome='11', genomic_nucleotide_accession_version='NC_000077.6', start_position_on_the_genomic_accession=42419515, end_position_on_the_genomic_accession=42632591, orientation='plus', exon_count=12, OMIM=[], no_hdr0=''),
    14402 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=14402, CurrentID=0, Status='live', Symbol='Gabrb3', Aliases=['A230092K12Rik', 'AW049585', 'Cp1', 'Gabrb', 'Gabrb-3', 'beta3'], description='gamma-aminobutyric acid (GABA) A receptor, subunit beta 3', other_designations='gamma-aminobutyric acid receptor subunit beta-3|GABA(A) receptor subunit beta-3|cleft palate 1', map_location='7 33.53 cM', chromosome='7', genomic_nucleotide_accession_version='NC_000073.6', start_position_on_the_genomic_accession=57590518, end_position_on_the_genomic_accession=57828802, orientation='plus', exon_count=10, OMIM=[], no_hdr0=''),
    14403 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=14403, CurrentID=0, Status='live', Symbol='Gabrd', Aliases=['AI853201'], description='gamma-aminobutyric acid (GABA) A receptor, subunit delta', other_designations='gamma-aminobutyric acid receptor subunit delta|GABA(A) receptor subunit delta', map_location='4 E2', chromosome='4', genomic_nucleotide_accession_version='NC_000070.6', start_position_on_the_genomic_accession=155384979, end_position_on_the_genomic_accession=155398098, orientation='minus', exon_count=10, OMIM=[], no_hdr0=''),
    14404 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=14404, CurrentID=0, Status='live', Symbol='Gabre', Aliases=[], description='gamma-aminobutyric acid (GABA) A receptor, subunit epsilon', other_designations='gamma-aminobutyric acid receptor subunit epsilon', map_location='X A7.3', chromosome='X', genomic_nucleotide_accession_version='NC_000086.7', start_position_on_the_genomic_accession=72256926, end_position_on_the_genomic_accession=72274828, orientation='minus', exon_count=11, OMIM=[], no_hdr0=''),
    14405 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=14405, CurrentID=0, Status='live', Symbol='Gabrg1', Aliases=['Ga', 'GabaA', 'GabaA/BZ'], description='gamma-aminobutyric acid (GABA) A receptor, subunit gamma 1', other_designations='gamma-aminobutyric acid receptor subunit gamma-1|GABA(A) receptor subunit gamma-1', map_location='5 37.43 cM', chromosome='5', genomic_nucleotide_accession_version='NC_000071.6', start_position_on_the_genomic_accession=70751047, end_position_on_the_genomic_accession=70842617, orientation='minus', exon_count=12, OMIM=[], no_hdr0=''),
    14406 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=14406, CurrentID=0, Status='live', Symbol='Gabrg2', Aliases=['GAB', 'GABAA-R', 'Gabrg', 'Gabrg-2', 'gamm', 'gamma2'], description='gamma-aminobutyric acid (GABA) A receptor, subunit gamma 2', other_designations='gamma-aminobutyric acid receptor subunit gamma-2', map_location='11 24.8 cM', chromosome='11', genomic_nucleotide_accession_version='NC_000077.6', start_position_on_the_genomic_accession=41910190, end_position_on_the_genomic_accession=42000857, orientation='minus', exon_count=11, OMIM=[], no_hdr0=''),
    14407 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=14407, CurrentID=0, Status='live', Symbol='Gabrg3', Aliases=['6330406O05', '6330406O05Rik', 'B230362M20Rik', 'Gabrg', 'Gabrg-3'], description='gamma-aminobutyric acid (GABA) A receptor, subunit gamma 3', other_designations='gamma-aminobutyric acid receptor subunit gamma-3', map_location='7 33.48 cM', chromosome='7', genomic_nucleotide_accession_version='NC_000073.6', start_position_on_the_genomic_accession=56716463, end_position_on_the_genomic_accession=57387215, orientation='minus', exon_count=10, OMIM=[], no_hdr0=''),
    14408 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=14408, CurrentID=0, Status='live', Symbol='Gabrr1', Aliases=['GABA', 'GABA-C'], description='gamma-aminobutyric acid (GABA) C receptor, subunit rho 1', other_designations='gamma-aminobutyric acid receptor subunit rho-1|GABA(A) receptor subunit rho-1|GABA(C) receptor|gamma-aminobutyric acid (GABA-A) receptor, subunit rho 1', map_location='4 14.68 cM', chromosome='4', genomic_nucleotide_accession_version='NC_000070.6', start_position_on_the_genomic_accession=33132556, end_position_on_the_genomic_accession=33163588, orientation='plus', exon_count=11, OMIM=[], no_hdr0=''),
    14409 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=14409, CurrentID=0, Status='live', Symbol='Gabrr2', Aliases=[], description='gamma-aminobutyric acid (GABA) C receptor, subunit rho 2', other_designations='gamma-aminobutyric acid receptor subunit rho-2|GABA(A) receptor subunit rho-2|GABA(C) receptor|gamma-aminobutyric acid (GABA-A) receptor, subunit rho 2|gamma-aminobutyric acid receptor rho2 subunit', map_location='4 14.64 cM', chromosome='4', genomic_nucleotide_accession_version='NC_000070.6', start_position_on_the_genomic_accession=33057712, end_position_on_the_genomic_accession=33095865, orientation='plus', exon_count=10, OMIM=[], no_hdr0=''),
    14411 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=14411, CurrentID=0, Status='live', Symbol='Slc6a12', Aliases=['BGT1', 'GAT-2', 'GAT2', 'Gabt', 'Gabt2'], description='solute carrier family 6 (neurotransmitter transporter, betaine/GABA), member 12', other_designations='sodium- and chloride-dependent betaine transporter|Na(+)/Cl(-) betaine/GABA transporter|gamma-aminobutyric acid (GABA-A) transporter 2|sodium- and chloride-dependent GABA transporter 2|solute carrier family 6 member 12', map_location='6 F1', chromosome='6', genomic_nucleotide_accession_version='NC_000072.6', start_position_on_the_genomic_accession=121342574, end_position_on_the_genomic_accession=121365773, orientation='plus', exon_count=21, OMIM=[], no_hdr0=''),
    14412 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=14412, CurrentID=0, Status='live', Symbol='Slc6a13', Aliases=['GAT3', 'Gabt', 'Gabt3', 'Gat', 'Gat2'], description='solute carrier family 6 (neurotransmitter transporter, GABA), member 13', other_designations='sodium- and chloride-dependent GABA transporter 2|GAT-2|GAT-3|gamma-aminobutyric acid (GABA-A) transporter 3|sodium- and chloride-dependent GABA transporter 3|solute carrier family 6 member 13', map_location='6 F1', chromosome='6', genomic_nucleotide_accession_version='NC_000072.6', start_position_on_the_genomic_accession=121300288, end_position_on_the_genomic_accession=121337721, orientation='plus', exon_count=18, OMIM=[], no_hdr0=''),
    14415 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=14415, CurrentID=0, Status='live', Symbol='Gad1', Aliases=['EP1', 'EP10', 'GAD2', 'GAD4', 'GAD6', 'Gad-', 'Gad-1'], description='glutamate decarboxylase 1', other_designations='glutamate decarboxylase 1|67 kDa glutamic acid decarboxylase|glutamic acid decarboxylase 1', map_location='2 41.63 cM', chromosome='2', genomic_nucleotide_accession_version='NC_000068.7', start_position_on_the_genomic_accession=70561303, end_position_on_the_genomic_accession=70602014, orientation='plus', exon_count=19, OMIM=[], no_hdr0=''),
    14417 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=14417, CurrentID=0, Status='live', Symbol='Gad2', Aliases=['6330404F12Rik', 'GAD(65', 'GAD(65)', 'GAD6', 'GAD65', 'Gad-', 'Gad-2'], description='glutamic acid decarboxylase 2', other_designations='glutamate decarboxylase 2|65 kDa glutamic acid decarboxylase|GAD-65', map_location='2 15.15 cM', chromosome='2', genomic_nucleotide_accession_version='NC_000068.7', start_position_on_the_genomic_accession=22621015, end_position_on_the_genomic_accession=22693877, orientation='plus', exon_count=17, OMIM=[], no_hdr0=''),
    14419 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=14419, CurrentID=0, Status='live', Symbol='Gal', Aliases=['Gn', 'Gal'], description='galanin and GMAP prepropeptide', other_designations='galanin peptides|galanin', map_location='19 3.16 cM', chromosome='19', genomic_nucleotide_accession_version='NC_000085.6', start_position_on_the_genomic_accession=3409915, end_position_on_the_genomic_accession=3414544, orientation='minus', exon_count=6, OMIM=[], no_hdr0=''),
    14420 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=14420, CurrentID=0, Status='live', Symbol='Galc', Aliases=['2310068B06Rik', 'A930008M05Rik', 'AW212969', 'AW413532', 'Gac', 'Gacy', 'twi', 'twitcher'], description='galactosylceramidase', other_designations='galactocerebrosidase|GALCERase|galactocerebroside beta-galactosidase|galactosylceramide beta-galactosidase', map_location='12 49.83 cM', chromosome='12', genomic_nucleotide_accession_version='NC_000078.6', start_position_on_the_genomic_accession=98202287, end_position_on_the_genomic_accession=98259459, orientation='minus', exon_count=19, OMIM=[], no_hdr0=''),
    14421 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=14421, CurrentID=0, Status='live', Symbol='B4galnt1', Aliases=['4933429D13Rik', 'Gal', 'Gal-N', 'Gal-NAc-T', 'GalN', 'GalNAc-T', 'GalNAcT', 'Galg', 'Galgt1', 'Ggm-2', 'Ggm2'], description='beta-1,4-N-acetyl-galactosaminyl transferase 1', other_designations='beta-1,4 N-acetylgalactosaminyltransferase 1|(N-acetylneuraminyl)-galactosylglucosylceramide|GM2/GD2 synthase|UDP-N-acetyl-alpha-D-galactosamine:(N-acetylneuraminyl)-galactosylglucosylceramide-beta-1, 4-N-acetylgalactosaminyltransferase|beta1,4GalNAC-T', map_location='10 74.5 cM', chromosome='10', genomic_nucleotide_accession_version='NC_000076.6', start_position_on_the_genomic_accession=127165156, end_position_on_the_genomic_accession=127172340, orientation='plus', exon_count=13, OMIM=[], no_hdr0=''),
    14422 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=14422, CurrentID=0, Status='live', Symbol='B4galnt2', Aliases=['AI593864', 'Dlb', 'Dlb-', 'Dlb-1', 'Dlb1', 'Galg', 'Galg2', 'Galgt2', 'Ggm3', 'Igf2bp1'], description='beta-1,4-N-acetyl-galactosaminyl transferase 2', other_designations='beta-1,4 N-acetylgalactosaminyltransferase 2|CT-Gal NAc transferase|N-acetylgalactosaminyltransferase|UDP-N-acetyl-alpha-D-galactosamine:(N-acetylneuraminyl)-galactosyl-N-acetylglucosaminylpolypeptide-beta-1, 4-N-acetylgalactosaminyltransferase|dolichos lectin binding 1', map_location='11 59.02 cM', chromosome='11', genomic_nucleotide_accession_version='NC_000077.6', start_position_on_the_genomic_accession=95863559, end_position_on_the_genomic_accession=95914960, orientation='minus', exon_count=11, OMIM=[], no_hdr0=''),
    14423 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=14423, CurrentID=0, Status='live', Symbol='Galnt1', Aliases=[], description='polypeptide N-acetylgalactosaminyltransferase 1', other_designations='polypeptide N-acetylgalactosaminyltransferase 1|UDP-GalNAc:polypeptide N-acetylgalactosaminyltransferase 1|UDP-N-acetyl-alpha-D-galactosamine:polypeptide N-acetylgalactosaminyltransferase 1|galNAc-T1|polypeptide GalNAc transferase 1|pp-GaNTase 1|ppGaNTase-T1|protein-UDP acetylgalactosaminyltransferase 1', map_location='18 A2', chromosome='18', genomic_nucleotide_accession_version='NC_000084.6', start_position_on_the_genomic_accession=24205321, end_position_on_the_genomic_accession=24286816, orientation='plus', exon_count=14, OMIM=[], no_hdr0=''),
    14425 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=14425, CurrentID=0, Status='live', Symbol='Galnt3', Aliases=[], description='polypeptide N-acetylgalactosaminyltransferase 3', other_designations='polypeptide N-acetylgalactosaminyltransferase 3|UDP-GalNAc:polypeptide N-acetylgalactosaminyltransferase 3|UDP-N-acetyl-alpha-D-galactosamine:polypeptide N-acetylgalactosaminyltransferase 3|galNAc-T3|polypeptide GalNAc transferase 3|pp-GaNTase 3|ppGaNTase-T3|protein-UDP acetylgalactosaminyltransferase 3', map_location='2 C1.3', chromosome='2', genomic_nucleotide_accession_version='NC_000068.7', start_position_on_the_genomic_accession=66082766, end_position_on_the_genomic_accession=66125056, orientation='minus', exon_count=11, OMIM=[], no_hdr0=''),
    14426 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=14426, CurrentID=0, Status='live', Symbol='Galnt4', Aliases=['AV011803'], description='polypeptide N-acetylgalactosaminyltransferase 4', other_designations='polypeptide N-acetylgalactosaminyltransferase 4|UDP-GalNAc:polypeptide N-acetylgalactosaminyltransferase 4|UDP-N-acetyl-alpha-D-galactosamine:polypeptide N-acetylgalactosaminyltransferase 4|galNAc-T4|polypeptide GalNAc transferase 4|pp-GaNTase 4|ppGaNTase-T4|protein-UDP acetylgalactosaminyltransferase 4', map_location='10 C3', chromosome='10', genomic_nucleotide_accession_version='NC_000076.6', start_position_on_the_genomic_accession=99108135, end_position_on_the_genomic_accession=99113247, orientation='plus', exon_count=1, OMIM=[], no_hdr0=''),
    14427 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=14427, CurrentID=0, Status='live', Symbol='Galr1', Aliases=['Ga', 'Galnr1'], description='galanin receptor 1', other_designations='galanin receptor type 1|GAL1-R|GALR-1', map_location='18 55.78 cM', chromosome='18', genomic_nucleotide_accession_version='NC_000084.6', start_position_on_the_genomic_accession=82392496, end_position_on_the_genomic_accession=82406777, orientation='minus', exon_count=3, OMIM=[], no_hdr0=''),
    14428 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=14428, CurrentID=0, Status='live', Symbol='Galr2', Aliases=['Ga', 'mG', 'mGalR'], description='galanin receptor 2', other_designations='galanin receptor type 2|GAL2-R|GALR-2', map_location='11 81.1 cM', chromosome='11', genomic_nucleotide_accession_version='NC_000077.6', start_position_on_the_genomic_accession=116280106, end_position_on_the_genomic_accession=116283950, orientation='plus', exon_count=3, OMIM=[], no_hdr0=''),
    14429 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=14429, CurrentID=0, Status='live', Symbol='Galr3', Aliases=['Ga', 'Galnr3'], description='galanin receptor 3', other_designations='galanin receptor type 3|GAL3-R|GALR-3', map_location='15 37.7 cM', chromosome='15', genomic_nucleotide_accession_version='NC_000081.6', start_position_on_the_genomic_accession=79041885, end_position_on_the_genomic_accession=79043558, orientation='plus', exon_count=2, OMIM=[], no_hdr0=''),
    14430 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=14430, CurrentID=0, Status='live', Symbol='Galt', Aliases=['AW553376'], description='galactose-1-phosphate uridyl transferase', other_designations='galactose-1-phosphate uridylyltransferase|UDP-glucose--hexose-1-phosphate uridylyltransferase|gal-1-P uridylyltransferase', map_location='4 22.07 cM', chromosome='4', genomic_nucleotide_accession_version='NC_000070.6', start_position_on_the_genomic_accession=41755517, end_position_on_the_genomic_accession=41759243, orientation='plus', exon_count=11, OMIM=[], no_hdr0=''),
    14431 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=14431, CurrentID=0, Status='live', Symbol='Gamt', Aliases=['AA571402', 'Spi', 'Spintz1'], description='guanidinoacetate methyltransferase', other_designations='guanidinoacetate N-methyltransferase', map_location='10 39.72 cM', chromosome='10', genomic_nucleotide_accession_version='NC_000076.6', start_position_on_the_genomic_accession=80258151, end_position_on_the_genomic_accession=80261025, orientation='minus', exon_count=6, OMIM=[], no_hdr0=''),
    14432 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=14432, CurrentID=0, Status='live', Symbol='Gap43', Aliases=['B-50', 'Ba', 'Basp2', 'GAP-', 'GAP-43'], description='growth associated protein 43', other_designations='neuromodulin|axonal membrane protein GAP-43|brain abundant, membrane attached signal protein 2|calmodulin-binding protein P-57|growth accentuating protein 43', map_location='16 28.37 cM', chromosome='16', genomic_nucleotide_accession_version='NC_000082.6', start_position_on_the_genomic_accession=42248552, end_position_on_the_genomic_accession=42340651, orientation='minus', exon_count=3, OMIM=[], no_hdr0=''),
    14433 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=14433, CurrentID=0, Status='live', Symbol='Gapdh', Aliases=['Ga', 'Gapd'], description='glyceraldehyde-3-phosphate dehydrogenase', other_designations='glyceraldehyde-3-phosphate dehydrogenase|peptidyl-cysteine S-nitrosylase GAPDH', map_location='6 59.32 cM', chromosome='6', genomic_nucleotide_accession_version='NC_000072.6', start_position_on_the_genomic_accession=125161852, end_position_on_the_genomic_accession=125166467, orientation='minus', exon_count=8, OMIM=[], no_hdr0=''),
    14447 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=14447, CurrentID=0, Status='live', Symbol='Gapdhs', Aliases=['Ga', 'Gap', 'Gapd-s', 'Gapds'], description='glyceraldehyde-3-phosphate dehydrogenase, spermatogenic', other_designations='glyceraldehyde-3-phosphate dehydrogenase, testis-specific|GAPDH-2|spermatogenic cell-specific glyceraldehyde 3-phosphate dehydrogenase 2|spermatogenic glyceraldehyde-3-phosphate dehydrogenase', map_location='7 B1', chromosome='7', genomic_nucleotide_accession_version='NC_000073.6', start_position_on_the_genomic_accession=30729779, end_position_on_the_genomic_accession=30744791, orientation='minus', exon_count=14, OMIM=[], no_hdr0=''),
    14450 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=14450, CurrentID=0, Status='live', Symbol='Gart', Aliases=['G', 'Gaps', 'P', 'Prgs'], description='phosphoribosylglycinamide formyltransferase', other_designations='trifunctional purine biosynthetic protein adenosine-3|glycinamide ribonucleotide synthetase|glycinamide ribonucleotide synthetase-aminoimidazole ribonucleotide synthetase-glycinamide ribonucleotide formyltransferase', map_location='16 53.18 cM', chromosome='16', genomic_nucleotide_accession_version='NC_000082.6', start_position_on_the_genomic_accession=91621395, end_position_on_the_genomic_accession=91646972, orientation='minus', exon_count=22, OMIM=[], no_hdr0=''),
    14451 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=14451, CurrentID=0, Status='live', Symbol='Gas1', Aliases=['AW554192', 'Gas', 'Gas-1'], description='growth arrest specific 1', other_designations='growth arrest-specific protein 1', map_location='13 31.92 cM', chromosome='13', genomic_nucleotide_accession_version='NC_000079.6', start_position_on_the_genomic_accession=60174405, end_position_on_the_genomic_accession=60177535, orientation='minus', exon_count=1, OMIM=[], no_hdr0=''),
    14453 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=14453, CurrentID=0, Status='live', Symbol='Gas2', Aliases=['Gas', 'Gas-2'], description='growth arrest specific 2', other_designations='growth arrest-specific protein 2', map_location='7 32.87 cM', chromosome='7', genomic_nucleotide_accession_version='NC_000073.6', start_position_on_the_genomic_accession=51861791, end_position_on_the_genomic_accession=51995005, orientation='plus', exon_count=16, OMIM=[], no_hdr0=''),
    14456 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=14456, CurrentID=0, Status='live', Symbol='Gas6', Aliases=['Gas', 'Gas-6'], description='growth arrest specific 6', other_designations='growth arrest-specific protein 6|AXL receptor tyrosine kinase ligand|GAS 6', map_location='8 6.06 cM', chromosome='8', genomic_nucleotide_accession_version='NC_000074.6', start_position_on_the_genomic_accession=13465374, end_position_on_the_genomic_accession=13494535, orientation='minus', exon_count=15, OMIM=[], no_hdr0=''),
    14457 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=14457, CurrentID=0, Status='live', Symbol='Gas7', Aliases=['AW124766', 'B230343A10Rik-', 'Gas7-cb', 'Gas7'], description='growth arrest specific 7', other_designations='growth arrest-specific protein 7|growth arrest-specific 7 protein', map_location='11 B3', chromosome='11', genomic_nucleotide_accession_version='NC_000077.6', start_position_on_the_genomic_accession=67453257, end_position_on_the_genomic_accession=67688992, orientation='plus', exon_count=22, OMIM=[], no_hdr0=''),
    14459 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=14459, CurrentID=0, Status='live', Symbol='Gast', Aliases=['G', 'GAS'], description='gastrin', other_designations='gastrin', map_location='11 63.46 cM', chromosome='11', genomic_nucleotide_accession_version='NC_000077.6', start_position_on_the_genomic_accession=100334407, end_position_on_the_genomic_accession=100336997, orientation='plus', exon_count=3, OMIM=[], no_hdr0=''),
    14460 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=14460, CurrentID=0, Status='live', Symbol='Gata1', Aliases=['Gata', 'Gata-1', 'Gf-1', 'eryf1'], description='GATA binding protein 1', other_designations='erythroid transcription factor|GATA-binding factor 1|NF-E1 DNA-binding protein', map_location='X 3.59 cM', chromosome='X', genomic_nucleotide_accession_version='NC_000086.7', start_position_on_the_genomic_accession=7959260, end_position_on_the_genomic_accession=7976663, orientation='minus', exon_count=7, OMIM=[], no_hdr0=''),
    14461 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=14461, CurrentID=0, Status='live', Symbol='Gata2', Aliases=['Gata', 'Gata-2'], description='GATA binding protein 2', other_designations='endothelial transcription factor GATA-2', map_location='6 39.2 cM', chromosome='6', genomic_nucleotide_accession_version='NC_000072.6', start_position_on_the_genomic_accession=88193891, end_position_on_the_genomic_accession=88207032, orientation='plus', exon_count=7, OMIM=[], no_hdr0=''),
    14462 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=14462, CurrentID=0, Status='live', Symbol='Gata3', Aliases=['Gata', 'Gata-3', 'j', 'jal'], description='GATA binding protein 3', other_designations='trans-acting T-cell-specific transcription factor GATA-3|GATA-binding factor 3', map_location='2 6.69 cM', chromosome='2', genomic_nucleotide_accession_version='NC_000068.7', start_position_on_the_genomic_accession=9857078, end_position_on_the_genomic_accession=9887953, orientation='minus', exon_count=8, OMIM=[], no_hdr0=''),
    14463 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=14463, CurrentID=0, Status='live', Symbol='Gata4', Aliases=['Gata', 'Gata-4'], description='GATA binding protein 4', other_designations='transcription factor GATA-4|GATA-binding factor 4', map_location='14 33.24 cM', chromosome='14', genomic_nucleotide_accession_version='NC_000080.6', start_position_on_the_genomic_accession=63198914, end_position_on_the_genomic_accession=63271712, orientation='minus', exon_count=9, OMIM=[], no_hdr0=''),
    14464 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=14464, CurrentID=0, Status='live', Symbol='Gata5', Aliases=[], description='GATA binding protein 5', other_designations='transcription factor GATA-5|GATA-binding factor 5|Transcription factor GATA-5 (GATA binding factor-5)', map_location='2 102.85 cM', chromosome='2', genomic_nucleotide_accession_version='NC_000068.7', start_position_on_the_genomic_accession=180325088, end_position_on_the_genomic_accession=180335503, orientation='minus', exon_count=7, OMIM=[], no_hdr0=''),
    14465 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=14465, CurrentID=0, Status='live', Symbol='Gata6', Aliases=['AA410133', 'GATA-6'], description='GATA binding protein 6', other_designations='transcription factor GATA-6|GATA-binding factor 6', map_location='18 5.63 cM', chromosome='18', genomic_nucleotide_accession_version='NC_000084.6', start_position_on_the_genomic_accession=11052510, end_position_on_the_genomic_accession=11085636, orientation='plus', exon_count=8, OMIM=[], no_hdr0=''),
    14466 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=14466, CurrentID=0, Status='live', Symbol='Gba', Aliases=['GBA1', 'GC', 'GCa', 'GCase', 'GLUC', 'betaG', 'betaGC'], description='glucosidase, beta, acid', other_designations='lysosomal acid glucosylceramidase|D-glucosyl-N-acylsphingosine glucohydrolase|SGTase|acid beta glucosidase|beta-glucocerebrosidase|cholesterol glucosyltransferase|cholesteryl-beta-glucosidase|glucocerebrosidase|glucosylceramidase|lysosomal acid GCase', map_location='3 39.01 cM', chromosome='3', genomic_nucleotide_accession_version='NC_000069.6', start_position_on_the_genomic_accession=89202905, end_position_on_the_genomic_accession=89208873, orientation='plus', exon_count=13, OMIM=[], no_hdr0=''),
    14467 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=14467, CurrentID=0, Status='live', Symbol='Nipsnap2', Aliases=['AV006093', 'Gb', 'Gbas', 'N'], description='nipsnap homolog 2', other_designations='protein NipSnap homolog 2|glioblastoma amplified sequence', map_location='5 G1.3', chromosome='5', genomic_nucleotide_accession_version='NC_000071.6', start_position_on_the_genomic_accession=129725016, end_position_on_the_genomic_accession=129758327, orientation='plus', exon_count=11, OMIM=[], no_hdr0=''),
    14468 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=14468, CurrentID=0, Status='live', Symbol='Gbp2b', Aliases=['Gbp', 'Gbp-', 'Gbp-1', 'Gbp1', 'Mag-', 'Mag-1', 'Mp', 'Mpa', 'Mpa-1', 'Mpa1'], description='guanylate binding protein 2b', other_designations='guanylate-binding protein 1|GTP-binding protein 1|guanylate nucleotide binding protein 1|interferon-gamma-inducible protein MAG-1|interferon-induced guanylate-binding protein 1', map_location='3 66.69 cM', chromosome='3', genomic_nucleotide_accession_version='NC_000069.6', start_position_on_the_genomic_accession=142594816, end_position_on_the_genomic_accession=142619179, orientation='plus', exon_count=12, OMIM=[], no_hdr0=''),
    14469 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=14469, CurrentID=0, Status='live', Symbol='Gbp2', Aliases=[], description='guanylate binding protein 2', other_designations='guanylate-binding protein 2|GBP-2|GTP-binding protein 2|guanine nucleotide-binding protein 2|guanylate nucleotide binding protein 2|guanylate-binding protein 1|interferon-induced guanylate-binding protein 2|mGBP-2|mGBP2', map_location='3 66.69 cM', chromosome='3', genomic_nucleotide_accession_version='NC_000069.6', start_position_on_the_genomic_accession=142620663, end_position_on_the_genomic_accession=142638008, orientation='plus', exon_count=11, OMIM=[], no_hdr0=''),
    14470 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=14470, CurrentID=0, Status='live', Symbol='Rabac1', Aliases=['2310040I06Rik', 'Gbp', 'Gbpap1', 'P', 'PRA1', 'pr', 'prenylin'], description='Rab acceptor 1 (prenylated)', other_designations='prenylated Rab acceptor protein 1|GTP binding protein associated protein 1|PRA1 family protein 1', map_location='7 A3', chromosome='7', genomic_nucleotide_accession_version='NC_000073.6', start_position_on_the_genomic_accession=24969750, end_position_on_the_genomic_accession=24972728, orientation='minus', exon_count=5, OMIM=[], no_hdr0=''),
    14472 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=14472, CurrentID=0, Status='live', Symbol='Gbx2', Aliases=['D130058E05Rik', 'Gbx-2', 'MMo', 'MMoxA', 'St', 'Stra7'], description='gastrulation brain homeobox 2', other_designations='homeobox protein GBX-2|gastrulation and brain-specific homeobox protein 2|stimulated by retinoic acid gene 7 protein', map_location='1 45.06 cM', chromosome='1', genomic_nucleotide_accession_version='NC_000067.6', start_position_on_the_genomic_accession=89927962, end_position_on_the_genomic_accession=89931176, orientation='minus', exon_count=2, OMIM=[], no_hdr0=''),
    14473 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=14473, CurrentID=0, Status='live', Symbol='Gc', Aliases=['DB', 'DBP', 'VDB'], description='vitamin D binding protein', other_designations='vitamin D-binding protein|gc-globulin|group specific component', map_location='5 44.32 cM', chromosome='5', genomic_nucleotide_accession_version='NC_000071.6', start_position_on_the_genomic_accession=89417511, end_position_on_the_genomic_accession=89457898, orientation='minus', exon_count=13, OMIM=[], no_hdr0=''),
    14475 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=14475, CurrentID=0, Status='live', Symbol='Gcap10', Aliases=[], description='granule cell antiserum positive 10', other_designations='granule cell antiserum positive 10', map_location='', chromosome='', genomic_nucleotide_accession_version='', start_position_on_the_genomic_accession='', end_position_on_the_genomic_accession='', orientation='', exon_count='', OMIM=[], no_hdr0=''),
    14479 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=14479, CurrentID=0, Status='live', Symbol='Usp15', Aliases=['4921514G19Rik', 'AI327321', 'E430033I05Rik', 'Gcap', 'Gcap18'], description='ubiquitin specific peptidase 15', other_designations='ubiquitin carboxyl-terminal hydrolase 15|deubiquitinating enzyme 15|granule cell antiserum positive 18|ubiquitin thioesterase 15|ubiquitin thiolesterase 15|ubiquitin-specific-processing protease 15', map_location='10 D2', chromosome='10', genomic_nucleotide_accession_version='NC_000076.6', start_position_on_the_genomic_accession=123105006, end_position_on_the_genomic_accession=123197281, orientation='minus', exon_count=25, OMIM=[], no_hdr0=''),
    14489 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=14489, CurrentID=0, Status='live', Symbol='Mtpn', Aliases=['5033418D15Rik', 'Gcd', 'Gcdp', 'V', 'V1'], description='myotrophin', other_designations='myotrophin|granule cell differentiation protein|protein V-1', map_location='6 B1', chromosome='6', genomic_nucleotide_accession_version='NC_000072.6', start_position_on_the_genomic_accession=35508824, end_position_on_the_genomic_accession=35539888, orientation='minus', exon_count=4, OMIM=[], no_hdr0=''),
    14525 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=14525, CurrentID=0, Status='live', Symbol='Gcsam', Aliases=['Gcet', 'Gcet2', 'M17', 'M17-L'], description='germinal center associated, signaling and motility', other_designations='germinal center-associated signaling and motility protein|germinal center B-cell-expressed transcript 2 protein|germinal center expressed transcript 2', map_location='16 B5', chromosome='16', genomic_nucleotide_accession_version='NC_000082.6', start_position_on_the_genomic_accession=45610440, end_position_on_the_genomic_accession=45622867, orientation='plus', exon_count=6, OMIM=[], no_hdr0=''),
    14526 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=14526, CurrentID=0, Status='live', Symbol='Gcg', Aliases=['GLP', 'GLP-1', 'Gl', 'Glu', 'P', 'PPG'], description='glucagon', other_designations='pro-glucagon|glucagon-like peptide I', map_location='2 35.85 cM', chromosome='2', genomic_nucleotide_accession_version='NC_000068.7', start_position_on_the_genomic_accession=62474530, end_position_on_the_genomic_accession=62483653, orientation='minus', exon_count=6, OMIM=[], no_hdr0=''),
    14527 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=14527, CurrentID=0, Status='live', Symbol='Gcgr', Aliases=['G', 'GR'], description='glucagon receptor', other_designations='glucagon receptor|GL-R', map_location='11 E2', chromosome='11', genomic_nucleotide_accession_version='NC_000077.6', start_position_on_the_genomic_accession=120529185, end_position_on_the_genomic_accession=120538989, orientation='plus', exon_count=17, OMIM=[], no_hdr0=''),
    14528 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=14528, CurrentID=0, Status='live', Symbol='Gch1', Aliases=['GTP-C', 'GTP-CH', 'GTP-CH-I', 'GTPC', 'GTPCH', 'Gch'], description='GTP cyclohydrolase 1', other_designations='GTP cyclohydrolase 1|GTP cyclohydrolase I', map_location='14 24.6 cM', chromosome='14', genomic_nucleotide_accession_version='NC_000080.6', start_position_on_the_genomic_accession=47153895, end_position_on_the_genomic_accession=47189413, orientation='minus', exon_count=6, OMIM=[], no_hdr0=''),
    14531 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=14531, CurrentID=0, Status='live', Symbol='Gcm1', Aliases=['GCM', 'GCMa', 'Gcm-rs2-r', 'Gcm1-rs1', 'gli', 'glide', 'Gcm1'], description='glial cells missing homolog 1', other_designations='chorion-specific transcription factor GCMa|GCM motif protein 1|Gcm 1|Gcm a|glial cell deficient|mGCM1|mGCMa', map_location='9 43.49 cM', chromosome='9', genomic_nucleotide_accession_version='NC_000075.6', start_position_on_the_genomic_accession=78051958, end_position_on_the_genomic_accession=78065624, orientation='plus', exon_count=6, OMIM=[], no_hdr0=''),
    14533 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=14533, CurrentID=0, Status='live', Symbol='Bloc1s1', Aliases=['AI839753', 'BL', 'BLOS1', 'Gcn5', 'Gcn5l1'], description='biogenesis of lysosomal organelles complex-1, subunit 1', other_designations='biogenesis of lysosome-related organelles complex 1 subunit 1|BLOC-1 subunit 1|GCN5 general control of amino acid synthesis-like 1|GCN5-like protein 1|biogenesis of lysosome-related organelles complex-1, subunit 1|general control of amino acid synthesis, yeast homolog-like 1|general control of amino acid synthesis-like 1', map_location='10 77.19 cM', chromosome='10', genomic_nucleotide_accession_version='NC_000076.6', start_position_on_the_genomic_accession=128919914, end_position_on_the_genomic_accession=128923524, orientation='minus', exon_count=4, OMIM=[], no_hdr0=''),
    14534 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=14534, CurrentID=0, Status='live', Symbol='Kat2a', Aliases=['1110051E14Rik', 'AW212720', 'Gcn', 'Gcn5', 'Gcn5l2', 'PCAF-B/G', 'mmGCN5'], description='K(lysine) acetyltransferase 2A', other_designations='histone acetyltransferase KAT2A|GCN5 general control of amino acid synthesis-like 2|PCAF-B/GCN5|general control of amino acid synthesis 5-like 2|general control of amino acid synthesis protein 5-like 2|general control of amino acid synthesis, yeast homolog-like 2|general control of amino acid synthesis-like 2|histone acetyltransferase GCN5|histone glutaryltransferase KAT2A|histone succinyltransferase KAT2A|lysine acetyltransferase 2A', map_location='11 63.53 cM', chromosome='11', genomic_nucleotide_accession_version='NC_000077.6', start_position_on_the_genomic_accession=100704746, end_position_on_the_genomic_accession=100712485, orientation='minus', exon_count=18, OMIM=[], no_hdr0=''),
    14536 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=14536, CurrentID=0, Status='live', Symbol='Nr6a1', Aliases=['1700113M01Rik', 'Gcn', 'Gcnf', 'NC', 'NCNF', 'RTR'], description='nuclear receptor subfamily 6, group A, member 1', other_designations='nuclear receptor subfamily 6 group A member 1|germ cell nuclear factor|mGCNF|retinoid receptor-related testis-specific receptor', map_location='2 B', chromosome='2', genomic_nucleotide_accession_version='NC_000068.7', start_position_on_the_genomic_accession=38723369, end_position_on_the_genomic_accession=38926461, orientation='minus', exon_count=12, OMIM=[], no_hdr0=''),
    14537 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=14537, CurrentID=0, Status='live', Symbol='Gcnt1', Aliases=['5630400D21Rik', 'B130048E03', 'C2 GlcNAcT', 'C2GNT', 'IG', 'IGnT'], description='glucosaminyl (N-acetyl) transferase 1, core 2', other_designations='beta-1,3-galactosyl-O-glycosyl-glycoprotein beta-1,6-N-acetylglucosaminyltransferase|beta-1,3-galactosyl-O-glycosyl-glycoprotein beta-1,6-N-acetylglucosaminyltransferase (Core 2 branching enzyme) (Core2-GlcNAc-transferase) (C2GNT)|core 2-branching enzyme|core2-GlcNAc-transferase', map_location='19 12.75 cM', chromosome='19', genomic_nucleotide_accession_version='NC_000085.6', start_position_on_the_genomic_accession=17326141, end_position_on_the_genomic_accession=17372844, orientation='minus', exon_count=8, OMIM=[], no_hdr0=''),
    14538 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=14538, CurrentID=0, Status='live', Symbol='Gcnt2', Aliases=['5330430K10Rik', 'IG', 'IGn', 'IGnT', 'IGnTA', 'IGnTB', 'IGnTC'], description='glucosaminyl (N-acetyl) transferase 2, I-branching enzyme', other_designations='N-acetyllactosaminide beta-1,6-N-acetylglucosaminyl-transferase|I-branching enzyme|N-acetylglucosaminyltransferase|beta-1,6-N-acetylglucosaminyltransferase|glucosaminyltransferase, I-branching enzyme|large I antigen-forming beta-1,6-N-acetylglucosaminyltransferase', map_location='13 20.12 cM', chromosome='13', genomic_nucleotide_accession_version='NC_000079.6', start_position_on_the_genomic_accession=40859768, end_position_on_the_genomic_accession=40960892, orientation='plus', exon_count=6, OMIM=[], no_hdr0=''),
    14539 : ntncbi(tax_id=10090, Org_name='Mus musculus', GeneID=14539, CurrentID=0, Status='live', Symbol='Opn1mw', Aliases=['Gc', 'Gcp', 'ML', 'ML-opsin', 'Op', 'Opn1lw', 'Rsvp'], description='opsin 1 (cone pigments), medium-wave-sensitive (color blindness, deutan)', other_designations='medium-wave-sensitiv