"""Data downloaded from NCBI Gene converted into Python namedtuples."""

from collections import namedtuple

WRITTEN = "2020_09_18" # 19880 items

#pylint: disable=line-too-long,too-many-lines,invalid-name
ntncbi = namedtuple('ntncbi', 'tax_id Org_name GeneID CurrentID Status Symbol Aliases description other_designations map_location chromosome genomic_nucleotide_accession_version start_position_on_the_genomic_accession end_position_on_the_genomic_accession orientation exon_count OMIM no_hdr0')

GENEID2NT = { # 19,880 items
    1 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1, CurrentID=0, Status='live', Symbol='A1BG', Aliases=['A1B', 'ABG', 'GAB', 'HYST2477'], description='alpha-1-B glycoprotein', other_designations='alpha-1B-glycoprotein|HEL-S-163pA|epididymis secretory sperm binding protein Li 163pA', map_location='19q13.43', chromosome='19', genomic_nucleotide_accession_version='NC_000019.10', start_position_on_the_genomic_accession=58345183, end_position_on_the_genomic_accession=58353492, orientation='minus', exon_count=8, OMIM=[138670], no_hdr0=''),
    2 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=2, CurrentID=0, Status='live', Symbol='A2M', Aliases=['A2MD', 'CPAMD5', 'FWP007', 'S863-7'], description='alpha-2-macroglobulin', other_designations='alpha-2-macroglobulin|C3 and PZP-like alpha-2-macroglobulin domain-containing protein 5|alpha-2-M', map_location='12p13.31', chromosome='12', genomic_nucleotide_accession_version='NC_000012.12', start_position_on_the_genomic_accession=9067708, end_position_on_the_genomic_accession=9116229, orientation='minus', exon_count=37, OMIM=[103950], no_hdr0=''),
    9 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=9, CurrentID=0, Status='live', Symbol='NAT1', Aliases=['AAC1', 'MNAT', 'NAT-1', 'NATI'], description='N-acetyltransferase 1', other_designations='arylamine N-acetyltransferase 1|N-acetyltransferase 1 (arylamine N-acetyltransferase)|N-acetyltransferase type 1|arylamide acetylase 1|monomorphic arylamine N-acetyltransferase', map_location='8p22', chromosome='8', genomic_nucleotide_accession_version='NC_000008.11', start_position_on_the_genomic_accession=18170419, end_position_on_the_genomic_accession=18223689, orientation='plus', exon_count=11, OMIM=[108345], no_hdr0=''),
    10 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=10, CurrentID=0, Status='live', Symbol='NAT2', Aliases=['AAC2', 'NAT-2', 'PNAT'], description='N-acetyltransferase 2', other_designations='arylamine N-acetyltransferase 2|N-acetyltransferase 2 (arylamine N-acetyltransferase)|N-acetyltransferase type 2|arylamide acetylase 2', map_location='8p22', chromosome='8', genomic_nucleotide_accession_version='NC_000008.11', start_position_on_the_genomic_accession=18386585, end_position_on_the_genomic_accession=18401219, orientation='plus', exon_count=3, OMIM=[612182], no_hdr0=''),
    12 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=12, CurrentID=0, Status='live', Symbol='SERPINA3', Aliases=['AACT', 'ACT', 'GIG24', 'GIG25'], description='serpin family A member 3', other_designations='alpha-1-antichymotrypsin|cell growth-inhibiting gene 24/25 protein|growth-inhibiting protein 24|growth-inhibiting protein 25|serine (or cysteine) proteinase inhibitor, clade A, member 3|serpin A3|serpin peptidase inhibitor, clade A (alpha-1 antiproteinase, antitrypsin), member 3', map_location='14q32.13', chromosome='14', genomic_nucleotide_accession_version='NC_000014.9', start_position_on_the_genomic_accession=94612391, end_position_on_the_genomic_accession=94624053, orientation='plus', exon_count=7, OMIM=[107280], no_hdr0=''),
    13 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=13, CurrentID=0, Status='live', Symbol='AADAC', Aliases=['CES5A1', 'DAC'], description='arylacetamide deacetylase', other_designations='arylacetamide deacetylase|arylacetamide deacetylase (esterase)', map_location='3q25.1', chromosome='3', genomic_nucleotide_accession_version='NC_000003.12', start_position_on_the_genomic_accession=151814008, end_position_on_the_genomic_accession=151828488, orientation='plus', exon_count=5, OMIM=[600338], no_hdr0=''),
    14 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=14, CurrentID=0, Status='live', Symbol='AAMP', Aliases=[], description='angio associated migratory cell protein', other_designations='angio-associated migratory cell protein', map_location='2q35', chromosome='2', genomic_nucleotide_accession_version='NC_000002.12', start_position_on_the_genomic_accession=218264127, end_position_on_the_genomic_accession=218270181, orientation='minus', exon_count=10, OMIM=[603488], no_hdr0=''),
    15 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=15, CurrentID=0, Status='live', Symbol='AANAT', Aliases=['DSPS', 'SNAT'], description='aralkylamine N-acetyltransferase', other_designations='serotonin N-acetyltransferase|arylalkylamine N-acetyltransferase|serotonin acetylase', map_location='17q25.1', chromosome='17', genomic_nucleotide_accession_version='NC_000017.11', start_position_on_the_genomic_accession=76453351, end_position_on_the_genomic_accession=76470797, orientation='plus', exon_count=8, OMIM=[600950], no_hdr0=''),
    16 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=16, CurrentID=0, Status='live', Symbol='AARS1', Aliases=['AARS', 'CMT2N', 'EIEE29'], description='alanyl-tRNA synthetase 1', other_designations='alanine--tRNA ligase, cytoplasmic|alaRS|alanine tRNA ligase 1, cytoplasmic|alanyl-tRNA synthetase, cytoplasmic|renal carcinoma antigen NY-REN-42', map_location='16q22.1', chromosome='16', genomic_nucleotide_accession_version='NC_000016.10', start_position_on_the_genomic_accession=70252295, end_position_on_the_genomic_accession=70289509, orientation='minus', exon_count=21, OMIM=[601065], no_hdr0=''),
    18 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=18, CurrentID=0, Status='live', Symbol='ABAT', Aliases=['GABA-AT', 'GABAT', 'NPD009'], description='4-aminobutyrate aminotransferase', other_designations='4-aminobutyrate aminotransferase, mitochondrial|(S)-3-amino-2-methylpropionate transaminase|4-aminobutyrate transaminase|GABA aminotransferase|GABA transaminase|GABA transferase|gamma-amino-N-butyrate transaminase|gamma-aminobutyrate aminotransferase', map_location='16p13.2', chromosome='16', genomic_nucleotide_accession_version='NC_000016.10', start_position_on_the_genomic_accession=8674617, end_position_on_the_genomic_accession=8784575, orientation='plus', exon_count=20, OMIM=[137150], no_hdr0=''),
    19 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=19, CurrentID=0, Status='live', Symbol='ABCA1', Aliases=['ABC-1', 'ABC1', 'CERP', 'HDLCQTL13', 'HDLDT1', 'HPALP1', 'TGD'], description='ATP binding cassette subfamily A member 1', other_designations='phospholipid-transporting ATPase ABCA1|ATP-binding cassette sub-family A member 1|ATP-binding cassette transporter A1|ATP-binding cassette, sub-family A (ABC1), member 1|cholesterol efflux regulatory protein|membrane-bound', map_location='9q31.1', chromosome='9', genomic_nucleotide_accession_version='NC_000009.12', start_position_on_the_genomic_accession=104781006, end_position_on_the_genomic_accession=104928232, orientation='minus', exon_count=58, OMIM=[600046], no_hdr0=''),
    20 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=20, CurrentID=0, Status='live', Symbol='ABCA2', Aliases=['ABC2', 'IDPOGSA'], description='ATP binding cassette subfamily A member 2', other_designations='ATP-binding cassette sub-family A member 2|ATP-binding cassette 2|ATP-binding cassette transporter 2|ATP-binding cassette, sub-family A (ABC1), member 2|ATP-binding cassette, sub-family A, member 2', map_location='9q34.3', chromosome='9', genomic_nucleotide_accession_version='NC_000009.12', start_position_on_the_genomic_accession=137007234, end_position_on_the_genomic_accession=137028922, orientation='minus', exon_count=49, OMIM=[600047], no_hdr0=''),
    21 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=21, CurrentID=0, Status='live', Symbol='ABCA3', Aliases=['ABC-C', 'ABC3', 'EST111653', 'LBM180', 'SMDP3'], description='ATP binding cassette subfamily A member 3', other_designations='ATP-binding cassette sub-family A member 3|ABC transporter 3|ABC-C transporter|ATP-binding cassette transporter 3|ATP-binding cassette, sub-family A (ABC1), member 3', map_location='16p13.3', chromosome='16', genomic_nucleotide_accession_version='NC_000016.10', start_position_on_the_genomic_accession=2275881, end_position_on_the_genomic_accession=2340728, orientation='minus', exon_count=33, OMIM=[601615], no_hdr0=''),
    22 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=22, CurrentID=0, Status='live', Symbol='ABCB7', Aliases=['ABC7', 'ASAT', 'Atm1p', 'EST140535'], description='ATP binding cassette subfamily B member 7', other_designations='ATP-binding cassette sub-family B member 7, mitochondrial|ABC transporter 7 protein|ATP-binding cassette transporter 7|ATP-binding cassette, sub-family B (MDR/TAP), member 7', map_location='Xq13.3', chromosome='X', genomic_nucleotide_accession_version='NC_000023.11', start_position_on_the_genomic_accession=75051048, end_position_on_the_genomic_accession=75156283, orientation='minus', exon_count=16, OMIM=[300135], no_hdr0=''),
    23 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=23, CurrentID=0, Status='live', Symbol='ABCF1', Aliases=['ABC27', 'ABC50'], description='ATP binding cassette subfamily F member 1', other_designations='ATP-binding cassette sub-family F member 1|ATP-binding cassette 50 (TNF-alpha stimulated)|ATP-binding cassette, sub-family F (GCN20), member 1|TNF-alpha-stimulated ABC protein|TNFalpha-inducible ATP-binding protein', map_location='6p21.33', chromosome='6', genomic_nucleotide_accession_version='NC_000006.12', start_position_on_the_genomic_accession=30571442, end_position_on_the_genomic_accession=30591522, orientation='plus', exon_count=25, OMIM=[603429], no_hdr0=''),
    24 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=24, CurrentID=0, Status='live', Symbol='ABCA4', Aliases=['ABC10', 'ABCR', 'ARMD2', 'CORD3', 'FFM', 'RMP', 'RP19', 'STGD', 'STGD1'], description='ATP binding cassette subfamily A member 4', other_designations='retinal-specific phospholipid-transporting ATPase ABCA4|ATP binding cassette transporter|ATP-binding cassette sub-family A member 4|ATP-binding cassette transporter, retinal-specific|ATP-binding cassette, sub-family A (ABC1), member 4|ATP-binding transporter, retina-specific|RIM ABC transporter|RIM protein|photoreceptor rim protein|retina-specific ABC transporter|retinal-specific ATP-binding cassette transporter|stargardt disease protein', map_location='1p22.1', chromosome='1', genomic_nucleotide_accession_version='NC_000001.11', start_position_on_the_genomic_accession=93992834, end_position_on_the_genomic_accession=94121148, orientation='minus', exon_count=50, OMIM=[601691], no_hdr0=''),
    25 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=25, CurrentID=0, Status='live', Symbol='ABL1', Aliases=['ABL', 'BCR-ABL', 'CHDSKM', 'JTK7', 'bcr/abl', 'c-ABL', 'c-ABL1', 'p150', 'v-abl'], description='ABL proto-oncogene 1, non-receptor tyrosine kinase', other_designations='tyrosine-protein kinase ABL1|ABL protooncogene 1 nonreceptor tyrosine kinase|Abelson tyrosine-protein kinase 1|bcr/c-abl oncogene protein|c-abl oncogene 1, receptor tyrosine kinase|proto-oncogene c-Abl|proto-oncogene tyrosine-protein kinase ABL1|truncated ABL protooncogene 1 nonreceptor tyrosine kinase|v-abl Abelson murine leukemia viral oncogene homolog 1', map_location='9q34.12', chromosome='9', genomic_nucleotide_accession_version='NC_000009.12', start_position_on_the_genomic_accession=130713881, end_position_on_the_genomic_accession=130887675, orientation='plus', exon_count=12, OMIM=[189980], no_hdr0=''),
    26 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=26, CurrentID=0, Status='live', Symbol='AOC1', Aliases=['ABP', 'ABP1', 'DAO', 'DAO1', 'KAO'], description='amine oxidase copper containing 1', other_designations='amiloride-sensitive amine oxidase [copper-containing]|amiloride binding protein 1 (amine oxidase (copper-containing))|amiloride-binding protein 1|amiloride-sensitive amine oxidase|amine oxidase copper domain-containing protein 1|diamine oxidase|histaminase|kidney amine oxidase', map_location='7q36.1', chromosome='7', genomic_nucleotide_accession_version='NC_000007.14', start_position_on_the_genomic_accession=150824875, end_position_on_the_genomic_accession=150861504, orientation='plus', exon_count=10, OMIM=[104610], no_hdr0=''),
    27 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=27, CurrentID=0, Status='live', Symbol='ABL2', Aliases=['ABLL', 'ARG'], description='ABL proto-oncogene 2, non-receptor tyrosine kinase', other_designations='tyrosine-protein kinase ABL2|Abelson tyrosine-protein kinase 2|abelson-related gene protein|c-abl oncogene 2, non-receptor tyrosine kinase|tyrosine-protein kinase ARG|v-abl Abelson murine leukemia viral oncogene homolog 2', map_location='1q25.2', chromosome='1', genomic_nucleotide_accession_version='NC_000001.11', start_position_on_the_genomic_accession=179099330, end_position_on_the_genomic_accession=179229693, orientation='minus', exon_count=16, OMIM=[164690], no_hdr0=''),
    28 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=28, CurrentID=0, Status='live', Symbol='ABO', Aliases=['A3GALNT', 'A3GALT1', 'GTB', 'NAGAT'], description='ABO, alpha 1-3-N-acetylgalactosaminyltransferase and alpha 1-3-galactosyltransferase', other_designations='histo-blood group ABO system transferase|ABO blood group (transferase A, alpha 1-3-N-acetylgalactosaminyltransferase; transferase B, alpha 1-3-galactosyltransferase)|B(A) alpha-1,3-galactosyltransferase|histo-blood group A2 transferase', map_location='9q34.2', chromosome='9', genomic_nucleotide_accession_version='NC_000009.12', start_position_on_the_genomic_accession=133250401, end_position_on_the_genomic_accession=133275201, orientation='minus', exon_count=7, OMIM=[110300], no_hdr0=''),
    29 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=29, CurrentID=0, Status='live', Symbol='ABR', Aliases=['MDB'], description='ABR activator of RhoGEF and GTPase', other_designations='active breakpoint cluster region-related protein|ABR, RhoGEF and GTPase activating protein|active BCR-related', map_location='17p13.3', chromosome='17', genomic_nucleotide_accession_version='NC_000017.11', start_position_on_the_genomic_accession=1003519, end_position_on_the_genomic_accession=1229722, orientation='minus', exon_count=36, OMIM=[600365], no_hdr0=''),
    30 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=30, CurrentID=0, Status='live', Symbol='ACAA1', Aliases=['ACAA', 'PTHIO', 'THIO'], description='acetyl-CoA acyltransferase 1', other_designations='3-ketoacyl-CoA thiolase, peroxisomal|acetyl-Coenzyme A acyltransferase 1|beta-ketothiolase|epididymis secretory sperm binding protein|peroxisomal 3-oxoacyl-CoA thiolase|peroxisomal 3-oxoacyl-Coenzyme A thiolase|testicular tissue protein Li 197', map_location='3p22.2', chromosome='3', genomic_nucleotide_accession_version='NC_000003.12', start_position_on_the_genomic_accession=38122710, end_position_on_the_genomic_accession=38137127, orientation='minus', exon_count=12, OMIM=[604054], no_hdr0=''),
    31 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=31, CurrentID=0, Status='live', Symbol='ACACA', Aliases=['ACACD', 'ACC', 'ACC1', 'ACCA', 'ACACA'], description='acetyl-CoA carboxylase alpha', other_designations='acetyl-CoA carboxylase 1|ACC-alpha|acetyl-Coenzyme A carboxylase alpha', map_location='17q12', chromosome='17', genomic_nucleotide_accession_version='NC_000017.11', start_position_on_the_genomic_accession=37084992, end_position_on_the_genomic_accession=37406836, orientation='minus', exon_count=63, OMIM=[200350], no_hdr0=''),
    32 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=32, CurrentID=0, Status='live', Symbol='ACACB', Aliases=['ACC2', 'ACCB', 'HACC275'], description='acetyl-CoA carboxylase beta', other_designations='acetyl-CoA carboxylase 2|ACC-beta|acetyl-Coenzyme A carboxylase beta', map_location='12q24.11', chromosome='12', genomic_nucleotide_accession_version='NC_000012.12', start_position_on_the_genomic_accession=109112666, end_position_on_the_genomic_accession=109268226, orientation='plus', exon_count=56, OMIM=[601557], no_hdr0=''),
    33 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=33, CurrentID=0, Status='live', Symbol='ACADL', Aliases=['ACAD4', 'LCAD'], description='acyl-CoA dehydrogenase long chain', other_designations='long-chain specific acyl-CoA dehydrogenase, mitochondrial|acyl-Coenzyme A dehydrogenase, long chain', map_location='2q34', chromosome='2', genomic_nucleotide_accession_version='NC_000002.12', start_position_on_the_genomic_accession=210187923, end_position_on_the_genomic_accession=210225447, orientation='minus', exon_count=12, OMIM=[609576], no_hdr0=''),
    34 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=34, CurrentID=0, Status='live', Symbol='ACADM', Aliases=['ACAD1', 'MCAD', 'MCADH'], description='acyl-CoA dehydrogenase medium chain', other_designations='medium-chain specific acyl-CoA dehydrogenase, mitochondrial|acyl-CoA dehydrogenase, C-4 to C-12 straight chain|acyl-Coenzyme A dehydrogenase, C-4 to C-12 straight chain|medium-chain acyl-CoA dehydrogenase|testicular tissue protein Li 7', map_location='1p31.1', chromosome='1', genomic_nucleotide_accession_version='NC_000001.11', start_position_on_the_genomic_accession=75724709, end_position_on_the_genomic_accession=75763679, orientation='plus', exon_count=13, OMIM=[607008], no_hdr0=''),
    35 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=35, CurrentID=0, Status='live', Symbol='ACADS', Aliases=['ACAD3', 'SCAD'], description='acyl-CoA dehydrogenase short chain', other_designations='short-chain specific acyl-CoA dehydrogenase, mitochondrial|acyl-CoA dehydrogenase, C-2 to C-3 short chain|acyl-Coenzyme A dehydrogenase, C-2 to C-3 short chain|butyryl-CoA dehydrogenase|epididymis secretory sperm binding protein|mitochondrial short-chain specific acyl-CoA dehydrogenase|unsaturated acyl-CoA reductase', map_location='12q24.31', chromosome='12', genomic_nucleotide_accession_version='NC_000012.12', start_position_on_the_genomic_accession=120725826, end_position_on_the_genomic_accession=120740008, orientation='plus', exon_count=11, OMIM=[606885], no_hdr0=''),
    36 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=36, CurrentID=0, Status='live', Symbol='ACADSB', Aliases=['2-MEBCAD', 'ACAD7', 'SBCAD'], description='acyl-CoA dehydrogenase short/branched chain', other_designations='short/branched chain specific acyl-CoA dehydrogenase, mitochondrial|2-methyl branched chain acyl-CoA dehydrogenase|2-methylbutyryl-coenzyme A dehydrogenase|acyl-Coenzyme A dehydrogenase, short/branched chain', map_location='10q26.13', chromosome='10', genomic_nucleotide_accession_version='NC_000010.11', start_position_on_the_genomic_accession=123009006, end_position_on_the_genomic_accession=123058290, orientation='plus', exon_count=11, OMIM=[600301], no_hdr0=''),
    37 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=37, CurrentID=0, Status='live', Symbol='ACADVL', Aliases=['ACAD6', 'LCACD', 'VLCAD'], description='acyl-CoA dehydrogenase very long chain', other_designations='very long-chain specific acyl-CoA dehydrogenase, mitochondrial|acyl-Coenzyme A dehydrogenase, very long chain', map_location='17p13.1', chromosome='17', genomic_nucleotide_accession_version='NC_000017.11', start_position_on_the_genomic_accession=7217125, end_position_on_the_genomic_accession=7225266, orientation='plus', exon_count=22, OMIM=[609575], no_hdr0=''),
    38 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=38, CurrentID=0, Status='live', Symbol='ACAT1', Aliases=['ACAT', 'MAT', 'T2', 'THIL'], description='acetyl-CoA acetyltransferase 1', other_designations='acetyl-CoA acetyltransferase, mitochondrial|acetoacetyl Coenzyme A thiolase|acetoacetyl-CoA thiolase|acetyl-Coenzyme A acetyltransferase 1|mitochondrial acetoacetyl-CoA thiolase|testicular tissue protein Li 198', map_location='11q22.3', chromosome='11', genomic_nucleotide_accession_version='NC_000011.10', start_position_on_the_genomic_accession=108116705, end_position_on_the_genomic_accession=108148822, orientation='plus', exon_count=17, OMIM=[607809], no_hdr0=''),
    39 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=39, CurrentID=0, Status='live', Symbol='ACAT2', Aliases=[], description='acetyl-CoA acetyltransferase 2', other_designations='acetyl-CoA acetyltransferase, cytosolic|acetoacetyl Coenzyme A thiolase|acetyl-CoA transferase-like protein|cytosolic acetoacetyl-CoA thiolase', map_location='6q25.3', chromosome='6', genomic_nucleotide_accession_version='NC_000006.12', start_position_on_the_genomic_accession=159762045, end_position_on_the_genomic_accession=159779112, orientation='plus', exon_count=10, OMIM=[100678], no_hdr0=''),
    40 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=40, CurrentID=0, Status='live', Symbol='ASIC2', Aliases=['ACCN', 'ACCN1a', 'BNC1', 'BNaC1', 'MDEG', 'hBNaC1', 'ASIC2'], description='acid sensing ion channel subunit 2', other_designations='acid-sensing ion channel 2|acid sensing (proton gated) ion channel 2|amiloride-sensitive cation channel 1, neuronal|brain sodium channel 1|mammalian degenerin homolog|neuronal amiloride-sensitive cation channel 1', map_location='17q11.2-q12', chromosome='17', genomic_nucleotide_accession_version='NC_000017.11', start_position_on_the_genomic_accession=33013087, end_position_on_the_genomic_accession=34156768, orientation='minus', exon_count=11, OMIM=[601784], no_hdr0=''),
    41 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=41, CurrentID=0, Status='live', Symbol='ASIC1', Aliases=['ACCN2', 'ASIC', 'BNaC2'], description='acid sensing ion channel subunit 1', other_designations='acid-sensing ion channel 1|Cation channel, amiloride-sensitive, neuronal, 2|acid sensing (proton gated) ion channel 1|acid-sensing ion channel 1a protein|amiloride-sensitive cation channel 2, neuronal|brain sodium channel 2', map_location='12q13.12', chromosome='12', genomic_nucleotide_accession_version='NC_000012.12', start_position_on_the_genomic_accession=50057596, end_position_on_the_genomic_accession=50083622, orientation='plus', exon_count=14, OMIM=[602866], no_hdr0=''),
    43 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=43, CurrentID=0, Status='live', Symbol='ACHE', Aliases=['ACEE', 'ARACHE', 'N-ACHE', 'YT'], description='acetylcholinesterase (Cartwright blood group)', other_designations='acetylcholinesterase|Yt blood group|acetylcholinesterase (Yt blood group)|apoptosis-related acetylcholinesterase', map_location='7q22.1', chromosome='7', genomic_nucleotide_accession_version='NC_000007.14', start_position_on_the_genomic_accession=100889994, end_position_on_the_genomic_accession=100896994, orientation='minus', exon_count=8, OMIM=[100740], no_hdr0=''),
    47 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=47, CurrentID=0, Status='live', Symbol='ACLY', Aliases=['ACL', 'ATPCL', 'CLATP'], description='ATP citrate lyase', other_designations='ATP-citrate synthase|ATP-citrate (pro-S-)-lyase|citrate cleavage enzyme', map_location='17q21.2', chromosome='17', genomic_nucleotide_accession_version='NC_000017.11', start_position_on_the_genomic_accession=41866916, end_position_on_the_genomic_accession=41930542, orientation='minus', exon_count=30, OMIM=[108728], no_hdr0=''),
    48 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=48, CurrentID=0, Status='live', Symbol='ACO1', Aliases=['ACONS', 'HEL60', 'IREB1', 'IREBP', 'IREBP1', 'IRP1'], description='aconitase 1', other_designations='cytoplasmic aconitate hydratase|aconitase 1, soluble|aconitate hydratase, cytoplasmic|citrate hydro-lyase|cytoplasmic aconitase|cytosplasmic aconitase|epididymis luminal protein 60|epididymis secretory sperm binding protein|ferritin repressor protein|iron regulatory protein 1|iron-responsive element-binding protein 1|soluble aconitase', map_location='9p21.1', chromosome='9', genomic_nucleotide_accession_version='NC_000009.12', start_position_on_the_genomic_accession=32384643, end_position_on_the_genomic_accession=32454769, orientation='plus', exon_count=23, OMIM=[100880], no_hdr0=''),
    49 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=49, CurrentID=0, Status='live', Symbol='ACR', Aliases=[], description='acrosin', other_designations='acrosin|acrosin light and heavy chain prepropeptide|preproacrosin|proacrosin', map_location='22q13.33', chromosome='22', genomic_nucleotide_accession_version='NC_000022.11', start_position_on_the_genomic_accession=50738204, end_position_on_the_genomic_accession=50745339, orientation='plus', exon_count=5, OMIM=[102480], no_hdr0=''),
    50 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=50, CurrentID=0, Status='live', Symbol='ACO2', Aliases=['ACONM', 'HEL-S-284', 'ICRD', 'OCA8', 'OPA9'], description='aconitase 2', other_designations='aconitate hydratase, mitochondrial|aconitase 2, mitochondrial|citrate hydro-lyase|epididymis secretory sperm binding protein Li 284|mitochondrial aconitase', map_location='22q13.2', chromosome='22', genomic_nucleotide_accession_version='NC_000022.11', start_position_on_the_genomic_accession=41468756, end_position_on_the_genomic_accession=41528979, orientation='plus', exon_count=19, OMIM=[100850], no_hdr0=''),
    51 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=51, CurrentID=0, Status='live', Symbol='ACOX1', Aliases=['ACOX', 'MITCH', 'PALMCOX', 'SCOX'], description='acyl-CoA oxidase 1', other_designations='peroxisomal acyl-coenzyme A oxidase 1|AOX|acyl-CoA oxidase 1, palmitoyl|acyl-CoA oxidase, straight-chain|acyl-Coenzyme A oxidase 1, palmitoyl|palmitoyl-CoA oxidase|peroxisomal fatty acyl-CoA oxidase|straight-chain acyl-CoA oxidase', map_location='17q25.1', chromosome='17', genomic_nucleotide_accession_version='NC_000017.11', start_position_on_the_genomic_accession=75941507, end_position_on_the_genomic_accession=75979199, orientation='minus', exon_count=15, OMIM=[609751], no_hdr0=''),
    52 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=52, CurrentID=0, Status='live', Symbol='ACP1', Aliases=['HAAP', 'LMW-PTP', 'LMWPTP'], description='acid phosphatase 1', other_designations='low molecular weight phosphotyrosine protein phosphatase|LMW-PTPase|acid phosphatase 1, soluble|acid phosphatase of erythrocyte|adipocyte acid phosphatase|cytoplasmic phosphotyrosyl protein phosphatase|low molecular weight cytosolic acid phosphatase|protein tyrosine phosphatase|red cell acid phosphatase 1|testicular secretory protein Li 37', map_location='2p25.3', chromosome='2', genomic_nucleotide_accession_version='NC_000002.12', start_position_on_the_genomic_accession=264947, end_position_on_the_genomic_accession=278283, orientation='plus', exon_count=7, OMIM=[171500], no_hdr0=''),
    53 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=53, CurrentID=0, Status='live', Symbol='ACP2', Aliases=['LAP'], description='acid phosphatase 2, lysosomal', other_designations='lysosomal acid phosphatase', map_location='11p12-p11', chromosome='11', genomic_nucleotide_accession_version='NC_000011.10', start_position_on_the_genomic_accession=47239302, end_position_on_the_genomic_accession=47248814, orientation='minus', exon_count=12, OMIM=[171650], no_hdr0=''),
    54 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=54, CurrentID=0, Status='live', Symbol='ACP5', Aliases=['HPAP', 'TRACP5a', 'TRACP5b', 'TRAP', 'TrATPase'], description='acid phosphatase 5, tartrate resistant', other_designations='tartrate-resistant acid phosphatase type 5|human purple acid phosphatase|tartrate-resistant acid ATPase|tartrate-resistant acid phosphatase 5a|tartrate-resistant acid phosphatase 5b', map_location='19p13.2', chromosome='19', genomic_nucleotide_accession_version='NC_000019.10', start_position_on_the_genomic_accession=11574660, end_position_on_the_genomic_accession=11578983, orientation='minus', exon_count=8, OMIM=[171640], no_hdr0=''),
    55 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=55, CurrentID=0, Status='live', Symbol='ACP3', Aliases=["5'-NT", 'ACP-3', 'ACPP', 'TM-PAP'], description='acid phosphatase 3', other_designations="prostatic acid phosphatase|TMPase|acid phosphatase, prostate|ecto-5'-nucleotidase|prostatic acid phosphotase|thiamine monophosphatase", map_location='3q22.1', chromosome='3', genomic_nucleotide_accession_version='NC_000003.12', start_position_on_the_genomic_accession=132317403, end_position_on_the_genomic_accession=132368765, orientation='plus', exon_count=12, OMIM=[171790], no_hdr0=''),
    56 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=56, CurrentID=0, Status='live', Symbol='ACRV1', Aliases=['D11S4365', 'SP-10', 'SPACA2'], description='acrosomal vesicle protein 1', other_designations='acrosomal protein SP-10|sperm protein 10', map_location='11q24.2', chromosome='11', genomic_nucleotide_accession_version='NC_000011.10', start_position_on_the_genomic_accession=125671522, end_position_on_the_genomic_accession=125680847, orientation='minus', exon_count=5, OMIM=[102525], no_hdr0=''),
    58 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=58, CurrentID=0, Status='live', Symbol='ACTA1', Aliases=['ACTA', 'ASMA', 'CFTD', 'CFTD1', 'CFTDM', 'MPFD', 'NEM1', 'NEM2', 'NEM3', 'SHPM'], description='actin alpha 1, skeletal muscle', other_designations='actin, alpha skeletal muscle|nemaline myopathy type 3', map_location='1q42.13', chromosome='1', genomic_nucleotide_accession_version='NC_000001.11', start_position_on_the_genomic_accession=229431245, end_position_on_the_genomic_accession=229434094, orientation='minus', exon_count=7, OMIM=[102610], no_hdr0=''),
    59 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=59, CurrentID=0, Status='live', Symbol='ACTA2', Aliases=['ACTSA'], description='actin alpha 2, smooth muscle', other_designations='actin, aortic smooth muscle|actin, alpha 2, smooth muscle, aorta|alpha-cardiac actin|cell growth-inhibiting gene 46 protein', map_location='10q23.31', chromosome='10', genomic_nucleotide_accession_version='NC_000010.11', start_position_on_the_genomic_accession=88935074, end_position_on_the_genomic_accession=88991397, orientation='minus', exon_count=10, OMIM=[102620], no_hdr0=''),
    60 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=60, CurrentID=0, Status='live', Symbol='ACTB', Aliases=['BRWS1', 'PS1TP5BP1'], description='actin beta', other_designations='actin, cytoplasmic 1|I(2)-actin|PS1TP5-binding protein 1|beta cytoskeletal actin', map_location='7p22.1', chromosome='7', genomic_nucleotide_accession_version='NC_000007.14', start_position_on_the_genomic_accession=5527148, end_position_on_the_genomic_accession=5530601, orientation='minus', exon_count=6, OMIM=[102630], no_hdr0=''),
    70 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=70, CurrentID=0, Status='live', Symbol='ACTC1', Aliases=['ACTC', 'ASD5', 'CMD1R', 'CMH11', 'LVNC4'], description='actin alpha cardiac muscle 1', other_designations='actin, alpha cardiac muscle 1', map_location='15q14', chromosome='15', genomic_nucleotide_accession_version='NC_000015.10', start_position_on_the_genomic_accession=34790230, end_position_on_the_genomic_accession=34795549, orientation='minus', exon_count=7, OMIM=[102540], no_hdr0=''),
    71 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=71, CurrentID=0, Status='live', Symbol='ACTG1', Aliases=['ACT', 'ACTG', 'DFNA20', 'DFNA26', 'HEL-176'], description='actin gamma 1', other_designations='actin, cytoplasmic 2|cytoskeletal gamma-actin|epididymis luminal protein 176', map_location='17q25.3', chromosome='17', genomic_nucleotide_accession_version='NC_000017.11', start_position_on_the_genomic_accession=81509971, end_position_on_the_genomic_accession=81512799, orientation='minus', exon_count=7, OMIM=[102560], no_hdr0=''),
    72 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=72, CurrentID=0, Status='live', Symbol='ACTG2', Aliases=['ACT', 'ACTA3', 'ACTE', 'ACTL3', 'ACTSG', 'VSCM'], description='actin gamma 2, smooth muscle', other_designations='actin, gamma-enteric smooth muscle|actin, gamma 2, smooth muscle, enteric|actin-like protein|alpha-actin-3', map_location='2p13.1', chromosome='2', genomic_nucleotide_accession_version='NC_000002.12', start_position_on_the_genomic_accession=73893008, end_position_on_the_genomic_accession=73919865, orientation='plus', exon_count=9, OMIM=[102545], no_hdr0=''),
    81 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=81, CurrentID=0, Status='live', Symbol='ACTN4', Aliases=['ACTININ-4', 'FSGS', 'FSGS1'], description='actinin alpha 4', other_designations='alpha-actinin-4|focal segmental glomerulosclerosis 1|non-muscle alpha-actinin 4', map_location='19q13.2', chromosome='19', genomic_nucleotide_accession_version='NC_000019.10', start_position_on_the_genomic_accession=38647649, end_position_on_the_genomic_accession=38731589, orientation='plus', exon_count=23, OMIM=[604638], no_hdr0=''),
    86 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=86, CurrentID=0, Status='live', Symbol='ACTL6A', Aliases=['ACTL6', 'ARPN-BETA', 'Arp4', 'BAF53A', 'INO80K'], description='actin like 6A', other_designations='actin-like protein 6A|53 kDa BRG1-associated factor A|BAF complex 53 kDa subunit|BAF53|BRG1-associated factor 53A|INO80 complex subunit K|actin-related protein 4|actin-related protein Baf53a|arpNbeta|hArpN beta', map_location='3q26.33', chromosome='3', genomic_nucleotide_accession_version='NC_000003.12', start_position_on_the_genomic_accession=179562926, end_position_on_the_genomic_accession=179588407, orientation='plus', exon_count=14, OMIM=[604958], no_hdr0=''),
    87 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=87, CurrentID=0, Status='live', Symbol='ACTN1', Aliases=['BDPLT15'], description='actinin alpha 1', other_designations='alpha-actinin-1|F-actin cross-linking protein|actinin 1 smooth muscle|epididymis secretory sperm binding protein|non-muscle alpha-actinin-1', map_location='14q22-q24', chromosome='14', genomic_nucleotide_accession_version='NC_000014.9', start_position_on_the_genomic_accession=68874123, end_position_on_the_genomic_accession=68979302, orientation='minus', exon_count=23, OMIM=[102575], no_hdr0=''),
    88 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=88, CurrentID=0, Status='live', Symbol='ACTN2', Aliases=['CMD1AA', 'CMH23', 'MPD6', 'MYOCOZ'], description='actinin alpha 2', other_designations='alpha-actinin-2|F-actin cross-linking protein|alpha-actinin skeletal muscle', map_location='1q43', chromosome='1', genomic_nucleotide_accession_version='NC_000001.11', start_position_on_the_genomic_accession=236686499, end_position_on_the_genomic_accession=236764631, orientation='plus', exon_count=23, OMIM=[102573], no_hdr0=''),
    89 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=89, CurrentID=0, Status='live', Symbol='ACTN3', Aliases=['ACTN3D'], description='actinin alpha 3', other_designations='alpha-actinin-3|F-actin cross-linking protein|alpha-actinin skeletal muscle', map_location='11q13.2', chromosome='11', genomic_nucleotide_accession_version='NC_000011.10', start_position_on_the_genomic_accession=66546395, end_position_on_the_genomic_accession=66563334, orientation='plus', exon_count=22, OMIM=[102574], no_hdr0=''),
    90 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=90, CurrentID=0, Status='live', Symbol='ACVR1', Aliases=['ACTRIA', 'ACVRLK2', 'ALK2', 'FOP', 'SKR1', 'TSRI', 'ACVR1'], description='activin A receptor type 1', other_designations='activin receptor type-1|TGF-B superfamily receptor type I|activin A receptor, type I|activin A receptor, type II-like kinase 2|activin receptor type I|activin receptor-like kinase 2|hydroxyalkyl-protein kinase|serine/threonine-protein kinase receptor R1', map_location='2q24.1', chromosome='2', genomic_nucleotide_accession_version='NC_000002.12', start_position_on_the_genomic_accession=157736446, end_position_on_the_genomic_accession=157876330, orientation='minus', exon_count=16, OMIM=[102576], no_hdr0=''),
    91 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=91, CurrentID=0, Status='live', Symbol='ACVR1B', Aliases=['ACTRIB', 'ACVRLK4', 'ALK4', 'SKR2'], description='activin A receptor type 1B', other_designations='activin receptor type-1B|activin A receptor, type IB|activin A receptor, type II-like kinase 4|activin receptor-like kinase 4|serine/threonine-protein kinase receptor R2', map_location='12q13.13', chromosome='12', genomic_nucleotide_accession_version='NC_000012.12', start_position_on_the_genomic_accession=51951696, end_position_on_the_genomic_accession=51997078, orientation='plus', exon_count=12, OMIM=[601300], no_hdr0=''),
    92 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=92, CurrentID=0, Status='live', Symbol='ACVR2A', Aliases=['ACTRII', 'ACVR2'], description='activin A receptor type 2A', other_designations='activin receptor type-2A|activin A receptor, type IIA', map_location='2q22.3-q23.1', chromosome='2', genomic_nucleotide_accession_version='NC_000002.12', start_position_on_the_genomic_accession=147844517, end_position_on_the_genomic_accession=147930822, orientation='plus', exon_count=12, OMIM=[102581], no_hdr0=''),
    93 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=93, CurrentID=0, Status='live', Symbol='ACVR2B', Aliases=['ACTRIIB', 'ActR-IIB', 'HTX4'], description='activin A receptor type 2B', other_designations='activin receptor type-2B|activin A receptor, type IIB', map_location='3p22.2', chromosome='3', genomic_nucleotide_accession_version='NC_000003.12', start_position_on_the_genomic_accession=38453890, end_position_on_the_genomic_accession=38493142, orientation='plus', exon_count=14, OMIM=[602730], no_hdr0=''),
    94 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=94, CurrentID=0, Status='live', Symbol='ACVRL1', Aliases=['ACVRLK1', 'ALK-1', 'ALK1', 'HHT', 'HHT2', 'ORW2', 'SKR3', 'TSR-I'], description='activin A receptor like type 1', other_designations='serine/threonine-protein kinase receptor R3|TGF-B superfamily receptor type I|activin A receptor type II-like 1|activin A receptor type IL|activin A receptor, type II-like kinase 1', map_location='12q13.13', chromosome='12', genomic_nucleotide_accession_version='NC_000012.12', start_position_on_the_genomic_accession=51906913, end_position_on_the_genomic_accession=51923361, orientation='plus', exon_count=11, OMIM=[601284], no_hdr0=''),
    95 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=95, CurrentID=0, Status='live', Symbol='ACY1', Aliases=['ACY-1D', 'HEL-S-5', 'ACY1'], description='aminoacylase 1', other_designations='aminoacylase-1|N-acyl-L-amino-acid amidohydrolase|acylase|epididymis secretory protein Li 5', map_location='3p21.2', chromosome='3', genomic_nucleotide_accession_version='NC_000003.12', start_position_on_the_genomic_accession=51983535, end_position_on_the_genomic_accession=51989197, orientation='plus', exon_count=15, OMIM=[104620], no_hdr0=''),
    97 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=97, CurrentID=0, Status='live', Symbol='ACYP1', Aliases=['ACYPE'], description='acylphosphatase 1', other_designations='acylphosphatase-1|acylphosphatase 1, erythrocyte (common) type|acylphosphatase, erythrocyte isozyme|acylphosphatase, organ-common type isozyme|acylphosphate phosphohydrolase 1', map_location='14q24.3', chromosome='14', genomic_nucleotide_accession_version='NC_000014.9', start_position_on_the_genomic_accession=75053243, end_position_on_the_genomic_accession=75069490, orientation='minus', exon_count=5, OMIM=[600875], no_hdr0=''),
    98 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=98, CurrentID=0, Status='live', Symbol='ACYP2', Aliases=['ACYM', 'ACYP'], description='acylphosphatase 2', other_designations='acylphosphatase-2|acylphosphatase 2, muscle type|acylphosphatase, muscle type isozyme|acylphosphate phosphohydrolase 2|testicular tissue protein Li 11', map_location='2p16.2', chromosome='2', genomic_nucleotide_accession_version='NC_000002.12', start_position_on_the_genomic_accession=53970838, end_position_on_the_genomic_accession=54305300, orientation='plus', exon_count=16, OMIM=[102595], no_hdr0=''),
    100 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=100, CurrentID=0, Status='live', Symbol='ADA', Aliases=['ADA1'], description='adenosine deaminase', other_designations='adenosine deaminase|adenosine aminohydrolase', map_location='20q13.12', chromosome='20', genomic_nucleotide_accession_version='NC_000020.11', start_position_on_the_genomic_accession=44619522, end_position_on_the_genomic_accession=44651699, orientation='minus', exon_count=12, OMIM=[608958], no_hdr0=''),
    101 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=101, CurrentID=0, Status='live', Symbol='ADAM8', Aliases=['CD156', 'CD156a', 'MS2'], description='ADAM metallopeptidase domain 8', other_designations='disintegrin and metalloproteinase domain-containing protein 8|a disintegrin and metalloproteinase domain 8|cell surface antigen MS2|human leukocyte differentiation antigen', map_location='10q26.3', chromosome='10', genomic_nucleotide_accession_version='NC_000010.11', start_position_on_the_genomic_accession=133262422, end_position_on_the_genomic_accession=133276891, orientation='minus', exon_count=24, OMIM=[602267], no_hdr0=''),
    102 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=102, CurrentID=0, Status='live', Symbol='ADAM10', Aliases=['AD10', 'AD18', 'CD156c', 'CDw156', 'HsT18717', 'MADM', 'RAK', 'kuz'], description='ADAM metallopeptidase domain 10', other_designations='disintegrin and metalloproteinase domain-containing protein 10|a disintegrin and metalloprotease domain 10|kuzbanian protein homolog|mammalian disintegrin-metalloprotease', map_location='15q21.3', chromosome='15', genomic_nucleotide_accession_version='NC_000015.10', start_position_on_the_genomic_accession=58588809, end_position_on_the_genomic_accession=58749707, orientation='minus', exon_count=17, OMIM=[602192], no_hdr0=''),
    103 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=103, CurrentID=0, Status='live', Symbol='ADAR', Aliases=['ADAR1', 'AGS6', 'DRADA', 'DSH', 'DSRAD', 'G1P1', 'IFI-4', 'IFI4', 'K88DSRBP', 'P136'], description='adenosine deaminase RNA specific', other_designations='double-stranded RNA-specific adenosine deaminase|136 kDa double-stranded RNA-binding protein|adenosine deaminase acting on RNA 1-A|dsRNA adenosine deaminase|dsRNA adeonosine deaminase|interferon-induced protein 4|interferon-inducible protein 4', map_location='1q21.3', chromosome='1', genomic_nucleotide_accession_version='NC_000001.11', start_position_on_the_genomic_accession=154582057, end_position_on_the_genomic_accession=154627997, orientation='minus', exon_count=21, OMIM=[146920], no_hdr0=''),
    104 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=104, CurrentID=0, Status='live', Symbol='ADARB1', Aliases=['ADAR2', 'DRABA2', 'DRADA2', 'NEDHYMS', 'RED1'], description='adenosine deaminase RNA specific B1', other_designations='double-stranded RNA-specific editase 1|RNA editing deaminase 1|RNA-editing enzyme 1|adenosine deaminase, RNA-specific, B1 (homolog of rat RED1)|dsRNA adenosine deaminase DRADA2', map_location='21q22.3', chromosome='21', genomic_nucleotide_accession_version='NC_000021.9', start_position_on_the_genomic_accession=45074578, end_position_on_the_genomic_accession=45226563, orientation='plus', exon_count=24, OMIM=[601218], no_hdr0=''),
    105 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=105, CurrentID=0, Status='live', Symbol='ADARB2', Aliases=['ADAR3', 'RED2'], description='adenosine deaminase RNA specific B2 (inactive)', other_designations='double-stranded RNA-specific editase B2|RED2 homolog|RNA-dependent adenosine deaminase 3|RNA-editing deaminase 2|RNA-editing enzyme 2|adenosine deaminase, RNA-specific, B2 (RED1 homolog rat)|adenosine deaminase, RNA-specific, B2 (RED2 homolog rat)|adenosine deaminase, RNA-specific, B2 (non-functional)|dsRNA adenosine deaminase B2|homolog of rat BLUE', map_location='10p15.3', chromosome='10', genomic_nucleotide_accession_version='NC_000010.11', start_position_on_the_genomic_accession=1177313, end_position_on_the_genomic_accession=1737525, orientation='minus', exon_count=10, OMIM=[602065], no_hdr0=''),
    107 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=107, CurrentID=0, Status='live', Symbol='ADCY1', Aliases=['AC1', 'DFNB44'], description='adenylate cyclase 1', other_designations="adenylate cyclase type 1|3',5'-cyclic AMP synthetase|ATP pyrophosphate-lyase 1|Ca(2+)/calmodulin-activated adenylyl cyclase|adenyl cyclase|adenylate cyclase 1 (brain)|adenylate cyclase type I|adenylyl cyclase 1", map_location='7p12.3', chromosome='7', genomic_nucleotide_accession_version='NC_000007.14', start_position_on_the_genomic_accession=45574140, end_position_on_the_genomic_accession=45723116, orientation='plus', exon_count=22, OMIM=[103072], no_hdr0=''),
    108 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=108, CurrentID=0, Status='live', Symbol='ADCY2', Aliases=['AC2', 'HBAC2'], description='adenylate cyclase 2', other_designations="adenylate cyclase type 2|3',5'-cyclic AMP synthetase|ATP pyrophosphate-lyase 2|adenylate cyclase 2 (brain)|adenylate cyclase II|adenylate cyclase type II|adenylyl cyclase 2|type II adenylate cyclase", map_location='5p15.31', chromosome='5', genomic_nucleotide_accession_version='NC_000005.10', start_position_on_the_genomic_accession=7396138, end_position_on_the_genomic_accession=7830081, orientation='plus', exon_count=26, OMIM=[103071], no_hdr0=''),
    109 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=109, CurrentID=0, Status='live', Symbol='ADCY3', Aliases=['AC-III', 'AC3', 'BMIQ19'], description='adenylate cyclase 3', other_designations='adenylate cyclase type 3|ATP pyrophosphate-lyase 3|adenylate cyclase type III|adenylate cyclase, olfactive type|adenylyl cyclase 3|adenylyl cyclase, type III', map_location='2p23.3', chromosome='2', genomic_nucleotide_accession_version='NC_000002.12', start_position_on_the_genomic_accession=24819169, end_position_on_the_genomic_accession=24920237, orientation='minus', exon_count=27, OMIM=[600291], no_hdr0=''),
    111 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=111, CurrentID=0, Status='live', Symbol='ADCY5', Aliases=['AC5', 'FDFM'], description='adenylate cyclase 5', other_designations='adenylate cyclase type 5|ATP pyrophosphate-lyase 5|adenylate cyclase type V|adenylyl cyclase 5|epididymis secretory sperm binding protein', map_location='3q21.1', chromosome='3', genomic_nucleotide_accession_version='NC_000003.12', start_position_on_the_genomic_accession=123282296, end_position_on_the_genomic_accession=123449090, orientation='minus', exon_count=30, OMIM=[600293], no_hdr0=''),
    112 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=112, CurrentID=0, Status='live', Symbol='ADCY6', Aliases=['AC6', 'LCCS8'], description='adenylate cyclase 6', other_designations='adenylate cyclase type 6|ATP pyrophosphate-lyase 6|adenylate cyclase type VI|ca(2+)-inhibitable adenylyl cyclase', map_location='12q13.12', chromosome='12', genomic_nucleotide_accession_version='NC_000012.12', start_position_on_the_genomic_accession=48766194, end_position_on_the_genomic_accession=48789089, orientation='minus', exon_count=23, OMIM=[600294], no_hdr0=''),
    113 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=113, CurrentID=0, Status='live', Symbol='ADCY7', Aliases=['AC7'], description='adenylate cyclase 7', other_designations='adenylate cyclase type 7|ATP pyrophosphate-lyase 7|adenylate cyclase type VII|adenylyl cyclase 7', map_location='16q12.1', chromosome='16', genomic_nucleotide_accession_version='NC_000016.10', start_position_on_the_genomic_accession=50246138, end_position_on_the_genomic_accession=50318135, orientation='plus', exon_count=30, OMIM=[600385], no_hdr0=''),
    114 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=114, CurrentID=0, Status='live', Symbol='ADCY8', Aliases=['AC8', 'ADCY3', 'HBAC1'], description='adenylate cyclase 8', other_designations='adenylate cyclase type 8|ATP pyrophosphate-lyase 8|HEL-S-172mP|adenylate cyclase 8 (brain)|adenylate cyclase type VIII|adenylyl cyclase 8|adenylyl cyclase-8, brain|ca(2+)/calmodulin-activated adenylyl cyclase|epididymis secretory sperm binding protein Li 172mP', map_location='8q24.22', chromosome='8', genomic_nucleotide_accession_version='NC_000008.11', start_position_on_the_genomic_accession=130780300, end_position_on_the_genomic_accession=131041604, orientation='minus', exon_count=19, OMIM=[103070], no_hdr0=''),
    115 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=115, CurrentID=0, Status='live', Symbol='ADCY9', Aliases=['AC9', 'ACIX'], description='adenylate cyclase 9', other_designations='adenylate cyclase type 9|ATP pyrophosphate-lyase 9|adenylate cyclase type IX|adenylyl cyclase 9|type IX ATP pyrophosphate-lyase', map_location='16p13.3', chromosome='16', genomic_nucleotide_accession_version='NC_000016.10', start_position_on_the_genomic_accession=3953387, end_position_on_the_genomic_accession=4116442, orientation='minus', exon_count=12, OMIM=[603302], no_hdr0=''),
    116 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=116, CurrentID=0, Status='live', Symbol='ADCYAP1', Aliases=['PACAP'], description='adenylate cyclase activating polypeptide 1', other_designations='pituitary adenylate cyclase-activating polypeptide|adenylate cyclase activating polypeptide 1 (pituitary)|prepro-PACAP', map_location='18p11.32', chromosome='18', genomic_nucleotide_accession_version='NC_000018.10', start_position_on_the_genomic_accession=904384, end_position_on_the_genomic_accession=912172, orientation='plus', exon_count=6, OMIM=[102980], no_hdr0=''),
    117 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=117, CurrentID=0, Status='live', Symbol='ADCYAP1R1', Aliases=['PAC1', 'PAC1R', 'PACAPR', 'PACAPRI'], description='ADCYAP receptor type I', other_designations='pituitary adenylate cyclase-activating polypeptide type I receptor|PACAP receptor 1|PACAP type I receptor|PACAP-R1|adenylate cyclase activating polypeptide 1 (pituitary) receptor type I|pituitary adenylate cyclase activating polypeptide 1 receptor type I Hiphop|pituitary adenylate cyclase-activating polypeptide type 1 receptor', map_location='7p14.3', chromosome='7', genomic_nucleotide_accession_version='NC_000007.14', start_position_on_the_genomic_accession=31052308, end_position_on_the_genomic_accession=31111474, orientation='plus', exon_count=18, OMIM=[102981], no_hdr0=''),
    118 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=118, CurrentID=0, Status='live', Symbol='ADD1', Aliases=['ADDA'], description='adducin 1', other_designations='alpha-adducin|adducin 1 (alpha)|erythrocyte adducin alpha subunit', map_location='4p16.3', chromosome='4', genomic_nucleotide_accession_version='NC_000004.12', start_position_on_the_genomic_accession=2843844, end_position_on_the_genomic_accession=2930065, orientation='plus', exon_count=19, OMIM=[102680], no_hdr0=''),
    119 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=119, CurrentID=0, Status='live', Symbol='ADD2', Aliases=['ADDB'], description='adducin 2', other_designations='beta-adducin|adducin 2 (beta)|erythrocyte adducin subunit beta', map_location='2p13.3', chromosome='2', genomic_nucleotide_accession_version='NC_000002.12', start_position_on_the_genomic_accession=70656784, end_position_on_the_genomic_accession=70768200, orientation='minus', exon_count=19, OMIM=[102681], no_hdr0=''),
    120 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=120, CurrentID=0, Status='live', Symbol='ADD3', Aliases=['ADDL', 'CPSQ3'], description='adducin 3', other_designations='gamma-adducin|adducin 3 (gamma)|adducin-like protein 70', map_location='10q25.1-q25.2', chromosome='10', genomic_nucleotide_accession_version='NC_000010.11', start_position_on_the_genomic_accession=109996365, end_position_on_the_genomic_accession=110135565, orientation='plus', exon_count=23, OMIM=[601568], no_hdr0=''),
    123 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=123, CurrentID=0, Status='live', Symbol='PLIN2', Aliases=['ADFP', 'ADRP'], description='perilipin 2', other_designations='perilipin-2|adipophilin|adipose differentiation-related protein', map_location='9p22.1', chromosome='9', genomic_nucleotide_accession_version='NC_000009.12', start_position_on_the_genomic_accession=19108391, end_position_on_the_genomic_accession=19127518, orientation='minus', exon_count=9, OMIM=[103195], no_hdr0=''),
    124 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=124, CurrentID=0, Status='live', Symbol='ADH1A', Aliases=['ADH1'], description='alcohol dehydrogenase 1A (class I), alpha polypeptide', other_designations='alcohol dehydrogenase 1A|ADH, alpha subunit|alcohol dehydrogenase 1 (class I), alpha polypeptide|alcohol dehydrogenase subunit alpha|aldehyde reductase', map_location='4q23', chromosome='4', genomic_nucleotide_accession_version='NC_000004.12', start_position_on_the_genomic_accession=99276369, end_position_on_the_genomic_accession=99290985, orientation='minus', exon_count=9, OMIM=[103700], no_hdr0=''),
    125 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=125, CurrentID=0, Status='live', Symbol='ADH1B', Aliases=['ADH2', 'HEL-S-117'], description='alcohol dehydrogenase 1B (class I), beta polypeptide', other_designations='all-trans-retinol dehydrogenase [NAD(+)] ADH1B|ADH, beta subunit|alcohol dehydrogenase 2 (class I), beta polypeptide|alcohol dehydrogenase subunit beta|aldehyde reductase|epididymis secretory protein Li 117', map_location='4q23', chromosome='4', genomic_nucleotide_accession_version='NC_000004.12', start_position_on_the_genomic_accession=99304971, end_position_on_the_genomic_accession=99321401, orientation='minus', exon_count=10, OMIM=[103720], no_hdr0=''),
    126 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=126, CurrentID=0, Status='live', Symbol='ADH1C', Aliases=['ADH3'], description='alcohol dehydrogenase 1C (class I), gamma polypeptide', other_designations='alcohol dehydrogenase 1C|ADH, gamma subunit|alcohol dehydrogenase 3 (class I), gamma polypeptide|aldehyde reductase', map_location='4q23', chromosome='4', genomic_nucleotide_accession_version='NC_000004.12', start_position_on_the_genomic_accession=99336497, end_position_on_the_genomic_accession=99352746, orientation='minus', exon_count=9, OMIM=[103730], no_hdr0=''),
    127 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=127, CurrentID=0, Status='live', Symbol='ADH4', Aliases=['ADH-2', 'HEL-S-4'], description='alcohol dehydrogenase 4 (class II), pi polypeptide', other_designations='all-trans-retinol dehydrogenase [NAD(+)] ADH4|alcohol dehydrogenase class II pi chain|aldehyde reductase|epididymis secretory protein Li 4', map_location='4q23', chromosome='4', genomic_nucleotide_accession_version='NC_000004.12', start_position_on_the_genomic_accession=99123658, end_position_on_the_genomic_accession=99144297, orientation='minus', exon_count=10, OMIM=[103740], no_hdr0=''),
    128 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=128, CurrentID=0, Status='live', Symbol='ADH5', Aliases=['ADH-3', 'ADHX', 'FALDH', 'FDH', 'GSH-FDH', 'GSNOR', 'HEL-S-60p'], description='alcohol dehydrogenase 5 (class III), chi polypeptide', other_designations='alcohol dehydrogenase class-3|S-(hydroxymethyl)glutathione dehydrogenase|S-nitrosoglutathione reductase|alcohol dehydrogenase (class III), chi polypeptide|alcohol dehydrogenase class chi chain|alcohol dehydrogenase class-III|epididymis secretory sperm binding protein Li 60p|formaldehyde dehydrogenase|glutathione-dependent formaldehyde dehydrogenase', map_location='4q23', chromosome='4', genomic_nucleotide_accession_version='NC_000004.12', start_position_on_the_genomic_accession=99070978, end_position_on_the_genomic_accession=99088788, orientation='minus', exon_count=9, OMIM=[103710], no_hdr0=''),
    130 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=130, CurrentID=0, Status='live', Symbol='ADH6', Aliases=['ADH-5'], description='alcohol dehydrogenase 6 (class V)', other_designations='alcohol dehydrogenase 6|aldehyde reductase', map_location='4q23', chromosome='4', genomic_nucleotide_accession_version='NC_000004.12', start_position_on_the_genomic_accession=99202639, end_position_on_the_genomic_accession=99219246, orientation='minus', exon_count=9, OMIM=[103735], no_hdr0=''),
    131 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=131, CurrentID=0, Status='live', Symbol='ADH7', Aliases=['ADH4'], description='alcohol dehydrogenase 7 (class IV), mu or sigma polypeptide', other_designations='all-trans-retinol dehydrogenase [NAD(+)] ADH7|alcohol dehydrogenase VII|alcohol dehydrogenase class 4 mu/sigma chain|alcohol dehydrogenase class IV mu/sigma chain|alcohol dehydrogenase-7|class IV sigma-1 alcohol dehydrogenase|class IV sigmasigma alcohol dehydrogenase|gastric alcohol dehydrogenase|omega-hydroxydecanoate dehydrogenase ADH7|retinol dehydrogenase', map_location='4q23', chromosome='4', genomic_nucleotide_accession_version='NC_000004.12', start_position_on_the_genomic_accession=99412263, end_position_on_the_genomic_accession=99435342, orientation='minus', exon_count=10, OMIM=[600086], no_hdr0=''),
    132 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=132, CurrentID=0, Status='live', Symbol='ADK', Aliases=['AK'], description='adenosine kinase', other_designations="adenosine kinase|adenosine 5'-phosphotransferase|testicular tissue protein Li 14", map_location='10q11-q24', chromosome='10', genomic_nucleotide_accession_version='NC_000010.11', start_position_on_the_genomic_accession=74151185, end_position_on_the_genomic_accession=74709300, orientation='plus', exon_count=16, OMIM=[102750], no_hdr0=''),
    133 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=133, CurrentID=0, Status='live', Symbol='ADM', Aliases=['AM', 'PAMP'], description='adrenomedullin', other_designations='pro-adrenomedullin|preproadrenomedullin|proadrenomedullin N-20 terminal peptide', map_location='11p15.4', chromosome='11', genomic_nucleotide_accession_version='NC_000011.10', start_position_on_the_genomic_accession=10305073, end_position_on_the_genomic_accession=10307397, orientation='plus', exon_count=4, OMIM=[103275], no_hdr0=''),
    134 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=134, CurrentID=0, Status='live', Symbol='ADORA1', Aliases=['RDC7'], description='adenosine A1 receptor', other_designations='adenosine receptor A1|adenosine A1 receptor variant 1|adenosine A1 receptor variant 2', map_location='1q32.1', chromosome='1', genomic_nucleotide_accession_version='NC_000001.11', start_position_on_the_genomic_accession=203127705, end_position_on_the_genomic_accession=203167405, orientation='plus', exon_count=4, OMIM=[102775], no_hdr0=''),
    135 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=135, CurrentID=0, Status='live', Symbol='ADORA2A', Aliases=['A2aR', 'ADORA2', 'RDC8'], description='adenosine A2a receptor', other_designations='adenosine receptor A2a|adenosine receptor subtype A2a', map_location='22q11.23', chromosome='22', genomic_nucleotide_accession_version='NC_000022.11', start_position_on_the_genomic_accession=24423597, end_position_on_the_genomic_accession=24442357, orientation='plus', exon_count=6, OMIM=[102776], no_hdr0=''),
    136 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=136, CurrentID=0, Status='live', Symbol='ADORA2B', Aliases=['ADORA2'], description='adenosine A2b receptor', other_designations='adenosine receptor A2b', map_location='17p12', chromosome='17', genomic_nucleotide_accession_version='NC_000017.11', start_position_on_the_genomic_accession=15927782, end_position_on_the_genomic_accession=15975896, orientation='plus', exon_count=6, OMIM=[600446], no_hdr0=''),
    140 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=140, CurrentID=0, Status='live', Symbol='ADORA3', Aliases=['A3AR'], description='adenosine A3 receptor', other_designations='adenosine receptor A3', map_location='1p13.2', chromosome='1', genomic_nucleotide_accession_version='NC_000001.11', start_position_on_the_genomic_accession=111499429, end_position_on_the_genomic_accession=111503633, orientation='minus', exon_count=2, OMIM=[600445], no_hdr0=''),
    141 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=141, CurrentID=0, Status='live', Symbol='ADPRH', Aliases=['ARH1', 'hARH1'], description='ADP-ribosylarginine hydrolase', other_designations='ADP-ribosylarginine hydrolase|ADP-ribose-L-arginine cleaving enzyme|[Protein ADP-ribosylarginine] hydrolase', map_location='3q13.33', chromosome='3', genomic_nucleotide_accession_version='NC_000003.12', start_position_on_the_genomic_accession=119579492, end_position_on_the_genomic_accession=119589945, orientation='plus', exon_count=5, OMIM=[603081], no_hdr0=''),
    142 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=142, CurrentID=0, Status='live', Symbol='PARP1', Aliases=['ADPRT', 'ADPRT 1', 'ADPRT1', 'ARTD1', 'PARP', 'PARP-1', 'PPOL', 'pADPRT-1'], description='poly(ADP-ribose) polymerase 1', other_designations='poly [ADP-ribose] polymerase 1|ADP-ribosyltransferase (NAD+; poly (ADP-ribose) polymerase)|ADP-ribosyltransferase NAD(+)|ADP-ribosyltransferase diphtheria toxin-like 1|DNA ADP-ribosyltransferase PARP1|NAD(+) ADP-ribosyltransferase 1|poly (ADP-ribose) polymerase family, member 1|poly(ADP-ribose) synthetase|poly(ADP-ribosyl)transferase|poly[ADP-ribose] synthase 1|protein poly-ADP-ribosyltransferase PARP1', map_location='1q42.12', chromosome='1', genomic_nucleotide_accession_version='NC_000001.11', start_position_on_the_genomic_accession=226360691, end_position_on_the_genomic_accession=226408093, orientation='minus', exon_count=23, OMIM=[173870], no_hdr0=''),
    143 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=143, CurrentID=0, Status='live', Symbol='PARP4', Aliases=['ADPRTL1', 'ARTD4', 'PARP-4', 'PARPL', 'PH5P', 'VAULT3', 'VPARP', 'VWA5C', 'p193'], description='poly(ADP-ribose) polymerase family member 4', other_designations='protein mono-ADP-ribosyltransferase PARP4|193 kDa vault protein|ADP-ribosyltransferase (NAD+; poly (ADP-ribose) polymerase)-like 1|ADP-ribosyltransferase diphtheria toxin-like 4|H5 proline-rich|I-alpha-I-related|PARP-related|PARP-related/IalphaI-related H5/proline-rich|poly [ADP-ribose] polymerase 4|poly(ADP-ribose) synthetase|poly(ADP-ribosyl)transferase-like 1|vault poly(ADP-ribose) polymerase|vault protein, 193-kDa|von Willebrand factor A domain containing 5C', map_location='13q12.12', chromosome='13', genomic_nucleotide_accession_version='NC_000013.11', start_position_on_the_genomic_accession=24420930, end_position_on_the_genomic_accession=24512993, orientation='minus', exon_count=36, OMIM=[607519], no_hdr0=''),
    146 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=146, CurrentID=0, Status='live', Symbol='ADRA1D', Aliases=['ADRA1', 'ADRA1A', 'ADRA1R', 'ALPHA1', 'DAR', 'dJ779E11.2'], description='adrenoceptor alpha 1D', other_designations='alpha-1D adrenergic receptor|adrenergic, alpha -1D-, receptor|adrenergic, alpha-1A-, receptor|alpha-1A adrenergic receptor|alpha-1D adrenoceptor|alpha-1D adrenoreceptor|alpha-adrenergic receptor 1a', map_location='20p13', chromosome='20', genomic_nucleotide_accession_version='NC_000020.11', start_position_on_the_genomic_accession=4220630, end_position_on_the_genomic_accession=4249287, orientation='minus', exon_count=2, OMIM=[104219], no_hdr0=''),
    147 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=147, CurrentID=0, Status='live', Symbol='ADRA1B', Aliases=['ADRA1', 'ALPHA1BAR'], description='adrenoceptor alpha 1B', other_designations='alpha-1B adrenergic receptor|adrenergic, alpha-1B-, receptor|alpha-1B adrenoceptor|alpha-1B adrenoreceptor', map_location='5q33.3', chromosome='5', genomic_nucleotide_accession_version='NC_000005.10', start_position_on_the_genomic_accession=159916482, end_position_on_the_genomic_accession=159989205, orientation='plus', exon_count=7, OMIM=[104220], no_hdr0=''),
    148 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=148, CurrentID=0, Status='live', Symbol='ADRA1A', Aliases=['ADRA1C', 'ADRA1L1', 'ALPHA1AAR'], description='adrenoceptor alpha 1A', other_designations='alpha-1A adrenergic receptor|G protein coupled receptor|alpha-1A adrenoceptor|alpha-1A adrenoreceptor|alpha-1C adrenergic receptor', map_location='8p21.2', chromosome='8', genomic_nucleotide_accession_version='NC_000008.11', start_position_on_the_genomic_accession=26738113, end_position_on_the_genomic_accession=26870994, orientation='minus', exon_count=11, OMIM=[104221], no_hdr0=''),
    150 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=150, CurrentID=0, Status='live', Symbol='ADRA2A', Aliases=['ADRA2', 'ADRA2R', 'ADRAR', 'ALPHA2AAR', 'ZNF32'], description='adrenoceptor alpha 2A', other_designations='alpha-2A adrenergic receptor|adrenergic, alpha-2A-, receptor|alpha-2 adrenergic receptor subtype C10|alpha-2-adrenergic receptor, platelet type|alpha-2A adrenoceptor|alpha-2A adrenoreceptor|alpha-2AAR subtype C10', map_location='10q25.2', chromosome='10', genomic_nucleotide_accession_version='NC_000010.11', start_position_on_the_genomic_accession=111077029, end_position_on_the_genomic_accession=111080907, orientation='plus', exon_count=1, OMIM=[104210], no_hdr0=''),
    151 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=151, CurrentID=0, Status='live', Symbol='ADRA2B', Aliases=['ADRA2L1', 'ADRA2RL1', 'ADRARL1', 'ALPHA2BAR', 'FAME2', 'alpha-2BAR'], description='adrenoceptor alpha 2B', other_designations='alpha-2B adrenergic receptor|ADRA2B adrenergic, alpha-2B-, receptor|G-protein coupled receptor|alpha-2 adrenergic receptor subtype C2|alpha-2-adrenergic receptor-like 1|alpha-2B adrenoreceptor', map_location='2q11.2', chromosome='2', genomic_nucleotide_accession_version='NC_000002.12', start_position_on_the_genomic_accession=96112876, end_position_on_the_genomic_accession=96116571, orientation='minus', exon_count=1, OMIM=[104260], no_hdr0=''),
    152 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=152, CurrentID=0, Status='live', Symbol='ADRA2C', Aliases=['ADRA2L2', 'ADRA2RL2', 'ADRARL2', 'ALPHA2CAR'], description='adrenoceptor alpha 2C', other_designations='alpha-2C adrenergic receptor|adrenergic, alpha-2C-, receptor|alpha-2 adrenergic receptor subtype C4|alpha-2C adrenoceptor|alpha-2C adrenoreceptor|alpha-2CAR|alpha2-AR-C4', map_location='4p16.3', chromosome='4', genomic_nucleotide_accession_version='NC_000004.12', start_position_on_the_genomic_accession=3766385, end_position_on_the_genomic_accession=3768526, orientation='plus', exon_count=1, OMIM=[104250], no_hdr0=''),
    153 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=153, CurrentID=0, Status='live', Symbol='ADRB1', Aliases=['ADRB1R', 'B1AR', 'BETA1AR', 'FNSS2', 'RHR'], description='adrenoceptor beta 1', other_designations='beta-1 adrenergic receptor|adrenergic, beta-1-, receptor|beta-1 adrenoceptor|beta-1 adrenoreceptor', map_location='10q25.3', chromosome='10', genomic_nucleotide_accession_version='NC_000010.11', start_position_on_the_genomic_accession=114043866, end_position_on_the_genomic_accession=114046904, orientation='plus', exon_count=1, OMIM=[109630], no_hdr0=''),
    154 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=154, CurrentID=0, Status='live', Symbol='ADRB2', Aliases=['ADRB2R', 'ADRBR', 'B2AR', 'BAR', 'BETA2AR'], description='adrenoceptor beta 2', other_designations='beta-2 adrenergic receptor|adrenergic, beta-2-, receptor, surface|adrenoceptor beta 2 surface|beta-2 adrenoceptor|beta-2 adrenoreceptor|catecholamine receptor', map_location='5q32', chromosome='5', genomic_nucleotide_accession_version='NC_000005.10', start_position_on_the_genomic_accession=148826611, end_position_on_the_genomic_accession=148828623, orientation='plus', exon_count=1, OMIM=[109690], no_hdr0=''),
    155 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=155, CurrentID=0, Status='live', Symbol='ADRB3', Aliases=['BETA3AR'], description='adrenoceptor beta 3', other_designations='beta-3 adrenergic receptor|adrenergic, beta-3-, receptor|beta-3 adrenoceptor|beta-3 adrenoreceptor', map_location='8p11.23', chromosome='8', genomic_nucleotide_accession_version='NC_000008.11', start_position_on_the_genomic_accession=37962990, end_position_on_the_genomic_accession=37966599, orientation='minus', exon_count=2, OMIM=[109691], no_hdr0=''),
    156 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=156, CurrentID=0, Status='live', Symbol='GRK2', Aliases=['ADRBK1', 'BARK1', 'BETA-ARK1'], description='G protein-coupled receptor kinase 2', other_designations='beta-adrenergic receptor kinase 1|adrenergic beta receptor kinase 1|beta-ARK-1', map_location='11q13.2', chromosome='11', genomic_nucleotide_accession_version='NC_000011.10', start_position_on_the_genomic_accession=67266420, end_position_on_the_genomic_accession=67286556, orientation='plus', exon_count=23, OMIM=[109635], no_hdr0=''),
    157 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=157, CurrentID=0, Status='live', Symbol='GRK3', Aliases=['ADRBK2', 'BARK2'], description='G protein-coupled receptor kinase 3', other_designations='beta-adrenergic receptor kinase 2|adrenergic, beta, receptor kinase 2|beta-ARK-2', map_location='22q12.1', chromosome='22', genomic_nucleotide_accession_version='NC_000022.11', start_position_on_the_genomic_accession=25564675, end_position_on_the_genomic_accession=25729294, orientation='plus', exon_count=23, OMIM=[109636], no_hdr0=''),
    158 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=158, CurrentID=0, Status='live', Symbol='ADSL', Aliases=['AMPS', 'ASASE', 'ASL'], description='adenylosuccinate lyase', other_designations='adenylosuccinate lyase|adenylosuccinase', map_location='22q13.1', chromosome='22', genomic_nucleotide_accession_version='NC_000022.11', start_position_on_the_genomic_accession=40346500, end_position_on_the_genomic_accession=40387527, orientation='plus', exon_count=14, OMIM=[608222], no_hdr0=''),
    159 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=159, CurrentID=0, Status='live', Symbol='ADSS2', Aliases=['ADEH', 'ADSS', 'ADSS 2'], description='adenylosuccinate synthase 2', other_designations='adenylosuccinate synthetase isozyme 2|AMPSase 2|IMP--aspartate ligase 2|L-type adenylosuccinate synthetase|adenylosuccinate synthetase (Ade(-)H-complementing)|adenylosuccinate synthetase, acidic isozyme|adenylosuccinate synthetase, liver isozyme|epididymis secretory sperm binding protein', map_location='1q44', chromosome='1', genomic_nucleotide_accession_version='NC_000001.11', start_position_on_the_genomic_accession=244408494, end_position_on_the_genomic_accession=244452060, orientation='minus', exon_count=14, OMIM=[103060], no_hdr0=''),
    160 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=160, CurrentID=0, Status='live', Symbol='AP2A1', Aliases=['ADTAA', 'AP2-ALPHA', 'CLAPA1'], description='adaptor related protein complex 2 subunit alpha 1', other_designations='AP-2 complex subunit alpha-1|100 kDa coated vesicle protein A|adapter-related protein complex 2 alpha-1 subunit|adapter-related protein complex 2 subunit alpha-1|adaptin, alpha A|adaptor protein complex AP-2 subunit alpha-1|adaptor related protein complex 2 alpha 1 subunit|alpha-adaptin A|alpha1-adaptin|clathrin assembly protein complex 2 alpha-A large chain|clathrin-associated/assembly/adaptor protein, large, alpha 1|plasma membrane adaptor HA2/AP2 adaptin alpha A subunit', map_location='19q13.33', chromosome='19', genomic_nucleotide_accession_version='NC_000019.10', start_position_on_the_genomic_accession=49767001, end_position_on_the_genomic_accession=49807114, orientation='plus', exon_count=25, OMIM=[601026], no_hdr0=''),
    161 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=161, CurrentID=0, Status='live', Symbol='AP2A2', Aliases=['ADTAB', 'CLAPA2', 'HIP-9', 'HIP9', 'HYPJ'], description='adaptor related protein complex 2 subunit alpha 2', other_designations='AP-2 complex subunit alpha-2|100 kDa coated vesicle protein C|adapter-related protein complex 2 subunit alpha-2|adaptin, alpha B|adaptor related protein complex 2 alpha 2 subunit|alpha-adaptin C; Huntingtin interacting protein J|alpha2-adaptin|clathrin assembly protein complex 2 alpha-C large chain|clathrin-associated/assembly/adaptor protein, large, alpha 2|huntingtin yeast partner J|huntingtin-interacting protein 9|plasma membrane adaptor HA2/AP2 adaptin alpha C subunit', map_location='11p15.5', chromosome='11', genomic_nucleotide_accession_version='NC_000011.10', start_position_on_the_genomic_accession=925850, end_position_on_the_genomic_accession=1012240, orientation='plus', exon_count=24, OMIM=[607242], no_hdr0=''),
    162 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=162, CurrentID=0, Status='live', Symbol='AP1B1', Aliases=['ADTB1', 'AP105A', 'BAM22', 'CLAPB2', 'KIDAR'], description='adaptor related protein complex 1 subunit beta 1', other_designations='AP-1 complex subunit beta-1|ADTB1, CLAPB2|Golgi adaptor HA1/AP1 adaptin beta subunit|adapter-related protein complex 1 subunit beta-1|adaptor protein complex AP-1 subunit beta-1|adaptor related protein complex 1 beta 1 subunit|beta-1-adaptin|beta-adaptin 1|beta-prime-adaptin|beta1-adaptin|clathrin assembly protein complex 1 beta large chain|plasma membrane adaptor HA2/AP2 adaptor beta subunit', map_location='22q12.2', chromosome='22', genomic_nucleotide_accession_version='NC_000022.11', start_position_on_the_genomic_accession=29327680, end_position_on_the_genomic_accession=29388570, orientation='minus', exon_count=23, OMIM=[600157], no_hdr0=''),
    163 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=163, CurrentID=0, Status='live', Symbol='AP2B1', Aliases=['ADTB2', 'AP105B', 'AP2-BETA', 'CLAPB1'], description='adaptor related protein complex 2 subunit beta 1', other_designations='AP-2 complex subunit beta|adapter-related protein complex 2 beta subunit|adapter-related protein complex 2 subunit beta|adaptin, beta 2 (beta)|adaptor protein complex AP-2 subunit beta|adaptor related protein complex 2 beta 1 subunit|adaptor-related protein complex 2 subunit beta|beta-2-adaptin|beta-adaptin|clathrin assembly protein complex 2 beta large chain|clathrin-associated/assembly/adaptor protein, large, beta 1|plasma membrane adaptor HA2/AP2 adaptin beta subunit|testicular tissue protein Li 22', map_location='17q12', chromosome='17', genomic_nucleotide_accession_version='NC_000017.11', start_position_on_the_genomic_accession=35587265, end_position_on_the_genomic_accession=35726413, orientation='plus', exon_count=26, OMIM=[601025], no_hdr0=''),
    164 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=164, CurrentID=0, Status='live', Symbol='AP1G1', Aliases=['ADTG', 'CLAPG1'], description='adaptor related protein complex 1 subunit gamma 1', other_designations='AP-1 complex subunit gamma-1|adapter-related protein complex 1 subunit gamma-1|adaptor protein complex AP-1 subunit gamma-1|adaptor related protein complex 1 gamma 1 subunit|clathrin assembly protein complex 1 gamma large chain|clathrin assembly protein complex 1 gamma-1 large chain|clathrin-associated/assembly/adaptor protein, large, gamma 1|gamma adaptin|gamma1-adaptin|golgi adaptor HA1/AP1 adaptin gamma subunit|golgi adaptor HA1/AP1 adaptin subunit gamma-1|testicular tissue protein Li 21', map_location='16q22.2', chromosome='16', genomic_nucleotide_accession_version='NC_000016.10', start_position_on_the_genomic_accession=71729000, end_position_on_the_genomic_accession=71808834, orientation='minus', exon_count=24, OMIM=[603533], no_hdr0=''),
    165 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=165, CurrentID=0, Status='live', Symbol='AEBP1', Aliases=['ACLP'], description='AE binding protein 1', other_designations='adipocyte enhancer-binding protein 1|aortic carboxypeptidase-like protein', map_location='7p13', chromosome='7', genomic_nucleotide_accession_version='NC_000007.14', start_position_on_the_genomic_accession=44104320, end_position_on_the_genomic_accession=44114564, orientation='plus', exon_count=21, OMIM=[602981], no_hdr0=''),
    166 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=166, CurrentID=0, Status='live', Symbol='TLE5', Aliases=['AES', 'AES-1', 'AES-2', 'ESP1', 'GRG', 'GRG5', 'Grg-5'], description='TLE family member 5, transcriptional modulator', other_designations='TLE family member 5|amino-terminal enhancer of split|gp130-associated protein GAM|groucho-related protein 5', map_location='19p13.3', chromosome='19', genomic_nucleotide_accession_version='NC_000019.10', start_position_on_the_genomic_accession=3052910, end_position_on_the_genomic_accession=3063107, orientation='minus', exon_count=8, OMIM=[600188], no_hdr0=''),
    167 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=167, CurrentID=0, Status='live', Symbol='CRISP1', Aliases=['AEGL1', 'ARP', 'CRISP-1', 'HEL-S-57', 'HSCRISP1D', 'HSCRISP1G', 'HUMARP'], description='cysteine rich secretory protein 1', other_designations='cysteine-rich secretory protein 1|AEG-like protein|AEG-related protein|acidic epididymal glycoprotein homolog|acidic epididymal glycoprotein-like 1|cysteine-rich secretory protein-1 delta|epididymis secretory protein Li 57', map_location='6p12.3', chromosome='6', genomic_nucleotide_accession_version='NC_000006.12', start_position_on_the_genomic_accession=49833939, end_position_on_the_genomic_accession=49877096, orientation='minus', exon_count=11, OMIM=[601193], no_hdr0=''),
    173 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=173, CurrentID=0, Status='live', Symbol='AFM', Aliases=['ALB2', 'ALBA', 'ALF'], description='afamin', other_designations='afamin|alpha-Alb|alpha-albumin', map_location='4q13.3', chromosome='4', genomic_nucleotide_accession_version='NC_000004.12', start_position_on_the_genomic_accession=73481745, end_position_on_the_genomic_accession=73504001, orientation='plus', exon_count=15, OMIM=[104145], no_hdr0=''),
    174 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=174, CurrentID=0, Status='live', Symbol='AFP', Aliases=['AFPD', 'FETA', 'HPAFP'], description='alpha fetoprotein', other_designations='alpha-fetoprotein|alpha-1-fetoprotein|alpha-fetoglobulin', map_location='4q13.3', chromosome='4', genomic_nucleotide_accession_version='NC_000004.12', start_position_on_the_genomic_accession=73436221, end_position_on_the_genomic_accession=73456174, orientation='plus', exon_count=15, OMIM=[104150], no_hdr0=''),
    175 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=175, CurrentID=0, Status='live', Symbol='AGA', Aliases=['AGU', 'ASRG', 'GA'], description='aspartylglucosaminidase', other_designations='N(4)-(beta-N-acetylglucosaminyl)-L-asparaginase|N4-(N-acetyl-beta-glucosaminyl)-L-asparagine amidase|aspartylglucosylamine deaspartylase|glycosylasparaginase', map_location='4q34.3', chromosome='4', genomic_nucleotide_accession_version='NC_000004.12', start_position_on_the_genomic_accession=177430774, end_position_on_the_genomic_accession=177442469, orientation='minus', exon_count=9, OMIM=[613228], no_hdr0=''),
    176 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=176, CurrentID=0, Status='live', Symbol='ACAN', Aliases=['AGC1', 'AGCAN', 'CSPG1', 'CSPGCP', 'MSK16', 'SEDK', 'SSOAOD'], description='aggrecan', other_designations='aggrecan core protein|cartilage-specific proteoglycan core protein|chondroitin sulfate proteoglycan core protein 1|large aggregating proteoglycan', map_location='15q26.1', chromosome='15', genomic_nucleotide_accession_version='NC_000015.10', start_position_on_the_genomic_accession=88803436, end_position_on_the_genomic_accession=88875353, orientation='plus', exon_count=19, OMIM=[155760], no_hdr0=''),
    177 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=177, CurrentID=0, Status='live', Symbol='AGER', Aliases=['RAGE', 'SCARJ1'], description='advanced glycosylation end-product specific receptor', other_designations='advanced glycosylation end product-specific receptor|receptor for advanced glycation end-products variant 20', map_location='6p21.32', chromosome='6', genomic_nucleotide_accession_version='NC_000006.12', start_position_on_the_genomic_accession=32180969, end_position_on_the_genomic_accession=32184380, orientation='minus', exon_count=11, OMIM=[600214], no_hdr0=''),
    178 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=178, CurrentID=0, Status='live', Symbol='AGL', Aliases=['GDE'], description='amylo-alpha-1, 6-glucosidase, 4-alpha-glucanotransferase', other_designations='glycogen debranching enzyme|amylo-1, 6-glucosidase, 4-alpha-glucanotransferase|amylo-alpha-1, 6-glucosidase, 4-alpha-glucanotransferaseprovided|glycogen debrancher|glycogen debranching protein', map_location='1p21.2', chromosome='1', genomic_nucleotide_accession_version='NC_000001.11', start_position_on_the_genomic_accession=99850077, end_position_on_the_genomic_accession=99924023, orientation='plus', exon_count=37, OMIM=[610860], no_hdr0=''),
    181 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=181, CurrentID=0, Status='live', Symbol='AGRP', Aliases=['AGRT', 'ART', 'ASIP2'], description='agouti related neuropeptide', other_designations='agouti-related protein|agouti related protein homolog', map_location='16q22.1', chromosome='16', genomic_nucleotide_accession_version='NC_000016.10', start_position_on_the_genomic_accession=67482571, end_position_on_the_genomic_accession=67483547, orientation='minus', exon_count=4, OMIM=[602311], no_hdr0=''),
    182 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=182, CurrentID=0, Status='live', Symbol='JAG1', Aliases=['AGS', 'AGS1', 'AHD', 'AWS', 'CD339', 'DCHE', 'HJ1', 'JAGL1'], description='jagged canonical Notch ligand 1', other_designations='protein jagged-1', map_location='20p12.2', chromosome='20', genomic_nucleotide_accession_version='NC_000020.11', start_position_on_the_genomic_accession=10637684, end_position_on_the_genomic_accession=10673999, orientation='minus', exon_count=26, OMIM=[601920], no_hdr0=''),
    183 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=183, CurrentID=0, Status='live', Symbol='AGT', Aliases=['ANHU', 'SERPINA8', 'hFLT1'], description='angiotensinogen', other_designations='angiotensinogen|alpha-1 antiproteinase, antitrypsin|angiotensin I|angiotensin II|fetal-liver predominant transporter 1|pre-angiotensinogen|serine (or cysteine) proteinase inhibitor|serpin A8|serpin peptidase inhibitor, clade A, member 8', map_location='1q42.2', chromosome='1', genomic_nucleotide_accession_version='NC_000001.11', start_position_on_the_genomic_accession=230702523, end_position_on_the_genomic_accession=230745583, orientation='minus', exon_count=6, OMIM=[106150], no_hdr0=''),
    185 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=185, CurrentID=0, Status='live', Symbol='AGTR1', Aliases=['AG2SB', 'AT1', 'AT1AR', 'AT1B', 'AT1BR', 'AT1R', 'AT2R1', 'HAT1R', 'AGTR1'], description='angiotensin II receptor type 1', other_designations='type-1 angiotensin II receptor|type-1B angiotensin II receptor', map_location='3q24', chromosome='3', genomic_nucleotide_accession_version='NC_000003.12', start_position_on_the_genomic_accession=148697871, end_position_on_the_genomic_accession=148743003, orientation='plus', exon_count=5, OMIM=[106165], no_hdr0=''),
    186 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=186, CurrentID=0, Status='live', Symbol='AGTR2', Aliases=['AT2', 'ATGR2', 'MRX88'], description='angiotensin II receptor type 2', other_designations='type-2 angiotensin II receptor|angiotensin II type-2 receptor', map_location='Xq23', chromosome='X', genomic_nucleotide_accession_version='NC_000023.11', start_position_on_the_genomic_accession=116170744, end_position_on_the_genomic_accession=116174974, orientation='plus', exon_count=3, OMIM=[300034], no_hdr0=''),
    187 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=187, CurrentID=0, Status='live', Symbol='APLNR', Aliases=['AGTRL1', 'APJ', 'APJR', 'HG11'], description='apelin receptor', other_designations='apelin receptor|APJ (apelin) receptor|APJ receptor|G protein-coupled receptor APJ|G-protein coupled receptor HG11|HG11 orphan receptor|angiotensin II receptor-like 1|angiotensin receptor-like 1', map_location='11q12.1', chromosome='11', genomic_nucleotide_accession_version='NC_000011.10', start_position_on_the_genomic_accession=57233591, end_position_on_the_genomic_accession=57237430, orientation='minus', exon_count=1, OMIM=[600052], no_hdr0=''),
    189 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=189, CurrentID=0, Status='live', Symbol='AGXT', Aliases=['AGT', 'AGT11', 'PH1', 'SPAT', 'SPT', 'TLH6', 'AGXT'], description='alanine--glyoxylate and serine--pyruvate aminotransferase', other_designations='serine--pyruvate aminotransferase|L-alanine: glyoxylate aminotransferase 1|alanine-glyoxylate aminotransferase|hepatic peroxisomal alanine:glyoxylate aminotransferase', map_location='2q37.3', chromosome='2', genomic_nucleotide_accession_version='NC_000002.12', start_position_on_the_genomic_accession=240868824, end_position_on_the_genomic_accession=240880500, orientation='plus', exon_count=11, OMIM=[604285], no_hdr0=''),
    190 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=190, CurrentID=0, Status='live', Symbol='NR0B1', Aliases=['AHC', 'AHCH', 'AHX', 'DAX-1', 'DAX1', 'DSS', 'GTD', 'HHG', 'NROB1', 'SRXY2'], description='nuclear receptor subfamily 0 group B member 1', other_designations='nuclear receptor subfamily 0 group B member 1|DSS-AHC critical region on the X chromosome protein 1|nuclear hormone receptor|nuclear receptor DAX-1|truncated nuclear receptor subfamily 0 group B member 1', map_location='Xp21.2', chromosome='X', genomic_nucleotide_accession_version='NC_000023.11', start_position_on_the_genomic_accession=30304206, end_position_on_the_genomic_accession=30309390, orientation='minus', exon_count=2, OMIM=[300473], no_hdr0=''),
    191 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=191, CurrentID=0, Status='live', Symbol='AHCY', Aliases=['SAHH', 'adoHcyase'], description='adenosylhomocysteinase', other_designations='adenosylhomocysteinase|S-adenosyl-L-homocysteine hydrolase|S-adenosylhomocysteine hydrolase|epididymis secretory sperm binding protein', map_location='20q11.22', chromosome='20', genomic_nucleotide_accession_version='NC_000020.11', start_position_on_the_genomic_accession=34235012, end_position_on_the_genomic_accession=34311976, orientation='minus', exon_count=17, OMIM=[180960], no_hdr0=''),
    196 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=196, CurrentID=0, Status='live', Symbol='AHR', Aliases=['RP85', 'bHLHe76'], description='aryl hydrocarbon receptor', other_designations='aryl hydrocarbon receptor|AH-receptor|ah receptor|aromatic hydrocarbon receptor|class E basic helix-loop-helix protein 76', map_location='7p21.1', chromosome='7', genomic_nucleotide_accession_version='NC_000007.14', start_position_on_the_genomic_accession=17298652, end_position_on_the_genomic_accession=17346147, orientation='plus', exon_count=11, OMIM=[600253], no_hdr0=''),
    197 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=197, CurrentID=0, Status='live', Symbol='AHSG', Aliases=['A2HS', 'AHS', 'APMR1', 'FETUA', 'HSGA'], description='alpha 2-HS glycoprotein', other_designations='alpha-2-HS-glycoprotein|alpha-2-Z-globulin|ba-alpha-2-glycoprotein|fetuin-A', map_location='3q27.3', chromosome='3', genomic_nucleotide_accession_version='NC_000003.12', start_position_on_the_genomic_accession=186613060, end_position_on_the_genomic_accession=186621318, orientation='plus', exon_count=7, OMIM=[138680], no_hdr0=''),
    199 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=199, CurrentID=0, Status='live', Symbol='AIF1', Aliases=['AIF-1', 'IBA1', 'IRT-1', 'IRT1'], description='allograft inflammatory factor 1', other_designations='allograft inflammatory factor 1|interferon gamma responsive transcript|ionized calcium-binding adapter molecule 1|protein G1', map_location='6p21.33', chromosome='6', genomic_nucleotide_accession_version='NC_000006.12', start_position_on_the_genomic_accession=31615212, end_position_on_the_genomic_accession=31617015, orientation='plus', exon_count=5, OMIM=[601833], no_hdr0=''),
    202 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=202, CurrentID=0, Status='live', Symbol='CRYBG1', Aliases=['AIM1', 'ST4'], description='crystallin beta-gamma domain containing 1', other_designations='beta/gamma crystallin domain-containing protein 1|absent in melanoma 1 protein|beta-gamma crystallin domain containing 1|suppression of tumorigenicity 4 (malignant melanoma)', map_location='6q21', chromosome='6', genomic_nucleotide_accession_version='NC_000006.12', start_position_on_the_genomic_accession=106360717, end_position_on_the_genomic_accession=106572017, orientation='plus', exon_count=22, OMIM=[601797], no_hdr0=''),
    203 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=203, CurrentID=0, Status='live', Symbol='AK1', Aliases=['HTL-S-58j'], description='adenylate kinase 1', other_designations='adenylate kinase isoenzyme 1|ATP-AMP transphosphorylase 1|ATP:AMP phosphotransferase|adenylate monophosphate kinase|epididymis secretory sperm binding protein|myokinase|testis secretory sperm binding protein Li 58j', map_location='9q34.11', chromosome='9', genomic_nucleotide_accession_version='NC_000009.12', start_position_on_the_genomic_accession=127866480, end_position_on_the_genomic_accession=127885542, orientation='minus', exon_count=10, OMIM=[103000], no_hdr0=''),
    204 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=204, CurrentID=0, Status='live', Symbol='AK2', Aliases=['ADK2'], description='adenylate kinase 2', other_designations='adenylate kinase 2, mitochondrial|ATP-AMP transphosphorylase 2|ATP:AMP phosphotransferase|adenylate kinase isoenzyme 2, mitochondrial|adenylate monophosphate kinase|testis secretory sperm-binding protein Li 220n', map_location='1p35.1', chromosome='1', genomic_nucleotide_accession_version='NC_000001.11', start_position_on_the_genomic_accession=33007940, end_position_on_the_genomic_accession=33036883, orientation='minus', exon_count=9, OMIM=[103020], no_hdr0=''),
    205 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=205, CurrentID=0, Status='live', Symbol='AK4', Aliases=['AK 4', 'AK3', 'AK3L1', 'AK3L2'], description='adenylate kinase 4', other_designations='adenylate kinase 4, mitochondrial|ATP-AMP transphosphorylase|GTP:AMP phosphotransferase AK4, mitochondrial|adenylate kinase 3-like 1|adenylate kinase isoenzyme 4, mitochondrial|epididymis secretory sperm binding protein|mitochondrial adenylate kinase-3|nucleoside-triphosphate-adenylate kinase', map_location='1p31.3', chromosome='1', genomic_nucleotide_accession_version='NC_000001.11', start_position_on_the_genomic_accession=65147342, end_position_on_the_genomic_accession=65232145, orientation='plus', exon_count=8, OMIM=[103030], no_hdr0=''),
    207 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=207, CurrentID=0, Status='live', Symbol='AKT1', Aliases=['AKT', 'PKB', 'PKB-ALPHA', 'PRKBA', 'RAC', 'RAC-ALPHA'], description='AKT serine/threonine kinase 1', other_designations='RAC-alpha serine/threonine-protein kinase|AKT1m|PKB alpha|RAC-PK-alpha|protein kinase B alpha|proto-oncogene c-Akt|rac protein kinase alpha|serine-threonine protein kinase|v-akt murine thymoma viral oncogene homolog 1|v-akt murine thymoma viral oncogene-like protein 1', map_location='14q32.33', chromosome='14', genomic_nucleotide_accession_version='NC_000014.9', start_position_on_the_genomic_accession=104769349, end_position_on_the_genomic_accession=104795748, orientation='minus', exon_count=15, OMIM=[164730], no_hdr0=''),
    208 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=208, CurrentID=0, Status='live', Symbol='AKT2', Aliases=['HIHGHH', 'PKBB', 'PKBBETA', 'PRKBB', 'RAC-BETA'], description='AKT serine/threonine kinase 2', other_designations='RAC-beta serine/threonine-protein kinase|PKB beta|RAC-PK-beta|murine thymoma viral (v-akt) homolog-2|protein kinase Akt-2|protein kinase B beta|putative v-akt murine thymoma viral oncoprotein 2|rac protein kinase beta|v-akt murine thymoma viral oncogene homolog 2', map_location='19q13.2', chromosome='19', genomic_nucleotide_accession_version='NC_000019.10', start_position_on_the_genomic_accession=40230317, end_position_on_the_genomic_accession=40285531, orientation='minus', exon_count=22, OMIM=[164731], no_hdr0=''),
    210 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=210, CurrentID=0, Status='live', Symbol='ALAD', Aliases=['ALADH', 'PBGS'], description='aminolevulinate dehydratase', other_designations='delta-aminolevulinic acid dehydratase|aminolevulinate, delta-, dehydratase|porphobilinogen synthase|testicular tissue protein Li 95', map_location='9q32', chromosome='9', genomic_nucleotide_accession_version='NC_000009.12', start_position_on_the_genomic_accession=113386312, end_position_on_the_genomic_accession=113401301, orientation='minus', exon_count=14, OMIM=[125270], no_hdr0=''),
    211 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=211, CurrentID=0, Status='live', Symbol='ALAS1', Aliases=['ALAS', 'ALAS-H', 'ALAS3', 'ALASH', 'MIG4'], description="5'-aminolevulinate synthase 1", other_designations='5-aminolevulinate synthase, nonspecific, mitochondrial|5-aminolevulinic acid synthase 1|aminolevulinate, delta-, synthase 1|delta-ALA synthase 1|delta-aminolevulinate synthase 1|migration-inducing protein 4', map_location='3p21.2', chromosome='3', genomic_nucleotide_accession_version='NC_000003.12', start_position_on_the_genomic_accession=52198083, end_position_on_the_genomic_accession=52214327, orientation='plus', exon_count=12, OMIM=[125290], no_hdr0=''),
    212 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=212, CurrentID=0, Status='live', Symbol='ALAS2', Aliases=['ALAS-E', 'ALASE', 'ANH1', 'ASB', 'SIDBA1', 'XLDPP', 'XLEPP', 'XLSA'], description="5'-aminolevulinate synthase 2", other_designations='5-aminolevulinate synthase, erythroid-specific, mitochondrial|5-aminolevulinic acid synthase 2|aminolevulinate, delta-, synthase 2|delta-ALA synthase 2|delta-ALA synthetase|delta-aminolevulinate synthase 2', map_location='Xp11.21', chromosome='X', genomic_nucleotide_accession_version='NC_000023.11', start_position_on_the_genomic_accession=55009055, end_position_on_the_genomic_accession=55030977, orientation='minus', exon_count=12, OMIM=[301300], no_hdr0=''),
    213 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=213, CurrentID=0, Status='live', Symbol='ALB', Aliases=['HSA', 'PRO0883', 'PRO0903', 'PRO1341'], description='albumin', other_designations='albumin|serum albumin', map_location='4q13.3', chromosome='4', genomic_nucleotide_accession_version='NC_000004.12', start_position_on_the_genomic_accession=73404287, end_position_on_the_genomic_accession=73421482, orientation='plus', exon_count=15, OMIM=[103600], no_hdr0=''),
    214 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=214, CurrentID=0, Status='live', Symbol='ALCAM', Aliases=['CD166', 'MEMD'], description='activated leukocyte cell adhesion molecule', other_designations='CD166 antigen', map_location='3q13.11', chromosome='3', genomic_nucleotide_accession_version='NC_000003.12', start_position_on_the_genomic_accession=105366909, end_position_on_the_genomic_accession=105576900, orientation='plus', exon_count=16, OMIM=[601662], no_hdr0=''),
    215 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=215, CurrentID=0, Status='live', Symbol='ABCD1', Aliases=['ABC42', 'ALD', 'ALDP', 'AMN'], description='ATP binding cassette subfamily D member 1', other_designations='ATP-binding cassette sub-family D member 1|ATP-binding cassette, sub-family D (ALD), member 1|adrenoleukodystrophy protein', map_location='Xq28', chromosome='X', genomic_nucleotide_accession_version='NC_000023.11', start_position_on_the_genomic_accession=153724851, end_position_on_the_genomic_accession=153744755, orientation='plus', exon_count=11, OMIM=[300371], no_hdr0=''),
    216 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=216, CurrentID=0, Status='live', Symbol='ALDH1A1', Aliases=['ALDC', 'ALDH-E1', 'ALDH1', 'ALDH11', 'HEL-9', 'HEL-S-53e', 'HEL12', 'PUMB1', 'RALDH1'], description='aldehyde dehydrogenase 1 family member A1', other_designations='retinal dehydrogenase 1|ALDH class 1|ALHDII|RALDH 1|acetaldehyde dehydrogenase 1|aldehyde dehydrogenase 1, soluble|aldehyde dehydrogenase, liver cytosolic|epididymis luminal protein 12|epididymis luminal protein 9|epididymis secretory sperm binding protein Li 53e|retinaldehyde dehydrogenase 1', map_location='9q21.13', chromosome='9', genomic_nucleotide_accession_version='NC_000009.12', start_position_on_the_genomic_accession=72900671, end_position_on_the_genomic_accession=72953053, orientation='minus', exon_count=13, OMIM=[100640], no_hdr0=''),
    217 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=217, CurrentID=0, Status='live', Symbol='ALDH2', Aliases=['ALDH-E2', 'ALDHI', 'ALDM'], description='aldehyde dehydrogenase 2 family member', other_designations='aldehyde dehydrogenase, mitochondrial|ALDH class 2|acetaldehyde dehydrogenase 2|aldehyde dehydrogenase 2 family (mitochondrial)|epididymis secretory sperm binding protein|liver mitochondrial ALDH|nucleus-encoded mitochondrial aldehyde dehydrogenase 2', map_location='12q24.12', chromosome='12', genomic_nucleotide_accession_version='NC_000012.12', start_position_on_the_genomic_accession=111766933, end_position_on_the_genomic_accession=111817532, orientation='plus', exon_count=13, OMIM=[100650], no_hdr0=''),
    218 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=218, CurrentID=0, Status='live', Symbol='ALDH3A1', Aliases=['ALDH3', 'ALDHIII'], description='aldehyde dehydrogenase 3 family member A1', other_designations='aldehyde dehydrogenase, dimeric NADP-preferring|aldehyde dehydrogenase isozyme 3|aldehyde dehydrogenase type III|stomach aldehyde dehydrogenase', map_location='17p11.2', chromosome='17', genomic_nucleotide_accession_version='NC_000017.11', start_position_on_the_genomic_accession=19737984, end_position_on_the_genomic_accession=19748390, orientation='minus', exon_count=12, OMIM=[100660], no_hdr0=''),
    219 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=219, CurrentID=0, Status='live', Symbol='ALDH1B1', Aliases=['ALDH5', 'ALDHX'], description='aldehyde dehydrogenase 1 family member B1', other_designations='aldehyde dehydrogenase X, mitochondrial|ALDH class 2|acetaldehyde dehydrogenase 5|aldehyde dehydrogenase 5|epididymis secretory sperm binding protein', map_location='9p13.1', chromosome='9', genomic_nucleotide_accession_version='NC_000009.12', start_position_on_the_genomic_accession=38392702, end_position_on_the_genomic_accession=38398665, orientation='plus', exon_count=3, OMIM=[100670], no_hdr0=''),
    220 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=220, CurrentID=0, Status='live', Symbol='ALDH1A3', Aliases=['ALDH1A6', 'ALDH6', 'MCOP8', 'RALDH3'], description='aldehyde dehydrogenase 1 family member A3', other_designations='aldehyde dehydrogenase family 1 member A3|acetaldehyde dehydrogenase 6|aldehyde dehydrogenase 6|retinaldehyde dehydrogenase 3', map_location='15q26.3', chromosome='15', genomic_nucleotide_accession_version='NC_000015.10', start_position_on_the_genomic_accession=100879831, end_position_on_the_genomic_accession=100916626, orientation='plus', exon_count=13, OMIM=[600463], no_hdr0=''),
    221 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=221, CurrentID=0, Status='live', Symbol='ALDH3B1', Aliases=['ALDH4', 'ALDH7'], description='aldehyde dehydrogenase 3 family member B1', other_designations='aldehyde dehydrogenase family 3 member B1|aldehyde dehydrogenase 3B1|aldehyde dehydrogenase 7', map_location='11q13.2', chromosome='11', genomic_nucleotide_accession_version='NC_000011.10', start_position_on_the_genomic_accession=68008547, end_position_on_the_genomic_accession=68029276, orientation='plus', exon_count=11, OMIM=[600466], no_hdr0=''),
    222 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=222, CurrentID=0, Status='live', Symbol='ALDH3B2', Aliases=['ALDH8'], description='aldehyde dehydrogenase 3 family member B2', other_designations='aldehyde dehydrogenase family 3 member B2|acetaldehyde dehydrogenase 8|aldehyde dehydrogenase 8', map_location='11q13.2', chromosome='11', genomic_nucleotide_accession_version='NC_000011.10', start_position_on_the_genomic_accession=67662155, end_position_on_the_genomic_accession=67681224, orientation='minus', exon_count=12, OMIM=[601917], no_hdr0=''),
    223 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=223, CurrentID=0, Status='live', Symbol='ALDH9A1', Aliases=['ALDH4', 'ALDH7', 'ALDH9', 'E3', 'TMABA-DH', 'TMABADH', 'TMABALDH'], description='aldehyde dehydrogenase 9 family member A1', other_designations='4-trimethylaminobutyraldehyde dehydrogenase|R-aminobutyraldehyde dehydrogenase|aldehyde dehydrogenase (NAD+)|aldehyde dehydrogenase E3 isozyme|aldehyde dehydrogenase family 9 member A1|gamma-aminobutyraldehyde dehydrogenase', map_location='1q24.1', chromosome='1', genomic_nucleotide_accession_version='NC_000001.11', start_position_on_the_genomic_accession=165662212, end_position_on_the_genomic_accession=165698663, orientation='minus', exon_count=11, OMIM=[602733], no_hdr0=''),
    224 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=224, CurrentID=0, Status='live', Symbol='ALDH3A2', Aliases=['ALDH10', 'FALDH', 'SLS'], description='aldehyde dehydrogenase 3 family member A2', other_designations='aldehyde dehydrogenase family 3 member A2|aldehyde dehydrogenase 10|fatty aldehyde dehydrogenase|microsomal aldehyde dehydrogenase', map_location='17p11.2', chromosome='17', genomic_nucleotide_accession_version='NC_000017.11', start_position_on_the_genomic_accession=19648136, end_position_on_the_genomic_accession=19677596, orientation='plus', exon_count=14, OMIM=[609523], no_hdr0=''),
    225 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=225, CurrentID=0, Status='live', Symbol='ABCD2', Aliases=['ABC39', 'ALDL1', 'ALDR', 'ALDRP', 'hALDR'], description='ATP binding cassette subfamily D member 2', other_designations='ATP-binding cassette sub-family D member 2|ATP-binding cassette, sub-family D (ALD), member 2|adrenoleukodystrophy-like 1|adrenoleukodystrophy-related protein', map_location='12q12', chromosome='12', genomic_nucleotide_accession_version='NC_000012.12', start_position_on_the_genomic_accession=39530965, end_position_on_the_genomic_accession=39651333, orientation='minus', exon_count=13, OMIM=[601081], no_hdr0=''),
    226 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=226, CurrentID=0, Status='live', Symbol='ALDOA', Aliases=['ALDA', 'GSD12', 'HEL-S-87p'], description='aldolase, fructose-bisphosphate A', other_designations='fructose-bisphosphate aldolase A|aldolase A, fructose-bisphosphate|epididymis secretory sperm binding protein Li 87p|fructose-1,6-bisphosphate triosephosphate-lyase|lung cancer antigen NY-LU-1|muscle-type aldolase', map_location='16p11.2', chromosome='16', genomic_nucleotide_accession_version='NC_000016.10', start_position_on_the_genomic_accession=30064279, end_position_on_the_genomic_accession=30070420, orientation='plus', exon_count=11, OMIM=[103850], no_hdr0=''),
    229 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=229, CurrentID=0, Status='live', Symbol='ALDOB', Aliases=['ALDB', 'ALDO2'], description='aldolase, fructose-bisphosphate B', other_designations='fructose-bisphosphate aldolase B|aldolase 2|aldolase B, fructose-bisphosphatase|aldolase B, fructose-bisphosphate|liver-type aldolase', map_location='9q31.1', chromosome='9', genomic_nucleotide_accession_version='NC_000009.12', start_position_on_the_genomic_accession=101420560, end_position_on_the_genomic_accession=101435774, orientation='minus', exon_count=9, OMIM=[612724], no_hdr0=''),
    230 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=230, CurrentID=0, Status='live', Symbol='ALDOC', Aliases=['ALDC'], description='aldolase, fructose-bisphosphate C', other_designations='fructose-bisphosphate aldolase C|aldolase 3|aldolase C, fructose-bisphosphate|brain-type aldolase|epididymis secretory sperm binding protein|fructoaldolase C|fructose-1,6-biphosphate triosephosphate lyase', map_location='17q11.2', chromosome='17', genomic_nucleotide_accession_version='NC_000017.11', start_position_on_the_genomic_accession=28573115, end_position_on_the_genomic_accession=28576963, orientation='minus', exon_count=10, OMIM=[103870], no_hdr0=''),
    231 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=231, CurrentID=0, Status='live', Symbol='AKR1B1', Aliases=['ADR', 'ALDR1', 'ALR2', 'AR'], description='aldo-keto reductase family 1 member B', other_designations='aldo-keto reductase family 1 member B1|Lii5-2 CTCL tumor antigen|aldehyde reductase 1|aldose reductase|low Km aldose reductase', map_location='7q33', chromosome='7', genomic_nucleotide_accession_version='NC_000007.14', start_position_on_the_genomic_accession=134442350, end_position_on_the_genomic_accession=134459239, orientation='minus', exon_count=11, OMIM=[103880], no_hdr0=''),
    238 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=238, CurrentID=0, Status='live', Symbol='ALK', Aliases=['CD246', 'NBLST3'], description='ALK receptor tyrosine kinase', other_designations='ALK tyrosine kinase receptor|CD246 antigen|anaplastic lymphoma receptor tyrosine kinase|mutant anaplastic lymphoma kinase', map_location='2p23.2-p23.1', chromosome='2', genomic_nucleotide_accession_version='NC_000002.12', start_position_on_the_genomic_accession=29190992, end_position_on_the_genomic_accession=29921589, orientation='minus', exon_count=29, OMIM=[105590], no_hdr0=''),
    239 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=239, CurrentID=0, Status='live', Symbol='ALOX12', Aliases=['12-LOX', '12S-LOX', 'LOG12'], description='arachidonate 12-lipoxygenase, 12S type', other_designations='polyunsaturated fatty acid lipoxygenase ALOX12|12S-lipoxygenase|Arachidonate 12-lipoxygenase, 12S-type|arachidonate (12S)-lipoxygenase|arachidonate (15S)-lipoxygenase|arachidonate 15-lipoxygenase,15S-type|linoleate 13S-lipoxygenase|lipoxin synthase 12-LO|platelet 12-LOX|platelet-type 12-lipoxygenase|platelet-type lipoxygenase 12', map_location='17p13.1', chromosome='17', genomic_nucleotide_accession_version='NC_000017.11', start_position_on_the_genomic_accession=6993791, end_position_on_the_genomic_accession=7010754, orientation='plus', exon_count=14, OMIM=[152391], no_hdr0=''),
    240 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=240, CurrentID=0, Status='live', Symbol='ALOX5', Aliases=['5-LO', '5-LOX', '5LPG', 'LOG5'], description='arachidonate 5-lipoxygenase', other_designations='polyunsaturated fatty acid 5-lipoxygenase|LOX-5|arachidonic acid 5-lipoxygenase|leukotriene A4 synthase', map_location='10q11.21', chromosome='10', genomic_nucleotide_accession_version='NC_000010.11', start_position_on_the_genomic_accession=45374209, end_position_on_the_genomic_accession=45446121, orientation='plus', exon_count=13, OMIM=[152390], no_hdr0=''),
    241 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=241, CurrentID=0, Status='live', Symbol='ALOX5AP', Aliases=['FLAP'], description='arachidonate 5-lipoxygenase activating protein', other_designations='arachidonate 5-lipoxygenase-activating protein|MK-886-binding protein', map_location='13q12.3', chromosome='13', genomic_nucleotide_accession_version='NC_000013.11', start_position_on_the_genomic_accession=30713485, end_position_on_the_genomic_accession=30764426, orientation='plus', exon_count=7, OMIM=[603700], no_hdr0=''),
    242 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=242, CurrentID=0, Status='live', Symbol='ALOX12B', Aliases=['12R-LOX', 'ARCI2'], description='arachidonate 12-lipoxygenase, 12R type', other_designations='arachidonate 12-lipoxygenase, 12R-type|12R-lipoxygenase|epidermis-type lipoxygenase 12', map_location='17p13.1', chromosome='17', genomic_nucleotide_accession_version='NC_000017.11', start_position_on_the_genomic_accession=8072636, end_position_on_the_genomic_accession=8087716, orientation='minus', exon_count=15, OMIM=[603741], no_hdr0=''),
    246 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=246, CurrentID=0, Status='live', Symbol='ALOX15', Aliases=['12-LOX', '15-LOX', '15-LOX-1', 'LOG15'], description='arachidonate 15-lipoxygenase', other_designations='polyunsaturated fatty acid lipoxygenase ALOX15|12/15-lipoxygenase|15-LOX type 1|15-lipooxygenase-1|15-lipoxygenase type 1|arachidonate 12-lipoxygenase, leukocyte-type|arachidonate omega-6 lipoxygenase|hepoxilin A3 synthase Alox15|linoleate 13S-lipoxygenase', map_location='17p13.2', chromosome='17', genomic_nucleotide_accession_version='NC_000017.11', start_position_on_the_genomic_accession=4630919, end_position_on_the_genomic_accession=4641678, orientation='minus', exon_count=14, OMIM=[152392], no_hdr0=''),
    247 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=247, CurrentID=0, Status='live', Symbol='ALOX15B', Aliases=['15-LOX-2'], description='arachidonate 15-lipoxygenase type B', other_designations='polyunsaturated fatty acid lipoxygenase ALOX15B|15-LOX-B|15S-lipoxygenase|arachidonate 15-lipoxygenase 2|arachidonate 15-lipoxygenase type II|arachidonate 15-lipoxygenase, second type|arachidonate omega(6) lipoxygenase|linoleate 13-lipoxygenase 15-LOb', map_location='17p13.1', chromosome='17', genomic_nucleotide_accession_version='NC_000017.11', start_position_on_the_genomic_accession=8039059, end_position_on_the_genomic_accession=8049134, orientation='plus', exon_count=14, OMIM=[603697], no_hdr0=''),
    248 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=248, CurrentID=0, Status='live', Symbol='ALPI', Aliases=['IAP'], description='alkaline phosphatase, intestinal', other_designations='intestinal-type alkaline phosphatase|Kasahara isozyme|alkaline phosphomonoesterase|glycerophosphatase|intestinal alkaline phosphatase', map_location='2q37.1', chromosome='2', genomic_nucleotide_accession_version='NC_000002.12', start_position_on_the_genomic_accession=232456153, end_position_on_the_genomic_accession=232460753, orientation='plus', exon_count=11, OMIM=[171740], no_hdr0=''),
    249 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=249, CurrentID=0, Status='live', Symbol='ALPL', Aliases=['AP-TNAP', 'APTNAP', 'HOPS', 'TNALP', 'TNAP', 'TNSALP'], description='alkaline phosphatase, biomineralization associated', other_designations='alkaline phosphatase, tissue-nonspecific isozyme|alkaline phosphatase liver/bone/kidney isozyme|alkaline phosphatase, liver/bone/kidney|liver/bone/kidney-type alkaline phosphatase|tissue non-specific alkaline phosphatase|tissue-nonspecific ALP', map_location='1p36.12', chromosome='1', genomic_nucleotide_accession_version='NC_000001.11', start_position_on_the_genomic_accession=21508984, end_position_on_the_genomic_accession=21578412, orientation='plus', exon_count=14, OMIM=[171760], no_hdr0=''),
    250 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=250, CurrentID=0, Status='live', Symbol='ALPP', Aliases=['ALP', 'ALPI', 'IAP', 'PALP', 'PLAP', 'PLAP-1'], description='alkaline phosphatase, placental', other_designations='alkaline phosphatase, placental type|Intestinal alkaline phosphatase|Intestinal-type alkaline phosphatase|alkaline phosphatase Regan isozyme|alkaline phosphomonoesterase|glycerophosphatase|placental alkaline phosphatase 1', map_location='2q37.1', chromosome='2', genomic_nucleotide_accession_version='NC_000002.12', start_position_on_the_genomic_accession=232378751, end_position_on_the_genomic_accession=232382889, orientation='plus', exon_count=11, OMIM=[171800], no_hdr0=''),
    251 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=251, CurrentID=0, Status='live', Symbol='ALPG', Aliases=['ALPPL', 'ALPPL2', 'GCAP'], description='alkaline phosphatase, germ cell', other_designations='alkaline phosphatase, germ cell type|ALP-1|Nagao isozyme|alkaline phosphatase Nagao isozyme|alkaline phosphatase, placental like 2|alkaline phosphatase, placental-like|germ cell alkaline phosphatase|placental-like alkaline phosphatase|testicular and thymus alkaline phosphatase', map_location='2q37.1', chromosome='2', genomic_nucleotide_accession_version='NC_000002.12', start_position_on_the_genomic_accession=232406844, end_position_on_the_genomic_accession=232410714, orientation='plus', exon_count=11, OMIM=[171810], no_hdr0=''),
    257 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=257, CurrentID=0, Status='live', Symbol='ALX3', Aliases=['FND', 'FND1'], description='ALX homeobox 3', other_designations='homeobox protein aristaless-like 3|aristaless-like homeobox 3|frontonasal dysplasia|proline-rich transcription factor ALX3', map_location='1p13.3', chromosome='1', genomic_nucleotide_accession_version='NC_000001.11', start_position_on_the_genomic_accession=110059870, end_position_on_the_genomic_accession=110070672, orientation='minus', exon_count=4, OMIM=[606014], no_hdr0=''),
    258 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=258, CurrentID=0, Status='live', Symbol='AMBN', Aliases=['AI1F'], description='ameloblastin', other_designations='ameloblastin|enamel matrix protein', map_location='4q13.3', chromosome='4', genomic_nucleotide_accession_version='NC_000004.12', start_position_on_the_genomic_accession=70592256, end_position_on_the_genomic_accession=70607288, orientation='plus', exon_count=13, OMIM=[601259], no_hdr0=''),
    259 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=259, CurrentID=0, Status='live', Symbol='AMBP', Aliases=['A1M', 'EDC1', 'HCP', 'HI30', 'IATIL', 'ITI', 'ITIL', 'ITILC', 'UTI'], description='alpha-1-microglobulin/bikunin precursor', other_designations='protein AMBP|bikunin|complex-forming glycoprotein heterogeneous in charge|growth-inhibiting protein 19|inter-alpha-trypsin inhibitor light chain|protein HC|trypstatin|uristatin|uronic-acid-rich protein', map_location='9q32', chromosome='9', genomic_nucleotide_accession_version='NC_000009.12', start_position_on_the_genomic_accession=114060127, end_position_on_the_genomic_accession=114078300, orientation='minus', exon_count=10, OMIM=[176870], no_hdr0=''),
    262 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=262, CurrentID=0, Status='live', Symbol='AMD1', Aliases=['ADOMETDC', 'AMD', 'SAMDC'], description='adenosylmethionine decarboxylase 1', other_designations='S-adenosylmethionine decarboxylase proenzyme|S-adenosylmethionine decarboxylase 1', map_location='6q21', chromosome='6', genomic_nucleotide_accession_version='NC_000006.12', start_position_on_the_genomic_accession=110814617, end_position_on_the_genomic_accession=110895713, orientation='plus', exon_count=10, OMIM=[180980], no_hdr0=''),
    265 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=265, CurrentID=0, Status='live', Symbol='AMELX', Aliases=['AI1E', 'AIH1', 'ALGN', 'AMG', 'AMGL', 'AMGX'], description='amelogenin X-linked', other_designations='amelogenin, X isoform|amelogenin (X chromosome, amelogenesis imperfecta 1)|amelogenin (amelogenesis imperfecta 1, X-linked)', map_location='Xp22.2', chromosome='X', genomic_nucleotide_accession_version='NC_000023.11', start_position_on_the_genomic_accession=11293413, end_position_on_the_genomic_accession=11304149, orientation='plus', exon_count=7, OMIM=[300391], no_hdr0=''),
    266 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=266, CurrentID=0, Status='live', Symbol='AMELY', Aliases=['AMGL', 'AMGY'], description='amelogenin Y-linked', other_designations='amelogenin, Y isoform|amelogenin (Y chromosome)', map_location='Yp11.2', chromosome='Y', genomic_nucleotide_accession_version='NC_000024.10', start_position_on_the_genomic_accession=6865918, end_position_on_the_genomic_accession=6874027, orientation='minus', exon_count=7, OMIM=[410000], no_hdr0=''),
    267 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=267, CurrentID=0, Status='live', Symbol='AMFR', Aliases=['GP78', 'RNF45'], description='autocrine motility factor receptor', other_designations='E3 ubiquitin-protein ligase AMFR|RING finger protein 45|RING-type E3 ubiquitin transferase AMFR', map_location='16q13', chromosome='16', genomic_nucleotide_accession_version='NC_000016.10', start_position_on_the_genomic_accession=56361452, end_position_on_the_genomic_accession=56425545, orientation='minus', exon_count=17, OMIM=[603243], no_hdr0=''),
    268 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=268, CurrentID=0, Status='live', Symbol='AMH', Aliases=['MIF', 'MIS'], description='anti-Mullerian hormone', other_designations='muellerian-inhibiting factor|Mullerian inhibiting factor|Mullerian inhibiting substance|anti-Muellerian hormone|muellerian-inhibiting substance', map_location='19p13.3', chromosome='19', genomic_nucleotide_accession_version='NC_000019.10', start_position_on_the_genomic_accession=2249323, end_position_on_the_genomic_accession=2252073, orientation='plus', exon_count=5, OMIM=[600957], no_hdr0=''),
    269 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=269, CurrentID=0, Status='live', Symbol='AMHR2', Aliases=['AMHR', 'MISR2', 'MISRII', 'MRII'], description='anti-Mullerian hormone receptor type 2', other_designations='anti-Muellerian hormone type-2 receptor|AMH type II receptor|MIS type II receptor|Muellerian inhibiting substance type II receptor|Mullerian inhibiting substance type II receptor|anti-Muellerian hormone type II receptor|anti-Mullerian hormone receptor, type II', map_location='12q13.13', chromosome='12', genomic_nucleotide_accession_version='NC_000012.12', start_position_on_the_genomic_accession=53423855, end_position_on_the_genomic_accession=53431672, orientation='plus', exon_count=13, OMIM=[600956], no_hdr0=''),
    270 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=270, CurrentID=0, Status='live', Symbol='AMPD1', Aliases=['MAD', 'MADA', 'MMDD'], description='adenosine monophosphate deaminase 1', other_designations='AMP deaminase 1|AMPD|adenosine monophosphate deaminase 1 (isoform M)|adenosine monophosphate deaminase-1 (muscle)|myoadenylate deaminase|skeletal muscle AMPD', map_location='1p13.2', chromosome='1', genomic_nucleotide_accession_version='NC_000001.11', start_position_on_the_genomic_accession=114673098, end_position_on_the_genomic_accession=114695618, orientation='minus', exon_count=16, OMIM=[102770], no_hdr0=''),
    271 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=271, CurrentID=0, Status='live', Symbol='AMPD2', Aliases=['PCH9', 'SPG63'], description='adenosine monophosphate deaminase 2', other_designations='AMP deaminase 2|AMPD|adenosine monophosphate deaminase 2 (isoform L)', map_location='1p13.3', chromosome='1', genomic_nucleotide_accession_version='NC_000001.11', start_position_on_the_genomic_accession=109619837, end_position_on_the_genomic_accession=109632055, orientation='plus', exon_count=20, OMIM=[102771], no_hdr0=''),
    272 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=272, CurrentID=0, Status='live', Symbol='AMPD3', Aliases=[], description='adenosine monophosphate deaminase 3', other_designations='AMP deaminase 3|AMP aminohydrolase|adenosine monophosphate deaminase (isoform E)|erythrocyte AMP deaminase|erythrocyte type AMP deaminase|erythrocyte-specific AMP deaminase|myoadenylate deaminase', map_location='11p15.4', chromosome='11', genomic_nucleotide_accession_version='NC_000011.10', start_position_on_the_genomic_accession=10450388, end_position_on_the_genomic_accession=10507579, orientation='plus', exon_count=19, OMIM=[102772], no_hdr0=''),
    273 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=273, CurrentID=0, Status='live', Symbol='AMPH', Aliases=['AMPH1'], description='amphiphysin', other_designations='amphiphysin|amphiphysin (Stiff-Mann syndrome with breast cancer 128kD autoantigen)|amphiphysin I', map_location='7p14.1', chromosome='7', genomic_nucleotide_accession_version='NC_000007.14', start_position_on_the_genomic_accession=38383694, end_position_on_the_genomic_accession=38631497, orientation='minus', exon_count=23, OMIM=[600418], no_hdr0=''),
    274 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=274, CurrentID=0, Status='live', Symbol='BIN1', Aliases=['AMPH2', 'AMPHL', 'CNM2', 'SH3P9'], description='bridging integrator 1', other_designations='myc box-dependent-interacting protein 1|amphiphysin II|amphiphysin-like protein|box dependant MYC interacting protein 1|box-dependent myc-interacting protein 1', map_location='2q14.3', chromosome='2', genomic_nucleotide_accession_version='NC_000002.12', start_position_on_the_genomic_accession=127048023, end_position_on_the_genomic_accession=127107154, orientation='minus', exon_count=22, OMIM=[601248], no_hdr0=''),
    275 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=275, CurrentID=0, Status='live', Symbol='AMT', Aliases=['GCE', 'GCST', 'GCVT', 'NKH'], description='aminomethyltransferase', other_designations='aminomethyltransferase, mitochondrial|glycine cleavage system T protein|nonketotic hyperglycinemia', map_location='3p21.31', chromosome='3', genomic_nucleotide_accession_version='NC_000003.12', start_position_on_the_genomic_accession=49416778, end_position_on_the_genomic_accession=49422473, orientation='minus', exon_count=9, OMIM=[238310], no_hdr0=''),
    276 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=276, CurrentID=0, Status='live', Symbol='AMY1A', Aliases=['AMY1'], description='amylase alpha 1A', other_designations='alpha-amylase 1|1,4-alpha-D-glucan glucanohydrolase 1|amylase alpha 1A (salivary)|amylase, salivary, alpha-1A|glycogenase|salivary alpha-amylase|salivary amylase alpha 1A', map_location='1p21.1', chromosome='1', genomic_nucleotide_accession_version='NC_000001.11', start_position_on_the_genomic_accession=103655519, end_position_on_the_genomic_accession=103664551, orientation='plus', exon_count=11, OMIM=[104700], no_hdr0=''),
    277 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=277, CurrentID=0, Status='live', Symbol='AMY1B', Aliases=['AMY1'], description='amylase alpha 1B', other_designations='alpha-amylase 1|1,4-alpha-D-glucan glucanohydrolase 1|amylase alpha 1B (salivary)|amylase, salivary, alpha-1B|glycogenase|salivary alpha-amylase|salivary amylase alpha 1B', map_location='1p21.1', chromosome='1', genomic_nucleotide_accession_version='NC_000001.11', start_position_on_the_genomic_accession=103687415, end_position_on_the_genomic_accession=103696452, orientation='minus', exon_count=12, OMIM=[104701], no_hdr0=''),
    278 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=278, CurrentID=0, Status='live', Symbol='AMY1C', Aliases=['AMY1'], description='amylase alpha 1C', other_designations='alpha-amylase 1|1,4-alpha-D-glucan glucanohydrolase 1|amylase alpha 1C (salivary)|amylase, salivary, alpha-1C|glycogenase|salivary alpha-amylase|salivary amylase alpha 1C', map_location='1p21.1', chromosome='1', genomic_nucleotide_accession_version='NC_000001.11', start_position_on_the_genomic_accession=103745430, end_position_on_the_genomic_accession=103758692, orientation='plus', exon_count=12, OMIM=[104702], no_hdr0=''),
    279 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=279, CurrentID=0, Status='live', Symbol='AMY2A', Aliases=['AMY2', 'PA'], description='amylase alpha 2A', other_designations='pancreatic alpha-amylase|1,4-alpha-D-glucan glucanohydrolase|amylase alpha 2A (pancreatic)|glycogenase|pancreatic amylase alpha 2A', map_location='1p21.1', chromosome='1', genomic_nucleotide_accession_version='NC_000001.11', start_position_on_the_genomic_accession=103617332, end_position_on_the_genomic_accession=103625780, orientation='plus', exon_count=10, OMIM=[104650], no_hdr0=''),
    280 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=280, CurrentID=0, Status='live', Symbol='AMY2B', Aliases=['AMY2', 'AMY3', 'HXA'], description='amylase alpha 2B', other_designations='alpha-amylase 2B|1,4-alpha-D-glucan glucanohydrolase 2B|amylase alpha 2B (pancreatic)|carcinoid alpha-amylase|glycogenase', map_location='1p21.1', chromosome='1', genomic_nucleotide_accession_version='NC_000001.11', start_position_on_the_genomic_accession=103554644, end_position_on_the_genomic_accession=103579534, orientation='plus', exon_count=13, OMIM=[104660], no_hdr0=''),
    283 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=283, CurrentID=0, Status='live', Symbol='ANG', Aliases=['ALS9', 'HEL168', 'RAA1', 'RNASE4', 'RNASE5'], description='angiogenin', other_designations='angiogenin|RNase 5|angiogenin, ribonuclease, RNase A family, 5|epididymis luminal protein 168|ribonuclease 5|ribonuclease A A1|ribonuclease A family member 5', map_location='14q11.2', chromosome='14', genomic_nucleotide_accession_version='NC_000014.9', start_position_on_the_genomic_accession=20684177, end_position_on_the_genomic_accession=20694186, orientation='plus', exon_count=4, OMIM=[105850], no_hdr0=''),
    284 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=284, CurrentID=0, Status='live', Symbol='ANGPT1', Aliases=['AGP1', 'AGPT', 'ANG1'], description='angiopoietin 1', other_designations='angiopoietin-1|ANG-1', map_location='8q23.1', chromosome='8', genomic_nucleotide_accession_version='NC_000008.11', start_position_on_the_genomic_accession=107249482, end_position_on_the_genomic_accession=107497918, orientation='minus', exon_count=10, OMIM=[601667], no_hdr0=''),
    285 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=285, CurrentID=0, Status='live', Symbol='ANGPT2', Aliases=['AGPT2', 'ANG2'], description='angiopoietin 2', other_designations='angiopoietin-2|Tie2-ligand|angiopoietin-2B|angiopoietin-2a', map_location='8p23.1', chromosome='8', genomic_nucleotide_accession_version='NC_000008.11', start_position_on_the_genomic_accession=6499632, end_position_on_the_genomic_accession=6563420, orientation='minus', exon_count=9, OMIM=[601922], no_hdr0=''),
    286 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=286, CurrentID=0, Status='live', Symbol='ANK1', Aliases=['ANK', 'SPH1', 'SPH2'], description='ankyrin 1', other_designations='ankyrin-1|ANK-1|ankyrin 1, erythrocytic|ankyrin-R|erythrocyte ankyrin', map_location='8p11.21', chromosome='8', genomic_nucleotide_accession_version='NC_000008.11', start_position_on_the_genomic_accession=41653225, end_position_on_the_genomic_accession=41896741, orientation='minus', exon_count=49, OMIM=[612641], no_hdr0=''),
    287 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=287, CurrentID=0, Status='live', Symbol='ANK2', Aliases=['ANK-2', 'CFAP87', 'FAP87', 'LQT4', 'brank-2'], description='ankyrin 2', other_designations='ankyrin-2|ankyrin 2, neuronal|ankyrin B|ankyrin, brain|ankyrin-2, nonerythrocytic|non-erythroid ankyrin', map_location='4q25-q26', chromosome='4', genomic_nucleotide_accession_version='NC_000004.12', start_position_on_the_genomic_accession=112705622, end_position_on_the_genomic_accession=113383736, orientation='plus', exon_count=61, OMIM=[106410], no_hdr0=''),
    288 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=288, CurrentID=0, Status='live', Symbol='ANK3', Aliases=['ANKYRIN-G', 'MRT37'], description='ankyrin 3', other_designations='ankyrin-3|ankyrin 3, node of Ranvier (ankyrin G)', map_location='10q21.2', chromosome='10', genomic_nucleotide_accession_version='NC_000010.11', start_position_on_the_genomic_accession=60026298, end_position_on_the_genomic_accession=60733528, orientation='minus', exon_count=52, OMIM=[600465], no_hdr0=''),
    290 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=290, CurrentID=0, Status='live', Symbol='ANPEP', Aliases=['APN', 'CD13', 'GP150', 'LAP1', 'P150', 'PEPN'], description='alanyl aminopeptidase, membrane', other_designations='aminopeptidase N|AP-M|AP-N|alanyl (membrane) aminopeptidase|aminopeptidase M|hAPN|membrane alanyl aminopeptidase|microsomal aminopeptidase|myeloid plasma membrane glycoprotein CD13', map_location='15q26.1', chromosome='15', genomic_nucleotide_accession_version='NC_000015.10', start_position_on_the_genomic_accession=89784895, end_position_on_the_genomic_accession=89814852, orientation='minus', exon_count=21, OMIM=[151530], no_hdr0=''),
    291 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=291, CurrentID=0, Status='live', Symbol='SLC25A4', Aliases=['AAC1', 'ANT', 'ANT 1', 'ANT1', 'MTDPS12', 'MTDPS12A', 'PEO2', 'PEO3', 'PEOA2', 'T1'], description='solute carrier family 25 member 4', other_designations='ADP/ATP translocase 1|ADP,ATP carrier protein 1|ADP,ATP carrier protein, heart/skeletal muscle|adenine nucleotide translocator 1 (skeletal muscle)|heart/skeletal muscle ATP/ADP translocator|solute carrier family 25 (mitochondrial carrier; adenine nucleotide translocator), member 4', map_location='4q35.1', chromosome='4', genomic_nucleotide_accession_version='NC_000004.12', start_position_on_the_genomic_accession=185143266, end_position_on_the_genomic_accession=185150382, orientation='plus', exon_count=4, OMIM=[103220], no_hdr0=''),
    292 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=292, CurrentID=0, Status='live', Symbol='SLC25A5', Aliases=['2F1', 'AAC2', 'ANT2', 'T2', 'T3'], description='solute carrier family 25 member 5', other_designations='ADP/ATP translocase 2|adenine nucleotide translocator 2 (fibroblast)|solute carrier family 25 (mitochondrial carrier; adenine nucleotide translocator), member 5', map_location='Xq24', chromosome='X', genomic_nucleotide_accession_version='NC_000023.11', start_position_on_the_genomic_accession=119468444, end_position_on_the_genomic_accession=119471396, orientation='plus', exon_count=4, OMIM=[300150], no_hdr0=''),
    293 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=293, CurrentID=0, Status='live', Symbol='SLC25A6', Aliases=['AAC3', 'ANT', 'ANT 2', 'ANT 3', 'ANT3', 'ANT3Y'], description='solute carrier family 25 member 6', other_designations='ADP/ATP translocase 3|ADP,ATP carrier protein 3|ADP,ATP carrier protein, liver|ADP/ATP translocator of liver|adenine nucleotide translocator 3|epididymis secretory sperm binding protein|solute carrier family 25 (mitochondrial carrier; adenine nucleotide translocator), member 6', map_location='Xp22.32 and Yp11.3', chromosome='X', genomic_nucleotide_accession_version='NC_000023.11', start_position_on_the_genomic_accession=1386152, end_position_on_the_genomic_accession=1392113, orientation='minus', exon_count=4, OMIM=[300151, 403000], no_hdr0=''),
    301 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=301, CurrentID=0, Status='live', Symbol='ANXA1', Aliases=['ANX1', 'LPC1'], description='annexin A1', other_designations='annexin A1|annexin I (lipocortin I)|annexin-1|calpactin II|calpactin-2|chromobindin-9|epididymis secretory sperm binding protein|phospholipase A2 inhibitory protein', map_location='9q21.13', chromosome='9', genomic_nucleotide_accession_version='NC_000009.12', start_position_on_the_genomic_accession=73151865, end_position_on_the_genomic_accession=73170393, orientation='plus', exon_count=15, OMIM=[151690], no_hdr0=''),
    302 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=302, CurrentID=0, Status='live', Symbol='ANXA2', Aliases=['ANX2', 'ANX2L4', 'CAL1H', 'HEL-S-270', 'LIP2', 'LPC2', 'LPC2D', 'P36', 'PAP-IV'], description='annexin A2', other_designations='annexin A2|annexin II|annexin-2|calpactin I heavy chain|calpactin I heavy polypeptide|calpactin-1 heavy chain|chromobindin 8|epididymis secretory protein Li 270|epididymis secretory sperm binding protein|lipocortin II|placental anticoagulant protein IV|protein I', map_location='15q22.2', chromosome='15', genomic_nucleotide_accession_version='NC_000015.10', start_position_on_the_genomic_accession=60347151, end_position_on_the_genomic_accession=60398025, orientation='minus', exon_count=16, OMIM=[151740], no_hdr0=''),
    306 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=306, CurrentID=0, Status='live', Symbol='ANXA3', Aliases=['ANX3'], description='annexin A3', other_designations='annexin A3|35-alpha calcimedin|Annexin III (lipocortin III)|PAP-III|annexin III (lipocortin III, 1,2-cyclic-inositol-phosphate phosphodiesterase, placental anticoagulant protein III, calcimedin 35-alpha)|annexin-3|calcimedin 35-alpha|inositol 1,2-cyclic phosphate 2-phosphohydrolase|lipocortin III|placental anticoagulant protein III', map_location='4q21.21', chromosome='4', genomic_nucleotide_accession_version='NC_000004.12', start_position_on_the_genomic_accession=78551761, end_position_on_the_genomic_accession=78610447, orientation='plus', exon_count=14, OMIM=[106490], no_hdr0=''),
    307 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=307, CurrentID=0, Status='live', Symbol='ANXA4', Aliases=['ANX4', 'HEL-S-274', 'P32.5', 'PAP-II', 'PIG28', 'PP4-X', 'ZAP36'], description='annexin A4', other_designations='annexin A4|35-beta calcimedin|annexin IV (placental anticoagulant protein II)|annexin-4|carbohydrate-binding protein p33/p41|chromobindin-4|endonexin I|epididymis secretory protein Li 274|lipocortin IV|placental anticoagulant protein II|proliferation-inducing gene 28|proliferation-inducing protein 28|protein II', map_location='2p13.3', chromosome='2', genomic_nucleotide_accession_version='NC_000002.12', start_position_on_the_genomic_accession=69643808, end_position_on_the_genomic_accession=69827112, orientation='plus', exon_count=20, OMIM=[106491], no_hdr0=''),
    308 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=308, CurrentID=0, Status='live', Symbol='ANXA5', Aliases=['ANX5', 'ENX2', 'HEL-S-7', 'PP4', 'RPRGL3'], description='annexin A5', other_designations='annexin A5|CBP-I|PAP-I|VAC-alpha|anchorin CII|annexin V|annexin-5|calphobindin I|endonexin II|epididymis secretory protein Li 7|lipocortin V|placental anticoagulant protein 4|placental anticoagulant protein I|thromboplastin inhibitor|vascular anticoagulant-alpha', map_location='4q27', chromosome='4', genomic_nucleotide_accession_version='NC_000004.12', start_position_on_the_genomic_accession=121667946, end_position_on_the_genomic_accession=121696994, orientation='minus', exon_count=14, OMIM=[131230], no_hdr0=''),
    309 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=309, CurrentID=0, Status='live', Symbol='ANXA6', Aliases=['ANX6', 'CBP68', 'CPB-II', 'p68', 'p70'], description='annexin A6', other_designations='annexin A6|67 kDa calelectrin|annexin VI (p68)|annexin-6|calcium-binding protein p68|calelectrin|calphobindin II|chromobindin-20|lipocortin VI|testis secretory sperm-binding protein Li 198a', map_location='5q33.1', chromosome='5', genomic_nucleotide_accession_version='NC_000005.10', start_position_on_the_genomic_accession=151100706, end_position_on_the_genomic_accession=151157779, orientation='minus', exon_count=27, OMIM=[114070], no_hdr0=''),
    310 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=310, CurrentID=0, Status='live', Symbol='ANXA7', Aliases=['ANX7', 'SNX', 'SYNEXIN'], description='annexin A7', other_designations='annexin A7|annexin VII|annexin-7', map_location='10q22.2', chromosome='10', genomic_nucleotide_accession_version='NC_000010.11', start_position_on_the_genomic_accession=73375101, end_position_on_the_genomic_accession=73414058, orientation='minus', exon_count=15, OMIM=[186360], no_hdr0=''),
    311 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=311, CurrentID=0, Status='live', Symbol='ANXA11', Aliases=['ALS23', 'ANX11', 'CAP-50', 'CAP50'], description='annexin A11', other_designations='annexin A11|56 kDa autoantigen|annexin XI|annexin-11|calcyclin-associated annexin 50|epididymis secretory sperm binding protein', map_location='10q22.3', chromosome='10', genomic_nucleotide_accession_version='NC_000010.11', start_position_on_the_genomic_accession=80150889, end_position_on_the_genomic_accession=80205808, orientation='minus', exon_count=20, OMIM=[602572], no_hdr0=''),
    312 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=312, CurrentID=0, Status='live', Symbol='ANXA13', Aliases=['ANX13', 'ISA'], description='annexin A13', other_designations='annexin A13|annexin XIII|annexin, intestine-specific|annexin-13|intestine-specific annexin', map_location='8q24.13', chromosome='8', genomic_nucleotide_accession_version='NC_000008.11', start_position_on_the_genomic_accession=123680794, end_position_on_the_genomic_accession=123737393, orientation='minus', exon_count=12, OMIM=[602573], no_hdr0=''),
    313 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=313, CurrentID=0, Status='live', Symbol='AOAH', Aliases=[], description='acyloxyacyl hydrolase', other_designations='acyloxyacyl hydrolase|acyloxyacyl hydrolase (neutrophil)', map_location='7p14.2', chromosome='7', genomic_nucleotide_accession_version='NC_000007.14', start_position_on_the_genomic_accession=36509313, end_position_on_the_genomic_accession=36724544, orientation='minus', exon_count=31, OMIM=[102593], no_hdr0=''),
    314 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=314, CurrentID=0, Status='live', Symbol='AOC2', Aliases=['DAO2', 'RAO', 'SSAO'], description='amine oxidase copper containing 2', other_designations='retina-specific copper amine oxidase|amine oxidase, copper containing 2 (retina-specific)|semicarbazide-sensitive amine oxidase', map_location='17q21.31', chromosome='17', genomic_nucleotide_accession_version='NC_000017.11', start_position_on_the_genomic_accession=42844580, end_position_on_the_genomic_accession=42850707, orientation='plus', exon_count=4, OMIM=[602268], no_hdr0=''),
    316 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=316, CurrentID=0, Status='live', Symbol='AOX1', Aliases=['AO', 'AOH1'], description='aldehyde oxidase 1', other_designations='aldehyde oxidase|azaheterocycle hydroxylase', map_location='2q33.1', chromosome='2', genomic_nucleotide_accession_version='NC_000002.12', start_position_on_the_genomic_accession=200585952, end_position_on_the_genomic_accession=200677064, orientation='plus', exon_count=36, OMIM=[602841], no_hdr0=''),
    317 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=317, CurrentID=0, Status='live', Symbol='APAF1', Aliases=['APAF-1', 'CED4'], description='apoptotic peptidase activating factor 1', other_designations='apoptotic protease-activating factor 1', map_location='12q23.1', chromosome='12', genomic_nucleotide_accession_version='NC_000012.12', start_position_on_the_genomic_accession=98645141, end_position_on_the_genomic_accession=98735433, orientation='plus', exon_count=28, OMIM=[602233], no_hdr0=''),
    318 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=318, CurrentID=0, Status='live', Symbol='NUDT2', Aliases=['APAH1'], description='nudix hydrolase 2', other_designations="bis(5'-nucleosyl)-tetraphosphatase [asymmetrical]|Ap4A hydrolase 1|Ap4Aase|bis(5'-nucleosyl)-tetraphosphatase (asymmetrical)|diadenosine 5',5'''-P1,P4-tetraphosphate asymmetrical hydrolase|diadenosine 5',5''-P1,P4-tetraphosphate pyrophosphohydrolase|diadenosine tetraphosphatase|nucleoside diphosphate-linked moiety X motif 2|nudix (nucleoside diphosphate linked moiety X)-type motif 2|nudix motif 2", map_location='9p13.3', chromosome='9', genomic_nucleotide_accession_version='NC_000009.12', start_position_on_the_genomic_accession=34329569, end_position_on_the_genomic_accession=34343713, orientation='plus', exon_count=6, OMIM=[602852], no_hdr0=''),
    319 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=319, CurrentID=0, Status='live', Symbol='APOF', Aliases=['Apo-F', 'LTIP'], description='apolipoprotein F', other_designations='apolipoprotein F|lipid transfer inhibitor protein', map_location='12q13.3', chromosome='12', genomic_nucleotide_accession_version='NC_000012.12', start_position_on_the_genomic_accession=56360568, end_position_on_the_genomic_accession=56362857, orientation='minus', exon_count=2, OMIM=[107760], no_hdr0=''),
    320 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=320, CurrentID=0, Status='live', Symbol='APBA1', Aliases=['D9S411E', 'LIN10', 'MINT1', 'X11', 'X11A', 'X11ALPHA'], description='amyloid beta precursor protein binding family A member 1', other_designations='amyloid-beta A4 precursor protein-binding family A member 1|adapter protein X11alpha|adaptor protein X11alpha|amyloid beta (A4) precursor protein-binding, family A, member 1 (X11)|mint-1|neuron-specific X11 protein|neuronal munc18-1-interacting protein 1|phosphotyrosine-binding/-interacting domain (PTB)-bearing protein', map_location='9q21.12', chromosome='9', genomic_nucleotide_accession_version='NC_000009.12', start_position_on_the_genomic_accession=69427532, end_position_on_the_genomic_accession=69673012, orientation='minus', exon_count=15, OMIM=[602414], no_hdr0=''),
    321 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=321, CurrentID=0, Status='live', Symbol='APBA2', Aliases=['D15S1518E', 'HsT16821', 'LIN-10', 'MGC:14091', 'MINT2', 'X11-BETA', 'X11L'], description='amyloid beta precursor protein binding family A member 2', other_designations='amyloid-beta A4 precursor protein-binding family A member 2|X11-like protein|adapter protein X11beta|amyloid beta (A4) precursor protein-binding, family A, member 2 (X11-like)|mint-2|neuron-specific X11L protein|neuronal munc18-1-interacting protein 2|phosphotyrosine-binding/-interacting domain (PTB)-bearing protein', map_location='15q13.1', chromosome='15', genomic_nucleotide_accession_version='NC_000015.10', start_position_on_the_genomic_accession=28885479, end_position_on_the_genomic_accession=29118315, orientation='plus', exon_count=23, OMIM=[602712], no_hdr0=''),
    322 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=322, CurrentID=0, Status='live', Symbol='APBB1', Aliases=['FE65', 'MGC:9072', 'RIR'], description='amyloid beta precursor protein binding family B member 1', other_designations='amyloid-beta A4 precursor protein-binding family B member 1|adaptor protein FE65a2|amyloid beta (A4) precursor protein-binding, family B, member 1 (Fe65)|stat-like protein', map_location='11p15.4', chromosome='11', genomic_nucleotide_accession_version='NC_000011.10', start_position_on_the_genomic_accession=6395124, end_position_on_the_genomic_accession=6419453, orientation='minus', exon_count=19, OMIM=[602709], no_hdr0=''),
    323 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=323, CurrentID=0, Status='live', Symbol='APBB2', Aliases=['FE65L', 'FE65L1'], description='amyloid beta precursor protein binding family B member 2', other_designations='amyloid-beta A4 precursor protein-binding family B member 2|Fe65-like 1|protein Fe65-like 1', map_location='4p14-p13', chromosome='4', genomic_nucleotide_accession_version='NC_000004.12', start_position_on_the_genomic_accession=40810027, end_position_on_the_genomic_accession=41216714, orientation='minus', exon_count=23, OMIM=[602710], no_hdr0=''),
    324 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=324, CurrentID=0, Status='live', Symbol='APC', Aliases=['BTPS2', 'DESMD', 'DP2', 'DP2.5', 'DP3', 'GS', 'PPP1R46'], description='APC regulator of WNT signaling pathway', other_designations='adenomatous polyposis coli protein|APC, WNT signaling pathway regulator|WNT signaling pathway regulator|adenomatosis polyposis coli tumor suppressor|adenomatous polyposis coli (APC)|deleted in polyposis 2.5|epididymis secretory sperm binding protein|protein phosphatase 1, regulatory subunit 46|truncated adenomatosis polyposis coli', map_location='5q22.2', chromosome='5', genomic_nucleotide_accession_version='NC_000005.10', start_position_on_the_genomic_accession=112707498, end_position_on_the_genomic_accession=112846239, orientation='plus', exon_count=20, OMIM=[611731], no_hdr0=''),
    325 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=325, CurrentID=0, Status='live', Symbol='APCS', Aliases=['HEL-S-92n', 'PTX2', 'SAP'], description='amyloid P component, serum', other_designations='serum amyloid P-component|9.5S alpha-1-glycoprotein|epididymis secretory sperm binding protein Li 92n|pentaxin-related|pentraxin-2|pentraxin-related', map_location='1q23.2', chromosome='1', genomic_nucleotide_accession_version='NC_000001.11', start_position_on_the_genomic_accession=159587826, end_position_on_the_genomic_accession=159588865, orientation='plus', exon_count=2, OMIM=[104770], no_hdr0=''),
    326 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=326, CurrentID=0, Status='live', Symbol='AIRE', Aliases=['AIRE1', 'APECED', 'APS1', 'APSI', 'PGA1'], description='autoimmune regulator', other_designations='autoimmune regulator|autoimmune polyendocrinopathy candidiasis ectodermal dystrophy protein', map_location='21q22.3', chromosome='21', genomic_nucleotide_accession_version='NC_000021.9', start_position_on_the_genomic_accession=44285876, end_position_on_the_genomic_accession=44298648, orientation='plus', exon_count=14, OMIM=[607358], no_hdr0=''),
    327 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=327, CurrentID=0, Status='live', Symbol='APEH', Aliases=['AARE', 'ACPH', 'APH', 'D3F15S2', 'D3S48E', 'DNF15S2', 'OPH'], description='acylaminoacyl-peptide hydrolase', other_designations='acylamino-acid-releasing enzyme|N-acylaminoacyl-peptide hydrolase|acyl-peptide hydrolase|acylaminoacyl-peptidase|oxidized protein hydrolase', map_location='3p21.31', chromosome='3', genomic_nucleotide_accession_version='NC_000003.12', start_position_on_the_genomic_accession=49673102, end_position_on_the_genomic_accession=49683971, orientation='plus', exon_count=22, OMIM=[102645], no_hdr0=''),
    328 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=328, CurrentID=0, Status='live', Symbol='APEX1', Aliases=['APE', 'APE1', 'APEN', 'APEX', 'APX', 'HAP1', 'REF1'], description='apurinic/apyrimidinic endodeoxyribonuclease 1', other_designations='DNA-(apurinic or apyrimidinic site) endonuclease|AP endonuclease class I|AP lyase|APEX nuclease (multifunctional DNA repair enzyme) 1|DNA-(apurinic or apyrimidinic site) lyase|apurinic-apyrimidinic endonuclease 1|apurinic/apyrimidinic (abasic) endonuclease|deoxyribonuclease (apurinic or apyrimidinic)|protein REF-1|redox factor-1', map_location='14q11.2', chromosome='14', genomic_nucleotide_accession_version='NC_000014.9', start_position_on_the_genomic_accession=20455226, end_position_on_the_genomic_accession=20457767, orientation='plus', exon_count=5, OMIM=[107748], no_hdr0=''),
    329 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=329, CurrentID=0, Status='live', Symbol='BIRC2', Aliases=['API1', 'HIAP2', 'Hiap-2', 'MIHB', 'RNF48', 'c-IAP1', 'cIAP1'], description='baculoviral IAP repeat containing 2', other_designations='baculoviral IAP repeat-containing protein 2|IAP homolog B|IAP-2|NFR2-TRAF signalling complex protein|RING finger protein 48|RING-type E3 ubiquitin transferase BIRC2|TNFR2-TRAF-signaling complex protein 2|apoptosis inhibitor 1|cellular inhibitor of apoptosis 1|inhibitor of apoptosis protein 2', map_location='11q22.2', chromosome='11', genomic_nucleotide_accession_version='NC_000011.10', start_position_on_the_genomic_accession=102347182, end_position_on_the_genomic_accession=102378670, orientation='plus', exon_count=9, OMIM=[601712], no_hdr0=''),
    330 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=330, CurrentID=0, Status='live', Symbol='BIRC3', Aliases=['AIP1', 'API2', 'CIAP2', 'HAIP1', 'HIAP1', 'IAP-1', 'MALT2', 'MIHC', 'RNF49', 'c-IAP2'], description='baculoviral IAP repeat containing 3', other_designations='baculoviral IAP repeat-containing protein 3|IAP homolog C|RING finger protein 49|RING-type E3 ubiquitin transferase BIRC3|TNFR2-TRAF signaling complex protein|TNFR2-TRAF-signaling complex protein 1|apoptosis inhibitor 2|cellular inhibitor of apoptosis 2|inhibitor of apoptosis protein 1|mammalian IAP homolog C', map_location='11q22.2', chromosome='11', genomic_nucleotide_accession_version='NC_000011.10', start_position_on_the_genomic_accession=102317373, end_position_on_the_genomic_accession=102339403, orientation='plus', exon_count=9, OMIM=[601721], no_hdr0=''),
    331 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=331, CurrentID=0, Status='live', Symbol='XIAP', Aliases=['API3', 'BIRC4', 'IAP-3', 'ILP1', 'MIHA', 'XLP2', 'hIAP-3', 'hIAP3'], description='X-linked inhibitor of apoptosis', other_designations='E3 ubiquitin-protein ligase XIAP|IAP-like protein 1|RING-type E3 ubiquitin transferase XIAP|X-linked IAP|X-linked inhibitor of apoptosis, E3 ubiquitin protein ligase|baculoviral IAP repeat-containing protein 4|inhibitor of apoptosis protein 3', map_location='Xq25', chromosome='X', genomic_nucleotide_accession_version='NC_000023.11', start_position_on_the_genomic_accession=123859708, end_position_on_the_genomic_accession=123913972, orientation='plus', exon_count=10, OMIM=[300079], no_hdr0=''),
    332 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=332, CurrentID=0, Status='live', Symbol='BIRC5', Aliases=['API4', 'EPR-1'], description='baculoviral IAP repeat containing 5', other_designations='baculoviral IAP repeat-containing protein 5|apoptosis inhibitor 4|apoptosis inhibitor survivin|survivin variant 3 alpha', map_location='17q25.3', chromosome='17', genomic_nucleotide_accession_version='NC_000017.11', start_position_on_the_genomic_accession=78214253, end_position_on_the_genomic_accession=78225635, orientation='plus', exon_count=6, OMIM=[603352], no_hdr0=''),
    333 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=333, CurrentID=0, Status='live', Symbol='APLP1', Aliases=['APLP'], description='amyloid beta precursor like protein 1', other_designations='amyloid-like protein 1|amyloid beta (A4) precursor-like protein 1|amyloid precursor-like protein 1', map_location='19q13.12', chromosome='19', genomic_nucleotide_accession_version='NC_000019.10', start_position_on_the_genomic_accession=35868570, end_position_on_the_genomic_accession=35879795, orientation='plus', exon_count=17, OMIM=[104775], no_hdr0=''),
    334 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=334, CurrentID=0, Status='live', Symbol='APLP2', Aliases=['APLP-2', 'APPH', 'APPL2', 'CDEBP'], description='amyloid beta precursor like protein 2', other_designations='amyloid-like protein 2|CDEI box-binding protein|amyloid beta (A4) precursor-like protein 2|amyloid precursor protein homolog HSD-2|testicular tissue protein Li 23', map_location='11q24.3', chromosome='11', genomic_nucleotide_accession_version='NC_000011.10', start_position_on_the_genomic_accession=130069894, end_position_on_the_genomic_accession=130144805, orientation='plus', exon_count=20, OMIM=[104776], no_hdr0=''),
    335 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=335, CurrentID=0, Status='live', Symbol='APOA1', Aliases=['HPALP2', 'apo(a)'], description='apolipoprotein A1', other_designations='apolipoprotein A-I|apo-AI|epididymis secretory sperm binding protein', map_location='11q23.3', chromosome='11', genomic_nucleotide_accession_version='NC_000011.10', start_position_on_the_genomic_accession=116835751, end_position_on_the_genomic_accession=116837950, orientation='minus', exon_count=4, OMIM=[107680], no_hdr0=''),
    336 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=336, CurrentID=0, Status='live', Symbol='APOA2', Aliases=['Apo-AII', 'ApoA-II', 'apoAII'], description='apolipoprotein A2', other_designations='apolipoprotein A-II', map_location='1q23.3', chromosome='1', genomic_nucleotide_accession_version='NC_000001.11', start_position_on_the_genomic_accession=161222292, end_position_on_the_genomic_accession=161223628, orientation='minus', exon_count=4, OMIM=[107670], no_hdr0=''),
    337 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=337, CurrentID=0, Status='live', Symbol='APOA4', Aliases=[], description='apolipoprotein A4', other_designations='apolipoprotein A-IV|apo-AIV|apoA-IV', map_location='11q23.3', chromosome='11', genomic_nucleotide_accession_version='NC_000011.10', start_position_on_the_genomic_accession=116820700, end_position_on_the_genomic_accession=116823304, orientation='minus', exon_count=3, OMIM=[107690], no_hdr0=''),
    338 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=338, CurrentID=0, Status='live', Symbol='APOB', Aliases=['FCHL2', 'FLDB', 'LDLCQ4', 'apoB-100', 'apoB-48'], description='apolipoprotein B', other_designations='apolipoprotein B-100|apolipoprotein B (including Ag(x) antigen)|apolipoprotein B48', map_location='2p24.1', chromosome='2', genomic_nucleotide_accession_version='NC_000002.12', start_position_on_the_genomic_accession=21001429, end_position_on_the_genomic_accession=21044073, orientation='minus', exon_count=29, OMIM=[107730], no_hdr0=''),
    339 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=339, CurrentID=0, Status='live', Symbol='APOBEC1', Aliases=['APOBEC-1', 'BEDP', 'CDAR1', 'HEPR'], description='apolipoprotein B mRNA editing enzyme catalytic subunit 1', other_designations='C->U-editing enzyme APOBEC-1|apolipoprotein B mRNA editing enzyme complex-1|apolipoprotein B mRNA editing enzyme, catalytic polypeptide 1|apolipoprotein B mRNA-editing enzyme 1|mRNA(cytosine(6666)) deaminase 1', map_location='12p13.31', chromosome='12', genomic_nucleotide_accession_version='NC_000012.12', start_position_on_the_genomic_accession=7649400, end_position_on_the_genomic_accession=7670599, orientation='minus', exon_count=6, OMIM=[600130], no_hdr0=''),
    341 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=341, CurrentID=0, Status='live', Symbol='APOC1', Aliases=['Apo-CI', 'ApoC-I', 'apo-CIB', 'apoC-IB'], description='apolipoprotein C1', other_designations='apolipoprotein C-I', map_location='19q13.32', chromosome='19', genomic_nucleotide_accession_version='NC_000019.10', start_position_on_the_genomic_accession=44914325, end_position_on_the_genomic_accession=44919346, orientation='plus', exon_count=5, OMIM=[107710], no_hdr0=''),
    343 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=343, CurrentID=0, Status='live', Symbol='AQP8', Aliases=['AQP-8'], description='aquaporin 8', other_designations='aquaporin-8', map_location='16p12.1', chromosome='16', genomic_nucleotide_accession_version='NC_000016.10', start_position_on_the_genomic_accession=25216917, end_position_on_the_genomic_accession=25228932, orientation='plus', exon_count=6, OMIM=[603750], no_hdr0=''),
    344 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=344, CurrentID=0, Status='live', Symbol='APOC2', Aliases=['APO-CII', 'APOC-II'], description='apolipoprotein C2', other_designations='apolipoprotein C-II', map_location='19q13.32', chromosome='19', genomic_nucleotide_accession_version='NC_000019.10', start_position_on_the_genomic_accession=44946051, end_position_on_the_genomic_accession=44949565, orientation='plus', exon_count=4, OMIM=[608083], no_hdr0=''),
    345 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=345, CurrentID=0, Status='live', Symbol='APOC3', Aliases=['APOCIII'], description='apolipoprotein C3', other_designations='apolipoprotein C-III', map_location='11q23.3', chromosome='11', genomic_nucleotide_accession_version='NC_000011.10', start_position_on_the_genomic_accession=116829907, end_position_on_the_genomic_accession=116833072, orientation='plus', exon_count=4, OMIM=[107720], no_hdr0=''),
    346 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=346, CurrentID=0, Status='live', Symbol='APOC4', Aliases=['APO-CIV', 'APOC-IV'], description='apolipoprotein C4', other_designations='apolipoprotein C-IV', map_location='19q13.32', chromosome='19', genomic_nucleotide_accession_version='NC_000019.10', start_position_on_the_genomic_accession=44942237, end_position_on_the_genomic_accession=44945496, orientation='plus', exon_count=3, OMIM=[600745], no_hdr0=''),
    347 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=347, CurrentID=0, Status='live', Symbol='APOD', Aliases=[], description='apolipoprotein D', other_designations='apolipoprotein D|apo-D', map_location='3q29', chromosome='3', genomic_nucleotide_accession_version='NC_000003.12', start_position_on_the_genomic_accession=195568705, end_position_on_the_genomic_accession=195583940, orientation='minus', exon_count=5, OMIM=[107740], no_hdr0=''),
    348 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=348, CurrentID=0, Status='live', Symbol='APOE', Aliases=['AD2', 'APO-E', 'ApoE4', 'LDLCQ5', 'LPG'], description='apolipoprotein E', other_designations='apolipoprotein E|apolipoprotein E3', map_location='19q13.32', chromosome='19', genomic_nucleotide_accession_version='NC_000019.10', start_position_on_the_genomic_accession=44905796, end_position_on_the_genomic_accession=44909393, orientation='plus', exon_count=6, OMIM=[107741], no_hdr0=''),
    350 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=350, CurrentID=0, Status='live', Symbol='APOH', Aliases=['B2G1', 'B2GP1', 'BG'], description='apolipoprotein H', other_designations='beta-2-glycoprotein 1|APC inhibitor|B2GPI|activated protein C-binding protein|anticardiolipin cofactor|apo-H|apolipoprotein H (beta-2-glycoprotein I)|beta(2)GPI|epididymis secretory sperm binding protein', map_location='17q24.2', chromosome='17', genomic_nucleotide_accession_version='NC_000017.11', start_position_on_the_genomic_accession=66212033, end_position_on_the_genomic_accession=66229415, orientation='minus', exon_count=8, OMIM=[138700], no_hdr0=''),
    351 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=351, CurrentID=0, Status='live', Symbol='APP', Aliases=['AAA', 'ABETA', 'ABPP', 'AD1I', 'CTFgamma', 'CVAP', 'PN-II', 'PN2', 'preA4', 'APP'], description='amyloid beta precursor protein', other_designations='amyloid-beta precursor protein|alzheimer disease amyloid protein|amyloid beta (A4) precursor protein|amyloid beta A4 protein|amyloid precursor protein|beta-amyloid peptide|beta-amyloid peptide(1-40)|beta-amyloid peptide(1-42)|beta-amyloid precursor protein|cerebral vascular amyloid peptide|peptidase nexin-II|protease nexin-II|testicular tissue protein Li 2', map_location='21q21.3', chromosome='21', genomic_nucleotide_accession_version='NC_000021.9', start_position_on_the_genomic_accession=25880550, end_position_on_the_genomic_accession=26171128, orientation='minus', exon_count=20, OMIM=[104760], no_hdr0=''),
    353 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=353, CurrentID=0, Status='live', Symbol='APRT', Aliases=['AMPD', 'APRT'], description='adenine phosphoribosyltransferase', other_designations='adenine phosphoribosyltransferase|AMP diphosphorylase|AMP pyrophosphorylase|transphosphoribosidase', map_location='16q24.3', chromosome='16', genomic_nucleotide_accession_version='NC_000016.10', start_position_on_the_genomic_accession=88809339, end_position_on_the_genomic_accession=88811928, orientation='minus', exon_count=5, OMIM=[102600], no_hdr0=''),
    354 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=354, CurrentID=0, Status='live', Symbol='KLK3', Aliases=['APS', 'KLK2A1', 'PSA', 'hK3'], description='kallikrein related peptidase 3', other_designations='prostate-specific antigen|P-30 antigen|gamma-seminoprotein|kallikrein-3|semenogelase|seminin', map_location='19q13.33', chromosome='19', genomic_nucleotide_accession_version='NC_000019.10', start_position_on_the_genomic_accession=50854915, end_position_on_the_genomic_accession=50860764, orientation='plus', exon_count=5, OMIM=[176820], no_hdr0=''),
    355 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=355, CurrentID=0, Status='live', Symbol='FAS', Aliases=['ALPS1A', 'APO-1', 'APT1', 'CD951', 'FASTM', 'TNFRSF6', 'FAS'], description='Fas cell surface death receptor', other_designations='tumor necrosis factor receptor superfamily member 6|APO-1 cell surface antigen|CD95 antigen|FASLG receptor|Fas (TNF receptor superfamily, member 6)|Fas AMA|TNF receptor superfamily member 6|apoptosis antigen 1|apoptosis signaling receptor FAS|apoptosis-mediating surface antigen FAS|mutant tumor necrosis receptor superfamily member 6|tumor necrosis factor receptor superfamily, member 6', map_location='10q23.31', chromosome='10', genomic_nucleotide_accession_version='NC_000010.11', start_position_on_the_genomic_accession=88968429, end_position_on_the_genomic_accession=89017059, orientation='plus', exon_count=15, OMIM=[134637], no_hdr0=''),
    356 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=356, CurrentID=0, Status='live', Symbol='FASLG', Aliases=['ALPS1B', 'APT1LG1', 'APTL', 'CD178', 'CD95-L', 'CD95L', 'FASL', 'TNFSF6', 'TNLG1A'], description='Fas ligand', other_designations='tumor necrosis factor ligand superfamily member 6|CD95 ligand|Fas ligand (TNF superfamily, member 6)|apoptosis (APO-1) antigen ligand 1|apoptosis antigen ligand|fas antigen ligand|mutant tumor necrosis factor family member 6|tumor necrosis factor ligand 1A', map_location='1q24.3', chromosome='1', genomic_nucleotide_accession_version='NC_000001.11', start_position_on_the_genomic_accession=172659103, end_position_on_the_genomic_accession=172666876, orientation='plus', exon_count=4, OMIM=[134638], no_hdr0=''),
    357 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=357, CurrentID=0, Status='live', Symbol='SHROOM2', Aliases=['APXL', 'HSAPXL'], description='shroom family member 2', other_designations='protein Shroom2|APX homolog of Xenopus|apical-like protein', map_location='Xp22.2', chromosome='X', genomic_nucleotide_accession_version='NC_000023.11', start_position_on_the_genomic_accession=9786406, end_position_on_the_genomic_accession=9949443, orientation='plus', exon_count=13, OMIM=[300103], no_hdr0=''),
    358 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=358, CurrentID=0, Status='live', Symbol='AQP1', Aliases=['AQP-CHIP', 'CHIP28', 'CO'], description='aquaporin 1 (Colton blood group)', other_designations='aquaporin-1|aquaporin 1 (channel-forming integral protein, 28kDa, CO blood group)|aquaporin 1, Colton blood group antigen|aquaporin-CHIP|channel-like integral membrane protein, 28-kDa|urine water channel|water channel protein for red blood cells and kidney proximal tubule', map_location='7p14.3', chromosome='7', genomic_nucleotide_accession_version='NC_000007.14', start_position_on_the_genomic_accession=30911853, end_position_on_the_genomic_accession=30925516, orientation='plus', exon_count=4, OMIM=[107776], no_hdr0=''),
    359 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=359, CurrentID=0, Status='live', Symbol='AQP2', Aliases=['AQP-CD', 'WCH-CD'], description='aquaporin 2', other_designations='aquaporin-2|ADH water channel|AQP-2|aquaporin 2 (collecting duct)|aquaporin-CD|collecting duct water channel protein|water channel protein for renal collecting duct|water-channel aquaporin 2', map_location='12q13.12', chromosome='12', genomic_nucleotide_accession_version='NC_000012.12', start_position_on_the_genomic_accession=49950737, end_position_on_the_genomic_accession=49958878, orientation='plus', exon_count=4, OMIM=[107777], no_hdr0=''),
    360 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=360, CurrentID=0, Status='live', Symbol='AQP3', Aliases=['AQP-3', 'GIL'], description='aquaporin 3 (Gill blood group)', other_designations='aquaporin-3|aquaglyceroporin-3|aquaporin 3 (GIL blood group)', map_location='9p13.3', chromosome='9', genomic_nucleotide_accession_version='NC_000009.12', start_position_on_the_genomic_accession=33441154, end_position_on_the_genomic_accession=33447596, orientation='minus', exon_count=6, OMIM=[600170], no_hdr0=''),
    361 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=361, CurrentID=0, Status='live', Symbol='AQP4', Aliases=['MIWC', 'WCH4'], description='aquaporin 4', other_designations='aquaporin-4|aquaporin type4|mercurial-insensitive water channel', map_location='18q11.2', chromosome='18', genomic_nucleotide_accession_version='NC_000018.10', start_position_on_the_genomic_accession=26852038, end_position_on_the_genomic_accession=26865803, orientation='minus', exon_count=6, OMIM=[600308], no_hdr0=''),
    362 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=362, CurrentID=0, Status='live', Symbol='AQP5', Aliases=['AQP-5', 'PPKB'], description='aquaporin 5', other_designations='aquaporin-5', map_location='12q13.12', chromosome='12', genomic_nucleotide_accession_version='NC_000012.12', start_position_on_the_genomic_accession=49961855, end_position_on_the_genomic_accession=49965682, orientation='plus', exon_count=5, OMIM=[600442], no_hdr0=''),
    363 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=363, CurrentID=0, Status='live', Symbol='AQP6', Aliases=['AQP2L', 'KID'], description='aquaporin 6', other_designations='aquaporin-6|AQP-6|aquaporin 2-like, kidney specific|aquaporin-6, kidney specific|hKID|kidney-specific aquaporin', map_location='12q13.12', chromosome='12', genomic_nucleotide_accession_version='NC_000012.12', start_position_on_the_genomic_accession=49972947, end_position_on_the_genomic_accession=49977139, orientation='plus', exon_count=4, OMIM=[601383], no_hdr0=''),
    364 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=364, CurrentID=0, Status='live', Symbol='AQP7', Aliases=['AQP7L', 'AQPap', 'GLYCQTL'], description='aquaporin 7', other_designations='aquaporin-7|aquaglyceroporin-7|aquaporin adipose', map_location='9p13.3', chromosome='9', genomic_nucleotide_accession_version='NC_000009.12', start_position_on_the_genomic_accession=33383135, end_position_on_the_genomic_accession=33402677, orientation='minus', exon_count=10, OMIM=[602974], no_hdr0=''),
    366 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=366, CurrentID=0, Status='live', Symbol='AQP9', Aliases=['AQP-9', 'HsT17287', 'SSC1', 'T17287'], description='aquaporin 9', other_designations='aquaporin-9|aquaglyceroporin-9|small solute channel 1', map_location='15q21.3', chromosome='15', genomic_nucleotide_accession_version='NC_000015.10', start_position_on_the_genomic_accession=58138169, end_position_on_the_genomic_accession=58185911, orientation='plus', exon_count=7, OMIM=[602914], no_hdr0=''),
    367 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=367, CurrentID=0, Status='live', Symbol='AR', Aliases=['AIS8', 'DHTR', 'HUMARA', 'HYSP1', 'KD', 'NR3C4', 'SBMA', 'SMAX1', 'TFM', 'AR'], description='androgen receptor', other_designations='androgen receptor|dihydrotestosterone receptor|nuclear receptor subfamily 3 group C member 4', map_location='Xq12', chromosome='X', genomic_nucleotide_accession_version='NC_000023.11', start_position_on_the_genomic_accession=67544021, end_position_on_the_genomic_accession=67730619, orientation='plus', exon_count=11, OMIM=[313700], no_hdr0=''),
    368 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=368, CurrentID=0, Status='live', Symbol='ABCC6', Aliases=['ABC34', 'ARA', 'EST349056', 'GACI2', 'MLP1', 'MOAT-E', 'MOATE', 'MRP6', 'PXE', 'PXE1', 'URG7'], description='ATP binding cassette subfamily C member 6', other_designations='multidrug resistance-associated protein 6|URG7 protein|ATP-binding cassette, sub-family C (CFTR/MRP), member 6|anthracycline resistance-associated protein|multi-specific organic anion transporter E', map_location='16p13.11', chromosome='16', genomic_nucleotide_accession_version='NC_000016.10', start_position_on_the_genomic_accession=16149565, end_position_on_the_genomic_accession=16223617, orientation='minus', exon_count=34, OMIM=[603234], no_hdr0=''),
    369 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=369, CurrentID=0, Status='live', Symbol='ARAF', Aliases=['A-RAF1', 'PKS2', 'RAFA1', 'ARAF'], description='A-Raf proto-oncogene, serine/threonine kinase', other_designations='serine/threonine-protein kinase A-Raf|A-Raf proto-oncogene serine/threonine-protein kinase|Oncogene ARAF1|Ras-binding protein DA-Raf|proto-oncogene A-Raf-1|proto-oncogene Pks|v-raf murine sarcoma 3611 viral oncogene homolog 1|v-raf murine sarcoma 3611 viral oncogene-like protein', map_location='Xp11.3', chromosome='X', genomic_nucleotide_accession_version='NC_000023.11', start_position_on_the_genomic_accession=47561205, end_position_on_the_genomic_accession=47571908, orientation='plus', exon_count=16, OMIM=[311010], no_hdr0=''),
    372 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=372, CurrentID=0, Status='live', Symbol='ARCN1', Aliases=['COPD', 'SRMMD'], description='archain 1', other_designations='coatomer subunit delta|COPI coat complex subunit delta|archain vesicle transport protein 1|coatomer delta subunit|coatomer protein complex, subunit delta|coatomer protein delta-COP|delta-COP|delta-coat protein', map_location='11q23.3', chromosome='11', genomic_nucleotide_accession_version='NC_000011.10', start_position_on_the_genomic_accession=118572396, end_position_on_the_genomic_accession=118603033, orientation='plus', exon_count=10, OMIM=[600820], no_hdr0=''),
    373 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=373, CurrentID=0, Status='live', Symbol='TRIM23', Aliases=['ARD1', 'ARFD1', 'RNF46'], description='tripartite motif containing 23', other_designations='E3 ubiquitin-protein ligase TRIM23|ADP-ribosylation factor domain protein 1, 64kDa|ADP-ribosylation factor domain-containing protein 1|ARF domain protein 1|GTP-binding protein ARD-1|RING finger protein 46|RING-type E3 ubiquitin transferase TRIM23|tripartite motif protein TRIM23|tripartite motif-containing protein 23', map_location='5q12.3', chromosome='5', genomic_nucleotide_accession_version='NC_000005.10', start_position_on_the_genomic_accession=65589690, end_position_on_the_genomic_accession=65624333, orientation='minus', exon_count=13, OMIM=[601747], no_hdr0=''),
    374 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=374, CurrentID=0, Status='live', Symbol='AREG', Aliases=['ARB', 'CRDGF', 'SDGF', 'AREG'], description='amphiregulin', other_designations='amphiregulin|amphiregulin B|colorectum cell-derived growth factor|schwannoma-derived growth factor', map_location='4q13.3', chromosome='4', genomic_nucleotide_accession_version='NC_000004.12', start_position_on_the_genomic_accession=74445136, end_position_on_the_genomic_accession=74455005, orientation='plus', exon_count=6, OMIM=[104640], no_hdr0=''),
    375 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=375, CurrentID=0, Status='live', Symbol='ARF1', Aliases=['PVNH8'], description='ADP ribosylation factor 1', other_designations='ADP-ribosylation factor 1', map_location='1q42.13', chromosome='1', genomic_nucleotide_accession_version='NC_000001.11', start_position_on_the_genomic_accession=228082708, end_position_on_the_genomic_accession=228099212, orientation='plus', exon_count=6, OMIM=[103180], no_hdr0=''),
    377 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=377, CurrentID=0, Status='live', Symbol='ARF3', Aliases=[], description='ADP ribosylation factor 3', other_designations='ADP-ribosylation factor 3|small GTP binding protein', map_location='12q13.12', chromosome='12', genomic_nucleotide_accession_version='NC_000012.12', start_position_on_the_genomic_accession=48930252, end_position_on_the_genomic_accession=48957526, orientation='minus', exon_count=8, OMIM=[103190], no_hdr0=''),
    378 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=378, CurrentID=0, Status='live', Symbol='ARF4', Aliases=['ARF2'], description='ADP ribosylation factor 4', other_designations='ADP-ribosylation factor 4|ADP-ribosylation factor 2', map_location='3p14.3', chromosome='3', genomic_nucleotide_accession_version='NC_000003.12', start_position_on_the_genomic_accession=57571363, end_position_on_the_genomic_accession=57597344, orientation='minus', exon_count=6, OMIM=[601177], no_hdr0=''),
    379 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=379, CurrentID=0, Status='live', Symbol='ARL4D', Aliases=['ARF4L', 'ARL6'], description='ADP ribosylation factor like GTPase 4D', other_designations='ADP-ribosylation factor-like protein 4D|ADP-ribosylation factor-like 4D|ADP-ribosylation factor-like 6|ADP-ribosylation factor-like protein 4L', map_location='17q21.31', chromosome='17', genomic_nucleotide_accession_version='NC_000017.11', start_position_on_the_genomic_accession=43398993, end_position_on_the_genomic_accession=43401137, orientation='plus', exon_count=3, OMIM=[600732], no_hdr0=''),
    381 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=381, CurrentID=0, Status='live', Symbol='ARF5', Aliases=[], description='ADP ribosylation factor 5', other_designations='ADP-ribosylation factor 5', map_location='7q32.1', chromosome='7', genomic_nucleotide_accession_version='NC_000007.14', start_position_on_the_genomic_accession=127588411, end_position_on_the_genomic_accession=127591700, orientation='plus', exon_count=6, OMIM=[103188], no_hdr0=''),
    382 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=382, CurrentID=0, Status='live', Symbol='ARF6', Aliases=[], description='ADP ribosylation factor 6', other_designations='ADP-ribosylation factor 6', map_location='14q21.3', chromosome='14', genomic_nucleotide_accession_version='NC_000014.9', start_position_on_the_genomic_accession=49893082, end_position_on_the_genomic_accession=49897054, orientation='plus', exon_count=2, OMIM=[600464], no_hdr0=''),
    383 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=383, CurrentID=0, Status='live', Symbol='ARG1', Aliases=[], description='arginase 1', other_designations='arginase-1|arginase, liver|liver-type arginase|type I arginase', map_location='6q23.2', chromosome='6', genomic_nucleotide_accession_version='NC_000006.12', start_position_on_the_genomic_accession=131573226, end_position_on_the_genomic_accession=131584329, orientation='plus', exon_count=8, OMIM=[608313], no_hdr0=''),
    384 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=384, CurrentID=0, Status='live', Symbol='ARG2', Aliases=[], description='arginase 2', other_designations='arginase-2, mitochondrial|L-arginine amidinohydrolase|L-arginine ureahydrolase|arginase II|arginase, type II|kidney arginase|kidney-type arginase|non-hepatic arginase|nonhepatic arginase|type II arginase', map_location='14q24.1', chromosome='14', genomic_nucleotide_accession_version='NC_000014.9', start_position_on_the_genomic_accession=67619920, end_position_on_the_genomic_accession=67651708, orientation='plus', exon_count=8, OMIM=[107830], no_hdr0=''),
    387 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=387, CurrentID=0, Status='live', Symbol='RHOA', Aliases=['ARH12', 'ARHA', 'EDFAOB', 'RHO12', 'RHOH12'], description='ras homolog family member A', other_designations='transforming protein RhoA|Aplysia ras-related homolog 12|epididymis secretory sperm binding protein|oncogene RHO H12|small GTP binding protein RhoA', map_location='3p21.31', chromosome='3', genomic_nucleotide_accession_version='NC_000003.12', start_position_on_the_genomic_accession=49359145, end_position_on_the_genomic_accession=49411976, orientation='minus', exon_count=7, OMIM=[165390], no_hdr0=''),
    388 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=388, CurrentID=0, Status='live', Symbol='RHOB', Aliases=['ARH6', 'ARHB', 'MST081', 'MSTP081', 'RHOH6'], description='ras homolog family member B', other_designations='rho-related GTP-binding protein RhoB|Aplysia RAS-related homolog 6|h6|oncogene RHO H6|ras homolog gene family, member B|rho cDNA clone 6', map_location='2p24.1', chromosome='2', genomic_nucleotide_accession_version='NC_000002.12', start_position_on_the_genomic_accession=20447074, end_position_on_the_genomic_accession=20449440, orientation='plus', exon_count=1, OMIM=[165370], no_hdr0=''),
    389 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=389, CurrentID=0, Status='live', Symbol='RHOC', Aliases=['ARH9', 'ARHC', 'H9', 'RHOH9'], description='ras homolog family member C', other_designations='rho-related GTP-binding protein RhoC|RAS-related homolog 9|epididymis secretory sperm binding protein|oncogene RHO H9|ras homolog gene family, member C|rho cDNA clone 9|rhoC GTPase|small GTP binding protein RhoC', map_location='1p13.2', chromosome='1', genomic_nucleotide_accession_version='NC_000001.11', start_position_on_the_genomic_accession=112701131, end_position_on_the_genomic_accession=112707408, orientation='minus', exon_count=7, OMIM=[165380], no_hdr0=''),
    390 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=390, CurrentID=0, Status='live', Symbol='RND3', Aliases=['ARHE', 'Rho8', 'RhoE', 'memB'], description='Rho family GTPase 3', other_designations='rho-related GTP-binding protein RhoE|protein MemB|ras homolog gene family, member E|rho-related GTP-binding protein Rho8|small GTP binding protein Rho8', map_location='2q23.3', chromosome='2', genomic_nucleotide_accession_version='NC_000002.12', start_position_on_the_genomic_accession=150468193, end_position_on_the_genomic_accession=150487695, orientation='minus', exon_count=6, OMIM=[602924], no_hdr0=''),
    391 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=391, CurrentID=0, Status='live', Symbol='RHOG', Aliases=['ARHG'], description='ras homolog family member G', other_designations='rho-related GTP-binding protein RhoG|ras homolog gene family, member G (rho G)', map_location='11p15.4', chromosome='11', genomic_nucleotide_accession_version='NC_000011.10', start_position_on_the_genomic_accession=3826978, end_position_on_the_genomic_accession=3840959, orientation='minus', exon_count=4, OMIM=[179505], no_hdr0=''),
    392 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=392, CurrentID=0, Status='live', Symbol='ARHGAP1', Aliases=['CDC42GAP', 'RHOGAP', 'RHOGAP1', 'p50rhoGAP'], description='Rho GTPase activating protein 1', other_designations='rho GTPase-activating protein 1|CDC42 GTPase-activating protein|GTPase-activating protein rhoGAP|GTPase-activating protein rhoOGAP|GTPase-activating protein, Rho, 1|rho-related small GTPase protein activator|rho-type GTPase-activating protein 1', map_location='11p11.2', chromosome='11', genomic_nucleotide_accession_version='NC_000011.10', start_position_on_the_genomic_accession=46677077, end_position_on_the_genomic_accession=46700660, orientation='minus', exon_count=14, OMIM=[602732], no_hdr0=''),
    393 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=393, CurrentID=0, Status='live', Symbol='ARHGAP4', Aliases=['C1', 'RGC1', 'RhoGAP4', 'SrGAP4', 'p115'], description='Rho GTPase activating protein 4', other_designations='rho GTPase-activating protein 4|Rho-GAP hematopoietic protein C1|rho-type GTPase-activating protein 4', map_location='Xq28', chromosome='X', genomic_nucleotide_accession_version='NC_000023.11', start_position_on_the_genomic_accession=153907378, end_position_on_the_genomic_accession=153926264, orientation='minus', exon_count=23, OMIM=[300023], no_hdr0=''),
    394 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=394, CurrentID=0, Status='live', Symbol='ARHGAP5', Aliases=['GFI2', 'RhoGAP5', 'p190-B', 'p190BRhoGAP'], description='Rho GTPase activating protein 5', other_designations='rho GTPase-activating protein 5|growth factor independent 2|p100 RasGAP-associated p105 protein|p105 RhoGAP|rho-type GTPase-activating protein 5', map_location='14q12', chromosome='14', genomic_nucleotide_accession_version='NC_000014.9', start_position_on_the_genomic_accession=32072588, end_position_on_the_genomic_accession=32159728, orientation='plus', exon_count=9, OMIM=[602680], no_hdr0=''),
    395 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=395, CurrentID=0, Status='live', Symbol='ARHGAP6', Aliases=['RHOGAP6', 'RHOGAPX-1'], description='Rho GTPase activating protein 6', other_designations='rho GTPase-activating protein 6|Rho-type GTPase-activating protein RhoGAPX-1|rho-type GTPase-activating protein 6', map_location='Xp22.2', chromosome='X', genomic_nucleotide_accession_version='NC_000023.11', start_position_on_the_genomic_accession=11137544, end_position_on_the_genomic_accession=11665920, orientation='minus', exon_count=17, OMIM=[300118], no_hdr0=''),
    396 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=396, CurrentID=0, Status='live', Symbol='ARHGDIA', Aliases=['GDIA1', 'HEL-S-47e', 'NPHS8', 'RHOGDI', 'RHOGDI-1'], description='Rho GDP dissociation inhibitor alpha', other_designations='rho GDP-dissociation inhibitor 1|GDP-dissociation inhibitor, aplysia RAS-related 1|Rho GDP dissociation inhibitor (GDI) alpha|epididymis secretory sperm binding protein Li 47e', map_location='17q25.3', chromosome='17', genomic_nucleotide_accession_version='NC_000017.11', start_position_on_the_genomic_accession=81867719, end_position_on_the_genomic_accession=81871337, orientation='minus', exon_count=7, OMIM=[601925], no_hdr0=''),
    397 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=397, CurrentID=0, Status='live', Symbol='ARHGDIB', Aliases=['D4', 'GDIA2', 'GDID4', 'LYGDI', 'Ly-GDI', 'RAP1GN1', 'RhoGDI2'], description='Rho GDP dissociation inhibitor beta', other_designations='rho GDP-dissociation inhibitor 2|Rho GDI 2|Rho GDP dissociation inhibitor (GDI) beta|rho-GDI beta', map_location='12p12.3', chromosome='12', genomic_nucleotide_accession_version='NC_000012.12', start_position_on_the_genomic_accession=14942015, end_position_on_the_genomic_accession=14961601, orientation='minus', exon_count=10, OMIM=[602843], no_hdr0=''),
    398 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=398, CurrentID=0, Status='live', Symbol='ARHGDIG', Aliases=['RHOGDI-3'], description='Rho GDP dissociation inhibitor gamma', other_designations='rho GDP-dissociation inhibitor 3|Rho GDP dissociation inhibitor (GDI) gamma|RhoGDI gamma|rho GDI 3|rho-GDI gamma', map_location='16p13.3', chromosome='16', genomic_nucleotide_accession_version='NC_000016.10', start_position_on_the_genomic_accession=280591, end_position_on_the_genomic_accession=283010, orientation='plus', exon_count=6, OMIM=[602844], no_hdr0=''),
    399 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=399, CurrentID=0, Status='live', Symbol='RHOH', Aliases=['ARHH', 'TTF'], description='ras homolog family member H', other_designations='rho-related GTP-binding protein RhoH|GTP-binding protein TTF|TTF, translocation three four|ras homolog gene family, member H', map_location='4p14', chromosome='4', genomic_nucleotide_accession_version='NC_000004.12', start_position_on_the_genomic_accession=40191080, end_position_on_the_genomic_accession=40246967, orientation='plus', exon_count=11, OMIM=[602037], no_hdr0=''),
    400 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=400, CurrentID=0, Status='live', Symbol='ARL1', Aliases=['ARFL1'], description='ADP ribosylation factor like GTPase 1', other_designations='ADP-ribosylation factor-like protein 1|ADP-ribosylation factor-like 1', map_location='12q23.2', chromosome='12', genomic_nucleotide_accession_version='NC_000012.12', start_position_on_the_genomic_accession=101393116, end_position_on_the_genomic_accession=101407820, orientation='minus', exon_count=6, OMIM=[603425], no_hdr0=''),
    401 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=401, CurrentID=0, Status='live', Symbol='PHOX2A', Aliases=['ARIX', 'CFEOM2', 'FEOM2', 'NCAM2', 'PMX2A'], description='paired like homeobox 2A', other_designations='paired mesoderm homeobox protein 2A|ARIX1 homeodomain protein|aristaless homeobox homolog|aristaless homeobox protein homolog|arix homeodomain protein', map_location='11q13.4', chromosome='11', genomic_nucleotide_accession_version='NC_000011.10', start_position_on_the_genomic_accession=72239077, end_position_on_the_genomic_accession=72244176, orientation='minus', exon_count=3, OMIM=[602753], no_hdr0=''),
    402 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=402, CurrentID=0, Status='live', Symbol='ARL2', Aliases=['ARFL2'], description='ADP ribosylation factor like GTPase 2', other_designations='ADP-ribosylation factor-like protein 2|ADP-ribosylation factor-like 2', map_location='11q13.1', chromosome='11', genomic_nucleotide_accession_version='NC_000011.10', start_position_on_the_genomic_accession=65014160, end_position_on_the_genomic_accession=65022184, orientation='plus', exon_count=5, OMIM=[601175], no_hdr0=''),
    403 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=403, CurrentID=0, Status='live', Symbol='ARL3', Aliases=['ARFL3', 'JBTS35', 'RP83'], description='ADP ribosylation factor like GTPase 3', other_designations='ADP-ribosylation factor-like protein 3|ADP-ribosylation factor-like 3|ARF-like 3', map_location='10q24.32', chromosome='10', genomic_nucleotide_accession_version='NC_000010.11', start_position_on_the_genomic_accession=102673731, end_position_on_the_genomic_accession=102714397, orientation='minus', exon_count=7, OMIM=[604695], no_hdr0=''),
    405 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=405, CurrentID=0, Status='live', Symbol='ARNT', Aliases=['HIF-1-beta', 'HIF-1beta', 'HIF1-beta', 'HIF1B', 'HIF1BETA', 'TANGO', 'bHLHe2'], description='aryl hydrocarbon receptor nuclear translocator', other_designations='aryl hydrocarbon receptor nuclear translocator|class E basic helix-loop-helix protein 2|dioxin receptor, nuclear translocator|hypoxia-inducible factor 1, beta subunit', map_location='1q21.3', chromosome='1', genomic_nucleotide_accession_version='NC_000001.11', start_position_on_the_genomic_accession=150809713, end_position_on_the_genomic_accession=150876737, orientation='minus', exon_count=25, OMIM=[126110], no_hdr0=''),
    406 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=406, CurrentID=0, Status='live', Symbol='ARNTL', Aliases=['BMAL1', 'BMAL1c', 'JAP3', 'MOP3', 'PASD3', 'TIC', 'bHLHe5'], description='aryl hydrocarbon receptor nuclear translocator like', other_designations='aryl hydrocarbon receptor nuclear translocator-like protein 1|ARNT-like protein 1, brain and muscle|PAS domain containing 3|PAS domain-containing protein 3|bHLH-PAS protein JAP3|basic helix-loop-helix family member e5|basic-helix-loop-helix-PAS orphan MOP3|basic-helix-loop-helix-PAS protein MOP3|brain and muscle ARNT-like 1|class E basic helix-loop-helix protein 5|member of PAS protein 3|member of PAS superfamily 3|testis tissue sperm-binding protein Li 50e', map_location='11p15.3', chromosome='11', genomic_nucleotide_accession_version='NC_000011.10', start_position_on_the_genomic_accession=13276552, end_position_on_the_genomic_accession=13387268, orientation='plus', exon_count=25, OMIM=[602550], no_hdr0=''),
    407 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=407, CurrentID=0, Status='live', Symbol='ARR3', Aliases=['ARRX', 'MYP26', 'cArr'], description='arrestin 3', other_designations='arrestin-C|C-arrestin|arrestin 3 retinal (X-arrestin)|arrestin 4|retinal cone arrestin-3', map_location='Xq13.1', chromosome='X', genomic_nucleotide_accession_version='NC_000023.11', start_position_on_the_genomic_accession=70268334, end_position_on_the_genomic_accession=70281840, orientation='plus', exon_count=17, OMIM=[301770], no_hdr0=''),
    408 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=408, CurrentID=0, Status='live', Symbol='ARRB1', Aliases=['ARB1', 'ARR1'], description='arrestin beta 1', other_designations='beta-arrestin-1|arrestin 2|non-visual arrestin-2', map_location='11q13.4', chromosome='11', genomic_nucleotide_accession_version='NC_000011.10', start_position_on_the_genomic_accession=75260122, end_position_on_the_genomic_accession=75351662, orientation='minus', exon_count=20, OMIM=[107940], no_hdr0=''),
    409 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=409, CurrentID=0, Status='live', Symbol='ARRB2', Aliases=['ARB2', 'ARR2', 'BARR2'], description='arrestin beta 2', other_designations='beta-arrestin-2|arrestin 3|non-visual arrestin-3', map_location='17p13.2', chromosome='17', genomic_nucleotide_accession_version='NC_000017.11', start_position_on_the_genomic_accession=4710619, end_position_on_the_genomic_accession=4721500, orientation='plus', exon_count=17, OMIM=[107941], no_hdr0=''),
    410 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=410, CurrentID=0, Status='live', Symbol='ARSA', Aliases=['ASA', 'MLD'], description='arylsulfatase A', other_designations='arylsulfatase A|cerebroside-sulfatase|epididymis secretory sperm binding protein', map_location='22q13.33', chromosome='22', genomic_nucleotide_accession_version='NC_000022.11', start_position_on_the_genomic_accession=50622754, end_position_on_the_genomic_accession=50628152, orientation='minus', exon_count=9, OMIM=[607574], no_hdr0=''),
    411 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=411, CurrentID=0, Status='live', Symbol='ARSB', Aliases=['ASB', 'G4S', 'MPS6'], description='arylsulfatase B', other_designations='arylsulfatase B|N-acetylgalactosamine-4-sulfatase', map_location='5q14.1', chromosome='5', genomic_nucleotide_accession_version='NC_000005.10', start_position_on_the_genomic_accession=78777209, end_position_on_the_genomic_accession=78986087, orientation='minus', exon_count=15, OMIM=[611542], no_hdr0=''),
    412 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=412, CurrentID=0, Status='live', Symbol='STS', Aliases=['ARSC', 'ARSC1', 'ASC', 'ES', 'SSDD', 'XLI'], description='steroid sulfatase', other_designations='steryl-sulfatase|arylsulfatase C|estrone sulfatase|steroid sulfatase (microsomal), isozyme S|steryl-sulfate sulfohydrolase', map_location='Xp22.31', chromosome='X', genomic_nucleotide_accession_version='NC_000023.11', start_position_on_the_genomic_accession=7147290, end_position_on_the_genomic_accession=7354641, orientation='plus', exon_count=16, OMIM=[300747], no_hdr0=''),
    414 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=414, CurrentID=0, Status='live', Symbol='ARSD', Aliases=['ASD'], description='arylsulfatase D', other_designations='arylsulfatase D|testis tissue sperm-binding protein Li 39a', map_location='Xp22.33', chromosome='X', genomic_nucleotide_accession_version='NC_000023.11', start_position_on_the_genomic_accession=2903972, end_position_on_the_genomic_accession=2929345, orientation='minus', exon_count=11, OMIM=[300002], no_hdr0=''),
    415 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=415, CurrentID=0, Status='live', Symbol='ARSL', Aliases=['ARSE', 'ASE', 'CDPX', 'CDPX1', 'CDPXR'], description='arylsulfatase L', other_designations='arylsulfatase L|arylsulfatase E (chondrodysplasia punctata 1)', map_location='Xp22.33', chromosome='X', genomic_nucleotide_accession_version='NC_000023.11', start_position_on_the_genomic_accession=2934521, end_position_on_the_genomic_accession=2968245, orientation='minus', exon_count=13, OMIM=[300180], no_hdr0=''),
    416 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=416, CurrentID=0, Status='live', Symbol='ARSF', Aliases=['ASF'], description='arylsulfatase F', other_designations='arylsulfatase F', map_location='Xp22.33', chromosome='X', genomic_nucleotide_accession_version='NC_000023.11', start_position_on_the_genomic_accession=3040234, end_position_on_the_genomic_accession=3112727, orientation='plus', exon_count=14, OMIM=[300003], no_hdr0=''),
    417 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=417, CurrentID=0, Status='live', Symbol='ART1', Aliases=['ART2', 'ARTC1', 'CD296', 'RT6'], description='ADP-ribosyltransferase 1', other_designations='GPI-linked NAD(P)(+)--arginine ADP-ribosyltransferase 1|ADP-ribosyltransferase 2|ADP-ribosyltransferase C2 and C3 toxin-like 1|mono(ADP-ribosyl)transferase 1', map_location='11p15.4', chromosome='11', genomic_nucleotide_accession_version='NC_000011.10', start_position_on_the_genomic_accession=3645110, end_position_on_the_genomic_accession=3665516, orientation='plus', exon_count=6, OMIM=[601625], no_hdr0=''),
    419 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=419, CurrentID=0, Status='live', Symbol='ART3', Aliases=['ARTC3'], description='ADP-ribosyltransferase 3 (inactive)', other_designations='ecto-ADP-ribosyltransferase 3|ADP-ribosyltransferase C2 and C3 toxin-like 3|NAD(P)(+)--arginine ADP-ribosyltransferase 3|mono(ADP-ribosyl)transferase 3|mono-ADP-ribosyltransferase', map_location='4p15.1-p14', chromosome='4', genomic_nucleotide_accession_version='NC_000004.12', start_position_on_the_genomic_accession=76011168, end_position_on_the_genomic_accession=76112791, orientation='plus', exon_count=17, OMIM=[603086], no_hdr0=''),
    420 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=420, CurrentID=0, Status='live', Symbol='ART4', Aliases=['ARTC4', 'CD297', 'DO', 'DO/ART4', 'DOK1'], description='ADP-ribosyltransferase 4 (inactive) (Dombrock blood group)', other_designations='ecto-ADP-ribosyltransferase 4|ADP-ribosyltransferase 4 (DO blood group)|ADP-ribosyltransferase 4 (Dombrock blood group)|ADP-ribosyltransferase C2 and C3 toxin-like 4|Do glycoprotein|Dombrock blood group carrier molecule|Dombrock glycoprotein|NAD(+)--protein-arginine ADP-ribosyltransferase 4|NAD(P)(+)--arginine ADP-ribosyltransferase 4|mono-ADP-ribosyltransferase 4|truncated Dombrock blood group protein', map_location='12p12.3', chromosome='12', genomic_nucleotide_accession_version='NC_000012.12', start_position_on_the_genomic_accession=14825569, end_position_on_the_genomic_accession=14843526, orientation='minus', exon_count=3, OMIM=[110600], no_hdr0=''),
    421 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=421, CurrentID=0, Status='live', Symbol='ARVCF', Aliases=[], description='ARVCF delta catenin family member', other_designations='armadillo repeat protein deleted in velo-cardio-facial syndrome|armadillo repeat gene deleted in velocardiofacial syndrome', map_location='22q11.21', chromosome='22', genomic_nucleotide_accession_version='NC_000022.11', start_position_on_the_genomic_accession=19966727, end_position_on_the_genomic_accession=20016823, orientation='minus', exon_count=27, OMIM=[602269], no_hdr0=''),
    427 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=427, CurrentID=0, Status='live', Symbol='ASAH1', Aliases=['AC', 'ACDase', 'ASAH', 'PHP', 'PHP32', 'SMAPME'], description='N-acylsphingosine amidohydrolase 1', other_designations='acid ceramidase|N-acylethanolamine hydrolase ASAH1|N-acylsphingosine amidohydrolase (acid ceramidase) 1|acid CDase|acylsphingosine deacylase|putative 32 kDa heart protein', map_location='8p22', chromosome='8', genomic_nucleotide_accession_version='NC_000008.11', start_position_on_the_genomic_accession=18055992, end_position_on_the_genomic_accession=18084961, orientation='minus', exon_count=17, OMIM=[613468], no_hdr0=''),
    429 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=429, CurrentID=0, Status='live', Symbol='ASCL1', Aliases=['ASH1', 'HASH1', 'MASH1', 'bHLHa46'], description='achaete-scute family bHLH transcription factor 1', other_designations='achaete-scute homolog 1|ASH-1|achaete scute protein|achaete-scute complex homolog 1|achaete-scute complex-like 1|class A basic helix-loop-helix protein 46', map_location='12q23.2', chromosome='12', genomic_nucleotide_accession_version='NC_000012.12', start_position_on_the_genomic_accession=102957674, end_position_on_the_genomic_accession=102960513, orientation='plus', exon_count=2, OMIM=[100790], no_hdr0=''),
    430 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=430, CurrentID=0, Status='live', Symbol='ASCL2', Aliases=['ASH2', 'HASH2', 'MASH2', 'bHLHa45'], description='achaete-scute family bHLH transcription factor 2', other_designations='achaete-scute homolog 2|achaete-scute complex homolog 2|achaete-scute complex-like 2|class A basic helix-loop-helix protein 45|mammalian achaete/scute homologue 2', map_location='11p15.5', chromosome='11', genomic_nucleotide_accession_version='NC_000011.10', start_position_on_the_genomic_accession=2268498, end_position_on_the_genomic_accession=2270588, orientation='minus', exon_count=2, OMIM=[601886], no_hdr0=''),
    432 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=432, CurrentID=0, Status='live', Symbol='ASGR1', Aliases=['ASGPR', 'ASGPR1', 'CLEC4H1', 'HL-1'], description='asialoglycoprotein receptor 1', other_designations='asialoglycoprotein receptor 1|C-type lectin domain family 4 member H1|hepatic lectin H1', map_location='17p13.1', chromosome='17', genomic_nucleotide_accession_version='NC_000017.11', start_position_on_the_genomic_accession=7173431, end_position_on_the_genomic_accession=7179426, orientation='minus', exon_count=9, OMIM=[108360], no_hdr0=''),
    433 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=433, CurrentID=0, Status='live', Symbol='ASGR2', Aliases=['ASGP-R2', 'ASGPR2', 'CLEC4H2', 'HBXBP', 'HL-2'], description='asialoglycoprotein receptor 2', other_designations='asialoglycoprotein receptor 2|C-type lectin domain family 4 member H2|HBxAg-binding protein|hepatic lectin H2', map_location='17p13.1', chromosome='17', genomic_nucleotide_accession_version='NC_000017.11', start_position_on_the_genomic_accession=7101322, end_position_on_the_genomic_accession=7115538, orientation='minus', exon_count=11, OMIM=[108361], no_hdr0=''),
    434 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=434, CurrentID=0, Status='live', Symbol='ASIP', Aliases=['AGSW', 'AGTI', 'AGTIL', 'ASP', 'SHEP9'], description='agouti signaling protein', other_designations='agouti-signaling protein|agouti signaling protein, nonagouti homolog|agouti switch protein|nonagouti homolog', map_location='20q11.22', chromosome='20', genomic_nucleotide_accession_version='NC_000020.11', start_position_on_the_genomic_accession=34186493, end_position_on_the_genomic_accession=34269344, orientation='plus', exon_count=8, OMIM=[600201], no_hdr0=''),
    435 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=435, CurrentID=0, Status='live', Symbol='ASL', Aliases=['ASAL'], description='argininosuccinate lyase', other_designations='argininosuccinate lyase|argininosuccinase|arginosuccinase', map_location='7q11.21', chromosome='7', genomic_nucleotide_accession_version='NC_000007.14', start_position_on_the_genomic_accession=66075819, end_position_on_the_genomic_accession=66093576, orientation='plus', exon_count=16, OMIM=[608310], no_hdr0=''),
    438 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=438, CurrentID=0, Status='live', Symbol='ASMT', Aliases=['ASMTY', 'HIOMT', 'HIOMTY'], description='acetylserotonin O-methyltransferase', other_designations='acetylserotonin O-methyltransferase|acetylserotonin N-methyltransferase|acetylserotonin methyltransferase (Y chromosome)|hydroxyindole O-methyltransferase', map_location='Xp22.3 and Yp11.3', chromosome='X', genomic_nucleotide_accession_version='NC_000023.11', start_position_on_the_genomic_accession=1595455, end_position_on_the_genomic_accession=1643081, orientation='plus', exon_count=10, OMIM=[300015, 402500], no_hdr0=''),
    439 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=439, CurrentID=0, Status='live', Symbol='GET3', Aliases=['ARSA-I', 'ARSA1', 'ASNA-I', 'ASNA1', 'TRC40'], description='guided entry of tail-anchored proteins factor 3, ATPase', other_designations='ATPase GET3|arsA arsenite transporter, ATP-binding, homolog 1|golgi to ER traffic 3 homolog|transmembrane domain recognition complex 40 kDa ATPase subunit', map_location='19p13.13', chromosome='19', genomic_nucleotide_accession_version='NC_000019.10', start_position_on_the_genomic_accession=12737106, end_position_on_the_genomic_accession=12748323, orientation='plus', exon_count=8, OMIM=[601913], no_hdr0=''),
    440 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=440, CurrentID=0, Status='live', Symbol='ASNS', Aliases=['ASNSD', 'TS11'], description='asparagine synthetase (glutamine-hydrolyzing)', other_designations='asparagine synthetase [glutamine-hydrolyzing]|TS11 cell cycle control protein|glutamine-dependent asparagine synthetase', map_location='7q21.3', chromosome='7', genomic_nucleotide_accession_version='NC_000007.14', start_position_on_the_genomic_accession=97851677, end_position_on_the_genomic_accession=97928441, orientation='minus', exon_count=16, OMIM=[108370], no_hdr0=''),
    443 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=443, CurrentID=0, Status='live', Symbol='ASPA', Aliases=['ACY2', 'ASP'], description='aspartoacylase', other_designations='aspartoacylase|ACY-2|aminoacylase 2', map_location='17p13.2', chromosome='17', genomic_nucleotide_accession_version='NC_000017.11', start_position_on_the_genomic_accession=3473646, end_position_on_the_genomic_accession=3503405, orientation='plus', exon_count=10, OMIM=[608034], no_hdr0=''),
    444 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=444, CurrentID=0, Status='live', Symbol='ASPH', Aliases=['AAH', 'BAH', 'CASQ2BP1', 'FDLAB', 'HAAH', 'JCTN', 'junctin'], description='aspartate beta-hydroxylase', other_designations='aspartyl/asparaginyl beta-hydroxylase|A beta H-J-J|ASP beta-hydroxylase|cardiac junctin|humbug|junctate|peptide-aspartate beta-dioxygenase', map_location='8q12.3', chromosome='8', genomic_nucleotide_accession_version='NC_000008.11', start_position_on_the_genomic_accession=61500556, end_position_on_the_genomic_accession=61714609, orientation='minus', exon_count=33, OMIM=[600582], no_hdr0=''),
    445 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=445, CurrentID=0, Status='live', Symbol='ASS1', Aliases=['ASS', 'CTLN1'], description='argininosuccinate synthase 1', other_designations='argininosuccinate synthase|argininosuccinate synthetase 1|citrulline-aspartate ligase|epididymis secretory sperm binding protein', map_location='9q34.11', chromosome='9', genomic_nucleotide_accession_version='NC_000009.12', start_position_on_the_genomic_accession=130444707, end_position_on_the_genomic_accession=130501274, orientation='plus', exon_count=18, OMIM=[603470], no_hdr0=''),
    460 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=460, CurrentID=0, Status='live', Symbol='ASTN1', Aliases=['ASTN'], description='astrotactin 1', other_designations='astrotactin-1', map_location='1q25.2', chromosome='1', genomic_nucleotide_accession_version='NC_000001.11', start_position_on_the_genomic_accession=176855117, end_position_on_the_genomic_accession=177164854, orientation='minus', exon_count=26, OMIM=[600904], no_hdr0=''),
    462 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=462, CurrentID=0, Status='live', Symbol='SERPINC1', Aliases=['AT3', 'AT3D', 'ATIII', 'ATIII-R2', 'ATIII-T1', 'ATIII-T2', 'THPH7'], description='serpin family C member 1', other_designations='antithrombin-III|serine (or cysteine) proteinase inhibitor, clade C (antithrombin), member 1|serpin peptidase inhibitor clade C member 1|serpin peptidase inhibitor, clade C (antithrombin), member 1', map_location='1q25.1', chromosome='1', genomic_nucleotide_accession_version='NC_000001.11', start_position_on_the_genomic_accession=173903800, end_position_on_the_genomic_accession=173917327, orientation='minus', exon_count=8, OMIM=[107300], no_hdr0=''),
    463 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=463, CurrentID=0, Status='live', Symbol='ZFHX3', Aliases=['ATBF1', 'ATBT', 'C16orf47', 'ZFH-3', 'ZNF927'], description='zinc finger homeobox 3', other_designations='zinc finger homeobox protein 3|AT motif-binding factor 1|AT-binding transcription factor 1|alpha-fetoprotein enhancer binding protein|zinc finger homeodomain protein 3', map_location='16q22.2-q22.3', chromosome='16', genomic_nucleotide_accession_version='NC_000016.10', start_position_on_the_genomic_accession=72782885, end_position_on_the_genomic_accession=73891931, orientation='minus', exon_count=22, OMIM=[104155], no_hdr0=''),
    466 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=466, CurrentID=0, Status='live', Symbol='ATF1', Aliases=['EWS-ATF1', 'FUS/ATF-1', 'TREB36'], description='activating transcription factor 1', other_designations='cyclic AMP-dependent transcription factor ATF-1|cAMP-dependent transcription factor ATF-1', map_location='12q13.12', chromosome='12', genomic_nucleotide_accession_version='NC_000012.12', start_position_on_the_genomic_accession=50763682, end_position_on_the_genomic_accession=50821162, orientation='plus', exon_count=13, OMIM=[123803], no_hdr0=''),
    467 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=467, CurrentID=0, Status='live', Symbol='ATF3', Aliases=[], description='activating transcription factor 3', other_designations='cyclic AMP-dependent transcription factor ATF-3|cAMP-dependent transcription factor ATF-3', map_location='1q32.3', chromosome='1', genomic_nucleotide_accession_version='NC_000001.11', start_position_on_the_genomic_accession=212565407, end_position_on_the_genomic_accession=212620777, orientation='plus', exon_count=7, OMIM=[603148], no_hdr0=''),
    468 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=468, CurrentID=0, Status='live', Symbol='ATF4', Aliases=['CREB-2', 'CREB2', 'TAXREB67', 'TXREB'], description='activating transcription factor 4', other_designations='cyclic AMP-dependent transcription factor ATF-4|DNA-binding protein TAXREB67|cAMP response element-binding protein 2|cAMP-dependent transcription factor ATF-4|cAMP-responsive element-binding protein 2|cyclic AMP-responsive element-binding protein 2|tax-responsive enhancer element B67|tax-responsive enhancer element-binding protein 67', map_location='22q13.1', chromosome='22', genomic_nucleotide_accession_version='NC_000022.11', start_position_on_the_genomic_accession=39514494, end_position_on_the_genomic_accession=39522686, orientation='plus', exon_count=3, OMIM=[604064], no_hdr0=''),
    471 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=471, CurrentID=0, Status='live', Symbol='ATIC', Aliases=['AICAR', 'AICARFT', 'HEL-S-70p', 'IMPCHASE', 'PURH'], description='5-aminoimidazole-4-carboxamide ribonucleotide formyltransferase/IMP cyclohydrolase', other_designations='bifunctional purine biosynthesis protein ATIC|5-aminoimidazole-4-carboxamide-1-beta-D-ribonucleotide transformylase/inosinicase|AICAR formyltransferase/IMP cyclohydrolase bifunctional enzyme|AICAR transformylase/inosine monophosphate cyclohydrolase|AICARFT/IMPCHASE|bifunctional purine biosynthesis protein PURH|epididymis secretory sperm binding protein Li 70p|phosphoribosylaminoimidazolecarboxamide formyltransferase/IMP cyclohydrolase', map_location='2q35', chromosome='2', genomic_nucleotide_accession_version='NC_000002.12', start_position_on_the_genomic_accession=215311974, end_position_on_the_genomic_accession=215359745, orientation='plus', exon_count=17, OMIM=[601731], no_hdr0=''),
    472 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=472, CurrentID=0, Status='live', Symbol='ATM', Aliases=['AT1', 'ATA', 'ATC', 'ATD', 'ATDC', 'ATE', 'TEL1', 'TELO1'], description='ATM serine/threonine kinase', other_designations='serine-protein kinase ATM|A-T mutated|AT mutated|TEL1, telomere maintenance 1, homolog|ataxia telangiectasia mutated', map_location='11q22.3', chromosome='11', genomic_nucleotide_accession_version='NC_000011.10', start_position_on_the_genomic_accession=108222484, end_position_on_the_genomic_accession=108369102, orientation='plus', exon_count=69, OMIM=[607585], no_hdr0=''),
    473 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=473, CurrentID=0, Status='live', Symbol='RERE', Aliases=['ARG', 'ARP', 'ATN1L', 'DNB1', 'NEDBEH'], description='arginine-glutamic acid dipeptide repeats', other_designations='arginine-glutamic acid dipeptide repeats protein|arginine-glutamic acid dipeptide (RE) repeats|atrophin 2|atrophin-1 like protein|atrophin-1 related protein', map_location='1p36.23', chromosome='1', genomic_nucleotide_accession_version='NC_000001.11', start_position_on_the_genomic_accession=8352404, end_position_on_the_genomic_accession=8817640, orientation='minus', exon_count=25, OMIM=[605226], no_hdr0=''),
    474 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=474, CurrentID=0, Status='live', Symbol='ATOH1', Aliases=['ATH1', 'HATH1', 'MATH-1', 'bHLHa14'], description='atonal bHLH transcription factor 1', other_designations='protein atonal homolog 1|atonal homolog 1|atonal homolog bHLH transcription factor 1|class A basic helix-loop-helix protein 14|helix-loop-helix protein hATH-1', map_location='4q22.2', chromosome='4', genomic_nucleotide_accession_version='NC_000004.12', start_position_on_the_genomic_accession=93828753, end_position_on_the_genomic_accession=93830964, orientation='plus', exon_count=1, OMIM=[601461], no_hdr0=''),
    475 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=475, CurrentID=0, Status='live', Symbol='ATOX1', Aliases=['ATX1', 'HAH1'], description='antioxidant 1 copper chaperone', other_designations='copper transport protein ATOX1|ATX1 antioxidant protein 1 homolog|metal transport protein ATX1', map_location='5q33.1', chromosome='5', genomic_nucleotide_accession_version='NC_000005.10', start_position_on_the_genomic_accession=151742822, end_position_on_the_genomic_accession=151758631, orientation='minus', exon_count=4, OMIM=[602270], no_hdr0=''),
    476 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=476, CurrentID=0, Status='live', Symbol='ATP1A1', Aliases=['CMT2DD', 'HOMGSMR2'], description='ATPase Na+/K+ transporting subunit alpha 1', other_designations='sodium/potassium-transporting ATPase subunit alpha-1|ATPase, Na+/K+ transporting, alpha 1 polypeptide|Na(+)/K(+) ATPase alpha-1 subunit|Na+/K+ ATPase 1|Na, K-ATPase, alpha-A catalytic polypeptide|Na,K-ATPase alpha-1 subunit|Na,K-ATPase catalytic subunit alpha-A protein|sodium pump subunit alpha-1|sodium-potassium ATPase catalytic subunit alpha-1|sodium-potassium-ATPase, alpha 1 polypeptide', map_location='1p13.1', chromosome='1', genomic_nucleotide_accession_version='NC_000001.11', start_position_on_the_genomic_accession=116372986, end_position_on_the_genomic_accession=116410259, orientation='plus', exon_count=26, OMIM=[182310], no_hdr0=''),
    477 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=477, CurrentID=0, Status='live', Symbol='ATP1A2', Aliases=['FHM2', 'MHP2'], description='ATPase Na+/K+ transporting subunit alpha 2', other_designations='sodium/potassium-transporting ATPase subunit alpha-2|ATPase Na+/K+ transporting alpha 2 polypeptide|Na(+)/K(+) ATPase alpha-2 subunit|Na+/K+ ATPase, alpha-A(+) catalytic polypeptide|Na+/K+ ATPase, alpha-B polypeptide|sodium pump subunit alpha-2|sodium-potassium ATPase catalytic subunit alpha-2|sodium/potassium-transporting ATPase alpha-2 chain', map_location='1q23.2', chromosome='1', genomic_nucleotide_accession_version='NC_000001.11', start_position_on_the_genomic_accession=160115759, end_position_on_the_genomic_accession=160143591, orientation='plus', exon_count=23, OMIM=[182340], no_hdr0=''),
    478 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=478, CurrentID=0, Status='live', Symbol='ATP1A3', Aliases=['AHC2', 'ATP1A1', 'CAPOS', 'DYT12', 'RDP'], description='ATPase Na+/K+ transporting subunit alpha 3', other_designations='sodium/potassium-transporting ATPase subunit alpha-3|ATPase, Na+/K+ transporting, alpha 3 polypeptide|Na(+)/K(+) ATPase alpha(III) subunit|Na(+)/K(+) ATPase alpha-3 subunit|Na+, K+ activated adenosine triphosphatase alpha subunit|Na+/K+ ATPase 3|sodium pump subunit alpha-3|sodium-potassium ATPase catalytic subunit alpha-3|sodium-potassium-ATPase, alpha 3 polypeptide|sodium/potassium-transporting ATPase alpha-3 chain', map_location='19q13.2', chromosome='19', genomic_nucleotide_accession_version='NC_000019.10', start_position_on_the_genomic_accession=41966582, end_position_on_the_genomic_accession=41994230, orientation='minus', exon_count=24, OMIM=[182350], no_hdr0=''),
    479 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=479, CurrentID=0, Status='live', Symbol='ATP12A', Aliases=['ATP1AL1', 'H-K-ATPase', 'HK'], description='ATPase H+/K+ transporting non-gastric alpha2 subunit', other_designations='potassium-transporting ATPase alpha chain 2|ATPase, H+/K+ transporting, nongastric, alpha polypeptide|ATPase, Na+/K+ transporting, alpha polypeptide-like 1', map_location='13q12.1-q12.3', chromosome='13', genomic_nucleotide_accession_version='NC_000013.11', start_position_on_the_genomic_accession=24680408, end_position_on_the_genomic_accession=24712472, orientation='plus', exon_count=23, OMIM=[182360], no_hdr0=''),
    480 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=480, CurrentID=0, Status='live', Symbol='ATP1A4', Aliases=['ATP1A1', 'ATP1AL2'], description='ATPase Na+/K+ transporting subunit alpha 4', other_designations='sodium/potassium-transporting ATPase subunit alpha-4|ATPase, Na+/K+ transporting, alpha 4 polypeptide|ATPase, Na+/K+ transporting, alpha polypeptide-like 2|Na(+)/K(+) ATPase alpha-4 subunit|Na+/K+ ATPase 4|Na+/K+ ATPase, alpha-D polypeptide|Na,K-ATPase subunit alpha-C|sodium pump 4|sodium pump subunit alpha-4|sodium-potassium ATPase catalytic subunit alpha-4|sodium/potassium-transporting ATPase alpha-4 chain', map_location='1q23.2', chromosome='1', genomic_nucleotide_accession_version='NC_000001.11', start_position_on_the_genomic_accession=160151603, end_position_on_the_genomic_accession=160186980, orientation='plus', exon_count=23, OMIM=[607321], no_hdr0=''),
    481 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=481, CurrentID=0, Status='live', Symbol='ATP1B1', Aliases=['ATP1B'], description='ATPase Na+/K+ transporting subunit beta 1', other_designations='sodium/potassium-transporting ATPase subunit beta-1|ATPase, Na+/K+ transporting, beta 1 polypeptide|Beta 1-subunit of Na(+),K(+)-ATPase|Na, K-ATPase beta-1 polypeptide|adenosinetriphosphatase|sodium pump subunit beta-1|sodium-potassium ATPase subunit beta 1 (non-catalytic)|sodium/potassium-dependent ATPase beta-1 subunit|sodium/potassium-transporting ATPase beta-1 chain', map_location='1q24.2', chromosome='1', genomic_nucleotide_accession_version='NC_000001.11', start_position_on_the_genomic_accession=169106690, end_position_on_the_genomic_accession=169132719, orientation='plus', exon_count=6, OMIM=[182330], no_hdr0=''),
    482 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=482, CurrentID=0, Status='live', Symbol='ATP1B2', Aliases=['AMOG'], description='ATPase Na+/K+ transporting subunit beta 2', other_designations='sodium/potassium-transporting ATPase subunit beta-2|ATPase, Na+/K+ transporting, beta 2 polypeptide|Na, K-ATPase beta-2 polypeptide|adhesion molecule in glia|adhesion molecule on glia|sodium pump subunit beta-2|sodium-potassium ATPase subunit beta 2 (non-catalytic)|sodium/potassium-dependent ATPase beta-2 subunit|sodium/potassium-dependent ATPase subunit beta-2|sodium/potassium-transporting ATPase beta-2 chain', map_location='17p13.1', chromosome='17', genomic_nucleotide_accession_version='NC_000017.11', start_position_on_the_genomic_accession=7646627, end_position_on_the_genomic_accession=7657770, orientation='plus', exon_count=8, OMIM=[182331], no_hdr0=''),
    483 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=483, CurrentID=0, Status='live', Symbol='ATP1B3', Aliases=['ATPB-3', 'CD298'], description='ATPase Na+/K+ transporting subunit beta 3', other_designations='sodium/potassium-transporting ATPase subunit beta-3|ATPase, Na+/K+ transporting, beta 3 polypeptide|Na, K-ATPase beta-3 polypeptide|sodium pump subunit beta-3|sodium-potassium ATPase subunit beta 3 (non-catalytic)|sodium/potassium-dependent ATPase subunit beta-3|sodium/potassium-transporting ATPase beta-3 chain', map_location='3q23', chromosome='3', genomic_nucleotide_accession_version='NC_000003.12', start_position_on_the_genomic_accession=141876643, end_position_on_the_genomic_accession=141926549, orientation='plus', exon_count=7, OMIM=[601867], no_hdr0=''),
    486 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=486, CurrentID=0, Status='live', Symbol='FXYD2', Aliases=['ATP1G1', 'HOMG2'], description='FXYD domain containing ion transport regulator 2', other_designations='sodium/potassium-transporting ATPase subunit gamma|ATPase, Na+/K+ transporting, gamma 1 polypeptide|Na(+)/K(+) ATPase subunit gamma|sodium pump gamma chain', map_location='11q23.3', chromosome='11', genomic_nucleotide_accession_version='NC_000011.10', start_position_on_the_genomic_accession=117820057, end_position_on_the_genomic_accession=117828089, orientation='minus', exon_count=7, OMIM=[601814], no_hdr0=''),
    487 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=487, CurrentID=0, Status='live', Symbol='ATP2A1', Aliases=['ATP2A', 'SERCA1'], description='ATPase sarcoplasmic/endoplasmic reticulum Ca2+ transporting 1', other_designations='sarcoplasmic/endoplasmic reticulum calcium ATPase 1|ATPase, Ca++ transporting, cardiac muscle, fast twitch 1|SR Ca(2+)-ATPase 1|calcium pump 1|endoplasmic reticulum class 1/2 Ca(2+) ATPase', map_location='16p11.2', chromosome='16', genomic_nucleotide_accession_version='NC_000016.10', start_position_on_the_genomic_accession=28878488, end_position_on_the_genomic_accession=28904466, orientation='plus', exon_count=24, OMIM=[108730], no_hdr0=''),
    488 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=488, CurrentID=0, Status='live', Symbol='ATP2A2', Aliases=['ATP2B', 'DAR', 'DD', 'SERCA2'], description='ATPase sarcoplasmic/endoplasmic reticulum Ca2+ transporting 2', other_designations='sarcoplasmic/endoplasmic reticulum calcium ATPase 2|ATPase Ca++ transporting cardiac muscle slow twitch 2|ATPase, Ca++ dependent, slow-twitch, cardiac muscle-2|SR Ca(2+)-ATPase 2|calcium pump 2|cardiac Ca2+ ATPase|endoplasmic reticulum class 1/2 Ca(2+) ATPase', map_location='12q24.11', chromosome='12', genomic_nucleotide_accession_version='NC_000012.12', start_position_on_the_genomic_accession=110281247, end_position_on_the_genomic_accession=110351093, orientation='plus', exon_count=21, OMIM=[108740], no_hdr0=''),
    489 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=489, CurrentID=0, Status='live', Symbol='ATP2A3', Aliases=['SERCA3'], description='ATPase sarcoplasmic/endoplasmic reticulum Ca2+ transporting 3', other_designations='sarcoplasmic/endoplasmic reticulum calcium ATPase 3|ATPase, Ca(2+)-transporting, ubiquitous|ATPase, Ca++ transporting, ubiquitous|SR Ca(2+)-ATPase 3|adenosine triphosphatase, calcium|calcium pump 3|calcium-translocating P-type ATPase|sarco/endoplasmic reticulum Ca2+ -ATPase', map_location='17p13.2', chromosome='17', genomic_nucleotide_accession_version='NC_000017.11', start_position_on_the_genomic_accession=3923869, end_position_on_the_genomic_accession=3964464, orientation='minus', exon_count=25, OMIM=[601929], no_hdr0=''),
    490 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=490, CurrentID=0, Status='live', Symbol='ATP2B1', Aliases=['PMCA1', 'PMCA1kb'], description='ATPase plasma membrane Ca2+ transporting 1', other_designations='plasma membrane calcium-transporting ATPase 1|ATPase, Ca++ transporting, plasma membrane 1|plasma membrane calcium pump', map_location='12q21.33', chromosome='12', genomic_nucleotide_accession_version='NC_000012.12', start_position_on_the_genomic_accession=89588049, end_position_on_the_genomic_accession=89709366, orientation='minus', exon_count=24, OMIM=[108731], no_hdr0=''),
    491 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=491, CurrentID=0, Status='live', Symbol='ATP2B2', Aliases=['PMCA2', 'PMCA2a', 'PMCA2i'], description='ATPase plasma membrane Ca2+ transporting 2', other_designations='plasma membrane calcium-transporting ATPase 2|ATPase, Ca++ transporting, plasma membrane 2|plasma membrane Ca(2+)-ATPase|plasma membrane Ca2+ pump 2|plasma membrane calcium ATPase|plasma membrane calcium pump', map_location='3p25.3', chromosome='3', genomic_nucleotide_accession_version='NC_000003.12', start_position_on_the_genomic_accession=10324023, end_position_on_the_genomic_accession=10707962, orientation='minus', exon_count=32, OMIM=[108733], no_hdr0=''),
    492 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=492, CurrentID=0, Status='live', Symbol='ATP2B3', Aliases=['CFAP39', 'CLA2', 'OPCA', 'PMCA3', 'PMCA3a', 'SCAX1'], description='ATPase plasma membrane Ca2+ transporting 3', other_designations='plasma membrane calcium-transporting ATPase 3|ATPase, Ca++ transporting, plasma membrane 3|cilia and flagella associated protein 39|plasma membrane calcium ATPase|plasma membrane calcium pump', map_location='Xq28', chromosome='X', genomic_nucleotide_accession_version='NC_000023.11', start_position_on_the_genomic_accession=153517677, end_position_on_the_genomic_accession=153582929, orientation='plus', exon_count=25, OMIM=[300014], no_hdr0=''),
    493 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=493, CurrentID=0, Status='live', Symbol='ATP2B4', Aliases=['ATP2B2', 'MXRA1', 'PMCA4', 'PMCA4b', 'PMCA4x'], description='ATPase plasma membrane Ca2+ transporting 4', other_designations='plasma membrane calcium-transporting ATPase 4|ATPase, Ca++ transporting, plasma membrane 4|matrix-remodeling-associated protein 1|sarcolemmal calcium pump', map_location='1q32.1', chromosome='1', genomic_nucleotide_accession_version='NC_000001.11', start_position_on_the_genomic_accession=203626832, end_position_on_the_genomic_accession=203744081, orientation='plus', exon_count=23, OMIM=[108732], no_hdr0=''),
    495 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=495, CurrentID=0, Status='live', Symbol='ATP4A', Aliases=['ATP6A'], description='ATPase H+/K+ transporting subunit alpha', other_designations='potassium-transporting ATPase alpha chain 1|ATPase H+/K+ transporting alpha subunit|ATPase, H+/K+ exchanging, alpha polypeptide|ATPase, H+/K+ transporting, alpha polypeptide|epididymis secretory sperm binding protein|gastric H+/K+ ATPase alpha subunit|gastric H,K-ATPase catalytic subunit|gastric hydrogen-potassium ATPase|proton pump', map_location='19q13.12', chromosome='19', genomic_nucleotide_accession_version='NC_000019.10', start_position_on_the_genomic_accession=35550031, end_position_on_the_genomic_accession=35563658, orientation='minus', exon_count=22, OMIM=[137216], no_hdr0=''),
    496 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=496, CurrentID=0, Status='live', Symbol='ATP4B', Aliases=['ATP6B'], description='ATPase H+/K+ transporting subunit beta', other_designations='potassium-transporting ATPase subunit beta|ATPase H+/K+ transporting beta subunit|ATPase, H+/K+ exchanging, beta polypeptide|ATPase, H+/K+ transporting, beta polypeptide|gastric H(+)/K(+) ATPase subunit beta|gastric H+/K+ ATPase beta subunit|gastric hydrogen-potassium ATPase, beta|potassium-transporting ATPase beta chain|proton pump beta chain', map_location='13q34', chromosome='13', genomic_nucleotide_accession_version='NC_000013.11', start_position_on_the_genomic_accession=113648804, end_position_on_the_genomic_accession=113658198, orientation='minus', exon_count=7, OMIM=[137217], no_hdr0=''),
    498 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=498, CurrentID=0, Status='live', Symbol='ATP5F1A', Aliases=['ATP5A', 'ATP5A1', 'ATP5AL2', 'ATPM', 'COXPD22', 'HEL-S-123m', 'MC5DN4', 'MOM2', 'OMR', 'ORM', 'hATP1'], description='ATP synthase F1 subunit alpha', other_designations='ATP synthase subunit alpha, mitochondrial|ATP synthase alpha chain, mitochondrial|ATP synthase, H+ transporting, mitochondrial F1 complex, alpha subunit 1, cardiac muscle|ATP sythase (F1-ATPase) alpha subunit|epididymis secretory sperm binding protein Li 123m|mitochondrial ATP synthetase, oligomycin-resistant', map_location='18q21.1', chromosome='18', genomic_nucleotide_accession_version='NC_000018.10', start_position_on_the_genomic_accession=46080248, end_position_on_the_genomic_accession=46104227, orientation='minus', exon_count=13, OMIM=[164360], no_hdr0=''),
    501 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=501, CurrentID=0, Status='live', Symbol='ALDH7A1', Aliases=['ATQ1', 'EPD', 'PDE'], description='aldehyde dehydrogenase 7 family member A1', other_designations='alpha-aminoadipic semialdehyde dehydrogenase|26g turgor protein homolog|P6c dehydrogenase|alpha-AASA dehydrogenase|antiquitin-1|betaine aldehyde dehydrogenase|delta1-piperideine-6-carboxylate dehydrogenase|epididymis secretory sperm binding protein', map_location='5q23.2', chromosome='5', genomic_nucleotide_accession_version='NC_000005.10', start_position_on_the_genomic_accession=126541841, end_position_on_the_genomic_accession=126595219, orientation='minus', exon_count=18, OMIM=[107323], no_hdr0=''),
    506 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=506, CurrentID=0, Status='live', Symbol='ATP5F1B', Aliases=['ATP5B', 'ATPMB', 'ATPSB', 'HEL-S-271'], description='ATP synthase F1 subunit beta', other_designations='ATP synthase subunit beta, mitochondrial|ATP synthase, H+ transporting, mitochondrial F1 complex, beta polypeptide|epididymis secretory protein Li 271|mitochondrial ATP synthase beta subunit|mitochondrial ATP synthetase, beta subunit', map_location='12q13.3', chromosome='12', genomic_nucleotide_accession_version='NC_000012.12', start_position_on_the_genomic_accession=56638175, end_position_on_the_genomic_accession=56645984, orientation='minus', exon_count=10, OMIM=[102910], no_hdr0=''),
    509 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=509, CurrentID=0, Status='live', Symbol='ATP5F1C', Aliases=['ATP5C', 'ATP5C1', 'ATP5CL1'], description='ATP synthase F1 subunit gamma', other_designations='ATP synthase subunit gamma, mitochondrial|ATP synthase gamma chain, mitochondrial|ATP synthase, H+ transporting, mitochondrial F1 complex, gamma polypeptide 1|F-ATPase gamma subunit|mitochondrial ATP synthase, gamma subunit 1', map_location='10p14', chromosome='10', genomic_nucleotide_accession_version='NC_000010.11', start_position_on_the_genomic_accession=7788159, end_position_on_the_genomic_accession=7807801, orientation='plus', exon_count=10, OMIM=[108729], no_hdr0=''),
    513 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=513, CurrentID=0, Status='live', Symbol='ATP5F1D', Aliases=['ATP5D', 'MC5DN5'], description='ATP synthase F1 subunit delta', other_designations='ATP synthase subunit delta, mitochondrial|ATP synthase, H+ transporting, mitochondrial F1 complex, delta subunit|F-ATPase delta subunit|mitochondrial ATP synthase complex delta-subunit precusor|mitochondrial ATP synthase, delta subunit', map_location='19p13.3', chromosome='19', genomic_nucleotide_accession_version='NC_000019.10', start_position_on_the_genomic_accession=1241751, end_position_on_the_genomic_accession=1244825, orientation='plus', exon_count=5, OMIM=[603150], no_hdr0=''),
    514 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=514, CurrentID=0, Status='live', Symbol='ATP5F1E', Aliases=['ATP5E', 'ATPE', 'MC5DN3'], description='ATP synthase F1 subunit epsilon', other_designations='ATP synthase subunit epsilon, mitochondrial|ATP synthase, H+ transporting, mitochondrial F1 complex, epsilon subunit|F(0)F(1)-ATPase|H(+)-transporting two-sector ATPase|mitochondrial ATP synthase epsilon chain|mitochondrial ATPase', map_location='20q13.32', chromosome='20', genomic_nucleotide_accession_version='NC_000020.11', start_position_on_the_genomic_accession=59025475, end_position_on_the_genomic_accession=59032335, orientation='minus', exon_count=3, OMIM=[606153], no_hdr0=''),
    515 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=515, CurrentID=0, Status='live', Symbol='ATP5PB', Aliases=['ATP5F1', 'PIG47'], description='ATP synthase peripheral stalk-membrane subunit b', other_designations='ATP synthase F(0) complex subunit B1, mitochondrial|ATP synthase B chain, mitochondrial|ATP synthase proton-transporting mitochondrial F(0) complex subunit B1|ATP synthase subunit b, mitochondrial|ATP synthase, H+ transporting, mitochondrial F0 complex, subunit B1|ATP synthase, H+ transporting, mitochondrial F0 complex, subunit b|ATP synthase, H+ transporting, mitochondrial Fo complex subunit B1|ATPase subunit b|H+-ATP synthase subunit b|cell proliferation-inducing protein 47', map_location='1p13.2', chromosome='1', genomic_nucleotide_accession_version='NC_000001.11', start_position_on_the_genomic_accession=111449464, end_position_on_the_genomic_accession=111462773, orientation='plus', exon_count=7, OMIM=[603270], no_hdr0=''),
    516 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=516, CurrentID=0, Status='live', Symbol='ATP5MC1', Aliases=['ATP5A', 'ATP5G', 'ATP5G1'], description='ATP synthase membrane subunit c locus 1', other_designations='ATP synthase F(0) complex subunit C1, mitochondrial|ATP synthase lipid-binding protein, mitochondrial|ATP synthase proteolipid P1|ATP synthase proton-transporting mitochondrial F(0) complex subunit C1|ATP synthase subunit 9|ATP synthase, H+ transporting, mitochondrial F0 complex, subunit C1 (subunit 9)|ATP synthase, H+ transporting, mitochondrial F0 complex, subunit c (subunit 9)|ATP synthase, H+ transporting, mitochondrial Fo complex subunit C1 (subunit 9)|ATPase protein 9|ATPase subunit 9|ATPase subunit C|mitochondrial ATP synthase, subunit 9|mitochondrial ATP synthase, subunit C', map_location='17q21.32', chromosome='17', genomic_nucleotide_accession_version='NC_000017.11', start_position_on_the_genomic_accession=48892787, end_position_on_the_genomic_accession=48895871, orientation='plus', exon_count=5, OMIM=[603192], no_hdr0=''),
    517 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=517, CurrentID=0, Status='live', Symbol='ATP5MC2', Aliases=['ATP5A', 'ATP5G2'], description='ATP synthase membrane subunit c locus 2', other_designations='ATP synthase F(0) complex subunit C2, mitochondrial|ATP synthase c subunit|ATP synthase lipid-binding protein, mitochondrial|ATP synthase proteolipid P2|ATP synthase proton-transporting mitochondrial F(0) complex subunit C2|ATP synthase, H+ transporting, mitochondrial F0 complex, subunit C2 (subunit 9)|ATP synthase, H+ transporting, mitochondrial Fo complex subunit C2 (subunit 9)|ATPase protein 9|ATPase subunit C', map_location='12q13.13', chromosome='12', genomic_nucleotide_accession_version='NC_000012.12', start_position_on_the_genomic_accession=53665166, end_position_on_the_genomic_accession=53677546, orientation='minus', exon_count=10, OMIM=[603193], no_hdr0=''),
    518 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=518, CurrentID=0, Status='live', Symbol='ATP5MC3', Aliases=['ATP5G3', 'P3'], description='ATP synthase membrane subunit c locus 3', other_designations='ATP synthase F(0) complex subunit C3, mitochondrial|ATP synthase lipid-binding protein, mitochondrial|ATP synthase proteolipid P3|ATP synthase proton-transporting mitochondrial F(0) complex subunit C3|ATP synthase subunit 9|ATP synthase, H+ transporting, mitochondrial F0 complex, subunit C3 (subunit 9)|ATP synthase, H+ transporting, mitochondrial Fo complex subunit C3 (subunit 9)|ATP synthase, mitochondrial, C subunit-3|ATPase protein 9|ATPase subunit C', map_location='2q31.1', chromosome='2', genomic_nucleotide_accession_version='NC_000002.12', start_position_on_the_genomic_accession=175176258, end_position_on_the_genomic_accession=175181710, orientation='minus', exon_count=4, OMIM=[602736], no_hdr0=''),
    521 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=521, CurrentID=0, Status='live', Symbol='ATP5ME', Aliases=['ATP5I', 'ATP5K'], description='ATP synthase membrane subunit e', other_designations='ATP synthase subunit e, mitochondrial|ATP synthase e chain, mitochondrial|ATP synthase, H+ transporting, mitochondrial F0 complex, subunit E|ATP synthase, H+ transporting, mitochondrial Fo complex subunit E|ATPase subunit e|F1F0-ATP synthase, murine e subunit', map_location='4p16.3', chromosome='4', genomic_nucleotide_accession_version='NC_000004.12', start_position_on_the_genomic_accession=672436, end_position_on_the_genomic_accession=674276, orientation='minus', exon_count=4, OMIM=[601519], no_hdr0=''),
    522 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=522, CurrentID=0, Status='live', Symbol='ATP5PF', Aliases=['ATP5', 'ATP5A', 'ATP5J', 'ATPM', 'CF6', 'F6'], description='ATP synthase peripheral stalk subunit F6', other_designations='ATP synthase-coupling factor 6, mitochondrial|ATP synthase, H+ transporting, mitochondrial F0 complex, subunit F6|ATP synthase, H+ transporting, mitochondrial Fo complex subunit F6|ATPase subunit F6|coupling factor 6|mitochondrial ATP synthase, coupling factor 6|mitochondrial ATP synthase, subunit F6|mitochondrial ATPase coupling factor 6|proliferation-inducing protein 36', map_location='21q21.3', chromosome='21', genomic_nucleotide_accession_version='NC_000021.9', start_position_on_the_genomic_accession=25724500, end_position_on_the_genomic_accession=25735653, orientation='minus', exon_count=7, OMIM=[603152], no_hdr0=''),
    523 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=523, CurrentID=0, Status='live', Symbol='ATP6V1A', Aliases=['ARCL2D', 'ATP6A11', 'HO68', 'IECEE3', 'VA68', 'VPP2', 'Vma1', 'ATP6V1A'], description='ATPase H+ transporting V1 subunit A', other_designations='V-type proton ATPase catalytic subunit A|ATPase, H+ transporting, lysosomal 70kDa, V1 subunit A|ATPase, H+ transporting, lysosomal, subunit A1|H(+)-transporting two-sector ATPase, subunit A|H+-transporting ATPase chain A, vacuolar (VA68 type)|V-ATPase 69 kDa subunit 1|V-ATPase A subunit 1|V-ATPase subunit A|vacuolar proton pump alpha subunit 1|vacuolar proton pump subunit alpha', map_location='3q13.31', chromosome='3', genomic_nucleotide_accession_version='NC_000003.12', start_position_on_the_genomic_accession=113747035, end_position_on_the_genomic_accession=113812056, orientation='plus', exon_count=15, OMIM=[607027], no_hdr0=''),
    525 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=525, CurrentID=0, Status='live', Symbol='ATP6V1B1', Aliases=['ATP6B1', 'DRTA2', 'RTA1B', 'VATB', 'VMA2', 'VPP3'], description='ATPase H+ transporting V1 subunit B1', other_designations='V-type proton ATPase subunit B, kidney isoform|ATPase, H+ transporting, lysosomal 56/58kDa, V1 subunit B1|H(+)-transporting two-sector ATPase, 58kD subunit|H+-ATPase beta 1 subunit|V-ATPase B1 subunit|V-ATPase subunit B 1|endomembrane proton pump 58 kDa subunit|vacuolar proton pump 3|vacuolar proton pump subunit B 1|vacuolar proton pump, subunit 3', map_location='2p13.3', chromosome='2', genomic_nucleotide_accession_version='NC_000002.12', start_position_on_the_genomic_accession=70935900, end_position_on_the_genomic_accession=70965431, orientation='plus', exon_count=15, OMIM=[192132], no_hdr0=''),
    526 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=526, CurrentID=0, Status='live', Symbol='ATP6V1B2', Aliases=['ATP6B1B2', 'ATP6B2', 'DOOD', 'HO57', 'VATB', 'VPP3', 'Vma2', 'ZLS2'], description='ATPase H+ transporting V1 subunit B2', other_designations='V-type proton ATPase subunit B, brain isoform|ATPase, H+ transporting, lysosomal 56/58kDa, V1 subunit B2|H+ transporting two-sector ATPase|V-ATPase B2 subunit|V-ATPase subunit B 2|endomembrane proton pump 58 kDa subunit|testicular secretory protein Li 65|vacuolar H+-ATPase 56,000 subunit|vacuolar proton pump subunit B 2', map_location='8p21.3', chromosome='8', genomic_nucleotide_accession_version='NC_000008.11', start_position_on_the_genomic_accession=20197375, end_position_on_the_genomic_accession=20226852, orientation='plus', exon_count=14, OMIM=[606939], no_hdr0=''),
    527 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=527, CurrentID=0, Status='live', Symbol='ATP6V0C', Aliases=['ATP6C', 'ATP6L', 'ATPL', 'VATL', 'VPPC', 'Vma3'], description='ATPase H+ transporting V0 subunit c', other_designations='V-type proton ATPase 16 kDa proteolipid subunit|ATPase, H+ transporting, lysosomal 16kDa, V0 subunit c|H(+)-transporting two-sector ATPase, 16 kDa subunit|V-ATPase 16 kDa proteolipid subunit|vacuolar ATP synthase 16 kDa proteolipid subunit|vacuolar H+ ATPase proton channel subunit|vacuolar proton pump 16 kDa proteolipid subunit', map_location='16p13.3', chromosome='16', genomic_nucleotide_accession_version='NC_000016.10', start_position_on_the_genomic_accession=2513726, end_position_on_the_genomic_accession=2520218, orientation='plus', exon_count=4, OMIM=[108745], no_hdr0=''),
    528 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=528, CurrentID=0, Status='live', Symbol='ATP6V1C1', Aliases=['ATP6C', 'ATP6D', 'VATC', 'Vma5'], description='ATPase H+ transporting V1 subunit C1', other_designations='V-type proton ATPase subunit C 1|ATPase, H+ transporting, lysosomal 42kDa, V1 subunit C1|H(+)-transporting two-sector ATPase, subunit C|H+ -ATPase C subunit|H+-transporting ATPase chain C, vacuolar|V-ATPase C subunit|V-ATPase subunit C 1|subunit C of vacuolar proton-ATPase V1 domain|testicular tissue protein Li 223|vacuolar ATP synthase subunit C|vacuolar proton pump C subunit|vacuolar proton pump subunit C 1|vacuolar proton pump, 42-kD subunit|vacuolar proton-ATPase, subunit C, VI domain', map_location='8q22.3', chromosome='8', genomic_nucleotide_accession_version='NC_000008.11', start_position_on_the_genomic_accession=103021083, end_position_on_the_genomic_accession=103073051, orientation='plus', exon_count=13, OMIM=[603097], no_hdr0=''),
    529 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=529, CurrentID=0, Status='live', Symbol='ATP6V1E1', Aliases=['ARCL2C', 'ATP6E', 'ATP6E2', 'ATP6V1E', 'P31', 'Vma4'], description='ATPase H+ transporting V1 subunit E1', other_designations='V-type proton ATPase subunit E 1|ATPase, H+ transporting, lysosomal 31kDa, V1 subunit E1|H(+)-transporting two-sector ATPase, 31kDa subunit|H+-transporting ATP synthase chain E, vacuolar|V-ATPase 31 kDa subunit|V-ATPase subunit E 1|V-ATPase, subunit E|vacuolar proton pump subunit E 1', map_location='22q11.21', chromosome='22', genomic_nucleotide_accession_version='NC_000022.11', start_position_on_the_genomic_accession=17592136, end_position_on_the_genomic_accession=17628822, orientation='minus', exon_count=9, OMIM=[108746], no_hdr0=''),
    533 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=533, CurrentID=0, Status='live', Symbol='ATP6V0B', Aliases=['ATP6F', 'HATPL', 'VMA16'], description='ATPase H+ transporting V0 subunit b', other_designations="V-type proton ATPase 21 kDa proteolipid subunit|ATPase, H+ transporting, lysosomal 21kDa, V0 subunit b|ATPase, H+ transporting, lysosomal, 21-KD, V0 subunit C-prime, prime|ATPase, H+ transporting, lysosomal, subunit F|H(+)-transporting two-sector ATPase, subunit F|V-ATPase 21 kDa proteolipid subunit|V-ATPase subunit c''|vacuolar ATP synthase 21 kDa proteolipid subunit|vacuolar proton pump 21 kDa proteolipid subunit", map_location='1p34.1', chromosome='1', genomic_nucleotide_accession_version='NC_000001.11', start_position_on_the_genomic_accession=43974960, end_position_on_the_genomic_accession=43978295, orientation='plus', exon_count=8, OMIM=[603717], no_hdr0=''),
    534 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=534, CurrentID=0, Status='live', Symbol='ATP6V1G2', Aliases=['ATP6G', 'ATP6G2', 'NG38', 'VMA10'], description='ATPase H+ transporting V1 subunit G2', other_designations='V-type proton ATPase subunit G 2|ATPase, H+ transporting, lysosomal (vacuolar proton pump)|ATPase, H+ transporting, lysosomal 13kDa, V1 subunit G2|H(+)-transporting two-sector ATPase, subunit G2|V-ATPase 13 kDa subunit 2|vacuolar ATP synthase subunit G 2|vacuolar proton pump G subunit 2', map_location='6p21.33', chromosome='6', genomic_nucleotide_accession_version='NC_000006.12', start_position_on_the_genomic_accession=31544444, end_position_on_the_genomic_accession=31546742, orientation='minus', exon_count=4, OMIM=[606853], no_hdr0=''),
    535 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=535, CurrentID=0, Status='live', Symbol='ATP6V0A1', Aliases=['ATP6N1', 'ATP6N1A', 'Stv1', 'VPP1', 'Vph1', 'a1'], description='ATPase H+ transporting V0 subunit a1', other_designations='V-type proton ATPase 116 kDa subunit a1|ATPase, H+ transporting, lysosomal V0 subunit a1|ATPase, H+ transporting, lysosomal non-catalytic accessory protein 1 (110/116kD)|H(+)-transporting two-sector ATPase, 116 kDa accessory protein A1|V-ATPase 116 kDa subunit a1|V-type proton ATPase 116 kDa subunit a|clathrin-coated vesicle/synaptic vesicle proton pump 116 kDa subunit|vacuolar adenosine triphosphatase subunit Ac116|vacuolar proton pump subunit 1|vacuolar proton translocating ATPase 116 kDa subunit A|vacuolar-type H(+)-ATPase 115 kDa subunit', map_location='17q21.2', chromosome='17', genomic_nucleotide_accession_version='NC_000017.11', start_position_on_the_genomic_accession=42458874, end_position_on_the_genomic_accession=42522579, orientation='plus', exon_count=25, OMIM=[192130], no_hdr0=''),
    537 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=537, CurrentID=0, Status='live', Symbol='ATP6AP1', Aliases=['16A', 'ATP6IP1', 'ATP6S1', 'Ac45', 'CF2', 'VATPS1', 'XAP-3', 'XAP3'], description='ATPase H+ transporting accessory protein 1', other_designations='V-type proton ATPase subunit S1|ATPase, H+ transporting, lysosomal (vacuolar proton pump), subunit 1|ATPase, H+ transporting, lysosomal accessory protein 1|ATPase, H+ transporting, lysosomal interacting protein 1|H-ATPase subunit|V-ATPase Ac45 subunit|V-ATPase S1 accessory protein|V-ATPase subunit S1|epididymis secretory sperm binding protein|protein XAP-3|vacuolar proton pump subunit S1', map_location='Xq28', chromosome='X', genomic_nucleotide_accession_version='NC_000023.11', start_position_on_the_genomic_accession=154428669, end_position_on_the_genomic_accession=154436516, orientation='plus', exon_count=11, OMIM=[300197], no_hdr0=''),
    538 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=538, CurrentID=0, Status='live', Symbol='ATP7A', Aliases=['DSMAX', 'MK', 'MNK', 'SMAX3'], description='ATPase copper transporting alpha', other_designations='copper-transporting ATPase 1|ATPase, Cu++ transporting, alpha polypeptide|Cu++-transporting P-type ATPase|Menkes disease-associated protein|copper pump 1', map_location='Xq21.1', chromosome='X', genomic_nucleotide_accession_version='NC_000023.11', start_position_on_the_genomic_accession=77910693, end_position_on_the_genomic_accession=78050395, orientation='plus', exon_count=23, OMIM=[300011], no_hdr0=''),
    539 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=539, CurrentID=0, Status='live', Symbol='ATP5PO', Aliases=['ATP5O', 'ATPO', 'HMC08D05', 'OSCP'], description='ATP synthase peripheral stalk subunit OSCP', other_designations='ATP synthase subunit O, mitochondrial|ATP synthase, H+ transporting, mitochondrial F1 complex, O subunit|human ATP synthase OSCP subunit|oligomycin sensitivity conferral protein oscp-like protein|oligomycin sensitivity conferring protein', map_location='21q22.11', chromosome='21', genomic_nucleotide_accession_version='NC_000021.9', start_position_on_the_genomic_accession=33903453, end_position_on_the_genomic_accession=33915804, orientation='minus', exon_count=7, OMIM=[600828], no_hdr0=''),
    540 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=540, CurrentID=0, Status='live', Symbol='ATP7B', Aliases=['PWD', 'WC1', 'WD', 'WND'], description='ATPase copper transporting beta', other_designations='copper-transporting ATPase 2|ATPase, Cu(2+)- transporting, beta polypeptide|ATPase, Cu++ transporting, beta polypeptide|Wilson disease-associated protein|copper pump 2|copper-transporting protein ATP7B', map_location='13q14.3', chromosome='13', genomic_nucleotide_accession_version='NC_000013.11', start_position_on_the_genomic_accession=51932669, end_position_on_the_genomic_accession=52012130, orientation='minus', exon_count=29, OMIM=[606882], no_hdr0=''),
    545 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=545, CurrentID=0, Status='live', Symbol='ATR', Aliases=['FCTCS', 'FRP1', 'MEC1', 'SCKL', 'SCKL1'], description='ATR serine/threonine kinase', other_designations='serine/threonine-protein kinase ATR|FRAP-related protein-1|MEC1, mitosis entry checkpoint 1, homolog|ataxia telangiectasia and Rad3-related protein', map_location='3q23', chromosome='3', genomic_nucleotide_accession_version='NC_000003.12', start_position_on_the_genomic_accession=142449235, end_position_on_the_genomic_accession=142578793, orientation='minus', exon_count=49, OMIM=[601215], no_hdr0=''),
    546 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=546, CurrentID=0, Status='live', Symbol='ATRX', Aliases=['JMS', 'MRX52', 'RAD54', 'RAD54L', 'XH2', 'XNP', 'ZNF-HX'], description='ATRX chromatin remodeler', other_designations='transcriptional regulator ATRX|ATP-dependent helicase ATRX|X-linked helicase II|X-linked nuclear protein|alpha thalassemia/mental retardation syndrome X-linked (RAD54 homolog, S. cerevisiae)', map_location='Xq21.1', chromosome='X', genomic_nucleotide_accession_version='NC_000023.11', start_position_on_the_genomic_accession=77504880, end_position_on_the_genomic_accession=77786235, orientation='minus', exon_count=37, OMIM=[300032], no_hdr0=''),
    547 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=547, CurrentID=0, Status='live', Symbol='KIF1A', Aliases=['ATSV', 'C2orf20', 'HSN2C', 'MRD9', 'NESCAVS', 'SPG30', 'UNC104'], description='kinesin family member 1A', other_designations='kinesin-like protein KIF1A|axonal transporter of synaptic vesicles|kinesin, heavy chain, member 1A, homolog of mouse|microtubule-based motor KIF1A|unc-104- and KIF1A-related protein', map_location='2q37.3', chromosome='2', genomic_nucleotide_accession_version='NC_000002.12', start_position_on_the_genomic_accession=240713767, end_position_on_the_genomic_accession=240821403, orientation='minus', exon_count=55, OMIM=[601255], no_hdr0=''),
    549 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=549, CurrentID=0, Status='live', Symbol='AUH', Aliases=[], description='AU RNA binding methylglutaconyl-CoA hydratase', other_designations='methylglutaconyl-CoA hydratase, mitochondrial|3-methylglutaconyl-CoA hydratase|AU RNA binding protein/enoyl-CoA hydratase|AU RNA-binding protein/enoyl-Coenzyme A hydratase|AU-binding protein/Enoyl-CoA hydratase|AU-specific RNA-binding enoyl-CoA hydratase|itaconyl-CoA hydratase', map_location='9q22.31', chromosome='9', genomic_nucleotide_accession_version='NC_000009.12', start_position_on_the_genomic_accession=91213823, end_position_on_the_genomic_accession=91361945, orientation='minus', exon_count=16, OMIM=[600529], no_hdr0=''),
    550 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=550, CurrentID=0, Status='live', Symbol='AUP1', Aliases=[], description='AUP1 lipid droplet regulating VLDL assembly factor', other_designations='ancient ubiquitous protein 1', map_location='2p13.1', chromosome='2', genomic_nucleotide_accession_version='NC_000002.12', start_position_on_the_genomic_accession=74526652, end_position_on_the_genomic_accession=74529706, orientation='minus', exon_count=12, OMIM=[602434], no_hdr0=''),
    551 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=551, CurrentID=0, Status='live', Symbol='AVP', Aliases=['ADH', 'ARVP-NPII', 'AVRP', 'VP', 'AVP'], description='arginine vasopressin', other_designations='vasopressin-neurophysin 2-copeptin|antidiuretic hormone|copeptin|neurohypophyseal|prepro-AVP-NP II|prepro-arginine-vasopressin-neurophysin II|vasopressin-neurophysin II-copeptin', map_location='20p13', chromosome='20', genomic_nucleotide_accession_version='NC_000020.11', start_position_on_the_genomic_accession=3082556, end_position_on_the_genomic_accession=3093521, orientation='minus', exon_count=4, OMIM=[192340], no_hdr0=''),
    552 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=552, CurrentID=0, Status='live', Symbol='AVPR1A', Aliases=['AVPR V1a', 'AVPR1', 'V1aR'], description='arginine vasopressin receptor 1A', other_designations='vasopressin V1a receptor|SCCL vasopressin subtype 1a receptor|V1-vascular vasopressin receptor AVPR1A|V1a vasopressin receptor|antidiuretic hormone receptor 1A|vascular/hepatic-type arginine vasopressin receptor', map_location='12q14.2', chromosome='12', genomic_nucleotide_accession_version='NC_000012.12', start_position_on_the_genomic_accession=63142759, end_position_on_the_genomic_accession=63151201, orientation='minus', exon_count=2, OMIM=[600821], no_hdr0=''),
    553 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=553, CurrentID=0, Status='live', Symbol='AVPR1B', Aliases=['AVPR3', 'V1bR'], description='arginine vasopressin receptor 1B', other_designations='vasopressin V1b receptor|AVPR V1b|AVPR V3|antidiuretic hormone receptor 1B|arginine vasopressin receptor 3|pituitary vasopressin receptor 3|vasopressin V3 receptor', map_location='1q32.1', chromosome='1', genomic_nucleotide_accession_version='NC_000001.11', start_position_on_the_genomic_accession=206106936, end_position_on_the_genomic_accession=206117388, orientation='minus', exon_count=2, OMIM=[600264], no_hdr0=''),
    554 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=554, CurrentID=0, Status='live', Symbol='AVPR2', Aliases=['ADHR', 'DI1', 'DIR', 'DIR3', 'NDI', 'V2R'], description='arginine vasopressin receptor 2', other_designations='vasopressin V2 receptor|AVPR V2|antidiuretic hormone receptor|renal-type arginine vasopressin receptor', map_location='Xq28', chromosome='X', genomic_nucleotide_accession_version='NC_000023.11', start_position_on_the_genomic_accession=153902625, end_position_on_the_genomic_accession=153907166, orientation='plus', exon_count=5, OMIM=[300538], no_hdr0=''),
    558 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=558, CurrentID=0, Status='live', Symbol='AXL', Aliases=['ARK', 'JTK11', 'Tyro7', 'UFO'], description='AXL receptor tyrosine kinase', other_designations='tyrosine-protein kinase receptor UFO|AXL oncogene|AXL transforming sequence/gene', map_location='19q13.2', chromosome='19', genomic_nucleotide_accession_version='NC_000019.10', start_position_on_the_genomic_accession=41219223, end_position_on_the_genomic_accession=41261766, orientation='plus', exon_count=21, OMIM=[109135], no_hdr0=''),
    563 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=563, CurrentID=0, Status='live', Symbol='AZGP1', Aliases=['ZA2G', 'ZAG'], description='alpha-2-glycoprotein 1, zinc-binding', other_designations='zinc-alpha-2-glycoprotein|Alpha-2-glycoprotein, zinc|Zn-alpha2-glycoprotein|testicular tissue protein Li 227|zn-alpha-2-GP|zn-alpha-2-glycoprotein', map_location='7q22.1', chromosome='7', genomic_nucleotide_accession_version='NC_000007.14', start_position_on_the_genomic_accession=99966730, end_position_on_the_genomic_accession=99976031, orientation='minus', exon_count=4, OMIM=[194460], no_hdr0=''),
    566 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=566, CurrentID=0, Status='live', Symbol='AZU1', Aliases=['AZAMP', 'AZU', 'CAP37', 'HBP', 'HUMAZUR', 'NAZC', 'hHBP'], description='azurocidin 1', other_designations='azurocidin|cationic antimicrobial protein 37|cationic antimicrobial protein CAP37|heparin-binding protein|neutrophil azurocidin', map_location='19p13.3', chromosome='19', genomic_nucleotide_accession_version='NC_000019.10', start_position_on_the_genomic_accession=827837, end_position_on_the_genomic_accession=832018, orientation='plus', exon_count=5, OMIM=[162815], no_hdr0=''),
    567 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=567, CurrentID=0, Status='live', Symbol='B2M', Aliases=['IMD43'], description='beta-2-microglobulin', other_designations='beta-2-microglobulin|beta chain of MHC class I molecules|beta-2-microglobin', map_location='15q21.1', chromosome='15', genomic_nucleotide_accession_version='NC_000015.10', start_position_on_the_genomic_accession=44711492, end_position_on_the_genomic_accession=44718145, orientation='plus', exon_count=3, OMIM=[109700], no_hdr0=''),
    570 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=570, CurrentID=0, Status='live', Symbol='BAAT', Aliases=['BACAT', 'BAT'], description='bile acid-CoA:amino acid N-acyltransferase', other_designations='bile acid-CoA:amino acid N-acyltransferase|bile acid CoA: amino acid N-acyltransferase (glycine N-choloyltransferase)|bile acid Coenzyme A: amino acid N-acyltransferase (glycine N-choloyltransferase)|bile acid-CoA thioesterase|choloyl-CoA hydrolase|long-chain fatty-acyl-CoA hydrolase', map_location='9q31.1', chromosome='9', genomic_nucleotide_accession_version='NC_000009.12', start_position_on_the_genomic_accession=101360417, end_position_on_the_genomic_accession=101385006, orientation='minus', exon_count=6, OMIM=[602938], no_hdr0=''),
    571 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=571, CurrentID=0, Status='live', Symbol='BACH1', Aliases=['BACH-1', 'BTBD24'], description='BTB domain and CNC homolog 1', other_designations='transcription regulator protein BACH1|BTB and CNC homology 1, basic leucine zipper transcription factor 1|basic region leucine zipper transcriptional regulator BACH1', map_location='21q21.3', chromosome='21', genomic_nucleotide_accession_version='NC_000021.9', start_position_on_the_genomic_accession=29298922, end_position_on_the_genomic_accession=29361894, orientation='plus', exon_count=11, OMIM=[602751], no_hdr0=''),
    572 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=572, CurrentID=0, Status='live', Symbol='BAD', Aliases=['BBC2', 'BCL2L8'], description='BCL2 associated agonist of cell death', other_designations='bcl2-associated agonist of cell death|BCL-X/BCL-2 binding protein|BCL2-antagonist of cell death protein|BCL2-binding component 6|BCL2-binding protein|bcl-2-binding component 6|bcl-2-like protein 8|bcl-XL/Bcl-2-associated death promoter|bcl2 antagonist of cell death|bcl2-L-8', map_location='11q13.1', chromosome='11', genomic_nucleotide_accession_version='NC_000011.10', start_position_on_the_genomic_accession=64269828, end_position_on_the_genomic_accession=64284704, orientation='minus', exon_count=4, OMIM=[603167], no_hdr0=''),
    573 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=573, CurrentID=0, Status='live', Symbol='BAG1', Aliases=['BAG-1', 'HAP', 'RAP46'], description='BAG cochaperone 1', other_designations='BAG family molecular chaperone regulator 1|BCL2 associated athanogene 1|BCL2-associated athanogene|Bcl-2 associating athanogene-1 protein|Bcl-2-binding protein|glucocortoid receptor-associated protein RAP46|receptor-associated protein, 46-KD', map_location='9p13.3', chromosome='9', genomic_nucleotide_accession_version='NC_000009.12', start_position_on_the_genomic_accession=33252471, end_position_on_the_genomic_accession=33264708, orientation='minus', exon_count=7, OMIM=[601497], no_hdr0=''),
    574 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=574, CurrentID=0, Status='live', Symbol='BAGE', Aliases=['BAGE1', 'CT2.1'], description='B melanoma antigen', other_designations='B melanoma antigen 1|antigen MZ2-BA|cancer/testis antigen 2.1|cancer/testis antigen family 2, member 1', map_location='21p11.1', chromosome='21', genomic_nucleotide_accession_version='', start_position_on_the_genomic_accession='', end_position_on_the_genomic_accession='', orientation='', exon_count='', OMIM=[605167], no_hdr0=''),
    575 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=575, CurrentID=0, Status='live', Symbol='ADGRB1', Aliases=['BAI1', 'GDAIF'], description='adhesion G protein-coupled receptor B1', other_designations='adhesion G protein-coupled receptor B1|brain-specific angiogenesis inhibitor 1', map_location='8q24.3', chromosome='8', genomic_nucleotide_accession_version='NC_000008.11', start_position_on_the_genomic_accession=142449649, end_position_on_the_genomic_accession=142545009, orientation='plus', exon_count=33, OMIM=[602682], no_hdr0=''),
    576 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=576, CurrentID=0, Status='live', Symbol='ADGRB2', Aliases=['BAI2'], description='adhesion G protein-coupled receptor B2', other_designations='adhesion G protein-coupled receptor B2|brain-specific angiogenesis inhibitor 2', map_location='1p35.2', chromosome='1', genomic_nucleotide_accession_version='NC_000001.11', start_position_on_the_genomic_accession=31727105, end_position_on_the_genomic_accession=31764340, orientation='minus', exon_count=32, OMIM=[602683], no_hdr0=''),
    577 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=577, CurrentID=0, Status='live', Symbol='ADGRB3', Aliases=['BAI3'], description='adhesion G protein-coupled receptor B3', other_designations='adhesion G protein-coupled receptor B3|brain-specific angiogenesis inhibitor 3|dJ91B17.1 (brain-specific angiogenesis inhibitor 3)', map_location='6q12-q13', chromosome='6', genomic_nucleotide_accession_version='NC_000006.12', start_position_on_the_genomic_accession=68635282, end_position_on_the_genomic_accession=69389506, orientation='plus', exon_count=32, OMIM=[602684], no_hdr0=''),
    578 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=578, CurrentID=0, Status='live', Symbol='BAK1', Aliases=['BAK', 'BAK-LIKE', 'BCL2L7', 'CDN1'], description='BCL2 antagonist/killer 1', other_designations='bcl-2 homologous antagonist/killer|BCL2-like 7 protein|apoptosis regulator BAK|bcl-2-like protein 7|bcl2-L-7|pro-apoptotic protein BAK', map_location='6p21.31', chromosome='6', genomic_nucleotide_accession_version='NC_000006.12', start_position_on_the_genomic_accession=33572552, end_position_on_the_genomic_accession=33580296, orientation='minus', exon_count=7, OMIM=[600516], no_hdr0=''),
    579 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=579, CurrentID=0, Status='live', Symbol='NKX3-2', Aliases=['BAPX1', 'NKX3.2', 'NKX3B', 'SMMD'], description='NK3 homeobox 2', other_designations='homeobox protein Nkx-3.2|bagpipe homeobox protein homolog 1|homeobox protein NK-3 homolog B', map_location='4p15.33', chromosome='4', genomic_nucleotide_accession_version='NC_000004.12', start_position_on_the_genomic_accession=13540830, end_position_on_the_genomic_accession=13544508, orientation='minus', exon_count=2, OMIM=[602183], no_hdr0=''),
    580 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=580, CurrentID=0, Status='live', Symbol='BARD1', Aliases=[], description='BRCA1 associated RING domain 1', other_designations='BRCA1-associated RING domain protein 1|BRCA1-associated RING domain gene 1|RING-type E3 ubiquitin transferase BARD1', map_location='2q35', chromosome='2', genomic_nucleotide_accession_version='NC_000002.12', start_position_on_the_genomic_accession=214725645, end_position_on_the_genomic_accession=214809683, orientation='minus', exon_count=13, OMIM=[601593], no_hdr0=''),
    581 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=581, CurrentID=0, Status='live', Symbol='BAX', Aliases=['BCL2L4'], description='BCL2 associated X, apoptosis regulator', other_designations='apoptosis regulator BAX|BCL2 associated X protein|BCL2-associated X protein omega|Baxdelta2G9|Baxdelta2G9omega|Baxdelta2omega|bcl-2-like protein 4|bcl2-L-4', map_location='19q13.33', chromosome='19', genomic_nucleotide_accession_version='NC_000019.10', start_position_on_the_genomic_accession=48954825, end_position_on_the_genomic_accession=48961798, orientation='plus', exon_count=7, OMIM=[600040], no_hdr0=''),
    582 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=582, CurrentID=0, Status='live', Symbol='BBS1', Aliases=['BBS2L2'], description='Bardet-Biedl syndrome 1', other_designations='Bardet-Biedl syndrome 1 protein|BBS2-like protein 2', map_location='11q13.2', chromosome='11', genomic_nucleotide_accession_version='NC_000011.10', start_position_on_the_genomic_accession=66510635, end_position_on_the_genomic_accession=66533598, orientation='plus', exon_count=17, OMIM=[209901], no_hdr0=''),
    583 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=583, CurrentID=0, Status='live', Symbol='BBS2', Aliases=['BBS', 'RP74'], description='Bardet-Biedl syndrome 2', other_designations='Bardet-Biedl syndrome 2 protein', map_location='16q13', chromosome='16', genomic_nucleotide_accession_version='NC_000016.10', start_position_on_the_genomic_accession=56470403, end_position_on_the_genomic_accession=56520095, orientation='minus', exon_count=18, OMIM=[606151], no_hdr0=''),
    585 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=585, CurrentID=0, Status='live', Symbol='BBS4', Aliases=[], description='Bardet-Biedl syndrome 4', other_designations='Bardet-Biedl syndrome 4 protein', map_location='15q24.1', chromosome='15', genomic_nucleotide_accession_version='NC_000015.10', start_position_on_the_genomic_accession=72686204, end_position_on_the_genomic_accession=72738476, orientation='plus', exon_count=17, OMIM=[600374], no_hdr0=''),
    586 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=586, CurrentID=0, Status='live', Symbol='BCAT1', Aliases=['BCATC', 'BCT1', 'ECA39', 'MECA39', 'PNAS121', 'PP18'], description='branched chain amino acid transaminase 1', other_designations='branched-chain-amino-acid aminotransferase, cytosolic|branched chain amino-acid transaminase 1, cytosolic|branched chain aminotransferase 1, cytosolic|placental protein 18', map_location='12p12.1', chromosome='12', genomic_nucleotide_accession_version='NC_000012.12', start_position_on_the_genomic_accession=24810024, end_position_on_the_genomic_accession=24949101, orientation='minus', exon_count=14, OMIM=[113520], no_hdr0=''),
    587 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=587, CurrentID=0, Status='live', Symbol='BCAT2', Aliases=['BCAM', 'BCATM', 'BCT2', 'HVLI', 'PP18'], description='branched chain amino acid transaminase 2', other_designations='branched-chain-amino-acid aminotransferase, mitochondrial|branched chain amino-acid transaminase 2, mitochondrial|branched chain aminotransferase 2, mitochondrial|placental protein 18', map_location='19q13.33', chromosome='19', genomic_nucleotide_accession_version='NC_000019.10', start_position_on_the_genomic_accession=48795064, end_position_on_the_genomic_accession=48811029, orientation='minus', exon_count=13, OMIM=[113530], no_hdr0=''),
    590 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=590, CurrentID=0, Status='live', Symbol='BCHE', Aliases=['BCHED', 'CHE1', 'CHE2', 'E1'], description='butyrylcholinesterase', other_designations='cholinesterase|acylcholine acylhydrolase|butyrylcholine esterase|choline esterase II|cholinesterase (serum) 2|cholinesterase 1|pseudocholinesterase', map_location='3q26.1', chromosome='3', genomic_nucleotide_accession_version='NC_000003.12', start_position_on_the_genomic_accession=165772904, end_position_on_the_genomic_accession=165837423, orientation='minus', exon_count=5, OMIM=[177400], no_hdr0=''),
    593 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=593, CurrentID=0, Status='live', Symbol='BCKDHA', Aliases=['BCKDE1A', 'MSU', 'MSUD1', 'OVD1A'], description='branched chain keto acid dehydrogenase E1 subunit alpha', other_designations='2-oxoisovalerate dehydrogenase subunit alpha, mitochondrial|2-oxoisovalerate dehydrogenase (lipoamide)|BCKDH E1-alpha|branched chain keto acid dehydrogenase E1 alpha protein|branched chain keto acid dehydrogenase E1, alpha polypeptide|branched-chain alpha-keto acid dehydrogenase E1 component alpha chain', map_location='19q13.2', chromosome='19', genomic_nucleotide_accession_version='NC_000019.10', start_position_on_the_genomic_accession=41397818, end_position_on_the_genomic_accession=41425002, orientation='plus', exon_count=9, OMIM=[608348], no_hdr0=''),
    594 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=594, CurrentID=0, Status='live', Symbol='BCKDHB', Aliases=['BCKDE1B', 'BCKDH E1-beta', 'E1B'], description='branched chain keto acid dehydrogenase E1 subunit beta', other_designations='2-oxoisovalerate dehydrogenase subunit beta, mitochondrial|E1b-beta subunit of the branched-chain complex|branched chain alpha-ketoacid dehydrogenase E1-beta subunit|branched chain keto acid dehydrogenase E1, beta polypeptide|branched-chain alpha-keto acid dehydrogenase E1 component beta chain|testis secretory sperm-binding protein Li 240mP', map_location='6q14.1', chromosome='6', genomic_nucleotide_accession_version='NC_000006.12', start_position_on_the_genomic_accession=80106610, end_position_on_the_genomic_accession=80469088, orientation='plus', exon_count=22, OMIM=[248611], no_hdr0=''),
    595 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=595, CurrentID=0, Status='live', Symbol='CCND1', Aliases=['BCL1', 'D11S287E', 'PRAD1', 'U21B31'], description='cyclin D1', other_designations='G1/S-specific cyclin-D1|B-cell CLL/lymphoma 1|B-cell lymphoma 1 protein|BCL-1 oncogene|PRAD1 oncogene', map_location='11q13.3', chromosome='11', genomic_nucleotide_accession_version='NC_000011.10', start_position_on_the_genomic_accession=69641156, end_position_on_the_genomic_accession=69654474, orientation='plus', exon_count=5, OMIM=[168461], no_hdr0=''),
    596 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=596, CurrentID=0, Status='live', Symbol='BCL2', Aliases=['Bcl-2', 'PPP1R50'], description='BCL2 apoptosis regulator', other_designations='apoptosis regulator Bcl-2|B-cell CLL/lymphoma 2|protein phosphatase 1, regulatory subunit 50', map_location='18q21.33', chromosome='18', genomic_nucleotide_accession_version='NC_000018.10', start_position_on_the_genomic_accession=63123346, end_position_on_the_genomic_accession=63320280, orientation='minus', exon_count=6, OMIM=[151430], no_hdr0=''),
    597 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=597, CurrentID=0, Status='live', Symbol='BCL2A1', Aliases=['ACC-1', 'ACC-2', 'ACC1', 'ACC2', 'BCL2L5', 'BFL1', 'GRS', 'HBPA1'], description='BCL2 related protein A1', other_designations='bcl-2-related protein A1|bcl-2-like protein 5|bcl2-L-5|hematopoietic BCL2-related protein A1|hemopoietic-specific early response protein|protein BFL-1', map_location='15q25.1', chromosome='15', genomic_nucleotide_accession_version='NC_000015.10', start_position_on_the_genomic_accession=79960892, end_position_on_the_genomic_accession=79971196, orientation='minus', exon_count=3, OMIM=[601056], no_hdr0=''),
    598 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=598, CurrentID=0, Status='live', Symbol='BCL2L1', Aliases=['BCL-XL/S', 'BCL2L', 'BCLX', 'Bcl-X', 'PPP1R52'], description='BCL2 like 1', other_designations='bcl-2-like protein 1|apoptosis regulator Bcl-X|protein phosphatase 1, regulatory subunit 52', map_location='20q11.21', chromosome='20', genomic_nucleotide_accession_version='NC_000020.11', start_position_on_the_genomic_accession=31664452, end_position_on_the_genomic_accession=31723963, orientation='minus', exon_count=6, OMIM=[600039], no_hdr0=''),
    599 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=599, CurrentID=0, Status='live', Symbol='BCL2L2', Aliases=['BCL-W', 'BCL2-L-2', 'BCLW', 'PPP1R51'], description='BCL2 like 2', other_designations='bcl-2-like protein 2|apoptosis regulator BCL-W|protein phosphatase 1, regulatory subunit 51', map_location='14q11.2', chromosome='14', genomic_nucleotide_accession_version='NC_000014.9', start_position_on_the_genomic_accession=23306833, end_position_on_the_genomic_accession=23311751, orientation='plus', exon_count=4, OMIM=[601931], no_hdr0=''),
    602 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=602, CurrentID=0, Status='live', Symbol='BCL3', Aliases=['BCL4', 'D19S37'], description='BCL3 transcription coactivator', other_designations='B-cell lymphoma 3 protein|B cell CLL/lymphoma 3|B-cell leukemia/lymphoma 3|B-cell lymphoma 3-encoded protein|BCL-3|chronic lymphatic leukemia protein|proto-oncogene BCL3', map_location='19q13.32', chromosome='19', genomic_nucleotide_accession_version='NC_000019.10', start_position_on_the_genomic_accession=44742620, end_position_on_the_genomic_accession=44760044, orientation='plus', exon_count=13, OMIM=[109560], no_hdr0=''),
    604 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=604, CurrentID=0, Status='live', Symbol='BCL6', Aliases=['BCL5A', 'LAZ3', 'ZBTB27', 'ZNF51', 'BCL6'], description='BCL6 transcription repressor', other_designations='B-cell lymphoma 6 protein|B cell CLL/lymphoma 6|B-cell lymphoma 5 protein|B-cell lymphoma 6 protein transcript|BCL-5|BCL-6|cys-his2 zinc finger transcription factor|lymphoma-associated zinc finger gene on chromosome 3|protein LAZ-3|zinc finger and BTB domain-containing protein 27|zinc finger protein 51|zinc finger transcription factor BCL6S', map_location='3q27.3', chromosome='3', genomic_nucleotide_accession_version='NC_000003.12', start_position_on_the_genomic_accession=187721377, end_position_on_the_genomic_accession=187745472, orientation='minus', exon_count=12, OMIM=[109565], no_hdr0=''),
    605 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=605, CurrentID=0, Status='live', Symbol='BCL7A', Aliases=['BCL7'], description='BAF chromatin remodeling complex subunit BCL7A', other_designations='B-cell CLL/lymphoma 7 protein family member A|B-cell CLL/lymphoma 7A|B-cell CLL/lymphoma-7|BCL tumor suppressor 7A|BCL7A, BAF complex component', map_location='12q24.31', chromosome='12', genomic_nucleotide_accession_version='NC_000012.12', start_position_on_the_genomic_accession=122021884, end_position_on_the_genomic_accession=122062044, orientation='plus', exon_count=6, OMIM=[601406], no_hdr0=''),
    607 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=607, CurrentID=0, Status='live', Symbol='BCL9', Aliases=['LGS'], description='BCL9 transcription coactivator', other_designations='B-cell CLL/lymphoma 9 protein|B cell CLL/lymphoma 9|B-cell lymphoma 9 protein|bcl-9|protein legless homolog', map_location='1q21.2', chromosome='1', genomic_nucleotide_accession_version='NC_000001.11', start_position_on_the_genomic_accession=147541501, end_position_on_the_genomic_accession=147626217, orientation='plus', exon_count=11, OMIM=[602597], no_hdr0=''),
    608 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=608, CurrentID=0, Status='live', Symbol='TNFRSF17', Aliases=['BCM', 'BCMA', 'CD269', 'TNFRSF13A'], description='TNF receptor superfamily member 17', other_designations='tumor necrosis factor receptor superfamily member 17|B cell maturation antigen|B-cell maturation factor|B-cell maturation protein', map_location='16p13.13', chromosome='16', genomic_nucleotide_accession_version='NC_000016.10', start_position_on_the_genomic_accession=11965210, end_position_on_the_genomic_accession=11968068, orientation='plus', exon_count=3, OMIM=[109545], no_hdr0=''),
    610 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=610, CurrentID=0, Status='live', Symbol='HCN2', Aliases=['BCNG-2', 'BCNG2', 'HAC-1'], description='hyperpolarization activated cyclic nucleotide gated potassium and sodium channel 2', other_designations='potassium/sodium hyperpolarization-activated cyclic nucleotide-gated channel 2|brain cyclic nucleotide-gated channel 2|hyperpolarization activated cyclic nucleotide gated potassium channel 2', map_location='19p13.3', chromosome='19', genomic_nucleotide_accession_version='NC_000019.10', start_position_on_the_genomic_accession=589881, end_position_on_the_genomic_accession=617159, orientation='plus', exon_count=8, OMIM=[602781], no_hdr0=''),
    611 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=611, CurrentID=0, Status='live', Symbol='OPN1SW', Aliases=['BCP', 'BOP', 'CBT'], description='opsin 1, short wave sensitive', other_designations='short-wave-sensitive opsin 1|blue cone photoreceptor pigment|blue-sensitive opsin|opsin 1 (cone pigments), short-wave-sensitive', map_location='7q32.1', chromosome='7', genomic_nucleotide_accession_version='NC_000007.14', start_position_on_the_genomic_accession=128772485, end_position_on_the_genomic_accession=128775794, orientation='minus', exon_count=5, OMIM=[613522], no_hdr0=''),
    613 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=613, CurrentID=0, Status='live', Symbol='BCR', Aliases=['ALL1', 'CML', 'D22S11', 'D22S662', 'PHL', 'BCR'], description='BCR activator of RhoGEF and GTPase', other_designations='breakpoint cluster region protein|BCR, RhoGEF and GTPase activating protein|BCR/FGFR1 chimera protein|FGFR1/BCR chimera protein|breakpoint cluster region|renal carcinoma antigen NY-REN-26', map_location='22q11.23', chromosome='22', genomic_nucleotide_accession_version='NC_000022.11', start_position_on_the_genomic_accession=23180509, end_position_on_the_genomic_accession=23318037, orientation='plus', exon_count=23, OMIM=[151410], no_hdr0=''),
    617 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=617, CurrentID=0, Status='live', Symbol='BCS1L', Aliases=['BCS', 'BCS1', 'BJS', 'FLNMS', 'GRACILE', 'Hs.6719', 'MC3DN1', 'PTD', 'h-BCS', 'h-BCS1'], description='BCS1 homolog, ubiquinol-cytochrome c reductase complex chaperone', other_designations='mitochondrial chaperone BCS1|BC1 (ubiquinol-cytochrome c reductase) synthesis-like|BCS1-like protein|mitochondrial complex III assembly', map_location='2q35', chromosome='2', genomic_nucleotide_accession_version='NC_000002.12', start_position_on_the_genomic_accession=218659683, end_position_on_the_genomic_accession=218663443, orientation='plus', exon_count=8, OMIM=[603647], no_hdr0=''),
    622 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=622, CurrentID=0, Status='live', Symbol='BDH1', Aliases=['BDH', 'SDR9C1'], description='3-hydroxybutyrate dehydrogenase 1', other_designations='D-beta-hydroxybutyrate dehydrogenase, mitochondrial|(R)-3-hydroxybutyrate dehydrogenase|3-hydroxybutyrate dehydrogenase (heart, mitochondrial)|3-hydroxybutyrate dehydrogenase, type 1|epididymis secretory sperm binding protein|short chain dehydrogenase/reductase family 9C member 1', map_location='3q29', chromosome='3', genomic_nucleotide_accession_version='NC_000003.12', start_position_on_the_genomic_accession=197509783, end_position_on_the_genomic_accession=197573343, orientation='minus', exon_count=19, OMIM=[603063], no_hdr0=''),
    623 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=623, CurrentID=0, Status='live', Symbol='BDKRB1', Aliases=['B1BKR', 'B1R', 'BKB1R', 'BKR1', 'BRADYB1'], description='bradykinin receptor B1', other_designations='B1 bradykinin receptor|BK-1 receptor|bradykinin B1 receptor|bradykinin receptor 1', map_location='14q32.2', chromosome='14', genomic_nucleotide_accession_version='NC_000014.9', start_position_on_the_genomic_accession=96256210, end_position_on_the_genomic_accession=96264763, orientation='plus', exon_count=3, OMIM=[600337], no_hdr0=''),
    624 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=624, CurrentID=0, Status='live', Symbol='BDKRB2', Aliases=['B2R', 'BK-2', 'BK2', 'BKR2', 'BRB2'], description='bradykinin receptor B2', other_designations='B2 bradykinin receptor|BK-2 receptor', map_location='14q32.2', chromosome='14', genomic_nucleotide_accession_version='NC_000014.9', start_position_on_the_genomic_accession=96204839, end_position_on_the_genomic_accession=96244164, orientation='plus', exon_count=3, OMIM=[113503], no_hdr0=''),
    627 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=627, CurrentID=0, Status='live', Symbol='BDNF', Aliases=['ANON2', 'BULN2'], description='brain derived neurotrophic factor', other_designations='brain-derived neurotrophic factor|abrineurin|neurotrophin', map_location='11p14.1', chromosome='11', genomic_nucleotide_accession_version='NC_000011.10', start_position_on_the_genomic_accession=27654893, end_position_on_the_genomic_accession=27722030, orientation='minus', exon_count=12, OMIM=[113505], no_hdr0=''),
    629 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=629, CurrentID=0, Status='live', Symbol='CFB', Aliases=['AHUS4', 'ARMD14', 'BF', 'BFD', 'CFABD', 'FB', 'FBI12', 'GBG', 'H2-Bf', 'PBF2', 'CFB'], description='complement factor B', other_designations='complement factor B|B-factor, properdin|C3 proaccelerator|C3 proactivator|C3/C5 convertase|glycine-rich beta-glycoprotein|properdin factor B', map_location='6p21.33', chromosome='6', genomic_nucleotide_accession_version='NC_000006.12', start_position_on_the_genomic_accession=31946095, end_position_on_the_genomic_accession=31952084, orientation='plus', exon_count=18, OMIM=[138470], no_hdr0=''),
    631 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=631, CurrentID=0, Status='live', Symbol='BFSP1', Aliases=['CP115', 'CP94', 'CTRCT33', 'LIFL-H'], description='beaded filament structural protein 1', other_designations='filensin|beaded filament structural protein 1, filensin|cytoskeletal protein, 115 KD|lens fiber cell beaded-filament structural protein CP 115|lens intermediate filament-like heavy', map_location='20p12.1', chromosome='20', genomic_nucleotide_accession_version='NC_000020.11', start_position_on_the_genomic_accession=17493905, end_position_on_the_genomic_accession=17569220, orientation='minus', exon_count=13, OMIM=[603307], no_hdr0=''),
    632 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=632, CurrentID=0, Status='live', Symbol='BGLAP', Aliases=['BGP', 'OC', 'OCN'], description='bone gamma-carboxyglutamate protein', other_designations='osteocalcin|bone gamma-carboxyglutamate (gla) protein (osteocalcin)|gamma-carboxyglutamic acid-containing protein', map_location='1q22', chromosome='1', genomic_nucleotide_accession_version='NC_000001.11', start_position_on_the_genomic_accession=156242184, end_position_on_the_genomic_accession=156243317, orientation='plus', exon_count=4, OMIM=[112260], no_hdr0=''),
    633 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=633, CurrentID=0, Status='live', Symbol='BGN', Aliases=['DSPG1', 'MRLS', 'PG-S1', 'PGI', 'SEMDX', 'SLRR1A'], description='biglycan', other_designations='biglycan|bone/cartilage proteoglycan-I|dermatan sulphate proteoglycan I|small leucine-rich protein 1A', map_location='Xq28', chromosome='X', genomic_nucleotide_accession_version='NC_000023.11', start_position_on_the_genomic_accession=153494980, end_position_on_the_genomic_accession=153509546, orientation='plus', exon_count=8, OMIM=[301870], no_hdr0=''),
    634 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=634, CurrentID=0, Status='live', Symbol='CEACAM1', Aliases=['BGP', 'BGP1', 'BGPI'], description='CEA cell adhesion molecule 1', other_designations='carcinoembryonic antigen-related cell adhesion molecule 1|CD66a antigen|antigen CD66|carcinoembryonic antigen related cell adhesion molecule 1|carcinoembryonic antigen-related cell adhesion molecule 1 (biliary glycoprotein)', map_location='19q13.2', chromosome='19', genomic_nucleotide_accession_version='NC_000019.10', start_position_on_the_genomic_accession=42507306, end_position_on_the_genomic_accession=42528482, orientation='minus', exon_count=10, OMIM=[109770], no_hdr0=''),
    635 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=635, CurrentID=0, Status='live', Symbol='BHMT', Aliases=['BHMT1', 'HEL-S-61p'], description='betaine--homocysteine S-methyltransferase', other_designations='betaine--homocysteine S-methyltransferase 1|epididymis secretory sperm binding protein Li 61p', map_location='5q14.1', chromosome='5', genomic_nucleotide_accession_version='NC_000005.10', start_position_on_the_genomic_accession=79111809, end_position_on_the_genomic_accession=79132288, orientation='plus', exon_count=8, OMIM=[602888], no_hdr0=''),
    636 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=636, CurrentID=0, Status='live', Symbol='BICD1', Aliases=['BICD', 'bic-D 1'], description='BICD cargo adaptor 1', other_designations='protein bicaudal D homolog 1|bicaudal D homolog 1|cytoskeleton-like bicaudal D protein homolog 1', map_location='12p11.21', chromosome='12', genomic_nucleotide_accession_version='NC_000012.12', start_position_on_the_genomic_accession=32106773, end_position_on_the_genomic_accession=32383637, orientation='plus', exon_count=13, OMIM=[602204], no_hdr0=''),
    637 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=637, CurrentID=0, Status='live', Symbol='BID', Aliases=['FP497'], description='BH3 interacting domain death agonist', other_designations='BH3-interacting domain death agonist|Human BID coding sequence|apoptic death agonist|desmocollin type 4|p22 BID', map_location='22q11.21', chromosome='22', genomic_nucleotide_accession_version='NC_000022.11', start_position_on_the_genomic_accession=17734138, end_position_on_the_genomic_accession=17774665, orientation='minus', exon_count=8, OMIM=[601997], no_hdr0=''),
    638 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=638, CurrentID=0, Status='live', Symbol='BIK', Aliases=['BIP1', 'BP4', 'NBK'], description='BCL2 interacting killer', other_designations='bcl-2-interacting killer|BCL2-interacting killer (apoptosis-inducing)|apoptosis inducer NBK|apoptosis-inducing NBK|natural born killer', map_location='22q13.2', chromosome='22', genomic_nucleotide_accession_version='NC_000022.11', start_position_on_the_genomic_accession=43110750, end_position_on_the_genomic_accession=43129712, orientation='plus', exon_count=5, OMIM=[603392], no_hdr0=''),
    639 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=639, CurrentID=0, Status='live', Symbol='PRDM1', Aliases=['BLIMP1', 'PRDI-BF1'], description='PR/SET domain 1', other_designations='PR domain zinc finger protein 1|B-lymphocyte-induced maturation protein 1|BLIMP-1|PR domain 1|PR domain containing 1, with ZNF domain|PRDI-binding factor-1|beta-interferon gene positive-regulatory domain I binding factor', map_location='6q21', chromosome='6', genomic_nucleotide_accession_version='NC_000006.12', start_position_on_the_genomic_accession=106046729, end_position_on_the_genomic_accession=106109938, orientation='plus', exon_count=11, OMIM=[603423], no_hdr0=''),
    640 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=640, CurrentID=0, Status='live', Symbol='BLK', Aliases=['MODY11'], description='BLK proto-oncogene, Src family tyrosine kinase', other_designations='tyrosine-protein kinase Blk|B lymphoid tyrosine kinase|BLK nonreceptor tyrosine kinase|b lymphocyte kinase|p55-Blk', map_location='8p23.1', chromosome='8', genomic_nucleotide_accession_version='NC_000008.11', start_position_on_the_genomic_accession=11493991, end_position_on_the_genomic_accession=11564599, orientation='plus', exon_count=15, OMIM=[191305], no_hdr0=''),
    641 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=641, CurrentID=0, Status='live', Symbol='BLM', Aliases=['BS', 'MGRISCE1', 'RECQ2', 'RECQL2', 'RECQL3'], description='BLM RecQ like helicase', other_designations='Bloom syndrome protein|Bloom syndrome RecQ like helicase|Bloom syndrome, RecQ helicase-like|DNA helicase, RecQ-like type 2|recQ protein-like 3', map_location='15q26.1', chromosome='15', genomic_nucleotide_accession_version='NC_000015.10', start_position_on_the_genomic_accession=90717346, end_position_on_the_genomic_accession=90816166, orientation='plus', exon_count=25, OMIM=[604610], no_hdr0=''),
    642 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=642, CurrentID=0, Status='live', Symbol='BLMH', Aliases=['BH', 'BMH'], description='bleomycin hydrolase', other_designations='bleomycin hydrolase|BLM hydrolase', map_location='17q11.2', chromosome='17', genomic_nucleotide_accession_version='NC_000017.11', start_position_on_the_genomic_accession=30248203, end_position_on_the_genomic_accession=30291944, orientation='minus', exon_count=12, OMIM=[602403], no_hdr0=''),
    643 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=643, CurrentID=0, Status='live', Symbol='CXCR5', Aliases=['BLR1', 'CD185', 'MDR15'], description='C-X-C motif chemokine receptor 5', other_designations='C-X-C chemokine receptor type 5|Burkitt lymphoma receptor 1, GTP binding protein (chemokine (C-X-C motif) receptor 5)|Burkitt lymphoma receptor 1, GTP-binding protein|CXC-R5|CXCR-5|MDR-15|chemokine (C-X-C motif) receptor 5|monocyte-derived receptor 15', map_location='11q23.3', chromosome='11', genomic_nucleotide_accession_version='NC_000011.10', start_position_on_the_genomic_accession=118883892, end_position_on_the_genomic_accession=118897787, orientation='plus', exon_count=2, OMIM=[601613], no_hdr0=''),
    644 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=644, CurrentID=0, Status='live', Symbol='BLVRA', Aliases=['BLVR', 'BVR', 'BVRA'], description='biliverdin reductase A', other_designations='biliverdin reductase A|BVR A|biliverdin-IX alpha-reductase|testis tissue sperm-binding protein Li 61n', map_location='7p13', chromosome='7', genomic_nucleotide_accession_version='NC_000007.14', start_position_on_the_genomic_accession=43758122, end_position_on_the_genomic_accession=43807342, orientation='plus', exon_count=12, OMIM=[109750], no_hdr0=''),
    645 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=645, CurrentID=0, Status='live', Symbol='BLVRB', Aliases=['BVRB', 'FLR', 'HEL-S-10', 'SDR43U1'], description='biliverdin reductase B', other_designations='flavin reductase (NADPH)|BVR-B|FR|GHBP|NADPH-dependent diaphorase|NADPH-flavin reductase|biliverdin-IX beta-reductase|epididymis secretory protein Li 10|green heme-binding protein|short chain dehydrogenase/reductase family 43U, member 1', map_location='19q13.2', chromosome='19', genomic_nucleotide_accession_version='NC_000019.10', start_position_on_the_genomic_accession=40447768, end_position_on_the_genomic_accession=40465745, orientation='minus', exon_count=5, OMIM=[600941], no_hdr0=''),
    646 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=646, CurrentID=0, Status='live', Symbol='BNC1', Aliases=['BNC', 'BSN1', 'HsT19447', 'POF16'], description='basonuclin 1', other_designations='zinc finger protein basonuclin-1', map_location='15q25.2', chromosome='15', genomic_nucleotide_accession_version='NC_000015.10', start_position_on_the_genomic_accession=83255884, end_position_on_the_genomic_accession=83284664, orientation='minus', exon_count=7, OMIM=[601930], no_hdr0=''),
    648 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=648, CurrentID=0, Status='live', Symbol='BMI1', Aliases=['FLVI2/BMI1', 'PCGF4', 'RNF51', 'flvi-2/bmi-1'], description='BMI1 proto-oncogene, polycomb ring finger', other_designations='polycomb complex protein BMI-1|B lymphoma Mo-MLV insertion region 1 homolog|BMI1 polycomb ring finger oncogene|BMI1 polycomb ring finger proto-oncogene|murine leukemia viral (bmi-1) oncogene homolog|polycomb group RING finger protein 4|polycomb group protein Bmi1|ring finger protein 51', map_location='10p12.2', chromosome='10', genomic_nucleotide_accession_version='NC_000010.11', start_position_on_the_genomic_accession=22321099, end_position_on_the_genomic_accession=22331484, orientation='plus', exon_count=10, OMIM=[164831], no_hdr0=''),
    649 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=649, CurrentID=0, Status='live', Symbol='BMP1', Aliases=['OI13', 'PCOLC', 'PCP', 'PCP2', 'TLD'], description='bone morphogenetic protein 1', other_designations='bone morphogenetic protein 1|mammalian tolloid protein|procollagen C-endopeptidase|procollagen C-proteinase 3|tolloid-like', map_location='8p21.3', chromosome='8', genomic_nucleotide_accession_version='NC_000008.11', start_position_on_the_genomic_accession=22165372, end_position_on_the_genomic_accession=22212326, orientation='plus', exon_count=21, OMIM=[112264], no_hdr0=''),
    650 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=650, CurrentID=0, Status='live', Symbol='BMP2', Aliases=['BDA2A', 'SSFSC', 'BMP2'], description='bone morphogenetic protein 2', other_designations='bone morphogenetic protein 2|bone morphogenetic protein 2A', map_location='20p12.3', chromosome='20', genomic_nucleotide_accession_version='NC_000020.11', start_position_on_the_genomic_accession=6767686, end_position_on_the_genomic_accession=6780246, orientation='plus', exon_count=3, OMIM=[112261], no_hdr0=''),
    651 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=651, CurrentID=0, Status='live', Symbol='BMP3', Aliases=['BMP-3A'], description='bone morphogenetic protein 3', other_designations='bone morphogenetic protein 3|bone morphogenetic protein 3 (osteogenic)|bone morphogenetic protein 3A|osteogenin', map_location='4q21.21', chromosome='4', genomic_nucleotide_accession_version='NC_000004.12', start_position_on_the_genomic_accession=81030708, end_position_on_the_genomic_accession=81057627, orientation='plus', exon_count=3, OMIM=[112263], no_hdr0=''),
    652 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=652, CurrentID=0, Status='live', Symbol='BMP4', Aliases=['BMP2B', 'BMP2B1', 'MCOPS6', 'OFC11', 'ZYME'], description='bone morphogenetic protein 4', other_designations='bone morphogenetic protein 4|bone morphogenetic protein 2B', map_location='14q22.2', chromosome='14', genomic_nucleotide_accession_version='NC_000014.9', start_position_on_the_genomic_accession=53949736, end_position_on_the_genomic_accession=53956891, orientation='minus', exon_count=6, OMIM=[112262], no_hdr0=''),
    653 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=653, CurrentID=0, Status='live', Symbol='BMP5', Aliases=[], description='bone morphogenetic protein 5', other_designations='bone morphogenetic protein 5', map_location='6p12.1', chromosome='6', genomic_nucleotide_accession_version='NC_000006.12', start_position_on_the_genomic_accession=55753653, end_position_on_the_genomic_accession=55875590, orientation='minus', exon_count=9, OMIM=[112265], no_hdr0=''),
    654 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=654, CurrentID=0, Status='live', Symbol='BMP6', Aliases=['VGR', 'VGR1'], description='bone morphogenetic protein 6', other_designations='bone morphogenetic protein 6|VG-1-R|VG-1-related protein|vegetal related growth factor (TGFB-related)', map_location='6p24.3', chromosome='6', genomic_nucleotide_accession_version='NC_000006.12', start_position_on_the_genomic_accession=7726099, end_position_on_the_genomic_accession=7881728, orientation='plus', exon_count=7, OMIM=[112266], no_hdr0=''),
    655 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=655, CurrentID=0, Status='live', Symbol='BMP7', Aliases=['OP-1'], description='bone morphogenetic protein 7', other_designations='bone morphogenetic protein 7|osteogenic protein 1', map_location='20q13.31', chromosome='20', genomic_nucleotide_accession_version='NC_000020.11', start_position_on_the_genomic_accession=57168753, end_position_on_the_genomic_accession=57266641, orientation='minus', exon_count=7, OMIM=[112267], no_hdr0=''),
    656 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=656, CurrentID=0, Status='live', Symbol='BMP8B', Aliases=['BMP8', 'OP2'], description='bone morphogenetic protein 8b', other_designations='bone morphogenetic protein 8B|bone morphogenetic protein 8 (osteogenic protein 2)|osteogenic protein 2', map_location='1p34.2', chromosome='1', genomic_nucleotide_accession_version='NC_000001.11', start_position_on_the_genomic_accession=39757182, end_position_on_the_genomic_accession=39788865, orientation='minus', exon_count=12, OMIM=[602284], no_hdr0=''),
    657 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=657, CurrentID=0, Status='live', Symbol='BMPR1A', Aliases=['10q23del', 'ACVRLK3', 'ALK3', 'CD292', 'SKR5'], description='bone morphogenetic protein receptor type 1A', other_designations='bone morphogenetic protein receptor type-1A|ALK-3|BMP type-1A receptor|BMPR-1A|activin A receptor, type II-like kinase 3|activin receptor-like kinase 3|bone morphogenetic protein receptor, type IA|serine/threonine-protein kinase receptor R5', map_location='10q23.2', chromosome='10', genomic_nucleotide_accession_version='NC_000010.11', start_position_on_the_genomic_accession=86755786, end_position_on_the_genomic_accession=86927969, orientation='plus', exon_count=15, OMIM=[601299], no_hdr0=''),
    658 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=658, CurrentID=0, Status='live', Symbol='BMPR1B', Aliases=['ALK-6', 'ALK6', 'AMDD', 'BDA1D', 'BDA2', 'CDw293'], description='bone morphogenetic protein receptor type 1B', other_designations='bone morphogenetic protein receptor type-1B|BMP type-1B receptor|BMPR-1B|activin receptor-like kinase 6|bone morphogenetic protein receptor, type IB|serine/threonine receptor kinase', map_location='4q22.3', chromosome='4', genomic_nucleotide_accession_version='NC_000004.12', start_position_on_the_genomic_accession=94757955, end_position_on_the_genomic_accession=95158453, orientation='plus', exon_count=18, OMIM=[603248], no_hdr0=''),
    659 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=659, CurrentID=0, Status='live', Symbol='BMPR2', Aliases=['BMPR-II', 'BMPR3', 'BMR2', 'BRK-3', 'POVD1', 'PPH1', 'T-ALK'], description='bone morphogenetic protein receptor type 2', other_designations='bone morphogenetic protein receptor type-2|BMP type II receptor|BMP type-2 receptor|bone morphogenetic protein receptor type II|bone morphogenetic protein receptor, type II (serine/threonine kinase)|type II activin receptor-like kinase|type II receptor for bone morphogenetic protein-4', map_location='2q33.1-q33.2', chromosome='2', genomic_nucleotide_accession_version='NC_000002.12', start_position_on_the_genomic_accession=202376310, end_position_on_the_genomic_accession=202567751, orientation='plus', exon_count=13, OMIM=[600799], no_hdr0=''),
    660 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=660, CurrentID=0, Status='live', Symbol='BMX', Aliases=['ETK', 'PSCTK2', 'PSCTK3'], description='BMX non-receptor tyrosine kinase', other_designations='cytoplasmic tyrosine-protein kinase BMX|BTK-like on X chromosome|Etk/Bmx cytosolic tyrosine kinase|NTK38 tyrosine kinase|bone marrow tyrosine kinase gene in chromosome X protein|epithelial and endothelial tyrosine kinase', map_location='Xp22.2', chromosome='X', genomic_nucleotide_accession_version='NC_000023.11', start_position_on_the_genomic_accession=15500777, end_position_on_the_genomic_accession=15556519, orientation='plus', exon_count=20, OMIM=[300101], no_hdr0=''),
    661 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=661, CurrentID=0, Status='live', Symbol='POLR3D', Aliases=['BN51T', 'C53', 'RPC4', 'RPC53', 'TSBN51'], description='RNA polymerase III subunit D', other_designations='DNA-directed RNA polymerase III subunit RPC4|BN51 (BHK21) temperature sensitivity complementing|DNA-directed RNA polymerase III 47 kDa polypeptide|DNA-directed RNA polymerase III subunit D|RNA polymerase III 47 kDa subunit|RNA polymerase III subunit C4|RPC53 homolog|polymerase (RNA) III (DNA directed) polypeptide D, 44kDa|polymerase (RNA) III subunit D|temperature sensitive complementation, cell cycle specific, tsBN51', map_location='8p21.3', chromosome='8', genomic_nucleotide_accession_version='NC_000008.11', start_position_on_the_genomic_accession=22245104, end_position_on_the_genomic_accession=22254601, orientation='plus', exon_count=9, OMIM=[187280], no_hdr0=''),
    662 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=662, CurrentID=0, Status='live', Symbol='BNIP1', Aliases=['NIP1', 'SEC20', 'TRG-8'], description='BCL2 interacting protein 1', other_designations='vesicle transport protein SEC20|BCL2/adenovirus E1B 19 kDa protein-interacting protein 1|BCL2/adenovirus E1B 19kDa interacting protein 1|transformation-related gene 8 protein', map_location='5q35.1', chromosome='5', genomic_nucleotide_accession_version='NC_000005.10', start_position_on_the_genomic_accession=173144447, end_position_on_the_genomic_accession=173164387, orientation='plus', exon_count=9, OMIM=[603291], no_hdr0=''),
    663 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=663, CurrentID=0, Status='live', Symbol='BNIP2', Aliases=['BNIP-2', 'NIP2'], description='BCL2 interacting protein 2', other_designations='BCL2/adenovirus E1B 19 kDa protein-interacting protein 2|BCL2/adenovirus E1B 19kDa interacting protein 2', map_location='15q22.2', chromosome='15', genomic_nucleotide_accession_version='NC_000015.10', start_position_on_the_genomic_accession=59659146, end_position_on_the_genomic_accession=59689320, orientation='minus', exon_count=12, OMIM=[603292], no_hdr0=''),
    664 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=664, CurrentID=0, Status='live', Symbol='BNIP3', Aliases=['NIP3'], description='BCL2 interacting protein 3', other_designations='BCL2/adenovirus E1B 19 kDa protein-interacting protein 3|BCL2/adenovirus E1B 19kDa interacting protein 3|BCL2/adenovirus E1B interacting protein 3|nineteen kD interacting protein-3', map_location='10q26.3', chromosome='10', genomic_nucleotide_accession_version='NC_000010.11', start_position_on_the_genomic_accession=131967683, end_position_on_the_genomic_accession=131982013, orientation='minus', exon_count=6, OMIM=[603293], no_hdr0=''),
    665 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=665, CurrentID=0, Status='live', Symbol='BNIP3L', Aliases=['BNIP3a', 'NIX'], description='BCL2 interacting protein 3 like', other_designations='BCL2/adenovirus E1B 19 kDa protein-interacting protein 3-like|BCL2/adenovirus E1B 19 kDa protein-interacting protein 3A|BCL2/adenovirus E1B 19-kd protein-interacting protein 3a|BCL2/adenovirus E1B 19kDa interacting protein 3 like|NIP-3-like protein X|NIP3-like protein X|NIP3L|adenovirus E1B19k-binding protein B5', map_location='8p21.2', chromosome='8', genomic_nucleotide_accession_version='NC_000008.11', start_position_on_the_genomic_accession=26383054, end_position_on_the_genomic_accession=26413127, orientation='plus', exon_count=7, OMIM=[605368], no_hdr0=''),
    666 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=666, CurrentID=0, Status='live', Symbol='BOK', Aliases=['BCL2L9L', 'BOK'], description='BCL2 family apoptosis regulator BOK', other_designations='bcl-2-related ovarian killer protein|BCL2 related ovarian killer|BOK, BCL2 family apoptosis regulator|bcl-2-like protein 9|bcl2-L-9|hBOK', map_location='2q37.3', chromosome='2', genomic_nucleotide_accession_version='NC_000002.12', start_position_on_the_genomic_accession=241558745, end_position_on_the_genomic_accession=241574131, orientation='plus', exon_count=7, OMIM=[605404], no_hdr0=''),
    667 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=667, CurrentID=0, Status='live', Symbol='DST', Aliases=['BP240', 'BPA', 'BPAG1', 'CATX-15', 'CATX15', 'D6S1101', 'DMH', 'DT', 'EBSB2', 'HSAN6', 'MACF2'], description='dystonin', other_designations='dystonin|bullous pemphigoid antigen|bullous pemphigoid antigen 1|dystonia musculorum protein|hemidesmosomal plaque protein|trabeculin-beta', map_location='6p12.1', chromosome='6', genomic_nucleotide_accession_version='NC_000006.12', start_position_on_the_genomic_accession=56457996, end_position_on_the_genomic_accession=56954830, orientation='minus', exon_count=112, OMIM=[113810], no_hdr0=''),
    668 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=668, CurrentID=0, Status='live', Symbol='FOXL2', Aliases=['BPES', 'BPES1', 'PFRK', 'PINTO', 'POF3'], description='forkhead box L2', other_designations='forkhead box protein L2|forkhead transcription factor FOXL2', map_location='3q22.3', chromosome='3', genomic_nucleotide_accession_version='NC_000003.12', start_position_on_the_genomic_accession=138944224, end_position_on_the_genomic_accession=138947137, orientation='minus', exon_count=1, OMIM=[605597], no_hdr0=''),
    669 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=669, CurrentID=0, Status='live', Symbol='BPGM', Aliases=['DPGM', 'ECYT8'], description='bisphosphoglycerate mutase', other_designations='bisphosphoglycerate mutase|2,3-bisphosphoglycerate mutase, erythrocyte|2,3-bisphosphoglycerate synthase|2,3-diphosphoglycerate mutase|BPG-dependent PGAM|erythrocyte 2,3-bisphosphoglycerate mutase|testis secretory sperm-binding protein Li 202a', map_location='7q33', chromosome='7', genomic_nucleotide_accession_version='NC_000007.14', start_position_on_the_genomic_accession=134646853, end_position_on_the_genomic_accession=134679816, orientation='plus', exon_count=6, OMIM=[613896], no_hdr0=''),
    670 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=670, CurrentID=0, Status='live', Symbol='BPHL', Aliases=['BPH-RP', 'MCNAA', 'VACVASE'], description='biphenyl hydrolase like', other_designations='valacyclovir hydrolase|biphenyl hydrolase-like (serine hydrolase)|biphenyl hydrolase-related protein|breast epithelial mucin-associated antigen|valacyclovirase', map_location='6p25.2', chromosome='6', genomic_nucleotide_accession_version='NC_000006.12', start_position_on_the_genomic_accession=3118376, end_position_on_the_genomic_accession=3153599, orientation='plus', exon_count=10, OMIM=[603156], no_hdr0=''),
    671 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=671, CurrentID=0, Status='live', Symbol='BPI', Aliases=['BPIFD1', 'rBPI'], description='bactericidal permeability increasing protein', other_designations='bactericidal permeability-increasing protein|BPI fold containing family D, member 1|CAP 57|recombinant BPI holoprotein, rBPI', map_location='20q11.23', chromosome='20', genomic_nucleotide_accession_version='NC_000020.11', start_position_on_the_genomic_accession=38304156, end_position_on_the_genomic_accession=38337505, orientation='plus', exon_count=16, OMIM=[109195], no_hdr0=''),
    672 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=672, CurrentID=0, Status='live', Symbol='BRCA1', Aliases=['BRCAI', 'BRCC1', 'BROVCA1', 'FANCS', 'IRIS', 'PNCA4', 'PPP1R53', 'PSCP', 'RNF53'], description='BRCA1 DNA repair associated', other_designations='breast cancer type 1 susceptibility protein|BRCA1/BRCA2-containing complex, subunit 1|Fanconi anemia, complementation group S|RING finger protein 53|breast and ovarian cancer susceptibility protein 1|breast cancer 1, early onset|early onset breast cancer 1|protein phosphatase 1, regulatory subunit 53', map_location='17q21.31', chromosome='17', genomic_nucleotide_accession_version='NC_000017.11', start_position_on_the_genomic_accession=43044295, end_position_on_the_genomic_accession=43125364, orientation='minus', exon_count=24, OMIM=[113705], no_hdr0=''),
    673 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=673, CurrentID=0, Status='live', Symbol='BRAF', Aliases=['B-RAF1', 'B-raf1', 'NS7', 'RAFB1', 'BRAF'], description='B-Raf proto-oncogene, serine/threonine kinase', other_designations='serine/threonine-protein kinase B-raf|94 kDa B-raf protein|B-Raf proto-oncogene serine/threonine-protein kinase (p94)|B-Raf serine/threonine-protein|murine sarcoma viral (v-raf) oncogene homolog B1|proto-oncogene B-Raf|v-raf murine sarcoma viral oncogene homolog B|v-raf murine sarcoma viral oncogene homolog B1', map_location='7q34', chromosome='7', genomic_nucleotide_accession_version='NC_000007.14', start_position_on_the_genomic_accession=140713328, end_position_on_the_genomic_accession=140924929, orientation='minus', exon_count=23, OMIM=[164757], no_hdr0=''),
    675 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=675, CurrentID=0, Status='live', Symbol='BRCA2', Aliases=['BRCC2', 'BROVCA2', 'FACD', 'FAD', 'FAD1', 'FANCD', 'FANCD1', 'GLM3', 'PNCA2', 'XRCC11'], description='BRCA2 DNA repair associated', other_designations='breast cancer type 2 susceptibility protein|BRCA1/BRCA2-containing complex, subunit 2|Fanconi anemia group D1 protein|breast and ovarian cancer susceptibility gene, early onset|breast and ovarian cancer susceptibility protein 2|breast cancer 2 tumor suppressor|breast cancer 2, early onset|mutant BRCA2|truncated BRCA2 DNA repair-associated protein|truncated breast cancer 2', map_location='13q13.1', chromosome='13', genomic_nucleotide_accession_version='NC_000013.11', start_position_on_the_genomic_accession=32315508, end_position_on_the_genomic_accession=32400268, orientation='plus', exon_count=27, OMIM=[600185], no_hdr0=''),
    676 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=676, CurrentID=0, Status='live', Symbol='BRDT', Aliases=['BRD6', 'CT9', 'SPGF21'], description='bromodomain testis associated', other_designations='bromodomain testis-specific protein|RING3-like protein|bromodomain, testis-specific|cancer/testis antigen 9', map_location='1p22.1', chromosome='1', genomic_nucleotide_accession_version='NC_000001.11', start_position_on_the_genomic_accession=91949371, end_position_on_the_genomic_accession=92014428, orientation='plus', exon_count=21, OMIM=[602144], no_hdr0=''),
    677 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=677, CurrentID=0, Status='live', Symbol='ZFP36L1', Aliases=['BRF1', 'Berg36', 'ERF-1', 'ERF1', 'RNF162B', 'TIS11B', 'cMG1'], description='ZFP36 ring finger protein like 1', other_designations='mRNA decay activator protein ZFP36L1|EGF-response factor 1|TPA-induced sequence 11b|ZFP36-like 1|butyrate response factor 1|early response factor Berg36|zinc finger protein 36, C3H type-like 1|zinc finger protein 36, C3H1 type-like 1|zinc finger protein, C3H type, 36-like 1', map_location='14q24.1', chromosome='14', genomic_nucleotide_accession_version='NC_000014.9', start_position_on_the_genomic_accession=68787655, end_position_on_the_genomic_accession=68796243, orientation='minus', exon_count=4, OMIM=[601064], no_hdr0=''),
    678 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=678, CurrentID=0, Status='live', Symbol='ZFP36L2', Aliases=['BRF2', 'ERF-2', 'ERF2', 'RNF162C', 'TIS11D'], description='ZFP36 ring finger protein like 2', other_designations='mRNA decay activator protein ZFP36L2|EGF-response factor 2|TPA-induced sequence 11d|ZFP36-like 2|butyrate response factor 2 (EGF-response factor 2)|zinc finger protein 36, C3H type-like 1|zinc finger protein 36, C3H type-like 2|zinc finger protein 36, C3H1 type-like 2|zinc finger protein, C3H type, 36-like 2', map_location='2p21', chromosome='2', genomic_nucleotide_accession_version='NC_000002.12', start_position_on_the_genomic_accession=43222402, end_position_on_the_genomic_accession=43226606, orientation='minus', exon_count=2, OMIM=[612053], no_hdr0=''),
    680 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=680, CurrentID=0, Status='live', Symbol='BRS3', Aliases=['BB3', 'BB3R', 'BBR3'], description='bombesin receptor subtype 3', other_designations='bombesin receptor subtype-3|BRS-3|G-protein coupled receptor|bombesin like receptor 3', map_location='Xq26.3', chromosome='X', genomic_nucleotide_accession_version='NC_000023.11', start_position_on_the_genomic_accession=136487947, end_position_on_the_genomic_accession=136493780, orientation='plus', exon_count=3, OMIM=[300107], no_hdr0=''),
    682 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=682, CurrentID=0, Status='live', Symbol='BSG', Aliases=['5F7', 'CD147', 'EMMPRIN', 'EMPRIN', 'OK', 'SLC7A11', 'TCSF'], description='basigin (Ok blood group)', other_designations='basigin|OK blood group antigen|collagenase stimulatory factor|extracellular matrix metalloproteinase inducer|leukocyte activation antigen M6|tumor cell-derived collagenase stimulatory factor', map_location='19p13.3', chromosome='19', genomic_nucleotide_accession_version='NC_000019.10', start_position_on_the_genomic_accession=571283, end_position_on_the_genomic_accession=583493, orientation='plus', exon_count=10, OMIM=[109480], no_hdr0=''),
    683 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=683, CurrentID=0, Status='live', Symbol='BST1', Aliases=['CD157'], description='bone marrow stromal cell antigen 1', other_designations='ADP-ribosyl cyclase/cyclic ADP-ribose hydrolase 2|ADP-ribosyl cyclase 2|NAD(+) nucleosidase|bone marrow stromal antigen 1|bone marrow stromal cell antigen 1 variant 2|cADPr hydrolase 2|cyclic ADP-ribose hydrolase 2', map_location='4p15.32', chromosome='4', genomic_nucleotide_accession_version='NC_000004.12', start_position_on_the_genomic_accession=15701866, end_position_on_the_genomic_accession=15774178, orientation='plus', exon_count=15, OMIM=[600387], no_hdr0=''),
    684 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=684, CurrentID=0, Status='live', Symbol='BST2', Aliases=['CD317', 'TETHERIN'], description='bone marrow stromal cell antigen 2', other_designations='bone marrow stromal antigen 2|BST-2|HM1.24 antigen|NPC-A-7', map_location='19p13.11', chromosome='19', genomic_nucleotide_accession_version='NC_000019.10', start_position_on_the_genomic_accession=17402939, end_position_on_the_genomic_accession=17405630, orientation='minus', exon_count=5, OMIM=[600534], no_hdr0=''),
    685 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=685, CurrentID=0, Status='live', Symbol='BTC', Aliases=[], description='betacellulin', other_designations='probetacellulin', map_location='4q13.3', chromosome='4', genomic_nucleotide_accession_version='NC_000004.12', start_position_on_the_genomic_accession=74744759, end_position_on_the_genomic_accession=74794718, orientation='minus', exon_count=8, OMIM=[600345], no_hdr0=''),
    686 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=686, CurrentID=0, Status='live', Symbol='BTD', Aliases=[], description='biotinidase', other_designations='biotinidase|biotinase', map_location='3p25.1', chromosome='3', genomic_nucleotide_accession_version='NC_000003.12', start_position_on_the_genomic_accession=15601352, end_position_on_the_genomic_accession=15722516, orientation='plus', exon_count=11, OMIM=[609019], no_hdr0=''),
    687 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=687, CurrentID=0, Status='live', Symbol='KLF9', Aliases=['BTEB', 'BTEB1'], description='Kruppel like factor 9', other_designations='Krueppel-like factor 9|BTE-binding protein 1|GC-box-binding protein 1|basic transcription element-binding protein 1|transcription factor BTEB1', map_location='9q21.12', chromosome='9', genomic_nucleotide_accession_version='NC_000009.12', start_position_on_the_genomic_accession=70384597, end_position_on_the_genomic_accession=70414657, orientation='minus', exon_count=2, OMIM=[602902], no_hdr0=''),
    688 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=688, CurrentID=0, Status='live', Symbol='KLF5', Aliases=['BTEB2', 'CKLF', 'IKLF'], description='Kruppel like factor 5', other_designations='Krueppel-like factor 5|(intestinal Kruppel-like factor|BTE-binding protein 2|GC box binding protein 2|Kruppel-like factor 5 (intestinal)|basic transcription element binding protein 2|colon krueppel-like factor|colon kruppel-like factor|epididymis secretory sperm binding protein|intestinal-enriched krueppel-like factor|intestinal-enriched kruppel-like factor|transcription factor BTEB2', map_location='13q22.1', chromosome='13', genomic_nucleotide_accession_version='NC_000013.11', start_position_on_the_genomic_accession=73054976, end_position_on_the_genomic_accession=73077538, orientation='plus', exon_count=5, OMIM=[602903], no_hdr0=''),
    689 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=689, CurrentID=0, Status='live', Symbol='BTF3', Aliases=['BETA-NACa', 'BTF3b', 'NACB', 'BTF3'], description='basic transcription factor 3', other_designations='transcription factor BTF3|NAC-beta|RNA polymerase B transcription factor 3|nascent polypeptide-associated complex subunit beta|nascent-polypeptide-associated complex beta polypeptide', map_location='5q13.2', chromosome='5', genomic_nucleotide_accession_version='NC_000005.10', start_position_on_the_genomic_accession=73498442, end_position_on_the_genomic_accession=73505667, orientation='plus', exon_count=6, OMIM=[602542], no_hdr0=''),
    694 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=694, CurrentID=0, Status='live', Symbol='BTG1', Aliases=['APRO2'], description='BTG anti-proliferation factor 1', other_designations='protein BTG1|B-cell translocation gene 1 protein|B-cell translocation gene 1, anti-proliferative', map_location='12q21.33', chromosome='12', genomic_nucleotide_accession_version='NC_000012.12', start_position_on_the_genomic_accession=92140278, end_position_on_the_genomic_accession=92145846, orientation='minus', exon_count=2, OMIM=[109580], no_hdr0=''),
    695 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=695, CurrentID=0, Status='live', Symbol='BTK', Aliases=['AGMX1', 'AT', 'ATK', 'BPK', 'IGHD3', 'IMD1', 'PSCTK1', 'XLA'], description='Bruton tyrosine kinase', other_designations="tyrosine-protein kinase BTK|B-cell progenitor kinase|Bruton agammaglobulinemia tyrosine kinase|Bruton's tyrosine kinase|agammaglobulinaemia tyrosine kinase|dominant-negative kinase-deficient Brutons tyrosine kinase|truncated Bruton agammaglobulinemia tyrosine kinase", map_location='Xq22.1', chromosome='X', genomic_nucleotide_accession_version='NC_000023.11', start_position_on_the_genomic_accession=101349450, end_position_on_the_genomic_accession=101390796, orientation='minus', exon_count=21, OMIM=[300300], no_hdr0=''),
    696 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=696, CurrentID=0, Status='live', Symbol='BTN1A1', Aliases=['BT', 'BTN', 'BTN1'], description='butyrophilin subfamily 1 member A1', other_designations='butyrophilin subfamily 1 member A1|bK14H9.2 (butyrophilin, subfamily 1, member A1)', map_location='6p22.2', chromosome='6', genomic_nucleotide_accession_version='NC_000006.12', start_position_on_the_genomic_accession=26500303, end_position_on_the_genomic_accession=26510425, orientation='plus', exon_count=8, OMIM=[601610], no_hdr0=''),
    699 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=699, CurrentID=0, Status='live', Symbol='BUB1', Aliases=['BUB1AL', 'hBUB1', 'BUB1'], description='BUB1 mitotic checkpoint serine/threonine kinase', other_designations='mitotic checkpoint serine/threonine-protein kinase BUB1|BUB1 budding uninhibited by benzimidazoles 1 homolog|budding uninhibited by benzimidazoles 1 homolog|mitotic spindle checkpoint kinase|putative serine/threonine-protein kinase', map_location='2q13', chromosome='2', genomic_nucleotide_accession_version='NC_000002.12', start_position_on_the_genomic_accession=110637528, end_position_on_the_genomic_accession=110678063, orientation='minus', exon_count=25, OMIM=[602452], no_hdr0=''),
    701 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=701, CurrentID=0, Status='live', Symbol='BUB1B', Aliases=['BUB1beta', 'BUBR1', 'Bub1A', 'MAD3L', 'MVA1', 'SSK1', 'hBUBR1'], description='BUB1 mitotic checkpoint serine/threonine kinase B', other_designations='mitotic checkpoint serine/threonine-protein kinase BUB1 beta|BUB1B, mitotic checkpoint serine/threonine kinase|MAD3/BUB1-related protein kinase|budding uninhibited by benzimidazoles 1 homolog beta|mitotic checkpoint kinase MAD3L', map_location='15q15.1', chromosome='15', genomic_nucleotide_accession_version='NC_000015.10', start_position_on_the_genomic_accession=40161069, end_position_on_the_genomic_accession=40221123, orientation='plus', exon_count=23, OMIM=[602860], no_hdr0=''),
    705 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=705, CurrentID=0, Status='live', Symbol='BYSL', Aliases=['BYSTIN', 'Enp1'], description='bystin like', other_designations='bystin|by the ribosomal protein s6 gene, drosophila, homolog-like', map_location='6p21.1', chromosome='6', genomic_nucleotide_accession_version='NC_000006.12', start_position_on_the_genomic_accession=41921499, end_position_on_the_genomic_accession=41933046, orientation='plus', exon_count=7, OMIM=[603871], no_hdr0=''),
    706 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=706, CurrentID=0, Status='live', Symbol='TSPO', Aliases=['BPBS', 'BZRP', 'DBI', 'IBP', 'MBR', 'PBR', 'PBS', 'PKBS', 'PTBR', 'mDRC', 'pk18'], description='translocator protein', other_designations='translocator protein|benzodiazepine peripheral binding site|mitochondrial benzodiazepine receptor|peripheral-type benzodiazepine receptor', map_location='22q13.2', chromosome='22', genomic_nucleotide_accession_version='NC_000022.11', start_position_on_the_genomic_accession=43151559, end_position_on_the_genomic_accession=43163242, orientation='plus', exon_count=5, OMIM=[109610], no_hdr0=''),
    708 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=708, CurrentID=0, Status='live', Symbol='C1QBP', Aliases=['COXPD33', 'GC1QBP', 'HABP1', 'SF2AP32', 'SF2p32', 'gC1Q-R', 'gC1qR', 'p32'], description='complement C1q binding protein', other_designations='complement component 1 Q subcomponent-binding protein, mitochondrial|ASF/SF2-associated protein p32|C1q globular domain-binding protein|complement component 1, q subcomponent binding protein|glycoprotein gC1qBP|hyaluronan-binding protein 1|mitochondrial matrix protein p32|p33|splicing factor SF2-associated protein', map_location='17p13.2', chromosome='17', genomic_nucleotide_accession_version='NC_000017.11', start_position_on_the_genomic_accession=5432777, end_position_on_the_genomic_accession=5439155, orientation='minus', exon_count=6, OMIM=[601269], no_hdr0=''),
    710 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=710, CurrentID=0, Status='live', Symbol='SERPING1', Aliases=['C1IN', 'C1INH', 'C1NH', 'HAE1', 'HAE2'], description='serpin family G member 1', other_designations='plasma protease C1 inhibitor|C1 esterase inhibitor|C1-inhibiting factor|C1-inhibitor|complement component 1 inhibitor|epididymis secretory sperm binding protein|serine/cysteine proteinase inhibitor clade G member 1|serpin G1|serpin peptidase inhibitor clade G member 1|serpin peptidase inhibitor, clade G (C1 inhibitor), member 1', map_location='11q12.1', chromosome='11', genomic_nucleotide_accession_version='NC_000011.10', start_position_on_the_genomic_accession=57597685, end_position_on_the_genomic_accession=57614848, orientation='plus', exon_count=8, OMIM=[606860], no_hdr0=''),
    712 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=712, CurrentID=0, Status='live', Symbol='C1QA', Aliases=[], description='complement C1q A chain', other_designations='complement C1q subcomponent subunit A|complement C1q chain A|complement component 1, q subcomponent, A chain|complement component 1, q subcomponent, alpha polypeptide|complement component C1q, A chain', map_location='1p36.12', chromosome='1', genomic_nucleotide_accession_version='NC_000001.11', start_position_on_the_genomic_accession=22636463, end_position_on_the_genomic_accession=22639678, orientation='plus', exon_count=3, OMIM=[120550], no_hdr0=''),
    713 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=713, CurrentID=0, Status='live', Symbol='C1QB', Aliases=[], description='complement C1q B chain', other_designations='complement C1q subcomponent subunit B|complement C1q chain B|complement component 1, q subcomponent, B chain|complement component 1, q subcomponent, beta polypeptide|complement component C1q, B chain|complement subcomponent C1q chain B', map_location='1p36.12', chromosome='1', genomic_nucleotide_accession_version='NC_000001.11', start_position_on_the_genomic_accession=22653236, end_position_on_the_genomic_accession=22661637, orientation='plus', exon_count=4, OMIM=[120570], no_hdr0=''),
    714 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=714, CurrentID=0, Status='live', Symbol='C1QC', Aliases=['C1Q-C', 'C1QG'], description='complement C1q C chain', other_designations='complement C1q subcomponent subunit C|complement component 1, q subcomponent, C chain|complement component 1, q subcomponent, gamma polypeptide', map_location='1p36.12', chromosome='1', genomic_nucleotide_accession_version='NC_000001.11', start_position_on_the_genomic_accession=22643633, end_position_on_the_genomic_accession=22648108, orientation='plus', exon_count=3, OMIM=[120575], no_hdr0=''),
    715 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=715, CurrentID=0, Status='live', Symbol='C1R', Aliases=['EDSPD1'], description='complement C1r', other_designations='complement C1r subcomponent|complement component 1, r subcomponent', map_location='12p13.31', chromosome='12', genomic_nucleotide_accession_version='NC_000012.12', start_position_on_the_genomic_accession=7080219, end_position_on_the_genomic_accession=7092445, orientation='minus', exon_count=12, OMIM=[613785], no_hdr0=''),
    716 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=716, CurrentID=0, Status='live', Symbol='C1S', Aliases=['EDSPD2'], description='complement C1s', other_designations='complement C1s subcomponent|C1 esterase|basic proline-rich peptide IB-1|complement component 1 subcomponent s|complement component 1, s subcomponent', map_location='12p13.31', chromosome='12', genomic_nucleotide_accession_version='NC_000012.12', start_position_on_the_genomic_accession=7060718, end_position_on_the_genomic_accession=7071032, orientation='plus', exon_count=13, OMIM=[120580], no_hdr0=''),
    717 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=717, CurrentID=0, Status='live', Symbol='C2', Aliases=['ARMD14', 'CO2'], description='complement C2', other_designations='complement C2|C3/C5 convertase|complement component 2|complement component C2', map_location='6p21.33', chromosome='6', genomic_nucleotide_accession_version='NC_000006.12', start_position_on_the_genomic_accession=31897783, end_position_on_the_genomic_accession=31945672, orientation='plus', exon_count=20, OMIM=[613927], no_hdr0=''),
    718 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=718, CurrentID=0, Status='live', Symbol='C3', Aliases=['AHUS5', 'ARMD9', 'ASPa', 'C3b', 'CPAMD1', 'HEL-S-62p', 'C3'], description='complement C3', other_designations='complement C3|C3 and PZP-like alpha-2-macroglobulin domain-containing protein 1|C3a anaphylatoxin|acylation-stimulating protein cleavage product|complement component 3|complement component C3a|complement component C3b|epididymis secretory sperm binding protein Li 62p|prepro-C3', map_location='19p13.3', chromosome='19', genomic_nucleotide_accession_version='NC_000019.10', start_position_on_the_genomic_accession=6677704, end_position_on_the_genomic_accession=6720650, orientation='minus', exon_count=41, OMIM=[120700], no_hdr0=''),
    719 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=719, CurrentID=0, Status='live', Symbol='C3AR1', Aliases=['AZ3B', 'C3AR', 'HNFAG09'], description='complement C3a receptor 1', other_designations='C3a anaphylatoxin chemotactic receptor|complement component 3 receptor 1|complement component 3a receptor 1', map_location='12p13.31', chromosome='12', genomic_nucleotide_accession_version='NC_000012.12', start_position_on_the_genomic_accession=8056844, end_position_on_the_genomic_accession=8066359, orientation='minus', exon_count=2, OMIM=[605246], no_hdr0=''),
    720 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=720, CurrentID=0, Status='live', Symbol='C4A', Aliases=['C42', 'C4A3', 'C4A4', 'C4A6', 'C4AD', 'C4S', 'CO4', 'CPAMD2', 'RG', 'C4A'], description='complement C4A (Rodgers blood group)', other_designations='complement C4-A|C3 and PZP-like alpha-2-macroglobulin domain-containing protein 2|C4A anaphylatoxin|MHC class III region complement|Rodgers form of C4|acidic C4|acidic complement C4|complement component 4A (Rodgers blood group)', map_location='6p21.33', chromosome='6', genomic_nucleotide_accession_version='NC_000006.12', start_position_on_the_genomic_accession=31982057, end_position_on_the_genomic_accession=32002681, orientation='plus', exon_count=41, OMIM=[120810], no_hdr0=''),
    721 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=721, CurrentID=0, Status='live', Symbol='C4B', Aliases=['C4B112', 'C4B2', 'C4B3', 'C4B5', 'C4BD', 'C4B_2', 'C4F', 'CH', 'CO4', 'CPAMD3', 'C4B'], description='complement C4B (Chido blood group)', other_designations='complement C4-B|C3 and PZP-like alpha-2-macroglobulin domain-containing protein 3|Chido form of C4|basic complement C4|complement C4B1a|complement component 4B (Chido blood group)', map_location='6p21.33', chromosome='6', genomic_nucleotide_accession_version='NC_000006.12', start_position_on_the_genomic_accession=32014795, end_position_on_the_genomic_accession=32035418, orientation='plus', exon_count=41, OMIM=[120820], no_hdr0=''),
    722 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=722, CurrentID=0, Status='live', Symbol='C4BPA', Aliases=['C4BP', 'PRP'], description='complement component 4 binding protein alpha', other_designations='C4b-binding protein alpha chain|proline-rich protein', map_location='1q32.2', chromosome='1', genomic_nucleotide_accession_version='NC_000001.11', start_position_on_the_genomic_accession=207104232, end_position_on_the_genomic_accession=207144972, orientation='plus', exon_count=12, OMIM=[120830], no_hdr0=''),
    725 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=725, CurrentID=0, Status='live', Symbol='C4BPB', Aliases=['C4BP'], description='complement component 4 binding protein beta', other_designations='C4b-binding protein beta chain', map_location='1q32.1', chromosome='1', genomic_nucleotide_accession_version='NC_000001.11', start_position_on_the_genomic_accession=207088795, end_position_on_the_genomic_accession=207099993, orientation='plus', exon_count=9, OMIM=[120831], no_hdr0=''),
    726 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=726, CurrentID=0, Status='live', Symbol='CAPN5', Aliases=['ADNIV', 'HTRA3', 'VRNI', 'nCL-3'], description='calpain 5', other_designations='calpain-5|calpain htra-3|new calpain 3|testis tissue sperm-binding protein Li 91mP', map_location='11q13.5', chromosome='11', genomic_nucleotide_accession_version='NC_000011.10', start_position_on_the_genomic_accession=77066971, end_position_on_the_genomic_accession=77126155, orientation='plus', exon_count=15, OMIM=[602537], no_hdr0=''),
    727 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=727, CurrentID=0, Status='live', Symbol='C5', Aliases=['C5Da', 'C5b', 'CPAMD4', 'ECLZB', 'C5'], description='complement C5', other_designations='complement C5|C3 and PZP-like alpha-2-macroglobulin domain-containing protein 4|C5a anaphylatoxin|anaphylatoxin C5a analog|complement component 5|prepro-C5', map_location='9q33.2', chromosome='9', genomic_nucleotide_accession_version='NC_000009.12', start_position_on_the_genomic_accession=120952335, end_position_on_the_genomic_accession=121074865, orientation='minus', exon_count=43, OMIM=[120900], no_hdr0=''),
    728 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=728, CurrentID=0, Status='live', Symbol='C5AR1', Aliases=['C5A', 'C5AR', 'C5R1', 'CD88'], description='complement C5a receptor 1', other_designations='C5a anaphylatoxin chemotactic receptor 1|C5a anaphylatoxin receptor|C5a ligand|C5a-R|complement component 5a receptor 1', map_location='19q13.32', chromosome='19', genomic_nucleotide_accession_version='NC_000019.10', start_position_on_the_genomic_accession=47309861, end_position_on_the_genomic_accession=47322066, orientation='plus', exon_count=3, OMIM=[113995], no_hdr0=''),
    729 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=729, CurrentID=0, Status='live', Symbol='C6', Aliases=[], description='complement C6', other_designations='complement component C6|complement component 6', map_location='5p13.1', chromosome='5', genomic_nucleotide_accession_version='NC_000005.10', start_position_on_the_genomic_accession=41142116, end_position_on_the_genomic_accession=41261486, orientation='minus', exon_count=23, OMIM=[217050], no_hdr0=''),
    730 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=730, CurrentID=0, Status='live', Symbol='C7', Aliases=[], description='complement C7', other_designations='complement component C7|complement component 7', map_location='5p13.1', chromosome='5', genomic_nucleotide_accession_version='NC_000005.10', start_position_on_the_genomic_accession=40909497, end_position_on_the_genomic_accession=40984643, orientation='plus', exon_count=18, OMIM=[217070], no_hdr0=''),
    731 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=731, CurrentID=0, Status='live', Symbol='C8A', Aliases=[], description='complement C8 alpha chain', other_designations='complement component C8 alpha chain|complement component 8 alpha subunit|complement component 8 subunit alpha|complement component 8, alpha polypeptide', map_location='1p32.2', chromosome='1', genomic_nucleotide_accession_version='NC_000001.11', start_position_on_the_genomic_accession=56854796, end_position_on_the_genomic_accession=56918223, orientation='plus', exon_count=13, OMIM=[120950], no_hdr0=''),
    732 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=732, CurrentID=0, Status='live', Symbol='C8B', Aliases=['C82'], description='complement C8 beta chain', other_designations='complement component C8 beta chain|complement component 8 subunit beta|complement component 8, beta polypeptide', map_location='1p32.2', chromosome='1', genomic_nucleotide_accession_version='NC_000001.11', start_position_on_the_genomic_accession=56929207, end_position_on_the_genomic_accession=56974383, orientation='minus', exon_count=15, OMIM=[120960], no_hdr0=''),
    733 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=733, CurrentID=0, Status='live', Symbol='C8G', Aliases=['C8C'], description='complement C8 gamma chain', other_designations='complement component C8 gamma chain|complement component 8, gamma polypeptide', map_location='9q34.3', chromosome='9', genomic_nucleotide_accession_version='NC_000009.12', start_position_on_the_genomic_accession=136944870, end_position_on_the_genomic_accession=136946981, orientation='plus', exon_count=7, OMIM=[120930], no_hdr0=''),
    734 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=734, CurrentID=0, Status='live', Symbol='OSGIN2', Aliases=['C8orf1', 'hT41'], description='oxidative stress induced growth inhibitor family member 2', other_designations='oxidative stress-induced growth inhibitor 2', map_location='8q21.3', chromosome='8', genomic_nucleotide_accession_version='NC_000008.11', start_position_on_the_genomic_accession=89901868, end_position_on_the_genomic_accession=89935614, orientation='plus', exon_count=9, OMIM=[604598], no_hdr0=''),
    735 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=735, CurrentID=0, Status='live', Symbol='C9', Aliases=['ARMD15D', 'C9'], description='complement C9', other_designations='complement component C9|complement component 9', map_location='5p13.1', chromosome='5', genomic_nucleotide_accession_version='NC_000005.10', start_position_on_the_genomic_accession=39284140, end_position_on_the_genomic_accession=39364495, orientation='minus', exon_count=11, OMIM=[120940], no_hdr0=''),
    738 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=738, CurrentID=0, Status='live', Symbol='VPS51', Aliases=['ANG2', 'ANG3', 'C11orf2', 'C11orf3', 'FFR', 'PCH13'], description='VPS51 subunit of GARP complex', other_designations='vacuolar protein sorting-associated protein 51 homolog|VPS51, GARP complex subunit|another new gene 2 protein|protein fat-free homolog|vacuolar protein sorting 51 homolog', map_location='11q13.1', chromosome='11', genomic_nucleotide_accession_version='NC_000011.10', start_position_on_the_genomic_accession=65096214, end_position_on_the_genomic_accession=65111862, orientation='plus', exon_count=10, OMIM=[615738], no_hdr0=''),
    740 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=740, CurrentID=0, Status='live', Symbol='MRPL49', Aliases=['C11orf4', 'L49mt', 'MRP-L49', 'NOF', 'NOF1'], description='mitochondrial ribosomal protein L49', other_designations='39S ribosomal protein L49, mitochondrial|mitochondrial large ribosomal subunit protein mL49|neighbor of FAU|next to FAU', map_location='11q13.1', chromosome='11', genomic_nucleotide_accession_version='NC_000011.10', start_position_on_the_genomic_accession=65122183, end_position_on_the_genomic_accession=65127371, orientation='plus', exon_count=4, OMIM=[606866], no_hdr0=''),
    741 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=741, CurrentID=0, Status='live', Symbol='ZNHIT2', Aliases=['C11orf5', 'FON'], description='zinc finger HIT-type containing 2', other_designations='zinc finger HIT domain-containing protein 2|zinc finger, HIT domain containing 2|zinc finger, HIT type 2', map_location='11q13.1', chromosome='11', genomic_nucleotide_accession_version='NC_000011.10', start_position_on_the_genomic_accession=65116403, end_position_on_the_genomic_accession=65117701, orientation='minus', exon_count=1, OMIM=[604575], no_hdr0=''),
    744 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=744, CurrentID=0, Status='live', Symbol='MPPED2', Aliases=['239FB', 'C11orf8'], description='metallophosphoesterase domain containing 2', other_designations='metallophosphoesterase MPPED2|fetal brain protein 239|metallophosphoesterase domain-containing protein 2', map_location='11p14.1', chromosome='11', genomic_nucleotide_accession_version='NC_000011.10', start_position_on_the_genomic_accession=30384079, end_position_on_the_genomic_accession=30586995, orientation='minus', exon_count=19, OMIM=[600911], no_hdr0=''),
    745 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=745, CurrentID=0, Status='live', Symbol='MYRF', Aliases=['11orf9', 'C11orf9', 'CUGS', 'MMERV', 'MRF', 'Ndt80', 'pqn-47'], description='myelin regulatory factor', other_designations='myelin regulatory factor|myelin gene regulatory factor', map_location='11q12.2', chromosome='11', genomic_nucleotide_accession_version='NC_000011.10', start_position_on_the_genomic_accession=61752617, end_position_on_the_genomic_accession=61788518, orientation='plus', exon_count=29, OMIM=[608329], no_hdr0=''),
    746 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=746, CurrentID=0, Status='live', Symbol='TMEM258', Aliases=['C11orf10', 'Kud', 'Kuduk'], description='transmembrane protein 258', other_designations='transmembrane protein 258|UPF0197 transmembrane protein C11orf10|dolichyl-diphosphooligosaccharide--protein glycosyltransferase subunit TMEM258|oligosaccharyl transferase subunit TMEM258', map_location='11q12.2', chromosome='11', genomic_nucleotide_accession_version='NC_000011.10', start_position_on_the_genomic_accession=61788949, end_position_on_the_genomic_accession=61792599, orientation='minus', exon_count=4, OMIM=[617615], no_hdr0=''),
    747 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=747, CurrentID=0, Status='live', Symbol='DAGLA', Aliases=['C11orf11', 'DAGL(ALPHA)LPHA', 'NSDDR', 'DAGLA'], description='diacylglycerol lipase alpha', other_designations='diacylglycerol lipase-alpha|DAGL-alpha|DGL-alpha|neural stem cell-derived dendrite regulator|sn1-specific diacylglycerol lipase alpha', map_location='11q12.2', chromosome='11', genomic_nucleotide_accession_version='NC_000011.10', start_position_on_the_genomic_accession=61680184, end_position_on_the_genomic_accession=61747002, orientation='plus', exon_count=23, OMIM=[614015], no_hdr0=''),
    752 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=752, CurrentID=0, Status='live', Symbol='FMNL1', Aliases=['C17orf1', 'C17orf1B', 'FHOD4', 'FMNL', 'KW-13'], description='formin like 1', other_designations='formin-like protein 1|CLL-associated antigen KW-13|leukocyte formin', map_location='17q21.31', chromosome='17', genomic_nucleotide_accession_version='NC_000017.11', start_position_on_the_genomic_accession=45220268, end_position_on_the_genomic_accession=45247322, orientation='plus', exon_count=27, OMIM=[604656], no_hdr0=''),
    753 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=753, CurrentID=0, Status='live', Symbol='LDLRAD4', Aliases=['C18orf1'], description='low density lipoprotein receptor class A domain containing 4', other_designations='low-density lipoprotein receptor class A domain-containing protein 4|clone 22', map_location='18p11.21', chromosome='18', genomic_nucleotide_accession_version='NC_000018.10', start_position_on_the_genomic_accession=13217606, end_position_on_the_genomic_accession=13652754, orientation='plus', exon_count=33, OMIM=[606571], no_hdr0=''),
    754 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=754, CurrentID=0, Status='live', Symbol='PTTG1IP', Aliases=['C21orf1', 'C21orf3', 'PBF'], description='PTTG1 interacting protein', other_designations='pituitary tumor-transforming gene 1 protein-interacting protein|PTTG-binding factor|pituitary tumor-transforming 1 interacting protein|pituitary tumor-transforming gene protein-binding factor', map_location='21q22.3', chromosome='21', genomic_nucleotide_accession_version='NC_000021.9', start_position_on_the_genomic_accession=44849598, end_position_on_the_genomic_accession=44873690, orientation='minus', exon_count=6, OMIM=[603784], no_hdr0=''),
    755 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=755, CurrentID=0, Status='live', Symbol='CFAP410', Aliases=['C21orf2', 'LRRC76', 'RDMS', 'SMDAX', 'YF5/A2'], description='cilia and flagella associated protein 410', other_designations='cilia- and flagella-associated protein 410|nuclear encoded mitochondrial protein C21orf2|C21orf-HUMF09G8.5|leucine rich repeat containing 76|leucine-rich repeat-containing protein 76|protein C21orf2', map_location='21q22.3', chromosome='21', genomic_nucleotide_accession_version='NC_000021.9', start_position_on_the_genomic_accession=44328944, end_position_on_the_genomic_accession=44339417, orientation='minus', exon_count=10, OMIM=[603191], no_hdr0=''),
    757 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=757, CurrentID=0, Status='live', Symbol='TMEM50B', Aliases=['C21orf4', 'HCVP7TP3'], description='transmembrane protein 50B', other_designations='transmembrane protein 50B|HCV p7-trans-regulated protein 3|HCV p7-transregulated protein 3', map_location='21q22.11', chromosome='21', genomic_nucleotide_accession_version='NC_000021.9', start_position_on_the_genomic_accession=33432486, end_position_on_the_genomic_accession=33480004, orientation='minus', exon_count=10, OMIM=[617894], no_hdr0=''),
    758 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=758, CurrentID=0, Status='live', Symbol='MPPED1', Aliases=['239AB', 'C22orf1', 'FAM1A'], description='metallophosphoesterase domain containing 1', other_designations='metallophosphoesterase domain-containing protein 1|adult brain protein 239', map_location='22q13.2', chromosome='22', genomic_nucleotide_accession_version='NC_000022.11', start_position_on_the_genomic_accession=43412014, end_position_on_the_genomic_accession=43507848, orientation='plus', exon_count=8, OMIM=[602112], no_hdr0=''),
    759 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=759, CurrentID=0, Status='live', Symbol='CA1', Aliases=['CA-I', 'CAB', 'Car1', 'HEL-S-11'], description='carbonic anhydrase 1', other_designations='carbonic anhydrase 1|carbonate dehydratase I|carbonic anhydrase B|carbonic anhydrase I|epididymis secretory protein Li 11|epididymis secretory sperm binding protein', map_location='8q21.2', chromosome='8', genomic_nucleotide_accession_version='NC_000008.11', start_position_on_the_genomic_accession=85327608, end_position_on_the_genomic_accession=85378113, orientation='minus', exon_count=11, OMIM=[114800], no_hdr0=''),
    760 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=760, CurrentID=0, Status='live', Symbol='CA2', Aliases=['CA-II', 'CAC', 'CAII', 'Car2', 'HEL-76', 'HEL-S-282'], description='carbonic anhydrase 2', other_designations='carbonic anhydrase 2|carbonate dehydratase II|carbonic anhydrase B|carbonic anhydrase C|carbonic anhydrase II|carbonic dehydratase|epididymis luminal protein 76|epididymis secretory protein Li 282', map_location='8q21.2', chromosome='8', genomic_nucleotide_accession_version='NC_000008.11', start_position_on_the_genomic_accession=85464007, end_position_on_the_genomic_accession=85481493, orientation='plus', exon_count=7, OMIM=[611492], no_hdr0=''),
    761 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=761, CurrentID=0, Status='live', Symbol='CA3', Aliases=['CAIII', 'Car3'], description='carbonic anhydrase 3', other_designations='carbonic anhydrase 3|CA-III|HEL-S-167mP|carbonate dehydratase III|carbonic anhydrase III, muscle specific|carbonic anhydrase IIII|epididymis secretory sperm binding protein Li 167mP', map_location='8q21.2', chromosome='8', genomic_nucleotide_accession_version='NC_000008.11', start_position_on_the_genomic_accession=85438859, end_position_on_the_genomic_accession=85449040, orientation='plus', exon_count=7, OMIM=[114750], no_hdr0=''),
    762 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=762, CurrentID=0, Status='live', Symbol='CA4', Aliases=['CAIV', 'Car4', 'RP17'], description='carbonic anhydrase 4', other_designations='carbonic anhydrase 4|CA-IV|carbonate dehydratase IV|carbonic anhydrase IV|carbonic dehydratase IV', map_location='17q23.1', chromosome='17', genomic_nucleotide_accession_version='NC_000017.11', start_position_on_the_genomic_accession=60149942, end_position_on_the_genomic_accession=60179021, orientation='plus', exon_count=13, OMIM=[114760], no_hdr0=''),
    763 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=763, CurrentID=0, Status='live', Symbol='CA5A', Aliases=['CA5D', 'CAV', 'CAVA', 'GS1-21A4.1', 'CA5A'], description='carbonic anhydrase 5A', other_designations='carbonic anhydrase 5A, mitochondrial|CA-VA|carbonate dehydratase VA|carbonic anhydrase V, mitochondrial|carbonic anhydrase VA, mitochondrial|carbonic dehydratase', map_location='16q24.2', chromosome='16', genomic_nucleotide_accession_version='NC_000016.10', start_position_on_the_genomic_accession=87881549, end_position_on_the_genomic_accession=87936575, orientation='minus', exon_count=11, OMIM=[114761], no_hdr0=''),
    765 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=765, CurrentID=0, Status='live', Symbol='CA6', Aliases=['CA-VI', 'GUSTIN'], description='carbonic anhydrase 6', other_designations='carbonic anhydrase 6|carbonate dehydratase VI|carbonic anhydrase VI nirs variant 2|salivary carbonic anhydrase|secreted carbonic anhydrase', map_location='1p36.23', chromosome='1', genomic_nucleotide_accession_version='NC_000001.11', start_position_on_the_genomic_accession=8945868, end_position_on_the_genomic_accession=8975092, orientation='plus', exon_count=10, OMIM=[114780], no_hdr0=''),
    766 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=766, CurrentID=0, Status='live', Symbol='CA7', Aliases=['CA-VII', 'CAVII'], description='carbonic anhydrase 7', other_designations='carbonic anhydrase 7|carbonate dehydratase VII|carbonic anhydrase VII|carbonic dehydratase VII', map_location='16q22.1', chromosome='16', genomic_nucleotide_accession_version='NC_000016.10', start_position_on_the_genomic_accession=66844414, end_position_on_the_genomic_accession=66854149, orientation='plus', exon_count=9, OMIM=[114770], no_hdr0=''),
    767 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=767, CurrentID=0, Status='live', Symbol='CA8', Aliases=['CA-RP', 'CA-VIII', 'CALS', 'CAMRQ3', 'CARP'], description='carbonic anhydrase 8', other_designations='carbonic anhydrase-related protein|CA-related protein|carbonate dehydratase|carbonic anhydrase VIII|carbonic anhydrase-like sequence', map_location='8q12.1', chromosome='8', genomic_nucleotide_accession_version='NC_000008.11', start_position_on_the_genomic_accession=60185412, end_position_on_the_genomic_accession=60281400, orientation='minus', exon_count=14, OMIM=[114815], no_hdr0=''),
    768 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=768, CurrentID=0, Status='live', Symbol='CA9', Aliases=['CAIX', 'MN'], description='carbonic anhydrase 9', other_designations='carbonic anhydrase 9|CA-IX|P54/58N|RCC-associated antigen G250|RCC-associated protein G250|carbonate dehydratase IX|carbonic anhydrase IX|carbonic dehydratase|membrane antigen MN|pMW1|renal cell carcinoma-associated antigen G250', map_location='9p13.3', chromosome='9', genomic_nucleotide_accession_version='NC_000009.12', start_position_on_the_genomic_accession=35673809, end_position_on_the_genomic_accession=35681159, orientation='plus', exon_count=11, OMIM=[603179], no_hdr0=''),
    770 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=770, CurrentID=0, Status='live', Symbol='CA11', Aliases=['CA-RP', 'CA-RP II', 'CA-XI', 'CARP-2', 'CARPX1'], description='carbonic anhydrase 11', other_designations='carbonic anhydrase-related protein 11|carbonic anhydrase XI|carbonic anhydrase-related protein 2|carbonic anhydrase-related protein XI', map_location='19q13.33', chromosome='19', genomic_nucleotide_accession_version='NC_000019.10', start_position_on_the_genomic_accession=48637946, end_position_on_the_genomic_accession=48646187, orientation='minus', exon_count=6, OMIM=[604644], no_hdr0=''),
    771 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=771, CurrentID=0, Status='live', Symbol='CA12', Aliases=['CA-XII', 'CAXII', 'HsT18816', 'T18816'], description='carbonic anhydrase 12', other_designations='carbonic anhydrase 12|carbonate dehydratase XII|carbonic anhydrase XII|carbonic dehydratase|tumor antigen HOM-RCC-3.1.3', map_location='15q22.2', chromosome='15', genomic_nucleotide_accession_version='NC_000015.10', start_position_on_the_genomic_accession=63321378, end_position_on_the_genomic_accession=63381846, orientation='minus', exon_count=11, OMIM=[603263], no_hdr0=''),
    773 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=773, CurrentID=0, Status='live', Symbol='CACNA1A', Aliases=['APCA', 'BI', 'CACNL1A4', 'CAV2.1', 'EA2', 'EIEE42', 'FHM', 'HPCA', 'MHP', 'MHP1', 'SCA6'], description='calcium voltage-gated channel subunit alpha1 A', other_designations='voltage-dependent P/Q-type calcium channel subunit alpha-1A|brain calcium channel 1|brain calcium channel I|calcium channel, L type, alpha-1 polypeptide|calcium channel, voltage-dependent, P/Q type, alpha 1A subunit|fetal brain Ca2+ voltage-gated channel alpha1A pore-forming subunit|voltage-gated calcium channel subunit alpha Cav2.1', map_location='19p13.13', chromosome='19', genomic_nucleotide_accession_version='NC_000019.10', start_position_on_the_genomic_accession=13206442, end_position_on_the_genomic_accession=13506479, orientation='minus', exon_count=49, OMIM=[601011], no_hdr0=''),
    774 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=774, CurrentID=0, Status='live', Symbol='CACNA1B', Aliases=['BIII', 'CACNL1A5', 'CACNN', 'Cav2.2', 'DYT23', 'NEDNEH'], description='calcium voltage-gated channel subunit alpha1 B', other_designations='voltage-dependent N-type calcium channel subunit alpha-1B|Cav2.2 voltage-gated Ca2+ channel|brain calcium channel III|calcium channel alpha12.2 subunit|calcium channel, L type, alpha-1 polypeptide|calcium channel, voltage-dependent, L type, alpha 1B subunit|calcium channel, voltage-dependent, N type, alpha 1B subunit|voltage-gated calcium channel alpha subunit Cav2.2|voltage-gated calcium channel subunit alpha Cav2.2', map_location='9q34.3', chromosome='9', genomic_nucleotide_accession_version='NC_000009.12', start_position_on_the_genomic_accession=137877782, end_position_on_the_genomic_accession=138124619, orientation='plus', exon_count=47, OMIM=[601012], no_hdr0=''),
    775 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=775, CurrentID=0, Status='live', Symbol='CACNA1C', Aliases=['CACH2', 'CACN2', 'CACNL1A1', 'CCHL1A1', 'CaV1.2', 'LQT8', 'TS', 'TS. LQT8'], description='calcium voltage-gated channel subunit alpha1 C', other_designations='voltage-dependent L-type calcium channel subunit alpha-1C|DHPR, alpha-1 subunit|calcium channel, cardic dihydropyridine-sensitive, alpha-1 subunit|calcium channel, voltage-dependent, L type, alpha 1C subunit|voltage-dependent L-type Ca2+ channel alpha 1 subunit|voltage-gated L-type calcium channel Cav1.2 alpha 1 subunit, splice variant 10*', map_location='12p13.33', chromosome='12', genomic_nucleotide_accession_version='NC_000012.12', start_position_on_the_genomic_accession=1969552, end_position_on_the_genomic_accession=2697950, orientation='plus', exon_count=56, OMIM=[114205], no_hdr0=''),
    776 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=776, CurrentID=0, Status='live', Symbol='CACNA1D', Aliases=['CACH3', 'CACN4', 'CACNL1A2', 'CCHL1A2', 'Cav1.3', 'PASNA', 'SANDD'], description='calcium voltage-gated channel subunit alpha1 D', other_designations='voltage-dependent L-type calcium channel subunit alpha-1D|calcium channel, L type, alpha-1 polypeptide|calcium channel, neuroendocrine/brain-type, alpha 1 subunit|calcium channel, voltage-dependent, L type, alpha 1D subunit|voltage-gated calcium channel alpha 1 subunit|voltage-gated calcium channel alpha subunit Cav1.3', map_location='3p21.1', chromosome='3', genomic_nucleotide_accession_version='NC_000003.12', start_position_on_the_genomic_accession=53494611, end_position_on_the_genomic_accession=53813733, orientation='plus', exon_count=53, OMIM=[114206], no_hdr0=''),
    777 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=777, CurrentID=0, Status='live', Symbol='CACNA1E', Aliases=['BII', 'CACH6', 'CACNL1A6', 'Cav2.3', 'EIEE69', 'gm139'], description='calcium voltage-gated channel subunit alpha1 E', other_designations='voltage-dependent R-type calcium channel subunit alpha-1E|brain calcium channel II|calcium channel, L type, alpha-1 polypeptide|calcium channel, R type, alpha-1 polypeptide|voltage-dependent calcium channel alpha 1E subunit|voltage-gated calcium channel alpha subunit Cav2.3', map_location='1q25.3', chromosome='1', genomic_nucleotide_accession_version='NC_000001.11', start_position_on_the_genomic_accession=181317712, end_position_on_the_genomic_accession=181808084, orientation='plus', exon_count=52, OMIM=[601013], no_hdr0=''),
    778 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=778, CurrentID=0, Status='live', Symbol='CACNA1F', Aliases=['AIED', 'COD3', 'COD4', 'CORDX', 'CORDX3', 'CSNB2', 'CSNB2A', 'CSNBX2', 'Cav1.4', 'Cav1.4alpha1', 'JM8', 'JMC8', 'OA2'], description='calcium voltage-gated channel subunit alpha1 F', other_designations='voltage-dependent L-type calcium channel subunit alpha-1F|calcium channel, voltage-dependent, L type, alpha 1F subunit|voltage-gated calcium channel subunit alpha Cav1.4', map_location='Xp11.23', chromosome='X', genomic_nucleotide_accession_version='NC_000023.11', start_position_on_the_genomic_accession=49205063, end_position_on_the_genomic_accession=49233404, orientation='minus', exon_count=48, OMIM=[300110], no_hdr0=''),
    779 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=779, CurrentID=0, Status='live', Symbol='CACNA1S', Aliases=['CACNL1A3', 'CCHL1A3', 'Cav1.1', 'HOKPP', 'HOKPP1', 'MHS5', 'TTPP1', 'hypoPP'], description='calcium voltage-gated channel subunit alpha1 S', other_designations='voltage-dependent L-type calcium channel subunit alpha-1S|calcium channel, voltage-dependent, L type, alpha 1S subunit|dihydropyridine receptor alpha 1 subunit|dihydropyridine-sensitive L-type calcium channel alpha-1 subunit|voltage-gated calcium channel subunit alpha Cav1.1', map_location='1q32.1', chromosome='1', genomic_nucleotide_accession_version='NC_000001.11', start_position_on_the_genomic_accession=201039509, end_position_on_the_genomic_accession=201112453, orientation='minus', exon_count=44, OMIM=[114208], no_hdr0=''),
    780 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=780, CurrentID=0, Status='live', Symbol='DDR1', Aliases=['CAK', 'CD167', 'DDR', 'EDDR1', 'HGK2', 'MCK10', 'NEP', 'NTRK4', 'PTK3', 'PTK3A', 'RTK6', 'TRKE'], description='discoidin domain receptor tyrosine kinase 1', other_designations='epithelial discoidin domain-containing receptor 1|CD167 antigen-like family member A|PTK3A protein tyrosine kinase 3A|cell adhesion kinase|mammary carcinoma kinase 10|neuroepithelial tyrosine kinase|neurotrophic tyrosine kinase, receptor, type 4|protein-tyrosine kinase RTK-6|tyrosine kinase DDR|tyrosine-protein kinase CAK', map_location='6p21.33', chromosome='6', genomic_nucleotide_accession_version='NC_000006.12', start_position_on_the_genomic_accession=30880958, end_position_on_the_genomic_accession=30900156, orientation='plus', exon_count=25, OMIM=[600408], no_hdr0=''),
    781 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=781, CurrentID=0, Status='live', Symbol='CACNA2D1', Aliases=['CACNA2', 'CACNL2A', 'CCHL2A', 'LINC01112', 'lncRNA-N3'], description='calcium voltage-gated channel auxiliary subunit alpha2delta 1', other_designations='voltage-dependent calcium channel subunit alpha-2/delta-1|calcium channel, L type, alpha 2 polypeptide|calcium channel, voltage-dependent, alpha 2/delta subunit 1|dihydropyridine-sensitive L-type, calcium channel alpha-2/delta subunit|voltage-gated calcium channel subunit alpha-2/delta-1', map_location='7q21.11', chromosome='7', genomic_nucleotide_accession_version='NC_000007.14', start_position_on_the_genomic_accession=81946444, end_position_on_the_genomic_accession=82443956, orientation='minus', exon_count=45, OMIM=[114204], no_hdr0=''),
    782 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=782, CurrentID=0, Status='live', Symbol='CACNB1', Aliases=['CAB1', 'CACNLB1', 'CCHLB1'], description='calcium voltage-gated channel auxiliary subunit beta 1', other_designations='voltage-dependent L-type calcium channel subunit beta-1|calcium channel voltage-dependent subunit beta 1|calcium channel, L type, beta 1 polypeptide|calcium channel, voltage-dependent, beta 1 subunit|dihydropyridine-sensitive L-type, calcium channel beta-1 subunit', map_location='17q12', chromosome='17', genomic_nucleotide_accession_version='NC_000017.11', start_position_on_the_genomic_accession=39173453, end_position_on_the_genomic_accession=39197669, orientation='minus', exon_count=19, OMIM=[114207], no_hdr0=''),
    783 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=783, CurrentID=0, Status='live', Symbol='CACNB2', Aliases=['CAB2', 'CACNLB2', 'CAVB2', 'MYSB'], description='calcium voltage-gated channel auxiliary subunit beta 2', other_designations='voltage-dependent L-type calcium channel subunit beta-2|calcium channel voltage-dependent subunit beta 2|calcium channel, voltage-dependent, beta 2 subunit|lambert-Eaton myasthenic syndrome antigen B|myasthenic (Lambert-Eaton) syndrome antigen B', map_location='10p12.33-p12.31', chromosome='10', genomic_nucleotide_accession_version='NC_000010.11', start_position_on_the_genomic_accession=18140424, end_position_on_the_genomic_accession=18545881, orientation='plus', exon_count=20, OMIM=[600003], no_hdr0=''),
    784 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=784, CurrentID=0, Status='live', Symbol='CACNB3', Aliases=['CAB3', 'CACNLB3'], description='calcium voltage-gated channel auxiliary subunit beta 3', other_designations='voltage-dependent L-type calcium channel subunit beta-3|calcium channel, voltage-dependent, beta 3 subunit', map_location='12q13.12', chromosome='12', genomic_nucleotide_accession_version='NC_000012.12', start_position_on_the_genomic_accession=48814432, end_position_on_the_genomic_accession=48828941, orientation='plus', exon_count=17, OMIM=[601958], no_hdr0=''),
    785 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=785, CurrentID=0, Status='live', Symbol='CACNB4', Aliases=['CAB4', 'CACNLB4', 'EA5', 'EIG9', 'EJM', 'EJM4', 'EJM6'], description='calcium voltage-gated channel auxiliary subunit beta 4', other_designations='voltage-dependent L-type calcium channel subunit beta-4|calcium channel voltage-dependent subunit beta 4|dihydropyridine-sensitive L-type, calcium channel beta-4 subunit', map_location='2q23.3', chromosome='2', genomic_nucleotide_accession_version='NC_000002.12', start_position_on_the_genomic_accession=151832771, end_position_on_the_genomic_accession=152099167, orientation='minus', exon_count=22, OMIM=[601949], no_hdr0=''),
    786 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=786, CurrentID=0, Status='live', Symbol='CACNG1', Aliases=['CACNLG'], description='calcium voltage-gated channel auxiliary subunit gamma 1', other_designations='voltage-dependent calcium channel gamma-1 subunit|L-type calcium channel gamma polypeptide|calcium channel, voltage-dependent, gamma subunit 1|dihydropyridine-sensitive L-type, skeletal muscle calcium channel subunit gamma|neuronal dihydropyridine-sensitive calcium channel gamma subunit', map_location='17q24.2', chromosome='17', genomic_nucleotide_accession_version='NC_000017.11', start_position_on_the_genomic_accession=67044554, end_position_on_the_genomic_accession=67056797, orientation='plus', exon_count=4, OMIM=[114209], no_hdr0=''),
    788 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=788, CurrentID=0, Status='live', Symbol='SLC25A20', Aliases=['CAC', 'CACT'], description='solute carrier family 25 member 20', other_designations='mitochondrial carnitine/acylcarnitine carrier protein|solute carrier family 25 (carnitine/acylcarnitine translocase), member 20', map_location='3p21.31', chromosome='3', genomic_nucleotide_accession_version='NC_000003.12', start_position_on_the_genomic_accession=48856926, end_position_on_the_genomic_accession=48898882, orientation='minus', exon_count=9, OMIM=[613698], no_hdr0=''),
    790 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=790, CurrentID=0, Status='live', Symbol='CAD', Aliases=['CDG1Z', 'EIEE50', 'GATD4'], description='carbamoyl-phosphate synthetase 2, aspartate transcarbamylase, and dihydroorotase', other_designations='CAD protein|CAD trifunctional protein|multifunctional protein CAD', map_location='2p23.3', chromosome='2', genomic_nucleotide_accession_version='NC_000002.12', start_position_on_the_genomic_accession=27217369, end_position_on_the_genomic_accession=27243943, orientation='plus', exon_count=45, OMIM=[114010], no_hdr0=''),
    793 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=793, CurrentID=0, Status='live', Symbol='CALB1', Aliases=['CALB', 'D-28K'], description='calbindin 1', other_designations='calbindin|RTVL-H protein|calbindin 1, (28kD)|calbindin 1, 28kDa|calbindin 27|calbindin D28|vitamin D-dependent calcium-binding protein, avian-type', map_location='8q21.3', chromosome='8', genomic_nucleotide_accession_version='NC_000008.11', start_position_on_the_genomic_accession=90058608, end_position_on_the_genomic_accession=90082879, orientation='minus', exon_count=11, OMIM=[114050], no_hdr0=''),
    794 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=794, CurrentID=0, Status='live', Symbol='CALB2', Aliases=['CAB29', 'CAL2', 'CR'], description='calbindin 2', other_designations='calretinin|29 kDa calbindin|calbindin 2, (29kD, calretinin)|calbindin D29K|testicular secretory protein Li 8', map_location='16q22.2', chromosome='16', genomic_nucleotide_accession_version='NC_000016.10', start_position_on_the_genomic_accession=71358723, end_position_on_the_genomic_accession=71390438, orientation='plus', exon_count=10, OMIM=[114051], no_hdr0=''),
    795 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=795, CurrentID=0, Status='live', Symbol='S100G', Aliases=['CABP', 'CABP1', 'CABP9K', 'CALB3'], description='S100 calcium binding protein G', other_designations='protein S100-G|calbindin 3, (vitamin D-dependent calcium-binding protein)|calbindin D9K|calbindin-D9k|vitamin D-dependent calcium-binding protein, intestinal', map_location='Xp22.2', chromosome='X', genomic_nucleotide_accession_version='NC_000023.11', start_position_on_the_genomic_accession=16649787, end_position_on_the_genomic_accession=16654674, orientation='plus', exon_count=3, OMIM=[302020], no_hdr0=''),
    796 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=796, CurrentID=0, Status='live', Symbol='CALCA', Aliases=['CALC1', 'CGRP', 'CGRP-I', 'CGRP-alpha', 'CGRP1', 'CT', 'KC', 'PCT'], description='calcitonin related polypeptide alpha', other_designations='calcitonin|calcitonin gene-related peptide 1|alpha-type CGRP|calcitonin 1|calcitonin gene-related peptide I|calcitonin/calcitonin-related polypeptide, alpha|katacalcin', map_location='11p15.2', chromosome='11', genomic_nucleotide_accession_version='NC_000011.10', start_position_on_the_genomic_accession=14966668, end_position_on_the_genomic_accession=14972361, orientation='minus', exon_count=7, OMIM=[114130], no_hdr0=''),
    797 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=797, CurrentID=0, Status='live', Symbol='CALCB', Aliases=['CALC2', 'CGRP-II', 'CGRP2'], description='calcitonin related polypeptide beta', other_designations='calcitonin gene-related peptide 2|beta-CGRP|beta-type CGRP|calcitonin 2|calcitonin gene-related peptide II', map_location='11p15.2', chromosome='11', genomic_nucleotide_accession_version='NC_000011.10', start_position_on_the_genomic_accession=15073593, end_position_on_the_genomic_accession=15078637, orientation='plus', exon_count=5, OMIM=[114160], no_hdr0=''),
    799 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=799, CurrentID=0, Status='live', Symbol='CALCR', Aliases=['CRT', 'CT-R', 'CTR', 'CTR1'], description='calcitonin receptor', other_designations='calcitonin receptor', map_location='7q21.3', chromosome='7', genomic_nucleotide_accession_version='NC_000007.14', start_position_on_the_genomic_accession=93424486, end_position_on_the_genomic_accession=93574730, orientation='minus', exon_count=17, OMIM=[114131], no_hdr0=''),
    800 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=800, CurrentID=0, Status='live', Symbol='CALD1', Aliases=['CDM', 'H-CAD', 'HCAD', 'L-CAD', 'LCAD', 'NAG22'], description='caldesmon 1', other_designations='caldesmon|testis secretory sperm-binding protein Li 227n', map_location='7q33', chromosome='7', genomic_nucleotide_accession_version='NC_000007.14', start_position_on_the_genomic_accession=134779629, end_position_on_the_genomic_accession=134970729, orientation='plus', exon_count=18, OMIM=[114213], no_hdr0=''),
    801 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=801, CurrentID=0, Status='live', Symbol='CALM1', Aliases=['CALML2', 'CAM2', 'CAM3', 'CAMB', 'CAMC', 'CAMI', 'CAMIII', 'CPVT4', 'DD132', 'LQT14', 'PHKD', 'caM'], description='calmodulin 1', other_designations='calmodulin-1|Calmodulin-2|Calmodulin-3|calmodulin 1 (phosphorylase kinase, delta)|phosphorylase kinase subunit delta|phosphorylase kinase, delta subunit|prepro-calmodulin 1', map_location='14q32.11', chromosome='14', genomic_nucleotide_accession_version='NC_000014.9', start_position_on_the_genomic_accession=90396502, end_position_on_the_genomic_accession=90408268, orientation='plus', exon_count=8, OMIM=[114180], no_hdr0=''),
    805 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=805, CurrentID=0, Status='live', Symbol='CALM2', Aliases=['CALM', 'CALML2', 'CAM1', 'CAM3', 'CAMC', 'CAMII', 'CAMIII', 'LQT15', 'PHKD', 'PHKD2', 'caM'], description='calmodulin 2', other_designations='calmodulin-2|Calmodulin-1|Calmodulin-3|LP7057 protein|calmodulin 2 (phosphorylase kinase, delta)|phosphorylase kinase delta|phosphorylase kinase subunit delta|prepro-calmodulin 2', map_location='2p21', chromosome='2', genomic_nucleotide_accession_version='NC_000002.12', start_position_on_the_genomic_accession=47160082, end_position_on_the_genomic_accession=47176936, orientation='minus', exon_count=8, OMIM=[114182], no_hdr0=''),
    808 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=808, CurrentID=0, Status='live', Symbol='CALM3', Aliases=['CALM', 'CAM1', 'CAM2', 'CAMB', 'CPVT6', 'CaM', 'CaMIII', 'HEL-S-72', 'LQT16', 'PHKD', 'PHKD3'], description='calmodulin 3', other_designations='calmodulin-3|Calmodulin-1|Calmodulin-2|epididymis secretory protein Li 72|phosphorylase kinase subunit delta|prepro-calmodulin 3', map_location='19q13.32', chromosome='19', genomic_nucleotide_accession_version='NC_000019.10', start_position_on_the_genomic_accession=46601074, end_position_on_the_genomic_accession=46610782, orientation='plus', exon_count=9, OMIM=[114183], no_hdr0=''),
    810 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=810, CurrentID=0, Status='live', Symbol='CALML3', Aliases=['CLP'], description='calmodulin like 3', other_designations='calmodulin-like protein 3|caM-like protein|calmodulin-related protein NB-1', map_location='10p15.1', chromosome='10', genomic_nucleotide_accession_version='NC_000010.11', start_position_on_the_genomic_accession=5524961, end_position_on_the_genomic_accession=5526771, orientation='plus', exon_count=1, OMIM=[114184], no_hdr0=''),
    811 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=811, CurrentID=0, Status='live', Symbol='CALR', Aliases=['CRT', 'HEL-S-99n', 'RO', 'SSA', 'cC1qR'], description='calreticulin', other_designations='calreticulin|CRP55|ERp60|HACBP|Sicca syndrome antigen A (autoantigen Ro; calreticulin)|calregulin|endoplasmic reticulum resident protein 60|epididymis secretory sperm binding protein Li 99n|grp60', map_location='19p13.13', chromosome='19', genomic_nucleotide_accession_version='NC_000019.10', start_position_on_the_genomic_accession=12938609, end_position_on_the_genomic_accession=12944489, orientation='plus', exon_count=9, OMIM=[109091], no_hdr0=''),
    813 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=813, CurrentID=0, Status='live', Symbol='CALU', Aliases=[], description='calumenin', other_designations='calumenin|IEF SSP 9302|crocalbin-like protein|multiple EF-hand protein', map_location='7q32.1', chromosome='7', genomic_nucleotide_accession_version='NC_000007.14', start_position_on_the_genomic_accession=128739359, end_position_on_the_genomic_accession=128773400, orientation='plus', exon_count=9, OMIM=[603420], no_hdr0=''),
    814 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=814, CurrentID=0, Status='live', Symbol='CAMK4', Aliases=['CaMK IV', 'CaMK-GR', 'CaMKIV', 'caMK'], description='calcium/calmodulin dependent protein kinase IV', other_designations='calcium/calmodulin-dependent protein kinase type IV|CAM kinase IV|CAM kinase- GR|brain Ca(2+)-calmodulin-dependent protein kinase type IV|brain Ca++-calmodulin-dependent protein kinase type IV|calcium/calmodulin-dependent protein kinase type IV catalytic chain', map_location='5q22.1', chromosome='5', genomic_nucleotide_accession_version='NC_000005.10', start_position_on_the_genomic_accession=111223583, end_position_on_the_genomic_accession=111498503, orientation='plus', exon_count=15, OMIM=[114080], no_hdr0=''),
    815 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=815, CurrentID=0, Status='live', Symbol='CAMK2A', Aliases=['CAMKA', 'CaMKIINalpha', 'CaMKIIalpha', 'MRD53', 'MRT63'], description='calcium/calmodulin dependent protein kinase II alpha', other_designations='calcium/calmodulin-dependent protein kinase type II subunit alpha|CaM kinase II alpha subunit|CaM-kinase II alpha chain|CaMK-II alpha subunit|caM kinase II subunit alpha|caMK-II subunit alpha|calcium/calmodulin-dependent protein kinase (CaM kinase) II alpha|calcium/calmodulin-dependent protein kinase II alpha-B subunit|calcium/calmodulin-dependent protein kinase type II alpha chain', map_location='5q32', chromosome='5', genomic_nucleotide_accession_version='NC_000005.10', start_position_on_the_genomic_accession=150219491, end_position_on_the_genomic_accession=150290130, orientation='minus', exon_count=20, OMIM=[114078], no_hdr0=''),
    816 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=816, CurrentID=0, Status='live', Symbol='CAMK2B', Aliases=['CAM2', 'CAMK2', 'CAMKB', 'CaMKIIbeta', 'MRD54'], description='calcium/calmodulin dependent protein kinase II beta', other_designations='calcium/calmodulin-dependent protein kinase type II subunit beta|CaM kinase II beta subunit|CaM-kinase II beta chain|caMK-II subunit beta|proline rich calmodulin-dependent protein kinase', map_location='7p13', chromosome='7', genomic_nucleotide_accession_version='NC_000007.14', start_position_on_the_genomic_accession=44217154, end_position_on_the_genomic_accession=44326167, orientation='minus', exon_count=28, OMIM=[607707], no_hdr0=''),
    817 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=817, CurrentID=0, Status='live', Symbol='CAMK2D', Aliases=['CAMKD'], description='calcium/calmodulin dependent protein kinase II delta', other_designations='calcium/calmodulin-dependent protein kinase type II subunit delta|CaM kinase II delta subunit|CaM-kinase II delta chain|CaMK-II delta subunit|calcium/calmodulin-dependent protein kinase (CaM kinase) II delta|calcium/calmodulin-dependent protein kinase type II delta chain', map_location='4q26', chromosome='4', genomic_nucleotide_accession_version='NC_000004.12', start_position_on_the_genomic_accession=113451032, end_position_on_the_genomic_accession=113762177, orientation='minus', exon_count=26, OMIM=[607708], no_hdr0=''),
    818 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=818, CurrentID=0, Status='live', Symbol='CAMK2G', Aliases=['CAMK', 'CAMK-II', 'CAMKG', 'MRD59'], description='calcium/calmodulin dependent protein kinase II gamma', other_designations='calcium/calmodulin-dependent protein kinase type II subunit gamma|caMK-II subunit gamma|calcium/calmodulin-dependent protein kinase (CaM kinase) II gamma', map_location='10q22.2', chromosome='10', genomic_nucleotide_accession_version='NC_000010.11', start_position_on_the_genomic_accession=73812501, end_position_on_the_genomic_accession=73874582, orientation='minus', exon_count=25, OMIM=[602123], no_hdr0=''),
    819 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=819, CurrentID=0, Status='live', Symbol='CAMLG', Aliases=['CAML', 'GET2'], description='calcium modulating ligand', other_designations='calcium signal-modulating cyclophilin ligand|calcium-modulating cyclophilin ligand|cyclophilin B-binding protein', map_location='5q31.1', chromosome='5', genomic_nucleotide_accession_version='NC_000005.10', start_position_on_the_genomic_accession=134738548, end_position_on_the_genomic_accession=134752157, orientation='plus', exon_count=4, OMIM=[601118], no_hdr0=''),
    820 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=820, CurrentID=0, Status='live', Symbol='CAMP', Aliases=['CAP-18', 'CAP18', 'CRAMP', 'FALL-39', 'FALL39', 'HSD26', 'LL37'], description='cathelicidin antimicrobial peptide', other_designations='cathelicidin antimicrobial peptide|18 kDa cationic antimicrobial protein|epididymis secretory sperm binding protein', map_location='3p21.31', chromosome='3', genomic_nucleotide_accession_version='NC_000003.12', start_position_on_the_genomic_accession=48223495, end_position_on_the_genomic_accession=48225485, orientation='plus', exon_count=4, OMIM=[600474], no_hdr0=''),
    821 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=821, CurrentID=0, Status='live', Symbol='CANX', Aliases=['CNX', 'IP90', 'P90'], description='calnexin', other_designations='calnexin|epididymis secretory sperm binding protein|major histocompatibility complex class I antigen-binding protein p88', map_location='5q35.3', chromosome='5', genomic_nucleotide_accession_version='NC_000005.10', start_position_on_the_genomic_accession=179678646, end_position_on_the_genomic_accession=179731641, orientation='plus', exon_count=20, OMIM=[114217], no_hdr0=''),
    822 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=822, CurrentID=0, Status='live', Symbol='CAPG', Aliases=['AFCP', 'HEL-S-66', 'MCP'], description='capping actin protein, gelsolin like', other_designations='macrophage-capping protein|actin-regulatory protein CAP-G|capping protein (actin filament), gelsolin-like|epididymis secretory protein Li 66|gelsolin-like capping protein', map_location='2p11.2', chromosome='2', genomic_nucleotide_accession_version='NC_000002.12', start_position_on_the_genomic_accession=85394753, end_position_on_the_genomic_accession=85418467, orientation='minus', exon_count=15, OMIM=[153615], no_hdr0=''),
    823 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=823, CurrentID=0, Status='live', Symbol='CAPN1', Aliases=['CANP', 'CANP1', 'CANPL1', 'SPG76', 'muCANP', 'muCL'], description='calpain 1', other_designations='calpain-1 catalytic subunit|CANP 1|calcium-activated neutral proteinase 1|calpain 1, (mu/I) large subunit|calpain mu-type|calpain, large polypeptide L1|calpain-1 large subunit|cell proliferation-inducing gene 30 protein|cell proliferation-inducing protein 30|micromolar-calpain', map_location='11q13.1', chromosome='11', genomic_nucleotide_accession_version='NC_000011.10', start_position_on_the_genomic_accession=65181373, end_position_on_the_genomic_accession=65212006, orientation='plus', exon_count=26, OMIM=[114220], no_hdr0=''),
    824 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=824, CurrentID=0, Status='live', Symbol='CAPN2', Aliases=['CANP2', 'CANPL2', 'CANPml', 'mCANP'], description='calpain 2', other_designations='calpain-2 catalytic subunit|CANP 2|M-calpain|calcium-activated neutral proteinase 2|calpain 2, (m/II) large subunit|calpain 2, large [catalytic] subunit|calpain 2, large subunit|calpain M-type|calpain, large polypeptide L2|millimolar-calpain', map_location='1q41', chromosome='1', genomic_nucleotide_accession_version='NC_000001.11', start_position_on_the_genomic_accession=223701597, end_position_on_the_genomic_accession=223776018, orientation='plus', exon_count=22, OMIM=[114230], no_hdr0=''),
    825 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=825, CurrentID=0, Status='live', Symbol='CAPN3', Aliases=['CANP3', 'CANPL3', 'LGMD2', 'LGMD2A', 'LGMDD4', 'LGMDR1', 'nCL-1', 'p94'], description='calpain 3', other_designations='calpain-3|calpain p94, large [catalytic] subunit|calpain, large polypeptide L3|muscle-specific calcium-activated neutral protease 3 large subunit|new calpain 1', map_location='15q15.1', chromosome='15', genomic_nucleotide_accession_version='NC_000015.10', start_position_on_the_genomic_accession=42359501, end_position_on_the_genomic_accession=42412317, orientation='plus', exon_count=26, OMIM=[114240], no_hdr0=''),
    826 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=826, CurrentID=0, Status='live', Symbol='CAPNS1', Aliases=['CALPAIN4', 'CANP', 'CANPS', 'CAPN4', 'CDPS', 'CSS1'], description='calpain small subunit 1', other_designations='calpain small subunit 1|CANP small subunit|calcium-activated neutral proteinase small subunit|calcium-dependent protease small subunit 1|calcium-dependent protease, small subunit|calpain 4, small subunit (30K)|calpain regulatory subunit|calpain, small polypeptide|epididymis secretory sperm binding protein', map_location='19q13.12', chromosome='19', genomic_nucleotide_accession_version='NC_000019.10', start_position_on_the_genomic_accession=36140066, end_position_on_the_genomic_accession=36150353, orientation='plus', exon_count=13, OMIM=[114170], no_hdr0=''),
    827 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=827, CurrentID=0, Status='live', Symbol='CAPN6', Aliases=['CANPX', 'CAPNX', 'CalpM', 'DJ914P14.1'], description='calpain 6', other_designations='calpain-6|calpain-like protease X-linked|calpamodulin', map_location='Xq23', chromosome='X', genomic_nucleotide_accession_version='NC_000023.11', start_position_on_the_genomic_accession=111245099, end_position_on_the_genomic_accession=111270483, orientation='minus', exon_count=13, OMIM=[300146], no_hdr0=''),
    828 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=828, CurrentID=0, Status='live', Symbol='CAPS', Aliases=['CAPS1'], description='calcyphosine', other_designations='calcyphosin|calcyphosine 1|epididymis secretory sperm binding protein|thyroid protein p24', map_location='19p13.3', chromosome='19', genomic_nucleotide_accession_version='NC_000019.10', start_position_on_the_genomic_accession=5914254, end_position_on_the_genomic_accession=5916211, orientation='plus', exon_count=5, OMIM=[114212], no_hdr0=''),
    829 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=829, CurrentID=0, Status='live', Symbol='CAPZA1', Aliases=['CAPPA1', 'CAPZ', 'CAZ1'], description='capping actin protein of muscle Z-line subunit alpha 1', other_designations='F-actin-capping protein subunit alpha-1|Cap Z|capZ alpha-1|capping actin protein of muscle Z-line alpha subunit 1|capping protein (actin filament) muscle Z-line, alpha 1', map_location='1p13.2', chromosome='1', genomic_nucleotide_accession_version='NC_000001.11', start_position_on_the_genomic_accession=112619775, end_position_on_the_genomic_accession=112671616, orientation='plus', exon_count=11, OMIM=[601580], no_hdr0=''),
    830 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=830, CurrentID=0, Status='live', Symbol='CAPZA2', Aliases=['CAPPA2', 'CAPZ'], description='capping actin protein of muscle Z-line subunit alpha 2', other_designations='F-actin-capping protein subunit alpha-2|F-actin capping protein alpha-2 subunit|capZ alpha-2|capping actin protein of muscle Z-line alpha subunit 2|capping protein (actin filament) muscle Z-line, alpha 2|epididymis secretory sperm binding protein', map_location='7q31.2', chromosome='7', genomic_nucleotide_accession_version='NC_000007.14', start_position_on_the_genomic_accession=116862587, end_position_on_the_genomic_accession=116922049, orientation='plus', exon_count=10, OMIM=[601571], no_hdr0=''),
    831 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=831, CurrentID=0, Status='live', Symbol='CAST', Aliases=['BS-17', 'PLACK'], description='calpastatin', other_designations='calpastatin|calpain inhibitor|sperm BS-17 component', map_location='5q15', chromosome='5', genomic_nucleotide_accession_version='NC_000005.10', start_position_on_the_genomic_accession=96662037, end_position_on_the_genomic_accession=96774683, orientation='plus', exon_count=36, OMIM=[114090], no_hdr0=''),
    832 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=832, CurrentID=0, Status='live', Symbol='CAPZB', Aliases=['CAPB', 'CAPPB', 'CAPZ'], description='capping actin protein of muscle Z-line subunit beta', other_designations='F-actin-capping protein subunit beta|capZ beta|capping actin protein of muscle Z-line beta subunit|capping protein (actin filament) muscle Z-line, beta|epididymis secretory sperm binding protein', map_location='1p36.13', chromosome='1', genomic_nucleotide_accession_version='NC_000001.11', start_position_on_the_genomic_accession=19338775, end_position_on_the_genomic_accession=19485539, orientation='minus', exon_count=17, OMIM=[601572], no_hdr0=''),
    833 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=833, CurrentID=0, Status='live', Symbol='CARS1', Aliases=['CARS', 'CYSRS', 'MCDDBH', 'MDBH', 'MGC:11246'], description='cysteinyl-tRNA synthetase 1', other_designations='cysteine--tRNA ligase, cytoplasmic|cysteine tRNA ligase 1, cytoplasmic|cysteine translase', map_location='11p15.4', chromosome='11', genomic_nucleotide_accession_version='NC_000011.10', start_position_on_the_genomic_accession=3000929, end_position_on_the_genomic_accession=3057423, orientation='minus', exon_count=25, OMIM=[123859], no_hdr0=''),
    834 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=834, CurrentID=0, Status='live', Symbol='CASP1', Aliases=['ICE', 'IL1BC', 'P45'], description='caspase 1', other_designations='caspase-1|CASP1 nirs variant 1|IL-1 beta-converting enzyme|IL1B-convertase|caspase 1, apoptosis-related cysteine peptidase|interleukin 1, beta, convertase|interleukin 1-B converting enzyme', map_location='11q22.3', chromosome='11', genomic_nucleotide_accession_version='NC_000011.10', start_position_on_the_genomic_accession=105025443, end_position_on_the_genomic_accession=105035591, orientation='minus', exon_count=12, OMIM=[147678], no_hdr0=''),
    835 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=835, CurrentID=0, Status='live', Symbol='CASP2', Aliases=['CASP-2', 'ICH1', 'NEDD-2', 'NEDD2', 'PPP1R57'], description='caspase 2', other_designations='caspase-2|caspase 2 apoptosis-related cysteine peptidase|neural precursor cell expressed developmentally down-regulated protein 2|protease ICH-1|protein phosphatase 1, regulatory subunit 57', map_location='7q34', chromosome='7', genomic_nucleotide_accession_version='NC_000007.14', start_position_on_the_genomic_accession=143288351, end_position_on_the_genomic_accession=143307696, orientation='plus', exon_count=13, OMIM=[600639], no_hdr0=''),
    836 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=836, CurrentID=0, Status='live', Symbol='CASP3', Aliases=['CPP32', 'CPP32B', 'SCA-1'], description='caspase 3', other_designations='caspase-3|CASP-3|CPP-32|PARP cleavage protease|SREBP cleavage activity 1|apopain|caspase 3, apoptosis-related cysteine peptidase|caspase 3, apoptosis-related cysteine protease|cysteine protease CPP32|procaspase3|protein Yama', map_location='4q35.1', chromosome='4', genomic_nucleotide_accession_version='NC_000004.12', start_position_on_the_genomic_accession=184627696, end_position_on_the_genomic_accession=184649447, orientation='minus', exon_count=9, OMIM=[600636], no_hdr0=''),
    837 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=837, CurrentID=0, Status='live', Symbol='CASP4', Aliases=['ICE(rel)II', 'ICEREL-II', 'ICH-2', 'Mih1', 'Mih1/TX', 'TX'], description='caspase 4', other_designations='caspase-4|CASP-4|ICE and Ced-3 homolog 2|ICE(rel)-II|apoptotic cysteine protease Mih1/TX|caspase 4, apoptosis-related cysteine peptidase|caspase 4, apoptosis-related cysteine protease|protease ICH-2|protease TX', map_location='11q22.3', chromosome='11', genomic_nucleotide_accession_version='NC_000011.10', start_position_on_the_genomic_accession=104942866, end_position_on_the_genomic_accession=104968596, orientation='minus', exon_count=10, OMIM=[602664], no_hdr0=''),
    838 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=838, CurrentID=0, Status='live', Symbol='CASP5', Aliases=['ICE(rel)III', 'ICEREL-III', 'ICH-3'], description='caspase 5', other_designations='caspase-5|TY protease|caspase 5, apoptosis-related cysteine peptidase|caspase 5, apoptosis-related cysteine protease|protease ICH-3|protease TY', map_location='11q22.3', chromosome='11', genomic_nucleotide_accession_version='NC_000011.10', start_position_on_the_genomic_accession=104994243, end_position_on_the_genomic_accession=105023902, orientation='minus', exon_count=10, OMIM=[602665], no_hdr0=''),
    839 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=839, CurrentID=0, Status='live', Symbol='CASP6', Aliases=['MCH2'], description='caspase 6', other_designations='caspase-6|apoptotic protease MCH-2|caspase 6, apoptosis-related cysteine peptidase|caspase 6, apoptosis-related cysteine protease', map_location='4q25', chromosome='4', genomic_nucleotide_accession_version='NC_000004.12', start_position_on_the_genomic_accession=109688628, end_position_on_the_genomic_accession=109703445, orientation='minus', exon_count=7, OMIM=[601532], no_hdr0=''),
    840 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=840, CurrentID=0, Status='live', Symbol='CASP7', Aliases=['CASP-7', 'CMH-1', 'ICE-LAP3', 'LICE2', 'MCH3'], description='caspase 7', other_designations='caspase-7|ICE-like apoptotic protease 3|apoptotic protease MCH-3|caspase 7, apoptosis-related cysteine peptidase|caspase 7, apoptosis-related cysteine protease', map_location='10q25.3', chromosome='10', genomic_nucleotide_accession_version='NC_000010.11', start_position_on_the_genomic_accession=113679194, end_position_on_the_genomic_accession=113730909, orientation='plus', exon_count=13, OMIM=[601761], no_hdr0=''),
    841 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=841, CurrentID=0, Status='live', Symbol='CASP8', Aliases=['ALPS2B', 'CAP4', 'Casp-8', 'FLICE', 'MACH', 'MCH5'], description='caspase 8', other_designations='caspase-8|FADD-homologous ICE/CED-3-like protease|FADD-like ICE|ICE-like apoptotic protease 5|MACH-alpha-1/2/3 protein|MACH-beta-1/2/3/4 protein|MORT1-associated ced-3 homolog|apoptotic cysteine protease|apoptotic protease Mch-5|caspase 8, apoptosis-related cysteine peptidase|caspase 8, apoptosis-related cysteine protease', map_location='2q33.1', chromosome='2', genomic_nucleotide_accession_version='NC_000002.12', start_position_on_the_genomic_accession=201233443, end_position_on_the_genomic_accession=201287711, orientation='plus', exon_count=15, OMIM=[601763], no_hdr0=''),
    842 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=842, CurrentID=0, Status='live', Symbol='CASP9', Aliases=['APAF-3', 'APAF3', 'ICE-LAP6', 'MCH6', 'PPP1R56'], description='caspase 9', other_designations='caspase-9|ICE-like apoptotic protease 6|apoptotic protease MCH-6|apoptotic protease activating factor 3|caspase 9, apoptosis-related cysteine peptidase|protein phosphatase 1, regulatory subunit 56', map_location='1p36.21', chromosome='1', genomic_nucleotide_accession_version='NC_000001.11', start_position_on_the_genomic_accession=15491401, end_position_on_the_genomic_accession=15524912, orientation='minus', exon_count=11, OMIM=[602234], no_hdr0=''),
    843 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=843, CurrentID=0, Status='live', Symbol='CASP10', Aliases=['ALPS2', 'FLICE-2', 'FLICE2', 'MCH4'], description='caspase 10', other_designations='caspase-10|CASP-10|FADD-like ICE2|FAS-associated death domain protein interleukin-1B-converting enzyme 2|ICE-like apoptotic protease 4|apoptotic protease MCH-4|caspase 10 apoptosis-related cysteine peptidase|caspase 10, apoptosis-related cysteine protease|interleukin-1B-converting enzyme 2', map_location='2q33.1', chromosome='2', genomic_nucleotide_accession_version='NC_000002.12', start_position_on_the_genomic_accession=201182885, end_position_on_the_genomic_accession=201229406, orientation='plus', exon_count=13, OMIM=[601762], no_hdr0=''),
    844 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=844, CurrentID=0, Status='live', Symbol='CASQ1', Aliases=['CASQ', 'PDIB1', 'VMCQA'], description='calsequestrin 1', other_designations='calsequestrin-1|calmitin|calmitine|calsequestrin 1 (fast-twitch, skeletal muscle)', map_location='1q23.2', chromosome='1', genomic_nucleotide_accession_version='NC_000001.11', start_position_on_the_genomic_accession=160190575, end_position_on_the_genomic_accession=160201886, orientation='plus', exon_count=11, OMIM=[114250], no_hdr0=''),
    845 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=845, CurrentID=0, Status='live', Symbol='CASQ2', Aliases=['PDIB2'], description='calsequestrin 2', other_designations='calsequestrin-2|calsequestrin 2 (cardiac muscle)|calsequestrin 2, fast-twitch, cardiac muscle', map_location='1p13.1', chromosome='1', genomic_nucleotide_accession_version='NC_000001.11', start_position_on_the_genomic_accession=115700021, end_position_on_the_genomic_accession=115768714, orientation='minus', exon_count=11, OMIM=[114251], no_hdr0=''),
    846 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=846, CurrentID=0, Status='live', Symbol='CASR', Aliases=['CAR', 'EIG8', 'FHH', 'FIH', 'GPRC2A', 'HHC', 'HHC1', 'HYPOC1', 'NSHPT', 'PCAR1', 'hCasR'], description='calcium sensing receptor', other_designations='extracellular calcium-sensing receptor|parathyroid Ca(2+)-sensing receptor 1|parathyroid cell calcium-sensing receptor 1', map_location='3q13.33-q21.1', chromosome='3', genomic_nucleotide_accession_version='NC_000003.12', start_position_on_the_genomic_accession=122183668, end_position_on_the_genomic_accession=122291629, orientation='plus', exon_count=11, OMIM=[601199], no_hdr0=''),
    847 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=847, CurrentID=0, Status='live', Symbol='CAT', Aliases=[], description='catalase', other_designations='catalase|epididymis secretory sperm binding protein', map_location='11p13', chromosome='11', genomic_nucleotide_accession_version='NC_000011.10', start_position_on_the_genomic_accession=34438934, end_position_on_the_genomic_accession=34472060, orientation='plus', exon_count=13, OMIM=[115500], no_hdr0=''),
    857 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=857, CurrentID=0, Status='live', Symbol='CAV1', Aliases=['BSCL3', 'CGL3', 'LCCNS', 'MSTP085', 'PPH3', 'VIP21'], description='caveolin 1', other_designations='caveolin-1|caveolin 1, caveolae protein, 22kDa|cell growth-inhibiting protein 32', map_location='7q31.2', chromosome='7', genomic_nucleotide_accession_version='NC_000007.14', start_position_on_the_genomic_accession=116525009, end_position_on_the_genomic_accession=116561185, orientation='plus', exon_count=4, OMIM=[601047], no_hdr0=''),
    858 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=858, CurrentID=0, Status='live', Symbol='CAV2', Aliases=['CAV'], description='caveolin 2', other_designations='caveolin-2|caveolae protein, 20-kD', map_location='7q31.2', chromosome='7', genomic_nucleotide_accession_version='NC_000007.14', start_position_on_the_genomic_accession=116499738, end_position_on_the_genomic_accession=116508541, orientation='plus', exon_count=3, OMIM=[601048], no_hdr0=''),
    859 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=859, CurrentID=0, Status='live', Symbol='CAV3', Aliases=['LGMD1C', 'LQT9', 'MPDT', 'RMD2', 'VIP-21', 'VIP21'], description='caveolin 3', other_designations='caveolin-3|M-caveolin|cavolin 3', map_location='3p25.3', chromosome='3', genomic_nucleotide_accession_version='NC_000003.12', start_position_on_the_genomic_accession=8733802, end_position_on_the_genomic_accession=8746758, orientation='plus', exon_count=2, OMIM=[601253], no_hdr0=''),
    860 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=860, CurrentID=0, Status='live', Symbol='RUNX2', Aliases=['AML3', 'CBF-alpha-1', 'CBFA1', 'CCD', 'CCD1', 'CLCD', 'OSF-2', 'OSF2', 'PEA2aA', 'PEBP2aA'], description='RUNX family transcription factor 2', other_designations='runt-related transcription factor 2|PEA2-alpha A|PEBP2-alpha A|SL3-3 enhancer factor 1 alpha A subunit|SL3/AKV core-binding factor alpha A subunit|acute myeloid leukemia 3 protein|core-binding factor, runt domain, alpha subunit 1|oncogene AML-3|osteoblast-specific transcription factor 2|polyomavirus enhancer-binding protein 2 alpha A subunit|runt related transcription factor 2', map_location='6p21.1', chromosome='6', genomic_nucleotide_accession_version='NC_000006.12', start_position_on_the_genomic_accession=45328330, end_position_on_the_genomic_accession=45551082, orientation='plus', exon_count=10, OMIM=[600211], no_hdr0=''),
    861 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=861, CurrentID=0, Status='live', Symbol='RUNX1', Aliases=['AML1', 'AML1-EVI-1', 'AMLCR1', 'CBF2alpha', 'CBFA2', 'EVI-1', 'PEBP2aB', 'PEBP2alpha'], description='RUNX family transcription factor 1', other_designations='runt-related transcription factor 1|AML1-EVI-1 fusion protein|PEA2-alpha B|PEBP2-alpha B|SL3-3 enhancer factor 1 alpha B subunit|SL3/AKV core-binding factor alpha B subunit|acute myeloid leukemia 1 protein|core-binding factor, runt domain, alpha subunit 2|mutant RUNX1|oncogene AML-1|polyomavirus enhancer-binding protein 2 alpha B subunit|runt related transcription factor 1', map_location='21q22.12', chromosome='21', genomic_nucleotide_accession_version='NC_000021.9', start_position_on_the_genomic_accession=34787801, end_position_on_the_genomic_accession=35049334, orientation='minus', exon_count=13, OMIM=[151385], no_hdr0=''),
    862 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=862, CurrentID=0, Status='live', Symbol='RUNX1T1', Aliases=['AML1-MTG8', 'AML1T1', 'CBFA2T1', 'CDR', 'ETO', 'MTG8', 'ZMYND2'], description='RUNX1 partner transcriptional co-repressor 1', other_designations='protein CBFA2T1|RUNX1 translocation partner 1|acute myelogenous leukemia 1 translocation 1, cyclin-D related|core-binding factor, runt domain, alpha subunit 2; translocated to, 1; cyclin D-related|eight twenty one protein|myeloid translocation gene on 8q22|runt related transcription factor 1; translocated to, 1 (cyclin D related)|zinc finger MYND domain-containing protein 2', map_location='8q21.3', chromosome='8', genomic_nucleotide_accession_version='NC_000008.11', start_position_on_the_genomic_accession=91954967, end_position_on_the_genomic_accession=92103451, orientation='minus', exon_count=20, OMIM=[133435], no_hdr0=''),
    863 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=863, CurrentID=0, Status='live', Symbol='CBFA2T3', Aliases=['ETO2', 'MTG16', 'MTGR2', 'RUNX1T3', 'ZMYND4'], description='CBFA2/RUNX1 partner transcriptional co-repressor 3', other_designations='protein CBFA2T3|CBFA2/RUNX1 translocation partner 3|MTG8-related gene 2|MTG8-related protein 2|core-binding factor, runt domain, alpha subunit 2; translocated to, 3|myeloid translocation gene 8 and 16b|myeloid translocation gene on chromosome 16 protein|zinc finger MYND domain-containing protein 4', map_location='16q24.3', chromosome='16', genomic_nucleotide_accession_version='NC_000016.10', start_position_on_the_genomic_accession=88874858, end_position_on_the_genomic_accession=88977207, orientation='minus', exon_count=14, OMIM=[603870], no_hdr0=''),
    864 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=864, CurrentID=0, Status='live', Symbol='RUNX3', Aliases=['AML2', 'CBFA3', 'PEBP2aC'], description='RUNX family transcription factor 3', other_designations='runt-related transcription factor 3|CBF-alpha-3|PEA2 alpha C|PEBP2 alpha C|SL3-3 enhancer factor 1 alpha C subunit|SL3/AKV core-binding factor alpha C subunit|acute myeloid leukemia 2 protein|acute myeloid leukemia gene 2|core-binding factor subunit alpha-3|core-binding factor, runt domain, alpha subunit 3|oncogene AML-2|polyomavirus enhancer-binding protein 2 alpha C subunit|runt related transcription factor 3|transcription factor AML2', map_location='1p36.11', chromosome='1', genomic_nucleotide_accession_version='NC_000001.11', start_position_on_the_genomic_accession=24899511, end_position_on_the_genomic_accession=24965158, orientation='minus', exon_count=7, OMIM=[600210], no_hdr0=''),
    865 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=865, CurrentID=0, Status='live', Symbol='CBFB', Aliases=['PEBP2B'], description='core-binding factor subunit beta', other_designations='core-binding factor subunit beta|CBF-beta|PEA2-beta|PEBP2-beta|SL3-3 enhancer factor 1 beta subunit|SL3-3 enhancer factor 1 subunit beta|SL3/AKV core-binding factor beta subunit|core-binding factor beta subunit|polyomavirus enhancer binding protein 2, beta subunit', map_location='16q22.1', chromosome='16', genomic_nucleotide_accession_version='NC_000016.10', start_position_on_the_genomic_accession=67029149, end_position_on_the_genomic_accession=67101058, orientation='plus', exon_count=6, OMIM=[121360], no_hdr0=''),
    866 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=866, CurrentID=0, Status='live', Symbol='SERPINA6', Aliases=['CBG'], description='serpin family A member 6', other_designations='corticosteroid-binding globulin|serine (or cysteine) proteinase inhibitor, clade A (alpha-1 antiproteinase, antitrypsin), member 6|serpin A6|serpin peptidase inhibitor, clade A (alpha-1 antiproteinase, antitrypsin), member 6|transcortin', map_location='14q32.13', chromosome='14', genomic_nucleotide_accession_version='NC_000014.9', start_position_on_the_genomic_accession=94304248, end_position_on_the_genomic_accession=94323336, orientation='minus', exon_count=5, OMIM=[122500], no_hdr0=''),
    867 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=867, CurrentID=0, Status='live', Symbol='CBL', Aliases=['C-CBL2', 'FRA11B', 'NSLL', 'RNF55', 'CBL'], description='Cbl proto-oncogene', other_designations='E3 ubiquitin-protein ligase CBL|Cas-Br-M (murine) ecotropic retroviral transforming sequence|Cbl proto-oncogene, E3 ubiquitin protein ligase|RING finger protein 55|RING-type E3 ubiquitin transferase CBL|casitas B-lineage lymphoma proto-oncogene|fragile site, folic acid type, rare, fra(11)(q23.3)|oncogene CBL2|proto-oncogene c-Cbl|signal transduction protein CBL', map_location='11q23.3', chromosome='11', genomic_nucleotide_accession_version='NC_000011.10', start_position_on_the_genomic_accession=119206339, end_position_on_the_genomic_accession=119308149, orientation='plus', exon_count=16, OMIM=[165360], no_hdr0=''),
    868 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=868, CurrentID=0, Status='live', Symbol='CBLB', Aliases=['Cbl-b', 'Nbla00127', 'RNF56'], description='Cbl proto-oncogene B', other_designations='E3 ubiquitin-protein ligase CBL-B|Cas-Br-M (murine) ecotropic retroviral transforming sequence b|Cbl proto-oncogene B, E3 ubiquitin protein ligase|Cbl proto-oncogene, E3 ubiquitin protein ligase B|RING finger protein 56|RING-type E3 ubiquitin transferase CBL-B|SH3-binding protein CBL-B|casitas B-lineage lymphoma proto-oncogene b|signal transduction protein CBL-B', map_location='3q13.11', chromosome='3', genomic_nucleotide_accession_version='NC_000003.12', start_position_on_the_genomic_accession=105655461, end_position_on_the_genomic_accession=105869552, orientation='minus', exon_count=31, OMIM=[604491], no_hdr0=''),
    869 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=869, CurrentID=0, Status='live', Symbol='CBLN1', Aliases=[], description='cerebellin 1 precursor', other_designations='cerebellin-1|precerebellin', map_location='16q12.1', chromosome='16', genomic_nucleotide_accession_version='NC_000016.10', start_position_on_the_genomic_accession=49277917, end_position_on_the_genomic_accession=49281838, orientation='minus', exon_count=3, OMIM=[600432], no_hdr0=''),
    871 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=871, CurrentID=0, Status='live', Symbol='SERPINH1', Aliases=['AsTP3', 'CBP1', 'CBP2', 'HSP47', 'OI10', 'PIG14', 'PPROM', 'RA-A47', 'SERPINH2', 'gp46'], description='serpin family H member 1', other_designations='serpin H1|47 kDa heat shock protein|arsenic-transactivated protein 3|cell proliferation-inducing gene 14 protein|collagen binding protein 1|colligin-1|colligin-2|rheumatoid arthritis antigen A-47|rheumatoid arthritis-related antigen RA-A47|serine (or cysteine) proteinase inhibitor, clade H (heat shock protein 47), member 1, (collagen binding protein 1)|serine (or cysteine) proteinase inhibitor, clade H (heat shock protein 47), member 2, (collagen-binding protein 2)|serpin peptidase inhibitor, clade H (heat shock protein 47), member 1, (collagen binding protein 1)', map_location='11q13.5', chromosome='11', genomic_nucleotide_accession_version='NC_000011.10', start_position_on_the_genomic_accession=75562253, end_position_on_the_genomic_accession=75572783, orientation='plus', exon_count=8, OMIM=[600943], no_hdr0=''),
    873 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=873, CurrentID=0, Status='live', Symbol='CBR1', Aliases=['CBR', 'PG-9-KR', 'SDR21C1', 'hCBR1'], description='carbonyl reductase 1', other_designations='carbonyl reductase [NADPH] 1|15-hydroxyprostaglandin dehydrogenase|20-beta-hydroxysteroid dehydrogenase|NADPH-dependent carbonyl reductase 1|carbonyl reductase (NADPH) 1|epididymis secretory sperm binding protein|prostaglandin 9-ketoreductase|prostaglandin-E(2) 9-reductase|short chain dehydrogenase/reductase family 21C member 1', map_location='21q22.12', chromosome='21', genomic_nucleotide_accession_version='NC_000021.9', start_position_on_the_genomic_accession=36070024, end_position_on_the_genomic_accession=36073164, orientation='plus', exon_count=3, OMIM=[114830], no_hdr0=''),
    874 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=874, CurrentID=0, Status='live', Symbol='CBR3', Aliases=['HEL-S-25', 'SDR21C2', 'hCBR3'], description='carbonyl reductase 3', other_designations='carbonyl reductase [NADPH] 3|NADPH-dependent carbonyl reductase 3|carbonyl reductase (NADPH) 3|epididymis secretory protein Li 25|short chain dehydrogenase/reductase family 21C member 2', map_location='21q22.12', chromosome='21', genomic_nucleotide_accession_version='NC_000021.9', start_position_on_the_genomic_accession=36134901, end_position_on_the_genomic_accession=36146562, orientation='plus', exon_count=4, OMIM=[603608], no_hdr0=''),
    875 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=875, CurrentID=0, Status='live', Symbol='CBS', Aliases=['CBSL', 'HIP4'], description='cystathionine beta-synthase', other_designations='cystathionine beta-synthase|Cystathionine beta-synthase-like protein|beta-thionase|methylcysteine synthase|serine sulfhydrase', map_location='21q22.3', chromosome='21', genomic_nucleotide_accession_version='NC_000021.9', start_position_on_the_genomic_accession=43053190, end_position_on_the_genomic_accession=43076873, orientation='minus', exon_count=23, OMIM=[613381], no_hdr0=''),
    881 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=881, CurrentID=0, Status='live', Symbol='CCIN', Aliases=['BTBD20', 'KBTBD14'], description='calicin', other_designations='calicin|testis tissue sperm-binding protein Li 65n', map_location='9p13.3', chromosome='9', genomic_nucleotide_accession_version='NC_000009.12', start_position_on_the_genomic_accession=36169388, end_position_on_the_genomic_accession=36171334, orientation='plus', exon_count=1, OMIM=[603960], no_hdr0=''),
    883 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=883, CurrentID=0, Status='live', Symbol='KYAT1', Aliases=['CCBL1', 'GTK', 'KAT1', 'KATI'], description='kynurenine aminotransferase 1', other_designations='kynurenine--oxoglutarate transaminase 1|beta-lysase, kidney|cysteine conjugate beta lyase 1|cysteine conjugate-beta lyase, cytoplasmic|cysteine conjugate-beta lyase; cytoplasmic (glutamine transaminase K, kyneurenine aminotransferase)|cysteine-S-conjugate beta-lyase|glutamine transaminase K|glutamine--phenylpyruvate transaminase|glutamine-phenylpyruvate aminotransferase|kyneurenine aminotransferase|kynurenine aminotransferase I|kynurenine--oxoglutarate transaminase I', map_location='9q34.11', chromosome='9', genomic_nucleotide_accession_version='NC_000009.12', start_position_on_the_genomic_accession=128832942, end_position_on_the_genomic_accession=128882523, orientation='minus', exon_count=19, OMIM=[600547], no_hdr0=''),
    885 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=885, CurrentID=0, Status='live', Symbol='CCK', Aliases=[], description='cholecystokinin', other_designations='cholecystokinin|cholecystokinin triacontatriapeptide|prepro-cholecystokinin', map_location='3p22.1', chromosome='3', genomic_nucleotide_accession_version='NC_000003.12', start_position_on_the_genomic_accession=42257826, end_position_on_the_genomic_accession=42266185, orientation='minus', exon_count=6, OMIM=[118440], no_hdr0=''),
    886 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=886, CurrentID=0, Status='live', Symbol='CCKAR', Aliases=['CCK-A', 'CCK1-R', 'CCK1R', 'CCKRA'], description='cholecystokinin A receptor', other_designations='cholecystokinin receptor type A|CCK-A receptor|CCK-AR|cholecystokinin type-A receptor|cholecystokinin-1 receptor', map_location='4p15.2', chromosome='4', genomic_nucleotide_accession_version='NC_000004.12', start_position_on_the_genomic_accession=26481396, end_position_on_the_genomic_accession=26490484, orientation='minus', exon_count=5, OMIM=[118444], no_hdr0=''),
    887 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=887, CurrentID=0, Status='live', Symbol='CCKBR', Aliases=['CCK-B', 'CCK2R', 'GASR'], description='cholecystokinin B receptor', other_designations='gastrin/cholecystokinin type B receptor|CCK-B receptor|CCK2 receptor|cholecystokinin-2 receptor|gastrin receptor', map_location='11p15.4', chromosome='11', genomic_nucleotide_accession_version='NC_000011.10', start_position_on_the_genomic_accession=6259838, end_position_on_the_genomic_accession=6272127, orientation='plus', exon_count=5, OMIM=[118445], no_hdr0=''),
    889 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=889, CurrentID=0, Status='live', Symbol='KRIT1', Aliases=['CAM', 'CCM1'], description='KRIT1 ankyrin repeat containing', other_designations='krev interaction trapped protein 1|ankyrin repeat-containing protein Krit1|cerebral cavernous malformations 1 protein|krev interaction trapped 1', map_location='7q21.2', chromosome='7', genomic_nucleotide_accession_version='NC_000007.14', start_position_on_the_genomic_accession=92198969, end_position_on_the_genomic_accession=92246100, orientation='minus', exon_count=20, OMIM=[604214], no_hdr0=''),
    890 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=890, CurrentID=0, Status='live', Symbol='CCNA2', Aliases=['CCN1', 'CCNA'], description='cyclin A2', other_designations='cyclin-A2|cyclin-A', map_location='4q27', chromosome='4', genomic_nucleotide_accession_version='NC_000004.12', start_position_on_the_genomic_accession=121816444, end_position_on_the_genomic_accession=121823883, orientation='minus', exon_count=8, OMIM=[123835], no_hdr0=''),
    891 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=891, CurrentID=0, Status='live', Symbol='CCNB1', Aliases=['CCNB'], description='cyclin B1', other_designations='G2/mitotic-specific cyclin-B1', map_location='5q13.2', chromosome='5', genomic_nucleotide_accession_version='NC_000005.10', start_position_on_the_genomic_accession=69167150, end_position_on_the_genomic_accession=69178245, orientation='plus', exon_count=9, OMIM=[123836], no_hdr0=''),
    892 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=892, CurrentID=0, Status='live', Symbol='CCNC', Aliases=['CycC', 'SRB11', 'hSRB11'], description='cyclin C', other_designations='cyclin-C|SRB11 homolog', map_location='6q16.2', chromosome='6', genomic_nucleotide_accession_version='NC_000006.12', start_position_on_the_genomic_accession=99542387, end_position_on_the_genomic_accession=99568814, orientation='minus', exon_count=16, OMIM=[123838], no_hdr0=''),
    894 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=894, CurrentID=0, Status='live', Symbol='CCND2', Aliases=['KIAK0002', 'MPPH3'], description='cyclin D2', other_designations='G1/S-specific cyclin-D2', map_location='12p13.32', chromosome='12', genomic_nucleotide_accession_version='NC_000012.12', start_position_on_the_genomic_accession=4273762, end_position_on_the_genomic_accession=4305353, orientation='plus', exon_count=5, OMIM=[123833], no_hdr0=''),
    896 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=896, CurrentID=0, Status='live', Symbol='CCND3', Aliases=[], description='cyclin D3', other_designations='G1/S-specific cyclin-D3|D3-type cyclin', map_location='6p21.1', chromosome='6', genomic_nucleotide_accession_version='NC_000006.12', start_position_on_the_genomic_accession=41934933, end_position_on_the_genomic_accession=42048894, orientation='minus', exon_count=7, OMIM=[123834], no_hdr0=''),
    898 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=898, CurrentID=0, Status='live', Symbol='CCNE1', Aliases=['CCNE', 'pCCNE1'], description='cyclin E1', other_designations='G1/S-specific cyclin-E1', map_location='19q12', chromosome='19', genomic_nucleotide_accession_version='NC_000019.10', start_position_on_the_genomic_accession=29811991, end_position_on_the_genomic_accession=29824312, orientation='plus', exon_count=12, OMIM=[123837], no_hdr0=''),
    899 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=899, CurrentID=0, Status='live', Symbol='CCNF', Aliases=['FBX1', 'FBXO1'], description='cyclin F', other_designations='cyclin-F|F-box only protein 1|G2/mitotic-specific cyclin-F', map_location='16p13.3', chromosome='16', genomic_nucleotide_accession_version='NC_000016.10', start_position_on_the_genomic_accession=2429447, end_position_on_the_genomic_accession=2458854, orientation='plus', exon_count=17, OMIM=[600227], no_hdr0=''),
    900 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=900, CurrentID=0, Status='live', Symbol='CCNG1', Aliases=['CCNG'], description='cyclin G1', other_designations='cyclin-G1|cyclin-G', map_location='5q34', chromosome='5', genomic_nucleotide_accession_version='NC_000005.10', start_position_on_the_genomic_accession=163437571, end_position_on_the_genomic_accession=163448199, orientation='plus', exon_count=11, OMIM=[601578], no_hdr0=''),
    901 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=901, CurrentID=0, Status='live', Symbol='CCNG2', Aliases=[], description='cyclin G2', other_designations='cyclin-G2', map_location='4q21.1', chromosome='4', genomic_nucleotide_accession_version='NC_000004.12', start_position_on_the_genomic_accession=77157207, end_position_on_the_genomic_accession=77170060, orientation='plus', exon_count=10, OMIM=[603203], no_hdr0=''),
    902 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=902, CurrentID=0, Status='live', Symbol='CCNH', Aliases=['CAK', 'CycH', 'p34', 'p37'], description='cyclin H', other_designations='cyclin-H|CAK complex subunit|CDK-activating kinase complex subunit|MO15-associated protein|cyclin-dependent kinase-activating kinase complex subunit', map_location='5q14.3', chromosome='5', genomic_nucleotide_accession_version='NC_000005.10', start_position_on_the_genomic_accession=87311471, end_position_on_the_genomic_accession=87412971, orientation='minus', exon_count=11, OMIM=[601953], no_hdr0=''),
    904 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=904, CurrentID=0, Status='live', Symbol='CCNT1', Aliases=['CCNT', 'CYCT1', 'HIVE1'], description='cyclin T1', other_designations='cyclin-T1|CDK9-associated C-type protein|MLLT10/CCNT1 fusion|cyclin C-related protein|human immunodeficiency virus type 1 (HIV-1) expression (elevated) 1', map_location='12q13.11-q13.12', chromosome='12', genomic_nucleotide_accession_version='NC_000012.12', start_position_on_the_genomic_accession=48688458, end_position_on_the_genomic_accession=48716707, orientation='minus', exon_count=10, OMIM=[143055], no_hdr0=''),
    905 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=905, CurrentID=0, Status='live', Symbol='CCNT2', Aliases=['CYCT2'], description='cyclin T2', other_designations='cyclin-T2|SDS-stable vimentin-bound DNA fragment HEF42VIM22|cyclin T2a|cyclin T2b|subunit of positive elongation transcription factor b', map_location='2q21.3', chromosome='2', genomic_nucleotide_accession_version='NC_000002.12', start_position_on_the_genomic_accession=134918810, end_position_on_the_genomic_accession=134959342, orientation='plus', exon_count=10, OMIM=[603862], no_hdr0=''),
    908 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=908, CurrentID=0, Status='live', Symbol='CCT6A', Aliases=['CCT-zeta', 'CCT-zeta-1', 'CCT6', 'Cctz', 'HTR3', 'MoDP-2', 'TCP-1-zeta', 'TCP20', 'TCPZ', 'TTCP20'], description='chaperonin containing TCP1 subunit 6A', other_designations='T-complex protein 1 subunit zeta|T-complex protein 1, zeta subunit|acute morphine dependence related protein 2|amino acid transport defect-complementing|chaperonin containing T-complex subunit 6|chaperonin containing TCP1, subunit 6A (zeta 1)|histidine transport regulator 3', map_location='7p11.2', chromosome='7', genomic_nucleotide_accession_version='NC_000007.14', start_position_on_the_genomic_accession=56051765, end_position_on_the_genomic_accession=56063989, orientation='plus', exon_count=14, OMIM=[104613], no_hdr0=''),
    909 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=909, CurrentID=0, Status='live', Symbol='CD1A', Aliases=['CD1', 'FCB6', 'HTA1', 'R4', 'T6'], description='CD1a molecule', other_designations='T-cell surface glycoprotein CD1a|CD1A antigen, a polypeptide|T-cell surface antigen T6/Leu-6|cluster of differentiation 1 A|cortical thymocyte antigen CD1A|differentiation antigen CD1-alpha-3|epidermal dendritic cell marker CD1a|hTa1 thymocyte antigen', map_location='1q23.1', chromosome='1', genomic_nucleotide_accession_version='NC_000001.11', start_position_on_the_genomic_accession=158248336, end_position_on_the_genomic_accession=158258269, orientation='plus', exon_count=8, OMIM=[188370], no_hdr0=''),
    910 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=910, CurrentID=0, Status='live', Symbol='CD1B', Aliases=['CD1', 'CD1A', 'R1'], description='CD1b molecule', other_designations='T-cell surface glycoprotein CD1b|CD1B antigen, b polypeptide|cortical thymocyte antigen CD1B|differentiation antigen CD1-alpha-3', map_location='1q23.1', chromosome='1', genomic_nucleotide_accession_version='NC_000001.11', start_position_on_the_genomic_accession=158285406, end_position_on_the_genomic_accession=158331531, orientation='minus', exon_count=8, OMIM=[188360], no_hdr0=''),
    911 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=911, CurrentID=0, Status='live', Symbol='CD1C', Aliases=['BDCA1', 'CD1', 'CD1A', 'R7'], description='CD1c molecule', other_designations='T-cell surface glycoprotein CD1c|CD1C antigen, c polypeptide|cortical thymocyte antigen CD1C|differentiation antigen CD1-alpha-3', map_location='1q23.1', chromosome='1', genomic_nucleotide_accession_version='NC_000001.11', start_position_on_the_genomic_accession=158289887, end_position_on_the_genomic_accession=158294774, orientation='plus', exon_count=6, OMIM=[188340], no_hdr0=''),
    912 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=912, CurrentID=0, Status='live', Symbol='CD1D', Aliases=['CD1A', 'R3', 'R3G1'], description='CD1d molecule', other_designations='antigen-presenting glycoprotein CD1d|CD1D antigen, d polypeptide|HMC class I antigen-like glycoprotein CD1D|T-cell surface glycoprotein CD1d|differentiation antigen CD1-alpha-3|thymocyte antigen CD1D', map_location='1q23.1', chromosome='1', genomic_nucleotide_accession_version='NC_000001.11', start_position_on_the_genomic_accession=158178030, end_position_on_the_genomic_accession=158186427, orientation='plus', exon_count=8, OMIM=[188410], no_hdr0=''),
    913 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=913, CurrentID=0, Status='live', Symbol='CD1E', Aliases=['CD1A', 'R2'], description='CD1e molecule', other_designations='T-cell surface glycoprotein CD1e, membrane-associated|CD1E antigen, e polypeptide|R2G1|differentiation antigen CD1-alpha-3|hCD1e|leukocyte differentiation antigen|thymocyte antigen CD1E', map_location='1q23.1', chromosome='1', genomic_nucleotide_accession_version='NC_000001.11', start_position_on_the_genomic_accession=158353123, end_position_on_the_genomic_accession=158357554, orientation='plus', exon_count=6, OMIM=[188411], no_hdr0=''),
    914 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=914, CurrentID=0, Status='live', Symbol='CD2', Aliases=['LFA-2', 'SRBC', 'T11'], description='CD2 molecule', other_designations='T-cell surface antigen CD2|CD2 antigen (p50), sheep red blood cell receptor|LFA-3 receptor|T-cell surface antigen T11/Leu-5|erythrocyte receptor|lymphocyte-function antigen-2|rosette receptor', map_location='1p13.1', chromosome='1', genomic_nucleotide_accession_version='NC_000001.11', start_position_on_the_genomic_accession=116754430, end_position_on_the_genomic_accession=116769229, orientation='plus', exon_count=5, OMIM=[186990], no_hdr0=''),
    915 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=915, CurrentID=0, Status='live', Symbol='CD3D', Aliases=['CD3-DELTA', 'IMD19', 'T3D'], description='CD3d molecule', other_designations='T-cell surface glycoprotein CD3 delta chain|CD3 antigen, delta subunit|CD3 delta|CD3d antigen, delta polypeptide (TiT3 complex)|CD3d molecule, delta (CD3-TCR complex)|OKT3, delta chain|T-cell receptor T3 delta chain', map_location='11q23.3', chromosome='11', genomic_nucleotide_accession_version='NC_000011.10', start_position_on_the_genomic_accession=118338954, end_position_on_the_genomic_accession=118342705, orientation='minus', exon_count=5, OMIM=[186790], no_hdr0=''),
    916 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=916, CurrentID=0, Status='live', Symbol='CD3E', Aliases=['IMD18', 'T3E', 'TCRE'], description='CD3e molecule', other_designations='T-cell surface glycoprotein CD3 epsilon chain|CD3-epsilon|CD3e antigen, epsilon polypeptide (TiT3 complex)|CD3e molecule, epsilon (CD3-TCR complex)|T-cell antigen receptor complex, epsilon subunit of T3|T-cell surface antigen T3/Leu-4 epsilon chain', map_location='11q23.3', chromosome='11', genomic_nucleotide_accession_version='NC_000011.10', start_position_on_the_genomic_accession=118304730, end_position_on_the_genomic_accession=118316173, orientation='plus', exon_count=9, OMIM=[186830], no_hdr0=''),
    917 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=917, CurrentID=0, Status='live', Symbol='CD3G', Aliases=['CD3-GAMMA', 'IMD17', 'T3G'], description='CD3g molecule', other_designations='T-cell surface glycoprotein CD3 gamma chain|CD3g antigen, gamma polypeptide (TiT3 complex)|CD3g molecule, epsilon (CD3-TCR complex)|CD3g molecule, gamma (CD3-TCR complex)|T-cell antigen receptor complex, gamma subunit of T3|T-cell receptor T3 gamma chain', map_location='11q23.3', chromosome='11', genomic_nucleotide_accession_version='NC_000011.10', start_position_on_the_genomic_accession=118344344, end_position_on_the_genomic_accession=118355161, orientation='plus', exon_count=7, OMIM=[186740], no_hdr0=''),
    919 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=919, CurrentID=0, Status='live', Symbol='CD247', Aliases=['CD3-ZETA', 'CD3H', 'CD3Q', 'CD3Z', 'IMD25', 'T3Z', 'TCRZ'], description='CD247 molecule', other_designations='T-cell surface glycoprotein CD3 zeta chain|CD247 antigen, zeta subunit|CD3Z antigen, zeta polypeptide (TiT3 complex)|CD3zeta chain|T-cell antigen receptor complex, zeta subunit of CD3|T-cell receptor T3 zeta chain|TCR zeta chain', map_location='1q24.2', chromosome='1', genomic_nucleotide_accession_version='NC_000001.11', start_position_on_the_genomic_accession=167430640, end_position_on_the_genomic_accession=167518542, orientation='minus', exon_count=10, OMIM=[186780], no_hdr0=''),
    920 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=920, CurrentID=0, Status='live', Symbol='CD4', Aliases=['CD4mut'], description='CD4 molecule', other_designations='T-cell surface glycoprotein CD4|CD4 antigen (p55)|CD4 receptor|T-cell surface antigen T4/Leu-3', map_location='12p13.31', chromosome='12', genomic_nucleotide_accession_version='NC_000012.12', start_position_on_the_genomic_accession=6789528, end_position_on_the_genomic_accession=6820799, orientation='plus', exon_count=11, OMIM=[186940], no_hdr0=''),
    921 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=921, CurrentID=0, Status='live', Symbol='CD5', Aliases=['LEU1', 'T1'], description='CD5 molecule', other_designations='T-cell surface glycoprotein CD5|CD5 antigen (p56-62)|epididymis secretory sperm binding protein|lymphocyte antigen T1/Leu-1', map_location='11q12.2', chromosome='11', genomic_nucleotide_accession_version='NC_000011.10', start_position_on_the_genomic_accession=61093963, end_position_on_the_genomic_accession=61127852, orientation='plus', exon_count=12, OMIM=[153340], no_hdr0=''),
    922 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=922, CurrentID=0, Status='live', Symbol='CD5L', Aliases=['AIM', 'API6', 'CT-2', 'PRO229', 'SP-ALPHA', 'Spalpha', 'hAIM'], description='CD5 molecule like', other_designations='CD5 antigen-like|CD5 antigen-like (scavenger receptor cysteine rich family)|apoptosis inhibitor 6|apoptosis inhibitor expressed by macrophages|apoptosis inhibitor of macrophage|igM-associated peptide', map_location='1q23.1', chromosome='1', genomic_nucleotide_accession_version='NC_000001.11', start_position_on_the_genomic_accession=157827068, end_position_on_the_genomic_accession=157841844, orientation='minus', exon_count=7, OMIM=[602592], no_hdr0=''),
    923 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=923, CurrentID=0, Status='live', Symbol='CD6', Aliases=['TP120'], description='CD6 molecule', other_designations='T-cell differentiation antigen CD6|CD6 antigen|T12', map_location='11q12.2', chromosome='11', genomic_nucleotide_accession_version='NC_000011.10', start_position_on_the_genomic_accession=60971678, end_position_on_the_genomic_accession=61020377, orientation='plus', exon_count=13, OMIM=[186720], no_hdr0=''),
    924 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=924, CurrentID=0, Status='live', Symbol='CD7', Aliases=['GP40', 'LEU-9', 'TP41', 'Tp40'], description='CD7 molecule', other_designations='T-cell antigen CD7|CD7 antigen (p41)|T-cell leukemia antigen|T-cell surface antigen Leu-9|p41 protein', map_location='17q25.3', chromosome='17', genomic_nucleotide_accession_version='NC_000017.11', start_position_on_the_genomic_accession=82314865, end_position_on_the_genomic_accession=82320829, orientation='minus', exon_count=4, OMIM=[186820], no_hdr0=''),
    925 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=925, CurrentID=0, Status='live', Symbol='CD8A', Aliases=['CD8', 'Leu2', 'p32'], description='CD8a molecule', other_designations='T-cell surface glycoprotein CD8 alpha chain|CD8 antigen, alpha polypeptide (p32)|Leu2 T-lymphocyte antigen|OKT8 T-cell antigen|T cell co-receptor|T-cell antigen Leu2|T-lymphocyte differentiation antigen T8/Leu-2|T8 T-cell antigen', map_location='2p11.2', chromosome='2', genomic_nucleotide_accession_version='NC_000002.12', start_position_on_the_genomic_accession=86784605, end_position_on_the_genomic_accession=86808396, orientation='minus', exon_count=10, OMIM=[186910], no_hdr0=''),
    926 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=926, CurrentID=0, Status='live', Symbol='CD8B', Aliases=['CD8B1', 'LEU2', 'LY3', 'LYT3', 'P37'], description='CD8b molecule', other_designations='T-cell surface glycoprotein CD8 beta chain|CD8 antigen, beta polypeptide 1 (p37)|T lymphocyte surface glycoprotein beta chain', map_location='2p11.2', chromosome='2', genomic_nucleotide_accession_version='NC_000002.12', start_position_on_the_genomic_accession=86815369, end_position_on_the_genomic_accession=86861886, orientation='minus', exon_count=8, OMIM=[186730], no_hdr0=''),
    927 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=927, CurrentID=0, Status='live', Symbol='CD8B2', Aliases=['CD8BP'], description='CD8b2 molecule', other_designations='T-cell surface glycoprotein CD8 beta-2 chain|CD8 antigen, beta polypeptide pseudogene|CD8b molecule pseudogene|CD8b pseudogene|putative T-cell surface glycoprotein CD8 beta-2 chain', map_location='2q12.2', chromosome='2', genomic_nucleotide_accession_version='NC_000002.12', start_position_on_the_genomic_accession=106487335, end_position_on_the_genomic_accession=106544297, orientation='plus', exon_count=7, OMIM=[], no_hdr0=''),
    928 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=928, CurrentID=0, Status='live', Symbol='CD9', Aliases=['BTCC-1', 'DRAP-27', 'MIC3', 'MRP-1', 'TSPAN-29', 'TSPAN29'], description='CD9 molecule', other_designations='CD9 antigen|5H9 antigen|BA-2/p24 antigen|CD9 antigen (p24)|antigen CD9|cell growth-inhibiting gene 2 protein|leukocyte antigen MIC3|motility related protein-1|tetraspanin-29', map_location='12p13.31', chromosome='12', genomic_nucleotide_accession_version='NC_000012.12', start_position_on_the_genomic_accession=6199946, end_position_on_the_genomic_accession=6238266, orientation='plus', exon_count=9, OMIM=[143030], no_hdr0=''),
    929 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=929, CurrentID=0, Status='live', Symbol='CD14', Aliases=[], description='CD14 molecule', other_designations='monocyte differentiation antigen CD14|myeloid cell-specific leucine-rich glycoprotein', map_location='5q31.3', chromosome='5', genomic_nucleotide_accession_version='NC_000005.10', start_position_on_the_genomic_accession=140631732, end_position_on_the_genomic_accession=140633701, orientation='minus', exon_count=3, OMIM=[158120], no_hdr0=''),
    930 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=930, CurrentID=0, Status='live', Symbol='CD19', Aliases=['B4', 'CVID3'], description='CD19 molecule', other_designations='B-lymphocyte antigen CD19|B-lymphocyte surface antigen B4|T-cell surface antigen Leu-12|differentiation antigen CD19', map_location='16p11.2', chromosome='16', genomic_nucleotide_accession_version='NC_000016.10', start_position_on_the_genomic_accession=28931735, end_position_on_the_genomic_accession=28939347, orientation='plus', exon_count=15, OMIM=[107265], no_hdr0=''),
    931 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=931, CurrentID=0, Status='live', Symbol='MS4A1', Aliases=['B1', 'Bp35', 'CD20', 'CVID5', 'LEU-16', 'MS4A2', 'S7'], description='membrane spanning 4-domains A1', other_designations='B-lymphocyte antigen CD20|B-lymphocyte cell-surface antigen B1|CD20 antigen|CD20 receptor|leukocyte surface antigen Leu-16|membrane-spanning 4-domains, subfamily A, member 1', map_location='11q12.2', chromosome='11', genomic_nucleotide_accession_version='NC_000011.10', start_position_on_the_genomic_accession=60455847, end_position_on_the_genomic_accession=60470752, orientation='plus', exon_count=8, OMIM=[112210], no_hdr0=''),
    932 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=932, CurrentID=0, Status='live', Symbol='MS4A3', Aliases=['CD20L', 'HTM4'], description='membrane spanning 4-domains A3', other_designations='membrane-spanning 4-domains subfamily A member 3|CD20 antigen homolog|CD20 antigen-like protein|IgE receptor beta chain|IgE receptor beta subunit|hematopoietic cell 4 transmembrane protein|hematopoietic-specific transmembrane protein 4|membrane-spanning 4-domains, subfamily A, member 3 (hematopoietic cell-specific)', map_location='11q12.1', chromosome='11', genomic_nucleotide_accession_version='NC_000011.10', start_position_on_the_genomic_accession=60056665, end_position_on_the_genomic_accession=60071116, orientation='plus', exon_count=8, OMIM=[606498], no_hdr0=''),
    933 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=933, CurrentID=0, Status='live', Symbol='CD22', Aliases=['SIGLEC-2', 'SIGLEC2'], description='CD22 molecule', other_designations='B-cell receptor CD22|B-lymphocyte cell adhesion molecule|BL-CAM|CD22 antigen|T-cell surface antigen Leu-14|sialic acid-binding Ig-like lectin 2', map_location='19q13.12', chromosome='19', genomic_nucleotide_accession_version='NC_000019.10', start_position_on_the_genomic_accession=35329187, end_position_on_the_genomic_accession=35347361, orientation='plus', exon_count=14, OMIM=[107266], no_hdr0=''),
    939 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=939, CurrentID=0, Status='live', Symbol='CD27', Aliases=['S152', 'S152. LPFS2', 'T14', 'TNFRSF7', 'Tp55'], description='CD27 molecule', other_designations='CD27 antigen|CD27L receptor|T cell activation antigen S152|T-cell activation antigen CD27|tumor necrosis factor receptor superfamily, member 7', map_location='12p13.31', chromosome='12', genomic_nucleotide_accession_version='NC_000012.12', start_position_on_the_genomic_accession=6444867, end_position_on_the_genomic_accession=6451718, orientation='plus', exon_count=6, OMIM=[186711], no_hdr0=''),
    940 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=940, CurrentID=0, Status='live', Symbol='CD28', Aliases=['Tp44'], description='CD28 molecule', other_designations='T-cell-specific surface glycoprotein CD28', map_location='2q33.2', chromosome='2', genomic_nucleotide_accession_version='NC_000002.12', start_position_on_the_genomic_accession=203706509, end_position_on_the_genomic_accession=203739756, orientation='plus', exon_count=5, OMIM=[186760], no_hdr0=''),
    941 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=941, CurrentID=0, Status='live', Symbol='CD80', Aliases=['B7', 'B7-1', 'B7.1', 'BB1', 'CD28LG', 'CD28LG1', 'LAB7'], description='CD80 molecule', other_designations='T-lymphocyte activation antigen CD80|B-lymphocyte activation antigen B7|CD80 antigen (CD28 antigen ligand 1, B7-1 antigen)|CTLA-4 counter-receptor B7.1|activation B7-1 antigen|costimulatory factor CD80|costimulatory molecule variant IgV-CD80', map_location='3q13.33', chromosome='3', genomic_nucleotide_accession_version='NC_000003.12', start_position_on_the_genomic_accession=119524293, end_position_on_the_genomic_accession=119559614, orientation='minus', exon_count=7, OMIM=[112203], no_hdr0=''),
    942 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=942, CurrentID=0, Status='live', Symbol='CD86', Aliases=['B7-2', 'B7.2', 'B70', 'CD28LG2', 'LAB72'], description='CD86 molecule', other_designations='T-lymphocyte activation antigen CD86|B-lymphocyte activation antigen B7-2|BU63|CD86 antigen (CD28 antigen ligand 2, B7-2 antigen)|CTLA-4 counter-receptor B7.2|FUN-1', map_location='3q13.33', chromosome='3', genomic_nucleotide_accession_version='NC_000003.12', start_position_on_the_genomic_accession=122055362, end_position_on_the_genomic_accession=122121136, orientation='plus', exon_count=8, OMIM=[601020], no_hdr0=''),
    943 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=943, CurrentID=0, Status='live', Symbol='TNFRSF8', Aliases=['CD30', 'D1S166E', 'Ki-1'], description='TNF receptor superfamily member 8', other_designations='tumor necrosis factor receptor superfamily member 8|CD30L receptor|Ki-1 antigen|cytokine receptor CD30|lymphocyte activation antigen CD30', map_location='1p36.22', chromosome='1', genomic_nucleotide_accession_version='NC_000001.11', start_position_on_the_genomic_accession=12063303, end_position_on_the_genomic_accession=12144213, orientation='plus', exon_count=16, OMIM=[153243], no_hdr0=''),
    944 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=944, CurrentID=0, Status='live', Symbol='TNFSF8', Aliases=['CD153', 'CD30L', 'CD30LG', 'TNLG3A'], description='TNF superfamily member 8', other_designations='tumor necrosis factor ligand superfamily member 8|CD153 antigen|CD30 antigen ligand|CD30 ligand|CD30-L|tumor necrosis factor (ligand) superfamily, member 8|tumor necrosis factor ligand 3A|tumor necrosis factor superfamily member 8', map_location='9q32-q33.1', chromosome='9', genomic_nucleotide_accession_version='NC_000009.12', start_position_on_the_genomic_accession=114893343, end_position_on_the_genomic_accession=114930674, orientation='minus', exon_count=6, OMIM=[603875], no_hdr0=''),
    945 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=945, CurrentID=0, Status='live', Symbol='CD33', Aliases=['SIGLEC-3', 'SIGLEC3', 'p67'], description='CD33 molecule', other_designations='myeloid cell surface antigen CD33|CD33 antigen (gp67)|CD33 molecule transcript|gp67|sialic acid-binding Ig-like lectin 3', map_location='19q13.41', chromosome='19', genomic_nucleotide_accession_version='NC_000019.10', start_position_on_the_genomic_accession=51211054, end_position_on_the_genomic_accession=51240016, orientation='plus', exon_count=14, OMIM=[159590], no_hdr0=''),
    946 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=946, CurrentID=0, Status='live', Symbol='SIGLEC6', Aliases=['CD327', 'CD33L', 'CD33L1', 'CD33L2', 'CDW327', 'OBBP1'], description='sialic acid binding Ig like lectin 6', other_designations='sialic acid-binding Ig-like lectin 6|CD33 antigen-like 1|obesity-binding protein 1', map_location='19q13.41', chromosome='19', genomic_nucleotide_accession_version='NC_000019.10', start_position_on_the_genomic_accession=51517819, end_position_on_the_genomic_accession=51531803, orientation='minus', exon_count=11, OMIM=[604405], no_hdr0=''),
    947 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=947, CurrentID=0, Status='live', Symbol='CD34', Aliases=[], description='CD34 molecule', other_designations='hematopoietic progenitor cell antigen CD34|CD34 antigen', map_location='1q32.2', chromosome='1', genomic_nucleotide_accession_version='NC_000001.11', start_position_on_the_genomic_accession=207880972, end_position_on_the_genomic_accession=207911125, orientation='minus', exon_count=8, OMIM=[142230], no_hdr0=''),
    948 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=948, CurrentID=0, Status='live', Symbol='CD36', Aliases=['BDPLT10', 'CHDS7', 'FAT', 'GP3B', 'GP4', 'GPIV', 'PASIV', 'SCARB3'], description='CD36 molecule', other_designations='platelet glycoprotein 4|CD36 antigen (collagen type I receptor, thrombospondin receptor)|CD36 molecule (thrombospondin receptor)|GPIIIB|PAS IV|PAS-4 protein|cluster determinant 36|fatty acid translocase|glycoprotein IIIb|leukocyte differentiation antigen CD36|platelet glycoprotein IV|scavenger receptor class B, member 3', map_location='7q21.11', chromosome='7', genomic_nucleotide_accession_version='NC_000007.14', start_position_on_the_genomic_accession=80602207, end_position_on_the_genomic_accession=80679277, orientation='plus', exon_count=19, OMIM=[173510], no_hdr0=''),
    949 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=949, CurrentID=0, Status='live', Symbol='SCARB1', Aliases=['CD36L1', 'CLA-1', 'CLA1', 'HDLQTL6', 'SR-BI', 'SRB1'], description='scavenger receptor class B member 1', other_designations='scavenger receptor class B member 1|CD36 and LIMPII analogous 1|CD36 antigen (collagen type I receptor, thrombospondin receptor)-like 1|scavenger receptor class B type III', map_location='12q24.31', chromosome='12', genomic_nucleotide_accession_version='NC_000012.12', start_position_on_the_genomic_accession=124776856, end_position_on_the_genomic_accession=124863864, orientation='minus', exon_count=15, OMIM=[601040], no_hdr0=''),
    950 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=950, CurrentID=0, Status='live', Symbol='SCARB2', Aliases=['AMRF', 'CD36L2', 'EPM4', 'HLGP85', 'LGP85', 'LIMP-2', 'LIMPII', 'SR-BII'], description='scavenger receptor class B member 2', other_designations='lysosome membrane protein 2|85 kDa lysosomal membrane sialoglycoprotein|85 kDa lysosomal sialoglycoprotein scavenger receptor class B, member 2|CD36 antigen (collagen type I receptor, thrombospondin receptor)-like 2 (lysosomal integral membrane protein II)|CD36 antigen-like 2|LIMP II|lysosome membrane protein II', map_location='4q21.1', chromosome='4', genomic_nucleotide_accession_version='NC_000004.12', start_position_on_the_genomic_accession=76158737, end_position_on_the_genomic_accession=76213824, orientation='minus', exon_count=12, OMIM=[602257], no_hdr0=''),
    951 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=951, CurrentID=0, Status='live', Symbol='CD37', Aliases=['GP52-40', 'TSPAN26'], description='CD37 molecule', other_designations='leukocyte antigen CD37|cell differentiation antigen 37|leukocyte surface antigen CD37|tetraspanin-26|tspan-26', map_location='19q13.33', chromosome='19', genomic_nucleotide_accession_version='NC_000019.10', start_position_on_the_genomic_accession=49334961, end_position_on_the_genomic_accession=49340608, orientation='plus', exon_count=8, OMIM=[151523], no_hdr0=''),
    952 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=952, CurrentID=0, Status='live', Symbol='CD38', Aliases=['ADPRC 1', 'ADPRC1'], description='CD38 molecule', other_designations="ADP-ribosyl cyclase/cyclic ADP-ribose hydrolase 1|2'-phospho-ADP-ribosyl cyclase|2'-phospho-cyclic-ADP-ribose transferase|ADP-ribosyl cyclase 1|CD38 antigen (p45)|NAD(+) nucleosidase|cluster of differentiation 38|cyclic ADP-ribose hydrolase 1|ecto-nicotinamide adenine dinucleotide glycohydrolase", map_location='4p15.32', chromosome='4', genomic_nucleotide_accession_version='NC_000004.12', start_position_on_the_genomic_accession=15778328, end_position_on_the_genomic_accession=15853232, orientation='plus', exon_count=8, OMIM=[107270], no_hdr0=''),
    953 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=953, CurrentID=0, Status='live', Symbol='ENTPD1', Aliases=['ATPDase', 'CD39', 'NTPDase-1', 'SPG64'], description='ectonucleoside triphosphate diphosphohydrolase 1', other_designations='ectonucleoside triphosphate diphosphohydrolase 1|CD39 antigen|ecto-ATP diphosphohydrolase 1|ecto-ATPDase 1|ecto-ATPase 1|ecto-apyrase|lymphoid cell activation antigen', map_location='10q24.1', chromosome='10', genomic_nucleotide_accession_version='NC_000010.11', start_position_on_the_genomic_accession=95710901, end_position_on_the_genomic_accession=95877266, orientation='plus', exon_count=18, OMIM=[601752], no_hdr0=''),
    954 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=954, CurrentID=0, Status='live', Symbol='ENTPD2', Aliases=['CD39L1', 'NTPDase-2'], description='ectonucleoside triphosphate diphosphohydrolase 2', other_designations='ectonucleoside triphosphate diphosphohydrolase 2|CD39 antigen-like 1|NTPDase 2|ecto-ATP diphosphohydrolase 2|ecto-ATPDase 2|ecto-ATPase 2', map_location='9q34.3', chromosome='9', genomic_nucleotide_accession_version='NC_000009.12', start_position_on_the_genomic_accession=137048107, end_position_on_the_genomic_accession=137054061, orientation='minus', exon_count=9, OMIM=[602012], no_hdr0=''),
    955 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=955, CurrentID=0, Status='live', Symbol='ENTPD6', Aliases=['CD39L2', 'IL-6SAG', 'IL6ST2', 'NTPDase-6', 'dJ738P15.3'], description='ectonucleoside triphosphate diphosphohydrolase 6', other_designations='ectonucleoside triphosphate diphosphohydrolase 6|CD39 antigen-like 2|NTPDase 6|ectonucleoside triphosphate diphosphohydrolase 6 (putative)|interleukin 6 signal transducer-2', map_location='20p11.21', chromosome='20', genomic_nucleotide_accession_version='NC_000020.11', start_position_on_the_genomic_accession=25195703, end_position_on_the_genomic_accession=25228075, orientation='plus', exon_count=19, OMIM=[603160], no_hdr0=''),
    956 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=956, CurrentID=0, Status='live', Symbol='ENTPD3', Aliases=['CD39L3', 'HB6', 'NTPDase-3'], description='ectonucleoside triphosphate diphosphohydrolase 3', other_designations='ectonucleoside triphosphate diphosphohydrolase 3|CD39 antigen-like 3|NTPDase 3|ecto-ATP diphosphohydrolase 3|ecto-ATPDase 3|ecto-ATPase 3|ecto-apyrase 3', map_location='3p22.1', chromosome='3', genomic_nucleotide_accession_version='NC_000003.12', start_position_on_the_genomic_accession=40387182, end_position_on_the_genomic_accession=40428744, orientation='plus', exon_count=13, OMIM=[603161], no_hdr0=''),
    957 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=957, CurrentID=0, Status='live', Symbol='ENTPD5', Aliases=['CD39L4', 'NTPDase-5', 'PCPH'], description='ectonucleoside triphosphate diphosphohydrolase 5 (inactive)', other_designations='ectonucleoside triphosphate diphosphohydrolase 5|CD39 antigen-like 4|CD39-like 4|ER-UDPase|GDPase ENTPD5|NTPDase 5|Pcph proto-oncogene protein|UDPase ENTPD5|guanosine-diphosphatase ENTPD5|nucleoside diphosphatase|proto-oncogene CPH|uridine-diphosphatase ENTPD5', map_location='14q24.3', chromosome='14', genomic_nucleotide_accession_version='NC_000014.9', start_position_on_the_genomic_accession=73955329, end_position_on_the_genomic_accession=74019326, orientation='minus', exon_count=23, OMIM=[603162], no_hdr0=''),
    958 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=958, CurrentID=0, Status='live', Symbol='CD40', Aliases=['Bp50', 'CDW40', 'TNFRSF5', 'p50'], description='CD40 molecule', other_designations='tumor necrosis factor receptor superfamily member 5|B cell surface antigen CD40|B cell-associated molecule|CD40 molecule, TNF receptor superfamily member 5|CD40L receptor', map_location='20q13.12', chromosome='20', genomic_nucleotide_accession_version='NC_000020.11', start_position_on_the_genomic_accession=46118242, end_position_on_the_genomic_accession=46129858, orientation='plus', exon_count=9, OMIM=[109535], no_hdr0=''),
    959 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=959, CurrentID=0, Status='live', Symbol='CD40LG', Aliases=['CD154', 'CD40L', 'HIGM1', 'IGM', 'IMD3', 'T-BAM', 'TNFSF5', 'TRAP', 'gp39', 'hCD40L'], description='CD40 ligand', other_designations='CD40 ligand|CD40 antigen ligand|CD40-L|T-B cell-activating molecule|T-cell antigen Gp39|TNF-related activation protein|tumor necrosis factor (ligand) superfamily member 5', map_location='Xq26.3', chromosome='X', genomic_nucleotide_accession_version='NC_000023.11', start_position_on_the_genomic_accession=136648158, end_position_on_the_genomic_accession=136660390, orientation='plus', exon_count=5, OMIM=[300386], no_hdr0=''),
    960 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=960, CurrentID=0, Status='live', Symbol='CD44', Aliases=['CDW44', 'CSPG8', 'ECMR-III', 'HCELL', 'HUTCH-I', 'IN', 'LHR', 'MC56', 'MDU2', 'MDU3', 'MIC4', 'Pgp1'], description='CD44 molecule (Indian blood group)', other_designations='CD44 antigen|GP90 lymphocyte homing/adhesion receptor|Hermes antigen|Indian blood group antigen|cell surface glycoprotein CD44|chondroitin sulfate proteoglycan 8|epican|extracellular matrix receptor III|hematopoietic cell E- and L-selectin ligand|heparan sulfate proteoglycan|homing function and Indian blood group system|hyaluronate receptor|phagocytic glycoprotein 1|soluble CD44', map_location='11p13', chromosome='11', genomic_nucleotide_accession_version='NC_000011.10', start_position_on_the_genomic_accession=35139168, end_position_on_the_genomic_accession=35232402, orientation='plus', exon_count=21, OMIM=[107269], no_hdr0=''),
    961 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=961, CurrentID=0, Status='live', Symbol='CD47', Aliases=['IAP', 'MER6', 'OA3'], description='CD47 molecule', other_designations='leukocyte surface antigen CD47|CD47 antigen (Rh-related antigen, integrin-associated signal transducer)|CD47 glycoprotein|Rh-related antigen|antigen identified by monoclonal antibody 1D8|antigenic surface determinant protein OA3|integrin associated protein|integrin-associated signal transducer', map_location='3q13.12', chromosome='3', genomic_nucleotide_accession_version='NC_000003.12', start_position_on_the_genomic_accession=108043091, end_position_on_the_genomic_accession=108094200, orientation='minus', exon_count=14, OMIM=[601028], no_hdr0=''),
    962 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=962, CurrentID=0, Status='live', Symbol='CD48', Aliases=['BCM1', 'BLAST', 'BLAST1', 'MEM-102', 'SLAMF2', 'hCD48', 'mCD48'], description='CD48 molecule', other_designations='CD48 antigen|B-lymphocyte activation marker BLAST-1|BCM1 surface antigen|CD48 antigen (B-cell membrane protein)|SLAM family member 2|TCT.1|leukocyte antigen MEM-102|signaling lymphocytic activation molecule 2', map_location='1q23.3', chromosome='1', genomic_nucleotide_accession_version='NC_000001.11', start_position_on_the_genomic_accession=160678746, end_position_on_the_genomic_accession=160711836, orientation='minus', exon_count=5, OMIM=[109530], no_hdr0=''),
    963 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=963, CurrentID=0, Status='live', Symbol='CD53', Aliases=['MOX44', 'TSPAN25'], description='CD53 molecule', other_designations='leukocyte surface antigen CD53|CD53 antigen|CD53 glycoprotein|CD53 tetraspan antigen|antigen MOX44 identified by monoclonal antibody MRC-OX44|cell surface antigen|cell surface glycoprotein CD53|tetraspanin-25|transmembrane glycoprotein|tspan-25', map_location='1p13.3', chromosome='1', genomic_nucleotide_accession_version='NC_000001.11', start_position_on_the_genomic_accession=110871167, end_position_on_the_genomic_accession=110899928, orientation='plus', exon_count=9, OMIM=[151525], no_hdr0=''),
    965 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=965, CurrentID=0, Status='live', Symbol='CD58', Aliases=['LFA-3', 'LFA3', 'ag3'], description='CD58 molecule', other_designations='lymphocyte function-associated antigen 3|CD58 antigen, (lymphocyte function-associated antigen 3)|surface glycoprotein LFA-3', map_location='1p13.1', chromosome='1', genomic_nucleotide_accession_version='NC_000001.11', start_position_on_the_genomic_accession=116500390, end_position_on_the_genomic_accession=116571037, orientation='minus', exon_count=7, OMIM=[153420], no_hdr0=''),
    966 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=966, CurrentID=0, Status='live', Symbol='CD59', Aliases=['16.3A5', '1F5', 'EJ16', 'EJ30', 'EL32', 'G344', 'HRF-20', 'HRF20', 'MAC-IP', 'MACIF', 'MEM43', 'MIC11', 'MIN1', 'MIN2', 'MIN3', 'MIRL', 'MSK21', 'p18-20'], description='CD59 molecule (CD59 blood group)', other_designations='CD59 glycoprotein|1F5 antigen|20 kDa homologous restriction factor|CD59 antigen p18-20 (antigen identified by monoclonal antibodies 16.3A5, EJ16, EJ30, EL32 and G344)|CD59 blood group antigen|CD59 molecule, complement regulatory protein|Ly-6-like protein|MEM43 antigen|T cell-activating protein|human leukocyte antigen MIC11|lymphocytic antigen CD59/MEM43|membrane attack complex (MAC) inhibition factor|membrane attack complex inhibition factor|membrane inhibitor of reactive lysis|protectin|surface anitgen recognized by monoclonal antibody 16.3A5', map_location='11p13', chromosome='11', genomic_nucleotide_accession_version='NC_000011.10', start_position_on_the_genomic_accession=33703010, end_position_on_the_genomic_accession=33736479, orientation='minus', exon_count=8, OMIM=[107271], no_hdr0=''),
    967 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=967, CurrentID=0, Status='live', Symbol='CD63', Aliases=['LAMP-3', 'ME491', 'MLA1', 'OMA81H', 'TSPAN30'], description='CD63 molecule', other_designations='CD63 antigen|CD63 antigen (melanoma 1 antigen)|granulophysin|lysosomal-associated membrane protein 3|lysosome-associated membrane glycoprotein 3|melanoma-associated antigen ME491|melanoma-associated antigen MLA1|ocular melanoma-associated antigen|tetraspanin-30|tspan-30', map_location='12q13.2', chromosome='12', genomic_nucleotide_accession_version='NC_000012.12', start_position_on_the_genomic_accession=55725323, end_position_on_the_genomic_accession=55729673, orientation='minus', exon_count=12, OMIM=[155740], no_hdr0=''),
    968 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=968, CurrentID=0, Status='live', Symbol='CD68', Aliases=['GP110', 'LAMP4', 'SCARD1'], description='CD68 molecule', other_designations='macrosialin|CD68 antigen|macrophage antigen CD68|scavenger receptor class D, member 1', map_location='17p13.1', chromosome='17', genomic_nucleotide_accession_version='NC_000017.11', start_position_on_the_genomic_accession=7579638, end_position_on_the_genomic_accession=7582111, orientation='plus', exon_count=6, OMIM=[153634], no_hdr0=''),
    969 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=969, CurrentID=0, Status='live', Symbol='CD69', Aliases=['AIM', 'BL-AC/P26', 'CLEC2C', 'EA1', 'GP32/28', 'MLR-3'], description='CD69 molecule', other_designations='early activation antigen CD69|C-type lectin domain family 2, member C|CD69 antigen (p60, early T-cell activation antigen)|activation inducer molecule (AIM/CD69)|early T-cell activation antigen p60|early lymphocyte activation antigen|leukocyte surface antigen Leu-23', map_location='12p13.31', chromosome='12', genomic_nucleotide_accession_version='NC_000012.12', start_position_on_the_genomic_accession=9752486, end_position_on_the_genomic_accession=9760901, orientation='minus', exon_count=5, OMIM=[107273], no_hdr0=''),
    970 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=970, CurrentID=0, Status='live', Symbol='CD70', Aliases=['CD27-L', 'CD27L', 'CD27LG', 'LPFS3', 'TNFSF7', 'TNLG8A'], description='CD70 molecule', other_designations='CD70 antigen|CD27 ligand|Ki-24 antigen|surface antigen CD70|tumor necrosis factor ligand 8A|tumor necrosis factor ligand superfamily member 7', map_location='19p13.3', chromosome='19', genomic_nucleotide_accession_version='NC_000019.10', start_position_on_the_genomic_accession=6581648, end_position_on_the_genomic_accession=6591150, orientation='minus', exon_count=4, OMIM=[602840], no_hdr0=''),
    971 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=971, CurrentID=0, Status='live', Symbol='CD72', Aliases=['CD72b', 'LYB2'], description='CD72 molecule', other_designations='B-cell differentiation antigen CD72|CD72 antigen|lyb-2', map_location='9p13.3', chromosome='9', genomic_nucleotide_accession_version='NC_000009.12', start_position_on_the_genomic_accession=35609981, end_position_on_the_genomic_accession=35618427, orientation='minus', exon_count=9, OMIM=[107272], no_hdr0=''),
    972 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=972, CurrentID=0, Status='live', Symbol='CD74', Aliases=['DHLAG', 'HLADG', 'II', 'Ia-GAMMA', 'p33'], description='CD74 molecule', other_designations='HLA class II histocompatibility antigen gamma chain|CD74 antigen (invariant polypeptide of major histocompatibility complex, class II antigen-associated)|CD74 molecule, major histocompatibility complex, class II invariant chain|HLA-DR antigens-associated invariant chain|HLA-DR-gamma|Ia-associated invariant chain|MHC HLA-DR gamma chain|gamma chain of class II antigens', map_location='5q33.1', chromosome='5', genomic_nucleotide_accession_version='NC_000005.10', start_position_on_the_genomic_accession=150400041, end_position_on_the_genomic_accession=150412936, orientation='minus', exon_count=9, OMIM=[142790], no_hdr0=''),
    973 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=973, CurrentID=0, Status='live', Symbol='CD79A', Aliases=['IGA', 'MB-1'], description='CD79a molecule', other_designations='B-cell antigen receptor complex-associated protein alpha chain|CD79a antigen (immunoglobulin-associated alpha)|CD79a molecule, immunoglobulin-associated alpha|MB-1 membrane glycoprotein|ig-alpha|membrane-bound immunoglobulin-associated protein|surface IgM-associated protein', map_location='19q13.2', chromosome='19', genomic_nucleotide_accession_version='NC_000019.10', start_position_on_the_genomic_accession=41877279, end_position_on_the_genomic_accession=41881372, orientation='plus', exon_count=5, OMIM=[112205], no_hdr0=''),
    974 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=974, CurrentID=0, Status='live', Symbol='CD79B', Aliases=['AGM6', 'B29', 'IGB'], description='CD79b molecule', other_designations='B-cell antigen receptor complex-associated protein beta chain|B-cell-specific glycoprotein B29|CD79b antigen (immunoglobulin-associated beta)|CD79b molecule, immunoglobulin-associated beta|Ig-beta|immunoglobulin-associated B29 protein', map_location='17q23.3', chromosome='17', genomic_nucleotide_accession_version='NC_000017.11', start_position_on_the_genomic_accession=63928740, end_position_on_the_genomic_accession=63932331, orientation='minus', exon_count=6, OMIM=[147245], no_hdr0=''),
    975 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=975, CurrentID=0, Status='live', Symbol='CD81', Aliases=['CVID6', 'S5.7', 'TAPA1', 'TSPAN28'], description='CD81 molecule', other_designations='CD81 antigen|26 kDa cell surface protein TAPA-1|CD81 antigen (target of antiproliferative antibody 1)|tetraspanin-28|tspan-28', map_location='11p15.5', chromosome='11', genomic_nucleotide_accession_version='NC_000011.10', start_position_on_the_genomic_accession=2376180, end_position_on_the_genomic_accession=2397402, orientation='plus', exon_count=10, OMIM=[186845], no_hdr0=''),
    976 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=976, CurrentID=0, Status='live', Symbol='ADGRE5', Aliases=['CD97', 'TM7LN1'], description='adhesion G protein-coupled receptor E5', other_designations='adhesion G protein-coupled receptor E5|CD97 molecule|leukocyte antigen CD97|seven transmembrane helix receptor|seven-span transmembrane protein|seven-transmembrane, heterodimeric receptor associated with inflammation', map_location='19p13.12', chromosome='19', genomic_nucleotide_accession_version='NC_000019.10', start_position_on_the_genomic_accession=14381144, end_position_on_the_genomic_accession=14408725, orientation='plus', exon_count=20, OMIM=[601211], no_hdr0=''),
    977 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=977, CurrentID=0, Status='live', Symbol='CD151', Aliases=['GP27', 'MER2', 'PETA-3', 'RAPH', 'SFA1', 'TSPAN24'], description='CD151 molecule (Raph blood group)', other_designations='CD151 antigen|CD151 antigen (Raph blood group)|hemidesmosomal tetraspanin CD151|membrane glycoprotein SFA-1|platelet surface glycoprotein gp27|platelet-endothelial cell tetraspan antigen 3|platelet-endothelial tetraspan antigen 3|tetraspanin-24|tspan-24', map_location='11p15.5', chromosome='11', genomic_nucleotide_accession_version='NC_000011.10', start_position_on_the_genomic_accession=832952, end_position_on_the_genomic_accession=838835, orientation='plus', exon_count=10, OMIM=[602243], no_hdr0=''),
    978 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=978, CurrentID=0, Status='live', Symbol='CDA', Aliases=['CDD'], description='cytidine deaminase', other_designations='cytidine deaminase|cytidine aminohydrolase|cytosine nucleoside deaminase|small cytidine deaminase', map_location='1p36.12', chromosome='1', genomic_nucleotide_accession_version='NC_000001.11', start_position_on_the_genomic_accession=20589097, end_position_on_the_genomic_accession=20618903, orientation='plus', exon_count=4, OMIM=[123920], no_hdr0=''),
    983 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=983, CurrentID=0, Status='live', Symbol='CDK1', Aliases=['CDC2', 'CDC28A', 'P34CDC2'], description='cyclin dependent kinase 1', other_designations='cyclin-dependent kinase 1|cell cycle controller CDC2|cell division control protein 2 homolog|cell division cycle 2, G1 to S and G2 to M|cell division protein kinase 1|p34 protein kinase', map_location='10q21.2', chromosome='10', genomic_nucleotide_accession_version='NC_000010.11', start_position_on_the_genomic_accession=60778331, end_position_on_the_genomic_accession=60794852, orientation='plus', exon_count=9, OMIM=[116940], no_hdr0=''),
    984 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=984, CurrentID=0, Status='live', Symbol='CDK11B', Aliases=['CDC2L1', 'CDK11', 'CDK11-p110', 'CDK11-p46', 'CDK11-p58', 'CLK-1', 'PITSLREA', 'PK58', 'p58', 'p58CDC2L1', 'p58CLK-1'], description='cyclin dependent kinase 11B', other_designations='cyclin-dependent kinase 11B|CDC-related protein kinase p58|PITSLRE serine/threonine-protein kinase CDC2L1|cell division cycle 2-like 1 (PITSLRE proteins)|cell division protein kinase 11B|galactosyltransferase-associated protein kinase p58/GTA|p58 CLK-1', map_location='1p36.33', chromosome='1', genomic_nucleotide_accession_version='NC_000001.11', start_position_on_the_genomic_accession=1635225, end_position_on_the_genomic_accession=1659619, orientation='minus', exon_count=22, OMIM=[176873], no_hdr0=''),
    987 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=987, CurrentID=0, Status='live', Symbol='LRBA', Aliases=['BGL', 'CDC4L', 'CVID8', 'LAB300', 'LBA'], description='LPS responsive beige-like anchor protein', other_designations='lipopolysaccharide-responsive and beige-like anchor protein|CDC4-like protein|LPS-responsive vesicle trafficking, beach and anchor containing|vesicle trafficking, beach and anchor containing', map_location='4q31.3', chromosome='4', genomic_nucleotide_accession_version='NC_000004.12', start_position_on_the_genomic_accession=150264435, end_position_on_the_genomic_accession=151015727, orientation='minus', exon_count=61, OMIM=[606453], no_hdr0=''),
    988 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=988, CurrentID=0, Status='live', Symbol='CDC5L', Aliases=['CDC5', 'CDC5-LIKE', 'CEF1', 'PCDC5RP', 'dJ319D22.1'], description='cell division cycle 5 like', other_designations='cell division cycle 5-like protein|CDC5 cell division cycle 5-like|Cdc5-related protein|dJ319D22.1 (CDC5-like protein)|pombe cdc5-related protein', map_location='6p21.1', chromosome='6', genomic_nucleotide_accession_version='NC_000006.12', start_position_on_the_genomic_accession=44387706, end_position_on_the_genomic_accession=44450425, orientation='plus', exon_count=16, OMIM=[602868], no_hdr0=''),
    989 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=989, CurrentID=0, Status='live', Symbol='SEPTIN7', Aliases=['CDC10', 'CDC3', 'NBLA02942', 'SEPT7', 'SEPT7A'], description='septin 7', other_designations='septin-7|CDC10 (cell division cycle 10, S. cerevisiae, homolog)|CDC10 protein homolog|septin 7 variant 4', map_location='7p14.2', chromosome='7', genomic_nucleotide_accession_version='NC_000007.14', start_position_on_the_genomic_accession=35800986, end_position_on_the_genomic_accession=35915763, orientation='plus', exon_count=19, OMIM=[603151], no_hdr0=''),
    990 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=990, CurrentID=0, Status='live', Symbol='CDC6', Aliases=['CDC18L', 'HsCDC18', 'HsCDC6', 'MGORS5'], description='cell division cycle 6', other_designations='cell division control protein 6 homolog|CDC6 cell division cycle 6 homolog|CDC6-related protein|cdc18-related protein|cell division cycle 6 homolog|p62(cdc6)', map_location='17q21.2', chromosome='17', genomic_nucleotide_accession_version='NC_000017.11', start_position_on_the_genomic_accession=40287878, end_position_on_the_genomic_accession=40304657, orientation='plus', exon_count=13, OMIM=[602627], no_hdr0=''),
    991 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=991, CurrentID=0, Status='live', Symbol='CDC20', Aliases=['CDC20A', 'bA276H19.3', 'p55CDC'], description='cell division cycle 20', other_designations='cell division cycle protein 20 homolog|CDC20 cell division cycle 20 homolog|cell division cycle 20 homolog', map_location='1p34.2', chromosome='1', genomic_nucleotide_accession_version='NC_000001.11', start_position_on_the_genomic_accession=43358981, end_position_on_the_genomic_accession=43363203, orientation='plus', exon_count=11, OMIM=[603618], no_hdr0=''),
    993 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=993, CurrentID=0, Status='live', Symbol='CDC25A', Aliases=['CDC25A2'], description='cell division cycle 25A', other_designations='M-phase inducer phosphatase 1|dual specificity phosphatase CDC25A', map_location='3p21.31', chromosome='3', genomic_nucleotide_accession_version='NC_000003.12', start_position_on_the_genomic_accession=48157146, end_position_on_the_genomic_accession=48188417, orientation='minus', exon_count=15, OMIM=[116947], no_hdr0=''),
    994 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=994, CurrentID=0, Status='live', Symbol='CDC25B', Aliases=[], description='cell division cycle 25B', other_designations='M-phase inducer phosphatase 2|dual specificity phosphatase Cdc25B', map_location='20p13', chromosome='20', genomic_nucleotide_accession_version='NC_000020.11', start_position_on_the_genomic_accession=3786951, end_position_on_the_genomic_accession=3806118, orientation='plus', exon_count=19, OMIM=[116949], no_hdr0=''),
    995 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=995, CurrentID=0, Status='live', Symbol='CDC25C', Aliases=['CDC25', 'PPP1R60'], description='cell division cycle 25C', other_designations='M-phase inducer phosphatase 3|dual specificity phosphatase CDC25C|mitosis inducer CDC25|phosphotyrosine phosphatase|protein phosphatase 1, regulatory subunit 60', map_location='5q31.2', chromosome='5', genomic_nucleotide_accession_version='NC_000005.10', start_position_on_the_genomic_accession=138285265, end_position_on_the_genomic_accession=138338355, orientation='minus', exon_count=15, OMIM=[157680], no_hdr0=''),
    996 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=996, CurrentID=0, Status='live', Symbol='CDC27', Aliases=['ANAPC3', 'APC3Hs', 'D0S1430E', 'D17S978E', 'H-NUC', 'HNUC', 'NUC2', 'CDC27'], description='cell division cycle 27', other_designations='cell division cycle protein 27 homolog|D0S1430E, D17S978E|anaphase promoting complex subunit 3|anaphase-promoting complex, protein 3|cell division cycle 27 homolog|nuc2 homolog', map_location='17q21.32', chromosome='17', genomic_nucleotide_accession_version='NC_000017.11', start_position_on_the_genomic_accession=47117703, end_position_on_the_genomic_accession=47189295, orientation='minus', exon_count=20, OMIM=[116946], no_hdr0=''),
    997 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=997, CurrentID=0, Status='live', Symbol='CDC34', Aliases=['E2-CDC34', 'UBC3', 'UBCH3', 'UBE2R1'], description='cell division cycle 34, ubiqiutin conjugating enzyme', other_designations='ubiquitin-conjugating enzyme E2 R1|(E3-independent) E2 ubiquitin-conjugating enzyme R1|E2 ubiquitin-conjugating enzyme R1|cell division cycle 34 homolog|ubiquitin carrier protein|ubiquitin-conjugating enzyme E2-32 KDA complementing|ubiquitin-conjugating enzyme E2-CDC34|ubiquitin-protein ligase R1', map_location='19p13.3', chromosome='19', genomic_nucleotide_accession_version='NC_000019.10', start_position_on_the_genomic_accession=531720, end_position_on_the_genomic_accession=542088, orientation='plus', exon_count=6, OMIM=[116948], no_hdr0=''),
    998 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=998, CurrentID=0, Status='live', Symbol='CDC42', Aliases=['CDC42Hs', 'G25K', 'TKS'], description='cell division cycle 42', other_designations='cell division control protein 42 homolog|G25K GTP-binding protein|GTP binding protein, 25kDa|dJ224A6.1.1 (cell division cycle 42 (GTP-binding protein, 25kD))|dJ224A6.1.2 (cell division cycle 42 (GTP-binding protein, 25kD))|growth-regulating protein|small GTP binding protein CDC42', map_location='1p36.12', chromosome='1', genomic_nucleotide_accession_version='NC_000001.11', start_position_on_the_genomic_accession=22052709, end_position_on_the_genomic_accession=22101360, orientation='plus', exon_count=8, OMIM=[116952], no_hdr0=''),
    999 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=999, CurrentID=0, Status='live', Symbol='CDH1', Aliases=['Arc-1', 'BCDS1', 'CD324', 'CDHE', 'ECAD', 'LCAM', 'UVO'], description='cadherin 1', other_designations='cadherin-1|CAM 120/80|E-cadherin 1|cadherin 1, E-cadherin (epithelial)|cadherin 1, type 1, E-cadherin (epithelial)|calcium-dependent adhesion protein, epithelial|cell-CAM 120/80|epididymis secretory sperm binding protein|epithelial cadherin|uvomorulin', map_location='16q22.1', chromosome='16', genomic_nucleotide_accession_version='NC_000016.10', start_position_on_the_genomic_accession=68737292, end_position_on_the_genomic_accession=68835537, orientation='plus', exon_count=16, OMIM=[192090], no_hdr0=''),
    1000 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1000, CurrentID=0, Status='live', Symbol='CDH2', Aliases=['ACOGS', 'ARVD14', 'CD325', 'CDHN', 'CDw325', 'NCAD'], description='cadherin 2', other_designations='cadherin-2|N-cadherin 1|cadherin 2, type 1, N-cadherin (neuronal)|calcium-dependent adhesion protein, neuronal|neural cadherin', map_location='18q12.1', chromosome='18', genomic_nucleotide_accession_version='NC_000018.10', start_position_on_the_genomic_accession=27932878, end_position_on_the_genomic_accession=28177130, orientation='minus', exon_count=19, OMIM=[114020], no_hdr0=''),
    1001 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1001, CurrentID=0, Status='live', Symbol='CDH3', Aliases=['CDHP', 'HJMD', 'PCAD'], description='cadherin 3', other_designations='cadherin-3|cadherin 3, type 1, P-cadherin (placental)|calcium-dependent adhesion protein, placental', map_location='16q22.1', chromosome='16', genomic_nucleotide_accession_version='NC_000016.10', start_position_on_the_genomic_accession=68644914, end_position_on_the_genomic_accession=68727573, orientation='plus', exon_count=18, OMIM=[114021], no_hdr0=''),
    1002 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1002, CurrentID=0, Status='live', Symbol='CDH4', Aliases=['CAD4', 'R-CAD', 'RCAD'], description='cadherin 4', other_designations='cadherin-4|R-cadherin|cadherin 4, type 1, R-cadherin (retinal)|cadherin 4, type 1, preproprotein|retinal cadherin', map_location='20q13.33', chromosome='20', genomic_nucleotide_accession_version='NC_000020.11', start_position_on_the_genomic_accession=61252261, end_position_on_the_genomic_accession=61940617, orientation='plus', exon_count=18, OMIM=[603006], no_hdr0=''),
    1003 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1003, CurrentID=0, Status='live', Symbol='CDH5', Aliases=['7B4', 'CD144'], description='cadherin 5', other_designations='cadherin-5|7B4 antigen|VE-cadherin|cadherin 5, type 2 (vascular endothelium)|cadherin 5, type 2, VE-cadherin (vascular epithelium)|cd144 antigen|endothelial-specific cadherin|vascular endothelial cadherin', map_location='16q21', chromosome='16', genomic_nucleotide_accession_version='NC_000016.10', start_position_on_the_genomic_accession=66366657, end_position_on_the_genomic_accession=66404784, orientation='plus', exon_count=12, OMIM=[601120], no_hdr0=''),
    1004 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1004, CurrentID=0, Status='live', Symbol='CDH6', Aliases=['CAD6', 'KCAD'], description='cadherin 6', other_designations='cadherin-6|cadherin 6, type 2, K-cadherin (fetal kidney)', map_location='5p13.3', chromosome='5', genomic_nucleotide_accession_version='NC_000005.10', start_position_on_the_genomic_accession=31193686, end_position_on_the_genomic_accession=31329146, orientation='plus', exon_count=14, OMIM=[603007], no_hdr0=''),
    1005 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1005, CurrentID=0, Status='live', Symbol='CDH7', Aliases=['CDH7L1'], description='cadherin 7', other_designations='cadherin-7|cadherin 7, type 2', map_location='18q22.1', chromosome='18', genomic_nucleotide_accession_version='NC_000018.10', start_position_on_the_genomic_accession=65750252, end_position_on_the_genomic_accession=65890337, orientation='plus', exon_count=13, OMIM=[605806], no_hdr0=''),
    1006 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1006, CurrentID=0, Status='live', Symbol='CDH8', Aliases=['Nbla04261'], description='cadherin 8', other_designations='cadherin-8|cadherin 8, type 2', map_location='16q21', chromosome='16', genomic_nucleotide_accession_version='NC_000016.10', start_position_on_the_genomic_accession=61640398, end_position_on_the_genomic_accession=62036446, orientation='minus', exon_count=14, OMIM=[603008], no_hdr0=''),
    1007 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1007, CurrentID=0, Status='live', Symbol='CDH9', Aliases=[], description='cadherin 9', other_designations='cadherin-9|T1-cadherin', map_location='5p14.1', chromosome='5', genomic_nucleotide_accession_version='NC_000005.10', start_position_on_the_genomic_accession=26880597, end_position_on_the_genomic_accession=27038586, orientation='minus', exon_count=12, OMIM=[609974], no_hdr0=''),
    1008 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1008, CurrentID=0, Status='live', Symbol='CDH10', Aliases=[], description='cadherin 10', other_designations='cadherin-10|T2-cadherin|cadherin 10 type 2', map_location='5p14.2-p14.1', chromosome='5', genomic_nucleotide_accession_version='NC_000005.10', start_position_on_the_genomic_accession=24487100, end_position_on_the_genomic_accession=24644978, orientation='minus', exon_count=13, OMIM=[604555], no_hdr0=''),
    1009 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1009, CurrentID=0, Status='live', Symbol='CDH11', Aliases=['CAD11', 'CDHOB', 'ESWS', 'OB', 'OSF-4'], description='cadherin 11', other_designations='cadherin-11|cadherin 11, type 2, OB-cadherin (osteoblast)', map_location='16q21', chromosome='16', genomic_nucleotide_accession_version='NC_000016.10', start_position_on_the_genomic_accession=64943753, end_position_on_the_genomic_accession=65126112, orientation='minus', exon_count=18, OMIM=[600023], no_hdr0=''),
    1010 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1010, CurrentID=0, Status='live', Symbol='CDH12', Aliases=['CDHB'], description='cadherin 12', other_designations='cadherin-12|Br-cadherin|N-cadherin 2|brain-cadherin|cadherin, neural type, 2|neural type cadherin 2|neuronal cadherin 2', map_location='5p14.3', chromosome='5', genomic_nucleotide_accession_version='NC_000005.10', start_position_on_the_genomic_accession=21750673, end_position_on_the_genomic_accession=22853344, orientation='minus', exon_count=18, OMIM=[600562], no_hdr0=''),
    1012 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1012, CurrentID=0, Status='live', Symbol='CDH13', Aliases=['CDHH', 'P105'], description='cadherin 13', other_designations='cadherin-13|H-cadherin (heart)|T-cad|T-cadherin|cadherin 13, H-cadherin (heart)|heart cadherin', map_location='16q23.3', chromosome='16', genomic_nucleotide_accession_version='NC_000016.10', start_position_on_the_genomic_accession=82626823, end_position_on_the_genomic_accession=83800640, orientation='plus', exon_count=20, OMIM=[601364], no_hdr0=''),
    1013 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1013, CurrentID=0, Status='live', Symbol='CDH15', Aliases=['CDH14', 'CDH3', 'CDHM', 'MCAD', 'MRD3'], description='cadherin 15', other_designations='cadherin-15|cadherin 15, type 1, M-cadherin (myotubule)|cadherin-14|cadherin-3|muscle-cadherin', map_location='16q24.3', chromosome='16', genomic_nucleotide_accession_version='NC_000016.10', start_position_on_the_genomic_accession=89171748, end_position_on_the_genomic_accession=89195492, orientation='plus', exon_count=14, OMIM=[114019], no_hdr0=''),
    1014 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1014, CurrentID=0, Status='live', Symbol='CDH16', Aliases=[], description='cadherin 16', other_designations='cadherin-16|KSP-cadherin|cadherin 16, KSP-cadherin|kidney-specific cadherin', map_location='16q22.1', chromosome='16', genomic_nucleotide_accession_version='NC_000016.10', start_position_on_the_genomic_accession=66908122, end_position_on_the_genomic_accession=66918885, orientation='minus', exon_count=18, OMIM=[603118], no_hdr0=''),
    1015 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1015, CurrentID=0, Status='live', Symbol='CDH17', Aliases=['CDH16', 'HPT-1', 'HPT1'], description='cadherin 17', other_designations='cadherin-17|HPT-1 cadherin|LI cadherin|cadherin 17, LI cadherin (liver-intestine)|cadherin-16|human intestinal peptide-associated transporter HPT-1|human peptide transporter 1|intestinal peptide-associated transporter HPT-1|liver-intestine cadherin', map_location='8q22.1', chromosome='8', genomic_nucleotide_accession_version='NC_000008.11', start_position_on_the_genomic_accession=94127162, end_position_on_the_genomic_accession=94217278, orientation='minus', exon_count=19, OMIM=[603017], no_hdr0=''),
    1016 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1016, CurrentID=0, Status='live', Symbol='CDH18', Aliases=['CDH14', 'CDH14L', 'CDH24'], description='cadherin 18', other_designations='cadherin-18|cadherin 18, type 2|cadherin-14|cadherin-like 24|ey-cadherin', map_location='5p14.3', chromosome='5', genomic_nucleotide_accession_version='NC_000005.10', start_position_on_the_genomic_accession=19471296, end_position_on_the_genomic_accession=20575886, orientation='minus', exon_count=25, OMIM=[603019], no_hdr0=''),
    1017 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1017, CurrentID=0, Status='live', Symbol='CDK2', Aliases=['CDKN2', 'p33(CDK2)'], description='cyclin dependent kinase 2', other_designations='cyclin-dependent kinase 2|cdc2-related protein kinase|cell division protein kinase 2|p33 protein kinase', map_location='12q13.2', chromosome='12', genomic_nucleotide_accession_version='NC_000012.12', start_position_on_the_genomic_accession=55966830, end_position_on_the_genomic_accession=55972789, orientation='plus', exon_count=8, OMIM=[116953], no_hdr0=''),
    1018 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1018, CurrentID=0, Status='live', Symbol='CDK3', Aliases=[], description='cyclin dependent kinase 3', other_designations='cyclin-dependent kinase 3|cell division protein kinase 3', map_location='17q25.1', chromosome='17', genomic_nucleotide_accession_version='NC_000017.11', start_position_on_the_genomic_accession=76000906, end_position_on_the_genomic_accession=76005998, orientation='plus', exon_count=8, OMIM=[123828], no_hdr0=''),
    1019 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1019, CurrentID=0, Status='live', Symbol='CDK4', Aliases=['CMM3', 'PSK-J3'], description='cyclin dependent kinase 4', other_designations='cyclin-dependent kinase 4|cell division protein kinase 4', map_location='12q14.1', chromosome='12', genomic_nucleotide_accession_version='NC_000012.12', start_position_on_the_genomic_accession=57747727, end_position_on_the_genomic_accession=57752310, orientation='minus', exon_count=8, OMIM=[123829], no_hdr0=''),
    1020 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1020, CurrentID=0, Status='live', Symbol='CDK5', Aliases=['LIS7', 'PSSALRE'], description='cyclin dependent kinase 5', other_designations='cyclin-dependent-like kinase 5|TPKII catalytic subunit|cell division protein kinase 5|epididymis secretory sperm binding protein|protein kinase CDK5 splicing|serine/threonine-protein kinase PSSALRE|tau protein kinase II catalytic subunit', map_location='7q36.1', chromosome='7', genomic_nucleotide_accession_version='NC_000007.14', start_position_on_the_genomic_accession=151053815, end_position_on_the_genomic_accession=151057897, orientation='minus', exon_count=12, OMIM=[123831], no_hdr0=''),
    1021 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1021, CurrentID=0, Status='live', Symbol='CDK6', Aliases=['MCPH12', 'PLSTIRE'], description='cyclin dependent kinase 6', other_designations='cyclin-dependent kinase 6|cell division protein kinase 6|serine/threonine-protein kinase PLSTIRE', map_location='7q21.2', chromosome='7', genomic_nucleotide_accession_version='NC_000007.14', start_position_on_the_genomic_accession=92604921, end_position_on_the_genomic_accession=92836573, orientation='minus', exon_count=10, OMIM=[603368], no_hdr0=''),
    1022 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1022, CurrentID=0, Status='live', Symbol='CDK7', Aliases=['CAK', 'CAK1', 'CDKN7', 'HCAK', 'MO15', 'STK1', 'p39MO15'], description='cyclin dependent kinase 7', other_designations='cyclin-dependent kinase 7|39 KDa protein kinase|CDK-activating kinase 1|TFIIH basal transcription factor complex kinase subunit|cell division protein kinase 7|cyclin-dependent kinase 7 (MO15 homolog, Xenopus laevis, cdk-activating kinase)|homolog of Xenopus MO15 Cdk-activating kinase|kinase subunit of CAK|serine/threonine kinase stk1|serine/threonine protein kinase 1|serine/threonine protein kinase MO15', map_location='5q13.2', chromosome='5', genomic_nucleotide_accession_version='NC_000005.10', start_position_on_the_genomic_accession=69234795, end_position_on_the_genomic_accession=69277430, orientation='plus', exon_count=13, OMIM=[601955], no_hdr0=''),
    1024 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1024, CurrentID=0, Status='live', Symbol='CDK8', Aliases=['IDDHBA', 'K35'], description='cyclin dependent kinase 8', other_designations='cyclin-dependent kinase 8|CDK8 protein kinase|cell division protein kinase 8|mediator complex subunit CDK8|mediator of RNA polymerase II transcription subunit CDK8|protein kinase K35', map_location='13q12.13', chromosome='13', genomic_nucleotide_accession_version='NC_000013.11', start_position_on_the_genomic_accession=26254125, end_position_on_the_genomic_accession=26405238, orientation='plus', exon_count=14, OMIM=[603184], no_hdr0=''),
    1025 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1025, CurrentID=0, Status='live', Symbol='CDK9', Aliases=['C-2k', 'CDC2L4', 'CTK1', 'PITALRE', 'TAK'], description='cyclin dependent kinase 9', other_designations='cyclin-dependent kinase 9|CDC2-related kinase|cell division cycle 2-like protein kinase 4|cell division protein kinase 9|serine/threonine protein kinase PITALRE|tat-associated kinase complex catalytic subunit', map_location='9q34.11', chromosome='9', genomic_nucleotide_accession_version='NC_000009.12', start_position_on_the_genomic_accession=127786034, end_position_on_the_genomic_accession=127790792, orientation='plus', exon_count=7, OMIM=[603251], no_hdr0=''),
    1026 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1026, CurrentID=0, Status='live', Symbol='CDKN1A', Aliases=['CAP20', 'CDKN1', 'CIP1', 'MDA-6', 'P21', 'SDI1', 'WAF1', 'p21CIP1'], description='cyclin dependent kinase inhibitor 1A', other_designations='cyclin-dependent kinase inhibitor 1|CDK-interacting protein 1|CDK-interaction protein 1|DNA synthesis inhibitor|cyclin-dependent kinase inhibitor 1A (p21, Cip1)|melanoma differentiation associated protein 6|wild-type p53-activated fragment 1', map_location='6p21.2', chromosome='6', genomic_nucleotide_accession_version='NC_000006.12', start_position_on_the_genomic_accession=36676463, end_position_on_the_genomic_accession=36687332, orientation='plus', exon_count=6, OMIM=[116899], no_hdr0=''),
    1027 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1027, CurrentID=0, Status='live', Symbol='CDKN1B', Aliases=['CDKN4', 'KIP1', 'MEN1B', 'MEN4', 'P27KIP1'], description='cyclin dependent kinase inhibitor 1B', other_designations='cyclin-dependent kinase inhibitor 1B|cyclin-dependent kinase inhibitor 1B (p27, Kip1)', map_location='12p13.1', chromosome='12', genomic_nucleotide_accession_version='NC_000012.12', start_position_on_the_genomic_accession=12717368, end_position_on_the_genomic_accession=12722369, orientation='plus', exon_count=3, OMIM=[600778], no_hdr0=''),
    1028 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1028, CurrentID=0, Status='live', Symbol='CDKN1C', Aliases=['BWCR', 'BWS', 'KIP2', 'WBS', 'p57', 'p57Kip2'], description='cyclin dependent kinase inhibitor 1C', other_designations='cyclin-dependent kinase inhibitor 1C|cyclin-dependent kinase inhibitor 1C (p57, Kip2)|cyclin-dependent kinase inhibitor p57', map_location='11p15.4', chromosome='11', genomic_nucleotide_accession_version='NC_000011.10', start_position_on_the_genomic_accession=2883218, end_position_on_the_genomic_accession=2885775, orientation='minus', exon_count=4, OMIM=[600856], no_hdr0=''),
    1029 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1029, CurrentID=0, Status='live', Symbol='CDKN2A', Aliases=['ARF', 'CDK4I', 'CDKN2', 'CMM2', 'INK4', 'INK4A', 'MLM', 'MTS-1', 'MTS1', 'P14', 'P14ARF', 'P16', 'P16-INK4A', 'P16INK4', 'P16INK4A', 'P19', 'P19ARF', 'TP16'], description='cyclin dependent kinase inhibitor 2A', other_designations='cyclin-dependent kinase inhibitor 2A|CDK4 inhibitor p16-INK4|alternative reading frame|cell cycle negative regulator beta|cyclin-dependent kinase 4 inhibitor A|cyclin-dependent kinase inhibitor 2A (melanoma, p16, inhibits CDK4)|multiple tumor suppressor 1', map_location='9p21.3', chromosome='9', genomic_nucleotide_accession_version='NC_000009.12', start_position_on_the_genomic_accession=21967752, end_position_on_the_genomic_accession=21995324, orientation='minus', exon_count=8, OMIM=[600160], no_hdr0=''),
    1030 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1030, CurrentID=0, Status='live', Symbol='CDKN2B', Aliases=['CDK4I', 'INK4B', 'MTS2', 'P15', 'TP15', 'p15INK4b'], description='cyclin dependent kinase inhibitor 2B', other_designations='cyclin-dependent kinase 4 inhibitor B|CDK inhibitory protein|CDK4B inhibitor|MTS-2|cyclin-dependent kinase inhibitor 2B (p15, inhibits CDK4)|cyclin-dependent kinases 4 and 6 binding protein|multiple tumor suppressor 2|p14-INK4b|p14_CDK inhibitor|p14_INK4B|p15 CDK inhibitor|p15-INK4b|p15_INK4B', map_location='9p21.3', chromosome='9', genomic_nucleotide_accession_version='NC_000009.12', start_position_on_the_genomic_accession=22002903, end_position_on_the_genomic_accession=22009313, orientation='minus', exon_count=2, OMIM=[600431], no_hdr0=''),
    1031 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1031, CurrentID=0, Status='live', Symbol='CDKN2C', Aliases=['INK4C', 'p18', 'p18-INK4C'], description='cyclin dependent kinase inhibitor 2C', other_designations='cyclin-dependent kinase 4 inhibitor C|CDK6 inhibitor p18|cyclin-dependent inhibitor|cyclin-dependent kinase 6 inhibitor p18|cyclin-dependent kinase inhibitor 2C (p18, inhibits CDK4)|p18-INK6', map_location='1p32.3', chromosome='1', genomic_nucleotide_accession_version='NC_000001.11', start_position_on_the_genomic_accession=50968706, end_position_on_the_genomic_accession=50974634, orientation='plus', exon_count=3, OMIM=[603369], no_hdr0=''),
    1032 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1032, CurrentID=0, Status='live', Symbol='CDKN2D', Aliases=['INK4D', 'p19', 'p19-INK4D'], description='cyclin dependent kinase inhibitor 2D', other_designations='cyclin-dependent kinase 4 inhibitor D|CDK inhibitor p19INK4d|cell cycle inhibitor, Nur77 associating protein|cyclin-dependent kinase 4 inhibitor D p19|cyclin-dependent kinase inhibitor 2D (p19, inhibits CDK4)|inhibitor of cyclin-dependent kinase 4d', map_location='19p13.2', chromosome='19', genomic_nucleotide_accession_version='NC_000019.10', start_position_on_the_genomic_accession=10566460, end_position_on_the_genomic_accession=10568979, orientation='minus', exon_count=2, OMIM=[600927], no_hdr0=''),
    1033 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1033, CurrentID=0, Status='live', Symbol='CDKN3', Aliases=['CDI1', 'CIP2', 'KAP', 'KAP1'], description='cyclin dependent kinase inhibitor 3', other_designations='cyclin-dependent kinase inhibitor 3|CDK2-associated dual specificity phosphatase|Cdk-associated protein phosphatase|cyclin-dependent kinase inhibitor|cyclin-dependent kinase interacting protein 2|cyclin-dependent kinase interactor 1|kinase-associated phosphatase', map_location='14q22.2', chromosome='14', genomic_nucleotide_accession_version='NC_000014.9', start_position_on_the_genomic_accession=54396873, end_position_on_the_genomic_accession=54420218, orientation='plus', exon_count=9, OMIM=[123832], no_hdr0=''),
    1036 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1036, CurrentID=0, Status='live', Symbol='CDO1', Aliases=['CDO-I'], description='cysteine dioxygenase type 1', other_designations='cysteine dioxygenase type 1|cysteine dioxygenase, type I', map_location='5q22.3', chromosome='5', genomic_nucleotide_accession_version='NC_000005.10', start_position_on_the_genomic_accession=115804733, end_position_on_the_genomic_accession=115816659, orientation='minus', exon_count=8, OMIM=[603943], no_hdr0=''),
    1038 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1038, CurrentID=0, Status='live', Symbol='CDR1', Aliases=['CDR', 'CDR34', 'CDR62A'], description='cerebellar degeneration related protein 1', other_designations='cerebellar degeneration-related antigen 1|cerebellar degeneration-related protein 1, 34kDa', map_location='Xq27.1', chromosome='X', genomic_nucleotide_accession_version='NC_000023.11', start_position_on_the_genomic_accession=140783260, end_position_on_the_genomic_accession=140784558, orientation='minus', exon_count=1, OMIM=[302650], no_hdr0=''),
    1039 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1039, CurrentID=0, Status='live', Symbol='CDR2', Aliases=['CDR62', 'Yo'], description='cerebellar degeneration related protein 2', other_designations='cerebellar degeneration-related protein 2|Yo paraneoplastic antigen|cerebellar degeneration-related protein 2, 62kDa|major Yo paraneoplastic antigen|paraneoplastic cerebellar degeneration-associated antigen', map_location='16p12.2', chromosome='16', genomic_nucleotide_accession_version='NC_000016.10', start_position_on_the_genomic_accession=22345936, end_position_on_the_genomic_accession=22374619, orientation='minus', exon_count=5, OMIM=[117340], no_hdr0=''),
    1040 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1040, CurrentID=0, Status='live', Symbol='CDS1', Aliases=['CDS 1'], description='CDP-diacylglycerol synthase 1', other_designations='phosphatidate cytidylyltransferase 1|CDP-DAG synthase 1|CDP-DG synthase 1|CDP-DG synthetase 1|CDP-diacylglycerol synthase (phosphatidate cytidylyltransferase) 1|CDP-diglyceride pyrophosphorylase 1|CDP-diglyceride synthase 1|CDP-diglyceride synthetase 1|CTP:phosphatidate cytidylyltransferase 1', map_location='4q21.23', chromosome='4', genomic_nucleotide_accession_version='NC_000004.12', start_position_on_the_genomic_accession=84582931, end_position_on_the_genomic_accession=84651334, orientation='plus', exon_count=13, OMIM=[603548], no_hdr0=''),
    1041 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1041, CurrentID=0, Status='live', Symbol='CDSN', Aliases=['HTSS', 'HTSS1', 'HYPT2', 'PSS', 'PSS1', 'S'], description='corneodesmosin', other_designations='corneodesmosin|differentiated keratinocyte S protein', map_location='6p21.33', chromosome='6', genomic_nucleotide_accession_version='NC_000006.12', start_position_on_the_genomic_accession=31115087, end_position_on_the_genomic_accession=31120446, orientation='minus', exon_count=2, OMIM=[602593], no_hdr0=''),
    1043 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1043, CurrentID=0, Status='live', Symbol='CD52', Aliases=['CDW52', 'EDDM5', 'HE5'], description='CD52 molecule', other_designations='CAMPATH-1 antigen|CD52 antigen (CAMPATH-1 antigen)|CDW52 antigen (CAMPATH-1 antigen)|HEL-S-171mP|cambridge pathology 1 antigen|epididymal secretory protein E5|epididymis secretory sperm binding protein Li 171mP|human epididymis-specific protein 5', map_location='1p36.11', chromosome='1', genomic_nucleotide_accession_version='NC_000001.11', start_position_on_the_genomic_accession=26317958, end_position_on_the_genomic_accession=26320523, orientation='plus', exon_count=2, OMIM=[114280], no_hdr0=''),
    1044 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1044, CurrentID=0, Status='live', Symbol='CDX1', Aliases=[], description='caudal type homeobox 1', other_designations='homeobox protein CDX-1|caudal type homeo box transcription factor 1|caudal type homeobox transcription factor 1|caudal-type homeobox protein 1|caudal-type homeobox protein CDX1', map_location='5q32', chromosome='5', genomic_nucleotide_accession_version='NC_000005.10', start_position_on_the_genomic_accession=150166778, end_position_on_the_genomic_accession=150184558, orientation='plus', exon_count=3, OMIM=[600746], no_hdr0=''),
    1045 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1045, CurrentID=0, Status='live', Symbol='CDX2', Aliases=['CDX-3/AS', 'CDX3', 'CDX2'], description='caudal type homeobox 2', other_designations='homeobox protein CDX-2|caudal type homeobox transcription factor 2|caudal-type homeobox protein 2|homeobox protein miniCDX2', map_location='13q12.2', chromosome='13', genomic_nucleotide_accession_version='NC_000013.11', start_position_on_the_genomic_accession=27960918, end_position_on_the_genomic_accession=27969337, orientation='minus', exon_count=4, OMIM=[600297], no_hdr0=''),
    1046 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1046, CurrentID=0, Status='live', Symbol='CDX4', Aliases=[], description='caudal type homeobox 4', other_designations='homeobox protein CDX-4|caudal type homeobox transcription factor 4|caudal-type homeobox protein 4', map_location='Xq13.2', chromosome='X', genomic_nucleotide_accession_version='NC_000023.11', start_position_on_the_genomic_accession=73447254, end_position_on_the_genomic_accession=73454585, orientation='plus', exon_count=3, OMIM=[300025], no_hdr0=''),
    1047 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1047, CurrentID=0, Status='live', Symbol='CLGN', Aliases=[], description='calmegin', other_designations='calmegin|testis tissue sperm-binding protein Li 79P', map_location='4q31.1', chromosome='4', genomic_nucleotide_accession_version='NC_000004.12', start_position_on_the_genomic_accession=140388453, end_position_on_the_genomic_accession=140427648, orientation='minus', exon_count=16, OMIM=[601858], no_hdr0=''),
    1048 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1048, CurrentID=0, Status='live', Symbol='CEACAM5', Aliases=['CD66e', 'CEA'], description='CEA cell adhesion molecule 5', other_designations='carcinoembryonic antigen-related cell adhesion molecule 5|carcinoembryonic antigen related cell adhesion molecule 5|meconium antigen 100', map_location='19q13.2', chromosome='19', genomic_nucleotide_accession_version='NC_000019.10', start_position_on_the_genomic_accession=41708626, end_position_on_the_genomic_accession=41730433, orientation='plus', exon_count=10, OMIM=[114890], no_hdr0=''),
    1050 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1050, CurrentID=0, Status='live', Symbol='CEBPA', Aliases=['C/EBP-alpha', 'CEBP'], description='CCAAT enhancer binding protein alpha', other_designations='CCAAT/enhancer-binding protein alpha|CCAAT/enhancer binding protein (C/EBP), alpha', map_location='19q13.11', chromosome='19', genomic_nucleotide_accession_version='NC_000019.10', start_position_on_the_genomic_accession=33299934, end_position_on_the_genomic_accession=33302564, orientation='minus', exon_count=1, OMIM=[116897], no_hdr0=''),
    1051 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1051, CurrentID=0, Status='live', Symbol='CEBPB', Aliases=['C/EBP-beta', 'IL6DBP', 'NF-IL6', 'TCF5'], description='CCAAT enhancer binding protein beta', other_designations='CCAAT/enhancer-binding protein beta|CCAAT/enhancer binding protein (C/EBP), beta|interleukin 6-dependent DNA-binding protein|nuclear factor NF-IL6|nuclear factor of interleukin 6|transcription factor 5|transcription factor C/EBP beta', map_location='20q13.13', chromosome='20', genomic_nucleotide_accession_version='NC_000020.11', start_position_on_the_genomic_accession=50190583, end_position_on_the_genomic_accession=50192690, orientation='plus', exon_count=1, OMIM=[189965], no_hdr0=''),
    1052 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1052, CurrentID=0, Status='live', Symbol='CEBPD', Aliases=['C/EBP-delta', 'CELF', 'CRP3', 'NF-IL6-beta'], description='CCAAT enhancer binding protein delta', other_designations='CCAAT/enhancer-binding protein delta|CCAAT/enhancer binding protein (C/EBP), delta|c/EBP delta|nuclear factor NF-IL6-beta', map_location='8q11.21', chromosome='8', genomic_nucleotide_accession_version='NC_000008.11', start_position_on_the_genomic_accession=47736913, end_position_on_the_genomic_accession=47738164, orientation='minus', exon_count=1, OMIM=[116898], no_hdr0=''),
    1053 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1053, CurrentID=0, Status='live', Symbol='CEBPE', Aliases=['C/EBP-epsilon', 'CRP1', 'c/EBP epsilon'], description='CCAAT enhancer binding protein epsilon', other_designations='CCAAT/enhancer-binding protein epsilon|CCAAT/enhancer binding protein (C/EBP), epsilon', map_location='14q11.2', chromosome='14', genomic_nucleotide_accession_version='NC_000014.9', start_position_on_the_genomic_accession=23117306, end_position_on_the_genomic_accession=23119255, orientation='minus', exon_count=2, OMIM=[600749], no_hdr0=''),
    1054 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1054, CurrentID=0, Status='live', Symbol='CEBPG', Aliases=['GPE1BP', 'IG/EBP-1'], description='CCAAT enhancer binding protein gamma', other_designations='CCAAT/enhancer-binding protein gamma|CCAAT/enhancer binding protein (C/EBP), gamma|c/EBP gamma', map_location='19q13.11', chromosome='19', genomic_nucleotide_accession_version='NC_000019.10', start_position_on_the_genomic_accession=33373709, end_position_on_the_genomic_accession=33382686, orientation='plus', exon_count=3, OMIM=[138972], no_hdr0=''),
    1056 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1056, CurrentID=0, Status='live', Symbol='CEL', Aliases=['BAL', 'BSDL', 'BSSLL', 'CEase', 'FAP', 'FAPP', 'LIPA', 'MODY8', 'CEL'], description='carboxyl ester lipase', other_designations='bile salt-activated lipase|bucelipase|carboxyl ester hydrolase|carboxyl ester lipase (bile salt-stimulated lipase)|cholesterol esterase|fetoacinar pancreatic protein|lysophospholipase, pancreatic|sterol esterase', map_location='9q34.13', chromosome='9', genomic_nucleotide_accession_version='NC_000009.12', start_position_on_the_genomic_accession=133061981, end_position_on_the_genomic_accession=133071861, orientation='plus', exon_count=11, OMIM=[114840], no_hdr0=''),
    1058 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1058, CurrentID=0, Status='live', Symbol='CENPA', Aliases=['CENP-A', 'CenH3'], description='centromere protein A', other_designations='histone H3-like centromeric protein A|centromere autoantigen A|centromere protein A, 17kDa|centromere-specific histone', map_location='2p23.3', chromosome='2', genomic_nucleotide_accession_version='NC_000002.12', start_position_on_the_genomic_accession=26786056, end_position_on_the_genomic_accession=26794589, orientation='plus', exon_count=5, OMIM=[117139], no_hdr0=''),
    1059 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1059, CurrentID=0, Status='live', Symbol='CENPB', Aliases=[], description='centromere protein B', other_designations='major centromere autoantigen B|CENP-B|centromere autoantigen B|centromere protein B, 80kDa', map_location='20p13', chromosome='20', genomic_nucleotide_accession_version='NC_000020.11', start_position_on_the_genomic_accession=3783851, end_position_on_the_genomic_accession=3786740, orientation='minus', exon_count=1, OMIM=[117140], no_hdr0=''),
    1060 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1060, CurrentID=0, Status='live', Symbol='CENPC', Aliases=['CENP-C1', 'MIF2', 'hcp-4', 'CENPC'], description='centromere protein C', other_designations='centromere protein C|CENP-C 1|centromere autoantigen C|centromere autoantigen C1|centromere protein C 1|interphase centromere complex protein 7', map_location='4q13.2', chromosome='4', genomic_nucleotide_accession_version='NC_000004.12', start_position_on_the_genomic_accession=67468762, end_position_on_the_genomic_accession=67545503, orientation='minus', exon_count=20, OMIM=[117141], no_hdr0=''),
    1062 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1062, CurrentID=0, Status='live', Symbol='CENPE', Aliases=['CENP-E', 'KIF10', 'MCPH13', 'PPP1R61'], description='centromere protein E', other_designations='centromere-associated protein E|Centromere autoantigen E (312kD)|centromere protein E, 312kDa|kinesin family member 10|kinesin-7|kinesin-related protein CENPE|protein phosphatase 1, regulatory subunit 61', map_location='4q24', chromosome='4', genomic_nucleotide_accession_version='NC_000004.12', start_position_on_the_genomic_accession=103105811, end_position_on_the_genomic_accession=103198408, orientation='minus', exon_count=49, OMIM=[117143], no_hdr0=''),
    1063 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1063, CurrentID=0, Status='live', Symbol='CENPF', Aliases=['CENF', 'CILD31', 'PRO1779', 'STROMS', 'hcp-1'], description='centromere protein F', other_designations='centromere protein F|AH antigen|CENP-F kinetochore protein|cell-cycle-dependent 350K nuclear protein|centromere protein F, 350/400kDa|kinetochore protein CENPF|mitosin', map_location='1q41', chromosome='1', genomic_nucleotide_accession_version='NC_000001.11', start_position_on_the_genomic_accession=214603195, end_position_on_the_genomic_accession=214664571, orientation='plus', exon_count=21, OMIM=[600236], no_hdr0=''),
    1066 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1066, CurrentID=0, Status='live', Symbol='CES1', Aliases=['ACAT', 'CE-1', 'CEH', 'CES2', 'HMSE', 'HMSE1', 'PCE-1', 'REH', 'SES1', 'TGH', 'hCE-1'], description='carboxylesterase 1', other_designations='liver carboxylesterase 1|acyl coenzyme A:cholesterol acyltransferase|brain carboxylesterase hBr1|carboxylesterase 1 (monocyte/macrophage serine esterase 1)|carboxylesterase 2 (liver)|cholesteryl ester hydrolase|cocaine carboxylesterase|egasyn|human monocyte/macrophage serine esterase 1|methylumbelliferyl-acetate deacetylase 1|monocyte/macrophage serine esterase|retinyl ester hydrolase|serine esterase 1|triacylglycerol hydrolase', map_location='16q12.2', chromosome='16', genomic_nucleotide_accession_version='NC_000016.10', start_position_on_the_genomic_accession=55802851, end_position_on_the_genomic_accession=55833127, orientation='minus', exon_count=14, OMIM=[114835], no_hdr0=''),
    1068 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1068, CurrentID=0, Status='live', Symbol='CETN1', Aliases=['CEN1', 'CETN'], description='centrin 1', other_designations='centrin-1|EF-hand protein|calcium binding protein|caltractin|centrin, EF-hand protein, 1|testicular tissue protein Li 37', map_location='18p11.32', chromosome='18', genomic_nucleotide_accession_version='NC_000018.10', start_position_on_the_genomic_accession=580380, end_position_on_the_genomic_accession=582114, orientation='plus', exon_count=1, OMIM=[603187], no_hdr0=''),
    1069 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1069, CurrentID=0, Status='live', Symbol='CETN2', Aliases=['CALT', 'CEN2'], description='centrin 2', other_designations='centrin-2|caltractin (20kD calcium-binding protein)|centrin, EF-hand protein, 2', map_location='Xq28', chromosome='X', genomic_nucleotide_accession_version='NC_000023.11', start_position_on_the_genomic_accession=152826994, end_position_on_the_genomic_accession=152830757, orientation='minus', exon_count=5, OMIM=[300006], no_hdr0=''),
    1070 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1070, CurrentID=0, Status='live', Symbol='CETN3', Aliases=['CDC31', 'CEN3'], description='centrin 3', other_designations='centrin-3|CDC31 yeast homolog|EF-hand superfamily member|centrin, EF-hand protein, 3 (CDC31 homolog, yeast)', map_location='5q14.3', chromosome='5', genomic_nucleotide_accession_version='NC_000005.10', start_position_on_the_genomic_accession=90392257, end_position_on_the_genomic_accession=90409756, orientation='minus', exon_count=6, OMIM=[602907], no_hdr0=''),
    1071 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1071, CurrentID=0, Status='live', Symbol='CETP', Aliases=['BPIFF', 'HDLCQ10'], description='cholesteryl ester transfer protein', other_designations='cholesteryl ester transfer protein|BPI fold containing family F|cholesteryl ester transfer protein plasma|lipid transfer protein I', map_location='16q13', chromosome='16', genomic_nucleotide_accession_version='NC_000016.10', start_position_on_the_genomic_accession=56961950, end_position_on_the_genomic_accession=56983845, orientation='plus', exon_count=17, OMIM=[118470], no_hdr0=''),
    1072 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1072, CurrentID=0, Status='live', Symbol='CFL1', Aliases=['CFL', 'HEL-S-15', 'cofilin'], description='cofilin 1', other_designations='cofilin-1|18 kDa phosphoprotein|cofilin 1 (non-muscle)|epididymis secretory protein Li 15|p18', map_location='11q13.1', chromosome='11', genomic_nucleotide_accession_version='NC_000011.10', start_position_on_the_genomic_accession=65854673, end_position_on_the_genomic_accession=65858180, orientation='minus', exon_count=4, OMIM=[601442], no_hdr0=''),
    1073 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1073, CurrentID=0, Status='live', Symbol='CFL2', Aliases=['NEM7'], description='cofilin 2', other_designations='cofilin-2|cofilin 2 (muscle)|nemaline myopathy type 7', map_location='14q13.1', chromosome='14', genomic_nucleotide_accession_version='NC_000014.9', start_position_on_the_genomic_accession=34709113, end_position_on_the_genomic_accession=34714593, orientation='minus', exon_count=6, OMIM=[601443], no_hdr0=''),
    1075 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1075, CurrentID=0, Status='live', Symbol='CTSC', Aliases=['CPPI', 'DPP-I', 'DPP1', 'DPPI', 'HMS', 'JP', 'JPD', 'PALS', 'PDON1', 'PLS'], description='cathepsin C', other_designations='dipeptidyl peptidase 1|cathepsin J|dipeptidyl transferase|dipeptidyl-peptidase I', map_location='11q14.2', chromosome='11', genomic_nucleotide_accession_version='NC_000011.10', start_position_on_the_genomic_accession=88293592, end_position_on_the_genomic_accession=88337736, orientation='minus', exon_count=9, OMIM=[602365], no_hdr0=''),
    1080 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1080, CurrentID=0, Status='live', Symbol='CFTR', Aliases=['ABC35', 'ABCC7', 'CF/MRP', 'MRP7', 'TNR-CFTR', 'dJ760C5.1', 'CFTR'], description='CF transmembrane conductance regulator', other_designations='cystic fibrosis transmembrane conductance regulator|cAMP-dependent chloride channel|channel conductance-controlling ATPase|cystic fibrosis transmembrane conductance regulating|cystic fibrosis transmembrane conductance regulator (ATP-binding cassette sub-family C, member 7)', map_location='7q31.2', chromosome='7', genomic_nucleotide_accession_version='NC_000007.14', start_position_on_the_genomic_accession=117480025, end_position_on_the_genomic_accession=117668665, orientation='plus', exon_count=27, OMIM=[602421], no_hdr0=''),
    1081 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1081, CurrentID=0, Status='live', Symbol='CGA', Aliases=['CG-ALPHA', 'FSHA', 'GPA1', 'GPHA1', 'GPHa', 'HCG', 'LHA', 'TSHA'], description='glycoprotein hormones, alpha polypeptide', other_designations='glycoprotein hormones alpha chain|FSH-alpha|LSH-alpha|TSH-alpha|anterior pituitary glycoprotein hormones common subunit alpha|choriogonadotropin alpha chain|chorionic gonadotrophin subunit alpha|chorionic gonadotropin, alpha polypeptide|follicle-stimulating hormone alpha chain|follicle-stimulating hormone alpha subunit|follitropin alpha chain|luteinizing hormone alpha chain|lutropin alpha chain|thyroid-stimulating hormone alpha chain|thyrotropin alpha chain', map_location='6q14.3', chromosome='6', genomic_nucleotide_accession_version='NC_000006.12', start_position_on_the_genomic_accession=87085498, end_position_on_the_genomic_accession=87095106, orientation='minus', exon_count=5, OMIM=[118850], no_hdr0=''),
    1082 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1082, CurrentID=0, Status='live', Symbol='CGB3', Aliases=['CGB', 'CGB5', 'CGB7', 'CGB8', 'hCGB'], description='chorionic gonadotropin subunit beta 3', other_designations='choriogonadotropin subunit beta 3|CG-beta|chorionic gonadotrophin chain beta|chorionic gonadotropin beta 3 subunit|chorionic gonadotropin beta chain|chorionic gonadotropin beta subunit 3|chorionic gonadotropin chain beta|chorionic gonadotropin, beta polypeptide', map_location='19q13.33', chromosome='19', genomic_nucleotide_accession_version='NC_000019.10', start_position_on_the_genomic_accession=49022869, end_position_on_the_genomic_accession=49024375, orientation='minus', exon_count=3, OMIM=[118860], no_hdr0=''),
    1084 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1084, CurrentID=0, Status='live', Symbol='CEACAM3', Aliases=['CD66D', 'CEA', 'CGM1', 'W264', 'W282'], description='CEA cell adhesion molecule 3', other_designations='carcinoembryonic antigen-related cell adhesion molecule 3|CD66d antigen|carcinoembryonic antigen CGM1|carcinoembryonic antigen gene family member 1|carcinoembryonic antigen related cell adhesion molecule 3|nonspecific cross-reacting antigen', map_location='19q13.2', chromosome='19', genomic_nucleotide_accession_version='NC_000019.10', start_position_on_the_genomic_accession=41796587, end_position_on_the_genomic_accession=41811554, orientation='plus', exon_count=8, OMIM=[609142], no_hdr0=''),
    1087 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1087, CurrentID=0, Status='live', Symbol='CEACAM7', Aliases=['CGM2'], description='CEA cell adhesion molecule 7', other_designations='carcinoembryonic antigen-related cell adhesion molecule 7|carcinoembryonic antigen CGM2|carcinoembryonic antigen gene family member 2|carcinoembryonic antigen related cell adhesion molecule 7', map_location='19q13.2', chromosome='19', genomic_nucleotide_accession_version='NC_000019.10', start_position_on_the_genomic_accession=41673303, end_position_on_the_genomic_accession=41688270, orientation='minus', exon_count=5, OMIM=[], no_hdr0=''),
    1088 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1088, CurrentID=0, Status='live', Symbol='CEACAM8', Aliases=['CD66b', 'CD67', 'CGM6', 'NCA-95'], description='CEA cell adhesion molecule 8', other_designations='carcinoembryonic antigen-related cell adhesion molecule 8|CD67 antigen|carcinoembryonic antigen CGM6|carcinoembryonic antigen gene family member 6|carcinoembryonic antigen related cell adhesion molecule 8|non-specific cross-reacting antigen NCA-95', map_location='19q13.2', chromosome='19', genomic_nucleotide_accession_version='NC_000019.10', start_position_on_the_genomic_accession=42580243, end_position_on_the_genomic_accession=42595157, orientation='minus', exon_count=8, OMIM=[615747], no_hdr0=''),
    1089 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1089, CurrentID=0, Status='live', Symbol='CEACAM4', Aliases=['CGM7', 'CGM7_HUMAN', 'NCA'], description='CEA cell adhesion molecule 4', other_designations='carcinoembryonic antigen-related cell adhesion molecule 4|Nonspecific cross-reacting antigen (NCA)|carcinoembryonic antigen CGM7|carcinoembryonic antigen gene family member 7|carcinoembryonic antigen related cell adhesion molecule 4|carcinoembryonic antigen-related cell adhesion molecule 4-sv1|carcinoembryonic antigen-related cell adhesion molecule 4-sv2|non-specific cross-reacting antigen W236|nonspecific cross-reacting antigen W236', map_location='19q13.2', chromosome='19', genomic_nucleotide_accession_version='NC_000019.10', start_position_on_the_genomic_accession=41616986, end_position_on_the_genomic_accession=41627087, orientation='minus', exon_count=11, OMIM=[], no_hdr0=''),
    1101 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1101, CurrentID=0, Status='live', Symbol='CHAD', Aliases=['SLRR4A'], description='chondroadherin', other_designations='chondroadherin|cartilage leucine-rich protein|chondroadherin proteoglycan', map_location='17q21.33', chromosome='17', genomic_nucleotide_accession_version='NC_000017.11', start_position_on_the_genomic_accession=50464492, end_position_on_the_genomic_accession=50469881, orientation='minus', exon_count=4, OMIM=[602178], no_hdr0=''),
    1102 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1102, CurrentID=0, Status='live', Symbol='RCBTB2', Aliases=['CHC1L', 'RLG'], description='RCC1 and BTB domain containing protein 2', other_designations='RCC1 and BTB domain-containing protein 2|RCC1-like G exchanging factor RLG|regulator of chromosome condensation (RCC1) and BTB (POZ) domain containing protein 2', map_location='13q14.2', chromosome='13', genomic_nucleotide_accession_version='NC_000013.11', start_position_on_the_genomic_accession=48488963, end_position_on_the_genomic_accession=48535997, orientation='minus', exon_count=18, OMIM=[603524], no_hdr0=''),
    1103 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1103, CurrentID=0, Status='live', Symbol='CHAT', Aliases=['CHOACTASE', 'CMS1A', 'CMS1A2', 'CMS6'], description='choline O-acetyltransferase', other_designations='choline O-acetyltransferase|acetyl CoA:choline O-acetyltransferase|choline acetylase', map_location='10q11.23', chromosome='10', genomic_nucleotide_accession_version='NC_000010.11', start_position_on_the_genomic_accession=49609095, end_position_on_the_genomic_accession=49667942, orientation='plus', exon_count=18, OMIM=[118490], no_hdr0=''),
    1104 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1104, CurrentID=0, Status='live', Symbol='RCC1', Aliases=['CHC1-I', 'SNHG3-RCC1', 'RCC1'], description='regulator of chromosome condensation 1', other_designations='regulator of chromosome condensation|SNHG3-RCC1 readthrough|cell cycle regulatory protein|guanine nucleotide-releasing protein', map_location='1p35.3', chromosome='1', genomic_nucleotide_accession_version='NC_000001.11', start_position_on_the_genomic_accession=28506043, end_position_on_the_genomic_accession=28538989, orientation='plus', exon_count=15, OMIM=[179710], no_hdr0=''),
    1105 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1105, CurrentID=0, Status='live', Symbol='CHD1', Aliases=['CHD-1', 'PILBOS'], description='chromodomain helicase DNA binding protein 1', other_designations='chromodomain-helicase-DNA-binding protein 1|ATP-dependent helicase CHD1', map_location='5q15-q21.1', chromosome='5', genomic_nucleotide_accession_version='NC_000005.10', start_position_on_the_genomic_accession=98853985, end_position_on_the_genomic_accession=98929772, orientation='minus', exon_count=40, OMIM=[602118], no_hdr0=''),
    1106 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1106, CurrentID=0, Status='live', Symbol='CHD2', Aliases=['EEOC'], description='chromodomain helicase DNA binding protein 2', other_designations='chromodomain-helicase-DNA-binding protein 2|ATP-dependent helicase CHD2|CHD-2', map_location='15q26.1', chromosome='15', genomic_nucleotide_accession_version='NC_000015.10', start_position_on_the_genomic_accession=92900324, end_position_on_the_genomic_accession=93027996, orientation='plus', exon_count=39, OMIM=[602119], no_hdr0=''),
    1107 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1107, CurrentID=0, Status='live', Symbol='CHD3', Aliases=['Mi-2a', 'Mi2-ALPHA', 'SNIBCPS', 'ZFH'], description='chromodomain helicase DNA binding protein 3', other_designations='chromodomain-helicase-DNA-binding protein 3|ATP-dependent helicase CHD3|CHD-3|hZFH|mi-2 autoantigen 240 kDa protein|zinc finger helicase|zinc-finger helicase (Snf2-like)', map_location='17p13.1', chromosome='17', genomic_nucleotide_accession_version='NC_000017.11', start_position_on_the_genomic_accession=7884764, end_position_on_the_genomic_accession=7912755, orientation='plus', exon_count=44, OMIM=[602120], no_hdr0=''),
    1108 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1108, CurrentID=0, Status='live', Symbol='CHD4', Aliases=['CHD-4', 'Mi-2b', 'Mi2-BETA', 'SIHIWES'], description='chromodomain helicase DNA binding protein 4', other_designations='chromodomain-helicase-DNA-binding protein 4|ATP-dependent helicase CHD4|Mi-2 autoantigen 218 kDa protein', map_location='12p13.31', chromosome='12', genomic_nucleotide_accession_version='NC_000012.12', start_position_on_the_genomic_accession=6570082, end_position_on_the_genomic_accession=6607379, orientation='minus', exon_count=40, OMIM=[603277], no_hdr0=''),
    1109 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1109, CurrentID=0, Status='live', Symbol='AKR1C4', Aliases=['3-alpha-HSD', 'C11', 'CDR', 'CHDR', 'DD-4', 'DD4', 'HAKRA'], description='aldo-keto reductase family 1 member C4', other_designations='aldo-keto reductase family 1 member C4|3-alpha-HSD1|chlordecone reductase; 3-alpha hydroxysteroid dehydrogenase, type I; dihydrodiol dehydrogenase 4|dihydrodiol dehydrogenase isozyme DD4|type I 3-alpha-hydroxysteroid dehydrogenase', map_location='10p15.1', chromosome='10', genomic_nucleotide_accession_version='NC_000010.11', start_position_on_the_genomic_accession=5196837, end_position_on_the_genomic_accession=5218949, orientation='plus', exon_count=9, OMIM=[600451], no_hdr0=''),
    1111 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1111, CurrentID=0, Status='live', Symbol='CHEK1', Aliases=['CHK1'], description='checkpoint kinase 1', other_designations='serine/threonine-protein kinase Chk1|CHK1 checkpoint homolog|Checkpoint, S. pombe, homolog of, 1|Chk1-S|cell cycle checkpoint kinase', map_location='11q24.2', chromosome='11', genomic_nucleotide_accession_version='NC_000011.10', start_position_on_the_genomic_accession=125624910, end_position_on_the_genomic_accession=125676256, orientation='plus', exon_count=15, OMIM=[603078], no_hdr0=''),
    1112 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1112, CurrentID=0, Status='live', Symbol='FOXN3', Aliases=['C14orf116', 'CHES1', 'PRO1635'], description='forkhead box N3', other_designations='forkhead box protein N3|checkpoint suppressor 1', map_location='14q31.3-q32.11', chromosome='14', genomic_nucleotide_accession_version='NC_000014.9', start_position_on_the_genomic_accession=89156177, end_position_on_the_genomic_accession=89619165, orientation='minus', exon_count=8, OMIM=[602628], no_hdr0=''),
    1113 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1113, CurrentID=0, Status='live', Symbol='CHGA', Aliases=['CGA'], description='chromogranin A', other_designations='chromogranin-A|SP-I|betagranin (N-terminal fragment of chromogranin A)|catestatin|chromofungin|parathyroid secretory protein 1|pituitary secretory protein I', map_location='14q32.12', chromosome='14', genomic_nucleotide_accession_version='NC_000014.9', start_position_on_the_genomic_accession=92922594, end_position_on_the_genomic_accession=92935293, orientation='plus', exon_count=9, OMIM=[118910], no_hdr0=''),
    1114 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1114, CurrentID=0, Status='live', Symbol='CHGB', Aliases=['SCG1'], description='chromogranin B', other_designations='secretogranin-1|cgB|secretogranin B|secretogranin I|sgI', map_location='20p12.3', chromosome='20', genomic_nucleotide_accession_version='NC_000020.11', start_position_on_the_genomic_accession=5911510, end_position_on_the_genomic_accession=5925353, orientation='plus', exon_count=5, OMIM=[118920], no_hdr0=''),
    1116 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1116, CurrentID=0, Status='live', Symbol='CHI3L1', Aliases=['ASRT7', 'CGP-39', 'GP-39', 'GP39', 'HC-gp39', 'HCGP-3P', 'YK-40', 'YKL-40', 'YKL40', 'YYL-40', 'hCGP-39'], description='chitinase 3 like 1', other_designations='chitinase-3-like protein 1|39 kDa synovial protein|cartilage glycoprotein 39|chitinase 3-like 1 (cartilage glycoprotein-39)', map_location='1q32.1', chromosome='1', genomic_nucleotide_accession_version='NC_000001.11', start_position_on_the_genomic_accession=203178931, end_position_on_the_genomic_accession=203186704, orientation='minus', exon_count=10, OMIM=[601525], no_hdr0=''),
    1117 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1117, CurrentID=0, Status='live', Symbol='CHI3L2', Aliases=['CHIL2', 'YKL-39', 'YKL39'], description='chitinase 3 like 2', other_designations='chitinase-3-like protein 2|chondrocyte protein 39', map_location='1p13.2', chromosome='1', genomic_nucleotide_accession_version='NC_000001.11', start_position_on_the_genomic_accession=111227080, end_position_on_the_genomic_accession=111243440, orientation='plus', exon_count=12, OMIM=[601526], no_hdr0=''),
    1118 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1118, CurrentID=0, Status='live', Symbol='CHIT1', Aliases=['CHI3', 'CHIT', 'CHITD'], description='chitinase 1', other_designations='chitotriosidase-1|chitinase 1 (chitotriosidase)|plasma methylumbelliferyl tetra-N-acetylchitotetraoside hydrolase', map_location='1q32.1', chromosome='1', genomic_nucleotide_accession_version='NC_000001.11', start_position_on_the_genomic_accession=203216079, end_position_on_the_genomic_accession=203229673, orientation='minus', exon_count=13, OMIM=[600031], no_hdr0=''),
    1119 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1119, CurrentID=0, Status='live', Symbol='CHKA', Aliases=['CHK', 'CK', 'CKI', 'EK'], description='choline kinase alpha', other_designations='choline kinase alpha|CHETK-alpha|ethanolamine kinase', map_location='11q13.2', chromosome='11', genomic_nucleotide_accession_version='NC_000011.10', start_position_on_the_genomic_accession=68052859, end_position_on_the_genomic_accession=68121389, orientation='minus', exon_count=14, OMIM=[118491], no_hdr0=''),
    1120 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1120, CurrentID=0, Status='live', Symbol='CHKB', Aliases=['CHETK', 'CHKL', 'CK', 'CKB', 'CKEKB', 'EK', 'EKB', 'MDCMC'], description='choline kinase beta', other_designations='choline/ethanolamine kinase|choline kinase-like protein|ethanolamine kinase beta', map_location='22q13.33', chromosome='22', genomic_nucleotide_accession_version='NC_000022.11', start_position_on_the_genomic_accession=50578963, end_position_on_the_genomic_accession=50582849, orientation='minus', exon_count=11, OMIM=[612395], no_hdr0=''),
    1121 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1121, CurrentID=0, Status='live', Symbol='CHM', Aliases=['DXS540', 'GGTA', 'HSD-32', 'REP-1', 'TCD'], description='CHM Rab escort protein', other_designations='rab proteins geranylgeranyltransferase component A 1|CHM, Rab escort protein 1|choroideremia (Rab escort protein 1)', map_location='Xq21.2', chromosome='X', genomic_nucleotide_accession_version='NC_000023.11', start_position_on_the_genomic_accession=85861180, end_position_on_the_genomic_accession=86047558, orientation='minus', exon_count=19, OMIM=[300390], no_hdr0=''),
    1122 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1122, CurrentID=0, Status='live', Symbol='CHML', Aliases=['REP2'], description='CHM like Rab escort protein', other_designations='rab proteins geranylgeranyltransferase component A 2|CHM like Rab escort protein 2|choroideraemia-like protein|choroideremia-like (Rab escort protein 2)|choroideremia-like protein', map_location='1q43', chromosome='1', genomic_nucleotide_accession_version='NC_000001.11', start_position_on_the_genomic_accession=241628851, end_position_on_the_genomic_accession=241640369, orientation='minus', exon_count=2, OMIM=[118825], no_hdr0=''),
    1123 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1123, CurrentID=0, Status='live', Symbol='CHN1', Aliases=['ARHGAP2', 'CHN', 'DURS2', 'NC', 'RHOGAP2'], description='chimerin 1', other_designations='N-chimaerin|A-chimaerin|Rho GTPase-activating protein 2|a2-chimaerin|alpha-chimerin|chimaerin 1|chimerin (chimaerin) 1|n-chimerin', map_location='2q31.1', chromosome='2', genomic_nucleotide_accession_version='NC_000002.12', start_position_on_the_genomic_accession=174798809, end_position_on_the_genomic_accession=175005381, orientation='minus', exon_count=15, OMIM=[118423], no_hdr0=''),
    1124 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1124, CurrentID=0, Status='live', Symbol='CHN2', Aliases=['ARHGAP3', 'BCH-3', 'RHOGAP3', 'CHN2'], description='chimerin 2', other_designations='beta-chimaerin|beta-chimerin|beta3-chimaerin|chimerin (chimaerin) 2|chimerin, beta-2|chimerin, testis-specific|rho-GTPase-activating protein 3', map_location='7p14.3', chromosome='7', genomic_nucleotide_accession_version='NC_000007.14', start_position_on_the_genomic_accession=29146547, end_position_on_the_genomic_accession=29514335, orientation='plus', exon_count=21, OMIM=[602857], no_hdr0=''),
    1128 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1128, CurrentID=0, Status='live', Symbol='CHRM1', Aliases=['HM1', 'M1', 'M1R'], description='cholinergic receptor muscarinic 1', other_designations='muscarinic acetylcholine receptor M1|acetylcholine receptor, muscarinic 1', map_location='11q12.3', chromosome='11', genomic_nucleotide_accession_version='NC_000011.10', start_position_on_the_genomic_accession=62908675, end_position_on_the_genomic_accession=62921861, orientation='minus', exon_count=3, OMIM=[118510], no_hdr0=''),
    1129 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1129, CurrentID=0, Status='live', Symbol='CHRM2', Aliases=['HM2'], description='cholinergic receptor muscarinic 2', other_designations='muscarinic acetylcholine receptor M2|7TM receptor|acetylcholine receptor, muscarinic 2|muscarinic M2 receptor', map_location='7q33', chromosome='7', genomic_nucleotide_accession_version='NC_000007.14', start_position_on_the_genomic_accession=136868652, end_position_on_the_genomic_accession=137020213, orientation='plus', exon_count=7, OMIM=[118493], no_hdr0=''),
    1130 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1130, CurrentID=0, Status='live', Symbol='LYST', Aliases=['CHS', 'CHS1'], description='lysosomal trafficking regulator', other_designations='lysosomal-trafficking regulator|Chediak-Higashi syndrome 1|beige homolog', map_location='1q42.3', chromosome='1', genomic_nucleotide_accession_version='NC_000001.11', start_position_on_the_genomic_accession=235661031, end_position_on_the_genomic_accession=235883713, orientation='minus', exon_count=61, OMIM=[606897], no_hdr0=''),
    1131 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1131, CurrentID=0, Status='live', Symbol='CHRM3', Aliases=['EGBRS', 'HM3', 'PBS'], description='cholinergic receptor muscarinic 3', other_designations='muscarinic acetylcholine receptor M3|acetylcholine receptor, muscarinic 3|m3 muscarinic receptor', map_location='1q43', chromosome='1', genomic_nucleotide_accession_version='NC_000001.11', start_position_on_the_genomic_accession=239386565, end_position_on_the_genomic_accession=239915450, orientation='plus', exon_count=17, OMIM=[118494], no_hdr0=''),
    1132 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1132, CurrentID=0, Status='live', Symbol='CHRM4', Aliases=['HM4', 'M4R'], description='cholinergic receptor muscarinic 4', other_designations='muscarinic acetylcholine receptor M4|acetylcholine receptor, muscarinic 4', map_location='11p11.2', chromosome='11', genomic_nucleotide_accession_version='NC_000011.10', start_position_on_the_genomic_accession=46383789, end_position_on_the_genomic_accession=46391776, orientation='minus', exon_count=2, OMIM=[118495], no_hdr0=''),
    1133 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1133, CurrentID=0, Status='live', Symbol='CHRM5', Aliases=['HM5'], description='cholinergic receptor muscarinic 5', other_designations='muscarinic acetylcholine receptor M5|acetylcholine receptor, muscarinic 5', map_location='15q14', chromosome='15', genomic_nucleotide_accession_version='NC_000015.10', start_position_on_the_genomic_accession=33968497, end_position_on_the_genomic_accession=34067458, orientation='plus', exon_count=3, OMIM=[118496], no_hdr0=''),
    1134 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1134, CurrentID=0, Status='live', Symbol='CHRNA1', Aliases=['ACHRA', 'ACHRD', 'CHRNA', 'CMS1A', 'CMS1B', 'CMS2A', 'FCCMS', 'SCCMS'], description='cholinergic receptor nicotinic alpha 1 subunit', other_designations='acetylcholine receptor subunit alpha|acetylcholine receptor, nicotinic, alpha 1 (muscle)|cholinergic receptor, nicotinic alpha 1|cholinergic receptor, nicotinic, alpha 1 (muscle)|cholinergic receptor, nicotinic, alpha polypeptide 1 (muscle)|muscle nicotinic acetylcholine receptor|nicotinic acetylcholine receptor alpha subunit|nicotinic cholinergic receptor alpha 1', map_location='2q31.1', chromosome='2', genomic_nucleotide_accession_version='NC_000002.12', start_position_on_the_genomic_accession=174747592, end_position_on_the_genomic_accession=174764472, orientation='minus', exon_count=10, OMIM=[100690], no_hdr0=''),
    1135 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1135, CurrentID=0, Status='live', Symbol='CHRNA2', Aliases=[], description='cholinergic receptor nicotinic alpha 2 subunit', other_designations='neuronal acetylcholine receptor subunit alpha-2|acetylcholine receptor, nicotinic, alpha 2 (neuronal)|cholinergic receptor, nicotinic alpha 2|cholinergic receptor, nicotinic, alpha 2 (neuronal)|cholinergic receptor, nicotinic, alpha polypeptide 2 (neuronal)', map_location='8p21.2', chromosome='8', genomic_nucleotide_accession_version='NC_000008.11', start_position_on_the_genomic_accession=27459756, end_position_on_the_genomic_accession=27479285, orientation='minus', exon_count=8, OMIM=[118502], no_hdr0=''),
    1136 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1136, CurrentID=0, Status='live', Symbol='CHRNA3', Aliases=['BAIPRCK', 'LNCR2', 'NACHRA3', 'PAOD2'], description='cholinergic receptor nicotinic alpha 3 subunit', other_designations='neuronal acetylcholine receptor subunit alpha-3|cholinergic receptor, nicotinic alpha 3|cholinergic receptor, nicotinic, alpha 3 (neuronal)|cholinergic receptor, nicotinic, alpha polypeptide 3|neuronal nicotinic acetylcholine receptor, alpha3 subunit', map_location='15q25.1', chromosome='15', genomic_nucleotide_accession_version='NC_000015.10', start_position_on_the_genomic_accession=78593052, end_position_on_the_genomic_accession=78620996, orientation='minus', exon_count=9, OMIM=[118503], no_hdr0=''),
    1137 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1137, CurrentID=0, Status='live', Symbol='CHRNA4', Aliases=['BFNC', 'EBN', 'EBN1', 'NACHR', 'NACHRA4', 'NACRA4'], description='cholinergic receptor nicotinic alpha 4 subunit', other_designations='neuronal acetylcholine receptor subunit alpha-4|cholinergic receptor, nicotinic alpha 4|cholinergic receptor, nicotinic, alpha 4 (neuronal)|cholinergic receptor, nicotinic, alpha polypeptide 4|neuronal nicotinic acetylcholine receptor alpha-4 subunit', map_location='20q13.33', chromosome='20', genomic_nucleotide_accession_version='NC_000020.11', start_position_on_the_genomic_accession=63343223, end_position_on_the_genomic_accession=63375471, orientation='minus', exon_count=10, OMIM=[118504], no_hdr0=''),
    1138 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1138, CurrentID=0, Status='live', Symbol='CHRNA5', Aliases=['LNCR2'], description='cholinergic receptor nicotinic alpha 5 subunit', other_designations='neuronal acetylcholine receptor subunit alpha-5|Cholinergic receptor, neuronal nicotinic, alpha polypeptide-5|acetylcholine receptor, nicotinic, alpha 5 (neuronal)|cholinergic receptor, nicotinic alpha 5|cholinergic receptor, nicotinic, alpha 5 (neuronal)|neuronal nicotinic acetylcholine receptor, alpha5 subunit', map_location='15q25.1', chromosome='15', genomic_nucleotide_accession_version='NC_000015.10', start_position_on_the_genomic_accession=78565520, end_position_on_the_genomic_accession=78595269, orientation='plus', exon_count=6, OMIM=[118505], no_hdr0=''),
    1139 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1139, CurrentID=0, Status='live', Symbol='CHRNA7', Aliases=['CHRNA7-2', 'NACHRA7'], description='cholinergic receptor nicotinic alpha 7 subunit', other_designations='neuronal acetylcholine receptor subunit alpha-7|a7 nicotinic acetylcholine receptor|alpha 7 neuronal nicotinic acetylcholine receptor|alpha-7 nicotinic cholinergic receptor subunit|cholinergic receptor, nicotinic alpha 7|cholinergic receptor, nicotinic, alpha 7 (neuronal)|cholinergic receptor, nicotinic, alpha polypeptide 7|neuronal acetylcholine receptor protein, alpha-7 chain', map_location='15q13.3', chromosome='15', genomic_nucleotide_accession_version='NC_000015.10', start_position_on_the_genomic_accession=32030462, end_position_on_the_genomic_accession=32173018, orientation='plus', exon_count=13, OMIM=[118511], no_hdr0=''),
    1140 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1140, CurrentID=0, Status='live', Symbol='CHRNB1', Aliases=['ACHRB', 'CHRNB', 'CMS1D', 'CMS2A', 'CMS2C', 'SCCMS'], description='cholinergic receptor nicotinic beta 1 subunit', other_designations='acetylcholine receptor subunit beta|acetylcholine receptor, nicotinic, beta 1 (muscle)|cholinergic receptor, nicotinic beta 1|cholinergic receptor, nicotinic, beta 1 (muscle)|cholinergic receptor, nicotinic, beta polypeptide 1 (muscle)', map_location='17p13.1', chromosome='17', genomic_nucleotide_accession_version='NC_000017.11', start_position_on_the_genomic_accession=7445061, end_position_on_the_genomic_accession=7457710, orientation='plus', exon_count=11, OMIM=[100710], no_hdr0=''),
    1141 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1141, CurrentID=0, Status='live', Symbol='CHRNB2', Aliases=['EFNL3', 'nAChRB2'], description='cholinergic receptor nicotinic beta 2 subunit', other_designations='neuronal acetylcholine receptor subunit beta-2|acetylcholine receptor, nicotinic, beta 2 (neuronal)|beta2 human neuronal nicotinic acetylcholine receptor|cholinergic receptor, nicotinic beta 2|cholinergic receptor, nicotinic, beta 2 (neuronal)|cholinergic receptor, nicotinic, beta polypeptide 2 (neuronal)|neuronal nicotinic acetylcholine receptor beta 2', map_location='1q21.3', chromosome='1', genomic_nucleotide_accession_version='NC_000001.11', start_position_on_the_genomic_accession=154567778, end_position_on_the_genomic_accession=154584708, orientation='plus', exon_count=7, OMIM=[118507], no_hdr0=''),
    1142 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1142, CurrentID=0, Status='live', Symbol='CHRNB3', Aliases=[], description='cholinergic receptor nicotinic beta 3 subunit', other_designations='neuronal acetylcholine receptor subunit beta-3|acetylcholine receptor, neuronal nicotinic, beta-3 subunit|acetylcholine receptor, nicotinic, beta 3 (neuronal)|cholinergic receptor, nicotinic beta 3|cholinergic receptor, nicotinic, beta 3 (neuronal)|cholinergic receptor, nicotinic, beta polypeptide 3', map_location='8p11.21', chromosome='8', genomic_nucleotide_accession_version='NC_000008.11', start_position_on_the_genomic_accession=42697366, end_position_on_the_genomic_accession=42737407, orientation='plus', exon_count=8, OMIM=[118508], no_hdr0=''),
    1143 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1143, CurrentID=0, Status='live', Symbol='CHRNB4', Aliases=[], description='cholinergic receptor nicotinic beta 4 subunit', other_designations='neuronal acetylcholine receptor subunit beta-4|acetylcholine receptor, nicotinic, beta 4 (neuronal)|cholinergic receptor, nicotinic, beta 4 (neuronal)|cholinergic receptor, nicotinic, beta polypeptide 4|neuronal nicotinic receptor beta 4 subunit', map_location='15q25.1', chromosome='15', genomic_nucleotide_accession_version='NC_000015.10', start_position_on_the_genomic_accession=78623282, end_position_on_the_genomic_accession=78655586, orientation='minus', exon_count=15, OMIM=[118509], no_hdr0=''),
    1144 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1144, CurrentID=0, Status='live', Symbol='CHRND', Aliases=['ACHRD', 'CMS2A', 'CMS3A', 'CMS3B', 'CMS3C', 'FCCMS', 'SCCMS'], description='cholinergic receptor nicotinic delta subunit', other_designations='acetylcholine receptor subunit delta|acetylcholine receptor, nicotinic, delta (muscle)|cholinergic receptor, nicotinic delta|cholinergic receptor, nicotinic, delta (muscle)|cholinergic receptor, nicotinic, delta polypeptide', map_location='2q37.1', chromosome='2', genomic_nucleotide_accession_version='NC_000002.12', start_position_on_the_genomic_accession=232526160, end_position_on_the_genomic_accession=232537907, orientation='plus', exon_count=12, OMIM=[100720], no_hdr0=''),
    1145 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1145, CurrentID=0, Status='live', Symbol='CHRNE', Aliases=['ACHRE', 'CMS1D', 'CMS1E', 'CMS2A', 'CMS4A', 'CMS4B', 'CMS4C', 'FCCMS', 'SCCMS'], description='cholinergic receptor nicotinic epsilon subunit', other_designations='acetylcholine receptor subunit epsilon|AchR epsilon subunit|acetylcholine receptor, nicotinic, epsilon (muscle)|cholinergic receptor, nicotinic epsilon|cholinergic receptor, nicotinic, epsilon (muscle)|cholinergic receptor, nicotinic, epsilon polypeptide', map_location='17p13.2', chromosome='17', genomic_nucleotide_accession_version='NC_000017.11', start_position_on_the_genomic_accession=4897771, end_position_on_the_genomic_accession=4905019, orientation='minus', exon_count=13, OMIM=[100725], no_hdr0=''),
    1146 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1146, CurrentID=0, Status='live', Symbol='CHRNG', Aliases=['ACHRG'], description='cholinergic receptor nicotinic gamma subunit', other_designations='acetylcholine receptor subunit gamma|acetylcholine receptor, muscle, gamma subunit|acetylcholine receptor, nicotinic, gamma (muscle)|cholinergic receptor, nicotinic gamma|cholinergic receptor, nicotinic, gamma (muscle)|cholinergic receptor, nicotinic, gamma polypeptide', map_location='2q37.1', chromosome='2', genomic_nucleotide_accession_version='NC_000002.12', start_position_on_the_genomic_accession=232539692, end_position_on_the_genomic_accession=232548115, orientation='plus', exon_count=12, OMIM=[100730], no_hdr0=''),
    1147 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1147, CurrentID=0, Status='live', Symbol='CHUK', Aliases=['IKBKA', 'IKK-alpha', 'IKK1', 'IKKA', 'NFKBIKA', 'TCF16'], description='component of inhibitor of nuclear factor kappa B kinase complex', other_designations='inhibitor of nuclear factor kappa-B kinase subunit alpha|I-kappa-B kinase 1|I-kappa-B kinase-alpha|IKK-a kinase|IkB kinase alpha subunit|Nuclear factor NFkappaB inhibitor kinase alpha|TCF-16|conserved helix-loop-helix ubiquitous kinase|transcription factor 16', map_location='10q24.31', chromosome='10', genomic_nucleotide_accession_version='NC_000010.11', start_position_on_the_genomic_accession=100188300, end_position_on_the_genomic_accession=100229610, orientation='minus', exon_count=23, OMIM=[600664], no_hdr0=''),
    1149 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1149, CurrentID=0, Status='live', Symbol='CIDEA', Aliases=['CIDE-A'], description='cell death inducing DFFA like effector a', other_designations='cell death activator CIDE-A', map_location='18', chromosome='18', genomic_nucleotide_accession_version='NC_000018.10', start_position_on_the_genomic_accession=12254361, end_position_on_the_genomic_accession=12277595, orientation='plus', exon_count=6, OMIM=[604440], no_hdr0=''),
    1152 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1152, CurrentID=0, Status='live', Symbol='CKB', Aliases=['B-CK', 'BCKB', 'CPK-B', 'HEL-211', 'HEL-S-29', 'CKB'], description='creatine kinase B', other_designations='creatine kinase B-type|brain creatine kinase|creatine kinase B chain|creatine kinase brain|creatine kinase brain-type|creatine phosphokinase B-type|epididymis luminal protein 211|epididymis secretory protein Li 29', map_location='14q32.33', chromosome='14', genomic_nucleotide_accession_version='NC_000014.9', start_position_on_the_genomic_accession=103519667, end_position_on_the_genomic_accession=103522833, orientation='minus', exon_count=7, OMIM=[123280], no_hdr0=''),
    1153 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1153, CurrentID=0, Status='live', Symbol='CIRBP', Aliases=['CIRP'], description='cold inducible RNA binding protein', other_designations='cold-inducible RNA-binding protein|A18 hnRNP|glycine-rich RNA binding protein|testicular tissue protein Li 39', map_location='19p13.3', chromosome='19', genomic_nucleotide_accession_version='NC_000019.10', start_position_on_the_genomic_accession=1269332, end_position_on_the_genomic_accession=1274880, orientation='plus', exon_count=7, OMIM=[602649], no_hdr0=''),
    1154 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1154, CurrentID=0, Status='live', Symbol='CISH', Aliases=['BACTS2', 'CIS', 'CIS-1', 'G18', 'SOCS'], description='cytokine inducible SH2 containing protein', other_designations='cytokine-inducible SH2-containing protein|cytokine-inducible inhibitor of signaling type 1B|suppressor of cytokine signaling', map_location='3p21.2', chromosome='3', genomic_nucleotide_accession_version='NC_000003.12', start_position_on_the_genomic_accession=50606454, end_position_on_the_genomic_accession=50611774, orientation='minus', exon_count=3, OMIM=[602441], no_hdr0=''),
    1155 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1155, CurrentID=0, Status='live', Symbol='TBCB', Aliases=['CG22', 'CKAP1', 'CKAPI'], description='tubulin folding cofactor B', other_designations='tubulin-folding cofactor B|cytoskeleton associated protein 1|cytoskeleton-associated protein CKAPI|tubulin-specific chaperone B', map_location='19q13.12', chromosome='19', genomic_nucleotide_accession_version='NC_000019.10', start_position_on_the_genomic_accession=36114967, end_position_on_the_genomic_accession=36125941, orientation='plus', exon_count=7, OMIM=[601303], no_hdr0=''),
    1158 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1158, CurrentID=0, Status='live', Symbol='CKM', Aliases=['CKMM', 'CPK-M', 'M-CK'], description='creatine kinase, M-type', other_designations='creatine kinase M-type|creatine kinase M chain|creatine kinase, muscle|creatine phosphokinase M-type', map_location='19q13.32', chromosome='19', genomic_nucleotide_accession_version='NC_000019.10', start_position_on_the_genomic_accession=45306413, end_position_on_the_genomic_accession=45322875, orientation='minus', exon_count=8, OMIM=[123310], no_hdr0=''),
    1159 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1159, CurrentID=0, Status='live', Symbol='CKMT1B', Aliases=['CKMT', 'CKMT1', 'UMTCK'], description='creatine kinase, mitochondrial 1B', other_designations='creatine kinase U-type, mitochondrial|U-MtCK|acidic-type mitochondrial creatine kinase|creatine kinase, mitochondrial 1 (ubiquitous)|mia-CK|ubiquitous mitochondrial creatine kinase', map_location='15q15.3', chromosome='15', genomic_nucleotide_accession_version='NC_000015.10', start_position_on_the_genomic_accession=43592857, end_position_on_the_genomic_accession=43599406, orientation='plus', exon_count=10, OMIM=[123290], no_hdr0=''),
    1160 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1160, CurrentID=0, Status='live', Symbol='CKMT2', Aliases=['SMTCK'], description='creatine kinase, mitochondrial 2', other_designations='creatine kinase S-type, mitochondrial|S-MtCK|basic-type mitochondrial creatine kinase|creatine kinase, mitochondrial 2 (sarcomeric)|mib-CK|sarcomeric mitochondrial creatine kinase', map_location='5q14.1', chromosome='5', genomic_nucleotide_accession_version='NC_000005.10', start_position_on_the_genomic_accession=81233322, end_position_on_the_genomic_accession=81266398, orientation='plus', exon_count=11, OMIM=[123295], no_hdr0=''),
    1161 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1161, CurrentID=0, Status='live', Symbol='ERCC8', Aliases=['CKN1', 'CSA', 'UVSS2'], description='ERCC excision repair 8, CSA ubiquitin ligase complex subunit', other_designations='DNA excision repair protein ERCC-8|Cockayne syndrome WD-repeat protein CSA|cockayne syndrome WD repeat protein CSA|excision repair cross-complementation group 8|excision repair cross-complementing rodent repair deficiency, complementation group 8', map_location='5q12.1', chromosome='5', genomic_nucleotide_accession_version='NC_000005.10', start_position_on_the_genomic_accession=60866454, end_position_on_the_genomic_accession=60945070, orientation='minus', exon_count=13, OMIM=[609412], no_hdr0=''),
    1163 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1163, CurrentID=0, Status='live', Symbol='CKS1B', Aliases=['CKS1', 'PNAS-16', 'PNAS-18', 'ckshs1'], description='CDC28 protein kinase regulatory subunit 1B', other_designations='cyclin-dependent kinases regulatory subunit 1|CDC2-associated protein CKS1|CDC28 protein kinase 1B|NB4 apoptosis/differentiation related protein|cell division control protein CKS1', map_location='1q21.3', chromosome='1', genomic_nucleotide_accession_version='NC_000001.11', start_position_on_the_genomic_accession=154974681, end_position_on_the_genomic_accession=154979251, orientation='plus', exon_count=3, OMIM=[116900], no_hdr0=''),
    1164 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1164, CurrentID=0, Status='live', Symbol='CKS2', Aliases=['CKSHS2'], description='CDC28 protein kinase regulatory subunit 2', other_designations='cyclin-dependent kinases regulatory subunit 2|CDC28 protein kinase 2|CKS-2|CKS1(S. cerevisiae Cdc28/Cdc2 kinase subunit) homolog-2', map_location='9q22.2', chromosome='9', genomic_nucleotide_accession_version='NC_000009.12', start_position_on_the_genomic_accession=89311195, end_position_on_the_genomic_accession=89316703, orientation='plus', exon_count=3, OMIM=[116901], no_hdr0=''),
    1173 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1173, CurrentID=0, Status='live', Symbol='AP2M1', Aliases=['AP50', 'CLAPM1', 'MRD60', 'mu2'], description='adaptor related protein complex 2 subunit mu 1', other_designations='AP-2 complex subunit mu|AP-2 mu 2 chain|HA2 50 kDA subunit|adaptin-mu2|adaptor protein complex AP-2 subunit mu|adaptor related protein complex 2 mu 1 subunit|adaptor-related protein complex 2 subunit mu|clathrin adaptor complex AP2, mu subunit|clathrin assembly protein complex 2 medium chain|clathrin assembly protein complex 2 mu medium chain|clathrin coat adaptor protein AP50|clathrin coat assembly protein AP50|clathrin coat-associated protein AP50|clathrin-associated/assembly/adaptor protein, medium 1|plasma membrane adaptor AP-2 50 kDa protein|plasma membrane adaptor AP-2 50kDA protein', map_location='3q27.1', chromosome='3', genomic_nucleotide_accession_version='NC_000003.12', start_position_on_the_genomic_accession=184174855, end_position_on_the_genomic_accession=184184091, orientation='plus', exon_count=14, OMIM=[601024], no_hdr0=''),
    1174 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1174, CurrentID=0, Status='live', Symbol='AP1S1', Aliases=['AP19', 'CLAPS1', 'EKV3', 'MEDNIK', 'SIGMA1A'], description='adaptor related protein complex 1 subunit sigma 1', other_designations='AP-1 complex subunit sigma-1A|HA1 19 kDa subunit|adapter-related protein complex 1 sigma-1A subunit|adaptor protein complex AP-1 subunit sigma-1A|adaptor related protein complex 1 sigma 1 subunit|adaptor-related protein complex 1 subunit sigma-1A|clathrin assembly protein complex 1 sigma-1A small chain|clathrin coat assembly protein AP19|clathrin-associated/assembly/adaptor protein, small 1 (19kD)|golgi adaptor HA1/AP1 adaptin sigma-1A subunit|sigma1A subunit of AP-1 clathrin adaptor complex|sigma1A-adaptin', map_location='7q22.1', chromosome='7', genomic_nucleotide_accession_version='NC_000007.14', start_position_on_the_genomic_accession=101154476, end_position_on_the_genomic_accession=101161276, orientation='plus', exon_count=5, OMIM=[603531], no_hdr0=''),
    1175 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1175, CurrentID=0, Status='live', Symbol='AP2S1', Aliases=['AP17', 'CLAPS2', 'FBH3', 'FBHOk', 'HHC3'], description='adaptor related protein complex 2 subunit sigma 1', other_designations='AP-2 complex subunit sigma|HA2 17 kDa subunit|adaptor protein complex AP-2 subunit sigma|adaptor related protein complex 2 sigma 1 subunit|clathrin assembly protein 2 sigma small chain|clathrin coat assembly protein AP17|clathrin coat-associated protein AP17|clathrin-associated/assembly/adaptor protein, small 2 (17kD)|plasma membrane adaptor AP-2 17 kDa protein|sigma2-adaptin', map_location='19q13.32', chromosome='19', genomic_nucleotide_accession_version='NC_000019.10', start_position_on_the_genomic_accession=46838167, end_position_on_the_genomic_accession=46850846, orientation='minus', exon_count=7, OMIM=[602242], no_hdr0=''),
    1176 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1176, CurrentID=0, Status='live', Symbol='AP3S1', Aliases=['CLAPS3', 'Sigma3A'], description='adaptor related protein complex 3 subunit sigma 1', other_designations='AP-3 complex subunit sigma-1|adapter-related protein complex 3 subunit sigma-1|adaptor related protein complex 3 sigma 1 subunit|clathrin adaptor complex AP3, sigma-3A subunit|clathrin-associated/assembly/adapter protein, small 3|clathrin-associated/assembly/adaptor protein, small 3 (22kD)|sigma-adaptin 3a', map_location='5q22.3-q23.1', chromosome='5', genomic_nucleotide_accession_version='NC_000005.10', start_position_on_the_genomic_accession=115841606, end_position_on_the_genomic_accession=115914081, orientation='plus', exon_count=11, OMIM=[601507], no_hdr0=''),
    1178 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1178, CurrentID=0, Status='live', Symbol='CLC', Aliases=['GAL10', 'Gal-10', 'LGALS10', 'LGALS10A', 'LPPL_HUMAN'], description='Charcot-Leyden crystal galectin', other_designations='galectin-10|Charcot-Leyden crystal protein|eosinophil lysophospholipase|lectin, galactoside-binding, soluble, 10|lysolecithin acylhydrolase', map_location='19q13.2', chromosome='19', genomic_nucleotide_accession_version='NC_000019.10', start_position_on_the_genomic_accession=39731255, end_position_on_the_genomic_accession=39738029, orientation='minus', exon_count=4, OMIM=[153310], no_hdr0=''),
    1179 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1179, CurrentID=0, Status='live', Symbol='CLCA1', Aliases=['CACC', 'CACC1', 'CLCRG1', 'CaCC-1', 'GOB5', 'hCLCA1', 'hCaCC-1'], description='chloride channel accessory 1', other_designations='calcium-activated chloride channel regulator 1|CLCA family member 1, chloride channel regulator|calcium-activated chloride channel family member 1|calcium-activated chloride channel protein 1|calcium-dependent chloride channel-1|chloride channel regulator 1|chloride channel, calcium activated, family member 1', map_location='1p22.3', chromosome='1', genomic_nucleotide_accession_version='NC_000001.11', start_position_on_the_genomic_accession=86468927, end_position_on_the_genomic_accession=86500259, orientation='plus', exon_count=14, OMIM=[603906], no_hdr0=''),
    1180 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1180, CurrentID=0, Status='live', Symbol='CLCN1', Aliases=['CLC1'], description='chloride voltage-gated channel 1', other_designations='chloride channel protein 1|chloride channel 1, skeletal muscle|chloride channel protein, skeletal muscle|chloride channel, voltage-sensitive 1|clC-1', map_location='7q34', chromosome='7', genomic_nucleotide_accession_version='NC_000007.14', start_position_on_the_genomic_accession=143316111, end_position_on_the_genomic_accession=143352083, orientation='plus', exon_count=23, OMIM=[118425], no_hdr0=''),
    1181 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1181, CurrentID=0, Status='live', Symbol='CLCN2', Aliases=['CIC-2', 'CLC2', 'ECA2', 'ECA3', 'EGI11', 'EGI3', 'EGMA', 'EJM6', 'EJM8', 'HALD2', 'LKPAT', 'clC-2'], description='chloride voltage-gated channel 2', other_designations='chloride channel protein 2|chloride channel 2|chloride channel, voltage-sensitive 2', map_location='3q27.1', chromosome='3', genomic_nucleotide_accession_version='NC_000003.12', start_position_on_the_genomic_accession=184346185, end_position_on_the_genomic_accession=184361605, orientation='minus', exon_count=25, OMIM=[600570], no_hdr0=''),
    1182 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1182, CurrentID=0, Status='live', Symbol='CLCN3', Aliases=['CLC3', 'ClC-3'], description='chloride voltage-gated channel 3', other_designations='H(+)/Cl(-) exchange transporter 3|chloride channel 3|chloride channel protein 3|chloride channel, voltage-sensitive 3|chloride transporter ClC-3', map_location='4q33', chromosome='4', genomic_nucleotide_accession_version='NC_000004.12', start_position_on_the_genomic_accession=169620578, end_position_on_the_genomic_accession=169723673, orientation='plus', exon_count=16, OMIM=[600580], no_hdr0=''),
    1183 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1183, CurrentID=0, Status='live', Symbol='CLCN4', Aliases=['CLC4', 'ClC-4', 'ClC-4A', 'MRX15', 'MRX49', 'MRXSRC'], description='chloride voltage-gated channel 4', other_designations='H(+)/Cl(-) exchange transporter 4|chloride channel 4|chloride channel protein 4|chloride channel, voltage-sensitive 4|chloride transporter ClC-4', map_location='Xp22.2', chromosome='X', genomic_nucleotide_accession_version='NC_000023.11', start_position_on_the_genomic_accession=10156975, end_position_on_the_genomic_accession=10237660, orientation='plus', exon_count=13, OMIM=[302910], no_hdr0=''),
    1184 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1184, CurrentID=0, Status='live', Symbol='CLCN5', Aliases=['CLC5', 'CLCK2', 'ClC-5', 'DENTS', 'NPHL1', 'NPHL2', 'XLRH', 'XRN', 'hCIC-K2'], description='chloride voltage-gated channel 5', other_designations='H(+)/Cl(-) exchange transporter 5|chloride channel, voltage-sensitive 5|chloride transporter ClC-5|voltage-gated chloride ion channel CLCN5', map_location='Xp11.23', chromosome='X', genomic_nucleotide_accession_version='NC_000023.11', start_position_on_the_genomic_accession=49922596, end_position_on_the_genomic_accession=50099231, orientation='plus', exon_count=17, OMIM=[300008], no_hdr0=''),
    1185 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1185, CurrentID=0, Status='live', Symbol='CLCN6', Aliases=['CLC-6'], description='chloride voltage-gated channel 6', other_designations='chloride transport protein 6|chloride channel, voltage-sensitive 6', map_location='1p36.22', chromosome='1', genomic_nucleotide_accession_version='NC_000001.11', start_position_on_the_genomic_accession=11806191, end_position_on_the_genomic_accession=11843130, orientation='plus', exon_count=23, OMIM=[602726], no_hdr0=''),
    1186 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1186, CurrentID=0, Status='live', Symbol='CLCN7', Aliases=['CLC-7', 'CLC7', 'HOD', 'OPTA2', 'OPTB4', 'PPP1R63'], description='chloride voltage-gated channel 7', other_designations='H(+)/Cl(-) exchange transporter 7|chloride channel 7 alpha subunit|chloride channel protein 7|chloride channel, voltage-sensitive 7|protein phosphatase 1, regulatory subunit 63', map_location='16p13.3', chromosome='16', genomic_nucleotide_accession_version='NC_000016.10', start_position_on_the_genomic_accession=1444935, end_position_on_the_genomic_accession=1475028, orientation='minus', exon_count=26, OMIM=[602727], no_hdr0=''),
    1187 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1187, CurrentID=0, Status='live', Symbol='CLCNKA', Aliases=['CLCK1', 'ClC-K1', 'hClC-Ka'], description='chloride voltage-gated channel Ka', other_designations='chloride channel protein ClC-Ka|chloride channel Ka|chloride channel, kidney, A|chloride channel, voltage-sensitive Ka', map_location='1p36.13', chromosome='1', genomic_nucleotide_accession_version='NC_000001.11', start_position_on_the_genomic_accession=16022036, end_position_on_the_genomic_accession=16034050, orientation='plus', exon_count=20, OMIM=[602024], no_hdr0=''),
    1188 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1188, CurrentID=0, Status='live', Symbol='CLCNKB', Aliases=['CLCKB', 'ClC-K2', 'ClC-Kb'], description='chloride voltage-gated channel Kb', other_designations='chloride channel protein ClC-Kb|chloride channel, kidney, B|chloride channel, voltage-sensitive Kb', map_location='1p36.13', chromosome='1', genomic_nucleotide_accession_version='NC_000001.11', start_position_on_the_genomic_accession=16043782, end_position_on_the_genomic_accession=16057326, orientation='plus', exon_count=20, OMIM=[602023], no_hdr0=''),
    1191 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1191, CurrentID=0, Status='live', Symbol='CLU', Aliases=['AAG4', 'APO-J', 'APOJ', 'CLI1', 'CLU2', 'KUB1', 'NA1/NA2', 'SGP-2', 'SGP2', 'SP-40', 'TRPM-2', 'TRPM2', 'CLU'], description='clusterin', other_designations='clusterin|aging-associated protein 4|apolipoprotein J|complement cytolysis inhibitor|complement lysis inhibitor|complement-associated protein SP-40,40|epididymis secretory sperm binding protein|ku70-binding protein 1|sulfated glycoprotein 2|testosterone-repressed prostate message 2', map_location='8p21.1', chromosome='8', genomic_nucleotide_accession_version='NC_000008.11', start_position_on_the_genomic_accession=27596917, end_position_on_the_genomic_accession=27614700, orientation='minus', exon_count=11, OMIM=[185430], no_hdr0=''),
    1192 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1192, CurrentID=0, Status='live', Symbol='CLIC1', Aliases=['CL1C1', 'CLCNL1', 'G6', 'NCC27'], description='chloride intracellular channel 1', other_designations='chloride intracellular channel protein 1|RNCC protein|chloride channel ABP|hRNCC|nuclear chloride ion channel 27|nuclear chloride ion channel protein|p64CLCP|regulatory nuclear chloride ion channel protein', map_location='6p21.33', chromosome='6', genomic_nucleotide_accession_version='NC_000006.12', start_position_on_the_genomic_accession=31730581, end_position_on_the_genomic_accession=31737318, orientation='minus', exon_count=7, OMIM=[602872], no_hdr0=''),
    1193 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1193, CurrentID=0, Status='live', Symbol='CLIC2', Aliases=['CLCNL2b', 'MRXS32', 'XAP121', 'CLIC2'], description='chloride intracellular channel 2', other_designations='chloride intracellular channel protein 2', map_location='Xq28', chromosome='X', genomic_nucleotide_accession_version='NC_000023.11', start_position_on_the_genomic_accession=155276211, end_position_on_the_genomic_accession=155334614, orientation='minus', exon_count=6, OMIM=[300138], no_hdr0=''),
    1195 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1195, CurrentID=0, Status='live', Symbol='CLK1', Aliases=['CLK', 'CLK/STY', 'STY'], description='CDC like kinase 1', other_designations='dual specificity protein kinase CLK1|CDC28/CDC2-like kinase|protein tyrosine kinase STY', map_location='2q33.1', chromosome='2', genomic_nucleotide_accession_version='NC_000002.12', start_position_on_the_genomic_accession=200853009, end_position_on_the_genomic_accession=200864658, orientation='minus', exon_count=14, OMIM=[601951], no_hdr0=''),
    1196 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1196, CurrentID=0, Status='live', Symbol='CLK2', Aliases=[], description='CDC like kinase 2', other_designations='dual specificity protein kinase CLK2|CLK kinase', map_location='1q22', chromosome='1', genomic_nucleotide_accession_version='NC_000001.11', start_position_on_the_genomic_accession=155262868, end_position_on_the_genomic_accession=155273504, orientation='minus', exon_count=13, OMIM=[602989], no_hdr0=''),
    1198 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1198, CurrentID=0, Status='live', Symbol='CLK3', Aliases=['PHCLK3', 'PHCLK3/152'], description='CDC like kinase 3', other_designations='dual specificity protein kinase CLK3', map_location='15q24.1', chromosome='15', genomic_nucleotide_accession_version='NC_000015.10', start_position_on_the_genomic_accession=74608372, end_position_on_the_genomic_accession=74630201, orientation='plus', exon_count=14, OMIM=[602990], no_hdr0=''),
    1200 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1200, CurrentID=0, Status='live', Symbol='TPP1', Aliases=['CLN2', 'GIG1', 'LPIC', 'SCAR7', 'TPP-1'], description='tripeptidyl peptidase 1', other_designations='tripeptidyl-peptidase 1|cell growth-inhibiting gene 1 protein|growth-inhibiting protein 1|lysosomal pepstatin insensitive protease|lysosomal pepstatin-insensitive carboxypeptidase|tripeptidyl aminopeptidase|tripeptidyl peptidase I', map_location='11p15.4', chromosome='11', genomic_nucleotide_accession_version='NC_000011.10', start_position_on_the_genomic_accession=6612768, end_position_on_the_genomic_accession=6619422, orientation='minus', exon_count=13, OMIM=[607998], no_hdr0=''),
    1201 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1201, CurrentID=0, Status='live', Symbol='CLN3', Aliases=['BTN1', 'BTS', 'JNCL'], description='CLN3 lysosomal/endosomal transmembrane protein, battenin', other_designations='battenin|CLN3, battenin|batten disease protein|ceroid-lipofuscinosis, neuronal 3', map_location='16p12.1', chromosome='16', genomic_nucleotide_accession_version='NC_000016.10', start_position_on_the_genomic_accession=28466653, end_position_on_the_genomic_accession=28492082, orientation='minus', exon_count=16, OMIM=[607042], no_hdr0=''),
    1203 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1203, CurrentID=0, Status='live', Symbol='CLN5', Aliases=[], description='CLN5 intracellular trafficking protein', other_designations='ceroid-lipofuscinosis neuronal protein 5|ceroid-lipofuscinosis, neuronal 5', map_location='13q22.3', chromosome='13', genomic_nucleotide_accession_version='NC_000013.11', start_position_on_the_genomic_accession=76992081, end_position_on_the_genomic_accession=77005117, orientation='plus', exon_count=5, OMIM=[608102], no_hdr0=''),
    1207 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1207, CurrentID=0, Status='live', Symbol='CLNS1A', Aliases=['CLCI', 'CLNS1B', 'ICln'], description='chloride nucleotide-sensitive channel 1A', other_designations='methylosome subunit pICln|chloride channel regulatory protein|chloride channel, nucleotide sensitive 1A|chloride conductance regulatory protein ICln|chloride ion current inducer protein|i(Cln)|reticulocyte pICln|reticulocyte protein ICln', map_location='11q14.1', chromosome='11', genomic_nucleotide_accession_version='NC_000011.10', start_position_on_the_genomic_accession=77614530, end_position_on_the_genomic_accession=77637794, orientation='minus', exon_count=8, OMIM=[602158], no_hdr0=''),
    1208 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1208, CurrentID=0, Status='live', Symbol='CLPS', Aliases=[], description='colipase', other_designations='colipase|colipase, pancreatic|pancreatic colipase preproprotein', map_location='6p21.31', chromosome='6', genomic_nucleotide_accession_version='NC_000006.12', start_position_on_the_genomic_accession=35794982, end_position_on_the_genomic_accession=35797323, orientation='minus', exon_count=4, OMIM=[120105], no_hdr0=''),
    1209 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1209, CurrentID=0, Status='live', Symbol='CLPTM1', Aliases=[], description='CLPTM1 regulator of GABA type A receptor forward trafficking', other_designations='cleft lip and palate transmembrane protein 1|CLPTM1, transmembrane protein|cleft lip and palate associated transmembrane protein 1', map_location='19q13.32', chromosome='19', genomic_nucleotide_accession_version='NC_000019.10', start_position_on_the_genomic_accession=44954585, end_position_on_the_genomic_accession=44993341, orientation='plus', exon_count=16, OMIM=[604783], no_hdr0=''),
    1211 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1211, CurrentID=0, Status='live', Symbol='CLTA', Aliases=['LCA'], description='clathrin light chain A', other_designations='clathrin light chain A|clathrin, light polypeptide (Lca)', map_location='9p13.3', chromosome='9', genomic_nucleotide_accession_version='NC_000009.12', start_position_on_the_genomic_accession=36190855, end_position_on_the_genomic_accession=36212059, orientation='plus', exon_count=8, OMIM=[118960], no_hdr0=''),
    1212 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1212, CurrentID=0, Status='live', Symbol='CLTB', Aliases=['LCB'], description='clathrin light chain B', other_designations='clathrin light chain B|clathrin, light chain (Lcb)|clathrin, light polypeptide (Lcb)', map_location='5q35.2', chromosome='5', genomic_nucleotide_accession_version='NC_000005.10', start_position_on_the_genomic_accession=176392455, end_position_on_the_genomic_accession=176416569, orientation='minus', exon_count=9, OMIM=[118970], no_hdr0=''),
    1213 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1213, CurrentID=0, Status='live', Symbol='CLTC', Aliases=['CHC', 'CHC17', 'CLH-17L2', 'Hc', 'MRD56', 'CLTC'], description='clathrin heavy chain', other_designations='clathrin heavy chain 1|clathrin heavy chain on chromosome 17|clathrin, heavy polypeptide (Hc)|clathrin, heavy polypeptide-like 2', map_location='17q23.1', chromosome='17', genomic_nucleotide_accession_version='NC_000017.11', start_position_on_the_genomic_accession=59619895, end_position_on_the_genomic_accession=59696956, orientation='plus', exon_count=32, OMIM=[118955], no_hdr0=''),
    1215 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1215, CurrentID=0, Status='live', Symbol='CMA1', Aliases=['CYH', 'MCT1', 'chymase'], description='chymase 1', other_designations='chymase|alpha-chymase|chymase 1 preproprotein transcript E|chymase 1 preproprotein transcript I|chymase 1, mast cell|chymase, heart|chymase, mast cell|mast cell protease I', map_location='14q12', chromosome='14', genomic_nucleotide_accession_version='NC_000014.9', start_position_on_the_genomic_accession=24505353, end_position_on_the_genomic_accession=24508265, orientation='minus', exon_count=5, OMIM=[118938], no_hdr0=''),
    1230 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1230, CurrentID=0, Status='live', Symbol='CCR1', Aliases=['CD191', 'CKR-1', 'CKR1', 'CMKBR1', 'HM145', 'MIP1aR', 'SCYAR1'], description='C-C motif chemokine receptor 1', other_designations='C-C chemokine receptor type 1|C-C CKR-1|CC-CKR-1|CCR-1|LD78 receptor|MIP-1alpha-R|RANTES receptor|RANTES-R|chemokine (C-C motif) receptor 1|macrophage inflammatory protein 1-alpha receptor', map_location='3p21.31', chromosome='3', genomic_nucleotide_accession_version='NC_000003.12', start_position_on_the_genomic_accession=46201711, end_position_on_the_genomic_accession=46208313, orientation='minus', exon_count=2, OMIM=[601159], no_hdr0=''),
    1232 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1232, CurrentID=0, Status='live', Symbol='CCR3', Aliases=['C C CKR3', 'CC-CKR-3', 'CD193', 'CKR 3', 'CKR3', 'CMKBR3'], description='C-C motif chemokine receptor 3', other_designations='C-C chemokine receptor type 3|C-C CKR-3|CC chemokine receptor 3|CCR-3|b-chemokine receptor|chemokine (C-C motif) receptor 3|eosinophil CC chemokine receptor 3|eosinophil eotaxin receptor', map_location='3p21.31', chromosome='3', genomic_nucleotide_accession_version='NC_000003.12', start_position_on_the_genomic_accession=46210699, end_position_on_the_genomic_accession=46266706, orientation='plus', exon_count=6, OMIM=[601268], no_hdr0=''),
    1233 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1233, CurrentID=0, Status='live', Symbol='CCR4', Aliases=['CC-CKR-4', 'CD194', 'CKR4', 'CMKBR4', 'ChemR13', 'HGCN:14099', 'K5-5'], description='C-C motif chemokine receptor 4', other_designations='C-C chemokine receptor type 4|C-C CKR-4|CCR-4|chemokine (C-C motif) receptor 4|chemokine (C-C) receptor 4', map_location='3p22.3', chromosome='3', genomic_nucleotide_accession_version='NC_000003.12', start_position_on_the_genomic_accession=32951555, end_position_on_the_genomic_accession=32956349, orientation='plus', exon_count=2, OMIM=[604836], no_hdr0=''),
    1234 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1234, CurrentID=0, Status='live', Symbol='CCR5', Aliases=['CC-CKR-5', 'CCCKR5', 'CCR-5', 'CD195', 'CKR-5', 'CKR5', 'CMKBR5', 'IDDM22'], description='C-C motif chemokine receptor 5', other_designations='C-C chemokine receptor type 5|C-C motif chemokine receptor 5 A159A|HIV-1 fusion coreceptor|chemokine (C-C motif) receptor 5|chemokine receptor CCR5|chemokine recptor CCR5 Delta32|chemr13', map_location='3p21.31', chromosome='3', genomic_nucleotide_accession_version='NC_000003.12', start_position_on_the_genomic_accession=46370142, end_position_on_the_genomic_accession=46376206, orientation='plus', exon_count=3, OMIM=[601373], no_hdr0=''),
    1235 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1235, CurrentID=0, Status='live', Symbol='CCR6', Aliases=['BN-1', 'C-C CKR-6', 'CC-CKR-6', 'CCR-6', 'CD196', 'CKR-L3', 'CKRL3', 'CMKBR6', 'DCR2', 'DRY6', 'GPR29', 'GPRCY4', 'STRL22'], description='C-C motif chemokine receptor 6', other_designations='C-C chemokine receptor type 6|G protein-coupled receptor 29|LARC receptor|chemokine (C-C motif) receptor 6|chemokine (C-C) receptor 6|chemokine receptor-like 3|seven-transmembrane receptor, lymphocyte, 22', map_location='6q27', chromosome='6', genomic_nucleotide_accession_version='NC_000006.12', start_position_on_the_genomic_accession=167111795, end_position_on_the_genomic_accession=167139141, orientation='plus', exon_count=4, OMIM=[601835], no_hdr0=''),
    1236 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1236, CurrentID=0, Status='live', Symbol='CCR7', Aliases=['BLR2', 'CC-CKR-7', 'CCR-7', 'CD197', 'CDw197', 'CMKBR7', 'EBI1'], description='C-C motif chemokine receptor 7', other_designations="C-C chemokine receptor type 7|Bukitt's lymphoma receptor 2|CC chemokine receptor 7|EBV-induced G protein-coupled receptor 1|Epstein-Barr virus induced gene 1|Epstein-Barr virus-induced G-protein coupled receptor 1|MIP-3 beta receptor|chemokine (C-C motif) receptor 7|lymphocyte-specific G protein-coupled peptide receptor", map_location='17q21.2', chromosome='17', genomic_nucleotide_accession_version='NC_000017.11', start_position_on_the_genomic_accession=40553769, end_position_on_the_genomic_accession=40565472, orientation='minus', exon_count=5, OMIM=[600242], no_hdr0=''),
    1237 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1237, CurrentID=0, Status='live', Symbol='CCR8', Aliases=['CC-CKR-8', 'CCR-8', 'CDw198', 'CKRL1', 'CMKBR8', 'CMKBRL2', 'CY6', 'GPRCY6', 'TER1'], description='C-C motif chemokine receptor 8', other_designations='C-C chemokine receptor type 8|CC chemokine receptor 8|CC chemokine receptor CHEMR1|CC-chemokine receptor chemr1|chemokine (C-C motif) receptor 8|chemokine (C-C) receptor 8|chemokine (C-C) receptor-like 2|chemokine receptor-like 1', map_location='3p22.1', chromosome='3', genomic_nucleotide_accession_version='NC_000003.12', start_position_on_the_genomic_accession=39329709, end_position_on_the_genomic_accession=39333680, orientation='plus', exon_count=2, OMIM=[601834], no_hdr0=''),
    1238 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1238, CurrentID=0, Status='live', Symbol='ACKR2', Aliases=['CCBP2', 'CCR10', 'CCR9', 'CMKBR9', 'D6', 'hD6'], description='atypical chemokine receptor 2', other_designations='atypical chemokine receptor 2|C-C chemokine receptor D6|CC-chemokine-binding receptor JAB61|chemokine (C-C motif) receptor 9|chemokine (C-C) receptor 9|chemokine receptor CCR-10|chemokine receptor CCR-9|chemokine receptor D6|chemokine-binding protein 2|chemokine-binding protein D6', map_location='3p22.1', chromosome='3', genomic_nucleotide_accession_version='NC_000003.12', start_position_on_the_genomic_accession=42809445, end_position_on_the_genomic_accession=42867286, orientation='plus', exon_count=3, OMIM=[602648], no_hdr0=''),
    1240 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1240, CurrentID=0, Status='live', Symbol='CMKLR1', Aliases=['CHEMERINR', 'ChemR23', 'DEZ', 'RVER1'], description='chemerin chemokine-like receptor 1', other_designations='chemokine-like receptor 1|G-protein coupled receptor ChemR23|G-protein coupled receptor DEZ|chemerin receptor|chemokine receptor-like 1|orphan G-protein coupled receptor, Dez|resolvin E1 receptor', map_location='12q23.3', chromosome='12', genomic_nucleotide_accession_version='NC_000012.12', start_position_on_the_genomic_accession=108288044, end_position_on_the_genomic_accession=108339347, orientation='minus', exon_count=5, OMIM=[602351], no_hdr0=''),
    1241 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1241, CurrentID=0, Status='live', Symbol='LTB4R', Aliases=['BLT1', 'BLTR', 'CMKRL1', 'GPR161', 'LTBR1', 'P2RY7', 'P2Y7', 'LTB4R'], description='leukotriene B4 receptor', other_designations='leukotriene B4 receptor 1|G protein-coupled receptor 16|LTB4-R 1|LTB4-R1|P2Y purinoceptor 7|chemoattractant receptor-like 1|chemokine receptor-like 1|purinergic receptor P2Y, G-protein coupled, 7', map_location='14q12', chromosome='14', genomic_nucleotide_accession_version='NC_000014.9', start_position_on_the_genomic_accession=24311502, end_position_on_the_genomic_accession=24318036, orientation='plus', exon_count=3, OMIM=[601531], no_hdr0=''),
    1244 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1244, CurrentID=0, Status='live', Symbol='ABCC2', Aliases=['ABC30', 'CMOAT', 'DJS', 'MRP2', 'cMRP'], description='ATP binding cassette subfamily C member 2', other_designations='canalicular multispecific organic anion transporter 1|ATP-binding cassette, sub-family C (CFTR/MRP), member 2|canalicular multidrug resistance protein|multidrug resistance-associated protein 2', map_location='10q24.2', chromosome='10', genomic_nucleotide_accession_version='NC_000010.11', start_position_on_the_genomic_accession=99782602, end_position_on_the_genomic_accession=99853741, orientation='plus', exon_count=34, OMIM=[601107], no_hdr0=''),
    1258 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1258, CurrentID=0, Status='live', Symbol='CNGB1', Aliases=['CNCG2', 'CNCG3L', 'CNCG4', 'CNG4B', 'GAR1', 'GARP', 'GARP2', 'RCNC2', 'RCNCb', 'RCNCbeta', 'RP45', 'CNGB1'], description='cyclic nucleotide gated channel subunit beta 1', other_designations='cyclic nucleotide-gated cation channel beta-1|CNG channel beta-1|CNG-4|cyclic nucleotide gated channel beta 1|cyclic nucleotide-gated cation channel 4|cyclic nucleotide-gated cation channel gamma|cyclic nucleotide-gated cation channel modulatory subunit|glutamic-acid-rich protein', map_location='16q21', chromosome='16', genomic_nucleotide_accession_version='NC_000016.10', start_position_on_the_genomic_accession=57882340, end_position_on_the_genomic_accession=57971128, orientation='minus', exon_count=36, OMIM=[600724], no_hdr0=''),
    1259 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1259, CurrentID=0, Status='live', Symbol='CNGA1', Aliases=['CNCG', 'CNCG1', 'CNG-1', 'CNG1', 'RCNC1', 'RCNCa', 'RCNCalpha', 'RP49'], description='cyclic nucleotide gated channel subunit alpha 1', other_designations='cGMP-gated cation channel alpha-1|CNG channel alpha-1|cyclic nucleotide gated channel alpha 1|cyclic nucleotide-gated cation channel 1|cyclic nucleotide-gated channel, photoreceptor|interleukin-1 homologue|rod photoreceptor cGMP-gated channel subunit alpha', map_location='4p12', chromosome='4', genomic_nucleotide_accession_version='NC_000004.12', start_position_on_the_genomic_accession=47935015, end_position_on_the_genomic_accession=48016718, orientation='minus', exon_count=13, OMIM=[123825], no_hdr0=''),
    1260 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1260, CurrentID=0, Status='live', Symbol='CNGA2', Aliases=['CNCA', 'CNCA1', 'CNG2', 'OCNC1', 'OCNCALPHA', 'OCNCa'], description='cyclic nucleotide gated channel subunit alpha 2', other_designations='cyclic nucleotide-gated olfactory channel|CNG channel alpha-2|cyclic nucleotide gated channel alpha 2|cyclic-nucleotide-gated cation channel 2', map_location='Xq28', chromosome='X', genomic_nucleotide_accession_version='NC_000023.11', start_position_on_the_genomic_accession=151734746, end_position_on_the_genomic_accession=151745564, orientation='plus', exon_count=7, OMIM=[300338], no_hdr0=''),
    1261 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1261, CurrentID=0, Status='live', Symbol='CNGA3', Aliases=['ACHM2', 'CCNC1', 'CCNCa', 'CCNCalpha', 'CNCG3', 'CNG3'], description='cyclic nucleotide gated channel subunit alpha 3', other_designations='cyclic nucleotide-gated cation channel alpha-3|CNG channel alpha-3|CNG-3|cone photoreceptor cGMP-gated channel alpha subunit|cone photoreceptor cGMP-gated channel subunit alpha|cyclic nucleotide gated channel alpha 3', map_location='2q11.2', chromosome='2', genomic_nucleotide_accession_version='NC_000002.12', start_position_on_the_genomic_accession=98346181, end_position_on_the_genomic_accession=98399154, orientation='plus', exon_count=9, OMIM=[600053], no_hdr0=''),
    1262 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1262, CurrentID=0, Status='live', Symbol='CNGA4', Aliases=['CNCA2', 'CNG-4', 'CNG4', 'CNG5', 'CNGB2', 'OCNC2', 'OCNCBETA', 'OCNCb'], description='cyclic nucleotide gated channel subunit alpha 4', other_designations='cyclic nucleotide-gated cation channel alpha-4|CNG channel alpha-4|cyclic nucleotide gated channel alpha 4|cyclic nucleotide gated channel beta 2', map_location='11p15.4', chromosome='11', genomic_nucleotide_accession_version='NC_000011.10', start_position_on_the_genomic_accession=6234713, end_position_on_the_genomic_accession=6245924, orientation='plus', exon_count=7, OMIM=[609472], no_hdr0=''),
    1263 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1263, CurrentID=0, Status='live', Symbol='PLK3', Aliases=['CNK', 'FNK', 'PLK-3', 'PRK'], description='polo like kinase 3', other_designations='serine/threonine-protein kinase PLK3|FGF-inducible kinase|cytokine-inducible serine/threonine-protein kinase|proliferation-related kinase', map_location='1p34.1', chromosome='1', genomic_nucleotide_accession_version='NC_000001.11', start_position_on_the_genomic_accession=44799952, end_position_on_the_genomic_accession=44805995, orientation='plus', exon_count=15, OMIM=[602913], no_hdr0=''),
    1264 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1264, CurrentID=0, Status='live', Symbol='CNN1', Aliases=['HEL-S-14', 'SMCC', 'Sm-Calp'], description='calponin 1', other_designations='calponin-1|basic calponin|calponin 1, basic, smooth muscle|calponin H1, smooth muscle|calponins, basic|epididymis secretory protein Li 14', map_location='19p13.2', chromosome='19', genomic_nucleotide_accession_version='NC_000019.10', start_position_on_the_genomic_accession=11538775, end_position_on_the_genomic_accession=11550323, orientation='plus', exon_count=10, OMIM=[600806], no_hdr0=''),
    1265 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1265, CurrentID=0, Status='live', Symbol='CNN2', Aliases=[], description='calponin 2', other_designations='calponin-2|calponin H2, smooth muscle|neutral calponin', map_location='19p13.3', chromosome='19', genomic_nucleotide_accession_version='NC_000019.10', start_position_on_the_genomic_accession=1026608, end_position_on_the_genomic_accession=1039065, orientation='plus', exon_count=7, OMIM=[602373], no_hdr0=''),
    1266 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1266, CurrentID=0, Status='live', Symbol='CNN3', Aliases=[], description='calponin 3', other_designations='calponin-3|calponin 3, acidic|dJ639P13.2.2 (acidic calponin 3)', map_location='1p21.3', chromosome='1', genomic_nucleotide_accession_version='NC_000001.11', start_position_on_the_genomic_accession=94896957, end_position_on_the_genomic_accession=94927110, orientation='minus', exon_count=10, OMIM=[602374], no_hdr0=''),
    1267 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1267, CurrentID=0, Status='live', Symbol='CNP', Aliases=['CNP1'], description="2',3'-cyclic nucleotide 3' phosphodiesterase", other_designations="2',3'-cyclic-nucleotide 3'-phosphodiesterase|2', 3' cyclic nucleotide 3' phosphohydrolase|CNPase", map_location='17q21.2', chromosome='17', genomic_nucleotide_accession_version='NC_000017.11', start_position_on_the_genomic_accession=41966795, end_position_on_the_genomic_accession=41977740, orientation='plus', exon_count=5, OMIM=[123830], no_hdr0=''),
    1268 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1268, CurrentID=0, Status='live', Symbol='CNR1', Aliases=['CANN6', 'CB-R', 'CB1', 'CB1A', 'CB1K5', 'CB1R', 'CNR'], description='cannabinoid receptor 1', other_designations='cannabinoid receptor 1|cannabinoid receptor 1 (brain)|central cannabinoid receptor', map_location='6q15', chromosome='6', genomic_nucleotide_accession_version='NC_000006.12', start_position_on_the_genomic_accession=88139864, end_position_on_the_genomic_accession=88167349, orientation='minus', exon_count=8, OMIM=[114610], no_hdr0=''),
    1269 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1269, CurrentID=0, Status='live', Symbol='CNR2', Aliases=['CB-2', 'CB2', 'CX5'], description='cannabinoid receptor 2', other_designations='cannabinoid receptor 2|cannabinoid receptor 2 (macrophage)', map_location='1p36.11', chromosome='1', genomic_nucleotide_accession_version='NC_000001.11', start_position_on_the_genomic_accession=23870515, end_position_on_the_genomic_accession=23913362, orientation='minus', exon_count=6, OMIM=[605051], no_hdr0=''),
    1270 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1270, CurrentID=0, Status='live', Symbol='CNTF', Aliases=['HCNTF'], description='ciliary neurotrophic factor', other_designations='ciliary neurotrophic factor|Ciliary Neuronotrophic Factor', map_location='11q12.1', chromosome='11', genomic_nucleotide_accession_version='NC_000011.10', start_position_on_the_genomic_accession=58622665, end_position_on_the_genomic_accession=58625733, orientation='plus', exon_count=2, OMIM=[118945], no_hdr0=''),
    1271 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1271, CurrentID=0, Status='live', Symbol='CNTFR', Aliases=[], description='ciliary neurotrophic factor receptor', other_designations='ciliary neurotrophic factor receptor subunit alpha|CNTF receptor subunit alpha|CNTFR-alpha', map_location='9p13.3', chromosome='9', genomic_nucleotide_accession_version='NC_000009.12', start_position_on_the_genomic_accession=34551432, end_position_on_the_genomic_accession=34590386, orientation='minus', exon_count=14, OMIM=[118946], no_hdr0=''),
    1272 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1272, CurrentID=0, Status='live', Symbol='CNTN1', Aliases=['F3', 'GP135', 'MYPCN'], description='contactin 1', other_designations='contactin-1|glycoprotein gP135|neural cell surface protein F3', map_location='12q12', chromosome='12', genomic_nucleotide_accession_version='NC_000012.12', start_position_on_the_genomic_accession=40692429, end_position_on_the_genomic_accession=41072415, orientation='plus', exon_count=29, OMIM=[600016], no_hdr0=''),
    1277 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1277, CurrentID=0, Status='live', Symbol='COL1A1', Aliases=['CAFYD', 'EDSARTH1', 'EDSC', 'OI1', 'OI2', 'OI3', 'OI4'], description='collagen type I alpha 1 chain', other_designations='collagen alpha-1(I) chain|alpha-1 type I collagen|alpha1(I) procollagen|collagen alpha 1 chain type I|collagen alpha-1(I) chain preproprotein|collagen of skin, tendon and bone, alpha-1 chain|collagen, type I, alpha 1|pro-alpha-1 collagen type 1|type I proalpha 1|type I procollagen alpha 1 chain', map_location='17q21.33', chromosome='17', genomic_nucleotide_accession_version='NC_000017.11', start_position_on_the_genomic_accession=50184096, end_position_on_the_genomic_accession=50201649, orientation='minus', exon_count=51, OMIM=[120150], no_hdr0=''),
    1278 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1278, CurrentID=0, Status='live', Symbol='COL1A2', Aliases=['EDSARTH2', 'EDSCV', 'OI4'], description='collagen type I alpha 2 chain', other_designations='collagen alpha-2(I) chain|alpha 2 type I procollagen|alpha 2(I) procollagen|alpha 2(I)-collagen|alpha-2 type I collagen|collagen I, alpha-2 polypeptide|collagen of skin, tendon and bone, alpha-2 chain|collagen, type I, alpha 2|epididymis secretory sperm binding protein|type I procollagen', map_location='7q21.3', chromosome='7', genomic_nucleotide_accession_version='NC_000007.14', start_position_on_the_genomic_accession=94394895, end_position_on_the_genomic_accession=94431227, orientation='plus', exon_count=52, OMIM=[120160], no_hdr0=''),
    1280 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1280, CurrentID=0, Status='live', Symbol='COL2A1', Aliases=['ANFH', 'AOM', 'COL11A3', 'SEDC', 'STL1'], description='collagen type II alpha 1 chain', other_designations='collagen alpha-1(II) chain|alpha-1 type II collagen|arthroophthalmopathy, progressive (Stickler syndrome)|cartilage collagen|chondrocalcin|collagen II, alpha-1 polypeptide|collagen, type II, alpha 1', map_location='12q13.11', chromosome='12', genomic_nucleotide_accession_version='NC_000012.12', start_position_on_the_genomic_accession=47972967, end_position_on_the_genomic_accession=48006212, orientation='minus', exon_count=57, OMIM=[120140], no_hdr0=''),
    1281 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1281, CurrentID=0, Status='live', Symbol='COL3A1', Aliases=['EDS4A', 'EDSVASC', 'PMGEDSV'], description='collagen type III alpha 1 chain', other_designations='collagen alpha-1(III) chain|Ehlers-Danlos syndrome type IV, autosomal dominant|alpha-1 type III collagen|alpha1 (III) collagen|collagen, fetal|collagen, type III, alpha 1', map_location='2q32.2', chromosome='2', genomic_nucleotide_accession_version='NC_000002.12', start_position_on_the_genomic_accession=188974373, end_position_on_the_genomic_accession=189012746, orientation='plus', exon_count=51, OMIM=[120180], no_hdr0=''),
    1282 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1282, CurrentID=0, Status='live', Symbol='COL4A1', Aliases=['BSVD', 'BSVD1s', 'PADMAL', 'RATOR', 'COL4A1'], description='collagen type IV alpha 1 chain', other_designations='collagen alpha-1(IV) chain|COL4A1 NC1 domain|arresten|collagen IV, alpha-1 polypeptide|collagen of basement membrane, alpha-1 chain', map_location='13q34', chromosome='13', genomic_nucleotide_accession_version='NC_000013.11', start_position_on_the_genomic_accession=110148963, end_position_on_the_genomic_accession=110307157, orientation='minus', exon_count=54, OMIM=[120130], no_hdr0=''),
    1284 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1284, CurrentID=0, Status='live', Symbol='COL4A2', Aliases=['BSVD2', 'ICH', 'POREN2'], description='collagen type IV alpha 2 chain', other_designations='collagen alpha-2(IV) chain|canstatin', map_location='13q34', chromosome='13', genomic_nucleotide_accession_version='NC_000013.11', start_position_on_the_genomic_accession=110307284, end_position_on_the_genomic_accession=110513209, orientation='plus', exon_count=48, OMIM=[120090], no_hdr0=''),
    1285 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1285, CurrentID=0, Status='live', Symbol='COL4A3', Aliases=['ATS2', 'ATS3'], description='collagen type IV alpha 3 chain', other_designations='collagen alpha-3(IV) chain|collagen IV, alpha-3 polypeptide|collagen, type IV, alpha 3 (Goodpasture antigen)|tumstatin', map_location='2q36.3', chromosome='2', genomic_nucleotide_accession_version='NC_000002.12', start_position_on_the_genomic_accession=227164589, end_position_on_the_genomic_accession=227314792, orientation='plus', exon_count=54, OMIM=[120070], no_hdr0=''),
    1286 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1286, CurrentID=0, Status='live', Symbol='COL4A4', Aliases=['ATS2', 'BFH', 'CA44'], description='collagen type IV alpha 4 chain', other_designations='collagen alpha-4(IV) chain|Collagen IV, alpha-4 polypeptide|collagen of basement membrane, alpha-4 chain|collagen, type IV, alpha 4', map_location='2q36.3', chromosome='2', genomic_nucleotide_accession_version='NC_000002.12', start_position_on_the_genomic_accession=226970293, end_position_on_the_genomic_accession=227164482, orientation='minus', exon_count=54, OMIM=[120131], no_hdr0=''),
    1287 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1287, CurrentID=0, Status='live', Symbol='COL4A5', Aliases=['ASLN', 'ATS', 'ATS1', 'CA54'], description='collagen type IV alpha 5 chain', other_designations='collagen alpha-5(IV) chain|collagen IV, alpha-5 polypeptide|collagen of basement membrane, alpha-5 chain|collagen, type IV, alpha 5|dA149D17.3|dA24A23.1', map_location='Xq22.3', chromosome='X', genomic_nucleotide_accession_version='NC_000023.11', start_position_on_the_genomic_accession=108439838, end_position_on_the_genomic_accession=108697545, orientation='plus', exon_count=58, OMIM=[303630], no_hdr0=''),
    1288 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1288, CurrentID=0, Status='live', Symbol='COL4A6', Aliases=['CXDELq22.3', 'DELXq22.3', 'DFNX6'], description='collagen type IV alpha 6 chain', other_designations='collagen alpha-6(IV) chain|collagen IV, alpha-6 polypeptide|collagen of basement membrane, alpha-6|collagen, type IV, alpha 6|dJ889N15.4 (Collagen Alpha 6(IV))', map_location='Xq22.3', chromosome='X', genomic_nucleotide_accession_version='NC_000023.11', start_position_on_the_genomic_accession=108155607, end_position_on_the_genomic_accession=108439493, orientation='minus', exon_count=50, OMIM=[303631], no_hdr0=''),
    1289 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1289, CurrentID=0, Status='live', Symbol='COL5A1', Aliases=['EDSC', 'EDSCL1'], description='collagen type V alpha 1 chain', other_designations='collagen alpha-1(V) chain|collagen, type V, alpha 1', map_location='9q34.3', chromosome='9', genomic_nucleotide_accession_version='NC_000009.12', start_position_on_the_genomic_accession=134641789, end_position_on_the_genomic_accession=134844843, orientation='plus', exon_count=67, OMIM=[120215], no_hdr0=''),
    1290 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1290, CurrentID=0, Status='live', Symbol='COL5A2', Aliases=['EDSC', 'EDSCL2'], description='collagen type V alpha 2 chain', other_designations='collagen alpha-2(V) chain|AB collagen|collagen, fetal membrane, A polypeptide|type V preprocollagen alpha 2 chain', map_location='2q32.2', chromosome='2', genomic_nucleotide_accession_version='NC_000002.12', start_position_on_the_genomic_accession=189031898, end_position_on_the_genomic_accession=189225301, orientation='minus', exon_count=55, OMIM=[120190], no_hdr0=''),
    1291 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1291, CurrentID=0, Status='live', Symbol='COL6A1', Aliases=['BTHLM1', 'OPLL', 'UCHMD1'], description='collagen type VI alpha 1 chain', other_designations='collagen alpha-1(VI) chain|alpha 1 (VI) chain (61 AA)|collagen VI, alpha-1 polypeptide|collagen, type VI, alpha 1|epididymis secretory sperm binding protein', map_location='21q22.3', chromosome='21', genomic_nucleotide_accession_version='NC_000021.9', start_position_on_the_genomic_accession=45981770, end_position_on_the_genomic_accession=46005048, orientation='plus', exon_count=35, OMIM=[120220], no_hdr0=''),
    1292 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1292, CurrentID=0, Status='live', Symbol='COL6A2', Aliases=['BTHLM1', 'PP3610', 'UCMD1'], description='collagen type VI alpha 2 chain', other_designations='collagen alpha-2(VI) chain|collagen VI, alpha-2 polypeptide|collagen, type VI, alpha 2|epididymis secretory sperm binding protein|human mRNA for collagen VI alpha-2 C-terminal globular domain', map_location='21q22.3', chromosome='21', genomic_nucleotide_accession_version='NC_000021.9', start_position_on_the_genomic_accession=46098071, end_position_on_the_genomic_accession=46132849, orientation='plus', exon_count=30, OMIM=[120240], no_hdr0=''),
    1293 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1293, CurrentID=0, Status='live', Symbol='COL6A3', Aliases=['BTHLM1', 'DYT27', 'UCMD1'], description='collagen type VI alpha 3 chain', other_designations='collagen alpha-3(VI) chain|collagen VI, alpha-3 polypeptide|collagen, type VI, alpha 3|epididymis secretory sperm binding protein', map_location='2q37.3', chromosome='2', genomic_nucleotide_accession_version='NC_000002.12', start_position_on_the_genomic_accession=237324018, end_position_on_the_genomic_accession=237434822, orientation='minus', exon_count=50, OMIM=[120250], no_hdr0=''),
    1294 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1294, CurrentID=0, Status='live', Symbol='COL7A1', Aliases=['EBD1', 'EBDCT', 'EBR1', 'NDNC8'], description='collagen type VII alpha 1 chain', other_designations='collagen alpha-1(VII) chain|LC collagen|collagen VII, alpha-1 polypeptide|collagen, type VII, alpha 1|long-chain collagen', map_location='3p21.31', chromosome='3', genomic_nucleotide_accession_version='NC_000003.12', start_position_on_the_genomic_accession=48564073, end_position_on_the_genomic_accession=48595329, orientation='minus', exon_count=120, OMIM=[120120], no_hdr0=''),
    1295 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1295, CurrentID=0, Status='live', Symbol='COL8A1', Aliases=['C3orf7'], description='collagen type VIII alpha 1 chain', other_designations='collagen alpha-1(VIII) chain|cell proliferation-inducing protein 41|collagen VIII, alpha-1 polypeptide|collagen, type VIII, alpha 1|endothelial collagen|smag-64|smooth muscle cell-expressed and macrophage conditioned medium-induced protein smag-64', map_location='3q12.1', chromosome='3', genomic_nucleotide_accession_version='NC_000003.12', start_position_on_the_genomic_accession=99638594, end_position_on_the_genomic_accession=99799217, orientation='plus', exon_count=5, OMIM=[120251], no_hdr0=''),
    1296 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1296, CurrentID=0, Status='live', Symbol='COL8A2', Aliases=['FECD', 'FECD1', 'PPCD', 'PPCD2'], description='collagen type VIII alpha 2 chain', other_designations='collagen alpha-2(VIII) chain|collagen VIII, alpha-2 polypeptide|collagen, type VIII, alpha 2|endothelial collagen', map_location='1p34.3', chromosome='1', genomic_nucleotide_accession_version='NC_000001.11', start_position_on_the_genomic_accession=36095239, end_position_on_the_genomic_accession=36126207, orientation='minus', exon_count=5, OMIM=[120252], no_hdr0=''),
    1297 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1297, CurrentID=0, Status='live', Symbol='COL9A1', Aliases=['DJ149L1.1.2', 'EDM6', 'MED', 'STL4'], description='collagen type IX alpha 1 chain', other_designations='collagen alpha-1(IX) chain|alpha-1(IX) collagen chain|cartilage-specific short collagen|collagen IX, alpha-1 polypeptide|collagen, type IX, alpha 1', map_location='6q13', chromosome='6', genomic_nucleotide_accession_version='NC_000006.12', start_position_on_the_genomic_accession=70215061, end_position_on_the_genomic_accession=70303084, orientation='minus', exon_count=43, OMIM=[120210], no_hdr0=''),
    1298 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1298, CurrentID=0, Status='live', Symbol='COL9A2', Aliases=['DJ39G22.4', 'EDM2', 'MED', 'STL5'], description='collagen type IX alpha 2 chain', other_designations='collagen alpha-2(IX) chain|alpha 2 type IX collagen|collagen IX, alpha-2 polypeptide|collagen, type IX, alpha 2', map_location='1p34.2', chromosome='1', genomic_nucleotide_accession_version='NC_000001.11', start_position_on_the_genomic_accession=40300487, end_position_on_the_genomic_accession=40317653, orientation='minus', exon_count=35, OMIM=[120260], no_hdr0=''),
    1299 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1299, CurrentID=0, Status='live', Symbol='COL9A3', Aliases=['DJ885L7.4.1', 'EDM3', 'IDD', 'MED'], description='collagen type IX alpha 3 chain', other_designations='collagen alpha-3(IX) chain|collagen IX, alpha-3 polypeptide|collagen type IX proteoglycan|collagen, type IX, alpha 3', map_location='20q13.33', chromosome='20', genomic_nucleotide_accession_version='NC_000020.11', start_position_on_the_genomic_accession=62817050, end_position_on_the_genomic_accession=62841159, orientation='plus', exon_count=33, OMIM=[120270], no_hdr0=''),
    1300 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1300, CurrentID=0, Status='live', Symbol='COL10A1', Aliases=[], description='collagen type X alpha 1 chain', other_designations='collagen alpha-1(X) chain|Schmid metaphyseal chondrodysplasia|collagen X, alpha-1 polypeptide|collagen, type X, alpha 1', map_location='6q22.1', chromosome='6', genomic_nucleotide_accession_version='NC_000006.12', start_position_on_the_genomic_accession=116118909, end_position_on_the_genomic_accession=116219937, orientation='minus', exon_count=6, OMIM=[120110], no_hdr0=''),
    1301 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1301, CurrentID=0, Status='live', Symbol='COL11A1', Aliases=['CO11A1', 'COLL6', 'DFNA37', 'STL2'], description='collagen type XI alpha 1 chain', other_designations='collagen alpha-1(XI) chain|collagen XI, alpha-1 polypeptide|collagen, type XI, alpha 1|deafness, autosomal dominant 37', map_location='1p21.1', chromosome='1', genomic_nucleotide_accession_version='NC_000001.11', start_position_on_the_genomic_accession=102876473, end_position_on_the_genomic_accession=103108580, orientation='minus', exon_count=71, OMIM=[120280], no_hdr0=''),
    1302 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1302, CurrentID=0, Status='live', Symbol='COL11A2', Aliases=['DFNA13', 'DFNB53', 'FBCG2', 'HKE5', 'OSMEDA', 'OSMEDB', 'PARP', 'STL3'], description='collagen type XI alpha 2 chain', other_designations='collagen alpha-2(XI) chain|collagen, type XI, alpha 2|pro-a2 chain of collagen type XI', map_location='6p21.32', chromosome='6', genomic_nucleotide_accession_version='NC_000006.12', start_position_on_the_genomic_accession=33162692, end_position_on_the_genomic_accession=33193009, orientation='minus', exon_count=70, OMIM=[120290], no_hdr0=''),
    1303 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1303, CurrentID=0, Status='live', Symbol='COL12A1', Aliases=['BA209D8.1', 'BTHLM2L', 'DJ234P15.1', 'EDSMYP', 'UCMD2', 'COL12A1'], description='collagen type XII alpha 1 chain', other_designations='collagen alpha-1(XII) chain|collagen type XII proteoglycan|collagen, type XII, alpha 1', map_location='6q13-q14.1', chromosome='6', genomic_nucleotide_accession_version='NC_000006.12', start_position_on_the_genomic_accession=75084326, end_position_on_the_genomic_accession=75206262, orientation='minus', exon_count=67, OMIM=[120320], no_hdr0=''),
    1305 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1305, CurrentID=0, Status='live', Symbol='COL13A1', Aliases=['CMS19', 'COLXIIIA1'], description='collagen type XIII alpha 1 chain', other_designations='collagen alpha-1(XIII) chain|collagen, type XIII, alpha 1', map_location='10q22.1', chromosome='10', genomic_nucleotide_accession_version='NC_000010.11', start_position_on_the_genomic_accession=69801835, end_position_on_the_genomic_accession=69959144, orientation='plus', exon_count=43, OMIM=[120350], no_hdr0=''),
    1306 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1306, CurrentID=0, Status='live', Symbol='COL15A1', Aliases=[], description='collagen type XV alpha 1 chain', other_designations='collagen alpha-1(XV) chain|collagen XV, alpha-1 polypeptide|collagen type XV proteoglycan|collagen, type XV, alpha 1|endostatin-XV|restin', map_location='9q22.33', chromosome='9', genomic_nucleotide_accession_version='NC_000009.12', start_position_on_the_genomic_accession=98943392, end_position_on_the_genomic_accession=99070787, orientation='plus', exon_count=43, OMIM=[120325], no_hdr0=''),
    1307 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1307, CurrentID=0, Status='live', Symbol='COL16A1', Aliases=['447AA', 'FP1572'], description='collagen type XVI alpha 1 chain', other_designations='collagen alpha-1(XVI) chain|alpha 1 type XVI collagen|collagen XVI, alpha-1 polypeptide|collagen, type XVI, alpha 1', map_location='1p35.2', chromosome='1', genomic_nucleotide_accession_version='NC_000001.11', start_position_on_the_genomic_accession=31652263, end_position_on_the_genomic_accession=31704162, orientation='minus', exon_count=74, OMIM=[120326], no_hdr0=''),
    1308 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1308, CurrentID=0, Status='live', Symbol='COL17A1', Aliases=['BA16H23.2', 'BP180', 'BPA-2', 'BPAG2', 'ERED', 'LAD-1'], description='collagen type XVII alpha 1 chain', other_designations='collagen alpha-1(XVII) chain|180 kDa bullous pemphigoid antigen 2|alpha 1 type XVII collagen|bA16H23.2 (collagen, type XVII, alpha 1 (BP180))|bullous pemphigoid antigen 2 (180kD)|collagen XVII, alpha-1 polypeptide|collagen, type XVII, alpha 1|type XVII collagen alpha-1', map_location='10q25.1', chromosome='10', genomic_nucleotide_accession_version='NC_000010.11', start_position_on_the_genomic_accession=104031286, end_position_on_the_genomic_accession=104085880, orientation='minus', exon_count=56, OMIM=[113811], no_hdr0=''),
    1310 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1310, CurrentID=0, Status='live', Symbol='COL19A1', Aliases=['COL9A1L', 'D6S228E'], description='collagen type XIX alpha 1 chain', other_designations='collagen alpha-1(XIX) chain|a1 chain of type XIX collagen|collagen XIX, alpha-1 polypeptide|collagen alpha 1 (Y) chain|collagen, type XIX, alpha 1', map_location='6q13', chromosome='6', genomic_nucleotide_accession_version='NC_000006.12', start_position_on_the_genomic_accession=69866556, end_position_on_the_genomic_accession=70215063, orientation='plus', exon_count=55, OMIM=[120165], no_hdr0=''),
    1311 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1311, CurrentID=0, Status='live', Symbol='COMP', Aliases=['EDM1', 'EPD1', 'MED', 'PSACH', 'THBS5', 'TSP5'], description='cartilage oligomeric matrix protein', other_designations='cartilage oligomeric matrix protein|cartilage oligomeric matrix protein (pseudoachondroplasia, epiphyseal dysplasia 1, multiple)|pseudoachondroplasia (epiphyseal dysplasia 1, multiple)|thrombospondin-5', map_location='19p13.11', chromosome='19', genomic_nucleotide_accession_version='NC_000019.10', start_position_on_the_genomic_accession=18782773, end_position_on_the_genomic_accession=18791305, orientation='minus', exon_count=19, OMIM=[600310], no_hdr0=''),
    1312 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1312, CurrentID=0, Status='live', Symbol='COMT', Aliases=['HEL-S-98n'], description='catechol-O-methyltransferase', other_designations='catechol O-methyltransferase|epididymis secretory sperm binding protein Li 98n|testicular tissue protein Li 42', map_location='22q11.21', chromosome='22', genomic_nucleotide_accession_version='NC_000022.11', start_position_on_the_genomic_accession=19941772, end_position_on_the_genomic_accession=19969975, orientation='plus', exon_count=8, OMIM=[116790], no_hdr0=''),
    1314 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1314, CurrentID=0, Status='live', Symbol='COPA', Aliases=['AILJK', 'HEP-COP', 'alpha-COP'], description='COPI coat complex subunit alpha', other_designations='coatomer subunit alpha|alpha coat protein|coatomer protein complex subunit alpha|proxenin|xenin', map_location='1q23.2', chromosome='1', genomic_nucleotide_accession_version='NC_000001.11', start_position_on_the_genomic_accession=160288594, end_position_on_the_genomic_accession=160343250, orientation='minus', exon_count=33, OMIM=[601924], no_hdr0=''),
    1315 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1315, CurrentID=0, Status='live', Symbol='COPB1', Aliases=['COPB'], description='COPI coat complex subunit beta 1', other_designations='coatomer subunit beta|beta coat protein|beta-cop|coatomer protein complex subunit beta 1', map_location='11p15.2', chromosome='11', genomic_nucleotide_accession_version='NC_000011.10', start_position_on_the_genomic_accession=14457512, end_position_on_the_genomic_accession=14499811, orientation='minus', exon_count=22, OMIM=[600959], no_hdr0=''),
    1316 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1316, CurrentID=0, Status='live', Symbol='KLF6', Aliases=['BCD1', 'CBA1', 'COPEB', 'CPBP', 'GBF', 'PAC1', 'ST12', 'ZF9'], description='Kruppel like factor 6', other_designations='Krueppel-like factor 6|B-cell-derived protein 1|GC-rich binding factor|GC-rich sites-binding factor GBF|Kruppel-like zinc finger protein Zf9|core promoter element binding protein|proto-oncogene BCD1|protooncogene B-cell derived 1|suppression of tumorigenicity 12 (prostate)|suppressor of tumorigenicity 12 protein|transcription factor Zf9', map_location='10p15.2', chromosome='10', genomic_nucleotide_accession_version='NC_000010.11', start_position_on_the_genomic_accession=3775996, end_position_on_the_genomic_accession=3785209, orientation='minus', exon_count=4, OMIM=[602053], no_hdr0=''),
    1317 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1317, CurrentID=0, Status='live', Symbol='SLC31A1', Aliases=['COPT1', 'CTR1'], description='solute carrier family 31 member 1', other_designations='high affinity copper uptake protein 1|copper transport 1 homolog|copper transporter 1|solute carrier family 31 (copper transporter), member 1|solute carrier family 31 (copper transporters), member 1', map_location='9q32', chromosome='9', genomic_nucleotide_accession_version='NC_000009.12', start_position_on_the_genomic_accession=113221544, end_position_on_the_genomic_accession=113264492, orientation='plus', exon_count=5, OMIM=[603085], no_hdr0=''),
    1318 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1318, CurrentID=0, Status='live', Symbol='SLC31A2', Aliases=['COPT2', 'CTR2', 'hCTR2'], description='solute carrier family 31 member 2', other_designations='probable low affinity copper uptake protein 2|copper transporter 2|solute carrier family 31 (copper transporter), member 2|solute carrier family 31 (copper transporters), member 2', map_location='9q32', chromosome='9', genomic_nucleotide_accession_version='NC_000009.12', start_position_on_the_genomic_accession=113150976, end_position_on_the_genomic_accession=113164140, orientation='plus', exon_count=5, OMIM=[603088], no_hdr0=''),
    1325 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1325, CurrentID=0, Status='live', Symbol='CORT', Aliases=['CST-14', 'CST-17', 'CST-29'], description='cortistatin', other_designations='cortistatin|cortistatin-14|cortistatin-17|cortistatin-29|prepro-cortistatin|preprocortistatin', map_location='1p36.22', chromosome='1', genomic_nucleotide_accession_version='NC_000001.11', start_position_on_the_genomic_accession=10450031, end_position_on_the_genomic_accession=10451998, orientation='plus', exon_count=2, OMIM=[602784], no_hdr0=''),
    1326 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1326, CurrentID=0, Status='live', Symbol='MAP3K8', Aliases=['AURA2', 'COT', 'EST', 'ESTF', 'MEKK8', 'TPL2', 'Tpl-2', 'c-COT'], description='mitogen-activated protein kinase kinase kinase 8', other_designations='mitogen-activated protein kinase kinase kinase 8|Ewing sarcoma transformant|augmented in rheumatoid arthritis 2|cot (cancer Osaka thyroid) oncogene|proto-oncogene c-Cot|proto-oncogene serine/threoine protein kinase|tumor progression locus 2', map_location='10p11.23', chromosome='10', genomic_nucleotide_accession_version='NC_000010.11', start_position_on_the_genomic_accession=30434021, end_position_on_the_genomic_accession=30461833, orientation='plus', exon_count=12, OMIM=[191195], no_hdr0=''),
    1327 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1327, CurrentID=0, Status='live', Symbol='COX4I1', Aliases=['COX IV-1', 'COX4', 'COX4-1', 'COXIV', 'COXIV-1'], description='cytochrome c oxidase subunit 4I1', other_designations='cytochrome c oxidase subunit 4 isoform 1, mitochondrial|cytochrome c oxidase polypeptide IV|cytochrome c oxidase subunit IV', map_location='16q24.1', chromosome='16', genomic_nucleotide_accession_version='NC_000016.10', start_position_on_the_genomic_accession=85799695, end_position_on_the_genomic_accession=85807068, orientation='plus', exon_count=6, OMIM=[123864], no_hdr0=''),
    1329 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1329, CurrentID=0, Status='live', Symbol='COX5B', Aliases=['COXVB'], description='cytochrome c oxidase subunit 5B', other_designations='cytochrome c oxidase subunit 5B, mitochondrial|cytochrome c oxidase polypeptide VB, mitochondrial|cytochrome c oxidase subunit Vb|epididymis secretory sperm binding protein', map_location='2q11.2', chromosome='2', genomic_nucleotide_accession_version='NC_000002.12', start_position_on_the_genomic_accession=97646062, end_position_on_the_genomic_accession=97648383, orientation='plus', exon_count=4, OMIM=[123866], no_hdr0=''),
    1337 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1337, CurrentID=0, Status='live', Symbol='COX6A1', Aliases=['CMTRID', 'COX6A', 'COX6AL'], description='cytochrome c oxidase subunit 6A1', other_designations='cytochrome c oxidase subunit 6A1, mitochondrial|COX VIa-L|cytochrome C oxidase subunit VIa homolog|cytochrome c oxidase polypeptide VIa-liver|cytochrome c oxidase subunit VIA-liver|cytochrome c oxidase subunit VIa polypeptide 1', map_location='12q24.2', chromosome='12', genomic_nucleotide_accession_version='NC_000012.12', start_position_on_the_genomic_accession=120438113, end_position_on_the_genomic_accession=120440730, orientation='plus', exon_count=3, OMIM=[602072], no_hdr0=''),
    1339 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1339, CurrentID=0, Status='live', Symbol='COX6A2', Aliases=['COX6AH', 'COXVIAH'], description='cytochrome c oxidase subunit 6A2', other_designations='cytochrome c oxidase subunit 6A2, mitochondrial|COX VIa-M|cytochrome c oxidase polypeptide VIa-heart|cytochrome c oxidase subunit VIA-muscle|cytochrome c oxidase subunit VIa polypeptide 2', map_location='16p11.2', chromosome='16', genomic_nucleotide_accession_version='NC_000016.10', start_position_on_the_genomic_accession=31427731, end_position_on_the_genomic_accession=31428360, orientation='minus', exon_count=3, OMIM=[602009], no_hdr0=''),
    1340 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1340, CurrentID=0, Status='live', Symbol='COX6B1', Aliases=['COX6B', 'COXG', 'COXVIb1'], description='cytochrome c oxidase subunit 6B1', other_designations='cytochrome c oxidase subunit 6B1|COX VIb-1|cytochrome c oxidase subunit VIb polypeptide 1 (ubiquitous)', map_location='19q13.12', chromosome='19', genomic_nucleotide_accession_version='NC_000019.10', start_position_on_the_genomic_accession=35648323, end_position_on_the_genomic_accession=35658782, orientation='plus', exon_count=4, OMIM=[124089], no_hdr0=''),
    1345 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1345, CurrentID=0, Status='live', Symbol='COX6C', Aliases=[], description='cytochrome c oxidase subunit 6C', other_designations='cytochrome c oxidase subunit 6C|cytochrome c oxidase polypeptide VIc|cytochrome c oxidase subunit VIc preprotein|epididymis secretory sperm binding protein', map_location='8q22.2', chromosome='8', genomic_nucleotide_accession_version='NC_000008.11', start_position_on_the_genomic_accession=99877865, end_position_on_the_genomic_accession=99893707, orientation='minus', exon_count=5, OMIM=[124090], no_hdr0=''),
    1346 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1346, CurrentID=0, Status='live', Symbol='COX7A1', Aliases=['COX7A', 'COX7AH', 'COX7AM'], description='cytochrome c oxidase subunit 7A1', other_designations='cytochrome c oxidase subunit 7A1, mitochondrial|cytochrome c oxidase subunit VIIa polypeptide 1 (muscle)|cytochrome c oxidase subunit VIIa-H|cytochrome c oxidase subunit VIIa-M|cytochrome c oxidase subunit VIIa-heart|cytochrome c oxidase subunit VIIa-muscle', map_location='19q13.12', chromosome='19', genomic_nucleotide_accession_version='NC_000019.10', start_position_on_the_genomic_accession=36150922, end_position_on_the_genomic_accession=36152447, orientation='minus', exon_count=4, OMIM=[123995], no_hdr0=''),
    1347 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1347, CurrentID=0, Status='live', Symbol='COX7A2', Aliases=['COX7AL', 'COX7AL1', 'COXVIIAL', 'COXVIIa-L', 'VIIAL'], description='cytochrome c oxidase subunit 7A2', other_designations='cytochrome c oxidase subunit 7A2, mitochondrial|cytochrome c oxidase polypeptide 7A2, mitochondrial|cytochrome c oxidase polypeptide VIIa-liver/heart|cytochrome c oxidase subunit VIIa polypeptide 2 (liver)|cytochrome c oxidase subunit VIIa-L|cytochrome c oxidase subunit VIIa-liver/heart|cytochrome c oxidase subunit VIIaL|hepatic cytochrome-c oxidase chain VIIa', map_location='6q14.1', chromosome='6', genomic_nucleotide_accession_version='NC_000006.12', start_position_on_the_genomic_accession=75237675, end_position_on_the_genomic_accession=75250298, orientation='minus', exon_count=6, OMIM=[123996], no_hdr0=''),
    1349 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1349, CurrentID=0, Status='live', Symbol='COX7B', Aliases=['APLCC', 'LSDMCA2'], description='cytochrome c oxidase subunit 7B', other_designations='cytochrome c oxidase subunit 7B, mitochondrial|cytochrome c oxidase polypeptide VIIb|cytochrome c oxidase subunit VIIb|cytochrome-c oxidase chain VIIb', map_location='Xq21.1', chromosome='X', genomic_nucleotide_accession_version='NC_000023.11', start_position_on_the_genomic_accession=77899468, end_position_on_the_genomic_accession=77907376, orientation='plus', exon_count=3, OMIM=[300885], no_hdr0=''),
    1350 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1350, CurrentID=0, Status='live', Symbol='COX7C', Aliases=[], description='cytochrome c oxidase subunit 7C', other_designations='cytochrome c oxidase subunit 7C, mitochondrial|cytochrome c oxidase polypeptide VIIc|cytochrome c oxidase subunit VIIc|cytochrome-c oxidase chain VIIc', map_location='5q14.3', chromosome='5', genomic_nucleotide_accession_version='NC_000005.10', start_position_on_the_genomic_accession=86617941, end_position_on_the_genomic_accession=86620962, orientation='plus', exon_count=3, OMIM=[603774], no_hdr0=''),
    1351 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1351, CurrentID=0, Status='live', Symbol='COX8A', Aliases=['COX', 'COX8', 'COX8-2', 'COX8L', 'VIII', 'VIII-L'], description='cytochrome c oxidase subunit 8A', other_designations='cytochrome c oxidase subunit 8A, mitochondrial|cytochrome c oxidase polypeptide VIII-liver/heart|cytochrome c oxidase subunit 8-2|cytochrome c oxidase subunit 8A (ubiquitous)|cytochrome c oxidase subunit VIII|cytochrome c oxidase subunit VIIIA (ubiquitous)', map_location='11q13.1', chromosome='11', genomic_nucleotide_accession_version='NC_000011.10', start_position_on_the_genomic_accession=63974620, end_position_on_the_genomic_accession=63976543, orientation='plus', exon_count=2, OMIM=[123870], no_hdr0=''),
    1352 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1352, CurrentID=0, Status='live', Symbol='COX10', Aliases=[], description='cytochrome c oxidase assembly factor heme A:farnesyltransferase COX10', other_designations='protoheme IX farnesyltransferase, mitochondrial|COX10 homolog, cytochrome c oxidase assembly protein, heme A: farnesyltransferase|COX10, heme A:farnesyltransferase cytochrome c oxidase assembly factor|cytochrome c oxidase assembly homolog 10|cytochrome c oxidase assembly protein|cytochrome c oxidase subunit X|heme A: farnesyltransferase|heme O synthase', map_location='17p12', chromosome='17', genomic_nucleotide_accession_version='NC_000017.11', start_position_on_the_genomic_accession=14069504, end_position_on_the_genomic_accession=14208677, orientation='plus', exon_count=7, OMIM=[602125], no_hdr0=''),
    1353 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1353, CurrentID=0, Status='live', Symbol='COX11', Aliases=['COX11P'], description='cytochrome c oxidase copper chaperone COX11', other_designations='cytochrome c oxidase assembly protein COX11, mitochondrial|COX11 homolog, cytochrome c oxidase assembly protein|COX11, cytochrome c oxidase copper chaperone|cytochrome c oxidase subunit 11', map_location='17q22', chromosome='17', genomic_nucleotide_accession_version='NC_000017.11', start_position_on_the_genomic_accession=54951898, end_position_on_the_genomic_accession=54968785, orientation='minus', exon_count=6, OMIM=[603648], no_hdr0=''),
    1355 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1355, CurrentID=0, Status='live', Symbol='COX15', Aliases=['CEMCOX2'], description='cytochrome c oxidase assembly homolog COX15', other_designations='cytochrome c oxidase assembly protein COX15 homolog|COX15 homolog, cytochrome c oxidase assembly protein|COX15, cytochrome c oxidase assembly homolog|cytochrome c oxidase assembly homolog 15|cytochrome c oxidase subunit 15', map_location='10q24.2', chromosome='10', genomic_nucleotide_accession_version='NC_000010.11', start_position_on_the_genomic_accession=99694293, end_position_on_the_genomic_accession=99732131, orientation='minus', exon_count=10, OMIM=[603646], no_hdr0=''),
    1356 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1356, CurrentID=0, Status='live', Symbol='CP', Aliases=['CP-2'], description='ceruloplasmin', other_designations='ceruloplasmin|ceruloplasmin (ferroxidase)', map_location='3q24-q25.1', chromosome='3', genomic_nucleotide_accession_version='NC_000003.12', start_position_on_the_genomic_accession=149162410, end_position_on_the_genomic_accession=149222008, orientation='minus', exon_count=22, OMIM=[117700], no_hdr0=''),
    1357 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1357, CurrentID=0, Status='live', Symbol='CPA1', Aliases=['CPA'], description='carboxypeptidase A1', other_designations='carboxypeptidase A1|carboxypeptidase A1 (pancreatic)|pancreatic carboxypeptidase A', map_location='7q32.2', chromosome='7', genomic_nucleotide_accession_version='NC_000007.14', start_position_on_the_genomic_accession=130380494, end_position_on_the_genomic_accession=130388108, orientation='plus', exon_count=10, OMIM=[114850], no_hdr0=''),
    1358 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1358, CurrentID=0, Status='live', Symbol='CPA2', Aliases=[], description='carboxypeptidase A2', other_designations='carboxypeptidase A2|carboxypeptidase A2 (pancreatic)', map_location='7q32.2', chromosome='7', genomic_nucleotide_accession_version='NC_000007.14', start_position_on_the_genomic_accession=130266863, end_position_on_the_genomic_accession=130289798, orientation='plus', exon_count=11, OMIM=[600688], no_hdr0=''),
    1359 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1359, CurrentID=0, Status='live', Symbol='CPA3', Aliases=['MC-CPA'], description='carboxypeptidase A3', other_designations='mast cell carboxypeptidase A|carboxypeptidase A3 (mast cell)|tissue carboxypeptidase A', map_location='3q24', chromosome='3', genomic_nucleotide_accession_version='NC_000003.12', start_position_on_the_genomic_accession=148865296, end_position_on_the_genomic_accession=148897203, orientation='plus', exon_count=11, OMIM=[114851], no_hdr0=''),
    1360 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1360, CurrentID=0, Status='live', Symbol='CPB1', Aliases=['CPB', 'PASP', 'PCPB'], description='carboxypeptidase B1', other_designations='carboxypeptidase B|carboxypeptidase B1 (tissue)|pancreas-specific protein|pancreatic carboxypeptidase B|procarboxypeptidase B|protaminase|tissue carboxypeptidase B', map_location='3q24', chromosome='3', genomic_nucleotide_accession_version='NC_000003.12', start_position_on_the_genomic_accession=148827811, end_position_on_the_genomic_accession=148860187, orientation='plus', exon_count=11, OMIM=[114852], no_hdr0=''),
    1361 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1361, CurrentID=0, Status='live', Symbol='CPB2', Aliases=['CPU', 'PCPB', 'TAFI'], description='carboxypeptidase B2', other_designations='carboxypeptidase B2|carboxypeptidase B-like protein|carboxypeptidase B2 (plasma)|carboxypeptidase B2 (plasma, carboxypeptidase U)|carboxypeptidase R|thrombin-activable fibrinolysis inhibitor|thrombin-activatable fibrinolysis inhibitor', map_location='13q14.13', chromosome='13', genomic_nucleotide_accession_version='NC_000013.11', start_position_on_the_genomic_accession=46053066, end_position_on_the_genomic_accession=46105033, orientation='minus', exon_count=12, OMIM=[603101], no_hdr0=''),
    1362 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1362, CurrentID=0, Status='live', Symbol='CPD', Aliases=['GP180'], description='carboxypeptidase D', other_designations='carboxypeptidase D|metallocarboxypeptidase D', map_location='17q11.2', chromosome='17', genomic_nucleotide_accession_version='NC_000017.11', start_position_on_the_genomic_accession=30378927, end_position_on_the_genomic_accession=30469989, orientation='plus', exon_count=22, OMIM=[603102], no_hdr0=''),
    1363 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1363, CurrentID=0, Status='live', Symbol='CPE', Aliases=['CPH'], description='carboxypeptidase E', other_designations='carboxypeptidase E|carboxypeptidase H|cobalt-stimulated chromaffin granule carboxypeptidase|enkephalin convertase|epididymis secretory sperm binding protein|insulin granule-associated carboxypeptidase|prohormone-processing carboxypeptidase', map_location='4q32.3', chromosome='4', genomic_nucleotide_accession_version='NC_000004.12', start_position_on_the_genomic_accession=165379008, end_position_on_the_genomic_accession=165498547, orientation='plus', exon_count=9, OMIM=[114855], no_hdr0=''),
    1364 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1364, CurrentID=0, Status='live', Symbol='CLDN4', Aliases=['CPE-R', 'CPER', 'CPETR', 'CPETR1', 'WBSCR8', 'hCPE-R'], description='claudin 4', other_designations='claudin-4|CPE-receptor|Clostridium perfringens enterotoxin receptor 1|Williams-Beuren syndrome chromosomal region 8 protein', map_location='7q11.23', chromosome='7', genomic_nucleotide_accession_version='NC_000007.14', start_position_on_the_genomic_accession=73830996, end_position_on_the_genomic_accession=73832690, orientation='plus', exon_count=1, OMIM=[602909], no_hdr0=''),
    1365 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1365, CurrentID=0, Status='live', Symbol='CLDN3', Aliases=['C7orf1', 'CPE-R2', 'CPETR2', 'HRVP1', 'RVP1'], description='claudin 3', other_designations='claudin-3|CPE-R 2|CPE-receptor 2|Clostridium perfringens enterotoxin receptor 2|ventral prostate.1 protein homolog|ventral prostate.1-like protein', map_location='7q11.23', chromosome='7', genomic_nucleotide_accession_version='NC_000007.14', start_position_on_the_genomic_accession=73768997, end_position_on_the_genomic_accession=73770270, orientation='minus', exon_count=1, OMIM=[602910], no_hdr0=''),
    1366 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1366, CurrentID=0, Status='live', Symbol='CLDN7', Aliases=['CEPTRL2', 'CLDN-7', 'CPETRL2', 'Hs.84359', 'claudin-1'], description='claudin 7', other_designations='claudin-7|clostridium perfringens enterotoxin receptor-like 2|epididymis secretory sperm binding protein', map_location='17p13.1', chromosome='17', genomic_nucleotide_accession_version='NC_000017.11', start_position_on_the_genomic_accession=7259903, end_position_on_the_genomic_accession=7263213, orientation='minus', exon_count=5, OMIM=[609131], no_hdr0=''),
    1368 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1368, CurrentID=0, Status='live', Symbol='CPM', Aliases=[], description='carboxypeptidase M', other_designations='carboxypeptidase M|renal carboxypeptidase|urinary carboxypeptidase B', map_location='12q15', chromosome='12', genomic_nucleotide_accession_version='NC_000012.12', start_position_on_the_genomic_accession=68842193, end_position_on_the_genomic_accession=68963469, orientation='minus', exon_count=11, OMIM=[114860], no_hdr0=''),
    1369 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1369, CurrentID=0, Status='live', Symbol='CPN1', Aliases=['CPN', 'SCPN'], description='carboxypeptidase N subunit 1', other_designations='carboxypeptidase N catalytic chain|anaphylatoxin inactivator|arginine carboxypeptidase|carboxypeptidase K|carboxypeptidase N catalytic subunit|carboxypeptidase N polypeptide 1 50 kD|carboxypeptidase N small subunit|carboxypeptidase N, polypeptide 1|kininase I|kininase-1|lysine carboxypeptidase|plasma carboxypeptidase B|serum carboxypeptidase N', map_location='10q24.2', chromosome='10', genomic_nucleotide_accession_version='NC_000010.11', start_position_on_the_genomic_accession=100042193, end_position_on_the_genomic_accession=100081869, orientation='minus', exon_count=9, OMIM=[603103], no_hdr0=''),
    1370 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1370, CurrentID=0, Status='live', Symbol='CPN2', Aliases=['ACBP'], description='carboxypeptidase N subunit 2', other_designations='carboxypeptidase N subunit 2|carboxypeptidase N 83 kDa chain|carboxypeptidase N large subunit|carboxypeptidase N regulatory subunit|carboxypeptidase N, polypeptide 2, 83kD', map_location='3q29', chromosome='3', genomic_nucleotide_accession_version='NC_000003.12', start_position_on_the_genomic_accession=194339765, end_position_on_the_genomic_accession=194351387, orientation='minus', exon_count=3, OMIM=[603104], no_hdr0=''),
    1371 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1371, CurrentID=0, Status='live', Symbol='CPOX', Aliases=['COX', 'CPO', 'CPX', 'HARPO', 'HCP'], description='coproporphyrinogen oxidase', other_designations='oxygen-dependent coproporphyrinogen-III oxidase, mitochondrial|coprogen oxidase|coproporphyrinogenase|homozygous coproporphyria', map_location='3q11.2', chromosome='3', genomic_nucleotide_accession_version='NC_000003.12', start_position_on_the_genomic_accession=98569837, end_position_on_the_genomic_accession=98593684, orientation='minus', exon_count=10, OMIM=[612732], no_hdr0=''),
    1373 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1373, CurrentID=0, Status='live', Symbol='CPS1', Aliases=['CPSASE1', 'PHN'], description='carbamoyl-phosphate synthase 1', other_designations='carbamoyl-phosphate synthase [ammonia], mitochondrial|carbamoyl-phosphate synthase (ammonia)|carbamoyl-phosphate synthase 1, mitochondrial|carbamoylphosphate synthetase I', map_location='2q34', chromosome='2', genomic_nucleotide_accession_version='NC_000002.12', start_position_on_the_genomic_accession=210477685, end_position_on_the_genomic_accession=210679107, orientation='plus', exon_count=43, OMIM=[608307], no_hdr0=''),
    1374 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1374, CurrentID=0, Status='live', Symbol='CPT1A', Aliases=['CPT1', 'CPT1-L', 'L-CPT1'], description='carnitine palmitoyltransferase 1A', other_designations='carnitine O-palmitoyltransferase 1, liver isoform|CPT I|CPTI-L|carnitine palmitoyltransferase 1A (liver)|carnitine palmitoyltransferase I, liver', map_location='11q13.3', chromosome='11', genomic_nucleotide_accession_version='NC_000011.10', start_position_on_the_genomic_accession=68754620, end_position_on_the_genomic_accession=68844410, orientation='minus', exon_count=22, OMIM=[600528], no_hdr0=''),
    1375 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1375, CurrentID=0, Status='live', Symbol='CPT1B', Aliases=['CPT1-M', 'CPT1M', 'CPTI', 'CPTI-M', 'M-CPT1', 'MCCPT1', 'MCPT1'], description='carnitine palmitoyltransferase 1B', other_designations='carnitine O-palmitoyltransferase 1, muscle isoform|carnitine O-palmitoyltransferase 1B|carnitine palmitoyltransferase 1B (muscle)|carnitine palmitoyltransferase I-like protein', map_location='22q13.33', chromosome='22', genomic_nucleotide_accession_version='NC_000022.11', start_position_on_the_genomic_accession=50568861, end_position_on_the_genomic_accession=50578612, orientation='minus', exon_count=21, OMIM=[601987], no_hdr0=''),
    1376 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1376, CurrentID=0, Status='live', Symbol='CPT2', Aliases=['CPT1', 'CPTASE', 'IIAE4'], description='carnitine palmitoyltransferase 2', other_designations='carnitine O-palmitoyltransferase 2, mitochondrial|CPT II|carnitine palmitoyltransferase II|testicular secretory protein Li 13', map_location='1p32.3', chromosome='1', genomic_nucleotide_accession_version='NC_000001.11', start_position_on_the_genomic_accession=53196824, end_position_on_the_genomic_accession=53214197, orientation='plus', exon_count=5, OMIM=[600650], no_hdr0=''),
    1378 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1378, CurrentID=0, Status='live', Symbol='CR1', Aliases=['C3BR', 'C4BR', 'CD35', 'KN'], description='complement C3b/C4b receptor 1 (Knops blood group)', other_designations='complement receptor type 1|C3-binding protein|C3b/C4b receptor|CD35 antigen|Knops blood group antigen|complement component (3b/4b) receptor 1 (Knops blood group)|complement receptor 1', map_location='1q32.2', chromosome='1', genomic_nucleotide_accession_version='NC_000001.11', start_position_on_the_genomic_accession=207496157, end_position_on_the_genomic_accession=207641765, orientation='plus', exon_count=47, OMIM=[120620], no_hdr0=''),
    1379 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1379, CurrentID=0, Status='live', Symbol='CR1L', Aliases=[], description='complement C3b/C4b receptor 1 like', other_designations='complement component receptor 1-like protein|complement C4b-binding protein CR-1-like protein|complement component (3b/4b) receptor 1-like', map_location='1q32.2', chromosome='1', genomic_nucleotide_accession_version='NC_000001.11', start_position_on_the_genomic_accession=207645133, end_position_on_the_genomic_accession=207723703, orientation='plus', exon_count=12, OMIM=[605886], no_hdr0=''),
    1380 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1380, CurrentID=0, Status='live', Symbol='CR2', Aliases=['C3DR', 'CD21', 'CR', 'CVID7', 'SLEB9'], description='complement C3d receptor 2', other_designations='complement receptor type 2|EBV receptor|complement component (3d/Epstein Barr virus) receptor 2|complement component 3d receptor 2', map_location='1q32.2', chromosome='1', genomic_nucleotide_accession_version='NC_000001.11', start_position_on_the_genomic_accession=207454328, end_position_on_the_genomic_accession=207489892, orientation='plus', exon_count=21, OMIM=[120650], no_hdr0=''),
    1381 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1381, CurrentID=0, Status='live', Symbol='CRABP1', Aliases=['CRABP', 'CRABP-I', 'CRABPI', 'RBP5'], description='cellular retinoic acid binding protein 1', other_designations='cellular retinoic acid-binding protein 1|cellular retinoic acid-binding protein I', map_location='15q25.1', chromosome='15', genomic_nucleotide_accession_version='NC_000015.10', start_position_on_the_genomic_accession=78340353, end_position_on_the_genomic_accession=78348225, orientation='plus', exon_count=4, OMIM=[180230], no_hdr0=''),
    1382 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1382, CurrentID=0, Status='live', Symbol='CRABP2', Aliases=['CRABP-II', 'RBP6'], description='cellular retinoic acid binding protein 2', other_designations='cellular retinoic acid-binding protein 2|cellular retinoic acid-binding protein II', map_location='1q23.1', chromosome='1', genomic_nucleotide_accession_version='NC_000001.11', start_position_on_the_genomic_accession=156699606, end_position_on_the_genomic_accession=156705784, orientation='minus', exon_count=5, OMIM=[180231], no_hdr0=''),
    1384 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1384, CurrentID=0, Status='live', Symbol='CRAT', Aliases=['CAT', 'CAT1', 'NBIA8'], description='carnitine O-acetyltransferase', other_designations='carnitine O-acetyltransferase|carnitine acetylase', map_location='9q34.11', chromosome='9', genomic_nucleotide_accession_version='NC_000009.12', start_position_on_the_genomic_accession=129094794, end_position_on_the_genomic_accession=129110793, orientation='minus', exon_count=18, OMIM=[600184], no_hdr0=''),
    1385 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1385, CurrentID=0, Status='live', Symbol='CREB1', Aliases=['CREB', 'CREB-1'], description='cAMP responsive element binding protein 1', other_designations="cyclic AMP-responsive element-binding protein 1|active transcription factor CREB|cAMP-response element-binding protein-1|cyclic adenosine 3',5'-monophosphate response element binding protein|cyclic adenosine 3',5'-monophosphate response element-binding protein CREB|transactivator protein", map_location='2q33.3', chromosome='2', genomic_nucleotide_accession_version='NC_000002.12', start_position_on_the_genomic_accession=207529943, end_position_on_the_genomic_accession=207605988, orientation='plus', exon_count=13, OMIM=[123810], no_hdr0=''),
    1386 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1386, CurrentID=0, Status='live', Symbol='ATF2', Aliases=['CRE-BP1', 'CREB-2', 'CREB2', 'HB16', 'TREB7'], description='activating transcription factor 2', other_designations='cyclic AMP-dependent transcription factor ATF-2|activating transcription factor 2 splice variant ATF2-var2|cAMP response element-binding protein CRE-BP1|cAMP responsive element binding protein 2, formerly|cAMP-dependent transcription factor ATF-2|cyclic AMP-responsive element-binding protein 2|histone acetyltransferase ATF2', map_location='2q31.1', chromosome='2', genomic_nucleotide_accession_version='NC_000002.12', start_position_on_the_genomic_accession=175072259, end_position_on_the_genomic_accession=175168203, orientation='minus', exon_count=17, OMIM=[123811], no_hdr0=''),
    1387 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1387, CurrentID=0, Status='live', Symbol='CREBBP', Aliases=['CBP', 'KAT3A', 'MKHK1', 'RSTS', 'RSTS1'], description='CREB binding protein', other_designations='CREB-binding protein|histone lysine acetyltransferase CREBBP|protein-lysine acetyltransferase CREBBP', map_location='16p13.3', chromosome='16', genomic_nucleotide_accession_version='NC_000016.10', start_position_on_the_genomic_accession=3725054, end_position_on_the_genomic_accession=3880727, orientation='minus', exon_count=33, OMIM=[600140], no_hdr0=''),
    1388 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1388, CurrentID=0, Status='live', Symbol='ATF6B', Aliases=['CREB-RP', 'CREBL1', 'G13'], description='activating transcription factor 6 beta', other_designations='cyclic AMP-dependent transcription factor ATF-6 beta|Creb-related protein|cAMP response element-binding protein-related protein|cAMP-dependent transcription factor ATF-6 beta|cAMP-responsive element-binding protein-like 1|protein G13', map_location='6p21.32', chromosome='6', genomic_nucleotide_accession_version='NC_000006.12', start_position_on_the_genomic_accession=32115264, end_position_on_the_genomic_accession=32128246, orientation='minus', exon_count=18, OMIM=[600984], no_hdr0=''),
    1389 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1389, CurrentID=0, Status='live', Symbol='CREBL2', Aliases=[], description='cAMP responsive element binding protein like 2', other_designations='cAMP-responsive element-binding protein-like 2|MHBs-binding protein 1', map_location='12p13.1', chromosome='12', genomic_nucleotide_accession_version='NC_000012.12', start_position_on_the_genomic_accession=12611876, end_position_on_the_genomic_accession=12645108, orientation='plus', exon_count=4, OMIM=[603476], no_hdr0=''),
    1390 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1390, CurrentID=0, Status='live', Symbol='CREM', Aliases=['CREM-2', 'ICER', 'hCREM-2'], description='cAMP responsive element modulator', other_designations='cAMP-responsive element modulator|CREM 2alpha-b protein|CREM 2beta-a protein|cAMP response element modulator|inducible cAMP early repressor ICER', map_location='10p11.21', chromosome='10', genomic_nucleotide_accession_version='NC_000010.11', start_position_on_the_genomic_accession=35126830, end_position_on_the_genomic_accession=35212958, orientation='plus', exon_count=18, OMIM=[123812], no_hdr0=''),
    1392 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1392, CurrentID=0, Status='live', Symbol='CRH', Aliases=['CRF1', 'CRH'], description='corticotropin releasing hormone', other_designations='corticoliberin|corticotropin-releasing factor', map_location='8q13.1', chromosome='8', genomic_nucleotide_accession_version='NC_000008.11', start_position_on_the_genomic_accession=66176376, end_position_on_the_genomic_accession=66178464, orientation='minus', exon_count=2, OMIM=[122560], no_hdr0=''),
    1393 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1393, CurrentID=0, Status='live', Symbol='CRHBP', Aliases=['CRF-BP', 'CRFBP'], description='corticotropin releasing hormone binding protein', other_designations='corticotropin-releasing factor-binding protein|CRF-binding protein|CRH-BP', map_location='5q13.3', chromosome='5', genomic_nucleotide_accession_version='NC_000005.10', start_position_on_the_genomic_accession=76952855, end_position_on_the_genomic_accession=76981143, orientation='plus', exon_count=9, OMIM=[122559], no_hdr0=''),
    1394 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1394, CurrentID=0, Status='live', Symbol='CRHR1', Aliases=['CRF-R', 'CRF-R-1', 'CRF-R1', 'CRF1', 'CRFR-1', 'CRFR1', 'CRH-R-1', 'CRH-R1', 'CRHRL', 'CRHR1'], description='corticotropin releasing hormone receptor 1', other_designations='corticotropin-releasing factor receptor 1|corticotropin-releasing factor type 1 receptor|seven transmembrane helix receptor', map_location='17q21.31', chromosome='17', genomic_nucleotide_accession_version='NC_000017.11', start_position_on_the_genomic_accession=45784320, end_position_on_the_genomic_accession=45835828, orientation='plus', exon_count=14, OMIM=[122561], no_hdr0=''),
    1395 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1395, CurrentID=0, Status='live', Symbol='CRHR2', Aliases=['CRF-RB', 'CRF2', 'CRFR2', 'HM-CRF'], description='corticotropin releasing hormone receptor 2', other_designations='corticotropin-releasing factor receptor 2|CRH receptor 2 variant B|CRH-R2', map_location='7p14.3', chromosome='7', genomic_nucleotide_accession_version='NC_000007.14', start_position_on_the_genomic_accession=30649406, end_position_on_the_genomic_accession=30700103, orientation='minus', exon_count=16, OMIM=[602034], no_hdr0=''),
    1396 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1396, CurrentID=0, Status='live', Symbol='CRIP1', Aliases=['CRHP', 'CRIP', 'CRP-1', 'CRP1'], description='cysteine rich protein 1', other_designations='cysteine-rich protein 1|cysteine-rich heart protein|cysteine-rich intestinal protein|cysteine-rich protein 1 (intestinal)', map_location='14q32.33', chromosome='14', genomic_nucleotide_accession_version='NC_000014.9', start_position_on_the_genomic_accession=105486886, end_position_on_the_genomic_accession=105488947, orientation='plus', exon_count=6, OMIM=[123875], no_hdr0=''),
    1397 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1397, CurrentID=0, Status='live', Symbol='CRIP2', Aliases=['CRIP', 'CRP2', 'ESP1'], description='cysteine rich protein 2', other_designations='cysteine-rich protein 2|Cysteine-rich intestinal protein|LIM domain protein ESP1/CRP2', map_location='14q32.33', chromosome='14', genomic_nucleotide_accession_version='NC_000014.9', start_position_on_the_genomic_accession=105472945, end_position_on_the_genomic_accession=105480170, orientation='plus', exon_count=10, OMIM=[601183], no_hdr0=''),
    1398 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1398, CurrentID=0, Status='live', Symbol='CRK', Aliases=['CRKII', 'p38'], description='CRK proto-oncogene, adaptor protein', other_designations='adapter molecule crk|proto-oncogene c-Crk|v-crk avian sarcoma virus CT10 oncogene homolog|v-crk sarcoma virus CT10 oncogene-like protein', map_location='17p13.3', chromosome='17', genomic_nucleotide_accession_version='NC_000017.11', start_position_on_the_genomic_accession=1420693, end_position_on_the_genomic_accession=1456232, orientation='minus', exon_count=3, OMIM=[164762], no_hdr0=''),
    1399 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1399, CurrentID=0, Status='live', Symbol='CRKL', Aliases=[], description='CRK like proto-oncogene, adaptor protein', other_designations='crk-like protein|v-crk avian sarcoma virus CT10 oncogene homolog-like', map_location='22q11.21', chromosome='22', genomic_nucleotide_accession_version='NC_000022.11', start_position_on_the_genomic_accession=20917407, end_position_on_the_genomic_accession=20953747, orientation='plus', exon_count=4, OMIM=[602007], no_hdr0=''),
    1400 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1400, CurrentID=0, Status='live', Symbol='CRMP1', Aliases=['CRMP-1', 'DPYSL1', 'DRP-1', 'DRP1', 'ULIP-3'], description='collapsin response mediator protein 1', other_designations='dihydropyrimidinase-related protein 1|dihydropyrimidinase-like 1|inactive dihydropyrimidinase|unc-33-like phosphoprotein 3', map_location='4p16.2', chromosome='4', genomic_nucleotide_accession_version='NC_000004.12', start_position_on_the_genomic_accession=5820764, end_position_on_the_genomic_accession=5893086, orientation='minus', exon_count=17, OMIM=[602462], no_hdr0=''),
    1401 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1401, CurrentID=0, Status='live', Symbol='CRP', Aliases=['PTX1'], description='C-reactive protein', other_designations='C-reactive protein|C-reactive protein, pentraxin-related|pentraxin 1', map_location='1q23.2', chromosome='1', genomic_nucleotide_accession_version='NC_000001.11', start_position_on_the_genomic_accession=159712289, end_position_on_the_genomic_accession=159714589, orientation='minus', exon_count=3, OMIM=[123260], no_hdr0=''),
    1404 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1404, CurrentID=0, Status='live', Symbol='HAPLN1', Aliases=['CRT1', 'CRTL1'], description='hyaluronan and proteoglycan link protein 1', other_designations='hyaluronan and proteoglycan link protein 1|Cartilage link protein|cartilage-link protein|cartilage-linking protein 1|proteoglycan link protein', map_location='5q14.3', chromosome='5', genomic_nucleotide_accession_version='NC_000005.10', start_position_on_the_genomic_accession=83637805, end_position_on_the_genomic_accession=83721210, orientation='minus', exon_count=8, OMIM=[115435], no_hdr0=''),
    1406 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1406, CurrentID=0, Status='live', Symbol='CRX', Aliases=['CORD2', 'CRD', 'LCA7', 'OTX3'], description='cone-rod homeobox', other_designations='cone-rod homeobox protein|orthodenticle homeobox 3', map_location='19q13.33', chromosome='19', genomic_nucleotide_accession_version='NC_000019.10', start_position_on_the_genomic_accession=47821937, end_position_on_the_genomic_accession=47843324, orientation='plus', exon_count=4, OMIM=[602225], no_hdr0=''),
    1407 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1407, CurrentID=0, Status='live', Symbol='CRY1', Aliases=['DSPD', 'PHLL1'], description='cryptochrome circadian regulator 1', other_designations='cryptochrome-1|cryptochrome 1 (photolyase-like)|cryptochrome circadian clock 1', map_location='12q23.3', chromosome='12', genomic_nucleotide_accession_version='NC_000012.12', start_position_on_the_genomic_accession=106991364, end_position_on_the_genomic_accession=107093872, orientation='minus', exon_count=14, OMIM=[601933], no_hdr0=''),
    1408 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1408, CurrentID=0, Status='live', Symbol='CRY2', Aliases=['HCRY2', 'PHLL2'], description='cryptochrome circadian regulator 2', other_designations='cryptochrome-2|cryptochrome 2 (photolyase-like)|cryptochrome circadian clock 2|growth-inhibiting protein 37', map_location='11p11.2', chromosome='11', genomic_nucleotide_accession_version='NC_000011.10', start_position_on_the_genomic_accession=45847118, end_position_on_the_genomic_accession=45883244, orientation='plus', exon_count=13, OMIM=[603732], no_hdr0=''),
    1409 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1409, CurrentID=0, Status='live', Symbol='CRYAA', Aliases=['CRYA1', 'CTRCT9', 'HSPB4'], description='crystallin alpha A', other_designations='alpha-crystallin A chain|crystallin, alpha-1|heat shock protein beta-4|human alphaA-crystallin (CRYA1)', map_location='21q22.3', chromosome='21', genomic_nucleotide_accession_version='NC_000021.9', start_position_on_the_genomic_accession=43169008, end_position_on_the_genomic_accession=43172810, orientation='plus', exon_count=4, OMIM=[123580], no_hdr0=''),
    1410 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1410, CurrentID=0, Status='live', Symbol='CRYAB', Aliases=['CMD1II', 'CRYA2', 'CTPP2', 'CTRCT16', 'HEL-S-101', 'HSPB5', 'MFM2'], description='crystallin alpha B', other_designations='alpha-crystallin B chain|epididymis secretory protein Li 101|heat shock protein beta-5|heat-shock 20 kD like-protein|renal carcinoma antigen NY-REN-27|rosenthal fiber component', map_location='11q23.1', chromosome='11', genomic_nucleotide_accession_version='NC_000011.10', start_position_on_the_genomic_accession=111908564, end_position_on_the_genomic_accession=111923740, orientation='minus', exon_count=6, OMIM=[123590], no_hdr0=''),
    1411 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1411, CurrentID=0, Status='live', Symbol='CRYBA1', Aliases=['CRYB1', 'CTRCT10'], description='crystallin beta A1', other_designations='beta-crystallin A3|beta crystallin A3 chain transcript CN|beta crystallin A3 chain transcript LAM|beta crystallin A3 chain transcript PS|beta crystallin A3 chain transcript TC|crystallin beta A3/A1|crystallin, beta A3|eye lens structural protein|truncated beta crystallin A3/A1 chain|truncated beta-crystallin A3', map_location='17q11.2', chromosome='17', genomic_nucleotide_accession_version='NC_000017.11', start_position_on_the_genomic_accession=29246859, end_position_on_the_genomic_accession=29254494, orientation='plus', exon_count=7, OMIM=[123610], no_hdr0=''),
    1412 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1412, CurrentID=0, Status='live', Symbol='CRYBA2', Aliases=['CTRCT42'], description='crystallin beta A2', other_designations='beta-crystallin A2|eye lens structural protein', map_location='2q35', chromosome='2', genomic_nucleotide_accession_version='NC_000002.12', start_position_on_the_genomic_accession=218990190, end_position_on_the_genomic_accession=218993422, orientation='minus', exon_count=5, OMIM=[600836], no_hdr0=''),
    1413 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1413, CurrentID=0, Status='live', Symbol='CRYBA4', Aliases=['CTRCT23', 'CYRBA4', 'MCOPCT4'], description='crystallin beta A4', other_designations='beta-crystallin A4|beta crystallin A4 chain transcript PS|beta crystallin alpha 4 chain|beta-A4 crystallin|crystallin, beta polypeptide A4|eye lens structural protein', map_location='22q12.1', chromosome='22', genomic_nucleotide_accession_version='NC_000022.11', start_position_on_the_genomic_accession=26607982, end_position_on_the_genomic_accession=26630672, orientation='plus', exon_count=7, OMIM=[123631], no_hdr0=''),
    1414 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1414, CurrentID=0, Status='live', Symbol='CRYBB1', Aliases=['CATCN3', 'CTRCT17'], description='crystallin beta B1', other_designations='beta-crystallin B1|beta-B1 crystallin|eye lens structural protein', map_location='22q12.1', chromosome='22', genomic_nucleotide_accession_version='NC_000022.11', start_position_on_the_genomic_accession=26599278, end_position_on_the_genomic_accession=26618104, orientation='minus', exon_count=6, OMIM=[600929], no_hdr0=''),
    1415 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1415, CurrentID=0, Status='live', Symbol='CRYBB2', Aliases=['CCA2', 'CRYB2', 'CRYB2A', 'CTRCT3', 'D22S665'], description='crystallin beta B2', other_designations='beta-crystallin B2|CTA-221G9.7|beta-B2 crystallin|beta-crystallin Bp|eye lens structural protein', map_location='22q11.23', chromosome='22', genomic_nucleotide_accession_version='NC_000022.11', start_position_on_the_genomic_accession=25211660, end_position_on_the_genomic_accession=25231869, orientation='plus', exon_count=7, OMIM=[123620], no_hdr0=''),
    1417 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1417, CurrentID=0, Status='live', Symbol='CRYBB3', Aliases=['CATCN2', 'CRYB3', 'CTRCT22'], description='crystallin beta B3', other_designations='beta-crystallin B3|eye lens structural protein', map_location='22q11.23', chromosome='22', genomic_nucleotide_accession_version='NC_000022.11', start_position_on_the_genomic_accession=25194244, end_position_on_the_genomic_accession=25207617, orientation='plus', exon_count=6, OMIM=[123630], no_hdr0=''),
    1418 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1418, CurrentID=0, Status='live', Symbol='CRYGA', Aliases=['CRY-g-A', 'CRYG1', 'CRYG5'], description='crystallin gamma A', other_designations='gamma-crystallin A|crystallin, gamma 1|gamma-crystallin 5', map_location='2q33.3', chromosome='2', genomic_nucleotide_accession_version='NC_000002.12', start_position_on_the_genomic_accession=208160740, end_position_on_the_genomic_accession=208163589, orientation='minus', exon_count=3, OMIM=[123660], no_hdr0=''),
    1419 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1419, CurrentID=0, Status='live', Symbol='CRYGB', Aliases=['CRYG2', 'CTRCT39'], description='crystallin gamma B', other_designations='gamma-crystallin B|crystallin, gamma 1-2', map_location='2q33.3', chromosome='2', genomic_nucleotide_accession_version='NC_000002.12', start_position_on_the_genomic_accession=208142573, end_position_on_the_genomic_accession=208146327, orientation='minus', exon_count=3, OMIM=[123670], no_hdr0=''),
    1420 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1420, CurrentID=0, Status='live', Symbol='CRYGC', Aliases=['CCL', 'CRYG3', 'CTRCT2'], description='crystallin gamma C', other_designations='gamma-crystallin C|gamma-crystallin 2-1|gamma-crystallin 3', map_location='2q33.3', chromosome='2', genomic_nucleotide_accession_version='NC_000002.12', start_position_on_the_genomic_accession=208128137, end_position_on_the_genomic_accession=208139100, orientation='minus', exon_count=4, OMIM=[123680], no_hdr0=''),
    1421 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1421, CurrentID=0, Status='live', Symbol='CRYGD', Aliases=['CACA', 'CCA3', 'CCP', 'CRYG4', 'CTRCT4', 'PCC', 'cry-g-D'], description='crystallin gamma D', other_designations='gamma-crystallin D|gamma crystallin 4|gamma-D-crystallin', map_location='2q33.3', chromosome='2', genomic_nucleotide_accession_version='NC_000002.12', start_position_on_the_genomic_accession=208121607, end_position_on_the_genomic_accession=208124524, orientation='minus', exon_count=3, OMIM=[123690], no_hdr0=''),
    1427 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1427, CurrentID=0, Status='live', Symbol='CRYGS', Aliases=['CRYG8', 'CTRCT20'], description='crystallin gamma S', other_designations='gamma-crystallin S|beta-crystallin S|crystallin, gamma 8', map_location='3q27.3', chromosome='3', genomic_nucleotide_accession_version='NC_000003.12', start_position_on_the_genomic_accession=186538443, end_position_on_the_genomic_accession=186544380, orientation='minus', exon_count=3, OMIM=[123730], no_hdr0=''),
    1428 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1428, CurrentID=0, Status='live', Symbol='CRYM', Aliases=['DFNA40', 'THBP'], description='crystallin mu', other_designations='ketimine reductase mu-crystallin|NADP-regulated thyroid-hormone binding protein|mu-crystallin homolog|thiomorpholine-carboxylate dehydrogenase', map_location='16p12.2', chromosome='16', genomic_nucleotide_accession_version='NC_000016.10', start_position_on_the_genomic_accession=21258521, end_position_on_the_genomic_accession=21303062, orientation='minus', exon_count=10, OMIM=[123740], no_hdr0=''),
    1429 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1429, CurrentID=0, Status='live', Symbol='CRYZ', Aliases=[], description='crystallin zeta', other_designations='quinone oxidoreductase|NADPH:quinone reductase|crystallin, zeta (quinone reductase)|epididymis secretory sperm binding protein', map_location='1p31.1', chromosome='1', genomic_nucleotide_accession_version='NC_000001.11', start_position_on_the_genomic_accession=74705470, end_position_on_the_genomic_accession=74733115, orientation='minus', exon_count=11, OMIM=[123691], no_hdr0=''),
    1431 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1431, CurrentID=0, Status='live', Symbol='CS', Aliases=[], description='citrate synthase', other_designations='citrate synthase, mitochondrial|citrate (Si)-synthase', map_location='12q13.3', chromosome='12', genomic_nucleotide_accession_version='NC_000012.12', start_position_on_the_genomic_accession=56271699, end_position_on_the_genomic_accession=56300330, orientation='minus', exon_count=11, OMIM=[118950], no_hdr0=''),
    1432 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1432, CurrentID=0, Status='live', Symbol='MAPK14', Aliases=['CSBP', 'CSBP1', 'CSBP2', 'CSPB1', 'EXIP', 'Mxi2', 'PRKM14', 'PRKM15', 'RK', 'SAPK2A', 'p38', 'p38ALPHA'], description='mitogen-activated protein kinase 14', other_designations='mitogen-activated protein kinase 14|CSAID-binding protein|MAP kinase 14|MAP kinase Mxi2|MAP kinase p38 alpha|MAX-interacting protein 2|cytokine suppressive anti-inflammatory drug binding protein|mitogen-activated protein kinase p38 alpha|p38 MAP kinase|p38 mitogen activated protein kinase|p38alpha Exip|stress-activated protein kinase 2A', map_location='6p21.31', chromosome='6', genomic_nucleotide_accession_version='NC_000006.12', start_position_on_the_genomic_accession=36027711, end_position_on_the_genomic_accession=36122964, orientation='plus', exon_count=22, OMIM=[600289], no_hdr0=''),
    1434 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1434, CurrentID=0, Status='live', Symbol='CSE1L', Aliases=['CAS', 'CSE1', 'XPO2'], description='chromosome segregation 1 like', other_designations='exportin-2|CSE1 chromosome segregation 1-like|cellular apoptosis susceptibility protein|chromosome segregation 1-like protein|epididymis secretory sperm binding protein|exp2|importin-alpha re-exporter', map_location='20q13.13', chromosome='20', genomic_nucleotide_accession_version='NC_000020.11', start_position_on_the_genomic_accession=49046312, end_position_on_the_genomic_accession=49096949, orientation='plus', exon_count=25, OMIM=[601342], no_hdr0=''),
    1435 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1435, CurrentID=0, Status='live', Symbol='CSF1', Aliases=['CSF-1', 'MCSF'], description='colony stimulating factor 1', other_designations='macrophage colony-stimulating factor 1|colony stimulating factor 1 (macrophage)|lanimostim|macrophage colony stimulating factor 1', map_location='1p13.3', chromosome='1', genomic_nucleotide_accession_version='NC_000001.11', start_position_on_the_genomic_accession=109910506, end_position_on_the_genomic_accession=109930992, orientation='plus', exon_count=11, OMIM=[120420], no_hdr0=''),
    1436 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1436, CurrentID=0, Status='live', Symbol='CSF1R', Aliases=['BANDDOS', 'C-FMS', 'CD115', 'CSF-1R', 'CSFR', 'FIM2', 'FMS', 'HDLS', 'M-CSF-R'], description='colony stimulating factor 1 receptor', other_designations='macrophage colony-stimulating factor 1 receptor|CD115 antigen|CSF-1 receptor|FMS proto-oncogene|McDonough feline sarcoma viral (v-fms) oncogene homolog|macrophage colony stimulating factor I receptor|proto-oncogene c-Fms', map_location='5q32', chromosome='5', genomic_nucleotide_accession_version='NC_000005.10', start_position_on_the_genomic_accession=150053295, end_position_on_the_genomic_accession=150113365, orientation='minus', exon_count=24, OMIM=[164770], no_hdr0=''),
    1437 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1437, CurrentID=0, Status='live', Symbol='CSF2', Aliases=['CSF', 'GMCSF'], description='colony stimulating factor 2', other_designations='granulocyte-macrophage colony-stimulating factor|colony stimulating factor 2 (granulocyte-macrophage)|granulocyte macrophage-colony stimulating factor|molgramostim|molgramostin|sargramostim', map_location='5q31.1', chromosome='5', genomic_nucleotide_accession_version='NC_000005.10', start_position_on_the_genomic_accession=132073789, end_position_on_the_genomic_accession=132076170, orientation='plus', exon_count=4, OMIM=[138960], no_hdr0=''),
    1438 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1438, CurrentID=0, Status='live', Symbol='CSF2RA', Aliases=['CD116', 'CDw116', 'CSF2RX', 'CSF2RAY', 'CSF2RX', 'CSF2RY', 'GM-CSF-R-alpha', 'GMCSFR', 'GMCSFR-alpha', 'GMR', 'GMR-alpha', 'SMDP4', 'alphaGMR', 'CSF2RA'], description='colony stimulating factor 2 receptor subunit alpha', other_designations='granulocyte-macrophage colony-stimulating factor receptor subunit alpha|CD116 antigen|GM-CSF receptor alpha subunit|alpha-GM-CSF receptor|colony stimulating factor 2 receptor alpha subunit|colony stimulating factor 2 receptor, alpha, low-affinity (granulocyte-macrophage)|granulocyte-macrophage colony-stimulating factor receptor alpha chain', map_location='Xp22.32 and Yp11.3', chromosome='X', genomic_nucleotide_accession_version='NC_000023.11', start_position_on_the_genomic_accession=1268814, end_position_on_the_genomic_accession=1325218, orientation='plus', exon_count=22, OMIM=[306250, 425000], no_hdr0=''),
    1439 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1439, CurrentID=0, Status='live', Symbol='CSF2RB', Aliases=['CD131', 'CDw131', 'IL3RB', 'IL5RB', 'SMDP5', 'betaGMR'], description='colony stimulating factor 2 receptor subunit beta', other_designations='cytokine receptor common subunit beta|GM-CSF/IL-3/IL-5 receptor common beta subunit|GM-CSF/IL-3/IL-5 receptor common beta-chain|beta common cytokine receptor|beta-GM-CSF receptor|colony stimulating factor 2 receptor beta common subunit|colony stimulating factor 2 receptor, beta, low-affinity (granulocyte-macrophage)|colony-stimulating factor-2 receptor, beta, low-affinity|interleukin 3 receptor/granulocyte-macrophage colony stimulating factor 3 receptor, beta (high affinity)', map_location='22q12.3', chromosome='22', genomic_nucleotide_accession_version='NC_000022.11', start_position_on_the_genomic_accession=36913574, end_position_on_the_genomic_accession=36940449, orientation='plus', exon_count=14, OMIM=[138981], no_hdr0=''),
    1440 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1440, CurrentID=0, Status='live', Symbol='CSF3', Aliases=['C17orf33OS', 'GCSF', 'CSF3'], description='colony stimulating factor 3', other_designations='granulocyte colony-stimulating factor|filgrastim|granulocyte-colony stimulating factor|lenograstim|pluripoietin', map_location='17q21.1', chromosome='17', genomic_nucleotide_accession_version='NC_000017.11', start_position_on_the_genomic_accession=40015440, end_position_on_the_genomic_accession=40017813, orientation='plus', exon_count=4, OMIM=[138970], no_hdr0=''),
    1441 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1441, CurrentID=0, Status='live', Symbol='CSF3R', Aliases=['CD114', 'GCSFR', 'SCN7'], description='colony stimulating factor 3 receptor', other_designations='granulocyte colony-stimulating factor receptor|CD114 antigen|G-CSF receptor|G-CSF-R|colony stimulating factor 3 receptor (granulocyte)', map_location='1p34.3', chromosome='1', genomic_nucleotide_accession_version='NC_000001.11', start_position_on_the_genomic_accession=36466043, end_position_on_the_genomic_accession=36483314, orientation='minus', exon_count=19, OMIM=[138971], no_hdr0=''),
    1442 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1442, CurrentID=0, Status='live', Symbol='CSH1', Aliases=['CS-1', 'CSA', 'CSMT', 'GHB3', 'PL', 'hCS-1', 'hCS-A'], description='chorionic somatomammotropin hormone 1', other_designations='chorionic somatomammotropin hormone 1|Chorionic somatomammotropin hormone 2|choriomammotropin|chorionic somatomammotropin A|chorionic somatomammotropin-1|growth hormone B3|placental lactogen', map_location='17q23.3', chromosome='17', genomic_nucleotide_accession_version='NC_000017.11', start_position_on_the_genomic_accession=63894918, end_position_on_the_genomic_accession=63896574, orientation='minus', exon_count=5, OMIM=[150200], no_hdr0=''),
    1443 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1443, CurrentID=0, Status='live', Symbol='CSH2', Aliases=['CS-2', 'CSB', 'GHB1', 'PL', 'hCS-B'], description='chorionic somatomammotropin hormone 2', other_designations='chorionic somatomammotropin hormone 2|choriomammotropin|chorionic somatomammotropin B|growth hormone B1|lactogen|placental lactogen', map_location='17q23.3', chromosome='17', genomic_nucleotide_accession_version='NC_000017.11', start_position_on_the_genomic_accession=63872012, end_position_on_the_genomic_accession=63873729, orientation='minus', exon_count=4, OMIM=[118820], no_hdr0=''),
    1444 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1444, CurrentID=0, Status='live', Symbol='CSHL1', Aliases=['CS-5', 'CSHP1', 'CSL', 'GHB4', 'hCS-L'], description='chorionic somatomammotropin hormone like 1', other_designations='chorionic somatomammotropin hormone-like 1|chorionic somatomammotropin CS-5|epididymis secretory sperm binding protein|growth hormone B4|growth hormone cluster', map_location='17q23.3', chromosome='17', genomic_nucleotide_accession_version='NC_000017.11', start_position_on_the_genomic_accession=63909602, end_position_on_the_genomic_accession=63911280, orientation='minus', exon_count=4, OMIM=[603515], no_hdr0=''),
    1445 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1445, CurrentID=0, Status='live', Symbol='CSK', Aliases=[], description='C-terminal Src kinase', other_designations='tyrosine-protein kinase CSK|C-Src kinase|CSK, non-receptor tyrosine kinase|c-src tyrosine kinase|protein-tyrosine kinase CYL', map_location='15q24.1', chromosome='15', genomic_nucleotide_accession_version='NC_000015.10', start_position_on_the_genomic_accession=74782080, end_position_on_the_genomic_accession=74803198, orientation='plus', exon_count=16, OMIM=[124095], no_hdr0=''),
    1446 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1446, CurrentID=0, Status='live', Symbol='CSN1S1', Aliases=['CASA', 'CSN1'], description='casein alpha s1', other_designations='alpha-S1-casein|casein, alpha', map_location='4q13.3', chromosome='4', genomic_nucleotide_accession_version='NC_000004.12', start_position_on_the_genomic_accession=69931062, end_position_on_the_genomic_accession=69946574, orientation='plus', exon_count=16, OMIM=[115450], no_hdr0=''),
    1447 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1447, CurrentID=0, Status='live', Symbol='CSN2', Aliases=['CASB', 'PDC213'], description='casein beta', other_designations='beta-casein', map_location='4q13.3', chromosome='4', genomic_nucleotide_accession_version='NC_000004.12', start_position_on_the_genomic_accession=69955256, end_position_on_the_genomic_accession=69965762, orientation='minus', exon_count=8, OMIM=[115460], no_hdr0=''),
    1448 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1448, CurrentID=0, Status='live', Symbol='CSN3', Aliases=['CNS10', 'CSN10', 'CSNK', 'KCA'], description='casein kappa', other_designations='kappa-casein', map_location='4q13.3', chromosome='4', genomic_nucleotide_accession_version='NC_000004.12', start_position_on_the_genomic_accession=70238370, end_position_on_the_genomic_accession=70251432, orientation='plus', exon_count=6, OMIM=[601695], no_hdr0=''),
    1452 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1452, CurrentID=0, Status='live', Symbol='CSNK1A1', Aliases=['CK1', 'CK1a', 'CKIa', 'HEL-S-77p', 'HLCDGP1', 'PRO2975'], description='casein kinase 1 alpha 1', other_designations='casein kinase I isoform alpha|CKI-alpha|clock regulator kinase|down-regulated in lung cancer|epididymis secretory sperm binding protein Li 77p', map_location='5q32', chromosome='5', genomic_nucleotide_accession_version='NC_000005.10', start_position_on_the_genomic_accession=149492982, end_position_on_the_genomic_accession=149551439, orientation='minus', exon_count=11, OMIM=[600505], no_hdr0=''),
    1453 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1453, CurrentID=0, Status='live', Symbol='CSNK1D', Aliases=['ASPS', 'CKI-delta', 'CKId', 'CKIdelta', 'FASPS2', 'HCKID'], description='casein kinase 1 delta', other_designations='casein kinase I isoform delta|casein kinase I|tau-protein kinase CSNK1D', map_location='17q25.3', chromosome='17', genomic_nucleotide_accession_version='NC_000017.11', start_position_on_the_genomic_accession=82239019, end_position_on_the_genomic_accession=82273750, orientation='minus', exon_count=13, OMIM=[600864], no_hdr0=''),
    1454 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1454, CurrentID=0, Status='live', Symbol='CSNK1E', Aliases=['CKIe', 'CKIepsilon', 'HCKIE'], description='casein kinase 1 epsilon', other_designations='casein kinase I isoform epsilon', map_location='22q13.1', chromosome='22', genomic_nucleotide_accession_version='NC_000022.11', start_position_on_the_genomic_accession=38290691, end_position_on_the_genomic_accession=38318084, orientation='minus', exon_count=12, OMIM=[600863], no_hdr0=''),
    1455 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1455, CurrentID=0, Status='live', Symbol='CSNK1G2', Aliases=['CK1g2'], description='casein kinase 1 gamma 2', other_designations='casein kinase I isoform gamma-2|casein kinase I|CKI-gamma 2', map_location='19p13.3', chromosome='19', genomic_nucleotide_accession_version='NC_000019.10', start_position_on_the_genomic_accession=1941149, end_position_on_the_genomic_accession=1981338, orientation='plus', exon_count=14, OMIM=[602214], no_hdr0=''),
    1456 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1456, CurrentID=0, Status='live', Symbol='CSNK1G3', Aliases=['CKI-gamma 3L', 'CSNK1G3'], description='casein kinase 1 gamma 3', other_designations='casein kinase I isoform gamma-3|casein kinase I', map_location='5q23.2', chromosome='5', genomic_nucleotide_accession_version='NC_000005.10', start_position_on_the_genomic_accession=123512116, end_position_on_the_genomic_accession=123617049, orientation='plus', exon_count=18, OMIM=[604253], no_hdr0=''),
    1457 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1457, CurrentID=0, Status='live', Symbol='CSNK2A1', Aliases=['CK2A1', 'CKII', 'Cka1', 'Cka2', 'OCNDS'], description='casein kinase 2 alpha 1', other_designations='casein kinase II subunit alpha|CK2 catalytic subunit alpha|casein kinase 2, alpha 1 polypeptide|casein kinase II alpha 1 polypeptide pseudogene|casein kinase II alpha 1 subunit|protein kinase CK2', map_location='20p13', chromosome='20', genomic_nucleotide_accession_version='NC_000020.11', start_position_on_the_genomic_accession=472498, end_position_on_the_genomic_accession=543790, orientation='minus', exon_count=14, OMIM=[115440], no_hdr0=''),
    1459 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1459, CurrentID=0, Status='live', Symbol='CSNK2A2', Aliases=['CK2A2', "CK2alpha'", 'CSNK2A1'], description='casein kinase 2 alpha 2', other_designations="casein kinase II subunit alpha'|CK II alpha'|casein kinase 2 alpha'|casein kinase 2, alpha prime polypeptide", map_location='16q21', chromosome='16', genomic_nucleotide_accession_version='NC_000016.10', start_position_on_the_genomic_accession=58157907, end_position_on_the_genomic_accession=58198106, orientation='minus', exon_count=13, OMIM=[115442], no_hdr0=''),
    1460 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1460, CurrentID=0, Status='live', Symbol='CSNK2B', Aliases=['CK2B', 'CK2N', 'CSK2B', 'Ckb1', 'Ckb2', 'G5A', 'POBINDS'], description='casein kinase 2 beta', other_designations='casein kinase II subunit beta|CK II beta|CSNK2B-LY6G5B-1072|CSNK2B-LY6G5B-1103|CSNK2B-LY6G5B-532|CSNK2B-LY6G5B-560|CSNK2B-LY6G5B-562|Casein kinase II beta subunit|alternative name: G5a, phosvitin|casein kinase 2, beta polypeptide|phosvitin|protein G5a', map_location='6p21.33', chromosome='6', genomic_nucleotide_accession_version='NC_000006.12', start_position_on_the_genomic_accession=31666080, end_position_on_the_genomic_accession=31670067, orientation='plus', exon_count=7, OMIM=[115441], no_hdr0=''),
    1462 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1462, CurrentID=0, Status='live', Symbol='VCAN', Aliases=['CSPG2', 'ERVR', 'GHAP', 'PG-M', 'WGN', 'WGN1'], description='versican', other_designations='versican core protein|chondroitin sulfate proteoglycan core protein 2|glial hyaluronate-binding protein|large fibroblast proteoglycan|versican proteoglycan', map_location='5q14.2-q14.3', chromosome='5', genomic_nucleotide_accession_version='NC_000005.10', start_position_on_the_genomic_accession=83471744, end_position_on_the_genomic_accession=83582302, orientation='plus', exon_count=15, OMIM=[118661], no_hdr0=''),
    1463 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1463, CurrentID=0, Status='live', Symbol='NCAN', Aliases=['CSPG3'], description='neurocan', other_designations='neurocan core protein|chondroitin sulfate proteoglycan 3 (neurocan)|neurocan proteoglycan', map_location='19p13.11', chromosome='19', genomic_nucleotide_accession_version='NC_000019.10', start_position_on_the_genomic_accession=19211958, end_position_on_the_genomic_accession=19252233, orientation='plus', exon_count=15, OMIM=[600826], no_hdr0=''),
    1464 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1464, CurrentID=0, Status='live', Symbol='CSPG4', Aliases=['CSPG4A', 'HMW-MAA', 'MCSP', 'MCSPG', 'MEL-CSPG', 'MSK16', 'NG2'], description='chondroitin sulfate proteoglycan 4', other_designations='chondroitin sulfate proteoglycan 4|chondroitin sulfate proteoglycan 4 (melanoma-associated)|chondroitin sulfate proteoglycan NG2|melanoma chondroitin sulfate proteoglycan|melanoma-associated chondroitin sulfate proteoglycan', map_location='15q24.2', chromosome='15', genomic_nucleotide_accession_version='NC_000015.10', start_position_on_the_genomic_accession=75674322, end_position_on_the_genomic_accession=75712848, orientation='minus', exon_count=10, OMIM=[601172], no_hdr0=''),
    1465 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1465, CurrentID=0, Status='live', Symbol='CSRP1', Aliases=['CRP', 'CRP1', 'CSRP', 'CYRP', 'D1S181E', 'HEL-141', 'HEL-S-286'], description='cysteine and glycine rich protein 1', other_designations='cysteine and glycine-rich protein 1|LIM-domain protein|cysteine-rich protein 1|epididymis luminal protein 141|epididymis secretory protein Li 286|epididymis secretory sperm binding protein', map_location='1q32.1', chromosome='1', genomic_nucleotide_accession_version='NC_000001.11', start_position_on_the_genomic_accession=201483530, end_position_on_the_genomic_accession=201507123, orientation='minus', exon_count=8, OMIM=[123876], no_hdr0=''),
    1466 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1466, CurrentID=0, Status='live', Symbol='CSRP2', Aliases=['CRP2', 'LMO5', 'SmLIM'], description='cysteine and glycine rich protein 2', other_designations='cysteine and glycine-rich protein 2|LIM domain only 5, smooth muscle|LIM domain only protein 5|LMO-5|cysteine-rich protein 2|epididymis secretory sperm binding protein|smooth muscle cell LIM protein', map_location='12q21.2', chromosome='12', genomic_nucleotide_accession_version='NC_000012.12', start_position_on_the_genomic_accession=76858709, end_position_on_the_genomic_accession=76879019, orientation='minus', exon_count=6, OMIM=[601871], no_hdr0=''),
    1468 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1468, CurrentID=0, Status='live', Symbol='SLC25A10', Aliases=['DIC', 'MTDPS19'], description='solute carrier family 25 member 10', other_designations='mitochondrial dicarboxylate carrier|dicarboxylate ion carrier|solute carrier family 25 (mitochondrial carrier; dicarboxylate transporter), member 10', map_location='17q25.3', chromosome='17', genomic_nucleotide_accession_version='NC_000017.11', start_position_on_the_genomic_accession=81712284, end_position_on_the_genomic_accession=81721012, orientation='plus', exon_count=12, OMIM=[606794], no_hdr0=''),
    1469 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1469, CurrentID=0, Status='live', Symbol='CST1', Aliases=[], description='cystatin SN', other_designations='cystatin-SN|cystain-SA-I|cystatin 1|cystatin SA-I|cysteine proteinase inhibitor, type 2 family|salivary cystatin-SA-1', map_location='20p11.21', chromosome='20', genomic_nucleotide_accession_version='NC_000020.11', start_position_on_the_genomic_accession=23747562, end_position_on_the_genomic_accession=23750935, orientation='minus', exon_count=3, OMIM=[123855], no_hdr0=''),
    1470 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1470, CurrentID=0, Status='live', Symbol='CST2', Aliases=[], description='cystatin SA', other_designations='cystatin-SA|cystatin 2|cystatin S5|cysteine-proteinase inhibitor|salivary cysteine (thiol) protease inhibitor', map_location='20p11.21', chromosome='20', genomic_nucleotide_accession_version='NC_000020.11', start_position_on_the_genomic_accession=23823769, end_position_on_the_genomic_accession=23826729, orientation='minus', exon_count=3, OMIM=[123856], no_hdr0=''),
    1471 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1471, CurrentID=0, Status='live', Symbol='CST3', Aliases=['ARMD11', 'HEL-S-2'], description='cystatin C', other_designations='cystatin-C|bA218C14.4 (cystatin C)|cystatin 3|epididymis secretory protein Li 2|gamma-trace|neuroendocrine basic polypeptide|post-gamma-globulin', map_location='20p11.21', chromosome='20', genomic_nucleotide_accession_version='NC_000020.11', start_position_on_the_genomic_accession=23626706, end_position_on_the_genomic_accession=23637955, orientation='minus', exon_count=4, OMIM=[604312], no_hdr0=''),
    1472 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1472, CurrentID=0, Status='live', Symbol='CST4', Aliases=[], description='cystatin S', other_designations='cystatin-S|cystatin 4|cystatin-SA-III|salivary acidic protein 1', map_location='20p11.21', chromosome='20', genomic_nucleotide_accession_version='NC_000020.11', start_position_on_the_genomic_accession=23685640, end_position_on_the_genomic_accession=23689038, orientation='minus', exon_count=3, OMIM=[123857], no_hdr0=''),
    1473 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1473, CurrentID=0, Status='live', Symbol='CST5', Aliases=[], description='cystatin D', other_designations='cystatin-D|cystatin 5|cysteine-proteinase inhibitor', map_location='20p11.21', chromosome='20', genomic_nucleotide_accession_version='NC_000020.11', start_position_on_the_genomic_accession=23875934, end_position_on_the_genomic_accession=23879748, orientation='minus', exon_count=3, OMIM=[123858], no_hdr0=''),
    1474 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1474, CurrentID=0, Status='live', Symbol='CST6', Aliases=['ECTD15'], description='cystatin E/M', other_designations='cystatin-M|cystatin 6|cystatin M/E|cystatin-E|cysteine proteinase inhibitor', map_location='11q13.1', chromosome='11', genomic_nucleotide_accession_version='NC_000011.10', start_position_on_the_genomic_accession=66012008, end_position_on_the_genomic_accession=66013505, orientation='plus', exon_count=3, OMIM=[601891], no_hdr0=''),
    1475 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1475, CurrentID=0, Status='live', Symbol='CSTA', Aliases=['AREI', 'PSS4', 'STF1', 'STFA'], description='cystatin A', other_designations='cystatin-A|cystatin A (stefin A)|cystatin AS', map_location='3q21.1', chromosome='3', genomic_nucleotide_accession_version='NC_000003.12', start_position_on_the_genomic_accession=122325248, end_position_on_the_genomic_accession=122341969, orientation='plus', exon_count=3, OMIM=[184600], no_hdr0=''),
    1476 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1476, CurrentID=0, Status='live', Symbol='CSTB', Aliases=['CPI-B', 'CST6', 'EPM1', 'EPM1A', 'PME', 'STFB', 'ULD'], description='cystatin B', other_designations='cystatin-B|cystatin B (stefin B)|epididymis secretory sperm binding protein|liver thiol proteinase inhibitor', map_location='21q22.3', chromosome='21', genomic_nucleotide_accession_version='NC_000021.9', start_position_on_the_genomic_accession=43773950, end_position_on_the_genomic_accession=43776308, orientation='minus', exon_count=3, OMIM=[601145], no_hdr0=''),
    1477 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1477, CurrentID=0, Status='live', Symbol='CSTF1', Aliases=['CstF-50', 'CstFp50'], description='cleavage stimulation factor subunit 1', other_designations="cleavage stimulation factor subunit 1|CF-1 50 kDa subunit|CSTF 50 kDa subunit|cleavage stimulation factor 50 kDa subunit|cleavage stimulation factor, 3' pre-RNA, subunit 1, 50kD|cleavage stimulation factor, 3' pre-RNA, subunit 1, 50kDa", map_location='20q13.2-q13.31', chromosome='20', genomic_nucleotide_accession_version='NC_000020.11', start_position_on_the_genomic_accession=56392379, end_position_on_the_genomic_accession=56406362, orientation='plus', exon_count=7, OMIM=[600369], no_hdr0=''),
    1478 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1478, CurrentID=0, Status='live', Symbol='CSTF2', Aliases=['CstF-64'], description='cleavage stimulation factor subunit 2', other_designations="cleavage stimulation factor subunit 2|CF-1 64 kDa subunit|CSTF 64 kDa subunit|betaCstF-64 variant 2|cleavage stimulation factor 64 kDa subunit|cleavage stimulation factor, 3' pre-RNA, subunit 2, 64kD|cleavage stimulation factor, 3' pre-RNA, subunit 2, 64kDa", map_location='Xq22.1', chromosome='X', genomic_nucleotide_accession_version='NC_000023.11', start_position_on_the_genomic_accession=100820369, end_position_on_the_genomic_accession=100843534, orientation='plus', exon_count=14, OMIM=[300907], no_hdr0=''),
    1479 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1479, CurrentID=0, Status='live', Symbol='CSTF3', Aliases=['CSTF-77'], description='cleavage stimulation factor subunit 3', other_designations="cleavage stimulation factor subunit 3|CF-1 77 kDa subunit|CSTF 77 kDa subunit|cleavage stimulation factor 77 kDa subunit|cleavage stimulation factor, 3' pre-RNA, subunit 3, 77kD|cleavage stimulation factor, 3' pre-RNA, subunit 3, 77kDa", map_location='11p13', chromosome='11', genomic_nucleotide_accession_version='NC_000011.10', start_position_on_the_genomic_accession=33084584, end_position_on_the_genomic_accession=33161480, orientation='minus', exon_count=21, OMIM=[600367], no_hdr0=''),
    1482 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1482, CurrentID=0, Status='live', Symbol='NKX2-5', Aliases=['CHNG5', 'CSX', 'CSX1', 'HLHS2', 'NKX2.5', 'NKX2E', 'NKX4-1', 'VSD3'], description='NK2 homeobox 5', other_designations='homeobox protein Nkx-2.5|NK2 transcription factor related, locus 5|NKX 2-5|cardiac-specific homeobox 1|homeobox protein CSX|homeobox protein NK-2 homolog E|homeobox protein NKX 2-5|tinman homolog|tinman paralog', map_location='5q35.1', chromosome='5', genomic_nucleotide_accession_version='NC_000005.10', start_position_on_the_genomic_accession=173232109, end_position_on_the_genomic_accession=173235321, orientation='minus', exon_count=3, OMIM=[600584], no_hdr0=''),
    1485 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1485, CurrentID=0, Status='live', Symbol='CTAG1B', Aliases=['CT6.1', 'CTAG', 'CTAG1', 'ESO1', 'LAGE-2', 'LAGE2B', 'NY-ESO-1'], description='cancer/testis antigen 1B', other_designations='cancer/testis antigen 1|New York esophageal squamous cell carcinoma 1|autoimmunogenic cancer/testis antigen NY-ESO-1|cancer antigen 3|cancer/testis antigen 6.1|l antigen family member 2', map_location='Xq28', chromosome='X', genomic_nucleotide_accession_version='NC_000023.11', start_position_on_the_genomic_accession=154617609, end_position_on_the_genomic_accession=154619282, orientation='minus', exon_count=3, OMIM=[300156], no_hdr0=''),
    1486 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1486, CurrentID=0, Status='live', Symbol='CTBS', Aliases=['CTB'], description='chitobiase', other_designations='di-N-acetylchitobiase|chitobiase, di-N-acetyl-', map_location='1p22.3', chromosome='1', genomic_nucleotide_accession_version='NC_000001.11', start_position_on_the_genomic_accession=84549611, end_position_on_the_genomic_accession=84574440, orientation='minus', exon_count=7, OMIM=[600873], no_hdr0=''),
    1487 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1487, CurrentID=0, Status='live', Symbol='CTBP1', Aliases=['BARS', 'HADDTS'], description='C-terminal binding protein 1', other_designations='C-terminal-binding protein 1|brefeldin A-ribosylated substrate', map_location='4p16.3', chromosome='4', genomic_nucleotide_accession_version='NC_000004.12', start_position_on_the_genomic_accession=1211444, end_position_on_the_genomic_accession=1250355, orientation='minus', exon_count=15, OMIM=[602618], no_hdr0=''),
    1488 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1488, CurrentID=0, Status='live', Symbol='CTBP2', Aliases=[], description='C-terminal binding protein 2', other_designations='C-terminal-binding protein 2|ribeye', map_location='10q26.13', chromosome='10', genomic_nucleotide_accession_version='NC_000010.11', start_position_on_the_genomic_accession=124984317, end_position_on_the_genomic_accession=125161039, orientation='minus', exon_count=20, OMIM=[602619], no_hdr0=''),
    1489 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1489, CurrentID=0, Status='live', Symbol='CTF1', Aliases=['CT-1', 'CT1'], description='cardiotrophin 1', other_designations='cardiotrophin-1|cardiophin 1', map_location='16p11.2', chromosome='16', genomic_nucleotide_accession_version='NC_000016.10', start_position_on_the_genomic_accession=30895824, end_position_on_the_genomic_accession=30903560, orientation='plus', exon_count=4, OMIM=[600435], no_hdr0=''),
    1490 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1490, CurrentID=0, Status='live', Symbol='CCN2', Aliases=['CTGF', 'HCS24', 'IGFBP8', 'NOV2'], description='cellular communication network factor 2', other_designations='CCN family member 2|IBP-8|IGF-binding protein 8|IGFBP-8|connective tissue growth factor|hypertrophic chondrocyte-specific protein 24|insulin-like growth factor-binding protein 8', map_location='6q23.2', chromosome='6', genomic_nucleotide_accession_version='NC_000006.12', start_position_on_the_genomic_accession=131948176, end_position_on_the_genomic_accession=131951372, orientation='minus', exon_count=5, OMIM=[121009], no_hdr0=''),
    1491 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1491, CurrentID=0, Status='live', Symbol='CTH', Aliases=[], description='cystathionine gamma-lyase', other_designations='cystathionine gamma-lyase|cystathionase (cystathionine gamma-lyase)|cysteine desulfhydrase|cysteine-protein sulfhydrase|gamma-cystathionase|homoserine deaminase|homoserine dehydratase', map_location='1p31.1', chromosome='1', genomic_nucleotide_accession_version='NC_000001.11', start_position_on_the_genomic_accession=70411268, end_position_on_the_genomic_accession=70441949, orientation='plus', exon_count=13, OMIM=[607657], no_hdr0=''),
    1493 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1493, CurrentID=0, Status='live', Symbol='CTLA4', Aliases=['ALPS5', 'CD', 'CD152', 'CELIAC3', 'CTLA-4', 'GRD4', 'GSE', 'IDDM12'], description='cytotoxic T-lymphocyte associated protein 4', other_designations='cytotoxic T-lymphocyte protein 4|celiac disease 3|cytotoxic T lymphocyte associated antigen 4 short spliced form|cytotoxic T-lymphocyte-associated serine esterase-4|insulin-dependent diabetes mellitus 12|ligand and transmembrane spliced cytotoxic T lymphocyte associated antigen 4', map_location='2q33.2', chromosome='2', genomic_nucleotide_accession_version='NC_000002.12', start_position_on_the_genomic_accession=203867771, end_position_on_the_genomic_accession=203873965, orientation='plus', exon_count=4, OMIM=[123890], no_hdr0=''),
    1495 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1495, CurrentID=0, Status='live', Symbol='CTNNA1', Aliases=['CAP102', 'MDPT2'], description='catenin alpha 1', other_designations='catenin alpha-1|alpha-E-catenin|catenin (cadherin-associated protein), alpha 1, 102kDa|epididymis secretory sperm binding protein|renal carcinoma antigen NY-REN-13', map_location='5q31.2', chromosome='5', genomic_nucleotide_accession_version='NC_000005.10', start_position_on_the_genomic_accession=138753425, end_position_on_the_genomic_accession=138935034, orientation='plus', exon_count=27, OMIM=[116805], no_hdr0=''),
    1496 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1496, CurrentID=0, Status='live', Symbol='CTNNA2', Aliases=['CAP-R', 'CAPR', 'CDCBM9', 'CT114', 'CTNR'], description='catenin alpha 2', other_designations='catenin alpha-2|alpha-N-catenin|alpha-catenin-related protein|cadherin-associated protein, related|cancer/testis antigen 114|catenin (cadherin-associated protein), alpha 2', map_location='2p12', chromosome='2', genomic_nucleotide_accession_version='NC_000002.12', start_position_on_the_genomic_accession=79505054, end_position_on_the_genomic_accession=80648788, orientation='plus', exon_count=29, OMIM=[114025], no_hdr0=''),
    1497 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1497, CurrentID=0, Status='live', Symbol='CTNS', Aliases=['CTNS-LSB', 'PQLC4', 'SLC66A4'], description='cystinosin, lysosomal cystine transporter', other_designations='cystinosin|cystinosis nephropathic', map_location='17p13.2', chromosome='17', genomic_nucleotide_accession_version='NC_000017.11', start_position_on_the_genomic_accession=3636459, end_position_on_the_genomic_accession=3663103, orientation='plus', exon_count=14, OMIM=[606272], no_hdr0=''),
    1499 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1499, CurrentID=0, Status='live', Symbol='CTNNB1', Aliases=['CTNNB', 'EVR7', 'MRD19', 'NEDSDV', 'armadillo'], description='catenin beta 1', other_designations='catenin beta-1|catenin (cadherin-associated protein), beta 1, 88kDa', map_location='3p22.1', chromosome='3', genomic_nucleotide_accession_version='NC_000003.12', start_position_on_the_genomic_accession=41199422, end_position_on_the_genomic_accession=41240445, orientation='plus', exon_count=19, OMIM=[116806], no_hdr0=''),
    1500 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1500, CurrentID=0, Status='live', Symbol='CTNND1', Aliases=['BCDS2', 'CAS', 'CTNND', 'P120CAS', 'P120CTN', 'p120', 'p120(CAS)', 'p120(CTN)'], description='catenin delta 1', other_designations='catenin delta-1|cadherin-associated Src substrate|catenin (cadherin-associated protein), delta 1|p120 catenin', map_location='11q12.1', chromosome='11', genomic_nucleotide_accession_version='NC_000011.10', start_position_on_the_genomic_accession=57761802, end_position_on_the_genomic_accession=57819540, orientation='plus', exon_count=21, OMIM=[601045], no_hdr0=''),
    1501 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1501, CurrentID=0, Status='live', Symbol='CTNND2', Aliases=['GT24', 'NPRAP'], description='catenin delta 2', other_designations='catenin delta-2|T-cell delta-catenin|catenin (cadherin-associated protein), delta 2 (neural plakophilin-related arm-repeat protein)|neurojungin', map_location='5p15.2', chromosome='5', genomic_nucleotide_accession_version='NC_000005.10', start_position_on_the_genomic_accession=10971836, end_position_on_the_genomic_accession=11904446, orientation='minus', exon_count=26, OMIM=[604275], no_hdr0=''),
    1503 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1503, CurrentID=0, Status='live', Symbol='CTPS1', Aliases=['CTPS', 'GATD5', 'IMD24'], description='CTP synthase 1', other_designations="CTP synthase 1|CTP synthetase 1|UTP--ammonia ligase 1|cytidine 5'-triphosphate synthetase|cytidine 5-prime triphosphate synthetase", map_location='1p34.2', chromosome='1', genomic_nucleotide_accession_version='NC_000001.11', start_position_on_the_genomic_accession=40979696, end_position_on_the_genomic_accession=41012565, orientation='plus', exon_count=22, OMIM=[123860], no_hdr0=''),
    1504 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1504, CurrentID=0, Status='live', Symbol='CTRB1', Aliases=['CTRB'], description='chymotrypsinogen B1', other_designations='chymotrypsinogen B', map_location='16q23.1', chromosome='16', genomic_nucleotide_accession_version='NC_000016.10', start_position_on_the_genomic_accession=75218988, end_position_on_the_genomic_accession=75224924, orientation='plus', exon_count=7, OMIM=[118890], no_hdr0=''),
    1506 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1506, CurrentID=0, Status='live', Symbol='CTRL', Aliases=['CTRL1'], description='chymotrypsin like', other_designations='chymotrypsin-like protease CTRL-1', map_location='16q22.1', chromosome='16', genomic_nucleotide_accession_version='NC_000016.10', start_position_on_the_genomic_accession=67929574, end_position_on_the_genomic_accession=67931862, orientation='minus', exon_count=7, OMIM=[118888], no_hdr0=''),
    1508 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1508, CurrentID=0, Status='live', Symbol='CTSB', Aliases=['APPS', 'CPSB', 'RECEUP'], description='cathepsin B', other_designations='cathepsin B|APP secretase|amyloid precursor protein secretase|cathepsin B1|cysteine protease|epididymis secretory sperm binding protein', map_location='8p23.1', chromosome='8', genomic_nucleotide_accession_version='NC_000008.11', start_position_on_the_genomic_accession=11842524, end_position_on_the_genomic_accession=11868087, orientation='minus', exon_count=15, OMIM=[116810], no_hdr0=''),
    1509 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1509, CurrentID=0, Status='live', Symbol='CTSD', Aliases=['CLN10', 'CPSD', 'HEL-S-130P'], description='cathepsin D', other_designations='cathepsin D|ceroid-lipofuscinosis, neuronal 10|epididymis secretory sperm binding protein Li 130P|lysosomal aspartyl peptidase|lysosomal aspartyl protease', map_location='11p15.5', chromosome='11', genomic_nucleotide_accession_version='NC_000011.10', start_position_on_the_genomic_accession=1752755, end_position_on_the_genomic_accession=1763927, orientation='minus', exon_count=9, OMIM=[116840], no_hdr0=''),
    1510 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1510, CurrentID=0, Status='live', Symbol='CTSE', Aliases=['CATE'], description='cathepsin E', other_designations='cathepsin E|erythrocyte membrane aspartic proteinase|slow-moving proteinase', map_location='1q32.1', chromosome='1', genomic_nucleotide_accession_version='NC_000001.11', start_position_on_the_genomic_accession=206009264, end_position_on_the_genomic_accession=206023899, orientation='minus', exon_count=9, OMIM=[116890], no_hdr0=''),
    1511 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1511, CurrentID=0, Status='live', Symbol='CTSG', Aliases=['CATG', 'CG'], description='cathepsin G', other_designations='cathepsin G', map_location='14q12', chromosome='14', genomic_nucleotide_accession_version='NC_000014.9', start_position_on_the_genomic_accession=24573518, end_position_on_the_genomic_accession=24576250, orientation='minus', exon_count=5, OMIM=[116830], no_hdr0=''),
    1512 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1512, CurrentID=0, Status='live', Symbol='CTSH', Aliases=['ACC-4', 'ACC-5', 'ACC4', 'ACC5', 'CPSB'], description='cathepsin H', other_designations='pro-cathepsin H|N-benzoylarginine-beta-naphthylamide hydrolase|aleurain|cathepsin B3|cathepsin BA', map_location='15q25.1', chromosome='15', genomic_nucleotide_accession_version='NC_000015.10', start_position_on_the_genomic_accession=78921058, end_position_on_the_genomic_accession=78945089, orientation='minus', exon_count=14, OMIM=[116820], no_hdr0=''),
    1513 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1513, CurrentID=0, Status='live', Symbol='CTSK', Aliases=['CTS02', 'CTSO', 'CTSO1', 'CTSO2', 'PKND', 'PYCD'], description='cathepsin K', other_designations='cathepsin K|cathepsin O|cathepsin O1|cathepsin O2|cathepsin X', map_location='1q21.3', chromosome='1', genomic_nucleotide_accession_version='NC_000001.11', start_position_on_the_genomic_accession=150796208, end_position_on_the_genomic_accession=150808260, orientation='minus', exon_count=8, OMIM=[601105], no_hdr0=''),
    1514 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1514, CurrentID=0, Status='live', Symbol='CTSL', Aliases=['CATL1', 'MEP', 'CTSL'], description='cathepsin L', other_designations='cathepsin L1|major excreted protein', map_location='9q21.33', chromosome='9', genomic_nucleotide_accession_version='NC_000009.12', start_position_on_the_genomic_accession=87726119, end_position_on_the_genomic_accession=87731469, orientation='plus', exon_count=9, OMIM=[116880], no_hdr0=''),
    1515 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1515, CurrentID=0, Status='live', Symbol='CTSV', Aliases=['CATL2', 'CTSL2', 'CTSU'], description='cathepsin V', other_designations='cathepsin L2|cathepsin L2, preproprotein|cathepsin U', map_location='9q22.33', chromosome='9', genomic_nucleotide_accession_version='NC_000009.12', start_position_on_the_genomic_accession=97029677, end_position_on_the_genomic_accession=97039643, orientation='minus', exon_count=9, OMIM=[603308], no_hdr0=''),
    1519 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1519, CurrentID=0, Status='live', Symbol='CTSO', Aliases=['CTSO1'], description='cathepsin O', other_designations='cathepsin O', map_location='4q32.1', chromosome='4', genomic_nucleotide_accession_version='NC_000004.12', start_position_on_the_genomic_accession=155924118, end_position_on_the_genomic_accession=155953866, orientation='minus', exon_count=8, OMIM=[600550], no_hdr0=''),
    1520 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1520, CurrentID=0, Status='live', Symbol='CTSS', Aliases=[], description='cathepsin S', other_designations='cathepsin S', map_location='1q21.3', chromosome='1', genomic_nucleotide_accession_version='NC_000001.11', start_position_on_the_genomic_accession=150730188, end_position_on_the_genomic_accession=150765778, orientation='minus', exon_count=8, OMIM=[116845], no_hdr0=''),
    1521 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1521, CurrentID=0, Status='live', Symbol='CTSW', Aliases=['LYPN'], description='cathepsin W', other_designations='cathepsin W|lymphopain', map_location='11q13.1', chromosome='11', genomic_nucleotide_accession_version='NC_000011.10', start_position_on_the_genomic_accession=65879837, end_position_on_the_genomic_accession=65883741, orientation='plus', exon_count=10, OMIM=[602364], no_hdr0=''),
    1522 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1522, CurrentID=0, Status='live', Symbol='CTSZ', Aliases=['CTSX'], description='cathepsin Z', other_designations='cathepsin Z|carboxypeptidase LB|cathepsin B2|cathepsin IV|cathepsin P|cathepsin X|cathepsin Y|cathepsin Z1|cysteine-type carboxypeptidase|lysosomal carboxypeptidase B|preprocathepsin P', map_location='20q13.32', chromosome='20', genomic_nucleotide_accession_version='NC_000020.11', start_position_on_the_genomic_accession=58995185, end_position_on_the_genomic_accession=59007254, orientation='minus', exon_count=6, OMIM=[603169], no_hdr0=''),
    1523 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1523, CurrentID=0, Status='live', Symbol='CUX1', Aliases=['CASP', 'CDP', 'CDP/Cut', 'CDP1', 'COY1', 'CUTL1', 'CUX', 'Clox', 'Cux/CDP', 'GDDI', 'GOLIM6', 'Nbla10317', 'p100', 'p110', 'p200', 'p75'], description='cut like homeobox 1', other_designations='protein CASP|Homeobox protein cut-like 1|CCAAT displacement protein|CUX1 gene Alternatively Spliced Product|cut homolog|golgi integral membrane protein 6|homeobox protein cux-1|mutant CUX1|putative protein product of Nbla10317', map_location='7q22.1', chromosome='7', genomic_nucleotide_accession_version='NC_000007.14', start_position_on_the_genomic_accession=101815991, end_position_on_the_genomic_accession=102283958, orientation='plus', exon_count=34, OMIM=[116896], no_hdr0=''),
    1524 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1524, CurrentID=0, Status='live', Symbol='CX3CR1', Aliases=['CCRL1', 'CMKBRL1', 'CMKDR1', 'GPR13', 'GPRV28', 'V28'], description='C-X3-C motif chemokine receptor 1', other_designations='CX3C chemokine receptor 1|C-X3-C CKR-1|CMK-BRL-1|CMK-BRL1|G-protein coupled receptor 13|beta chemokine receptor-like 1|chemokine (C-C) receptor-like 1|chemokine (C-X3-C motif) receptor 1|chemokine (C-X3-C) receptor 1|fractalkine receptor', map_location='3p22.2', chromosome='3', genomic_nucleotide_accession_version='NC_000003.12', start_position_on_the_genomic_accession=39263494, end_position_on_the_genomic_accession=39281735, orientation='minus', exon_count=5, OMIM=[601470], no_hdr0=''),
    1525 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1525, CurrentID=0, Status='live', Symbol='CXADR', Aliases=['CAR', 'CAR4/6', 'HCAR'], description='CXADR Ig-like cell adhesion molecule', other_designations='coxsackievirus and adenovirus receptor|46 kD coxsackievirus and adenovirus receptor (CAR) protein|CVB3-binding protein|HCVADR|coxsackie virus and adenovirus receptor|coxsackievirus B-adenovirus receptor', map_location='21q21.1', chromosome='21', genomic_nucleotide_accession_version='NC_000021.9', start_position_on_the_genomic_accession=17513016, end_position_on_the_genomic_accession=17636213, orientation='plus', exon_count=10, OMIM=[602621], no_hdr0=''),
    1527 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1527, CurrentID=0, Status='live', Symbol='TEX28', Aliases=['CXorf2', 'MRX99P1', 'TEX28P2', 'fTEX', 'TEX28'], description='testis expressed 28', other_designations='testis-specific protein TEX28', map_location='Xq28', chromosome='X', genomic_nucleotide_accession_version='NC_000023.11', start_position_on_the_genomic_accession=154271265, end_position_on_the_genomic_accession=154295356, orientation='minus', exon_count=8, OMIM=[300092], no_hdr0=''),
    1528 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1528, CurrentID=0, Status='live', Symbol='CYB5A', Aliases=['CYB5', 'MCB5', 'METAG'], description='cytochrome b5 type A', other_designations='cytochrome b5|cytochrome b5 type A (microsomal)|epididymis secretory sperm binding protein|type 1 cyt-b5', map_location='18q22.3', chromosome='18', genomic_nucleotide_accession_version='NC_000018.10', start_position_on_the_genomic_accession=74250846, end_position_on_the_genomic_accession=74291980, orientation='minus', exon_count=6, OMIM=[613218], no_hdr0=''),
    1534 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1534, CurrentID=0, Status='live', Symbol='CYB561', Aliases=['CYB561A1', 'FRRS2', 'ORTHYP2'], description='cytochrome b561', other_designations='cytochrome b561|cytochrome b-561|cytochrome b561 family, member A1|ferric-chelate reductase 2', map_location='17q23.3', chromosome='17', genomic_nucleotide_accession_version='NC_000017.11', start_position_on_the_genomic_accession=63432304, end_position_on_the_genomic_accession=63446639, orientation='minus', exon_count=8, OMIM=[600019], no_hdr0=''),
    1535 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1535, CurrentID=0, Status='live', Symbol='CYBA', Aliases=['CGD4', 'p22-PHOX'], description='cytochrome b-245 alpha chain', other_designations='cytochrome b-245 light chain|cytochrome b light chain|cytochrome b(558) alpha chain|cytochrome b(558) alpha-subunit|cytochrome b, alpha polypeptide|cytochrome b-245, alpha polypeptide|cytochrome b558 subunit alpha|flavocytochrome b-558 alpha polypeptide|neutrophil cytochrome b 22 kDa polypeptide|p22 phagocyte B-cytochrome|p22phox|superoxide-generating NADPH oxidase light chain subunit', map_location='16q24.2', chromosome='16', genomic_nucleotide_accession_version='NC_000016.10', start_position_on_the_genomic_accession=88643289, end_position_on_the_genomic_accession=88651079, orientation='minus', exon_count=7, OMIM=[608508], no_hdr0=''),
    1536 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1536, CurrentID=0, Status='live', Symbol='CYBB', Aliases=['AMCBX2', 'CGD', 'GP91-1', 'GP91-PHOX', 'GP91PHOX', 'IMD34', 'NOX2', 'p91-PHOX'], description='cytochrome b-245 beta chain', other_designations='cytochrome b-245 heavy chain|CGD91-phox|NADPH oxidase 2|cytochrome b(558) subunit beta|cytochrome b-245 beta polypeptide|cytochrome b558 subunit beta|heme-binding membrane glycoprotein gp91phox|neutrophil cytochrome b 91 kDa polypeptide|p22 phagocyte B-cytochrome|superoxide-generating NADPH oxidase heavy chain subunit', map_location='Xp21.1-p11.4', chromosome='X', genomic_nucleotide_accession_version='NC_000023.11', start_position_on_the_genomic_accession=37780059, end_position_on_the_genomic_accession=37813461, orientation='plus', exon_count=13, OMIM=[300481], no_hdr0=''),
    1537 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1537, CurrentID=0, Status='live', Symbol='CYC1', Aliases=['MC3DN6', 'UQCR4'], description='cytochrome c1', other_designations='cytochrome c1, heme protein, mitochondrial|complex III subunit 4|complex III subunit IV|cytochrome b-c1 complex subunit 4|cytochrome c-1|ubiquinol-cytochrome-c reductase complex cytochrome c1 subunit', map_location='8q24.3', chromosome='8', genomic_nucleotide_accession_version='NC_000008.11', start_position_on_the_genomic_accession=144095076, end_position_on_the_genomic_accession=144097525, orientation='plus', exon_count=8, OMIM=[123980], no_hdr0=''),
    1538 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1538, CurrentID=0, Status='live', Symbol='CYLC1', Aliases=['CYCL1'], description='cylicin 1', other_designations='cylicin-1|cylicin I|cylicin, basic protein of sperm head cytoskeleton 1|multiple-band polypeptide I', map_location='Xq21.1', chromosome='X', genomic_nucleotide_accession_version='NC_000023.11', start_position_on_the_genomic_accession=83861135, end_position_on_the_genomic_accession=83886700, orientation='plus', exon_count=5, OMIM=[300768], no_hdr0=''),
    1539 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1539, CurrentID=0, Status='live', Symbol='CYLC2', Aliases=[], description='cylicin 2', other_designations='cylicin-2|cylicin II|cylicin, basic protein of sperm head cytoskeleton 2|multiple-band polypeptide II', map_location='9q31.1', chromosome='9', genomic_nucleotide_accession_version='NC_000009.12', start_position_on_the_genomic_accession=102995333, end_position_on_the_genomic_accession=103018488, orientation='plus', exon_count=8, OMIM=[604035], no_hdr0=''),
    1540 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1540, CurrentID=0, Status='live', Symbol='CYLD', Aliases=['BRSS', 'CDMT1', 'CYLDI', 'EAC', 'MFT', 'MFT1', 'SBS', 'TEM', 'USPL2', 'CYLD'], description='CYLD lysine 63 deubiquitinase', other_designations='ubiquitin carboxyl-terminal hydrolase CYLD|cylindromatosis (turban tumor syndrome)|deubiquitinating enzyme CYLD|probable ubiquitin carboxyl-terminal hydrolase CYLD|ubiquitin specific peptidase like 2|ubiquitin thioesterase CYLD|ubiquitin thiolesterase CYLD|ubiquitin-specific-processing protease CYLD', map_location='16q12.1', chromosome='16', genomic_nucleotide_accession_version='NC_000016.10', start_position_on_the_genomic_accession=50742086, end_position_on_the_genomic_accession=50801935, orientation='plus', exon_count=23, OMIM=[605018], no_hdr0=''),
    1543 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1543, CurrentID=0, Status='live', Symbol='CYP1A1', Aliases=['AHH', 'AHRR', 'CP11', 'CYP1', 'CYPIA1', 'P1-450', 'P450-C', 'P450DX'], description='cytochrome P450 family 1 subfamily A member 1', other_designations='cytochrome P450 1A1|aryl hydrocarbon hydroxylase|cytochrome P1-450, dioxin-inducible|cytochrome P450 form 6|cytochrome P450, family 1, subfamily A, polypeptide 1|cytochrome P450, subfamily I (aromatic compound-inducible), polypeptide 1|cytochrome P450-C|cytochrome P450-P1|flavoprotein-linked monooxygenase|hydroperoxy icosatetraenoate dehydratase|xenobiotic monooxygenase', map_location='15q24.1', chromosome='15', genomic_nucleotide_accession_version='NC_000015.10', start_position_on_the_genomic_accession=74719542, end_position_on_the_genomic_accession=74725528, orientation='minus', exon_count=7, OMIM=[108330], no_hdr0=''),
    1544 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1544, CurrentID=0, Status='live', Symbol='CYP1A2', Aliases=['CP12', 'CYPIA2', 'P3-450', 'P450(PA)'], description='cytochrome P450 family 1 subfamily A member 2', other_designations='cytochrome P450 1A2|P450 form 4|aryl hydrocarbon hydroxylase|cholesterol 25-hydroxylase|cytochrome P(3)450|cytochrome P450 4|cytochrome P450, family 1, subfamily A, polypeptide 2|cytochrome P450, subfamily I (aromatic compound-inducible), polypeptide 2|cytochrome P450-P3|dioxin-inducible P3-450|flavoprotein-linked monooxygenase|hydroperoxy icosatetraenoate dehydratase|microsomal monooxygenase|xenobiotic monooxygenase', map_location='15q24.1', chromosome='15', genomic_nucleotide_accession_version='NC_000015.10', start_position_on_the_genomic_accession=74748845, end_position_on_the_genomic_accession=74756607, orientation='plus', exon_count=7, OMIM=[124060], no_hdr0=''),
    1545 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1545, CurrentID=0, Status='live', Symbol='CYP1B1', Aliases=['ASGD6', 'CP1B', 'CYPIB1', 'GLC3A', 'P4501B1'], description='cytochrome P450 family 1 subfamily B member 1', other_designations='cytochrome P450 1B1|aryl hydrocarbon hydroxylase|cytochrome P450, family 1, subfamily B, polypeptide 1|cytochrome P450, subfamily I (dioxin-inducible), polypeptide 1 (glaucoma 3, primary infantile)|dioxin-inducible cytochrome p450|flavoprotein-linked monooxygenase|hydroperoxy icosatetraenoate dehydratase|microsomal monooxygenase|xenobiotic monooxygenase', map_location='2p22.2', chromosome='2', genomic_nucleotide_accession_version='NC_000002.12', start_position_on_the_genomic_accession=38067509, end_position_on_the_genomic_accession=38076151, orientation='minus', exon_count=3, OMIM=[601771], no_hdr0=''),
    1548 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1548, CurrentID=0, Status='live', Symbol='CYP2A6', Aliases=['CPA6', 'CYP2A', 'CYP2A3', 'CYPIIA6', 'P450C2A', 'P450PB'], description='cytochrome P450 family 2 subfamily A member 6', other_designations='cytochrome P450 2A6|1,4-cineole 2-exo-monooxygenase|coumarin 7-hydroxylase|cytochrome P450 IIA3|cytochrome P450(I)|cytochrome P450, family 2, subfamily A, polypeptide 6|cytochrome P450, subfamily IIA (phenobarbital-inducible), polypeptide 6|flavoprotein-linked monooxygenase|xenobiotic monooxygenase', map_location='19q13.2', chromosome='19', genomic_nucleotide_accession_version='NC_000019.10', start_position_on_the_genomic_accession=40843541, end_position_on_the_genomic_accession=40850447, orientation='minus', exon_count=9, OMIM=[122720], no_hdr0=''),
    1549 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1549, CurrentID=0, Status='live', Symbol='CYP2A7', Aliases=['CPA7', 'CPAD', 'CYP2A', 'CYPIIA7', 'P450-IIA4'], description='cytochrome P450 family 2 subfamily A member 7', other_designations='cytochrome P450 2A7|cytochrome P450 IIA4|cytochrome P450, family 2, subfamily A, polypeptide 7|cytochrome P450, subfamily IIA (phenobarbital-inducible), polypeptide 7|cytochrome P450IIA4', map_location='19q13.2', chromosome='19', genomic_nucleotide_accession_version='NC_000019.10', start_position_on_the_genomic_accession=40875439, end_position_on_the_genomic_accession=40885951, orientation='minus', exon_count=8, OMIM=[608054], no_hdr0=''),
    1551 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1551, CurrentID=0, Status='live', Symbol='CYP3A7', Aliases=['CP37', 'CYPIIIA7', 'P-450(HFL33)', 'P-450111A7', 'P450-HFLA', 'P450HLp2'], description='cytochrome P450 family 3 subfamily A member 7', other_designations='cytochrome P450 3A7|aryl hydrocarbon hydroxylase|cytochrome P450, family 3, subfamily A, polypeptide 7|cytochrome P450, subfamily IIIA, polypeptide 7|cytochrome P450-HFLA|flavoprotein-linked monooxygenase|microsomal monooxygenase|xenobiotic monooxygenase', map_location='7q22.1', chromosome='7', genomic_nucleotide_accession_version='NC_000007.14', start_position_on_the_genomic_accession=99705036, end_position_on_the_genomic_accession=99735196, orientation='minus', exon_count=13, OMIM=[605340], no_hdr0=''),
    1553 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1553, CurrentID=0, Status='live', Symbol='CYP2A13', Aliases=['CPAD', 'CYP2A', 'CYPIIA13'], description='cytochrome P450 family 2 subfamily A member 13', other_designations='cytochrome P450 2A13|cytochrome P450, family 2, subfamily A, polypeptide 13|cytochrome P450, subfamily IIA (phenobarbital-inducible), polypeptide 13', map_location='19q13.2', chromosome='19', genomic_nucleotide_accession_version='NC_000019.10', start_position_on_the_genomic_accession=41088451, end_position_on_the_genomic_accession=41096195, orientation='plus', exon_count=9, OMIM=[608055], no_hdr0=''),
    1555 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1555, CurrentID=0, Status='live', Symbol='CYP2B6', Aliases=['CPB6', 'CYP2B', 'CYP2B7', 'CYP2B7P', 'CYPIIB6', 'EFVM', 'IIB1', 'P450'], description='cytochrome P450 family 2 subfamily B member 6', other_designations='cytochrome P450 2B6|1,4-cineole 2-exo-monooxygenase|cytochrome P450 IIB1|cytochrome P450, family 2, subfamily B, polypeptide 6|cytochrome P450, subfamily IIB (phenobarbital-inducible), polypeptide 6', map_location='19q13.2', chromosome='19', genomic_nucleotide_accession_version='NC_000019.10', start_position_on_the_genomic_accession=40991282, end_position_on_the_genomic_accession=41018398, orientation='plus', exon_count=9, OMIM=[123930], no_hdr0=''),
    1557 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1557, CurrentID=0, Status='live', Symbol='CYP2C19', Aliases=['CPCJ', 'CYP2C', 'CYPIIC17', 'CYPIIC19', 'P450C2C', 'P450IIC19'], description='cytochrome P450 family 2 subfamily C member 19', other_designations="cytochrome P450 2C19|(R)-limonene 6-monooxygenase|(S)-limonene 6-monooxygenase|(S)-limonene 7-monooxygenase|S-mephenytoin 4-hydroxylase|cytochrome P-450 II C|cytochrome P450, family 2, subfamily C, polypeptide 19|cytochrome P450, subfamily IIC (mephenytoin 4-hydroxylase), polypeptide 19|cytochrome P450-11A|cytochrome P450-254C|fenbendazole monooxygenase (4'-hydroxylating)|flavoprotein-linked monooxygenase|mephenytoin 4'-hydroxylase|mephenytoin 4-hydroxylase|microsomal monooxygenase|xenobiotic monooxygenase", map_location='10q23.33', chromosome='10', genomic_nucleotide_accession_version='NC_000010.11', start_position_on_the_genomic_accession=94762681, end_position_on_the_genomic_accession=94855547, orientation='plus', exon_count=9, OMIM=[124020], no_hdr0=''),
    1558 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1558, CurrentID=0, Status='live', Symbol='CYP2C8', Aliases=['CPC8DM', 'CYPIIC8', 'MP-12/MP-20', 'CYP2C8'], description='cytochrome P450 family 2 subfamily C member 8', other_designations='cytochrome P450 2C8|P450 form 1|cytochrome P450 IIC2|cytochrome P450 MP-12|cytochrome P450 MP-20|cytochrome P450 form 1|cytochrome P450, family 2, subfamily C, polypeptide 8|cytochrome P450, subfamily IIC (mephenytoin 4-hydroxylase), polypeptide 8|flavoprotein-linked monooxygenase|microsomal monooxygenase|s-mephenytoin 4-hydroxylase|xenobiotic monooxygenase', map_location='10q23.33', chromosome='10', genomic_nucleotide_accession_version='NC_000010.11', start_position_on_the_genomic_accession=95036772, end_position_on_the_genomic_accession=95069497, orientation='minus', exon_count=10, OMIM=[601129], no_hdr0=''),
    1559 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1559, CurrentID=0, Status='live', Symbol='CYP2C9', Aliases=['CPC9', 'CYP2C', 'CYP2C10', 'CYPIIC9', 'P450IIC9'], description='cytochrome P450 family 2 subfamily C member 9', other_designations='cytochrome P450 2C9|cytochrome P-450 S-mephenytoin 4-hydroxylase|cytochrome P-450MP|cytochrome P450 PB-1|cytochrome P450, family 2, subfamily C, polypeptide 9|flavoprotein-linked monooxygenase|microsomal monooxygenase|xenobiotic monooxygenase', map_location='10q23.33', chromosome='10', genomic_nucleotide_accession_version='NC_000010.11', start_position_on_the_genomic_accession=94938658, end_position_on_the_genomic_accession=94990091, orientation='plus', exon_count=9, OMIM=[601130], no_hdr0=''),
    1562 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1562, CurrentID=0, Status='live', Symbol='CYP2C18', Aliases=['CPCI', 'CYP2C', 'CYP2C17', 'P450-6B/29C', 'P450IIC17'], description='cytochrome P450 family 2 subfamily C member 18', other_designations='cytochrome P450 2C18|(S)-mephenytoin hydroxylase associated cytochrome P450|CYPIIC18|cytochrome P450, family 2, subfamily C, polypeptide 18|cytochrome P450, subfamily IIC (mephenytoin 4-hydroxylase), polypeptide 17|cytochrome P450, subfamily IIC (mephenytoin 4-hydroxylase), polypeptide 18|cytochrome P450-6B/29C|flavoprotein-linked monooxygenase|microsomal monooxygenase|unspecific monooxygenase', map_location='10q23.33', chromosome='10', genomic_nucleotide_accession_version='NC_000010.11', start_position_on_the_genomic_accession=94683729, end_position_on_the_genomic_accession=94736190, orientation='plus', exon_count=9, OMIM=[601131], no_hdr0=''),
    1564 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1564, CurrentID=0, Status='live', Symbol='CYP2D7', Aliases=['CYP2D', 'CYP2D6AP', 'CYP2D7P', 'CYP2D7P1', 'CYP2D@', 'P450C2D', 'P450DB1', 'RNA40057', 'CYP2D7'], description='cytochrome P450 family 2 subfamily D member 7 (gene/pseudogene)', other_designations='putative cytochrome P450 2D7|Putative cytochrome P450 2D7|cytochrome P450, family 2, subfamily D, polypeptide 7 pseudogene 1|cytochrome P450, subfamily II (debrisoquine, sparteine, etc., -metabolising), polypeptide 7 pseudogene 1|cytochrome P450, subfamily IID (debrisoquine, sparteine, etc., -metabolizing) cluster|cytochrome P4502D6|nonfunctional cytochrome P450 family 2 subfamily D polypeptide 6', map_location='22q13.2', chromosome='22', genomic_nucleotide_accession_version='NC_000022.11', start_position_on_the_genomic_accession=42139576, end_position_on_the_genomic_accession=42144483, orientation='minus', exon_count=9, OMIM=[], no_hdr0=''),
    1565 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1565, CurrentID=0, Status='live', Symbol='CYP2D6', Aliases=['CPD6', 'CYP2D', 'CYP2D7AP', 'CYP2D7BP', 'CYP2D7P2', 'CYP2D8P2', 'CYP2DL1', 'CYPIID6', 'P450-DB1', 'P450C2D', 'P450DB1'], description='cytochrome P450 family 2 subfamily D member 6', other_designations='cytochrome P450 2D6|cholesterol 25-hydroxylase|cytochrome P450, family 2, subfamily D, polypeptide 6|cytochrome P450, family 2, subfamily D, polypeptide 7 pseudogene 2|cytochrome P450, family 2, subfamily D, polypeptide 8 pseudogene 2|cytochrome P450, subfamily II (debrisoquine, sparteine, etc., -metabolising), polypeptide 7 pseudogene 2|cytochrome P450, subfamily IID (debrisoquine, sparteine, etc., -metabolising), polypeptide 8 pseudogene 2|cytochrome P450, subfamily IID (debrisoquine, sparteine, etc., -metabolizing), polypeptide 6|cytochrome P450, subfamily IID (debrisoquine, sparteine, etc., -metabolizing)-like 1|cytochrome P450-DB1|debrisoquine 4-hydroxylase|flavoprotein-linked monooxygenase|microsomal monooxygenase|nonfunctional cytochrome P450 2D6|xenobiotic monooxygenase', map_location='22q13.2', chromosome='22', genomic_nucleotide_accession_version='NC_000022.11', start_position_on_the_genomic_accession=42126499, end_position_on_the_genomic_accession=42130810, orientation='minus', exon_count=9, OMIM=[124030], no_hdr0=''),
    1571 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1571, CurrentID=0, Status='live', Symbol='CYP2E1', Aliases=['CPE1', 'CYP2E', 'P450-J', 'P450C2E'], description='cytochrome P450 family 2 subfamily E member 1', other_designations='cytochrome P450 2E1|4-nitrophenol 2-hydroxylase|CYPIIE1|cytochrome P450, family 2, subfamily E, polypeptide 1|cytochrome P450, subfamily IIE (ethanol-inducible), polypeptide 1|cytochrome P450-J|flavoprotein-linked monooxygenase|microsomal monooxygenase|xenobiotic monooxygenase', map_location='10q26.3', chromosome='10', genomic_nucleotide_accession_version='NC_000010.11', start_position_on_the_genomic_accession=133527363, end_position_on_the_genomic_accession=133539123, orientation='plus', exon_count=9, OMIM=[124040], no_hdr0=''),
    1572 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1572, CurrentID=0, Status='live', Symbol='CYP2F1', Aliases=['C2F1', 'CYP2F', 'CYPIIF1'], description='cytochrome P450 family 2 subfamily F member 1', other_designations='cytochrome P450 2F1|cytochrome P450, family 2, subfamily F, polypeptide 1|cytochrome P450, subfamily IIF, polypeptide 1|flavoprotein-linked monooxygenase|microsomal monooxygenase|xenobiotic monooxygenase', map_location='19q13.2', chromosome='19', genomic_nucleotide_accession_version='NC_000019.10', start_position_on_the_genomic_accession=41114292, end_position_on_the_genomic_accession=41128381, orientation='plus', exon_count=10, OMIM=[124070], no_hdr0=''),
    1573 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1573, CurrentID=0, Status='live', Symbol='CYP2J2', Aliases=['CPJ2', 'CYPIIJ2'], description='cytochrome P450 family 2 subfamily J member 2', other_designations='cytochrome P450 2J2|albendazole monooxygenase (hydroxylating)|albendazole monooxygenase (sulfoxide-forming)|arachidonic acid epoxygenase|cytochrome P450, family 2, subfamily J, polypeptide 2|cytochrome P450, subfamily IIJ (arachidonic acid epoxygenase) polypeptide 2|flavoprotein-linked monooxygenase|hydroperoxy icosatetraenoate isomerase|microsomal monooxygenase', map_location='1p32.1', chromosome='1', genomic_nucleotide_accession_version='NC_000001.11', start_position_on_the_genomic_accession=59893308, end_position_on_the_genomic_accession=59926773, orientation='minus', exon_count=10, OMIM=[601258], no_hdr0=''),
    1576 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1576, CurrentID=0, Status='live', Symbol='CYP3A4', Aliases=['CP33', 'CP34', 'CYP3A', 'CYP3A3', 'CYPIIIA3', 'CYPIIIA4', 'HLP', 'NF-25', 'P450C3', 'P450PCN1'], description='cytochrome P450 family 3 subfamily A member 4', other_designations='cytochrome P450 3A4|1,4-cineole 2-exo-monooxygenase|1,8-cineole 2-exo-monooxygenase|P450-III, steroid inducible|albendazole monooxygenase (sulfoxide-forming)|albendazole sulfoxidase|cholesterol 25-hydroxylase|cytochrome P450 3A3|cytochrome P450 HLp|cytochrome P450 NF-25|cytochrome P450, family 3, subfamily A, polypeptide 4|cytochrome P450, subfamily IIIA (niphedipine oxidase), polypeptide 3|cytochrome P450, subfamily IIIA (niphedipine oxidase), polypeptide 4|cytochrome P450-PCN1|glucocorticoid-inducible P450|nifedipine oxidase|quinine 3-monooxygenase|taurochenodeoxycholate 6-alpha-hydroxylase', map_location='7q22.1', chromosome='7', genomic_nucleotide_accession_version='NC_000007.14', start_position_on_the_genomic_accession=99756967, end_position_on_the_genomic_accession=99784184, orientation='minus', exon_count=13, OMIM=[124010], no_hdr0=''),
    1577 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1577, CurrentID=0, Status='live', Symbol='CYP3A5', Aliases=['CP35', 'CYPIIIA5', 'P450PCN3', 'PCN3'], description='cytochrome P450 family 3 subfamily A member 5', other_designations='cytochrome P450 3A5|aryl hydrocarbon hydroxylase|cytochrome P450 HLp2|cytochrome P450, family 3, subfamily A, polypeptide 5|cytochrome P450, subfamily IIIA (niphedipine oxidase), polypeptide 5|cytochrome P450-PCN3|flavoprotein-linked monooxygenase|microsomal monooxygenase|xenobiotic monooxygenase', map_location='7q22.1', chromosome='7', genomic_nucleotide_accession_version='NC_000007.14', start_position_on_the_genomic_accession=99648194, end_position_on_the_genomic_accession=99679996, orientation='minus', exon_count=14, OMIM=[605325], no_hdr0=''),
    1579 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1579, CurrentID=0, Status='live', Symbol='CYP4A11', Aliases=['CP4Y', 'CYP4A2', 'CYP4AII', 'CYPIVA11'], description='cytochrome P450 family 4 subfamily A member 11', other_designations='cytochrome P450 4A11|20-HETE synthase|20-hydroxyeicosatetraenoic acid synthase|P450HL-omega|alkane-1 monooxygenase|cytochrome P-450HK-omega|cytochrome P450, family 4, subfamily A, polypeptide 11|cytochrome P450, subfamily IVA, polypeptide 11|cytochrome P450HL-omega|fatty acid omega-hydroxylase|lauric acid omega-hydroxylase|long-chain fatty acid omega-monooxygenase', map_location='1p33', chromosome='1', genomic_nucleotide_accession_version='NC_000001.11', start_position_on_the_genomic_accession=46929177, end_position_on_the_genomic_accession=46941476, orientation='minus', exon_count=13, OMIM=[601310], no_hdr0=''),
    1580 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1580, CurrentID=0, Status='live', Symbol='CYP4B1', Aliases=['CYPIVB1', 'P-450HP'], description='cytochrome P450 family 4 subfamily B member 1', other_designations='cytochrome P450 4B1|cytochrome P450, family 4, subfamily B, polypeptide 1|cytochrome P450, subfamily IVB, polypeptide 1|cytochrome P450-HP|microsomal monooxygenase', map_location='1p33', chromosome='1', genomic_nucleotide_accession_version='NC_000001.11', start_position_on_the_genomic_accession=46799046, end_position_on_the_genomic_accession=46819413, orientation='plus', exon_count=12, OMIM=[124075], no_hdr0=''),
    1581 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1581, CurrentID=0, Status='live', Symbol='CYP7A1', Aliases=['CP7A', 'CYP7', 'CYPVII'], description='cytochrome P450 family 7 subfamily A member 1', other_designations='cytochrome P450 7A1|24-hydroxycholesterol 7-alpha-hydroxylase|cholesterol 7-alpha-hydroxylase|cholesterol 7-alpha-monooxygenase|cholesterol 7alpha-hydroxylase|cytochrome P450, family 7, subfamily A, polypeptide 1|cytochrome P450, subfamily VIIA polypeptide 1', map_location='8q12.1', chromosome='8', genomic_nucleotide_accession_version='NC_000008.11', start_position_on_the_genomic_accession=58490178, end_position_on_the_genomic_accession=58500163, orientation='minus', exon_count=6, OMIM=[118455], no_hdr0=''),
    1582 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1582, CurrentID=0, Status='live', Symbol='CYP8B1', Aliases=['CP8B', 'CYP12'], description='cytochrome P450 family 8 subfamily B member 1', other_designations='7-alpha-hydroxycholest-4-en-3-one 12-alpha-hydroxylase|7 alpha-hydroxy-4-cholesten-3-one 12-alpha-hydroxylase|CYPVIIIB1|cytochrome P450 8B1|cytochrome P450, family 8, subfamily B, polypeptide 1|cytochrome P450, subfamily VIIIB (sterol 12-alpha-hydroxylase), polypeptide 1|sterol 12-alpha-hydroxylase', map_location='3p22.1', chromosome='3', genomic_nucleotide_accession_version='NC_000003.12', start_position_on_the_genomic_accession=42872192, end_position_on_the_genomic_accession=42875879, orientation='minus', exon_count=1, OMIM=[602172], no_hdr0=''),
    1583 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1583, CurrentID=0, Status='live', Symbol='CYP11A1', Aliases=['CYP11A', 'CYPXIA1', 'P450SCC'], description='cytochrome P450 family 11 subfamily A member 1', other_designations='cholesterol side-chain cleavage enzyme, mitochondrial|cholesterol 20-22 desmolase|cholesterol monooxygenase (side-chain cleaving)|cytochrome P450 11A1|cytochrome P450 family 11 subfamily A polypeptide 1|cytochrome P450(scc)|cytochrome P450, subfamily XIA (cholesterol side chain cleavage)|steroid 20-22-lyase', map_location='15q24.1', chromosome='15', genomic_nucleotide_accession_version='NC_000015.10', start_position_on_the_genomic_accession=74337762, end_position_on_the_genomic_accession=74367646, orientation='minus', exon_count=10, OMIM=[118485], no_hdr0=''),
    1584 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1584, CurrentID=0, Status='live', Symbol='CYP11B1', Aliases=['CPN1', 'CYP11B', 'FHI', 'P450C11'], description='cytochrome P450 family 11 subfamily B member 1', other_designations='cytochrome P450 11B1, mitochondrial|cytochrome P-450c11|cytochrome P450, family 11, subfamily B, polypeptide 1|cytochrome P450, subfamily XIB (steroid 11-beta-hydroxylase), polypeptide 1|cytochrome P450C11|cytochrome p450 XIB1|steroid 11-beta-hydroxylase, CYP11B1|steroid 11-beta-monooxygenase', map_location='8q24.3', chromosome='8', genomic_nucleotide_accession_version='NC_000008.11', start_position_on_the_genomic_accession=142872357, end_position_on_the_genomic_accession=142879825, orientation='minus', exon_count=9, OMIM=[610613], no_hdr0=''),
    1585 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1585, CurrentID=0, Status='live', Symbol='CYP11B2', Aliases=['ALDOS', 'CPN2', 'CYP11B', 'CYP11BL', 'CYPXIB2', 'P-450C18', 'P450C18', 'P450aldo'], description='cytochrome P450 family 11 subfamily B member 2', other_designations='cytochrome P450 11B2, mitochondrial|aldosterone synthase|aldosterone-synthesizing enzyme|corticosterone 18-monooxygenase, CYP11B2|cytochrome P-450Aldo|cytochrome P-450C18|cytochrome P450, family 11, subfamily B, polypeptide 2|cytochrome P450, subfamily XIB (steroid 11-beta-hydroxylase), polypeptide 2|mitochondrial cytochrome P450, family 11, subfamily B, polypeptide 2|steroid 11-beta-hydroxylase, CYP11B2|steroid 11-beta-monooxygenase|steroid 11-beta/18-hydroxylase|steroid 18-hydroxylase, aldosterone synthase, P450C18, P450aldo', map_location='8q24.3', chromosome='8', genomic_nucleotide_accession_version='NC_000008.11', start_position_on_the_genomic_accession=142910559, end_position_on_the_genomic_accession=142917843, orientation='minus', exon_count=9, OMIM=[124080], no_hdr0=''),
    1586 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1586, CurrentID=0, Status='live', Symbol='CYP17A1', Aliases=['CPT7', 'CYP17', 'P450C17', 'S17AH'], description='cytochrome P450 family 17 subfamily A member 1', other_designations='steroid 17-alpha-hydroxylase/17,20 lyase|17-alpha-hydroxyprogesterone aldolase|CYPXVII|cytochrome P450 17A1|cytochrome P450, family 17, subfamily A, polypeptide 1|cytochrome P450, subfamily XVII (steroid 17-alpha-hydroxylase), adrenal hyperplasia|cytochrome P450-C17|cytochrome P450c17|cytochrome p450 XVIIA1|steroid 17-alpha-monooxygenase', map_location='10q24.32', chromosome='10', genomic_nucleotide_accession_version='NC_000010.11', start_position_on_the_genomic_accession=102830531, end_position_on_the_genomic_accession=102837413, orientation='minus', exon_count=8, OMIM=[609300], no_hdr0=''),
    1588 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1588, CurrentID=0, Status='live', Symbol='CYP19A1', Aliases=['ARO', 'ARO1', 'CPV1', 'CYAR', 'CYP19', 'CYPXIX', 'P-450AROM'], description='cytochrome P450 family 19 subfamily A member 1', other_designations='aromatase|cytochrome P-450AROM|cytochrome P450 19A1|cytochrome P450, family 19, subfamily A, polypeptide 1|cytochrome P450, subfamily XIX (aromatization of androgens)|estrogen synthase|estrogen synthetase|flavoprotein-linked monooxygenase|microsomal monooxygenase', map_location='15q21.2', chromosome='15', genomic_nucleotide_accession_version='NC_000015.10', start_position_on_the_genomic_accession=51208057, end_position_on_the_genomic_accession=51338596, orientation='minus', exon_count=18, OMIM=[107910], no_hdr0=''),
    1589 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1589, CurrentID=0, Status='live', Symbol='CYP21A2', Aliases=['CA21H', 'CAH1', 'CPS1', 'CYP21', 'CYP21B', 'P450c21B'], description='cytochrome P450 family 21 subfamily A member 2', other_designations='steroid 21-hydroxylase|21-OHase|cytochrome P450 XXI|cytochrome P450, family 21, subfamily A, polypeptide 2|cytochrome P450, subfamily XXIA (steroid 21-hydroxylase, congenital adrenal hyperplasia), polypeptide 2|cytochrome P450-C21B|steroid 21 hydroxylase|steroid 21-monooxygenase', map_location='6p21.33', chromosome='6', genomic_nucleotide_accession_version='NC_000006.12', start_position_on_the_genomic_accession=32038415, end_position_on_the_genomic_accession=32041644, orientation='plus', exon_count=10, OMIM=[613815], no_hdr0=''),
    1591 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1591, CurrentID=0, Status='live', Symbol='CYP24A1', Aliases=['CP24', 'CYP24', 'HCAI', 'HCINF1', 'P450-CC24'], description='cytochrome P450 family 24 subfamily A member 1', other_designations='1,25-dihydroxyvitamin D(3) 24-hydroxylase, mitochondrial|1,25-@dihydroxyvitamin D3 24-hydroxylase|24-OHase|cytochrome P450 24A1|cytochrome P450, family 24, subfamily A, polypeptide 1|cytochrome P450, subfamily XXIV (vitamin D 24-hydroxylase)|cytochrome P450-CC24|exo-mitochondrial protein|vitamin D 24-hydroxylase|vitamin D(3) 24-hydroxylase', map_location='20q13.2', chromosome='20', genomic_nucleotide_accession_version='NC_000020.11', start_position_on_the_genomic_accession=54145731, end_position_on_the_genomic_accession=54174032, orientation='minus', exon_count=13, OMIM=[126065], no_hdr0=''),
    1592 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1592, CurrentID=0, Status='live', Symbol='CYP26A1', Aliases=['CP26', 'CYP26', 'P450RAI', 'P450RAI1'], description='cytochrome P450 family 26 subfamily A member 1', other_designations='cytochrome P450 26A1|P450, retinoic acid-inactivating, 1|cytochrome P450 retinoic acid-inactivating 1|cytochrome P450, family 26, subfamily A, polypeptide 1|cytochrome P450, subfamily XXVIA, polypeptide 1|cytochrome P450RAI|hP450RAI|retinoic acid 4-hydroxylase|retinoic acid-metabolizing cytochrome', map_location='10q23.33', chromosome='10', genomic_nucleotide_accession_version='NC_000010.11', start_position_on_the_genomic_accession=93073475, end_position_on_the_genomic_accession=93077885, orientation='plus', exon_count=8, OMIM=[602239], no_hdr0=''),
    1593 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1593, CurrentID=0, Status='live', Symbol='CYP27A1', Aliases=['CP27', 'CTX', 'CYP27'], description='cytochrome P450 family 27 subfamily A member 1', other_designations='sterol 26-hydroxylase, mitochondrial|5-beta-cholestane-3-alpha, 7-alpha, 12-alpha-triol 26-hydroxylase|5-beta-cholestane-3-alpha, 7-alpha, 12-alpha-triol 27-hydroxylase|cholestanetriol 26-monooxygenase|cytochrome P-450C27/25|cytochrome P450 27|cytochrome P450, family 27, subfamily A, polypeptide 1|cytochrome P450, subfamily XXVIIA (steroid 27-hydroxylase, cerebrotendinous xanthomatosis), polypeptide 1|sterol 27-hydroxylase|vitamin D(3) 25-hydroxylase', map_location='2q35', chromosome='2', genomic_nucleotide_accession_version='NC_000002.12', start_position_on_the_genomic_accession=218781733, end_position_on_the_genomic_accession=218815293, orientation='plus', exon_count=9, OMIM=[606530], no_hdr0=''),
    1594 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1594, CurrentID=0, Status='live', Symbol='CYP27B1', Aliases=['CP2B', 'CYP1', 'CYP1alpha', 'CYP27B', 'P450c1', 'PDDR', 'VDD1', 'VDDR', 'VDDRI', 'VDR'], description='cytochrome P450 family 27 subfamily B member 1', other_designations='25-hydroxyvitamin D-1 alpha hydroxylase, mitochondrial|1alpha(OH)ase|25 hydroxyvitamin D3-1-alpha hydroxylase|25-OHD-1 alpha-hydroxylase|VD3 1A hydroxylase|calcidiol 1-monooxygenase|cytochrome P450 subfamily XXVIIB polypeptide 1|cytochrome P450, family 27, subfamily B, polypeptide 1|cytochrome P450C1 alpha|cytochrome P450VD1-alpha|cytochrome p450 27B1', map_location='12q14.1', chromosome='12', genomic_nucleotide_accession_version='NC_000012.12', start_position_on_the_genomic_accession=57762334, end_position_on_the_genomic_accession=57767078, orientation='minus', exon_count=9, OMIM=[609506], no_hdr0=''),
    1595 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1595, CurrentID=0, Status='live', Symbol='CYP51A1', Aliases=['CP51', 'CYP51', 'CYPL1', 'LDM', 'P450-14DM', 'P450L1'], description='cytochrome P450 family 51 subfamily A member 1', other_designations='lanosterol 14-alpha demethylase|CYPLI|cytochrome P450 51A1|cytochrome P450, 51 (lanosterol 14-alpha-demethylase)|cytochrome P450, family 51, subfamily A, polypeptide 1|cytochrome P450-14DM|cytochrome P45014DM|cytochrome P450LI|sterol 14-alpha demethylase', map_location='7q21.2', chromosome='7', genomic_nucleotide_accession_version='NC_000007.14', start_position_on_the_genomic_accession=92112153, end_position_on_the_genomic_accession=92134803, orientation='minus', exon_count=11, OMIM=[601637], no_hdr0=''),
    1600 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1600, CurrentID=0, Status='live', Symbol='DAB1', Aliases=['SCA37'], description='DAB adaptor protein 1', other_designations='disabled homolog 1|DAB1, reelin adaptor protein|Dab reelin signal transducer 1|Dab, reelin signal transducer, homolog 1', map_location='1p32.2', chromosome='1', genomic_nucleotide_accession_version='NC_000001.11', start_position_on_the_genomic_accession=56994778, end_position_on_the_genomic_accession=58546726, orientation='minus', exon_count=27, OMIM=[603448], no_hdr0=''),
    1601 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1601, CurrentID=0, Status='live', Symbol='DAB2', Aliases=['DOC-2', 'DOC2'], description='DAB adaptor protein 2', other_designations='disabled homolog 2|DAB2, clathrin adaptor protein|Dab, mitogen-responsive phosphoprotein, homolog 2|adaptor molecule disabled-2|differentially expressed in ovarian carcinoma 2|differentially-expressed protein 2|disabled homolog 2, mitogen-responsive phosphoprotein', map_location='5p13.1', chromosome='5', genomic_nucleotide_accession_version='NC_000005.10', start_position_on_the_genomic_accession=39371677, end_position_on_the_genomic_accession=39424980, orientation='minus', exon_count=15, OMIM=[601236], no_hdr0=''),
    1602 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1602, CurrentID=0, Status='live', Symbol='DACH1', Aliases=['DACH'], description='dachshund family transcription factor 1', other_designations='dachshund homolog 1|dac homolog', map_location='13q21.33', chromosome='13', genomic_nucleotide_accession_version='NC_000013.11', start_position_on_the_genomic_accession=71437966, end_position_on_the_genomic_accession=71868068, orientation='minus', exon_count=15, OMIM=[603803], no_hdr0=''),
    1603 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1603, CurrentID=0, Status='live', Symbol='DAD1', Aliases=['OST2'], description='defender against cell death 1', other_designations='dolichyl-diphosphooligosaccharide--protein glycosyltransferase subunit DAD1|DAD-1|oligosaccharyl transferase subunit DAD1|oligosaccharyltransferase 2 homolog|oligosaccharyltransferase subunit 2 (non-catalytic)', map_location='14q11.2', chromosome='14', genomic_nucleotide_accession_version='NC_000014.9', start_position_on_the_genomic_accession=22564907, end_position_on_the_genomic_accession=22589224, orientation='minus', exon_count=3, OMIM=[600243], no_hdr0=''),
    1604 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1604, CurrentID=0, Status='live', Symbol='CD55', Aliases=['CHAPLE', 'CR', 'CROM', 'DAF', 'TC'], description='CD55 molecule (Cromer blood group)', other_designations='complement decay-accelerating factor|CD55 antigen|CD55 molecule, decay accelerating factor for complement (Cromer blood group)|Cromer blood group antigen', map_location='1q32.2', chromosome='1', genomic_nucleotide_accession_version='NC_000001.11', start_position_on_the_genomic_accession=207321674, end_position_on_the_genomic_accession=207360966, orientation='plus', exon_count=15, OMIM=[125240], no_hdr0=''),
    1605 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1605, CurrentID=0, Status='live', Symbol='DAG1', Aliases=['156DAG', 'A3a', 'AGRNR', 'DAG', 'LGMDR16', 'MDDGA9', 'MDDGC7', 'MDDGC9'], description='dystroglycan 1', other_designations='dystroglycan|dystroglycan 1 (dystrophin-associated glycoprotein 1)', map_location='3p21.31', chromosome='3', genomic_nucleotide_accession_version='NC_000003.12', start_position_on_the_genomic_accession=49468703, end_position_on_the_genomic_accession=49535618, orientation='plus', exon_count=9, OMIM=[128239], no_hdr0=''),
    1606 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1606, CurrentID=0, Status='live', Symbol='DGKA', Aliases=['DAGK', 'DAGK1', 'DGK-alpha'], description='diacylglycerol kinase alpha', other_designations='diacylglycerol kinase alpha|80 kDa diacylglycerol kinase|DAG kinase alpha|diacylglycerol kinase, alpha 80kDa|diglyceride kinase alpha', map_location='12q13.2', chromosome='12', genomic_nucleotide_accession_version='NC_000012.12', start_position_on_the_genomic_accession=55931091, end_position_on_the_genomic_accession=55954023, orientation='plus', exon_count=32, OMIM=[125855], no_hdr0=''),
    1607 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1607, CurrentID=0, Status='live', Symbol='DGKB', Aliases=['DAGK2', 'DGK', 'DGK-BETA'], description='diacylglycerol kinase beta', other_designations='diacylglycerol kinase beta|90 kDa diacylglycerol kinase|DAG kinase beta|diacylglycerol kinase, beta 90kDa|diglyceride kinase beta', map_location='7p21.2', chromosome='7', genomic_nucleotide_accession_version='NC_000007.14', start_position_on_the_genomic_accession=14145049, end_position_on_the_genomic_accession=14974858, orientation='minus', exon_count=32, OMIM=[604070], no_hdr0=''),
    1608 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1608, CurrentID=0, Status='live', Symbol='DGKG', Aliases=['DAGK3', 'DGK-GAMMA'], description='diacylglycerol kinase gamma', other_designations='diacylglycerol kinase gamma|DAG kinase gamma|diacylglycerol kinase, gamma 90kDa|diacylglyerol kinase gamma|diglyceride kinase gamma', map_location='3q27.2-q27.3', chromosome='3', genomic_nucleotide_accession_version='NC_000003.12', start_position_on_the_genomic_accession=186147201, end_position_on_the_genomic_accession=186362234, orientation='minus', exon_count=25, OMIM=[601854], no_hdr0=''),
    1609 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1609, CurrentID=0, Status='live', Symbol='DGKQ', Aliases=['DAGK', 'DAGK4', 'DAGK7'], description='diacylglycerol kinase theta', other_designations='diacylglycerol kinase theta|DAG kinase theta|DGK-theta|diacylglycerol kinase, theta 110kDa|diglyceride kinase theta|testis tissue sperm-binding protein Li 38a', map_location='4p16.3', chromosome='4', genomic_nucleotide_accession_version='NC_000004.12', start_position_on_the_genomic_accession=958887, end_position_on_the_genomic_accession=973569, orientation='minus', exon_count=25, OMIM=[601207], no_hdr0=''),
    1610 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1610, CurrentID=0, Status='live', Symbol='DAO', Aliases=['DAAO', 'DAMOX', 'OXDA'], description='D-amino acid oxidase', other_designations='D-amino-acid oxidase', map_location='12q24.11', chromosome='12', genomic_nucleotide_accession_version='NC_000012.12', start_position_on_the_genomic_accession=108880030, end_position_on_the_genomic_accession=108901043, orientation='plus', exon_count=12, OMIM=[124050], no_hdr0=''),
    1611 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1611, CurrentID=0, Status='live', Symbol='DAP', Aliases=[], description='death associated protein', other_designations='death-associated protein 1|DAP-1', map_location='5p15.2', chromosome='5', genomic_nucleotide_accession_version='NC_000005.10', start_position_on_the_genomic_accession=10679230, end_position_on_the_genomic_accession=10761234, orientation='minus', exon_count=4, OMIM=[600954], no_hdr0=''),
    1612 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1612, CurrentID=0, Status='live', Symbol='DAPK1', Aliases=['DAPK', 'ROCO3'], description='death associated protein kinase 1', other_designations='death-associated protein kinase 1|DAP kinase 1', map_location='9q21.33', chromosome='9', genomic_nucleotide_accession_version='NC_000009.12', start_position_on_the_genomic_accession=87497228, end_position_on_the_genomic_accession=87708634, orientation='plus', exon_count=31, OMIM=[600831], no_hdr0=''),
    1613 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1613, CurrentID=0, Status='live', Symbol='DAPK3', Aliases=['DLK', 'ZIP', 'ZIPK'], description='death associated protein kinase 3', other_designations='death-associated protein kinase 3|DAP kinase 3|DAP-like kinase|MYPT1 kinase|ZIP-kinase|zipper-interacting protein kinase', map_location='19p13.3', chromosome='19', genomic_nucleotide_accession_version='NC_000019.10', start_position_on_the_genomic_accession=3958453, end_position_on_the_genomic_accession=3971099, orientation='minus', exon_count=9, OMIM=[603289], no_hdr0=''),
    1615 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1615, CurrentID=0, Status='live', Symbol='DARS1', Aliases=['DARS', 'HBSL', 'aspRS'], description='aspartyl-tRNA synthetase 1', other_designations='aspartate--tRNA ligase, cytoplasmic|aspartate tRNA ligase 1, cytoplasmic|aspartyl-tRNA synthetase, cytoplasmic|cell proliferation-inducing gene 40 protein|testicular tissue protein Li 192', map_location='2q21.3', chromosome='2', genomic_nucleotide_accession_version='NC_000002.12', start_position_on_the_genomic_accession=135905881, end_position_on_the_genomic_accession=135985684, orientation='minus', exon_count=16, OMIM=[603084], no_hdr0=''),
    1616 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1616, CurrentID=0, Status='live', Symbol='DAXX', Aliases=['BING2', 'DAP6', 'EAP1', 'SMIM40'], description='death domain associated protein', other_designations='death domain-associated protein 6|CENP-C binding protein|ETS1-associated protein 1|Fas-binding protein|death-associated protein 6|fas death domain-associated protein', map_location='6p21.32', chromosome='6', genomic_nucleotide_accession_version='NC_000006.12', start_position_on_the_genomic_accession=33318558, end_position_on_the_genomic_accession=33322959, orientation='minus', exon_count=8, OMIM=[603186], no_hdr0=''),
    1617 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1617, CurrentID=0, Status='live', Symbol='DAZ1', Aliases=['DAZ', 'SPGY'], description='deleted in azoospermia 1', other_designations='deleted in azoospermia protein 1|testicular tissue protein Li 49', map_location='Yq11.223', chromosome='Y', genomic_nucleotide_accession_version='NC_000024.10', start_position_on_the_genomic_accession=23129355, end_position_on_the_genomic_accession=23199117, orientation='minus', exon_count=28, OMIM=[400003], no_hdr0=''),
    1618 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1618, CurrentID=0, Status='live', Symbol='DAZL', Aliases=['DAZH1', 'DAZLA', 'SPGYLA', 'DAZL'], description='deleted in azoospermia like', other_designations='deleted in azoospermia-like|DAZ homolog|DAZ-like autosomal|SPGY-like-autosomal|deleted in azoospermia-like 1|germline specific RNA binding protein|spermatogenesis gene on the Y-like autosomal|testis secretory sperm-binding protein Li 204a', map_location='3p24.3', chromosome='3', genomic_nucleotide_accession_version='NC_000003.12', start_position_on_the_genomic_accession=16586792, end_position_on_the_genomic_accession=16605423, orientation='minus', exon_count=12, OMIM=[601486], no_hdr0=''),
    1620 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1620, CurrentID=0, Status='live', Symbol='BRINP1', Aliases=['DBC1', 'DBCCR1', 'FAM5A'], description='BMP/retinoic acid inducible neural specific 1', other_designations='BMP/retinoic acid-inducible neural-specific protein 1|bA574M5.1 (deleted in bladder cancer chromosome region candidate 1 (IB3089A))|bone morphogenetic protein/retinoic acid inducible neural-specific 1|bone morphogenic protein/retinoic acid inducible neural-specific 1|deleted in bladder cancer 1|deleted in bladder cancer chromosome region candidate 1|deleted in bladder cancer protein 1', map_location='9q33.1', chromosome='9', genomic_nucleotide_accession_version='NC_000009.12', start_position_on_the_genomic_accession=119166629, end_position_on_the_genomic_accession=119369435, orientation='minus', exon_count=8, OMIM=[602865], no_hdr0=''),
    1621 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1621, CurrentID=0, Status='live', Symbol='DBH', Aliases=['DBM', 'ORTHYP1'], description='dopamine beta-hydroxylase', other_designations='dopamine beta-hydroxylase|dopamine beta-hydroxylase (dopamine beta-monooxygenase)', map_location='9q34.2', chromosome='9', genomic_nucleotide_accession_version='NC_000009.12', start_position_on_the_genomic_accession=133636363, end_position_on_the_genomic_accession=133659329, orientation='plus', exon_count=12, OMIM=[609312], no_hdr0=''),
    1622 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1622, CurrentID=0, Status='live', Symbol='DBI', Aliases=['ACBD1', 'ACBP', 'CCK-RP', 'EP'], description='diazepam binding inhibitor, acyl-CoA binding protein', other_designations='acyl-CoA-binding protein|GABA receptor modulator|acyl coenzyme A binding protein|acyl-Coenzyme A binding domain containing 1|cholecystokinin-releasing peptide, trypsin-sensitive|diazepam binding inhibitor (GABA receptor modulator, acyl-CoA binding protein)|diazepam binding inhibitor (GABA receptor modulator, acyl-Coenzyme A binding protein)|diazepam-binding inhibitor|endozepine|epididymis secretory sperm binding protein', map_location='2q14.2', chromosome='2', genomic_nucleotide_accession_version='NC_000002.12', start_position_on_the_genomic_accession=119366977, end_position_on_the_genomic_accession=119372560, orientation='plus', exon_count=7, OMIM=[125950], no_hdr0=''),
    1627 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1627, CurrentID=0, Status='live', Symbol='DBN1', Aliases=['D0S117E'], description='drebrin 1', other_designations='drebrin|developmentally-regulated brain protein|drebrin A|drebrin E|drebrin E2', map_location='5q35.3', chromosome='5', genomic_nucleotide_accession_version='NC_000005.10', start_position_on_the_genomic_accession=177456610, end_position_on_the_genomic_accession=177480368, orientation='minus', exon_count=19, OMIM=[126660], no_hdr0=''),
    1628 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1628, CurrentID=0, Status='live', Symbol='DBP', Aliases=['DABP', 'taxREB302'], description='D-box binding PAR bZIP transcription factor', other_designations='D site-binding protein|D site of albumin promoter (albumin D-box) binding protein|albumin D box-binding protein|albumin D-element-binding protein|tax-responsive enhancer element-binding protein 302', map_location='19q13.33', chromosome='19', genomic_nucleotide_accession_version='NC_000019.10', start_position_on_the_genomic_accession=48630030, end_position_on_the_genomic_accession=48637379, orientation='minus', exon_count=4, OMIM=[124097], no_hdr0=''),
    1629 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1629, CurrentID=0, Status='live', Symbol='DBT', Aliases=['BCATE2', 'BCKAD-E2', 'BCKADE2', 'BCKDH-E2', 'BCOADC-E2', 'E2', 'E2B'], description='dihydrolipoamide branched chain transacylase E2', other_designations='lipoamide acyltransferase component of branched-chain alpha-keto acid dehydrogenase complex, mitochondrial|52 kDa mitochondrial autoantigen of primary biliary cirrhosis|BCKAD E2 subunit|E2 component of branched chain alpha-keto acid dehydrogenase complex|branched chain 2-oxo-acid dehydrogenase complex component E2|branched chain acyltransferase, E2 component|branched-chain alpha-keto acid dehydrogenase complex component E2|dihydrolipoamide acetyltransferase component of branched-chain alpha-keto acid dehydrogenase complex|dihydrolipoyl transacylase|dihydrolipoyllysine-residue (2-methylpropanoyl)transferase|lipoamide acyltransferase component of mitochondrial branched-chain alpha-keto acid dehydrogenase complex|mitochondrial branched chain alpha-keto acid dehydrogenase transacylase subunit (E2b)', map_location='1p21.2', chromosome='1', genomic_nucleotide_accession_version='NC_000001.11', start_position_on_the_genomic_accession=100186919, end_position_on_the_genomic_accession=100249864, orientation='minus', exon_count=14, OMIM=[248610], no_hdr0=''),
    1630 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1630, CurrentID=0, Status='live', Symbol='DCC', Aliases=['CRC18', 'CRCR1', 'HGPPS2', 'IGDCC1', 'MRMV1', 'NTN1R1'], description='DCC netrin 1 receptor', other_designations='netrin receptor DCC|colorectal cancer suppressor|deleted in colorectal carcinoma|immunoglobulin superfamily DCC subclass member 1|putative colorectal tumor suppressor|tumor suppressor protein DCC', map_location='18q21.2', chromosome='18', genomic_nucleotide_accession_version='NC_000018.10', start_position_on_the_genomic_accession=52340172, end_position_on_the_genomic_accession=53535899, orientation='plus', exon_count=32, OMIM=[120470], no_hdr0=''),
    1632 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1632, CurrentID=0, Status='live', Symbol='ECI1', Aliases=['DCI'], description='enoyl-CoA delta isomerase 1', other_designations='enoyl-CoA delta isomerase 1, mitochondrial|3,2 trans-enoyl-Coenzyme A isomerase|3,2-trans-enoyl-CoA isomerase, mitochondrial|D3,D2-enoyl-CoA isomerase|acetylene-allene isomerase|delta(3),Delta(2)-enoyl-CoA isomerase|dodecenoyl-CoA delta isomerase (3,2 trans-enoyl-CoA isomerase)|dodecenoyl-Coenzyme A delta isomerase (3,2 trans-enoyl-Coenzyme A isomerase)|epididymis secretory sperm binding protein', map_location='16p13.3', chromosome='16', genomic_nucleotide_accession_version='NC_000016.10', start_position_on_the_genomic_accession=2239402, end_position_on_the_genomic_accession=2251587, orientation='minus', exon_count=7, OMIM=[600305], no_hdr0=''),
    1633 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1633, CurrentID=0, Status='live', Symbol='DCK', Aliases=[], description='deoxycytidine kinase', other_designations='deoxycytidine kinase|deoxyadenosine kinase|deoxyguanosine kinase|deoxynucleoside kinase', map_location='4q13.3', chromosome='4', genomic_nucleotide_accession_version='NC_000004.12', start_position_on_the_genomic_accession=70993649, end_position_on_the_genomic_accession=71030914, orientation='plus', exon_count=7, OMIM=[125450], no_hdr0=''),
    1634 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1634, CurrentID=0, Status='live', Symbol='DCN', Aliases=['CSCD', 'DSPG2', 'PG40', 'PGII', 'PGS2', 'SLRR1B'], description='decorin', other_designations='decorin|bone proteoglycan II|dermatan sulphate proteoglycans II|proteoglycan core protein|small leucine-rich protein 1B', map_location='12q21.33', chromosome='12', genomic_nucleotide_accession_version='NC_000012.12', start_position_on_the_genomic_accession=91140484, end_position_on_the_genomic_accession=91182817, orientation='minus', exon_count=9, OMIM=[125255], no_hdr0=''),
    1635 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1635, CurrentID=0, Status='live', Symbol='DCTD', Aliases=[], description='dCMP deaminase', other_designations='deoxycytidylate deaminase', map_location='4q35.1', chromosome='4', genomic_nucleotide_accession_version='NC_000004.12', start_position_on_the_genomic_accession=182890091, end_position_on_the_genomic_accession=182917611, orientation='minus', exon_count=9, OMIM=[607638], no_hdr0=''),
    1636 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1636, CurrentID=0, Status='live', Symbol='ACE', Aliases=['ACE1', 'CD143', 'DCP', 'DCP1'], description='angiotensin I converting enzyme', other_designations='angiotensin-converting enzyme|CD143 antigen|angiotensin I converting enzyme (peptidyl-dipeptidase A) 1|carboxycathepsin|dipeptidyl carboxypeptidase 1|dipeptidyl carboxypeptidase I|kininase II|peptidase P', map_location='17q23.3', chromosome='17', genomic_nucleotide_accession_version='NC_000017.11', start_position_on_the_genomic_accession=63477061, end_position_on_the_genomic_accession=63498373, orientation='plus', exon_count=26, OMIM=[106180], no_hdr0=''),
    1638 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1638, CurrentID=0, Status='live', Symbol='DCT', Aliases=['TRP-2', 'TYRP2'], description='dopachrome tautomerase', other_designations='L-dopachrome tautomerase|DT|L-dopachrome Delta-isomerase|L-dopachrome isomerase|TRP2|dopachrome delta-isomerase|dopachrome tautomerase (dopachrome delta-isomerase, tyrosine-related protein 2)|tyrosinase related protein-2|tyrosine-related protein 2', map_location='13q32.1', chromosome='13', genomic_nucleotide_accession_version='NC_000013.11', start_position_on_the_genomic_accession=94436811, end_position_on_the_genomic_accession=94549406, orientation='minus', exon_count=14, OMIM=[191275], no_hdr0=''),
    1639 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1639, CurrentID=0, Status='live', Symbol='DCTN1', Aliases=['DAP-150', 'DP-150', 'P135'], description='dynactin subunit 1', other_designations='dynactin subunit 1|150 kDa dynein-associated polypeptide|dynactin 1 (p150, glued homolog, Drosophila)', map_location='2p13.1', chromosome='2', genomic_nucleotide_accession_version='NC_000002.12', start_position_on_the_genomic_accession=74361155, end_position_on_the_genomic_accession=74391866, orientation='minus', exon_count=32, OMIM=[601143], no_hdr0=''),
    1641 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1641, CurrentID=0, Status='live', Symbol='DCX', Aliases=['DBCN', 'DC', 'LISX', 'SCLH', 'XLIS'], description='doublecortin', other_designations='neuronal migration protein doublecortin|doublecortex|doublin|lis-X|lissencephalin-X', map_location='Xq23', chromosome='X', genomic_nucleotide_accession_version='NC_000023.11', start_position_on_the_genomic_accession=111293779, end_position_on_the_genomic_accession=111412205, orientation='minus', exon_count=9, OMIM=[300121], no_hdr0=''),
    1642 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1642, CurrentID=0, Status='live', Symbol='DDB1', Aliases=['DDBA', 'UV-DDB1', 'XAP1', 'XPCE', 'XPE', 'XPE-BF'], description='damage specific DNA binding protein 1', other_designations='DNA damage-binding protein 1|DDB p127 subunit|DNA damage-binding protein a|HBV X-associated protein 1|UV-DDB 1|UV-damaged DNA-binding factor|UV-damaged DNA-binding protein 1|XAP-1|XPE-binding factor|damage-specific DNA binding protein 1, 127kDa|xeroderma pigmentosum group E-complementing protein', map_location='11q12.2', chromosome='11', genomic_nucleotide_accession_version='NC_000011.10', start_position_on_the_genomic_accession=61299451, end_position_on_the_genomic_accession=61333105, orientation='minus', exon_count=27, OMIM=[600045], no_hdr0=''),
    1643 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1643, CurrentID=0, Status='live', Symbol='DDB2', Aliases=['DDBB', 'UV-DDB2', 'XPE'], description='damage specific DNA binding protein 2', other_designations='DNA damage-binding protein 2|DDB p48 subunit|UV-DDB 2|UV-damaged DNA-binding protein 2|damage-specific DNA binding protein 2, 48kDa|xeroderma pigmentosum group E protein', map_location='11p11.2', chromosome='11', genomic_nucleotide_accession_version='NC_000011.10', start_position_on_the_genomic_accession=47214969, end_position_on_the_genomic_accession=47239218, orientation='plus', exon_count=10, OMIM=[600811], no_hdr0=''),
    1644 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1644, CurrentID=0, Status='live', Symbol='DDC', Aliases=['AADC'], description='dopa decarboxylase', other_designations='aromatic-L-amino-acid decarboxylase|dopa decarboxylase (aromatic L-amino acid decarboxylase)', map_location='7p12.2-p12.1', chromosome='7', genomic_nucleotide_accession_version='NC_000007.14', start_position_on_the_genomic_accession=50458436, end_position_on_the_genomic_accession=50565460, orientation='minus', exon_count=18, OMIM=[107930], no_hdr0=''),
    1645 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1645, CurrentID=0, Status='live', Symbol='AKR1C1', Aliases=['2-ALPHA-HSD', '20-ALPHA-HSD', 'C9', 'DD1', 'DD1/DD2', 'DDH', 'DDH1', 'H-37', 'HAKRC', 'HBAB', 'MBAB'], description='aldo-keto reductase family 1 member C1', other_designations='aldo-keto reductase family 1 member C1|20 alpha-hydroxysteroid dehydrogenase|aldo-keto reductase C|chlordecone reductase homolog HAKRC|dihydrodiol dehydrogenase 1|dihydrodiol dehydrogenase 1/2|dihydrodiol dehydrogenase 1; 20-alpha (3-alpha)-hydroxysteroid dehydrogenase|hepatic dihydrodiol dehydrogenase|high-affinity hepatic bile acid-binding protein|indanol dehydrogenase|trans-1,2-dihydrobenzene-1,2-diol dehydrogenase|type II 3-alpha-hydroxysteroid dehydrogenase', map_location='10p15.1', chromosome='10', genomic_nucleotide_accession_version='NC_000010.11', start_position_on_the_genomic_accession=4963415, end_position_on_the_genomic_accession=4983283, orientation='plus', exon_count=9, OMIM=[600449], no_hdr0=''),
    1646 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1646, CurrentID=0, Status='live', Symbol='AKR1C2', Aliases=['AKR1C-pseudo', 'BABP', 'DD', 'DD-2', 'DD/BABP', 'DD2', 'DDH2', 'HAKRD', 'HBAB', 'MCDR2', 'SRXY8', 'TDD'], description='aldo-keto reductase family 1 member C2', other_designations='aldo-keto reductase family 1 member C2|3-alpha-HSD3|chlordecone reductase homolog HAKRD|dihydrodiol dehydrogenase 2; bile acid binding protein; 3-alpha hydroxysteroid dehydrogenase, type III|pseudo-chlordecone reductase|testicular 17,20-desmolase deficiency|trans-1,2-dihydrobenzene-1,2-diol dehydrogenase|type II dihydrodiol dehydrogenase', map_location='10p15.1', chromosome='10', genomic_nucleotide_accession_version='NC_000010.11', start_position_on_the_genomic_accession=4987775, end_position_on_the_genomic_accession=5018000, orientation='minus', exon_count=12, OMIM=[600450], no_hdr0=''),
    1647 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1647, CurrentID=0, Status='live', Symbol='GADD45A', Aliases=['DDIT1', 'GADD45'], description='growth arrest and DNA damage inducible alpha', other_designations='growth arrest and DNA damage-inducible protein GADD45 alpha|DDIT-1|DNA damage-inducible transcript 1 protein|DNA damage-inducible transcript-1|growth arrest and DNA-damage-inducible 45 alpha', map_location='1p31.3', chromosome='1', genomic_nucleotide_accession_version='NC_000001.11', start_position_on_the_genomic_accession=67685201, end_position_on_the_genomic_accession=67688334, orientation='plus', exon_count=4, OMIM=[126335], no_hdr0=''),
    1649 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1649, CurrentID=0, Status='live', Symbol='DDIT3', Aliases=['AltDDIT3', 'C/EBPzeta', 'CEBPZ', 'CHOP', 'CHOP-10', 'CHOP10', 'GADD153'], description='DNA damage inducible transcript 3', other_designations='DNA damage-inducible transcript 3 protein|C/EBP zeta|CCAAT/enhancer-binding protein homologous protein|alternative DDIT3 protein|c/EBP-homologous protein 10|growth arrest and DNA damage-inducible protein GADD153', map_location='12q13.3', chromosome='12', genomic_nucleotide_accession_version='NC_000012.12', start_position_on_the_genomic_accession=57516588, end_position_on_the_genomic_accession=57520517, orientation='minus', exon_count=4, OMIM=[126337], no_hdr0=''),
    1650 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1650, CurrentID=0, Status='live', Symbol='DDOST', Aliases=['AGER1', 'CDG1R', 'GATD6', 'OKSWcl45', 'OST', 'OST48', 'WBP1'], description='dolichyl-diphosphooligosaccharide--protein glycosyltransferase non-catalytic subunit', other_designations='dolichyl-diphosphooligosaccharide--protein glycosyltransferase 48 kDa subunit|advanced glycation end-product receptor 1|advanced glycation endproduct receptor 1|dolichyl-diphosphooligosaccharide--protein glycosyltransferase subunit (non-catalytic)|dolichyl-diphosphooligosaccharide-protein glycotransferase|oligosaccharyl transferase 48 kDa subunit|oligosaccharyltransferase 48 kDa subunit|oligosaccharyltransferase subunit 48', map_location='1p36.12', chromosome='1', genomic_nucleotide_accession_version='NC_000001.11', start_position_on_the_genomic_accession=20651777, end_position_on_the_genomic_accession=20661369, orientation='minus', exon_count=11, OMIM=[602202], no_hdr0=''),
    1652 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1652, CurrentID=0, Status='live', Symbol='DDT', Aliases=['D-DT', 'DDCT', 'MIF-2', 'MIF2'], description='D-dopachrome tautomerase', other_designations='D-dopachrome decarboxylase|phenylpyruvate tautomerase II', map_location='22q11.23', chromosome='22', genomic_nucleotide_accession_version='NC_000022.11', start_position_on_the_genomic_accession=23971370, end_position_on_the_genomic_accession=23979828, orientation='minus', exon_count=5, OMIM=[602750], no_hdr0=''),
    1653 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1653, CurrentID=0, Status='live', Symbol='DDX1', Aliases=['DBP-RB', 'UKVH5d'], description='DEAD-box helicase 1', other_designations='ATP-dependent RNA helicase DDX1|DEAD (Asp-Glu-Ala-Asp) box helicase 1|DEAD (Asp-Glu-Ala-Asp) box polypeptide 1|DEAD box polypeptide 1|DEAD box protein 1|DEAD box protein retinoblastoma|DEAD box-1|DEAD/H (Asp-Glu-Ala-Asp/His) box polypeptide 1|DEAD/H-box helicase 1', map_location='2p24.3', chromosome='2', genomic_nucleotide_accession_version='NC_000002.12', start_position_on_the_genomic_accession=15591868, end_position_on_the_genomic_accession=15631101, orientation='plus', exon_count=26, OMIM=[601257], no_hdr0=''),
    1654 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1654, CurrentID=0, Status='live', Symbol='DDX3X', Aliases=['CAP-Rf', 'DBX', 'DDX14', 'DDX3', 'HLP2', 'MRX102', 'MRXSSB'], description='DEAD-box helicase 3 X-linked', other_designations='ATP-dependent RNA helicase DDX3X|DEAD (Asp-Glu-Ala-Asp) box helicase 3, X-linked|DEAD (Asp-Glu-Ala-Asp) box polypeptide 3, X-linked|DEAD box protein 3, X-chromosomal|DEAD/H (Asp-Glu-Ala-Asp/His) box polypeptide 3|DEAD/H box-3|helicase-like protein 2', map_location='Xp11.4', chromosome='X', genomic_nucleotide_accession_version='NC_000023.11', start_position_on_the_genomic_accession=41333308, end_position_on_the_genomic_accession=41364472, orientation='plus', exon_count=20, OMIM=[300160], no_hdr0=''),
    1655 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1655, CurrentID=0, Status='live', Symbol='DDX5', Aliases=['G17P1', 'HLR1', 'HUMP68', 'p68'], description='DEAD-box helicase 5', other_designations='probable ATP-dependent RNA helicase DDX5|ATP-dependent RNA helicase DDX5|DEAD (Asp-Glu-Ala-Asp) box helicase 5|DEAD (Asp-Glu-Ala-Asp) box polypeptide 5|DEAD box protein 5|DEAD box-5|DEAD/H (Asp-Glu-Ala-Asp/His) box polypeptide 5 (RNA helicase, 68kD)|RNA helicase p68', map_location='17q23.3', chromosome='17', genomic_nucleotide_accession_version='NC_000017.11', start_position_on_the_genomic_accession=64498254, end_position_on_the_genomic_accession=64506866, orientation='minus', exon_count=16, OMIM=[180630], no_hdr0=''),
    1656 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1656, CurrentID=0, Status='live', Symbol='DDX6', Aliases=['HLR2', 'IDDILF', 'P54', 'RCK', 'Rck/p54'], description='DEAD-box helicase 6', other_designations='probable ATP-dependent RNA helicase DDX6|ATP-dependent RNA helicase p54|DEAD (Asp-Glu-Ala-Asp) box helicase 6|DEAD (Asp-Glu-Ala-Asp) box polypeptide 6|DEAD box protein 6|DEAD box-6|DEAD/H (Asp-Glu-Ala-Asp/His) box polypeptide 6 (RNA helicase, 54kD)|oncogene RCK', map_location='11q23.3', chromosome='11', genomic_nucleotide_accession_version='NC_000011.10', start_position_on_the_genomic_accession=118747763, end_position_on_the_genomic_accession=118791696, orientation='minus', exon_count=16, OMIM=[600326], no_hdr0=''),
    1657 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1657, CurrentID=0, Status='live', Symbol='DMXL1', Aliases=[], description='Dmx like 1', other_designations='dmX-like protein 1', map_location='5q23.1', chromosome='5', genomic_nucleotide_accession_version='NC_000005.10', start_position_on_the_genomic_accession=119071002, end_position_on_the_genomic_accession=119249432, orientation='plus', exon_count=47, OMIM=[605671], no_hdr0=''),
    1659 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1659, CurrentID=0, Status='live', Symbol='DHX8', Aliases=['DDX8', 'Dhr2', 'HRH1', 'PRP22', 'PRPF22'], description='DEAH-box helicase 8', other_designations='ATP-dependent RNA helicase DHX8|DEAD/H (Asp-Glu-Ala-Asp/His) box polypeptide 8 (RNA helicase)|DEAH (Asp-Glu-Ala-His) box polypeptide 8|DEAH box protein 8|RNA helicase HRH1', map_location='17q21.31', chromosome='17', genomic_nucleotide_accession_version='NC_000017.11', start_position_on_the_genomic_accession=43483975, end_position_on_the_genomic_accession=43544799, orientation='plus', exon_count=27, OMIM=[600396], no_hdr0=''),
    1660 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1660, CurrentID=0, Status='live', Symbol='DHX9', Aliases=['DDX9', 'LKP', 'NDH2', 'NDHII', 'RHA'], description='DExH-box helicase 9', other_designations='ATP-dependent RNA helicase A|DEAD/H (Asp-Glu-Ala-Asp/His) box polypeptide 9|DEAH (Asp-Glu-Ala-His) box helicase 9|DEAH (Asp-Glu-Ala-His) box polypeptide 9|DEAH box protein 9|DEAH-box helicase 9|RNA helicase A|leukophysin|nuclear DNA helicase II', map_location='1q25.3', chromosome='1', genomic_nucleotide_accession_version='NC_000001.11', start_position_on_the_genomic_accession=182839347, end_position_on_the_genomic_accession=182887982, orientation='plus', exon_count=29, OMIM=[603115], no_hdr0=''),
    1662 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1662, CurrentID=0, Status='live', Symbol='DDX10', Aliases=['Dbp4', 'HRH-J8'], description='DEAD-box helicase 10', other_designations='probable ATP-dependent RNA helicase DDX10|DDX10-NUP98 fusion protein type 2|DEAD (Asp-Glu-Ala-Asp) box polypeptide 10|DEAD box protein 10|DEAD/H (Asp-Glu-Ala-Asp/His) box polypeptide 10 (RNA helicase)', map_location='11q22.3', chromosome='11', genomic_nucleotide_accession_version='NC_000011.10', start_position_on_the_genomic_accession=108665069, end_position_on_the_genomic_accession=108940927, orientation='plus', exon_count=18, OMIM=[601235], no_hdr0=''),
    1663 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1663, CurrentID=0, Status='live', Symbol='DDX11', Aliases=['CHL1', 'CHLR1', 'KRG2', 'WABS'], description='DEAD/H-box helicase 11', other_designations='ATP-dependent DNA helicase DDX11|CHL1-like helicase homolog|CHL1-related helicase gene-1|CHL1-related protein 1|DEAD/H (Asp-Glu-Ala-Asp/His) box helicase 11|DEAD/H (Asp-Glu-Ala-Asp/His) box polypeptide 11 (CHL1-like helicase homolog, S. cerevisiae)|DEAD/H box protein 11|KRG-2|hCHLR1|keratinocyte growth factor-regulated gene 2 protein|probable ATP-dependent DNA helicase DDX11|probable ATP-dependent RNA helicase DDX11', map_location='12p11.21', chromosome='12', genomic_nucleotide_accession_version='NC_000012.12', start_position_on_the_genomic_accession=31073860, end_position_on_the_genomic_accession=31104799, orientation='plus', exon_count=33, OMIM=[601150], no_hdr0=''),
    1665 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1665, CurrentID=0, Status='live', Symbol='DHX15', Aliases=['DBP1', 'DDX15', 'HRH2', 'PRP43', 'PRPF43', 'PrPp43p'], description='DEAH-box helicase 15', other_designations='pre-mRNA-splicing factor ATP-dependent RNA helicase DHX15|ATP-dependent RNA helicase #46|DEAD/H (Asp-Glu-Ala-Asp/His) box polypeptide 15|DEAD/H box-15|DEAH (Asp-Glu-Ala-His) box helicase 15|DEAH (Asp-Glu-Ala-His) box polypeptide 15|DEAH box protein 15|RNA helicase 2|putative pre-mRNA-splicing factor ATP-dependent RNA helicase DHX15', map_location='4p15.2', chromosome='4', genomic_nucleotide_accession_version='NC_000004.12', start_position_on_the_genomic_accession=24527475, end_position_on_the_genomic_accession=24584554, orientation='minus', exon_count=14, OMIM=[603403], no_hdr0=''),
    1666 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1666, CurrentID=0, Status='live', Symbol='DECR1', Aliases=['DECR', 'NADPH', 'SDR18C1'], description='2,4-dienoyl-CoA reductase 1', other_designations='2,4-dienoyl-CoA reductase, mitochondrial|2,4-dienoyl-CoA reductase 1, mitochondrial|4-enoyl-CoA reductase|short chain dehydrogenase/reductase family 18C member 1', map_location='8q21.3', chromosome='8', genomic_nucleotide_accession_version='NC_000008.11', start_position_on_the_genomic_accession=90001437, end_position_on_the_genomic_accession=90053633, orientation='plus', exon_count=13, OMIM=[222745], no_hdr0=''),
    1667 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1667, CurrentID=0, Status='live', Symbol='DEFA1', Aliases=['DEF1', 'DEFA2', 'HNP-1', 'HP-1', 'HP1', 'MRS'], description='defensin alpha 1', other_designations='neutrophil defensin 1|defensin, alpha 1, myeloid-related sequence|defensin, alpha 2|myeloid-related sequence', map_location='8p23.1', chromosome='8', genomic_nucleotide_accession_version='NC_000008.11', start_position_on_the_genomic_accession=6977649, end_position_on_the_genomic_accession=6980120, orientation='minus', exon_count=4, OMIM=[125220], no_hdr0=''),
    1668 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1668, CurrentID=0, Status='live', Symbol='DEFA3', Aliases=['DEF3', 'HNP-3', 'HNP3', 'HP-3', 'HP3'], description='defensin alpha 3', other_designations='neutrophil defensin 3|defensin 3, neutrophil-specific|defensin, alpha 3, neutrophil-specific|neutrophil peptide 3', map_location='8p23.1', chromosome='8', genomic_nucleotide_accession_version='NC_000008.11', start_position_on_the_genomic_accession=7015869, end_position_on_the_genomic_accession=7018336, orientation='minus', exon_count=4, OMIM=[604522], no_hdr0=''),
    1669 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1669, CurrentID=0, Status='live', Symbol='DEFA4', Aliases=['DEF4', 'HNP-4', 'HP-4', 'HP4'], description='defensin alpha 4', other_designations='neutrophil defensin 4|corticostatin|defensin, alpha 4, corticostatin|defensin, alpha 4, preproprotein', map_location='8p23.1', chromosome='8', genomic_nucleotide_accession_version='NC_000008.11', start_position_on_the_genomic_accession=6935820, end_position_on_the_genomic_accession=6938306, orientation='minus', exon_count=3, OMIM=[601157], no_hdr0=''),
    1670 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1670, CurrentID=0, Status='live', Symbol='DEFA5', Aliases=['DEF5', 'HD-5'], description='defensin alpha 5', other_designations='defensin-5|HD5(20-94)|defensin, alpha 5, Paneth cell-specific|defensin, alpha 5, preproprotein', map_location='8p23.1', chromosome='8', genomic_nucleotide_accession_version='NC_000008.11', start_position_on_the_genomic_accession=7055304, end_position_on_the_genomic_accession=7056739, orientation='minus', exon_count=2, OMIM=[600472], no_hdr0=''),
    1671 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1671, CurrentID=0, Status='live', Symbol='DEFA6', Aliases=['DEF6', 'HD-6'], description='defensin alpha 6', other_designations='defensin-6|defensin, alpha 6, Paneth cell-specific', map_location='8p23.1', chromosome='8', genomic_nucleotide_accession_version='NC_000008.11', start_position_on_the_genomic_accession=6924697, end_position_on_the_genomic_accession=6926076, orientation='minus', exon_count=2, OMIM=[600471], no_hdr0=''),
    1672 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1672, CurrentID=0, Status='live', Symbol='DEFB1', Aliases=['BD1', 'DEFB-101', 'HBD1', 'DEFB1'], description='defensin beta 1', other_designations='beta-defensin 1|BD-1', map_location='8p23.1', chromosome='8', genomic_nucleotide_accession_version='NC_000008.11', start_position_on_the_genomic_accession=6870592, end_position_on_the_genomic_accession=6877936, orientation='minus', exon_count=2, OMIM=[602056], no_hdr0=''),
    1673 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1673, CurrentID=0, Status='live', Symbol='DEFB4A', Aliases=['BD-2', 'DEFB-2', 'DEFB102', 'DEFB2', 'DEFB4', 'HBD-2', 'SAP1'], description='defensin beta 4A', other_designations='beta-defensin 4A|beta defensin-2|defensin, beta 2|defensin, beta 4|skin-antimicrobial peptide 1', map_location='8p23.1', chromosome='8', genomic_nucleotide_accession_version='NC_000008.11', start_position_on_the_genomic_accession=7894677, end_position_on_the_genomic_accession=7896716, orientation='plus', exon_count=2, OMIM=[602215], no_hdr0=''),
    1674 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1674, CurrentID=0, Status='live', Symbol='DES', Aliases=['CDCD3', 'CSM1', 'CSM2', 'LGMD1D', 'LGMD1E', 'LGMD2R'], description='desmin', other_designations='desmin|cardiomyopathy, dilated 1F (autosomal dominant)|epididymis secretory sperm binding protein|intermediate filament protein', map_location='2q35', chromosome='2', genomic_nucleotide_accession_version='NC_000002.12', start_position_on_the_genomic_accession=219418377, end_position_on_the_genomic_accession=219426734, orientation='plus', exon_count=9, OMIM=[125660], no_hdr0=''),
    1675 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1675, CurrentID=0, Status='live', Symbol='CFD', Aliases=['ADIPSIN', 'ADN', 'DF', 'PFD'], description='complement factor D', other_designations='complement factor D|C3 convertase activator|D component of complement (adipsin)|complement factor D preproprotein|properdin factor D', map_location='19p13.3', chromosome='19', genomic_nucleotide_accession_version='NC_000019.10', start_position_on_the_genomic_accession=859664, end_position_on_the_genomic_accession=863641, orientation='plus', exon_count=5, OMIM=[134350], no_hdr0=''),
    1676 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1676, CurrentID=0, Status='live', Symbol='DFFA', Aliases=['DFF-45', 'DFF1', 'ICAD'], description='DNA fragmentation factor subunit alpha', other_designations='DNA fragmentation factor subunit alpha|DFF45|DNA fragmentation factor 45 kDa subunit|DNA fragmentation factor, 45kDa, alpha polypeptide|inhibitor of CAD', map_location='1p36.22', chromosome='1', genomic_nucleotide_accession_version='NC_000001.11', start_position_on_the_genomic_accession=10456522, end_position_on_the_genomic_accession=10472529, orientation='minus', exon_count=6, OMIM=[601882], no_hdr0=''),
    1677 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1677, CurrentID=0, Status='live', Symbol='DFFB', Aliases=['CAD', 'CPAN', 'DFF-40', 'DFF2', 'DFF40'], description='DNA fragmentation factor subunit beta', other_designations='DNA fragmentation factor subunit beta|DNA fragmentation factor 40 kDa subunit|DNA fragmentation factor, 40kDa, beta polypeptide (caspase-activated DNase)|caspase-activated DNase|caspase-activated deoxyribonuclease|caspase-activated nuclease', map_location='1p36.32', chromosome='1', genomic_nucleotide_accession_version='NC_000001.11', start_position_on_the_genomic_accession=3857286, end_position_on_the_genomic_accession=3885429, orientation='plus', exon_count=11, OMIM=[601883], no_hdr0=''),
    1678 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1678, CurrentID=0, Status='live', Symbol='TIMM8A', Aliases=['DDP', 'DDP1', 'DFN1', 'MTS', 'TIM8'], description='translocase of inner mitochondrial membrane 8A', other_designations='mitochondrial import inner membrane translocase subunit Tim8 A|X-linked deafness dystonia protein|deafness dystonia protein 1|deafness/dystonia peptide|translocase of inner mitochondrial membrane 8 homolog A', map_location='Xq22.1', chromosome='X', genomic_nucleotide_accession_version='NC_000023.11', start_position_on_the_genomic_accession=101345661, end_position_on_the_genomic_accession=101348742, orientation='minus', exon_count=2, OMIM=[300356], no_hdr0=''),
    1687 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1687, CurrentID=0, Status='live', Symbol='GSDME', Aliases=['DFNA5', 'ICERE-1'], description='gasdermin E', other_designations='gasdermin-E|DFNA5, deafness associated tumor suppressor|inversely correlated with estrogen receptor expression 1|non-syndromic hearing impairment protein 5|nonsyndromic hearing impairment protein', map_location='7p15.3', chromosome='7', genomic_nucleotide_accession_version='NC_000007.14', start_position_on_the_genomic_accession=24698355, end_position_on_the_genomic_accession=24762235, orientation='minus', exon_count=13, OMIM=[608798], no_hdr0=''),
    1690 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1690, CurrentID=0, Status='live', Symbol='COCH', Aliases=['COCH-5B25B2', 'DFNA9', 'DFNB110', 'COCH'], description='cochlin', other_designations='cochlin|coagulation factor C homolog, cochlin (Limulus polyphemus)', map_location='14q12', chromosome='14', genomic_nucleotide_accession_version='NC_000014.9', start_position_on_the_genomic_accession=30874496, end_position_on_the_genomic_accession=30890618, orientation='plus', exon_count=13, OMIM=[603196], no_hdr0=''),
    1716 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1716, CurrentID=0, Status='live', Symbol='DGUOK', Aliases=['MTDPS3', 'NCPH', 'PEOB4', 'dGK'], description='deoxyguanosine kinase', other_designations='deoxyguanosine kinase, mitochondrial|deoxyadenosine kinase, mitochondrial', map_location='2p13.1', chromosome='2', genomic_nucleotide_accession_version='NC_000002.12', start_position_on_the_genomic_accession=73926827, end_position_on_the_genomic_accession=73958961, orientation='plus', exon_count=8, OMIM=[601465], no_hdr0=''),
    1717 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1717, CurrentID=0, Status='live', Symbol='DHCR7', Aliases=['SLOS'], description='7-dehydrocholesterol reductase', other_designations='7-dehydrocholesterol reductase|7-DHC reductase|delta-7-dehydrocholesterol reductase|delta7-sterol reductase|putative sterol reductase SR-2|sterol delta-7-reductase|sterol reductase SR-2', map_location='11q13.4', chromosome='11', genomic_nucleotide_accession_version='NC_000011.10', start_position_on_the_genomic_accession=71434411, end_position_on_the_genomic_accession=71448393, orientation='minus', exon_count=9, OMIM=[602858], no_hdr0=''),
    1718 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1718, CurrentID=0, Status='live', Symbol='DHCR24', Aliases=['DCE', 'Nbla03646', 'SELADIN1', 'seladin-1'], description='24-dehydrocholesterol reductase', other_designations='delta(24)-sterol reductase|3 beta-hydroxysterol delta 24-reductase|desmosterol-to-cholesterol enzyme|diminuto/dwarf1 homolog|seladin 1|selective AD indicator 1', map_location='1p32.3', chromosome='1', genomic_nucleotide_accession_version='NC_000001.11', start_position_on_the_genomic_accession=54849627, end_position_on_the_genomic_accession=54887195, orientation='minus', exon_count=9, OMIM=[606418], no_hdr0=''),
    1719 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1719, CurrentID=0, Status='live', Symbol='DHFR', Aliases=['DHFRP1', 'DYR'], description='dihydrofolate reductase', other_designations='dihydrofolate reductase', map_location='5q14.1', chromosome='5', genomic_nucleotide_accession_version='NC_000005.10', start_position_on_the_genomic_accession=80626226, end_position_on_the_genomic_accession=80654983, orientation='minus', exon_count=6, OMIM=[126060], no_hdr0=''),
    1723 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1723, CurrentID=0, Status='live', Symbol='DHODH', Aliases=['DHOdehase', 'POADS', 'URA1'], description='dihydroorotate dehydrogenase (quinone)', other_designations='dihydroorotate dehydrogenase (quinone), mitochondrial|dihydroorotate oxidase|human complement of yeast URA1', map_location='16q22.2', chromosome='16', genomic_nucleotide_accession_version='NC_000016.10', start_position_on_the_genomic_accession=72008744, end_position_on_the_genomic_accession=72027659, orientation='plus', exon_count=11, OMIM=[126064], no_hdr0=''),
    1725 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1725, CurrentID=0, Status='live', Symbol='DHPS', Aliases=['DHS', 'DS', 'MIG13', 'NEDSSWI'], description='deoxyhypusine synthase', other_designations='deoxyhypusine synthase|migration-inducing gene 13', map_location='19p13.13', chromosome='19', genomic_nucleotide_accession_version='NC_000019.10', start_position_on_the_genomic_accession=12672470, end_position_on_the_genomic_accession=12681880, orientation='minus', exon_count=12, OMIM=[600944], no_hdr0=''),
    1727 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1727, CurrentID=0, Status='live', Symbol='CYB5R3', Aliases=['B5R', 'DIA1'], description='cytochrome b5 reductase 3', other_designations='NADH-cytochrome b5 reductase 3|NADH-cytochrome b5 reductase 3 membrane-bound form|NADH-cytochrome b5 reductase 3 soluble form|diaphorase-1|mutant NADH-cytochrome b5 reductase', map_location='22q13.2', chromosome='22', genomic_nucleotide_accession_version='NC_000022.11', start_position_on_the_genomic_accession=42617840, end_position_on_the_genomic_accession=42649392, orientation='minus', exon_count=12, OMIM=[613213], no_hdr0=''),
    1728 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1728, CurrentID=0, Status='live', Symbol='NQO1', Aliases=['DHQU', 'DIA4', 'DTD', 'NMOR1', 'NMORI', 'QR1'], description='NAD(P)H quinone dehydrogenase 1', other_designations='NAD(P)H dehydrogenase [quinone] 1|DT-diaphorase|NAD(P)H dehydrogenase, quinone 1|NAD(P)H:Quinone acceptor oxidoreductase type 1|NAD(P)H:menadione oxidoreductase 1|NAD(P)H:quinone oxidoreductase 1|NAD(P)H:quinone oxireductase|azoreductase|diaphorase (NADH/NADPH) (cytochrome b-5 reductase)|diaphorase-4|dioxin-inducible 1|menadione reductase|phylloquinone reductase|quinone reductase 1', map_location='16q22.1', chromosome='16', genomic_nucleotide_accession_version='NC_000016.10', start_position_on_the_genomic_accession=69709401, end_position_on_the_genomic_accession=69726560, orientation='minus', exon_count=6, OMIM=[125860], no_hdr0=''),
    1729 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1729, CurrentID=0, Status='live', Symbol='DIAPH1', Aliases=['DFNA1', 'DIA1', 'DRF1', 'LFHL1', 'SCBMS', 'hDIA1'], description='diaphanous related formin 1', other_designations='protein diaphanous homolog 1', map_location='5q31.3', chromosome='5', genomic_nucleotide_accession_version='NC_000005.10', start_position_on_the_genomic_accession=141515016, end_position_on_the_genomic_accession=141619055, orientation='minus', exon_count=30, OMIM=[602121], no_hdr0=''),
    1730 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1730, CurrentID=0, Status='live', Symbol='DIAPH2', Aliases=['DIA', 'DIA2', 'DRF2', 'POF', 'POF2', 'POF2A'], description='diaphanous related formin 2', other_designations='protein diaphanous homolog 2|diaphanous homolog 2|diaphorase-2', map_location='Xq21.33', chromosome='X', genomic_nucleotide_accession_version='NC_000023.11', start_position_on_the_genomic_accession=96684842, end_position_on_the_genomic_accession=97604997, orientation='plus', exon_count=28, OMIM=[300108], no_hdr0=''),
    1731 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1731, CurrentID=0, Status='live', Symbol='SEPTIN1', Aliases=['DIFF6', 'LARP', 'PNUTL3', 'SEP1', 'SEPT1'], description='septin 1', other_designations='septin-1|differentiation 6 (deoxyguanosine triphosphate triphosphohydrolase)|peanut-like protein 3|serologically defined breast cancer antigen NY-BR-24', map_location='16p11.2', chromosome='16', genomic_nucleotide_accession_version='NC_000016.10', start_position_on_the_genomic_accession=30378135, end_position_on_the_genomic_accession=30382830, orientation='minus', exon_count=10, OMIM=[612897], no_hdr0=''),
    1733 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1733, CurrentID=0, Status='live', Symbol='DIO1', Aliases=['5DI', 'TXDI1'], description='iodothyronine deiodinase 1', other_designations="type I iodothyronine deiodinase|DIOI|deiodinase, iodothyronine type I|iodothyronine deiodinase type 1|selenoprotein DIO1|thyroxine 5'-deiodinase|thyroxine deiodinase type I (selenoprotein)|type 1 DI|type-I 5'-deiodinase", map_location='1p32.3', chromosome='1', genomic_nucleotide_accession_version='NC_000001.11', start_position_on_the_genomic_accession=53894187, end_position_on_the_genomic_accession=53911086, orientation='plus', exon_count=5, OMIM=[147892], no_hdr0=''),
    1734 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1734, CurrentID=0, Status='live', Symbol='DIO2', Aliases=['5DII', 'D2', 'DIOII', 'SelY', 'TXDI2'], description='iodothyronine deiodinase 2', other_designations="type II iodothyronine deiodinase|deiodinase, iodothyronine type II|deiodinase-2|deiodonase-2|selenoprotein Y|thyroxine deiodinase, type II|type 2 DI|type 2 iodothyronine deiodinase|type-II 5'-deiodinase|type-II 5'deiodinase", map_location='14q31.1', chromosome='14', genomic_nucleotide_accession_version='NC_000014.9', start_position_on_the_genomic_accession=80197526, end_position_on_the_genomic_accession=80231057, orientation='minus', exon_count=7, OMIM=[601413], no_hdr0=''),
    1735 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1735, CurrentID=0, Status='live', Symbol='DIO3', Aliases=['5DIII', 'D3', 'DIOIII', 'TXDI3'], description='iodothyronine deiodinase 3', other_designations="thyroxine 5-deiodinase|deiodinase, iodothyronine type III|iodothyronine deiodinase, placental type|selenoprotein DIO3|thyroxine deiodinase type III (selenoprotein)|type 3 DI|type 3 iodothyronine selenodeiodinase|type-III 5' deiodinase", map_location='14q32.31', chromosome='14', genomic_nucleotide_accession_version='NC_000014.9', start_position_on_the_genomic_accession=101561351, end_position_on_the_genomic_accession=101563452, orientation='plus', exon_count=1, OMIM=[601038], no_hdr0=''),
    1736 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1736, CurrentID=0, Status='live', Symbol='DKC1', Aliases=['CBF5', 'DKC', 'DKCX', 'NAP57', 'NOLA4', 'XAP101'], description='dyskerin pseudouridine synthase 1', other_designations='H/ACA ribonucleoprotein complex subunit DKC1|CBF5 homolog|H/ACA ribonucleoprotein complex subunit 4|dyskeratosis congenita 1, dyskerin|nopp140-associated protein of 57 kDa|nucleolar protein NAP57|nucleolar protein family A member 4|snoRNP protein DKC1', map_location='Xq28', chromosome='X', genomic_nucleotide_accession_version='NC_000023.11', start_position_on_the_genomic_accession=154762864, end_position_on_the_genomic_accession=154777689, orientation='plus', exon_count=14, OMIM=[300126], no_hdr0=''),
    1737 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1737, CurrentID=0, Status='live', Symbol='DLAT', Aliases=['DLTA', 'E2', 'PBC', 'PDC-E2', 'PDCE2'], description='dihydrolipoamide S-acetyltransferase', other_designations='dihydrolipoyllysine-residue acetyltransferase component of pyruvate dehydrogenase complex, mitochondrial|70 kDa mitochondrial autoantigen of primary biliary cirrhosis|E2 component of pyruvate dehydrogenase complex|M2 antigen complex 70 kDa subunit|dihydrolipoamide acetyltransferase component of pyruvate dehydrogenase complex|pyruvate dehydrogenase complex component E2', map_location='11q23.1', chromosome='11', genomic_nucleotide_accession_version='NC_000011.10', start_position_on_the_genomic_accession=112025408, end_position_on_the_genomic_accession=112064404, orientation='plus', exon_count=14, OMIM=[608770], no_hdr0=''),
    1738 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1738, CurrentID=0, Status='live', Symbol='DLD', Aliases=['DLDDH', 'E3', 'GCSL', 'LAD', 'OGDC-E3', 'PHE3', 'DLD'], description='dihydrolipoamide dehydrogenase', other_designations='dihydrolipoyl dehydrogenase, mitochondrial|E3 component of pyruvate dehydrogenase complex, 2-oxo-glutarate complex, branched chain keto acid dehydrogenase complex|diaphorase|epididymis secretory sperm binding protein|glycine cleavage system L protein|glycine cleavage system protein L|lipoamide dehydrogenase|lipoamide reductase|lipoyl dehydrogenase', map_location='7q31.1', chromosome='7', genomic_nucleotide_accession_version='NC_000007.14', start_position_on_the_genomic_accession=107891107, end_position_on_the_genomic_accession=107921198, orientation='plus', exon_count=14, OMIM=[238331], no_hdr0=''),
    1739 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1739, CurrentID=0, Status='live', Symbol='DLG1', Aliases=['DLGH1', 'SAP-97', 'SAP97', 'hdlg'], description='discs large MAGUK scaffold protein 1', other_designations='disks large homolog 1|dJ1061C18.1.1|discs large homolog 1, scribble cell polarity complex component|presynaptic protein SAP97|synapse-associated protein 97', map_location='3q29', chromosome='3', genomic_nucleotide_accession_version='NC_000003.12', start_position_on_the_genomic_accession=197042560, end_position_on_the_genomic_accession=197299321, orientation='minus', exon_count=35, OMIM=[601014], no_hdr0=''),
    1740 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1740, CurrentID=0, Status='live', Symbol='DLG2', Aliases=['PPP1R58', 'PSD-93', 'PSD93', 'chapsyn-110'], description='discs large MAGUK scaffold protein 2', other_designations='disks large homolog 2|channel-associated protein of synapse-110|channel-associated protein of synapses, 110kDa|discs, large homolog 2, chapsyn-110|postsynaptic density protein PSD-93|protein phosphatase 1, regulatory subunit 58', map_location='11q14.1', chromosome='11', genomic_nucleotide_accession_version='NC_000011.10', start_position_on_the_genomic_accession=83455009, end_position_on_the_genomic_accession=85628535, orientation='minus', exon_count=47, OMIM=[603583], no_hdr0=''),
    1741 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1741, CurrentID=0, Status='live', Symbol='DLG3', Aliases=['MRX', 'MRX90', 'NEDLG', 'PPP1R82', 'SAP102', 'XLMR'], description='discs large MAGUK scaffold protein 3', other_designations='disks large homolog 3|discs, large homolog 3|neuroendocrine-DLG|protein phosphatase 1, regulatory subunit 82|synapse-associated protein 102', map_location='Xq13.1', chromosome='X', genomic_nucleotide_accession_version='NC_000023.11', start_position_on_the_genomic_accession=70444835, end_position_on_the_genomic_accession=70505490, orientation='plus', exon_count=26, OMIM=[300189], no_hdr0=''),
    1742 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1742, CurrentID=0, Status='live', Symbol='DLG4', Aliases=['MRD62', 'PSD95', 'SAP-90', 'SAP90'], description='discs large MAGUK scaffold protein 4', other_designations='disks large homolog 4|Tax interaction protein 15|discs large homolog 4|post-synaptic density protein 95|synapse-associated protein 90', map_location='17p13.1', chromosome='17', genomic_nucleotide_accession_version='NC_000017.11', start_position_on_the_genomic_accession=7187187, end_position_on_the_genomic_accession=7220050, orientation='minus', exon_count=27, OMIM=[602887], no_hdr0=''),
    1743 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1743, CurrentID=0, Status='live', Symbol='DLST', Aliases=['DLTS', 'KGD2', 'PGL7'], description='dihydrolipoamide S-succinyltransferase', other_designations='dihydrolipoyllysine-residue succinyltransferase component of 2-oxoglutarate dehydrogenase complex, mitochondrial|E2K|OGDC-E2|dihydrolipoamide S-succinyltransferase (E2 component of 2-oxo-glutarate complex)', map_location='14q24.3', chromosome='14', genomic_nucleotide_accession_version='NC_000014.9', start_position_on_the_genomic_accession=74881913, end_position_on_the_genomic_accession=74903743, orientation='plus', exon_count=15, OMIM=[126063], no_hdr0=''),
    1745 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1745, CurrentID=0, Status='live', Symbol='DLX1', Aliases=[], description='distal-less homeobox 1', other_designations='homeobox protein DLX-1|distal-less homeo box 1', map_location='2q31.1', chromosome='2', genomic_nucleotide_accession_version='NC_000002.12', start_position_on_the_genomic_accession=172085507, end_position_on_the_genomic_accession=172089674, orientation='plus', exon_count=3, OMIM=[600029], no_hdr0=''),
    1746 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1746, CurrentID=0, Status='live', Symbol='DLX2', Aliases=['TES-1', 'TES1'], description='distal-less homeobox 2', other_designations='homeobox protein DLX-2|distal-less homeo box 2', map_location='2q31.1', chromosome='2', genomic_nucleotide_accession_version='NC_000002.12', start_position_on_the_genomic_accession=172099438, end_position_on_the_genomic_accession=172102900, orientation='minus', exon_count=3, OMIM=[126255], no_hdr0=''),
    1747 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1747, CurrentID=0, Status='live', Symbol='DLX3', Aliases=['AI4', 'TDO'], description='distal-less homeobox 3', other_designations='homeobox protein DLX-3', map_location='17q21.33', chromosome='17', genomic_nucleotide_accession_version='NC_000017.11', start_position_on_the_genomic_accession=49990005, end_position_on_the_genomic_accession=49995224, orientation='minus', exon_count=3, OMIM=[600525], no_hdr0=''),
    1748 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1748, CurrentID=0, Status='live', Symbol='DLX4', Aliases=['BP1', 'DLX7', 'DLX8', 'DLX9', 'OFC15'], description='distal-less homeobox 4', other_designations='homeobox protein DLX-4|beta protein 1|distal-less homeo box 7|distal-less homeo box 9|homeobox protein DLX-7|homeobox protein DLX-8', map_location='17q21.33', chromosome='17', genomic_nucleotide_accession_version='NC_000017.11', start_position_on_the_genomic_accession=49968970, end_position_on_the_genomic_accession=49974959, orientation='plus', exon_count=4, OMIM=[601911], no_hdr0=''),
    1749 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1749, CurrentID=0, Status='live', Symbol='DLX5', Aliases=['SHFM1', 'SHFM1D'], description='distal-less homeobox 5', other_designations='homeobox protein DLX-5|distal-less homeo box 5|split hand/foot malformation type 1 with sensorineural hearing loss', map_location='7q21.3', chromosome='7', genomic_nucleotide_accession_version='NC_000007.14', start_position_on_the_genomic_accession=97020396, end_position_on_the_genomic_accession=97024831, orientation='minus', exon_count=5, OMIM=[600028], no_hdr0=''),
    1750 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1750, CurrentID=0, Status='live', Symbol='DLX6', Aliases=[], description='distal-less homeobox 6', other_designations='homeobox protein DLX-6|distal-less homeo box 6', map_location='7q21.3', chromosome='7', genomic_nucleotide_accession_version='NC_000007.14', start_position_on_the_genomic_accession=97005553, end_position_on_the_genomic_accession=97011040, orientation='plus', exon_count=3, OMIM=[600030], no_hdr0=''),
    1755 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1755, CurrentID=0, Status='live', Symbol='DMBT1', Aliases=['GP340', 'SAG', 'SALSA', 'muclin'], description='deleted in malignant brain tumors 1', other_designations='deleted in malignant brain tumors 1 protein|glycoprotein 340|hensin|salivary agglutinin|salivary scavenger and agglutinin|surfactant pulmonary-associated D-binding protein|vomeroglandin', map_location='10q26.13', chromosome='10', genomic_nucleotide_accession_version='NC_000010.11', start_position_on_the_genomic_accession=122560677, end_position_on_the_genomic_accession=122643736, orientation='plus', exon_count=57, OMIM=[601969], no_hdr0=''),
    1756 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1756, CurrentID=0, Status='live', Symbol='DMD', Aliases=['BMD', 'CMD3B', 'DXS142', 'DXS164', 'DXS206', 'DXS230', 'DXS239', 'DXS268', 'DXS269', 'DXS270', 'DXS272', 'MRX85'], description='dystrophin', other_designations='dystrophin|truncated dystrophin', map_location='Xp21.2-p21.1', chromosome='X', genomic_nucleotide_accession_version='NC_000023.11', start_position_on_the_genomic_accession=31119219, end_position_on_the_genomic_accession=33339460, orientation='minus', exon_count=89, OMIM=[300377], no_hdr0=''),
    1757 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1757, CurrentID=0, Status='live', Symbol='SARDH', Aliases=['BPR-2', 'DMGDHL1', 'SAR', 'SARD', 'SDH'], description='sarcosine dehydrogenase', other_designations='sarcosine dehydrogenase, mitochondrial|dimethylglycine dehydrogenase-like 1', map_location='9q34.2', chromosome='9', genomic_nucleotide_accession_version='NC_000009.12', start_position_on_the_genomic_accession=133663074, end_position_on_the_genomic_accession=133739958, orientation='minus', exon_count=26, OMIM=[604455], no_hdr0=''),
    1758 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1758, CurrentID=0, Status='live', Symbol='DMP1', Aliases=['ARHP', 'ARHR', 'DMP-1'], description='dentin matrix acidic phosphoprotein 1', other_designations='dentin matrix acidic phosphoprotein 1|dentin matrix protein 1', map_location='4q22.1', chromosome='4', genomic_nucleotide_accession_version='NC_000004.12', start_position_on_the_genomic_accession=87650280, end_position_on_the_genomic_accession=87664357, orientation='plus', exon_count=7, OMIM=[600980], no_hdr0=''),
    1759 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1759, CurrentID=0, Status='live', Symbol='DNM1', Aliases=['DNM', 'EIEE31'], description='dynamin 1', other_designations='dynamin-1', map_location='9q34.11', chromosome='9', genomic_nucleotide_accession_version='NC_000009.12', start_position_on_the_genomic_accession=128203379, end_position_on_the_genomic_accession=128255244, orientation='plus', exon_count=24, OMIM=[602377], no_hdr0=''),
    1760 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1760, CurrentID=0, Status='live', Symbol='DMPK', Aliases=['DM', 'DM1', 'DM1PK', 'DMK', 'MDPK', 'MT-PK'], description='DM1 protein kinase', other_designations='myotonin-protein kinase|DM protein kinase|dystrophia myotonica protein kinase|myotonic dystrophy associated protein kinase|myotonin protein kinase A|thymopoietin homolog', map_location='19q13.32', chromosome='19', genomic_nucleotide_accession_version='NC_000019.10', start_position_on_the_genomic_accession=45769709, end_position_on_the_genomic_accession=45782490, orientation='minus', exon_count=15, OMIM=[605377], no_hdr0=''),
    1761 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1761, CurrentID=0, Status='live', Symbol='DMRT1', Aliases=['CT154', 'DMT1'], description='doublesex and mab-3 related transcription factor 1', other_designations='doublesex- and mab-3-related transcription factor 1|DM domain expressed in testis 1|DM domain expressed in testis protein 1', map_location='9p24.3', chromosome='9', genomic_nucleotide_accession_version='NC_000009.12', start_position_on_the_genomic_accession=841647, end_position_on_the_genomic_accession=969090, orientation='plus', exon_count=8, OMIM=[602424], no_hdr0=''),
    1762 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1762, CurrentID=0, Status='live', Symbol='DMWD', Aliases=['D19S593E', 'DMR-N9', 'DMRN9', 'gene59'], description='DM1 locus, WD repeat containing', other_designations='dystrophia myotonica WD repeat-containing protein|dystrophia myotonica, WD repeat containing|dystrophia myotonica-containing WD repeat motif protein|protein 59', map_location='19q13.32', chromosome='19', genomic_nucleotide_accession_version='NC_000019.10', start_position_on_the_genomic_accession=45782947, end_position_on_the_genomic_accession=45792845, orientation='minus', exon_count=5, OMIM=[609857], no_hdr0=''),
    1763 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1763, CurrentID=0, Status='live', Symbol='DNA2', Aliases=['DNA2L', 'hDNA2'], description='DNA replication helicase/nuclease 2', other_designations='DNA replication ATP-dependent helicase/nuclease DNA2|DNA replication ATP-dependent helicase-like homolog|DNA replication helicase 2 homolog|DNA2 DNA replication helicase 2-like|DNA2-like helicase', map_location='10q21.3', chromosome='10', genomic_nucleotide_accession_version='NC_000010.11', start_position_on_the_genomic_accession=68414064, end_position_on_the_genomic_accession=68472521, orientation='minus', exon_count=22, OMIM=[601810], no_hdr0=''),
    1767 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1767, CurrentID=0, Status='live', Symbol='DNAH5', Aliases=['CILD3', 'DNAHC5', 'HL1', 'KTGNR', 'PCD'], description='dynein axonemal heavy chain 5', other_designations='dynein heavy chain 5, axonemal|axonemal beta dynein heavy chain 5|ciliary dynein heavy chain 5|dynein, axonemal, heavy polypeptide 5', map_location='5p15.2', chromosome='5', genomic_nucleotide_accession_version='NC_000005.10', start_position_on_the_genomic_accession=13690328, end_position_on_the_genomic_accession=14011829, orientation='minus', exon_count=86, OMIM=[603335], no_hdr0=''),
    1768 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1768, CurrentID=0, Status='live', Symbol='DNAH6', Aliases=['DNHL1', 'Dnahc6', 'HL-2', 'HL2'], description='dynein axonemal heavy chain 6', other_designations='dynein heavy chain 6, axonemal|axonemal beta dynein heavy chain 6|ciliary dynein heavy chain 6|dynein heavy chain-like 1|dynein, axonemal, heavy polypeptide 6', map_location='2p11.2', chromosome='2', genomic_nucleotide_accession_version='NC_000002.12', start_position_on_the_genomic_accession=84459572, end_position_on_the_genomic_accession=84819589, orientation='plus', exon_count=81, OMIM=[603336], no_hdr0=''),
    1769 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1769, CurrentID=0, Status='live', Symbol='DNAH8', Aliases=['ATPase', 'hdhc9'], description='dynein axonemal heavy chain 8', other_designations='dynein heavy chain 8, axonemal|axonemal beta dynein heavy chain 8|ciliary dynein heavy chain 8|dynein, axonemal, heavy polypeptide 8', map_location='6p21.2', chromosome='6', genomic_nucleotide_accession_version='NC_000006.12', start_position_on_the_genomic_accession=38715311, end_position_on_the_genomic_accession=39030798, orientation='plus', exon_count=97, OMIM=[603337], no_hdr0=''),
    1770 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1770, CurrentID=0, Status='live', Symbol='DNAH9', Aliases=['CILD40', 'DNAH17L', 'DNEL1', 'DYH9', 'Dnahc9', 'HL-20', 'HL20'], description='dynein axonemal heavy chain 9', other_designations='dynein heavy chain 9, axonemal|DNAH9 variant protein|axonemal beta dynein heavy chain 9|ciliary dynein heavy chain 9|dynein, axonemal, heavy polypeptide 9', map_location='17p12', chromosome='17', genomic_nucleotide_accession_version='NC_000017.11', start_position_on_the_genomic_accession=11598470, end_position_on_the_genomic_accession=11970168, orientation='plus', exon_count=73, OMIM=[603330], no_hdr0=''),
    1773 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1773, CurrentID=0, Status='live', Symbol='DNASE1', Aliases=['DNL1', 'DRNI'], description='deoxyribonuclease 1', other_designations='deoxyribonuclease-1|DNase I, lysosomal|Dornase alfa|deoxyribonuclease I|human urine deoxyribonuclease I', map_location='16p13.3', chromosome='16', genomic_nucleotide_accession_version='NC_000016.10', start_position_on_the_genomic_accession=3611737, end_position_on_the_genomic_accession=3665472, orientation='plus', exon_count=15, OMIM=[125505], no_hdr0=''),
    1774 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1774, CurrentID=0, Status='live', Symbol='DNASE1L1', Aliases=['DNAS1L1', 'DNASEX', 'DNL1L', 'G4.8', 'XIB'], description='deoxyribonuclease 1 like 1', other_designations='deoxyribonuclease-1-like 1|DNase I, lysosomal-like|DNase I-like 1|DNase I-like, muscle-specific|deoxyribonuclease I-like 1', map_location='Xq28', chromosome='X', genomic_nucleotide_accession_version='NC_000023.11', start_position_on_the_genomic_accession=154401236, end_position_on_the_genomic_accession=154412101, orientation='minus', exon_count=10, OMIM=[300081], no_hdr0=''),
    1775 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1775, CurrentID=0, Status='live', Symbol='DNASE1L2', Aliases=['DNAS1L2'], description='deoxyribonuclease 1 like 2', other_designations='deoxyribonuclease-1-like 2|DNase I homolog protein DHP1|DNase I-like 2|deoxyribonuclease I like 2', map_location='16p13.3', chromosome='16', genomic_nucleotide_accession_version='NC_000016.10', start_position_on_the_genomic_accession=2236444, end_position_on_the_genomic_accession=2238711, orientation='plus', exon_count=7, OMIM=[602622], no_hdr0=''),
    1776 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1776, CurrentID=0, Status='live', Symbol='DNASE1L3', Aliases=['DHP2', 'DNAS1L3', 'LSD', 'SLEB16'], description='deoxyribonuclease 1 like 3', other_designations='deoxyribonuclease gamma|DNase I homolog protein 2|DNase I homolog protein DHP2|DNase I-like 3|DNase gamma|LS-DNase|Liver and spleen DNase|deoxyribonuclease I-like 3|deoxyribonuclease I-like III', map_location='3p14.3', chromosome='3', genomic_nucleotide_accession_version='NC_000003.12', start_position_on_the_genomic_accession=58192257, end_position_on_the_genomic_accession=58210972, orientation='minus', exon_count=8, OMIM=[602244], no_hdr0=''),
    1777 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1777, CurrentID=0, Status='live', Symbol='DNASE2', Aliases=['DNASE2A', 'DNL', 'DNL2'], description='deoxyribonuclease 2, lysosomal', other_designations='deoxyribonuclease-2-alpha|DNase II alpha|DNase II, lysosomal|R31240_2|acid DNase|deoxyribonuclease II alpha|deoxyribonuclease II, lysosomal|lysosomal DNase II', map_location='19p13.13', chromosome='19', genomic_nucleotide_accession_version='NC_000019.10', start_position_on_the_genomic_accession=12875209, end_position_on_the_genomic_accession=12881449, orientation='minus', exon_count=6, OMIM=[126350], no_hdr0=''),
    1778 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1778, CurrentID=0, Status='live', Symbol='DYNC1H1', Aliases=['CMT2O', 'DHC1', 'DHC1a', 'DNCH1', 'DNCL', 'DNECL', 'DYHC', 'Dnchc1', 'HL-3', 'SMALED1', 'p22'], description='dynein cytoplasmic 1 heavy chain 1', other_designations='cytoplasmic dynein 1 heavy chain 1|dynein heavy chain, cytosolic|dynein, cytoplasmic, heavy polypeptide 1', map_location='14q32.31', chromosome='14', genomic_nucleotide_accession_version='NC_000014.9', start_position_on_the_genomic_accession=101964573, end_position_on_the_genomic_accession=102056443, orientation='plus', exon_count=78, OMIM=[600112], no_hdr0=''),
    1780 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1780, CurrentID=0, Status='live', Symbol='DYNC1I1', Aliases=['DNCI1', 'DNCIC1'], description='dynein cytoplasmic 1 intermediate chain 1', other_designations='cytoplasmic dynein 1 intermediate chain 1|DH IC-1|cytoplasmic dynein intermediate chain 1|dynein intermediate chain 1, cytosolic|dynein, cytoplasmic, intermediate polypeptide 1', map_location='7q21.3', chromosome='7', genomic_nucleotide_accession_version='NC_000007.14', start_position_on_the_genomic_accession=95772554, end_position_on_the_genomic_accession=96110322, orientation='plus', exon_count=18, OMIM=[603772], no_hdr0=''),
    1781 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1781, CurrentID=0, Status='live', Symbol='DYNC1I2', Aliases=['DIC74', 'DNCI2', 'IC2', 'NEDMIBA'], description='dynein cytoplasmic 1 intermediate chain 2', other_designations='cytoplasmic dynein 1 intermediate chain 2|DH IC-2|dynein intermediate chain 2, cytosolic|dynein, cytoplasmic, intermediate polypeptide 2|testis tissue sperm-binding protein Li 66n', map_location='2q31.1', chromosome='2', genomic_nucleotide_accession_version='NC_000002.12', start_position_on_the_genomic_accession=171687469, end_position_on_the_genomic_accession=171750158, orientation='plus', exon_count=19, OMIM=[603331], no_hdr0=''),
    1783 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1783, CurrentID=0, Status='live', Symbol='DYNC1LI2', Aliases=['DNCLI2', 'LIC2'], description='dynein cytoplasmic 1 light intermediate chain 2', other_designations='cytoplasmic dynein 1 light intermediate chain 2|LIC-2|LIC53/55|dynein light intermediate chain 2, cytosolic|dynein, cytoplasmic, light intermediate polypeptide 2', map_location='16q22.1', chromosome='16', genomic_nucleotide_accession_version='NC_000016.10', start_position_on_the_genomic_accession=66720893, end_position_on_the_genomic_accession=66751609, orientation='minus', exon_count=14, OMIM=[611406], no_hdr0=''),
    1785 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1785, CurrentID=0, Status='live', Symbol='DNM2', Aliases=['CMT2M', 'CMTDI1', 'CMTDIB', 'DI-CMTB', 'DYN2', 'DYNII', 'LCCS5'], description='dynamin 2', other_designations='dynamin-2|dynamin II', map_location='19p13.2', chromosome='19', genomic_nucleotide_accession_version='NC_000019.10', start_position_on_the_genomic_accession=10718079, end_position_on_the_genomic_accession=10831903, orientation='plus', exon_count=22, OMIM=[602378], no_hdr0=''),
    1786 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1786, CurrentID=0, Status='live', Symbol='DNMT1', Aliases=['ADCADN', 'AIM', 'CXXC9', 'DNMT', 'HSN1E', 'MCMT', 'm.HsaI'], description='DNA methyltransferase 1', other_designations='DNA (cytosine-5)-methyltransferase 1|CXXC-type zinc finger protein 9|DNA (cytosine-5-)-methyltransferase 1|DNA MTase HsaI|DNA methyltransferase HsaI', map_location='19p13.2', chromosome='19', genomic_nucleotide_accession_version='NC_000019.10', start_position_on_the_genomic_accession=10133346, end_position_on_the_genomic_accession=10194953, orientation='minus', exon_count=41, OMIM=[126375], no_hdr0=''),
    1787 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1787, CurrentID=0, Status='live', Symbol='TRDMT1', Aliases=['DMNT2', 'DNMT2', 'MHSAIIP', 'PUMET', 'RNMT1'], description='tRNA aspartic acid methyltransferase 1', other_designations='tRNA (cytosine(38)-C(5))-methyltransferase|DNA (cytosine-5)-methyltransferase-like protein 2|DNA MTase homolog HsaIIP|DNA cytosine-5 methyltransferase 2|DNA methyltransferase-2|tRNA (cytosine-5-)-methyltransferase', map_location='10p13', chromosome='10', genomic_nucleotide_accession_version='NC_000010.11', start_position_on_the_genomic_accession=17137336, end_position_on_the_genomic_accession=17202066, orientation='minus', exon_count=15, OMIM=[602478], no_hdr0=''),
    1788 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1788, CurrentID=0, Status='live', Symbol='DNMT3A', Aliases=['DNMT3A2', 'HESJAS', 'M.HsaIIIA', 'TBRS'], description='DNA methyltransferase 3 alpha', other_designations='DNA (cytosine-5)-methyltransferase 3A|DNA (cytosine-5-)-methyltransferase 3 alpha|DNA MTase HsaIIIA|DNA cytosine methyltransferase 3A2', map_location='2p23.3', chromosome='2', genomic_nucleotide_accession_version='NC_000002.12', start_position_on_the_genomic_accession=25227874, end_position_on_the_genomic_accession=25342590, orientation='minus', exon_count=34, OMIM=[602769], no_hdr0=''),
    1789 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1789, CurrentID=0, Status='live', Symbol='DNMT3B', Aliases=['ICF', 'ICF1', 'M.HsaIIIB'], description='DNA methyltransferase 3 beta', other_designations='DNA (cytosine-5)-methyltransferase 3B|DNA (cytosine-5-)-methyltransferase 3 beta|DNA MTase HsaIIIB|DNA cytosine-5--methyltransferase 3 beta|DNA methyltransferase HsaIIIB', map_location='20q11.21', chromosome='20', genomic_nucleotide_accession_version='NC_000020.11', start_position_on_the_genomic_accession=32762385, end_position_on_the_genomic_accession=32809356, orientation='plus', exon_count=24, OMIM=[602900], no_hdr0=''),
    1791 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1791, CurrentID=0, Status='live', Symbol='DNTT', Aliases=['TDT'], description='DNA nucleotidylexotransferase', other_designations='DNA nucleotidylexotransferase|nucleosidetriphosphate:DNA deoxynucleotidylexotransferase|terminal addition enzyme|terminal deoxynucleotidyltransferase|terminal deoxyribonucleotidyltransferase|terminal transferase', map_location='10q24.1', chromosome='10', genomic_nucleotide_accession_version='NC_000010.11', start_position_on_the_genomic_accession=96304434, end_position_on_the_genomic_accession=96338564, orientation='plus', exon_count=11, OMIM=[187410], no_hdr0=''),
    1793 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1793, CurrentID=0, Status='live', Symbol='DOCK1', Aliases=['DOCK180', 'ced5'], description='dedicator of cytokinesis 1', other_designations='dedicator of cytokinesis protein 1|180 kDa protein downstream of CRK|DOwnstream of CrK', map_location='10q26.2', chromosome='10', genomic_nucleotide_accession_version='NC_000010.11', start_position_on_the_genomic_accession=126905428, end_position_on_the_genomic_accession=127452517, orientation='plus', exon_count=59, OMIM=[601403], no_hdr0=''),
    1794 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1794, CurrentID=0, Status='live', Symbol='DOCK2', Aliases=['IMD40'], description='dedicator of cytokinesis 2', other_designations='dedicator of cytokinesis protein 2|dedicator of cyto-kinesis 2', map_location='5q35.1', chromosome='5', genomic_nucleotide_accession_version='NC_000005.10', start_position_on_the_genomic_accession=169637247, end_position_on_the_genomic_accession=170083382, orientation='plus', exon_count=60, OMIM=[603122], no_hdr0=''),
    1795 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1795, CurrentID=0, Status='live', Symbol='DOCK3', Aliases=['MOCA', 'NEDIDHA', 'PBP'], description='dedicator of cytokinesis 3', other_designations='dedicator of cytokinesis protein 3|modifier of cell adhesion|presenilin-binding protein', map_location='3p21.2', chromosome='3', genomic_nucleotide_accession_version='NC_000003.12', start_position_on_the_genomic_accession=50674927, end_position_on_the_genomic_accession=51384198, orientation='plus', exon_count=59, OMIM=[603123], no_hdr0=''),
    1796 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1796, CurrentID=0, Status='live', Symbol='DOK1', Aliases=['P62DOK', 'pp62'], description='docking protein 1', other_designations='docking protein 1|Downstream of tyrosine kinase 1', map_location='2p13.1', chromosome='2', genomic_nucleotide_accession_version='NC_000002.12', start_position_on_the_genomic_accession=74549105, end_position_on_the_genomic_accession=74557551, orientation='plus', exon_count=6, OMIM=[602919], no_hdr0=''),
    1797 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1797, CurrentID=0, Status='live', Symbol='DXO', Aliases=['DOM3L', 'DOM3Z', 'NG6', 'RAI1'], description='decapping exoribonuclease', other_designations='decapping and exoribonuclease protein|protein Dom3Z', map_location='6p21.33', chromosome='6', genomic_nucleotide_accession_version='NC_000006.12', start_position_on_the_genomic_accession=31969811, end_position_on_the_genomic_accession=31972290, orientation='minus', exon_count=6, OMIM=[605996], no_hdr0=''),
    1798 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1798, CurrentID=0, Status='live', Symbol='DPAGT1', Aliases=['ALG7', 'CDG-Ij', 'CDG1J', 'CMS13', 'CMSTA2', 'D11S366', 'DGPT', 'DPAGT', 'DPAGT2', 'G1PT', 'GPT', 'UAGT', 'UGAT'], description='dolichyl-phosphate N-acetylglucosaminephosphotransferase 1', other_designations='UDP-N-acetylglucosamine--dolichyl-phosphate N-acetylglucosaminephosphotransferase|GlcNAc-1-P transferase 1|N-acetylglucosamine-1-phosphate transferase|UDP-GlcNAc:dolichyl-phosphate N-acetylglucosaminephosphotransferase|UDP-N-acetylglucosamine--dolichyl-phosphate N-acetylglucosaminephosphotransferase 1|dolichyl-phosphate (UDP-N-acetylglucosamine) N-acetylglucosaminephosphotransferase 1 (GlcNAc-1-P tra|dolichyl-phosphate (UDP-N-acetylglucosamine) N-acetylglucosaminephosphotransferase 1 (GlcNAc-1-P transferase)|dolichyl-phosphate alpha-N-acetylglucosaminyltransferase', map_location='11q23.3', chromosome='11', genomic_nucleotide_accession_version='NC_000011.10', start_position_on_the_genomic_accession=119096505, end_position_on_the_genomic_accession=119101884, orientation='minus', exon_count=9, OMIM=[191350], no_hdr0=''),
    1800 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1800, CurrentID=0, Status='live', Symbol='DPEP1', Aliases=['MBD1', 'MDP', 'RDP'], description='dipeptidase 1', other_designations='dipeptidase 1|beta-lactamase|dehydropeptidase-I|dipeptidase 1 (renal)|hRDP|microsomal dipeptidase|renal dipeptidase|testicular tissue protein Li 57', map_location='16q24.3', chromosome='16', genomic_nucleotide_accession_version='NC_000016.10', start_position_on_the_genomic_accession=89613308, end_position_on_the_genomic_accession=89641540, orientation='plus', exon_count=17, OMIM=[179780], no_hdr0=''),
    1801 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1801, CurrentID=0, Status='live', Symbol='DPH1', Aliases=['DEDSSH', 'DPH2L', 'DPH2L1', 'OVCA1'], description='diphthamide biosynthesis 1', other_designations='2-(3-amino-3-carboxypropyl)histidine synthase subunit 1|DPH-like 1|DPH1 homolog|DPH2-like 1|S-adenosyl-L-methionine:L-histidine 3-amino-3-carboxypropyltransferase 1|candidate tumor suppressor in ovarian cancer 1|diphthamide biosynthesis protein 1|diphthamide biosynthesis protein 2 homolog-like 1|diphtheria toxin resistance protein 1|diptheria toxin resistance protein required for diphthamide biosynthesis (Saccharomyces)-like 1|ovarian cancer-associated gene 1 protein|ovarian tumor suppressor candidate 1', map_location='17p13.3', chromosome='17', genomic_nucleotide_accession_version='NC_000017.11', start_position_on_the_genomic_accession=2030112, end_position_on_the_genomic_accession=2043898, orientation='plus', exon_count=13, OMIM=[603527], no_hdr0=''),
    1802 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1802, CurrentID=0, Status='live', Symbol='DPH2', Aliases=['DPH2L2'], description='diphthamide biosynthesis 2', other_designations='2-(3-amino-3-carboxypropyl)histidine synthase subunit 2|DPH2 homolog|DPH2-like 2|S-adenosyl-L-methionine:L-histidine 3-amino-3-carboxypropyltransferase 2|diphthamide biosynthesis protein 2 homolog-like 2|diphthamide biosynthesis-like protein 2|diphtheria toxin resistance protein 2|diptheria toxin resistance protein required for diphthamide biosynthesis-like 2', map_location='1p34.1', chromosome='1', genomic_nucleotide_accession_version='NC_000001.11', start_position_on_the_genomic_accession=43969997, end_position_on_the_genomic_accession=43973369, orientation='plus', exon_count=5, OMIM=[603456], no_hdr0=''),
    1803 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1803, CurrentID=0, Status='live', Symbol='DPP4', Aliases=['ADABP', 'ADCP2', 'CD26', 'DPPIV', 'TP103'], description='dipeptidyl peptidase 4', other_designations='dipeptidyl peptidase 4|ADCP-2|DPP IV|Gly-Pro naphthylamidase|Post-proline dipeptidyl aminopeptidase IV|T-cell activation antigen CD26|Xaa-Pro-dipeptidylaminopeptidase|adenosine deaminase complexing protein 2|dipeptidyl peptidase IV|dipeptidylpeptidase 4|dipeptidylpeptidase IV (CD26, adenosine deaminase complexing protein 2)', map_location='2q24.2', chromosome='2', genomic_nucleotide_accession_version='NC_000002.12', start_position_on_the_genomic_accession=161992245, end_position_on_the_genomic_accession=162074215, orientation='minus', exon_count=28, OMIM=[102720], no_hdr0=''),
    1804 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1804, CurrentID=0, Status='live', Symbol='DPP6', Aliases=['DPL1', 'DPPX', 'MRD33', 'VF2'], description='dipeptidyl peptidase like 6', other_designations='dipeptidyl aminopeptidase-like protein 6|DPP VI|dipeptidyl aminopeptidase IV-related protein|dipeptidyl peptidase IV-related protein|dipeptidyl peptidase VI|dipeptidyl-peptidase 6', map_location='7q36.2', chromosome='7', genomic_nucleotide_accession_version='NC_000007.14', start_position_on_the_genomic_accession=153748133, end_position_on_the_genomic_accession=154894285, orientation='plus', exon_count=32, OMIM=[126141], no_hdr0=''),
    1805 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1805, CurrentID=0, Status='live', Symbol='DPT', Aliases=['TRAMP'], description='dermatopontin', other_designations='dermatopontin|tyrosine-rich acidic matrix protein', map_location='1q24.2', chromosome='1', genomic_nucleotide_accession_version='NC_000001.11', start_position_on_the_genomic_accession=168695468, end_position_on_the_genomic_accession=168729206, orientation='minus', exon_count=4, OMIM=[125597], no_hdr0=''),
    1806 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1806, CurrentID=0, Status='live', Symbol='DPYD', Aliases=['DHP', 'DHPDHASE', 'DPD'], description='dihydropyrimidine dehydrogenase', other_designations='dihydropyrimidine dehydrogenase [NADP(+)]|dihydrothymine dehydrogenase|dihydrouracil dehydrogenase', map_location='1p21.3', chromosome='1', genomic_nucleotide_accession_version='NC_000001.11', start_position_on_the_genomic_accession=97077743, end_position_on_the_genomic_accession=97921059, orientation='minus', exon_count=26, OMIM=[612779], no_hdr0=''),
    1807 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1807, CurrentID=0, Status='live', Symbol='DPYS', Aliases=['DHP', 'DHPase'], description='dihydropyrimidinase', other_designations='dihydropyrimidinase|dihydropyrimidine amidohydrolase|hydantoinase', map_location='8q22.3', chromosome='8', genomic_nucleotide_accession_version='NC_000008.11', start_position_on_the_genomic_accession=104379429, end_position_on_the_genomic_accession=104467074, orientation='minus', exon_count=13, OMIM=[613326], no_hdr0=''),
    1808 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1808, CurrentID=0, Status='live', Symbol='DPYSL2', Aliases=['CRMP-2', 'CRMP2', 'DHPRP2', 'DRP-2', 'DRP2', 'N2A3', 'ULIP-2', 'ULIP2'], description='dihydropyrimidinase like 2', other_designations='dihydropyrimidinase-related protein 2|collapsin response mediator protein hCRMP-2|unc-33-like phosphoprotein 2', map_location='8p21.2', chromosome='8', genomic_nucleotide_accession_version='NC_000008.11', start_position_on_the_genomic_accession=26514031, end_position_on_the_genomic_accession=26658175, orientation='plus', exon_count=16, OMIM=[602463], no_hdr0=''),
    1809 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1809, CurrentID=0, Status='live', Symbol='DPYSL3', Aliases=['CRMP-4', 'CRMP4', 'DRP-3', 'DRP3', 'LCRMP', 'ULIP', 'ULIP-1'], description='dihydropyrimidinase like 3', other_designations='dihydropyrimidinase-related protein 3|collapsin response mediator protein 4 long|testicular secretory protein Li 7|unc-33-like phosphoprotein 1', map_location='5q32', chromosome='5', genomic_nucleotide_accession_version='NC_000005.10', start_position_on_the_genomic_accession=147390808, end_position_on_the_genomic_accession=147510068, orientation='minus', exon_count=16, OMIM=[601168], no_hdr0=''),
    1810 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1810, CurrentID=0, Status='live', Symbol='DR1', Aliases=['NC2', 'NC2-BETA', 'NC2B', 'NCB2'], description='down-regulator of transcription 1', other_designations='protein Dr1|TATA-binding protein-associated phosphoprotein|negative cofactor 2|negative cofactor 2-beta', map_location='1p22.1', chromosome='1', genomic_nucleotide_accession_version='NC_000001.11', start_position_on_the_genomic_accession=93345907, end_position_on_the_genomic_accession=93369493, orientation='plus', exon_count=3, OMIM=[601482], no_hdr0=''),
    1811 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1811, CurrentID=0, Status='live', Symbol='SLC26A3', Aliases=['CLD', 'DRA'], description='solute carrier family 26 member 3', other_designations='chloride anion exchanger|down-regulated in adenoma protein|solute carrier family 26 (anion exchanger), member 3', map_location='7q22.3-q31.1', chromosome='7', genomic_nucleotide_accession_version='NC_000007.14', start_position_on_the_genomic_accession=107765469, end_position_on_the_genomic_accession=107803223, orientation='minus', exon_count=21, OMIM=[126650], no_hdr0=''),
    1812 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1812, CurrentID=0, Status='live', Symbol='DRD1', Aliases=['DADRA', 'DRD1'], description='dopamine receptor D1', other_designations='D(1A) dopamine receptor|dopamine D1 receptor', map_location='5q35.2', chromosome='5', genomic_nucleotide_accession_version='NC_000005.10', start_position_on_the_genomic_accession=175440036, end_position_on_the_genomic_accession=175444182, orientation='minus', exon_count=2, OMIM=[126449], no_hdr0=''),
    1813 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1813, CurrentID=0, Status='live', Symbol='DRD2', Aliases=['D2DR', 'D2R'], description='dopamine receptor D2', other_designations='D(2) dopamine receptor|dopamine D2 receptor|seven transmembrane helix receptor', map_location='11q23.2', chromosome='11', genomic_nucleotide_accession_version='NC_000011.10', start_position_on_the_genomic_accession=113409605, end_position_on_the_genomic_accession=113475398, orientation='minus', exon_count=9, OMIM=[126450], no_hdr0=''),
    1814 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1814, CurrentID=0, Status='live', Symbol='DRD3', Aliases=['D3DR', 'ETM1', 'FET1'], description='dopamine receptor D3', other_designations='D(3) dopamine receptor|essential tremor 1', map_location='3q13.31', chromosome='3', genomic_nucleotide_accession_version='NC_000003.12', start_position_on_the_genomic_accession=114127580, end_position_on_the_genomic_accession=114199407, orientation='minus', exon_count=11, OMIM=[126451], no_hdr0=''),
    1815 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1815, CurrentID=0, Status='live', Symbol='DRD4', Aliases=['D4DR'], description='dopamine receptor D4', other_designations='D(4) dopamine receptor|D(2C) dopamine receptor|dopamine D4 receptor|seven transmembrane helix receptor', map_location='11p15.5', chromosome='11', genomic_nucleotide_accession_version='NC_000011.10', start_position_on_the_genomic_accession=637269, end_position_on_the_genomic_accession=640706, orientation='plus', exon_count=4, OMIM=[126452], no_hdr0=''),
    1816 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1816, CurrentID=0, Status='live', Symbol='DRD5', Aliases=['DBDR', 'DRD1B', 'DRD1L2'], description='dopamine receptor D5', other_designations='D(1B) dopamine receptor|D1beta dopamine receptor|d(5) dopamine receptor|dopamine D5 receptor|dopamine receptor D1B', map_location='4p16.1', chromosome='4', genomic_nucleotide_accession_version='NC_000004.12', start_position_on_the_genomic_accession=9781634, end_position_on_the_genomic_accession=9784009, orientation='plus', exon_count=1, OMIM=[126453], no_hdr0=''),
    1819 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1819, CurrentID=0, Status='live', Symbol='DRG2', Aliases=[], description='developmentally regulated GTP binding protein 2', other_designations='developmentally-regulated GTP-binding protein 2|TRAFAC GTPase DRG2|translation factor GTPase DRG2', map_location='17p11.2', chromosome='17', genomic_nucleotide_accession_version='NC_000017.11', start_position_on_the_genomic_accession=18087885, end_position_on_the_genomic_accession=18107970, orientation='plus', exon_count=13, OMIM=[602986], no_hdr0=''),
    1820 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1820, CurrentID=0, Status='live', Symbol='ARID3A', Aliases=['BRIGHT', 'DRIL1', 'DRIL3', 'E2FBP1'], description='AT-rich interaction domain 3A', other_designations='AT-rich interactive domain-containing protein 3A|ARID domain-containing 3A|ARID domain-containing protein 3A|AT rich interactive domain 3A (BRIGHT- like) protein|AT rich interactive domain 3A (BRIGHT-like)|B-cell regulator of IgH transcription|E2F-binding protein 1|dead ringer-like 1|dead ringer-like protein 1', map_location='19p13.3', chromosome='19', genomic_nucleotide_accession_version='NC_000019.10', start_position_on_the_genomic_accession=925733, end_position_on_the_genomic_accession=975939, orientation='plus', exon_count=12, OMIM=[603265], no_hdr0=''),
    1821 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1821, CurrentID=0, Status='live', Symbol='DRP2', Aliases=['DRP-2'], description='dystrophin related protein 2', other_designations='dystrophin-related protein 2', map_location='Xq22.1', chromosome='X', genomic_nucleotide_accession_version='NC_000023.11', start_position_on_the_genomic_accession=101219786, end_position_on_the_genomic_accession=101264502, orientation='plus', exon_count=24, OMIM=[300052], no_hdr0=''),
    1822 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1822, CurrentID=0, Status='live', Symbol='ATN1', Aliases=['B37', 'CHEDDA', 'D12S755E', 'DRPLA', 'HRS', 'NOD'], description='atrophin 1', other_designations='atrophin-1|dentatorubral-pallidoluysian atrophy protein', map_location='12p13.31', chromosome='12', genomic_nucleotide_accession_version='NC_000012.12', start_position_on_the_genomic_accession=6924459, end_position_on_the_genomic_accession=6942321, orientation='plus', exon_count=11, OMIM=[607462], no_hdr0=''),
    1823 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1823, CurrentID=0, Status='live', Symbol='DSC1', Aliases=['CDHF1', 'DG2/DG3'], description='desmocollin 1', other_designations='desmocollin-1|cadherin family member 1|desmosomal glycoprotein 2/3', map_location='18q12.1', chromosome='18', genomic_nucleotide_accession_version='NC_000018.10', start_position_on_the_genomic_accession=31129236, end_position_on_the_genomic_accession=31162856, orientation='minus', exon_count=17, OMIM=[125643], no_hdr0=''),
    1824 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1824, CurrentID=0, Status='live', Symbol='DSC2', Aliases=['ARVD11', 'CDHF2', 'DG2', 'DGII/III', 'DSC3'], description='desmocollin 2', other_designations='desmocollin-2|cadherin family member 2|desmosomal glycoprotein II/III', map_location='18q12.1', chromosome='18', genomic_nucleotide_accession_version='NC_000018.10', start_position_on_the_genomic_accession=31058840, end_position_on_the_genomic_accession=31102421, orientation='minus', exon_count=18, OMIM=[125645], no_hdr0=''),
    1825 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1825, CurrentID=0, Status='live', Symbol='DSC3', Aliases=['CDHF3', 'DSC', 'DSC1', 'DSC2', 'DSC4', 'HT-CP'], description='desmocollin 3', other_designations='desmocollin-3|cadherin family member 3|desmocollin-4', map_location='18q12.1', chromosome='18', genomic_nucleotide_accession_version='NC_000018.10', start_position_on_the_genomic_accession=30989365, end_position_on_the_genomic_accession=31042742, orientation='minus', exon_count=17, OMIM=[600271], no_hdr0=''),
    1826 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1826, CurrentID=0, Status='live', Symbol='DSCAM', Aliases=['CHD2', 'CHD2-42', 'CHD2-52'], description='DS cell adhesion molecule', other_designations='Down syndrome cell adhesion molecule', map_location='21q22.2', chromosome='21', genomic_nucleotide_accession_version='NC_000021.9', start_position_on_the_genomic_accession=40010999, end_position_on_the_genomic_accession=40847158, orientation='minus', exon_count=33, OMIM=[602523], no_hdr0=''),
    1827 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1827, CurrentID=0, Status='live', Symbol='RCAN1', Aliases=['ADAPT78', 'CSP1', 'DSC1', 'DSCR1', 'MCIP1', 'RCN1'], description='regulator of calcineurin 1', other_designations='calcipressin-1|Down syndrome candidate region 1|Down syndrome critical region gene 1|calcium and oxidant-inducible mRNA|modulatory calcineurin-interacting protein 1|myocyte-enriched calcineurin-interacting protein 1|near DSCR proline-rich protein', map_location='21q22.12', chromosome='21', genomic_nucleotide_accession_version='NC_000021.9', start_position_on_the_genomic_accession=34516442, end_position_on_the_genomic_accession=34615123, orientation='minus', exon_count=9, OMIM=[602917], no_hdr0=''),
    1828 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1828, CurrentID=0, Status='live', Symbol='DSG1', Aliases=['CDHF4', 'DG1', 'DSG', 'EPKHE', 'EPKHIA', 'PPKS1', 'SPPK1'], description='desmoglein 1', other_designations='desmoglein-1|cadherin family member 4|desmosomal glycoprotein 1|pemphigus foliaceus antigen', map_location='18q12.1', chromosome='18', genomic_nucleotide_accession_version='NC_000018.10', start_position_on_the_genomic_accession=31318160, end_position_on_the_genomic_accession=31359246, orientation='plus', exon_count=15, OMIM=[125670], no_hdr0=''),
    1829 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1829, CurrentID=0, Status='live', Symbol='DSG2', Aliases=['CDHF5', 'HDGC'], description='desmoglein 2', other_designations='desmoglein-2|cadherin family member 5', map_location='18q12.1', chromosome='18', genomic_nucleotide_accession_version='NC_000018.10', start_position_on_the_genomic_accession=31498177, end_position_on_the_genomic_accession=31549008, orientation='plus', exon_count=16, OMIM=[125671], no_hdr0=''),
    1830 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1830, CurrentID=0, Status='live', Symbol='DSG3', Aliases=['CDHF6', 'PVA'], description='desmoglein 3', other_designations='desmoglein-3|130 kDa pemphigus vulgaris antigen|cadherin family member 6', map_location='18q12.1', chromosome='18', genomic_nucleotide_accession_version='NC_000018.10', start_position_on_the_genomic_accession=31447741, end_position_on_the_genomic_accession=31478712, orientation='plus', exon_count=16, OMIM=[169615], no_hdr0=''),
    1831 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1831, CurrentID=0, Status='live', Symbol='TSC22D3', Aliases=['DIP', 'DSIPI', 'GILZ', 'TSC-22R'], description='TSC22 domain family member 3', other_designations='TSC22 domain family protein 3|DSIP-immunoreactive leucine zipper protein|DSIP-immunoreactive peptide|TSC-22 related protein|TSC-22-like protein|delta sleep-inducing peptide immunoreactor|glucocorticoid-induced leucine zipper protein', map_location='Xq22.3', chromosome='X', genomic_nucleotide_accession_version='NC_000023.11', start_position_on_the_genomic_accession=107713221, end_position_on_the_genomic_accession=107777329, orientation='minus', exon_count=8, OMIM=[300506], no_hdr0=''),
    1832 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1832, CurrentID=0, Status='live', Symbol='DSP', Aliases=['DCWHKTA', 'DP'], description='desmoplakin', other_designations='desmoplakin|250/210 kDa paraneoplastic pemphigus antigen', map_location='6p24.3', chromosome='6', genomic_nucleotide_accession_version='NC_000006.12', start_position_on_the_genomic_accession=7541671, end_position_on_the_genomic_accession=7586714, orientation='plus', exon_count=24, OMIM=[125647], no_hdr0=''),
    1833 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1833, CurrentID=0, Status='live', Symbol='EPYC', Aliases=['DSPG3', 'PGLB', 'Pg-Lb', 'SLRR3B'], description='epiphycan', other_designations='epiphycan|dermatan sulfate proteoglycan 3|epiphycan proteoglycan|proteoglycan-lb|small chondroitin/dermatan sulfate proteoglycan', map_location='12q21.33', chromosome='12', genomic_nucleotide_accession_version='NC_000012.12', start_position_on_the_genomic_accession=90963679, end_position_on_the_genomic_accession=91004972, orientation='minus', exon_count=8, OMIM=[601657], no_hdr0=''),
    1834 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1834, CurrentID=0, Status='live', Symbol='DSPP', Aliases=['DFNA39', 'DGI1', 'DMP3', 'DPP', 'DSP'], description='dentin sialophosphoprotein', other_designations='dentin sialophosphoprotein|deafness, autosomal dominant 39|dentin phosphophoryn|dentin phosphoprotein|dentin phosphoryn|dentin sialoprotein', map_location='4q22.1', chromosome='4', genomic_nucleotide_accession_version='NC_000004.12', start_position_on_the_genomic_accession=87608529, end_position_on_the_genomic_accession=87616873, orientation='plus', exon_count=5, OMIM=[125485], no_hdr0=''),
    1836 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1836, CurrentID=0, Status='live', Symbol='SLC26A2', Aliases=['D5S1708', 'DTD', 'DTDST', 'EDM4', 'MST153', 'MSTP157'], description='solute carrier family 26 member 2', other_designations='sulfate transporter|diastrophic dysplasia protein|solute carrier family 26 (anion exchanger), member 2|solute carrier family 26 (sulfate transporter), member 2|sulfate anion transporter 1', map_location='5q32', chromosome='5', genomic_nucleotide_accession_version='NC_000005.10', start_position_on_the_genomic_accession=149960758, end_position_on_the_genomic_accession=149987400, orientation='plus', exon_count=3, OMIM=[606718], no_hdr0=''),
    1837 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1837, CurrentID=0, Status='live', Symbol='DTNA', Aliases=['D18S892E', 'DRP3', 'DTN', 'DTN-A', 'LVNC1'], description='dystrobrevin alpha', other_designations='dystrobrevin alpha|dystrophin-related protein 3', map_location='18q12.1', chromosome='18', genomic_nucleotide_accession_version='NC_000018.10', start_position_on_the_genomic_accession=34493298, end_position_on_the_genomic_accession=34891844, orientation='plus', exon_count=30, OMIM=[601239], no_hdr0=''),
    1838 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1838, CurrentID=0, Status='live', Symbol='DTNB', Aliases=[], description='dystrobrevin beta', other_designations='dystrobrevin beta|DTN-B|beta-dystrobrevin', map_location='2p23.3', chromosome='2', genomic_nucleotide_accession_version='NC_000002.12', start_position_on_the_genomic_accession=25377243, end_position_on_the_genomic_accession=25673577, orientation='minus', exon_count=28, OMIM=[602415], no_hdr0=''),
    1839 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1839, CurrentID=0, Status='live', Symbol='HBEGF', Aliases=['DTR', 'DTS', 'DTSF', 'HEGFL'], description='heparin binding EGF like growth factor', other_designations='proheparin-binding EGF-like growth factor|diphtheria toxin receptor (heparin-binding EGF-like growth factor)|diphtheria toxin receptor (heparin-binding epidermal growth factor-like growth factor)|heparin-binding epidermal growth factor', map_location='5q31.3', chromosome='5', genomic_nucleotide_accession_version='NC_000005.10', start_position_on_the_genomic_accession=140332843, end_position_on_the_genomic_accession=140346603, orientation='minus', exon_count=6, OMIM=[126150], no_hdr0=''),
    1840 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1840, CurrentID=0, Status='live', Symbol='DTX1', Aliases=['RNF140', 'hDx-1'], description='deltex E3 ubiquitin ligase 1', other_designations='E3 ubiquitin-protein ligase DTX1|RING-type E3 ubiquitin transferase DTX1|deltex 1, E3 ubiquitin ligase|deltex homolog 1|protein deltex-1', map_location='12q24.13', chromosome='12', genomic_nucleotide_accession_version='NC_000012.12', start_position_on_the_genomic_accession=113056730, end_position_on_the_genomic_accession=113098025, orientation='plus', exon_count=10, OMIM=[602582], no_hdr0=''),
    1841 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1841, CurrentID=0, Status='live', Symbol='DTYMK', Aliases=['CDC8', 'PP3731', 'TMPK', 'TYMK'], description='deoxythymidylate kinase', other_designations='thymidylate kinase|dTMP kinase|deoxythymidylate kinase (thymidylate kinase)', map_location='2q37.3', chromosome='2', genomic_nucleotide_accession_version='NC_000002.12', start_position_on_the_genomic_accession=241675747, end_position_on_the_genomic_accession=241686815, orientation='minus', exon_count=7, OMIM=[188345], no_hdr0=''),
    1842 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1842, CurrentID=0, Status='live', Symbol='ECM2', Aliases=[], description='extracellular matrix protein 2', other_designations='extracellular matrix protein 2|extracellular matrix protein 2, female organ and adipocyte specific|matrix glycoprotein SC1/ECM2', map_location='9q22.31', chromosome='9', genomic_nucleotide_accession_version='NC_000009.12', start_position_on_the_genomic_accession=92493547, end_position_on_the_genomic_accession=92536841, orientation='minus', exon_count=13, OMIM=[603479], no_hdr0=''),
    1843 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1843, CurrentID=0, Status='live', Symbol='DUSP1', Aliases=['CL100', 'HVH1', 'MKP-1', 'MKP1', 'PTPN10'], description='dual specificity phosphatase 1', other_designations='dual specificity protein phosphatase 1|CL 100|MAP kinase phosphatase 1|dual specificity protein phosphatase hVH1|mitogen-activated protein kinase phosphatase 1|protein-tyrosine phosphatase CL100|serine/threonine specific protein phosphatase', map_location='5q35.1', chromosome='5', genomic_nucleotide_accession_version='NC_000005.10', start_position_on_the_genomic_accession=172768096, end_position_on_the_genomic_accession=172771195, orientation='minus', exon_count=4, OMIM=[600714], no_hdr0=''),
    1844 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1844, CurrentID=0, Status='live', Symbol='DUSP2', Aliases=['PAC-1', 'PAC1'], description='dual specificity phosphatase 2', other_designations='dual specificity protein phosphatase 2|dual specificity protein phosphatase PAC-1|serine/threonine specific protein phosphatase', map_location='2q11.2', chromosome='2', genomic_nucleotide_accession_version='NC_000002.12', start_position_on_the_genomic_accession=96143166, end_position_on_the_genomic_accession=96145468, orientation='minus', exon_count=3, OMIM=[603068], no_hdr0=''),
    1845 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1845, CurrentID=0, Status='live', Symbol='DUSP3', Aliases=['VHR'], description='dual specificity phosphatase 3', other_designations='dual specificity protein phosphatase 3|dual specificity protein phosphatase VHR|serine/threonine specific protein phosphatase|vaccinia H1-related phosphatase|vaccinia virus phosphatase VH1-related', map_location='17q21.31', chromosome='17', genomic_nucleotide_accession_version='NC_000017.11', start_position_on_the_genomic_accession=43766125, end_position_on_the_genomic_accession=43778977, orientation='minus', exon_count=3, OMIM=[600183], no_hdr0=''),
    1846 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1846, CurrentID=0, Status='live', Symbol='DUSP4', Aliases=['HVH2', 'MKP-2', 'MKP2', 'TYP'], description='dual specificity phosphatase 4', other_designations='dual specificity protein phosphatase 4|MAP kinase phosphatase 2|VH1 homologous phosphatase 2|dual specificity protein phosphatase hVH2|mitogen-activated protein kinase phosphatase 2|serine/threonine specific protein phosphatase', map_location='8p12', chromosome='8', genomic_nucleotide_accession_version='NC_000008.11', start_position_on_the_genomic_accession=29333064, end_position_on_the_genomic_accession=29350684, orientation='minus', exon_count=5, OMIM=[602747], no_hdr0=''),
    1847 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1847, CurrentID=0, Status='live', Symbol='DUSP5', Aliases=['DUSP', 'HVH3'], description='dual specificity phosphatase 5', other_designations='dual specificity protein phosphatase 5|VH1-like phosphatase 3|dual specificity protein phosphatase hVH3|serine/threonine specific protein phosphatase', map_location='10q25.2', chromosome='10', genomic_nucleotide_accession_version='NC_000010.11', start_position_on_the_genomic_accession=110497907, end_position_on_the_genomic_accession=110511533, orientation='plus', exon_count=4, OMIM=[603069], no_hdr0=''),
    1848 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1848, CurrentID=0, Status='live', Symbol='DUSP6', Aliases=['HH19', 'MKP3', 'PYST1'], description='dual specificity phosphatase 6', other_designations='dual specificity protein phosphatase 6|MAP kinase phosphatase 3|dual specificity protein phosphatase PYST1|mitogen-activated protein kinase phosphatase 3|serine/threonine specific protein phosphatase', map_location='12q21.33', chromosome='12', genomic_nucleotide_accession_version='NC_000012.12', start_position_on_the_genomic_accession=89347235, end_position_on_the_genomic_accession=89352501, orientation='minus', exon_count=3, OMIM=[602748], no_hdr0=''),
    1849 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1849, CurrentID=0, Status='live', Symbol='DUSP7', Aliases=['MKPX', 'PYST2'], description='dual specificity phosphatase 7', other_designations='dual specificity protein phosphatase 7|dual specificity protein phosphatase PYST2', map_location='3p21.2', chromosome='3', genomic_nucleotide_accession_version='NC_000003.12', start_position_on_the_genomic_accession=52048919, end_position_on_the_genomic_accession=52056571, orientation='minus', exon_count=3, OMIM=[602749], no_hdr0=''),
    1850 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1850, CurrentID=0, Status='live', Symbol='DUSP8', Aliases=['C11orf81', 'HB5', 'HVH-5', 'HVH8'], description='dual specificity phosphatase 8', other_designations='dual specificity protein phosphatase 8|H1 phosphatase, vaccinia virus homolog|dual specificity protein phosphatase hVH-5|serine/threonine specific protein phosphatase', map_location='11p15.5', chromosome='11', genomic_nucleotide_accession_version='NC_000011.10', start_position_on_the_genomic_accession=1554051, end_position_on_the_genomic_accession=1572839, orientation='minus', exon_count=9, OMIM=[602038], no_hdr0=''),
    1852 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1852, CurrentID=0, Status='live', Symbol='DUSP9', Aliases=['MKP-4', 'MKP4'], description='dual specificity phosphatase 9', other_designations='dual specificity protein phosphatase 9|map kinase phosphatase 4|mitogen-activated protein kinase phosphatase 4|serine/threonine specific protein phosphatase', map_location='Xq28', chromosome='X', genomic_nucleotide_accession_version='NC_000023.11', start_position_on_the_genomic_accession=153642441, end_position_on_the_genomic_accession=153651326, orientation='plus', exon_count=7, OMIM=[300134], no_hdr0=''),
    1854 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1854, CurrentID=0, Status='live', Symbol='DUT', Aliases=['dUTPase'], description='deoxyuridine triphosphatase', other_designations="deoxyuridine 5'-triphosphate nucleotidohydrolase, mitochondrial|dUTP diphosphatase|dUTP nucleotidohydrolase|dUTP pyrophosphatase", map_location='15q21.1', chromosome='15', genomic_nucleotide_accession_version='NC_000015.10', start_position_on_the_genomic_accession=48329991, end_position_on_the_genomic_accession=48343373, orientation='plus', exon_count=9, OMIM=[601266], no_hdr0=''),
    1855 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1855, CurrentID=0, Status='live', Symbol='DVL1', Aliases=['DRS2', 'DVLL1', 'DVL1P1', 'DVL1'], description='dishevelled segment polarity protein 1', other_designations='segment polarity protein dishevelled homolog DVL-1|DSH homolog 1|dishevelled 1 (homologous to Drosophila dsh)|dishevelled, dsh homolog 1|dishevelled-1', map_location='1p36.33', chromosome='1', genomic_nucleotide_accession_version='NC_000001.11', start_position_on_the_genomic_accession=1335278, end_position_on_the_genomic_accession=1349418, orientation='minus', exon_count=16, OMIM=[601365], no_hdr0=''),
    1856 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1856, CurrentID=0, Status='live', Symbol='DVL2', Aliases=[], description='dishevelled segment polarity protein 2', other_designations='segment polarity protein dishevelled homolog DVL-2|dishevelled 2 (homologous to Drosophila dsh)|dishevelled, dsh homolog 2', map_location='17p13.1', chromosome='17', genomic_nucleotide_accession_version='NC_000017.11', start_position_on_the_genomic_accession=7225341, end_position_on_the_genomic_accession=7234544, orientation='minus', exon_count=16, OMIM=[602151], no_hdr0=''),
    1857 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1857, CurrentID=0, Status='live', Symbol='DVL3', Aliases=['DRS3'], description='dishevelled segment polarity protein 3', other_designations='segment polarity protein dishevelled homolog DVL-3|dishevelled 3 (homologous to Drosophila dsh)|dishevelled, dsh homolog 3', map_location='3q27.1', chromosome='3', genomic_nucleotide_accession_version='NC_000003.12', start_position_on_the_genomic_accession=184155311, end_position_on_the_genomic_accession=184173614, orientation='plus', exon_count=16, OMIM=[601368], no_hdr0=''),
    1859 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1859, CurrentID=0, Status='live', Symbol='DYRK1A', Aliases=['DYRK', 'DYRK1', 'HP86', 'MNB', 'MNBH', 'MRD7'], description='dual specificity tyrosine phosphorylation regulated kinase 1A', other_designations='dual specificity tyrosine-phosphorylation-regulated kinase 1A|MNB/DYRK protein kinase|dual specificity YAK1-related kinase|dual specificity tyrosine-(Y)-phosphorylation regulated kinase 1A|mnb protein kinase homolog hp86|protein kinase minibrain homolog|serine/threonine kinase MNB|serine/threonine-specific protein kinase', map_location='21q22.13', chromosome='21', genomic_nucleotide_accession_version='NC_000021.9', start_position_on_the_genomic_accession=37365573, end_position_on_the_genomic_accession=37526358, orientation='plus', exon_count=21, OMIM=[600855], no_hdr0=''),
    1861 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1861, CurrentID=0, Status='live', Symbol='TOR1A', Aliases=['AMC5', 'DQ2', 'DYT1'], description='torsin family 1 member A', other_designations='torsin-1A|dystonia 1 protein|dystonia 1, torsion (autosomal dominant; torsin A)|torsin A|torsin ATPase 1|torsin ATPase-1A', map_location='9q34.11', chromosome='9', genomic_nucleotide_accession_version='NC_000009.12', start_position_on_the_genomic_accession=129812942, end_position_on_the_genomic_accession=129824136, orientation='minus', exon_count=5, OMIM=[605204], no_hdr0=''),
    1869 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1869, CurrentID=0, Status='live', Symbol='E2F1', Aliases=['E2F-1', 'RBAP1', 'RBBP3', 'RBP3'], description='E2F transcription factor 1', other_designations='transcription factor E2F1|PBR3|PRB-binding protein E2F-1|RBAP-1|RBBP-3|retinoblastoma-associated protein 1|retinoblastoma-binding protein 3', map_location='20q11.22', chromosome='20', genomic_nucleotide_accession_version='NC_000020.11', start_position_on_the_genomic_accession=33675477, end_position_on_the_genomic_accession=33686385, orientation='minus', exon_count=7, OMIM=[189971], no_hdr0=''),
    1870 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1870, CurrentID=0, Status='live', Symbol='E2F2', Aliases=['E2F-2'], description='E2F transcription factor 2', other_designations='transcription factor E2F2', map_location='1p36.12', chromosome='1', genomic_nucleotide_accession_version='NC_000001.11', start_position_on_the_genomic_accession=23505696, end_position_on_the_genomic_accession=23531250, orientation='minus', exon_count=10, OMIM=[600426], no_hdr0=''),
    1871 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1871, CurrentID=0, Status='live', Symbol='E2F3', Aliases=['E2F-3'], description='E2F transcription factor 3', other_designations='transcription factor E2F3', map_location='6p22.3', chromosome='6', genomic_nucleotide_accession_version='NC_000006.12', start_position_on_the_genomic_accession=20401879, end_position_on_the_genomic_accession=20493714, orientation='plus', exon_count=11, OMIM=[600427], no_hdr0=''),
    1874 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1874, CurrentID=0, Status='live', Symbol='E2F4', Aliases=['E2F-4'], description='E2F transcription factor 4', other_designations='transcription factor E2F4|E2F transcription factor 4, p107/p130-binding|p107/p130-binding protein', map_location='16q22.1', chromosome='16', genomic_nucleotide_accession_version='NC_000016.10', start_position_on_the_genomic_accession=67192155, end_position_on_the_genomic_accession=67198918, orientation='plus', exon_count=10, OMIM=[600659], no_hdr0=''),
    1875 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1875, CurrentID=0, Status='live', Symbol='E2F5', Aliases=['E2F-5'], description='E2F transcription factor 5', other_designations='transcription factor E2F5|E2F transcription factor 5, p130-binding', map_location='8q21.2', chromosome='8', genomic_nucleotide_accession_version='NC_000008.11', start_position_on_the_genomic_accession=85177154, end_position_on_the_genomic_accession=85214518, orientation='plus', exon_count=9, OMIM=[600967], no_hdr0=''),
    1876 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1876, CurrentID=0, Status='live', Symbol='E2F6', Aliases=['E2F-6'], description='E2F transcription factor 6', other_designations='transcription factor E2F6', map_location='2p25.1', chromosome='2', genomic_nucleotide_accession_version='NC_000002.12', start_position_on_the_genomic_accession=11444375, end_position_on_the_genomic_accession=11466177, orientation='minus', exon_count=10, OMIM=[602944], no_hdr0=''),
    1877 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1877, CurrentID=0, Status='live', Symbol='E4F1', Aliases=['E4F'], description='E4F transcription factor 1', other_designations='transcription factor E4F1|RING-type E3 ubiquitin transferase E4F1|p120E4F|p50E4F|putative E3 ubiquitin-protein ligase E4F1|transcription factor E4F', map_location='16p13.3', chromosome='16', genomic_nucleotide_accession_version='NC_000016.10', start_position_on_the_genomic_accession=2223498, end_position_on_the_genomic_accession=2235742, orientation='plus', exon_count=14, OMIM=[603022], no_hdr0=''),
    1879 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1879, CurrentID=0, Status='live', Symbol='EBF1', Aliases=['COE1', 'EBF', 'O/E-1', 'OLF1'], description='EBF transcription factor 1', other_designations='transcription factor COE1|Collier, Olf and EBF transcription factor 1|early B cell factor 1|olfactory neuronal transcription factor 1', map_location='5q33.3', chromosome='5', genomic_nucleotide_accession_version='NC_000005.10', start_position_on_the_genomic_accession=158695918, end_position_on_the_genomic_accession=159099916, orientation='minus', exon_count=22, OMIM=[164343], no_hdr0=''),
    1880 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1880, CurrentID=0, Status='live', Symbol='GPR183', Aliases=['EBI2', 'hEBI2'], description='G protein-coupled receptor 183', other_designations='G-protein coupled receptor 183|EBV-induced G-protein coupled receptor 2|Epstein-Barr virus induced gene 2 (lymphocyte-specific G protein-coupled receptor)|epstein-Barr virus-induced G-protein coupled receptor 2', map_location='13q32.3', chromosome='13', genomic_nucleotide_accession_version='NC_000013.11', start_position_on_the_genomic_accession=99294273, end_position_on_the_genomic_accession=99307399, orientation='minus', exon_count=3, OMIM=[605741], no_hdr0=''),
    1889 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1889, CurrentID=0, Status='live', Symbol='ECE1', Aliases=['ECE'], description='endothelin converting enzyme 1', other_designations='endothelin-converting enzyme 1|ECE-1', map_location='1p36.12', chromosome='1', genomic_nucleotide_accession_version='NC_000001.11', start_position_on_the_genomic_accession=21217250, end_position_on_the_genomic_accession=21345504, orientation='minus', exon_count=23, OMIM=[600423], no_hdr0=''),
    1890 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1890, CurrentID=0, Status='live', Symbol='TYMP', Aliases=['ECGF', 'ECGF1', 'MEDPS1', 'MNGIE', 'MTDPS1', 'PDECGF', 'TP', 'hPD-ECGF'], description='thymidine phosphorylase', other_designations='thymidine phosphorylase|gliostatin|tdRPase', map_location='22q13.33', chromosome='22', genomic_nucleotide_accession_version='NC_000022.11', start_position_on_the_genomic_accession=50525752, end_position_on_the_genomic_accession=50530085, orientation='minus', exon_count=10, OMIM=[131222], no_hdr0=''),
    1891 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1891, CurrentID=0, Status='live', Symbol='ECH1', Aliases=['HPXEL'], description='enoyl-CoA hydratase 1', other_designations='delta(3,5)-Delta(2,4)-dienoyl-CoA isomerase, mitochondrial|delta3,5-delta2,4-dienoyl-CoA isomerase|delta3,5-delta2,4-dienoyl-coenzyme A isomerase|dienoyl-CoA isomerase|enoyl Coenzyme A hydratase 1, peroxisomal|enoyl-CoA hydratase 1, peroxisomal|epididymis secretory sperm binding protein|peroxisomal enoyl-CoA hydratase 1', map_location='19q13.2', chromosome='19', genomic_nucleotide_accession_version='NC_000019.10', start_position_on_the_genomic_accession=38815422, end_position_on_the_genomic_accession=38831794, orientation='minus', exon_count=9, OMIM=[600696], no_hdr0=''),
    1892 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1892, CurrentID=0, Status='live', Symbol='ECHS1', Aliases=['ECHS1D', 'SCEH'], description='enoyl-CoA hydratase, short chain 1', other_designations='enoyl-CoA hydratase, mitochondrial|enoyl Coenzyme A hydratase, short chain, 1, mitochondrial|enoyl-CoA hydratase, short chain, 1, mitochondrial|epididymis secretory sperm binding protein|short chain enoyl-CoA hydratase', map_location='10q26.3', chromosome='10', genomic_nucleotide_accession_version='NC_000010.11', start_position_on_the_genomic_accession=133362480, end_position_on_the_genomic_accession=133373396, orientation='minus', exon_count=7, OMIM=[602292], no_hdr0=''),
    1893 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1893, CurrentID=0, Status='live', Symbol='ECM1', Aliases=['URBWD'], description='extracellular matrix protein 1', other_designations='extracellular matrix protein 1|secretory component p85|testicular tissue protein Li 61', map_location='1q21.2', chromosome='1', genomic_nucleotide_accession_version='NC_000001.11', start_position_on_the_genomic_accession=150508109, end_position_on_the_genomic_accession=150513789, orientation='plus', exon_count=10, OMIM=[602201], no_hdr0=''),
    1894 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1894, CurrentID=0, Status='live', Symbol='ECT2', Aliases=['ARHGEF31'], description='epithelial cell transforming 2', other_designations='protein ECT2|epithelial cell-transforming sequence 2 oncogene', map_location='3q26.31', chromosome='3', genomic_nucleotide_accession_version='NC_000003.12', start_position_on_the_genomic_accession=172750694, end_position_on_the_genomic_accession=172829273, orientation='plus', exon_count=29, OMIM=[600586], no_hdr0=''),
    1896 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1896, CurrentID=0, Status='live', Symbol='EDA', Aliases=['ECTD1', 'ED1', 'ED1-A1', 'ED1-A2-A1', 'EDA-A2', 'EDA1', 'EDA2', 'HED', 'HED1', 'ODT1', 'STHAGX1', 'TNLG7C', 'XHED', 'XLHED', 'EDA'], description='ectodysplasin A', other_designations='ectodysplasin-A|X-linked anhidroitic ectodermal dysplasia protein|oligodontia 1|tumor necrosis factor ligand 7C', map_location='Xq13.1', chromosome='X', genomic_nucleotide_accession_version='NC_000023.11', start_position_on_the_genomic_accession=69616086, end_position_on_the_genomic_accession=70039472, orientation='plus', exon_count=13, OMIM=[300451], no_hdr0=''),
    1901 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1901, CurrentID=0, Status='live', Symbol='S1PR1', Aliases=['CD363', 'CHEDG1', 'D1S3362', 'ECGF1', 'EDG-1', 'EDG1', 'S1P1'], description='sphingosine-1-phosphate receptor 1', other_designations='sphingosine 1-phosphate receptor 1|S1P receptor 1|S1P receptor Edg-1|endothelial differentiation G-protein coupled receptor 1|endothelial differentiation, sphingolipid G-protein-coupled receptor, 1|sphingosine 1-phosphate receptor EDG1|sphingosine 1-phosphate receptor Edg-1', map_location='1p21.2', chromosome='1', genomic_nucleotide_accession_version='NC_000001.11', start_position_on_the_genomic_accession=101236899, end_position_on_the_genomic_accession=101241518, orientation='plus', exon_count=3, OMIM=[601974], no_hdr0=''),
    1902 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1902, CurrentID=0, Status='live', Symbol='LPAR1', Aliases=['EDG2', 'GPR26', 'Gpcr26', 'LPA1', 'Mrec1.3', 'VZG1', 'edg-2', 'rec.1.3', 'vzg-1'], description='lysophosphatidic acid receptor 1', other_designations='lysophosphatidic acid receptor 1|LPA receptor 1|LPA-1|endothelial differentiation, lysophosphatidic acid G-protein-coupled receptor, 2|lysophosphatidic acid receptor Edg-2|ventricular zone gene 1', map_location='9q31.3', chromosome='9', genomic_nucleotide_accession_version='NC_000009.12', start_position_on_the_genomic_accession=110873252, end_position_on_the_genomic_accession=111038998, orientation='minus', exon_count=14, OMIM=[602282], no_hdr0=''),
    1903 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1903, CurrentID=0, Status='live', Symbol='S1PR3', Aliases=['EDG-3', 'EDG3', 'LPB3', 'S1P3'], description='sphingosine-1-phosphate receptor 3', other_designations='sphingosine 1-phosphate receptor 3|G protein-coupled receptor, endothelial differentiation gene-3|S1P receptor 3|S1P receptor EDG3|S1P receptor Edg-3|endothelial differentiation G-protein coupled receptor 3|endothelial differentiation, sphingolipid G-protein-coupled receptor, 3|sphingosine 1-phosphate receptor Edg-3', map_location='9q22.1', chromosome='9', genomic_nucleotide_accession_version='NC_000009.12', start_position_on_the_genomic_accession=88991468, end_position_on_the_genomic_accession=89005155, orientation='plus', exon_count=2, OMIM=[601965], no_hdr0=''),
    1906 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1906, CurrentID=0, Status='live', Symbol='EDN1', Aliases=['ARCND3', 'ET1', 'HDLCQ7', 'PPET1', 'QME'], description='endothelin 1', other_designations='endothelin-1|preproendothelin-1', map_location='6p24.1', chromosome='6', genomic_nucleotide_accession_version='NC_000006.12', start_position_on_the_genomic_accession=12256463, end_position_on_the_genomic_accession=12297194, orientation='plus', exon_count=9, OMIM=[131240], no_hdr0=''),
    1907 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1907, CurrentID=0, Status='live', Symbol='EDN2', Aliases=['ET-2', 'ET2', 'PPET2'], description='endothelin 2', other_designations='endothelin-2|preproendothelin 2', map_location='1p34.2', chromosome='1', genomic_nucleotide_accession_version='NC_000001.11', start_position_on_the_genomic_accession=41478775, end_position_on_the_genomic_accession=41484699, orientation='minus', exon_count=6, OMIM=[131241], no_hdr0=''),
    1908 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1908, CurrentID=0, Status='live', Symbol='EDN3', Aliases=['ET-3', 'ET3', 'HSCR4', 'PPET3', 'WS4B'], description='endothelin 3', other_designations='endothelin-3|preproendothelin-3', map_location='20q13.32', chromosome='20', genomic_nucleotide_accession_version='NC_000020.11', start_position_on_the_genomic_accession=59300415, end_position_on_the_genomic_accession=59325992, orientation='plus', exon_count=6, OMIM=[131242], no_hdr0=''),
    1909 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1909, CurrentID=0, Status='live', Symbol='EDNRA', Aliases=['ET-A', 'ETA', 'ETA-R', 'ETAR', 'ETRA', 'MFDA', 'hET-AR'], description='endothelin receptor type A', other_designations='endothelin-1 receptor|G protein-coupled receptor|endothelin receptor subtype A|endothelin-1-specific receptor', map_location='4q31.22-q31.23', chromosome='4', genomic_nucleotide_accession_version='NC_000004.12', start_position_on_the_genomic_accession=147481097, end_position_on_the_genomic_accession=147544954, orientation='plus', exon_count=9, OMIM=[131243], no_hdr0=''),
    1910 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1910, CurrentID=0, Status='live', Symbol='EDNRB', Aliases=['ABCDS', 'ET-B', 'ET-BR', 'ETB', 'ETB1', 'ETBR', 'ETRB', 'HSCR', 'HSCR2', 'WS4A'], description='endothelin receptor type B', other_designations='endothelin receptor type B|Hirschsprung disease 2|endothelin receptor non-selective type|endothelin receptor subtype B1', map_location='13q22.3', chromosome='13', genomic_nucleotide_accession_version='NC_000013.11', start_position_on_the_genomic_accession=77895481, end_position_on_the_genomic_accession=77975527, orientation='minus', exon_count=9, OMIM=[131244], no_hdr0=''),
    1911 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1911, CurrentID=0, Status='live', Symbol='PHC1', Aliases=['EDR1', 'HPH1', 'MCPH11', 'RAE28'], description='polyhomeotic homolog 1', other_designations='polyhomeotic-like protein 1|early development regulator 1 (homolog of polyhomeotic 1)|early development regulatory protein 1|polyhomeotic-like 1', map_location='12p13.31', chromosome='12', genomic_nucleotide_accession_version='NC_000012.12', start_position_on_the_genomic_accession=8914509, end_position_on_the_genomic_accession=8941467, orientation='plus', exon_count=16, OMIM=[602978], no_hdr0=''),
    1912 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1912, CurrentID=0, Status='live', Symbol='PHC2', Aliases=['EDR2', 'HPH2', 'PH2'], description='polyhomeotic homolog 2', other_designations='polyhomeotic-like protein 2|early development regulator 2 (homolog of polyhomeotic 2)|early development regulatory protein 2|polyhomeotic 2|polyhomeotic-like 2', map_location='1p35.1', chromosome='1', genomic_nucleotide_accession_version='NC_000001.11', start_position_on_the_genomic_accession=33323626, end_position_on_the_genomic_accession=33431095, orientation='minus', exon_count=18, OMIM=[602979], no_hdr0=''),
    1915 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1915, CurrentID=0, Status='live', Symbol='EEF1A1', Aliases=['CCS-3', 'CCS3', 'EE1A1', 'EEF-1', 'EEF1A', 'EF-Tu', 'EF1A', 'GRAF-1EF', 'LENG7', 'PTI1', 'eEF1A-1'], description='eukaryotic translation elongation factor 1 alpha 1', other_designations='elongation factor 1-alpha 1|CTCL tumor antigen|EF-1-alpha-1|EF1a-like protein|cervical cancer suppressor 3|elongation factor 1 alpha subunit|elongation factor Tu|epididymis secretory sperm binding protein|eukaryotic elongation factor 1 A-1|eukaryotic translation elongation factor 1 alpha 1-like 14|glucocorticoid receptor AF-1 specific elongation factor|leukocyte receptor cluster (LRC) member 7|leukocyte receptor cluster member 7|prostate tumor-inducing protein 1|translation elongation factor 1 alpha 1-like 14', map_location='6q13', chromosome='6', genomic_nucleotide_accession_version='NC_000006.12', start_position_on_the_genomic_accession=73515750, end_position_on_the_genomic_accession=73521032, orientation='minus', exon_count=8, OMIM=[130590], no_hdr0=''),
    1917 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1917, CurrentID=0, Status='live', Symbol='EEF1A2', Aliases=['EEF1AL', 'EF-1-alpha-2', 'EF1A', 'EIEE33', 'HS1', 'MRD38', 'STN', 'STNL'], description='eukaryotic translation elongation factor 1 alpha 2', other_designations='elongation factor 1-alpha 2|eukaryotic elongation factor 1 A-2|statin-S1', map_location='20q13.33', chromosome='20', genomic_nucleotide_accession_version='NC_000020.11', start_position_on_the_genomic_accession=63488014, end_position_on_the_genomic_accession=63499083, orientation='minus', exon_count=8, OMIM=[602959], no_hdr0=''),
    1933 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1933, CurrentID=0, Status='live', Symbol='EEF1B2', Aliases=['EEF1B', 'EEF1B1', 'EF1B'], description='eukaryotic translation elongation factor 1 beta 2', other_designations='elongation factor 1-beta|EF-1-beta|eukaryotic translation elongation factor 1 beta 1', map_location='2q33.3', chromosome='2', genomic_nucleotide_accession_version='NC_000002.12', start_position_on_the_genomic_accession=206159609, end_position_on_the_genomic_accession=206162928, orientation='plus', exon_count=7, OMIM=[600655], no_hdr0=''),
    1936 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1936, CurrentID=0, Status='live', Symbol='EEF1D', Aliases=['EF-1D', 'EF1D', 'FP1047'], description='eukaryotic translation elongation factor 1 delta', other_designations='elongation factor 1-delta|EF-1-delta|antigen NY-CO-4|eukaryotic translation elongation factor 1 delta (guanine nucleotide exchange protein)', map_location='8q24.3', chromosome='8', genomic_nucleotide_accession_version='NC_000008.11', start_position_on_the_genomic_accession=143579728, end_position_on_the_genomic_accession=143597422, orientation='minus', exon_count=11, OMIM=[130592], no_hdr0=''),
    1937 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1937, CurrentID=0, Status='live', Symbol='EEF1G', Aliases=['EF1G', 'GIG35'], description='eukaryotic translation elongation factor 1 gamma', other_designations='elongation factor 1-gamma|EF-1-gamma|PRO1608|eEF-1B gamma|pancreatic tumor-related protein|translation elongation factor eEF-1 gamma chain', map_location='11q12.3', chromosome='11', genomic_nucleotide_accession_version='NC_000011.10', start_position_on_the_genomic_accession=62559596, end_position_on_the_genomic_accession=62573891, orientation='minus', exon_count=10, OMIM=[130593], no_hdr0=''),
    1938 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1938, CurrentID=0, Status='live', Symbol='EEF2', Aliases=['EEF-2', 'EF-2', 'EF2', 'SCA26'], description='eukaryotic translation elongation factor 2', other_designations='elongation factor 2|epididymis secretory sperm binding protein|polypeptidyl-tRNA translocase', map_location='19p13.3', chromosome='19', genomic_nucleotide_accession_version='NC_000019.10', start_position_on_the_genomic_accession=3976056, end_position_on_the_genomic_accession=3985463, orientation='minus', exon_count=15, OMIM=[130610], no_hdr0=''),
    1939 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1939, CurrentID=0, Status='live', Symbol='EIF2D', Aliases=['HCA56', 'LGTN'], description='eukaryotic translation initiation factor 2D', other_designations='eukaryotic translation initiation factor 2D|hepatocellular carcinoma-associated antigen 56|ligatin', map_location='1q32.1', chromosome='1', genomic_nucleotide_accession_version='NC_000001.11', start_position_on_the_genomic_accession=206572484, end_position_on_the_genomic_accession=206612466, orientation='minus', exon_count=18, OMIM=[613709], no_hdr0=''),
    1942 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1942, CurrentID=0, Status='live', Symbol='EFNA1', Aliases=['B61', 'ECKLG', 'EFL1', 'EPLG1', 'GMAN', 'LERK-1', 'LERK1', 'TNFAIP4'], description='ephrin A1', other_designations='ephrin-A1|TNF alpha-induced protein 4|eph-related receptor tyrosine kinase ligand 1|epididymis secretory sperm binding protein|gastric cancer metastasis associated long noncoding RNA|immediate early response protein B61|ligand of eph-related kinase 1|tumor necrosis factor, alpha-induced protein 4', map_location='1q22', chromosome='1', genomic_nucleotide_accession_version='NC_000001.11', start_position_on_the_genomic_accession=155127876, end_position_on_the_genomic_accession=155134899, orientation='plus', exon_count=5, OMIM=[191164], no_hdr0=''),
    1943 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1943, CurrentID=0, Status='live', Symbol='EFNA2', Aliases=['ELF-1', 'EPLG6', 'HEK7-L', 'LERK-6', 'LERK6'], description='ephrin A2', other_designations='ephrin-A2|HEK7 ligand|eph-related receptor tyrosine kinase ligand 6', map_location='19p13.3', chromosome='19', genomic_nucleotide_accession_version='NC_000019.10', start_position_on_the_genomic_accession=1282817, end_position_on_the_genomic_accession=1301431, orientation='plus', exon_count=6, OMIM=[602756], no_hdr0=''),
    1944 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1944, CurrentID=0, Status='live', Symbol='EFNA3', Aliases=['EFL2', 'EPLG3', 'Ehk1-L', 'LERK3'], description='ephrin A3', other_designations='ephrin-A3|EFL-2|EHK1 ligand|LERK-3|eph-related receptor tyrosine kinase ligand 3|ligand of eph-related kinase 3', map_location='1q21.3', chromosome='1', genomic_nucleotide_accession_version='NC_000001.11', start_position_on_the_genomic_accession=155078837, end_position_on_the_genomic_accession=155087538, orientation='plus', exon_count=5, OMIM=[601381], no_hdr0=''),
    1945 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1945, CurrentID=0, Status='live', Symbol='EFNA4', Aliases=['EFL4', 'EPLG4', 'LERK4'], description='ephrin A4', other_designations='ephrin-A4|LERK-4|eph-related receptor tyrosine kinase ligand 4|ligand of eph-related kinase 4', map_location='1q21.3', chromosome='1', genomic_nucleotide_accession_version='NC_000001.11', start_position_on_the_genomic_accession=155063740, end_position_on_the_genomic_accession=155069553, orientation='plus', exon_count=4, OMIM=[601380], no_hdr0=''),
    1946 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1946, CurrentID=0, Status='live', Symbol='EFNA5', Aliases=['AF1', 'EFL5', 'EPLG7', 'GLC1M', 'LERK7', 'RAGS'], description='ephrin A5', other_designations='ephrin-A5|AL-1|LERK-7|eph-related receptor tyrosine kinase ligand 7', map_location='5q21.3', chromosome='5', genomic_nucleotide_accession_version='NC_000005.10', start_position_on_the_genomic_accession=107376889, end_position_on_the_genomic_accession=107670937, orientation='minus', exon_count=8, OMIM=[601535], no_hdr0=''),
    1947 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1947, CurrentID=0, Status='live', Symbol='EFNB1', Aliases=['CFND', 'CFNS', 'EFB1', 'EFL3', 'EPLG2', 'Elk-L', 'LERK2'], description='ephrin B1', other_designations='ephrin-B1|ELK ligand|eph-related receptor tyrosine kinase ligand 2', map_location='Xq13.1', chromosome='X', genomic_nucleotide_accession_version='NC_000023.11', start_position_on_the_genomic_accession=68829021, end_position_on_the_genomic_accession=68842160, orientation='plus', exon_count=5, OMIM=[300035], no_hdr0=''),
    1948 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1948, CurrentID=0, Status='live', Symbol='EFNB2', Aliases=['EPLG5', 'HTKL', 'Htk-L', 'LERK5'], description='ephrin B2', other_designations='ephrin-B2|HTK ligand|eph-related receptor tyrosine kinase ligand 5|ligand of eph-related kinase 5', map_location='13q33.3', chromosome='13', genomic_nucleotide_accession_version='NC_000013.11', start_position_on_the_genomic_accession=106489745, end_position_on_the_genomic_accession=106535662, orientation='minus', exon_count=7, OMIM=[600527], no_hdr0=''),
    1949 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1949, CurrentID=0, Status='live', Symbol='EFNB3', Aliases=['EFL6', 'EPLG8', 'LERK8'], description='ephrin B3', other_designations='ephrin-B3|EPH-related receptor transmembrane ligand ELK-L3|eph-related receptor tyrosine kinase ligand 8', map_location='17p13.1', chromosome='17', genomic_nucleotide_accession_version='NC_000017.11', start_position_on_the_genomic_accession=7705202, end_position_on_the_genomic_accession=7711372, orientation='plus', exon_count=5, OMIM=[602297], no_hdr0=''),
    1950 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1950, CurrentID=0, Status='live', Symbol='EGF', Aliases=['HOMG4', 'URG'], description='epidermal growth factor', other_designations='pro-epidermal growth factor|beta-urogastrone', map_location='4q25', chromosome='4', genomic_nucleotide_accession_version='NC_000004.12', start_position_on_the_genomic_accession=109912883, end_position_on_the_genomic_accession=110013766, orientation='plus', exon_count=26, OMIM=[131530], no_hdr0=''),
    1951 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1951, CurrentID=0, Status='live', Symbol='CELSR3', Aliases=['ADGRC3', 'CDHF11', 'EGFL1', 'FMI1', 'HFMI1', 'MEGF2', 'RESDA1'], description='cadherin EGF LAG seven-pass G-type receptor 3', other_designations='cadherin EGF LAG seven-pass G-type receptor 3|EGF-like protein 1|EGF-like-domain, multiple 1|adhesion G protein-coupled receptor C3|anchor protein|cadherin family member 11|cadherin, EGF LAG seven-pass G-type receptor 3 (flamingo homolog, Drosophila)|epidermal growth factor-like protein 1|flamingo homolog 1|multiple EGF-like domains protein 2|multiple epidermal growth factor-like domains protein 2', map_location='3p21.31', chromosome='3', genomic_nucleotide_accession_version='NC_000003.12', start_position_on_the_genomic_accession=48636463, end_position_on_the_genomic_accession=48662886, orientation='minus', exon_count=35, OMIM=[604264], no_hdr0=''),
    1952 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1952, CurrentID=0, Status='live', Symbol='CELSR2', Aliases=['ADGRC2', 'CDHF10', 'EGFL2', 'Flamingo1', 'MEGF3'], description='cadherin EGF LAG seven-pass G-type receptor 2', other_designations='cadherin EGF LAG seven-pass G-type receptor 2|EGF-like protein 2|EGF-like-domain, multiple 2|adhesion G protein-coupled receptor C2|cadherin family member 10|cadherin, EGF LAG seven-pass G-type receptor 2 (flamingo homolog, Drosophila)|epidermal growth factor-like 2|epidermal growth factor-like protein 2|flamingo homolog 3|multiple EGF-like domains protein 3|multiple epidermal growth factor-like domains 3|multiple epidermal growth factor-like domains protein 3', map_location='1p13.3', chromosome='1', genomic_nucleotide_accession_version='NC_000001.11', start_position_on_the_genomic_accession=109249539, end_position_on_the_genomic_accession=109275751, orientation='plus', exon_count=34, OMIM=[604265], no_hdr0=''),
    1953 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1953, CurrentID=0, Status='live', Symbol='MEGF6', Aliases=['EGFL3'], description='multiple EGF like domains 6', other_designations='multiple epidermal growth factor-like domains protein 6|EGF-like protein 3|EGF-like-domain, multiple 3|epidermal growth factor-like protein 3|multiple EGF-like domains protein 6', map_location='1p36.32', chromosome='1', genomic_nucleotide_accession_version='NC_000001.11', start_position_on_the_genomic_accession=3487951, end_position_on_the_genomic_accession=3624770, orientation='minus', exon_count=41, OMIM=[604266], no_hdr0=''),
    1954 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1954, CurrentID=0, Status='live', Symbol='MEGF8', Aliases=['C19orf49', 'CRPT2', 'EGFL4', 'SBP1'], description='multiple EGF like domains 8', other_designations='multiple epidermal growth factor-like domains protein 8|EGF-like domain-containing protein 4|EGF-like-domain, multiple 4|HBV pre-S2-binding protein 1|HBV pre-s2 binding protein 1|epidermal growth factor-like protein 4|hepatitis B virus pre-S2-binding protein 1', map_location='19q13.2', chromosome='19', genomic_nucleotide_accession_version='NC_000019.10', start_position_on_the_genomic_accession=42325635, end_position_on_the_genomic_accession=42378765, orientation='plus', exon_count=42, OMIM=[604267], no_hdr0=''),
    1955 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1955, CurrentID=0, Status='live', Symbol='MEGF9', Aliases=['EGFL5'], description='multiple EGF like domains 9', other_designations='multiple epidermal growth factor-like domains protein 9|EGF-like-domain, multiple 5|epidermal growth factor-like protein 5', map_location='9q33.2', chromosome='9', genomic_nucleotide_accession_version='NC_000009.12', start_position_on_the_genomic_accession=120600811, end_position_on_the_genomic_accession=120714470, orientation='minus', exon_count=6, OMIM=[604268], no_hdr0=''),
    1956 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1956, CurrentID=0, Status='live', Symbol='EGFR', Aliases=['ERBB', 'ERBB1', 'HER1', 'NISBD2', 'PIG61', 'mENA'], description='epidermal growth factor receptor', other_designations='epidermal growth factor receptor|avian erythroblastic leukemia viral (v-erb-b) oncogene homolog|cell growth inhibiting protein 40|cell proliferation-inducing protein 61|epidermal growth factor receptor tyrosine kinase domain|erb-b2 receptor tyrosine kinase 1|proto-oncogene c-ErbB-1|receptor tyrosine-protein kinase erbB-1', map_location='7p11.2', chromosome='7', genomic_nucleotide_accession_version='NC_000007.14', start_position_on_the_genomic_accession=55019017, end_position_on_the_genomic_accession=55211628, orientation='plus', exon_count=31, OMIM=[131550], no_hdr0=''),
    1958 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1958, CurrentID=0, Status='live', Symbol='EGR1', Aliases=['AT225', 'G0S30', 'KROX-24', 'NGFI-A', 'TIS8', 'ZIF-268', 'ZNF225'], description='early growth response 1', other_designations='early growth response protein 1|EGR-1|nerve growth factor-induced protein A|transcription factor ETR103|transcription factor Zif268|zinc finger protein 225|zinc finger protein Krox-24', map_location='5q31.2', chromosome='5', genomic_nucleotide_accession_version='NC_000005.10', start_position_on_the_genomic_accession=138465479, end_position_on_the_genomic_accession=138469303, orientation='plus', exon_count=2, OMIM=[128990], no_hdr0=''),
    1959 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1959, CurrentID=0, Status='live', Symbol='EGR2', Aliases=['AT591', 'CHN1', 'CMT1D', 'CMT4E', 'KROX20'], description='early growth response 2', other_designations='E3 SUMO-protein ligase EGR2|E3 SUMO-protein transferase ERG2|KROX-20, Drosophila, homolog (early growth response-2)|early growth response protein 2|zinc finger protein Krox-20', map_location='10q21.3', chromosome='10', genomic_nucleotide_accession_version='NC_000010.11', start_position_on_the_genomic_accession=62811996, end_position_on_the_genomic_accession=62819167, orientation='minus', exon_count=5, OMIM=[129010], no_hdr0=''),
    1960 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1960, CurrentID=0, Status='live', Symbol='EGR3', Aliases=['EGR-3', 'PILOT'], description='early growth response 3', other_designations='early growth response protein 3|zinc finger protein pilot', map_location='8p21.3', chromosome='8', genomic_nucleotide_accession_version='NC_000008.11', start_position_on_the_genomic_accession=22687659, end_position_on_the_genomic_accession=22693480, orientation='minus', exon_count=5, OMIM=[602419], no_hdr0=''),
    1961 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1961, CurrentID=0, Status='live', Symbol='EGR4', Aliases=['AT133', 'NGFI-C', 'NGFIC', 'PAT133'], description='early growth response 4', other_designations='early growth response protein 4', map_location='2p13.2', chromosome='2', genomic_nucleotide_accession_version='NC_000002.12', start_position_on_the_genomic_accession=73290929, end_position_on_the_genomic_accession=73293548, orientation='minus', exon_count=2, OMIM=[128992], no_hdr0=''),
    1962 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1962, CurrentID=0, Status='live', Symbol='EHHADH', Aliases=['ECHD', 'FRTS3', 'L-PBE', 'LBFP', 'LBP', 'MFE1', 'PBFE'], description='enoyl-CoA hydratase and 3-hydroxyacyl CoA dehydrogenase', other_designations='peroxisomal bifunctional enzyme|3,2-trans-enoyl-CoA isomerase|L-3-hydroxyacyl-CoA dehydrogenase|L-bifunctional protein, peroxisomal|PBE|enoyl-CoA, hydratase/3-hydroxyacyl CoA dehydrogenase|enoyl-Coenzyme A, hydratase/3-hydroxyacyl Coenzyme A dehydrogenase|multifunctional enzyme 1|peroxisomal enoyl-CoA hydratase', map_location='3q27.2', chromosome='3', genomic_nucleotide_accession_version='NC_000003.12', start_position_on_the_genomic_accession=185190624, end_position_on_the_genomic_accession=185254049, orientation='minus', exon_count=8, OMIM=[607037], no_hdr0=''),
    1964 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1964, CurrentID=0, Status='live', Symbol='EIF1AX', Aliases=['EIF1A', 'EIF1AP1', 'EIF4C', 'eIF-1A', 'eIF-4C'], description='eukaryotic translation initiation factor 1A X-linked', other_designations='eukaryotic translation initiation factor 1A, X-chromosomal|Putative eukaryotic translation initiation factor 1A|eukaryotic translation initiation factor 1A, X chromosome|eukaryotic translation initiation factor 4C', map_location='Xp22.12', chromosome='X', genomic_nucleotide_accession_version='NC_000023.11', start_position_on_the_genomic_accession=20124525, end_position_on_the_genomic_accession=20141838, orientation='minus', exon_count=7, OMIM=[300186], no_hdr0=''),
    1965 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1965, CurrentID=0, Status='live', Symbol='EIF2S1', Aliases=['EIF-2', 'EIF-2A', 'EIF-2alpha', 'EIF2', 'EIF2A'], description='eukaryotic translation initiation factor 2 subunit alpha', other_designations='eukaryotic translation initiation factor 2 subunit 1|eIF-2-alpha|eukaryotic translation initiation factor 2, subunit 1 alpha, 35kDa', map_location='14q23.3', chromosome='14', genomic_nucleotide_accession_version='NC_000014.9', start_position_on_the_genomic_accession=67360328, end_position_on_the_genomic_accession=67386516, orientation='plus', exon_count=8, OMIM=[603907], no_hdr0=''),
    1967 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1967, CurrentID=0, Status='live', Symbol='EIF2B1', Aliases=['EIF2B', 'EIF2BA'], description='eukaryotic translation initiation factor 2B subunit alpha', other_designations='translation initiation factor eIF-2B subunit alpha|eIF-2B GDP-GTP exchange factor subunit alpha|eukaryotic translation initiation factor 2B, subunit 1 alpha, 26kDa', map_location='12q24.31', chromosome='12', genomic_nucleotide_accession_version='NC_000012.12', start_position_on_the_genomic_accession=123620406, end_position_on_the_genomic_accession=123633686, orientation='minus', exon_count=9, OMIM=[606686], no_hdr0=''),
    1968 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1968, CurrentID=0, Status='live', Symbol='EIF2S3', Aliases=['EIF2', 'EIF2G', 'EIF2gamma', 'MEHMO', 'MRXSBRK', 'eIF-2gA'], description='eukaryotic translation initiation factor 2 subunit gamma', other_designations='eukaryotic translation initiation factor 2 subunit 3|eIF-2-gamma X|eIF-2gX|eukaryotic translation initiation factor 2 subunit gamma X|eukaryotic translation initiation factor 2, subunit 3 gamma, 52kDa|eukaryotic translation initiation factor 2G', map_location='Xp22.11', chromosome='X', genomic_nucleotide_accession_version='NC_000023.11', start_position_on_the_genomic_accession=24054956, end_position_on_the_genomic_accession=24078810, orientation='plus', exon_count=12, OMIM=[300161], no_hdr0=''),
    1969 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1969, CurrentID=0, Status='live', Symbol='EPHA2', Aliases=['ARCC2', 'CTPA', 'CTPP1', 'CTRCT6', 'ECK'], description='EPH receptor A2', other_designations='ephrin type-A receptor 2|epithelial cell receptor protein tyrosine kinase|soluble EPHA2 variant 1|tyrosine-protein kinase receptor ECK', map_location='1p36.13', chromosome='1', genomic_nucleotide_accession_version='NC_000001.11', start_position_on_the_genomic_accession=16124337, end_position_on_the_genomic_accession=16156104, orientation='minus', exon_count=18, OMIM=[176946], no_hdr0=''),
    1973 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1973, CurrentID=0, Status='live', Symbol='EIF4A1', Aliases=['DDX2A', 'EIF-4A', 'EIF4A', 'eIF-4A-I', 'eIF4A-I'], description='eukaryotic translation initiation factor 4A1', other_designations='eukaryotic initiation factor 4A-I|ATP-dependent RNA helicase eIF4A-1|eukaryotic initiation factor 4AI|eukaryotic translation initiation factor 4A', map_location='17p13.1', chromosome='17', genomic_nucleotide_accession_version='NC_000017.11', start_position_on_the_genomic_accession=7572825, end_position_on_the_genomic_accession=7579006, orientation='plus', exon_count=11, OMIM=[602641], no_hdr0=''),
    1974 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1974, CurrentID=0, Status='live', Symbol='EIF4A2', Aliases=['BM-010', 'DDX2B', 'EIF4A', 'EIF4F', 'eIF-4A-II', 'eIF4A-II'], description='eukaryotic translation initiation factor 4A2', other_designations='eukaryotic initiation factor 4A-II|ATP-dependent RNA helicase eIF4A-2', map_location='3q27.3', chromosome='3', genomic_nucleotide_accession_version='NC_000003.12', start_position_on_the_genomic_accession=186783577, end_position_on_the_genomic_accession=186789897, orientation='plus', exon_count=11, OMIM=[601102], no_hdr0=''),
    1975 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1975, CurrentID=0, Status='live', Symbol='EIF4B', Aliases=['EIF-4B', 'PRO1843'], description='eukaryotic translation initiation factor 4B', other_designations='eukaryotic translation initiation factor 4B', map_location='12q13.13', chromosome='12', genomic_nucleotide_accession_version='NC_000012.12', start_position_on_the_genomic_accession=53006456, end_position_on_the_genomic_accession=53042215, orientation='plus', exon_count=15, OMIM=[603928], no_hdr0=''),
    1977 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1977, CurrentID=0, Status='live', Symbol='EIF4E', Aliases=['AUTS19', 'CBP1', 'EIF4EL1', 'EIF4F', 'eIF-4E', 'EIF4E'], description='eukaryotic translation initiation factor 4E', other_designations='eukaryotic translation initiation factor 4E|eIF-4F 25 kDa subunit|eukaryotic translation initiation factor 4E-like 1|mRNA cap-binding protein', map_location='4q23', chromosome='4', genomic_nucleotide_accession_version='NC_000004.12', start_position_on_the_genomic_accession=98879276, end_position_on_the_genomic_accession=98929133, orientation='minus', exon_count=9, OMIM=[133440], no_hdr0=''),
    1978 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1978, CurrentID=0, Status='live', Symbol='EIF4EBP1', Aliases=['4E-BP1', '4EBP1', 'BP-1', 'PHAS-I'], description='eukaryotic translation initiation factor 4E binding protein 1', other_designations='eukaryotic translation initiation factor 4E-binding protein 1|eIF4E-binding protein 1|phosphorylated heat- and acid-stable protein regulated by insulin 1', map_location='8p11.23', chromosome='8', genomic_nucleotide_accession_version='NC_000008.11', start_position_on_the_genomic_accession=38030534, end_position_on_the_genomic_accession=38060365, orientation='plus', exon_count=3, OMIM=[602223], no_hdr0=''),
    1979 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1979, CurrentID=0, Status='live', Symbol='EIF4EBP2', Aliases=['4EBP2', 'PHASII'], description='eukaryotic translation initiation factor 4E binding protein 2', other_designations='eukaryotic translation initiation factor 4E-binding protein 2|4E-BP2|eIF4E-binding protein 2|phosphorylated, heat and acid stable regulated by insulin protein II', map_location='10q22.1', chromosome='10', genomic_nucleotide_accession_version='NC_000010.11', start_position_on_the_genomic_accession=70404145, end_position_on_the_genomic_accession=70428618, orientation='plus', exon_count=3, OMIM=[602224], no_hdr0=''),
    1981 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1981, CurrentID=0, Status='live', Symbol='EIF4G1', Aliases=['EIF-4G1', 'EIF4F', 'EIF4G', 'EIF4GI', 'P220', 'PARK18'], description='eukaryotic translation initiation factor 4 gamma 1', other_designations='eukaryotic translation initiation factor 4 gamma 1|EIF4-gamma|eIF-4-gamma 1|eucaryotic translation initiation factor 4G', map_location='3q27.1', chromosome='3', genomic_nucleotide_accession_version='NC_000003.12', start_position_on_the_genomic_accession=184314606, end_position_on_the_genomic_accession=184335358, orientation='plus', exon_count=34, OMIM=[600495], no_hdr0=''),
    1982 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1982, CurrentID=0, Status='live', Symbol='EIF4G2', Aliases=['AAG1', 'DAP5', 'NAT1', 'P97'], description='eukaryotic translation initiation factor 4 gamma 2', other_designations='eukaryotic translation initiation factor 4 gamma 2|DAP-5|aging-associated protein 1|death-associated protein 5|eIF-4-gamma 2|eIF-4G 2|eIF4G 2|eukaryotic translation initiation factor 4G-like 1', map_location='11p15.4', chromosome='11', genomic_nucleotide_accession_version='NC_000011.10', start_position_on_the_genomic_accession=10797046, end_position_on_the_genomic_accession=10808926, orientation='minus', exon_count=23, OMIM=[602325], no_hdr0=''),
    1983 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1983, CurrentID=0, Status='live', Symbol='EIF5', Aliases=['EIF-5', 'EIF-5A'], description='eukaryotic translation initiation factor 5', other_designations='eukaryotic translation initiation factor 5', map_location='14q32.32', chromosome='14', genomic_nucleotide_accession_version='NC_000014.9', start_position_on_the_genomic_accession=103334237, end_position_on_the_genomic_accession=103345025, orientation='plus', exon_count=13, OMIM=[601710], no_hdr0=''),
    1984 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1984, CurrentID=0, Status='live', Symbol='EIF5A', Aliases=['EIF-5A1', 'eIF-4D', 'eIF5AI', 'EIF5A'], description='eukaryotic translation initiation factor 5A', other_designations='eukaryotic translation initiation factor 5A-1|eukaryotic initiation factor 5A|rev-binding factor', map_location='17p13.1', chromosome='17', genomic_nucleotide_accession_version='NC_000017.11', start_position_on_the_genomic_accession=7306999, end_position_on_the_genomic_accession=7312463, orientation='plus', exon_count=10, OMIM=[600187], no_hdr0=''),
    1990 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1990, CurrentID=0, Status='live', Symbol='CELA1', Aliases=['ELA1'], description='chymotrypsin like elastase 1', other_designations='chymotrypsin-like elastase family member 1|chymotrypsin like elastase family member 1|elastase 1, pancreatic|elastase-1|pancreatic elastase 1', map_location='12q13.13', chromosome='12', genomic_nucleotide_accession_version='NC_000012.12', start_position_on_the_genomic_accession=51328442, end_position_on_the_genomic_accession=51346679, orientation='minus', exon_count=8, OMIM=[130120], no_hdr0=''),
    1991 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1991, CurrentID=0, Status='live', Symbol='ELANE', Aliases=['ELA2', 'GE', 'HLE', 'HNE', 'NE', 'PMN-E', 'SCN1'], description='elastase, neutrophil expressed', other_designations='neutrophil elastase|PMN elastase|bone marrow serine protease|elastase 2, neutrophil|elastase-2|granulocyte-derived elastase|leukocyte elastase|medullasin|polymorphonuclear elastase', map_location='19p13.3', chromosome='19', genomic_nucleotide_accession_version='NC_000019.10', start_position_on_the_genomic_accession=850997, end_position_on_the_genomic_accession=856250, orientation='plus', exon_count=6, OMIM=[130130], no_hdr0=''),
    1992 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1992, CurrentID=0, Status='live', Symbol='SERPINB1', Aliases=['EI', 'ELANH2', 'HEL-S-27', 'HEL57', 'LEI', 'M/NEI', 'MNEI', 'PI-2', 'PI2'], description='serpin family B member 1', other_designations='leukocyte elastase inhibitor|epididymis luminal protein 57|epididymis secretory protein Li 27|peptidase inhibitor 2|protease inhibitor 2 (anti-elastase), monocyte/neutrophil derived|serine (or cysteine) proteinase inhibitor, clade B (ovalbumin), member 1|serpin peptidase inhibitor, clade B (ovalbumin), member 1', map_location='6p25.2', chromosome='6', genomic_nucleotide_accession_version='NC_000006.12', start_position_on_the_genomic_accession=2832332, end_position_on_the_genomic_accession=2842012, orientation='minus', exon_count=9, OMIM=[130135], no_hdr0=''),
    1993 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1993, CurrentID=0, Status='live', Symbol='ELAVL2', Aliases=['HEL-N1', 'HELN1', 'HUB'], description='ELAV like RNA binding protein 2', other_designations='ELAV-like protein 2|ELAV (embryonic lethal, abnormal vision, Drosophila)-like 2 (Hu antigen B)|ELAV like neuron-specific RNA binding protein 2|hu-antigen B|nervous system-specific RNA-binding protein Hel-N1', map_location='9p21.3', chromosome='9', genomic_nucleotide_accession_version='NC_000009.12', start_position_on_the_genomic_accession=23690099, end_position_on_the_genomic_accession=23850601, orientation='minus', exon_count=20, OMIM=[601673], no_hdr0=''),
    1994 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1994, CurrentID=0, Status='live', Symbol='ELAVL1', Aliases=['ELAV1', 'HUR', 'Hua', 'MelG'], description='ELAV like RNA binding protein 1', other_designations='ELAV-like protein 1|ELAV (embryonic lethal, abnormal vision, Drosophila)-like 1 (Hu antigen R)|Hu antigen R|embryonic lethal, abnormal vision, drosophila, homolog-like 1|hu-antigen R', map_location='19p13.2', chromosome='19', genomic_nucleotide_accession_version='NC_000019.10', start_position_on_the_genomic_accession=7958573, end_position_on_the_genomic_accession=8005641, orientation='minus', exon_count=7, OMIM=[603466], no_hdr0=''),
    1995 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1995, CurrentID=0, Status='live', Symbol='ELAVL3', Aliases=['HUC', 'HUCL', 'PLE21'], description='ELAV like RNA binding protein 3', other_designations='ELAV-like protein 3|ELAV (embryonic lethal, abnormal vision, Drosophila)-like 3 (Hu antigen C)|ELAV like neuron-specific RNA binding protein 3|Hu antigen C|hu-antigen C|paraneoplastic cerebellar degeneration-associated antigen|paraneoplastic limbic encephalitis antigen 21', map_location='19p13.2', chromosome='19', genomic_nucleotide_accession_version='NC_000019.10', start_position_on_the_genomic_accession=11451326, end_position_on_the_genomic_accession=11481046, orientation='minus', exon_count=7, OMIM=[603458], no_hdr0=''),
    1996 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1996, CurrentID=0, Status='live', Symbol='ELAVL4', Aliases=['HUD', 'PNEM'], description='ELAV like RNA binding protein 4', other_designations='ELAV-like protein 4|ELAV (embryonic lethal, abnormal vision, Drosophila)-like 4 (Hu antigen D)|ELAV like neuron-specific RNA binding protein 4|Hu antigen D|paraneoplastic encephalomyelitis antigen HuD', map_location='1p33-p32.3', chromosome='1', genomic_nucleotide_accession_version='NC_000001.11', start_position_on_the_genomic_accession=50048055, end_position_on_the_genomic_accession=50203772, orientation='plus', exon_count=17, OMIM=[168360], no_hdr0=''),
    1997 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1997, CurrentID=0, Status='live', Symbol='ELF1', Aliases=['EFTUD1', 'RIA1'], description='E74 like ETS transcription factor 1', other_designations='ETS-related transcription factor Elf-1|E74-like factor 1 (ets domain transcription factor)', map_location='13q14.11', chromosome='13', genomic_nucleotide_accession_version='NC_000013.11', start_position_on_the_genomic_accession=40931919, end_position_on_the_genomic_accession=41061386, orientation='minus', exon_count=14, OMIM=[189973], no_hdr0=''),
    1998 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1998, CurrentID=0, Status='live', Symbol='ELF2', Aliases=['EU32', 'NERF', 'NERF-1A', 'NERF-1B', 'NERF-1a', 'b', 'NERF-2'], description='E74 like ETS transcription factor 2', other_designations='ETS-related transcription factor Elf-2|E74-like factor 2 (ets domain transcription factor)|ets family transcription factor ELF2C|new Ets-related factor', map_location='4q31.1', chromosome='4', genomic_nucleotide_accession_version='NC_000004.12', start_position_on_the_genomic_accession=139057220, end_position_on_the_genomic_accession=139177218, orientation='minus', exon_count=15, OMIM=[], no_hdr0=''),
    1999 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=1999, CurrentID=0, Status='live', Symbol='ELF3', Aliases=['EPR-1', 'ERT', 'ESE-1', 'ESX'], description='E74 like ETS transcription factor 3', other_designations='ETS-related transcription factor Elf-3|E74-like factor 3 (ETS domain transcription factor, serine box, epithelial-specific)|E74-like factor 3 (ets domain transcription factor)|E74-like factor 3 (ets domain transcription factor, epithelial-specific )|epithelial-restricted with serine box|epithelium-restricted Ets protein ESX|epithelium-specific Ets transcription factor 1|ets domain transcription factor, serine box (epithelial-specific)', map_location='1q32.1', chromosome='1', genomic_nucleotide_accession_version='NC_000001.11', start_position_on_the_genomic_accession=202010583, end_position_on_the_genomic_accession=202017183, orientation='plus', exon_count=9, OMIM=[602191], no_hdr0=''),
    2000 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=2000, CurrentID=0, Status='live', Symbol='ELF4', Aliases=['ELFR', 'MEF'], description='E74 like ETS transcription factor 4', other_designations='ETS-related transcription factor Elf-4|E74-like factor 4 (ets domain transcription factor)|myeloid Elf-1-like factor', map_location='Xq26.1', chromosome='X', genomic_nucleotide_accession_version='NC_000023.11', start_position_on_the_genomic_accession=130063955, end_position_on_the_genomic_accession=130110891, orientation='minus', exon_count=11, OMIM=[300775], no_hdr0=''),
    2001 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=2001, CurrentID=0, Status='live', Symbol='ELF5', Aliases=['ESE2'], description='E74 like ETS transcription factor 5', other_designations='ETS-related transcription factor Elf-5|E74-like factor 5 (ets domain transcription factor)|epithelium-restricted ESE-1-related Ets factor|epithelium-specific Ets transcription factor 2', map_location='11p13', chromosome='11', genomic_nucleotide_accession_version='NC_000011.10', start_position_on_the_genomic_accession=34478791, end_position_on_the_genomic_accession=34513794, orientation='minus', exon_count=8, OMIM=[605169], no_hdr0=''),
    2002 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=2002, CurrentID=0, Status='live', Symbol='ELK1', Aliases=[], description='ETS transcription factor ELK1', other_designations='ETS domain-containing protein Elk-1|ELK1, ETS transcription factor|ELK1, member of ETS oncogene family|ETS-like gene 1|tyrosine kinase (ELK1) oncogene', map_location='Xp11.23', chromosome='X', genomic_nucleotide_accession_version='NC_000023.11', start_position_on_the_genomic_accession=47635520, end_position_on_the_genomic_accession=47650604, orientation='minus', exon_count=7, OMIM=[311040], no_hdr0=''),
    2004 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=2004, CurrentID=0, Status='live', Symbol='ELK3', Aliases=['ERP', 'NET', 'SAP-2', 'SAP2'], description='ETS transcription factor ELK3', other_designations='ETS domain-containing protein Elk-3|ELK3, ETS transcription factor|ELK3, ETS-domain protein (SRF accessory protein 2)|ETS-related protein ERP|ETS-related protein NET|SRF accessory protein 2|serum response factor accessory protein 2', map_location='12q23.1', chromosome='12', genomic_nucleotide_accession_version='NC_000012.12', start_position_on_the_genomic_accession=96194375, end_position_on_the_genomic_accession=96269824, orientation='plus', exon_count=7, OMIM=[600247], no_hdr0=''),
    2005 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=2005, CurrentID=0, Status='live', Symbol='ELK4', Aliases=['SAP1'], description='ETS transcription factor ELK4', other_designations='ETS domain-containing protein Elk-4|ELK4, ETS transcription factor|ELK4, ETS-domain protein (SRF accessory protein 1)|SAP-1|serum response factor accessory protein 1', map_location='1q32.1', chromosome='1', genomic_nucleotide_accession_version='NC_000001.11', start_position_on_the_genomic_accession=205607943, end_position_on_the_genomic_accession=205632872, orientation='minus', exon_count=5, OMIM=[600246], no_hdr0=''),
    2006 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=2006, CurrentID=0, Status='live', Symbol='ELN', Aliases=['ADCL1', 'SVAS', 'WBS', 'WS'], description='elastin', other_designations='elastin|tropoelastin', map_location='7q11.23', chromosome='7', genomic_nucleotide_accession_version='NC_000007.14', start_position_on_the_genomic_accession=74027772, end_position_on_the_genomic_accession=74069907, orientation='plus', exon_count=34, OMIM=[130160], no_hdr0=''),
    2009 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=2009, CurrentID=0, Status='live', Symbol='EML1', Aliases=['BH', 'ELP79', 'EMAP', 'EMAP-1', 'EMAPL'], description='EMAP like 1', other_designations='echinoderm microtubule-associated protein-like 1|echinoderm microtubule associated protein like 1', map_location='14q32.2', chromosome='14', genomic_nucleotide_accession_version='NC_000014.9', start_position_on_the_genomic_accession=99737722, end_position_on_the_genomic_accession=99942060, orientation='plus', exon_count=27, OMIM=[602033], no_hdr0=''),
    2010 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=2010, CurrentID=0, Status='live', Symbol='EMD', Aliases=['EDMD', 'LEMD5', 'STA'], description='emerin', other_designations='emerin|LEM domain containing 5', map_location='Xq28', chromosome='X', genomic_nucleotide_accession_version='NC_000023.11', start_position_on_the_genomic_accession=154379236, end_position_on_the_genomic_accession=154381523, orientation='plus', exon_count=5, OMIM=[300384], no_hdr0=''),
    2011 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=2011, CurrentID=0, Status='live', Symbol='MARK2', Aliases=['EMK-1', 'EMK1', 'PAR-1', 'Par-1b', 'Par1b'], description='microtubule affinity regulating kinase 2', other_designations='serine/threonine-protein kinase MARK2|ELKL motif kinase 1|MAP/microtubule affinity-regulating kinase 2|PAR1 homolog b|Ser/Thr protein kinase PAR-1B|serine/threonine protein kinase EMK|testicular tissue protein Li 117', map_location='11q13.1', chromosome='11', genomic_nucleotide_accession_version='NC_000011.10', start_position_on_the_genomic_accession=63838955, end_position_on_the_genomic_accession=63911020, orientation='plus', exon_count=22, OMIM=[600526], no_hdr0=''),
    2012 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=2012, CurrentID=0, Status='live', Symbol='EMP1', Aliases=['CL-20', 'EMP-1', 'TMP'], description='epithelial membrane protein 1', other_designations='epithelial membrane protein 1|tumor-associated membrane protein', map_location='12p13.1', chromosome='12', genomic_nucleotide_accession_version='NC_000012.12', start_position_on_the_genomic_accession=13196726, end_position_on_the_genomic_accession=13219941, orientation='plus', exon_count=4, OMIM=[602333], no_hdr0=''),
    2013 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=2013, CurrentID=0, Status='live', Symbol='EMP2', Aliases=['XMP'], description='epithelial membrane protein 2', other_designations='epithelial membrane protein 2', map_location='16p13.13', chromosome='16', genomic_nucleotide_accession_version='NC_000016.10', start_position_on_the_genomic_accession=10528422, end_position_on_the_genomic_accession=10580598, orientation='minus', exon_count=6, OMIM=[602334], no_hdr0=''),
    2014 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=2014, CurrentID=0, Status='live', Symbol='EMP3', Aliases=['YMP'], description='epithelial membrane protein 3', other_designations='epithelial membrane protein 3|EMP-3|HNMP-1|hematopoietic neural membrane protein 1', map_location='19q13.33', chromosome='19', genomic_nucleotide_accession_version='NC_000019.10', start_position_on_the_genomic_accession=48325504, end_position_on_the_genomic_accession=48330554, orientation='plus', exon_count=6, OMIM=[602335], no_hdr0=''),
    2015 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=2015, CurrentID=0, Status='live', Symbol='ADGRE1', Aliases=['EMR1', 'TM7LN3'], description='adhesion G protein-coupled receptor E1', other_designations='adhesion G protein-coupled receptor E1|EGF-like module receptor 1|EGF-like module-containing mucin-like hormone receptor-like 1|EMR1 hormone receptor|egf-like module containing, mucin-like, hormone receptor-like 1|egf-like module containing, mucin-like, hormone receptor-like sequence 1', map_location='19p13.3-p13.2', chromosome='19', genomic_nucleotide_accession_version='NC_000019.10', start_position_on_the_genomic_accession=6887549, end_position_on_the_genomic_accession=6940450, orientation='plus', exon_count=23, OMIM=[600493], no_hdr0=''),
    2016 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=2016, CurrentID=0, Status='live', Symbol='EMX1', Aliases=[], description='empty spiracles homeobox 1', other_designations='homeobox protein EMX1|empty spiracles homolog 1|empty spiracles-like protein 1', map_location='2p13.2', chromosome='2', genomic_nucleotide_accession_version='NC_000002.12', start_position_on_the_genomic_accession=72910949, end_position_on_the_genomic_accession=72936691, orientation='plus', exon_count=5, OMIM=[600034], no_hdr0=''),
    2017 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=2017, CurrentID=0, Status='live', Symbol='CTTN', Aliases=['EMS1'], description='cortactin', other_designations='src substrate cortactin|1110020L01Rik|amplaxin|ems1 sequence (mammary tumor and squamous cell carcinoma-associated (p80/85 src substrate)|epididymis secretory sperm binding protein|oncogene EMS1', map_location='11q13.3', chromosome='11', genomic_nucleotide_accession_version='NC_000011.10', start_position_on_the_genomic_accession=70398529, end_position_on_the_genomic_accession=70436579, orientation='plus', exon_count=20, OMIM=[164765], no_hdr0=''),
    2018 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=2018, CurrentID=0, Status='live', Symbol='EMX2', Aliases=[], description='empty spiracles homeobox 2', other_designations='homeobox protein EMX2|empty spiracles homolog 2|empty spiracles-like protein 2', map_location='10q26.11', chromosome='10', genomic_nucleotide_accession_version='NC_000010.11', start_position_on_the_genomic_accession=117542746, end_position_on_the_genomic_accession=117549546, orientation='plus', exon_count=3, OMIM=[600035], no_hdr0=''),
    2019 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=2019, CurrentID=0, Status='live', Symbol='EN1', Aliases=[], description='engrailed homeobox 1', other_designations='homeobox protein engrailed-1|engrailed homolog 1|homeobox protein en-1|hu-En-1', map_location='2q14.2', chromosome='2', genomic_nucleotide_accession_version='NC_000002.12', start_position_on_the_genomic_accession=118842171, end_position_on_the_genomic_accession=118847648, orientation='minus', exon_count=2, OMIM=[131290], no_hdr0=''),
    2020 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=2020, CurrentID=0, Status='live', Symbol='EN2', Aliases=[], description='engrailed homeobox 2', other_designations='homeobox protein engrailed-2|engrailed homolog 2|engrailed-2|homeobox protein en-2|hu-En-2', map_location='7q36.3', chromosome='7', genomic_nucleotide_accession_version='NC_000007.14', start_position_on_the_genomic_accession=155458129, end_position_on_the_genomic_accession=155464831, orientation='plus', exon_count=2, OMIM=[131310], no_hdr0=''),
    2021 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=2021, CurrentID=0, Status='live', Symbol='ENDOG', Aliases=[], description='endonuclease G', other_designations='endonuclease G, mitochondrial|endo G|mitochondrial endonuclease G', map_location='9q34.11', chromosome='9', genomic_nucleotide_accession_version='NC_000009.12', start_position_on_the_genomic_accession=128818402, end_position_on_the_genomic_accession=128822676, orientation='plus', exon_count=4, OMIM=[600440], no_hdr0=''),
    2022 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=2022, CurrentID=0, Status='live', Symbol='ENG', Aliases=['END', 'HHT1', 'ORW1'], description='endoglin', other_designations='endoglin|CD105 antigen', map_location='9q34.11', chromosome='9', genomic_nucleotide_accession_version='NC_000009.12', start_position_on_the_genomic_accession=127815012, end_position_on_the_genomic_accession=127854773, orientation='minus', exon_count=15, OMIM=[131195], no_hdr0=''),
    2023 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=2023, CurrentID=0, Status='live', Symbol='ENO1', Aliases=['ENO1L1', 'HEL-S-17', 'MPB1', 'NNE', 'PPH'], description='enolase 1', other_designations='alpha-enolase|c-myc promoter-binding protein-1|2-phospho-D-glycerate hydro-lyase|MYC promoter-binding protein 1|alpha enolase like 1|enolase 1, (alpha)|enolase-alpha|epididymis secretory protein Li 17|non-neural enolase|phosphopyruvate hydratase|plasminogen-binding protein|tau-crystallin', map_location='1p36.23', chromosome='1', genomic_nucleotide_accession_version='NC_000001.11', start_position_on_the_genomic_accession=8861000, end_position_on_the_genomic_accession=8878686, orientation='minus', exon_count=13, OMIM=[172430], no_hdr0=''),
    2026 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=2026, CurrentID=0, Status='live', Symbol='ENO2', Aliases=['HEL-S-279', 'NSE'], description='enolase 2', other_designations='gamma-enolase|2-phospho-D-glycerate hydro-lyase|2-phospho-D-glycerate hydrolyase|enolase 2 (gamma, neuronal)|epididymis secretory protein Li 279|neural enolase|neuron specific gamma enolase|neuron-specific enolase|neuronal enriched enolase|neurone-specific enolase', map_location='12p13.31', chromosome='12', genomic_nucleotide_accession_version='NC_000012.12', start_position_on_the_genomic_accession=6914580, end_position_on_the_genomic_accession=6923697, orientation='plus', exon_count=12, OMIM=[131360], no_hdr0=''),
    2027 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=2027, CurrentID=0, Status='live', Symbol='ENO3', Aliases=['GSD13', 'MSE'], description='enolase 3', other_designations='beta-enolase|2-phospho-D-glycerate hydrolyase|enolase 3 (beta, muscle)|muscle enriched enolase|muscle-specific enolase|skeletal muscle enolase', map_location='17p13.2', chromosome='17', genomic_nucleotide_accession_version='NC_000017.11', start_position_on_the_genomic_accession=4949182, end_position_on_the_genomic_accession=4957131, orientation='plus', exon_count=14, OMIM=[131370], no_hdr0=''),
    2028 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=2028, CurrentID=0, Status='live', Symbol='ENPEP', Aliases=['APA', 'CD249', 'gp160'], description='glutamyl aminopeptidase', other_designations='glutamyl aminopeptidase|AP-A|EAP|aminopeptidase A|differentiation antigen gp160', map_location='4q25', chromosome='4', genomic_nucleotide_accession_version='NC_000004.12', start_position_on_the_genomic_accession=110476155, end_position_on_the_genomic_accession=110565285, orientation='plus', exon_count=24, OMIM=[138297], no_hdr0=''),
    2029 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=2029, CurrentID=0, Status='live', Symbol='ENSA', Aliases=['ARPP-19e'], description='endosulfine alpha', other_designations='alpha-endosulfine', map_location='1q21.3', chromosome='1', genomic_nucleotide_accession_version='NC_000001.11', start_position_on_the_genomic_accession=150621246, end_position_on_the_genomic_accession=150629612, orientation='minus', exon_count=6, OMIM=[603061], no_hdr0=''),
    2030 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=2030, CurrentID=0, Status='live', Symbol='SLC29A1', Aliases=['ENT1'], description='solute carrier family 29 member 1 (Augustine blood group)', other_designations='equilibrative nucleoside transporter 1|equilibrative nitrobenzylmercaptopurine riboside (NBMPR)-sensitive nucleoside transporter|nucleoside transporter, es-type|solute carrier family 29 (equilibrative nucleoside transporter), member 1|solute carrier family 29 (nucleoside transporters), member 1', map_location='6p21.1', chromosome='6', genomic_nucleotide_accession_version='NC_000006.12', start_position_on_the_genomic_accession=44219587, end_position_on_the_genomic_accession=44234144, orientation='plus', exon_count=17, OMIM=[602193], no_hdr0=''),
    2033 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=2033, CurrentID=0, Status='live', Symbol='EP300', Aliases=['KAT3B', 'MKHK2', 'RSTS2', 'p300'], description='E1A binding protein p300', other_designations='histone acetyltransferase p300|E1A-associated protein p300|E1A-binding protein, 300kD|histone butyryltransferase p300|histone crotonyltransferase p300|p300 HAT|protein 2-hydroxyisobutyryltransferase p300|protein propionyltransferase p300', map_location='22q13.2', chromosome='22', genomic_nucleotide_accession_version='NC_000022.11', start_position_on_the_genomic_accession=41092592, end_position_on_the_genomic_accession=41180077, orientation='plus', exon_count=31, OMIM=[602700], no_hdr0=''),
    2034 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=2034, CurrentID=0, Status='live', Symbol='EPAS1', Aliases=['ECYT4', 'HIF2A', 'HLF', 'MOP2', 'PASD2', 'bHLHe73'], description='endothelial PAS domain protein 1', other_designations='endothelial PAS domain-containing protein 1|EPAS-1|HIF-1-alpha-like factor|HIF-1alpha-like factor|HIF-2-alpha|HIF2-alpha|PAS domain-containing protein 2|basic-helix-loop-helix-PAS protein MOP2|class E basic helix-loop-helix protein 73|hypoxia-inducible factor 2 alpha|member of PAS protein 2', map_location='2p21', chromosome='2', genomic_nucleotide_accession_version='NC_000002.12', start_position_on_the_genomic_accession=46297407, end_position_on_the_genomic_accession=46386697, orientation='plus', exon_count=17, OMIM=[603349], no_hdr0=''),
    2035 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=2035, CurrentID=0, Status='live', Symbol='EPB41', Aliases=['4.1R', 'EL1', 'HE'], description='erythrocyte membrane protein band 4.1', other_designations='protein 4.1|EPB4.1|P4.1|band 4.1|elliptocytosis 1, RH-linked|erythrocyte surface protein band 4.1', map_location='1p35.3', chromosome='1', genomic_nucleotide_accession_version='NC_000001.11', start_position_on_the_genomic_accession=28887100, end_position_on_the_genomic_accession=29120041, orientation='plus', exon_count=28, OMIM=[130500], no_hdr0=''),
    2036 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=2036, CurrentID=0, Status='live', Symbol='EPB41L1', Aliases=['4.1N', 'MRD11'], description='erythrocyte membrane protein band 4.1 like 1', other_designations='band 4.1-like protein 1|neuron-type nonerythroid protein 4.1|neuronal protein 4.1', map_location='20q11.23', chromosome='20', genomic_nucleotide_accession_version='NC_000020.11', start_position_on_the_genomic_accession=36064891, end_position_on_the_genomic_accession=36232799, orientation='plus', exon_count=36, OMIM=[602879], no_hdr0=''),
    2037 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=2037, CurrentID=0, Status='live', Symbol='EPB41L2', Aliases=['4.1-G', '4.1G'], description='erythrocyte membrane protein band 4.1 like 2', other_designations='band 4.1-like protein 2|erythrocyte membrane protein band 4.1 like-protein 2|generally expressed protein 4.1', map_location='6q23.1-q23.2', chromosome='6', genomic_nucleotide_accession_version='NC_000006.12', start_position_on_the_genomic_accession=130827955, end_position_on_the_genomic_accession=131063251, orientation='minus', exon_count=31, OMIM=[603237], no_hdr0=''),
    2038 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=2038, CurrentID=0, Status='live', Symbol='EPB42', Aliases=['PA', 'SPH5'], description='erythrocyte membrane protein band 4.2', other_designations='erythrocyte membrane protein band 4.2|P4.2|erythrocyte protein 4.2|erythrocyte surface protein band 4.2', map_location='15q15.2', chromosome='15', genomic_nucleotide_accession_version='NC_000015.10', start_position_on_the_genomic_accession=43197227, end_position_on_the_genomic_accession=43225856, orientation='minus', exon_count=16, OMIM=[177070], no_hdr0=''),
    2039 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=2039, CurrentID=0, Status='live', Symbol='DMTN', Aliases=['DMT', 'EPB49'], description='dematin actin binding protein', other_designations='dematin|erythrocyte membrane protein band 4.9 (dematin)', map_location='8p21.3', chromosome='8', genomic_nucleotide_accession_version='NC_000008.11', start_position_on_the_genomic_accession=22048931, end_position_on_the_genomic_accession=22082525, orientation='plus', exon_count=21, OMIM=[125305], no_hdr0=''),
    2040 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=2040, CurrentID=0, Status='live', Symbol='STOM', Aliases=['BND7', 'EPB7', 'EPB72'], description='stomatin', other_designations='erythrocyte band 7 integral membrane protein|erythrocyte membrane protein band 7.2 (stomatin)|erythrocyte surface protein band 7.2|protein 7.2b', map_location='9q33.2', chromosome='9', genomic_nucleotide_accession_version='NC_000009.12', start_position_on_the_genomic_accession=121338987, end_position_on_the_genomic_accession=121370250, orientation='minus', exon_count=8, OMIM=[133090], no_hdr0=''),
    2041 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=2041, CurrentID=0, Status='live', Symbol='EPHA1', Aliases=['EPH', 'EPHT', 'EPHT1'], description='EPH receptor A1', other_designations='ephrin type-A receptor 1|eph tyrosine kinase 1|erythropoietin-producing hepatoma amplified sequence|erythropoietin-producing hepatoma receptor|hEpha1|oncogene EPH|soluble EPHA1 variant 1|soluble EPHA1 variant 2|tyrosine-protein kinase receptor EPH', map_location='7q34-q35', chromosome='7', genomic_nucleotide_accession_version='NC_000007.14', start_position_on_the_genomic_accession=143390813, end_position_on_the_genomic_accession=143408865, orientation='minus', exon_count=18, OMIM=[179610], no_hdr0=''),
    2042 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=2042, CurrentID=0, Status='live', Symbol='EPHA3', Aliases=['EK4', 'ETK', 'ETK1', 'HEK', 'HEK4', 'TYRO4'], description='EPH receptor A3', other_designations='ephrin type-A receptor 3|EPH-like kinase 4|TYRO4 protein tyrosine kinase|eph-like tyrosine kinase 1|human embryo kinase 1|testicular tissue protein Li 64|tyrosine-protein kinase receptor ETK1', map_location='3p11.1', chromosome='3', genomic_nucleotide_accession_version='NC_000003.12', start_position_on_the_genomic_accession=89107621, end_position_on_the_genomic_accession=89482134, orientation='plus', exon_count=17, OMIM=[179611], no_hdr0=''),
    2043 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=2043, CurrentID=0, Status='live', Symbol='EPHA4', Aliases=['EK8', 'HEK8', 'SEK', 'TYRO1'], description='EPH receptor A4', other_designations='ephrin type-A receptor 4|EPH-like kinase 8|TYRO1 protein tyrosine kinase|receptor protein-tyrosine kinase HEK8|tyrosine-protein kinase TYRO1|tyrosine-protein kinase receptor SEK', map_location='2q36.1', chromosome='2', genomic_nucleotide_accession_version='NC_000002.12', start_position_on_the_genomic_accession=221418027, end_position_on_the_genomic_accession=221574202, orientation='minus', exon_count=19, OMIM=[602188], no_hdr0=''),
    2044 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=2044, CurrentID=0, Status='live', Symbol='EPHA5', Aliases=['CEK7', 'EHK-1', 'EHK1', 'EK7', 'HEK7', 'TYRO4'], description='EPH receptor A5', other_designations='ephrin type-A receptor 5|EPH homology kinase 1|EPH-like kinase 7|brain-specific kinase|epididymis secretory sperm binding protein|receptor protein-tyrosine kinase HEK7|tyrosine-protein kinase receptor EHK-1', map_location='4q13.1-q13.2', chromosome='4', genomic_nucleotide_accession_version='NC_000004.12', start_position_on_the_genomic_accession=65319567, end_position_on_the_genomic_accession=65670489, orientation='minus', exon_count=19, OMIM=[600004], no_hdr0=''),
    2045 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=2045, CurrentID=0, Status='live', Symbol='EPHA7', Aliases=['EHK-3', 'EHK3', 'EK11', 'HEK11'], description='EPH receptor A7', other_designations='ephrin type-A receptor 7|EPH homology kinase 3|EPH-like kinase 11|Eph homology kinase-3|receptor protein-tyrosine kinase HEK11|tyrosine-protein kinase receptor EHK-3', map_location='6q16.1', chromosome='6', genomic_nucleotide_accession_version='NC_000006.12', start_position_on_the_genomic_accession=93240020, end_position_on_the_genomic_accession=93419584, orientation='minus', exon_count=21, OMIM=[602190], no_hdr0=''),
    2046 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=2046, CurrentID=0, Status='live', Symbol='EPHA8', Aliases=['EEK', 'EK3', 'HEK3'], description='EPH receptor A8', other_designations='ephrin type-A receptor 8|EPH- and ELK-related kinase|EPH- and ELK-related tyrosine kinase|EPH-like kinase 3|hydroxyaryl-protein kinase|protein-tyrosine kinase|tyrosine-protein kinase receptor EEK|tyrosylprotein kinase', map_location='1p36.12', chromosome='1', genomic_nucleotide_accession_version='NC_000001.11', start_position_on_the_genomic_accession=22563489, end_position_on_the_genomic_accession=22603595, orientation='plus', exon_count=24, OMIM=[176945], no_hdr0=''),
    2047 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=2047, CurrentID=0, Status='live', Symbol='EPHB1', Aliases=['ELK', 'EPHT2', 'Hek6', 'NET'], description='EPH receptor B1', other_designations='ephrin type-B receptor 1|EK6|EPH-like kinase 6|eph tyrosine kinase 2|neuronally-expressed EPH-related tyrosine kinase|soluble EPHB1 variant 1|tyrosine-protein kinase receptor EPH-2', map_location='3q22.2', chromosome='3', genomic_nucleotide_accession_version='NC_000003.12', start_position_on_the_genomic_accession=134595264, end_position_on_the_genomic_accession=135260467, orientation='plus', exon_count=23, OMIM=[600600], no_hdr0=''),
    2048 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=2048, CurrentID=0, Status='live', Symbol='EPHB2', Aliases=['BDPLT22', 'CAPB', 'DRT', 'EK5', 'EPHT3', 'ERK', 'Hek5', 'PCBC', 'Tyro5'], description='EPH receptor B2', other_designations='ephrin type-B receptor 2|EPH-like kinase 5|developmentally-regulated Eph-related tyrosine kinase|elk-related tyrosine kinase|eph tyrosine kinase 3|protein-tyrosine kinase HEK5|renal carcinoma antigen NY-REN-47|tyrosine-protein kinase TYRO5|tyrosine-protein kinase receptor EPH-3', map_location='1p36.12', chromosome='1', genomic_nucleotide_accession_version='NC_000001.11', start_position_on_the_genomic_accession=22710770, end_position_on_the_genomic_accession=22921500, orientation='plus', exon_count=17, OMIM=[600997], no_hdr0=''),
    2049 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=2049, CurrentID=0, Status='live', Symbol='EPHB3', Aliases=['EK2', 'ETK2', 'HEK2', 'TYRO6'], description='EPH receptor B3', other_designations='ephrin type-B receptor 3|EPH-like tyrosine kinase 2|embryonic kinase 2|human embryo kinase 2|tyrosine-protein kinase TYRO6', map_location='3q27.1', chromosome='3', genomic_nucleotide_accession_version='NC_000003.12', start_position_on_the_genomic_accession=184561785, end_position_on_the_genomic_accession=184582408, orientation='plus', exon_count=16, OMIM=[601839], no_hdr0=''),
    2050 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=2050, CurrentID=0, Status='live', Symbol='EPHB4', Aliases=['CMAVM2', 'HFASD', 'HTK', 'LMPHM7', 'MYK1', 'TYRO11'], description='EPH receptor B4', other_designations='ephrin type-B receptor 4|ephrin receptor EphB4|hepatoma transmembrane kinase|soluble EPHB4 variant 1|soluble EPHB4 variant 2|soluble EPHB4 variant 3|tyrosine-protein kinase TYRO11|tyrosine-protein kinase receptor HTK', map_location='7q22.1', chromosome='7', genomic_nucleotide_accession_version='NC_000007.14', start_position_on_the_genomic_accession=100802565, end_position_on_the_genomic_accession=100827523, orientation='minus', exon_count=17, OMIM=[600011], no_hdr0=''),
    2051 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=2051, CurrentID=0, Status='live', Symbol='EPHB6', Aliases=['HEP'], description='EPH receptor B6', other_designations='ephrin type-B receptor 6|human kinase-defective Eph-family receptor protein|tyrosine-protein kinase-defective receptor EPH-6', map_location='7q34', chromosome='7', genomic_nucleotide_accession_version='NC_000007.14', start_position_on_the_genomic_accession=142854639, end_position_on_the_genomic_accession=142871093, orientation='plus', exon_count=21, OMIM=[602757], no_hdr0=''),
    2052 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=2052, CurrentID=0, Status='live', Symbol='EPHX1', Aliases=['EPHX', 'EPOX', 'HYL1', 'MEH'], description='epoxide hydrolase 1', other_designations='epoxide hydrolase 1|epoxide hydratase|epoxide hydrolase 1 microsomal|epoxide hydrolase 1, microsomal (xenobiotic)', map_location='1q42.12', chromosome='1', genomic_nucleotide_accession_version='NC_000001.11', start_position_on_the_genomic_accession=225810124, end_position_on_the_genomic_accession=225845563, orientation='plus', exon_count=11, OMIM=[132810], no_hdr0=''),
    2053 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=2053, CurrentID=0, Status='live', Symbol='EPHX2', Aliases=['ABHD20', 'CEH', 'SEH'], description='epoxide hydrolase 2', other_designations='bifunctional epoxide hydrolase 2|epoxide hydratase|epoxide hydrolase 2, cytoplasmic|epoxide hydrolase 2, cytosolic|epoxide hydrolase, soluble', map_location='8p21.2-p21.1', chromosome='8', genomic_nucleotide_accession_version='NC_000008.11', start_position_on_the_genomic_accession=27491143, end_position_on_the_genomic_accession=27597559, orientation='plus', exon_count=22, OMIM=[132811], no_hdr0=''),
    2054 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=2054, CurrentID=0, Status='live', Symbol='STX2', Aliases=['EPIM', 'EPMA', 'STX2B', 'STX2C', 'STX2'], description='syntaxin 2', other_designations='syntaxin-2|epimorphin', map_location='12q24.33', chromosome='12', genomic_nucleotide_accession_version='NC_000012.12', start_position_on_the_genomic_accession=130789600, end_position_on_the_genomic_accession=130839274, orientation='minus', exon_count=17, OMIM=[132350], no_hdr0=''),
    2055 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=2055, CurrentID=0, Status='live', Symbol='CLN8', Aliases=['C8orf61', 'EPMR', 'TLCD6'], description='CLN8 transmembrane ER and ERGIC protein', other_designations='protein CLN8|ceroid-lipofuscinosis, neuronal 8', map_location='8p23.3', chromosome='8', genomic_nucleotide_accession_version='NC_000008.11', start_position_on_the_genomic_accession=1755778, end_position_on_the_genomic_accession=1786570, orientation='plus', exon_count=7, OMIM=[607837], no_hdr0=''),
    2056 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=2056, CurrentID=0, Status='live', Symbol='EPO', Aliases=['DBAL', 'ECYT5', 'EP', 'MVCD2'], description='erythropoietin', other_designations='erythropoietin|epoetin', map_location='7q22.1', chromosome='7', genomic_nucleotide_accession_version='NC_000007.14', start_position_on_the_genomic_accession=100720468, end_position_on_the_genomic_accession=100723700, orientation='plus', exon_count=5, OMIM=[133170], no_hdr0=''),
    2057 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=2057, CurrentID=0, Status='live', Symbol='EPOR', Aliases=['EPO-R'], description='erythropoietin receptor', other_designations='erythropoietin receptor|truncated erythropoietin receptor', map_location='19p13.2', chromosome='19', genomic_nucleotide_accession_version='NC_000019.10', start_position_on_the_genomic_accession=11377207, end_position_on_the_genomic_accession=11384314, orientation='minus', exon_count=8, OMIM=[133171], no_hdr0=''),
    2058 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=2058, CurrentID=0, Status='live', Symbol='EPRS1', Aliases=['EARS', 'EPRS', 'GLUPRORS', 'HLD15', 'PARS', 'PIG32', 'QARS', 'QPRS'], description='glutamyl-prolyl-tRNA synthetase 1', other_designations='bifunctional glutamate/proline--tRNA ligase|bifunctional aminoacyl-tRNA synthetase|cell proliferation-inducing gene 32 protein|glutamate tRNA ligase|glutamatyl-prolyl-tRNA synthetase|glutaminyl-tRNA synthetase|proliferation-inducing gene 32 protein|proliferation-inducing protein 32|proline-tRNA ligase|prolyl-tRNA synthetase', map_location='1q41', chromosome='1', genomic_nucleotide_accession_version='NC_000001.11', start_position_on_the_genomic_accession=219968600, end_position_on_the_genomic_accession=220046505, orientation='minus', exon_count=33, OMIM=[138295], no_hdr0=''),
    2059 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=2059, CurrentID=0, Status='live', Symbol='EPS8', Aliases=['DFNB102'], description='epidermal growth factor receptor pathway substrate 8', other_designations='epidermal growth factor receptor kinase substrate 8', map_location='12p12.3', chromosome='12', genomic_nucleotide_accession_version='NC_000012.12', start_position_on_the_genomic_accession=15620134, end_position_on_the_genomic_accession=15789388, orientation='minus', exon_count=26, OMIM=[600206], no_hdr0=''),
    2060 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=2060, CurrentID=0, Status='live', Symbol='EPS15', Aliases=['AF-1P', 'AF1P', 'MLLT5'], description='epidermal growth factor receptor pathway substrate 15', other_designations='epidermal growth factor receptor substrate 15|ALL1 fused gene from chromosome 1|protein AF-1p', map_location='1p32.3', chromosome='1', genomic_nucleotide_accession_version='NC_000001.11', start_position_on_the_genomic_accession=51354263, end_position_on_the_genomic_accession=51519275, orientation='minus', exon_count=26, OMIM=[600051], no_hdr0=''),
    2063 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=2063, CurrentID=0, Status='live', Symbol='NR2F6', Aliases=['EAR-2', 'EAR2', 'ERBAL2'], description='nuclear receptor subfamily 2 group F member 6', other_designations='nuclear receptor subfamily 2 group F member 6|ERBA-related gene-2|V-erbA-related protein 2|nuclear receptor V-erbA-related|v-erb-a avian erythroblastic leukemia viral oncogene homolog-like 2', map_location='19p13.11', chromosome='19', genomic_nucleotide_accession_version='NC_000019.10', start_position_on_the_genomic_accession=17231883, end_position_on_the_genomic_accession=17245919, orientation='minus', exon_count=4, OMIM=[132880], no_hdr0=''),
    2064 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=2064, CurrentID=0, Status='live', Symbol='ERBB2', Aliases=['CD340', 'HER-2', 'HER-2/neu', 'HER2', 'MLN 19', 'NEU', 'NGL', 'TKR1'], description='erb-b2 receptor tyrosine kinase 2', other_designations='receptor tyrosine-protein kinase erbB-2|c-erb B2/neu protein|herstatin|human epidermal growth factor receptor 2|metastatic lymph node gene 19 protein|neuro/glioblastoma derived oncogene homolog|neuroblastoma/glioblastoma derived oncogene homolog|proto-oncogene Neu|proto-oncogene c-ErbB-2|tyrosine kinase-type cell surface receptor HER2|v-erb-b2 avian erythroblastic leukemia viral oncogene homolog 2|v-erb-b2 avian erythroblastic leukemia viral oncoprotein 2|v-erb-b2 erythroblastic leukemia viral oncogene homolog 2, neuro/glioblastoma derived oncogene homolog', map_location='17q12', chromosome='17', genomic_nucleotide_accession_version='NC_000017.11', start_position_on_the_genomic_accession=39688094, end_position_on_the_genomic_accession=39728660, orientation='plus', exon_count=35, OMIM=[164870], no_hdr0=''),
    2065 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=2065, CurrentID=0, Status='live', Symbol='ERBB3', Aliases=['ErbB-3', 'FERLK', 'HER3', 'LCCS2', 'MDA-BF-1', 'c-erbB-3', 'c-erbB3', 'erbB3-S', 'p180-ErbB3', 'p45-sErbB3', 'p85-sErbB3'], description='erb-b2 receptor tyrosine kinase 3', other_designations='receptor tyrosine-protein kinase erbB-3|human epidermal growth factor receptor 3|proto-oncogene-like protein c-ErbB-3|tyrosine kinase-type cell surface receptor HER3|v-erb-b2 avian erythroblastic leukemia viral oncogene homolog 3', map_location='12q13.2', chromosome='12', genomic_nucleotide_accession_version='NC_000012.12', start_position_on_the_genomic_accession=56080108, end_position_on_the_genomic_accession=56103505, orientation='plus', exon_count=28, OMIM=[190151], no_hdr0=''),
    2066 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=2066, CurrentID=0, Status='live', Symbol='ERBB4', Aliases=['ALS19', 'HER4', 'p180erbB4'], description='erb-b2 receptor tyrosine kinase 4', other_designations='receptor tyrosine-protein kinase erbB-4|avian erythroblastic leukemia viral (v-erb-b2) oncogene homolog 4|human epidermal growth factor receptor 4|proto-oncogene-like protein c-ErbB-4|tyrosine kinase-type cell surface receptor HER4|v-erb-a erythroblastic leukemia viral oncogene homolog 4|v-erb-b2 avian erythroblastic leukemia viral oncogene homolog 4', map_location='2q34', chromosome='2', genomic_nucleotide_accession_version='NC_000002.12', start_position_on_the_genomic_accession=211375717, end_position_on_the_genomic_accession=212538802, orientation='minus', exon_count=31, OMIM=[600543], no_hdr0=''),
    2067 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=2067, CurrentID=0, Status='live', Symbol='ERCC1', Aliases=['COFS4', 'RAD10', 'UV20'], description='ERCC excision repair 1, endonuclease non-catalytic subunit', other_designations='DNA excision repair protein ERCC-1|excision repair cross-complementation group 1|excision repair cross-complementing rodent repair deficiency, complementation group 1 (includes overlapping antisense sequence)', map_location='19q13.32', chromosome='19', genomic_nucleotide_accession_version='NC_000019.10', start_position_on_the_genomic_accession=45407334, end_position_on_the_genomic_accession=45451547, orientation='minus', exon_count=13, OMIM=[126380], no_hdr0=''),
    2068 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=2068, CurrentID=0, Status='live', Symbol='ERCC2', Aliases=['COFS2', 'EM9', 'TFIIH', 'TTD', 'TTD1', 'XPD'], description='ERCC excision repair 2, TFIIH core complex helicase subunit', other_designations='general transcription and DNA repair factor IIH helicase subunit XPD|BTF2 p80|CXPD|DNA excision repair protein ERCC-2|DNA repair protein complementing XP-D cells|TFIIH 80 kDa subunit|TFIIH basal transcription factor complex 80 kDa subunit|TFIIH basal transcription factor complex helicase XPB subunit|TFIIH basal transcription factor complex helicase XPD subunit|TFIIH basal transcription factor complex helicase subunit|TFIIH p80|TFIIH subunit XPD|basic transcription factor 2 80 kDa subunit|excision repair cross-complementation group 2|excision repair cross-complementing rodent repair deficiency, complementation group 2|xeroderma pigmentosum complementary group D|xeroderma pigmentosum group D-complementing protein', map_location='19q13.32', chromosome='19', genomic_nucleotide_accession_version='NC_000019.10', start_position_on_the_genomic_accession=45349837, end_position_on_the_genomic_accession=45370647, orientation='minus', exon_count=25, OMIM=[126340], no_hdr0=''),
    2069 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=2069, CurrentID=0, Status='live', Symbol='EREG', Aliases=['EPR', 'ER', 'Ep'], description='epiregulin', other_designations='proepiregulin', map_location='4q13.3', chromosome='4', genomic_nucleotide_accession_version='NC_000004.12', start_position_on_the_genomic_accession=74365145, end_position_on_the_genomic_accession=74388749, orientation='plus', exon_count=5, OMIM=[602061], no_hdr0=''),
    2070 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=2070, CurrentID=0, Status='live', Symbol='EYA4', Aliases=['CMD1J', 'DFNA10'], description='EYA transcriptional coactivator and phosphatase 4', other_designations='eyes absent homolog 4|dJ78N10.1 (eyes absent)|eyes absent-like protein 4', map_location='6q23.2', chromosome='6', genomic_nucleotide_accession_version='NC_000006.12', start_position_on_the_genomic_accession=133240340, end_position_on_the_genomic_accession=133532128, orientation='plus', exon_count=22, OMIM=[603550], no_hdr0=''),
    2071 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=2071, CurrentID=0, Status='live', Symbol='ERCC3', Aliases=['BTF2', 'GTF2H', 'RAD25', 'TFIIH', 'TTD2', 'XPB'], description='ERCC excision repair 3, TFIIH core complex helicase subunit', other_designations='general transcription and DNA repair factor IIH helicase subunit XPB|BTF2 p89|DNA excision repair protein ERCC-3|DNA repair helicase|DNA repair protein complementing XP-B cells|TFIIH 89 kDa subunit|TFIIH basal transcription factor complex 89 kDa subunit|TFIIH basal transcription factor complex helicase XPB subunit|TFIIH p89|TFIIH subunit XPB|basic transcription factor 2 89 kDa subunit|excision repair cross-complementation group 3|excision repair cross-complementing rodent repair deficiency, complementation group 3|xeroderma pigmentosum group B-complementing protein|xeroderma pigmentosum, complementation group B', map_location='2q14.3', chromosome='2', genomic_nucleotide_accession_version='NC_000002.12', start_position_on_the_genomic_accession=127257290, end_position_on_the_genomic_accession=127294166, orientation='minus', exon_count=15, OMIM=[133510], no_hdr0=''),
    2072 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=2072, CurrentID=0, Status='live', Symbol='ERCC4', Aliases=['ERCC11', 'FANCQ', 'RAD1', 'XFEPS', 'XPF'], description='ERCC excision repair 4, endonuclease catalytic subunit', other_designations='DNA repair endonuclease XPF|DNA excision repair protein ERCC-4|DNA repair protein complementing XP-F cells|excision repair cross-complementation group 4|excision repair cross-complementing rodent repair deficiency, complementation group 4|excision-repair, complementing defective, in Chinese hamster|xeroderma pigmentosum group F-complementing protein|xeroderma pigmentosum, complementation group F', map_location='16p13.12', chromosome='16', genomic_nucleotide_accession_version='NC_000016.10', start_position_on_the_genomic_accession=13920137, end_position_on_the_genomic_accession=13952348, orientation='plus', exon_count=13, OMIM=[133520], no_hdr0=''),
    2073 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=2073, CurrentID=0, Status='live', Symbol='ERCC5', Aliases=['COFS3-201', 'ERCM2', 'UVDR', 'XPG', 'XPGC', 'ERCC5'], description='ERCC excision repair 5, endonuclease', other_designations='DNA repair protein complementing XP-G cells|DNA excision repair protein ERCC-5|XPG-complementing protein|excision repair cross-complementation group 5|excision repair cross-complementing rodent repair deficiency, complementation group 5|xeroderma pigmentosum, complementation group G', map_location='13q33.1', chromosome='13', genomic_nucleotide_accession_version='NC_000013.11', start_position_on_the_genomic_accession=102846032, end_position_on_the_genomic_accession=102875995, orientation='plus', exon_count=15, OMIM=[133530], no_hdr0=''),
    2074 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=2074, CurrentID=0, Status='live', Symbol='ERCC6', Aliases=['ARMD5', 'CKN2', 'COFS', 'COFS1', 'CSB', 'CSB-PGBD3', 'POF11', 'RAD26', 'UVSS1'], description='ERCC excision repair 6, chromatin remodeling factor', other_designations='DNA excision repair protein ERCC-6|ERCC6-PGBD3 fusion protein|ATP-dependent helicase ERCC6|Chimeric CSB-PGBD3 protein|Chimeric ERCC6-PGBD3 protein|Cockayne syndrome group B protein|cockayne syndrome protein CSB|excision repair cross-complementation group 6|excision repair cross-complementing rodent repair deficiency, complementation group 6', map_location='10q11.23', chromosome='10', genomic_nucleotide_accession_version='NC_000010.11', start_position_on_the_genomic_accession=49434881, end_position_on_the_genomic_accession=49539538, orientation='minus', exon_count=23, OMIM=[609413], no_hdr0=''),
    2077 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=2077, CurrentID=0, Status='live', Symbol='ERF', Aliases=['CHYTS', 'CRS4', 'PE-2', 'PE2'], description='ETS2 repressor factor', other_designations='ETS domain-containing transcription factor ERF', map_location='19q13.2', chromosome='19', genomic_nucleotide_accession_version='NC_000019.10', start_position_on_the_genomic_accession=42247569, end_position_on_the_genomic_accession=42255128, orientation='minus', exon_count=8, OMIM=[611888], no_hdr0=''),
    2078 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=2078, CurrentID=0, Status='live', Symbol='ERG', Aliases=['erg-3', 'p55'], description='ETS transcription factor ERG', other_designations='transcriptional regulator ERG|ERG, ETS transcription factor|FUS/ERG fusion protein|TMPRSS2/ERG fusion|erythroblast transformation-specific transcription factor ERG variant 10|ets-related|transcriptional regulator ERG (transforming protein ERG)|v-ets avian erythroblastosis virus E26 oncogene homolog|v-ets avian erythroblastosis virus E26 oncogene related|v-ets erythroblastosis virus E26 oncogene homolog|v-ets erythroblastosis virus E26 oncogene like', map_location='21q22.2', chromosome='21', genomic_nucleotide_accession_version='NC_000021.9', start_position_on_the_genomic_accession=38367261, end_position_on_the_genomic_accession=38661783, orientation='minus', exon_count=17, OMIM=[165080], no_hdr0=''),
    2079 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=2079, CurrentID=0, Status='live', Symbol='ERH', Aliases=['DROER'], description='ERH mRNA splicing and mitosis factor', other_designations='enhancer of rudimentary homolog', map_location='14q24.1', chromosome='14', genomic_nucleotide_accession_version='NC_000014.9', start_position_on_the_genomic_accession=69380128, end_position_on_the_genomic_accession=69398299, orientation='minus', exon_count=4, OMIM=[601191], no_hdr0=''),
    2081 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=2081, CurrentID=0, Status='live', Symbol='ERN1', Aliases=['IRE1', 'IRE1P', 'IRE1a', 'hIRE1p'], description='endoplasmic reticulum to nucleus signaling 1', other_designations='serine/threonine-protein kinase/endoribonuclease IRE1|ER to nucleus signalling 1|inositol-requiring 1|inositol-requiring enzyme 1|inositol-requiring protein 1|ire1-alpha|protein kinase/endoribonuclease', map_location='17q23.3', chromosome='17', genomic_nucleotide_accession_version='NC_000017.11', start_position_on_the_genomic_accession=64039142, end_position_on_the_genomic_accession=64132469, orientation='minus', exon_count=22, OMIM=[604033], no_hdr0=''),
    2086 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=2086, CurrentID=0, Status='live', Symbol='ERV3-1', Aliases=['ERV-R', 'ERV3', 'ERVR', 'HERV-R', 'HERVR', 'envR'], description='endogenous retrovirus group 3 member 1, envelope', other_designations='endogenous retrovirus group 3 member 1 Env polyprotein|ERV-R envelope protein|ERV3-1 envelope protein|HERV-R envelope protein|HERV-R_7q21.2 provirus ancestral Env polyprotein|endogenous retroviral sequence 3|endogenous retrovirus group 3, member 1', map_location='7q11.21', chromosome='7', genomic_nucleotide_accession_version='NC_000007.14', start_position_on_the_genomic_accession=64990356, end_position_on_the_genomic_accession=65006687, orientation='minus', exon_count=4, OMIM=[131170], no_hdr0=''),
    2090 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=2090, CurrentID=0, Status='live', Symbol='ESA4', Aliases=[], description='esterase A4', other_designations='esterase A4', map_location='11q13-q22', chromosome='11', genomic_nucleotide_accession_version='', start_position_on_the_genomic_accession='', end_position_on_the_genomic_accession='', orientation='', exon_count='', OMIM=[133220], no_hdr0=''),
    2091 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=2091, CurrentID=0, Status='live', Symbol='FBL', Aliases=['FIB', 'FLRN', 'Nop1', 'RNU3IP1'], description='fibrillarin', other_designations="rRNA 2'-O-methyltransferase fibrillarin|34 kDa nucleolar scleroderma antigen|34-kD nucleolar scleroderma antigen|RNA, U3 small nucleolar interacting protein 1|U6 snRNA 2'-O-methyltransferase fibrillarin|histone-glutamine methyltransferase", map_location='19q13.2', chromosome='19', genomic_nucleotide_accession_version='NC_000019.10', start_position_on_the_genomic_accession=39834458, end_position_on_the_genomic_accession=39846395, orientation='minus', exon_count=9, OMIM=[134795], no_hdr0=''),
    2097 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=2097, CurrentID=0, Status='live', Symbol='ESB3', Aliases=[], description='esterase B3', other_designations='esterase B3', map_location='', chromosome='16', genomic_nucleotide_accession_version='', start_position_on_the_genomic_accession='', end_position_on_the_genomic_accession='', orientation='', exon_count='', OMIM=[133290], no_hdr0=''),
    2098 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=2098, CurrentID=0, Status='live', Symbol='ESD', Aliases=['FGH'], description='esterase D', other_designations='S-formylglutathione hydrolase|esterase 10|esterase D/formylglutathione hydrolase|methylumbelliferyl-acetate deacetylase|testicular tissue protein Li 66', map_location='13q14.2', chromosome='13', genomic_nucleotide_accession_version='NC_000013.11', start_position_on_the_genomic_accession=46771256, end_position_on_the_genomic_accession=46797700, orientation='minus', exon_count=11, OMIM=[133280], no_hdr0=''),
    2099 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=2099, CurrentID=0, Status='live', Symbol='ESR1', Aliases=['ER', 'ESR', 'ESRA', 'ESTRR', 'Era', 'NR3A1'], description='estrogen receptor 1', other_designations='estrogen receptor|E2 receptor alpha|ER-alpha|estradiol receptor|estrogen nuclear receptor alpha|estrogen receptor alpha E1-E2-1-2|estrogen receptor alpha E1-N2-E2-1-2|nuclear receptor subfamily 3 group A member 1|oestrogen receptor alpha', map_location='6q25.1-q25.2', chromosome='6', genomic_nucleotide_accession_version='NC_000006.12', start_position_on_the_genomic_accession=151654148, end_position_on_the_genomic_accession=152129619, orientation='plus', exon_count=23, OMIM=[133430], no_hdr0=''),
    2100 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=2100, CurrentID=0, Status='live', Symbol='ESR2', Aliases=['ER-BETA', 'ESR-BETA', 'ESRB', 'ESTRB', 'Erb', 'NR3A2', 'ODG8'], description='estrogen receptor 2', other_designations='estrogen receptor beta|estrogen receptor beta 4|estrogen receptor beta splice variant, ERbeta2delta7|estrogen receptor beta splice variant, ERbeta4delta7|estrogen receptor beta splice variant, ERbeta6|estrogen receptor beta splice variant, ERbeta6delta7|estrogen receptor beta splice variant, ERbeta7|estrogen receptor beta splice variant, ERbeta7delta7|estrogen receptor beta splice variant, ERbetaEx. 4L|estrogen receptor beta splice variant, ERbetaEx. 6L|nuclear receptor subfamily 3 group A member 2|oestrogen receptor beta', map_location='14q23.2-q23.3', chromosome='14', genomic_nucleotide_accession_version='NC_000014.9', start_position_on_the_genomic_accession=64226707, end_position_on_the_genomic_accession=64338631, orientation='minus', exon_count=17, OMIM=[601663], no_hdr0=''),
    2101 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=2101, CurrentID=0, Status='live', Symbol='ESRRA', Aliases=['ERR1', 'ERRa', 'ERRalpha', 'ESRL1', 'NR3B1'], description='estrogen related receptor alpha', other_designations='steroid hormone receptor ERR1|ERR-alpha|estrogen receptor-like 1|estrogen-related nuclear receptor alpha|nuclear receptor subfamily 3 group B member 1', map_location='11q13.1', chromosome='11', genomic_nucleotide_accession_version='NC_000011.10', start_position_on_the_genomic_accession=64305524, end_position_on_the_genomic_accession=64316743, orientation='plus', exon_count=8, OMIM=[601998], no_hdr0=''),
    2103 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=2103, CurrentID=0, Status='live', Symbol='ESRRB', Aliases=['DFNB35', 'ERR beta-2', 'ERR2', 'ERRb', 'ERRbeta2', 'ESRL2', 'NR3B2'], description='estrogen related receptor beta', other_designations='steroid hormone receptor ERR2|estrogen receptor-like 2|estrogen-related nuclear receptor beta|nuclear receptor ERRB2|nuclear receptor subfamily 3 group B member 2|orphan nuclear receptor', map_location='14q24.3', chromosome='14', genomic_nucleotide_accession_version='NC_000014.9', start_position_on_the_genomic_accession=76371271, end_position_on_the_genomic_accession=76501839, orientation='plus', exon_count=14, OMIM=[602167], no_hdr0=''),
    2104 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=2104, CurrentID=0, Status='live', Symbol='ESRRG', Aliases=['ERR-gamma', 'ERR3', 'ERRg', 'ERRgamma', 'NR3B3'], description='estrogen related receptor gamma', other_designations='estrogen-related receptor gamma|ERR gamma-2|estrogen receptor-related protein 3|nuclear receptor subfamily 3 group B member 3', map_location='1q41', chromosome='1', genomic_nucleotide_accession_version='NC_000001.11', start_position_on_the_genomic_accession=216503246, end_position_on_the_genomic_accession=217137702, orientation='minus', exon_count=28, OMIM=[602969], no_hdr0=''),
    2107 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=2107, CurrentID=0, Status='live', Symbol='ETF1', Aliases=['D5S1995', 'ERF', 'ERF1', 'RF1', 'SUP45L1', 'TB3-1'], description='eukaryotic translation termination factor 1', other_designations='eukaryotic peptide chain release factor subunit 1|polypeptide chain release factor 1|protein Cl1|sup45 (yeast omnipotent suppressor 45) homolog-like 1', map_location='5q31.2', chromosome='5', genomic_nucleotide_accession_version='NC_000005.10', start_position_on_the_genomic_accession=138506095, end_position_on_the_genomic_accession=138543236, orientation='minus', exon_count=13, OMIM=[600285], no_hdr0=''),
    2108 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=2108, CurrentID=0, Status='live', Symbol='ETFA', Aliases=['EMA', 'GA2', 'MADD'], description='electron transfer flavoprotein subunit alpha', other_designations='electron transfer flavoprotein subunit alpha, mitochondrial|alpha-ETF|electron transfer flavoprotein alpha subunit|electron transfer flavoprotein, alpha polypeptide|epididymis secretory sperm binding protein|glutaric aciduria II', map_location='15q24.2-q24.3', chromosome='15', genomic_nucleotide_accession_version='NC_000015.10', start_position_on_the_genomic_accession=76215353, end_position_on_the_genomic_accession=76311469, orientation='minus', exon_count=13, OMIM=[608053], no_hdr0=''),
    2109 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=2109, CurrentID=0, Status='live', Symbol='ETFB', Aliases=['FP585', 'MADD'], description='electron transfer flavoprotein subunit beta', other_designations='electron transfer flavoprotein subunit beta|beta-ETF|electron transfer flavoprotein beta subunit|electron transfer flavoprotein, beta polypeptide|electron-transferring-flavoprotein, beta polypeptide', map_location='19q13.41', chromosome='19', genomic_nucleotide_accession_version='NC_000019.10', start_position_on_the_genomic_accession=51345155, end_position_on_the_genomic_accession=51366388, orientation='minus', exon_count=7, OMIM=[130410], no_hdr0=''),
    2110 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=2110, CurrentID=0, Status='live', Symbol='ETFDH', Aliases=['ETFQO', 'MADD'], description='electron transfer flavoprotein dehydrogenase', other_designations='electron transfer flavoprotein-ubiquinone oxidoreductase, mitochondrial|ETF dehydrogenase|ETF-QO|ETF-ubiquinone oxidoreductase|electron-transferring-flavoprotein dehydrogenase|mutant electron transfer flavoprotein dehydrogenase', map_location='4q32.1', chromosome='4', genomic_nucleotide_accession_version='NC_000004.12', start_position_on_the_genomic_accession=158672296, end_position_on_the_genomic_accession=158709623, orientation='plus', exon_count=14, OMIM=[231675], no_hdr0=''),
    2113 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=2113, CurrentID=0, Status='live', Symbol='ETS1', Aliases=['ETS-1', 'EWSR2', 'c-ets-1', 'p54'], description='ETS proto-oncogene 1, transcription factor', other_designations='protein C-ets-1|Avian erythroblastosis virus E26 (v-ets) oncogene homolog-1|v-ets avian erythroblastosis virus E2 oncogene homolog 1|v-ets avian erythroblastosis virus E26 oncogene homolog 1', map_location='11q24.3', chromosome='11', genomic_nucleotide_accession_version='NC_000011.10', start_position_on_the_genomic_accession=128458765, end_position_on_the_genomic_accession=128587593, orientation='minus', exon_count=12, OMIM=[164720], no_hdr0=''),
    2114 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=2114, CurrentID=0, Status='live', Symbol='ETS2', Aliases=['ETS2IT1'], description='ETS proto-oncogene 2, transcription factor', other_designations='protein C-ets-2|oncogene ETS-2|v-ets avian erythroblastosis virus E2 oncogene homolog 2|v-ets avian erythroblastosis virus E26 oncogene homolog 2|v-ets erythroblastosis virus E26 oncogene homolog 2', map_location='21q22.2', chromosome='21', genomic_nucleotide_accession_version='NC_000021.9', start_position_on_the_genomic_accession=38805183, end_position_on_the_genomic_accession=38824955, orientation='plus', exon_count=13, OMIM=[164740], no_hdr0=''),
    2115 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=2115, CurrentID=0, Status='live', Symbol='ETV1', Aliases=['ER81'], description='ETS variant transcription factor 1', other_designations='ETS translocation variant 1|ETS variant 1|ets variant gene 1|ets-related protein 81', map_location='7p21.2', chromosome='7', genomic_nucleotide_accession_version='NC_000007.14', start_position_on_the_genomic_accession=13891229, end_position_on_the_genomic_accession=13991425, orientation='minus', exon_count=21, OMIM=[600541], no_hdr0=''),
    2116 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=2116, CurrentID=0, Status='live', Symbol='ETV2', Aliases=['ER71', 'ETSRP71'], description='ETS variant transcription factor 2', other_designations='ETS translocation variant 2|ETS variant 2|ets variant gene 2|ets-related protein 71', map_location='19q13.12', chromosome='19', genomic_nucleotide_accession_version='NC_000019.10', start_position_on_the_genomic_accession=35641175, end_position_on_the_genomic_accession=35644871, orientation='plus', exon_count=7, OMIM=[609358], no_hdr0=''),
    2117 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=2117, CurrentID=0, Status='live', Symbol='ETV3', Aliases=['METS', 'PE-1', 'PE1'], description='ETS variant transcription factor 3', other_designations='ETS translocation variant 3|ETS domain transcriptional repressor PE1|ETS variant 3|ets variant gene 3, ETS family transcriptional repressor|mitogenic Ets transcriptional suppressor', map_location='1q23.1', chromosome='1', genomic_nucleotide_accession_version='NC_000001.11', start_position_on_the_genomic_accession=157121191, end_position_on_the_genomic_accession=157138575, orientation='minus', exon_count=5, OMIM=[164873], no_hdr0=''),
    2118 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=2118, CurrentID=0, Status='live', Symbol='ETV4', Aliases=['E1A-F', 'E1AF', 'PEA3', 'PEAS3'], description='ETS variant transcription factor 4', other_designations='ETS translocation variant 4|ETS variant 4|EWS protein/E1A enhancer binding protein chimera|adenovirus E1A enhancer-binding protein|ets variant gene 4 (E1A enhancer-binding protein, E1AF)|polyomavirus enhancer activator 3 homolog', map_location='17q21.31', chromosome='17', genomic_nucleotide_accession_version='NC_000017.11', start_position_on_the_genomic_accession=43527843, end_position_on_the_genomic_accession=43546340, orientation='minus', exon_count=14, OMIM=[600711], no_hdr0=''),
    2119 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=2119, CurrentID=0, Status='live', Symbol='ETV5', Aliases=['ERM'], description='ETS variant transcription factor 5', other_designations='ETS translocation variant 5|ETS variant 5|ets-related molecule|ets-related protein ERM', map_location='3q27.2', chromosome='3', genomic_nucleotide_accession_version='NC_000003.12', start_position_on_the_genomic_accession=186046314, end_position_on_the_genomic_accession=186109089, orientation='minus', exon_count=13, OMIM=[601600], no_hdr0=''),
    2120 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=2120, CurrentID=0, Status='live', Symbol='ETV6', Aliases=['TEL', 'TEL/ABL', 'THC5'], description='ETS variant transcription factor 6', other_designations='transcription factor ETV6|ETS translocation variant 6|ETS variant 6|ETS-related protein Tel1|TEL1 oncogene|ets variant gene 6 (TEL oncogene)', map_location='12p13.2', chromosome='12', genomic_nucleotide_accession_version='NC_000012.12', start_position_on_the_genomic_accession=11649601, end_position_on_the_genomic_accession=11895386, orientation='plus', exon_count=14, OMIM=[600618], no_hdr0=''),
    2121 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=2121, CurrentID=0, Status='live', Symbol='EVC', Aliases=['DWF-11', 'EVCL', 'EVC'], description='EvC ciliary complex subunit 1', other_designations='ellis-van Creveld syndrome protein|Ellis van Creveld protein|Ellis van Creveld syndrome', map_location='4p16.2', chromosome='4', genomic_nucleotide_accession_version='NC_000004.12', start_position_on_the_genomic_accession=5711199, end_position_on_the_genomic_accession=5829043, orientation='plus', exon_count=30, OMIM=[604831], no_hdr0=''),
    2122 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=2122, CurrentID=0, Status='live', Symbol='MECOM', Aliases=['AML1-EVI-1', 'EVI1', 'KMT8E', 'MDS1', 'MDS1-EVI1', 'PRDM3', 'RUSAT2'], description='MDS1 and EVI1 complex locus', other_designations='histone-lysine N-methyltransferase MECOM|AML1-EVI-1 fusion protein|MDS1 and EVI1 complex locus protein EVI1|MDS1 and EVI1 complex locus protein MDS1|PR domain 3|ecotropic virus integration site 1 protein homolog|myelodysplasia syndrome-associated protein 1|oncogene EVI1|zinc finger protein Evi1', map_location='3q26.2', chromosome='3', genomic_nucleotide_accession_version='NC_000003.12', start_position_on_the_genomic_accession=169083506, end_position_on_the_genomic_accession=169663781, orientation='minus', exon_count=23, OMIM=[165215], no_hdr0=''),
    2123 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=2123, CurrentID=0, Status='live', Symbol='EVI2A', Aliases=['EVDA', 'EVI-2A', 'EVI2'], description='ecotropic viral integration site 2A', other_designations='protein EVI2A|ecotropic viral integration site 2A protein homolog', map_location='17q11.2', chromosome='17', genomic_nucleotide_accession_version='NC_000017.11', start_position_on_the_genomic_accession=31316410, end_position_on_the_genomic_accession=31321622, orientation='minus', exon_count=3, OMIM=[158380], no_hdr0=''),
    2124 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=2124, CurrentID=0, Status='live', Symbol='EVI2B', Aliases=['CD361', 'D17S376', 'EVDB'], description='ecotropic viral integration site 2B', other_designations='protein EVI2B|EVI-2B|ecotropic viral integration site 2B protein homolog', map_location='17q11.2', chromosome='17', genomic_nucleotide_accession_version='NC_000017.11', start_position_on_the_genomic_accession=31303770, end_position_on_the_genomic_accession=31314149, orientation='minus', exon_count=3, OMIM=[158381], no_hdr0=''),
    2125 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=2125, CurrentID=0, Status='live', Symbol='EVPL', Aliases=['EVPK'], description='envoplakin', other_designations='envoplakin|210 kDa cornified envelope precursor protein|210 kDa paraneoplastic pemphigus antigen', map_location='17q25.1', chromosome='17', genomic_nucleotide_accession_version='NC_000017.11', start_position_on_the_genomic_accession=76006845, end_position_on_the_genomic_accession=76027306, orientation='minus', exon_count=22, OMIM=[601590], no_hdr0=''),
    2128 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=2128, CurrentID=0, Status='live', Symbol='EVX1', Aliases=['EVX-1'], description='even-skipped homeobox 1', other_designations='homeobox even-skipped homolog protein 1|eve, even-skipped homeo box homolog 1|eve, even-skipped homeobox homolog 1|even-skipped homeo box 1 (homolog of Drosophila)', map_location='7p15.2', chromosome='7', genomic_nucleotide_accession_version='NC_000007.14', start_position_on_the_genomic_accession=27242802, end_position_on_the_genomic_accession=27247830, orientation='plus', exon_count=4, OMIM=[142996], no_hdr0=''),
    2130 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=2130, CurrentID=0, Status='live', Symbol='EWSR1', Aliases=['EWS', 'EWS-FLI1', 'bK984G1.4'], description='EWS RNA binding protein 1', other_designations='RNA-binding protein EWS|EWS RNA-binding protein variant 6|Ewing sarcoma breakpoint region 1|Ewings sarcoma EWS-Fli1 (type 1) oncogene', map_location='22q12.2', chromosome='22', genomic_nucleotide_accession_version='NC_000022.11', start_position_on_the_genomic_accession=29268254, end_position_on_the_genomic_accession=29300523, orientation='plus', exon_count=19, OMIM=[133450], no_hdr0=''),
    2131 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=2131, CurrentID=0, Status='live', Symbol='EXT1', Aliases=['EXT', 'LGCR', 'LGS', 'TRPS2', 'TTV'], description='exostosin glycosyltransferase 1', other_designations='exostosin-1|Glucuronosyl-N-acetylglucosaminyl-proteoglycan 4-alpha-N- acetylglucosaminyltransferase|Langer-Giedion syndrome chromosome region|N-acetylglucosaminyl-proteoglycan 4-beta-glucuronosyltransferase|exostoses (multiple) 1|glucuronosyl-N-acetylglucosaminyl-proteoglycan/N-acetylglucosaminyl-proteoglycan 4-alpha-N-acetylglucosaminyltransferase|multiple exostoses protein 1|putative tumor suppressor protein EXT1', map_location='8q24.11', chromosome='8', genomic_nucleotide_accession_version='NC_000008.11', start_position_on_the_genomic_accession=117794490, end_position_on_the_genomic_accession=118111826, orientation='minus', exon_count=11, OMIM=[608177], no_hdr0=''),
    2132 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=2132, CurrentID=0, Status='live', Symbol='EXT2', Aliases=['SOTV', 'SSMS'], description='exostosin glycosyltransferase 2', other_designations='exostosin-2|N-acetylglucosaminyl-proteoglycan 4-beta-glucuronosyltransferase|glucuronosyl-N-acetylglucosaminyl-proteoglycan/N-acetylglucosaminyl-proteoglycan 4-alpha-N-acetylglucosaminyltransferase|multiple exostoses protein 2|multiple exostosis 2|putative tumor suppressor protein EXT2', map_location='11p11.2', chromosome='11', genomic_nucleotide_accession_version='NC_000011.10', start_position_on_the_genomic_accession=44095659, end_position_on_the_genomic_accession=44251962, orientation='plus', exon_count=18, OMIM=[608210], no_hdr0=''),
    2134 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=2134, CurrentID=0, Status='live', Symbol='EXTL1', Aliases=['EXTL'], description='exostosin like glycosyltransferase 1', other_designations='exostosin-like 1|alpha-N-acetylglucosaminyltransferase II|exostoses (multiple)-like 1|exostosin-L|glucuronosyl-N-acetylglucosaminyl-proteoglycan 4-alpha-N- acetylglucosaminyltransferase|glucuronyl-N-acetylglucosaminylproteoglycan alpha-1,4-N- acetylglucosaminyltransferase|multiple exostosis-like protein', map_location='1p36.11', chromosome='1', genomic_nucleotide_accession_version='NC_000001.11', start_position_on_the_genomic_accession=26021775, end_position_on_the_genomic_accession=26036464, orientation='plus', exon_count=12, OMIM=[601738], no_hdr0=''),
    2135 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=2135, CurrentID=0, Status='live', Symbol='EXTL2', Aliases=['EXTR2'], description='exostosin like glycosyltransferase 2', other_designations='exostosin-like 2|EXT-related protein 2|alpha-1,4-N-acetylhexosaminyltransferase EXTL2|alpha-GalNAcT EXTL2|exostoses (multiple)-like 2|glucuronyl-galactosyl-proteoglycan 4-alpha-N-acetylglucosaminyltransferase|processed exostosin-like 2', map_location='1p21.2', chromosome='1', genomic_nucleotide_accession_version='NC_000001.11', start_position_on_the_genomic_accession=100872372, end_position_on_the_genomic_accession=100895411, orientation='minus', exon_count=9, OMIM=[602411], no_hdr0=''),
    2137 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=2137, CurrentID=0, Status='live', Symbol='EXTL3', Aliases=['BOTV', 'EXTL1L', 'EXTR1', 'ISDNA', 'REGR', 'RPR'], description='exostosin like glycosyltransferase 3', other_designations='exostosin-like 3|EXT-related 1|epididymis secretory sperm binding protein|exostoses (multiple)-like 3|exostosin tumor-like 3|glucuronyl-galactosyl-proteoglycan 4-alpha-N-acetylglucosaminyltransferase|hereditary multiple exostoses gene isolog|putative tumor suppressor protein EXTL3|reg receptor', map_location='8p21.1', chromosome='8', genomic_nucleotide_accession_version='NC_000008.11', start_position_on_the_genomic_accession=28607736, end_position_on_the_genomic_accession=28755599, orientation='plus', exon_count=10, OMIM=[605744], no_hdr0=''),
    2138 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=2138, CurrentID=0, Status='live', Symbol='EYA1', Aliases=['BOP', 'BOR', 'BOS1', 'OFC1'], description='EYA transcriptional coactivator and phosphatase 1', other_designations='eyes absent homolog 1', map_location='8q13.3', chromosome='8', genomic_nucleotide_accession_version='NC_000008.11', start_position_on_the_genomic_accession=71197433, end_position_on_the_genomic_accession=71548104, orientation='minus', exon_count=25, OMIM=[601653], no_hdr0=''),
    2139 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=2139, CurrentID=0, Status='live', Symbol='EYA2', Aliases=['EAB1'], description='EYA transcriptional coactivator and phosphatase 2', other_designations='eyes absent homolog 2', map_location='20q13.12', chromosome='20', genomic_nucleotide_accession_version='NC_000020.11', start_position_on_the_genomic_accession=46894843, end_position_on_the_genomic_accession=47188844, orientation='plus', exon_count=16, OMIM=[601654], no_hdr0=''),
    2140 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=2140, CurrentID=0, Status='live', Symbol='EYA3', Aliases=[], description='EYA transcriptional coactivator and phosphatase 3', other_designations='eyes absent homolog 3|eyes absent 3', map_location='1p35.3', chromosome='1', genomic_nucleotide_accession_version='NC_000001.11', start_position_on_the_genomic_accession=27970344, end_position_on_the_genomic_accession=28088671, orientation='minus', exon_count=22, OMIM=[601655], no_hdr0=''),
    2145 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=2145, CurrentID=0, Status='live', Symbol='EZH1', Aliases=['KMT6B'], description='enhancer of zeste 1 polycomb repressive complex 2 subunit', other_designations='histone-lysine N-methyltransferase EZH1|ENX-2|enhancer of zeste homolog 1', map_location='17q21.2', chromosome='17', genomic_nucleotide_accession_version='NC_000017.11', start_position_on_the_genomic_accession=42700275, end_position_on_the_genomic_accession=42745078, orientation='minus', exon_count=21, OMIM=[601674], no_hdr0=''),
    2146 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=2146, CurrentID=0, Status='live', Symbol='EZH2', Aliases=['ENX-1', 'ENX1b', 'KMT6', 'KMT6A', 'WVS', 'WVS2', 'EZH2'], description='enhancer of zeste 2 polycomb repressive complex 2 subunit', other_designations='histone-lysine N-methyltransferase EZH2|enhancer of zeste homolog 2|lysine N-methyltransferase 6', map_location='7q36.1', chromosome='7', genomic_nucleotide_accession_version='NC_000007.14', start_position_on_the_genomic_accession=148807374, end_position_on_the_genomic_accession=148884344, orientation='minus', exon_count=25, OMIM=[601573], no_hdr0=''),
    2147 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=2147, CurrentID=0, Status='live', Symbol='F2', Aliases=['PT', 'RPRGL2', 'THPH1'], description='coagulation factor II, thrombin', other_designations='prothrombin|prepro-coagulation factor II|prothrombin B-chain|thrombin factor II', map_location='11p11.2', chromosome='11', genomic_nucleotide_accession_version='NC_000011.10', start_position_on_the_genomic_accession=46719213, end_position_on_the_genomic_accession=46739506, orientation='plus', exon_count=14, OMIM=[176930], no_hdr0=''),
    2149 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=2149, CurrentID=0, Status='live', Symbol='F2R', Aliases=['CF2R', 'HTR', 'PAR-1', 'PAR1', 'TR'], description='coagulation factor II thrombin receptor', other_designations='proteinase-activated receptor 1|protease-activated receptor 1', map_location='5q13.3', chromosome='5', genomic_nucleotide_accession_version='NC_000005.10', start_position_on_the_genomic_accession=76716126, end_position_on_the_genomic_accession=76735770, orientation='plus', exon_count=3, OMIM=[187930], no_hdr0=''),
    2150 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=2150, CurrentID=0, Status='live', Symbol='F2RL1', Aliases=['GPR11', 'PAR2'], description='F2R like trypsin receptor 1', other_designations='proteinase-activated receptor 2|G-protein coupled receptor 11|coagulation factor II (thrombin) receptor-like 1|protease-activated receptor 2|thrombin receptor-like 1', map_location='5q13.3', chromosome='5', genomic_nucleotide_accession_version='NC_000005.10', start_position_on_the_genomic_accession=76819030, end_position_on_the_genomic_accession=76835315, orientation='plus', exon_count=3, OMIM=[600933], no_hdr0=''),
    2151 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=2151, CurrentID=0, Status='live', Symbol='F2RL2', Aliases=['PAR-3', 'PAR3'], description='coagulation factor II thrombin receptor like 2', other_designations='proteinase-activated receptor 3|Coagulation factor II receptor-like 2 (protease-actovated receptor 3)|protease-activated receptor 3|thrombin receptor-like 2', map_location='5q13.3', chromosome='5', genomic_nucleotide_accession_version='NC_000005.10', start_position_on_the_genomic_accession=76615482, end_position_on_the_genomic_accession=76623403, orientation='minus', exon_count=2, OMIM=[601919], no_hdr0=''),
    2152 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=2152, CurrentID=0, Status='live', Symbol='F3', Aliases=['CD142', 'TF', 'TFA'], description='coagulation factor III, tissue factor', other_designations='tissue factor|coagulation factor III (thromboplastin, tissue factor)', map_location='1p21.3', chromosome='1', genomic_nucleotide_accession_version='NC_000001.11', start_position_on_the_genomic_accession=94529173, end_position_on_the_genomic_accession=94541759, orientation='minus', exon_count=6, OMIM=[134390], no_hdr0=''),
    2153 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=2153, CurrentID=0, Status='live', Symbol='F5', Aliases=['FVL', 'PCCF', 'RPRGL1', 'THPH2'], description='coagulation factor V', other_designations='coagulation factor V|activated protein c cofactor|coagulation factor V (proaccelerin, labile factor)|coagulation factor V jinjiang A2 domain|factor V Leiden', map_location='1q24.2', chromosome='1', genomic_nucleotide_accession_version='NC_000001.11', start_position_on_the_genomic_accession=169511951, end_position_on_the_genomic_accession=169586630, orientation='minus', exon_count=25, OMIM=[612309], no_hdr0=''),
    2155 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=2155, CurrentID=0, Status='live', Symbol='F7', Aliases=['SPCA'], description='coagulation factor VII', other_designations='coagulation factor VII|FVII coagulation protein|coagulation factor VII (serum prothrombin conversion accelerator)|eptacog alfa|proconvertin', map_location='13q34', chromosome='13', genomic_nucleotide_accession_version='NC_000013.11', start_position_on_the_genomic_accession=113105773, end_position_on_the_genomic_accession=113120685, orientation='plus', exon_count=10, OMIM=[613878], no_hdr0=''),
    2157 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=2157, CurrentID=0, Status='live', Symbol='F8', Aliases=['AHF', 'DXS1253EB', 'F8C', 'FVIII', 'HEMA', 'F8'], description='coagulation factor VIII', other_designations='coagulation factor VIII|antihemophilic factor|coagulation factor VIII A1 domain|coagulation factor VIII C2 domain|coagulation factor VIII, procoagulant component|coagulation factor VIIIc|factor VIII F8B', map_location='Xq28', chromosome='X', genomic_nucleotide_accession_version='NC_000023.11', start_position_on_the_genomic_accession=154835792, end_position_on_the_genomic_accession=155022723, orientation='minus', exon_count=27, OMIM=[300841], no_hdr0=''),
    2158 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=2158, CurrentID=0, Status='live', Symbol='F9', Aliases=['F9 p22', 'FIX', 'HEMB', 'P19', 'PTC', 'THPH8'], description='coagulation factor IX', other_designations='coagulation factor IX|Christmas factor|factor 9|factor IX F9|plasma thromboplastic component|plasma thromboplastin component', map_location='Xq27.1', chromosome='X', genomic_nucleotide_accession_version='NC_000023.11', start_position_on_the_genomic_accession=139530720, end_position_on_the_genomic_accession=139563459, orientation='plus', exon_count=8, OMIM=[300746], no_hdr0=''),
    2159 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=2159, CurrentID=0, Status='live', Symbol='F10', Aliases=['FX', 'FXA'], description='coagulation factor X', other_designations='coagulation factor X|Stuart-Prower factor|factor X|factor Xa|prothrombinase', map_location='13q34', chromosome='13', genomic_nucleotide_accession_version='NC_000013.11', start_position_on_the_genomic_accession=113122799, end_position_on_the_genomic_accession=113149529, orientation='plus', exon_count=8, OMIM=[613872], no_hdr0=''),
    2160 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=2160, CurrentID=0, Status='live', Symbol='F11', Aliases=['FXI', 'PTA'], description='coagulation factor XI', other_designations='coagulation factor XI|coagualtion factor XI|plasma thromboplastin antecedent', map_location='4q35.2', chromosome='4', genomic_nucleotide_accession_version='NC_000004.12', start_position_on_the_genomic_accession=186265964, end_position_on_the_genomic_accession=186290727, orientation='plus', exon_count=15, OMIM=[264900], no_hdr0=''),
    2161 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=2161, CurrentID=0, Status='live', Symbol='F12', Aliases=['HAE3', 'HAEX', 'HAF'], description='coagulation factor XII', other_designations='coagulation factor XII|Hageman factor|beta-factor XIIa part 1|beta-factor XIIa part 2|coagulation factor XIIa heavy chain|coagulation factor XIIa light chain', map_location='5q35.3', chromosome='5', genomic_nucleotide_accession_version='NC_000005.10', start_position_on_the_genomic_accession=177402138, end_position_on_the_genomic_accession=177409564, orientation='minus', exon_count=15, OMIM=[610619], no_hdr0=''),
    2162 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=2162, CurrentID=0, Status='live', Symbol='F13A1', Aliases=['F13A'], description='coagulation factor XIII A chain', other_designations='coagulation factor XIII A chain|FSF, A subunit|TGase|bA525O21.1 (coagulation factor XIII, A1 polypeptide)|coagulation factor XIII, A polypeptide|coagulation factor XIII, A1 polypeptide|coagulation factor XIIIa|factor XIIIa|fibrin stabilizing factor, A subunit|fibrinoligase|protein-glutamine gamma-glutamyltransferase A chain|transglutaminase A chain|transglutaminase. plasma', map_location='6p25.1', chromosome='6', genomic_nucleotide_accession_version='NC_000006.12', start_position_on_the_genomic_accession=6144084, end_position_on_the_genomic_accession=6320662, orientation='minus', exon_count=15, OMIM=[134570], no_hdr0=''),
    2165 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=2165, CurrentID=0, Status='live', Symbol='F13B', Aliases=['FXIIIB'], description='coagulation factor XIII B chain', other_designations='coagulation factor XIII B chain|TGase|coagulation factor XIII, B polypeptide|fibrin-stabilizing factor B subunit|protein-glutamine gamma-glutamyltransferase B chain|transglutaminase B chain', map_location='1q31.3', chromosome='1', genomic_nucleotide_accession_version='NC_000001.11', start_position_on_the_genomic_accession=197038741, end_position_on_the_genomic_accession=197067264, orientation='minus', exon_count=12, OMIM=[134580], no_hdr0=''),
    2166 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=2166, CurrentID=0, Status='live', Symbol='FAAH', Aliases=['FAAH-1', 'PSAB'], description='fatty acid amide hydrolase', other_designations='fatty-acid amide hydrolase 1|anandamide amidohydrolase 1|fatty acid ester hydrolase|oleamide hydrolase 1', map_location='1p33', chromosome='1', genomic_nucleotide_accession_version='NC_000001.11', start_position_on_the_genomic_accession=46394317, end_position_on_the_genomic_accession=46413845, orientation='plus', exon_count=15, OMIM=[602935], no_hdr0=''),
    2167 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=2167, CurrentID=0, Status='live', Symbol='FABP4', Aliases=['A-FABP', 'AFABP', 'ALBP', 'HEL-S-104', 'aP2'], description='fatty acid binding protein 4', other_designations='fatty acid-binding protein, adipocyte|adipocyte fatty acid binding protein|adipocyte lipid-binding protein|adipocyte-type fatty acid-binding protein|epididymis secretory protein Li 104|fatty acid binding protein 4, adipocyte', map_location='8q21.13', chromosome='8', genomic_nucleotide_accession_version='NC_000008.11', start_position_on_the_genomic_accession=81478419, end_position_on_the_genomic_accession=81483233, orientation='minus', exon_count=4, OMIM=[600434], no_hdr0=''),
    2168 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=2168, CurrentID=0, Status='live', Symbol='FABP1', Aliases=['FABPL', 'L-FABP'], description='fatty acid binding protein 1', other_designations='fatty acid-binding protein, liver|fatty acid binding protein 1, liver|liver-type fatty acid-binding protein', map_location='2p11.2', chromosome='2', genomic_nucleotide_accession_version='NC_000002.12', start_position_on_the_genomic_accession=88122982, end_position_on_the_genomic_accession=88128062, orientation='minus', exon_count=4, OMIM=[134650], no_hdr0=''),
    2169 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=2169, CurrentID=0, Status='live', Symbol='FABP2', Aliases=['FABPI', 'I-FABP'], description='fatty acid binding protein 2', other_designations='fatty acid-binding protein, intestinal|fatty acid binding protein 2, intestinal|intestinal-type fatty acid-binding protein', map_location='4q26', chromosome='4', genomic_nucleotide_accession_version='NC_000004.12', start_position_on_the_genomic_accession=119317250, end_position_on_the_genomic_accession=119322138, orientation='minus', exon_count=4, OMIM=[134640], no_hdr0=''),
    2170 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=2170, CurrentID=0, Status='live', Symbol='FABP3', Aliases=['FABP11', 'H-FABP', 'M-FABP', 'MDGI', 'O-FABP'], description='fatty acid binding protein 3', other_designations='fatty acid-binding protein, heart|epididymis secretory sperm binding protein|fatty acid binding protein 11|fatty acid binding protein 3, muscle and heart|heart-type fatty acid-binding protein|mammary-derived growth inhibitor|muscle fatty acid-binding protein', map_location='1p35.2', chromosome='1', genomic_nucleotide_accession_version='NC_000001.11', start_position_on_the_genomic_accession=31359595, end_position_on_the_genomic_accession=31373618, orientation='minus', exon_count=5, OMIM=[134651], no_hdr0=''),
    2171 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=2171, CurrentID=0, Status='live', Symbol='FABP5', Aliases=['E-FABP', 'EFABP', 'KFABP', 'PA-FABP', 'PAFABP'], description='fatty acid binding protein 5', other_designations='fatty acid-binding protein 5|epidermal-type fatty acid-binding protein|fatty acid binding protein 5 (psoriasis-associated)|psoriasis-associated fatty acid-binding protein homolog', map_location='8q21.13', chromosome='8', genomic_nucleotide_accession_version='NC_000008.11', start_position_on_the_genomic_accession=81280536, end_position_on_the_genomic_accession=81284775, orientation='plus', exon_count=4, OMIM=[605168], no_hdr0=''),
    2172 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=2172, CurrentID=0, Status='live', Symbol='FABP6', Aliases=['I-15P', 'I-BABP', 'I-BALB', 'I-BAP', 'ILBP', 'ILBP3', 'ILLBP'], description='fatty acid binding protein 6', other_designations='gastrotropin|GT|fatty acid binding protein 6, ileal|ileal bile acid binding protein|ileal lipid-binding protein|illeal lipid-binding protein|intestinal 15 kDa protein', map_location='5q33.3', chromosome='5', genomic_nucleotide_accession_version='NC_000005.10', start_position_on_the_genomic_accession=160187381, end_position_on_the_genomic_accession=160238722, orientation='plus', exon_count=7, OMIM=[600422], no_hdr0=''),
    2173 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=2173, CurrentID=0, Status='live', Symbol='FABP7', Aliases=['B-FABP', 'BLBP', 'FABPB', 'MRG'], description='fatty acid binding protein 7', other_designations='fatty acid-binding protein, brain|brain lipid-binding protein|brain-type fatty acid-binding protein|hypothetical protein DKFZp547J2313|mammary-derived growth inhibitor-related', map_location='6q22.31', chromosome='6', genomic_nucleotide_accession_version='NC_000006.12', start_position_on_the_genomic_accession=122749201, end_position_on_the_genomic_accession=122784074, orientation='plus', exon_count=5, OMIM=[602965], no_hdr0=''),
    2175 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=2175, CurrentID=0, Status='live', Symbol='FANCA', Aliases=['FA', 'FA-H', 'FA1', 'FAA', 'FACA', 'FAH', 'FANCH'], description='FA complementation group A', other_designations='Fanconi anemia group A protein|Fanconi anemia complementation group A|Fanconi anemia, complementation group H|Fanconi anemia, type 1', map_location='16q24.3', chromosome='16', genomic_nucleotide_accession_version='NC_000016.10', start_position_on_the_genomic_accession=89737549, end_position_on_the_genomic_accession=89816647, orientation='minus', exon_count=44, OMIM=[607139], no_hdr0=''),
    2176 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=2176, CurrentID=0, Status='live', Symbol='FANCC', Aliases=['FA3', 'FAC', 'FACC'], description='FA complementation group C', other_designations='Fanconi anemia group C protein|Fanconi anemia complementation group C', map_location='9q22.32', chromosome='9', genomic_nucleotide_accession_version='NC_000009.12', start_position_on_the_genomic_accession=95099054, end_position_on_the_genomic_accession=95317730, orientation='minus', exon_count=22, OMIM=[613899], no_hdr0=''),
    2177 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=2177, CurrentID=0, Status='live', Symbol='FANCD2', Aliases=['FA-D2', 'FA4', 'FACD', 'FAD', 'FAD2', 'FANCD'], description='FA complementation group D2', other_designations='Fanconi anemia group D2 protein|Fanconi anemia complementation group D2', map_location='3p25.3', chromosome='3', genomic_nucleotide_accession_version='NC_000003.12', start_position_on_the_genomic_accession=10026437, end_position_on_the_genomic_accession=10101932, orientation='plus', exon_count=45, OMIM=[613984], no_hdr0=''),
    2178 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=2178, CurrentID=0, Status='live', Symbol='FANCE', Aliases=['FACE', 'FAE'], description='FA complementation group E', other_designations='Fanconi anemia group E protein|Fanconi anemia complementation group E', map_location='6p21.31', chromosome='6', genomic_nucleotide_accession_version='NC_000006.12', start_position_on_the_genomic_accession=35452338, end_position_on_the_genomic_accession=35467106, orientation='plus', exon_count=10, OMIM=[613976], no_hdr0=''),
    2180 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=2180, CurrentID=0, Status='live', Symbol='ACSL1', Aliases=['ACS1', 'FACL1', 'FACL2', 'LACS', 'LACS1', 'LACS2'], description='acyl-CoA synthetase long chain family member 1', other_designations='long-chain-fatty-acid--CoA ligase 1|LACS 1|LACS 2|acyl-CoA synthetase 1|arachidonate--CoA ligase|fatty-acid-Coenzyme A ligase, long-chain 1|fatty-acid-Coenzyme A ligase, long-chain 2|lignoceroyl-CoA synthase|long-chain acyl-CoA synthetase 1|long-chain acyl-CoA synthetase 2|long-chain fatty acid-CoA ligase 2|long-chain fatty-acid-coenzyme A ligase 1|palmitoyl-CoA ligase 1|palmitoyl-CoA ligase 2|paltimoyl-CoA ligase 1|phytanate--CoA ligase', map_location='4q35.1', chromosome='4', genomic_nucleotide_accession_version='NC_000004.12', start_position_on_the_genomic_accession=184755595, end_position_on_the_genomic_accession=184826593, orientation='minus', exon_count=31, OMIM=[152425], no_hdr0=''),
    2181 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=2181, CurrentID=0, Status='live', Symbol='ACSL3', Aliases=['ACS3', 'FACL3', 'LACS 3', 'LACS3', 'PRO2194'], description='acyl-CoA synthetase long chain family member 3', other_designations='long-chain-fatty-acid--CoA ligase 3|arachidonate--CoA ligase|fatty-acid-Coenzyme A ligase, long-chain 3|lignoceroyl-CoA synthase|long-chain acyl-CoA synthetase 3', map_location='2q36.1', chromosome='2', genomic_nucleotide_accession_version='NC_000002.12', start_position_on_the_genomic_accession=222861036, end_position_on_the_genomic_accession=222944639, orientation='plus', exon_count=17, OMIM=[602371], no_hdr0=''),
    2182 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=2182, CurrentID=0, Status='live', Symbol='ACSL4', Aliases=['ACS4', 'FACL4', 'LACS4', 'MRX63', 'MRX68'], description='acyl-CoA synthetase long chain family member 4', other_designations='long-chain-fatty-acid--CoA ligase 4|acyl-CoA synthetase 4|arachidonate--CoA ligase|fatty-acid-Coenzyme A ligase, long-chain 4|lignoceroyl-CoA synthase|long-chain acyl-CoA synthetase 4|long-chain fatty-acid-Coenzyme A ligase 4', map_location='Xq23', chromosome='X', genomic_nucleotide_accession_version='NC_000023.11', start_position_on_the_genomic_accession=109641335, end_position_on_the_genomic_accession=109733325, orientation='minus', exon_count=18, OMIM=[300157], no_hdr0=''),
    2184 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=2184, CurrentID=0, Status='live', Symbol='FAH', Aliases=[], description='fumarylacetoacetate hydrolase', other_designations='fumarylacetoacetase|FAA|beta-diketonase|epididymis secretory sperm binding protein|fumarylacetoacetate hydrolase (fumarylacetoacetase)', map_location='15q25.1', chromosome='15', genomic_nucleotide_accession_version='NC_000015.10', start_position_on_the_genomic_accession=80152789, end_position_on_the_genomic_accession=80186949, orientation='plus', exon_count=15, OMIM=[613871], no_hdr0=''),
    2185 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=2185, CurrentID=0, Status='live', Symbol='PTK2B', Aliases=['CADTK', 'CAKB', 'FADK2', 'FAK2', 'PKB', 'PTK', 'PYK2', 'RAFTK'], description='protein tyrosine kinase 2 beta', other_designations='protein-tyrosine kinase 2-beta|CAK-beta|FADK 2|PTK2B protein tyrosine kinase 2 beta|calcium-dependent tyrosine kinase|calcium-regulated non-receptor proline-rich tyrosine kinase|cell adhesion kinase beta|focal adhesion kinase 2|proline-rich tyrosine kinase 2|protein kinase B|related adhesion focal tyrosine kinase', map_location='8p21.2', chromosome='8', genomic_nucleotide_accession_version='NC_000008.11', start_position_on_the_genomic_accession=27311478, end_position_on_the_genomic_accession=27459391, orientation='plus', exon_count=39, OMIM=[601212], no_hdr0=''),
    2186 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=2186, CurrentID=0, Status='live', Symbol='BPTF', Aliases=['FAC1', 'FALZ', 'NEDDFL', 'NURF301'], description='bromodomain PHD finger transcription factor', other_designations='nucleosome-remodeling factor subunit BPTF|bromodomain and PHD domain transcription factor|bromodomain and PHD finger-containing transcription factor|fetal Alz-50 clone 1 protein|fetal Alz-50 reactive clone 1|fetal Alzheimer antigen|nucleosome remodeling factor, large subunit', map_location='17q24.2', chromosome='17', genomic_nucleotide_accession_version='NC_000017.11', start_position_on_the_genomic_accession=67825503, end_position_on_the_genomic_accession=67984378, orientation='plus', exon_count=34, OMIM=[601819], no_hdr0=''),
    2187 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=2187, CurrentID=0, Status='live', Symbol='FANCB', Aliases=['FA2', 'FAAP90', 'FAAP95', 'FAB', 'FACB'], description='FA complementation group B', other_designations='Fanconi anemia group B protein|Fanconi anemia complementation group B|Fanconi anemia-associated polypeptide of 95 kDa', map_location='Xp22.2', chromosome='X', genomic_nucleotide_accession_version='NC_000023.11', start_position_on_the_genomic_accession=14690863, end_position_on_the_genomic_accession=14873255, orientation='minus', exon_count=17, OMIM=[300515], no_hdr0=''),
    2188 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=2188, CurrentID=0, Status='live', Symbol='FANCF', Aliases=['FAF'], description='FA complementation group F', other_designations='Fanconi anemia group F protein|Fanconi anemia complementation group F', map_location='11p14.3', chromosome='11', genomic_nucleotide_accession_version='NC_000011.10', start_position_on_the_genomic_accession=22622533, end_position_on_the_genomic_accession=22625823, orientation='minus', exon_count=1, OMIM=[613897], no_hdr0=''),
    2189 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=2189, CurrentID=0, Status='live', Symbol='FANCG', Aliases=['FAG', 'XRCC9'], description='FA complementation group G', other_designations='Fanconi anemia group G protein|DNA repair protein XRCC9|Fanconi anemia complementation group G|X-ray repair complementing defective repair in Chinese hamster cells 9|X-ray repair, complementing defective, in Chinese hamster, 9|truncated Fanconi anemia group G protein', map_location='9p13.3', chromosome='9', genomic_nucleotide_accession_version='NC_000009.12', start_position_on_the_genomic_accession=35073839, end_position_on_the_genomic_accession=35079942, orientation='minus', exon_count=14, OMIM=[602956], no_hdr0=''),
    2191 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=2191, CurrentID=0, Status='live', Symbol='FAP', Aliases=['DPPIVA', 'FAPalpha', 'SIMP', 'FAP'], description='fibroblast activation protein alpha', other_designations='prolyl endopeptidase FAP|170 kDa melanoma membrane-bound gelatinase|dipeptidyl peptidase FAP|gelatine degradation protease FAP|integral membrane serine protease|post-proline cleaving enzyme|seprase|surface-expressed protease', map_location='2q24.2', chromosome='2', genomic_nucleotide_accession_version='NC_000002.12', start_position_on_the_genomic_accession=162170684, end_position_on_the_genomic_accession=162243472, orientation='minus', exon_count=30, OMIM=[600403], no_hdr0=''),
    2192 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=2192, CurrentID=0, Status='live', Symbol='FBLN1', Aliases=['FBLN', 'FIBL1'], description='fibulin 1', other_designations='fibulin-1', map_location='22q13.31', chromosome='22', genomic_nucleotide_accession_version='NC_000022.11', start_position_on_the_genomic_accession=45502883, end_position_on_the_genomic_accession=45601135, orientation='plus', exon_count=20, OMIM=[135820], no_hdr0=''),
    2193 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=2193, CurrentID=0, Status='live', Symbol='FARSA', Aliases=['CML33', 'FARSL', 'FARSLA', 'FRSA', 'PheHA', 'RILDBC2'], description='phenylalanyl-tRNA synthetase subunit alpha', other_designations='phenylalanine--tRNA ligase alpha subunit|pheRS|phenylalanine tRNA ligase 1, alpha, cytoplasmic|phenylalanine--tRNA ligase alpha chain|phenylalanine-tRNA synthetase alpha-subunit|phenylalanine-tRNA synthetase-like, alpha subunit|phenylalanyl-tRNA synthetase alpha chain|phenylalanyl-tRNA synthetase alpha subunit|phenylalanyl-tRNA synthetase-like, alpha subunit', map_location='19p13.13', chromosome='19', genomic_nucleotide_accession_version='NC_000019.10', start_position_on_the_genomic_accession=12922479, end_position_on_the_genomic_accession=12933711, orientation='minus', exon_count=13, OMIM=[602918], no_hdr0=''),
    2194 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=2194, CurrentID=0, Status='live', Symbol='FASN', Aliases=['FAS', 'OA-519', 'SDR27X1'], description='fatty acid synthase', other_designations='fatty acid synthase|short chain dehydrogenase/reductase family 27X, member 1|type I fatty acid synthase', map_location='17q25.3', chromosome='17', genomic_nucleotide_accession_version='NC_000017.11', start_position_on_the_genomic_accession=82078338, end_position_on_the_genomic_accession=82098303, orientation='minus', exon_count=43, OMIM=[600212], no_hdr0=''),
    2195 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=2195, CurrentID=0, Status='live', Symbol='FAT1', Aliases=['CDHF7', 'CDHR8', 'FAT', 'ME5', 'hFat1'], description='FAT atypical cadherin 1', other_designations='protocadherin Fat 1|FAT tumor suppressor 1|cadherin ME5|cadherin family member 7|cadherin-related family member 8|cadherin-related tumor suppressor homolog|protein fat homolog', map_location='4q35.2', chromosome='4', genomic_nucleotide_accession_version='NC_000004.12', start_position_on_the_genomic_accession=186587789, end_position_on_the_genomic_accession=186726696, orientation='minus', exon_count=29, OMIM=[600976], no_hdr0=''),
    2196 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=2196, CurrentID=0, Status='live', Symbol='FAT2', Aliases=['CDHF8', 'CDHR9', 'HFAT2', 'MEGF1', 'SCA45'], description='FAT atypical cadherin 2', other_designations='protocadherin Fat 2|FAT tumor suppressor homolog 2|cadherin family member 8|cadherin-related family member 9|multiple EGF-like domains protein 1|multiple epidermal growth factor-like domains 1|multiple epidermal growth factor-like domains protein 1|protocadherin FAT2', map_location='5q33.1', chromosome='5', genomic_nucleotide_accession_version='NC_000005.10', start_position_on_the_genomic_accession=151504092, end_position_on_the_genomic_accession=151594822, orientation='minus', exon_count=30, OMIM=[604269], no_hdr0=''),
    2197 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=2197, CurrentID=0, Status='live', Symbol='FAU', Aliases=['FAU1', 'Fub1', 'Fubi', 'MNSFbeta', 'RPS30', 'S30', 'asr1'], description='FAU ubiquitin like and ribosomal protein S30 fusion', other_designations='ubiquitin-like protein fubi and ribosomal protein S30|40S ribosomal protein S30|FAU-encoded ubiquitin-like protein|FBR-MuSV-associated ubiquitously expressed|Finkel-Biskis-Reilly murine sarcoma virus (FBR-MuSV) ubiquitously expressed (fox derived)|monoclonal nonspecific suppressor factor beta|ribosomal protein S30|small ribosomal subunit protein eS30|ubiquitin-like-S30 fusion protein', map_location='11q13.1', chromosome='11', genomic_nucleotide_accession_version='NC_000011.10', start_position_on_the_genomic_accession=65120630, end_position_on_the_genomic_accession=65122134, orientation='minus', exon_count=5, OMIM=[134690], no_hdr0=''),
    2199 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=2199, CurrentID=0, Status='live', Symbol='FBLN2', Aliases=[], description='fibulin 2', other_designations='fibulin-2|FIBL-2', map_location='3p25.1', chromosome='3', genomic_nucleotide_accession_version='NC_000003.12', start_position_on_the_genomic_accession=13549125, end_position_on_the_genomic_accession=13638408, orientation='plus', exon_count=19, OMIM=[135821], no_hdr0=''),
    2200 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=2200, CurrentID=0, Status='live', Symbol='FBN1', Aliases=['ACMICD', 'ECTOL1', 'FBN', 'GPHYSD2', 'MASS', 'MFLS', 'MFS1', 'OCTD', 'SGS', 'SSKS', 'WMS', 'WMS2'], description='fibrillin 1', other_designations='fibrillin-1|asprosin|epididymis secretory sperm binding protein|fibrillin 15|fibrillin-1 preproprotein', map_location='15q21.1', chromosome='15', genomic_nucleotide_accession_version='NC_000015.10', start_position_on_the_genomic_accession=48408313, end_position_on_the_genomic_accession=48645709, orientation='minus', exon_count=66, OMIM=[134797], no_hdr0=''),
    2201 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=2201, CurrentID=0, Status='live', Symbol='FBN2', Aliases=['CCA', 'DA9', 'EOMD'], description='fibrillin 2', other_designations='fibrillin-2|fibrillin 5', map_location='5q23.3', chromosome='5', genomic_nucleotide_accession_version='NC_000005.10', start_position_on_the_genomic_accession=128257909, end_position_on_the_genomic_accession=128538245, orientation='minus', exon_count=65, OMIM=[612570], no_hdr0=''),
    2202 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=2202, CurrentID=0, Status='live', Symbol='EFEMP1', Aliases=['DHRD', 'DRAD', 'FBLN3', 'FBNL', 'FIBL-3', 'MLVT', 'MTLV', 'S1-5'], description='EGF containing fibulin extracellular matrix protein 1', other_designations='EGF-containing fibulin-like extracellular matrix protein 1|EGF containing fibulin like extracellular matrix protein 1|extracellular protein S1-5|fibulin-3', map_location='2p16.1', chromosome='2', genomic_nucleotide_accession_version='NC_000002.12', start_position_on_the_genomic_accession=55865967, end_position_on_the_genomic_accession=55924163, orientation='minus', exon_count=12, OMIM=[601548], no_hdr0=''),
    2203 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=2203, CurrentID=0, Status='live', Symbol='FBP1', Aliases=['FBP'], description='fructose-bisphosphatase 1', other_designations='fructose-1,6-bisphosphatase 1|D-fructose-1,6-bisphosphate 1-phosphohydrolase 1|FBPase 1|growth-inhibiting protein 17|liver FBPase', map_location='9q22.32', chromosome='9', genomic_nucleotide_accession_version='NC_000009.12', start_position_on_the_genomic_accession=94603133, end_position_on_the_genomic_accession=94640263, orientation='minus', exon_count=8, OMIM=[611570], no_hdr0=''),
    2204 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=2204, CurrentID=0, Status='live', Symbol='FCAR', Aliases=['CD89', 'CTB-61M7.2', 'FcalphaRI'], description='Fc fragment of IgA receptor', other_designations='immunoglobulin alpha Fc receptor|FCAR variant 14|Fc alpha receptor|Fc fragment of IgA, receptor for', map_location='19q13.42', chromosome='19', genomic_nucleotide_accession_version='NC_000019.10', start_position_on_the_genomic_accession=54874231, end_position_on_the_genomic_accession=54891420, orientation='plus', exon_count=7, OMIM=[147045], no_hdr0=''),
    2205 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=2205, CurrentID=0, Status='live', Symbol='FCER1A', Aliases=['FCE1A', 'FcERI'], description='Fc fragment of IgE receptor Ia', other_designations='high affinity immunoglobulin epsilon receptor subunit alpha|Fc IgE receptor, alpha polypeptide|Fc epsilon RI alpha-chain|Fc epsilon receptor Ia|Fc fragment of IgE, high affinity I, receptor for; alpha polypeptide|Fc-epsilon RI-alpha|high affinity immunoglobulin epsilon receptor alpha-subunit|igE Fc receptor subunit alpha|immunoglobulin E receptor, high-affinity, of mast cells, alpha polypeptide', map_location='1q23.2', chromosome='1', genomic_nucleotide_accession_version='NC_000001.11', start_position_on_the_genomic_accession=159283888, end_position_on_the_genomic_accession=159308224, orientation='plus', exon_count=7, OMIM=[147140], no_hdr0=''),
    2206 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=2206, CurrentID=0, Status='live', Symbol='MS4A2', Aliases=['APY', 'ATOPY', 'FCER1B', 'FCERI', 'IGEL', 'IGER', 'IGHER', 'MS4A1'], description='membrane spanning 4-domains A2', other_designations='high affinity immunoglobulin epsilon receptor subunit beta|Fc fragment of IgE, high affinity I, receptor for; beta polypeptide|High affinity immunoglobulin epsilon receptor beta-subunit (FcERI) (IgE Fc receptor, beta-subunit) (Fc epsilon receptor I beta-chain)|high affinity IgE receptor beta subunit|igE Fc receptor subunit beta|immunoglobulin E receptor, high affinity, beta polypeptide|membrane-spanning 4-domains subfamily A member 2', map_location='11q12.1', chromosome='11', genomic_nucleotide_accession_version='NC_000011.10', start_position_on_the_genomic_accession=60088261, end_position_on_the_genomic_accession=60098467, orientation='plus', exon_count=8, OMIM=[147138], no_hdr0=''),
    2207 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=2207, CurrentID=0, Status='live', Symbol='FCER1G', Aliases=['FCRG'], description='Fc fragment of IgE receptor Ig', other_designations='high affinity immunoglobulin epsilon receptor subunit gamma|Fc epsilon receptor Ig|Fc fragment of IgE, high affinity I, receptor for; gamma polypeptide|Fc receptor gamma-chain|fc-epsilon RI-gamma|fcRgamma|fceRI gamma|immunoglobulin E receptor, high affinity, gamma chain', map_location='1q23.3', chromosome='1', genomic_nucleotide_accession_version='NC_000001.11', start_position_on_the_genomic_accession=161215295, end_position_on_the_genomic_accession=161219245, orientation='plus', exon_count=5, OMIM=[147139], no_hdr0=''),
    2208 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=2208, CurrentID=0, Status='live', Symbol='FCER2', Aliases=['BLAST-2', 'CD23', 'CD23A', 'CLEC4J', 'FCE2', 'IGEBF'], description='Fc fragment of IgE receptor II', other_designations='low affinity immunoglobulin epsilon Fc receptor|C-type lectin domain family 4, member J|CD23 antigen|Fc epsilon receptor II|Fc fragment of IgE, low affinity II, receptor for (CD23)|fc-epsilon-RII|immunoglobulin E-binding factor|immunoglobulin epsilon-chain|lymphocyte IgE receptor', map_location='19p13.2', chromosome='19', genomic_nucleotide_accession_version='NC_000019.10', start_position_on_the_genomic_accession=7688759, end_position_on_the_genomic_accession=7702755, orientation='minus', exon_count=12, OMIM=[151445], no_hdr0=''),
    2209 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=2209, CurrentID=0, Status='live', Symbol='FCGR1A', Aliases=['CD64', 'CD64A', 'FCRI', 'IGFR1'], description='Fc fragment of IgG receptor Ia', other_designations='high affinity immunoglobulin gamma Fc receptor I|Fc fragment of IgG, high affinity Ia, receptor (CD64)|Fc fragment of IgG, high affinity Ia, receptor for (CD64)|Fc gamma receptor Ia|Fc-gamma RI|Fc-gamma receptor I A1|IgG Fc receptor I|fc-gamma RIA|fcgammaRIa', map_location='1q21.2', chromosome='1', genomic_nucleotide_accession_version='NC_000001.11', start_position_on_the_genomic_accession=149782694, end_position_on_the_genomic_accession=149800609, orientation='plus', exon_count=8, OMIM=[146760], no_hdr0=''),
    2212 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=2212, CurrentID=0, Status='live', Symbol='FCGR2A', Aliases=['CD32', 'CD32A', 'CDw32', 'FCG2', 'FCGR21', 'FcGR', 'IGFR2', 'FCGR2A'], description='Fc fragment of IgG receptor IIa', other_designations='low affinity immunoglobulin gamma Fc region receptor II-a|Fc fragment of IgG, low affinity IIa, receptor (CD32)|Fc gamma receptor RIIa3|Immunoglobulin G Fc receptor II|fc-gamma-RIIa|fcRII-a|igG Fc receptor II-a', map_location='1q23.3', chromosome='1', genomic_nucleotide_accession_version='NC_000001.11', start_position_on_the_genomic_accession=161505430, end_position_on_the_genomic_accession=161524048, orientation='plus', exon_count=12, OMIM=[146790], no_hdr0=''),
    2213 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=2213, CurrentID=0, Status='live', Symbol='FCGR2B', Aliases=['CD32', 'CD32B', 'FCG2', 'FCGR2', 'FCGR2C', 'FcRII-c', 'IGFR2'], description='Fc fragment of IgG receptor IIb', other_designations='low affinity immunoglobulin gamma Fc region receptor II-b|CDw32|Fc fragment of IgG, low affinity II, receptor for (CD32)|Fc fragment of IgG, low affinity IIb, receptor (CD32)|Fc fragment of IgG, low affinity IIb, receptor for (CD32)|Fc gamma RIIb|Fc gamma receptor IIb|Fc-gamma RII-c|Fc-gamma-RIIc|IgG Fc receptor II-c|Low affinity immunoglobulin gamma Fc region receptor II-c|fc-gamma RII-b|fc-gamma-RIIb|fcRII-b|igG Fc receptor II-b', map_location='1q23.3', chromosome='1', genomic_nucleotide_accession_version='NC_000001.11', start_position_on_the_genomic_accession=161647243, end_position_on_the_genomic_accession=161678654, orientation='plus', exon_count=11, OMIM=[604590], no_hdr0=''),
    2214 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=2214, CurrentID=0, Status='live', Symbol='FCGR3A', Aliases=['CD16', 'CD16A', 'FCG3', 'FCGR3', 'FCGRIII', 'FCR-10', 'FCRIII', 'FCRIIIA', 'IGFR3', 'IMD20'], description='Fc fragment of IgG receptor IIIa', other_designations='low affinity immunoglobulin gamma Fc region receptor III-A|CD16a antigen|Fc fragment of IgG, low affinity III, receptor for (CD16)|Fc fragment of IgG, low affinity IIIa, receptor (CD16a)|Fc gamma receptor III-A|Fc-gamma RIII-alpha|Fc-gamma receptor III-2 (CD 16)|Fc-gamma receptor IIIb (CD16)|FcgammaRIIIA|igG Fc receptor III-2|immunoglobulin G Fc receptor III|low affinity immunoglobulin gamma receptor III-a Fc fragment|neutrophil-specific antigen NA', map_location='1q23.3', chromosome='1', genomic_nucleotide_accession_version='NC_000001.11', start_position_on_the_genomic_accession=161541759, end_position_on_the_genomic_accession=161550737, orientation='minus', exon_count=7, OMIM=[146740], no_hdr0=''),
    2215 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=2215, CurrentID=0, Status='live', Symbol='FCGR3B', Aliases=['CD16', 'CD16A', 'CD16b', 'FCG3', 'FCGR3', 'FCGR3A', 'FCR-10', 'FCRIII', 'FCRIIIb'], description='Fc fragment of IgG receptor IIIb', other_designations='low affinity immunoglobulin gamma Fc region receptor III-B|Fc fragment of IgG, low affinity IIIb, receptor (CD16b)|Fc gamma receptor III-B|Fc gamma receptor IIIb|Fc-gamma receptor IIIb (CD 16)|fc-gamma RIII-beta|fc-gamma RIIIb|igG Fc receptor III-1', map_location='1q23.3', chromosome='1', genomic_nucleotide_accession_version='NC_000001.11', start_position_on_the_genomic_accession=161623196, end_position_on_the_genomic_accession=161631963, orientation='minus', exon_count=7, OMIM=[610665], no_hdr0=''),
    2217 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=2217, CurrentID=0, Status='live', Symbol='FCGRT', Aliases=['FCRN', 'alpha-chain'], description='Fc fragment of IgG receptor and transporter', other_designations='IgG receptor FcRn large subunit p51|Fc fragment of IgG, receptor, transporter, alpha|FcRn alpha chain|IgG Fc fragment receptor transporter alpha chain|heavy chain of the major histocompatibility complex class I-like Fc receptor|immunoglobulin receptor, intestinal, heavy chain|major histocompatibility complex class I-like Fc receptor|neonatal Fc receptor|neonatal Fc-receptor for Ig|transmembrane alpha chain of the neonatal receptor', map_location='19q13.33', chromosome='19', genomic_nucleotide_accession_version='NC_000019.10', start_position_on_the_genomic_accession=49512661, end_position_on_the_genomic_accession=49526428, orientation='plus', exon_count=7, OMIM=[601437], no_hdr0=''),
    2218 : ntncbi(tax_id=9606, Org_name='Homo sapiens', GeneID=2218, CurrentID=0, Status='live', Symbol='FKTN', Aliases=['CMD1X', 'FCMD', 'LGMD2M', 'LGMDR13', 'MDDGA4', 'MDDGB4', 'MDDGC4'], description='fukutin', other_designations='fukutin|Fukuyama type congenital muscular dystrophy protein|patient fukutin|ribitol-5-phosphate transferase