"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Runtime = exports.RuntimeFamily = void 0;
const jsiiDeprecationWarnings = require("../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
/**
 * All known Lambda runtime families.
 */
var RuntimeFamily;
(function (RuntimeFamily) {
    /**
     * All Lambda runtimes that depend on Node.js.
     */
    RuntimeFamily[RuntimeFamily["NODEJS"] = 0] = "NODEJS";
    /**
     * All lambda runtimes that depend on Python.
     */
    RuntimeFamily[RuntimeFamily["PYTHON"] = 1] = "PYTHON";
    /**
     * Any future runtime family.
     */
    RuntimeFamily[RuntimeFamily["OTHER"] = 2] = "OTHER";
})(RuntimeFamily = exports.RuntimeFamily || (exports.RuntimeFamily = {}));
/**
 * Runtime options for a canary
 */
class Runtime {
    /**
      * @param name The name of the runtime version
      * @param family The Lambda runtime family
      */
    constructor(name, family) {
        this.name = name;
        this.family = family;
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_synthetics_alpha_RuntimeFamily(family);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, Runtime);
            }
            throw error;
        }
    }
}
exports.Runtime = Runtime;
_a = JSII_RTTI_SYMBOL_1;
Runtime[_a] = { fqn: "@aws-cdk/aws-synthetics-alpha.Runtime", version: "2.45.0-alpha.0" };
/**
 * **Deprecated by AWS Synthetics. You can't create canaries with deprecated runtimes.**
 *
 * `syn-1.0` includes the following:
 *
 * - Synthetics library 1.0
 * - Synthetics handler code 1.0
 * - Lambda runtime Node.js 10.x
 * - Puppeteer-core version 1.14.0
 * - The Chromium version that matches Puppeteer-core 1.14.0
 *
 * @see https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch_Synthetics_Library_nodejs_puppeteer.html#CloudWatch_Synthetics_runtimeversion-1.0
 */
Runtime.SYNTHETICS_1_0 = new Runtime('syn-1.0', RuntimeFamily.NODEJS);
/**
 * **Deprecated by AWS Synthetics. You can't create canaries with deprecated runtimes.**
 *
 * `syn-nodejs-2.0` includes the following:
 * - Lambda runtime Node.js 10.x
 * - Puppeteer-core version 3.3.0
 * - Chromium version 83.0.4103.0
 *
 * @see https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch_Synthetics_Library_nodejs_puppeteer.html#CloudWatch_Synthetics_runtimeversion-2.0
 */
Runtime.SYNTHETICS_NODEJS_2_0 = new Runtime('syn-nodejs-2.0', RuntimeFamily.NODEJS);
/**
 * **Deprecated by AWS Synthetics. You can't create canaries with deprecated runtimes.**
 *
 * `syn-nodejs-2.1` includes the following:
 * - Lambda runtime Node.js 10.x
 * - Puppeteer-core version 3.3.0
 * - Chromium version 83.0.4103.0
 *
 * @see https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch_Synthetics_Library_nodejs_puppeteer.html#CloudWatch_Synthetics_runtimeversion-2.1
 */
Runtime.SYNTHETICS_NODEJS_2_1 = new Runtime('syn-nodejs-2.1', RuntimeFamily.NODEJS);
/**
 * **Deprecated by AWS Synthetics. You can't create canaries with deprecated runtimes.**
 *
 * `syn-nodejs-2.2` includes the following:
 * - Lambda runtime Node.js 10.x
 * - Puppeteer-core version 3.3.0
 * - Chromium version 83.0.4103.0
 *
 * @see https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch_Synthetics_Library_nodejs_puppeteer.html#CloudWatch_Synthetics_runtimeversion-2.2
 */
Runtime.SYNTHETICS_NODEJS_2_2 = new Runtime('syn-nodejs-2.2', RuntimeFamily.NODEJS);
/**
 * `syn-nodejs-puppeteer-3.0` includes the following:
 * - Lambda runtime Node.js 12.x
 * - Puppeteer-core version 5.5.0
 * - Chromium version 88.0.4298.0
 *
 * @see https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch_Synthetics_Library_nodejs_puppeteer.html#CloudWatch_Synthetics_runtimeversion-nodejs-puppeteer-3.0
 */
Runtime.SYNTHETICS_NODEJS_PUPPETEER_3_0 = new Runtime('syn-nodejs-puppeteer-3.0', RuntimeFamily.NODEJS);
/**
 * `syn-nodejs-puppeteer-3.1` includes the following:
 * - Lambda runtime Node.js 12.x
 * - Puppeteer-core version 5.5.0
 * - Chromium version 88.0.4298.0
 *
 * @see https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch_Synthetics_Library_nodejs_puppeteer.html#CloudWatch_Synthetics_runtimeversion-nodejs-puppeteer-3.1
 */
Runtime.SYNTHETICS_NODEJS_PUPPETEER_3_1 = new Runtime('syn-nodejs-puppeteer-3.1', RuntimeFamily.NODEJS);
/**
 * `syn-nodejs-puppeteer-3.2` includes the following:
 * - Lambda runtime Node.js 12.x
 * - Puppeteer-core version 5.5.0
 * - Chromium version 88.0.4298.0
 *
 * @see https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch_Synthetics_Library_nodejs_puppeteer.html#CloudWatch_Synthetics_runtimeversion-nodejs-puppeteer-3.2
 */
Runtime.SYNTHETICS_NODEJS_PUPPETEER_3_2 = new Runtime('syn-nodejs-puppeteer-3.2', RuntimeFamily.NODEJS);
/**
 * `syn-nodejs-puppeteer-3.3` includes the following:
 * - Lambda runtime Node.js 12.x
 * - Puppeteer-core version 5.5.0
 * - Chromium version 88.0.4298.0
 *
 * @see https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch_Synthetics_Library_nodejs_puppeteer.html#CloudWatch_Synthetics_runtimeversion-nodejs-puppeteer-3.3
 */
Runtime.SYNTHETICS_NODEJS_PUPPETEER_3_3 = new Runtime('syn-nodejs-puppeteer-3.3', RuntimeFamily.NODEJS);
/**
 * `syn-nodejs-puppeteer-3.4` includes the following:
 * - Lambda runtime Node.js 12.x
 * - Puppeteer-core version 5.5.0
 * - Chromium version 88.0.4298.0
 *
 * @see https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch_Synthetics_Library_nodejs_puppeteer.html#CloudWatch_Synthetics_runtimeversion-nodejs-puppeteer-3.4
 */
Runtime.SYNTHETICS_NODEJS_PUPPETEER_3_4 = new Runtime('syn-nodejs-puppeteer-3.4', RuntimeFamily.NODEJS);
/**
 * `syn-nodejs-puppeteer-3.5` includes the following:
 * - Lambda runtime Node.js 14.x
 * - Puppeteer-core version 10.1.0
 * - Chromium version 92.0.4512
 *
 * @see https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch_Synthetics_Library_nodejs_puppeteer.html#CloudWatch_Synthetics_runtimeversion-nodejs-puppeteer-3.5
 */
Runtime.SYNTHETICS_NODEJS_PUPPETEER_3_5 = new Runtime('syn-nodejs-puppeteer-3.5', RuntimeFamily.NODEJS);
/**
 * `syn-python-selenium-1.0` includes the following:
 * - Lambda runtime Python 3.8
 * - Selenium version 3.141.0
 * - Chromium version 83.0.4103.0
 *
 * @see https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch_Synthetics_Library_python_selenium.html
 */
Runtime.SYNTHETICS_PYTHON_SELENIUM_1_0 = new Runtime('syn-python-selenium-1.0', RuntimeFamily.PYTHON);
//# sourceMappingURL=data:application/json;base64,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