from typing import Optional

from ..ecosystems import ECOSYSTEM
from .npm_package_scanner import NPMPackageScanner
from .npm_project_scanner import NPMRequirementsScanner
from .pypi_package_scanner import PypiPackageScanner
from .pypi_project_scanner import PypiRequirementsScanner
from .scanner import Scanner


def get_scanner(ecosystem: ECOSYSTEM, project: bool) -> Optional[Scanner]:
    match (ecosystem, project):
        case (ECOSYSTEM.PYPI, False):
            return PypiPackageScanner()
        case (ECOSYSTEM.PYPI, True):
            return PypiRequirementsScanner()
        case (ECOSYSTEM.NPM, False):
            return NPMPackageScanner()
        case (ECOSYSTEM.NPM, True):
            return NPMRequirementsScanner()
    return None
