"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.ConcreteWidget = exports.GRID_WIDTH = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
/**
 * The width of the grid we're filling
 */
exports.GRID_WIDTH = 24;
/**
 * A real CloudWatch widget that has its own fixed size and remembers its position
 *
 * This is in contrast to other widgets which exist for layout purposes.
 */
class ConcreteWidget {
    constructor(width, height) {
        this.width = width;
        this.height = height;
        if (this.width > exports.GRID_WIDTH) {
            throw new Error(`Widget is too wide, max ${exports.GRID_WIDTH} units allowed`);
        }
    }
    position(x, y) {
        this.x = x;
        this.y = y;
    }
}
exports.ConcreteWidget = ConcreteWidget;
_a = JSII_RTTI_SYMBOL_1;
ConcreteWidget[_a] = { fqn: "@aws-cdk/aws-cloudwatch.ConcreteWidget", version: "1.152.0" };
//# sourceMappingURL=data:application/json;base64,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