# korean-geocoding

 대한민국의 약 2만개 정도 있는 각 행정구역의 위도/경도를 검색하는 라이브러리입니다.  
네이버 Geocoding API를 통해 각 행정구역별로 좌표를 수집하였으며, 주소 문자열을 통해 해당 행정구역의 좌표를 확인할 수 있습니다.  
트리 형태의 Python 오브젝트 형태로 데이터를 저장하여, 엑셀 등의 파일에서 단순 검색에 비해 훨씬 속도가 빠릅니다.  

그냥 행정구역별 위도/경도를 담은 엑셀 파일이 필요하신 분은 [여기](https://skyseven73.tistory.com/23)로

## Update log

#### 0.1.2

- 공개 초창기다 보니 생긴 자잘한 많은 버그 수정
- get_under_district가 특정 조건에서 에러를 내던 버그 수정


#### 0.1.1

- 코드에서 typing.Final 키워드가 Python 3.8 이상만 지원해서 삭제
- 자잘한 버그 수정 


## Usage

아래와 같이 라이브러리를 설치합니다. python 3.5 아래는 지원하지 않으며, Python 3.6 이상을 권장합니다.  

`pip install korean-geocoding`


### 기본 사용법

```python
from korean_geocoding.geocoding import KoreanGeocoding as Kg
kg = Kg()
```

kg 인스턴스를 이용하여 해당 라이브러리의 기능을 이용할 수 있습니다.

------------------------------------------------

### get_coordinates(query: str, delimiter=' ', just_fit=True)

주어진 행정구역의 위도/경도 좌표를 반환합니다. (<위도>, <경도>)의 Tuple 형태로 반환됩니다.

- query(Required) : 검색할 행정구역명. 각 구역은 기본적으로 띄어쓰기 하나로 구분하며 현재는 시군구/리 까지만 지원합니다. (Ex: 부산광역시 동구 범일동, 부산광역시 기장군 일광면 용천리)
도로명까지의 세부 주소를 넣지 말아주세요.

- delimiter : 각 행정구별 구분자. 기본적으로 공백 하나로 구분합니다. 만약 '부산광역시|동구|범일동' 이라는 쿼리를 넣고 싶다면,  
delimiter='|'로 값을 넣음으로써 정상적으로 ['부산광역시', '동구', '범일동'] 으로 인식됩니다.

- just_fit : T/F 값을 가집니다. False라면 중간에 알 수 없는 행정구역 이름이 들어온 경우, 여기까지 인식된 곳의 주소만 가지고 좌표를 계산합니다.  
"부산광역시 동구 알수없는동"이라고 입력한다면, '알수없는동'은 인식할 수 없으므로 "부산광역시 동구"의 좌표를 반환합니다.

#### Example
```python
from korean_geocoding.geocoding import KoreanGeocoding as Kg
kg = Kg()

print(kg.get_coordinates('서울특별시 종로구'))
print(kg.get_coordinates('서울특별시:종로구', delimiter=':'))
print(kg.get_coordinates('서울특별시 종로구 알수없는동', just_fit=False))

```

```
(126.9788345, 37.5735207)
(126.9788345, 37.5735207)
(126.9788345, 37.5735207)
```

-----------------------------------------

### get_under_districts(query, delimiter=' ', just_fit=True)

주어진 행정구역의 하위 행정구역의 list를 반환합니다.  


__***주의: 현재 [행정동과 법정동](https://www.yna.co.kr/view/AKR20180521134900061)이 구분되어 있지 않아, 특히 광역시나 특별시의 하위 구에서 이 함수를 사용할 시 행정동과 법정동이 섞여서 출력되고 있습니다. 주의해 주세요. 추후 이 문제는 태깅을 통해 수정할 예정입니다. ㅠ.ㅠ 시군구나 읍면리는 정상적으로 이용 가능합니다.***__

파라미터는 위와 동일합니다.

#### Example
```python
from korean_geocoding.geocoding import KoreanGeocoding as Kg
kg = Kg()

print(kg.get_under_districts('서울특별시'))
print(kg.get_under_districts('부산광역시 기장군'))
print(kg.get_under_districts('세종특별자치시'))

```

```
['종로구', '중구', '용산구', '성동구', '광진구', '동대문구', '중랑구', '성북구', '강북구', '도봉구', '노원구', '은평구', '서대문구', '마포구', '양천구', '강서구', '구로구', '금천구', '영등포구', '동작구', '관악구', '서초구', '강남구', '송파구', '강동구']
['기장읍', '장안읍', '정관읍', '일광면', '철마면']
['조치원읍', '연기면', '연동면', '부강면', '금남면', '장군면', '연서면', '전의면', '전동면', '소정면', '한솔동', '새롬동', '도담동', '아름동', '종촌동', '고운동', '소담동', '보람동', '대평동', '반곡동', '가람동', '나성동', '다정동', '어진동']
```

---------------

## 안내

- Issue 사항이나 뭔가 필요한 기능, 개선사항이 있으시다면 언제든 여기 깃헙의 이슈나 제 블로그 게시글(아래)의 댓글에 알려 주세요.
- 위의 파일들 수정일자 보면 아시겠지만 2022년 4월 기준으로 전혀 죽은 프로젝트 아닙니다 ㅠㅠ
- 앞으로 추가될 기능들은 [여기](https://github.com/RE-A/korean-geocoding/issues/5) 서 정리하는 중입니다.
- 해당 라이브러리에 개발과 관련된 TMI는 [여기](https://skyseven73.tistory.com/24)에 업데이트 될 예정입니다.
