"""
Django settings for pyclash project.

Generated by 'django-admin startproject' using Django 1.11.8.

For more information on this file, see
https://docs.djangoproject.com/en/1.11/topics/settings/

For the full list of settings and their values, see
https://docs.djangoproject.com/en/1.11/ref/settings/
"""

from django.conf import settings
from django.core.signals import setting_changed
from rest_framework.settings import APISettings

DEFAULTS = {
    "CAPTCHA_CHARS": "1234567890",
    "PAGE_SIZE": 20,
    "MAX_PAGE_SIZE": 1000,
    "DEFAULT_ORDERING_FIELD": "pk",
    "DEFAULT_SORTING": "asc",
    "SEARCH_PARAM": "key_word",
    "DEFAULT_FILTER_BACKENDS": [
        "uboxadmin.filters.OrderingFilter",
        "uboxadmin.filters.SearchFilter",
        "uboxadmin.filters.ConditionFilter",
    ],
    "DEFAULT_PERMISSION_CLASSES": [
        "rest_framework.permissions.IsAuthenticated",
    ],
    "DEFAULT_PAGINATION_CLASS": "uboxadmin.pagination.PageNumberPagination",
    "DEFAULT_AUTHENTICATION_CLASSES": [
        "uboxadmin.authentication.JwtAuthentication",
    ],
    "EXCEPTION_HANDLER": "uboxadmin.utils.exception_handler",
}

import_strings = [
    "DEFAULT_PAGINATION_CLASS",
    "DEFAULT_FILTER_BACKENDS",
    "DEFAULT_AUTHENTICATION_CLASSES",
    "DEFAULT_PERMISSION_CLASSES",
    "EXCEPTION_HANDLER",
]


class AdminSettings(APISettings):
    @property
    def user_settings(self):
        if not hasattr(self, "_user_settings"):
            self._user_settings = getattr(settings, "UBOX_ADMIN_CONF", {})
        return self._user_settings

    def __check_user_settings(self, user_settings):
        return user_settings


admin_settings = AdminSettings(None, DEFAULTS, import_strings)


def reload_api_settings(*args, **kwargs):
    setting = kwargs["setting"]
    if setting == "UBOX_ADMIN_CONF":
        admin_settings.reload()


setting_changed.connect(reload_api_settings)
