# -*- coding: utf-8 -*-
# Generated by Django 1.11.29 on 2021-05-20 14:44
from __future__ import unicode_literals

from django.db import migrations, models
import django.db.models.deletion


class Migration(migrations.Migration):

    initial = True

    dependencies = [
    ]

    operations = [
        migrations.CreateModel(
            name='AppSpaceInfo',
            fields=[
                ('id', models.AutoField(primary_key=True, serialize=False)),
                ('create_time', models.DateTimeField(auto_now_add=True, null=True, verbose_name='创建时间')),
                ('update_time', models.DateTimeField(auto_now=True, null=True, verbose_name='修改时间')),
                ('url', models.URLField(verbose_name='地址')),
                ('type', models.CharField(max_length=255, verbose_name='类型')),
                ('classify_id', models.IntegerField(null=True, verbose_name='分类ID')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='AppSpaceType',
            fields=[
                ('id', models.AutoField(primary_key=True, serialize=False)),
                ('create_time', models.DateTimeField(auto_now_add=True, null=True, verbose_name='创建时间')),
                ('update_time', models.DateTimeField(auto_now=True, null=True, verbose_name='修改时间')),
                ('name', models.CharField(max_length=255, verbose_name='类别名称')),
                ('parent_id', models.IntegerField(null=True, verbose_name='父类型ID')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='BlackListedToken',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('token', models.CharField(max_length=500)),
                ('timestamp', models.DateTimeField(auto_now=True)),
            ],
        ),
        migrations.CreateModel(
            name='Conf',
            fields=[
                ('id', models.AutoField(primary_key=True, serialize=False)),
                ('create_time', models.DateTimeField(auto_now_add=True, null=True, verbose_name='创建时间')),
                ('update_time', models.DateTimeField(auto_now=True, null=True, verbose_name='修改时间')),
                ('key', models.CharField(max_length=255, unique=True, verbose_name='配置键')),
                ('value', models.CharField(max_length=255, verbose_name='配置值')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='Department',
            fields=[
                ('id', models.AutoField(primary_key=True, serialize=False)),
                ('create_time', models.DateTimeField(auto_now_add=True, null=True, verbose_name='创建时间')),
                ('update_time', models.DateTimeField(auto_now=True, null=True, verbose_name='修改时间')),
                ('name', models.CharField(max_length=255, verbose_name='部门名称')),
                ('parent_id', models.IntegerField(null=True, verbose_name='上级部门ID')),
                ('order_num', models.IntegerField(default=0, verbose_name='排序')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='Log',
            fields=[
                ('id', models.AutoField(primary_key=True, serialize=False)),
                ('create_time', models.DateTimeField(auto_now_add=True, null=True, verbose_name='创建时间')),
                ('update_time', models.DateTimeField(auto_now=True, null=True, verbose_name='修改时间')),
                ('user_id', models.BigIntegerField(db_index=True, null=True, verbose_name='用户ID')),
                ('action', models.CharField(max_length=100, verbose_name='行为')),
                ('ip', models.GenericIPAddressField(null=True, verbose_name='ip')),
                ('ip_addr', models.CharField(max_length=50, null=True, verbose_name='ip地址')),
                ('params', models.TextField(null=True, verbose_name='参数')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='Menu',
            fields=[
                ('id', models.AutoField(primary_key=True, serialize=False)),
                ('create_time', models.DateTimeField(auto_now_add=True, null=True, verbose_name='创建时间')),
                ('update_time', models.DateTimeField(auto_now=True, null=True, verbose_name='修改时间')),
                ('parent_id', models.IntegerField(null=True, verbose_name='上级部门ID')),
                ('name', models.CharField(max_length=255, verbose_name='菜单名称')),
                ('router', models.CharField(max_length=255, null=True, verbose_name='菜单地址')),
                ('perms', models.CharField(max_length=255, null=True, verbose_name='权限标识')),
                ('type', models.IntegerField(default=0, help_text='类型 0：目录 1：菜单 2：按钮', verbose_name='类型')),
                ('icon', models.CharField(max_length=255, null=True, verbose_name='图标')),
                ('order_num', models.IntegerField(default=0, verbose_name='排序')),
                ('view_path', models.CharField(max_length=255, null=True, verbose_name='视图地址')),
                ('keep_alive', models.BooleanField(default=True, verbose_name='路由缓存')),
                ('is_show', models.BooleanField(default=True, verbose_name='是否展示')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='Param',
            fields=[
                ('id', models.AutoField(primary_key=True, serialize=False)),
                ('create_time', models.DateTimeField(auto_now_add=True, null=True, verbose_name='创建时间')),
                ('update_time', models.DateTimeField(auto_now=True, null=True, verbose_name='修改时间')),
                ('key_name', models.CharField(db_index=True, help_text='键位', max_length=255, verbose_name='键位')),
                ('name', models.CharField(max_length=255, verbose_name='名称')),
                ('data', models.TextField(verbose_name='数据')),
                ('data_type', models.IntegerField(choices=[(0, 'STRING'), (1, 'ARRAY'), (2, 'MAPPING')], default=0, help_text='数据类型 0:字符串 1：数组 2：键值对', verbose_name='数据类型')),
                ('remark', models.CharField(max_length=255, null=True, verbose_name='备注')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='Role',
            fields=[
                ('id', models.AutoField(primary_key=True, serialize=False)),
                ('create_time', models.DateTimeField(auto_now_add=True, null=True, verbose_name='创建时间')),
                ('update_time', models.DateTimeField(auto_now=True, null=True, verbose_name='修改时间')),
                ('user_id', models.CharField(max_length=255, verbose_name='用户ID')),
                ('name', models.CharField(max_length=255, unique=True, verbose_name='名称')),
                ('label', models.CharField(db_index=True, max_length=255, null=True, unique=True, verbose_name='角色标签')),
                ('remark', models.CharField(max_length=255, null=True, verbose_name='备注')),
                ('relevance', models.IntegerField(default=1, verbose_name='数据权限是否关联上下级')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='RoleDepartment',
            fields=[
                ('id', models.AutoField(primary_key=True, serialize=False)),
                ('create_time', models.DateTimeField(auto_now_add=True, null=True, verbose_name='创建时间')),
                ('update_time', models.DateTimeField(auto_now=True, null=True, verbose_name='修改时间')),
                ('role_id', models.IntegerField(verbose_name='角色ID')),
                ('department_id', models.IntegerField(verbose_name='部门ID')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='RoleMenu',
            fields=[
                ('id', models.AutoField(primary_key=True, serialize=False)),
                ('create_time', models.DateTimeField(auto_now_add=True, null=True, verbose_name='创建时间')),
                ('update_time', models.DateTimeField(auto_now=True, null=True, verbose_name='修改时间')),
                ('role_id', models.IntegerField(verbose_name='角色ID')),
                ('menu_id', models.IntegerField(verbose_name='菜单ID')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='User',
            fields=[
                ('last_login', models.DateTimeField(blank=True, null=True, verbose_name='last login')),
                ('id', models.AutoField(primary_key=True, serialize=False)),
                ('create_time', models.DateTimeField(auto_now_add=True, null=True, verbose_name='创建时间')),
                ('update_time', models.DateTimeField(auto_now=True, null=True, verbose_name='修改时间')),
                ('department_id', models.IntegerField(db_index=True, null=True, verbose_name='部门ID')),
                ('name', models.CharField(max_length=255, null=True, verbose_name='姓名')),
                ('username', models.CharField(max_length=255, unique=True, verbose_name='用户名')),
                ('password', models.CharField(max_length=255, verbose_name='密码')),
                ('password_v', models.CharField(default=1, help_text='作用是改完密码，让原来的token失效', max_length=255, verbose_name='密码版本')),
                ('nick_name', models.CharField(max_length=255, null=True, verbose_name='昵称')),
                ('head_img', models.CharField(max_length=255, null=True, verbose_name='头像')),
                ('phone', models.CharField(db_index=True, max_length=20, verbose_name='手机')),
                ('remark', models.CharField(max_length=255, null=True, verbose_name='备注')),
                ('status', models.IntegerField(choices=[(0, 'DISABLED'), (1, 'ENABLED')], default=1, verbose_name='状态')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='UserRole',
            fields=[
                ('id', models.AutoField(primary_key=True, serialize=False)),
                ('create_time', models.DateTimeField(auto_now_add=True, null=True, verbose_name='创建时间')),
                ('update_time', models.DateTimeField(auto_now=True, null=True, verbose_name='修改时间')),
                ('user_id', models.IntegerField(verbose_name='用户ID')),
                ('role_id', models.IntegerField(verbose_name='角色ID')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.AddField(
            model_name='blacklistedtoken',
            name='user',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='uboxadmin.User'),
        ),
        migrations.AlterUniqueTogether(
            name='blacklistedtoken',
            unique_together=set([('token', 'user')]),
        ),
    ]
