# flake8: noqa
from django.core.management.base import BaseCommand

from uboxadmin.models.space import AppSpaceType
from uboxadmin.models.system import Conf, Department, Menu, Param, Role, RoleMenu, User, UserRole
from uboxadmin.utils import insert_or_update

NULL = None

# fmt: off
APP_SPACE_TYPE_FIELDS = ("id", "create_time", "update_time", "name", "parent_id")
APP_SPACE_TYPE_DATA = (
    (1, '2021-02-26 14:07:48.867045', '2021-02-26 14:07:48.867045', 'a', None),
    (2, '2021-02-26 14:07:52.285531', '2021-02-26 14:07:52.285531', 'b', None),
)

CONF_FIELDS = ("id", "create_time", "update_time", "key", "value")
CONF_DATA = (
    (1, '2021-02-25 14:23:26.810981', '2021-02-25 14:23:26.810981', 'logKeep', '31'),
)

DEPARTMENT_FIELDS = ("id", "create_time", "update_time", "name", "parent_id", "order_num")
DEPARTMENT_DATA = (
    (1, '2021-02-24 21:17:11.971397', '2021-02-24 21:17:15.697917', 'COOL', NULL, 0),
    (11, '2021-02-26 14:17:06.690613', '2021-02-26 14:17:06.690613', '开发', 1, 0),
    (12, '2021-02-26 14:17:11.576369', '2021-02-26 14:17:11.576369', '测试', 1, 0),
    (13, '2021-02-26 14:28:59.685177', '2021-02-26 14:28:59.685177', '游客', 1, 0),
)

MENU_FIELDS = ("id", "create_time", "update_time", "parent_id", "name", "router", "perms", "type", "icon", "order_num", "view_path", "keep_alive", "is_show")
MENU_DATA = (
    (1, '2019-09-11 11:14:44.000000', '2019-11-18 15:56:36.000000', None, '工作台', '/', None, 0, 'icon-workbench', 1, None, 1, 1),
    (2, '2019-09-11 11:14:47.000000', '2021-02-27 17:16:05.000000', None, '系统管理', '/sys', None, 0, 'icon-system', 2, None, 1, 1),
    (8, '1900-01-20 23:19:57.000000', '2021-03-08 22:59:12.000000', 27, '菜单列表', '/sys/menu', None, 1, 'icon-menu', 2, 'cool/modules/base/views/menu.vue', 1, 1),
    (10, '1900-01-20 00:19:27.325000', '1900-01-20 00:19:27.325000', 8, '新增', None, 'base:sys:menu:add', 2, None, 1, None, 0, 1),
    (11, '1900-01-20 00:19:51.101000', '1900-01-20 00:19:51.101000', 8, '删除', None, 'base:sys:menu:delete', 2, None, 2, None, 0, 1),
    (12, '1900-01-20 00:20:05.150000', '1900-01-20 00:20:05.150000', 8, '修改', None, 'base:sys:menu:update', 2, None, 3, None, 0, 1),
    (13, '1900-01-20 00:20:19.341000', '1900-01-20 00:20:19.341000', 8, '查询', None, 'base:sys:menu:page,base:sys:menu:list,base:sys:menu:info', 2, None, 4, None, 0, 1),
    (22, '2019-09-12 00:34:01.000000', '2021-03-08 22:59:23.000000', 27, '角色列表', '/sys/role', None, 1, 'icon-common', 3, 'cool/modules/base/views/role.vue', 1, 1),
    (23, '1900-01-20 00:34:23.459000', '1900-01-20 00:34:23.459000', 22, '新增', None, 'base:sys:role:add', 2, None, 1, None, 0, 1),
    (24, '1900-01-20 00:34:40.523000', '1900-01-20 00:34:40.523000', 22, '删除', None, 'base:sys:role:delete', 2, None, 2, None, 0, 1),
    (25, '1900-01-20 00:34:53.306000', '1900-01-20 00:34:53.306000', 22, '修改', None, 'base:sys:role:update', 2, None, 3, None, 0, 1),
    (26, '1900-01-20 00:35:05.024000', '1900-01-20 00:35:05.024000', 22, '查询', None, 'base:sys:role:page,base:sys:role:list,base:sys:role:info', 2, None, 4, None, 0, 1),
    (27, '2019-09-12 15:52:44.000000', '2019-09-15 22:11:56.000000', 2, '权限管理', None, None, 0, 'icon-auth', 1, None, 0, 1),
    (29, '2019-09-12 17:35:51.000000', '2021-03-08 23:01:39.000000', 105, '请求日志', '/sys/log', None, 1, 'icon-log', 1, 'cool/modules/base/views/log.vue', 1, 1),
    (30, '2019-09-12 17:37:03.000000', '2021-03-03 10:16:26.000000', 29, '权限', None, 'base:sys:log:page,base:sys:log:clear,base:sys:log:getKeep,base:sys:log:setKeep', 2, None, 1, None, 0, 1),
    (43, '2019-11-07 14:22:34.000000', '2021-03-08 23:02:51.000000', 45, 'crud 示例', '/crud', None, 1, 'icon-favor', 1, 'cool/modules/demo/views/crud.vue', 1, 1),
    (45, '2019-11-07 22:36:57.000000', '2019-11-11 15:21:10.000000', 1, '组件库', '/ui-lib', None, 0, 'icon-common', 2, None, 1, 1),
    (47, '2019-11-08 09:35:08.000000', '2021-02-27 17:16:35.000000', None, '框架教程', '/tutorial', None, 0, 'icon-task', 4, None, 1, 1),
    (48, '2019-11-08 09:35:53.000000', '2021-03-03 11:03:21.000000', 47, '文档', '/tutorial/doc', None, 1, 'icon-log', 0, 'https://admin.cool-js.com', 1, 1),
    (49, '2019-11-09 22:11:13.000000', '2021-03-09 09:50:46.000000', 45, 'quill 富文本编辑器', '/editor-quill', None, 1, 'icon-favor', 2, 'cool/modules/demo/views/editor-quill.vue', 1, 1),
    (59, '2019-11-18 16:50:27.000000', '2019-11-18 16:50:27.000000', 97, '部门列表', None, 'base:sys:department:list', 2, None, 0, None, 1, 1),
    (60, '2019-11-18 16:50:45.000000', '2019-11-18 16:50:45.000000', 97, '新增部门', None, 'base:sys:department:add', 2, None, 0, None, 1, 1),
    (61, '2019-11-18 16:50:59.000000', '2019-11-18 16:50:59.000000', 97, '更新部门', None, 'base:sys:department:update', 2, None, 0, None, 1, 1),
    (62, '2019-11-18 16:51:13.000000', '2019-11-18 16:51:13.000000', 97, '删除部门', None, 'base:sys:department:delete', 2, None, 0, None, 1, 1),
    (63, '2019-11-18 17:49:35.000000', '2019-11-18 17:49:35.000000', 97, '部门排序', None, 'base:sys:department:order', 2, None, 0, None, 1, 1),
    (65, '2019-11-18 23:59:21.000000', '2019-11-18 23:59:21.000000', 97, '用户转移', None, 'base:sys:user:move', 2, None, 0, None, 1, 1),
    (78, '2019-12-10 13:27:56.000000', '2021-02-27 17:08:53.000000', 2, '参数配置', None, None, 0, 'icon-common', 4, None, 1, 1),
    (79, '1900-01-20 13:29:33.000000', '2021-03-08 23:01:48.000000', 78, '参数列表', '/sys/param', None, 1, 'icon-menu', 0, 'cool/modules/base/views/param.vue', 1, 1),
    (80, '1900-01-20 13:29:50.146000', '1900-01-20 13:29:50.146000', 79, '新增', None, 'base:sys:param:add', 2, None, 0, None, 1, 1),
    (81, '1900-01-20 13:30:10.030000', '1900-01-20 13:30:10.030000', 79, '修改', None, 'base:sys:param:info,base:sys:param:update', 2, None, 0, None, 1, 1),
    (82, '1900-01-20 13:30:25.791000', '1900-01-20 13:30:25.791000', 79, '删除', None, 'base:sys:param:delete', 2, None, 0, None, 1, 1),
    (83, '1900-01-20 13:30:40.469000', '1900-01-20 13:30:40.469000', 79, '查看', None, 'base:sys:param:page,base:sys:param:list,base:sys:param:info', 2, None, 0, None, 1, 1),
    (84, '2020-07-25 16:21:30.000000', '2020-07-25 16:21:30.000000', None, '通用', None, None, 0, 'icon-radioboxfill', 99, None, 1, 0),
    (85, '2020-07-25 16:22:14.000000', '2021-03-03 10:36:00.000000', 84, '图片上传', None, 'space:info:page,space:info:list,space:info:info,space:info:add,space:info:delete,space:info:update,space:type:page,space:type:list,space:type:info,space:type:add,space:type:delete,space:type:update', 2, None, 1, None, 1, 1),  # noqa: E501
    (86, '2020-08-12 09:56:27.000000', '2021-03-08 23:03:03.000000', 45, '文件上传', '/upload', None, 1, 'icon-favor', 3, 'cool/modules/demo/views/upload.vue', 1, 1),
    (90, '1900-01-20 10:26:58.615000', '1900-01-20 10:26:58.615000', 84, '客服聊天', None, 'base:app:im:message:read,base:app:im:message:page,base:app:im:session:page,base:app:im:session:list,base:app:im:session:unreadCount,base:app:im:session:delete', 2, None, 0, None, 1, 1),  # noqa: E501
    (96, '2021-01-12 14:12:20.000000', '2021-03-08 23:02:40.000000', 1, '组件预览', '/demo', None, 1, 'icon-favor', 0, 'cool/modules/demo/views/demo.vue', 1, 1),
    (97, '1900-01-20 14:14:02.000000', '2021-03-09 11:03:09.000000', 27, '用户列表', '/sys/user', None, 1, 'icon-user', 0, 'cool/modules/base/views/user.vue', 1, 1),
    (98, '1900-01-20 14:14:13.528000', '1900-01-20 14:14:13.528000', 97, '新增', None, 'base:sys:user:add', 2, None, 0, None, 1, 1),
    (99, '1900-01-20 14:14:22.823000', '1900-01-20 14:14:22.823000', 97, '删除', None, 'base:sys:user:delete', 2, None, 0, None, 1, 1),
    (100, '1900-01-20 14:14:33.973000', '1900-01-20 14:14:33.973000', 97, '修改', None, 'base:sys:user:delete,base:sys:user:update', 2, None, 0, None, 1, 1),
    (101, '2021-01-12 14:14:51.000000', '2021-01-12 14:14:51.000000', 97, '查询', None, 'base:sys:user:page,base:sys:user:list,base:sys:user:info', 2, None, 0, None, 1, 1),
    (105, '2021-01-21 10:42:55.000000', '2021-01-21 10:42:55.000000', 2, '监控管理', None, None, 0, 'icon-rank', 6, None, 1, 1),
    (109, '2021-02-27 14:13:56.000000', '2021-02-27 17:09:19.000000', None, '插件管理', None, None, 0, 'icon-menu', 3, None, 1, 1),
    (110, '2021-02-27 14:14:13.000000', '2021-03-08 23:01:30.000000', 109, '插件列表', '/plugin', None, 1, 'icon-menu', 0, 'cool/modules/base/views/plugin.vue', 1, 1),
    (111, '2021-02-27 14:24:41.877000', '2021-02-27 14:24:41.877000', 110, '编辑', None, 'base:plugin:info:info,base:plugin:info:update', 2, None, 0, None, 1, 1),
    (112, '2021-02-27 14:24:52.159000', '2021-02-27 14:24:52.159000', 110, '列表', None, 'base:plugin:info:list', 2, None, 0, None, 1, 1),
    (113, '2021-02-27 14:25:02.066000', '2021-02-27 14:25:02.066000', 110, '删除', None, 'base:plugin:info:delete', 2, None, 0, None, 1, 1),
    (114, '2021-02-27 16:36:59.322000', '2021-02-27 16:36:59.322000', 110, '保存配置', None, 'base:plugin:info:config', 2, None, 0, None, 1, 1),
    (115, '2021-02-27 16:38:21.000000', '2021-02-27 18:18:22.000000', 110, '获取配置', None, 'base:plugin:info:getConfig', 2, None, 0, None, 1, 1),
    (116, '2021-02-27 17:57:42.000000', '2021-02-27 18:19:35.000000', 110, '开启、关闭', None, 'base:plugin:info:enable', 2, None, 0, None, 1, 1),
    (117, '2021-03-05 10:58:25.000000', '2021-03-05 10:58:25.000000', None, '任务管理', None, None, 0, 'icon-activity', 5, None, 1, 1),
    (118, '2021-03-05 10:59:42.000000', '2021-03-05 10:59:42.000000', 117, '任务列表', '/task', None, 1, 'icon-menu', 0, 'cool/modules/task/views/task.vue', 1, 1),
    (119, '2021-03-05 11:00:00.000000', '2021-03-05 11:00:00.000000', 118, '权限', None, 'task:info:page,task:info:list,task:info:info,task:info:add,task:info:delete,task:info:update,task:info:stop,task:info:start,task:info:once,task:info:log', 2, None, 0, None, 1, 1),  # noqa: E501
)

PARAM_FIELDS = ("id", "create_time", "update_time", "key_name", "name", "data", "data_type", "remark")
PARAM_DATA = (
    (1, '2021-02-26 13:53:05.000000', '2021-03-03 17:50:04.000000', 'text', '富文本参数', '<p><strong class=\"ql-size-huge\">111xxxxx2222<span class=\"ql-cursor\">﻿﻿</span></strong></p>', 0, NULL),
    (2, '2021-02-26 13:53:18.000000', '2021-02-26 13:53:18.000000', 'json', 'JSON参数', '{\n    code: 111\n}', 0, NULL)
)

ROLE_FIELDS = ("id", "create_time", "update_time", "user_id", "name", "label", "remark", "relevance")
ROLE_DATA = (
    (1, '2021-02-24 21:18:39.682358', '2021-02-24 21:18:39.682358', '1', '超管', 'admin', '最高权限的角色', 1),
    (10, '2021-02-26 14:15:38.000000', '2021-02-26 14:15:38.000000', '1', '系统管理员', 'admin-sys', NULL, 1),
    (11, '2021-02-26 14:16:49.044744', '2021-02-26 14:16:49.044744', '1', '游客', 'visitor', NULL, 0),
    (12, '2021-02-26 14:26:51.000000', '2021-02-26 14:32:35.000000', '1', '开发', 'dev', NULL, 0),
    (13, '2021-02-26 14:27:58.000000', '2021-02-26 14:33:49.000000', '1', '测试', 'test', NULL, 0),
)

ROLE_MENU_FIELDS = ("id", "create_time", "update_time", "role_id", "menu_id")
ROLE_MENU_DATA = (
    (1, '2021-02-26 12:00:18.240154', '2021-02-26 12:00:18.240154', 8, 1),
    (2, '2021-02-26 12:00:18.342131', '2021-02-26 12:00:18.342131', 8, 96),
    (3, '2021-02-26 12:00:18.444143', '2021-02-26 12:00:18.444143', 8, 45),
    (4, '2021-02-26 12:00:18.545490', '2021-02-26 12:00:18.545490', 8, 43),
    (5, '2021-02-26 12:00:18.649626', '2021-02-26 12:00:18.649626', 8, 49),
    (6, '2021-02-26 12:00:18.752369', '2021-02-26 12:00:18.752369', 8, 86),
    (7, '2021-02-26 12:00:18.856023', '2021-02-26 12:00:18.856023', 8, 2),
    (8, '2021-02-26 12:00:18.956131', '2021-02-26 12:00:18.956131', 8, 27),
    (9, '2021-02-26 12:00:19.071490', '2021-02-26 12:00:19.071490', 8, 97),
    (10, '2021-02-26 12:00:19.171745', '2021-02-26 12:00:19.171745', 8, 59),
    (11, '2021-02-26 12:00:19.274495', '2021-02-26 12:00:19.274495', 8, 60),
    (12, '2021-02-26 12:00:19.374610', '2021-02-26 12:00:19.374610', 8, 61),
    (13, '2021-02-26 12:00:19.474750', '2021-02-26 12:00:19.474750', 8, 62),
    (14, '2021-02-26 12:00:19.573369', '2021-02-26 12:00:19.573369', 8, 63),
    (15, '2021-02-26 12:00:19.674242', '2021-02-26 12:00:19.674242', 8, 65),
    (16, '2021-02-26 12:00:19.772886', '2021-02-26 12:00:19.772886', 8, 98),
    (17, '2021-02-26 12:00:19.874134', '2021-02-26 12:00:19.874134', 8, 99),
    (18, '2021-02-26 12:00:19.972728', '2021-02-26 12:00:19.972728', 8, 100),
    (19, '2021-02-26 12:00:20.085877', '2021-02-26 12:00:20.085877', 8, 101),
    (20, '2021-02-26 12:00:20.192887', '2021-02-26 12:00:20.192887', 8, 8),
    (21, '2021-02-26 12:00:20.293747', '2021-02-26 12:00:20.293747', 8, 10),
    (22, '2021-02-26 12:00:20.393491', '2021-02-26 12:00:20.393491', 8, 11),
    (23, '2021-02-26 12:00:20.495110', '2021-02-26 12:00:20.495110', 8, 12),
    (24, '2021-02-26 12:00:20.594083', '2021-02-26 12:00:20.594083', 8, 13),
    (25, '2021-02-26 12:00:20.695727', '2021-02-26 12:00:20.695727', 8, 22),
    (26, '2021-02-26 12:00:20.794729', '2021-02-26 12:00:20.794729', 8, 23),
    (27, '2021-02-26 12:00:20.895601', '2021-02-26 12:00:20.895601', 8, 24),
    (28, '2021-02-26 12:00:20.994972', '2021-02-26 12:00:20.994972', 8, 25),
    (29, '2021-02-26 12:00:21.110384', '2021-02-26 12:00:21.110384', 8, 26),
    (30, '2021-02-26 12:00:21.210970', '2021-02-26 12:00:21.210970', 8, 69),
    (31, '2021-02-26 12:00:21.311852', '2021-02-26 12:00:21.311852', 8, 70),
    (32, '2021-02-26 12:00:21.411591', '2021-02-26 12:00:21.411591', 8, 71),
    (33, '2021-02-26 12:00:21.513584', '2021-02-26 12:00:21.513584', 8, 72),
    (34, '2021-02-26 12:00:21.612212', '2021-02-26 12:00:21.612212', 8, 73),
    (35, '2021-02-26 12:00:21.712720', '2021-02-26 12:00:21.712720', 8, 74),
    (36, '2021-02-26 12:00:21.812839', '2021-02-26 12:00:21.812839', 8, 75),
    (37, '2021-02-26 12:00:21.913321', '2021-02-26 12:00:21.913321', 8, 76),
    (38, '2021-02-26 12:00:22.013970', '2021-02-26 12:00:22.013970', 8, 77),
    (39, '2021-02-26 12:00:22.144879', '2021-02-26 12:00:22.144879', 8, 78),
    (40, '2021-02-26 12:00:22.246707', '2021-02-26 12:00:22.246707', 8, 79),
    (41, '2021-02-26 12:00:22.347579', '2021-02-26 12:00:22.347579', 8, 80),
    (42, '2021-02-26 12:00:22.446947', '2021-02-26 12:00:22.446947', 8, 81),
    (43, '2021-02-26 12:00:22.547082', '2021-02-26 12:00:22.547082', 8, 82),
    (44, '2021-02-26 12:00:22.647197', '2021-02-26 12:00:22.647197', 8, 83),
    (45, '2021-02-26 12:00:22.748089', '2021-02-26 12:00:22.748089', 8, 105),
    (46, '2021-02-26 12:00:22.847814', '2021-02-26 12:00:22.847814', 8, 102),
    (47, '2021-02-26 12:00:22.949071', '2021-02-26 12:00:22.949071', 8, 103),
    (48, '2021-02-26 12:00:23.047353', '2021-02-26 12:00:23.047353', 8, 29),
    (49, '2021-02-26 12:00:23.147826', '2021-02-26 12:00:23.147826', 8, 30),
    (50, '2021-02-26 12:00:23.246800', '2021-02-26 12:00:23.246800', 8, 47),
    (51, '2021-02-26 12:00:23.349541', '2021-02-26 12:00:23.349541', 8, 48),
    (52, '2021-02-26 12:00:23.463177', '2021-02-26 12:00:23.463177', 8, 84),
    (53, '2021-02-26 12:00:23.564096', '2021-02-26 12:00:23.564096', 8, 90),
    (54, '2021-02-26 12:00:23.663815', '2021-02-26 12:00:23.663815', 8, 85),
    (55, '2021-02-26 12:01:05.971978', '2021-02-26 12:01:05.971978', 9, 1),
    (56, '2021-02-26 12:01:06.085568', '2021-02-26 12:01:06.085568', 9, 96),
    (57, '2021-02-26 12:01:06.198271', '2021-02-26 12:01:06.198271', 9, 45),
    (58, '2021-02-26 12:01:06.309736', '2021-02-26 12:01:06.309736', 9, 43),
    (59, '2021-02-26 12:01:06.410785', '2021-02-26 12:01:06.410785', 9, 49),
    (60, '2021-02-26 12:01:06.510712', '2021-02-26 12:01:06.510712', 9, 86),
    (61, '2021-02-26 12:01:06.612457', '2021-02-26 12:01:06.612457', 9, 2),
    (62, '2021-02-26 12:01:06.710397', '2021-02-26 12:01:06.710397', 9, 27),
    (63, '2021-02-26 12:01:06.809104', '2021-02-26 12:01:06.809104', 9, 97),
    (64, '2021-02-26 12:01:06.907088', '2021-02-26 12:01:06.907088', 9, 59),
    (65, '2021-02-26 12:01:07.009988', '2021-02-26 12:01:07.009988', 9, 60),
    (66, '2021-02-26 12:01:07.122372', '2021-02-26 12:01:07.122372', 9, 61),
    (67, '2021-02-26 12:01:07.223694', '2021-02-26 12:01:07.223694', 9, 62),
    (68, '2021-02-26 12:01:07.325022', '2021-02-26 12:01:07.325022', 9, 63),
    (69, '2021-02-26 12:01:07.425209', '2021-02-26 12:01:07.425209', 9, 65),
    (70, '2021-02-26 12:01:07.522081', '2021-02-26 12:01:07.522081', 9, 98),
    (71, '2021-02-26 12:01:07.622775', '2021-02-26 12:01:07.622775', 9, 99),
    (72, '2021-02-26 12:01:07.721181', '2021-02-26 12:01:07.721181', 9, 100),
    (73, '2021-02-26 12:01:07.819589', '2021-02-26 12:01:07.819589', 9, 101),
    (74, '2021-02-26 12:01:07.920497', '2021-02-26 12:01:07.920497', 9, 8),
    (75, '2021-02-26 12:01:08.018875', '2021-02-26 12:01:08.018875', 9, 10),
    (76, '2021-02-26 12:01:08.135192', '2021-02-26 12:01:08.135192', 9, 11),
    (77, '2021-02-26 12:01:08.246405', '2021-02-26 12:01:08.246405', 9, 12),
    (78, '2021-02-26 12:01:08.346661', '2021-02-26 12:01:08.346661', 9, 13),
    (79, '2021-02-26 12:01:08.448436', '2021-02-26 12:01:08.448436', 9, 22),
    (80, '2021-02-26 12:01:08.547496', '2021-02-26 12:01:08.547496', 9, 23),
    (81, '2021-02-26 12:01:08.648457', '2021-02-26 12:01:08.648457', 9, 24),
    (82, '2021-02-26 12:01:08.750564', '2021-02-26 12:01:08.750564', 9, 25),
    (83, '2021-02-26 12:01:08.851783', '2021-02-26 12:01:08.851783', 9, 26),
    (84, '2021-02-26 12:01:08.950898', '2021-02-26 12:01:08.950898', 9, 69),
    (85, '2021-02-26 12:01:09.061982', '2021-02-26 12:01:09.061982', 9, 70),
    (86, '2021-02-26 12:01:09.165258', '2021-02-26 12:01:09.165258', 9, 71),
    (87, '2021-02-26 12:01:09.266177', '2021-02-26 12:01:09.266177', 9, 72),
    (88, '2021-02-26 12:01:09.366427', '2021-02-26 12:01:09.366427', 9, 73),
    (89, '2021-02-26 12:01:09.467877', '2021-02-26 12:01:09.467877', 9, 74),
    (90, '2021-02-26 12:01:09.568526', '2021-02-26 12:01:09.568526', 9, 75),
    (91, '2021-02-26 12:01:09.668052', '2021-02-26 12:01:09.668052', 9, 76),
    (92, '2021-02-26 12:01:09.766367', '2021-02-26 12:01:09.766367', 9, 77),
    (93, '2021-02-26 12:01:09.866170', '2021-02-26 12:01:09.866170', 9, 78),
    (94, '2021-02-26 12:01:09.963037', '2021-02-26 12:01:09.963037', 9, 79),
    (95, '2021-02-26 12:01:10.082046', '2021-02-26 12:01:10.082046', 9, 80),
    (96, '2021-02-26 12:01:10.185024', '2021-02-26 12:01:10.185024', 9, 81),
    (97, '2021-02-26 12:01:10.283787', '2021-02-26 12:01:10.283787', 9, 82),
    (98, '2021-02-26 12:01:10.382883', '2021-02-26 12:01:10.382883', 9, 83),
    (99, '2021-02-26 12:01:10.481150', '2021-02-26 12:01:10.481150', 9, 105),
    (100, '2021-02-26 12:01:10.579579', '2021-02-26 12:01:10.579579', 9, 102),
    (101, '2021-02-26 12:01:10.679489', '2021-02-26 12:01:10.679489', 9, 103),
    (102, '2021-02-26 12:01:10.777496', '2021-02-26 12:01:10.777496', 9, 29),
    (103, '2021-02-26 12:01:10.878292', '2021-02-26 12:01:10.878292', 9, 30),
    (104, '2021-02-26 12:01:10.977354', '2021-02-26 12:01:10.977354', 9, 47),
    (105, '2021-02-26 12:01:11.097786', '2021-02-26 12:01:11.097786', 9, 48),
    (106, '2021-02-26 12:01:11.201390', '2021-02-26 12:01:11.201390', 9, 84),
    (107, '2021-02-26 12:01:11.302120', '2021-02-26 12:01:11.302120', 9, 90),
    (108, '2021-02-26 12:01:11.402751', '2021-02-26 12:01:11.402751', 9, 85),
    (161, '2021-02-26 14:16:49.162546', '2021-02-26 14:16:49.162546', 11, 1),
    (162, '2021-02-26 14:16:49.257677', '2021-02-26 14:16:49.257677', 11, 96),
    (163, '2021-02-26 14:16:49.356225', '2021-02-26 14:16:49.356225', 11, 45),
    (164, '2021-02-26 14:16:49.450708', '2021-02-26 14:16:49.450708', 11, 43),
    (165, '2021-02-26 14:16:49.543794', '2021-02-26 14:16:49.543794', 11, 49),
    (166, '2021-02-26 14:16:49.636496', '2021-02-26 14:16:49.636496', 11, 86),
    (167, '2021-02-26 14:16:49.728634', '2021-02-26 14:16:49.728634', 11, 47),
    (168, '2021-02-26 14:16:49.824754', '2021-02-26 14:16:49.824754', 11, 48),
    (169, '2021-02-26 14:16:49.919329', '2021-02-26 14:16:49.919329', 11, 85),
    (170, '2021-02-26 14:16:50.015239', '2021-02-26 14:16:50.015239', 11, 84),
    (290, '2021-02-26 14:32:35.143867', '2021-02-26 14:32:35.143867', 12, 1),
    (291, '2021-02-26 14:32:35.239965', '2021-02-26 14:32:35.239965', 12, 96),
    (292, '2021-02-26 14:32:35.336398', '2021-02-26 14:32:35.336398', 12, 45),
    (293, '2021-02-26 14:32:35.435180', '2021-02-26 14:32:35.435180', 12, 43),
    (294, '2021-02-26 14:32:35.528631', '2021-02-26 14:32:35.528631', 12, 49),
    (295, '2021-02-26 14:32:35.623123', '2021-02-26 14:32:35.623123', 12, 86),
    (296, '2021-02-26 14:32:35.718831', '2021-02-26 14:32:35.718831', 12, 2),
    (297, '2021-02-26 14:32:35.812975', '2021-02-26 14:32:35.812975', 12, 27),
    (298, '2021-02-26 14:32:35.904487', '2021-02-26 14:32:35.904487', 12, 97),
    (299, '2021-02-26 14:32:35.998773', '2021-02-26 14:32:35.998773', 12, 59),
    (300, '2021-02-26 14:32:36.107749', '2021-02-26 14:32:36.107749', 12, 60),
    (301, '2021-02-26 14:32:36.213069', '2021-02-26 14:32:36.213069', 12, 61),
    (302, '2021-02-26 14:32:36.308985', '2021-02-26 14:32:36.308985', 12, 62),
    (303, '2021-02-26 14:32:36.404237', '2021-02-26 14:32:36.404237', 12, 63),
    (304, '2021-02-26 14:32:36.499569', '2021-02-26 14:32:36.499569', 12, 65),
    (305, '2021-02-26 14:32:36.593710', '2021-02-26 14:32:36.593710', 12, 98),
    (306, '2021-02-26 14:32:36.685988', '2021-02-26 14:32:36.685988', 12, 99),
    (307, '2021-02-26 14:32:36.778733', '2021-02-26 14:32:36.778733', 12, 100),
    (308, '2021-02-26 14:32:36.874715', '2021-02-26 14:32:36.874715', 12, 101),
    (309, '2021-02-26 14:32:36.973153', '2021-02-26 14:32:36.973153', 12, 8),
    (310, '2021-02-26 14:32:37.082734', '2021-02-26 14:32:37.082734', 12, 10),
    (311, '2021-02-26 14:32:37.176859', '2021-02-26 14:32:37.176859', 12, 11),
    (312, '2021-02-26 14:32:37.271440', '2021-02-26 14:32:37.271440', 12, 12),
    (313, '2021-02-26 14:32:37.365206', '2021-02-26 14:32:37.365206', 12, 13),
    (314, '2021-02-26 14:32:37.457092', '2021-02-26 14:32:37.457092', 12, 22),
    (315, '2021-02-26 14:32:37.549860', '2021-02-26 14:32:37.549860', 12, 23),
    (316, '2021-02-26 14:32:37.645684', '2021-02-26 14:32:37.645684', 12, 24),
    (317, '2021-02-26 14:32:37.743370', '2021-02-26 14:32:37.743370', 12, 25),
    (318, '2021-02-26 14:32:37.837218', '2021-02-26 14:32:37.837218', 12, 26),
    (319, '2021-02-26 14:32:37.930953', '2021-02-26 14:32:37.930953', 12, 69),
    (320, '2021-02-26 14:32:38.031191', '2021-02-26 14:32:38.031191', 12, 70),
    (321, '2021-02-26 14:32:38.130839', '2021-02-26 14:32:38.130839', 12, 71),
    (322, '2021-02-26 14:32:38.229359', '2021-02-26 14:32:38.229359', 12, 72),
    (323, '2021-02-26 14:32:38.323868', '2021-02-26 14:32:38.323868', 12, 73),
    (324, '2021-02-26 14:32:38.415194', '2021-02-26 14:32:38.415194', 12, 74),
    (325, '2021-02-26 14:32:38.505597', '2021-02-26 14:32:38.505597', 12, 75),
    (326, '2021-02-26 14:32:38.600426', '2021-02-26 14:32:38.600426', 12, 76),
    (327, '2021-02-26 14:32:38.698676', '2021-02-26 14:32:38.698676', 12, 77),
    (328, '2021-02-26 14:32:38.793832', '2021-02-26 14:32:38.793832', 12, 78),
    (329, '2021-02-26 14:32:38.889203', '2021-02-26 14:32:38.889203', 12, 79),
    (330, '2021-02-26 14:32:38.985851', '2021-02-26 14:32:38.985851', 12, 80),
    (331, '2021-02-26 14:32:39.092110', '2021-02-26 14:32:39.092110', 12, 81),
    (332, '2021-02-26 14:32:39.188945', '2021-02-26 14:32:39.188945', 12, 82),
    (333, '2021-02-26 14:32:39.280043', '2021-02-26 14:32:39.280043', 12, 83),
    (334, '2021-02-26 14:32:39.374899', '2021-02-26 14:32:39.374899', 12, 105),
    (335, '2021-02-26 14:32:39.473563', '2021-02-26 14:32:39.473563', 12, 102),
    (336, '2021-02-26 14:32:39.570921', '2021-02-26 14:32:39.570921', 12, 103),
    (337, '2021-02-26 14:32:39.665052', '2021-02-26 14:32:39.665052', 12, 29),
    (338, '2021-02-26 14:32:39.760189', '2021-02-26 14:32:39.760189', 12, 30),
    (339, '2021-02-26 14:32:39.852856', '2021-02-26 14:32:39.852856', 12, 47),
    (340, '2021-02-26 14:32:39.944180', '2021-02-26 14:32:39.944180', 12, 48),
    (341, '2021-02-26 14:32:40.038086', '2021-02-26 14:32:40.038086', 12, 84),
    (342, '2021-02-26 14:32:40.135874', '2021-02-26 14:32:40.135874', 12, 90),
    (343, '2021-02-26 14:32:40.234015', '2021-02-26 14:32:40.234015', 12, 85),
    (355, '2021-02-26 14:32:54.538822', '2021-02-26 14:32:54.538822', 10, 1),
    (356, '2021-02-26 14:32:54.634784', '2021-02-26 14:32:54.634784', 10, 96),
    (357, '2021-02-26 14:32:54.732878', '2021-02-26 14:32:54.732878', 10, 45),
    (358, '2021-02-26 14:32:54.826023', '2021-02-26 14:32:54.826023', 10, 43),
    (359, '2021-02-26 14:32:54.920173', '2021-02-26 14:32:54.920173', 10, 49),
    (360, '2021-02-26 14:32:55.019141', '2021-02-26 14:32:55.019141', 10, 86),
    (361, '2021-02-26 14:32:55.119438', '2021-02-26 14:32:55.119438', 10, 2),
    (362, '2021-02-26 14:32:55.211471', '2021-02-26 14:32:55.211471', 10, 27),
    (363, '2021-02-26 14:32:55.304855', '2021-02-26 14:32:55.304855', 10, 97),
    (364, '2021-02-26 14:32:55.397939', '2021-02-26 14:32:55.397939', 10, 59),
    (365, '2021-02-26 14:32:55.491674', '2021-02-26 14:32:55.491674', 10, 60),
    (366, '2021-02-26 14:32:55.584051', '2021-02-26 14:32:55.584051', 10, 61),
    (367, '2021-02-26 14:32:55.676449', '2021-02-26 14:32:55.676449', 10, 62),
    (368, '2021-02-26 14:32:55.774524', '2021-02-26 14:32:55.774524', 10, 63),
    (369, '2021-02-26 14:32:55.871634', '2021-02-26 14:32:55.871634', 10, 65),
    (370, '2021-02-26 14:32:55.964611', '2021-02-26 14:32:55.964611', 10, 98),
    (371, '2021-02-26 14:32:56.074043', '2021-02-26 14:32:56.074043', 10, 99),
    (372, '2021-02-26 14:32:56.169316', '2021-02-26 14:32:56.169316', 10, 100),
    (373, '2021-02-26 14:32:56.263408', '2021-02-26 14:32:56.263408', 10, 101),
    (374, '2021-02-26 14:32:56.356537', '2021-02-26 14:32:56.356537', 10, 8),
    (375, '2021-02-26 14:32:56.448195', '2021-02-26 14:32:56.448195', 10, 10),
    (376, '2021-02-26 14:32:56.544394', '2021-02-26 14:32:56.544394', 10, 11),
    (377, '2021-02-26 14:32:56.641515', '2021-02-26 14:32:56.641515', 10, 12),
    (378, '2021-02-26 14:32:56.735242', '2021-02-26 14:32:56.735242', 10, 13),
    (379, '2021-02-26 14:32:56.828811', '2021-02-26 14:32:56.828811', 10, 22),
    (380, '2021-02-26 14:32:56.922664', '2021-02-26 14:32:56.922664', 10, 23),
    (381, '2021-02-26 14:32:57.016873', '2021-02-26 14:32:57.016873', 10, 24),
    (382, '2021-02-26 14:32:57.123800', '2021-02-26 14:32:57.123800', 10, 25),
    (383, '2021-02-26 14:32:57.223306', '2021-02-26 14:32:57.223306', 10, 26),
    (384, '2021-02-26 14:32:57.328482', '2021-02-26 14:32:57.328482', 10, 69),
    (385, '2021-02-26 14:32:57.430006', '2021-02-26 14:32:57.430006', 10, 70),
    (386, '2021-02-26 14:32:57.521664', '2021-02-26 14:32:57.521664', 10, 71),
    (387, '2021-02-26 14:32:57.612399', '2021-02-26 14:32:57.612399', 10, 72),
    (388, '2021-02-26 14:32:57.705553', '2021-02-26 14:32:57.705553', 10, 73),
    (389, '2021-02-26 14:32:57.799288', '2021-02-26 14:32:57.799288', 10, 74),
    (390, '2021-02-26 14:32:57.893894', '2021-02-26 14:32:57.893894', 10, 75),
    (391, '2021-02-26 14:32:57.988856', '2021-02-26 14:32:57.988856', 10, 76),
    (392, '2021-02-26 14:32:58.090250', '2021-02-26 14:32:58.090250', 10, 77),
    (393, '2021-02-26 14:32:58.196616', '2021-02-26 14:32:58.196616', 10, 78),
    (394, '2021-02-26 14:32:58.288151', '2021-02-26 14:32:58.288151', 10, 79),
    (395, '2021-02-26 14:32:58.378493', '2021-02-26 14:32:58.378493', 10, 80),
    (396, '2021-02-26 14:32:58.471283', '2021-02-26 14:32:58.471283', 10, 81),
    (397, '2021-02-26 14:32:58.564666', '2021-02-26 14:32:58.564666', 10, 82),
    (398, '2021-02-26 14:32:58.658511', '2021-02-26 14:32:58.658511', 10, 83),
    (399, '2021-02-26 14:32:58.752713', '2021-02-26 14:32:58.752713', 10, 105),
    (400, '2021-02-26 14:32:58.849472', '2021-02-26 14:32:58.849472', 10, 102),
    (401, '2021-02-26 14:32:58.948387', '2021-02-26 14:32:58.948387', 10, 103),
    (402, '2021-02-26 14:32:59.042410', '2021-02-26 14:32:59.042410', 10, 29),
    (403, '2021-02-26 14:32:59.132594', '2021-02-26 14:32:59.132594', 10, 30),
    (404, '2021-02-26 14:32:59.226150', '2021-02-26 14:32:59.226150', 10, 47),
    (405, '2021-02-26 14:32:59.319494', '2021-02-26 14:32:59.319494', 10, 48),
    (406, '2021-02-26 14:32:59.413370', '2021-02-26 14:32:59.413370', 10, 84),
    (407, '2021-02-26 14:32:59.507584', '2021-02-26 14:32:59.507584', 10, 90),
    (408, '2021-02-26 14:32:59.604332', '2021-02-26 14:32:59.604332', 10, 85),
    (463, '2021-02-26 14:33:49.310315', '2021-02-26 14:33:49.310315', 13, 1),
    (464, '2021-02-26 14:33:49.403445', '2021-02-26 14:33:49.403445', 13, 96),
    (465, '2021-02-26 14:33:49.496802', '2021-02-26 14:33:49.496802', 13, 45),
    (466, '2021-02-26 14:33:49.595210', '2021-02-26 14:33:49.595210', 13, 43),
    (467, '2021-02-26 14:33:49.688024', '2021-02-26 14:33:49.688024', 13, 49),
    (468, '2021-02-26 14:33:49.781292', '2021-02-26 14:33:49.781292', 13, 86),
    (469, '2021-02-26 14:33:49.874061', '2021-02-26 14:33:49.874061', 13, 2),
    (470, '2021-02-26 14:33:49.965534', '2021-02-26 14:33:49.965534', 13, 27),
    (471, '2021-02-26 14:33:50.072373', '2021-02-26 14:33:50.072373', 13, 97),
    (472, '2021-02-26 14:33:50.176473', '2021-02-26 14:33:50.176473', 13, 59),
    (473, '2021-02-26 14:33:50.272264', '2021-02-26 14:33:50.272264', 13, 60),
    (474, '2021-02-26 14:33:50.370328', '2021-02-26 14:33:50.370328', 13, 61),
    (475, '2021-02-26 14:33:50.463159', '2021-02-26 14:33:50.463159', 13, 62),
    (476, '2021-02-26 14:33:50.557911', '2021-02-26 14:33:50.557911', 13, 63),
    (477, '2021-02-26 14:33:50.650669', '2021-02-26 14:33:50.650669', 13, 65),
    (478, '2021-02-26 14:33:50.742871', '2021-02-26 14:33:50.742871', 13, 98),
    (479, '2021-02-26 14:33:50.838052', '2021-02-26 14:33:50.838052', 13, 99),
    (480, '2021-02-26 14:33:50.932201', '2021-02-26 14:33:50.932201', 13, 100),
    (481, '2021-02-26 14:33:51.030973', '2021-02-26 14:33:51.030973', 13, 101),
    (482, '2021-02-26 14:33:51.168873', '2021-02-26 14:33:51.168873', 13, 8),
    (483, '2021-02-26 14:33:51.265779', '2021-02-26 14:33:51.265779', 13, 10),
    (484, '2021-02-26 14:33:51.379934', '2021-02-26 14:33:51.379934', 13, 11),
    (485, '2021-02-26 14:33:51.473016', '2021-02-26 14:33:51.473016', 13, 12),
    (486, '2021-02-26 14:33:51.568753', '2021-02-26 14:33:51.568753', 13, 13),
    (487, '2021-02-26 14:33:51.667262', '2021-02-26 14:33:51.667262', 13, 22),
    (488, '2021-02-26 14:33:51.761865', '2021-02-26 14:33:51.761865', 13, 23),
    (489, '2021-02-26 14:33:51.857295', '2021-02-26 14:33:51.857295', 13, 24),
    (490, '2021-02-26 14:33:51.951231', '2021-02-26 14:33:51.951231', 13, 25),
    (491, '2021-02-26 14:33:52.047431', '2021-02-26 14:33:52.047431', 13, 26),
    (492, '2021-02-26 14:33:52.141210', '2021-02-26 14:33:52.141210', 13, 69),
    (493, '2021-02-26 14:33:52.236892', '2021-02-26 14:33:52.236892', 13, 70),
    (494, '2021-02-26 14:33:52.332986', '2021-02-26 14:33:52.332986', 13, 71),
    (495, '2021-02-26 14:33:52.432629', '2021-02-26 14:33:52.432629', 13, 72),
    (496, '2021-02-26 14:33:52.529105', '2021-02-26 14:33:52.529105', 13, 73),
    (497, '2021-02-26 14:33:52.625291', '2021-02-26 14:33:52.625291', 13, 74),
    (498, '2021-02-26 14:33:52.721109', '2021-02-26 14:33:52.721109', 13, 75),
    (499, '2021-02-26 14:33:52.813753', '2021-02-26 14:33:52.813753', 13, 76),
    (500, '2021-02-26 14:33:52.905436', '2021-02-26 14:33:52.905436', 13, 77),
    (501, '2021-02-26 14:33:52.998499', '2021-02-26 14:33:52.998499', 13, 78),
    (502, '2021-02-26 14:33:53.100975', '2021-02-26 14:33:53.100975', 13, 79),
    (503, '2021-02-26 14:33:53.199493', '2021-02-26 14:33:53.199493', 13, 80),
    (504, '2021-02-26 14:33:53.294088', '2021-02-26 14:33:53.294088', 13, 81),
    (505, '2021-02-26 14:33:53.391390', '2021-02-26 14:33:53.391390', 13, 82),
    (506, '2021-02-26 14:33:53.486104', '2021-02-26 14:33:53.486104', 13, 83),
    (507, '2021-02-26 14:33:53.578385', '2021-02-26 14:33:53.578385', 13, 105),
    (508, '2021-02-26 14:33:53.670073', '2021-02-26 14:33:53.670073', 13, 102),
    (509, '2021-02-26 14:33:53.763868', '2021-02-26 14:33:53.763868', 13, 103),
    (510, '2021-02-26 14:33:53.860706', '2021-02-26 14:33:53.860706', 13, 29),
    (511, '2021-02-26 14:33:53.959262', '2021-02-26 14:33:53.959262', 13, 30),
    (512, '2021-02-26 14:33:54.064932', '2021-02-26 14:33:54.064932', 13, 47),
    (513, '2021-02-26 14:33:54.168918', '2021-02-26 14:33:54.168918', 13, 48),
    (514, '2021-02-26 14:33:54.273982', '2021-02-26 14:33:54.273982', 13, 84),
    (515, '2021-02-26 14:33:54.366992', '2021-02-26 14:33:54.366992', 13, 90),
    (516, '2021-02-26 14:33:54.458682', '2021-02-26 14:33:54.458682', 13, 85),
)

# fmt: on


class Command(BaseCommand):
    help = "Used to create a superuser for ubox admin."

    def add_arguments(self, parser):
        """
        添加命令参数

        @param parser: see also: https://docs.python.org/3/library/argparse.html#module-argparse
        """
        ...

    def handle(self, *args, **options):
        insert_or_update(AppSpaceType, APP_SPACE_TYPE_FIELDS, APP_SPACE_TYPE_DATA)
        insert_or_update(Conf, CONF_FIELDS, CONF_DATA)
        insert_or_update(Department, DEPARTMENT_FIELDS, DEPARTMENT_DATA)
        insert_or_update(Menu, MENU_FIELDS, MENU_DATA)
        insert_or_update(Param, PARAM_FIELDS, PARAM_DATA)
        insert_or_update(Role, ROLE_FIELDS, ROLE_DATA)
        insert_or_update(RoleMenu, ROLE_MENU_FIELDS, ROLE_MENU_DATA)
