"""Most common abbreviations for product names."""
from typing import Dict


PRODUCTS: Dict[str, str] = {
    "морож": "мороженое",
    "плом": "пломбир",
    "ароматиз": "ароматизатор",
    "нап": "напиток",
    "напи": "напиток",
    "напит": "напиток",
    "подгуз-трус": "подгузники",
    "пив": "пиво",
    "ср-во": "средство",
    "пельм": "пельмени",
    "молшок": "шоколад",
    "бискв": "бисквит",
    "хлоп": "хлопья",
    "конф": "конфеты",
    "шокол": "шоколад",
    "сгущ": "сгущёнка",
    "яг": "ягоды",
    "карт": "картотфель",
    "майон": "майонез",
    "мак": "макароны",
    "лап": "лапша",
    "кр": "красная",
    "печ": "печенье",
    "салф": "салфетки",
    "бум": "бумага",
    "прян": "пряники",
    "пломб": "пломбир",
    "проклад": "прокладки",
    "кукур": "кукуруза",
    "йог": "йогурт",
    "груд": "грудка",
    "упаков": "упаковка",
    "батонч": "батончик",
    "бат": "батон",
    "глаз": "глазурь",
    "свин": "свинина",
    "круас": "круасаны",
    "базил": "базилик",
    "пос": "посуда",
    "трюф": "трюфель",
    "вар": "варенье",
    "жев": "жевательная резинка",
    "рез": "резинка",
    "лик": "ликер",
    "бифшт": "бифштекс",
    "сосис": "сосиски",
    "твор": "творог",
    "биск": "бисквит",
    "лаком": "лакомство",
    "кетч": "кетчуп",
    "пирож": "пирожное",
    "подуш": "подушечки",
    "колб": "колбаса",
    "наб": "набор",
    "tea": "чай",
    "шамп": "шампанское",
    "осв": "освежитель",
    "воз": "воздух",
    "возд": "воздух",
    "филе-кусок": "филе",
    "крем-мыло": "мыло",
    "мини-сушки": "сушки",
    "лук-репка": "лук",
    "отбел": "отбеливатель",
    "биотвор": "биотворог",
    "биойог": "биойогурт",
    "вин": "вино",
    "сард": "сардельки",
    "припр": "приправа",
    "мол": "молоко",
    "шок": "шоколад",
    "пакет-майка": "пакет",
    "печен": "печенье",
    "штруд": "штрудель",
    "пашт": "паштет",
    "марм": "мармелад",
    "дес": "десерт",
    "жеврезинка": "жевательная резинка",
    "лим кислота": "лимонная кислота",
    "том.паста": "томатная паста",
    "ваф": "вафли",
    "спагет": "спагетти",
    "мюс": "мюсли",
    "кор": "коре",
    "наполн": "наполнитель",
    "макар": "макароны",
    "порош": "порошок",
    "tоматы": "томаты",
    "сред": "средство",
    "свечи-мини": "свечи",
    "шам": "шампунь",
    "нект": "нектар",
    "зп": "зубная паста",
    "сухар": "сухари",
    "приправ": "приправа",
    "котл": "котлета",
    "прокл": "прокладки",
    "салфет": "салфетки",
    "мармел": "мармелад",
    "багета": "багет",
    "горош": "горошек",
    "семеч": "семечки",
    "кренд": "крендели",
    "пасх": "пасха",
    "зажиг": "зажигалка",
    "сырчечилспаг": "сыр",
    "антиперсп": "антиперспант",
    "бальз-опол": "бальзам",
    "бзмжсыр": "сыр",
    "био-йогу": "биойогурт",
    "био-йогурт": "биойогурт",
    "биотв": "биотворог",
    "бумаг": "бумага",
    "вермиш": "вермишель",
    "гель-эксп": "гель",
    "зажигалок": "зажигалка",
    "кнофеты": "конфеты",
    "крем-мыл": "мыло",
    "кэфир": "кефир",
    "лосьон-тон": "лосьон",
    "макарон": "макароны",
    "манг": "манго",
    "морожен": "мороженое",
    "пирожн": "пирожное",
    "подг": "подгузники",
    "презерв": "презервативы",
    "сосиск": "сосиски",
    "тамп": "тампоны",
    "разрыхлит": "разрыхлитель",
    "красит": "краситель",
}

"""Вot brands, anglicisms and acronyms."""
BRANDS: Dict[str, str] = {
    "д.в д": "домик в деревне",
    "д.в.д": "домик в деревне",
    "хл.сп": "хлебный спас",
    "к.ц.": "красная цена",
    "кр.ц.": "красная цена",
    "кр.цена": "красная цена",
    "пр!ст": "просто",
    "орео": "oreo",
    "п.св": "первая свежесть",
    "раст": "растишка",
    "гранд дуэт": "grand duet",
    "прост.": "простоквашино",
    "прост ": "простоквашино",
    "mil gen": "miller genuine",
    "шарл": "шарлиз",
    "домашняя кухн": "домашняя кухня",
    "крикет": "cricket",
    "домик в дерев": "домик в деревне",
    "акт.": "актвия",
    "озор.пчел": "озорная пчелка",
    "вор.сух": "воронцовские сухарики",
    "mr.ricco": "mr. ricco",
    "geese": "geese",
    "dr.korner": "dr. korner",
    "dr.oetker": "dr. oetker",
    "alp.gold": "alpen gold",
    "mil.gen.dr": "miller",
    "био-бал.": "bio balance",
    "epica": "epica",
    "с.прид": "сады придонья",
    "g.gold": "gourmet gold",
    "colg.з/п": "colgate",
    "с.пудовъ": "с. пудовъ",
    "сибирск.коллекция": "сибирская коллекция",
    "(данон)": "danone",
    "lay`": "lays",
    "кока-кола": "coca-cola",
    "марс": "mars",
    "нестле": "nestle",
    "брест-литовск": "брест-литовский",
    "lay's": "lays",
    "хенкель": "henkel",
    "gl.vil": "global village",
    "bar": "barilla",
    "tol": "tolli",
    "юбил.": "юбилейное",
    "астор": "astoria",
    "бар.": "барни",
    "рот фронт": "ротфронт",
    "роллт": "роллтон",
    "верхов.": "верховье",
    "мист.": "мистраль",
    "иммун": "иммунеле",
    "рест.": "рестория",
    "зд.мен.": "здоровое меню",
    " вв ": "вкусвилл",
    "зелен. линия": "зеленая линия",
    "комм.": "коммунарка",
    "волоконовско": "волоконовское",
    "олвейс": "always",
    "пантин": "pantene",
    "палмолив": "palmolive",
    "жатецкий гусь": "zatecky gus",
    "советские традиц": "советские традиции",
    "президент": "president",
    "стародв": "стародворские",
    "альметте": "almette",
    "дом в дер": "домик в деревне",
    "дом дер": "домик в деревне",
    "дом.в дер.": "домик в деревне",
    "виола виттр": "виола виттрока",
    "золот ларец": "золотой ларец",
    "клинск": "клинский",
    "добр ": "добрый",
    "добр. ": "добрый",
    "хл.д.": "хлебный дом",
    "рублев": "рублевский",
    "фрутм.": "фрутмотив",
    "черкизов.": "черкизовский",
    "пилигр.": "пилигрим",
    "кремлев": "кремлевский",
    "гессер": "gosser",
    "воронц": "воронцовские",
    "гранола": "granola",
    "r.sp.": "ritter sport",
    "sиб.кол.": "сибирская коллекция",
    "яр.бройл.": "ярославский бройлер",
    "кузм.": "кузмино",
    "виола": "viola",
    "чупа чупс": "chupa chups",
    "наше солнышк": "наше солнышко",
    "ролл": "роллтон",
    "зева": "zewa",
    "б.ю.алекс.": "б.ю.александров",
    "мамба": "mamba",
    "эком.": "ecomilk",
    "савушк.": "савушкин хуторок",
    "милка": "milka",
    "виолетта": "Violette",
    "марк.пер.": "маркет перекресток",
    "национ.": "националь",
    "пр.кав.": "предгорье кавказа",
    "велк.": "велком",
    "байс.": "baisad",
    "ростагроэкс": "ростагроэкспорт",
    "слав.": "славянка",
    "варен.": "варенька",
    "хейнек.": "heineken",
    "гринфилдголден": "greenfield",
    "стр.вас.": "страна васильки",
    "бархатные ручк": "бархатные ручки",
    "велле": "velle",
    "терре аллегре": "terre allegre",
    "зелен.линия": "зеленая линия",
    "ильина": "от ильиной",
    "данон": "danone",
    "юби.": "юбилейное",
    "больш.кружка": "большая кружка",
    "рязан.": "рязаночка",
    "вдох.": "вдохновение",
    "озби": "семейка озби",
    "ландлибе": "landliebe",
    "асен.фер.": "асеньевская ферма",
    "приос.": "приосколье",
    "б.ю. алексан": "б.ю. александров",
    "б.ю.алексан": "б.ю. александров",
    "б.ю.александров": "б.ю. александров",
    "б.ю. александров": "б.ю. александров",
    "азов.кф": "азовская кф",
    "феликс": "felix",
    "з.боч": "золотая бочка",
    "пр.ява": "принцесса ява",
    "золот.ярлык": "золотой ярлык",
    "село зел.": "село зеленое",
    "оral-в": "оral-b",
    "рог.": "рогачевъ",
    "золотая симф.": "золотая симфония",
    "золот стан": "золотой стандарт",
    "mентос": "mentos",
    "men.": "mentos",
    "дан.": "danone",
    "петр ": "петр I",
    "ява ": "ява",
    "лд ": "LD",
    "люб.": "любимый",
    "act.": "activia",
    "сенатор": "senator",
    "мальборо": "marlboro",
    "филип моррис": "philip morris",
    "филлип моррис": "philip morris",
    "винстон": "winston",
    "бонд": "bond",
    "ротманс": "rothmans",
    "эссе": "esse",
    "bon": "bonduelle",
    "магги": "maggi",
    "чист.лин.": "чистая линия",
    "рост.": "ростагроэкспорт",
    "залесск.фермер": "залесский фермер",
    "kаmis": "kamis",
    "мистер пропер": "mr. proper",
    "лейз": "lays",
    "natur.": "natural",
    "alw.": "always",
    "tur.dies.": "turbo diesel",
    "мдб": "мясной дом бородина",
    "три короч.": "три корочки",
    "pur.": "purina",
    "nest.": "nestle",
    "bio баланс": "bio balance",
    "посид.": "посиделкино",
    "сл.слоб.": "сладкая слобода",
    "ост.": "останкино",
    "ког.я выр.": "когда я вырасту",
    "ког.я.выр.": "когда я вырасту",
    "coca-c.": "coca-cola",
    "хугар.": "hoegaarden",
    "хугарден": "hoegaarden",
    "черног.": "черноголовка",
    "мерси": "mersi",
    "чоко пай": "chocopie",
    "мос.кар.": "московский картофель",
    "maxib.": "maxibon",
    "р.хол.": "русский холод",
    "extr.": "extreme",
    "свитл.": "свитлогорье",
    "дом.кух.": "домашняя кухня",
    "дом кух": "домашняя кухня",
    "китекат": "kitekat",
    "контекс": "contex",
    "лукоил": "lukoil",
    "орбит": "orbit",
    "пепси": "pepsi",
    "простокваш": "простоквашино",
    "простоквашино": "простоквашино",
    "раули мерло": "rauli merlot",
    "ядрена коп": "ядрена копоть",
    "ядрена": "ядрена копоть",
    "тетри": "tetri",
    "зол.капли": "золотые капли",
    "мария": "любятово",
    "нев.косм.": "невская косметика",
    "шато тамань": "chateau tamagne",
    "DR.OETK.": "dr. oetker",
    "баб.": "бабаевский",
    "меллер": "meller",
    "кр.лин.": "красная линия",
    "мос.пр.": "московский провансаль",
    "м.к.": "морской котик",
    "обер.": "обережье",
    "б.бер.": "балтийский берег",
    "ясно солны": "ясно солнышко",
    "коров.": "коровка",
    "любят.": "любятово",
    "рус.нива": "русская нива",
    "алекс.": "б. ю. александров",
    "спрайт": "sprite",
    "фанта": "fanta",
    "фр.сад": "фруктовый сад",
    "дюарс": "dewars",
    "вологод.пломбир": "вологодский пломбир",
    "greenf": "greenfield",
    "hochl": "hochland",
    "nesc": "nescafe",
    "ч лин": "чистая линия",
    "pres": "president",
    "бабаев": "бабаевский",
    "дош": "доширак",
    "бр-лит": "брест-литовский",
    "lor.": "lorenz naturals",
    "dan": "danone",
    "bond": "bonduelle",
    "colg": "colgate",
    "сады прид.": "сады придонья",
    "ч.линия": "чистая линия",
    "кп/": "красная птица",
    "кд/": "каждый день",
    "lay`s/": "lays",
    " я/": "я",
    "/я ": "я",
    "кр/цена": "красня цена",
    "д/ваня": "дядя ваня",
    "дом.в/дер.": "домик в деревне",
}

SLASH_PRODUCTS: Dict[str, str] = {
    "б/йог": "биойогурт",
    "сух/завтрак": "сухой завтрак",
    "з/щ": "зубная щётка",
    "йогурт/смусси": "йогурт",
    "т/бумага": "туалетная бумага",
    "укроп/петрушк": "зелень",
    "б/полотенца": "бумажные полотенца",
    "з/паста": "зубная паста",
    "т/мыло": "мыло",
    "ж/мыло": "жидкое мыло",
    "бум/салф": "бумажные полотенца",
    "з/п": "зубная паста",
    "шамп/бал": "шампунь",
    "с/порошок": "порошок",
    "ш/р": "шариковая ручка",
    "т/бум": "тулетная бумага",
}

BRANDS_WITH_NUMBERS: Dict[str, str] = {
    "кр.с 1901г": "чай краснодарский с 1901 года",
    "365 дней": "365 дней",
    "365дней": "365 дней",
    "7 days": "7 days",
    "7days": "7 days",
    "7day": "7 days",
    "6 соток": "6 соток",
    "6соток": "6 соток",
    "5 морей": "5 морей",
    "5морей": "5 морей",
    "4 сезона": "",
    "7 up": "7 up",
    "7up": "7 up",
    "3 glocken": "3 glocken",
    "3glocken": "3 glocken",
    "1 toy": "1 toy",
    "1toy": "1 toy",
    "48 копеек": "48 копеек",
    "48копеек": "48 копеек",
    "48 коп": "48 копеек",
    "48коп": "48 копеек",
    "got2b": "got2b",
    "хлебозавод 28": "",
    "хлебозавод28": "",
    "4life": "4 life",
    "4 life": "4 life",
    "36 копеек": "36 копеек",
    "36копеек": "36 копеек",
    "36 коп": "36 копеек",
    "36коп": "36 копеек",
    "101 зерно": "101 зерно",
    "101зерно": "101 зерно",
    "5 океанов": "5 океанов",
    "5океанов": "5 океанов",
    "j-7": "j-7",
    "j7": "j-7",
    "петр I": "петр I",
    "петрI": "петр I",
    "петр 1": "петр I",
    "петр1": "петр I",
    "7 злаков": "7 злаков",
    "7злаков": "7 злаков",
}
