"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.CfnHelm = exports.toJson_CfnHelmPropsVpcConfiguration = exports.toJson_CfnHelmProps = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
// Generated by cdk-import
const cdk = require("aws-cdk-lib");
/**
 * Converts an object of type 'CfnHelmProps' to JSON representation.
 */
/* eslint-disable max-len, quote-props */
function toJson_CfnHelmProps(obj) {
    if (obj === undefined) {
        return undefined;
    }
    const result = {
        'ClusterID': obj.clusterId,
        'KubeConfig': obj.kubeConfig,
        'RoleArn': obj.roleArn,
        'Namespace': obj.namespace,
        'Name': obj.name,
        'Values': obj.values,
        'ValueYaml': obj.valueYaml,
        'Version': obj.version,
        'ValueOverrideURL': obj.valueOverrideUrl,
        'TimeOut': obj.timeOut,
        'VPCConfiguration': toJson_CfnHelmPropsVpcConfiguration(obj.vpcConfiguration),
    };
    // filter undefined values
    return Object.entries(result).reduce((r, i) => (i[1] === undefined) ? r : ({ ...r, [i[0]]: i[1] }), {});
}
exports.toJson_CfnHelmProps = toJson_CfnHelmProps;
/**
 * Converts an object of type 'CfnHelmPropsVpcConfiguration' to JSON representation.
 */
/* eslint-disable max-len, quote-props */
function toJson_CfnHelmPropsVpcConfiguration(obj) {
    var _b, _c;
    if (obj === undefined) {
        return undefined;
    }
    const result = {
        'SecurityGroupIds': (_b = obj.securityGroupIds) === null || _b === void 0 ? void 0 : _b.map(y => y),
        'SubnetIds': (_c = obj.subnetIds) === null || _c === void 0 ? void 0 : _c.map(y => y),
    };
    // filter undefined values
    return Object.entries(result).reduce((r, i) => (i[1] === undefined) ? r : ({ ...r, [i[0]]: i[1] }), {});
}
exports.toJson_CfnHelmPropsVpcConfiguration = toJson_CfnHelmPropsVpcConfiguration;
/* eslint-enable max-len, quote-props */
/**
 * A CloudFormation `Snyk::Container::Helm`
 *
 * @cloudformationResource Snyk::Container::Helm
 * @stability external
 * @link https://github.com/snyk/aws-cloudformation-resource-providers.git
 */
class CfnHelm extends cdk.CfnResource {
    /**
     * Create a new `Snyk::Container::Helm`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props) {
        super(scope, id, { type: CfnHelm.CFN_RESOURCE_TYPE_NAME, properties: toJson_CfnHelmProps(props) });
        this.props = props;
        this.attrId = cdk.Token.asString(this.getAtt('ID'));
    }
}
exports.CfnHelm = CfnHelm;
_a = JSII_RTTI_SYMBOL_1;
CfnHelm[_a] = { fqn: "@cdk-cloudformation/snyk-container-helm.CfnHelm", version: "1.2.0-alpha.5" };
/**
* The CloudFormation resource type name for this resource class.
*/
CfnHelm.CFN_RESOURCE_TYPE_NAME = "Snyk::Container::Helm";
//# sourceMappingURL=data:application/json;base64,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