
<!-- PROJECT LOGO -->
<br />
<p align="center">
  <a href="https://github.com/tomon-world/tomon-sdk-py">
    <img src="images/LOGO%20with%20TOMON.png" alt="Logo" width="1200" height="300">
  </a>

</p>

# Tomon SDK Python

## About

Tomon SDK for python is a python module which provide a more convenient way for developer to interact with the [Tomon API](https://developer.tomon.co/docs/).

- Javascript like EventEmitter for listening the specific event occurs
- Use official Tomon API

## Installation
**Python 3.0 or newer is required.**

Install tomon-sdk from pip:
```
# Linux/macOS
python3 -m pip install -U  tomon-sdk

# Windows
py -3 -m pip install -U tomon-sdk.
```

## How to use:

1.Initialise your bot
```python
bot_app = bot.Bot()
```
2.start your bot by using your account or bot token which generated by **Bot Master**
```python
bot_app.start_with_password("name#0000", "password")
# or using token
bot_app.start("your token")
```
3.you can listen to gateway or dispatched event
```python
bot_app.on(bot.OpCodeEvent.HEARTBEAT, on_dispatch)
# or dispatched event
bot_app.on(EventType.EMOJI_CREATE, print)
```

For more examples, please refer to the [tomon-bot-boilerplate-py](https://github.com/tomon-world/tomon-bot-boilerplate-py)

***Please read the [Documentation](https://developer.tomon.co/docs/connect) for more detail***


## Links:
[Documentation](https://developer.tomon.co/docs/)

[Tomon Bot](https://beta.tomon.co/bot/)

[pip](https://pypi.org/project/tomon-sdk/)

[Tomon Bot World](https://beta.tomon.co/invite/x3RMui)
