# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['subgrounds', 'subgrounds.pagination', 'subgrounds.subgraph']

package_data = \
{'': ['*']}

install_requires = \
['pandas>=1.4.2,<2.0.0',
 'pathlib>=1.0.1,<2.0.0',
 'pipe>=2.0,<3.0',
 'pydantic>=1.10.2,<2.0.0',
 'requests>=2.27.1,<3.0.0']

extras_require = \
{'dash': ['dash>=2.3.1,<3.0.0']}

setup_kwargs = {
    'name': 'subgrounds',
    'version': '1.2.0',
    'description': 'A Pythonic data access layer for applications querying data from The Graph Network.',
    'long_description': "# Subgrounds\n<!-- [![GitHub Actions](https://github.com/0xPlaygrounds/subgrounds/workflows/CI/badge.svg)](https://github.com/0xPlaygrounds/subgrounds/actions) -->\n[![PyPI](https://img.shields.io/pypi/v/subgrounds.svg)](https://pypi.org/project/subgrounds/)\n[![PyPI - Python Version](https://img.shields.io/pypi/pyversions/subgrounds.svg)](https://pypi.org/project/subgrounds/)\n[![Code style: black](https://img.shields.io/badge/code%20style-black-000000.svg)](https://github.com/ambv/black)\n<br>\n\n[![Discord](https://img.shields.io/discord/896944341598208070?color=7289DA&label=discord&logo=discord&logoColor=fff)](https://discord.gg/gMSSh5bjvk)\n[![Twitter Follow](https://img.shields.io/twitter/follow/Playgrounds0x?color=%231fa1f2&label=Playgrounds%20Analytics&logo=Twitter&logoColor=1fa1f2&style=flat-square)](https://twitter.com/Playgrounds0x)\n\n\n<!-- start elevator-pitch -->\nAn intuitive python library for interfacing with Subgraphs.\n\n## Features\n- **Simple**: Leverage a Pythonic API to easily build queries and transformations without the need for raw GraphQL manipulation.\n- **Automated**: Automatically handle pagination and schema introspection for effortless data retrieval.\n- **Powerful**: Create sophisticated queries using the `SyntheticFields` transformation system.\n\n<!-- end elevator-pitch -->\n\n## Resources\n- [**Subgrounds Docs**](http://docs.playgrounds.network/): User guide and API documentation\n- [**Examples**](https://github.com/0xPlaygrounds/subgrounds/tree/main/examples): A list of examples showcasing Subgrounds integration with Dash and Plotly\n- [**Community projects**](http://docs.playgrounds.network//examples/): An ever growing list of projects created by our community members\n- [**MetricsDAO Subgrounds Workshop**](https://docs.metricsdao.xyz/get-involved/workshops/2022-03-30+-subgrounds-workshop-series): Subgrounds workshop series hosted by MetricsDAO \n\n## Installation\n> Subgrounds **requires** atleast Python 3.10+\n\nSubgrounds is available on PyPi. To install it, run the following:<br>\n`pip install subgrounds`.\n\nSubgrounds also comes bundled with some handy `dash` wrappers. To use those wrappers, you can install the extra `dash` dependencies.<br>\n`pip install subgrounds[dash]`.\n\n## Simple example\n<!-- start simple-example -->\n```python\n>>> from subgrounds import Subgrounds\n\n>>> sg = Subgrounds()\n\n>>> # Load\n>>> aave_v2 = sg.load_subgraph('https://api.thegraph.com/subgraphs/name/messari/aave-v2-ethereum')\n\n>>> # Construct the query\n>>> latest = aave_v2.Query.markets(\n  orderBy=aave_v2.Market.totalValueLockedUSD,\n  orderDirection='desc',\n  first=5,\n)\n\n>>> # Return query to a dataframe\n>>> sg.query_df([\n  latest.name,\n  latest.totalValueLockedUSD,\n])\n                  markets_name  markets_totalValueLockedUSD\n0  Aave interest bearing STETH                 1.522178e+09\n1   Aave interest bearing WETH                 1.221299e+09\n2   Aave interest bearing USDC                 8.140547e+08\n3   Aave interest bearing WBTC                 6.615692e+08\n4   Aave interest bearing USDT                 3.734017e+08\n```\n<!-- end simple-example -->\n\n\n## About Us\nPlaygrounds Analytics is a data solutions company providing serverless on-chain data infrastructures and services for data teams, analysts, and engineers. Checkout us out [here](https://playgrounds.network/) to learn more!\n\n\n\n\n<!-- TODO: Move this to github pages docs -->\n<!-- # Dash and Plotly wrappers\nSubgrounds provides wrappers for Plotly objects and Dash components to facilitate visualization of data from The Graph.\n\nPlotly wrappers can be found in the `subgrounds.plotly_wrappers` submodule. The wrappers include a `Figure` wrapper as well as wrappers for most Plotly traces (see https://plotly.com/python/reference/). All Plotly trace wrappers accept the same arguments as their underlying Plotly trace with the notable difference being that Subgrounds `FieldPath` objects can be used as arguments wherever one would usually provide data to the traces.\n\n```python\nfrom subgrounds.plotly_wrappers import Bar, Figure\nfrom subgrounds.dash_wrappers import Graph\n\nborrows = aave_v2.Query.borrows(\n  orderBy=aave_v2.Borrow.timestamp,\n  orderDirection='desc',\n  first=100\n)\n\nrepays = aave_v2.Query.repays(\n  orderBy=aave_v2.Repay.timestamp,\n  orderDirection='desc',\n  first=100\n)\n\n# Dashboard\napp = dash.Dash(__name__)\n\napp.layout = html.Div(\n  html.Div([\n    html.H4('Entities'),\n    html.Div([\n      # Subgrounds Graph Dash component\n      Graph(\n        # A Subgrounds Plotly figure \n        Figure(\n          subgrounds=sg,\n          traces=[\n            # Subgrounds Plotly traces\n            Bar(x=borrows.reserve.symbol, y=borrows.amount),\n            Bar(x=repays.reserve.symbol, y=repays.amount)\n          ]\n        )\n      )\n    ])\n  ])\n)\n``` -->\n\n<!-- Generates the following Dash dashboard (at time of writing):\n![Alt text](https://raw.githubusercontent.com/Protean-Labs/subgrounds/main/img/bar-chart-example.png) -->\n\n<!-- # Examples and resources\nSee the `examples/` directory for an evergrowing list of examples. -->\n\n\n## Acknowledgments\nThis software project would not be possible without the support of The Graph Foundation. You can learn more about The Graph and its mission [here](https://thegraph.com/).\n\n<!-- TODO: Move this to github pages docs -->\n<!-- # Notes\n## Non-subgraph GraphQL APIs\nAlthough Subgrounds has been developed with subgraph APIs in mind, most features will also work with any GraphQL API. However, Subgrounds has not been tested with non-subgraph GraphQL APIs and some features will definitely break if the non-subgraph APIs do not follow the same conventions as subgraph APIs (e.g.: automatic pagination relies on each entity having a unique `id` field).\n\nIt is nonetheless possible to use Subgrounds with non-subgraph GraphQL APIs by using `load_api` instead of `load_subgraph`. This will bypass Subgrounds automatic pagination feature and pagination will therefore have to be done manually. Below is an example of using Subgrounds with the snapshot GraphQL API.\n```python\n>>> from datetime import datetime\n\n>>> from subgrounds.subgrounds import Subgrounds\n>>> from subgrounds.subgraph import SyntheticField\n\n>>> sg = Subgrounds()\n>>> snapshot = sg.load_api('https://hub.snapshot.org/graphql')\n\n>>> snapshot.Proposal.datetime = SyntheticField(\n...   lambda timestamp: str(datetime.fromtimestamp(timestamp)),\n...   SyntheticField.STRING,\n...   snapshot.Proposal.end,\n... )\n\n>>> proposals = snapshot.Query.proposals(\n...   orderBy='created',\n...   orderDirection='desc',\n...   first=100,\n...   where=[\n...     snapshot.Proposal.space == 'olympusdao.eth',\n...     snapshot.Proposal.state == 'closed'\n...   ]\n... )\n\n>>> sg.query_df([\n...   proposals.datetime,\n...   proposals.title,\n...   proposals.votes,\n... ])\n     proposals_datetime                                    proposals_title  proposals_votes\n0   2022-03-25 15:33:00  OIP-87: BeraChain Investment + Strategic Partn...              184\n1   2022-03-25 12:00:00                 OIP-86: Uniswap Migration Proposal              146\n2   2022-03-25 13:12:00                    TAP 8 - Yearn Finance Whitelist              137\n3   2022-03-22 15:10:10                      OIP-85: Emissions Adjustments              167\n4   2022-03-13 20:17:26                  TAP 7 - Anchor Protocol Whitelist              141\n..                  ...                                                ...              ...\n95  2021-11-20 23:00:00                 OlympusDAO Add ETH to the Treasury               52\n96  2022-01-31 12:00:00                            Add BTC to the Treasury              232\n97  2021-11-29 23:00:00   OlympusDAO OlympusDAO Launch OHM on POLYGON c...              234\n98  2021-11-29 23:00:00                 OlympusDAO Launch OHM on BSC chain               92\n99  2021-11-20 23:00:00  Suggestions to add more video operation guidan...               53\n\n[100 rows x 3 columns]\n```\n\n## GraphQL Aliases\nThe use of the alias `xf608864358427cfb` in the query string is to prevent conflict when merging fieldpaths that select the same fields with different arguments. For example, in the following code, the `borrows` query field is selected twice with different arguments:\n```python\n>>> latest_borrows = aave_v2.Query.borrows(\n...  orderBy=aave_v2.Borrow.timestamp,\n...  orderDirection='desc',\n...  first=100\n...)\n\n>>> largest_borrows = aave_v2.Query.borrows(\n...  orderBy=aave_v2.Borrow.amount,\n...  orderDirection='desc',\n...  first=100\n...)\n\n>>> req = sg.mk_request([\n...   latest_borrows.reserve.symbol,\n...   latest_borrows.amount,\n...   largest_borrows.reserve.symbol,\n...   largest_borrows.amount,\n... ])\n>>> print(req.graphql)\nquery {\n  x8b3edf3dc6501837: borrows(first: 100, orderBy: amount, orderDirection: desc) {\n    reserve {\n      symbol\n    }\n    amount\n  }\n  xf608864358427cfb: borrows(first: 100, orderBy: timestamp, orderDirection: desc) {\n    reserve {\n      symbol\n    }\n    amount\n  }\n}\n``` -->\n",
    'author': 'cvauclair',
    'author_email': 'cvauclair@playgrounds.network',
    'maintainer': 'None',
    'maintainer_email': 'None',
    'url': 'https://github.com/0xPlaygrounds/subgrounds',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'extras_require': extras_require,
    'python_requires': '>=3.10,<4.0',
}


setup(**setup_kwargs)
