# swagger-client

Welcome to the Timeplus HTTP REST API specification. # Authentication <!-- ReDoc-Inject: <security-definitions> -->

This Python package is automatically generated by the [Swagger Codegen](https://github.com/swagger-api/swagger-codegen) project:

- API version: 1.0.0-oas3
- Package version: 1.0.0
- Build package: io.swagger.codegen.v3.generators.python.PythonClientCodegen
  For more information, please visit [https://timeplus.com](https://timeplus.com)

## Requirements.

Python 2.7 and 3.4+

## Installation & Usage

### pip install

If the python package is hosted on Github, you can install directly from Github

```sh
pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git
```

(you may need to run `pip` with root permission: `sudo pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git`)

Then import the package:

```python
import timeplus_client
```

### Setuptools

Install via [Setuptools](http://pypi.python.org/pypi/setuptools).

```sh
python setup.py install --user
```

(or `sudo python setup.py install` to install the package for all users)

Then import the package:

```python
import timeplus_client
```

## Getting Started

Please follow the [installation procedure](#installation--usage) and then run the following:

```python
from __future__ import print_function
import time
import timeplus_client
from timeplus_client.rest import ApiException
from pprint import pprint

# Configure API key authorization: ApiKeyAuth
configuration = timeplus_client.Configuration()
configuration.api_key['X-Api-Key'] = 'YOUR_API_KEY'
# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['X-Api-Key'] = 'Bearer'

# create an instance of the API class
api_instance = timeplus_client.APIKeysV1beta1Api(timeplus_client.ApiClient(configuration))

try:
    # List API keys
    api_response = api_instance.v1beta1_auth_api_keys_get()
    pprint(api_response)
except ApiException as e:
    print("Exception when calling APIKeysV1beta1Api->v1beta1_auth_api_keys_get: %s\n" % e)

# Configure API key authorization: ApiKeyAuth
configuration = timeplus_client.Configuration()
configuration.api_key['X-Api-Key'] = 'YOUR_API_KEY'
# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['X-Api-Key'] = 'Bearer'

# create an instance of the API class
api_instance = timeplus_client.APIKeysV1beta1Api(timeplus_client.ApiClient(configuration))
id = 'id_example' # str | API key ID

try:
    # Delete an API key
    api_instance.v1beta1_auth_api_keys_id_delete(id)
except ApiException as e:
    print("Exception when calling APIKeysV1beta1Api->v1beta1_auth_api_keys_id_delete: %s\n" % e)

# Configure API key authorization: ApiKeyAuth
configuration = timeplus_client.Configuration()
configuration.api_key['X-Api-Key'] = 'YOUR_API_KEY'
# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['X-Api-Key'] = 'Bearer'

# create an instance of the API class
api_instance = timeplus_client.APIKeysV1beta1Api(timeplus_client.ApiClient(configuration))
body = timeplus_client.CreateAPIKeyRequest() # CreateAPIKeyRequest | API Key parameters (optional)

try:
    # Create an API key
    api_response = api_instance.v1beta1_auth_api_keys_post(body=body)
    pprint(api_response)
except ApiException as e:
    print("Exception when calling APIKeysV1beta1Api->v1beta1_auth_api_keys_post: %s\n" % e)
```

## Documentation for API Endpoints

All URIs are relative to _https//beta.timeplus.cloud/{workspace-id}/api_

| Class                         | Method                                                                                                                   | HTTP request                                  | Description                                                                                |
| ----------------------------- | ------------------------------------------------------------------------------------------------------------------------ | --------------------------------------------- | ------------------------------------------------------------------------------------------ |
| _APIKeysV1beta1Api_           | [**v1beta1_auth_api_keys_get**](docs/APIKeysV1beta1Api.md#v1beta1_auth_api_keys_get)                                     | **GET** /v1beta1/auth/api_keys                | List API keys                                                                              |
| _APIKeysV1beta1Api_           | [**v1beta1_auth_api_keys_id_delete**](docs/APIKeysV1beta1Api.md#v1beta1_auth_api_keys_id_delete)                         | **DELETE** /v1beta1/auth/api_keys/{id}        | Delete an API key                                                                          |
| _APIKeysV1beta1Api_           | [**v1beta1_auth_api_keys_post**](docs/APIKeysV1beta1Api.md#v1beta1_auth_api_keys_post)                                   | **POST** /v1beta1/auth/api_keys               | Create an API key                                                                          |
| _DashboardsV1beta2Api_        | [**v1beta2_dashboards_get**](docs/DashboardsV1beta2Api.md#v1beta2_dashboards_get)                                        | **GET** /v1beta2/dashboards                   | list dashboards.                                                                           |
| _DashboardsV1beta2Api_        | [**v1beta2_dashboards_id_delete**](docs/DashboardsV1beta2Api.md#v1beta2_dashboards_id_delete)                            | **DELETE** /v1beta2/dashboards/{id}           | delete a dashboard.                                                                        |
| _DashboardsV1beta2Api_        | [**v1beta2_dashboards_id_get**](docs/DashboardsV1beta2Api.md#v1beta2_dashboards_id_get)                                  | **GET** /v1beta2/dashboards/{id}              | get a dashboard.                                                                           |
| _DashboardsV1beta2Api_        | [**v1beta2_dashboards_id_put**](docs/DashboardsV1beta2Api.md#v1beta2_dashboards_id_put)                                  | **PUT** /v1beta2/dashboards/{id}              | Update a dashboard.                                                                        |
| _DashboardsV1beta2Api_        | [**v1beta2_dashboards_post**](docs/DashboardsV1beta2Api.md#v1beta2_dashboards_post)                                      | **POST** /v1beta2/dashboards                  | create a dashboard.                                                                        |
| _PersistentQueriesV1beta2Api_ | [**v1beta2_persistent_queries_get**](docs/PersistentQueriesV1beta2Api.md#v1beta2_persistent_queries_get)                 | **GET** /v1beta2/persistent-queries           | list persistent-queries.                                                                   |
| _PersistentQueriesV1beta2Api_ | [**v1beta2_persistent_queries_id_data_get**](docs/PersistentQueriesV1beta2Api.md#v1beta2_persistent_queries_id_data_get) | **GET** /v1beta2/persistent-queries/{id}/data | stream persistent query result via websocket                                               |
| _PersistentQueriesV1beta2Api_ | [**v1beta2_persistent_queries_id_delete**](docs/PersistentQueriesV1beta2Api.md#v1beta2_persistent_queries_id_delete)     | **DELETE** /v1beta2/persistent-queries/{id}   | delete a persistent query.                                                                 |
| _PersistentQueriesV1beta2Api_ | [**v1beta2_persistent_queries_id_get**](docs/PersistentQueriesV1beta2Api.md#v1beta2_persistent_queries_id_get)           | **GET** /v1beta2/persistent-queries/{id}      | get a persistent query.                                                                    |
| _PersistentQueriesV1beta2Api_ | [**v1beta2_persistent_queries_post**](docs/PersistentQueriesV1beta2Api.md#v1beta2_persistent_queries_post)               | **POST** /v1beta2/persistent-queries          | execute a persistent query.                                                                |
| _QueriesV1beta1Api_           | [**v1beta1_format_post**](docs/QueriesV1beta1Api.md#v1beta1_format_post)                                                 | **POST** /v1beta1/format                      | format a query.                                                                            |
| _QueriesV1beta1Api_           | [**v1beta1_queries_get**](docs/QueriesV1beta1Api.md#v1beta1_queries_get)                                                 | **GET** /v1beta1/queries                      | list queries.                                                                              |
| _QueriesV1beta1Api_           | [**v1beta1_queries_id_cancel_post**](docs/QueriesV1beta1Api.md#v1beta1_queries_id_cancel_post)                           | **POST** /v1beta1/queries/{id}/cancel         | cancel a query.                                                                            |
| _QueriesV1beta1Api_           | [**v1beta1_queries_id_delete**](docs/QueriesV1beta1Api.md#v1beta1_queries_id_delete)                                     | **DELETE** /v1beta1/queries/{id}              | delete a query.                                                                            |
| _QueriesV1beta1Api_           | [**v1beta1_queries_id_get**](docs/QueriesV1beta1Api.md#v1beta1_queries_id_get)                                           | **GET** /v1beta1/queries/{id}                 | get a query.                                                                               |
| _QueriesV1beta1Api_           | [**v1beta1_queries_id_pipeline_get**](docs/QueriesV1beta1Api.md#v1beta1_queries_id_pipeline_get)                         | **GET** /v1beta1/queries/{id}/pipeline        | get the pipeline for a query                                                               |
| _QueriesV1beta1Api_           | [**v1beta1_queries_post**](docs/QueriesV1beta1Api.md#v1beta1_queries_post)                                               | **POST** /v1beta1/queries                     | execute a query.                                                                           |
| _QueriesV1beta1Api_           | [**v1beta1_sqlanalyze_post**](docs/QueriesV1beta1Api.md#v1beta1_sqlanalyze_post)                                         | **POST** /v1beta1/sqlanalyze                  | analyze sql                                                                                |
| _QueriesV1beta1Api_           | [**ws_queries_id_get**](docs/QueriesV1beta1Api.md#ws_queries_id_get)                                                     | **GET** /ws/queries/{id}                      | stream query result via websocket [THIS API DOESN&#x27;T HAVE &#x60;v1beta1&#x60; IN PATH] |
| _QueriesV1beta2Api_           | [**v1beta2_queries_post**](docs/QueriesV1beta2Api.md#v1beta2_queries_post)                                               | **POST** /v1beta2/queries                     | execute a query.                                                                           |
| _SinksV1beta1Api_             | [**v1beta1_sinks_get**](docs/SinksV1beta1Api.md#v1beta1_sinks_get)                                                       | **GET** /v1beta1/sinks                        | list sinks                                                                                 |
| _SinksV1beta1Api_             | [**v1beta1_sinks_id_delete**](docs/SinksV1beta1Api.md#v1beta1_sinks_id_delete)                                           | **DELETE** /v1beta1/sinks/{id}                | delete a sink.                                                                             |
| _SinksV1beta1Api_             | [**v1beta1_sinks_id_get**](docs/SinksV1beta1Api.md#v1beta1_sinks_id_get)                                                 | **GET** /v1beta1/sinks/{id}                   | get a sink.                                                                                |
| _SinksV1beta1Api_             | [**v1beta1_sinks_post**](docs/SinksV1beta1Api.md#v1beta1_sinks_post)                                                     | **POST** /v1beta1/sinks                       | create a sink.                                                                             |
| _SourcesV1beta1Api_           | [**v1beta1_source_infer_post**](docs/SourcesV1beta1Api.md#v1beta1_source_infer_post)                                     | **POST** /v1beta1/source/infer                | infer schema from an existing event                                                        |
| _SourcesV1beta1Api_           | [**v1beta1_source_match_post**](docs/SourcesV1beta1Api.md#v1beta1_source_match_post)                                     | **POST** /v1beta1/source/match                | return streams match provided events                                                       |
| _SourcesV1beta1Api_           | [**v1beta1_source_preview_post**](docs/SourcesV1beta1Api.md#v1beta1_source_preview_post)                                 | **POST** /v1beta1/source/preview              | preview a source.                                                                          |
| _SourcesV1beta1Api_           | [**v1beta1_source_upload_post**](docs/SourcesV1beta1Api.md#v1beta1_source_upload_post)                                   | **POST** /v1beta1/source/upload               | upload a file                                                                              |
| _SourcesV1beta1Api_           | [**v1beta1_sources_get**](docs/SourcesV1beta1Api.md#v1beta1_sources_get)                                                 | **GET** /v1beta1/sources                      | list sources.                                                                              |
| _SourcesV1beta1Api_           | [**v1beta1_sources_id_delete**](docs/SourcesV1beta1Api.md#v1beta1_sources_id_delete)                                     | **DELETE** /v1beta1/sources/{id}              | delete a source.                                                                           |
| _SourcesV1beta1Api_           | [**v1beta1_sources_id_get**](docs/SourcesV1beta1Api.md#v1beta1_sources_id_get)                                           | **GET** /v1beta1/sources/{id}                 | get a source.                                                                              |
| _SourcesV1beta1Api_           | [**v1beta1_sources_id_put**](docs/SourcesV1beta1Api.md#v1beta1_sources_id_put)                                           | **PUT** /v1beta1/sources/{id}                 | Update a source.                                                                           |
| _SourcesV1beta1Api_           | [**v1beta1_sources_id_start_post**](docs/SourcesV1beta1Api.md#v1beta1_sources_id_start_post)                             | **POST** /v1beta1/sources/{id}/start          | start a source.                                                                            |
| _SourcesV1beta1Api_           | [**v1beta1_sources_id_stop_post**](docs/SourcesV1beta1Api.md#v1beta1_sources_id_stop_post)                               | **POST** /v1beta1/sources/{id}/stop           | stop a source.                                                                             |
| _SourcesV1beta1Api_           | [**v1beta1_sources_post**](docs/SourcesV1beta1Api.md#v1beta1_sources_post)                                               | **POST** /v1beta1/sources                     | create a source.                                                                           |
| _StreamsV1beta1Api_           | [**v1beta1_streams_external_post**](docs/StreamsV1beta1Api.md#v1beta1_streams_external_post)                             | **POST** /v1beta1/streams/external            | create an external stream.                                                                 |
| _StreamsV1beta1Api_           | [**v1beta1_streams_get**](docs/StreamsV1beta1Api.md#v1beta1_streams_get)                                                 | **GET** /v1beta1/streams                      | list streams.                                                                              |
| _StreamsV1beta1Api_           | [**v1beta1_streams_name_delete**](docs/StreamsV1beta1Api.md#v1beta1_streams_name_delete)                                 | **DELETE** /v1beta1/streams/{name}            | delete a stream.                                                                           |
| _StreamsV1beta1Api_           | [**v1beta1_streams_name_ingest_post**](docs/StreamsV1beta1Api.md#v1beta1_streams_name_ingest_post)                       | **POST** /v1beta1/streams/{name}/ingest       | ingest data.                                                                               |
| _StreamsV1beta1Api_           | [**v1beta1_streams_name_put**](docs/StreamsV1beta1Api.md#v1beta1_streams_name_put)                                       | **PUT** /v1beta1/streams/{name}               | Update a stream.                                                                           |
| _StreamsV1beta1Api_           | [**v1beta1_streams_post**](docs/StreamsV1beta1Api.md#v1beta1_streams_post)                                               | **POST** /v1beta1/streams                     | create a stream.                                                                           |
| _TopologyV1beta2Api_          | [**v1beta2_topology_get**](docs/TopologyV1beta2Api.md#v1beta2_topology_get)                                              | **GET** /v1beta2/topology                     | get topology graph.                                                                        |
| _UDFsV1beta1Api_              | [**v1beta1_udfs_get**](docs/UDFsV1beta1Api.md#v1beta1_udfs_get)                                                          | **GET** /v1beta1/udfs                         | list udf.                                                                                  |
| _UDFsV1beta1Api_              | [**v1beta1_udfs_name_delete**](docs/UDFsV1beta1Api.md#v1beta1_udfs_name_delete)                                          | **DELETE** /v1beta1/udfs/{name}               | delete a udf.                                                                              |
| _UDFsV1beta1Api_              | [**v1beta1_udfs_name_get**](docs/UDFsV1beta1Api.md#v1beta1_udfs_name_get)                                                | **GET** /v1beta1/udfs/{name}                  | get a udf.                                                                                 |
| _UDFsV1beta1Api_              | [**v1beta1_udfs_post**](docs/UDFsV1beta1Api.md#v1beta1_udfs_post)                                                        | **POST** /v1beta1/udfs                        | create a udf.                                                                              |
| _ViewsV1beta1Api_             | [**v1beta1_views_get**](docs/ViewsV1beta1Api.md#v1beta1_views_get)                                                       | **GET** /v1beta1/views                        | list views.                                                                                |
| _ViewsV1beta1Api_             | [**v1beta1_views_name_delete**](docs/ViewsV1beta1Api.md#v1beta1_views_name_delete)                                       | **DELETE** /v1beta1/views/{name}              | delete a view.                                                                             |
| _ViewsV1beta1Api_             | [**v1beta1_views_post**](docs/ViewsV1beta1Api.md#v1beta1_views_post)                                                     | **POST** /v1beta1/views                       | create a view.                                                                             |

## Documentation For Models

- [APIKey](docs/APIKey.md)
- [AnalyzeSQLRequest](docs/AnalyzeSQLRequest.md)
- [Column](docs/Column.md)
- [ColumnDef](docs/ColumnDef.md)
- [ColumnsResp](docs/ColumnsResp.md)
- [Connection](docs/Connection.md)
- [ConnectionConfig](docs/ConnectionConfig.md)
- [ConnectionStat](docs/ConnectionStat.md)
- [CreateAPIKeyRequest](docs/CreateAPIKeyRequest.md)
- [CreateAPIKeyResponse](docs/CreateAPIKeyResponse.md)
- [CreateDashboardRequest](docs/CreateDashboardRequest.md)
- [CreatePersistentQueryRequest](docs/CreatePersistentQueryRequest.md)
- [CreateQueryRequestV1Beta1](docs/CreateQueryRequestV1Beta1.md)
- [CreateQueryRequestV1Beta2](docs/CreateQueryRequestV1Beta2.md)
- [CreateQueryResponse](docs/CreateQueryResponse.md)
- [CreateSinkRequest](docs/CreateSinkRequest.md)
- [CreateSourceRequest](docs/CreateSourceRequest.md)
- [DashboardDashboard](docs/DashboardDashboard.md)
- [DashboardPanel](docs/DashboardPanel.md)
- [Edge](docs/Edge.md)
- [ErrorResponse](docs/ErrorResponse.md)
- [Event](docs/Event.md)
- [EventInferRequest](docs/EventInferRequest.md)
- [EventInferResponse](docs/EventInferResponse.md)
- [ExternalStreamDef](docs/ExternalStreamDef.md)
- [FileUploadResponse](docs/FileUploadResponse.md)
- [FormatQueryRequest](docs/FormatQueryRequest.md)
- [FormatQueryResponse](docs/FormatQueryResponse.md)
- [Graph](docs/Graph.md)
- [IngestData](docs/IngestData.md)
- [Latency](docs/Latency.md)
- [Node](docs/Node.md)
- [Owner](docs/Owner.md)
- [Query](docs/Query.md)
- [QueryAnalysis](docs/QueryAnalysis.md)
- [QueryMetrics](docs/QueryMetrics.md)
- [QueryPipeline](docs/QueryPipeline.md)
- [QueryPipelineEdge](docs/QueryPipelineEdge.md)
- [QueryPipelineNode](docs/QueryPipelineNode.md)
- [QueryPipelineNodeMetric](docs/QueryPipelineNodeMetric.md)
- [QueryResult](docs/QueryResult.md)
- [QueryWithMetrics](docs/QueryWithMetrics.md)
- [SQLAnalyzeColumn](docs/SQLAnalyzeColumn.md)
- [SQLAnalyzeResult](docs/SQLAnalyzeResult.md)
- [Sink](docs/Sink.md)
- [SinkMetrics](docs/SinkMetrics.md)
- [SinkStat](docs/SinkStat.md)
- [SinkWithMetrics](docs/SinkWithMetrics.md)
- [Source](docs/Source.md)
- [SourceMetrics](docs/SourceMetrics.md)
- [SourcePreviewRequest](docs/SourcePreviewRequest.md)
- [SourceUploadBody](docs/SourceUploadBody.md)
- [SourceWithMetrics](docs/SourceWithMetrics.md)
- [Stream](docs/Stream.md)
- [StreamDef](docs/StreamDef.md)
- [StreamMatchRequest](docs/StreamMatchRequest.md)
- [StreamSetting](docs/StreamSetting.md)
- [StreamStats](docs/StreamStats.md)
- [Throughput](docs/Throughput.md)
- [TimeColumns](docs/TimeColumns.md)
- [UDF](docs/UDF.md)
- [UDFArgument](docs/UDFArgument.md)
- [UDFAuthContext](docs/UDFAuthContext.md)
- [UpdateDashboardRequest](docs/UpdateDashboardRequest.md)
- [UpdateSourceRequest](docs/UpdateSourceRequest.md)
- [View](docs/View.md)

## Documentation For Authorization

## ApiKeyAuth

- **Type**: API key
- **API key parameter name**: X-Api-Key
- **Location**: HTTP header

## Author

support@timeplus.com
