Http-Html
A lightweight and complete Python library for building simple web servers.

Features
Integrated Web Structure: Includes classes for Request, Response, Router, and Server.

Request Routing: Automatically directs each URL to a specific function using the Router class.

Easy Header Building: Build complex HTTP headers in a single line.

Automatic Request Parsing: Parses incoming requests (GET and POST) automatically.

Standard Status Codes: Supports standard HTTP status codes and their messages.

Installation
You can install the library easily using pip once it's published on PyPI:

Bash

pip install http-html
How to Use http-html
This library is designed to make it simple to build a web server from scratch. All you need is a single Python file to run your server.

Step 1: Create Your Server
First, create a Server object. This class handles the low-level socket connections and listens for incoming requests.

Python

# main_server.py

from httpkit.server import Server

HOST = '0.0.0.0'
PORT = 8080

# Create your server instance
app = Server(HOST, PORT)

# Start the server
if __name__ == "__main__":
    app.run()
Step 2: Define Your Routes
Use the @app.route decorator to connect specific URLs to a function. The decorator takes two arguments: the path (e.g., "/", "/about") and the HTTP method (e.g., "GET", "POST").

Python

from httpkit.response import Response

@app.route("/", "GET")
def index_page(client_connection, request):
    html_content = "<html><body><h1>Welcome to Http-Html!</h1></body></html>"
    # The handler function takes two arguments:
    # 1. client_connection: for sending the response
    # 2. request: the parsed request object
    
    # Use Response to build and send the final data
    response = Response(200, "text/html", html_content)
    client_connection.sendall(response.build())

@app.route("/contact", "GET")
def contact_page(client_connection, request):
    html_content = "<html><body>Contact us at my_email@example.com</body></html>"
    response = Response(200, "text/html", html_content)
    client_connection.sendall(response.build())
Step 3: Handle Requests
The request object provides easy access to all the information from the browser. You can access headers, the request method, and the path.

Python

@app.route("/user-info", "GET")
def user_info(client_connection, request):
    # Access a header (e.g., User-Agent)
    user_agent = request.headers.get("User-Agent", "Not specified")
    
    # Access the request path
    path = request.path

    # Access the request method (GET, POST)
    method = request.method

    # You can also get POST data from request.body
    # ...
Step 4: Build a Response
Use the Response class to build the final HTTP response. It handles everything for you and is a much better way than manually writing the headers.

Python

from httpkit.response import Response

# This creates a complete HTTP response with headers and body
my_response = Response(
    200,                     # Status Code (e.g., 200)
    "text/html",             # Content Type
    "<h1>Success!</h1>"      # Content
)

# Use the .build() method to get the final bytes to send
final_bytes = my_response.build()
License
This project is licensed under the MIT License.
