# this file is generated by build_network_protocol_files.py
from typing import Any, Dict

new_signage_point_json: Dict[str, Any] = {
    "challenge_hash": "0x34b2a753b0dc864e7218f8facf23ca0e2b636351df5289b76f5845d9a78b7026",
    "challenge_chain_sp": "0x9dc8b9d685c79acdf8780d994416dfcfb118e0adc99769ecfa94e1f40aa5bbe5",
    "reward_chain_sp": "0xb2828a2c7f6a2555c80c3ca9d10792a7da6ee80f686122ecd2c748dc0569a867",
    "difficulty": 2329045448547720842,
    "sub_slot_iters": 8265724497259558930,
    "signage_point_index": 194,
}

declare_proof_of_space_json: Dict[str, Any] = {
    "challenge_hash": "0x3f44d177faa11cea40477f233a8b365cce77215a84f48f65a37b2ac35c7e3ccc",
    "challenge_chain_sp": "0x931c83fd8ef121177257301e11f41642618ddac65509939e252243e41bacbf78",
    "signage_point_index": 31,
    "reward_chain_sp": "0x6c8dbcfae52c8df391231f3f7aae24c0b1e2be9638f6fc9e4c216b9ff43548d1",
    "proof_of_space": {
        "challenge": "0x1fb331df88bc142e70c110e21620374118fb220ccc3ef621378197e850882ec9",
        "pool_public_key": "0xa04c6b5ac7dfb935f6feecfdd72348ccf1d4be4fe7e26acf271ea3b7d308da61e0a308f7a62495328a81f5147b66634c",
        "pool_contract_puzzle_hash": None,
        "plot_public_key": "0xb6449c2c68df97c19e884427e42ee7350982d4020571ead08732615ff39bd216bfd630b6460784982bec98b49fea79d0",
        "size": 204,
        "proof": "0xa67188ae0c02c49b0e821a9773033a3fbd338030c383080dbb8b1d63f07af427d8075e59d911f85ea562fd967823588f9a405a4464fdf5dc0866ee15bebd6b94cb147e28aa9cf96da930611486b779737ed721ea376b9939ba05357141223d75d21b21f310ec32d85ed3b98cf301494ea91b8501138481f3bfa1c384fd998b1fdd2855ac6f0c8554c520fb0bfa3663f238124035e14682bc11eaf7c372b6af4ed7f59a406810c71711906f8c91f94b1f",
    },
    "challenge_chain_sp_signature": "0xc00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000",
    "reward_chain_sp_signature": "0xc00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000",
    "farmer_puzzle_hash": "0x3843d1c2c574d376225733cf1a9c63da7051954b88b5adc1a4c198c1c7d5edfd",
    "pool_target": {
        "puzzle_hash": "0xd23da14695a188ae5708dd152263c4db883eb27edeb936178d4d988b8f3ce5fc",
        "max_height": 421941852,
    },
    "pool_signature": "0xc00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000",
}

request_signed_values_json: Dict[str, Any] = {
    "quality_string": "0x60649de258d2221ca6a178476861b13f8c394a992eaeae1f1159c32bbf703b45",
    "foliage_block_data_hash": "0x9da23e943246bb99ebeb5e773e35a445bbbfdbd45dd9b9df169eeca80880a53b",
    "foliage_transaction_block_hash": "0x5d76a4bcb3524d862e92317410583daf50828927885444c6d62ca8843635c46f",
}

farming_info_json: Dict[str, Any] = {
    "challenge_hash": "0x345cefad6a04d3ea4fec4b31e56000de622de9fe861afa53424138dd45307fc2",
    "sp_hash": "0x1105c288abb976e95804796aea5bb6f66a6b500c0f538d4e71f0d701cad9ff11",
    "timestamp": 16359391077414942762,
    "passed": 1390832181,
    "proofs": 908923578,
    "total_plots": 2259819406,
}

signed_values_json: Dict[str, Any] = {
    "quality_string": "0x915de5949724e1fc92d334e589c26ddbcd67415cbbdbbfc5e6de93b3b33bb267",
    "foliage_block_data_signature": "0xc00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000",
    "foliage_transaction_block_signature": "0xc00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000",
}

new_peak_json: Dict[str, Any] = {
    "header_hash": "0x8a346e8dc02e9b44c0571caa74fd99f163d4c5d7deae9f8ddb00528721493f7a",
    "height": 2653549198,
    "weight": 196318552117141200341240034145143439804,
    "fork_point_with_previous_peak": 928039765,
    "unfinished_reward_block_hash": "0xdd421c55d4edaeeb3ad60e80d73c2005a1b275c381c7e418915200d7467711b5",
}

new_transaction_json: Dict[str, Any] = {
    "transaction_id": "0xe4fe833328d4e82f9c57bc1fc2082c9b63da23e46927522cb5a073f9f0979b6a",
    "cost": 13950654730705425115,
    "fees": 10674036971945712700,
}

request_transaction_json: Dict[str, Any] = {
    "transaction_id": "0x3dc310a07be53bfd701e4a0d77ce39836eeab4717fe25b1ae4c3f16aad0e5d83"
}

respond_transaction_json: Dict[str, Any] = {
    "transaction": {
        "coin_spends": [
            {
                "coin": {
                    "parent_coin_info": "0xd56f435d3382cb9aa5f50f51816e4c54487c66402339901450f3c810f1d77098",
                    "puzzle_hash": "0x9944f63fcc251719b2f04c47ab976a167f96510736dc6fdfa8e037d740f4b5f3",
                    "amount": 6602327684212801382,
                },
                "puzzle_reveal": "0xff01ffff33ffa0f8912302fb33b8188046662785704afc3dd945074e4b45499a7173946e044695ff8203e880ffff33ffa03eaa52e850322dbc281c6b922e9d8819c7b4120ee054c4aa79db50be516a2bcaff8207d08080",
                "solution": "0xffff01ffff33ffa0f8912302fb33b8188046662785704afc3dd945074e4b45499a7173946e044695ff8203e880ffff33ffa03eaa52e850322dbc281c6b922e9d8819c7b4120ee054c4aa79db50be516a2bcaff8207d08080ff8080",
            }
        ],
        "aggregated_signature": "0xc00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000",
    }
}

request_proof_of_weight_json: Dict[str, Any] = {
    "total_number_of_blocks": 1109907246,
    "tip": "0x1fa3bfc747762c6edbe9937630e50b6982c3cf4fd67931f2ffcececb8c509839",
}

respond_proof_of_weight_json: Dict[str, Any] = {
    "wp": {
        "sub_epochs": [
            {
                "reward_chain_hash": "0x6fdcfaabeb149f9c44c80c230c44771e14b3d4e1b361dcca9c823b7ea7887ffe",
                "num_blocks_overflow": 190,
                "new_sub_slot_iters": 10527522631566046685,
                "new_difficulty": 989988965238543242,
            }
        ],
        "sub_epoch_segments": [
            {
                "sub_epoch_n": 3946877794,
                "sub_slots": [
                    {
                        "proof_of_space": {
                            "challenge": "0x1fb331df88bc142e70c110e21620374118fb220ccc3ef621378197e850882ec9",
                            "pool_public_key": "0xa04c6b5ac7dfb935f6feecfdd72348ccf1d4be4fe7e26acf271ea3b7d308da61e0a308f7a62495328a81f5147b66634c",
                            "pool_contract_puzzle_hash": None,
                            "plot_public_key": "0xb6449c2c68df97c19e884427e42ee7350982d4020571ead08732615ff39bd216bfd630b6460784982bec98b49fea79d0",
                            "size": 204,
                            "proof": "0xa67188ae0c02c49b0e821a9773033a3fbd338030c383080dbb8b1d63f07af427d8075e59d911f85ea562fd967823588f9a405a4464fdf5dc0866ee15bebd6b94cb147e28aa9cf96da930611486b779737ed721ea376b9939ba05357141223d75d21b21f310ec32d85ed3b98cf301494ea91b8501138481f3bfa1c384fd998b1fdd2855ac6f0c8554c520fb0bfa3663f238124035e14682bc11eaf7c372b6af4ed7f59a406810c71711906f8c91f94b1f",
                        },
                        "cc_signage_point": {
                            "witness_type": 197,
                            "witness": "0x30303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030",
                            "normalized_to_identity": False,
                        },
                        "cc_infusion_point": {
                            "witness_type": 197,
                            "witness": "0x30303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030",
                            "normalized_to_identity": False,
                        },
                        "icc_infusion_point": {
                            "witness_type": 197,
                            "witness": "0x30303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030",
                            "normalized_to_identity": False,
                        },
                        "cc_sp_vdf_info": {
                            "challenge": "0x7cbd5905838c1dc2becd00298a5b3a6e42b6a306d574c8897cd721f84d429972",
                            "number_of_iterations": 14708638287767651172,
                            "output": {
                                "data": "0x08000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
                            },
                        },
                        "signage_point_index": 255,
                        "cc_slot_end": {
                            "witness_type": 197,
                            "witness": "0x30303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030",
                            "normalized_to_identity": False,
                        },
                        "icc_slot_end": {
                            "witness_type": 197,
                            "witness": "0x30303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030",
                            "normalized_to_identity": False,
                        },
                        "cc_slot_end_info": {
                            "challenge": "0x7cbd5905838c1dc2becd00298a5b3a6e42b6a306d574c8897cd721f84d429972",
                            "number_of_iterations": 14708638287767651172,
                            "output": {
                                "data": "0x08000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
                            },
                        },
                        "icc_slot_end_info": {
                            "challenge": "0x7cbd5905838c1dc2becd00298a5b3a6e42b6a306d574c8897cd721f84d429972",
                            "number_of_iterations": 14708638287767651172,
                            "output": {
                                "data": "0x08000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
                            },
                        },
                        "cc_ip_vdf_info": {
                            "challenge": "0x7cbd5905838c1dc2becd00298a5b3a6e42b6a306d574c8897cd721f84d429972",
                            "number_of_iterations": 14708638287767651172,
                            "output": {
                                "data": "0x08000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
                            },
                        },
                        "icc_ip_vdf_info": {
                            "challenge": "0x7cbd5905838c1dc2becd00298a5b3a6e42b6a306d574c8897cd721f84d429972",
                            "number_of_iterations": 14708638287767651172,
                            "output": {
                                "data": "0x08000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
                            },
                        },
                        "total_iters": 178067533887691737655963933428342640848,
                    }
                ],
                "rc_slot_end_info": {
                    "challenge": "0x7cbd5905838c1dc2becd00298a5b3a6e42b6a306d574c8897cd721f84d429972",
                    "number_of_iterations": 14708638287767651172,
                    "output": {
                        "data": "0x08000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
                    },
                },
            }
        ],
        "recent_chain_data": [
            {
                "finished_sub_slots": [
                    {
                        "challenge_chain": {
                            "challenge_chain_end_of_slot_vdf": {
                                "challenge": "0x7cbd5905838c1dc2becd00298a5b3a6e42b6a306d574c8897cd721f84d429972",
                                "number_of_iterations": 14708638287767651172,
                                "output": {
                                    "data": "0x08000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
                                },
                            },
                            "infused_challenge_chain_sub_slot_hash": "0x42c10d66108589c11bb3811b37d214b6351b73e25bad6c956c0bf1c05a4d93fb",
                            "subepoch_summary_hash": "0xcdb6d334b461a01c4d07c76dd71d5a9f3a2949807a3499eb484e4b91e6cea309",
                            "new_sub_slot_iters": 42556034269004566,
                            "new_difficulty": 16610212302933121129,
                        },
                        "infused_challenge_chain": {
                            "infused_challenge_chain_end_of_slot_vdf": {
                                "challenge": "0x7cbd5905838c1dc2becd00298a5b3a6e42b6a306d574c8897cd721f84d429972",
                                "number_of_iterations": 14708638287767651172,
                                "output": {
                                    "data": "0x08000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
                                },
                            }
                        },
                        "reward_chain": {
                            "end_of_slot_vdf": {
                                "challenge": "0x7cbd5905838c1dc2becd00298a5b3a6e42b6a306d574c8897cd721f84d429972",
                                "number_of_iterations": 14708638287767651172,
                                "output": {
                                    "data": "0x08000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
                                },
                            },
                            "challenge_chain_sub_slot_hash": "0x893f282b27c4961f47d886577a8d7c136d1e738e6c5badd37c1994e68871cb70",
                            "infused_challenge_chain_sub_slot_hash": "0x4be4cc2a1f15c5c69fb9becac0cbe0df5ea007a94f22bca79f88e14fc2a46def",
                            "deficit": 52,
                        },
                        "proofs": {
                            "challenge_chain_slot_proof": {
                                "witness_type": 197,
                                "witness": "0x30303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030",
                                "normalized_to_identity": False,
                            },
                            "infused_challenge_chain_slot_proof": {
                                "witness_type": 197,
                                "witness": "0x30303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030",
                                "normalized_to_identity": False,
                            },
                            "reward_chain_slot_proof": {
                                "witness_type": 197,
                                "witness": "0x30303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030",
                                "normalized_to_identity": False,
                            },
                        },
                    }
                ],
                "reward_chain_block": {
                    "weight": 187084448821891925757676377381787790114,
                    "height": 301889038,
                    "total_iters": 147405131564197136044258885592706844266,
                    "signage_point_index": 9,
                    "pos_ss_cc_challenge_hash": "0x50102505a28e3969db19c699a5e53af73c1cb3108e2ab9ce9d86d1f058b10457",
                    "proof_of_space": {
                        "challenge": "0x1fb331df88bc142e70c110e21620374118fb220ccc3ef621378197e850882ec9",
                        "pool_public_key": "0xa04c6b5ac7dfb935f6feecfdd72348ccf1d4be4fe7e26acf271ea3b7d308da61e0a308f7a62495328a81f5147b66634c",
                        "pool_contract_puzzle_hash": None,
                        "plot_public_key": "0xb6449c2c68df97c19e884427e42ee7350982d4020571ead08732615ff39bd216bfd630b6460784982bec98b49fea79d0",
                        "size": 204,
                        "proof": "0xa67188ae0c02c49b0e821a9773033a3fbd338030c383080dbb8b1d63f07af427d8075e59d911f85ea562fd967823588f9a405a4464fdf5dc0866ee15bebd6b94cb147e28aa9cf96da930611486b779737ed721ea376b9939ba05357141223d75d21b21f310ec32d85ed3b98cf301494ea91b8501138481f3bfa1c384fd998b1fdd2855ac6f0c8554c520fb0bfa3663f238124035e14682bc11eaf7c372b6af4ed7f59a406810c71711906f8c91f94b1f",
                    },
                    "challenge_chain_sp_vdf": {
                        "challenge": "0x7cbd5905838c1dc2becd00298a5b3a6e42b6a306d574c8897cd721f84d429972",
                        "number_of_iterations": 14708638287767651172,
                        "output": {
                            "data": "0x08000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
                        },
                    },
                    "challenge_chain_sp_signature": "0xc00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000",
                    "challenge_chain_ip_vdf": {
                        "challenge": "0x7cbd5905838c1dc2becd00298a5b3a6e42b6a306d574c8897cd721f84d429972",
                        "number_of_iterations": 14708638287767651172,
                        "output": {
                            "data": "0x08000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
                        },
                    },
                    "reward_chain_sp_vdf": {
                        "challenge": "0x7cbd5905838c1dc2becd00298a5b3a6e42b6a306d574c8897cd721f84d429972",
                        "number_of_iterations": 14708638287767651172,
                        "output": {
                            "data": "0x08000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
                        },
                    },
                    "reward_chain_sp_signature": "0xc00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000",
                    "reward_chain_ip_vdf": {
                        "challenge": "0x7cbd5905838c1dc2becd00298a5b3a6e42b6a306d574c8897cd721f84d429972",
                        "number_of_iterations": 14708638287767651172,
                        "output": {
                            "data": "0x08000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
                        },
                    },
                    "infused_challenge_chain_ip_vdf": {
                        "challenge": "0x7cbd5905838c1dc2becd00298a5b3a6e42b6a306d574c8897cd721f84d429972",
                        "number_of_iterations": 14708638287767651172,
                        "output": {
                            "data": "0x08000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
                        },
                    },
                    "is_transaction_block": False,
                },
                "challenge_chain_sp_proof": {
                    "witness_type": 197,
                    "witness": "0x30303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030",
                    "normalized_to_identity": False,
                },
                "challenge_chain_ip_proof": {
                    "witness_type": 197,
                    "witness": "0x30303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030",
                    "normalized_to_identity": False,
                },
                "reward_chain_sp_proof": {
                    "witness_type": 197,
                    "witness": "0x30303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030",
                    "normalized_to_identity": False,
                },
                "reward_chain_ip_proof": {
                    "witness_type": 197,
                    "witness": "0x30303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030",
                    "normalized_to_identity": False,
                },
                "infused_challenge_chain_ip_proof": {
                    "witness_type": 197,
                    "witness": "0x30303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030",
                    "normalized_to_identity": False,
                },
                "foliage": {
                    "prev_block_hash": "0x312fd3fe7c9a21cd90ce40b567730ab087fa29436bf8568adacc605f52912fba",
                    "reward_block_hash": "0xba37d30b755680e0b8873a1b7f0ae7636400999ca2b2d32ad0aebb0c24e258aa",
                    "foliage_block_data": {
                        "unfinished_reward_block_hash": "0x205be4e4efff5b8d99b3f5c8d0ad19072875b9bac1ec3edda1f0df5467e2e61a",
                        "pool_target": {
                            "puzzle_hash": "0xd23da14695a188ae5708dd152263c4db883eb27edeb936178d4d988b8f3ce5fc",
                            "max_height": 421941852,
                        },
                        "pool_signature": "0xc00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000",
                        "farmer_reward_puzzle_hash": "0x4e62d7ed145b394ce28533e4f0a7d70f339f9d4c49ee717e51e2d6480e5fcbcc",
                        "extension_data": "0xd53254dcdcbfddb431c3ff89d1a785491663b51552e3847d29e36972f43b536d",
                    },
                    "foliage_block_data_signature": "0xc00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000",
                    "foliage_transaction_block_hash": "0xac6a47ca76efeac93b1c435dfa2e876ab63c0a62fa7aa5a6b8cf9efd95084025",
                    "foliage_transaction_block_signature": "0xc00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000",
                },
                "foliage_transaction_block": {
                    "prev_transaction_block_hash": "0x852ed117f46fa98af7a17fcb050c369245a30fcffc190177c3a316109d1609c7",
                    "timestamp": 3871668531533889186,
                    "filter_hash": "0xffab724c5df9b90c0842565225f5ed842da14f159373c05d63643405ccce84b3",
                    "additions_root": "0x5f87a17fafb44afd0d6b5b67b77be38570b4bc0150388bd9c176d4ac5d4e693b",
                    "removals_root": "0xdb967ce278f9bf4fdc77cb9fa82b5b2ce6876746eb5e61f4352a41e3abb63275",
                    "transactions_info_hash": "0x7eebe3b21505f7c7cb5536e96ab893bfa4626a5cf9c79fadb5dae6913e0a7cb3",
                },
                "transactions_filter": "0x0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000",
                "transactions_info": {
                    "generator_root": "0x4cb791379aee03879628f69f16c0d3b78fd865c010c53c3b412dfa56e40f4d78",
                    "generator_refs_root": "0x180c72ecd6e32986a354681fcf6924aa82c08cfb9df95667fa24442103cc2189",
                    "aggregated_signature": "0xc00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000",
                    "fees": 5840504611725889474,
                    "cost": 7273736876528078474,
                    "reward_claims_incorporated": [
                        {
                            "parent_coin_info": "0xdde12b149d44bafd07390d2ad6ce774ab50d083ada3f0bc3c0adebe6a6a1a4ab",
                            "puzzle_hash": "0x503da231145145b114e85af933ed86a5834c08323743803ee31fca2b1c64ce15",
                            "amount": 8428133224333694484,
                        }
                    ],
                },
            }
        ],
    },
    "tip": "0xbf71d6f1ecae308aacf87db77aeba5a06f5d1099bfc7005529885e1f2dad857f",
}

request_block_json: Dict[str, Any] = {"height": 678860074, "include_transaction_block": False}

reject_block_json: Dict[str, Any] = {"height": 966946253}

request_blocks_json: Dict[str, Any] = {
    "start_height": 2578479570,
    "end_height": 3884442719,
    "include_transaction_block": False,
}

respond_blocks_json: Dict[str, Any] = {
    "start_height": 1000,
    "end_height": 4201431299,
    "blocks": [
        {
            "finished_sub_slots": [
                {
                    "challenge_chain": {
                        "challenge_chain_end_of_slot_vdf": {
                            "challenge": "0x7cbd5905838c1dc2becd00298a5b3a6e42b6a306d574c8897cd721f84d429972",
                            "number_of_iterations": 14708638287767651172,
                            "output": {
                                "data": "0x08000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
                            },
                        },
                        "infused_challenge_chain_sub_slot_hash": "0x42c10d66108589c11bb3811b37d214b6351b73e25bad6c956c0bf1c05a4d93fb",
                        "subepoch_summary_hash": "0xcdb6d334b461a01c4d07c76dd71d5a9f3a2949807a3499eb484e4b91e6cea309",
                        "new_sub_slot_iters": 42556034269004566,
                        "new_difficulty": 16610212302933121129,
                    },
                    "infused_challenge_chain": {
                        "infused_challenge_chain_end_of_slot_vdf": {
                            "challenge": "0x7cbd5905838c1dc2becd00298a5b3a6e42b6a306d574c8897cd721f84d429972",
                            "number_of_iterations": 14708638287767651172,
                            "output": {
                                "data": "0x08000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
                            },
                        }
                    },
                    "reward_chain": {
                        "end_of_slot_vdf": {
                            "challenge": "0x7cbd5905838c1dc2becd00298a5b3a6e42b6a306d574c8897cd721f84d429972",
                            "number_of_iterations": 14708638287767651172,
                            "output": {
                                "data": "0x08000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
                            },
                        },
                        "challenge_chain_sub_slot_hash": "0x893f282b27c4961f47d886577a8d7c136d1e738e6c5badd37c1994e68871cb70",
                        "infused_challenge_chain_sub_slot_hash": "0x4be4cc2a1f15c5c69fb9becac0cbe0df5ea007a94f22bca79f88e14fc2a46def",
                        "deficit": 52,
                    },
                    "proofs": {
                        "challenge_chain_slot_proof": {
                            "witness_type": 197,
                            "witness": "0x30303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030",
                            "normalized_to_identity": False,
                        },
                        "infused_challenge_chain_slot_proof": {
                            "witness_type": 197,
                            "witness": "0x30303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030",
                            "normalized_to_identity": False,
                        },
                        "reward_chain_slot_proof": {
                            "witness_type": 197,
                            "witness": "0x30303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030",
                            "normalized_to_identity": False,
                        },
                    },
                }
            ],
            "reward_chain_block": {
                "weight": 187084448821891925757676377381787790114,
                "height": 301889038,
                "total_iters": 147405131564197136044258885592706844266,
                "signage_point_index": 9,
                "pos_ss_cc_challenge_hash": "0x50102505a28e3969db19c699a5e53af73c1cb3108e2ab9ce9d86d1f058b10457",
                "proof_of_space": {
                    "challenge": "0x1fb331df88bc142e70c110e21620374118fb220ccc3ef621378197e850882ec9",
                    "pool_public_key": "0xa04c6b5ac7dfb935f6feecfdd72348ccf1d4be4fe7e26acf271ea3b7d308da61e0a308f7a62495328a81f5147b66634c",
                    "pool_contract_puzzle_hash": None,
                    "plot_public_key": "0xb6449c2c68df97c19e884427e42ee7350982d4020571ead08732615ff39bd216bfd630b6460784982bec98b49fea79d0",
                    "size": 204,
                    "proof": "0xa67188ae0c02c49b0e821a9773033a3fbd338030c383080dbb8b1d63f07af427d8075e59d911f85ea562fd967823588f9a405a4464fdf5dc0866ee15bebd6b94cb147e28aa9cf96da930611486b779737ed721ea376b9939ba05357141223d75d21b21f310ec32d85ed3b98cf301494ea91b8501138481f3bfa1c384fd998b1fdd2855ac6f0c8554c520fb0bfa3663f238124035e14682bc11eaf7c372b6af4ed7f59a406810c71711906f8c91f94b1f",
                },
                "challenge_chain_sp_vdf": {
                    "challenge": "0x7cbd5905838c1dc2becd00298a5b3a6e42b6a306d574c8897cd721f84d429972",
                    "number_of_iterations": 14708638287767651172,
                    "output": {
                        "data": "0x08000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
                    },
                },
                "challenge_chain_sp_signature": "0xc00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000",
                "challenge_chain_ip_vdf": {
                    "challenge": "0x7cbd5905838c1dc2becd00298a5b3a6e42b6a306d574c8897cd721f84d429972",
                    "number_of_iterations": 14708638287767651172,
                    "output": {
                        "data": "0x08000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
                    },
                },
                "reward_chain_sp_vdf": {
                    "challenge": "0x7cbd5905838c1dc2becd00298a5b3a6e42b6a306d574c8897cd721f84d429972",
                    "number_of_iterations": 14708638287767651172,
                    "output": {
                        "data": "0x08000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
                    },
                },
                "reward_chain_sp_signature": "0xc00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000",
                "reward_chain_ip_vdf": {
                    "challenge": "0x7cbd5905838c1dc2becd00298a5b3a6e42b6a306d574c8897cd721f84d429972",
                    "number_of_iterations": 14708638287767651172,
                    "output": {
                        "data": "0x08000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
                    },
                },
                "infused_challenge_chain_ip_vdf": {
                    "challenge": "0x7cbd5905838c1dc2becd00298a5b3a6e42b6a306d574c8897cd721f84d429972",
                    "number_of_iterations": 14708638287767651172,
                    "output": {
                        "data": "0x08000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
                    },
                },
                "is_transaction_block": False,
            },
            "challenge_chain_sp_proof": {
                "witness_type": 197,
                "witness": "0x30303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030",
                "normalized_to_identity": False,
            },
            "challenge_chain_ip_proof": {
                "witness_type": 197,
                "witness": "0x30303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030",
                "normalized_to_identity": False,
            },
            "reward_chain_sp_proof": {
                "witness_type": 197,
                "witness": "0x30303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030",
                "normalized_to_identity": False,
            },
            "reward_chain_ip_proof": {
                "witness_type": 197,
                "witness": "0x30303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030",
                "normalized_to_identity": False,
            },
            "infused_challenge_chain_ip_proof": {
                "witness_type": 197,
                "witness": "0x30303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030",
                "normalized_to_identity": False,
            },
            "foliage": {
                "prev_block_hash": "0x312fd3fe7c9a21cd90ce40b567730ab087fa29436bf8568adacc605f52912fba",
                "reward_block_hash": "0xba37d30b755680e0b8873a1b7f0ae7636400999ca2b2d32ad0aebb0c24e258aa",
                "foliage_block_data": {
                    "unfinished_reward_block_hash": "0x205be4e4efff5b8d99b3f5c8d0ad19072875b9bac1ec3edda1f0df5467e2e61a",
                    "pool_target": {
                        "puzzle_hash": "0xd23da14695a188ae5708dd152263c4db883eb27edeb936178d4d988b8f3ce5fc",
                        "max_height": 421941852,
                    },
                    "pool_signature": "0xc00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000",
                    "farmer_reward_puzzle_hash": "0x4e62d7ed145b394ce28533e4f0a7d70f339f9d4c49ee717e51e2d6480e5fcbcc",
                    "extension_data": "0xd53254dcdcbfddb431c3ff89d1a785491663b51552e3847d29e36972f43b536d",
                },
                "foliage_block_data_signature": "0xc00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000",
                "foliage_transaction_block_hash": "0xac6a47ca76efeac93b1c435dfa2e876ab63c0a62fa7aa5a6b8cf9efd95084025",
                "foliage_transaction_block_signature": "0xc00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000",
            },
            "foliage_transaction_block": {
                "prev_transaction_block_hash": "0x852ed117f46fa98af7a17fcb050c369245a30fcffc190177c3a316109d1609c7",
                "timestamp": 3871668531533889186,
                "filter_hash": "0xffab724c5df9b90c0842565225f5ed842da14f159373c05d63643405ccce84b3",
                "additions_root": "0x5f87a17fafb44afd0d6b5b67b77be38570b4bc0150388bd9c176d4ac5d4e693b",
                "removals_root": "0xdb967ce278f9bf4fdc77cb9fa82b5b2ce6876746eb5e61f4352a41e3abb63275",
                "transactions_info_hash": "0x7eebe3b21505f7c7cb5536e96ab893bfa4626a5cf9c79fadb5dae6913e0a7cb3",
            },
            "transactions_info": {
                "generator_root": "0x4cb791379aee03879628f69f16c0d3b78fd865c010c53c3b412dfa56e40f4d78",
                "generator_refs_root": "0x180c72ecd6e32986a354681fcf6924aa82c08cfb9df95667fa24442103cc2189",
                "aggregated_signature": "0xc00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000",
                "fees": 5840504611725889474,
                "cost": 7273736876528078474,
                "reward_claims_incorporated": [
                    {
                        "parent_coin_info": "0xdde12b149d44bafd07390d2ad6ce774ab50d083ada3f0bc3c0adebe6a6a1a4ab",
                        "puzzle_hash": "0x503da231145145b114e85af933ed86a5834c08323743803ee31fca2b1c64ce15",
                        "amount": 8428133224333694484,
                    }
                ],
            },
            "transactions_generator": "0xff01ffff33ffa0f8912302fb33b8188046662785704afc3dd945074e4b45499a7173946e044695ff8203e880ffff33ffa03eaa52e850322dbc281c6b922e9d8819c7b4120ee054c4aa79db50be516a2bcaff8207d08080",
            "transactions_generator_ref_list": [2456207540],
        },
        {
            "finished_sub_slots": [
                {
                    "challenge_chain": {
                        "challenge_chain_end_of_slot_vdf": {
                            "challenge": "0x7cbd5905838c1dc2becd00298a5b3a6e42b6a306d574c8897cd721f84d429972",
                            "number_of_iterations": 14708638287767651172,
                            "output": {
                                "data": "0x08000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
                            },
                        },
                        "infused_challenge_chain_sub_slot_hash": "0x42c10d66108589c11bb3811b37d214b6351b73e25bad6c956c0bf1c05a4d93fb",
                        "subepoch_summary_hash": "0xcdb6d334b461a01c4d07c76dd71d5a9f3a2949807a3499eb484e4b91e6cea309",
                        "new_sub_slot_iters": 42556034269004566,
                        "new_difficulty": 16610212302933121129,
                    },
                    "infused_challenge_chain": {
                        "infused_challenge_chain_end_of_slot_vdf": {
                            "challenge": "0x7cbd5905838c1dc2becd00298a5b3a6e42b6a306d574c8897cd721f84d429972",
                            "number_of_iterations": 14708638287767651172,
                            "output": {
                                "data": "0x08000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
                            },
                        }
                    },
                    "reward_chain": {
                        "end_of_slot_vdf": {
                            "challenge": "0x7cbd5905838c1dc2becd00298a5b3a6e42b6a306d574c8897cd721f84d429972",
                            "number_of_iterations": 14708638287767651172,
                            "output": {
                                "data": "0x08000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
                            },
                        },
                        "challenge_chain_sub_slot_hash": "0x893f282b27c4961f47d886577a8d7c136d1e738e6c5badd37c1994e68871cb70",
                        "infused_challenge_chain_sub_slot_hash": "0x4be4cc2a1f15c5c69fb9becac0cbe0df5ea007a94f22bca79f88e14fc2a46def",
                        "deficit": 52,
                    },
                    "proofs": {
                        "challenge_chain_slot_proof": {
                            "witness_type": 197,
                            "witness": "0x30303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030",
                            "normalized_to_identity": False,
                        },
                        "infused_challenge_chain_slot_proof": {
                            "witness_type": 197,
                            "witness": "0x30303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030",
                            "normalized_to_identity": False,
                        },
                        "reward_chain_slot_proof": {
                            "witness_type": 197,
                            "witness": "0x30303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030",
                            "normalized_to_identity": False,
                        },
                    },
                }
            ],
            "reward_chain_block": {
                "weight": 187084448821891925757676377381787790114,
                "height": 301889038,
                "total_iters": 147405131564197136044258885592706844266,
                "signage_point_index": 9,
                "pos_ss_cc_challenge_hash": "0x50102505a28e3969db19c699a5e53af73c1cb3108e2ab9ce9d86d1f058b10457",
                "proof_of_space": {
                    "challenge": "0x1fb331df88bc142e70c110e21620374118fb220ccc3ef621378197e850882ec9",
                    "pool_public_key": "0xa04c6b5ac7dfb935f6feecfdd72348ccf1d4be4fe7e26acf271ea3b7d308da61e0a308f7a62495328a81f5147b66634c",
                    "pool_contract_puzzle_hash": None,
                    "plot_public_key": "0xb6449c2c68df97c19e884427e42ee7350982d4020571ead08732615ff39bd216bfd630b6460784982bec98b49fea79d0",
                    "size": 204,
                    "proof": "0xa67188ae0c02c49b0e821a9773033a3fbd338030c383080dbb8b1d63f07af427d8075e59d911f85ea562fd967823588f9a405a4464fdf5dc0866ee15bebd6b94cb147e28aa9cf96da930611486b779737ed721ea376b9939ba05357141223d75d21b21f310ec32d85ed3b98cf301494ea91b8501138481f3bfa1c384fd998b1fdd2855ac6f0c8554c520fb0bfa3663f238124035e14682bc11eaf7c372b6af4ed7f59a406810c71711906f8c91f94b1f",
                },
                "challenge_chain_sp_vdf": {
                    "challenge": "0x7cbd5905838c1dc2becd00298a5b3a6e42b6a306d574c8897cd721f84d429972",
                    "number_of_iterations": 14708638287767651172,
                    "output": {
                        "data": "0x08000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
                    },
                },
                "challenge_chain_sp_signature": "0xc00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000",
                "challenge_chain_ip_vdf": {
                    "challenge": "0x7cbd5905838c1dc2becd00298a5b3a6e42b6a306d574c8897cd721f84d429972",
                    "number_of_iterations": 14708638287767651172,
                    "output": {
                        "data": "0x08000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
                    },
                },
                "reward_chain_sp_vdf": {
                    "challenge": "0x7cbd5905838c1dc2becd00298a5b3a6e42b6a306d574c8897cd721f84d429972",
                    "number_of_iterations": 14708638287767651172,
                    "output": {
                        "data": "0x08000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
                    },
                },
                "reward_chain_sp_signature": "0xc00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000",
                "reward_chain_ip_vdf": {
                    "challenge": "0x7cbd5905838c1dc2becd00298a5b3a6e42b6a306d574c8897cd721f84d429972",
                    "number_of_iterations": 14708638287767651172,
                    "output": {
                        "data": "0x08000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
                    },
                },
                "infused_challenge_chain_ip_vdf": {
                    "challenge": "0x7cbd5905838c1dc2becd00298a5b3a6e42b6a306d574c8897cd721f84d429972",
                    "number_of_iterations": 14708638287767651172,
                    "output": {
                        "data": "0x08000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
                    },
                },
                "is_transaction_block": False,
            },
            "challenge_chain_sp_proof": {
                "witness_type": 197,
                "witness": "0x30303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030",
                "normalized_to_identity": False,
            },
            "challenge_chain_ip_proof": {
                "witness_type": 197,
                "witness": "0x30303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030",
                "normalized_to_identity": False,
            },
            "reward_chain_sp_proof": {
                "witness_type": 197,
                "witness": "0x30303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030",
                "normalized_to_identity": False,
            },
            "reward_chain_ip_proof": {
                "witness_type": 197,
                "witness": "0x30303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030",
                "normalized_to_identity": False,
            },
            "infused_challenge_chain_ip_proof": {
                "witness_type": 197,
                "witness": "0x30303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030",
                "normalized_to_identity": False,
            },
            "foliage": {
                "prev_block_hash": "0x312fd3fe7c9a21cd90ce40b567730ab087fa29436bf8568adacc605f52912fba",
                "reward_block_hash": "0xba37d30b755680e0b8873a1b7f0ae7636400999ca2b2d32ad0aebb0c24e258aa",
                "foliage_block_data": {
                    "unfinished_reward_block_hash": "0x205be4e4efff5b8d99b3f5c8d0ad19072875b9bac1ec3edda1f0df5467e2e61a",
                    "pool_target": {
                        "puzzle_hash": "0xd23da14695a188ae5708dd152263c4db883eb27edeb936178d4d988b8f3ce5fc",
                        "max_height": 421941852,
                    },
                    "pool_signature": "0xc00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000",
                    "farmer_reward_puzzle_hash": "0x4e62d7ed145b394ce28533e4f0a7d70f339f9d4c49ee717e51e2d6480e5fcbcc",
                    "extension_data": "0xd53254dcdcbfddb431c3ff89d1a785491663b51552e3847d29e36972f43b536d",
                },
                "foliage_block_data_signature": "0xc00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000",
                "foliage_transaction_block_hash": "0xac6a47ca76efeac93b1c435dfa2e876ab63c0a62fa7aa5a6b8cf9efd95084025",
                "foliage_transaction_block_signature": "0xc00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000",
            },
            "foliage_transaction_block": {
                "prev_transaction_block_hash": "0x852ed117f46fa98af7a17fcb050c369245a30fcffc190177c3a316109d1609c7",
                "timestamp": 3871668531533889186,
                "filter_hash": "0xffab724c5df9b90c0842565225f5ed842da14f159373c05d63643405ccce84b3",
                "additions_root": "0x5f87a17fafb44afd0d6b5b67b77be38570b4bc0150388bd9c176d4ac5d4e693b",
                "removals_root": "0xdb967ce278f9bf4fdc77cb9fa82b5b2ce6876746eb5e61f4352a41e3abb63275",
                "transactions_info_hash": "0x7eebe3b21505f7c7cb5536e96ab893bfa4626a5cf9c79fadb5dae6913e0a7cb3",
            },
            "transactions_info": {
                "generator_root": "0x4cb791379aee03879628f69f16c0d3b78fd865c010c53c3b412dfa56e40f4d78",
                "generator_refs_root": "0x180c72ecd6e32986a354681fcf6924aa82c08cfb9df95667fa24442103cc2189",
                "aggregated_signature": "0xc00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000",
                "fees": 5840504611725889474,
                "cost": 7273736876528078474,
                "reward_claims_incorporated": [
                    {
                        "parent_coin_info": "0xdde12b149d44bafd07390d2ad6ce774ab50d083ada3f0bc3c0adebe6a6a1a4ab",
                        "puzzle_hash": "0x503da231145145b114e85af933ed86a5834c08323743803ee31fca2b1c64ce15",
                        "amount": 8428133224333694484,
                    }
                ],
            },
            "transactions_generator": "0xff01ffff33ffa0f8912302fb33b8188046662785704afc3dd945074e4b45499a7173946e044695ff8203e880ffff33ffa03eaa52e850322dbc281c6b922e9d8819c7b4120ee054c4aa79db50be516a2bcaff8207d08080",
            "transactions_generator_ref_list": [2456207540],
        },
    ],
}

reject_blocks_json: Dict[str, Any] = {"start_height": 1160742782, "end_height": 1856800720}

respond_block_json: Dict[str, Any] = {
    "block": {
        "finished_sub_slots": [
            {
                "challenge_chain": {
                    "challenge_chain_end_of_slot_vdf": {
                        "challenge": "0x7cbd5905838c1dc2becd00298a5b3a6e42b6a306d574c8897cd721f84d429972",
                        "number_of_iterations": 14708638287767651172,
                        "output": {
                            "data": "0x08000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
                        },
                    },
                    "infused_challenge_chain_sub_slot_hash": "0x42c10d66108589c11bb3811b37d214b6351b73e25bad6c956c0bf1c05a4d93fb",
                    "subepoch_summary_hash": "0xcdb6d334b461a01c4d07c76dd71d5a9f3a2949807a3499eb484e4b91e6cea309",
                    "new_sub_slot_iters": 42556034269004566,
                    "new_difficulty": 16610212302933121129,
                },
                "infused_challenge_chain": {
                    "infused_challenge_chain_end_of_slot_vdf": {
                        "challenge": "0x7cbd5905838c1dc2becd00298a5b3a6e42b6a306d574c8897cd721f84d429972",
                        "number_of_iterations": 14708638287767651172,
                        "output": {
                            "data": "0x08000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
                        },
                    }
                },
                "reward_chain": {
                    "end_of_slot_vdf": {
                        "challenge": "0x7cbd5905838c1dc2becd00298a5b3a6e42b6a306d574c8897cd721f84d429972",
                        "number_of_iterations": 14708638287767651172,
                        "output": {
                            "data": "0x08000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
                        },
                    },
                    "challenge_chain_sub_slot_hash": "0x893f282b27c4961f47d886577a8d7c136d1e738e6c5badd37c1994e68871cb70",
                    "infused_challenge_chain_sub_slot_hash": "0x4be4cc2a1f15c5c69fb9becac0cbe0df5ea007a94f22bca79f88e14fc2a46def",
                    "deficit": 52,
                },
                "proofs": {
                    "challenge_chain_slot_proof": {
                        "witness_type": 197,
                        "witness": "0x30303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030",
                        "normalized_to_identity": False,
                    },
                    "infused_challenge_chain_slot_proof": {
                        "witness_type": 197,
                        "witness": "0x30303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030",
                        "normalized_to_identity": False,
                    },
                    "reward_chain_slot_proof": {
                        "witness_type": 197,
                        "witness": "0x30303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030",
                        "normalized_to_identity": False,
                    },
                },
            }
        ],
        "reward_chain_block": {
            "weight": 187084448821891925757676377381787790114,
            "height": 301889038,
            "total_iters": 147405131564197136044258885592706844266,
            "signage_point_index": 9,
            "pos_ss_cc_challenge_hash": "0x50102505a28e3969db19c699a5e53af73c1cb3108e2ab9ce9d86d1f058b10457",
            "proof_of_space": {
                "challenge": "0x1fb331df88bc142e70c110e21620374118fb220ccc3ef621378197e850882ec9",
                "pool_public_key": "0xa04c6b5ac7dfb935f6feecfdd72348ccf1d4be4fe7e26acf271ea3b7d308da61e0a308f7a62495328a81f5147b66634c",
                "pool_contract_puzzle_hash": None,
                "plot_public_key": "0xb6449c2c68df97c19e884427e42ee7350982d4020571ead08732615ff39bd216bfd630b6460784982bec98b49fea79d0",
                "size": 204,
                "proof": "0xa67188ae0c02c49b0e821a9773033a3fbd338030c383080dbb8b1d63f07af427d8075e59d911f85ea562fd967823588f9a405a4464fdf5dc0866ee15bebd6b94cb147e28aa9cf96da930611486b779737ed721ea376b9939ba05357141223d75d21b21f310ec32d85ed3b98cf301494ea91b8501138481f3bfa1c384fd998b1fdd2855ac6f0c8554c520fb0bfa3663f238124035e14682bc11eaf7c372b6af4ed7f59a406810c71711906f8c91f94b1f",
            },
            "challenge_chain_sp_vdf": {
                "challenge": "0x7cbd5905838c1dc2becd00298a5b3a6e42b6a306d574c8897cd721f84d429972",
                "number_of_iterations": 14708638287767651172,
                "output": {
                    "data": "0x08000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
                },
            },
            "challenge_chain_sp_signature": "0xc00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000",
            "challenge_chain_ip_vdf": {
                "challenge": "0x7cbd5905838c1dc2becd00298a5b3a6e42b6a306d574c8897cd721f84d429972",
                "number_of_iterations": 14708638287767651172,
                "output": {
                    "data": "0x08000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
                },
            },
            "reward_chain_sp_vdf": {
                "challenge": "0x7cbd5905838c1dc2becd00298a5b3a6e42b6a306d574c8897cd721f84d429972",
                "number_of_iterations": 14708638287767651172,
                "output": {
                    "data": "0x08000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
                },
            },
            "reward_chain_sp_signature": "0xc00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000",
            "reward_chain_ip_vdf": {
                "challenge": "0x7cbd5905838c1dc2becd00298a5b3a6e42b6a306d574c8897cd721f84d429972",
                "number_of_iterations": 14708638287767651172,
                "output": {
                    "data": "0x08000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
                },
            },
            "infused_challenge_chain_ip_vdf": {
                "challenge": "0x7cbd5905838c1dc2becd00298a5b3a6e42b6a306d574c8897cd721f84d429972",
                "number_of_iterations": 14708638287767651172,
                "output": {
                    "data": "0x08000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
                },
            },
            "is_transaction_block": False,
        },
        "challenge_chain_sp_proof": {
            "witness_type": 197,
            "witness": "0x30303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030",
            "normalized_to_identity": False,
        },
        "challenge_chain_ip_proof": {
            "witness_type": 197,
            "witness": "0x30303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030",
            "normalized_to_identity": False,
        },
        "reward_chain_sp_proof": {
            "witness_type": 197,
            "witness": "0x30303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030",
            "normalized_to_identity": False,
        },
        "reward_chain_ip_proof": {
            "witness_type": 197,
            "witness": "0x30303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030",
            "normalized_to_identity": False,
        },
        "infused_challenge_chain_ip_proof": {
            "witness_type": 197,
            "witness": "0x30303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030",
            "normalized_to_identity": False,
        },
        "foliage": {
            "prev_block_hash": "0x312fd3fe7c9a21cd90ce40b567730ab087fa29436bf8568adacc605f52912fba",
            "reward_block_hash": "0xba37d30b755680e0b8873a1b7f0ae7636400999ca2b2d32ad0aebb0c24e258aa",
            "foliage_block_data": {
                "unfinished_reward_block_hash": "0x205be4e4efff5b8d99b3f5c8d0ad19072875b9bac1ec3edda1f0df5467e2e61a",
                "pool_target": {
                    "puzzle_hash": "0xd23da14695a188ae5708dd152263c4db883eb27edeb936178d4d988b8f3ce5fc",
                    "max_height": 421941852,
                },
                "pool_signature": "0xc00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000",
                "farmer_reward_puzzle_hash": "0x4e62d7ed145b394ce28533e4f0a7d70f339f9d4c49ee717e51e2d6480e5fcbcc",
                "extension_data": "0xd53254dcdcbfddb431c3ff89d1a785491663b51552e3847d29e36972f43b536d",
            },
            "foliage_block_data_signature": "0xc00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000",
            "foliage_transaction_block_hash": "0xac6a47ca76efeac93b1c435dfa2e876ab63c0a62fa7aa5a6b8cf9efd95084025",
            "foliage_transaction_block_signature": "0xc00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000",
        },
        "foliage_transaction_block": {
            "prev_transaction_block_hash": "0x852ed117f46fa98af7a17fcb050c369245a30fcffc190177c3a316109d1609c7",
            "timestamp": 3871668531533889186,
            "filter_hash": "0xffab724c5df9b90c0842565225f5ed842da14f159373c05d63643405ccce84b3",
            "additions_root": "0x5f87a17fafb44afd0d6b5b67b77be38570b4bc0150388bd9c176d4ac5d4e693b",
            "removals_root": "0xdb967ce278f9bf4fdc77cb9fa82b5b2ce6876746eb5e61f4352a41e3abb63275",
            "transactions_info_hash": "0x7eebe3b21505f7c7cb5536e96ab893bfa4626a5cf9c79fadb5dae6913e0a7cb3",
        },
        "transactions_info": {
            "generator_root": "0x4cb791379aee03879628f69f16c0d3b78fd865c010c53c3b412dfa56e40f4d78",
            "generator_refs_root": "0x180c72ecd6e32986a354681fcf6924aa82c08cfb9df95667fa24442103cc2189",
            "aggregated_signature": "0xc00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000",
            "fees": 5840504611725889474,
            "cost": 7273736876528078474,
            "reward_claims_incorporated": [
                {
                    "parent_coin_info": "0xdde12b149d44bafd07390d2ad6ce774ab50d083ada3f0bc3c0adebe6a6a1a4ab",
                    "puzzle_hash": "0x503da231145145b114e85af933ed86a5834c08323743803ee31fca2b1c64ce15",
                    "amount": 8428133224333694484,
                }
            ],
        },
        "transactions_generator": "0xff01ffff33ffa0f8912302fb33b8188046662785704afc3dd945074e4b45499a7173946e044695ff8203e880ffff33ffa03eaa52e850322dbc281c6b922e9d8819c7b4120ee054c4aa79db50be516a2bcaff8207d08080",
        "transactions_generator_ref_list": [2456207540],
    }
}

new_unfinished_block_json: Dict[str, Any] = {
    "unfinished_reward_hash": "0x229646fb33551966039d9324c0d10166c554d20e9a11e3f30942ec0bb346377e"
}

request_unfinished_block_json: Dict[str, Any] = {
    "unfinished_reward_hash": "0x8b5e5a59f33bb89e1bfd5aca79409352864e70aa7765c331d641875f83d59d1d"
}

respond_unfinished_block_json: Dict[str, Any] = {
    "unfinished_block": {
        "finished_sub_slots": [
            {
                "challenge_chain": {
                    "challenge_chain_end_of_slot_vdf": {
                        "challenge": "0x7cbd5905838c1dc2becd00298a5b3a6e42b6a306d574c8897cd721f84d429972",
                        "number_of_iterations": 14708638287767651172,
                        "output": {
                            "data": "0x08000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
                        },
                    },
                    "infused_challenge_chain_sub_slot_hash": "0x42c10d66108589c11bb3811b37d214b6351b73e25bad6c956c0bf1c05a4d93fb",
                    "subepoch_summary_hash": "0xcdb6d334b461a01c4d07c76dd71d5a9f3a2949807a3499eb484e4b91e6cea309",
                    "new_sub_slot_iters": 42556034269004566,
                    "new_difficulty": 16610212302933121129,
                },
                "infused_challenge_chain": {
                    "infused_challenge_chain_end_of_slot_vdf": {
                        "challenge": "0x7cbd5905838c1dc2becd00298a5b3a6e42b6a306d574c8897cd721f84d429972",
                        "number_of_iterations": 14708638287767651172,
                        "output": {
                            "data": "0x08000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
                        },
                    }
                },
                "reward_chain": {
                    "end_of_slot_vdf": {
                        "challenge": "0x7cbd5905838c1dc2becd00298a5b3a6e42b6a306d574c8897cd721f84d429972",
                        "number_of_iterations": 14708638287767651172,
                        "output": {
                            "data": "0x08000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
                        },
                    },
                    "challenge_chain_sub_slot_hash": "0x893f282b27c4961f47d886577a8d7c136d1e738e6c5badd37c1994e68871cb70",
                    "infused_challenge_chain_sub_slot_hash": "0x4be4cc2a1f15c5c69fb9becac0cbe0df5ea007a94f22bca79f88e14fc2a46def",
                    "deficit": 52,
                },
                "proofs": {
                    "challenge_chain_slot_proof": {
                        "witness_type": 197,
                        "witness": "0x30303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030",
                        "normalized_to_identity": False,
                    },
                    "infused_challenge_chain_slot_proof": {
                        "witness_type": 197,
                        "witness": "0x30303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030",
                        "normalized_to_identity": False,
                    },
                    "reward_chain_slot_proof": {
                        "witness_type": 197,
                        "witness": "0x30303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030",
                        "normalized_to_identity": False,
                    },
                },
            }
        ],
        "reward_chain_block": {
            "total_iters": 147405131564197136044258885592706844266,
            "signage_point_index": 9,
            "pos_ss_cc_challenge_hash": "0x50102505a28e3969db19c699a5e53af73c1cb3108e2ab9ce9d86d1f058b10457",
            "proof_of_space": {
                "challenge": "0x1fb331df88bc142e70c110e21620374118fb220ccc3ef621378197e850882ec9",
                "pool_public_key": "0xa04c6b5ac7dfb935f6feecfdd72348ccf1d4be4fe7e26acf271ea3b7d308da61e0a308f7a62495328a81f5147b66634c",
                "pool_contract_puzzle_hash": None,
                "plot_public_key": "0xb6449c2c68df97c19e884427e42ee7350982d4020571ead08732615ff39bd216bfd630b6460784982bec98b49fea79d0",
                "size": 204,
                "proof": "0xa67188ae0c02c49b0e821a9773033a3fbd338030c383080dbb8b1d63f07af427d8075e59d911f85ea562fd967823588f9a405a4464fdf5dc0866ee15bebd6b94cb147e28aa9cf96da930611486b779737ed721ea376b9939ba05357141223d75d21b21f310ec32d85ed3b98cf301494ea91b8501138481f3bfa1c384fd998b1fdd2855ac6f0c8554c520fb0bfa3663f238124035e14682bc11eaf7c372b6af4ed7f59a406810c71711906f8c91f94b1f",
            },
            "challenge_chain_sp_vdf": {
                "challenge": "0x7cbd5905838c1dc2becd00298a5b3a6e42b6a306d574c8897cd721f84d429972",
                "number_of_iterations": 14708638287767651172,
                "output": {
                    "data": "0x08000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
                },
            },
            "challenge_chain_sp_signature": "0xc00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000",
            "reward_chain_sp_vdf": {
                "challenge": "0x7cbd5905838c1dc2becd00298a5b3a6e42b6a306d574c8897cd721f84d429972",
                "number_of_iterations": 14708638287767651172,
                "output": {
                    "data": "0x08000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
                },
            },
            "reward_chain_sp_signature": "0xc00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000",
        },
        "challenge_chain_sp_proof": {
            "witness_type": 197,
            "witness": "0x30303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030",
            "normalized_to_identity": False,
        },
        "reward_chain_sp_proof": {
            "witness_type": 197,
            "witness": "0x30303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030",
            "normalized_to_identity": False,
        },
        "foliage": {
            "prev_block_hash": "0x312fd3fe7c9a21cd90ce40b567730ab087fa29436bf8568adacc605f52912fba",
            "reward_block_hash": "0xba37d30b755680e0b8873a1b7f0ae7636400999ca2b2d32ad0aebb0c24e258aa",
            "foliage_block_data": {
                "unfinished_reward_block_hash": "0x205be4e4efff5b8d99b3f5c8d0ad19072875b9bac1ec3edda1f0df5467e2e61a",
                "pool_target": {
                    "puzzle_hash": "0xd23da14695a188ae5708dd152263c4db883eb27edeb936178d4d988b8f3ce5fc",
                    "max_height": 421941852,
                },
                "pool_signature": "0xc00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000",
                "farmer_reward_puzzle_hash": "0x4e62d7ed145b394ce28533e4f0a7d70f339f9d4c49ee717e51e2d6480e5fcbcc",
                "extension_data": "0xd53254dcdcbfddb431c3ff89d1a785491663b51552e3847d29e36972f43b536d",
            },
            "foliage_block_data_signature": "0xc00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000",
            "foliage_transaction_block_hash": "0xac6a47ca76efeac93b1c435dfa2e876ab63c0a62fa7aa5a6b8cf9efd95084025",
            "foliage_transaction_block_signature": "0xc00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000",
        },
        "foliage_transaction_block": {
            "prev_transaction_block_hash": "0x852ed117f46fa98af7a17fcb050c369245a30fcffc190177c3a316109d1609c7",
            "timestamp": 3871668531533889186,
            "filter_hash": "0xffab724c5df9b90c0842565225f5ed842da14f159373c05d63643405ccce84b3",
            "additions_root": "0x5f87a17fafb44afd0d6b5b67b77be38570b4bc0150388bd9c176d4ac5d4e693b",
            "removals_root": "0xdb967ce278f9bf4fdc77cb9fa82b5b2ce6876746eb5e61f4352a41e3abb63275",
            "transactions_info_hash": "0x7eebe3b21505f7c7cb5536e96ab893bfa4626a5cf9c79fadb5dae6913e0a7cb3",
        },
        "transactions_info": {
            "generator_root": "0x4cb791379aee03879628f69f16c0d3b78fd865c010c53c3b412dfa56e40f4d78",
            "generator_refs_root": "0x180c72ecd6e32986a354681fcf6924aa82c08cfb9df95667fa24442103cc2189",
            "aggregated_signature": "0xc00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000",
            "fees": 5840504611725889474,
            "cost": 7273736876528078474,
            "reward_claims_incorporated": [
                {
                    "parent_coin_info": "0xdde12b149d44bafd07390d2ad6ce774ab50d083ada3f0bc3c0adebe6a6a1a4ab",
                    "puzzle_hash": "0x503da231145145b114e85af933ed86a5834c08323743803ee31fca2b1c64ce15",
                    "amount": 8428133224333694484,
                }
            ],
        },
        "transactions_generator": "0xff01ffff33ffa0f8912302fb33b8188046662785704afc3dd945074e4b45499a7173946e044695ff8203e880ffff33ffa03eaa52e850322dbc281c6b922e9d8819c7b4120ee054c4aa79db50be516a2bcaff8207d08080",
        "transactions_generator_ref_list": [1862532955],
    }
}

new_signage_point_or_end_of_subslot_json: Dict[str, Any] = {
    "prev_challenge_hash": "0xf945510ccea927f832635e56bc20315c92943e108d2b458ac91a290a82e02997",
    "challenge_hash": "0x27a16b348971e5dfb258e7a01f0b300acbecf8339476afd144e8520f1981833b",
    "index_from_challenge": 102,
    "last_rc_infusion": "0xa619471c0ba0b8b8b92b7b2cb1241c2fbb2324c4f1a20a01eb7dcc0027393a56",
}

request_signage_point_or_end_of_subslot_json: Dict[str, Any] = {
    "challenge_hash": "0xedd45b516bf1dc3754c30a99e289639e05f967dc1b590df8a377652bee4f463c",
    "index_from_challenge": 217,
    "last_rc_infusion": "0xb574062b42a5b3d76ea141d3b89a4a1096f7797bafe625770047380448622420",
}

respond_signage_point_json: Dict[str, Any] = {
    "index_from_challenge": 111,
    "challenge_chain_vdf": {
        "challenge": "0x7cbd5905838c1dc2becd00298a5b3a6e42b6a306d574c8897cd721f84d429972",
        "number_of_iterations": 14708638287767651172,
        "output": {
            "data": "0x08000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        },
    },
    "challenge_chain_proof": {
        "witness_type": 197,
        "witness": "0x30303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030",
        "normalized_to_identity": False,
    },
    "reward_chain_vdf": {
        "challenge": "0x7cbd5905838c1dc2becd00298a5b3a6e42b6a306d574c8897cd721f84d429972",
        "number_of_iterations": 14708638287767651172,
        "output": {
            "data": "0x08000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        },
    },
    "reward_chain_proof": {
        "witness_type": 197,
        "witness": "0x30303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030",
        "normalized_to_identity": False,
    },
}

respond_end_of_subslot_json: Dict[str, Any] = {
    "end_of_slot_bundle": {
        "challenge_chain": {
            "challenge_chain_end_of_slot_vdf": {
                "challenge": "0x7cbd5905838c1dc2becd00298a5b3a6e42b6a306d574c8897cd721f84d429972",
                "number_of_iterations": 14708638287767651172,
                "output": {
                    "data": "0x08000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
                },
            },
            "infused_challenge_chain_sub_slot_hash": "0x42c10d66108589c11bb3811b37d214b6351b73e25bad6c956c0bf1c05a4d93fb",
            "subepoch_summary_hash": "0xcdb6d334b461a01c4d07c76dd71d5a9f3a2949807a3499eb484e4b91e6cea309",
            "new_sub_slot_iters": 42556034269004566,
            "new_difficulty": 16610212302933121129,
        },
        "infused_challenge_chain": {
            "infused_challenge_chain_end_of_slot_vdf": {
                "challenge": "0x7cbd5905838c1dc2becd00298a5b3a6e42b6a306d574c8897cd721f84d429972",
                "number_of_iterations": 14708638287767651172,
                "output": {
                    "data": "0x08000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
                },
            }
        },
        "reward_chain": {
            "end_of_slot_vdf": {
                "challenge": "0x7cbd5905838c1dc2becd00298a5b3a6e42b6a306d574c8897cd721f84d429972",
                "number_of_iterations": 14708638287767651172,
                "output": {
                    "data": "0x08000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
                },
            },
            "challenge_chain_sub_slot_hash": "0x893f282b27c4961f47d886577a8d7c136d1e738e6c5badd37c1994e68871cb70",
            "infused_challenge_chain_sub_slot_hash": "0x4be4cc2a1f15c5c69fb9becac0cbe0df5ea007a94f22bca79f88e14fc2a46def",
            "deficit": 52,
        },
        "proofs": {
            "challenge_chain_slot_proof": {
                "witness_type": 197,
                "witness": "0x30303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030",
                "normalized_to_identity": False,
            },
            "infused_challenge_chain_slot_proof": {
                "witness_type": 197,
                "witness": "0x30303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030",
                "normalized_to_identity": False,
            },
            "reward_chain_slot_proof": {
                "witness_type": 197,
                "witness": "0x30303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030",
                "normalized_to_identity": False,
            },
        },
    }
}

request_mempool_transaction_json: Dict[str, Any] = {
    "filter": "0x0000000000000000000000000000000000000000000000000000000000000000"
}

new_compact_vdf_json: Dict[str, Any] = {
    "height": 1333973478,
    "header_hash": "0xe2188779d4a8e8fdf9cbe3103878b4c3f5f25a999fa8d04551c4ae01046c634e",
    "field_vdf": 169,
    "vdf_info": {
        "challenge": "0x7cbd5905838c1dc2becd00298a5b3a6e42b6a306d574c8897cd721f84d429972",
        "number_of_iterations": 14708638287767651172,
        "output": {
            "data": "0x08000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        },
    },
}

request_compact_vdf_json: Dict[str, Any] = {
    "height": 3529778757,
    "header_hash": "0x1c02dfbf437c464cfd3f71d2da283c22bd04b2061e3c6b4bfd8b859092957d96",
    "field_vdf": 207,
    "vdf_info": {
        "challenge": "0x7cbd5905838c1dc2becd00298a5b3a6e42b6a306d574c8897cd721f84d429972",
        "number_of_iterations": 14708638287767651172,
        "output": {
            "data": "0x08000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        },
    },
}

respond_compact_vdf_json: Dict[str, Any] = {
    "height": 2759248594,
    "header_hash": "0x51f2e23ac76179d69bc9232420f47e2a332b8c2495c24ceef7f730feb53c9117",
    "field_vdf": 167,
    "vdf_info": {
        "challenge": "0x7cbd5905838c1dc2becd00298a5b3a6e42b6a306d574c8897cd721f84d429972",
        "number_of_iterations": 14708638287767651172,
        "output": {
            "data": "0x08000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        },
    },
    "vdf_proof": {
        "witness_type": 197,
        "witness": "0x30303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030",
        "normalized_to_identity": False,
    },
}

request_peers_json: Dict[str, Any] = {}

respond_peers_json: Dict[str, Any] = {"peer_list": [{"host": "127.0.0.1", "port": 43444, "timestamp": 10796}]}

request_puzzle_solution_json: Dict[str, Any] = {
    "coin_name": "0x6edddb46bd154f50566b49c95812e0f1131a0a7162630349fc8d1d696e463e47",
    "height": 3905474497,
}

puzzle_solution_response_json: Dict[str, Any] = {
    "coin_name": "0x45c4451fdeef92aa0706def2448adfaed8e4a1c0b08a6d303c57de661509c442",
    "height": 3776325015,
    "puzzle": "0xff01ffff33ffa0f8912302fb33b8188046662785704afc3dd945074e4b45499a7173946e044695ff8203e880ffff33ffa03eaa52e850322dbc281c6b922e9d8819c7b4120ee054c4aa79db50be516a2bcaff8207d08080",
    "solution": "0xff01ffff33ffa0f8912302fb33b8188046662785704afc3dd945074e4b45499a7173946e044695ff8203e880ffff33ffa03eaa52e850322dbc281c6b922e9d8819c7b4120ee054c4aa79db50be516a2bcaff8207d08080",
}

respond_puzzle_solution_json: Dict[str, Any] = {
    "response": {
        "coin_name": "0x45c4451fdeef92aa0706def2448adfaed8e4a1c0b08a6d303c57de661509c442",
        "height": 3776325015,
        "puzzle": "0xff01ffff33ffa0f8912302fb33b8188046662785704afc3dd945074e4b45499a7173946e044695ff8203e880ffff33ffa03eaa52e850322dbc281c6b922e9d8819c7b4120ee054c4aa79db50be516a2bcaff8207d08080",
        "solution": "0xff01ffff33ffa0f8912302fb33b8188046662785704afc3dd945074e4b45499a7173946e044695ff8203e880ffff33ffa03eaa52e850322dbc281c6b922e9d8819c7b4120ee054c4aa79db50be516a2bcaff8207d08080",
    }
}

reject_puzzle_solution_json: Dict[str, Any] = {
    "coin_name": "0x2f16254e8e7a0b3fbe7bc709d29c5e7d2daa23ce1a2964e3f77b9413055029dd",
    "height": 2039721496,
}

send_transaction_json: Dict[str, Any] = {
    "transaction": {
        "coin_spends": [
            {
                "coin": {
                    "parent_coin_info": "0xd56f435d3382cb9aa5f50f51816e4c54487c66402339901450f3c810f1d77098",
                    "puzzle_hash": "0x9944f63fcc251719b2f04c47ab976a167f96510736dc6fdfa8e037d740f4b5f3",
                    "amount": 6602327684212801382,
                },
                "puzzle_reveal": "0xff01ffff33ffa0f8912302fb33b8188046662785704afc3dd945074e4b45499a7173946e044695ff8203e880ffff33ffa03eaa52e850322dbc281c6b922e9d8819c7b4120ee054c4aa79db50be516a2bcaff8207d08080",
                "solution": "0xffff01ffff33ffa0f8912302fb33b8188046662785704afc3dd945074e4b45499a7173946e044695ff8203e880ffff33ffa03eaa52e850322dbc281c6b922e9d8819c7b4120ee054c4aa79db50be516a2bcaff8207d08080ff8080",
            }
        ],
        "aggregated_signature": "0xc00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000",
    }
}

transaction_ack_json: Dict[str, Any] = {
    "txid": "0xfc30d2df70f4ca0a138d5135d352611ddf268ea46c59cde48c29c43d9472532c",
    "status": 30,
    "error": "None",
}

new_peak_wallet_json: Dict[str, Any] = {
    "header_hash": "0xee50e45652cb6a60e3ab0031aa425a6019648fe5344ae860e6fc14af1aa3c2fa",
    "height": 1093428752,
    "weight": 207496292293729126634170184354599452208,
    "fork_point_with_previous_peak": 133681371,
}

request_block_header_json: Dict[str, Any] = {"height": 3562957314}

request_block_headers_json: Dict[str, Any] = {
    "start_height": 1234970524,
    "end_height": 234653234,
    "return_filter": False,
}

respond_header_block_json: Dict[str, Any] = {
    "header_block": {
        "finished_sub_slots": [
            {
                "challenge_chain": {
                    "challenge_chain_end_of_slot_vdf": {
                        "challenge": "0x7cbd5905838c1dc2becd00298a5b3a6e42b6a306d574c8897cd721f84d429972",
                        "number_of_iterations": 14708638287767651172,
                        "output": {
                            "data": "0x08000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
                        },
                    },
                    "infused_challenge_chain_sub_slot_hash": "0x42c10d66108589c11bb3811b37d214b6351b73e25bad6c956c0bf1c05a4d93fb",
                    "subepoch_summary_hash": "0xcdb6d334b461a01c4d07c76dd71d5a9f3a2949807a3499eb484e4b91e6cea309",
                    "new_sub_slot_iters": 42556034269004566,
                    "new_difficulty": 16610212302933121129,
                },
                "infused_challenge_chain": {
                    "infused_challenge_chain_end_of_slot_vdf": {
                        "challenge": "0x7cbd5905838c1dc2becd00298a5b3a6e42b6a306d574c8897cd721f84d429972",
                        "number_of_iterations": 14708638287767651172,
                        "output": {
                            "data": "0x08000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
                        },
                    }
                },
                "reward_chain": {
                    "end_of_slot_vdf": {
                        "challenge": "0x7cbd5905838c1dc2becd00298a5b3a6e42b6a306d574c8897cd721f84d429972",
                        "number_of_iterations": 14708638287767651172,
                        "output": {
                            "data": "0x08000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
                        },
                    },
                    "challenge_chain_sub_slot_hash": "0x893f282b27c4961f47d886577a8d7c136d1e738e6c5badd37c1994e68871cb70",
                    "infused_challenge_chain_sub_slot_hash": "0x4be4cc2a1f15c5c69fb9becac0cbe0df5ea007a94f22bca79f88e14fc2a46def",
                    "deficit": 52,
                },
                "proofs": {
                    "challenge_chain_slot_proof": {
                        "witness_type": 197,
                        "witness": "0x30303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030",
                        "normalized_to_identity": False,
                    },
                    "infused_challenge_chain_slot_proof": {
                        "witness_type": 197,
                        "witness": "0x30303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030",
                        "normalized_to_identity": False,
                    },
                    "reward_chain_slot_proof": {
                        "witness_type": 197,
                        "witness": "0x30303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030",
                        "normalized_to_identity": False,
                    },
                },
            }
        ],
        "reward_chain_block": {
            "weight": 187084448821891925757676377381787790114,
            "height": 301889038,
            "total_iters": 147405131564197136044258885592706844266,
            "signage_point_index": 9,
            "pos_ss_cc_challenge_hash": "0x50102505a28e3969db19c699a5e53af73c1cb3108e2ab9ce9d86d1f058b10457",
            "proof_of_space": {
                "challenge": "0x1fb331df88bc142e70c110e21620374118fb220ccc3ef621378197e850882ec9",
                "pool_public_key": "0xa04c6b5ac7dfb935f6feecfdd72348ccf1d4be4fe7e26acf271ea3b7d308da61e0a308f7a62495328a81f5147b66634c",
                "pool_contract_puzzle_hash": None,
                "plot_public_key": "0xb6449c2c68df97c19e884427e42ee7350982d4020571ead08732615ff39bd216bfd630b6460784982bec98b49fea79d0",
                "size": 204,
                "proof": "0xa67188ae0c02c49b0e821a9773033a3fbd338030c383080dbb8b1d63f07af427d8075e59d911f85ea562fd967823588f9a405a4464fdf5dc0866ee15bebd6b94cb147e28aa9cf96da930611486b779737ed721ea376b9939ba05357141223d75d21b21f310ec32d85ed3b98cf301494ea91b8501138481f3bfa1c384fd998b1fdd2855ac6f0c8554c520fb0bfa3663f238124035e14682bc11eaf7c372b6af4ed7f59a406810c71711906f8c91f94b1f",
            },
            "challenge_chain_sp_vdf": {
                "challenge": "0x7cbd5905838c1dc2becd00298a5b3a6e42b6a306d574c8897cd721f84d429972",
                "number_of_iterations": 14708638287767651172,
                "output": {
                    "data": "0x08000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
                },
            },
            "challenge_chain_sp_signature": "0xc00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000",
            "challenge_chain_ip_vdf": {
                "challenge": "0x7cbd5905838c1dc2becd00298a5b3a6e42b6a306d574c8897cd721f84d429972",
                "number_of_iterations": 14708638287767651172,
                "output": {
                    "data": "0x08000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
                },
            },
            "reward_chain_sp_vdf": {
                "challenge": "0x7cbd5905838c1dc2becd00298a5b3a6e42b6a306d574c8897cd721f84d429972",
                "number_of_iterations": 14708638287767651172,
                "output": {
                    "data": "0x08000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
                },
            },
            "reward_chain_sp_signature": "0xc00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000",
            "reward_chain_ip_vdf": {
                "challenge": "0x7cbd5905838c1dc2becd00298a5b3a6e42b6a306d574c8897cd721f84d429972",
                "number_of_iterations": 14708638287767651172,
                "output": {
                    "data": "0x08000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
                },
            },
            "infused_challenge_chain_ip_vdf": {
                "challenge": "0x7cbd5905838c1dc2becd00298a5b3a6e42b6a306d574c8897cd721f84d429972",
                "number_of_iterations": 14708638287767651172,
                "output": {
                    "data": "0x08000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
                },
            },
            "is_transaction_block": False,
        },
        "challenge_chain_sp_proof": {
            "witness_type": 197,
            "witness": "0x30303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030",
            "normalized_to_identity": False,
        },
        "challenge_chain_ip_proof": {
            "witness_type": 197,
            "witness": "0x30303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030",
            "normalized_to_identity": False,
        },
        "reward_chain_sp_proof": {
            "witness_type": 197,
            "witness": "0x30303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030",
            "normalized_to_identity": False,
        },
        "reward_chain_ip_proof": {
            "witness_type": 197,
            "witness": "0x30303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030",
            "normalized_to_identity": False,
        },
        "infused_challenge_chain_ip_proof": {
            "witness_type": 197,
            "witness": "0x30303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030",
            "normalized_to_identity": False,
        },
        "foliage": {
            "prev_block_hash": "0x312fd3fe7c9a21cd90ce40b567730ab087fa29436bf8568adacc605f52912fba",
            "reward_block_hash": "0xba37d30b755680e0b8873a1b7f0ae7636400999ca2b2d32ad0aebb0c24e258aa",
            "foliage_block_data": {
                "unfinished_reward_block_hash": "0x205be4e4efff5b8d99b3f5c8d0ad19072875b9bac1ec3edda1f0df5467e2e61a",
                "pool_target": {
                    "puzzle_hash": "0xd23da14695a188ae5708dd152263c4db883eb27edeb936178d4d988b8f3ce5fc",
                    "max_height": 421941852,
                },
                "pool_signature": "0xc00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000",
                "farmer_reward_puzzle_hash": "0x4e62d7ed145b394ce28533e4f0a7d70f339f9d4c49ee717e51e2d6480e5fcbcc",
                "extension_data": "0xd53254dcdcbfddb431c3ff89d1a785491663b51552e3847d29e36972f43b536d",
            },
            "foliage_block_data_signature": "0xc00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000",
            "foliage_transaction_block_hash": "0xac6a47ca76efeac93b1c435dfa2e876ab63c0a62fa7aa5a6b8cf9efd95084025",
            "foliage_transaction_block_signature": "0xc00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000",
        },
        "foliage_transaction_block": {
            "prev_transaction_block_hash": "0x852ed117f46fa98af7a17fcb050c369245a30fcffc190177c3a316109d1609c7",
            "timestamp": 3871668531533889186,
            "filter_hash": "0xffab724c5df9b90c0842565225f5ed842da14f159373c05d63643405ccce84b3",
            "additions_root": "0x5f87a17fafb44afd0d6b5b67b77be38570b4bc0150388bd9c176d4ac5d4e693b",
            "removals_root": "0xdb967ce278f9bf4fdc77cb9fa82b5b2ce6876746eb5e61f4352a41e3abb63275",
            "transactions_info_hash": "0x7eebe3b21505f7c7cb5536e96ab893bfa4626a5cf9c79fadb5dae6913e0a7cb3",
        },
        "transactions_filter": "0x0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000",
        "transactions_info": {
            "generator_root": "0x4cb791379aee03879628f69f16c0d3b78fd865c010c53c3b412dfa56e40f4d78",
            "generator_refs_root": "0x180c72ecd6e32986a354681fcf6924aa82c08cfb9df95667fa24442103cc2189",
            "aggregated_signature": "0xc00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000",
            "fees": 5840504611725889474,
            "cost": 7273736876528078474,
            "reward_claims_incorporated": [
                {
                    "parent_coin_info": "0xdde12b149d44bafd07390d2ad6ce774ab50d083ada3f0bc3c0adebe6a6a1a4ab",
                    "puzzle_hash": "0x503da231145145b114e85af933ed86a5834c08323743803ee31fca2b1c64ce15",
                    "amount": 8428133224333694484,
                }
            ],
        },
    }
}

respond_block_headers_json: Dict[str, Any] = {
    "start_height": 923662371,
    "end_height": 992357623,
    "header_blocks": [
        {
            "finished_sub_slots": [
                {
                    "challenge_chain": {
                        "challenge_chain_end_of_slot_vdf": {
                            "challenge": "0x7cbd5905838c1dc2becd00298a5b3a6e42b6a306d574c8897cd721f84d429972",
                            "number_of_iterations": 14708638287767651172,
                            "output": {
                                "data": "0x08000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
                            },
                        },
                        "infused_challenge_chain_sub_slot_hash": "0x42c10d66108589c11bb3811b37d214b6351b73e25bad6c956c0bf1c05a4d93fb",
                        "subepoch_summary_hash": "0xcdb6d334b461a01c4d07c76dd71d5a9f3a2949807a3499eb484e4b91e6cea309",
                        "new_sub_slot_iters": 42556034269004566,
                        "new_difficulty": 16610212302933121129,
                    },
                    "infused_challenge_chain": {
                        "infused_challenge_chain_end_of_slot_vdf": {
                            "challenge": "0x7cbd5905838c1dc2becd00298a5b3a6e42b6a306d574c8897cd721f84d429972",
                            "number_of_iterations": 14708638287767651172,
                            "output": {
                                "data": "0x08000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
                            },
                        }
                    },
                    "reward_chain": {
                        "end_of_slot_vdf": {
                            "challenge": "0x7cbd5905838c1dc2becd00298a5b3a6e42b6a306d574c8897cd721f84d429972",
                            "number_of_iterations": 14708638287767651172,
                            "output": {
                                "data": "0x08000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
                            },
                        },
                        "challenge_chain_sub_slot_hash": "0x893f282b27c4961f47d886577a8d7c136d1e738e6c5badd37c1994e68871cb70",
                        "infused_challenge_chain_sub_slot_hash": "0x4be4cc2a1f15c5c69fb9becac0cbe0df5ea007a94f22bca79f88e14fc2a46def",
                        "deficit": 52,
                    },
                    "proofs": {
                        "challenge_chain_slot_proof": {
                            "witness_type": 197,
                            "witness": "0x30303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030",
                            "normalized_to_identity": False,
                        },
                        "infused_challenge_chain_slot_proof": {
                            "witness_type": 197,
                            "witness": "0x30303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030",
                            "normalized_to_identity": False,
                        },
                        "reward_chain_slot_proof": {
                            "witness_type": 197,
                            "witness": "0x30303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030",
                            "normalized_to_identity": False,
                        },
                    },
                }
            ],
            "reward_chain_block": {
                "weight": 187084448821891925757676377381787790114,
                "height": 301889038,
                "total_iters": 147405131564197136044258885592706844266,
                "signage_point_index": 9,
                "pos_ss_cc_challenge_hash": "0x50102505a28e3969db19c699a5e53af73c1cb3108e2ab9ce9d86d1f058b10457",
                "proof_of_space": {
                    "challenge": "0x1fb331df88bc142e70c110e21620374118fb220ccc3ef621378197e850882ec9",
                    "pool_public_key": "0xa04c6b5ac7dfb935f6feecfdd72348ccf1d4be4fe7e26acf271ea3b7d308da61e0a308f7a62495328a81f5147b66634c",
                    "pool_contract_puzzle_hash": None,
                    "plot_public_key": "0xb6449c2c68df97c19e884427e42ee7350982d4020571ead08732615ff39bd216bfd630b6460784982bec98b49fea79d0",
                    "size": 204,
                    "proof": "0xa67188ae0c02c49b0e821a9773033a3fbd338030c383080dbb8b1d63f07af427d8075e59d911f85ea562fd967823588f9a405a4464fdf5dc0866ee15bebd6b94cb147e28aa9cf96da930611486b779737ed721ea376b9939ba05357141223d75d21b21f310ec32d85ed3b98cf301494ea91b8501138481f3bfa1c384fd998b1fdd2855ac6f0c8554c520fb0bfa3663f238124035e14682bc11eaf7c372b6af4ed7f59a406810c71711906f8c91f94b1f",
                },
                "challenge_chain_sp_vdf": {
                    "challenge": "0x7cbd5905838c1dc2becd00298a5b3a6e42b6a306d574c8897cd721f84d429972",
                    "number_of_iterations": 14708638287767651172,
                    "output": {
                        "data": "0x08000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
                    },
                },
                "challenge_chain_sp_signature": "0xc00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000",
                "challenge_chain_ip_vdf": {
                    "challenge": "0x7cbd5905838c1dc2becd00298a5b3a6e42b6a306d574c8897cd721f84d429972",
                    "number_of_iterations": 14708638287767651172,
                    "output": {
                        "data": "0x08000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
                    },
                },
                "reward_chain_sp_vdf": {
                    "challenge": "0x7cbd5905838c1dc2becd00298a5b3a6e42b6a306d574c8897cd721f84d429972",
                    "number_of_iterations": 14708638287767651172,
                    "output": {
                        "data": "0x08000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
                    },
                },
                "reward_chain_sp_signature": "0xc00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000",
                "reward_chain_ip_vdf": {
                    "challenge": "0x7cbd5905838c1dc2becd00298a5b3a6e42b6a306d574c8897cd721f84d429972",
                    "number_of_iterations": 14708638287767651172,
                    "output": {
                        "data": "0x08000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
                    },
                },
                "infused_challenge_chain_ip_vdf": {
                    "challenge": "0x7cbd5905838c1dc2becd00298a5b3a6e42b6a306d574c8897cd721f84d429972",
                    "number_of_iterations": 14708638287767651172,
                    "output": {
                        "data": "0x08000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
                    },
                },
                "is_transaction_block": False,
            },
            "challenge_chain_sp_proof": {
                "witness_type": 197,
                "witness": "0x30303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030",
                "normalized_to_identity": False,
            },
            "challenge_chain_ip_proof": {
                "witness_type": 197,
                "witness": "0x30303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030",
                "normalized_to_identity": False,
            },
            "reward_chain_sp_proof": {
                "witness_type": 197,
                "witness": "0x30303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030",
                "normalized_to_identity": False,
            },
            "reward_chain_ip_proof": {
                "witness_type": 197,
                "witness": "0x30303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030",
                "normalized_to_identity": False,
            },
            "infused_challenge_chain_ip_proof": {
                "witness_type": 197,
                "witness": "0x30303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030",
                "normalized_to_identity": False,
            },
            "foliage": {
                "prev_block_hash": "0x312fd3fe7c9a21cd90ce40b567730ab087fa29436bf8568adacc605f52912fba",
                "reward_block_hash": "0xba37d30b755680e0b8873a1b7f0ae7636400999ca2b2d32ad0aebb0c24e258aa",
                "foliage_block_data": {
                    "unfinished_reward_block_hash": "0x205be4e4efff5b8d99b3f5c8d0ad19072875b9bac1ec3edda1f0df5467e2e61a",
                    "pool_target": {
                        "puzzle_hash": "0xd23da14695a188ae5708dd152263c4db883eb27edeb936178d4d988b8f3ce5fc",
                        "max_height": 421941852,
                    },
                    "pool_signature": "0xc00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000",
                    "farmer_reward_puzzle_hash": "0x4e62d7ed145b394ce28533e4f0a7d70f339f9d4c49ee717e51e2d6480e5fcbcc",
                    "extension_data": "0xd53254dcdcbfddb431c3ff89d1a785491663b51552e3847d29e36972f43b536d",
                },
                "foliage_block_data_signature": "0xc00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000",
                "foliage_transaction_block_hash": "0xac6a47ca76efeac93b1c435dfa2e876ab63c0a62fa7aa5a6b8cf9efd95084025",
                "foliage_transaction_block_signature": "0xc00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000",
            },
            "foliage_transaction_block": {
                "prev_transaction_block_hash": "0x852ed117f46fa98af7a17fcb050c369245a30fcffc190177c3a316109d1609c7",
                "timestamp": 3871668531533889186,
                "filter_hash": "0xffab724c5df9b90c0842565225f5ed842da14f159373c05d63643405ccce84b3",
                "additions_root": "0x5f87a17fafb44afd0d6b5b67b77be38570b4bc0150388bd9c176d4ac5d4e693b",
                "removals_root": "0xdb967ce278f9bf4fdc77cb9fa82b5b2ce6876746eb5e61f4352a41e3abb63275",
                "transactions_info_hash": "0x7eebe3b21505f7c7cb5536e96ab893bfa4626a5cf9c79fadb5dae6913e0a7cb3",
            },
            "transactions_filter": "0x0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000",
            "transactions_info": {
                "generator_root": "0x4cb791379aee03879628f69f16c0d3b78fd865c010c53c3b412dfa56e40f4d78",
                "generator_refs_root": "0x180c72ecd6e32986a354681fcf6924aa82c08cfb9df95667fa24442103cc2189",
                "aggregated_signature": "0xc00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000",
                "fees": 5840504611725889474,
                "cost": 7273736876528078474,
                "reward_claims_incorporated": [
                    {
                        "parent_coin_info": "0xdde12b149d44bafd07390d2ad6ce774ab50d083ada3f0bc3c0adebe6a6a1a4ab",
                        "puzzle_hash": "0x503da231145145b114e85af933ed86a5834c08323743803ee31fca2b1c64ce15",
                        "amount": 8428133224333694484,
                    }
                ],
            },
        }
    ],
}

reject_header_request_json: Dict[str, Any] = {"height": 17867635}

request_removals_json: Dict[str, Any] = {
    "height": 3500751918,
    "header_hash": "0xb44bc0e0fce20331a57081107dfd30ef39fc436e6e6ce4f6f0ab8db4f981d114",
    "coin_names": ["0xab62cfb2abaf9e1a475b707c3d3de35d6ef4a298b31137802fd9ea47d48ff0d5"],
}

respond_removals_json: Dict[str, Any] = {
    "height": 461268095,
    "header_hash": "0xe2db23a6484b05d9ae1033efe8dcfcf5894fc600a6b93b03782fab8dd1cba8a4",
    "coins": [
        [
            "0xf800ab7a0d1598c473e31700b21a7cc590c1619f10e72a707d1c66f090e4e078",
            {
                "parent_coin_info": "0xd56f435d3382cb9aa5f50f51816e4c54487c66402339901450f3c810f1d77098",
                "puzzle_hash": "0x9944f63fcc251719b2f04c47ab976a167f96510736dc6fdfa8e037d740f4b5f3",
                "amount": 6602327684212801382,
            },
        ]
    ],
    "proofs": [["0x652c312e1dd9f32bf074e17ae8b658bf47711bd1a5e6c937adfb0c80b51fa49d", "0x61616161616161616161"]],
}

reject_removals_request_json: Dict[str, Any] = {
    "height": 3247661701,
    "header_hash": "0xd5eee2d2ad56663c1c1d1cbde69329862dcf29010683aa7a0da91712d6876caf",
}

request_additions_json: Dict[str, Any] = {
    "height": 2566479739,
    "header_hash": "0x17262e35437ddc95d43431d20657c096cff95f7ba93a39367f56f1f9df0f0277",
    "puzzle_hashes": ["0x6fc7b72bc37f462dc820d4b39c9e69e9e65b590ee1a6b0a06b5105d048c278d4"],
}

respond_additions_json: Dict[str, Any] = {
    "height": 1992350400,
    "header_hash": "0x449ba349ce403c1acfcd46108758e7ada3a455e7a82dbee90860ec73adb090c9",
    "coins": [
        [
            "0xed8daaf9233ed82e773ef4d1e89f2958fec0570137cf2c267ae22099ab43a9a4",
            [
                {
                    "parent_coin_info": "0xd56f435d3382cb9aa5f50f51816e4c54487c66402339901450f3c810f1d77098",
                    "puzzle_hash": "0x9944f63fcc251719b2f04c47ab976a167f96510736dc6fdfa8e037d740f4b5f3",
                    "amount": 6602327684212801382,
                },
                {
                    "parent_coin_info": "0xd56f435d3382cb9aa5f50f51816e4c54487c66402339901450f3c810f1d77098",
                    "puzzle_hash": "0x9944f63fcc251719b2f04c47ab976a167f96510736dc6fdfa8e037d740f4b5f3",
                    "amount": 6602327684212801382,
                },
            ],
        ]
    ],
    "proofs": [
        [
            "0x8bb1381ff8ee01944d6d6c7e2df4b2fc84343a0c6c0fb93e8ef6d75e5c8b3048",
            "0x61616161616161616161",
            "0x61616161616161616161",
        ]
    ],
}

reject_additions_json: Dict[str, Any] = {
    "height": 3457211200,
    "header_hash": "0x4eb659e6dd727bc22191795692aae576922e56ae309871c352eede0c9dd8bb12",
}

request_header_blocks_json: Dict[str, Any] = {"start_height": 2858301848, "end_height": 720941539}

reject_header_blocks_json: Dict[str, Any] = {"start_height": 876520264, "end_height": 2908717391}

respond_header_blocks_json: Dict[str, Any] = {
    "start_height": 4130100992,
    "end_height": 17664086,
    "header_blocks": [
        {
            "finished_sub_slots": [
                {
                    "challenge_chain": {
                        "challenge_chain_end_of_slot_vdf": {
                            "challenge": "0x7cbd5905838c1dc2becd00298a5b3a6e42b6a306d574c8897cd721f84d429972",
                            "number_of_iterations": 14708638287767651172,
                            "output": {
                                "data": "0x08000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
                            },
                        },
                        "infused_challenge_chain_sub_slot_hash": "0x42c10d66108589c11bb3811b37d214b6351b73e25bad6c956c0bf1c05a4d93fb",
                        "subepoch_summary_hash": "0xcdb6d334b461a01c4d07c76dd71d5a9f3a2949807a3499eb484e4b91e6cea309",
                        "new_sub_slot_iters": 42556034269004566,
                        "new_difficulty": 16610212302933121129,
                    },
                    "infused_challenge_chain": {
                        "infused_challenge_chain_end_of_slot_vdf": {
                            "challenge": "0x7cbd5905838c1dc2becd00298a5b3a6e42b6a306d574c8897cd721f84d429972",
                            "number_of_iterations": 14708638287767651172,
                            "output": {
                                "data": "0x08000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
                            },
                        }
                    },
                    "reward_chain": {
                        "end_of_slot_vdf": {
                            "challenge": "0x7cbd5905838c1dc2becd00298a5b3a6e42b6a306d574c8897cd721f84d429972",
                            "number_of_iterations": 14708638287767651172,
                            "output": {
                                "data": "0x08000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
                            },
                        },
                        "challenge_chain_sub_slot_hash": "0x893f282b27c4961f47d886577a8d7c136d1e738e6c5badd37c1994e68871cb70",
                        "infused_challenge_chain_sub_slot_hash": "0x4be4cc2a1f15c5c69fb9becac0cbe0df5ea007a94f22bca79f88e14fc2a46def",
                        "deficit": 52,
                    },
                    "proofs": {
                        "challenge_chain_slot_proof": {
                            "witness_type": 197,
                            "witness": "0x30303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030",
                            "normalized_to_identity": False,
                        },
                        "infused_challenge_chain_slot_proof": {
                            "witness_type": 197,
                            "witness": "0x30303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030",
                            "normalized_to_identity": False,
                        },
                        "reward_chain_slot_proof": {
                            "witness_type": 197,
                            "witness": "0x30303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030",
                            "normalized_to_identity": False,
                        },
                    },
                }
            ],
            "reward_chain_block": {
                "weight": 187084448821891925757676377381787790114,
                "height": 301889038,
                "total_iters": 147405131564197136044258885592706844266,
                "signage_point_index": 9,
                "pos_ss_cc_challenge_hash": "0x50102505a28e3969db19c699a5e53af73c1cb3108e2ab9ce9d86d1f058b10457",
                "proof_of_space": {
                    "challenge": "0x1fb331df88bc142e70c110e21620374118fb220ccc3ef621378197e850882ec9",
                    "pool_public_key": "0xa04c6b5ac7dfb935f6feecfdd72348ccf1d4be4fe7e26acf271ea3b7d308da61e0a308f7a62495328a81f5147b66634c",
                    "pool_contract_puzzle_hash": None,
                    "plot_public_key": "0xb6449c2c68df97c19e884427e42ee7350982d4020571ead08732615ff39bd216bfd630b6460784982bec98b49fea79d0",
                    "size": 204,
                    "proof": "0xa67188ae0c02c49b0e821a9773033a3fbd338030c383080dbb8b1d63f07af427d8075e59d911f85ea562fd967823588f9a405a4464fdf5dc0866ee15bebd6b94cb147e28aa9cf96da930611486b779737ed721ea376b9939ba05357141223d75d21b21f310ec32d85ed3b98cf301494ea91b8501138481f3bfa1c384fd998b1fdd2855ac6f0c8554c520fb0bfa3663f238124035e14682bc11eaf7c372b6af4ed7f59a406810c71711906f8c91f94b1f",
                },
                "challenge_chain_sp_vdf": {
                    "challenge": "0x7cbd5905838c1dc2becd00298a5b3a6e42b6a306d574c8897cd721f84d429972",
                    "number_of_iterations": 14708638287767651172,
                    "output": {
                        "data": "0x08000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
                    },
                },
                "challenge_chain_sp_signature": "0xc00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000",
                "challenge_chain_ip_vdf": {
                    "challenge": "0x7cbd5905838c1dc2becd00298a5b3a6e42b6a306d574c8897cd721f84d429972",
                    "number_of_iterations": 14708638287767651172,
                    "output": {
                        "data": "0x08000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
                    },
                },
                "reward_chain_sp_vdf": {
                    "challenge": "0x7cbd5905838c1dc2becd00298a5b3a6e42b6a306d574c8897cd721f84d429972",
                    "number_of_iterations": 14708638287767651172,
                    "output": {
                        "data": "0x08000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
                    },
                },
                "reward_chain_sp_signature": "0xc00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000",
                "reward_chain_ip_vdf": {
                    "challenge": "0x7cbd5905838c1dc2becd00298a5b3a6e42b6a306d574c8897cd721f84d429972",
                    "number_of_iterations": 14708638287767651172,
                    "output": {
                        "data": "0x08000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
                    },
                },
                "infused_challenge_chain_ip_vdf": {
                    "challenge": "0x7cbd5905838c1dc2becd00298a5b3a6e42b6a306d574c8897cd721f84d429972",
                    "number_of_iterations": 14708638287767651172,
                    "output": {
                        "data": "0x08000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
                    },
                },
                "is_transaction_block": False,
            },
            "challenge_chain_sp_proof": {
                "witness_type": 197,
                "witness": "0x30303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030",
                "normalized_to_identity": False,
            },
            "challenge_chain_ip_proof": {
                "witness_type": 197,
                "witness": "0x30303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030",
                "normalized_to_identity": False,
            },
            "reward_chain_sp_proof": {
                "witness_type": 197,
                "witness": "0x30303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030",
                "normalized_to_identity": False,
            },
            "reward_chain_ip_proof": {
                "witness_type": 197,
                "witness": "0x30303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030",
                "normalized_to_identity": False,
            },
            "infused_challenge_chain_ip_proof": {
                "witness_type": 197,
                "witness": "0x30303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030",
                "normalized_to_identity": False,
            },
            "foliage": {
                "prev_block_hash": "0x312fd3fe7c9a21cd90ce40b567730ab087fa29436bf8568adacc605f52912fba",
                "reward_block_hash": "0xba37d30b755680e0b8873a1b7f0ae7636400999ca2b2d32ad0aebb0c24e258aa",
                "foliage_block_data": {
                    "unfinished_reward_block_hash": "0x205be4e4efff5b8d99b3f5c8d0ad19072875b9bac1ec3edda1f0df5467e2e61a",
                    "pool_target": {
                        "puzzle_hash": "0xd23da14695a188ae5708dd152263c4db883eb27edeb936178d4d988b8f3ce5fc",
                        "max_height": 421941852,
                    },
                    "pool_signature": "0xc00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000",
                    "farmer_reward_puzzle_hash": "0x4e62d7ed145b394ce28533e4f0a7d70f339f9d4c49ee717e51e2d6480e5fcbcc",
                    "extension_data": "0xd53254dcdcbfddb431c3ff89d1a785491663b51552e3847d29e36972f43b536d",
                },
                "foliage_block_data_signature": "0xc00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000",
                "foliage_transaction_block_hash": "0xac6a47ca76efeac93b1c435dfa2e876ab63c0a62fa7aa5a6b8cf9efd95084025",
                "foliage_transaction_block_signature": "0xc00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000",
            },
            "foliage_transaction_block": {
                "prev_transaction_block_hash": "0x852ed117f46fa98af7a17fcb050c369245a30fcffc190177c3a316109d1609c7",
                "timestamp": 3871668531533889186,
                "filter_hash": "0xffab724c5df9b90c0842565225f5ed842da14f159373c05d63643405ccce84b3",
                "additions_root": "0x5f87a17fafb44afd0d6b5b67b77be38570b4bc0150388bd9c176d4ac5d4e693b",
                "removals_root": "0xdb967ce278f9bf4fdc77cb9fa82b5b2ce6876746eb5e61f4352a41e3abb63275",
                "transactions_info_hash": "0x7eebe3b21505f7c7cb5536e96ab893bfa4626a5cf9c79fadb5dae6913e0a7cb3",
            },
            "transactions_filter": "0x0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000",
            "transactions_info": {
                "generator_root": "0x4cb791379aee03879628f69f16c0d3b78fd865c010c53c3b412dfa56e40f4d78",
                "generator_refs_root": "0x180c72ecd6e32986a354681fcf6924aa82c08cfb9df95667fa24442103cc2189",
                "aggregated_signature": "0xc00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000",
                "fees": 5840504611725889474,
                "cost": 7273736876528078474,
                "reward_claims_incorporated": [
                    {
                        "parent_coin_info": "0xdde12b149d44bafd07390d2ad6ce774ab50d083ada3f0bc3c0adebe6a6a1a4ab",
                        "puzzle_hash": "0x503da231145145b114e85af933ed86a5834c08323743803ee31fca2b1c64ce15",
                        "amount": 8428133224333694484,
                    }
                ],
            },
        }
    ],
}

coin_state_json: Dict[str, Any] = {
    "coin": {
        "parent_coin_info": "0xd56f435d3382cb9aa5f50f51816e4c54487c66402339901450f3c810f1d77098",
        "puzzle_hash": "0x9944f63fcc251719b2f04c47ab976a167f96510736dc6fdfa8e037d740f4b5f3",
        "amount": 6602327684212801382,
    },
    "spent_height": 2287030048,
    "created_height": 3361305811,
}

register_for_ph_updates_json: Dict[str, Any] = {
    "puzzle_hashes": ["0xdf24b7dc1d5ffa12f112e198cd26385b5ab302b5c2e5f9d589e5cd3f7b900510"],
    "min_height": 874269130,
}

reject_block_headers_json: Dict[str, Any] = {"start_height": 543373229, "end_height": 2347869036}

respond_to_ph_updates_json: Dict[str, Any] = {
    "puzzle_hashes": ["0x1be3bdc54b84901554e4e843966cfa3be3380054c968bebc41cc6be4aa65322f"],
    "min_height": 3664709982,
    "coin_states": [
        {
            "coin": {
                "parent_coin_info": "0xd56f435d3382cb9aa5f50f51816e4c54487c66402339901450f3c810f1d77098",
                "puzzle_hash": "0x9944f63fcc251719b2f04c47ab976a167f96510736dc6fdfa8e037d740f4b5f3",
                "amount": 6602327684212801382,
            },
            "spent_height": 2287030048,
            "created_height": 3361305811,
        }
    ],
}

register_for_coin_updates_json: Dict[str, Any] = {
    "coin_ids": ["0x1d7748531ece395e8bb8468b112d4ccdd1cea027359abd03c0b015edf666eec8"],
    "min_height": 3566185528,
}

respond_to_coin_updates_json: Dict[str, Any] = {
    "coin_ids": ["0xdb8bad6bd9de34d4884380176135f31a655dca18e9a5fadfb567145b81b6a9e0"],
    "min_height": 3818814774,
    "coin_states": [
        {
            "coin": {
                "parent_coin_info": "0xd56f435d3382cb9aa5f50f51816e4c54487c66402339901450f3c810f1d77098",
                "puzzle_hash": "0x9944f63fcc251719b2f04c47ab976a167f96510736dc6fdfa8e037d740f4b5f3",
                "amount": 6602327684212801382,
            },
            "spent_height": 2287030048,
            "created_height": 3361305811,
        }
    ],
}

coin_state_update_json: Dict[str, Any] = {
    "height": 855344561,
    "fork_height": 1659753011,
    "peak_hash": "0x8512cc80a2976c81186e8963bc7af9d6d5732ccae5227fffee823f0bf3081e76",
    "items": [
        {
            "coin": {
                "parent_coin_info": "0xd56f435d3382cb9aa5f50f51816e4c54487c66402339901450f3c810f1d77098",
                "puzzle_hash": "0x9944f63fcc251719b2f04c47ab976a167f96510736dc6fdfa8e037d740f4b5f3",
                "amount": 6602327684212801382,
            },
            "spent_height": 2287030048,
            "created_height": 3361305811,
        }
    ],
}

request_children_json: Dict[str, Any] = {
    "coin_name": "0x15beeed2e6dd0cf1b81a3f68a49845c020912218e4c1f002a1b3f43333495478"
}

respond_children_json: Dict[str, Any] = {
    "coin_states": [
        {
            "coin": {
                "parent_coin_info": "0xd56f435d3382cb9aa5f50f51816e4c54487c66402339901450f3c810f1d77098",
                "puzzle_hash": "0x9944f63fcc251719b2f04c47ab976a167f96510736dc6fdfa8e037d740f4b5f3",
                "amount": 6602327684212801382,
            },
            "spent_height": 2287030048,
            "created_height": 3361305811,
        }
    ]
}

request_ses_info_json: Dict[str, Any] = {"start_height": 2704205398, "end_height": 2050258406}

respond_ses_info_json: Dict[str, Any] = {
    "reward_chain_hash": ["0xb61cb91773995e99cb8259609c0985f915a5734a1706aeab9342a2d1c5abf71b"],
    "heights": [[1, 2, 3], [4, 606340525]],
}

pool_difficulty_json: Dict[str, Any] = {
    "difficulty": 14819251421858580996,
    "sub_slot_iters": 12852879676624401630,
    "pool_contract_puzzle_hash": "0xc9423123ea65e6923e973b95531b4874570dae942cb757a2daec4a6971753886",
}

harvester_handhsake_json: Dict[str, Any] = {
    "farmer_public_keys": [
        "0xa04c6b5ac7dfb935f6feecfdd72348ccf1d4be4fe7e26acf271ea3b7d308da61e0a308f7a62495328a81f5147b66634c"
    ],
    "pool_public_keys": [
        "0xa04c6b5ac7dfb935f6feecfdd72348ccf1d4be4fe7e26acf271ea3b7d308da61e0a308f7a62495328a81f5147b66634c"
    ],
}

new_signage_point_harvester_json: Dict[str, Any] = {
    "challenge_hash": "0xe342c21b4aeaa52349d42492be934692db58494ca9bce4a8697d06fdf8e583bb",
    "difficulty": 15615706268399948682,
    "sub_slot_iters": 10520767421667792980,
    "signage_point_index": 148,
    "sp_hash": "0xb78c9fca155e9742df835cbe84bb7e518bee70d78b6be6e39996c0a02e0cfe4c",
    "pool_difficulties": [
        {
            "difficulty": 14819251421858580996,
            "sub_slot_iters": 12852879676624401630,
            "pool_contract_puzzle_hash": "0xc9423123ea65e6923e973b95531b4874570dae942cb757a2daec4a6971753886",
        }
    ],
}

new_proof_of_space_json: Dict[str, Any] = {
    "challenge_hash": "0x1b64ec6bf3fe33bb80eca5b64ff1c88be07771eaed1e98a7199510522087e56e",
    "sp_hash": "0xad1f8a74376ce8c5c93b7fbb355c2fb6d689ae4f4a7134166593d95265a3da30",
    "plot_identifier": "plot_1",
    "proof": {
        "challenge": "0x1fb331df88bc142e70c110e21620374118fb220ccc3ef621378197e850882ec9",
        "pool_public_key": "0xa04c6b5ac7dfb935f6feecfdd72348ccf1d4be4fe7e26acf271ea3b7d308da61e0a308f7a62495328a81f5147b66634c",
        "pool_contract_puzzle_hash": None,
        "plot_public_key": "0xb6449c2c68df97c19e884427e42ee7350982d4020571ead08732615ff39bd216bfd630b6460784982bec98b49fea79d0",
        "size": 204,
        "proof": "0xa67188ae0c02c49b0e821a9773033a3fbd338030c383080dbb8b1d63f07af427d8075e59d911f85ea562fd967823588f9a405a4464fdf5dc0866ee15bebd6b94cb147e28aa9cf96da930611486b779737ed721ea376b9939ba05357141223d75d21b21f310ec32d85ed3b98cf301494ea91b8501138481f3bfa1c384fd998b1fdd2855ac6f0c8554c520fb0bfa3663f238124035e14682bc11eaf7c372b6af4ed7f59a406810c71711906f8c91f94b1f",
    },
    "signage_point_index": 160,
}

request_signatures_json: Dict[str, Any] = {
    "plot_identifier": "plot_1",
    "challenge_hash": "0xb5fa873020fa8b959d89bc2ffc5797501bf870ac8b30437cd6b4fcdea0812789",
    "sp_hash": "0xbccb7744192771f3a7abca2bce6ea03ed53f1f0d991c13bd2711ce32a2fb3777",
    "messages": ["0x3fc12545f50a9f0621371688f60b29eff05805dd51b42c90063f5e3c6698fc75"],
}

respond_signatures_json: Dict[str, Any] = {
    "plot_identifier": "plot_1",
    "challenge_hash": "0x59468dce63b5b08490ec4eec4c461fc84b69b6f80a64f4c76b0d55780f7e7e7a",
    "sp_hash": "0x270b5fc00545db714077aba3b60245d769f492563f108a73b2b8502503d12b9e",
    "local_pk": "0xa04c6b5ac7dfb935f6feecfdd72348ccf1d4be4fe7e26acf271ea3b7d308da61e0a308f7a62495328a81f5147b66634c",
    "farmer_pk": "0xa04c6b5ac7dfb935f6feecfdd72348ccf1d4be4fe7e26acf271ea3b7d308da61e0a308f7a62495328a81f5147b66634c",
    "message_signatures": [
        [
            "0xc32fd5310f5e8623697561930dca73cb9da5b3ddb903f52818724bb3bdd9349c",
            "0xc00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000",
        ]
    ],
}

plot_json: Dict[str, Any] = {
    "filename": "plot_1",
    "size": 124,
    "plot_id": "0xb2eb7e5c5239e8610a9dd0e137e185966ebb430faf31ae4a0e55d86251065b98",
    "pool_public_key": "0xa04c6b5ac7dfb935f6feecfdd72348ccf1d4be4fe7e26acf271ea3b7d308da61e0a308f7a62495328a81f5147b66634c",
    "pool_contract_puzzle_hash": "0x1c96d26def7be696f12e7ebb91d50211e6217ce5d9087c9cd1b84782d5d4b237",
    "plot_public_key": "0xa04c6b5ac7dfb935f6feecfdd72348ccf1d4be4fe7e26acf271ea3b7d308da61e0a308f7a62495328a81f5147b66634c",
    "file_size": 3368414292564311420,
    "time_modified": 2573238947935295522,
}

request_plots_json: Dict[str, Any] = {}

respond_plots_json: Dict[str, Any] = {
    "plots": [
        {
            "filename": "plot_1",
            "size": 124,
            "plot_id": "0xb2eb7e5c5239e8610a9dd0e137e185966ebb430faf31ae4a0e55d86251065b98",
            "pool_public_key": "0xa04c6b5ac7dfb935f6feecfdd72348ccf1d4be4fe7e26acf271ea3b7d308da61e0a308f7a62495328a81f5147b66634c",
            "pool_contract_puzzle_hash": "0x1c96d26def7be696f12e7ebb91d50211e6217ce5d9087c9cd1b84782d5d4b237",
            "plot_public_key": "0xa04c6b5ac7dfb935f6feecfdd72348ccf1d4be4fe7e26acf271ea3b7d308da61e0a308f7a62495328a81f5147b66634c",
            "file_size": 3368414292564311420,
            "time_modified": 2573238947935295522,
        }
    ],
    "failed_to_open_filenames": ["str"],
    "no_key_filenames": ["str"],
}

request_peers_introducer_json: Dict[str, Any] = {}

respond_peers_introducer_json: Dict[str, Any] = {
    "peer_list": [{"host": "127.0.0.1", "port": 49878, "timestamp": 15079028934557257795}]
}

authentication_payload_json: Dict[str, Any] = {
    "method_name": "method",
    "launcher_id": "0x0251e3b3a1aacc689091b6b085be7a8d319bd9d1a015faae969cb76d8a45607c",
    "target_puzzle_hash": "0x9de241b508b5e9e2073b7645291cfaa9458d33935340399a861acf2ee1770440",
    "authentication_token": 4676522834655707230,
}

get_pool_info_response_json: Dict[str, Any] = {
    "name": "pool_name",
    "logo_url": "pool_name",
    "minimum_difficulty": 7020711482626732214,
    "relative_lock_height": 3407308703,
    "protocol_version": 129,
    "fee": "fee",
    "description": "pool description.",
    "target_puzzle_hash": "0xf6b5120ff1ab7ba661e3b2c91c8b373a8aceea8e4eb6ce3f085f3e80a8655b36",
    "authentication_token_timeout": 76,
}

post_partial_payload_json: Dict[str, Any] = {
    "launcher_id": "0xdada61e179e67e5e8bc7aaab16e192facf0f15871f0c479d2a96ac5f85721a1a",
    "authentication_token": 2491521039628830788,
    "proof_of_space": {
        "challenge": "0x1fb331df88bc142e70c110e21620374118fb220ccc3ef621378197e850882ec9",
        "pool_public_key": "0xa04c6b5ac7dfb935f6feecfdd72348ccf1d4be4fe7e26acf271ea3b7d308da61e0a308f7a62495328a81f5147b66634c",
        "pool_contract_puzzle_hash": None,
        "plot_public_key": "0xb6449c2c68df97c19e884427e42ee7350982d4020571ead08732615ff39bd216bfd630b6460784982bec98b49fea79d0",
        "size": 204,
        "proof": "0xa67188ae0c02c49b0e821a9773033a3fbd338030c383080dbb8b1d63f07af427d8075e59d911f85ea562fd967823588f9a405a4464fdf5dc0866ee15bebd6b94cb147e28aa9cf96da930611486b779737ed721ea376b9939ba05357141223d75d21b21f310ec32d85ed3b98cf301494ea91b8501138481f3bfa1c384fd998b1fdd2855ac6f0c8554c520fb0bfa3663f238124035e14682bc11eaf7c372b6af4ed7f59a406810c71711906f8c91f94b1f",
    },
    "sp_hash": "0x929287fab514e2204808821e2afe8c4d84f0093c75554b067fe4fca272890c9d",
    "end_of_sub_slot": False,
    "harvester_id": "0xf98dff6bdcc3926b33cb8ab22e11bd15c13d6a9b6832ac948b3273f5ccd8e7ec",
}

post_partial_request_json: Dict[str, Any] = {
    "payload": {
        "launcher_id": "0xdada61e179e67e5e8bc7aaab16e192facf0f15871f0c479d2a96ac5f85721a1a",
        "authentication_token": 2491521039628830788,
        "proof_of_space": {
            "challenge": "0x1fb331df88bc142e70c110e21620374118fb220ccc3ef621378197e850882ec9",
            "pool_public_key": "0xa04c6b5ac7dfb935f6feecfdd72348ccf1d4be4fe7e26acf271ea3b7d308da61e0a308f7a62495328a81f5147b66634c",
            "pool_contract_puzzle_hash": None,
            "plot_public_key": "0xb6449c2c68df97c19e884427e42ee7350982d4020571ead08732615ff39bd216bfd630b6460784982bec98b49fea79d0",
            "size": 204,
            "proof": "0xa67188ae0c02c49b0e821a9773033a3fbd338030c383080dbb8b1d63f07af427d8075e59d911f85ea562fd967823588f9a405a4464fdf5dc0866ee15bebd6b94cb147e28aa9cf96da930611486b779737ed721ea376b9939ba05357141223d75d21b21f310ec32d85ed3b98cf301494ea91b8501138481f3bfa1c384fd998b1fdd2855ac6f0c8554c520fb0bfa3663f238124035e14682bc11eaf7c372b6af4ed7f59a406810c71711906f8c91f94b1f",
        },
        "sp_hash": "0x929287fab514e2204808821e2afe8c4d84f0093c75554b067fe4fca272890c9d",
        "end_of_sub_slot": False,
        "harvester_id": "0xf98dff6bdcc3926b33cb8ab22e11bd15c13d6a9b6832ac948b3273f5ccd8e7ec",
    },
    "aggregate_signature": "0xc00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000",
}

post_partial_response_json: Dict[str, Any] = {"new_difficulty": 5956480724816802941}

get_farmer_response_json: Dict[str, Any] = {
    "authentication_public_key": "0xa04c6b5ac7dfb935f6feecfdd72348ccf1d4be4fe7e26acf271ea3b7d308da61e0a308f7a62495328a81f5147b66634c",
    "payout_instructions": "instructions",
    "current_difficulty": 8362834206591090467,
    "current_points": 14310455844127802841,
}

post_farmer_payload_json: Dict[str, Any] = {
    "launcher_id": "0xd3785b251b4e066f87784d06afc8e6ac8dac5a4922d994902c1bad60b5fa7ad3",
    "authentication_token": 5820795488800541986,
    "authentication_public_key": "0xa04c6b5ac7dfb935f6feecfdd72348ccf1d4be4fe7e26acf271ea3b7d308da61e0a308f7a62495328a81f5147b66634c",
    "payout_instructions": "payout_instructions",
    "suggested_difficulty": 1996244065095983466,
}

post_farmer_request_json: Dict[str, Any] = {
    "payload": {
        "launcher_id": "0xd3785b251b4e066f87784d06afc8e6ac8dac5a4922d994902c1bad60b5fa7ad3",
        "authentication_token": 5820795488800541986,
        "authentication_public_key": "0xa04c6b5ac7dfb935f6feecfdd72348ccf1d4be4fe7e26acf271ea3b7d308da61e0a308f7a62495328a81f5147b66634c",
        "payout_instructions": "payout_instructions",
        "suggested_difficulty": 1996244065095983466,
    },
    "signature": "0xc00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000",
}

post_farmer_response_json: Dict[str, Any] = {"welcome_message": "welcome"}

put_farmer_payload_json: Dict[str, Any] = {
    "launcher_id": "0x78aec4d523b0bea49829a1322d5de92a86a553ce8774690b8c8ad5fc1f7540a8",
    "authentication_token": 15049374353843709257,
    "authentication_public_key": "0xa04c6b5ac7dfb935f6feecfdd72348ccf1d4be4fe7e26acf271ea3b7d308da61e0a308f7a62495328a81f5147b66634c",
    "payout_instructions": "payload",
    "suggested_difficulty": 201241879360854600,
}

put_farmer_request_json: Dict[str, Any] = {
    "payload": {
        "launcher_id": "0x78aec4d523b0bea49829a1322d5de92a86a553ce8774690b8c8ad5fc1f7540a8",
        "authentication_token": 15049374353843709257,
        "authentication_public_key": "0xa04c6b5ac7dfb935f6feecfdd72348ccf1d4be4fe7e26acf271ea3b7d308da61e0a308f7a62495328a81f5147b66634c",
        "payout_instructions": "payload",
        "suggested_difficulty": 201241879360854600,
    },
    "signature": "0xc00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000",
}

put_farmer_response_json: Dict[str, Any] = {
    "authentication_public_key": False,
    "payout_instructions": False,
    "suggested_difficulty": True,
}

error_response_json: Dict[str, Any] = {"error_code": 47018, "error_message": "err"}

new_peak_timelord_json: Dict[str, Any] = {
    "reward_chain_block": {
        "weight": 187084448821891925757676377381787790114,
        "height": 301889038,
        "total_iters": 147405131564197136044258885592706844266,
        "signage_point_index": 9,
        "pos_ss_cc_challenge_hash": "0x50102505a28e3969db19c699a5e53af73c1cb3108e2ab9ce9d86d1f058b10457",
        "proof_of_space": {
            "challenge": "0x1fb331df88bc142e70c110e21620374118fb220ccc3ef621378197e850882ec9",
            "pool_public_key": "0xa04c6b5ac7dfb935f6feecfdd72348ccf1d4be4fe7e26acf271ea3b7d308da61e0a308f7a62495328a81f5147b66634c",
            "pool_contract_puzzle_hash": None,
            "plot_public_key": "0xb6449c2c68df97c19e884427e42ee7350982d4020571ead08732615ff39bd216bfd630b6460784982bec98b49fea79d0",
            "size": 204,
            "proof": "0xa67188ae0c02c49b0e821a9773033a3fbd338030c383080dbb8b1d63f07af427d8075e59d911f85ea562fd967823588f9a405a4464fdf5dc0866ee15bebd6b94cb147e28aa9cf96da930611486b779737ed721ea376b9939ba05357141223d75d21b21f310ec32d85ed3b98cf301494ea91b8501138481f3bfa1c384fd998b1fdd2855ac6f0c8554c520fb0bfa3663f238124035e14682bc11eaf7c372b6af4ed7f59a406810c71711906f8c91f94b1f",
        },
        "challenge_chain_sp_vdf": {
            "challenge": "0x7cbd5905838c1dc2becd00298a5b3a6e42b6a306d574c8897cd721f84d429972",
            "number_of_iterations": 14708638287767651172,
            "output": {
                "data": "0x08000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
            },
        },
        "challenge_chain_sp_signature": "0xc00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000",
        "challenge_chain_ip_vdf": {
            "challenge": "0x7cbd5905838c1dc2becd00298a5b3a6e42b6a306d574c8897cd721f84d429972",
            "number_of_iterations": 14708638287767651172,
            "output": {
                "data": "0x08000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
            },
        },
        "reward_chain_sp_vdf": {
            "challenge": "0x7cbd5905838c1dc2becd00298a5b3a6e42b6a306d574c8897cd721f84d429972",
            "number_of_iterations": 14708638287767651172,
            "output": {
                "data": "0x08000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
            },
        },
        "reward_chain_sp_signature": "0xc00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000",
        "reward_chain_ip_vdf": {
            "challenge": "0x7cbd5905838c1dc2becd00298a5b3a6e42b6a306d574c8897cd721f84d429972",
            "number_of_iterations": 14708638287767651172,
            "output": {
                "data": "0x08000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
            },
        },
        "infused_challenge_chain_ip_vdf": {
            "challenge": "0x7cbd5905838c1dc2becd00298a5b3a6e42b6a306d574c8897cd721f84d429972",
            "number_of_iterations": 14708638287767651172,
            "output": {
                "data": "0x08000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
            },
        },
        "is_transaction_block": False,
    },
    "difficulty": 7661623532867338566,
    "deficit": 202,
    "sub_slot_iters": 16623089924886538940,
    "sub_epoch_summary": {
        "prev_subepoch_summary_hash": "0x2d0550de416467e7b57e56e962c712b79bee29cae29c73cc908da5978fc9789e",
        "reward_chain_hash": "0x3d29f5a3fe067ce7edea76c9cebaf3a3afdebc0eb9fbd530f807f1a28ed2df6d",
        "num_blocks_overflow": 4,
        "new_difficulty": 14666749803532899046,
        "new_sub_slot_iters": 10901191956946573440,
    },
    "previous_reward_challenges": [
        ["0x5bb65d8662d561ed2fc17e4177ba61c43017ee7e5418091d38968e36ce380d11", 134240022887890669757150210097251845335]
    ],
    "last_challenge_sb_or_eos_total_iters": 42058411995615810488183751196800190575,
    "passes_ses_height_but_not_yet_included": True,
}

new_unfinished_block_timelord_json: Dict[str, Any] = {
    "reward_chain_block": {
        "total_iters": 147405131564197136044258885592706844266,
        "signage_point_index": 9,
        "pos_ss_cc_challenge_hash": "0x50102505a28e3969db19c699a5e53af73c1cb3108e2ab9ce9d86d1f058b10457",
        "proof_of_space": {
            "challenge": "0x1fb331df88bc142e70c110e21620374118fb220ccc3ef621378197e850882ec9",
            "pool_public_key": "0xa04c6b5ac7dfb935f6feecfdd72348ccf1d4be4fe7e26acf271ea3b7d308da61e0a308f7a62495328a81f5147b66634c",
            "pool_contract_puzzle_hash": None,
            "plot_public_key": "0xb6449c2c68df97c19e884427e42ee7350982d4020571ead08732615ff39bd216bfd630b6460784982bec98b49fea79d0",
            "size": 204,
            "proof": "0xa67188ae0c02c49b0e821a9773033a3fbd338030c383080dbb8b1d63f07af427d8075e59d911f85ea562fd967823588f9a405a4464fdf5dc0866ee15bebd6b94cb147e28aa9cf96da930611486b779737ed721ea376b9939ba05357141223d75d21b21f310ec32d85ed3b98cf301494ea91b8501138481f3bfa1c384fd998b1fdd2855ac6f0c8554c520fb0bfa3663f238124035e14682bc11eaf7c372b6af4ed7f59a406810c71711906f8c91f94b1f",
        },
        "challenge_chain_sp_vdf": {
            "challenge": "0x7cbd5905838c1dc2becd00298a5b3a6e42b6a306d574c8897cd721f84d429972",
            "number_of_iterations": 14708638287767651172,
            "output": {
                "data": "0x08000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
            },
        },
        "challenge_chain_sp_signature": "0xc00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000",
        "reward_chain_sp_vdf": {
            "challenge": "0x7cbd5905838c1dc2becd00298a5b3a6e42b6a306d574c8897cd721f84d429972",
            "number_of_iterations": 14708638287767651172,
            "output": {
                "data": "0x08000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
            },
        },
        "reward_chain_sp_signature": "0xc00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000",
    },
    "difficulty": 601152037470280666,
    "sub_slot_iters": 14270340639924562415,
    "foliage": {
        "prev_block_hash": "0x312fd3fe7c9a21cd90ce40b567730ab087fa29436bf8568adacc605f52912fba",
        "reward_block_hash": "0xba37d30b755680e0b8873a1b7f0ae7636400999ca2b2d32ad0aebb0c24e258aa",
        "foliage_block_data": {
            "unfinished_reward_block_hash": "0x205be4e4efff5b8d99b3f5c8d0ad19072875b9bac1ec3edda1f0df5467e2e61a",
            "pool_target": {
                "puzzle_hash": "0xd23da14695a188ae5708dd152263c4db883eb27edeb936178d4d988b8f3ce5fc",
                "max_height": 421941852,
            },
            "pool_signature": "0xc00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000",
            "farmer_reward_puzzle_hash": "0x4e62d7ed145b394ce28533e4f0a7d70f339f9d4c49ee717e51e2d6480e5fcbcc",
            "extension_data": "0xd53254dcdcbfddb431c3ff89d1a785491663b51552e3847d29e36972f43b536d",
        },
        "foliage_block_data_signature": "0xc00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000",
        "foliage_transaction_block_hash": "0xac6a47ca76efeac93b1c435dfa2e876ab63c0a62fa7aa5a6b8cf9efd95084025",
        "foliage_transaction_block_signature": "0xc00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000",
    },
    "sub_epoch_summary": {
        "prev_subepoch_summary_hash": "0x2d0550de416467e7b57e56e962c712b79bee29cae29c73cc908da5978fc9789e",
        "reward_chain_hash": "0x3d29f5a3fe067ce7edea76c9cebaf3a3afdebc0eb9fbd530f807f1a28ed2df6d",
        "num_blocks_overflow": 4,
        "new_difficulty": 14666749803532899046,
        "new_sub_slot_iters": 10901191956946573440,
    },
    "rc_prev": "0x0f90296b605904a794e4e98852e3b22e0d9bee2fa07abb12df6cecbdb778e1e5",
}

new_infusion_point_vdf_json: Dict[str, Any] = {
    "unfinished_reward_hash": "0x3d3b977d3a3dab50f0cd72b74b2f08f5018fb5ef826a8773161b7a499dafa60f",
    "challenge_chain_ip_vdf": {
        "challenge": "0x7cbd5905838c1dc2becd00298a5b3a6e42b6a306d574c8897cd721f84d429972",
        "number_of_iterations": 14708638287767651172,
        "output": {
            "data": "0x08000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        },
    },
    "challenge_chain_ip_proof": {
        "witness_type": 197,
        "witness": "0x30303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030",
        "normalized_to_identity": False,
    },
    "reward_chain_ip_vdf": {
        "challenge": "0x7cbd5905838c1dc2becd00298a5b3a6e42b6a306d574c8897cd721f84d429972",
        "number_of_iterations": 14708638287767651172,
        "output": {
            "data": "0x08000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        },
    },
    "reward_chain_ip_proof": {
        "witness_type": 197,
        "witness": "0x30303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030",
        "normalized_to_identity": False,
    },
    "infused_challenge_chain_ip_vdf": {
        "challenge": "0x7cbd5905838c1dc2becd00298a5b3a6e42b6a306d574c8897cd721f84d429972",
        "number_of_iterations": 14708638287767651172,
        "output": {
            "data": "0x08000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        },
    },
    "infused_challenge_chain_ip_proof": {
        "witness_type": 197,
        "witness": "0x30303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030",
        "normalized_to_identity": False,
    },
}

new_signage_point_vdf_json: Dict[str, Any] = {
    "index_from_challenge": 182,
    "challenge_chain_sp_vdf": {
        "challenge": "0x7cbd5905838c1dc2becd00298a5b3a6e42b6a306d574c8897cd721f84d429972",
        "number_of_iterations": 14708638287767651172,
        "output": {
            "data": "0x08000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        },
    },
    "challenge_chain_sp_proof": {
        "witness_type": 197,
        "witness": "0x30303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030",
        "normalized_to_identity": False,
    },
    "reward_chain_sp_vdf": {
        "challenge": "0x7cbd5905838c1dc2becd00298a5b3a6e42b6a306d574c8897cd721f84d429972",
        "number_of_iterations": 14708638287767651172,
        "output": {
            "data": "0x08000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        },
    },
    "reward_chain_sp_proof": {
        "witness_type": 197,
        "witness": "0x30303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030",
        "normalized_to_identity": False,
    },
}

new_end_of_sub_slot_bundle_json: Dict[str, Any] = {
    "end_of_sub_slot_bundle": {
        "challenge_chain": {
            "challenge_chain_end_of_slot_vdf": {
                "challenge": "0x7cbd5905838c1dc2becd00298a5b3a6e42b6a306d574c8897cd721f84d429972",
                "number_of_iterations": 14708638287767651172,
                "output": {
                    "data": "0x08000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
                },
            },
            "infused_challenge_chain_sub_slot_hash": "0x42c10d66108589c11bb3811b37d214b6351b73e25bad6c956c0bf1c05a4d93fb",
            "subepoch_summary_hash": "0xcdb6d334b461a01c4d07c76dd71d5a9f3a2949807a3499eb484e4b91e6cea309",
            "new_sub_slot_iters": 42556034269004566,
            "new_difficulty": 16610212302933121129,
        },
        "infused_challenge_chain": {
            "infused_challenge_chain_end_of_slot_vdf": {
                "challenge": "0x7cbd5905838c1dc2becd00298a5b3a6e42b6a306d574c8897cd721f84d429972",
                "number_of_iterations": 14708638287767651172,
                "output": {
                    "data": "0x08000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
                },
            }
        },
        "reward_chain": {
            "end_of_slot_vdf": {
                "challenge": "0x7cbd5905838c1dc2becd00298a5b3a6e42b6a306d574c8897cd721f84d429972",
                "number_of_iterations": 14708638287767651172,
                "output": {
                    "data": "0x08000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
                },
            },
            "challenge_chain_sub_slot_hash": "0x893f282b27c4961f47d886577a8d7c136d1e738e6c5badd37c1994e68871cb70",
            "infused_challenge_chain_sub_slot_hash": "0x4be4cc2a1f15c5c69fb9becac0cbe0df5ea007a94f22bca79f88e14fc2a46def",
            "deficit": 52,
        },
        "proofs": {
            "challenge_chain_slot_proof": {
                "witness_type": 197,
                "witness": "0x30303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030",
                "normalized_to_identity": False,
            },
            "infused_challenge_chain_slot_proof": {
                "witness_type": 197,
                "witness": "0x30303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030",
                "normalized_to_identity": False,
            },
            "reward_chain_slot_proof": {
                "witness_type": 197,
                "witness": "0x30303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030",
                "normalized_to_identity": False,
            },
        },
    }
}

request_compact_proof_of_time_json: Dict[str, Any] = {
    "new_proof_of_time": {
        "challenge": "0x7cbd5905838c1dc2becd00298a5b3a6e42b6a306d574c8897cd721f84d429972",
        "number_of_iterations": 14708638287767651172,
        "output": {
            "data": "0x08000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        },
    },
    "header_hash": "0xad71f7e66dc12c4fd7dca7d0c7b4e1825dfd55b93dd590111d2c44bc4f4d66de",
    "height": 4134186845,
    "field_vdf": 237,
}

respond_compact_proof_of_time_json: Dict[str, Any] = {
    "vdf_info": {
        "challenge": "0x7cbd5905838c1dc2becd00298a5b3a6e42b6a306d574c8897cd721f84d429972",
        "number_of_iterations": 14708638287767651172,
        "output": {
            "data": "0x08000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"
        },
    },
    "vdf_proof": {
        "witness_type": 197,
        "witness": "0x30303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030",
        "normalized_to_identity": False,
    },
    "header_hash": "0x071bef40d098cfadc2614d8b57db924788f7f2ea0fde8cf4bfaeae2894caa442",
    "height": 386395693,
    "field_vdf": 224,
}
