# Copyright (C) 2023 - 2025 ANSYS, Inc. and/or its affiliates.

# SPDX-License-Identifier: MIT
#
#
# Permission is hereby granted, free of charge, to any person obtaining a copy
# of this software and associated documentation files (the "Software"), to deal
# in the Software without restriction, including without limitation the rights
# to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
# copies of the Software, and to permit persons to whom the Software is
# furnished to do so, subject to the following conditions:
#
# The above copyright notice and this permission notice shall be included in all
# copies or substantial portions of the Software.
#
# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
# IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
# FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
# AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
# LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
# OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
# SOFTWARE.
# This file is @generated

from ansys.units import Unit

__all__ = (
    "kg",
    "g",
    "lb",
    "lbm",
    "slug",
    "m",
    "cm",
    "ft",
    "inch",
    "in_",
    "s",
    "A",
    "mol",
    "slugmol",
    "cd",
    "sr",
    "radian",
    "degree",
    "K",
    "C",
    "F",
    "R",
    "delta_K",
    "delta_C",
    "delta_F",
    "delta_R",
    "N",
    "Pa",
    "W",
    "J",
    "V",
    "farad",
    "H",
    "S",
    "Wb",
    "T",
    "dyne",
    "erg",
    "h",
    "pdl",
    "psi",
    "lbf",
    "psf",
    "ohm",
    "Hz",
    "l",
    "gal",
    "BTU",
    "cal",
    "coulomb",
)

kg = Unit("kg")  #: A predefined unit for a kg
g = Unit("g")  #: A predefined unit for a g
lb = Unit("lb")  #: A predefined unit for a lb
lbm = Unit("lbm")  #: A predefined unit for a lbm
slug = Unit("slug")  #: A predefined unit for a slug
m = Unit("m")  #: A predefined unit for a m
cm = Unit("cm")  #: A predefined unit for a cm
ft = Unit("ft")  #: A predefined unit for a ft
inch = Unit("inch")  #: A predefined unit for a inch
in_ = Unit("in")  #: A predefined unit for a in
s = Unit("s")  #: A predefined unit for a s
A = Unit("A")  #: A predefined unit for a A
mol = Unit("mol")  #: A predefined unit for a mol
slugmol = Unit("slugmol")  #: A predefined unit for a slugmol
cd = Unit("cd")  #: A predefined unit for a cd
sr = Unit("sr")  #: A predefined unit for a sr
radian = Unit("radian")  #: A predefined unit for a radian
degree = Unit("degree")  #: A predefined unit for a degree
K = Unit("K")  #: A predefined unit for a K
C = Unit("C")  #: A predefined unit for a C
F = Unit("F")  #: A predefined unit for a F
R = Unit("R")  #: A predefined unit for a R
delta_K = Unit("delta_K")  #: A predefined unit for a delta_K
delta_C = Unit("delta_C")  #: A predefined unit for a delta_C
delta_F = Unit("delta_F")  #: A predefined unit for a delta_F
delta_R = Unit("delta_R")  #: A predefined unit for a delta_R
N = Unit("N")  #: A predefined unit for a N
Pa = Unit("Pa")  #: A predefined unit for a Pa
W = Unit("W")  #: A predefined unit for a W
J = Unit("J")  #: A predefined unit for a J
V = Unit("V")  #: A predefined unit for a V
farad = Unit("farad")  #: A predefined unit for a farad
H = Unit("H")  #: A predefined unit for a H
S = Unit("S")  #: A predefined unit for a S
Wb = Unit("Wb")  #: A predefined unit for a Wb
T = Unit("T")  #: A predefined unit for a T
dyne = Unit("dyne")  #: A predefined unit for a dyne
erg = Unit("erg")  #: A predefined unit for a erg
h = Unit("h")  #: A predefined unit for a h
pdl = Unit("pdl")  #: A predefined unit for a pdl
psi = Unit("psi")  #: A predefined unit for a psi
lbf = Unit("lbf")  #: A predefined unit for a lbf
psf = Unit("psf")  #: A predefined unit for a psf
ohm = Unit("ohm")  #: A predefined unit for a ohm
Hz = Unit("Hz")  #: A predefined unit for a Hz
l = Unit("l")  #: A predefined unit for a l
gal = Unit("gal")  #: A predefined unit for a gal
BTU = Unit("BTU")  #: A predefined unit for a BTU
cal = Unit("cal")  #: A predefined unit for a cal
coulomb = Unit("coulomb")  #: A predefined unit for a coulomb
