# Copyright (C) 2023 - 2025 ANSYS, Inc. and/or its affiliates.
# SPDX-License-Identifier: MIT
#
#
# Permission is hereby granted, free of charge, to any person obtaining a copy
# of this software and associated documentation files (the "Software"), to deal
# in the Software without restriction, including without limitation the rights
# to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
# copies of the Software, and to permit persons to whom the Software is
# furnished to do so, subject to the following conditions:
#
# The above copyright notice and this permission notice shall be included in all
# copies or substantial portions of the Software.
#
# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
# IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
# FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
# AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
# LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
# OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
# SOFTWARE.
"""Pyunits is a pythonic interface for units, unit systems, and unit conversions."""

import importlib.metadata

try:
    __version__ = importlib.metadata.version(__name__.replace(".", "-"))
except importlib.metadata.PackageNotFoundError:
    __version__ = "script-running"  # should never hit this unless you're running the generation scripts

import os

from ansys.units.base_dimensions import BaseDimensions
from ansys.units.dimensions import Dimensions
from ansys.units.quantity import Quantity, get_si_value
from ansys.units.quantity_dimensions import QuantityDimensions
from ansys.units.systems import UnitSystem
from ansys.units.unit import Unit
from ansys.units.unit_registry import UnitRegistry
from ansys.units.variable_descriptor import (
    ConversionStrategy,
    MappingConversionStrategy,
    VariableCatalog,
    VariableDescriptor,
)

_THIS_DIRNAME = os.path.dirname(__file__)
_README_FILE = os.path.normpath(os.path.join(_THIS_DIRNAME, "docs", "README.rst"))

if os.path.exists(_README_FILE):
    with open(_README_FILE, encoding="utf8") as f:
        __doc__ = f.read()


__all__ = [
    "BaseDimensions",
    "Dimensions",
    "Quantity",
    "get_si_value",
    "UnitSystem",
    "Unit",
    "UnitRegistry",
    "QuantityDimensions",
    "VariableDescriptor",
    "VariableCatalog",
    "ConversionStrategy",
    "MappingConversionStrategy",
]
