"""
Django settings for dl project.

Generated by 'django-admin startproject' using Django 4.1.7.

For more information on this file, see
https://docs.djangoproject.com/en/4.1/topics/settings/

For the full list of settings and their values, see
https://docs.djangoproject.com/en/4.1/ref/settings/
"""

from pathlib import Path

from django.utils.translation import gettext_lazy as _

# Build paths inside the project like this: BASE_DIR / 'subdir'.
BASE_DIR = Path(__file__).resolve().parent.parent

# Quick-start development settings - unsuitable for production
# See https://docs.djangoproject.com/en/4.1/howto/deployment/checklist/

# SECURITY WARNING: keep the secret key used in production secret!
SECRET_KEY = 'django-insecure-cx951zq36+&*^2xe_-7^nk_*7p8o$bdg93oa7*4@vj)u6w75)h'

# SECURITY WARNING: don't run with debug turned on in production!
DEBUG = True

ALLOWED_HOSTS = []

# Application definition

INSTALLED_APPS = [
    'dynamic_listing',
    'blog',
    'base_template',

    'django.contrib.auth',
    'django.contrib.contenttypes',
    'django.contrib.sessions',
    'django.contrib.messages',
    'django.contrib.staticfiles',
]

MIDDLEWARE = [
    'django.middleware.security.SecurityMiddleware',
    'django.contrib.sessions.middleware.SessionMiddleware',
    'django.middleware.common.CommonMiddleware',
    'django.middleware.csrf.CsrfViewMiddleware',
    'django.contrib.auth.middleware.AuthenticationMiddleware',
    'django.contrib.messages.middleware.MessageMiddleware',
    'django.middleware.clickjacking.XFrameOptionsMiddleware',
]

ROOT_URLCONF = 'dl.urls'

TEMPLATES = [
    {
        'BACKEND': 'django.template.backends.django.DjangoTemplates',
        'DIRS': [
            BASE_DIR / 'templates',
        ],
        'APP_DIRS': True,
        'OPTIONS': {
            'context_processors': [
                'django.template.context_processors.debug',
                'django.template.context_processors.request',
                'django.contrib.auth.context_processors.auth',
                'django.contrib.messages.context_processors.messages',
                'base_template.context_processors.base_template'
            ],
        },
    },
]

WSGI_APPLICATION = 'dl.wsgi.application'

# Database
# https://docs.djangoproject.com/en/4.1/ref/settings/#databases

DATABASES = {
    'default': {
        'ENGINE': 'django.db.backends.sqlite3',
        'NAME': BASE_DIR / 'db.sqlite3',
    }
}

# Password validation
# https://docs.djangoproject.com/en/4.1/ref/settings/#auth-password-validators

AUTH_PASSWORD_VALIDATORS = [
    {
        'NAME': 'django.contrib.auth.password_validation.UserAttributeSimilarityValidator',
    },
    {
        'NAME': 'django.contrib.auth.password_validation.MinimumLengthValidator',
    },
    {
        'NAME': 'django.contrib.auth.password_validation.CommonPasswordValidator',
    },
    {
        'NAME': 'django.contrib.auth.password_validation.NumericPasswordValidator',
    },
]

# Internationalization
# https://docs.djangoproject.com/en/4.1/topics/i18n/

LANGUAGE_CODE = 'en'

TIME_ZONE = 'UTC'

USE_I18N = True

USE_TZ = True

LANGUAGE_ENGLISH = "en"
LANGUAGE_ARABIC = "ar"
LANGUAGES = (
    (LANGUAGE_ENGLISH, _("English")),
    (LANGUAGE_ARABIC, _("Arabic"))
)

# Static files (CSS, JavaScript, Images)
# https://docs.djangoproject.com/en/4.1/howto/static-files/

STATIC_URL = 'static/'

# Default primary key field type
# https://docs.djangoproject.com/en/4.1/ref/settings/#default-auto-field

DEFAULT_AUTO_FIELD = 'django.db.models.BigAutoField'

BASE_TEMPLATE_MULTIPLE_LANGUAGES = True

BASE_TEMPLATE_APP_NAME = _("Base Template")

# Sidebar
BASE_TEMPLATE_GET_SIDEBAR_METHOD = 'dl.sidebars.get_sidebar'
BASE_TEMPLATE_GET_ASSETS_METHOD = 'base_template.utils.get_assets'
BASE_TEMPLATE_SIDEBAR_FOOTER_TEMPLATE = "base_template/layout/partials/sidebar/_footer.html"
BASE_TEMPLATE_SIDEBAR_LOGO = "base_template/images/logo-white.svg"
BASE_TEMPLATE_SIDEBAR_LOGO_ICON = "base_template/images/icon.svg"

# header
BASE_TEMPLATE_HEADER_LOGO = "base_template/images/logo-dark.svg"
BASE_TEMPLATE_HEADER_LEFT_MENUS = [
    {"order": 0, "template_name": "base_template/partials/menus/_sample_right_menu.html"}
]
BASE_TEMPLATE_HEADER_RIGHT_MENUS = [
    {"order": 0, "template_name": "base_template/partials/theme-mode/_main.html"},
    {"order": 1, "template_name": "base_template/partials/menus/_user-account-menu.html"},
]

# toolbar
BASE_TEMPLATE_TOOLBAR_FIXED = False

# right drawers
BASE_TEMPLATE_RIGHT_DRAWERS = []

# footer
BASE_TEMPLATE_LINKS_TEMPLATE = 'base_template/layout/partials/footer/__footer_links.html'
BASE_TEMPLATE_COPYRIGHTS = {"text": _("Fritill"), "url": "https://fritill.com"}
