/**
 * Utility class for reading values from the payload of an Attini deployment plan.
 * Each method can only be used as the value of a key/value pair in an Attini or
 * StepFunction step.
 *
 * @example
 * Valid example:
 *
 * {my-key: AttiniPayload.environment()}
 *
 * Invalid examples:
 *
 * {my-key: 'test'+ AttiniPayload.environment()}
 * {my-key: '[step.AttiniPayload.environment()]}
 *
 *
 */
export declare abstract class AttiniPayload {
    static readonly ENVIRONMENT_PATH: string;
    static readonly DISTRIBUTION_NAME_PATH: string;
    static readonly DISTRIBUTION_VERSION: string;
    static readonly STACK_PARAMETERS_PATH: string;
    static environment(): string;
    static distributionName(): string;
    static stackParameter(parameterName: string): string;
    static version(): string;
}
