import copy
import os
import pickle
import random
import sys
from abc import ABC, abstractmethod
from datetime import datetime, timedelta
from typing import Any, List, Optional, Sequence, Text, Tuple, Union, overload

import pygame
import pygame_menu
from pygame.locals import *
from xpinyin import Pinyin

from primaryschool.dirs import *
from primaryschool.locale import _, sys_lang_code
from primaryschool.resource import (
    default_font,
    default_font_path,
    get_default_font,
    get_font_path,
)
from primaryschool.subjects import *


class GameBase(ABC):
    @abstractmethod
    def __init__(self):
        ...

    @abstractmethod
    def save(self):
        ...

    @abstractmethod
    def load(self):
        ...

    @abstractmethod
    def play(self):
        ...
