# coding: utf-8

"""
    DocuSign REST API

    The DocuSign REST API provides you with a powerful, convenient, and simple Web services API for interacting with DocuSign.

    OpenAPI spec version: v2
    Contact: devcenter@docusign.com
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from pprint import pformat
from six import iteritems
import re


class UserSignatureDefinition(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self, signature_font=None, signature_id=None, signature_initials=None, signature_name=None):
        """
        UserSignatureDefinition - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'signature_font': 'str',
            'signature_id': 'str',
            'signature_initials': 'str',
            'signature_name': 'str'
        }

        self.attribute_map = {
            'signature_font': 'signatureFont',
            'signature_id': 'signatureId',
            'signature_initials': 'signatureInitials',
            'signature_name': 'signatureName'
        }

        self._signature_font = signature_font
        self._signature_id = signature_id
        self._signature_initials = signature_initials
        self._signature_name = signature_name

    @property
    def signature_font(self):
        """
        Gets the signature_font of this UserSignatureDefinition.
        

        :return: The signature_font of this UserSignatureDefinition.
        :rtype: str
        """
        return self._signature_font

    @signature_font.setter
    def signature_font(self, signature_font):
        """
        Sets the signature_font of this UserSignatureDefinition.
        

        :param signature_font: The signature_font of this UserSignatureDefinition.
        :type: str
        """

        self._signature_font = signature_font

    @property
    def signature_id(self):
        """
        Gets the signature_id of this UserSignatureDefinition.
        Specifies the signature ID associated with the signature name. You can use the signature ID in the URI in place of the signature name, and the value stored in the `signatureName` property in the body is used. This allows the use of special characters (such as \"&\", \"<\", \">\") in a the signature name. Note that with each update to signatures, the returned signature ID might change, so the caller will need to trigger off the signature name to get the new signature ID.

        :return: The signature_id of this UserSignatureDefinition.
        :rtype: str
        """
        return self._signature_id

    @signature_id.setter
    def signature_id(self, signature_id):
        """
        Sets the signature_id of this UserSignatureDefinition.
        Specifies the signature ID associated with the signature name. You can use the signature ID in the URI in place of the signature name, and the value stored in the `signatureName` property in the body is used. This allows the use of special characters (such as \"&\", \"<\", \">\") in a the signature name. Note that with each update to signatures, the returned signature ID might change, so the caller will need to trigger off the signature name to get the new signature ID.

        :param signature_id: The signature_id of this UserSignatureDefinition.
        :type: str
        """

        self._signature_id = signature_id

    @property
    def signature_initials(self):
        """
        Gets the signature_initials of this UserSignatureDefinition.
        

        :return: The signature_initials of this UserSignatureDefinition.
        :rtype: str
        """
        return self._signature_initials

    @signature_initials.setter
    def signature_initials(self, signature_initials):
        """
        Sets the signature_initials of this UserSignatureDefinition.
        

        :param signature_initials: The signature_initials of this UserSignatureDefinition.
        :type: str
        """

        self._signature_initials = signature_initials

    @property
    def signature_name(self):
        """
        Gets the signature_name of this UserSignatureDefinition.
        Specifies the user signature name.

        :return: The signature_name of this UserSignatureDefinition.
        :rtype: str
        """
        return self._signature_name

    @signature_name.setter
    def signature_name(self, signature_name):
        """
        Sets the signature_name of this UserSignatureDefinition.
        Specifies the user signature name.

        :param signature_name: The signature_name of this UserSignatureDefinition.
        :type: str
        """

        self._signature_name = signature_name

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other
