# coding: utf-8

"""
    DocuSign REST API

    The DocuSign REST API provides you with a powerful, convenient, and simple Web services API for interacting with DocuSign.

    OpenAPI spec version: v2
    Contact: devcenter@docusign.com
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from pprint import pformat
from six import iteritems
import re


class ReferralInformation(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self, advertisement_id=None, enable_support=None, external_org_id=None, group_member_id=None, id_type=None, included_seats=None, industry=None, plan_start_month=None, promo_code=None, publisher_id=None, referral_code=None, referrer_name=None, sale_discount_amount=None, sale_discount_fixed_amount=None, sale_discount_percent=None, sale_discount_periods=None, sale_discount_seat_price_override=None, shopper_id=None):
        """
        ReferralInformation - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'advertisement_id': 'str',
            'enable_support': 'str',
            'external_org_id': 'str',
            'group_member_id': 'str',
            'id_type': 'str',
            'included_seats': 'str',
            'industry': 'str',
            'plan_start_month': 'str',
            'promo_code': 'str',
            'publisher_id': 'str',
            'referral_code': 'str',
            'referrer_name': 'str',
            'sale_discount_amount': 'str',
            'sale_discount_fixed_amount': 'str',
            'sale_discount_percent': 'str',
            'sale_discount_periods': 'str',
            'sale_discount_seat_price_override': 'str',
            'shopper_id': 'str'
        }

        self.attribute_map = {
            'advertisement_id': 'advertisementId',
            'enable_support': 'enableSupport',
            'external_org_id': 'externalOrgId',
            'group_member_id': 'groupMemberId',
            'id_type': 'idType',
            'included_seats': 'includedSeats',
            'industry': 'industry',
            'plan_start_month': 'planStartMonth',
            'promo_code': 'promoCode',
            'publisher_id': 'publisherId',
            'referral_code': 'referralCode',
            'referrer_name': 'referrerName',
            'sale_discount_amount': 'saleDiscountAmount',
            'sale_discount_fixed_amount': 'saleDiscountFixedAmount',
            'sale_discount_percent': 'saleDiscountPercent',
            'sale_discount_periods': 'saleDiscountPeriods',
            'sale_discount_seat_price_override': 'saleDiscountSeatPriceOverride',
            'shopper_id': 'shopperId'
        }

        self._advertisement_id = advertisement_id
        self._enable_support = enable_support
        self._external_org_id = external_org_id
        self._group_member_id = group_member_id
        self._id_type = id_type
        self._included_seats = included_seats
        self._industry = industry
        self._plan_start_month = plan_start_month
        self._promo_code = promo_code
        self._publisher_id = publisher_id
        self._referral_code = referral_code
        self._referrer_name = referrer_name
        self._sale_discount_amount = sale_discount_amount
        self._sale_discount_fixed_amount = sale_discount_fixed_amount
        self._sale_discount_percent = sale_discount_percent
        self._sale_discount_periods = sale_discount_periods
        self._sale_discount_seat_price_override = sale_discount_seat_price_override
        self._shopper_id = shopper_id

    @property
    def advertisement_id(self):
        """
        Gets the advertisement_id of this ReferralInformation.
        A complex type that contains the following information for entering referral and discount information. The following items are included in the referral information (all string content): enableSupport, includedSeats, saleDiscountPercent, saleDiscountAmount, saleDiscountFixedAmount, saleDiscountPeriods, saleDiscountSeatPriceOverride, planStartMonth, referralCode, referrerName, advertisementId, publisherId, shopperId, promoCode, groupMemberId, idType, and industry.  ###### Note: saleDiscountPercent, saleDiscountAmount, saleDiscountFixedAmount, saleDiscountPeriods, and saleDiscountSeatPriceOverride are reserved for DoucSign use only.  

        :return: The advertisement_id of this ReferralInformation.
        :rtype: str
        """
        return self._advertisement_id

    @advertisement_id.setter
    def advertisement_id(self, advertisement_id):
        """
        Sets the advertisement_id of this ReferralInformation.
        A complex type that contains the following information for entering referral and discount information. The following items are included in the referral information (all string content): enableSupport, includedSeats, saleDiscountPercent, saleDiscountAmount, saleDiscountFixedAmount, saleDiscountPeriods, saleDiscountSeatPriceOverride, planStartMonth, referralCode, referrerName, advertisementId, publisherId, shopperId, promoCode, groupMemberId, idType, and industry.  ###### Note: saleDiscountPercent, saleDiscountAmount, saleDiscountFixedAmount, saleDiscountPeriods, and saleDiscountSeatPriceOverride are reserved for DoucSign use only.  

        :param advertisement_id: The advertisement_id of this ReferralInformation.
        :type: str
        """

        self._advertisement_id = advertisement_id

    @property
    def enable_support(self):
        """
        Gets the enable_support of this ReferralInformation.
        When set to **true**, then customer support is provided as part of the account plan.

        :return: The enable_support of this ReferralInformation.
        :rtype: str
        """
        return self._enable_support

    @enable_support.setter
    def enable_support(self, enable_support):
        """
        Sets the enable_support of this ReferralInformation.
        When set to **true**, then customer support is provided as part of the account plan.

        :param enable_support: The enable_support of this ReferralInformation.
        :type: str
        """

        self._enable_support = enable_support

    @property
    def external_org_id(self):
        """
        Gets the external_org_id of this ReferralInformation.
        

        :return: The external_org_id of this ReferralInformation.
        :rtype: str
        """
        return self._external_org_id

    @external_org_id.setter
    def external_org_id(self, external_org_id):
        """
        Sets the external_org_id of this ReferralInformation.
        

        :param external_org_id: The external_org_id of this ReferralInformation.
        :type: str
        """

        self._external_org_id = external_org_id

    @property
    def group_member_id(self):
        """
        Gets the group_member_id of this ReferralInformation.
        

        :return: The group_member_id of this ReferralInformation.
        :rtype: str
        """
        return self._group_member_id

    @group_member_id.setter
    def group_member_id(self, group_member_id):
        """
        Sets the group_member_id of this ReferralInformation.
        

        :param group_member_id: The group_member_id of this ReferralInformation.
        :type: str
        """

        self._group_member_id = group_member_id

    @property
    def id_type(self):
        """
        Gets the id_type of this ReferralInformation.
        

        :return: The id_type of this ReferralInformation.
        :rtype: str
        """
        return self._id_type

    @id_type.setter
    def id_type(self, id_type):
        """
        Sets the id_type of this ReferralInformation.
        

        :param id_type: The id_type of this ReferralInformation.
        :type: str
        """

        self._id_type = id_type

    @property
    def included_seats(self):
        """
        Gets the included_seats of this ReferralInformation.
        The number of seats (users) included.

        :return: The included_seats of this ReferralInformation.
        :rtype: str
        """
        return self._included_seats

    @included_seats.setter
    def included_seats(self, included_seats):
        """
        Sets the included_seats of this ReferralInformation.
        The number of seats (users) included.

        :param included_seats: The included_seats of this ReferralInformation.
        :type: str
        """

        self._included_seats = included_seats

    @property
    def industry(self):
        """
        Gets the industry of this ReferralInformation.
        

        :return: The industry of this ReferralInformation.
        :rtype: str
        """
        return self._industry

    @industry.setter
    def industry(self, industry):
        """
        Sets the industry of this ReferralInformation.
        

        :param industry: The industry of this ReferralInformation.
        :type: str
        """

        self._industry = industry

    @property
    def plan_start_month(self):
        """
        Gets the plan_start_month of this ReferralInformation.
        

        :return: The plan_start_month of this ReferralInformation.
        :rtype: str
        """
        return self._plan_start_month

    @plan_start_month.setter
    def plan_start_month(self, plan_start_month):
        """
        Sets the plan_start_month of this ReferralInformation.
        

        :param plan_start_month: The plan_start_month of this ReferralInformation.
        :type: str
        """

        self._plan_start_month = plan_start_month

    @property
    def promo_code(self):
        """
        Gets the promo_code of this ReferralInformation.
        

        :return: The promo_code of this ReferralInformation.
        :rtype: str
        """
        return self._promo_code

    @promo_code.setter
    def promo_code(self, promo_code):
        """
        Sets the promo_code of this ReferralInformation.
        

        :param promo_code: The promo_code of this ReferralInformation.
        :type: str
        """

        self._promo_code = promo_code

    @property
    def publisher_id(self):
        """
        Gets the publisher_id of this ReferralInformation.
        

        :return: The publisher_id of this ReferralInformation.
        :rtype: str
        """
        return self._publisher_id

    @publisher_id.setter
    def publisher_id(self, publisher_id):
        """
        Sets the publisher_id of this ReferralInformation.
        

        :param publisher_id: The publisher_id of this ReferralInformation.
        :type: str
        """

        self._publisher_id = publisher_id

    @property
    def referral_code(self):
        """
        Gets the referral_code of this ReferralInformation.
        

        :return: The referral_code of this ReferralInformation.
        :rtype: str
        """
        return self._referral_code

    @referral_code.setter
    def referral_code(self, referral_code):
        """
        Sets the referral_code of this ReferralInformation.
        

        :param referral_code: The referral_code of this ReferralInformation.
        :type: str
        """

        self._referral_code = referral_code

    @property
    def referrer_name(self):
        """
        Gets the referrer_name of this ReferralInformation.
        

        :return: The referrer_name of this ReferralInformation.
        :rtype: str
        """
        return self._referrer_name

    @referrer_name.setter
    def referrer_name(self, referrer_name):
        """
        Sets the referrer_name of this ReferralInformation.
        

        :param referrer_name: The referrer_name of this ReferralInformation.
        :type: str
        """

        self._referrer_name = referrer_name

    @property
    def sale_discount_amount(self):
        """
        Gets the sale_discount_amount of this ReferralInformation.
        Reserved for DocuSign use only.

        :return: The sale_discount_amount of this ReferralInformation.
        :rtype: str
        """
        return self._sale_discount_amount

    @sale_discount_amount.setter
    def sale_discount_amount(self, sale_discount_amount):
        """
        Sets the sale_discount_amount of this ReferralInformation.
        Reserved for DocuSign use only.

        :param sale_discount_amount: The sale_discount_amount of this ReferralInformation.
        :type: str
        """

        self._sale_discount_amount = sale_discount_amount

    @property
    def sale_discount_fixed_amount(self):
        """
        Gets the sale_discount_fixed_amount of this ReferralInformation.
        Reserved for DocuSign use only.

        :return: The sale_discount_fixed_amount of this ReferralInformation.
        :rtype: str
        """
        return self._sale_discount_fixed_amount

    @sale_discount_fixed_amount.setter
    def sale_discount_fixed_amount(self, sale_discount_fixed_amount):
        """
        Sets the sale_discount_fixed_amount of this ReferralInformation.
        Reserved for DocuSign use only.

        :param sale_discount_fixed_amount: The sale_discount_fixed_amount of this ReferralInformation.
        :type: str
        """

        self._sale_discount_fixed_amount = sale_discount_fixed_amount

    @property
    def sale_discount_percent(self):
        """
        Gets the sale_discount_percent of this ReferralInformation.
        Reserved for DocuSign use only.

        :return: The sale_discount_percent of this ReferralInformation.
        :rtype: str
        """
        return self._sale_discount_percent

    @sale_discount_percent.setter
    def sale_discount_percent(self, sale_discount_percent):
        """
        Sets the sale_discount_percent of this ReferralInformation.
        Reserved for DocuSign use only.

        :param sale_discount_percent: The sale_discount_percent of this ReferralInformation.
        :type: str
        """

        self._sale_discount_percent = sale_discount_percent

    @property
    def sale_discount_periods(self):
        """
        Gets the sale_discount_periods of this ReferralInformation.
        Reserved for DocuSign use only.

        :return: The sale_discount_periods of this ReferralInformation.
        :rtype: str
        """
        return self._sale_discount_periods

    @sale_discount_periods.setter
    def sale_discount_periods(self, sale_discount_periods):
        """
        Sets the sale_discount_periods of this ReferralInformation.
        Reserved for DocuSign use only.

        :param sale_discount_periods: The sale_discount_periods of this ReferralInformation.
        :type: str
        """

        self._sale_discount_periods = sale_discount_periods

    @property
    def sale_discount_seat_price_override(self):
        """
        Gets the sale_discount_seat_price_override of this ReferralInformation.
        Reserved for DocuSign use only.

        :return: The sale_discount_seat_price_override of this ReferralInformation.
        :rtype: str
        """
        return self._sale_discount_seat_price_override

    @sale_discount_seat_price_override.setter
    def sale_discount_seat_price_override(self, sale_discount_seat_price_override):
        """
        Sets the sale_discount_seat_price_override of this ReferralInformation.
        Reserved for DocuSign use only.

        :param sale_discount_seat_price_override: The sale_discount_seat_price_override of this ReferralInformation.
        :type: str
        """

        self._sale_discount_seat_price_override = sale_discount_seat_price_override

    @property
    def shopper_id(self):
        """
        Gets the shopper_id of this ReferralInformation.
        

        :return: The shopper_id of this ReferralInformation.
        :rtype: str
        """
        return self._shopper_id

    @shopper_id.setter
    def shopper_id(self, shopper_id):
        """
        Sets the shopper_id of this ReferralInformation.
        

        :param shopper_id: The shopper_id of this ReferralInformation.
        :type: str
        """

        self._shopper_id = shopper_id

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other
