# coding: utf-8

"""
    DocuSign REST API

    The DocuSign REST API provides you with a powerful, convenient, and simple Web services API for interacting with DocuSign.

    OpenAPI spec version: v2
    Contact: devcenter@docusign.com
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from pprint import pformat
from six import iteritems
import re


class PowerFormFormDataRecipient(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self, email=None, form_data=None, name=None, recipient_id=None):
        """
        PowerFormFormDataRecipient - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'email': 'str',
            'form_data': 'list[NameValue]',
            'name': 'str',
            'recipient_id': 'str'
        }

        self.attribute_map = {
            'email': 'email',
            'form_data': 'formData',
            'name': 'name',
            'recipient_id': 'recipientId'
        }

        self._email = email
        self._form_data = form_data
        self._name = name
        self._recipient_id = recipient_id

    @property
    def email(self):
        """
        Gets the email of this PowerFormFormDataRecipient.
        

        :return: The email of this PowerFormFormDataRecipient.
        :rtype: str
        """
        return self._email

    @email.setter
    def email(self, email):
        """
        Sets the email of this PowerFormFormDataRecipient.
        

        :param email: The email of this PowerFormFormDataRecipient.
        :type: str
        """

        self._email = email

    @property
    def form_data(self):
        """
        Gets the form_data of this PowerFormFormDataRecipient.
        

        :return: The form_data of this PowerFormFormDataRecipient.
        :rtype: list[NameValue]
        """
        return self._form_data

    @form_data.setter
    def form_data(self, form_data):
        """
        Sets the form_data of this PowerFormFormDataRecipient.
        

        :param form_data: The form_data of this PowerFormFormDataRecipient.
        :type: list[NameValue]
        """

        self._form_data = form_data

    @property
    def name(self):
        """
        Gets the name of this PowerFormFormDataRecipient.
        

        :return: The name of this PowerFormFormDataRecipient.
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """
        Sets the name of this PowerFormFormDataRecipient.
        

        :param name: The name of this PowerFormFormDataRecipient.
        :type: str
        """

        self._name = name

    @property
    def recipient_id(self):
        """
        Gets the recipient_id of this PowerFormFormDataRecipient.
        Unique for the recipient. It is used by the tab element to indicate which recipient is to sign the Document.

        :return: The recipient_id of this PowerFormFormDataRecipient.
        :rtype: str
        """
        return self._recipient_id

    @recipient_id.setter
    def recipient_id(self, recipient_id):
        """
        Sets the recipient_id of this PowerFormFormDataRecipient.
        Unique for the recipient. It is used by the tab element to indicate which recipient is to sign the Document.

        :param recipient_id: The recipient_id of this PowerFormFormDataRecipient.
        :type: str
        """

        self._recipient_id = recipient_id

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other
