# coding: utf-8

"""
    DocuSign REST API

    The DocuSign REST API provides you with a powerful, convenient, and simple Web services API for interacting with DocuSign.

    OpenAPI spec version: v2
    Contact: devcenter@docusign.com
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from pprint import pformat
from six import iteritems
import re


class EventNotification(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self, envelope_events=None, include_certificate_of_completion=None, include_certificate_with_soap=None, include_document_fields=None, include_documents=None, include_envelope_void_reason=None, include_hmac=None, include_sender_account_as_custom_field=None, include_time_zone=None, logging_enabled=None, recipient_events=None, require_acknowledgment=None, sign_message_with_x509_cert=None, soap_name_space=None, url=None, use_soap_interface=None):
        """
        EventNotification - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'envelope_events': 'list[EnvelopeEvent]',
            'include_certificate_of_completion': 'str',
            'include_certificate_with_soap': 'str',
            'include_document_fields': 'str',
            'include_documents': 'str',
            'include_envelope_void_reason': 'str',
            'include_hmac': 'str',
            'include_sender_account_as_custom_field': 'str',
            'include_time_zone': 'str',
            'logging_enabled': 'str',
            'recipient_events': 'list[RecipientEvent]',
            'require_acknowledgment': 'str',
            'sign_message_with_x509_cert': 'str',
            'soap_name_space': 'str',
            'url': 'str',
            'use_soap_interface': 'str'
        }

        self.attribute_map = {
            'envelope_events': 'envelopeEvents',
            'include_certificate_of_completion': 'includeCertificateOfCompletion',
            'include_certificate_with_soap': 'includeCertificateWithSoap',
            'include_document_fields': 'includeDocumentFields',
            'include_documents': 'includeDocuments',
            'include_envelope_void_reason': 'includeEnvelopeVoidReason',
            'include_hmac': 'includeHMAC',
            'include_sender_account_as_custom_field': 'includeSenderAccountAsCustomField',
            'include_time_zone': 'includeTimeZone',
            'logging_enabled': 'loggingEnabled',
            'recipient_events': 'recipientEvents',
            'require_acknowledgment': 'requireAcknowledgment',
            'sign_message_with_x509_cert': 'signMessageWithX509Cert',
            'soap_name_space': 'soapNameSpace',
            'url': 'url',
            'use_soap_interface': 'useSoapInterface'
        }

        self._envelope_events = envelope_events
        self._include_certificate_of_completion = include_certificate_of_completion
        self._include_certificate_with_soap = include_certificate_with_soap
        self._include_document_fields = include_document_fields
        self._include_documents = include_documents
        self._include_envelope_void_reason = include_envelope_void_reason
        self._include_hmac = include_hmac
        self._include_sender_account_as_custom_field = include_sender_account_as_custom_field
        self._include_time_zone = include_time_zone
        self._logging_enabled = logging_enabled
        self._recipient_events = recipient_events
        self._require_acknowledgment = require_acknowledgment
        self._sign_message_with_x509_cert = sign_message_with_x509_cert
        self._soap_name_space = soap_name_space
        self._url = url
        self._use_soap_interface = use_soap_interface

    @property
    def envelope_events(self):
        """
        Gets the envelope_events of this EventNotification.
        A list of envelope-level event statuses that will trigger Connect to send updates to the endpoint specified in the `url` property.   To receive notifications, you must include either an `envelopeEvents` node or a `recipientEvents` node. You do not need to specify both.

        :return: The envelope_events of this EventNotification.
        :rtype: list[EnvelopeEvent]
        """
        return self._envelope_events

    @envelope_events.setter
    def envelope_events(self, envelope_events):
        """
        Sets the envelope_events of this EventNotification.
        A list of envelope-level event statuses that will trigger Connect to send updates to the endpoint specified in the `url` property.   To receive notifications, you must include either an `envelopeEvents` node or a `recipientEvents` node. You do not need to specify both.

        :param envelope_events: The envelope_events of this EventNotification.
        :type: list[EnvelopeEvent]
        """

        self._envelope_events = envelope_events

    @property
    def include_certificate_of_completion(self):
        """
        Gets the include_certificate_of_completion of this EventNotification.
        When set to **true**, the Connect Service includes the Certificate of Completion with completed envelopes. 

        :return: The include_certificate_of_completion of this EventNotification.
        :rtype: str
        """
        return self._include_certificate_of_completion

    @include_certificate_of_completion.setter
    def include_certificate_of_completion(self, include_certificate_of_completion):
        """
        Sets the include_certificate_of_completion of this EventNotification.
        When set to **true**, the Connect Service includes the Certificate of Completion with completed envelopes. 

        :param include_certificate_of_completion: The include_certificate_of_completion of this EventNotification.
        :type: str
        """

        self._include_certificate_of_completion = include_certificate_of_completion

    @property
    def include_certificate_with_soap(self):
        """
        Gets the include_certificate_with_soap of this EventNotification.
        When set to **true**, this tells the Connect service to send the DocuSign signedby certificate as part of the outgoing SOAP xml. This appears in the XML as wsse:BinarySecurityToken.

        :return: The include_certificate_with_soap of this EventNotification.
        :rtype: str
        """
        return self._include_certificate_with_soap

    @include_certificate_with_soap.setter
    def include_certificate_with_soap(self, include_certificate_with_soap):
        """
        Sets the include_certificate_with_soap of this EventNotification.
        When set to **true**, this tells the Connect service to send the DocuSign signedby certificate as part of the outgoing SOAP xml. This appears in the XML as wsse:BinarySecurityToken.

        :param include_certificate_with_soap: The include_certificate_with_soap of this EventNotification.
        :type: str
        """

        self._include_certificate_with_soap = include_certificate_with_soap

    @property
    def include_document_fields(self):
        """
        Gets the include_document_fields of this EventNotification.
        When set to **true**, the Document Fields associated with envelope documents are included in the data. Document Fields are optional custom name-value pairs added to documents using the API. 

        :return: The include_document_fields of this EventNotification.
        :rtype: str
        """
        return self._include_document_fields

    @include_document_fields.setter
    def include_document_fields(self, include_document_fields):
        """
        Sets the include_document_fields of this EventNotification.
        When set to **true**, the Document Fields associated with envelope documents are included in the data. Document Fields are optional custom name-value pairs added to documents using the API. 

        :param include_document_fields: The include_document_fields of this EventNotification.
        :type: str
        """

        self._include_document_fields = include_document_fields

    @property
    def include_documents(self):
        """
        Gets the include_documents of this EventNotification.
        When set to **true**, the PDF documents are included in the message along with the updated XML. 

        :return: The include_documents of this EventNotification.
        :rtype: str
        """
        return self._include_documents

    @include_documents.setter
    def include_documents(self, include_documents):
        """
        Sets the include_documents of this EventNotification.
        When set to **true**, the PDF documents are included in the message along with the updated XML. 

        :param include_documents: The include_documents of this EventNotification.
        :type: str
        """

        self._include_documents = include_documents

    @property
    def include_envelope_void_reason(self):
        """
        Gets the include_envelope_void_reason of this EventNotification.
        When set to **true**, this tells the Connect Service to include the void reason, as entered by the person that voided the envelope, in the message. 

        :return: The include_envelope_void_reason of this EventNotification.
        :rtype: str
        """
        return self._include_envelope_void_reason

    @include_envelope_void_reason.setter
    def include_envelope_void_reason(self, include_envelope_void_reason):
        """
        Sets the include_envelope_void_reason of this EventNotification.
        When set to **true**, this tells the Connect Service to include the void reason, as entered by the person that voided the envelope, in the message. 

        :param include_envelope_void_reason: The include_envelope_void_reason of this EventNotification.
        :type: str
        """

        self._include_envelope_void_reason = include_envelope_void_reason

    @property
    def include_hmac(self):
        """
        Gets the include_hmac of this EventNotification.
        

        :return: The include_hmac of this EventNotification.
        :rtype: str
        """
        return self._include_hmac

    @include_hmac.setter
    def include_hmac(self, include_hmac):
        """
        Sets the include_hmac of this EventNotification.
        

        :param include_hmac: The include_hmac of this EventNotification.
        :type: str
        """

        self._include_hmac = include_hmac

    @property
    def include_sender_account_as_custom_field(self):
        """
        Gets the include_sender_account_as_custom_field of this EventNotification.
        When set to **true**, the sender account ID is included as a envelope custom field in the data. 

        :return: The include_sender_account_as_custom_field of this EventNotification.
        :rtype: str
        """
        return self._include_sender_account_as_custom_field

    @include_sender_account_as_custom_field.setter
    def include_sender_account_as_custom_field(self, include_sender_account_as_custom_field):
        """
        Sets the include_sender_account_as_custom_field of this EventNotification.
        When set to **true**, the sender account ID is included as a envelope custom field in the data. 

        :param include_sender_account_as_custom_field: The include_sender_account_as_custom_field of this EventNotification.
        :type: str
        """

        self._include_sender_account_as_custom_field = include_sender_account_as_custom_field

    @property
    def include_time_zone(self):
        """
        Gets the include_time_zone of this EventNotification.
        When set to **true**, the envelope time zone information is included in the message. 

        :return: The include_time_zone of this EventNotification.
        :rtype: str
        """
        return self._include_time_zone

    @include_time_zone.setter
    def include_time_zone(self, include_time_zone):
        """
        Sets the include_time_zone of this EventNotification.
        When set to **true**, the envelope time zone information is included in the message. 

        :param include_time_zone: The include_time_zone of this EventNotification.
        :type: str
        """

        self._include_time_zone = include_time_zone

    @property
    def logging_enabled(self):
        """
        Gets the logging_enabled of this EventNotification.
        When set to **true**, logging is turned on for envelope events on the Web Console Connect page. 

        :return: The logging_enabled of this EventNotification.
        :rtype: str
        """
        return self._logging_enabled

    @logging_enabled.setter
    def logging_enabled(self, logging_enabled):
        """
        Sets the logging_enabled of this EventNotification.
        When set to **true**, logging is turned on for envelope events on the Web Console Connect page. 

        :param logging_enabled: The logging_enabled of this EventNotification.
        :type: str
        """

        self._logging_enabled = logging_enabled

    @property
    def recipient_events(self):
        """
        Gets the recipient_events of this EventNotification.
        A list of recipient event statuses that will trigger Connect to send updates to   the endpoint specified in the url property.  To receive notifications, you must include either an `envelopeEvents` node or a `recipientEvents` node. You do not need to specify both.

        :return: The recipient_events of this EventNotification.
        :rtype: list[RecipientEvent]
        """
        return self._recipient_events

    @recipient_events.setter
    def recipient_events(self, recipient_events):
        """
        Sets the recipient_events of this EventNotification.
        A list of recipient event statuses that will trigger Connect to send updates to   the endpoint specified in the url property.  To receive notifications, you must include either an `envelopeEvents` node or a `recipientEvents` node. You do not need to specify both.

        :param recipient_events: The recipient_events of this EventNotification.
        :type: list[RecipientEvent]
        """

        self._recipient_events = recipient_events

    @property
    def require_acknowledgment(self):
        """
        Gets the require_acknowledgment of this EventNotification.
        When set to **true**, the DocuSign Connect service checks that the message was received and retries on failures. 

        :return: The require_acknowledgment of this EventNotification.
        :rtype: str
        """
        return self._require_acknowledgment

    @require_acknowledgment.setter
    def require_acknowledgment(self, require_acknowledgment):
        """
        Sets the require_acknowledgment of this EventNotification.
        When set to **true**, the DocuSign Connect service checks that the message was received and retries on failures. 

        :param require_acknowledgment: The require_acknowledgment of this EventNotification.
        :type: str
        """

        self._require_acknowledgment = require_acknowledgment

    @property
    def sign_message_with_x509_cert(self):
        """
        Gets the sign_message_with_x509_cert of this EventNotification.
        When set to **true**, messages are signed with an X509 certificate. This provides support for 2-way SSL in the envelope. 

        :return: The sign_message_with_x509_cert of this EventNotification.
        :rtype: str
        """
        return self._sign_message_with_x509_cert

    @sign_message_with_x509_cert.setter
    def sign_message_with_x509_cert(self, sign_message_with_x509_cert):
        """
        Sets the sign_message_with_x509_cert of this EventNotification.
        When set to **true**, messages are signed with an X509 certificate. This provides support for 2-way SSL in the envelope. 

        :param sign_message_with_x509_cert: The sign_message_with_x509_cert of this EventNotification.
        :type: str
        """

        self._sign_message_with_x509_cert = sign_message_with_x509_cert

    @property
    def soap_name_space(self):
        """
        Gets the soap_name_space of this EventNotification.
        This lists the namespace in the SOAP listener provided.

        :return: The soap_name_space of this EventNotification.
        :rtype: str
        """
        return self._soap_name_space

    @soap_name_space.setter
    def soap_name_space(self, soap_name_space):
        """
        Sets the soap_name_space of this EventNotification.
        This lists the namespace in the SOAP listener provided.

        :param soap_name_space: The soap_name_space of this EventNotification.
        :type: str
        """

        self._soap_name_space = soap_name_space

    @property
    def url(self):
        """
        Gets the url of this EventNotification.
        Specifies the endpoint to which envelope updates are sent. Udpates are sent as XML unless `useSoapInterface` property is set to **true**.

        :return: The url of this EventNotification.
        :rtype: str
        """
        return self._url

    @url.setter
    def url(self, url):
        """
        Sets the url of this EventNotification.
        Specifies the endpoint to which envelope updates are sent. Udpates are sent as XML unless `useSoapInterface` property is set to **true**.

        :param url: The url of this EventNotification.
        :type: str
        """

        self._url = url

    @property
    def use_soap_interface(self):
        """
        Gets the use_soap_interface of this EventNotification.
        When set to **true**, this tells the Connect service that the user's endpoint has implemented a SOAP interface. 

        :return: The use_soap_interface of this EventNotification.
        :rtype: str
        """
        return self._use_soap_interface

    @use_soap_interface.setter
    def use_soap_interface(self, use_soap_interface):
        """
        Sets the use_soap_interface of this EventNotification.
        When set to **true**, this tells the Connect service that the user's endpoint has implemented a SOAP interface. 

        :param use_soap_interface: The use_soap_interface of this EventNotification.
        :type: str
        """

        self._use_soap_interface = use_soap_interface

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other
