# coding: utf-8

"""
    DocuSign REST API

    The DocuSign REST API provides you with a powerful, convenient, and simple Web services API for interacting with DocuSign.

    OpenAPI spec version: v2
    Contact: devcenter@docusign.com
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from pprint import pformat
from six import iteritems
import re


class DocumentVisibility(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self, document_id=None, error_details=None, recipient_id=None, rights=None, visible=None):
        """
        DocumentVisibility - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'document_id': 'str',
            'error_details': 'ErrorDetails',
            'recipient_id': 'str',
            'rights': 'str',
            'visible': 'str'
        }

        self.attribute_map = {
            'document_id': 'documentId',
            'error_details': 'errorDetails',
            'recipient_id': 'recipientId',
            'rights': 'rights',
            'visible': 'visible'
        }

        self._document_id = document_id
        self._error_details = error_details
        self._recipient_id = recipient_id
        self._rights = rights
        self._visible = visible

    @property
    def document_id(self):
        """
        Gets the document_id of this DocumentVisibility.
        Specifies the document ID number that the tab is placed on. This must refer to an existing Document's ID attribute.

        :return: The document_id of this DocumentVisibility.
        :rtype: str
        """
        return self._document_id

    @document_id.setter
    def document_id(self, document_id):
        """
        Sets the document_id of this DocumentVisibility.
        Specifies the document ID number that the tab is placed on. This must refer to an existing Document's ID attribute.

        :param document_id: The document_id of this DocumentVisibility.
        :type: str
        """

        self._document_id = document_id

    @property
    def error_details(self):
        """
        Gets the error_details of this DocumentVisibility.

        :return: The error_details of this DocumentVisibility.
        :rtype: ErrorDetails
        """
        return self._error_details

    @error_details.setter
    def error_details(self, error_details):
        """
        Sets the error_details of this DocumentVisibility.

        :param error_details: The error_details of this DocumentVisibility.
        :type: ErrorDetails
        """

        self._error_details = error_details

    @property
    def recipient_id(self):
        """
        Gets the recipient_id of this DocumentVisibility.
        Unique for the recipient. It is used by the tab element to indicate which recipient is to sign the Document.

        :return: The recipient_id of this DocumentVisibility.
        :rtype: str
        """
        return self._recipient_id

    @recipient_id.setter
    def recipient_id(self, recipient_id):
        """
        Sets the recipient_id of this DocumentVisibility.
        Unique for the recipient. It is used by the tab element to indicate which recipient is to sign the Document.

        :param recipient_id: The recipient_id of this DocumentVisibility.
        :type: str
        """

        self._recipient_id = recipient_id

    @property
    def rights(self):
        """
        Gets the rights of this DocumentVisibility.
        

        :return: The rights of this DocumentVisibility.
        :rtype: str
        """
        return self._rights

    @rights.setter
    def rights(self, rights):
        """
        Sets the rights of this DocumentVisibility.
        

        :param rights: The rights of this DocumentVisibility.
        :type: str
        """

        self._rights = rights

    @property
    def visible(self):
        """
        Gets the visible of this DocumentVisibility.
        

        :return: The visible of this DocumentVisibility.
        :rtype: str
        """
        return self._visible

    @visible.setter
    def visible(self, visible):
        """
        Sets the visible of this DocumentVisibility.
        

        :param visible: The visible of this DocumentVisibility.
        :type: str
        """

        self._visible = visible

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other
