# coding: utf-8

"""
    DocuSign REST API

    The DocuSign REST API provides you with a powerful, convenient, and simple Web services API for interacting with DocuSign.

    OpenAPI spec version: v2
    Contact: devcenter@docusign.com
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from pprint import pformat
from six import iteritems
import re


class DocumentHtmlDefinitionOriginal(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self, document_id=None, document_id_guid=None, html_definition=None):
        """
        DocumentHtmlDefinitionOriginal - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'document_id': 'str',
            'document_id_guid': 'str',
            'html_definition': 'DocumentHtmlDefinition'
        }

        self.attribute_map = {
            'document_id': 'documentId',
            'document_id_guid': 'documentIdGuid',
            'html_definition': 'htmlDefinition'
        }

        self._document_id = document_id
        self._document_id_guid = document_id_guid
        self._html_definition = html_definition

    @property
    def document_id(self):
        """
        Gets the document_id of this DocumentHtmlDefinitionOriginal.
        Specifies the document ID number that the tab is placed on. This must refer to an existing Document's ID attribute.

        :return: The document_id of this DocumentHtmlDefinitionOriginal.
        :rtype: str
        """
        return self._document_id

    @document_id.setter
    def document_id(self, document_id):
        """
        Sets the document_id of this DocumentHtmlDefinitionOriginal.
        Specifies the document ID number that the tab is placed on. This must refer to an existing Document's ID attribute.

        :param document_id: The document_id of this DocumentHtmlDefinitionOriginal.
        :type: str
        """

        self._document_id = document_id

    @property
    def document_id_guid(self):
        """
        Gets the document_id_guid of this DocumentHtmlDefinitionOriginal.
        

        :return: The document_id_guid of this DocumentHtmlDefinitionOriginal.
        :rtype: str
        """
        return self._document_id_guid

    @document_id_guid.setter
    def document_id_guid(self, document_id_guid):
        """
        Sets the document_id_guid of this DocumentHtmlDefinitionOriginal.
        

        :param document_id_guid: The document_id_guid of this DocumentHtmlDefinitionOriginal.
        :type: str
        """

        self._document_id_guid = document_id_guid

    @property
    def html_definition(self):
        """
        Gets the html_definition of this DocumentHtmlDefinitionOriginal.

        :return: The html_definition of this DocumentHtmlDefinitionOriginal.
        :rtype: DocumentHtmlDefinition
        """
        return self._html_definition

    @html_definition.setter
    def html_definition(self, html_definition):
        """
        Sets the html_definition of this DocumentHtmlDefinitionOriginal.

        :param html_definition: The html_definition of this DocumentHtmlDefinitionOriginal.
        :type: DocumentHtmlDefinition
        """

        self._html_definition = html_definition

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other
