# coding: utf-8

"""
    DocuSign REST API

    The DocuSign REST API provides you with a powerful, convenient, and simple Web services API for interacting with DocuSign.

    OpenAPI spec version: v2
    Contact: devcenter@docusign.com
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from pprint import pformat
from six import iteritems
import re


class ConnectLogs(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self, failures=None, logs=None, total_records=None, type=None):
        """
        ConnectLogs - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'failures': 'list[ConnectLog]',
            'logs': 'list[ConnectLog]',
            'total_records': 'str',
            'type': 'str'
        }

        self.attribute_map = {
            'failures': 'failures',
            'logs': 'logs',
            'total_records': 'totalRecords',
            'type': 'type'
        }

        self._failures = failures
        self._logs = logs
        self._total_records = total_records
        self._type = type

    @property
    def failures(self):
        """
        Gets the failures of this ConnectLogs.
        An array of containing failure information from the Connect failure log.

        :return: The failures of this ConnectLogs.
        :rtype: list[ConnectLog]
        """
        return self._failures

    @failures.setter
    def failures(self, failures):
        """
        Sets the failures of this ConnectLogs.
        An array of containing failure information from the Connect failure log.

        :param failures: The failures of this ConnectLogs.
        :type: list[ConnectLog]
        """

        self._failures = failures

    @property
    def logs(self):
        """
        Gets the logs of this ConnectLogs.
        A complex type containing Connect log information. It is divided into two sections, one for regular logs and one for Connect failures. 

        :return: The logs of this ConnectLogs.
        :rtype: list[ConnectLog]
        """
        return self._logs

    @logs.setter
    def logs(self, logs):
        """
        Sets the logs of this ConnectLogs.
        A complex type containing Connect log information. It is divided into two sections, one for regular logs and one for Connect failures. 

        :param logs: The logs of this ConnectLogs.
        :type: list[ConnectLog]
        """

        self._logs = logs

    @property
    def total_records(self):
        """
        Gets the total_records of this ConnectLogs.
        

        :return: The total_records of this ConnectLogs.
        :rtype: str
        """
        return self._total_records

    @total_records.setter
    def total_records(self, total_records):
        """
        Sets the total_records of this ConnectLogs.
        

        :param total_records: The total_records of this ConnectLogs.
        :type: str
        """

        self._total_records = total_records

    @property
    def type(self):
        """
        Gets the type of this ConnectLogs.
        

        :return: The type of this ConnectLogs.
        :rtype: str
        """
        return self._type

    @type.setter
    def type(self, type):
        """
        Sets the type of this ConnectLogs.
        

        :param type: The type of this ConnectLogs.
        :type: str
        """

        self._type = type

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other
