# coding: utf-8

"""
    DocuSign REST API

    The DocuSign REST API provides you with a powerful, convenient, and simple Web services API for interacting with DocuSign.

    OpenAPI spec version: v2
    Contact: devcenter@docusign.com
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from pprint import pformat
from six import iteritems
import re


class BillingPlanInformation(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self, app_store_receipt=None, billing_address=None, credit_card_information=None, downgrade_reason=None, enable_support=None, included_seats=None, incremental_seats=None, payment_processor_information=None, plan_information=None, referral_information=None, renewal_status=None, sale_discount_amount=None, sale_discount_fixed_amount=None, sale_discount_percent=None, sale_discount_periods=None, sale_discount_seat_price_override=None):
        """
        BillingPlanInformation - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'app_store_receipt': 'AppStoreReceipt',
            'billing_address': 'AccountAddress',
            'credit_card_information': 'CreditCardInformation',
            'downgrade_reason': 'str',
            'enable_support': 'str',
            'included_seats': 'str',
            'incremental_seats': 'str',
            'payment_processor_information': 'PaymentProcessorInformation',
            'plan_information': 'PlanInformation',
            'referral_information': 'ReferralInformation',
            'renewal_status': 'str',
            'sale_discount_amount': 'str',
            'sale_discount_fixed_amount': 'str',
            'sale_discount_percent': 'str',
            'sale_discount_periods': 'str',
            'sale_discount_seat_price_override': 'str'
        }

        self.attribute_map = {
            'app_store_receipt': 'appStoreReceipt',
            'billing_address': 'billingAddress',
            'credit_card_information': 'creditCardInformation',
            'downgrade_reason': 'downgradeReason',
            'enable_support': 'enableSupport',
            'included_seats': 'includedSeats',
            'incremental_seats': 'incrementalSeats',
            'payment_processor_information': 'paymentProcessorInformation',
            'plan_information': 'planInformation',
            'referral_information': 'referralInformation',
            'renewal_status': 'renewalStatus',
            'sale_discount_amount': 'saleDiscountAmount',
            'sale_discount_fixed_amount': 'saleDiscountFixedAmount',
            'sale_discount_percent': 'saleDiscountPercent',
            'sale_discount_periods': 'saleDiscountPeriods',
            'sale_discount_seat_price_override': 'saleDiscountSeatPriceOverride'
        }

        self._app_store_receipt = app_store_receipt
        self._billing_address = billing_address
        self._credit_card_information = credit_card_information
        self._downgrade_reason = downgrade_reason
        self._enable_support = enable_support
        self._included_seats = included_seats
        self._incremental_seats = incremental_seats
        self._payment_processor_information = payment_processor_information
        self._plan_information = plan_information
        self._referral_information = referral_information
        self._renewal_status = renewal_status
        self._sale_discount_amount = sale_discount_amount
        self._sale_discount_fixed_amount = sale_discount_fixed_amount
        self._sale_discount_percent = sale_discount_percent
        self._sale_discount_periods = sale_discount_periods
        self._sale_discount_seat_price_override = sale_discount_seat_price_override

    @property
    def app_store_receipt(self):
        """
        Gets the app_store_receipt of this BillingPlanInformation.

        :return: The app_store_receipt of this BillingPlanInformation.
        :rtype: AppStoreReceipt
        """
        return self._app_store_receipt

    @app_store_receipt.setter
    def app_store_receipt(self, app_store_receipt):
        """
        Sets the app_store_receipt of this BillingPlanInformation.

        :param app_store_receipt: The app_store_receipt of this BillingPlanInformation.
        :type: AppStoreReceipt
        """

        self._app_store_receipt = app_store_receipt

    @property
    def billing_address(self):
        """
        Gets the billing_address of this BillingPlanInformation.

        :return: The billing_address of this BillingPlanInformation.
        :rtype: AccountAddress
        """
        return self._billing_address

    @billing_address.setter
    def billing_address(self, billing_address):
        """
        Sets the billing_address of this BillingPlanInformation.

        :param billing_address: The billing_address of this BillingPlanInformation.
        :type: AccountAddress
        """

        self._billing_address = billing_address

    @property
    def credit_card_information(self):
        """
        Gets the credit_card_information of this BillingPlanInformation.

        :return: The credit_card_information of this BillingPlanInformation.
        :rtype: CreditCardInformation
        """
        return self._credit_card_information

    @credit_card_information.setter
    def credit_card_information(self, credit_card_information):
        """
        Sets the credit_card_information of this BillingPlanInformation.

        :param credit_card_information: The credit_card_information of this BillingPlanInformation.
        :type: CreditCardInformation
        """

        self._credit_card_information = credit_card_information

    @property
    def downgrade_reason(self):
        """
        Gets the downgrade_reason of this BillingPlanInformation.
        

        :return: The downgrade_reason of this BillingPlanInformation.
        :rtype: str
        """
        return self._downgrade_reason

    @downgrade_reason.setter
    def downgrade_reason(self, downgrade_reason):
        """
        Sets the downgrade_reason of this BillingPlanInformation.
        

        :param downgrade_reason: The downgrade_reason of this BillingPlanInformation.
        :type: str
        """

        self._downgrade_reason = downgrade_reason

    @property
    def enable_support(self):
        """
        Gets the enable_support of this BillingPlanInformation.
        

        :return: The enable_support of this BillingPlanInformation.
        :rtype: str
        """
        return self._enable_support

    @enable_support.setter
    def enable_support(self, enable_support):
        """
        Sets the enable_support of this BillingPlanInformation.
        

        :param enable_support: The enable_support of this BillingPlanInformation.
        :type: str
        """

        self._enable_support = enable_support

    @property
    def included_seats(self):
        """
        Gets the included_seats of this BillingPlanInformation.
        The number of seats (users) included.

        :return: The included_seats of this BillingPlanInformation.
        :rtype: str
        """
        return self._included_seats

    @included_seats.setter
    def included_seats(self, included_seats):
        """
        Sets the included_seats of this BillingPlanInformation.
        The number of seats (users) included.

        :param included_seats: The included_seats of this BillingPlanInformation.
        :type: str
        """

        self._included_seats = included_seats

    @property
    def incremental_seats(self):
        """
        Gets the incremental_seats of this BillingPlanInformation.
        Reserved: TBD

        :return: The incremental_seats of this BillingPlanInformation.
        :rtype: str
        """
        return self._incremental_seats

    @incremental_seats.setter
    def incremental_seats(self, incremental_seats):
        """
        Sets the incremental_seats of this BillingPlanInformation.
        Reserved: TBD

        :param incremental_seats: The incremental_seats of this BillingPlanInformation.
        :type: str
        """

        self._incremental_seats = incremental_seats

    @property
    def payment_processor_information(self):
        """
        Gets the payment_processor_information of this BillingPlanInformation.

        :return: The payment_processor_information of this BillingPlanInformation.
        :rtype: PaymentProcessorInformation
        """
        return self._payment_processor_information

    @payment_processor_information.setter
    def payment_processor_information(self, payment_processor_information):
        """
        Sets the payment_processor_information of this BillingPlanInformation.

        :param payment_processor_information: The payment_processor_information of this BillingPlanInformation.
        :type: PaymentProcessorInformation
        """

        self._payment_processor_information = payment_processor_information

    @property
    def plan_information(self):
        """
        Gets the plan_information of this BillingPlanInformation.

        :return: The plan_information of this BillingPlanInformation.
        :rtype: PlanInformation
        """
        return self._plan_information

    @plan_information.setter
    def plan_information(self, plan_information):
        """
        Sets the plan_information of this BillingPlanInformation.

        :param plan_information: The plan_information of this BillingPlanInformation.
        :type: PlanInformation
        """

        self._plan_information = plan_information

    @property
    def referral_information(self):
        """
        Gets the referral_information of this BillingPlanInformation.

        :return: The referral_information of this BillingPlanInformation.
        :rtype: ReferralInformation
        """
        return self._referral_information

    @referral_information.setter
    def referral_information(self, referral_information):
        """
        Sets the referral_information of this BillingPlanInformation.

        :param referral_information: The referral_information of this BillingPlanInformation.
        :type: ReferralInformation
        """

        self._referral_information = referral_information

    @property
    def renewal_status(self):
        """
        Gets the renewal_status of this BillingPlanInformation.
        

        :return: The renewal_status of this BillingPlanInformation.
        :rtype: str
        """
        return self._renewal_status

    @renewal_status.setter
    def renewal_status(self, renewal_status):
        """
        Sets the renewal_status of this BillingPlanInformation.
        

        :param renewal_status: The renewal_status of this BillingPlanInformation.
        :type: str
        """

        self._renewal_status = renewal_status

    @property
    def sale_discount_amount(self):
        """
        Gets the sale_discount_amount of this BillingPlanInformation.
        

        :return: The sale_discount_amount of this BillingPlanInformation.
        :rtype: str
        """
        return self._sale_discount_amount

    @sale_discount_amount.setter
    def sale_discount_amount(self, sale_discount_amount):
        """
        Sets the sale_discount_amount of this BillingPlanInformation.
        

        :param sale_discount_amount: The sale_discount_amount of this BillingPlanInformation.
        :type: str
        """

        self._sale_discount_amount = sale_discount_amount

    @property
    def sale_discount_fixed_amount(self):
        """
        Gets the sale_discount_fixed_amount of this BillingPlanInformation.
        

        :return: The sale_discount_fixed_amount of this BillingPlanInformation.
        :rtype: str
        """
        return self._sale_discount_fixed_amount

    @sale_discount_fixed_amount.setter
    def sale_discount_fixed_amount(self, sale_discount_fixed_amount):
        """
        Sets the sale_discount_fixed_amount of this BillingPlanInformation.
        

        :param sale_discount_fixed_amount: The sale_discount_fixed_amount of this BillingPlanInformation.
        :type: str
        """

        self._sale_discount_fixed_amount = sale_discount_fixed_amount

    @property
    def sale_discount_percent(self):
        """
        Gets the sale_discount_percent of this BillingPlanInformation.
        

        :return: The sale_discount_percent of this BillingPlanInformation.
        :rtype: str
        """
        return self._sale_discount_percent

    @sale_discount_percent.setter
    def sale_discount_percent(self, sale_discount_percent):
        """
        Sets the sale_discount_percent of this BillingPlanInformation.
        

        :param sale_discount_percent: The sale_discount_percent of this BillingPlanInformation.
        :type: str
        """

        self._sale_discount_percent = sale_discount_percent

    @property
    def sale_discount_periods(self):
        """
        Gets the sale_discount_periods of this BillingPlanInformation.
        

        :return: The sale_discount_periods of this BillingPlanInformation.
        :rtype: str
        """
        return self._sale_discount_periods

    @sale_discount_periods.setter
    def sale_discount_periods(self, sale_discount_periods):
        """
        Sets the sale_discount_periods of this BillingPlanInformation.
        

        :param sale_discount_periods: The sale_discount_periods of this BillingPlanInformation.
        :type: str
        """

        self._sale_discount_periods = sale_discount_periods

    @property
    def sale_discount_seat_price_override(self):
        """
        Gets the sale_discount_seat_price_override of this BillingPlanInformation.
        

        :return: The sale_discount_seat_price_override of this BillingPlanInformation.
        :rtype: str
        """
        return self._sale_discount_seat_price_override

    @sale_discount_seat_price_override.setter
    def sale_discount_seat_price_override(self, sale_discount_seat_price_override):
        """
        Sets the sale_discount_seat_price_override of this BillingPlanInformation.
        

        :param sale_discount_seat_price_override: The sale_discount_seat_price_override of this BillingPlanInformation.
        :type: str
        """

        self._sale_discount_seat_price_override = sale_discount_seat_price_override

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other
