# coding: utf-8

"""
    DocuSign REST API

    The DocuSign REST API provides you with a powerful, convenient, and simple Web services API for interacting with DocuSign.

    OpenAPI spec version: v2
    Contact: devcenter@docusign.com
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from pprint import pformat
from six import iteritems
import re


class BillingPaymentItem(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self, amount=None, description=None, payment_date=None, payment_id=None, payment_number=None):
        """
        BillingPaymentItem - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'amount': 'str',
            'description': 'str',
            'payment_date': 'str',
            'payment_id': 'str',
            'payment_number': 'str'
        }

        self.attribute_map = {
            'amount': 'amount',
            'description': 'description',
            'payment_date': 'paymentDate',
            'payment_id': 'paymentId',
            'payment_number': 'paymentNumber'
        }

        self._amount = amount
        self._description = description
        self._payment_date = payment_date
        self._payment_id = payment_id
        self._payment_number = payment_number

    @property
    def amount(self):
        """
        Gets the amount of this BillingPaymentItem.
        Reserved: TBD

        :return: The amount of this BillingPaymentItem.
        :rtype: str
        """
        return self._amount

    @amount.setter
    def amount(self, amount):
        """
        Sets the amount of this BillingPaymentItem.
        Reserved: TBD

        :param amount: The amount of this BillingPaymentItem.
        :type: str
        """

        self._amount = amount

    @property
    def description(self):
        """
        Gets the description of this BillingPaymentItem.
        

        :return: The description of this BillingPaymentItem.
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description):
        """
        Sets the description of this BillingPaymentItem.
        

        :param description: The description of this BillingPaymentItem.
        :type: str
        """

        self._description = description

    @property
    def payment_date(self):
        """
        Gets the payment_date of this BillingPaymentItem.
        

        :return: The payment_date of this BillingPaymentItem.
        :rtype: str
        """
        return self._payment_date

    @payment_date.setter
    def payment_date(self, payment_date):
        """
        Sets the payment_date of this BillingPaymentItem.
        

        :param payment_date: The payment_date of this BillingPaymentItem.
        :type: str
        """

        self._payment_date = payment_date

    @property
    def payment_id(self):
        """
        Gets the payment_id of this BillingPaymentItem.
        

        :return: The payment_id of this BillingPaymentItem.
        :rtype: str
        """
        return self._payment_id

    @payment_id.setter
    def payment_id(self, payment_id):
        """
        Sets the payment_id of this BillingPaymentItem.
        

        :param payment_id: The payment_id of this BillingPaymentItem.
        :type: str
        """

        self._payment_id = payment_id

    @property
    def payment_number(self):
        """
        Gets the payment_number of this BillingPaymentItem.
        When set to **true**, a PDF version of the invoice is available.   To get the PDF, make the call again and change \"Accept:\" in the header to \"Accept: application/pdf\".

        :return: The payment_number of this BillingPaymentItem.
        :rtype: str
        """
        return self._payment_number

    @payment_number.setter
    def payment_number(self, payment_number):
        """
        Sets the payment_number of this BillingPaymentItem.
        When set to **true**, a PDF version of the invoice is available.   To get the PDF, make the call again and change \"Accept:\" in the header to \"Accept: application/pdf\".

        :param payment_number: The payment_number of this BillingPaymentItem.
        :type: str
        """

        self._payment_number = payment_number

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other
