"""
The POTENTIAL PREDATORY JOURNALS were extracted from https://beallslist.net

Using the following script (With some additional manual adjustments after extraction, like removing journals indexed by DOAJ):

var links = Array.from(document.querySelectorAll("li a"));
links = links.map(x => ({name: x.text, url: x.href}));
console.log(JSON.stringify(links));

"""

POTENTIAL_PREDATORY_PUBLISHERS = [
    {"name":"1088 Email Press","url":"http://1088.email/"},
    {"name":"2425 Publishers","url":"http://2425publishers.org/"},
    {"name":"The 5th Publisher","url":"http://www.5thpublisher.com/"},
    {"name":"ABC Journals","url":"http://www.abcjournals.net/"},
    {"name":"A M Publishers","url":"http://ampublisher.com/index.html"},
    {"name":"Abhinav","url":"http://www.abhinavjournal.com/"},
    {"name":"Academe Research Journals","url":"http://www.academeresearchjournals.org/"},
    {"name":"Academia Publishing","url":"http://academiapublishing.org/index.htm"},
    {"name":"Academia Research","url":"http://academiaresearch.org/"},
    {"name":"Academia Scholarly Journals","url":"http://www.academiascholarlyjournal.org/"},
    {"name":"Academic and Business Research Institute","url":"http://www.aabri.com/"},
    {"name":"Academic and Scientific Publishing","url":"http://acascipub.com/"},
    {"name":"Academic Direct Publishing House","url":"http://ph.academicdirect.org/"},
    {"name":"Academic Journals","url":"http://www.academicjournals.org/"},
    {"name":"Academic Journals and Research ACJAR","url":"http://www.acjar.org/index.html"},
    {"name":"Academic Journals Online","url":"http://www.academicjournalsonline.co.in/"},
    {"name":"Academic Journals, Inc.","url":"http://www.academicjournalsinc.com/"},
    {"name":"Academic Knowledge and Research Publishing","url":"http://www.akrpub.com/"},
    {"name":"Academic Organization for Advancement of Strategic and International Studies","url":"http://www.academicoasis.org/"},
    {"name":"Academic Publications, Ltd.","url":"http://www.acadpubl.eu/index.html"},
    {"name":"Academic Research in Science, Engineering, Art and Management","url":"http://www.arseam.com/"},
    {"name":"Academic Research Journals","url":"http://www.academicresearchjournals.org/index.htm"},
    {"name":"Academic Research Publishers","url":"http://acrpub.com/index.php"},
    {"name":"Academic Research Publishing Agency","url":"http://www.arpapress.com/"},
    {"name":"Academic Research Publishing Group","url":"http://arpgweb.com/index.php"},
    {"name":"Academic Research Publishing House","url":"http://www.acadrp.org/"},
    {"name":"Academic Scholars Publishing House","url":"http://academic-publishing-house.com/"},
    {"name":"Academic Sciences","url":"http://www.ijaponline.org/"},
    {"name":"Academic Star Publishing Company","url":"http://www.academicstar.us/index.asp"},
    {"name":"Academic Star Publishing Company","url":"http://www.astarstore.us/"},
    {"name":"Academic Web Publishers","url":"http://academicwebpublishers.org/"},
    {"name":"Academic World Education & Research Center","url":"http://www.awer-center.org/journals.htm"},
    {"name":"AcademicDirect Publishing House","url":"http://ph.academicdirect.org/"},
    {"name":"Academicians’ Research Center","url":"http://www.arcjournals.org/index.php"},
    {"name":"Academics World","url":"http://academicsworld.org/"},
    {"name":"Academy for Environment and Life Sciences","url":"http://aelsindia.com/"},
    {"name":"Academy Journals","url":"http://www.academyjournals.net/"},
    {"name":"Academy of Business & Retail Management","url":"http://www.abrmr.com/"},
    {"name":"Academy of Business & Scientific Research","url":"http://www.absronline.org/"},
    {"name":"Academy of IRMBR International Research in Management and Business Realities","url":"http://www.academyirmbr.com/"},
    {"name":"Academy of Knowledge Process","url":"http://akpinsight.webs.com/"},
    {"name":"Academy of Science and Engineering","url":"http://www.scienceengineeringacademy.org/asesite/"},
    {"name":"Academy of Science and Social Science","url":"http://www.asss-web.com/"},
    {"name":"Academy of Scientific and Applied Research","url":"http://asaarjournals.com/"},
    {"name":"Academy Publish","url":"http://www.academypublish.org/"},
    {"name":"Access International Journals","url":"http://www.accessinterjournals.org/"},
    {"name":"Access Journals","url":"http://www.accessjournals.org/"},
    {"name":"Access Publishers","url":"http://www.accesspublishers.org/"},
    {"name":"ACT Publishing","url":"http://www.ghrnet.org/"},
    {"name":"Acta Scientifica","url":"http://actascientifica.com/index.php"},
    {"name":"AD Publication","url":"http://www.adpublication.org/"},
    {"name":"AD Publications","url":"http://adpublications.org/"},
    {"name":"Ada Lovelace Publications","url":"http://www.ada-lovelace.co.uk/"},
    {"name":"Advance Educational Institute & Research Centre","url":"http://aeirc-edu.com/"},
    {"name":"Advance Journals","url":"http://advancejournals.org/"},
    {"name":"Advanced Institute of Convergence Information Technology","url":"http://www.aicit.org/publications.html"},
    {"name":"Advanced Journals","url":"http://advancedjournals.org/index.htm"},
    {"name":"Advanced Research Journals","url":"http://www.advancedresearchjournals.org/"},
    {"name":"Advanced Research Publications","url":"http://adrpublications.in/"},
    {"name":"Advanced Scholars Journals","url":"http://advancedscholarsjournals.org/"},
    {"name":"Advanced Science and Engineering Technology Institute","url":"http://www.asetrc.org/"},
    {"name":"Advanced Science Research Journals","url":"http://advancedscienceresearchjournals.org/"},
    {"name":"Advanced Technology & Science","url":"http://atscience.org/"},
    {"name":"Advancement and Development in Technology International","url":"http://aditisci.com/index.php"},
    {"name":"Advancements in Science","url":"http://www.ajournals.com/"},
    {"name":"Adyan Academic Press","url":"http://www.adyanacademicpress.com/index.php"},
    {"name":"AENSI","url":"http://www.aensiweb.com/index.html"},
    {"name":"African Research Review","url":"http://afrrevjo.net/"},
    {"name":"AgiAl Publishing House","url":"http://www.agialpress.com/"},
    {"name":"Agropub","url":"http://agropub.com/index.html"},
    {"name":"AINSTIN Knowledge Hub","url":"http://ainstin.com/"},
    {"name":"AIRCC Publishing Corporation","url":"http://airccse.org/index.php"},
    {"name":"Aizeon Publishers","url":"http://www.aizeonpublishers.net/aboutus.html"},
    {"name":"Albert Science International Organization","url":"http://albertscience.com/"},
    {"name":"Allied Academies","url":"http://www.alliedacademies.org/"},
    {"name":"Allied Journals","url":"http://www.alliedjournals.com/"},
    {"name":"Ambit Journals","url":"http://ambitjournals.org/"},
    {"name":"AME Publishing Company","url":"http://www.amepc.org/"},
    {"name":"AME Publishing Company","url":"http://www.amegroups.com/"},
    {"name":"American Academic & Scholarly Research Center","url":"http://aasrc.org/"},
    {"name":"American Association for Science and Technology","url":"http://www.aascit.org/home/index"},
    {"name":"American Journal","url":"http://www.amjournals.org/"},
    {"name":"American Research Institute for Policy Development","url":"http://aripd.org/"},
    {"name":"American Research Journals","url":"http://www.arjonline.org/"},
    {"name":"American Research Publications","url":"http://www.arepub.com/"},
    {"name":"American Scholarly Research Association","url":"http://www.asraresearch.org/"},
    {"name":"American Scientific Research Journals","url":"http://www.americanscientificresearchjournals.org/"},
    {"name":"American Society of Registered Nurses","url":"http://www.asrn.org/"},
    {"name":"American Society of Science and Engineering","url":"http://www.as-se.org/"},
    {"name":"American V-King Scientific Publishing","url":"http://www.vkingpub.com/"},
    {"name":"Amoghsiddhi Education Society","url":"http://aessangli.in/"},
    {"name":"Amoghsiddhi Education Society","url":"http://www.ejournal.aessangli.in/index.php"},
    {"name":"Andrew John Publishing Inc.","url":"http://www.andrewjohnpublishing.org/open-access-publications.php"},
    {"name":"Annex Publishers","url":"http://www.annexpublishers.com/"},
    {"name":"ansinet","url":"http://www.ansinet.com/"},
    {"name":"Antarctic Journals","url":"http://www.domainsmoon.com/"},
    {"name":"Aperito Online Publishing","url":"http://aperito.org/index.php"},
    {"name":"Apex Journal","url":"http://apexjournal.org/"},
    {"name":"Applied Science Innovations","url":"http://www.applied-science-innovations.com/"},
    {"name":"APST Publication","url":"http://www.apst.co.in/"},
    {"name":"Arabian Group of Journals","url":"http://www.arabianjbmr.com/index.php"},
    {"name":"Aradhya International Publication","url":"http://puneresearch.com/home"},
    {"name":"ARC Journals","url":"https://www.arcjournals.org/"},
    {"name":"Archers & Elevators Publishing House","url":"http://www.aeph.in/"},
    {"name":"Archyworld","url":"http://www.archyworld.com/"},
    {"name":"ARPN Journals","url":"http://arpnjournals.com/"},
    {"name":"AS Publishers","url":"http://aspublishers.com/"},
    {"name":"ASD Publisher","url":"http://asdpub.com/"},
    {"name":"Ashdin Publishing","url":"http://www.ashdin.com/"},
    {"name":"AshEse Visionary","url":"http://www.ashese.co.uk/"},
    {"name":"Asia-Pacific Association of Medical Research","url":"http://www.apamr.org/"},
    {"name":"Asia Pacific Institute of Advanced Research","url":"http://apiar.org.au/"},
    {"name":"Asian Academic Research Associates","url":"http://www.asianacademicresearch.org/index.html"},
    {"name":"Asian and American Research Publishing Group","url":"http://www.aarpub.com/"},
    {"name":"Asian Economic and Social Society","url":"http://www.aessweb.com/index.php"},
    {"name":"Asian Online Journal Publishing Group","url":"http://www.asianonlinejournals.com/"},
    {"name":"Asian Online Journals","url":"http://www.ajouronline.com/"},
    {"name":"Asian Pharma Press","url":"http://www.asianpharmaonline.org/"},
    {"name":"Asian Publication Corporation","url":"http://asianpubs.org/content/"},
    {"name":"Asian Research Consortium","url":"http://www.aijsh.org/?task=index"},
    {"name":"Asian Transactions","url":"http://www.asian-transactions.org/"},
    {"name":"Associated Asia Research Foundation","url":"http://www.aarf.asia/"},
    {"name":"Association for Sustainable Education, Research and Science","url":"http://www.asers.eu/asers-publishing/journals.html"},
    {"name":"Association for Sustainable Education, Research and Science","url":"https://aserspublishing.eu/"},
    {"name":"Association of Computer Electronics and Electrical Engineers","url":"http://www.theaceee.org/"},
    {"name":"Association of North America Higher Education International","url":"http://anahei.org/"},
    {"name":"Aster Publications","url":"http://asterpublications.org/"},
    {"name":"AstonJournals","url":"http://astonjournals.com/"},
    {"name":"Athal Press & Media","url":"http://www.athalgroup.com/Athal-Press-and-Media.aspx"},
    {"name":"Atharva Scientific Publications","url":"http://www.atharvapub.com/HomePage/"},
    {"name":"Athens Institute for Education and Research","url":"http://www.atiner.gr/"},
    {"name":"Atlas Publishing, LP","url":"http://www.atlas-publishing.org/index.php"},
    {"name":"Aufau Periodicals","url":"http://www.chesci.com/"},
    {"name":"Austin Publishing Group","url":"http://austinpublishinggroup.org/"},
    {"name":"Australasian Centre for Research and Development","url":"http://www.acrd.net.au/"},
    {"name":"Australian Academy of Business and Social Sciences","url":"http://www.aabss.org.au/"},
    {"name":"Australian Academy of Business Leadership","url":"http://aabl.com.au/"},
    {"name":"Australian International Academic Centre Pty. Ltd.","url":"http://www.aiac.org.au/"},
    {"name":"Australian International Research Consortium","url":"http://www.ausinternationaljournals.com.au/"},
    {"name":"Australian Society for Commerce Industry & Engineering","url":"http://www.scie.org.au/"},
    {"name":"Austrian E-Journals of Universal Scientific Organization","url":"http://www.aeuso.org/"},
    {"name":"Austrian Scientific Publication House","url":"http://www.autpub.org/MWP/"},
    {"name":"Avanti Publishers.com","url":"http://www.avantipublishers.com/"},
    {"name":"Avens Publishing Group","url":"http://www.avensonline.org/"},
    {"name":"Avestia Publishing","url":"http://avestia.com/"},
    {"name":"Avicena Publisher","url":"http://www.avicenapublisher.org/"},
    {"name":"Avid Science","url":"http://avidscience.com/"},
    {"name":"Axis Journals","url":"http://www.axisjournals.com/"},
    {"name":"Baishideng Publishing Group","url":"http://www.wjgnet.com/"},
    {"name":"Basha Research Corporation","url":"http://basharesearch.com/journals.htm"},
    {"name":"Basic Research Journals","url":"http://basicresearchjournals.org/index.html"},
    {"name":"Bell Press","url":"http://bellpress.org/"},
    {"name":"Bentham Open","url":"http://benthamopen.com/"},
    {"name":"Best Journals","url":"http://www.bestjournals.in/index.php"},
    {"name":"Better Advances Press","url":"http://www.bapress.ca/index.html"},
    {"name":"Betty Jones & Sisters Publishing","url":"http://bettyjonespub.com/"},
    {"name":"Binary Information Press","url":"http://www.1010press.com/"},
    {"name":"Bio Accent","url":"http://bioaccent.org/"},
    {"name":"Bio Core","url":"http://biocoreopen.org/index.php"},
    {"name":"Bioflux Society","url":"http://www.bioflux.com.ro/"},
    {"name":"Biohelikon","url":"http://www.biohelikon.org/"},
    {"name":"Biohouse Publishing Group","url":"http://biohouse.us/"},
    {"name":"BioInfo Publications","url":"http://www.bioinfopublication.org/"},
    {"name":"BioIT international Journals ","url":"http://bipublication.com/index.html"},
    {"name":"Biological and Chemical Publishing","url":"http://www.bacpl.org/"},
    {"name":"BioMed Press","url":"http://www.biomedpress.org/"},
    {"name":"BioMed Research","url":"http://bmrjournals.com/Home/Index"},
    {"name":"BioMedSciDirect Publications","url":"http://www.biomedscidirect.com/aboutjournal.php"},
    {"name":"BioPublisher","url":"http://biopublisher.ca/"},
    {"name":"Bioscience Research & Educational Institute","url":"http://www.bret.ac.in/"},
    {"name":"Blaze Journals","url":"http://blazejournals.org/index.php"},
    {"name":"Blue Apple Publications","url":"http://www.blue-ap.org/"},
    {"name":"Blue Eyes Intelligence Engineering & Sciences Publication","url":"http://blueeyesintelligence.org/"},
    {"name":"Blue Ocean Research Journal","url":"http://www.borjournals.com/"},
    {"name":"BluePen Journals","url":"http://www.bluepenjournals.org/"},
    {"name":"Bonfring","url":"http://www.bonfring.org/"},
    {"name":"Bowen Publishing","url":"http://www.bowenpublishing.com/"},
    {"name":"Brainy Buzz","url":"http://brainybuzz.in/"},
    {"name":"Bret Research Journals","url":"http://www.bretj.com/"},
    {"name":"British Association of Academic Research","url":"http://www.bjmhs.baar.org.uk/"},
    {"name":"British Journal","url":"http://www.bjournal.co.uk/"},
    {"name":"British Open Research Publications","url":"http://www.borpub.com/index.php"},
    {"name":"BRNSS Publication Hub","url":"http://brnsspublicationhub.org/"},
    {"name":"Business Journalz","url":"http://www.businessjournalz.org/"},
    {"name":"Business Management Centre","url":"http://www.bizmanagementcentre.com/"},
    {"name":"Cafet Innova Technical Society","url":"http://cafetinnova.org/"},
    {"name":"Cairo Center for Development Benchmarking","url":"http://cdbenchmark.com/publishing"},
    {"name":"Canadian Academy of Oriental and Occidental Culture","url":"http://cscanada.net/"},
    {"name":"CSCanada","url":"http://cscanada.net/"},
    {"name":"Canadian Center of Science and Education","url":"http://ccsenet.org/"},
    {"name":"Canadian Research & Development Center of Sciences and Cultures","url":"http://cscanada.net/"},
    {"name":"Canadian Research Publication","url":"http://www.crpub.com/index.php"},
    {"name":"Canadian Science and Research Group","url":"http://www.cansrg.com/"},
    {"name":"Canadian Science and Technology Press Inc.","url":"http://canadianstpress.com/ojs/index.php"},
    {"name":"Cardiology Academic Press","url":"http://cardiologyacademicpress.com/"},
    {"name":"CARI Journals","url":"http://www.carijournals.org/"},
    {"name":"Cenetri Publishing Group","url":"https://www.cenetrionline.org/"},
    {"name":"Center for Enhancing Knowledge","url":"http://www.cekinfo.org.uk/"},
    {"name":"Center for Global Research Development","url":"http://www.cgrd.org/"},
    {"name":"The Center for Innovations in Business & Management Practice","url":"http://www.cibmp.org/"},
    {"name":"Center for Natural Science & Engineering Research","url":"http://cennser.org/"},
    {"name":"Center for Promoting Ideas","url":"http://www.cpinet.info/"},
    {"name":"Center for the Development and Dissemination of Knowledge","url":"http://www.cddk.org/index.html"},
    {"name":"Center of Advanced Scientific Research and Publications","url":"http://casrp.co.uk/"},
    {"name":"Central Bohemia University Publishing","url":"http://journals.cz/"},
    {"name":"Central Research Insight","url":"http://cri.ideainfinity.pk/?p=1"},
    {"name":"Centre For Info Bio Technology","url":"http://www.cibtech.org/index.htm"},
    {"name":"Centre for Multidisciplinary Research, Innovation and Collaboration","url":"http://www.c-mric.org/"},
    {"name":"Centre for Promoting Knowledge","url":"http://www.ijsrit.com/page.php?cat=25"},
    {"name":"Centre of Excellence for Scientific & Research Journalism ","url":"http://www.centreofexcellence.net/"},
    {"name":"Centre of Promoting Research Excellence","url":"http://cprenet.com/home/"},
    {"name":"CESER Publications","url":"http://www.ceser.in/"},
    {"name":"CESER Publications","url":"http://ceserpublications.com/"},
    {"name":"Chitkara University Publications","url":"http://www.chitkara.edu.in/publications/journals/"},
    {"name":"CIRWORLD","url":"https://cirworld.com/"},
    {"name":"CIRWORLD","url":"https://cirworld.com/cir/"},
    {"name":"Clerisy Publishers","url":"http://clerisyonlinepublishers.org/"},
    {"name":"ClinMed International Library","url":"http://clinmedjournals.org/"},
    {"name":"Cloud Journals","url":"http://cloud-journals.com/"},
    {"name":"Cloud Publications","url":"http://www.cloudpublications.org/"},
    {"name":"The Clute Institute","url":"http://www.cluteinstitute.com/"},
    {"name":"Clyto Access","url":"http://www.clytoaccess.com/"},
    {"name":"Coltharp Institute","url":"http://www.coltharpinstitute.com/"},
    {"name":"Columbia International Publishing","url":"http://www.uscip.org/"},
    {"name":"Comparative Journals","url":"http://comparativejournals.org/index.php/index"},
    {"name":"Comprehensive Research Journals","url":"https://comprehensiveresearchjournals.org/"},
    {"name":"Computer Science Journals","url":"http://www.cscjournals.org/"},
    {"name":"CONFAB Journals","url":"http://www.confabjournals.com/"},
    {"name":"Congress Press","url":"http://www.congresspress.com/Journals/index.php/index/index"},
    {"name":"CONSORTIUM Intellectual Consortium of Drug Discovery and Technology Development, Inc.","url":"http://www.icdtdi.ca/home.html"},
    {"name":"Contemporary Research Center","url":"http://www.ijern.com/index.php"},
    {"name":"Convergence Information Society","url":"http://www.globalcis.org/eng/"},
    {"name":"Cosmic Journals","url":"http://cosmicjournals.com/"},
    {"name":"Cosmos Scholars Publishing House","url":"http://www.cosmosscholars.com/"},
    {"name":"Council for Innovative Research","url":"http://www.cirworld.net/"},
    {"name":"CRDEEP International Journals","url":"http://www.crdeep.com/"},
    {"name":"Cresco Online Publishing","url":"http://crescopublications.org/"},
    {"name":"Cresco Online Publishing","url":"http://crescoonline.org/"},
    {"name":"CREST Journals","url":"http://www.crestjournals.com/"},
    {"name":"Crown Journals","url":"http://www.crownjournals.org/"},
    {"name":"CSCanada","url":"http://cscanada.net/"},
    {"name":"CTR Publications","url":"http://tcrjournals.com/index.php"},
    {"name":"Current Research Web","url":"http://www.curresweb.com/"},
    {"name":"Cyber Journals","url":"http://www.cyberjournals.com/"},
    {"name":"DAMA International","url":"http://www.sciencejournal.in/home/"},
    {"name":"Darsgah-e-Ahlebait","url":"http://darsgah-e-ahlebait.com/journals.php"},
    {"name":"Darshan Publishers","url":"http://darshanpublishers.com/index.html"},
    {"name":"David Publishing","url":"http://www.davidpublishing.com/"},
    {"name":"David Publishing","url":"http://www.davidpublisher.com/"},
    {"name":"Deccan Pharma Journals","url":"http://www.deccanpharmajournals.com/"},
    {"name":"DeNovo Scientific Publishing","url":"http://www.denovojournal.com/"},
    {"name":"Dentamed Publishing","url":"http://www.dentamedpublishing.com/"},
    {"name":"Design for Scientific Renaissance","url":"http://www.sign-ific-ance.co.uk/index.html"},
    {"name":"DEStech Publications, Inc.","url":"http://www.destechpub.com/"},
    {"name":"Developing Country Think Tank Institute","url":"http://dcthink.org/"},
    {"name":"Dhan Med Publishers","url":"http://www.dhanmedpublishers.com/"},
    {"name":"Didactic Journals","url":"http://didacticjournals.org/"},
    {"name":"Digital Information Research Foundation","url":"http://www.dirf.org/"},
    {"name":"Digital Science Press","url":"http://dscipress.com/"},
    {"name":"Direct Research Journals","url":"http://directresearchpublisher.org/"},
    {"name":"DISA Publication Group","url":"http://www.disa.org.in/DPGroup/index.html"},
    {"name":"Discourse Journals","url":"http://www.resjournals.org/"},
    {"name":"Discovery Publication","url":"http://discoveryjournals.com/"},
    {"name":"DJ Publications","url":"http://www.djjames.org/"},
    {"name":"Donnish Journals","url":"http://donnishjournals.org/"},
    {"name":"Dorma Journals","url":"http://www.dormaj.com/"},
    {"name":"Dr.BGR Publications","url":"http://www.drbgrpublications.in/"},
    {"name":"DRUNPP Sarajevo","url":"http://www.drunpp.ba/"},
    {"name":"Dynamic Publishers","url":"http://www.dynamicpublishers.org/journals/index.php/index"},
    {"name":"e-Century Publishing Corporation","url":"http://www.e-century.org/"},
    {"name":"E-Cronicon","url":"https://www.ecronicon.com/"},
    {"name":"e-journal","url":"http://worldresearchjournals.com/"},
    {"name":"e-Science Central","url":"http://esciencecentral.org/"},
    {"name":"e3Journals","url":"http://www.e3journals.org/index.php"},
    {"name":"Eagle Publishing Group","url":"http://eaglegp.org/"},
    {"name":"Earth Journals","url":"http://www.earthjournals.org/"},
    {"name":"“East West” Association For Advanced Studies and Higher Education","url":"http://ew-a.org/"},
    {"name":"Ebioscholar","url":"http://ebioscholar.com/ojs/index.php/index/index"},
    {"name":"Ebu Press","url":"http://www.ebupress.com/"},
    {"name":"eCanadian Journals","url":"http://www.ecanadianjournals.com/ecanadian/"},
    {"name":"The Economics and Social Development Organization","url":"http://www.tesdo.org/Default.aspx"},
    {"name":"Edelweiss Publications","url":"http://edelweisspublications.com/edelweiss/frontend/index.php"},
    {"name":"EDUGAIT Press","url":"http://www.edugait.com/"},
    {"name":"E-International Journals of Academic & Scientific Research","url":"http://eijasr.com/index.php"},
    {"name":"E-International Scientific Research Journal Consortium","url":"http://www.eisrjc.com/"},
    {"name":"Eighth Sense Research Group","url":"http://www.internationaljournalesrg.org/"},
    {"name":"Einstein International Journal Organization","url":"http://www.eijo.in/"},
    {"name":"EISRJC Journals","url":"http://www.eisrjc.com/"},
    {"name":"eJM","url":"http://www.ejmscience.com/journals/"},
    {"name":"eJM","url":"https://www.ejmanager.com/"},
    {"name":"eJM Science","url":"https://www.ejmanager.com/"},
    {"name":"eJManager","url":"https://www.ejmanager.com/"},
    {"name":"eJournals of Academic Research & Reviews","url":"http://www.ejarr.com/"},
    {"name":"Eko Journal","url":"http://www.ekojournal.com/"},
    {"name":"eLearning Institute","url":"http://www.theelearninginstitute.org/"},
    {"name":"Electronic Center for International Scientific Information","url":"http://ecisi.com/"},
    {"name":"Elewa Bio Sciences","url":"http://www.m.elewa.org/index.php"},
    {"name":"Elite Hall Publishing House","url":"http://elitehall.elitehall.com/"},
    {"name":"Elite Research Journals","url":"http://www.eliteresearchjournals.org/"},
    {"name":"ELK Asia Pacific Journals","url":"http://www.elkjournals.com/"},
    {"name":"ElmCore Journals","url":"http://www.science-fellows.org/"},
    {"name":"Elmer Press","url":"http://www.elmerpress.com/"},
    {"name":"ELVEDIT.COM","url":"http://elvedit.com/"},
    {"name":"Elyns Publishing Group","url":"http://www.elynsgroup.com/Default.aspx"},
    {"name":"Emerging Academy Resources","url":"http://www.emergingresource.org/index.html"},
    {"name":"Engineering and Technology Publishing","url":"http://etpub.com/"},
    {"name":"Engineering Journals","url":"http://www.enggjournals.com/"},
    {"name":"Engineering Publication House","url":"http://ephjournal.com/"},
    {"name":"Engineering Research Publication","url":"https://www.erpublication.org/"},
    {"name":"Enhanced Research Publications","url":"http://www.erpublications.com/"},
    {"name":"Enliven Archive","url":"http://www.enlivenarchive.org/"},
    {"name":"Enriched Science Publication","url":"http://www.printjournals.com/"},
    {"name":"ERM Publications","url":"http://www.researchersworld.com/ermp.html"},
    {"name":"EPH Journal","url":"http://ephjournal.com/"},
    {"name":"EPIX PUB","url":"http://epixpub.com/"},
    {"name":"EPRA Journals","url":"http://eprajournals.com/"},
    {"name":"EPRA Wisdom","url":"http://eprawisdom.com/"},
    {"name":"Erudite Journals Limited","url":"http://eruditejournals.org/ejb/index.htm"},
    {"name":"ESRSA Publication ","url":"http://www.esrsa.org/"},
    {"name":"ESci Journals Publishing","url":"http://www.escijournals.net/"},
    {"name":"eScience Publisher","url":"http://escipub.com/"},
    {"name":"ETA Maths Journals","url":"http://etamaths.com/"},
    {"name":"Ethan Publishing Company","url":"http://www.ethanpublishing.com/"},
    {"name":"Eurasian Academy of Sciences","url":"http://eurasianacademy.org/"},
    {"name":"Eurasian Research Publishing","url":"http://www.erepub.com/"},
    {"name":"Eurasian Union of Scientists","url":"http://euroasia-science.ru/en/about/"},
    {"name":"Euro Asia Research and Development Association","url":"http://www.euroasiapub.org/"},
    {"name":"EuroJournals","url":"http://eurojournals.com/"},
    {"name":"European-American Journals","url":"http://ea-journals.org/index.php"},
    {"name":"European-American Journals","url":"http://www.eajournals.org/"},
    {"name":"European Center for Science Education and Research","url":"http://euser.org/"},
    {"name":"European Journals of Business Management","url":"http://www.ejobm.org/"},
    {"name":"European Journals of Education Studies","url":"http://oapub.org/edu/index.php/index"},
    {"name":"The European Scientific Community","url":"http://europe-science.com/en/"},
    {"name":"European Union Research Publishing","url":"http://www.eurpub.com/"},
    {"name":"Everant","url":"http://everant.in/"},
    {"name":"EverScience Publications","url":"http://www.everscience.org/index.html"},
    {"name":"ExcelingTech Publishing Company, Ltd.","url":"http://ojs.excelingtech.co.uk/"},
    {"name":"Excellent Publishers","url":"http://www.excellentpublishers.com/"},
    {"name":"Excellent Word Journals","url":"http://www.excellentwordjournals.org/index.html"},
    {"name":"Excelytics Publishers","url":"http://excelyticspublishers.com/"},
    {"name":"Expert Journals","url":"http://www.expertjournals.com/"},
    {"name":"Far East Research Centre","url":"http://www.fareastjournals.com/"},
    {"name":"Ficus Publishers","url":"http://ficuspublishers.com/Home.php"},
    {"name":"Finlogy","url":"http://onlinejournal.in/"},
    {"name":"Focus in Research & Education","url":"http://firepubs.com/index.php"},
    {"name":"Foundation for Promotion of Basic & Applied Science","url":"http://www.fopras.org/"},
    {"name":"Friends Science Publishers","url":"http://www.fspublishers.org/index.php"},
    {"name":"Frontiers","url":"http://www.frontiersin.org/"},
    {"name":"Frontiers in Bioscience","url":"https://www.bioscience.org/"},
    {"name":"FSSH Scholarly Journals","url":"http://fssh-journal.org/"},
    {"name":"Fundamental Journals","url":"http://fundamentaljournals.org/"},
    {"name":"Fundamental Research and Development International","url":"http://frdint.com/index.html"},
    {"name":"Future Academy","url":"http://www.futureacademy.org.uk/"},
    {"name":"Galore Knowledge Publication Pvt. Ltd.","url":"http://www.gkpublication.in/"},
    {"name":"Gatha Cognition","url":"http://www.gathacognition.com/"},
    {"name":"Gavin Publishers","url":"http://gavinpublishers.org/"},
    {"name":"GBS Publishers & Distributors (India)","url":"http://www.gbspublisher.com/"},
    {"name":"Genexcellence Publication","url":"http://gpublication.com/"},
    {"name":"German Science and Technology Press","url":"http://grsci-techpress.org/"},
    {"name":"Gexin Publications","url":"http://gexinonline.com/"},
    {"name":"Global Academic Institute","url":"http://www.globalacademicinstitute.com/"},
    {"name":"Global Advanced Research Journals","url":"http://garj.org/"},
    {"name":"Global Business Research Journals","url":"http://www.globalbizresearch.org/index.php"},
    {"name":"Global Institute for Research and Education","url":"http://www.gifre.org/"},
    {"name":"Global International Scientific Analytical Project","url":"http://iashe.eu/en/periodicals-journals-academy"},
    {"name":"International Academy of Science and Higher Education","url":"http://iashe.eu/en/periodicals-journals-academy"},
    {"name":"The Global Journals","url":"http://www.paripex.in/"},
    {"name":"Global Journals, Inc. (US)","url":"http://globaljournals.us/"},
    {"name":"Global Journals","url":"https://globaljournals.org/"},
    {"name":"Global Journal of Science Research","url":"https://journalofscience.org/"},
    {"name":"Global Open Journals","url":"http://globalopenjournals.org/"},
    {"name":"Global Openaccess","url":"http://globalopenaccess.com/"},
    {"name":"Global Publishing Corporation","url":"http://gpcpublishing.com/"},
    {"name":"Global Research Journals","url":"http://www.globalresearchjournals.org/"},
    {"name":"Global Research Online","url":"http://www.globalresearchonline.net/"},
    {"name":"Global Research Publishing","url":"http://www.grpjournal.org/"},
    {"name":"Global Researchers Journals","url":"http://www.grjournals.com/"},
    {"name":"Global Scholars Journals","url":"http://www.globalscholarsjournals.org/"},
    {"name":"Global Science Center LP","url":"http://european-science.org/en/"},
    {"name":"Global Science Publishing Group","url":"http://globalsciencepg.org/"},
    {"name":"Global Science Research Journals","url":"http://globalscienceresearchjournals.org/"},
    {"name":"Global Scientific, Inc.","url":"http://globalpublication.org/index.html"},
    {"name":"Global Scientific Research Journals","url":"http://www.gsrjournals.com/"},
    {"name":"Global Society of Scientific Research and Researchers","url":"http://gssrr.org/index.php?journal=gssrr&page=index"},
    {"name":"Global Technocrats & Intellectual’s Association","url":"http://www.gtia.co.in/"},
    {"name":"GlobalSkope Publishing Society","url":"http://globalskope.com/ijesr/index.html"},
    {"name":"Gnosis Open Access Publishers","url":"http://www.gnosisoa.org/"},
    {"name":"Gratis Open Access Publishers","url":"http://www.gratisoa.org/"},
    {"name":"Gopalax","url":"http://www.ijcns.com/"},
    {"name":"GRABS Educational Charitable Trust","url":"http://grabstrust.com/"},
    {"name":"Grant Medical Journals","url":"http://grantmedicaljournals.org/"},
    {"name":"Graphy Publications","url":"http://www.graphyonline.com/index.php"},
    {"name":"Gratis Open Access Publishers","url":"http://www.gratisoa.org/"},
    {"name":"GRDS Publishing","url":"http://grdspublishing.org/"},
    {"name":"Green Earth Research Network","url":"http://www.gejournal.net/index.html"},
    {"name":"Green Global Foundation","url":"http://www.ggfagro.com/"},
    {"name":"Greener Journals","url":"http://www.gjournals.org/"},
    {"name":"Greenfield Advanced Research Publishing House","url":"http://www.garph.co.uk/index.html"},
    {"name":"GS Publishers","url":"http://www.gspublishers.com/"},
    {"name":"GSB Life Sciences","url":"http://gsblifesciences.org/index.php"},
    {"name":"Gurpukur Research Institute","url":"http://gscience.gurpukur.com/"},
    {"name":"Gyancity Research Lab Private Limited","url":"http://gyancity.com/"},
    {"name":"Halmac Research","url":"http://www.halmacresearch.org/"},
    {"name":"Hans Publishers, Inc.","url":"http://www.hanspub.org/"},
    {"name":"Har Krishan Bhalla & Sons","url":"http://hkbpublications.com/"},
    {"name":"Heighten Science Publications","url":"http://www.heighpubs.com/"},
    {"name":"Helics Scientific Network","url":"http://helicsonline.net/"},
    {"name":"Hendun Research Access","url":"http://www.hendun.org/"},
    {"name":"Henry Publishing Group","url":"http://www.henrypublishinggroup.com/"},
    {"name":"Herald International Research Journals","url":"http://heraldjournals.org/index.htm"},
    {"name":"Herald Scholarly Open Access","url":"http://www.heraldopenaccess.us/"},
    {"name":"Herbert Open Access Journals","url":"http://www.hoajonline.com/"},
    {"name":"Hikari Ltd.","url":"http://www.m-hikari.com/"},
    {"name":"Hilaris","url":"http://www.e-hilaris.com/index.html"},
    {"name":"Hind Agri-Horticultural Society","url":"http://www.researchjournal.co.in/index.html"},
    {"name":"Horizon Journals","url":"http://www.horizonjournals.org/"},
    {"name":"Horizon Research Publishing","url":"http://www.hrpub.org/"},
    {"name":"Human and Sciences Publications","url":"http://www.humanpub.org/"},
    {"name":"Human Resource Management Academic Research Society","url":"http://hrmars.com/index.php?page=our%20journals%20f"},
    {"name":"i-Explore International Research Journals Consortium","url":"http://www.irjcjournals.org/"},
    {"name":"IAMURE Multidisciplinary Research","url":"http://www.iamure.com/"},
    {"name":"ibai-publishing","url":"http://ibai-publishing.org/"},
    {"name":"IBIMA Publishing","url":"http://www.ibimapublishing.com/"},
    {"name":"ICGST","url":"http://www.icgst.com/"},
    {"name":"iConcept Press Ltd.","url":"https://www.iconceptpress.com/"},
    {"name":"ICTACT Journal","url":"http://www.ictactjournals.in/index.aspx"},
    {"name":"Id Press / ID Design","url":"http://www.id-press.eu/"},
    {"name":"IERI & PRESS","url":"http://www.ieripress.com/"},
    {"name":"IGM Publication","url":"http://igmpublication.org/index.html"},
    {"name":"IIARD Publication Company","url":"http://www.iiardonline.org/"},
    {"name":"iJARS Group","url":"http://www.ijarsgroup.com/"},
    {"name":"Ijbsse.org","url":"http://ijbsse.org/"},
    {"name":"ijManager – Online Journal Management","url":"http://www.ijmanager.org/"},
    {"name":"IJRCM","url":"http://ijrcm.org.in/"},
    {"name":"IMED Research Publications","url":"http://www.ijmhr.org/index.html"},
    {"name":"iMedPharm","url":"http://www.imedpharm.com/"},
    {"name":"iMed.pub","url":"http://imed.pub/"},
    {"name":"Impact Journals","url":"http://www.impactjournals.com/"},
    {"name":"Impact Journals","url":"http://www.impactjournals.us/index.php"},
    {"name":"Imperial Journals","url":"http://www.imperialjournals.com/"},
    {"name":"Imprints Open Access","url":"http://imprintsonline.org/index.php"},
    {"name":"Indian Academicians and Researchers Association","url":"http://iaraedu.com/"},
    {"name":"Indian Society for Education and Environment","url":"http://www.iseeadyar.org/"},
    {"name":"IndianResearchJournals.Com","url":"http://indianresearchjournals.com/Default.aspx"},
    {"name":"Indus Foundation for Education, Research & Social Welfare","url":"http://www.indusedu.org/"},
    {"name":"Infinity Press","url":"http://infinitypress.info/publisher/"},
    {"name":"infofacility","url":"http://www.infofacility.com/journals"},
    {"name":"Infonomics Society","url":"http://infonomics-society.org/"},
    {"name":"Inforesights Publishing","url":"http://inforesights.com/"},
    {"name":"Informatics Journals","url":"http://www.informaticsjournals.com/"},
    {"name":"Information Engineering Research Institute","url":"http://www.ier-institute.org/index.htm"},
    {"name":"Ingenious Enterprises International","url":"http://ingenin.org/"},
    {"name":"Innovare Academic Sciences","url":"http://innovareacademics.in/"},
    {"name":"Innovational Publishers","url":"http://www.innovationalpublishers.com/"},
    {"name":"Innovative Journals","url":"http://www.innovativejournal.in/"},
    {"name":"Innovative Publication","url":"http://www.innovativepublication.com/"},
    {"name":"Innovative Space of Scientific Research","url":"http://www.issr-journals.org/"},
    {"name":"Innovinc","url":"http://innovinc.org/"},
    {"name":"INPRESSCO","url":"http://inpressco.com/"},
    {"name":"INREWI","url":"http://www.inrewi.com/home"},
    {"name":"Ishaan Publishing House","url":"http://www.iphsci.com/index.html"},
    {"name":"Insight Core","url":"http://www.insightcore.com/"},
    {"name":"Insight Knowledge","url":"http://insightknowledge.co.uk/index.php"},
    {"name":"Insight Knowledge","url":"https://insightknowledge.org/"},
    {"name":"Insight Medical Publishing","url":"http://imedpub.com/"},
    {"name":"Instaci","url":"http://www.instascijournals.info/index.php"},
    {"name":"The Institute for Business and Finance Research","url":"http://www.theibfr.com/"},
    {"name":"Institute for Research and Development India","url":"http://www.irdindia.in/"},
    {"name":"Institute of Advanced Scientific Research","url":"http://www.i-asr.com/journals.aspx"},
    {"name":"Institute of Doctors Engineers and Scientists","url":"http://www.theides.org/"},
    {"name":"Institute of Electronic & Information Technology","url":"http://www.ieit-web.org/apscj/editorialboard.html"},
    {"name":"Institute of Integrative Omics and Applied Biotechnology","url":"http://iioab.webs.com/researchandpublications.htm"},
    {"name":"Institute of Language and Communication Studies","url":"http://www.inlcs.org/"},
    {"name":"Institute of Research Advances","url":"http://www.research-advances.org/"},
    {"name":"Institute of Research and Journals","url":"http://iraj.in/index.php"},
    {"name":"Institute of Research Engineers and Doctors ","url":"http://www.theired.org/"},
    {"name":"Institute of Research Engineers and Scientists","url":"http://theires.org/"},
    {"name":"Institute of Research In Engineering and Technology","url":"http://www.iret.co.in/index.html"},
    {"name":"Institute of Strategic and International Studies","url":"http://www.isisworld.org/"},
    {"name":"InTechOpen ","url":"http://www.intechweb.org/"},
    {"name":"InTechOpen ","url":"http://www.intechopen.com/"},
    {"name":"Integrated Academic Journals","url":"http://www.intergratedjournals.org/"},
    {"name":"Integrated Intelligent Research","url":"http://iirpublications.com/index.php"},
    {"name":"Integrated Publishing Association","url":"http://www.ipublishing.co.in/"},
    {"name":"Integrated Science Publications","url":"http://indianscience.in/pubs/journals/"},
    {"name":"Intellectual Archive","url":"http://www.intellectualarchive.com/"},
    {"name":"Intercontinental Management Research Review","url":"http://icmrr.org/index.html"},
    {"name":"Interlink Continental Journals","url":"http://icjpublishers.org/index.php"},
    {"name":"Intermedcentral","url":"http://www.intermedcentral.hk/"},
    {"name":"International Academic Journals","url":"http://www.inacj.com/"},
    {"name":"International Academic Publishing House","url":"http://www.iaph.in/"},
    {"name":"International Academy for Advancement of Business Research","url":"http://www.iaabr.com/"},
    {"name":"International Academy for Science & Technology Education and Research","url":"http://www.iaster.com/index.php"},
    {"name":"International Academy of Arts, Science & Technology","url":"http://iaast.org/"},
    {"name":"International Academy of Business","url":"http://www.intl-academy.org/index.htm"},
    {"name":"International Academy of Business & Economics","url":"http://www.iabe.org/"},
    {"name":"International Academy of Computer & IT Engineering","url":"http://iacite.org/"},
    {"name":"International Academy of Ecology and Environmental Sciences ","url":"http://www.iaees.org/"},
    {"name":"International Academy of Science and Higher Education ","url":"http://iashe.eu/en/periodicals-journals-academy"},
    {"name":"International Academy of Science, Engineering and Technology","url":"http://www.iaset.us/index.php"},
    {"name":"International Academy of Science, Engineering and Technology","url":"http://international-aset.com/index.html"},
    {"name":"International Academy of Science, Technology, Engineering and Management","url":"http://iastem.org/"},
    {"name":"International Academy Publishing","url":"http://www.iap.org/"},
    {"name":"The International Academy, Research and Industry Association","url":"http://www.iaria.org/"},
    {"name":"International Advances for Research","url":"http://www.intlafr.com/index.html"},
    {"name":"International Agency for Development of Culture, Education and Science","url":"http://iadces.com/"},
    {"name":"International Association for Academians","url":"http://www.academians.org/"},
    {"name":"International Association for Engineering & Technology","url":"http://www.iaet.net/"},
    {"name":"International Association for Engineering and Management Education","url":"http://www.iaeme.com/about.asp"},
    {"name":"International Association for Information, Culture, Human and Industry Technology","url":"http://www.aicit.org/publications.html"},
    {"name":"International Association of Computer Science and Information Technology","url":"http://www.iacsit.org/"},
    {"name":"International Association of Advances in Engineering and Technology","url":"http://iaaet.org/"},
    {"name":"International Association of Engineering & Technology Researchers","url":"http://iaetr.org/"},
    {"name":"International Association of Journals & Conferences","url":"http://www.iajc.org/overview.html"},
    {"name":"International Association of Scientific Innovation and Research","url":"http://iasir.net/index.html"},
    {"name":"International Association of Technology Education & Industry","url":"http://iatei.org/"},
    {"name":"International Bauhaus Science Press","url":"http://www.bhssci.com/"},
    {"name":"International Center for Business Research","url":"http://icbr.net/"},
    {"name":"International Centre for Integrated Development Research","url":"http://www.icidr.org/index.php"},
    {"name":"International Centre of Culture Inventory","url":"http://www.icoci.org/"},
    {"name":"International Computer Science and Engineering Society","url":"http://www.i-cses.com/"},
    {"name":"International Conference on Computer Science and Engineering","url":"http://www.icgst.com/"},
    {"name":"International Digital Organization for Scientific Information","url":"http://idosi.org/index.htm"},
    {"name":"International Economics Development and Research Center","url":"http://www.iedrc.org/"},
    {"name":"International Education Research Foundation","url":"http://www.ierfinfo.com/"},
    {"name":"International Educative Research Foundation And Publisher","url":"http://www.publisher.ijier.net/"},
    {"name":"International eJournals","url":"http://internationalejournals.com/"},
    {"name":"International Formulae Group","url":"http://www.ifgdg.org/"},
    {"name":"International Forum of Researchers Students and Academician","url":"http://www.ifrsa.org/"},
    {"name":"International Foundation for Modern Education and Scientific Research","url":"http://infomesr.org/en/home"},
    {"name":"International Foundation for Research and Development","url":"http://www.ifrnd.org/"},
    {"name":"International House for Academic Scientific Research","url":"http://www.ihasr.org/"},
    {"name":"International Indexed Refereed Research Journal","url":"http://www.ssmrae.com/"},
    {"name":"International Information Institute","url":"http://www.information-iii.org/"},
    {"name":"International Institute for Private, Commercial and Competition Law","url":"http://iipccl.org/"},
    {"name":"International Institute for Science, Technology and Education","url":"http://www.iiste.org/Journals/"},
    {"name":"International Institute of Engineers","url":"http://www.iieng.org/journals.php"},
    {"name":"International Institute of Engineers & Researchers","url":"http://theiier.org/Conference/Singapore/1/ICSTEM/publication.php"},
    {"name":"International Institute of Engineers & Researchers","url":"http://theiier.org/"},
    {"name":"International Institute of Informatics and Systemics","url":"http://www.iiis.org/"},
    {"name":"International Institute of Science & Industry Research","url":"http://www.iisir.org/"},
    {"name":"International Invention Journals","url":"http://internationalinventjournals.org/index.html"},
    {"name":"International Journal of College & University","url":"http://ijcu.us/"},
    {"name":"International Journal of Research & Development Organisation","url":"http://www.ijrdo.org/"},
    {"name":"International Journal Publishers Group","url":"http://www.ijpg.org/"},
    {"name":"The International Journal Research Publications","url":"http://www.theinternationaljournal.org/ojs/index1.htm"},
    {"name":"International Journals","url":"https://ijddmr.wordpress.com/"},
    {"name":"International Journals.co.in","url":"http://www.internationaljournals.co.in/titles.aspx"},
    {"name":"International Journals for Research","url":"http://internationaljournalsforresearch.com/index.php"},
    {"name":"International Journals for Research","url":"http://ijrgroup.com/"},
    {"name":"International Journals for Researchers","url":"http://www.ijronline.com/"},
    {"name":"International Journal of Academic Research","url":"http://www.eu-print.org/ilk.php"},
    {"name":"International Journals of Engineering & Sciences","url":"http://www.ijens.org/"},
    {"name":"International Journals of Multi Dimensional Research","url":"http://www.ijmr.net.in/"},
    {"name":"International Journals of Multidisciplinary Research Academy","url":"http://www.ijmra.us/"},
    {"name":"International Journals of N&N Global Technology","url":"http://www.ijnngt.org/index.php"},
    {"name":"International Journals of Research","url":"http://intjr.com/index.php"},
    {"name":"International Journals of Research Papers","url":"http://gssrr.org/"},
    {"name":"International Journals of Sciences and High Technologies","url":"http://ijsht-journals.org/"},
    {"name":"International Journals of Scientific Knowledge","url":"http://www.ijsk.org/"},
    {"name":"International Journals of Scientific Research Publications","url":"http://www.ijsrpub.com/"},
    {"name":"International Journals of Scientific Research","url":"http://ijscience.com/default.htm"},
    {"name":"International Knowledge Press","url":"http://www.ikpresse.com/"},
    {"name":"International Network for Applied Sciences and Technology","url":"http://www.inast.org/"},
    {"name":"International Network for Natural Sciences","url":"http://www.innspub.net/"},
    {"name":"International Network for Scientific & Industrial Information","url":"http://insii.com/index.php"},
    {"name":"International Online Knowledge Services Provider","url":"http://www.ioksp.com/index.html"},
    {"name":"International Online Medical Council","url":"http://www.iomcworld.com/publications.htm"},
    {"name":"International Organization Center of Academic Research","url":"http://www.ocerint.org/index.php/homepage"},
    {"name":"International Organization of Scientific Invention","url":"http://iosi.in/"},
    {"name":"International Organization of Scientific Research","url":"http://iosrjournals.org/index.html"},
    {"name":"International Organization of Scientific Research and Development","url":"http://iosrd.org/"},
    {"name":"International Postgraduate Network","url":"http://www.internationalpostgraduatenetwork.org/"},
    {"name":"International Publisher & C.O","url":"http://ipco-co.com/"},
    {"name":"International Publisher for Advanced Scientific Journals","url":"http://ipasj.org/index.htm"},
    {"name":"International Recognition Multidisciplinary Research Journals, Monthly Publish","url":"http://lsrj.in/"},
    {"name":"International Recognition Research Journals","url":"http://www.lsrj.in/"},
    {"name":"International Research Association of Computer Science, & Technology ","url":"http://www.iracst.org/home.htm"},
    {"name":"International Research E-Journals","url":"http://www.oiirj.org/"},
    {"name":"International Research Group","url":"http://www.irgjournals.org/"},
    {"name":"International Research Journals","url":"http://resjournals.com/"},
    {"name":"International Research Journals ","url":"http://www.interesjournals.org/"},
    {"name":"International Research Organization of Computer Science","url":"http://www.irocsjournals.org/irocs/home.php"},
    {"name":"International Research Publication House","url":"http://www.irphouse.com/"},
    {"name":"International Research Society For Promotion of Science","url":"http://www.inposo.org/"},
    {"name":"International Scholarly Open Access Research","url":"http://internationaljournalofresearch.org/"},
    {"name":"International Scholarly Open Access Research","url":"http://www.isoar.in/"},
    {"name":"Edupedia Publications","url":"https://edupediapublications.org/"},
    {"name":"International Scholars Journals","url":"http://internationalscholarsjournals.org/"},
    {"name":"International Science & Research Journals","url":"http://www.isrjournals.org/"},
    {"name":"International Science and Medical Journals","url":"http://www.isamedjournals.com/"},
    {"name":"International Science Community Association","url":"http://www.isca.in/"},
    {"name":"International Scientific Academic Corporation","url":"http://isacorporation.org.in/"},
    {"name":"International Scientific Academy of Engineering & Technology","url":"http://www.isaet.org/"},
    {"name":"International Scientific Engineering and Research Publications","url":"http://iserp.org/"},
    {"name":"International Scientific Invention Journals","url":"http://isij.in/"},
    {"name":"International Scientific Publications","url":"http://www.scientific-publications.net/"},
    {"name":"International Scientific Research Organization for Science, Engineering and Technology","url":"http://www.isroset.org/"},
    {"name":"International Scientific Research Organization Journals","url":"http://isroj.net/index.php?menu=home"},
    {"name":"International Skill Research Journals","url":"http://acjournal.in/"},
    {"name":"International Society for Engineering Research and Development","url":"http://www.iserd.co/"},
    {"name":"International Society for Engineers and Researchers","url":"http://iser.co/"},
    {"name":"International Society for green.sustainable engineering and management","url":"http://isgsemjournal.blogspot.com/"},
    {"name":"International Society for Zoological Research","url":"http://iszr.org/Jrs/index.php/index/index"},
    {"name":"International Society of Thesis Publication","url":"http://www.istp.org.in/"},
    {"name":"International Society of Universal Research in Sciences","url":"http://www.isurs.org/"},
    {"name":"International Technology Innovation","url":"http://theiti.net/"},
    {"name":"InternationalJournals.co.in","url":"http://internationaljournals.co.in/"},
    {"name":"Internet Scientific Publications","url":"http://www.ispub.com/"},
    {"name":"Interscience Journals","url":"http://interscience.org.uk/"},
    {"name":"Interscience Open Access Journals","url":"http://www.interscience.in/"},
    {"name":"Inter-USE","url":"http://inter-use.com/"},
    {"name":"Intuition Journals","url":"http://intuitionjournals.org/"},
    {"name":"Invention Journals","url":"http://inventionjournals.org/"},
    {"name":"IORE International","url":"http://www.ioreinternational.org/"},
    {"name":"IOS Publishing","url":"http://www.iospublishing.org/"},
    {"name":"International Organization of Scientific Research","url":"http://iosrjournals.org/index.html"},
    {"name":"iProbe","url":"https://www.iprobegrp.com/"},
    {"name":"Ira Publications","url":"http://www.irapub.com/"},
    {"name":"IRED International Journals","url":"http://theired.org/organizer.html"},
    {"name":"IRO Journals","url":"http://irojournals.com/index.html"},
    {"name":"IROSSS","url":"http://www.irosss.org/"},
    {"name":"Isaac Scientific Publishing","url":"http://www.isaacpub.org/Home.aspx"},
    {"name":"iSER Publications","url":"http://iserjournals.com/"},
    {"name":"Ishitv Technologies","url":"http://ishitvtech.in/#"},
    {"name":"ISISnet","url":"http://www.isisn.org/"},
    {"name":"Islamic World Network for Environmental Science and Technology","url":"http://www.iwnest.com/index.html"},
    {"name":"ISPACS","url":"http://ispacs.com/"},
    {"name":"Ivy Union Publishing","url":"http://ivyunion.org/"},
    {"name":"Jabalpur Management Association","url":"http://jabalpurmanagementassociation.co.in/Journals.aspx"},
    {"name":"Jacobs Publishers","url":"http://www.jacobspublishers.com/index.php"},
    {"name":"JACS Directory","url":"http://jacsdirectory.com/jacs/index.php"},
    {"name":"Jaypee Journals","url":"http://jaypeejournals.com/"},
    {"name":"JET Publishing","url":"http://www.jetpublishing.org/index.html"},
    {"name":"Journals of Scientifics R&D","url":"http://journals-of-scientifcs-rd.com/"},
    {"name":"Joseph Publishing Group","url":"http://www.josephpublishinggroup.com/"},
    {"name":"Journal Dynamics","url":"http://www.journaldynamics.org/"},
    {"name":"Journal Issues","url":"http://www.journalissues.org/index.php"},
    {"name":"Journal Network","url":"http://www.journalnetwork.org/"},
    {"name":"Journal of Comprehensive Research","url":"http://jupapadoc.startlogic.com/compresearch/"},
    {"name":"Journal of Harmonized Research Publications","url":"http://www.johronline.com/"},
    {"name":"Journal of The International Association of Advanced Technology and Science","url":"http://www.jiaats.com/index.php"},
    {"name":"Journals Club & Co.","url":"https://journalsclub.com/"},
    {"name":"Journals Pub","url":"http://www.journalspub.com/"},
    {"name":"JournalsBank","url":"http://www.journalsbank.com/"},
    {"name":"JScholar Journals","url":"http://www.jscholaronline.org/list-of-journals.php"},
    {"name":"JSciMed Central","url":"http://www.jscimedcentral.com/"},
    {"name":"July Press","url":"http://julypress.com/"},
    {"name":"Juniper Publishers","url":"http://juniperpublishers.com/"},
    {"name":"Jyoti Academic Press","url":"http://jyotiacademicpress.net/"},
    {"name":"KAAV Publications","url":"http://www.kaavpublications.org/"},
    {"name":"Kaleidoscope Journals","url":"http://www.kjournals.org/"},
    {"name":"KambohWell Publisher Enterprises","url":"http://www.kwpublisher.com/"},
    {"name":"Kamla Raj Enterprises","url":"http://www.krepublishers.com/KRE-New-J/index.html"},
    {"name":"KEI Journals","url":"http://www.journals.ke-i.org/index.php/index/index"},
    {"name":"KEJA Publications","url":"http://www.kejapub.com/"},
    {"name":"Kenkyu Group","url":"http://www.kenkyuonline.org/"},
    {"name":"Key Research Journals","url":"http://www.keyresearchjournals.org/"},
    {"name":"Kiban Research Publications","url":"http://kibanresearchpublications.com/index.html"},
    {"name":"Kindi Publication","url":"http://www.kindipublication.com/home.html"},
    {"name":"Knowledge Publishing Printing & Distribution House","url":"http://www.knowledgepublishinghouse.com/index.html"},
    {"name":"Knowledgebase Publishers","url":"http://www.knowledgebasepublishers.org/"},
    {"name":"KnowledgeCuddle Publication","url":"http://www.knowledgecuddle.com/"},
    {"name":"KnowledgesPublisher","url":"http://www.knowledgespublisher.com/"},
    {"name":"Knowledgia Scientific","url":"http://www.knowledgia.net/"},
    {"name":"Kogaion Publishing Center","url":"http://euacademic.org/"},
    {"name":"Kowsar Publishing","url":"http://kowsarpub.com/en/"},
    {"name":"Kozmenko Science Publishing","url":"http://www.kozmenkopublishing.com/"},
    {"name":"Krishi Sanskriti","url":"http://www.krishisanskriti.org/Jounrals.php?title=Journals"},
    {"name":"KSP Journals","url":"http://kspjournals.org/"},
    {"name":"KY Publications","url":"http://www.kypublications.com/"},
    {"name":"Ladder Publishing House","url":"http://www.ladderpublishers.org/"},
    {"name":"Landmark Research Journals","url":"http://www.landmarkresearchjournals.org/lrjbme/index.php"},
    {"name":"LAR","url":"http://www.thelar.org/"},
    {"name":"Lawarence Press","url":"http://lawarencepress.com/"},
    {"name":"Lecolink Research Journals","url":"http://www.lecolinkresearchjournals.org/index.php"},
    {"name":"Lectito Journals","url":"http://www.lectitojournals.com/"},
    {"name":"Leena & Luna International","url":"http://www.ajssh.leena-luna.co.jp/"},
    {"name":"Lexis Publisher","url":"http://lexispublisher.com/index.html"},
    {"name":"Library of Academic Resources","url":"http://thelar.ca/"},
    {"name":"Lifescience Global","url":"http://www.lifescienceglobal.com/"},
    {"name":"LifeSciFeed Ventures","url":"http://www.lifescifeed.com/index.htm"},
    {"name":"Lighthouse Journal Publication","url":"http://www.lighthousejournals.org/index.php"},
    {"name":"Literati Scientific and Publishers","url":"http://literatipublishers.com/Journal/index.html"},
    {"name":"London Journals Press","url":"http://journalspress.com/"},
    {"name":"Longbridge Publishing Company","url":"http://www.lbrpublishing.com/"},
    {"name":"Look Academic Publishers","url":"http://lookacademy.nl/"},
    {"name":"Lorem Journals","url":"http://loremjournals.com/index.php"},
    {"name":"Macoctagon Journals","url":"http://www.macoctagonjournals.org/"},
    {"name":"macroJournals","url":"http://macrojournals.com/home"},
    {"name":"Macrothink Institute","url":"http://www.macrothink.org/"},
    {"name":"MacroWorld","url":"http://www.macroworldpub.com/"},
    {"name":"Madridge Publishers","url":"http://madridge.org/"},
    {"name":"Mainspringer","url":"http://mainspringer.com/pub_site/"},
    {"name":"Management Journals","url":"http://www.managementjournals.org/index.php"},
    {"name":"Marsland Press","url":"http://www.sciencepub.net/"},
    {"name":"Mary and Sam Research Academia","url":"http://www.marynsam.co.uk/"},
    {"name":"Maryland Institute of Research","url":"http://miredu.org/"},
    {"name":"MASAUM Network","url":"http://www.masaumnet.com/"},
    {"name":"Mathews Open Access Journals","url":"http://www.mathewsopenaccess.com/"},
    {"name":"Maxwell Scientific Organization","url":"http://maxwellsci.com/jlist.php"},
    {"name":"MAYFEB Technology Development","url":"http://www.mayfeb.com/OJS/"},
    {"name":"McMed International","url":"http://mcmed.us/"},
    {"name":"Meas Publishing Ltd","url":"http://measpublishing.co.uk/"},
    {"name":"MECS","url":"http://www.mecs-press.org/"},
    {"name":"MedCrave","url":"http://medcraveonline.com/"},
    {"name":"Medical science","url":"http://www.ghrnet.org/index.php/index/index"},
    {"name":"Medical Science Journals","url":"http://medical.sciencejournals.cc/"},
    {"name":"Medip Academy","url":"http://www.medipacademy.com/"},
    {"name":"MEDNANO Publications","url":"http://www.medtechnano.com/"},
    {"name":"Medwell Journals","url":"http://www.medwelljournals.com/home.php"},
    {"name":"Medwin Publishers","url":"http://medwinpublishers.org/"},
    {"name":"Meghana Publications","url":"http://meghanapublications.com/index.php#MEGHANA"},
    {"name":"Mehta Press","url":"http://www.mehtapress.com/"},
    {"name":"Merit Research Journals","url":"http://meritresearchjournals.org/index.htm"},
    {"name":"Meta Research Press","url":"http://www.mrpress.org/"},
    {"name":"MNK Publication","url":"http://www.mnkjournals.com/index.htm"},
    {"name":"Modern Research Publishers","url":"http://www.modernrespub.org/"},
    {"name":"Modern Scientific Press","url":"http://modernscientificpress.com/"},
    {"name":"Mr. Scholar","url":"https://www.mrscholar.com/"},
    {"name":"Muhammadon Centre for Research and Development","url":"http://www.muhammadon.org/index.php"},
    {"name":"MuK Publications & Distributions","url":"http://www.mukpublications.com/"},
    {"name":"Multidisciplinary Journals","url":"http://www.multidisciplinaryjournals.com/"},
    {"name":"Mustang Journals","url":"http://mustangjournals.com/index.html"},
    {"name":"N&N Global Technology","url":"http://www.nngt.org/"},
    {"name":"Narain Publishers Pvt. Ltd","url":"http://www.npplweb.com/"},
    {"name":"National Association of Scholars","url":"http://national-science.ru/"},
    {"name":"National College of Physicians","url":"https://www.ncnp.org/medical-journals.html"},
    {"name":"Natural Sciences Publishing Corporation","url":"http://www.naturalspublishing.com/index.asp"},
    {"name":"Naturepub","url":"http://naturepub.org/"},
    {"name":"Nauk Publication","url":"http://www.naukpublication.org/"},
    {"name":"Nemis Journals","url":"http://www.nemisjournals.org/"},
    {"name":"Nessa Publishers","url":"http://www.nessapublishers.com/index.php"},
    {"name":"Net Journals","url":"http://www.netjournals.org/"},
    {"name":"New Century Publishing Group","url":"http://www.newcpress.com/"},
    {"name":"New Century Science Press","url":"http://www.newcenturyscience.com/"},
    {"name":"New Delhi Publisher","url":"http://ndpublisher.in/index.php"},
    {"name":"New Ground Research Journals","url":"http://www.newgroundresjournals.org/"},
    {"name":"New Science Series Journals","url":"http://web.newscienceseries.com/"},
    {"name":"New Scientist Publishers","url":"http://www.newscientistpublish.com/"},
    {"name":"New World Publishing","url":"http://www.newworldpub.com/homepage.html"},
    {"name":"New World Sciences Academy","url":"http://www.newwsa.com/"},
    {"name":"Newpubli","url":"http://www.newpubli.com/index.shtml"},
    {"name":"Nexus Academic Publishers","url":"http://nexusacademicpublishers.com/"},
    {"name":"nhsJournal","url":"http://nhsjournals.org/"},
    {"name":"Noble Academic Publisher","url":"http://napublisher.org/"},
    {"name":"Nobel International Journals","url":"http://www.nobel.gen.tr/"},
    {"name":"NobleResearch","url":"http://nobleresearch.org/"},
    {"name":"Non Olympic Times","url":"http://www.nonolympictimes.org/"},
    {"name":"North American Research Publishing","url":"http://www.narpub.com/"},
    {"name":"North Asian International Research Journal Consortium","url":"http://www.nairjc.com/"},
    {"name":"North Atlantic University Union","url":"http://www.naun.org/wseas/cms.action"},
    {"name":"Noto-are","url":"https://www.notoare.com/"},
    {"name":"Nova Explore Publications","url":"http://novaexplore.com/"},
    {"name":"Novel Science","url":"http://www.nvlscience.com/"},
    {"name":"Novelty Journals","url":"http://www.noveltyjournals.com/"},
    {"name":"Social Science Journals","url":"http://socialsciencejournals.com/"},
    {"name":"Novus Scientia Journals","url":"http://novusscientia.org/index.php"},
    {"name":"Nuclei Online","url":"http://nucleionline.org/"},
    {"name":"OA Publishing London","url":"http://oapublishinglondon.com/index.php"},
    {"name":"OAE Publishing, Inc. (OAE)","url":"http://oaepublish.com/"},
    {"name":"Oak-Fortress Journals","url":"http://oakfortressjournals.org/index.php"},
    {"name":"OASP Journals","url":"http://www.oaspjournal.org/"},
    {"name":"Oceanic Journals","url":"http://oceanicjournals.org/"},
    {"name":"Ology Science","url":"http://ologyscience.com/index.php"},
    {"name":"OMICS International","url":"http://www.omicsonline.org/"},
    {"name":"Ommega Publishers","url":"http://ommegaonline.com/"},
    {"name":"OneCentral Press","url":"http://www.onecentralpress.com/"},
    {"name":"Online Journals Management System","url":"http://onlinejournals.oscij.com/index.php/index/index"},
    {"name":"Online Research Journals","url":"http://onlineresearchjournals.org/index.htm"},
    {"name":"Online Science Publishing","url":"http://onlinesciencepublishing.com/"},
    {"name":"OPAST","url":"http://www.opastonline.com/"},
    {"name":"Open Access eBooks","url":"http://openaccessebooks.com/"},
    {"name":"Open Academic Press","url":"http://www.openacademicpress.de/"},
    {"name":"Open Access Journal Limited","url":"http://theojal.com/"},
    {"name":"Open Access Journals","url":"http://www.openaccessjournals.com/"},
    {"name":"Open Access Journals Publishing Company","url":"http://oaj-pc.com/"},
    {"name":"Open Access Library","url":"http://www.oalib.com/"},
    {"name":"Open Access Pub","url":"http://www.openaccesspub.org/"},
    {"name":"Open Access Pub","url":"http://oap-journals.org/index.php"},
    {"name":"Open Access Publishing Group","url":"http://oapub.org/edu/index.php/index"},
    {"name":"Open Access Science Research Publisher ","url":"http://openaccessscience.com/"},
    {"name":"Open Access Text","url":"http://oatext.com/"},
    {"name":"Open BioMedical Publishing Corporation","url":"http://www.obm-pc.com/"},
    {"name":"LIDSEN Publishing Inc.","url":"http://www.lidsen.com/"},
    {"name":"Open Journal Systems","url":"http://ambs-journal.co.uk/ojs-2.4.7-1/index.php/index"},
    {"name":"Open Knowledge Journals","url":"http://okjournals.org/"},
    {"name":"Open Research and Science Library","url":"http://www.orslib.org/index.html"},
    {"name":"Open Research Network","url":"http://www.openresearchnetwork.org/"},
    {"name":"Open Research Society","url":"http://www.open-knowledge-society.org/"},
    {"name":"Open Science","url":"http://www.openscienceonline.com/"},
    {"name":"Open Science Publications","url":"http://www.opensciencepublications.com/"},
    {"name":"OpenAccessPub","url":"http://www.openaccesspub.org/"},
    {"name":"OpenAccessPub","url":"http://oap-journals.org/index.php"},
    {"name":"Openventio Publishsers","url":"http://openventio.org/"},
    {"name":"OPR Science","url":"http://oprscience.com/"},
    {"name":"ORB Academic Publisher","url":"http://www.orb-academic.org/"},
    {"name":"Orbit Research and Development","url":"http://www.orbitjournals.com/index.php"},
    {"name":"ORIC Publications ","url":"http://www.oricpub.com/"},
    {"name":"Ozean Publications","url":"http://ozelacademy.com/"},
    {"name":"Pacesetter Online Publishers","url":"http://pacesetteronlinepublishers.org/"},
    {"name":"Pacific Group of e-Journals","url":"http://pacificejournals.com/"},
    {"name":"Pak Publishing Group","url":"http://www.pakinsight.com/"},
    {"name":"Pakistan Science Mission","url":"http://psmpublishers.org/"},
    {"name":"Palgo Journals","url":"http://www.palgojournals.org/"},
    {"name":"Panacea Research Library","url":"http://prlpublisher.com/"},
    {"name":"Paper Publications","url":"http://www.paperpublications.org/"},
    {"name":"Social Science Journals","url":"http://socialsciencejournals.com/"},
    {"name":"PaperSciences Research Publisher","url":"http://www.papersciences.com/"},
    {"name":"Paramount Journals","url":"http://www.paramountjournals.com/"},
    {"name":"PBS Journals","url":"http://pbsjournals.com/index.php"},
    {"name":"Peak Journals","url":"http://www.peakjournals.org/index.html"},
    {"name":"Pearl Publication","url":"http://www.pearlpub.com/"},
    {"name":"Pearl Research Journals","url":"http://www.pearlresearchjournals.org/"},
    {"name":"Peertechz","url":"http://www.peertechz.com/"},
    {"name":"Pelagia Research Library","url":"http://pelagiaresearchlibrary.com/index.html"},
    {"name":"Pencil Academic Press","url":"http://www.pencilacademicpress.org/"},
    {"name":"Pezzottaite Journals","url":"http://pezzottaitejournals.net/pezzottaite/"},
    {"name":"Pharma Intelligence","url":"http://www.pharmaintelligence.org/"},
    {"name":"Pharma Publisher","url":"http://www.pharmapublisher.com/"},
    {"name":"Pharma Research Library","url":"http://www.pharmaresearchlibrary.com/"},
    {"name":"Pharmaceutical Research Foundation","url":"http://pharmresfoundation.com/"},
    {"name":"PharmaInfo","url":"http://www.pharmainfo.in/"},
    {"name":"PharmaInterScience Publishers","url":"http://www.pharmainterscience.com/"},
    {"name":"Pharmascope Publications","url":"http://www.pharmascope.org/"},
    {"name":"Philippine Association of Institutions for Research","url":"http://philair.ph/publication/index.php/index/index"},
    {"name":"Photon Foundation","url":"https://sites.google.com/site/photonfoundationorganization/"},
    {"name":"Pinnacle Journal Publication","url":"http://pjpub.org/"},
    {"name":"Pinnacle Research Journals","url":"http://prj.co.in/"},
    {"name":"Pioneer Scientific Publisher","url":"http://www.pspchv.com/"},
    {"name":"PiscoMed Publishing","url":"http://www.piscomed.com/"},
    {"name":"Planetary Scientific Research Center","url":"http://psrcentre.org/"},
    {"name":"Platinum Global Journals","url":"http://www.platinumglobaljournals.org/"},
    {"name":"Premier Publishers","url":"http://premierpublishers.org/"},
    {"name":"PressAcademia","url":"http://www.pressacademia.org/"},
    {"name":"Prime Journals","url":"http://www.primejournal.org/index.html"},
    {"name":"Pristine Research Journal Publications","url":"http://www.prjp.org/index.htm"},
    {"name":"Priyanka Research Journal Publication","url":"http://www.prjpublication.com/index.html"},
    {"name":"International Journal of Academic Research (Publisher)","url":"http://www.eu-print.org/ilk.php"},
    {"name":"Progressive Academic Publishing","url":"http://www.idpublications.org/"},
    {"name":"Progressive Science Publications","url":"http://www.pscipub.com/MWP/"},
    {"name":"Project Innovation","url":"http://www.projectinnovation.biz/"},
    {"name":"Project Innovation","url":"http://www.projectinnovation.com/"},
    {"name":"ProJournals ","url":"http://www.projournals.org/"},
    {"name":"Proscience Journals","url":"http://www.proscience-journals.com/default.php"},
    {"name":"Prudence Journals","url":"http://www.prudencejournals.org/index.htm"},
    {"name":"Prudent Journals","url":"http://prudentjournals.org/IRJCP/"},
    {"name":"Pubicon International Publications","url":"http://www.pubicon.com/"},
    {"name":"Public Science Framework","url":"http://www.aiscience.org/psf/index.html"},
    {"name":"Publishing House of Sciences","url":"http://phosciences.com/"},
    {"name":"Pulsus Group","url":"http://www.pulsus.com/"},
    {"name":"Purple Journals","url":"http://www.purplejournals.org/"},
    {"name":"Pushpa Publishing House","url":"http://www.pphmj.com/"},
    {"name":"Pyrex Journals","url":"http://www.pyrexjournals.org/"},
    {"name":"Qingres","url":"http://www.qingres.com/"},
    {"name":"Quazzy Journals","url":"http://quazzyjournals.org/index.htm"},
    {"name":"Quest Journals","url":"http://www.questjournals.org/index.html"},
    {"name":"R&D Modern Research Publication","url":"http://rdmodernresearch.com/"},
    {"name":"R & S Publications","url":"https://sites.google.com/a/randspublications.org/randspublications/home"},
    {"name":"RAJ Group","url":"http://www.ra-j.org/"},
    {"name":"Rating Academy","url":"http://ratingacademy.com.tr/web/index.php/en/"},
    {"name":"Readers Insight Publishers","url":"http://readersinsight.net/"},
    {"name":"Recent Science","url":"http://recentscience.org/"},
    {"name":"Red Flower Publication Private Limited","url":"http://www.rfppl.co.in/index.php"},
    {"name":"RedFame Publishing","url":"http://www.redfame.com/home/"},
    {"name":"Remedy Publications","url":"http://www.remedypublications.com/"},
    {"name":"Renu Publishers","url":"https://renupublishers.com/"},
    {"name":"Research & Analysis Journals","url":"http://www.rajournals.in/"},
    {"name":"Research Academy of Social Sciences","url":"http://www.rassweb.com/"},
    {"name":"Research Alert Journals","url":"http://resealert.com/"},
    {"name":"Research and Educational Society","url":"http://www.resindia.org/"},
    {"name":"Research and Information Organization","url":"http://riojournals.com/home/"},
    {"name":"Research and Knowledge Publication","url":"http://www.rekpub.com/"},
    {"name":"Research and Scientific Innovation Society","url":"http://www.rsisinternational.org/"},
    {"name":"Research & Reviews","url":"http://www.rroij.com/"},
    {"name":"Research Centre for Management and Social Studies","url":"http://rcmss.com/"},
    {"name":"Research Consultants and Publisher","url":"http://recopublisher.org/index.php/Recopublisher"},
    {"name":"Research Foundation for Humanity","url":"http://rfh.org.pk/"},
    {"name":"Research India Publications","url":"http://www.ripublication.com/"},
    {"name":"Research Institute for Progression of Knowledge","url":"http://www.ripknet.org/"},
    {"name":"Research Institute for Science, Technology, and Society ","url":"http://journal.ristas.org/"},
    {"name":"Research Journal","url":"http://www.researchjournalz.com/"},
    {"name":"ResearchLEAP","url":"http://researchleap.com/"},
    {"name":"Research Open","url":"http://researchopenworld.com/"},
    {"name":"Research Publish Journals","url":"http://www.researchpublish.com/"},
    {"name":"Social Science Journals","url":"http://socialsciencejournals.com/"},
    {"name":"Research Publisher","url":"http://researchpub.org/index.html"},
    {"name":"Research Publishing Group","url":"http://rpublishing.org/"},
    {"name":"Research, Science, and Technology Publishers","url":"http://rstpublishers.com/"},
    {"name":"Research Script","url":"http://researchscript.com/"},
    {"name":"Research Trend","url":"http://www.researchtrend.net/"},
    {"name":"Research WebPub","url":"http://www.researchwebpub.org/"},
    {"name":"Researchjournali","url":"http://www.researchjournali.com/index.php"},
    {"name":"Revistas Academicas","url":"http://revistas-academicas.com/"},
    {"name":"Revotech Press","url":"http://www.revotechpress.com/"},
    {"name":"RG Education Society","url":"http://www.rgsociety.org/"},
    {"name":"Rising Vision","url":"http://www.risingvision.org/index.html"},
    {"name":"Ross Science Publishers","url":"http://rossscience.org/index.php"},
    {"name":"RS Publication","url":"http://rspublication.com/"},
    {"name":"Rutveg Publishing, Inc.","url":"http://www.rutveg.com/"},
    {"name":"RW|ResearchWorld","url":"http://researchworld.org/"},
    {"name":"Sacha And Diamond Academic Publishers","url":"http://www.sachajournals.com/"},
    {"name":"Sageya Publishers","url":"http://www.jicep.com/?page=aboutsageya"},
    {"name":"Sadguru Publications","url":"http://www.sadgurupublications.com/ContactUs.aspx"},
    {"name":"Sai Om Publications","url":"http://www.saiompublications.com/"},
    {"name":"Sai Scientific Communications","url":"http://sphinxsai.com/index.htm"},
    {"name":"Sakun Publishing House","url":"http://www.ijplsjournal.com/index.html"},
    {"name":"SAMANM Group of Research Publications","url":"http://www.samanmjournals.org/"},
    {"name":"Sanford Inter Science Press","url":"http://sispress.org/"},
    {"name":"Sans Publishing Group","url":"http://www.sansgroup.org/"},
    {"name":"Sapient Press","url":"http://www.sapientpress.com/index.html"},
    {"name":"Savant Journals","url":"http://savantjournals.org/"},
    {"name":"SAVAP International","url":"http://www.journals.savap.org.pk/"},
    {"name":"Savvy Science Publisher","url":"http://savvysciencepublisher.com/"},
    {"name":"Scholar Journals","url":"http://www.scholarjournals.org/"},
    {"name":"Scholar People","url":"http://scholarpeople.org/"},
    {"name":"Scholar Publications","url":"http://www.scholarpublications.in/index.html"},
    {"name":"Scholar Science Journals","url":"http://www.ssjournals.com/"},
    {"name":"ScholArena","url":"http://www.scholarena.com/"},
    {"name":"ScholArena","url":"http://www.scholarenagroup.com/"},
    {"name":"Scholarlink Resource Centre Limited","url":"http://scholarlinkresearch.com/"},
    {"name":"Scholarly and Academic Research Journals","url":"http://www.sarjournals.org/index.html"},
    {"name":"Scholarly Journals","url":"http://scholarly-journals.com/index.htm"},
    {"name":"Scholarly Research Journal’s","url":"http://www.srjis.com/"},
    {"name":"Scholarly Research Publisher","url":"http://www.srpublishers.org/"},
    {"name":"Scholars Academic and Scientific Publishers","url":"http://saspublisher.com/"},
    {"name":"Scholars Scitech Research","url":"http://www.scischolars.com/"},
    {"name":"Scholars Middle East Publishers","url":"http://scholarsmepub.com/"},
    {"name":"Scholars Research Library","url":"http://scholarsresearchlibrary.com/"},
    {"name":"ScholarsHub.net","url":"http://www.scholarshub.net/"},
    {"name":"Scholedge R&D Center","url":"http://thescholedge.org/"},
    {"name":"Scholink","url":"http://www.scholink.org/Home.html"},
    {"name":"Scholoxy Publications","url":"http://www.scholoxy.org/open-access-journals.php"},
    {"name":"Sci-Afric Publishers","url":"http://www.sci-africpublishers.org/"},
    {"name":"Sci-Edit Publications","url":"http://sci-edit.net/journal/"},
    {"name":"Sci Forschen","url":"http://sciforschenonline.org/"},
    {"name":"SciDoc Publishers","url":"http://scidoc.org/index.php"},
    {"name":"Sciedu Press","url":"http://sciedu.ca/web/"},
    {"name":"Science & Engineering Research Support soCiety","url":"http://www.sersc.org/"},
    {"name":"Science & Knowledge Publishing Corporation Limited","url":"http://scik.org/"},
    {"name":"The Science and Information Organization","url":"http://thesai.org/"},
    {"name":"Science and Knowledge Research Society","url":"http://www.sandkrs.com/index-2.html"},
    {"name":"Science Academy Publisher","url":"http://www.sciacademypublisher.com/"},
    {"name":"Science Alert","url":"http://scialert.net/index.php"},
    {"name":"Science and Education Centre of North America","url":"http://www.todayscience.org/"},
    {"name":"Science and Education","url":"http://www.sciepub.com/portal/Home"},
    {"name":"Science and Engineering Publishing Company","url":"http://www.seipub.org/"},
    {"name":"Science and Technology Central","url":"http://scitechc.com/index.php/index"},
    {"name":"Science and Technology Publishing","url":"http://www.scitecpub.com/"},
    {"name":"Science Arena Publications","url":"http://sciarena.com/MWP/"},
    {"name":"Science Education Foundation","url":"http://www.ejournalnet.com/"},
    {"name":"Science Explorer Publications","url":"http://explorerpub.com/en/"},
    {"name":"Science Fair Open Library","url":"http://www.sciencefairopenlib.com/index.html"},
    {"name":"ScienceFlora","url":"http://scienceflora.org/"},
    {"name":"Science Huβ","url":"http://scihub.org/"},
    {"name":"Science Instinct Publications","url":"http://www.sciipub.com/"},
    {"name":"Science Journal Publication","url":"http://www.sjpub.org/"},
    {"name":"Science Park Journals","url":"http://scienceparkjournals.com/"},
    {"name":"Science Park Research Organization and Counseling","url":"http://www.sproc.org/index.htm"},
    {"name":"Science Publications","url":"http://www.thescipub.com/"},
    {"name":"Science Publications","url":"http://www.sciencepublication.org/"},
    {"name":"Science Publishers","url":"http://thesciencepublishers.com/"},
    {"name":"Science Publishing Corporation","url":"http://www.sciencepubco.com/"},
    {"name":"Science Publishing Group","url":"http://www.sciencepublishinggroup.com/home/index.aspx"},
    {"name":"SciencePG","url":"http://sciencepg.com/"},
    {"name":"SCIPG","url":"http://scipg.net/"},
    {"name":"Science Q Publishing Group","url":"http://www.scienceq.org/"},
    {"name":"Science Record Journals","url":"http://www.sciencerecord.com/"},
    {"name":"Science Research Association","url":"http://www.scirea.org/"},
    {"name":"Science Research Library","url":"http://www.scienceresearchlibrary.com/"},
    {"name":"Science Sights","url":"http://sciencesights.com/j/home.php?x=0"},
    {"name":"Science Signpost Publishing Inc.","url":"http://www.ss-pub.org/"},
    {"name":"Science Target","url":"http://www.sciencetarget.com/"},
    {"name":"Science Web Publishing","url":"http://www.sciencewebpublishing.net/"},
    {"name":"ScienceDomain International","url":"http://www.sciencedomain.org/"},
    {"name":"ScienceDomain International","url":"http://www.sciencedomains.org/"},
    {"name":"ScienceDomain International","url":"https://sciencedomaine.org/"},
    {"name":"Scienceline Publications","url":"http://www.science-line.com/index/"},
    {"name":"ScienceSolve","url":"http://www.sciencesolve.com/"},
    {"name":"Sciences & Engineering Research Publication","url":"http://www.scenrp.com/"},
    {"name":"ScienceScript","url":"http://www.sciencescript.org/"},
    {"name":"Scienpress Ltd.","url":"http://www.scienpress.com/Default.asp"},
    {"name":"Sciencevier","url":"http://sciencevier.com/"},
    {"name":"Scient Open Access","url":"http://scientonline.org/"},
    {"name":"ScienTech Publisher","url":"http://www.sci-en-tech.com/index.html"},
    {"name":"Scientia Ricerca","url":"http://scientiaricerca.com/"},
    {"name":"Scientia Socialis","url":"http://www.scientiasocialis.lt/?q=node/5"},
    {"name":"Scientific & Academic Publishing","url":"http://www.sapub.org/journal/index.aspx"},
    {"name":"Scientific Advances Publishers","url":"http://www.scientificadvances.co.in/"},
    {"name":"Scientific & Academic Publishing","url":"http://www.sapub.org/journal/index.aspx"},
    {"name":"Scientific Cooperations","url":"http://ase-scoop.org/journals.html"},
    {"name":"Scientific Federation","url":"http://scientificfederation.com/index.php"},
    {"name":"Scientific Future","url":"http://scientificfuturegroup.com/"},
    {"name":"Scientific Institute For Advanced Training and Studies","url":"http://www.siats.co.uk/"},
    {"name":"Scientific Journals","url":"http://www.scientific-journals.co.uk/"},
    {"name":"Scientific Journals International","url":"http://www.scientificjournals.org/"},
    {"name":"Scientific Literature","url":"http://www.scientificliterature.org/"},
    {"name":"Scientific Online Publishing","url":"http://www.scipublish.com/"},
    {"name":"Scientific Open Access Journals","url":"http://www.scientificoajournals.org/index.php"},
    {"name":"The Scientific Pages","url":"http://thescientificpages.org/"},
    {"name":"Scholarly Pages","url":"http://scholarlypages.org/"},
    {"name":"Scientific Perspectives Publishing","url":"http://waprogramming.com/index.php"},
    {"name":"Scientific Planet","url":"http://www.sciencebeingjournal.com/"},
    {"name":"Scientific Platform Online Journals","url":"http://sciplatform.com/journals/index.php/index/index"},
    {"name":"Scientific Research Gate","url":"http://scigatejournals.com/publications/"},
    {"name":"Scientific Research Publishing","url":"http://www.scirp.org/"},
    {"name":"Scientific Times","url":"http://scientifictimes.org/index.html"},
    {"name":"Scientific Viewers","url":"http://www.scientificviewers.com/"},
    {"name":"ScientificWebJournals","url":"http://www.scientificwebjournals.com/"},
    {"name":"Sci Forschen","url":"http://sciforschenonline.org/"},
    {"name":"Scigmoid","url":"http://www.scigmoid.com/index.php"},
    {"name":"Sciknow","url":"http://www.sciknow.org/"},
    {"name":"Scinzer Scientific Publications","url":"http://www.scinzer.com/"},
    {"name":"SciPress Ltd","url":"http://www.scipress.com/"},
    {"name":"SciRes Literature","url":"http://scireslit.com/index.php"},
    {"name":"SciRex","url":"http://scirexonline.com/"},
    {"name":"SCITECH","url":"http://scitecresearch.com/"},
    {"name":"SciTech Publishers","url":"http://www.thescitechpub.com/publishers/index.aspx"},
    {"name":"Scitechz","url":"http://scitechz.com/index.html"},
    {"name":"SciTechnol","url":"http://scitechnol.com/"},
    {"name":"ScottishGroup Education and Testing Services","url":"http://scottishjournal.co.uk/"},
    {"name":"Scribes Guild","url":"http://www.scribesguildjournals.org/journals.html"},
    {"name":"SEAHI Publications & Academic Journals","url":"http://seahipaj.org/"},
    {"name":"Segment Journals","url":"http://www.segmentjournals.com/"},
    {"name":"Seitejournals","url":"http://www.seitejournals.com/"},
    {"name":"Serials Publications","url":"http://www.serialsjournals.com/"},
    {"name":"SETScholars","url":"http://www.setscholars.org/"},
    {"name":"Seventh Sense Research Group Journals","url":"http://www.internationaljournalssrg.org/index.html"},
    {"name":"Shri Param Hans Education & Research Foundation Trust","url":"http://www.sphert.org/"},
    {"name":"Sift Desk","url":"http://www.siftdesk.org/"},
    {"name":"Significs Online Publishing","url":"http://significsonline.com/"},
    {"name":"Signpost e Journals","url":"http://signpostejournals.com/ejournals/Home.aspx"},
    {"name":"Silicon Valley Publishers","url":"http://www.svpublishers.co.uk/"},
    {"name":"Singaporean Journals","url":"http://iaaet.org/sjsr/index.html"},
    {"name":"SJournals","url":"http://sjournals.com/"},
    {"name":"Sky Journals","url":"http://www.skyjournals.org/index.htm"},
    {"name":"Slovakia Academic Publishing","url":"http://www.skaponline.com/"},
    {"name":"SM Group (SM Online Publishers)","url":"http://smjournals.com/"},
    {"name":"Smart Science & Technology","url":"http://www.smartscitech.com/"},
    {"name":"SmatPub","url":"http://smatpub.com/Journals.php"},
    {"name":"Smile Nation – Lets Smile Together","url":"http://www.ijsscr.com/contact.html"},
    {"name":"Smith & Franklin Academic Publishing Corporation","url":"http://smithandfranklin.com/"},
    {"name":"Society for Advancement of Sciences","url":"http://www.sasjournals.com/"},
    {"name":"Society for Science and Education United Kingdom","url":"http://scholarpublishing.org/index.php/index"},
    {"name":"Society for Science and Education","url":"http://scholarpublishing.org/sse/"},
    {"name":"Society for Science and Nature","url":"http://scienceandnature.org/index.php"},
    {"name":"Society of Business Research","url":"https://www.sbrconferences.com/"},
    {"name":"Society of Digital Information and Wireless Communications","url":"http://sdiwc.net/"},
    {"name":"Society of Education","url":"http://soeagra.com/"},
    {"name":"Society of Engineering Science and Technology","url":"http://www.sestindia.org/"},
    {"name":"Sons and Daughters Publishing House","url":"http://www.e-journaldirect.com/index.php"},
    {"name":"Source","url":"http://www.researchsource.org/home"},
    {"name":"Source Journals","url":"http://sourcejournals.com/"},
    {"name":"South Asian Academic Research Journals","url":"http://www.saarj.com/index.html"},
    {"name":"Southern Cross Publishing Group","url":"http://www.sciencej.com/submit.html"},
    {"name":"Speak Foundation","url":"http://foundationspeak.com/"},
    {"name":"SPIRI The Global Research","url":"http://www.spiri.org/"},
    {"name":"Spring City Culture International Group Pte Ltd.","url":"http://www.springcityculture.com/"},
    {"name":"Spring City Culture International Group Pte Ltd.","url":"http://www.spring-city.org/"},
    {"name":"Spring International S&T Publishing Media Co.","url":"http://springpublishing.org/index.php/index/index"},
    {"name":"Spring Journals","url":"http://www.springjournals.net/"},
    {"name":"Springwood Publishing Corporation","url":"http://www.springwoodpublication.com.au/"},
    {"name":"Sprint Journals","url":"http://www.sprintjournals.com/"},
    {"name":"Sri Krishna International Research & Educational Consortium","url":"http://skirec.org/index"},
    {"name":"SS Publications","url":"http://www.sspublications.co.in/"},
    {"name":"St. Anne Mary Publication","url":"http://www.annemary.org/publication"},
    {"name":"Standard Global Journals","url":"http://www.standardglobaljournals.com/index.html"},
    {"name":"The Standard International Journals","url":"http://www.thesij.com/"},
    {"name":"Standard Research Journals","url":"http://standardresearchjournals.org/"},
    {"name":"Statperson Publishing Corporation","url":"http://statperson.com/"},
    {"name":"STM Connect","url":"http://www.stmconnect.com/"},
    {"name":"Streem Journal","url":"http://streemjournals.org/"},
    {"name":"Stringer Open","url":"http://www.stringeropen.com/"},
    {"name":"Suryansh Publications","url":"https://scholarlyoa.wordpress.com/wp-admin/www.suryanshpublications.inf"},
    {"name":"Sustainable Scientific Publisher","url":"http://www.sustsci.org/"},
    {"name":"SV Publication","url":"http://www.svpublication.com/#"},
    {"name":"Swan Open","url":"http://www.swanopen.com/"},
    {"name":"Swedish Scientific Publications","url":"http://swedishscientificpublications.com/"},
    {"name":"Swift Journals","url":"http://www.swiftjournals.org/"},
    {"name":"Swiss Journals","url":"http://www.swissjournals.org/"},
    {"name":"Symbiosis ","url":"http://symbiosisonlinepublishing.com/index.php"},
    {"name":"Synchro Publisher","url":"http://www.synchropublisher.com/"},
    {"name":"Synergy Publishers","url":"http://www.synergypublishers.com/"},
    {"name":"T&S Journal PUblications","url":"http://tands-journal-publications.com/"},
    {"name":"TAF Publishing","url":"http://www.tafpublications.com/platform"},
    {"name":"Takayama Publishing Group","url":"http://journal.medsys-site.com/"},
    {"name":"Takshila","url":"http://takshila.org/"},
    {"name":"Taraksh Journals","url":"http://www.taraksh.org/index.htm"},
    {"name":"Techmind Research","url":"http://www.techmindresearch.com/index.php?page=index"},
    {"name":"Technical Journals Online","url":"http://www.technicaljournalsonline.com/index.html"},
    {"name":"Technopark Publications","url":"http://technoparkpublications.com/"},
    {"name":"Techno Science Academy","url":"http://technoscienceacademy.com/"},
    {"name":"Terminal Journals","url":"http://www.terminaljournals.org/"},
    {"name":"Textroad Journals","url":"http://www.textroad.com/"},
    {"name":"Thales Academic Publisher","url":"http://www.thalespublisher.com/"},
    {"name":"Thavan E ACT International Journals","url":"http://www.thavan.org/"},
    {"name":"Thetic Journals","url":"http://theticjour.in/"},
    {"name":"Thomson & Ryberg Publications","url":"http://www.trpubonline.com/index.php"},
    {"name":"TI Journals","url":"http://waprogramming.com/"},
    {"name":"Time Journals","url":"http://www.timejournals.org/"},
    {"name":"Timeline Publication Pvt. Ltd.","url":"http://timelinepublication.com/"},
    {"name":"TLEP Journals","url":"http://www.tlepub.org/en/"},
    {"name":"Tomas Publishing","url":"http://tomaspubs.com/"},
    {"name":"Topclass Global Journals","url":"http://www.topclassglobaljournals.org/"},
    {"name":"Trade Science, Inc","url":"http://www.tsijournals.com/"},
    {"name":"Trans Stellar","url":"http://www.tjprc.org/index.php"},
    {"name":"Transaction Series on Engineering Sciences and Technologies","url":"http://www.tsest.org/"},
    {"name":"Transcontinental Publishers","url":"http://icjpublishers.org/index.php"},
    {"name":"Transnational Research Journals","url":"http://universalresearchjournals.org/"},
    {"name":"TSPublications","url":"https://sites.google.com/a/tspublications.org/tspublications/home"},
    {"name":"Tulpar Academic Publishing","url":"http://www.challengejournal.com/"},
    {"name":"U.S. Science Press","url":"http://usspress.com/"},
    {"name":"UHIVE","url":"http://www.uhedergisi.com/?sayfa=icerik&tur=icerik&kategori=diger-dergilerimiz&icerik=diger-dergilerimiz"},
    {"name":"Uluslararası Hakemli İletişim ve Edebiyat Araştırmaları Dergisi","url":"http://www.uhedergisi.com/"},
    {"name":"Ulster Press","url":"http://ulster-press.uk/"},
    {"name":"Unified Journals","url":"http://unifiedjournals.org/"},
    {"name":"Unique Journals Communication","url":"http://www.ujconline.net/"},
    {"name":"Unique Research Journals","url":"http://www.uniqueresearchjournals.com/index.htm"},
    {"name":"United Scholars Publications","url":"http://www.unitedscholars.net/home.html"},
    {"name":"United Scientific Group","url":"http://unitedscientificgroup.com/"},
    {"name":"Universal Association of Computer and Electronics Engineers","url":"http://uacee.org/"},
    {"name":"Universal Association of Mechanical and Aeronautical Engineers","url":"http://uamae.org/"},
    {"name":"Universal Publishing & Research Organization","url":"http://www.upro.org.in/"},
    {"name":"Universal Research Group","url":"http://universalrg.org/index.aspx"},
    {"name":"Universal Research Publications","url":"http://urpjournals.com/contactus.php"},
    {"name":"Universe Scientific Publishing","url":"http://www.usp-pl.com/"},
    {"name":"UniversityPublications.net","url":"http://www.universitypublications.net/index.html"},
    {"name":"Universum Scientific Journals","url":"http://7universum.com/en/"},
    {"name":"Научные журналы Universum","url":"http://sibac.info/universum"},
    {"name":"Uptodate Research Publication","url":"http://www.uptodateresearchpublication.com/"},
    {"name":"URO Journals","url":"http://www.urojournals.com/"},
    {"name":"USN Scientific Journal","url":"http://usnsj.com/index.php/index/index"},
    {"name":"Valley International Journals","url":"http://valleyinternational.net/index.php"},
    {"name":"VBRI Press","url":"http://www.vbripress.com/"},
    {"name":"Verizona Publisher","url":"http://verizonaonlinepublishing.com/"},
    {"name":"Vernon Innovative Publishers","url":"http://www.vipoa.org/"},
    {"name":"VIBGYOR Online Publishers","url":"http://vibgyorpublishers.org/main/index.php"},
    {"name":"Victorquest Publications","url":"http://victorquestpub.com/"},
    {"name":"Vidya Publications","url":"http://vidyapublications.com/home.php"},
    {"name":"Virtual Foundation for Advancement of Science and Technology","url":"http://www.vfast.org/"},
    {"name":"VNMPublication","url":"http://www.vnmpublication.com/Journal.htm"},
    {"name":"Vow Scientific Quest","url":"http://vowscientificquest.com/"},
    {"name":"VRJ Publishers","url":"http://www.vrjpublishers.com/index.php/index/index"},
    {"name":"VSRD International Journals","url":"http://www.vsrdjournals.com/"},
    {"name":"Watch Plus","url":"http://www.watchpub.org/index.htm"},
    {"name":"Webcrawler Journals","url":"http://webcrawlerjournals.org/"},
    {"name":"We-Together to Save Yourself Society","url":"http://www.sospublication.co.in/index.php"},
    {"name":"Wesley & Eber Publishing","url":"http://weberpub.org/"},
    {"name":"West East Institute","url":"http://www.westeastinstitute.com/"},
    {"name":"WFL Publisher","url":"http://world-food.net/"},
    {"name":"Whites Science","url":"http://whitesscience.com/"},
    {"name":"Whioce Publishing Pte. Ltd.","url":"http://www.whioce.com/"},
    {"name":"Wilolud Journals","url":"http://www.wiloludjournal.com/page.php?3"},
    {"name":"Wireilla Scientific Publications","url":"http://wireilla.com/"},
    {"name":"WIT Press","url":"http://www.witpress.com/"},
    {"name":"WOAR Journals","url":"https://www.woarjournals.org/"},
    {"name":"World Academic Journal of Business & Applied Science","url":"http://wajbas.webs.com/"},
    {"name":"World Academic Publishing","url":"http://www.academicpub.org/"},
    {"name":"World Academic Research Journals","url":"http://www.worldacademicresearchjournals.org/"},
    {"name":"World Academic Union","url":"http://www.worldacademicunion.com/default.html"},
    {"name":"World Academy of Research and Publication","url":"http://www.warponline.org/"},
    {"name":"World Academy of Research in Science and Engineering","url":"http://warse.org/"},
    {"name":"World Academy of Science and Technology","url":"http://www.wastinc.us/"},
    {"name":"World Academy of Science, Engineering and Technology","url":"http://www.waset.org/publications.php"},
    {"name":"World Business Institute","url":"http://www.wbiworld.org/"},
    {"name":"World Business Institute","url":"http://www.wassco.org/"},
    {"name":"World Journal of Publisher","url":"http://www.wjp.co.in/"},
    {"name":"World Journals of Academic Advances","url":"http://www.wjoaa.org/"},
    {"name":"World Open Access Journals","url":"http://www.woaj.org/"},
    {"name":"World Research Journals","url":"http://worldresearchjournals.com/"},
    {"name":"World Research Library","url":"http://worldresearchlibrary.org/journal.php"},
    {"name":"World Research Publications","url":"http://www.wrpjournals.com/"},
    {"name":"World Scholars","url":"http://wscholars.com/"},
    {"name":"World Science and Research Publishing","url":"http://www.wsrpublishing.com/index.php/wsrp"},
    {"name":"World Science Publisher","url":"http://www.worldsciencepublisher.org/index.php"},
    {"name":"World Science Research Journals","url":"http://www.wsrjournals.org/"},
    {"name":"World Scientific and Engineering Academy and Society","url":"http://www.wseas.org/"},
    {"name":"World Standard Organization","url":"http://standard.org/"},
    {"name":"World Wide Journals","url":"http://www.worldwidejournals.com/"},
    {"name":"Wudpecker Research Journals","url":"http://www.wudpeckerresearchjournals.org/"},
    {"name":"Wyno Academic Journals","url":"http://www.wynoacademicjournals.org/index.html"},
    {"name":"Wyvern Publishing Group","url":"http://www.wyvernpublishinggroup.com/"},
    {"name":"Xia & He Publishing","url":"http://www.xandhpublishing.com/Default.aspx?sid=1"},
    {"name":"Xia & He Publishing","url":"http://www.xiahepublishing.com/"},
    {"name":"Yellow Loop Journal","url":"http://journal.yloop.com/"},
    {"name":"Zant World Press","url":"http://zantworldpress.com/"},
    {"name":"Zeal Scienza Realm of Erudition","url":"http://zealscienza.com/zealscienza/"},
    {"name":"ZealSci Journals","url":"http://www.zealscijournals.com/index.html"},
    {"name":"Zeetarz Group Publishing","url":"http://www.zeetarz.com/"},
    {"name":"Zenith International Research and Academic Foundation","url":"http://www.zenithresearch.org.in/"},
    {"name":"Zia World Press","url":"http://ziaworldpress.com/"},
    {"name":"ZolCat Academic House","url":"http://www.zolcat.com/"},
    {"name":"Zt-Journals","url":"http://www.ztjournals.com/"},
    {"name":"Zygoscient","url":"http://zygoscient.org/"},
    {"name":"Academic Publications","url":"https://www.academicpublications.net/"},
    {"name":"Prime Publications","url":"http://www.newresearchjournal.com/"},
    {"name":"Academic Solutions","url":"https://acadsol.eu/"},
    {"name":"ACTA Press","url":"http://www.actapress.com/"},
    {"name":"Acta Scientific","url":"https://actascientific.com/journals.php"},
    {"name":"Advanced Research Society for Science and Sociology","url":"http://arsss.org/"},
    {"name":"AGU Publications","url":"http://www.agupublication.com/"},
    {"name":"AI Publications","url":"http://aipublications.com/"},
    {"name":"Akademia Baru Publishing","url":"http://www.akademiabaru.com/"},
    {"name":"AMS Central","url":"http://www.amscentral.com/"},
    {"name":"Ant Journals","url":"http://www.antjournals.org/"},
    {"name":"Arena Of Sciences","url":"http://arenaofsciences.com/"},
    {"name":"Asclepius Open","url":"https://asclepiusopen.com/"},
    {"name":"Auctores Publishing, LLC","url":"https://www.auctoresonline.org/"},
    {"name":"Bilingual Publishing Co","url":"http://www.bilpublishing.com/"},
    {"name":"Bio-Byword Publishing PTY LTD","url":"http://www.bbwpublisher.com/"},
    {"name":"Biogeneric Publishers","url":"https://biogenericpublishers.com/"},
    {"name":"BiomedGrid, LLC","url":"https://biomedgrid.com/"},
    {"name":"Biomedical Research Network+, LLC","url":"http://biomedres.co/"},
    {"name":"Birlesik Dunya Yenilik Arastirma ve Yayincilik Merkezi","url":"https://www.un-pub.eu/ojs/"},
    {"name":"Boffin Access","url":"https://www.boffinaccess.com/"},
    {"name":"Bosal Journals","url":"http://bosaljournals.com/"},
    {"name":"Boya Century Publishing","url":"http://www.journals.cfp.edu.pl/"},
    {"name":"British Bio Medicine Institute","url":"https://www.britishbiomedicine.com/"},
    {"name":"BUSSECON International Publishing","url":"https://bussecon.com/"},
    {"name":"Cambridge Scholars Publishing","url":"http://www.cambridgescholars.com/"},
    {"name":"Center for Academic Research","url":"https://www.ijssb.com/index.php/car"},
    {"name":"Center for Contemporary Research","url":"http://www.ijbmcnet.com/index.php/ccr"},
    {"name":"Center for Promoting Education and Research","url":"http://cpernet.org/"},
    {"name":"Centre for Research on Islamic Banking & Finance and Business","url":"https://www.cribfb.com/"},
    {"name":"Chembio Publishers","url":"http://chembioepub.com/"},
    {"name":"Chembio Publishers","url":"https://www.chembiopublishers.com/"},
    {"name":"Cientific Group","url":"https://www.cientificgroup.com/journals.php"},
    {"name":"Cloud Journals","url":"http://www.cloud-journals.com/"},
    {"name":"Cloud Publications","url":"https://www.cloudpublications.org/"},
    {"name":"CME Publishing Group","url":"http://www.cmepub.com/index"},
    {"name":"Coalesce Research Group","url":"http://coalesceresearchgroup.com/"},
    {"name":"Consortia Academia","url":"http://consortiacademia.org/"},
    {"name":"Copernicus Publishing","url":"http://copernicuspublishing.com/"},
    {"name":"Crimson Publishers","url":"http://crimsonpublishers.com/"},
    {"name":"East African Scholars Publisher","url":"http://www.easpublisher.com/"},
    {"name":"Edupedia Publications","url":"http://edupediapublications.org/"},
    {"name":"International Scholarly Open Access Research","url":"http://www.isoar.in/"},
    {"name":"Emeraldtree Publishing","url":"http://emtpub.com/"},
    {"name":"Engineering Information Institute","url":"http://www.engii.org/"},
    {"name":"EnPress Publisher","url":"http://enpress-publisher.com/"},
    {"name":"eScientific Research","url":"http://escires.com/"},
    {"name":"European Open Access Publishing","url":"https://www.europapublishing.org/"},
    {"name":"FM Publishers","url":"https://fmpublishers.org/"},
    {"name":"ForteOpen Journals","url":"https://forteopen.com/"},
    {"name":"Fortune Journals","url":"http://www.fortunejournals.com/"},
    {"name":"Geist Science","url":"https://geistscience.com/"},
    {"name":"GIAP Journals","url":"https://giapjournals.com/"},
    {"name":"GJ Publications","url":"http://www.gjpublications.com/"},
    {"name":"Globeedu Group","url":"http://www.globeedugroup.com/"},
    {"name":"GPH Journal","url":"http://www.gphjournal.org/"},
    {"name":"Green Publication","url":"https://gnpublication.org/"},
    {"name":"Gupta Publications","url":"http://www.guptapublications.com/"},
    {"name":"Healthcare Bulletin","url":"http://www.healthcare-bulletin.com/"},
    {"name":"Hilaris Publisher","url":"https://www.hilarispublisher.com/"},
    {"name":"i-manager Publications","url":"http://www.imanagerpublications.com/"},
    {"name":"i-Proclaim","url":"https://i-proclaim.my/"},
    {"name":"​","url":"http://www.imrpress.org/"},
    {"name":"Incessant Nature Science Publishers","url":"http://www.inspublishers.com/"},
    {"name":"Infogain Publication","url":"http://infogainpublication.com/"},
    {"name":"Informing Science Institute","url":"https://www.informingscience.org/"},
    {"name":"Innovation Info","url":"https://innovationinfo.org/"},
    {"name":"Innovision Health Media, Inc.","url":"http://innovisionhm.com/"},
    {"name":"Institute for Environment, Engineering, Economics","url":"http://ieee.am/"},
    {"name":"Institute for Promoting Research & Policy Development","url":"https://iprpd.org/"},
    {"name":"International Association for Research and Science","url":"https://www.iaras.org/"},
    {"name":"International Association of Engineers","url":"http://www.iaeng.org/"},
    {"name":"International Association of Science and Technology for Development","url":"http://www.iasted.org/"},
    {"name":"International Business Academics Consortium","url":"http://ibac-conference.org/ibac/index.html"},
    {"name":"International Center for Promoting Knowledge","url":"https://icpknet.org/"},
    {"name":"International Institute of Education, Research and Development","url":"https://www.iierd.org/"},
    {"name":"International Institute of Social and Economic Sciences","url":"https://www.iises.net/"},
    {"name":"International Journal of Modern Research and Development","url":"http://www.ijmrnd.com/"},
    {"name":"International Peer Reviewed Journals and Books","url":"https://www.iprjb.org/"},
    {"name":"International Publisher LLC","url":"http://publisher-europe.com/?l=us"},
    {"name":"International Scientific Journal","url":"http://www.scientific-journal.com/"},
    {"name":"International Scientific Organization","url":"http://www.iscientific.org/"},
    {"name":"International Technology and Science Publications Ltd","url":"http://www.itspoa.com/"},
    {"name":"Institute of Mathematics and Management","url":"https://imathm.edu.lk/publications"},
    {"name":"IPN Education Group","url":"http://www.ipneducationgroup.org/"},
    {"name":"IRDP Group of Journals","url":"http://irdp.info/"},
    {"name":"IRIS Publishers","url":"https://irispublishers.com/"},
    {"name":"ITSR","url":"http://informtechcell.com/"},
    {"name":"Journals of University of Babylon","url":"https://www.journalofbabylon.com/"},
    {"name":"Knowledge Insights","url":"http://knowledge-insights.org/"},
    {"name":"Kosmos Publishers","url":"http://www.kosmospublishers.com/"},
    {"name":"Lectito","url":"http://www.lectitopublishing.nl/"},
    {"name":"LIDSEN Publishing Inc.","url":"http://www.lidsen.com/"},
    {"name":"Open BioMedical Publishing Corporation","url":"http://www.obm-pc.com/"},
    {"name":"Longdom Publishing","url":"https://www.longdom.org/"},
    {"name":"Lupine Publishers","url":"http://www.lupinepublishers.com/"},
    {"name":"Mak Periodical Library","url":"https://makperiodicallibrary.com/"},
    {"name":"MedCave Publications","url":"http://medcavepublications.org/"},
    {"name":"MedCave Publications","url":"http://www.openaccessjournals.us/"},
    {"name":"Medip Academy","url":"https://www.medipacademy.com/"},
    {"name":"Medpulse Publishing Corporation","url":"https://www.medpulse.in/"},
    {"name":"Mehria International Publishers","url":"http://www.ijvets.com/"},
    {"name":"Modern Business Press","url":"http://www.modernbusinesspress.com/"},
    {"name":"Molecular Biology Journals","url":"http://www.molecularbiologyjournals.com/"},
    {"name":"NADIA","url":"https://nadiapub.com/"},
    {"name":"National FORUM Journals","url":"http://www.nationalforum.com/"},
    {"name":"Natural Science Simulations and Engineering Laboratory Limited","url":"https://nssel.uk/"},
    {"name":"Nextgen Research Publications","url":"https://www.ijntr.org/"},
    {"name":"Ocimum Scientific Publishers","url":"https://ocimumpublishers.com/"},
    {"name":"Ology Journals","url":"http://ologyjournals.com/"},
    {"name":"Onjourn","url":"https://www.onjourn.org/"},
    {"name":"Onomy Science","url":"http://onomyscience.com/"},
    {"name":"Open Access (OA) Publication","url":"https://oapublication.com/"},
    {"name":"Open Exploration","url":"https://www.explorationpub.com/"},
    {"name":"Oriental Scientific Publishing Company","url":"http://ospcindia.org/"},
    {"name":"Phronesis, LLC","url":"https://phronesisonline.com/"},
    {"name":"Prague Development Center","url":"http://www.pradec.eu/"},
    {"name":"Publishing Press","url":"http://publishingpress.info/"},
    {"name":"PubMedHouse","url":"http://www.pubmedhouse.com/"},
    {"name":"Raft Publications","url":"https://www.raftpubs.com/"},
    {"name":"ReDelve International Publications","url":"https://www.redelve.com/"},
    {"name":"Research Center of Education and Science","url":"http://rcesnet.com/"},
    {"name":"Research Infotext","url":"https://researchinfotext.com/"},
    {"name":"Research Novelty Publisher","url":"https://researchnovelty.com/"},
    {"name":"Research Pioneers","url":"http://researchpioneers.com/"},
    {"name":"Research Route","url":"http://www.researchroute.com/"},
    {"name":"Rivera Publications","url":"http://riverapublications.com/"},
    {"name":"RM Research International Pte. Ltd","url":"http://rmjournals.com/"},
    {"name":"S Open Access Open Journals Publishing","url":"https://soaoj.com/"},
    {"name":"SAE Publications","url":"http://saepub.com/"},
    {"name":"Scholarly Pages","url":"http://scholarlypages.org/"},
    {"name":"The Scientific Pages","url":"http://thescientificpages.org/"},
    {"name":"Scholars Academic and Scientific Society","url":"https://sassociety.com/journals/"},
    {"name":"SciAccess Publisher","url":"http://www.sciaccesspublishers.com/"},
    {"name":"SCIAEON","url":"http://sciaeon.org/"},
    {"name":"ScienceForecast Publications LLC","url":"https://scienceforecastoa.com/"},
    {"name":"ScienceScholar","url":"https://sciencescholar.us/"},
    {"name":"Science Publishing Gate","url":"http://sciencepublishgate.com/"},
    {"name":"Science Publishing Group","url":"http://spg.ltd/"},
    {"name":"Science Repository","url":"https://www.sciencerepository.org/"},
    {"name":"Scientia Socialis","url":"http://www.scientiasocialis.lt/"},
    {"name":"Scientific Education","url":"http://www.scientificeducation.org/"},
    {"name":"Scimaze Group","url":"https://scimaze.org/"},
    {"name":"SciTech Central Inc.","url":"http://www.scitcentral.com/"},
    {"name":"SciVision Publishers","url":"http://www.scivisionpub.com/"},
    {"name":"SDIP Press","url":"https://www.sdippress.com/"},
    {"name":"Social Science Journals","url":"http://socialsciencejournals.com/"},
    {"name":"Sryahwa Publications","url":"http://www.sryahwapublications.com/"},
    {"name":"Stechnolock","url":"http://www.stechnolock.com/"},
    {"name":"SunKrist Publishing","url":"https://sunkristpublishing.com/"},
    {"name":"Synotec Publishers","url":"http://www.synotecpublishers.com/"},
    {"name":"Syntax Publishers","url":"https://syntaxpublishers.org/"},
    {"name":"The American Publishing House","url":"https://www.theamph.com/"},
    {"name":"Thomson.id","url":"http://thomson.id/"},
    {"name":"TMR Publishing Group","url":"https://www.tmrjournals.com/"},
    {"name":"TSNS “Interaktiv plus”, LLC","url":"https://interactive-plus.ru/en"},
    {"name":"UK Education Consultancy Services Ltd","url":"https://uk-education.com/publications"},
    {"name":"United Prime Publications, Universal Access Medical Publishers","url":"https://www.untdprimepub.com/"},
    {"name":"Universal Wiser Publisher","url":"http://www.wiserpub.com/"},
    {"name":"Vision Science Research Sdn Bhd","url":"http://vision-science.com/"},
    {"name":"Universe Scientific Publishing","url":"http://www.usp-pl.com/"},
]

POTENTIAL_PREDATORY_JOURNALS = [
    {"name":"Academic Exchange Quarterly","url":"http://www.rapidintellect.com/AEQweb/"},
    {"name":"Academic Research Reviews","url":"http://academicreviews.us/Default.aspx"},
    {"name":"Academy of Contemporary Research Journal ","url":"http://aocrj.org/"},
    {"name":"ACME Intellects","url":"http://www.acmeintellects.org/"},
    {"name":"Acta  de Gerencia Ciencia","url":"http://www.cagena.com/"},
    {"name":"Acta Advances in Agricultural Sciences","url":"http://www.aaasjournal.com/"},
    {"name":"Acta Kinesiologica","url":"http://www.actakin.com/"},
    {"name":"Acta Medica International","url":"http://www.tmu.ac.in/acta_publications.htm"},
    {"name":"Acta Scientiae et Intellectus","url":"http://www.actaint.com/"},
    {"name":"Acta Velit","url":"http://actavelit.com/"},
    {"name":"Advance Journals of Engineering Mathematics and Computer Sciences","url":"http://ajemc.in/index.php/ajemc"},
    {"name":"Advance Research Journal of Multidisciplinary Discoveries","url":"http://www.journalresearchijf.com/"},
    {"name":"The Advanced Science Journal","url":"http://advancedscience.org/"},
    {"name":"Advances in Aerospace Science and Technology","url":"http://www.scirp.org/journal/AAST"},
    {"name":"Advances in Biomedicine and Pharmacy","url":"http://www.thescientificpub.com/"},
    {"name":"Advances in Forestry Letter","url":"http://www.afl-journal.org/index.aspx"},
    {"name":"Advances in Science, Technology and Engineering Systems Journal","url":"http://www.astesj.com/"},
    {"name":"Afrasian Journal of Humanities and Social Sciences","url":"http://www.aajhss.org/index.php/aajhss"},
    {"name":"African Journal of Traditional, Complementary and Alternative Medicines","url":"http://journals.sfu.ca/africanem/index.php/ajtcam/index"},
    {"name":"Aging","url":"http://www.impactaging.com/index.html"},
    {"name":"Ahead International Journal of Recent Research Review","url":"http://www.aijrrr.com/"},
    {"name":"Al Ameen Journal of Medical Sciences","url":"http://ajms.alameenmedical.org/"},
    {"name":"Aloy Journal of Soft Computing and Applications","url":"http://ajsca.org/"},
    {"name":"American Based Research Journal","url":"http://www.abrj.org/"},
    {"name":"American International Journal of Contemporary Research","url":"http://aijcrnet.com/"},
    {"name":"American International Journal of Contemporary Scientific Research","url":"http://www.americanij.com/"},
    {"name":"American Journal of Advanced Agricultural Research","url":"http://www.esterdjipress.org/index.php/AJAAR"},
    {"name":"American Journal of Advanced Drug Delivery","url":"http://ojadd.com/index.php/AJADD"},
    {"name":"American Journal of Advanced Scientific Research","url":"http://www.esterdjipress.org/index.php/AJAAR"},
    {"name":"American Journal of Advances in Medical Science","url":"http://www.arnaca.com/"},
    {"name":"American Journal of Biotechnology and Medical Research","url":"http://my.ejmanager.com/ajbmr/"},
    {"name":"American Journal of Engineering Research","url":"http://www.ajer.org/"},
    {"name":"American Journal of Essential Oils and Natural Products","url":"http://essencejournal.com/index.html"},
    {"name":"American Journal of Innovative Research and Applied Sciences","url":"http://american-jiras.com/"},
    {"name":"American Journal of Pharmacy and Health Research","url":"http://www.ajphr.com/"},
    {"name":"American Journal of PharmTech Research","url":"http://www.ajptr.com/"},
    {"name":"American Journal of Phytomedicine and Clinical Therapeutics","url":"http://www.ajpct.org/"},
    {"name":"American Journal of Research Communication","url":"http://www.usa-journals.com/"},
    {"name":"American Journal of Scientific Research","url":"http://www.americanjournalofscientificresearch.com/"},
    {"name":"American Journal of Social issues and Humanities ","url":"http://www.ajsih.org/index.php/ajsih"},
    {"name":"American Research Thoughts","url":"http://researchthoughts.us/Default.aspx"},
    {"name":"American Scientific Research Journal for Engineering, Technology, and Sciences","url":"http://asrjetsjournal.org/"},
    {"name":"American Transactions on Engineering & Applied Sciences","url":"http://tuengr.com/ATEAS/index.html"},
    {"name":"Anglisticum","url":"http://www.anglisticum.mk/index.php"},
    {"name":"Annals of EURASIAN MEDICIN","url":"http://www.aemed.eu/en/index.php"},
    {"name":"Annals of British Medical Sciences","url":"http://abmsj.co.uk/index.htm"},
    {"name":"Annals of Clinical Case Reports","url":"http://anncaserep.com/"},
    {"name":"Annals of International Medical and Dental Research","url":"http://aimdrjournal.com/"},
    {"name":"Annals of Medical and Biomedical Sciences","url":"http://ambs-journal.co.uk/"},
    {"name":"Annals of Phytomedicine","url":"http://ukaazpublications.com/publications/index.php"},
    {"name":"Applied Research Journal","url":"http://arjournal.org/"},
    {"name":"Archives Des Sciences Journal","url":"http://www.sciencesarchive.com/"},
    {"name":"ARNACA American Journal of Advances in Medical Science","url":"http://arnaca.com/"},
    {"name":"ARPN Journal of Science and Technology","url":"http://ejournalofscience.org/"},
    {"name":"ARPN Journal of Systems and Software","url":"http://www.scientific-journals.org/"},
    {"name":"Asia Pacific Journal of Education, Arts and Sciences","url":"http://apjeas.apjmr.com/"},
    {"name":"Asia Pacific Journal of Multidisciplinary Research","url":"http://www.apjmr.com/"},
    {"name":"Asian Pacific Journal of Natural Products","url":"http://ainstin.com/asian-pacific-journal-of-natural-products"},
    {"name":"Asian Pacific Journal of Pharmacy and Phytochemistry","url":"http://apjpp.com/"},
    {"name":"Asia-Pacific Journal of Research","url":"http://apjor.com/index.php"},
    {"name":"Asian Journal of Applied Science and Engineering","url":"http://ajase.weebly.com/"},
    {"name":"Asian Journal of Biomedical and Pharmaceutical Sciences","url":"http://www.jbiopharm.com/index.php/ajbp"},
    {"name":"Asian Journal of Chemistry","url":"http://www.asianjournalofchemistry.co.in/Home.aspx"},
    {"name":"Asian Journal of Health and Medical Sciences","url":"http://www.ajhms.org/"},
    {"name":"Asian Journal of Humanities and Social Sciences","url":"http://ajhss.org/"},
    {"name":"Asian Journal of Business and Management Sciences","url":"http://www.ajbms.org/index.php"},
    {"name":"Asian Journal of Mathematics and Applications","url":"http://scienceasia.asia/index.php/ama"},
    {"name":"Asian Journal of Multidisciplinary Studies","url":"http://www.ajms.co.in/sites/ajms/index.php/ajms"},
    {"name":"Asian Journal of Pharmaceutical and Health Sciences","url":"http://ajphs.com/"},
    {"name":"Asian Journal of Pharmacy and Life Science","url":"http://www.ajpls.com/index.html"},
    {"name":"Asian Journal of Pharmaceutical Research and Health Care","url":"http://jprhc.in/index.php"},
    {"name":"Asian Journal of Science and Technology","url":"http://www.journalajst.com/"},
    {"name":"Asian Pacific Journal of Health Sciences","url":"http://www.apjhs.com/index.html"},
    {"name":"Asian Pacific Journal of Tropical Disease","url":"http://www.apjtcm.com/"},
    {"name":"Asian Research Journal of Business Management","url":"http://www.arjbm.com/index.php"},
    {"name":"Australasian Journal of Herpetology","url":"http://www.smuggled.com/AJHFP1.htm"},
    {"name":"JCR","url":"https://mjl.clarivate.com/search-results?issn=1836-1935"},
    {"name":"Australian Journal of Basic and Applied Sciences","url":"http://www.ajbasweb.com/"},
    {"name":"Australian Journal of Business and Management Research","url":"http://www.ajbmr.com/index.php"},
    {"name":"Astronomical Review","url":"http://journals.ke-i.org/index.php/AstRv"},
    {"name":"Averroes European Medical Journal","url":"http://www.averroes-emj.com/"},
    {"name":"Ayupharm: International Journal of Ayurveda and Allied Sciences","url":"http://www.ayurpharm.com/"},
    {"name":"Ayushdhar","url":"http://ayushdhara.in/index.php/ayushdhara"},
    {"name":"Bio Bulletin","url":"http://www.biobulletin.com/"},
    {"name":"Bioinformation","url":"http://bioinformation.net/"},
    {"name":"Biointerface Research in Applied Chemistry","url":"http://biointerfaceresearch.com/"},
    {"name":"Biomaterials and Tissue Engineering Bulletin","url":"http://btebulletin.com/"},
    {"name":"Biomedical & Pharmacology Journa","url":"http://www.biomedpharmajournal.org/"},
    {"name":"Biomedical Engineering Review","url":"http://journals.ke-i.org/index.php/bme"},
    {"name":"Bionano Frontier","url":"http://bionanofrontier.org/"},
    {"name":"Biopharm Journal","url":"http://www.biopharmj.com/"},
    {"name":"The Bioscan","url":"http://www.thebioscan.in/index.htm"},
    {"name":"Bioresearch Bulletin","url":"http://bioresonline.org/"},
    {"name":"Bioscience and Bioengineering Communications","url":"http://www.bioscibioeng.com/"},
    {"name":"Bioscience Biotechnology Research Communications","url":"http://www.bbrc.in/"},
    {"name":"Bioscience Discovery","url":"http://biosciencediscovery.com/index.html#gsc.tab=0"},
    {"name":"Biosciences, Biotechnology Research Asia","url":"http://www.biotech-asia.org/"},
    {"name":"Biosciences International","url":"http://biosciencesjournal.info/index.php/biointl/"},
    {"name":"Biotechnological Research","url":"http://www.biotechnologicalresearch-journal.com/"},
    {"name":"Botany Journal","url":"http://plantsjournal.com/"},
    {"name":"British Biomedical Bulletin","url":"http://bbbulletin.org/"},
    {"name":"British Journal of Economics, Finance and Management Sciences","url":"http://www.ajournal.co.uk/BJEFM.htm"},
    {"name":"British Journal of Interdisciplinary Studies","url":"http://www.bjis-online.org/index.php/bjis"},
    {"name":"British Journal of Medical and Health Research","url":"http://www.bjmhr.com/index.php"},
    {"name":"British Journal of Science","url":"http://www.ajournal.co.uk/index.htm"},
    {"name":"Buletin Teknologi Makanan","url":"http://www.btmjournal.com/index.html"},
    {"name":"Bulletin of Applied and Research Science","url":"http://www.barsjournal.net/"},
    {"name":"Bulletin of Mathematical Sciences & Applications","url":"http://www.bmsa.us/index.php"},
    {"name":"Bulletin of Pharmaceutical Research","url":"http://journal.appconnect.in/"},
    {"name":"Bulletin of Society for Mathematical Services and Standards","url":"http://www.jsomass.com/index.php"},
    {"name":"Business and Economics Journal","url":"http://www.irbejournal.com/"},
    {"name":"The Business Review, Cambridge","url":"http://www.jaabc.com/brc.html"},
    {"name":"Calodema","url":"http://www.calodema.com/"},
    {"name":"Canadian Chemical Transactions","url":"http://canchemtrans.ca/"},
    {"name":"Canadian International Journal of Science and Technology","url":"http://www.tcsse.org/#!journal/ct84"},
    {"name":"Canadian Journal of Basic and Applied Sciences","url":"http://www.cjbas.com/"},
    {"name":"Canadian Journal of Biotechnology","url":"http://www.canadianjbiotech.com/index.php"},
    {"name":"Canadian Journal of Pure and Applied Sciences","url":"http://www.cjpas.net/"},
    {"name":"Canadian Scientific Journal","url":"http://csjournal.ca/"},
    {"name":"Cancer Research Frontiers","url":"http://cancer-research-frontiers.org/"},
    {"name":"Cardiology and Cardiovascular Medicine","url":"http://www.cardiolcardiovascmed.com/"},
    {"name":"Caribbean Journal of Science and Technology","url":"http://caribjscitech.com/"},
    {"name":"Case Study and Case Report","url":"http://www.scopemed.org/?jid=23"},
    {"name":"Caspian Sea Journal","url":"http://csjonline.org/index.php"},
    {"name":"Cellular and Molecular Biology","url":"http://www.cellmolbiol.com/"},
    {"name":"Cellular and Molecular Biology","url":"http://www.omicsonline.com/open-access/cellular-and-molecular-biology.php"},
    {"name":"Centrum","url":"http://www.centrum.mk/"},
    {"name":"Chemical Science Transactions","url":"http://www.e-journals.in/"},
    {"name":"Chemistry Research Journal","url":"http://chemrj.org/"},
    {"name":"Clinics in Oncology","url":"http://www.clinicsinoncology.com/"},
    {"name":"Clinics in Surgery","url":"http://www.clinicsinsurgery.com/"},
    {"name":"Columban Journal of Life Sciences","url":"http://cjlscience.org/"},
    {"name":"Communications on Applied Electronics","url":"http://www.caeaccess.org/"},
    {"name":"Computational Research Progress in Applied Science & Engineering","url":"http://www.crpase.com/"},
    {"name":"Computer Science Chronicle","url":"http://www.cschronicle.org/"},
    {"name":"Computer Science Journal","url":"http://comsj.org/"},
    {"name":"Contemporary Research in India","url":"http://www.contemporaryresearchindia.net/"},
    {"name":"Contemporary Sociological Global Review","url":"http://www.csgr.syllabapress.us/index.html"},
    {"name":"The Criterion: An International Journal in English","url":"http://www.the-criterion.com/"},
    {"name":"Current Biotica","url":"http://www.currentbiotica.com/"},
    {"name":"Current Botany","url":"http://currentbotany.org/index.php/currbotany/"},
    {"name":"Current Discovery","url":"http://www.ijcdi.com/"},
    {"name":"Current Trends in Technology and Sciences","url":"http://www.ctts.in/"},
    {"name":"DAV International Journal of Science","url":"http://davjournal.com/"},
    {"name":"Dawn Journal","url":"http://thedawnjournal.com/"},
    {"name":"Der Pharma Chemica","url":"http://derpharmachemica.com/"},
    {"name":"Direct Research Journals","url":"http://directresearchjournals.org/index.html"},
    {"name":"Diyala Journal for Pure Science","url":"http://www.sciencesmag.uodiyala.edu.iq/"},
    {"name":"East European Science Journal","url":"http://eesa-journal.com/en/"},
    {"name":"Eastern Academic Journal","url":"http://www.e-acadjournal.org/"},
    {"name":"Eastern European Scientific Journal","url":"http://journale.auris-verlag.de/index.php/EESJ"},
    {"name":"E-Library Science Research Journal","url":"http://lsrj.in/Default1.aspx"},
    {"name":"Ecoforum","url":"http://www.ecoforumjournal.ro/index.php/eco"},
    {"name":"Ecoletra.com Scientific eJournal","url":"http://ebook.ecoletra.com/ecoletra-com-scientific-ejournal"},
    {"name":"EDUVED Global Management Research","url":"http://egmr.eduved.org/"},
    {"name":"Eduved, International Journal of Interdisciplinary Research","url":"http://www.eduved.org/"},
    {"name":"Electronic Journal of Biology","url":"http://www.ejbio.com/"},
    {"name":"Electronic Journal of Engineering and Technology","url":"http://www.ejet.org.uk/index.html"},
    {"name":"Electronic Journal of Geotechnical Engineering","url":"http://www.ejge.com/"},
    {"name":"Electronic Journal of Vocational Colleges","url":"http://www.ejovoc.org/default.aspx"},
    {"name":"Elixir International Journal","url":"http://www.elixirpublishers.com/"},
    {"name":"Elixir Online  Journal","url":"http://www.elixirjournal.org/"},
    {"name":"Engineering & IT Journal","url":"http://www.eitjournal.com/"},
    {"name":"Engineering Physics and Thermodynamics Journal","url":"http://djphys.org/"},
    {"name":"Engineering Research Journal","url":"http://www.mnf-eng.com/"},
    {"name":"Entomology and Applied Science Letters","url":"http://easletters.com/"},
    {"name":"ESSENCE: International Journal for Environmental Rehabilitation and Conservation","url":"http://essence-journal.com/"},
    {"name":"Euro-Afro Journal of Arts and Social Sciences","url":"http://euro-afrojournals.com/index.php"},
    {"name":"European Academic Research","url":"http://www.euacademic.org/Default.aspx"},
    {"name":"European Chemical Bulletin","url":"http://www.eurchembull.com/index.php/ECB"},
    {"name":"European Environmental Sciences and Ecology Journal","url":"http://www.eesej.eu/"},
    {"name":"European International Journal of Science and Humanities","url":"http://www.eijsr.org/"},
    {"name":"European International Journal of Science and Technology","url":"http://www.cekinfo.org.uk/EIJST"},
    {"name":"European Journal of Academic Essays","url":"http://euroessays.org/"},
    {"name":"European Journal of Advanced Computer Science","url":"http://eujcs.eu/"},
    {"name":"European Journal of Advances in Engineering & Technology","url":"http://ejaet.com/theme.php?go=home"},
    {"name":"European Journal of Biomedical and Pharmaceutical Sciences","url":"http://www.ejbps.com/"},
    {"name":"European Journal of Biotechnology and Bioscience","url":"http://www.biotechjournal.info/"},
    {"name":"European Journal of Business and Social Sciences","url":"http://www.ejbss.com/home.aspx"},
    {"name":"European Journal of Chemistry","url":"http://www.eurjchem.com/index.php/eurjchem"},
    {"name":"European Journal of Contemporary Economics and Management","url":"http://ejcem.eu/"},
    {"name":"European Journal of Economics, Finance and Administrative Sciences","url":"http://www.europeanjournalofeconomicsfinanceandadministrativesciences.com/"},
    {"name":"European Journal of Educational Research","url":"http://eurojedu.com/"},
    {"name":"European Journal of Educational Sciences","url":"http://www.ejes.eu/"},
    {"name":"European Journal of Engineering Research and Science","url":"http://www.ejers.org/index.php/ejers"},
    {"name":"European Journal of Natural History","url":"http://world-science.ru/euro/"},
    {"name":"European Journal of Pharmaceutical and Medical Research","url":"http://www.ejpmr.com/"},
    {"name":"European Journal of Science and Theology","url":"http://www.ejst.tuiasi.ro/"},
    {"name":"European Journal of Scientific Research","url":"http://www.europeanjournalofscientificresearch.com/"},
    {"name":"European Journal of Social Sciences","url":"http://www.europeanjournalofsocialsciences.com/index.html"},
    {"name":"European Journal of Sustainable Development","url":"http://www.ecsdev.org/"},
    {"name":"European Law and Politics Journal","url":"http://elpjournal.eu/"},
    {"name":"European Online Journal of Natural and Social Sciences","url":"http://european-science.com/eojnss/index"},
    {"name":"European Scientific Journal","url":"http://eujournal.org/index.php/esj"},
    {"name":"Experiment","url":"http://www.experimentjournal.com/"},
    {"name":"First Independent Scientific Journal","url":"http://firjournal.com.ua/"},
    {"name":"FLUIDS: International Journal of Medical Fluid Management","url":"http://www.fluidsjournal.org/"},
    {"name":"Food Biology","url":"http://foodbiology.org/index.php/foodbio/"},
    {"name":"FOREX Technical Journal Library","url":"http://www.forexjournal.co.in/Index.aspx"},
    {"name":"Frontiers in Aerospace Engineering","url":"http://www.fae-journal.org/index.aspx"},
    {"name":"Functional Analysis: Theory, Method & Applications","url":"http://jfatma.com/index.php"},
    {"name":"G-Journal of Environmental Science and Technology","url":"http://gjestenv.com/"},
    {"name":"G-Journal of Education, Social Science and Humanities","url":"http://gjestenv.com/"},
    {"name":"Galaxy: International Multidisciplinary Research Journal","url":"http://www.galaxyimrj.com/"},
    {"name":"Genes & Cancer","url":"http://www.impactjournals.com/Genes&Cancer/"},
    {"name":"Generics and Biosimilars Initiative Journal","url":"http://gabi-journal.net/"},
    {"name":"Genetics and Molecular Research","url":"http://www.geneticsmr.com/"},
    {"name":"Geodynamics Research International Bulletin","url":"http://www.geo-dynamica.com/"},
    {"name":"Global Journal for Research Analysis","url":"http://worldwidejournals.com/gra/"},
    {"name":"Global Journal of Advanced Engineering Technologies and Sciences","url":"http://www.gjaets.com/"},
    {"name":"Global Journal of Advanced Research ","url":"http://www.gjar.org/"},
    {"name":"Global Journal of Animal Scientific Research","url":"http://www.gjasr.com/"},
    {"name":"Global Journal of Business and Social Science","url":"http://www.gjbss.com/"},
    {"name":"Global Journal of Business and Social Science Review","url":"http://www.gjbssr.org/"},
    {"name":"Global Journal of Engineering Science and Research Management","url":"http://www.gjesrm.com/"},
    {"name":"Global Journal of Management Science and Technology","url":"http://gjmst.com/index.htm"},
    {"name":"Global Journal of Medical and Health Sciences","url":"http://globaljmhs.org/"},
    {"name":"Global Journal of Medicine and Public Health","url":"http://www.gjmedph.org/"},
    {"name":"Global Journal of Multidisciplinary Studies","url":"http://www.gjms.co.in/index.php/gjms/index"},
    {"name":"Global Media Journal","url":"http://www.globalmediajournal.com/"},
    {"name":"Golden Research Thoughts","url":"http://aygrt.isrj.org/Default.aspx"},
    {"name":"Global Scholastic Research Journal","url":"http://globalscholasticresearch.org/"},
    {"name":"HCTL Open International Journal of Technology Innovations and Research","url":"http://ijtir.hctl.org/"},
    {"name":"Hiperboreea Journal","url":"http://revistahiperboreea.ro/"},
    {"name":"HortFlora Research Spectrum","url":"http://hortflorajournal.com/"},
    {"name":"Hygeia: Journal for Drugs and Medicines","url":"http://www.hygeiajournal.com/"},
    {"name":"IARS’ International Research Journal","url":"http://www.irj.iars.info/index.php"},
    {"name":"Ideal Journal of Arts and Humanities","url":"http://ijah.truescholar.org/"},
    {"name":"Ideal Journal of Engineering and Applied Sciences","url":"http://ijeas.truescholar.org/"},
    {"name":"Ideal Journal of Economics and Management Sciences","url":"http://ijems.truescholar.org/"},
    {"name":"Ideal Journal of Pure and Applied Sciences","url":"http://ijopas.truescholar.org/"},
    {"name":"Ideal Journal of Education and Policy Studies","url":"http://ijeps.truescholar.org/"},
    {"name":"Ideal Journal of Psychology and Theology","url":"http://ijopat.truescholar.org/"},
    {"name":"Indian Journal of Advanced Nursing","url":"http://ijan.co.in/"},
    {"name":"Indian Journal of Applied-Basic Medical Sciences","url":"http://www.themedicalacademy.in/"},
    {"name":"Indian Journal of Applied Research","url":"http://www.theglobaljournals.com/ijar/index.php"},
    {"name":"Indian Journal of Drugs","url":"http://drugresearch.in/"},
    {"name":"Indian Journal of Medical Research and Pharmaceutical Sciences","url":"http://www.ijmrps.com/"},
    {"name":"Indian Journal of Natural Sciences","url":"http://tnsroindia.org.in/journals.html"},
    {"name":"Indian Journal of Pharmaceutical and Biological Research","url":"http://ijpbr.in/"},
    {"name":"Indian Journal of Pharmaceutical Science & Research","url":"http://www.ijpsrjournal.com/index.php"},
    {"name":"Indian Journal of Research Anvikshiki","url":"http://www.anvikshikijournal.com/"},
    {"name":"Indian Journal of Research in Pharmacy and Biotechnology","url":"http://www.ijrpb.com/"},
    {"name":"Indian Journal of Scientific Research ","url":"http://www.ijsr.in/index.php"},
    {"name":"Indian Journal of Scientific Research and Technology","url":"http://www.indjsrt.com/"},
    {"name":"Indian Research Journal of Pharmacy and Science","url":"http://irjps.in/"},
    {"name":"Indian Scholar","url":"http://www.indianscholar.co.in/"},
    {"name":"Indian Streams Research Journal","url":"http://isrj.org/Default.aspx"},
    {"name":"Indo American Journal of Pharmaceutical Research","url":"http://www.iajpr.com/"},
    {"name":"Indo American Journal of Pharmaceutical Sciences","url":"http://iajps.com/"},
    {"name":"Indo-Global Journal of Pharmaceutical Sciences","url":"http://iglobaljournal.com/"},
    {"name":"Industrial Science Journal","url":"http://www.industrialscience.org/Default.aspx"},
    {"name":"INFORMATION-An International Interdisciplinary Journal","url":"http://www.information-iii.org/information_journal.html"},
    {"name":"Innovations in Pharmaceuticals and Pharmacotherapy","url":"http://www.innpharmacotherapy.com/Default.aspx"},
    {"name":"Institute of Electrical & Electronics Engineers Advanced Journal","url":"http://www.ieeeaj.com/"},
    {"name":"Integrated Journal of British","url":"http://www.ijbritish.com/"},
    {"name":"Interdisciplinary Journal of Contemporary Research in Business","url":"http://ijcrb.webs.com/"},
    {"name":"Interdisciplinary Journal of Research in Business","url":"http://www.idjrb.com/index.php"},
    {"name":"Interdisciplinary Toxicology","url":"http://www.intertox.sav.sk/"},
    {"name":"Internal Medicine Review","url":"http://internalmedicinereview.org/index.php/imr"},
    {"name":"International Advanced Research Journal in Science, Engineering and Technology","url":"http://iarjset.com/"},
    {"name":"International Archives of BioMedical and Clinical Research","url":"http://iabcr.org/"},
    {"name":"International Archives of Medicine","url":"http://www.intarchmed.com/"},
    {"name":"International Ayurvedic Medical Journal","url":"http://www.iamj.in/"},
    {"name":"The International Asian Research Journal ","url":"http://www.tiarj.com/"},
    {"name":"International Biology Review","url":"http://journals.ke-i.org/index.php/IBR"},
    {"name":"International Bulletin of Business Administration","url":"http://www.internationalbulletinofbusinessadministration.com/"},
    {"name":"International Cardiovascular Forum","url":"http://icfjournal.org/"},
    {"name":"International Cardiovascular Forum","url":"http://journals.sfu.ca/icfj/index.php/icfj/index"},
    {"name":"International Chemistry Review","url":"http://journals.ke-i.org/index.php/icr"},
    {"name":"International Design Journal","url":"http://www.journal.faa-design.com/index.htm"},
    {"name":"International Economic Letters","url":"http://www.ielonline.eu/"},
    {"name":"International Education and Research Journal","url":"http://www.ierj.in/"},
    {"name":"International Educational E-Journal","url":"http://oiirj.org/oiirj/ejournal/"},
    {"name":"International Educational Scientific Research Journal","url":"http://iesrj.com/"},
    {"name":"International Interdisciplinary Journal of Education","url":"http://iijoe.org/"},
    {"name":"International Interdisciplinary Journal of Scientific Research","url":"http://www.iijsr.org/"},
    {"name":"International Journal & Magazine of Engineering, Technology, Management and Research","url":"http://www.ijmetmr.com/"},
    {"name":"International Journal Advances in Social Science and Humanities ","url":"http://www.ijassh.com/index.php"},
    {"name":"International Journal and Bulletin of Multidisciplinary Research","url":"http://www.ijnmr.com/"},
    {"name":"International Journal for Advanced Review and Research in Pharmacy","url":"http://www.ijarrp.com/"},
    {"name":"International Journal for Development of Computer Science and Technology","url":"http://ijdcst.com/Default.aspx"},
    {"name":"International Journal for Innovation Education and Research","url":"http://www.ijier.net/"},
    {"name":"International Journal for Innovative Research in Multidisciplinary Field","url":"http://ijirmf.com/"},
    {"name":"International Journal for Innovative Research in Science and Technology","url":"http://www.ijirst.org/"},
    {"name":"International Journal for Modern Trends in Science and Technology","url":"http://www.ijmtst.com/index.html"},
    {"name":"International Journal for Pharmaceutical Research Scholars","url":"http://www.ijprs.com/"},
    {"name":"International Journal for Research & Development in Technology","url":"http://ijrdt.org/"},
    {"name":"International Journal for Research in Applied Science and Engineering Technology","url":"http://www.ijraset.com/"},
    {"name":"International Journal for Research in Emerging Science and Technology","url":"http://ijrest.net/"},
    {"name":"International Journal for Research in Engineering Application & Management","url":"http://www.ijream.org/"},
    {"name":"International Journal for Scientific Research & Development","url":"http://www.ijsrd.com/"},
    {"name":"International Journal for Technological Research in Engineering","url":"http://www.ijtre.com/home/"},
    {"name":"International Journal of Abdominal Research","url":"http://blackhorse.nazwa.pl/public_html/ojs/index.php/ijar"},
    {"name":"International Journal of Academic Research","url":"http://www.ijar.org.in/index.php"},
    {"name":"International Journal of Academic Studies","url":"http://www.ijacademicstudies.com/"},
    {"name":"International Journal of Advance Computing Techniques and Applications","url":"http://www.ijacta.com/index.php/ojs"},
    {"name":"International Journal of Advance Engineering and Research Development","url":"http://www.ijaerd.com/"},
    {"name":"International Journal of Advance Foundation and Research in Computer","url":"http://www.ijafrc.org/"},
    {"name":"International Journal of Advance Foundation and Research in Science and Engineering","url":"http://ijafrse.org/"},
    {"name":"International Journal of Advance Research and Innovation","url":"http://www.ijari.org/"},
    {"name":"International Journal of Advance Research and Innovative Ideas in Education","url":"http://ijariie.com/"},
    {"name":"International Journal of Advance Research, Ideas and Innovations in Technology ","url":"http://www.ijariit.com/"},
    {"name":"International Journal of Advance Research in Computer Science And Management","url":"http://www.ijarcsms.com/"},
    {"name":"International Journal of Advance Research in Science and Engineering","url":"http://www.ijarse.com/"},
    {"name":"International Journal of Advanced Academic Research","url":"http://www.ijaar.org/"},
    {"name":"International Journal of Advanced and Innovative Research","url":"http://ijair.jctjournals.com/"},
    {"name":"International Journal of Advanced Computer Technology","url":"http://www.ijact.org/"},
    {"name":"International Journal of Advanced Computer Technology","url":"http://ijact.in/"},
    {"name":"International Journal of Advanced Education and Research","url":"http://www.alleducationjournal.com/"},
    {"name":"International Journal of Advanced Engineering and Management Research","url":"http://www.ijaemr.com/"},
    {"name":"International Journal of Advanced Engineering and Nano Technology","url":"http://www.ijaent.org/"},
    {"name":"International Journal of Advanced Engineering Applications","url":"http://fragrancejournals.com/"},
    {"name":"International Journal of Advanced Engineering, Management and Science","url":"http://ijaems.com/"},
    {"name":"International Journal of Advanced Engineering Research and Applications","url":"http://www.ijaera.org/"},
    {"name":"International Journal of Advanced Engineering Research and Science","url":"http://www.ijaers.com/"},
    {"name":"International Journal of Advanced Engineering Science and Technological Research","url":"http://www.ader.org.in/"},
    {"name":"International Journal of Advanced Engineering Science and Technological Research","url":"http://www.aestjournal.org/"},
    {"name":"International Journal of Advanced Information in Arts Science and Management","url":"http://www.ijaiasm.com/"},
    {"name":"International Journal of Advanced Information Science and Technology","url":"http://www.ijaist.com/"},
    {"name":"International Journal of Advanced Life Sciences","url":"http://ijals.com/"},
    {"name":"International Journal of Advanced Multidisciplinary Research","url":"http://ijarm.com/index.html"},
    {"name":"International Journal of Advanced Networking and Applications","url":"http://www.ijana.in/"},
    {"name":"International Journal of Advanced Research","url":"http://www.journalijar.com/index.php"},
    {"name":"International Journal of Advanced Research and Review","url":"http://www.ijarr.in/"},
    {"name":"International Journal of Advanced Research in Applied Science and Technology","url":"http://ijarast.com/"},
    {"name":"International Journal of Advanced Research in Biological Sciences","url":"http://www.ijarbs.com/"},
    {"name":"International Journal of Advanced Research in Biology, Ecology, Science and Technology","url":"http://www.ijarbest.com/"},
    {"name":"International Journal of Advanced Research in Computer and Communication Engineering","url":"http://www.ijarcce.com/"},
    {"name":"International Journal of Advanced Research in Computer Science and Electronics Engineering","url":"http://ijarcsee.org/index.php/IJARCSEE"},
    {"name":"International Journal of Advanced Research in Computer Science and Software Engineering","url":"http://www.ijarcsse.com/"},
    {"name":"International Journal of Advanced Research in Computer Science & Technology","url":"http://www.ijarcst.com/index.html"},
    {"name":"International Journal of Advanced Research in Education & Technology","url":"http://ijaret.com/"},
    {"name":"International Journal of Advanced Research in Electrical, Electronics and Instrumentation Engineering","url":"http://www.ijareeie.com/"},
    {"name":"International Journal of Advanced Research in Engineering & Management","url":"http://www.ijarem.org/"},
    {"name":"International Journal of Advanced Research in Engineering and Science","url":"http://www.ijares.com/"},
    {"name":"International Journal of Advanced Research in Mechanical Engineering & Technology","url":"http://ijarmet.com/"},
    {"name":"International Journal of Advanced Research in Science and Technology","url":"http://www.ijarst.com/"},
    {"name":"International Journal of Advanced Research in Science, Engineering and Technology","url":"http://www.ijarset.com/"},
    {"name":"International Journal of Advanced Science and Engineering Technology","url":"http://www.ijaset.com/"},
    {"name":"International Journal of Advanced Scientific Research & Development","url":"https://www.ijasrd.org/in/"},
    {"name":"International Journal of Advanced Technology and Innovative Research","url":"http://www.ijatir.org/"},
    {"name":"International Journal of Advanced Technology in Engineering and Science","url":"http://www.ijates.com/"},
    {"name":"International Journal of Advanced Technology and Engineering Research","url":"http://www.ijater.com/"},
    {"name":"International Journal of Advanced Technology and Science","url":"http://www.ijats.org/"},
    {"name":"International Journal of Advanced Trends in Computer Applications","url":"http://ijatca.com/"},
    {"name":"International Journal of Advancement in Engineering Technology, Management & Applied Science","url":"http://www.ijaetmas.com/"},
    {"name":"International Journal of Advancements in Mechanical and Aeronautical Engineering","url":"http://www.ijamae.uamae.org/editorial_board.html"},
    {"name":"International Journal of Advancements in Research & Technology ","url":"http://www.ijoart.org/"},
    {"name":"International Journal of Advances in Applied Mathematics and Mechanics","url":"http://www.ijaamm.com/"},
    {"name":"International Journal of Advances in Engineering","url":"http://www.ijae.in/"},
    {"name":"International Journal of Advances in Engineering & Technology","url":"http://www.ijaet.org/"},
    {"name":"International Journal of Advances in Interdisciplinary Research","url":"https://www.academiascholarlyjournal.org/ijasrr"},
    {"name":"International Journal of Advances in Management and Economics","url":"http://www.managementjournal.info/"},
    {"name":"International Journal of Advances in Management, Economics and Entrepreneurship","url":"http://www.ijamee.info/"},
    {"name":"International Journal of Advances in Mathematics","url":"http://adv-math.com/"},
    {"name":"International Journal of Advances in Pharmaceutical Research","url":"http://www.ijapronline.org/index.php"},
    {"name":"International Journal of Advances in Power Systems ","url":"http://www.ijaps.org/Index/"},
    {"name":"International Journal of Advances in Social Science and Humanities","url":"http://www.ijassh.com/index.php"},
    {"name":"International Journal of Advent Research in Computer and Electronics","url":"http://ijarce.com/"},
    {"name":"International Journal of Aerospace and Mechanical Engineering","url":"http://www.ijamejournals.com/"},
    {"name":"International Journal of Agriculture and Crop Sciences","url":"http://ijagcs.com/"},
    {"name":"International Journal of Agriculture and Environmental Research","url":"http://ijaer.in/index.php"},
    {"name":"International Journal of Agriculture Innovations and Research","url":"http://ijair.org/"},
    {"name":"International Journal of Agricultural, Forestry & Plantation","url":"http://ijafp.com/"},
    {"name":"International Journal of Agricultural Sciences and Veterinary Medicine","url":"http://www.ijasvm.com/"},
    {"name":"International Journal of Agronomy & Plant Production","url":"http://www.ijappjournal.com/"},
    {"name":"International Journal of All Research Education & Scientific Methods","url":"http://www.ijaresm.com/"},
    {"name":"International Journal of Application or Innovation in Engineering & Management","url":"http://www.ijaiem.org/"},
    {"name":"International Journal of Applied and Pure Science and Agriculture","url":"http://ijapsa.com/"},
    {"name":"International Journal of Applied Biology and Pharmaceutical Technology","url":"http://www.ijabpt.com/index.html"},
    {"name":"International Journal of Applied Dental Sciences","url":"http://www.oraljournal.com/"},
    {"name":"International Journal of Applied Economic Studies","url":"http://sijournals.com/IJAE/"},
    {"name":"International Journal of Applied Information Systems","url":"http://www.ijais.org/"},
    {"name":"International Journal of Applied Linguistics & English Literature","url":"http://www.journals.aiac.org.au/index.php/IJALEL"},
    {"name":"International Journal of Applied Pharmaceutical & Biological Research","url":"http://www.ijapbr.com/"},
    {"name":"International Journal of Applied Pharmaceutical Sciences and Biological Sciences","url":"http://ijapsbs.com/"},
    {"name":"International Journal of Applied Research","url":"http://www.allresearchjournal.com/"},
    {"name":"International Journal of Applied Research & Studies","url":"http://www.ijars.in/"},
    {"name":"International Journal of Applied Research in Natural Products","url":"http://www.ijarnp.org/index.php/ijarnp"},
    {"name":"International Journal of Applied Science Engineering and Management","url":"http://www.ijasem.com/"},
    {"name":"International Journal of Applied Sciences and Biotechnology","url":"http://ijasbt.org/"},
    {"name":"International Journal of Applied Sciences and Engineering","url":"http://www.ijapscengr.com/"},
    {"name":"International Journal of Architecture, Civil Engineering and Urban Design","url":"http://iaajs.com/ijacu/"},
    {"name":"International Journal of Artificial Intelligence and Mechatronics","url":"http://www.ijaim.org/"},
    {"name":"International Journal of Art and Humanity Science","url":"http://www.ijahs.com/"},
    {"name":"International Journal of Arts and Commerce","url":"http://www.ijac.org.uk/"},
    {"name":"International Journal of Arts and Entrepreneurship","url":"http://www.ijsse.org/index.php?option=com_content&view=article&id=67&Itemid=63"},
    {"name":"International Journal of Arts, Humanities and Management Studies","url":"http://ijahms.com/"},
    {"name":"International Journal of Arts Humanities and Social Sciences","url":"http://www.ijahss.com/"},
    {"name":"International Journal of Ayurveda and Pharma Research","url":"http://ijapr.in/"},
    {"name":"International Journal of Ayurveda and Pharmaceutical Chemistry","url":"http://ijapc.com/"},
    {"name":"International Journal of Basic and Applied Science","url":"http://www.insikapub.com/"},
    {"name":"International Journal of Basic Medical Sciences and Pharmacy ","url":"http://www.ijbmsp.org/index.php/IJBMSP/index"},
    {"name":"International Journal of Basic Sciences and Applied Computing","url":"http://www.ijbsac.org/"},
    {"name":"International Journal of Basic Sciences and Applied Research","url":"https://https://www.textroad.com/Basic%20and%20Applied%20Scientific%20Research-Scope.html"},
    {"name":"International Journal of Bio","url":"http://www.ijobio.com/"},
    {"name":"International Journal of Bioassays","url":"https://www.ijbio.com/index.php/ijb"},
    {"name":"International Journal of Biological & Pharmaceutical Research","url":"http://www.ijbpr.com/"},
    {"name":"International Journal of Biological and Chemical Sciences","url":"http://www.ifgdg.org/index.php?option=com_content&view=featured&Itemid=564"},
    {"name":"International Journal of Biology, Pharmacy and Allied Sciences","url":"http://www.ijbpas.com/"},
    {"name":"International Journal of Biomedical Science","url":"http://www.ijbs.org/HomePage.aspx"},
    {"name":"International Journal of Biosciences and Nanosciences","url":"http://ijbsans.com/index.html"},
    {"name":"International Journal of Business and Administration Research Review","url":"http://www.ijbarr.com/"},
    {"name":"International Journal of Business and Commerce","url":"http://www.ijbcnet.com/"},
    {"name":"The International Journal of Business & Management","url":"http://www.theijbm.com/"},
    {"name":"International Journal of Business and Management Invention","url":"http://www.ijbmi.org/index.html"},
    {"name":"International Journal of Business and Social Research","url":"http://thejournalofbusiness.org/index.php/site"},
    {"name":"International Journal of Business Management and Economic Research","url":"http://www.ijbmer.com/index.php"},
    {"name":"International Journal of Business Management and Economic Studies","url":"http://www.ijbmes.com/"},
    {"name":"International Journal of Business Marketing and Management","url":"http://www.ijbmm.com/"},
    {"name":"International Journal of Business Quantitative Economics and Applied Management Research","url":"http://ijbemr.com/"},
    {"name":"International Journal of Business Tourism & Applied Sciences","url":"http://www.ijbts-journal.com/"},
    {"name":"International Journal of Case Studies","url":"http://www.casestudiesjournal.com/"},
    {"name":"International Journal of Chemical and Pharmaceutical Sciences","url":"http://www.ijcps.com/"},
    {"name":"International Journal of Chemical Science and Technology","url":"http://www.ijcst.net/"},
    {"name":"International Journal of Chemical Studies","url":"http://www.chemijournal.com/"},
    {"name":"International Journal of Civil, Mechanical and Energy Science","url":"http://ijcmes.com/"},
    {"name":"International Journal of Clinical and Diagnostic Research","url":"http://ijcdr.net/index.php"},
    {"name":"International Journal of Clinical Cases and Investigations","url":"http://ijcci.info/"},
    {"name":"International Journal of Collaborative Research on Internal Medicine & Public Health ","url":"http://www.iomcworld.com/ijcrimph/"},
    {"name":"International Journal of Commerce and Management Research","url":"http://www.managejournal.com/"},
    {"name":"International Journal of Communication and Health","url":"http://communicationandhealth.ro/"},
    {"name":"International Journal of Communication Networks and Information Security","url":"http://www.ijcnis.org/"},
    {"name":"International Journal of Comprehensive Research in Biological Sciences","url":"http://ijcrbs.com/index.php"},
    {"name":"International Journal of Computation and Applied Sciences","url":"https://ijocaas.com/"},
    {"name":"International Journal of Computational Engineering Research","url":"http://www.ijceronline.com/"},
    {"name":"International Journal of Computational Science, Mathematics and Engineering","url":"http://www.ijcsme.com/"},
    {"name":"International Journal of Computer & Electronics Research","url":"http://ijcer.org/"},
    {"name":"International Journal of Computer & Communication Engineering Research","url":"http://www.ijccer.org/"},
    {"name":"International Journal of Computer and Information Technology","url":"http://www.ijcit.com/"},
    {"name":"International Journal of Computer Applications","url":"http://www.ijcaonline.org/"},
    {"name":"International Journal of Computer Application and Engineering Technology","url":"http://www.ijcaet.net/"},
    {"name":"International Journal of Computer Applications in Engineering Sciences","url":"http://www.caesjournals.org/"},
    {"name":"International Journal of Computer Applications Technology and Research","url":"http://www.ijcat.com/Default"},
    {"name":"International Journal of Computer Engineering & Applications","url":"http://www.ijcea.com/"},
    {"name":"International Journal of Computer Engineering in Research Trends","url":"http://ijcert.org/"},
    {"name":"International Journal of Computer Networks and Applications","url":"http://www.ijcna.org/"},
    {"name":"International Journal of Computer Networks and Communications Security","url":"http://ijcncs.org/"},
    {"name":"International Journal of Computer Science & Communication Security","url":"http://www.ijcscs.org/"},
    {"name":"International Journal of Computer Science and Business Informatics","url":"http://www.ijcsbi.org/index.php/ijcsbi"},
    {"name":"International Journal of Computer Science and Communication Networks","url":"http://www.ijcscn.com/"},
    {"name":"International Journal of Computer Science and Information Security","url":"https://sites.google.com/site/ijcsis/"},
    {"name":"International Journal of Computer Science and Information Technologies","url":"http://www.ijcsit.com/index.php"},
    {"name":"International Journal of Computer Science and Mobile Computing","url":"http://www.ijcsmc.com/"},
    {"name":"International Journal of Computer Science and Network","url":"http://ijcsn.org/"},
    {"name":"International Journal of Computer Science and Network Security","url":"http://ijcsns.org/"},
    {"name":"International Journal of Computer Science and Software Engineering","url":"http://ijcsse.org/"},
    {"name":"International Journal of Computer Science and Technology","url":"http://ijcst.com/"},
    {"name":"International Journal of Computer Science and Telecommunications","url":"http://www.ijcst.org/"},
    {"name":"International Journal of Computer Science Engineering","url":"http://www.ijcse.net/index.php"},
    {"name":"International Journal of Computer Science Engineering and Technology","url":"http://ijcset.net/"},
    {"name":"International Journal of Computer Science, Information Technology, & Security","url":"http://ijcsits.org/"},
    {"name":"International Journal of Computer Science Issues","url":"http://ijcsi.org/index.php"},
    {"name":"International Journal of Computer Science Trends and Technology","url":"http://www.ijcstjournal.org/"},
    {"name":"International Journal of Computer Systems","url":"http://www.ijcsonline.com/"},
    {"name":"International Journal of Computer Technology and Applications","url":"http://www.ijcta.com/index.php"},
    {"name":"International Journal of Computer Technology and Electronics Engineering","url":"http://www.ijctee.org/"},
    {"name":"International Journal of Computing Academic Research","url":"http://www.meacse.org/ijcar/"},
    {"name":"International Journal of Computing and Corporate Research","url":"http://www.ijccr.com/"},
    {"name":"International Journal of Computing Science and Information Technology","url":"http://ijcsit.org/"},
    {"name":"International Journal of Conference Proceedings","url":"http://jocponline.com/"},
    {"name":"International Journal of Contemporary Applied Sciences","url":"http://ijcas.net/"},
    {"name":"International Journal of Contemporary Medical Research","url":"http://www.ijcmr.com/"},
    {"name":"International Journal of Contemporary Research and Review","url":"http://ijcrr.in/index.php/ijcrr"},
    {"name":"International Journal of Core Engineering and Management","url":"http://ijcem.in/"},
    {"name":"International Journal of Current Advanced Research","url":"http://journalijcar.org/"},
    {"name":"International Journal of Current Agricultural Sciences","url":"http://www.journalijcas.com/"},
    {"name":"International Journal of Current Business and Social Sciences","url":"https://scholarlyoa.com/individual-journals/International%20Journal%20of%20Current%20Business%20and%20Social%20Sciences%20(IJCBSS)"},
    {"name":"International Journal of Current Engineering Sciences","url":"http://www.journalijces.com/"},
    {"name":"International Journal of Current Innovation Research ","url":"http://journalijcir.com/"},
    {"name":"International Journal of Current Medical and Pharmaceutical Research","url":"http://journalcmpr.com/"},
    {"name":"International Journal of Current Medical Sciences","url":"http://journalijcmes.com/"},
    {"name":"International Journal of Current Microbiology and Applied Sciences","url":"http://www.ijcmas.com/"},
    {"name":"International Journal of Current Multidisciplinary Studies","url":"http://international%20journal%20of%20current%20multidisciplinary%20studies/"},
    {"name":"International Journal of Current Pharmaceutical Review and Research","url":"http://ijcpr.com/"},
    {"name":"International Journal of Current Research","url":"http://www.journalcra.com/"},
    {"name":"International Journal of Current Research and Academic Review","url":"http://www.ijcrar.com/"},
    {"name":"International Journal of Current Research and Review","url":"http://www.ijcrr.com/current_issue.html"},
    {"name":"International Journal of Current Research in Chemistry and Pharmaceutical Sciences","url":"http://www.ijcrcps.com/"},
    {"name":"International Journal of Current Research in  Life Sciences","url":"http://www.ijcrls.com/"},
    {"name":"International Journal of Current Research in Multidisciplinary","url":"http://www.ijcrm.com/"},
    {"name":"International Journal of Current Science","url":"http://currentsciencejournal.info/index.html"},
    {"name":"International Journal of Current Science and Technology","url":"http://www.journalijcst.com/"},
    {"name":"International Journal of Dental and Health Sciences","url":"http://www.ijdhs.com/home.html"},
    {"name":"International Journal of Dermatopathology and Surgery","url":"http://dermatopathologyjournal.com/"},
    {"name":"International Journal of Development and Sustainability","url":"http://isdsnet.com/journal.html"},
    {"name":"International Journal of Development Research","url":"http://www.journalijdr.com/"},
    {"name":"International Journal of Digital Communication and Networks","url":"http://ijdcn.co.in/"},
    {"name":"International Journal of Digital Library Services","url":"http://www.ijodls.in/"},
    {"name":"International Journal of Drug Development and Research","url":"http://www.ijddr.in/"},
    {"name":"International Journal of E-Computer Science Evolution","url":"http://www.ijecse.com/"},
    {"name":"International Journal of Economics and Finance","url":"http://www.ijsse.org/index.php?option=com_content&view=article&id=548&Itemid=82"},
    {"name":"International Journal of Economics and Research","url":"http://www.ijeronline.com/"},
    {"name":"International Journal of Economics, Commerce and Management","url":"http://ijecm.co.uk/"},
    {"name":"International Journal of Economics, Finance and Management","url":"http://www.ejournalofbusiness.org/"},
    {"name":"International Journal of Education and Applied Research","url":"http://ijear.org/"},
    {"name":"International Journal of Education and Psychological Research","url":"http://ijepr.org/"},
    {"name":"International Journal of Education and Research","url":"http://www.ijern.com/index.php"},
    {"name":"International Journal of Education and Social Science","url":"http://www.ijessnet.com/"},
    {"name":"The International Journal of Educational and Psychological Assessment","url":"https://sites.google.com/site/tijepa2012/home"},
    {"name":"International Journal of Educational Investigations","url":"http://www.ijeionline.com/"},
    {"name":"International Journal of Electrical and Electronics Engineers","url":"http://www.arresearchpublication.com/"},
    {"name":"International Journal of Electrical, Electronics and Computers","url":"http://eecjournal.com/"},
    {"name":"International Journal of Electrical, Electronics and Mechanical Controls","url":"http://www.ijeemc.com/"},
    {"name":"International Journal of Electrical Energy","url":"http://www.ijoee.org/"},
    {"name":"International Journal of Electrochemical Science","url":"http://www.electrochemsci.org/"},
    {"name":"International Journal of Electronics & Communication Technology","url":"http://iject.org/"},
    {"name":"International Journal of Electronics and Information Engineering","url":"http://ijeie.jalaxy.com.tw/"},
    {"name":"International Journal of Electronics Communication and Computer Engineering","url":"http://www.ijecce.org/"},
    {"name":"International Journal of Electronics Communication and Computer Technology","url":"http://www.ijecct.org/index.htm"},
    {"name":"International Journal of Emerging Engineering Research and Technology","url":"http://www.ijeert.org/"},
    {"name":"International Journal of Emerging Research in Management and Technology ","url":"http://www.ermt.net/"},
    {"name":"International Journal of Emerging Science and Engineering ","url":"http://www.ijese.org/"},
    {"name":"International Journal of Emerging Sciences","url":"http://ijes.info/index.html"},
    {"name":"International Journal of Emerging Technologies and Innovative Research","url":"http://www.jetir.org/"},
    {"name":"International Journal of Emerging Technology & Research","url":"http://www.ijetr.org/"},
    {"name":"International Journal of Emerging Technology and Advanced Engineering","url":"http://www.ijetae.com/index.html"},
    {"name":"International Journal of Emerging Trends in Electrical and Electronics","url":"http://www.ijetee.org/"},
    {"name":"International Journal of Emerging Trends in Pharmaceutical Sciences","url":"http://ijetps.com/"},
    {"name":"International Journal of Emerging Trends in Research","url":"http://www.ijoetr.com/"},
    {"name":"International Journal of Emerging Trends in Science and Technology","url":"http://igmpublication.org/ijetst.in/"},
    {"name":"International Journal of Energy & Technology","url":"http://www.journal-enertech.eu/"},
    {"name":"International Journal of Energy and Water Resources","url":"http://international%20journal%20of%20energy%20and%20water%20resources%20%28ijewr%29/"},
    {"name":"International Journal of Engineering & Science Research","url":"http://www.ijesr.org/"},
    {"name":"International Journal of Engineering and Advanced Research Technology","url":"https://www.ijeart.com/"},
    {"name":"International Journal of Engineering and Advanced Technology","url":"http://www.ijeat.org/"},
    {"name":"International Journal of Engineering and Applied Sciences","url":"http://eaas-journal.org/"},
    {"name":"International Journal of Engineering and Applied Sciences","url":"http://www.ijeas.org/"},
    {"name":"International Journal of Engineering and Computer Science","url":"http://www.ijecs.in/"},
    {"name":"International Journal of Engineering and Innovative Technology","url":"http://ijeit.com/index.php"},
    {"name":"International Journal of Engineering and Management Research","url":"http://www.ijemr.net/"},
    {"name":"International Journal of Engineering and Science","url":"http://www.theijes.com/"},
    {"name":"International Journal of Engineering and Science Invention","url":"http://www.ijesi.org/index.html"},
    {"name":"International Journal of Engineering & Technology","url":"http://www.iet-journals.org/"},
    {"name":"International Journal of Engineering and Technology","url":"http://www.ijetch.org/"},
    {"name":"International Journal of Engineering Applied Science and Technology","url":"http://www.ijeast.com/"},
    {"name":"International Journal of Engineering Associates","url":"http://ijea.jctjournals.com/"},
    {"name":"International Journal of Engineering Development and Research","url":"http://www.ijedr.org/index.php"},
    {"name":"International Journal of Engineering Innovations and Research","url":"http://ijeir.org/"},
    {"name":"International Journal of Engineering Inventions","url":"http://www.ijeijournal.com/index.html"},
    {"name":"International Journal of Engineering Maths and Computer Science","url":"http://ijemcs.in/index.php/ijemcs"},
    {"name":"International Journal of Engineering Research","url":"http://www.ijer.in/ijer/"},
    {"name":"International Journal of Engineering Research and Applications","url":"http://www.ijera.com/index.html"},
    {"name":"International Journal of Engineering Research and Computer Science","url":"http://ijercs.in/"},
    {"name":"International Journal of Engineering Research and Development","url":"http://www.ijerd.com/"},
    {"name":"International Journal of Engineering Research and General Science","url":"http://www.ijergs.org/"},
    {"name":"International Journal of Engineering Research & Management","url":"https://www.ijerm.com/"},
    {"name":"International Journal of Engineering Research & Science","url":"http://www.ijoer.com/"},
    {"name":"International Journal of Engineering Research and Science & Technology","url":"http://www.ijerst.com/index.php"},
    {"name":"International Journal of Engineering Research & Technology","url":"https://www.ijert.org/"},
    {"name":"International Journal of Engineering Researches and Management Studies","url":"http://www.ijerms.com/"},
    {"name":"International Journal of Engineering Science & Advanced Technology","url":"http://ijesat.org/"},
    {"name":"International Journal of Engineering Science and Computing","url":"http://ijesc.org/"},
    {"name":"International Journal of Engineering Science and Generic Research","url":"http://ijesar.in/home/index"},
    {"name":"International Journal of Engineering Science and Innovative Technology","url":"http://www.ijesit.com/"},
    {"name":"International Journal of Engineering, Science and Technology","url":"http://www.ijest-ng.com/"},
    {"name":"International Journal of Engineering Science Invention-Research & Development","url":"http://www.ijesird.com/"},
    {"name":"International Journal of Engineering Sciences & Research Technology","url":"http://www.ijesrt.com/index.html"},
    {"name":"International Journal of Engineering Sciences & Management","url":"http://www.ijesmr.com/"},
    {"name":"International Journal of Engineering Technologies and Management Research","url":"http://www.ijetmr.com/index.html"},
    {"name":"International Journal of Engineering Technology and Computer Research","url":"http://ijetcr.org/"},
    {"name":"International Journal of Engineering Technology and Management","url":"http://ijetm.org/"},
    {"name":"International Journal of Engineering Technology and Scientific Innovation","url":"http://www.ijetsi.org/"},
    {"name":"International Journal of Engineering Technology, Management and Applied Sciences","url":"http://www.ijetmas.com/"},
    {"name":"International Journal of Engineering Trends and Applications","url":"http://www.ijetajournal.org/"},
    {"name":"International Journal of Engineering Trends and Technology","url":"http://ijettjournal.org/"},
    {"name":"International Journal of English and Education","url":"http://ijee.org/"},
    {"name":"International Journal of English Language & Translation Studies","url":"http://eltsjournal.org/"},
    {"name":"International Journal of English Language , Literature & Humanities","url":"http://ijellh.com/"},
    {"name":"International Journal of English Language, Literature and Translation Studies","url":"http://www.ijelr.in/"},
    {"name":"International Journal of English Research","url":"http://www.englishresearchjournal.com/"},
    {"name":"International Journal of Enterprise Computing and Business Systems","url":"http://www.ijecbs.com/"},
    {"name":"International Journal of Environment","url":"http://benjapan.org/ije/"},
    {"name":"International Journal of Environmental & Agriculture Research","url":"http://www.ijoear.com/"},
    {"name":"International Journal of Environment, Agriculture and Biotechnology","url":"http://ijeab.com/"},
    {"name":"International Journal of Environmental Science and Development","url":"http://www.ijesd.org/"},
    {"name":"International Journal of Farming and Allied Sciences","url":"http://ijfas.com/"},
    {"name":"International Journal of Fauna and Biological Studies","url":"http://www.faunajournal.com/"},
    {"name":"International Journal of Fisheries and Aquatic Studies","url":"http://www.fisheriesjournal.com/"},
    {"name":"International Journal of Food and Nutritional Sciences","url":"http://www.ijfans.com/index.php"},
    {"name":"International Journal of Fundamental & Applied Sciences","url":"http://www.bma.org.in/IJFAS.aspx"},
    {"name":"International Journal of Global Communications","url":"http://ijgc.jalaxy.com.tw/"},
    {"name":"International Journal of Global Ideas","url":"http://journalglobalideas.com/"},
    {"name":"International Journal of Governance","url":"http://www.ijgovernance.com/"},
    {"name":"International Journal of Green and Herbal Chemistry","url":"http://www.ijghc.com/"},
    {"name":"International Journal of Health Research","url":"http://www.ijhr.org/"},
    {"name":"International Journal of Health Research in Modern Integrated Medical Sciences","url":"http://ijhrmims.com/index.php"},
    {"name":"International Journal of Health Sciences and Research","url":"http://www.ijhsr.org/"},
    {"name":"International Journal of Herbal Medicine","url":"http://www.florajournal.com/"},
    {"name":"International Journal of Hindi Research","url":"http://www.hindijournal.com/"},
    {"name":"International Journal of History, Arts and Culture","url":"http://newhistoryjournal.com/"},
    {"name":"International Journal of Home Science","url":"http://www.homesciencejournal.com/board.html"},
    {"name":"International Journal of Human Resource and Procurement","url":"http://www.ijsse.org/index.php?option=com_content&view=article&id=69&Itemid=68"},
    {"name":"International Journal of Human Sciences","url":"http://www.j-humansciences.com/"},
    {"name":"International Journal of Humanities and Cultural Studies","url":"http://www.ijhcs.com/index.php/ijhcs"},
    {"name":"International Journal of Humanities and Social Science Invention","url":"http://www.ijhssi.org/"},
    {"name":"International Journal of Humanities and Social Science Research","url":"http://www.socialresearchjournals.com/"},
    {"name":"The International Journal of Humanities & Social Studies","url":"http://www.theijhss.com/"},
    {"name":"International Journal of Humanities & Social Sciences","url":"http://aajhss.org/index.php/ijhss/index"},
    {"name":"International Journal of Humanities and Religion","url":"http://humanitiesjournal.info/index.php/ijhr/"},
    {"name":"International Journal of Humanities, Engineering and Pharmaceutical Sciences","url":"http://ijheps.org/"},
    {"name":"International Journal of Indian Psychology","url":"http://ijip.in/"},
    {"name":"International Journal of Information and Communication Technology Research","url":"http://esjournals.org/index.php"},
    {"name":"International Journal of Information and Communication Technology Trends","url":"http://www.ijictt.ictt.info/"},
    {"name":"International Journal of Information and Education Technology","url":"http://www.ijiet.org/"},
    {"name":"International Journal of Information Research","url":"http://www.spoars.org/journal/"},
    {"name":"International Journal of Information Research and Review","url":"http://www.ijirr.com/"},
    {"name":"International Journal of Information Sources and Services","url":"http://www.ijss.in/"},
    {"name":"International Journal of Information Technology & Business Management","url":"http://www.jitbm.com/"},
    {"name":"International Journal of Information Technology & Computer Science","url":"http://ijitcs.com/"},
    {"name":"International Journal of Information Technology and Electrical Engineering","url":"http://www.iteejournal.org/"},
    {"name":"International Journal of Informative and Futuristic Research","url":"http://ijifr.com/"},
    {"name":"International Journal of Innovation and Research in Educational Sciences","url":"http://www.ijires.org/"},
    {"name":"International Journal of Innovation in Science and Mathematics","url":"http://www.ijism.org/"},
    {"name":"International Journal of Innovation Research","url":"http://www.journalijir.com/"},
    {"name":"International Journal of Innovations in Engineering and Technology","url":"http://ijiet.com/"},
    {"name":"International Journal of Innovations in Engineering Research and Technology","url":"http://www.ijiert.org/"},
    {"name":"International Journal of Innovation Science and Research","url":"http://www.ijisr.com/"},
    {"name":"International Journal of Innovative and Applied Research","url":"http://journalijiar.com/"},
    {"name":"International Journal of Innovative and Emerging Research in Engineering","url":"http://ijiere.com/"},
    {"name":"International Journal of Innovative Computer Science & Engineering","url":"http://ijicse.in/"},
    {"name":"International Journal of Innovative Concepts in Research","url":"http://www.ijicr.com/"},
    {"name":"International Journal of Innovative Ideas","url":"http://www.publishtopublic.com/"},
    {"name":"International Journal of Innovative Interdisciplinary Research","url":"http://www.auamii.com/journal.html"},
    {"name":"International Journal of Innovative Pharmaceutical Research","url":"http://www.ijipr.com/"},
    {"name":"International Journal of Innovative Research & Advanced Studies","url":"http://www.ijiras.com/"},
    {"name":"International Journal of Innovative Research and Creative Technology","url":"http://www.ijirct.org/index.php"},
    {"name":"International Journal of Innovative Research and Development","url":"http://www.ijird.com/"},
    {"name":"International Journal of Innovative Research and Studies","url":"http://www.ijirs.com/"},
    {"name":"International Journal of Innovative Research in Advanced Engineering","url":"http://ijirae.com/"},
    {"name":"International Journal of Innovative Research in Computer and Communication Engineering","url":"http://www.ijircce.com/"},
    {"name":"International Journal of Innovative Research in Electrical, Electronics, Instrumentation and Control Engineering","url":"http://www.ijireeice.com/"},
    {"name":"International Journal of Innovative Research in Computer Science & Technology","url":"http://www.ijircst.org/"},
    {"name":"International Journal of Innovative Research in Engineering & Multidisciplinary Physical Sciences","url":"http://ijirmps.com/"},
    {"name":"International Journal of Innovative Research in Engineering and Management","url":"http://www.ijirem.org/IJIREM/Home.aspx"},
    {"name":"International Journal of Innovative Research in Medical Science","url":"http://ijirms.in/"},
    {"name":"International Journal of Innovative  Research in Science and Engineering","url":"http://www.ijirse.in/index.html"},
    {"name":"International Journal of Innovative Research in Science, Engineering and Technology","url":"http://www.ijirset.com/"},
    {"name":"International Journal of Innovative Research in Technology","url":"http://www.ijirt.org/index.php"},
    {"name":"International Journal of Innovative Research in Technology & Science","url":"http://www.ijirts.org/"},
    {"name":"International Journal of Innovative Science Engineering and Technology","url":"http://www.ijiset.com/"},
    {"name":"International Journal of Innovative Science and Modern Engineering","url":"http://www.ijisme.org/"},
    {"name":"International Journal of Innovative Studies in Sciences and Engineering Technology","url":"http://ijisset.org/"},
    {"name":"International Journal of Innovative Technologies","url":"http://ijitech.org/index.php"},
    {"name":"International Journal of Innovative Technology and Exploring Engineering","url":"http://www.ijitee.org/"},
    {"name":"International Journal of Innovative Technology and Research","url":"http://www.ijitr.com/"},
    {"name":"International Journal of Innovative Trends in Engineering","url":"http://www.ijite.com/"},
    {"name":"International Journal of Integrated Computer Applications & Research","url":"http://ijicar.net/"},
    {"name":"International Journal of Integrated Medical Research","url":"http://www.ijoimr.com/"},
    {"name":"International Journal of Interdisciplinary and Multidisciplinary Studies","url":"http://www.ijims.com/current.php"},
    {"name":"International Journal of Interdisciplinary Research in Science, Society and Culture","url":"http://ijirssc.in/site/"},
    {"name":"International Journal of Interdisciplinary Scientific Research","url":"http://www.iijsr.org/"},
    {"name":"International Journal of Inventions in Pharmaceutical Sciences","url":"http://www.ijips.net/"},
    {"name":"International Journal of Inventive Engineering and Sciences","url":"http://www.ijies.org/"},
    {"name":"The International Journal of Knowledge, Innovation and Entreprenurship","url":"http://ijkie.org/index.html"},
    {"name":"International Journal of Language and Applied Linguistics","url":"http://www.khatesefid.com/journal/index.html"},
    {"name":"International Journal of Language Learning and Applied Linguistics World","url":"http://www.ijllalw.org/"},
    {"name":"International Journal of Language Sciences","url":"http://www.intjls.com/"},
    {"name":"International Journal of Languages, Literature and Linguistics","url":"http://www.ijlll.org/"},
    {"name":"International Journal of Latest Research in Engineering and Computing","url":"http://www.ijlrec.com/"},
    {"name":"International Journal of Latest Research in Engineering and Technology","url":"http://www.ijlret.com/"},
    {"name":"International Journal of Latest Technology in Engineering, Management & Applied Science","url":"http://www.ijltemas.in/"},
    {"name":"International Journal of Latest Trends in Engineering and Technology","url":"http://www.ijltet.org/"},
    {"name":"International Journal of Latest Trends in Engineering, Science and Technology","url":"http://www.ijltest.org/"},
    {"name":"International Journal of Law and Legal Jurisprudence Studies","url":"http://ijlljs.in/"},
    {"name":"International Journal of Law and Management Studies","url":"http://ijlms.in/"},
    {"name":"International Journal of Law Research","url":"http://www.lawresearchjournal.com/"},
    {"name":"International Journal of Learning, Teaching and Educational Research","url":"http://www.ijlter.org/index.php/ijlter/index"},
    {"name":"International Journal of Liberal Arts & Social Science","url":"http://www.ijlass.org/"},
    {"name":"International Journal of Life science and Pharma Research","url":"http://www.ijlpr.com/"},
    {"name":"International Journal of Life Sciences Biotechnology and Pharma Research","url":"http://www.ijlbpr.com/index.php"},
    {"name":"International Journal of Life-Sciences Scientific Research","url":"http://ijlssr.com/"},
    {"name":"International Journal of Linguistics, Social and Natural Sciences","url":"http://www.ijlsns.com/"},
    {"name":"International Journal of Livestock Research","url":"http://www.scopemed.org/?jid=68/"},
    {"name":"The International Journal of Management","url":"http://www.theijm.com/"},
    {"name":"International Journal of Management, Accounting & Economics (IJMAE)","url":"http://iaajs.com/ijmae/"},
    {"name":"International Journal of Management and Business Studies","url":"http://ijmbs.com/"},
    {"name":"International Journal of Management and Research","url":"http://ijmr.humanjournals.com/"},
    {"name":"International Journal of Management and Social Science Research Review","url":"http://ijmsrr.com/"},
    {"name":"International Journal of Management, Economics and Social Sciences","url":"http://www.ijmess.com/index.php"},
    {"name":"International Journal of Management Research and Business Strategy","url":"http://www.ijmrbs.com/"},
    {"name":"International Journal of Management Research and Review","url":"http://ijmrr.com/"},
    {"name":"International Journal of Management Sciences and Business Research","url":"http://www.ijmsbr.com/"},
    {"name":"International Journal of Mathematical Archive","url":"http://www.ijma.info/index.php/ijma"},
    {"name":"International Journal of Mathematical Research & Science","url":"http://www.ijmrs.org/"},
    {"name":"International Journal of Mathematical Sciences & Applications","url":"http://ijmsa.yolasite.com/"},
    {"name":"International Journal of Mathematics And Computer Research","url":"http://ijmcr.in/index.php"},
    {"name":"International Journal of Mathematics and Soft Computing","url":"http://www.ijmsc.com/index.php/ijmsc/index"},
    {"name":"International Journal of Mathematics and Statistics Invention","url":"http://www.ijmsi.org/index.html"},
    {"name":"International Journal of Mechanical Engineering and Information Technology","url":"http://igmpublication.org/ijmeit/"},
    {"name":"International Journal of Medical and Health Research","url":"http://www.medicalsjournals.com/"},
    {"name":"International Journal Of Medical and Health Sciences","url":"http://www.ijmhs.net/"},
    {"name":"International Journal of Medical Research","url":"http://www.scopemed.org/?jid=76"},
    {"name":"International Journal of Medical Research & Health Sciences","url":"http://ijmrhs.com/"},
    {"name":"International Journal of Medical Research & Review","url":"http://www.ijmrr.in/Default.aspx?pageid=1"},
    {"name":"International Journal of Medical Research and Pharmaceutical Sciences","url":"http://www.ijmrpsjournal.com/"},
    {"name":"International Journal of Medical Research Professionals","url":"http://ijmrp.com/"},
    {"name":"International Journal of Medical Science and Education","url":"http://www.ijmse.com/"},
    {"name":"International Journal of Medical Science and Public Health","url":"http://www.ijmsph.com/"},
    {"name":"International Journal of Medical Science Research and Practice","url":"http://www.ijmsrp.com/"},
    {"name":"International Journal of Medical Sciences and Health Care","url":"http://www.ijmshc.com/"},
    {"name":"International Journal of Medical Students","url":"http://www.ijms.info/ojs/index.php/IJMS/index"},
    {"name":"International Journal of Medicine and Biosciences","url":"http://www.ijmbonline.com/"},
    {"name":"International Journal of Medicobiologial Research","url":"http://www.ijmedres.com/"},
    {"name":"International Journal of MediPharm Research","url":"http://www.medipharmsai.com/"},
    {"name":"International Journal of Modern Chemistry and Applied Science","url":"http://www.ijcasonline.com/"},
    {"name":"International Journal of Modern Engineering Research","url":"http://www.ijmer.com/"},
    {"name":"International Journal of Modern Sciences and Engineering Technology","url":"https://www.ijmset.com/home.html"},
    {"name":"International Journal of Mosquito Research","url":"http://dipterajournal.com/"},
    {"name":"International Journal of Multidisciplinary and Current Research","url":"http://ijmcr.com/"},
    {"name":"International Journal of Multidisciplinary and Scientific Emerging Research","url":"http://www.ijmser.com/"},
    {"name":"International Journal of Multidisciplinary and Scientific Emerging Research","url":"http://www.ijesm.com/"},
    {"name":"International Journal of Multidisciplinary Education and Research","url":"http://www.newresearchjournal.com/"},
    {"name":"International Journal of Multidisciplinary Educational Research","url":"http://www.ijmer.in/"},
    {"name":"International Journal of Multidisciplinary Health Sciences","url":"http://www.ijomhs.org/"},
    {"name":"International Journal of Multidisciplinary Research and Development","url":"http://allsubjectjournal.com/"},
    {"name":"International Journal of Multidisciplinary Research and Information","url":"http://www.journalijmri.com/"},
    {"name":"International Journal of Multidisciplinary Research and Modern Education","url":"http://rdmodernresearch.org/"},
    {"name":"International Journal Of Multidisciplinary Research and Review","url":"http://journalmrr.com/"},
    {"name":"International Journal of Multidisciplinary Research Review","url":"http://www.ijmdrr.com/"},
    {"name":"International Journal of Multidisciplinary Sciences and Engineering","url":"http://www.ijmse.org/"},
    {"name":"International Journal of Nanofluids and Nanoparticles","url":"http://international%20journal%20of%20nanofluids%20and%20nanoparticles/"},
    {"name":"International Journal of Network Security","url":"http://ijns.jalaxy.com.tw/"},
    {"name":"International Journal of Network Service and Technologies","url":"http://ijnst.jalaxy.com.tw/"},
    {"name":"International Journal of New Innovations in Engineering and Technology","url":"http://www.ijniet.org/"},
    {"name":"International Journal of New Technologies in Science and Engineering","url":"http://www.ijntse.com/"},
    {"name":"International Journal of New Technology and Research","url":"https://www.ijntr.org/"},
    {"name":"International Journal of New Trends in Arts, Sports & Science Education","url":"http://www.ijtase.net/ojs/index.php/IJTASE"},
    {"name":"International Journal of Novel Trends in Pharmaceutical Sciences","url":"http://www.ijntps.org/"},
    {"name":"International Journal of Nursing","url":"http://www.ijnonline.com/"},
    {"name":"International Journal of Obstetrics and Gynaecology Research","url":"http://www.ijogr.com/"},
    {"name":"International Journal of Oral Health and Medical Research","url":"http://ijohmr.com/"},
    {"name":"International Journal of Oncology Science","url":"http://oncologyscience.com/"},
    {"name":"International Journal of Orthopaedics Sciences ","url":"http://www.orthopaper.com/"},
    {"name":"International Journal of Pediatrics","url":"http://ijp.mums.ac.ir/"},
    {"name":"International Journal of Pharma and Bio Sciences","url":"http://www.ijpbs.net/index.html"},
    {"name":"International Journal of Pharma Professional’s Research","url":"http://www.ijppronline.in/"},
    {"name":"International Journal of Pharmaceutical & Research Science","url":"http://www.ijprsjournal.com/index.html"},
    {"name":"International Journal of Pharmaceutical and Biological Science Archive","url":"http://www.ijpba.in/index.php/ijpba"},
    {"name":"International Journal of Pharmaceutical and Biomedical Research","url":"http://www.pharmscidirect.com/"},
    {"name":"International Journal of Pharmaceutical and Clinical Research","url":"http://ijpcr.com/"},
    {"name":"International Journal of Pharmaceutical and Phytopharmacological Research","url":"http://www.eijppr.com/"},
    {"name":"International Journal of Pharmaceutical Quality Assurance and Pharmaceutical Analysis","url":"http://ijpqa.com/"},
    {"name":"International Journal of Pharmaceutical Research and Applications","url":"http://www.ijprajournal.com/index.html"},
    {"name":"International Journal of Pharmaceutical Research and Bioscience","url":"http://www.ijprbs.com/"},
    {"name":"International Journal of Pharmaceutical Research and Development","url":"http://www.ijprd.com/"},
    {"name":"International Journal of Pharmaceutical Science Invention","url":"http://www.ijpsi.org/"},
    {"name":"International Journal of Pharmaceutical Sciences and Business Management","url":"http://www.ijpsbm.com/"},
    {"name":"International Journal of Pharmaceutical Sciences and Drug Research","url":"http://www.ijpsdr.com/index.htm"},
    {"name":"International Journal of Pharmaceutical Sciences and Research","url":"http://www.ijpsr.com/index.html"},
    {"name":"International Journal of Pharmaceutical Sciences Letters","url":"http://ijpsl.com/"},
    {"name":"International Journal of Pharmaceutical Sciences Review and Research","url":"http://www.globalresearchonline.net/"},
    {"name":"International Journal of Pharmaceuticals and Health Care Research","url":"http://www.ijphr.com/"},
    {"name":"International Journal of Pharmacognosy","url":"http://www.ijpjournal.com/"},
    {"name":"International Journal of Pharmacognosy and Phytochemical Research","url":"http://ijppr.com/"},
    {"name":"International Journal of Pharmacology and Physiology","url":"http://my.ejmanager.com/ijpp/"},
    {"name":"International Journal of Pharmacy","url":"http://www.pharmascholars.com/"},
    {"name":"International Journal of Pharmacy & Industrial Research","url":"http://www.ijpir.com/%20"},
    {"name":"International Journal of Pharmacy and Pharmaceutical Research","url":"http://ijppr.humanjournals.com/"},
    {"name":"International Journal of Pharmacy and Pharmaceutical Sciences","url":"http://www.ijppsjournal.com/"},
    {"name":"International Journal of Pharmacy and Technology","url":"http://www.ijptonline.com/"},
    {"name":"International Journal of Physical Education, Sports and Health","url":"http://www.kheljournal.com/"},
    {"name":"International Journal of Physiotherapy","url":"https://www.ijphy.org/"},
    {"name":"International Journal of Plant, Animal and Environmental Sciences","url":"http://www.ijpaes.com/"},
    {"name":"International Journal of Power Electronics Engineering","url":"http://www.ijpee.com/index.php/ijpee"},
    {"name":"International Journal of Precious Engineering Research and Applications","url":"http://www.ijpera.com/"},
    {"name":"International Journal of Printing, Packaging & Allied Sciences","url":"http://ijppas.com/index.php"},
    {"name":"International Journal of Psycho-Educational Sciences","url":"http://www.arees.org/journal/about-journal"},
    {"name":"International Journal of Psychology and Behavioral Research","url":"http://ijpbrjournal.com/"},
    {"name":"International Journal of Pure & Applied Bioscience","url":"http://www.ijpab.com/"},
    {"name":"International Journal of Pure and Applied Zoology","url":"http://www.ijpaz.com/index.php/ijpaz"},
    {"name":"International Journal of Recent Advances in Multidisciplinary Research","url":"http://www.ijramr.com/"},
    {"name":"International Journal of Recent Development in Engineering and Technology","url":"http://www.ijrdet.com/index.php"},
    {"name":"International Journal of Recent Engineering Research and Development","url":"http://www.ijrerd.com/"},
    {"name":"International Journal of Recent Research and Applied Studies","url":"http://www.ijrras.com/"},
    {"name":"International Journal of Recent Research in Science, Engineering and Technology ","url":"http://www.ijrrset.com/"},
    {"name":"International Journal of Recent Scientific Research","url":"http://www.recentscientific.com/"},
    {"name":"International Journal of Recent Technology and Engineering","url":"http://www.ijrte.org/"},
    {"name":"International Journal of Recent Trends in Electrical & Electronics Engineering","url":"https://scholarlyoa.com/individual-journals/International%20Journal%20of%20Recent%20trends%20in%20Electrical%20&%20Electronics%20Engineering%20(IJRTE)"},
    {"name":"International Journal of Recent Trends in Engineering & Research","url":"http://www.ijrter.com/"},
    {"name":"International Journal of Remote Sensing and Geoscience","url":"http://www.ijrsg.com/"},
    {"name":"International Journal of Renewable Energy Research","url":"http://www.ijrer.org/ijrer/index.php/ijrer/index"},
    {"name":"International Journal of Research and Current Development","url":"http://www.journalijrcd.com/"},
    {"name":"International Journal of Research and Development in Pharmacy & Life Sciences","url":"http://www.ijrdpl.com/"},
    {"name":"International Journal of Research and Development in Technology & Management Sciences Kailash","url":"http://journal.rtmonline.in/"},
    {"name":"International Journal of Research and Engineering","url":"http://ijre.org/"},
    {"name":"International Journal of Research and Innovation in Computer Engineering","url":"http://www.ijrice.com/"},
    {"name":"International Journal of Research and Science Publication","url":"http://www.ijrsp.org/"},
    {"name":"International Journal of Research Culture Society","url":"http://ijrcs.in/"},
    {"name":"International Journal of Research Development ","url":"http://forefrontcorpo.wix.com/ijord"},
    {"name":"International Journal of Research GRANTHAALAYAH","url":"http://granthaalayah.com/index.html"},
    {"name":"International Journal of Research in Advanced Engineering and Technology","url":"http://www.engineeringresearchjournal.com/"},
    {"name":"International Journal of Research In Advanced Engineering Technologies","url":"http://www.ijraet.com/"},
    {"name":"International Journal of Research in Aeronautical and Mechanical Engineering","url":"http://www.ijrame.com/"},
    {"name":"International Journal of Research in Agricultural Sciences","url":"http://ijras.org/"},
    {"name":"International Journal of Research in Agriculture and Forestry","url":"http://www.ijraf.org/"},
    {"name":"International Journal of Research in Ayurveda and Pharmacy","url":"http://www.ijrap.net/"},
    {"name":"International Journal of Research in Business Studies and Management","url":"http://www.ijrbsm.org/"},
    {"name":"International Journal of Research in Computer and Communication Technology","url":"http://www.ijrcct.org/index.php/ojs"},
    {"name":"International Journal of Research in Computer Engineering & Electronics","url":"http://www.ijrcee.org/index.php/ijrcee"},
    {"name":"International Journal of Research in Computer Science","url":"http://www.ijorcs.org/"},
    {"name":"International Journal of Research in Computer Technology","url":"http://www.opusinfo.in/ijrct/index.php/ijrct/information/readers"},
    {"name":"International Journal of Research in Education and Science","url":"http://www.ijres.net/"},
    {"name":"International Journal of Research in Education and Social Science","url":"http://www.ijress.com/"},
    {"name":"International Journal of Research in Electronics & Communication Technology","url":"http://ijrect.com/"},
    {"name":"International Journal of Research in Engineering and Advanced Technology","url":"http://www.ijreat.org/"},
    {"name":"International Journal of Research in Engineering and Science","url":"http://www.ijres.org/index.html"},
    {"name":"nternational Journal of Research in Engineering and Science","url":"http://www.mgijournal.com/"},
    {"name":"International Journal of Research in Engineering and Technology","url":"http://ijret.org/"},
    {"name":"International Journal of Research in Humanities and Social Sciences","url":"http://www.ijrhss.org/"},
    {"name":"International Journal of Research in Library Science","url":"http://ijrls.in/"},
    {"name":"International Journal of Research in Management & Business Studies","url":"http://ijrmbs.com/"},
    {"name":"International Journal of Research in Mechanical Engineering and Technology","url":"http://www.ijrmet.com/"},
    {"name":"International Journal of Research in Medical & Applied Sciences","url":"http://ijrmas.org/"},
    {"name":"International Journal of Research in Medical and Dental Sciences","url":"https://edas.info/web/ijrmds/index.html"},
    {"name":"International Journal of Research in Pharmacy and Biosciences","url":"http://www.ijrpb.org/"},
    {"name":"International Journal of Research in Pharmacy and Science","url":"http://www.ijrpsonline.com/index.php"},
    {"name":"International Journal of Research in Science & Engineering","url":"http://ijrise.org/home"},
    {"name":"International Journal of Research in Science & Technology","url":"http://www.ijrst.com/index.php"},
    {"name":"International Journal of Research in Wireless Systems","url":"http://www.ijrws.org/index.php/ijrws"},
    {"name":"International Journal of Research Methodology","url":"http://ijrm.humanjournals.com/"},
    {"name":"International Journal of Research Publications in Engineering and Technology ","url":"http://www.ijrpet.org/"},
    {"name":"International Journal of Research Science and Management","url":"http://www.ijrsm.com/"},
    {"name":"International Journal of Review in Applied and Social Sciences","url":"http://www.ijrass.com/"},
    {"name":"International Journal of Review in Life Sciences","url":"https://pharmascope.org/ijrls/"},
    {"name":"International Journal of Review in Life Sciences","url":"http://www.ijrls.com/"},
    {"name":"International Journal of Reviews in Computing","url":"http://www.ijric.org/index.php"},
    {"name":"International Journal of Reviews, Surveys and Research ","url":"http://www.ijrsr.com/"},
    {"name":"International Journal of Sanskrit Research","url":"http://www.sanskritjournal.com/"},
    {"name":"International Journal of Science and Advanced Technology","url":"http://www.ijsat.com/"},
    {"name":"International Journal of Science & Engineering Development Research","url":"http://www.ijsdr.org/index.php"},
    {"name":"International Journal of Science and Engineering Applications","url":"http://www.ijsea.com/index"},
    {"name":"International Journal of Science and Engineering Investigations","url":"http://www.ijsei.com/"},
    {"name":"The International Journal of Science & Technoledge","url":"http://www.theijst.com/"},
    {"name":"International Journal of Science and Research","url":"http://www.ijsr.net/"},
    {"name":"International Journal of Science and Research Methodology","url":"http://ijsrm.humanjournals.com/"},
    {"name":"International Journal of Science and Technology","url":"http://ejournalofsciences.org/"},
    {"name":"International Journal of Science & Technology","url":"http://www.journalofsciences-technology.org/"},
    {"name":"International Journal of Science Commerce and Humanities","url":"http://www.ijsch.com/journaluk/Publisher-69"},
    {"name":"International Journal of Science Culture and Sport","url":"http://www.iscsjournal.com/Anasayfa.Aspx"},
    {"name":"International Journal of Science Engineering and Advance Technology","url":"http://www.ijseat.com/index.php/ijseat"},
    {"name":"International Journal of Science, Engineering and Technology Research ","url":"http://ijsetr.org/"},
    {"name":"International Journal of Science Environment and Technology","url":"http://www.ijset.net/"},
    {"name":"International Journal of Science Innovations and Discoveries","url":"http://www.ijsidonline.info/"},
    {"name":"International Journal of Science Technology and Engineering","url":"http://www.ijste.org/"},
    {"name":"International Journal Of Science Technology & Management","url":"http://www.ijstm.com/"},
    {"name":"International Journal of Sciences","url":"http://www.ijsciences.com/"},
    {"name":"International Journal of Sciences and Applied Research","url":"http://www.ijsar.in/"},
    {"name":"International Journal of Scientific & Technology Research","url":"http://www.ijstr.org/"},
    {"name":"International Journal of Scientific and Engineering Research","url":"http://www.ijser.org/"},
    {"name":"International Journal of Scientific and Research","url":"http://journalijsr.com/"},
    {"name":"International Journal of Scientific and Research Publications","url":"http://www.ijsrp.org/"},
    {"name":"International Journal of Scientific and Technical Advancements","url":"http://www.ijsta.com/"},
    {"name":"International Journal of Scientific Engineering and Applied Science","url":"http://ijseas.com/"},
    {"name":"International Journal of Scientific Engineering and Technology","url":"http://ijset.com/ijset/"},
    {"name":"International Journal of Scientific Engineering and Technology Research","url":"http://ijsetr.com/"},
    {"name":"International Journal of Scientific Progress & Research","url":"http://www.ijspr.com/index.php"},
    {"name":"International Journal of Scientific Research","url":"http://www.ijscr.com/index.html"},
    {"name":"International Journal of Scientific Research","url":"http://worldwidejournals.com/ijsr/"},
    {"name":"International Journal of Scientific Research & Management Studies","url":"http://www.ijsrms.com/home/index.html"},
    {"name":"International Journal of Scientific Research and Application","url":"http://ijsra.com/"},
    {"name":"International Journal Of Scientific Research And Education","url":"http://ijsae.in/"},
    {"name":"International Journal of Scientific Research and Engineering Trends","url":"http://www.ijsret.com/"},
    {"name":"International Journal of Scientific Research and Innovative Technology","url":"http://www.ijsrit.com/"},
    {"name":"International Journal of Scientific Research and Management","url":"http://www.ijsrm.in/"},
    {"name":"International Journal of Scientific Research in Education","url":"http://www.ijsre.com/"},
    {"name":"International Journal of Scientific Research in Information Systems and Engineering","url":"http://www.ijsrise.com/index.php/ijsrise"},
    {"name":"International Journal of Scientific Study","url":"http://www.ijss-sn.com/"},
    {"name":"International Journal of Signal Processing Systems","url":"http://international%20journal%20of%20signal%20processing%20systems%20%28ijsps%29/"},
    {"name":"The International Journal of Social and Applied Sciences","url":"http://ijsas.webs.com/indexing"},
    {"name":"International Journal of Social Science & Economic Research","url":"http://ijsser.org/index.php"},
    {"name":"International Journal of Social Science and Humanity","url":"http://www.ijssh.org/"},
    {"name":"The International Journal of Social Sciences","url":"http://www.tijoss.com/index.html"},
    {"name":"International Journal of Social Sciences and Education","url":"http://www.ijsse.com/"},
    {"name":"International Journal of Social Sciences and Entrepreneurship","url":"http://www.ijsse.org/"},
    {"name":"International Journal of Society and Technology","url":"http://jst.vlsiengineers.in/ojs1/index.php/jst"},
    {"name":"International Journal of Society, Culture & Language","url":"http://ijscl.net/"},
    {"name":"International Journal of Soft Computing and Engineering","url":"http://www.ijsce.org/"},
    {"name":"International Journal of Sport Studies","url":"http://ijssjournal.com/"},
    {"name":"OIDA International Journal of Sustainable Development","url":"http://www.ontariointernational.org/Publications.html"},
    {"name":"International Journal of Teacher Educational Research","url":"http://ijter.com/"},
    {"name":"International Journal of Technical Research and Applications","url":"http://www.ijtra.com/index.php"},
    {"name":"International Journal of Technical Research and Innovation","url":"http://www.ijtri.org/"},
    {"name":"International Journal of Technology and Computing","url":"http://www.ijtc.org/ijtc.html"},
    {"name":"International Journal of Technology, Education, and Resource Management","url":"http://www.ijterm.org/index.php/IJTERM/index"},
    {"name":"International Journal of Technology Enhancements and Emerging Engineering Research","url":"http://www.ijteee.org/"},
    {"name":"International Journal of Technology, Management and Humanities","url":"http://www.ijtmh.com/"},
    {"name":"International Journal of Therapeutic Applications","url":"http://journal.npaa.in/"},
    {"name":"International Journal of Toxicological and Pharmacological Research","url":"http://ijtpr.com/"},
    {"name":"International Journal of Trend in Research and Development","url":"http://www.ijtrd.com/"},
    {"name":"International Journal of Trends in Economics Management and Technology ","url":"http://www.ijtemt.org/"},
    {"name":"International Journal of Universal Pharmacy and Bio Sciences","url":"http://www.ijupbs.com/Home.aspx"},
    {"name":"International Journal of Veterinary Science","url":"http://www.ijvets.com/"},
    {"name":"International Journal of Wind and Renewable Energy","url":"http://www.ijwre.org/index.php"},
    {"name":"International Journal of Wisdom Based Computing","url":"http://www.wisdombasedcomputing.com/index.html"},
    {"name":"International Journal of World Research","url":"http://apjor.com/ijrp/"},
    {"name":"International Journal on Recent and Innovation Trends in Computing and Communication","url":"http://ijritcc.org/"},
    {"name":"International Journal on Recent Technologies in Mechanical and Electrical Engineering","url":"http://www.ijrmee.org/"},
    {"name":"International Journal on Recent Trends in Life Science and Mathematics","url":"http://www.ijlsm.org/"},
    {"name":"International Journal on Research Methodologies in Physics and Chemistry","url":"http://www.ijrpc.org/"},
    {"name":"International Journal Online of Humanities","url":"http://ijohmn.com/"},
    {"name":"International Letters of Chemistry, Physics and Astronomy","url":"http://www.ilcpa.pl/"},
    {"name":"International Letters of Natural Sciences","url":"http://www.ilns.pl/"},
    {"name":"International Letters of Social and Humanistic Sciences","url":"http://www.ilshs.pl/"},
    {"name":"International Multidisciplinary Research Journal","url":"http://irjs.info/index.php/irjs/"},
    {"name":"International Multispeciality Journal of Health","url":"http://imjhealth.org/"},
    {"name":"International Online Journal of Primary Education","url":"http://www.iojpe.org/ojs/index.php/IOJPE"},
    {"name":"International Proceedings of Chemical, Biological and Environmental Engineering","url":"http://www.ipcbee.com/"},
    {"name":"International Refereed Journal Of Architecture and Design","url":"http://www.mtddergisi.com/eng/"},
    {"name":"International Refereed Journal of Engineering and Science","url":"http://www.irjes.com/"},
    {"name":"International Research and Publications in Medical Sciences","url":"http://www.irpms.com/"},
    {"name":"International Research Journal of Advanced Engineering in Frontiers","url":"http://irjef.net/"},
    {"name":"International Research Journal of Applied and Basic Sciences","url":"http://www.irjabs.com/en/"},
    {"name":"International Research Journal of Applied Finance","url":"https://irjaf.com/"},
    {"name":"International Research Journal of Engineering and Technology","url":"https://www.irjet.net/"},
    {"name":"International Research Journal of Engineering and Technology","url":"https://irjet.org/"},
    {"name":"International Research Journal of Finance and Economics","url":"http://www.internationalresearchjournaloffinanceandeconomics.com/"},
    {"name":"International Research Journal of Management Sciences","url":"http://irjmsjournal.com/"},
    {"name":"International Research Journal of Multidisciplinary Science & Technology","url":"http://www.irjmrs.com/"},
    {"name":"International Research Journal of Pharmaceutical and Applied Sciences","url":"http://www.irjpas.com/"},
    {"name":"International Research Journal of Pharmaceutical Sciences","url":"http://irjps.info/index.php/IRJPS/index"},
    {"name":"International Research Journal of Pharmacy","url":"http://www.irjponline.com/"},
    {"name":"International Research Journal of Sustainable Science & Engineering","url":"http://irjse.com/"},
    {"name":"International Researchers","url":"http://iresearcher.org/index.html"},
    {"name":"International Review of Basic and Applied Sciences","url":"http://irbas.academyirmbr.com/journalmain.php"},
    {"name":"International Review of Management and Business Research","url":"http://www.irmbrjournal.com/index.php"},
    {"name":"International Review of Social Sciences and Humanities","url":"http://www.irssh.com/"},
    {"name":"International Science and Investigation Journal","url":"http://isijournal.info/journals/index.php/ISIJ"},
    {"name":"International Scientific Investigations","url":"http://isi-journal.org/"},
    {"name":"International Scientific Journal Theoretical & Applied Science","url":"http://www.t-science.org/"},
    {"name":"International Scientific Research Journal","url":"http://www.irj.science/"},
    {"name":"International Technical Sciences Journal","url":"http://itsj.org/"},
    {"name":"Invention Journal of Research Technology in Engineering & Management","url":"http://www.ijrtem.com/"},
    {"name":"IOSR Journal of Engineering","url":"http://www.iosrjen.org/"},
    {"name":"Italian Journal of Science & Engineering","url":"http://ijournalse.org/index.php/IJSE"},
    {"name":"JACOTECH","url":"http://www.jacotech.org/"},
    {"name":"Jai Maa Saraswati Gyandayini","url":"http://www.jmsjournals.in/"},
    {"name":"Journal of Accounting, Ethics & Public Policy","url":"http://www.jaepp.org/"},
    {"name":"Journal de Afrikana","url":"http://www.jdeafrikana.com/home.html"},
    {"name":"Journal der Pharmazie Forschung","url":"http://www.rapsr.com/"},
    {"name":"Journal for Research","url":"http://www.journal4research.org/index.php"},
    {"name":"Journal Francophone de Cas Clinique","url":"http://jfcc.fr/"},
    {"name":"Journal of Advanced Agricultural Technologies","url":"http://www.joaat.com/"},
    {"name":"Journal of Advanced Studies in Agricultural, Biological and Environmental Sciences","url":"http://jabe.in/"},
    {"name":"Journal of Advances in Civil Engineering","url":"http://djcivil.org/"},
    {"name":"Journal of Advances in Electronics and Communication Engineering","url":"http://www.djjames.org/"},
    {"name":"Journal of Advances in Information Technology","url":"http://www.jait.us/"},
    {"name":"Journal of Advances in Internal Medicine","url":"http://www.aimjournal.org/index.php"},
    {"name":"Journal of Advances in Science and Technology","url":"http://www.jadbm.com/"},
    {"name":"Journal of Advances in Social Science and Humanities","url":"http://www.jassh.in/index.php/jassh"},
    {"name":"Journal of Agriculture, Forestry & Environmental Sciences","url":"http://jafes.eduved.org/"},
    {"name":"Journal of American Academic Research","url":"http://www.american-journals.com/"},
    {"name":"The Journal of American Academy of Business, Cambridge","url":"http://www.jaabc.com/journal.htm"},
    {"name":"The Journal of American Business Review, Cambridge","url":"http://www.jaabc.com/jabrc.html"},
    {"name":"Journal of American Physicians and Surgeons","url":"http://www.jpands.org/"},
    {"name":"Journal of Anaesthesia and Critical Care Case Reports","url":"http://jaccr.com/"},
    {"name":"Journal of Analytical Research","url":"http://www.researchanalytica.com/index.php"},
    {"name":"Journal of Animal and Plant Sciences","url":"http://www.m.elewa.org/JAPS/"},
    {"name":"Journal of Animal and Poultry Sciences","url":"http://www.japsc.com/"},
    {"name":"Journal of Applicable Chemistry","url":"http://www.joac.info/"},
    {"name":"Journal of Applied Biology & Biotechnology ","url":"http://jabonline.in/"},
    {"name":"Journal of Applied Economics and Business","url":"http://www.aebjournal.org/index.php"},
    {"name":"Journal of Applied Linguistics and Language Research","url":"http://www.jallr.com/index.php/JALLR"},
    {"name":"Journal of Applied Linguistics (Dubai)","url":"http://www.iaajs.com/jal/"},
    {"name":"Journal of Applied Management and Investments","url":"http://www.jami.org.ua/"},
    {"name":"Journal of Applied Pharmacy","url":"http://japharmacy.com/master/Default.aspx"},
    {"name":"Journal of Applied Pharmaceutical Science","url":"http://www.japsonline.com/index.php"},
    {"name":"Journal of Arts and Humanities","url":"http://theartsjournal.org/index.php/site"},
    {"name":"Journal of Automation and Control Engineering","url":"http://www.joace.org/"},
    {"name":"Journal of Ayurveda and Integrated Medical Sciences","url":"http://www.jaims.in/index.php/jaims"},
    {"name":"Journal of Ayurveda and Holistic Medicine","url":"http://www.jahm.in/"},
    {"name":"Journal of Basic and Environmental Sciences","url":"http://jbesci.org/"},
    {"name":"Journal of Behavioral Health","url":"http://www.scopemed.org/?jid=57"},
    {"name":"Journal of Behavioral Sciences in Asia","url":"http://www.joursa.com/"},
    {"name":"Journal of Bio Innovation","url":"http://www.jbino.com/index.htm"},
    {"name":"Journal of Biological and Scientific Opinion","url":"http://www.jbsoweb.com/"},
    {"name":"Journal of Biological Sciences and Medicine","url":"http://www.jbscim.com/"},
    {"name":"Journal of Biomedical and Pharmaceutical Research","url":"http://jbpr.in/index.php/jbpr"},
    {"name":"Journal of Bioscience and Technology","url":"http://www.jbstonline.com/"},
    {"name":"Journal of Biospectracal","url":"http://journalofbiospectracal.com/"},
    {"name":"Journal of Business Management and Applied Economics","url":"http://jbmae.scientificpapers.org/"},
    {"name":"Journal of Business Management and Economic Studies","url":"http://www.jbmes.com/index.html"},
    {"name":"Journal of Business Studies Quarterly","url":"http://jbsq.org/"},
    {"name":"Journal of Chemical and Pharmaceutical Research","url":"http://jocpr.com/"},
    {"name":"Journal of Chemical and Pharmaceutical Sciences","url":"http://jchps.com/"},
    {"name":"Journal of Chemical, Biological and Physical Sciences","url":"http://www.jcbsc.org/index.php"},
    {"name":"Journal of Clean Energy Technologies","url":"http://www.jocet.org/"},
    {"name":"Journal of Clinical and Analytical Medicine","url":"http://www.jcam.com.tr/en/index.php"},
    {"name":"Journal of Communications Technology, Electronics and Computer Science","url":"https://www.jctecs.com/index.php/com"},
    {"name":"Journal of Computers","url":"http://www.jcomputers.us/"},
    {"name":"Journal of Computing","url":"http://www.journalofcomputing.org/"},
    {"name":"Journal of Computing Technologies","url":"http://jctjournals.com/"},
    {"name":"Journal of Contemporary Issues in Business Research","url":"http://jcibr.webs.com/"},
    {"name":"Journal of Contemporary Management Sciences","url":"http://jmsciences.com/Presentation/Client/Home.aspx"},
    {"name":"Journal of Contemporary Medical Education","url":"http://www.scopemed.org/?jid=63"},
    {"name":"Journal of Coastal Life Medicine","url":"http://jclmm.com/"},
    {"name":"Journal of Cosmology","url":"http://journalofcosmology.com/"},
    {"name":"Journal of Current Pharma Research","url":"http://www.cpronline.in/"},
    {"name":"Journal of Current Research in Science","url":"http://www.jcrs010.com/"},
    {"name":"Journal of Current Trends in Big Data Analytics","url":"http://jctbda.ijkie.org/index.html"},
    {"name":"Journal of Drug Discovery and Therapeutics","url":"http://jddt.in/index.php/jddt"},
    {"name":"Journal of Economics and Banking","url":"http://journals.ke-i.org/index.php/econ"},
    {"name":"Journal of Economics and Engineering","url":"http://www.eu-print.org/iqt.php"},
    {"name":"Journal of Economics and Political Economy","url":"http://www.ijepe.com/index.php/JEPE"},
    {"name":"Journal of Economics, Business and Management","url":"http://joebm.com/"},
    {"name":"Journal of Education and Social Science","url":"http://jesoc.com/"},
    {"name":"Journal of Education and Sociology","url":"http://www.eu-print.org/teh.php"},
    {"name":"Journal of ELT and Applied Linguistics","url":"http://www.jeltal.com/"},
    {"name":"Journal of Electrical Engineering","url":"http://www.jee.ro/index.php"},
    {"name":"Journal of Electrical Engineering and Science","url":"http://djeee.org/"},
    {"name":"Journal of Emerging Trends in Computing and Information Sciences","url":"http://cisjournal.org/"},
    {"name":"Journal of English Language and Literature","url":"http://joell.in/"},
    {"name":"Journal of Engineering and Applied Mathematics","url":"http://djmaths.org/"},
    {"name":"Journal of Engineering Innovation & Research","url":"http://jeir.org/"},
    {"name":"Journal of Entomology and Zoology Studies ","url":"http://entomoljournal.com/"},
    {"name":"Journal of Environment and Life Sciences","url":"http://www.imedpharm.com/journals/index.php/JELS/index"},
    {"name":"Journal of Environmental and Occupational Science","url":"http://www.jenvos.com/"},
    {"name":"Journal of Environmental Biology","url":"http://www.jeb.co.in/"},
    {"name":"Journal of Environmental Hydrology","url":"http://www.hydroweb.com/journal-hydrology.html"},
    {"name":"Journal of Environmental Nanotechnology","url":"http://www.nanoient.org/journal-of-environmental-nanotechnology.php"},
    {"name":"Journal of Environmental Research and Development","url":"http://www.jerad.org/"},
    {"name":"Journal of Environmental Science, Computer Science and Engineering & Technology","url":"http://www.jecet.org/"},
    {"name":"Journal of Evidence Based Medicine and Healthcare","url":"http://www.jebmh.com/index.php"},
    {"name":"Journal of Evolution of Research in Dermatology and Venerology","url":"http://www.jerdv.com/"},
    {"name":"Journal of Evolution of Research in Human Physiology","url":"http://www.jerhp.com/"},
    {"name":"Journal of Evolution of Research in Medical Microbiology","url":"http://jermm.com/index.php"},
    {"name":"Journal of Evolution of Research in Medical Pharmacology","url":"http://www.jermp.com/index.php"},
    {"name":"Journal of Evolution of Research in Paediatrics and Neonatology","url":"http://www.jerpn.com/"},
    {"name":"Journal of Excellence in Computer Science and Engineering","url":"http://djcse.in/"},
    {"name":"Journal of Experimental Biology and Agricultural Sciences","url":"http://www.jebas.org/"},
    {"name":"Journal of Experimental Sciences","url":"http://jexpsciences.com/"},
    {"name":"Journal of Financial Education","url":"http://jfedweb.org/jfedpage.html"},
    {"name":"Journal of Food, Agriculture and Environment","url":"http://world-food.net/products/scientific-journal-jfae/"},
    {"name":"Journal of Fundamental and Applied Sciences","url":"http://journal%20of%20fundamental%20and%20applied%20sciences/"},
    {"name":"Journal of Genetic and Environmental Resources Conservation","url":"http://www.jgerc.com/"},
    {"name":"Journal of Geotechnical and Transportation Engineering","url":"http://jgtte.com/"},
    {"name":"Journal of Global Biosciences","url":"http://www.mutagens.co.in/"},
    {"name":"Journal of Global Business Management","url":"http://www.jgbm.org/"},
    {"name":"Journal of Global Innovations in Agricultural and Social Sciences","url":"http://jgiass.com/"},
    {"name":"Journal of Global Research in Computer Science","url":"http://www.jgrcs.info/index.php/jgrcs"},
    {"name":"Journal of Health Economics and Outcomes Research","url":"http://www.jheor.org/"},
    {"name":"Journal of Health, Sport and Tourism","url":"http://www.eu-print.org/tur.php"},
    {"name":"Journal of HerbMed Pharmacology","url":"http://www.herbmedpharmacol.com/"},
    {"name":"Journal of Human Resource and Adult Learning","url":"http://www.hraljournal.com/"},
    {"name":"Journal of Humanities and Cultural Studies R&D","url":"http://jrsdjournal.wix.com/humanities-cultural"},
    {"name":"Journal of Hydrology and Environment Research","url":"http://jher.org/"},
    {"name":"JCR","url":"http://mjl.clarivate.com/cgi-bin/jrnlst/jlresults.cgi?PC=MASTER&ISSN=1312-773X"},
    {"name":"Journal of Industrial and Intelligent Information","url":"http://www.jiii.org/"},
    {"name":"Journal of Information Management","url":"http://splpjim.org/"},
    {"name":"Journal of Innovations in Applied Pharmaceutical Science","url":"http://www.jiapsonline.com/"},
    {"name":"Journal of Innovations in Pharmaceuticals and Biological Sciences","url":"http://www.jipbs.com/"},
    {"name":"Journal of Innovative Biology","url":"http://jibresearch.com/"},
    {"name":"Journal of Innovative Engineering","url":"http://www.jieonline.org/"},
    {"name":"Journal of Innovative Research and Solutions","url":"http://www.jirasindia.com/"},
    {"name":"Journal of Intercultural Ethnopharmacology","url":"http://www.jicep.com/"},
    {"name":"Journal of Interdisciplinary Histopathology","url":"http://www.scopemed.org/?jid=60"},
    {"name":"Journal of International Academic Research for Multidisciplinary","url":"http://www.jiarm.com/home.html"},
    {"name":"Journal of International Anatolia Sport Science","url":"http://www.jiasscience.com/Anasayfa.Aspx"},
    {"name":"Journal of International Environmental Application & Science","url":"http://www.jieas.com/index.html"},
    {"name":"Journal of International Management Studies","url":"http://www.jimsjournal.org/index.html"},
    {"name":"Journal of Internet Banking and Commerce","url":"http://www.icommercecentral.com/"},
    {"name":"Journal of Investigational Biochemistry","url":"http://www.scopemed.org/?jid=61"},
    {"name":"Journal of Knowledge Management, Economics and Information Technology","url":"http://www.scientificpapers.org/"},
    {"name":"Journal of Language and Literature","url":"http://www.eu-print.org/filo.php"},
    {"name":"Journal of Law and Ethics","url":"http://www.eu-print.org/etika.php"},
    {"name":"Journal of Materials and Environmental Science","url":"http://www.jmaterenvironsci.com/"},
    {"name":"Journal of Mathematics and Computer Science","url":"http://www.tjmcs.com/index.php"},
    {"name":"Journal of Mathematics and Technology","url":"http://www.eu-print.org/riy.php"},
    {"name":"Journal of Media & Mass Communication","url":"http://www.jmmc.org/"},
    {"name":"Journal of Media Critiques","url":"http://www.mediacritiques.net/index.php/jmc"},
    {"name":"Journal of Medical Science and Technology","url":"http://www.jmst.webs.com/"},
    {"name":"Journal of Molecular Pathophysiology","url":"http://www.scopemed.org/?jid=66"},
    {"name":"Journal of Nano Innovation","url":"http://nanoinnovationjournal.com/"},
    {"name":"Journal of Natural Products","url":"http://journalofnaturalproducts.com/"},
    {"name":"Journal of Novel Applied Sciences","url":"http://jnasci.org/"},
    {"name":"Journal of Medical Biomedical and Applied Sciences","url":"http://www.jmbm.in/index.php/jmbm"},
    {"name":"Journal of Medical Pharmaceutical and Allied Sciences","url":"http://www.jmpas.com/index.php"},
    {"name":"The Journal of Medical Research","url":"http://medicinearticle.com/"},
    {"name":"Journal of Medical Research and Practice","url":"http://jmrp.info/index.php/jmrp"},
    {"name":"Journal of Medical Science and Clinical Research","url":"http://jmscr.igmpublication.org/home/"},
    {"name":"Plants Journal / Journal of Medicinal Plants Studies","url":"http://www.plantsjournal.com/"},
    {"name":"Journal of Middle East and North Africa Sciences","url":"http://www.jomenas.org/home.html"},
    {"name":"Journal of Middle East Applied Science and Technology","url":"http://jmeast.webs.com/"},
    {"name":"Journal of Microbiology and Antimicrobial Agents","url":"http://jmaa.co.uk/"},
    {"name":"Journal of Modern Science & Heritage","url":"http://www.jmsh.eu/"},
    {"name":"Journal of Modern Science And Technology","url":"http://jmstpapers.com/editorial_board"},
    {"name":"Journal of Multidisciplinary Developments","url":"http://www.jomude.com/index.php/index/index"},
    {"name":"Journal of Multidisciplinary Engineering Science and Technology","url":"http://www.jmest.org/"},
    {"name":"Journal of Multidisciplinary Engineering Science Studies","url":"http://jmess.org/"},
    {"name":"Journal of Nature and Science","url":"http://www.jnsci.org/"},
    {"name":"Journal of Neurology & Neuromedicine","url":"http://www.jneurology.com/index.php"},
    {"name":"Journal of New Sciences","url":"http://www.jnsciences.org/"},
    {"name":"Journal of Nonlinear Science and Applications","url":"http://www.emis.de/journals/TJNSA/"},
    {"name":"Journal of Pharmaceutical and Bioanalytical Science ","url":"http://www.jpbscience.com/"},
    {"name":"Journal of Pharmaceutical and Biological Sciences","url":"http://www.jpabs.org/"},
    {"name":"Journal of Pharmaceutical and Biomedical Sciences","url":"http://www.jpbms.info/"},
    {"name":"Journal of Pharmaceutical and Scientific Innovation","url":"http://jpsionline.com/"},
    {"name":"Journal of Pharmaceutical, Chemical and Biological Sciences","url":"http://www.jpcbs.info/Home_Page.html"},
    {"name":"Journal of Pharmacognosy and Phytochemistry","url":"http://www.phytojournal.com/"},
    {"name":"Journal of Pharmacy Practice and Community Medicine","url":"http://www.jppcm.org/"},
    {"name":"Journal of Pharmacy Research","url":"http://jpronline.info/index.php/jpr/index"},
    {"name":"Journal of Physical Education Research","url":"http://www.joper.org/"},
    {"name":"Journal of Physical Therapy Science","url":"https://www.jstage.jst.go.jp/browse/jpts"},
    {"name":"Journal of Psychology and Theology","url":"http://www.dinz.info/"},
    {"name":"Journal of Postharvest Technology","url":"http://jpht.info/index.php/jpht/"},
    {"name":"Journal of Process Management New Technologies International","url":"http://journal%20of%20process%20management%20new%20technologies%20international%20%28jpmnt%29/"},
    {"name":"Journal of Rare Diseases Research & Treatment","url":"http://rarediseasesjournal.com/index.php"},
    {"name":" Journal of Reading and Literacy","url":"https://journalofreadingandliteracy.wordpress.com/"},
    {"name":"Journal of Research in Anaesthesology and Pain Medicine","url":"http://www.jrapm.com/"},
    {"name":"Journal of Research in Biology","url":"http://www.jresearchbiology.com/"},
    {"name":"Journal of Research in Computers and Technology","url":"http://www.jrctonline.com/"},
    {"name":"Journal of Research in Forensic Medicine and Toxicology","url":"http://www.jrfmt.com/"},
    {"name":"Journal of Research in General Surgery and Laparoscopy","url":"http://www.jegsl.com/"},
    {"name":"Journal of Research in Human Anatomy and Embryology","url":"http://www.jrhae.com/"},
    {"name":"Journal of Research in Obstetrics, Gynaecology and Infertility","url":"http://www.jrogi.com/"},
    {"name":"Journal of Research in Preventive and Social Medicine","url":"http://www.jrpsm.com/"},
    {"name":"Journal of Research in Psychiatry and Behavioural Sciences","url":"http://www.jrpbs.com/"},
    {"name":"Journal of Research in Psychiatry and Behavioural Sciences","url":"http://www.jrpbs.com/"},
    {"name":"Journal of Research in Radiodiagnosis, Teleradiology and Imaging","url":"http://www.jrrti.com/"},
    {"name":"Journal of Research in Traditional Medicine","url":"http://www.tmjournal.org/"},
    {"name":"Journal of Science","url":"http://www.journalofscience.net/"},
    {"name":"Journal of Science and Its Applications","url":"http://naukpublication.org/index.php/JOURNAL_SCIENCE_APPLICATIONS"},
    {"name":"Journal of Science and Technology Advances","url":"http://www.imedpharm.com/journals/index.php/JSTA"},
    {"name":"Journal of Science Editing","url":"http://journalofscienceediting.org/"},
    {"name":"Journal of Scientific and Engineering Research","url":"http://jsaer.com/"},
    {"name":"Journal of Scientific Letters","url":"http://www.jslsci.org/"},
    {"name":"Journal of Scientific Research and Development","url":"http://jsrad.org/"},
    {"name":"Journal of Scientific Research and Development","url":"http://jsrd.org/index.html"},
    {"name":"Journal of Scientific Research in Pharmacy","url":"http://www.jsrponline.com/"},
    {"name":"Journal of Scientific Research in Physical & Mathematical Sciences","url":"http://www.jsrpms.com/index.php"},
    {"name":"Journal of Scientific Theory and Methods","url":"http://journalofscientifictheoryandmethods.com/"},
    {"name":"Journal of Social Issues & Humanities","url":"http://www.journalsih.com/index.html"},
    {"name":"Journal of Software","url":"http://www.jsoftware.us/"},
    {"name":"Journal of Spectroscopy and Molecular Physics","url":"http://journal%20of%20spectroscopy%20and%20molecular%20physics/"},
    {"name":"Journal of Surgery & Patient Care","url":"http://surgeryopenaccess.com/"},
    {"name":"Journal of Telecommunications","url":"http://www.journaloftelecommunications.co.uk/home"},
    {"name":"Journal of The International Association of Advanced Technology and Science","url":"http://www.jiaats.com/index.php"},
    {"name":"Journal of Theoretical and Applied Information Technology","url":"http://www.jatit.org/index.php"},
    {"name":"Journal of Trends in the Development of Machinery and Associated Technology","url":"http://www.tmt.unze.ba/proceedings2014.php"},
    {"name":"Jundishapur Journal of Health Sciences","url":"http://jjhsci.com/"},
    {"name":"Junior Scientific Researcher","url":"http://www.jsrpublishing.com/"},
    {"name":"Kashmir Economic Review","url":"http://ker.ajku.edu.pk/"},
    {"name":"LangLit","url":"http://www.langlit.org/"},
    {"name":"Lecture Notes on Software Engineering","url":"http://www.lnse.org/"},
    {"name":"Legal Research Development","url":"http://lrdjournal.com/"},
    {"name":"Letters in Applied NanoBioScience","url":"http://nanobioletters.com/"},
    {"name":"LiBRI: Linguistic and Literary Broad Research and Innovation","url":"http://www.edusoft.ro/brain/index.php/libri"},
    {"name":"Lingua: International Journal of Linguistics, Literature and Culture","url":"http://ijllc.eu/"},
    {"name":"Lokavishkar International E-Journal","url":"http://liirj.org/"},
    {"name":"The Macrotheme Review","url":"http://macrotheme.com/home"},
    {"name":"Malti: International Hindi e-Research Journal","url":"http://www.maltihindijournal.info/"},
    {"name":"Mathematical and Computational Applications","url":"http://mcajournal.cbu.edu.tr/"},
    {"name":"Mechanics, Materials Science & Engineering Journal","url":"http://mmse.xyz/en/"},
    {"name":"Medical Research Archives","url":"http://journals.ke-i.org/index.php/mra"},
    {"name":"Medico Research Chronicles","url":"http://www.medrech.com/"},
    {"name":"Mediterranean Journal of Biosciences","url":"http://ojs.medjbio.com/index.php/medjbio"},
    {"name":"Mediterranean Journal of Chemistry","url":"http://www.medjchem.com/index.php/medjchem/index"},
    {"name":"Mediterranean Journal of Modeling & Simulation","url":"https://sites.google.com/site/lesimjms/home"},
    {"name":"Mediterranean Journal of Physics","url":"http://ojs.medjphysics.com/index.php/medjphysics"},
    {"name":"MedLife Clinics","url":"http://medlifeclinics.org/demo/"},
    {"name":"Modern Behavioral Science","url":"http://pwriters.com/index.php/mbs/index"},
    {"name":"The Modern Journal of Applied Linguistics","url":"http://www.mjal.org/index.htm"},
    {"name":"Modern Journal of Language Teaching Methods","url":"http://www.mjltm.com/index.php"},
    {"name":"Multidisciplinary Scientific Reviewer","url":"http://oiirj.org/oiirj/msr/"},
    {"name":"Munis Entomology & Zoology","url":"http://www.munisentzool.org/"},
    {"name":"NanoWorld Journal","url":"http://www.jnanoworld.com/index.php"},
    {"name":"National Journal of Basic Medical Sciences","url":"http://njbms.com/"},
    {"name":"National Journal of Community Medicine","url":"http://www.njcmindia.org/home"},
    {"name":"National Journal of Medical and Dental Research","url":"http://njmdr.org/"},
    {"name":"National Journal of Physiology, Pharmacy, and Pharmacology","url":"http://www.njppp.com/"},
    {"name":"Norwegian Journal of Development of the International Science","url":"http://www.njd-iscience.com/njdis/"},
    {"name":"OIDA International Journal of Sustainable Development","url":"http://www.ontariointernational.org/Publications.html"},
    {"name":"Oncoscience","url":"http://www.impactjournals.com/oncoscience/index.php"},
    {"name":"Oncotarget","url":"http://www.impactjournals.com/oncotarget/index.php?journal=oncotarget&page=index"},
    {"name":"Online International Interdisciplinary Research Journal","url":"http://oiirj.org/oiirj/"},
    {"name":"Online Journal of Communication and Media Technologies","url":"http://www.ojcmt.net/"},
    {"name":"The Online Journal of Distance Education and e-Learning","url":"http://tojdel.net/"},
    {"name":"Online Journal of Library & Information Science","url":"http://ojlis.sel.org.pk/"},
    {"name":"The Online Journal of New Horizons in Education","url":"http://www.tojned.net/"},
    {"name":"The Online Journal of Science and Technology","url":"http://www.tojsat.net/"},
    {"name":"Open Access Journal of Science and Technology","url":"http://oajost.com/"},
    {"name":"Open Journal of Clinical & Medical Sciences","url":"http://jclinmedsciences.com/index.html"},
    {"name":"Open Journal of Clinical & Medical Case Reports","url":"http://jclinmedcasereports.com/index.html"},
    {"name":"Oriental Journal of Computer Science and Technology","url":"http://www.computerscijournal.org/"},
    {"name":"Paripex Indian Journal of Research","url":"http://worldwidejournals.com/paripex/"},
    {"name":"Path of Science","url":"http://pathofscience.org/index.php/ps"},
    {"name":"Pattern Recognition in Physics","url":"http://www.pattern-recognition-in-physics.com/"},
    {"name":"People’s Journal of Scientific Research","url":"http://www.pjsr.org/Home.html"},
    {"name":"Pharma Innovation","url":"http://www.thepharmajournal.com/"},
    {"name":"The Pharma Research (Journal)","url":"http://www.thepharmaresearch.info/"},
    {"name":"Pharmaceutical and Biological Evaluations","url":"http://www.onlinepbe.com/index.php/PBE/index"},
    {"name":"Pharmaceutical and Chemical Journal","url":"http://tpcj.org/"},
    {"name":"Pharmacie Globale: International Journal of Comprehensive Pharmacy","url":"http://pharmacie-globale.info/"},
    {"name":"Pharmacognosy: Journal of Pharmacognosy and Phytochemistry","url":"http://www.phytojournal.com/"},
    {"name":"Pharmacologia","url":"http://pharmacologia.com/"},
    {"name":"PharmacologyOnline","url":"http://pharmacologyonline.silae.it/front"},
    {"name":"PHARMANEST: An International Journal of Advances in Pharmaceutical Sciences","url":"http://www.pharmanest.net/"},
    {"name":"Physical Education and Sports Research Journal","url":"http://pe.lsrj.in/"},
    {"name":"Plant Digest","url":"http://plantdigest.co.uk/index.php"},
    {"name":"Professionals Center for Business Research","url":"http://pcbr.net/"},
    {"name":"Progress in Physics","url":"http://www.ptep-online.com/"},
    {"name":"Pyxis Journal","url":"http://pyxis-journal.ru/"},
    {"name":"PunarnaV","url":"http://www.punarnav.com/"},
    {"name":"Quarterly Physics Review","url":"http://journals.ke-i.org/index.php/qpr"},
    {"name":"Reef Resources Assessment and Management Technical Paper","url":"http://behaviorsciences.com/"},
    {"name":"Remedy Open Access","url":"http://remedyoa.com/"},
    {"name":"Research","url":"http://www.labome.org/"},
    {"name":"Research (French version)","url":"http://www.labome.fr/"},
    {"name":"Research Ambition","url":"http://researchambition.com/"},
    {"name":"Research Chronicler","url":"http://research-chronicler.com/reschro/index.asp"},
    {"name":"Research Chronicles","url":"http://www.reschrone.com/"},
    {"name":"Research Dimension","url":"http://rd.researchdirection.org/Default.aspx"},
    {"name":"Research Directions","url":"http://researchdirection.org/Default.aspx"},
    {"name":"Research in Biotechnology","url":"http://www.researchinbiotechnology.com/home"},
    {"name":"Research in Pharmacy and Health Sciences","url":"http://www.rphsonline.com/"},
    {"name":"Research Innovator","url":"http://research-chronicler.com/resinv/index.asp"},
    {"name":"Research Inspiration","url":"http://researchinspiration.com/"},
    {"name":"Research Inventy: International Journal of Engineering and Science","url":"http://www.researchinventy.com/index.html"},
    {"name":"Research Journal of Life Sciences, Bioinformatics, Pharmaceutical, and Chemical Sciences","url":"http://rjlbpcs.com/"},
    {"name":"Research Journal of Pharmaceutical, Biological and Chemical Sciences","url":"http://www.rjpbcs.com/index.html"},
    {"name":"Research Opinions in Animal and Veterinary Sciences","url":"http://www.roavs.com/"},
    {"name":"Research Revolution","url":"http://www.researchrevolution.in/index.php"},
    {"name":"Research Scholar","url":"http://www.researchscholar.co.in/"},
    {"name":"ResearchDesk","url":"http://researchdesk.net/"},
    {"name":"Researchers World – Journal of Arts Science & Commerce","url":"http://www.researchersworld.com/index.html"},
    {"name":"Review of Research","url":"http://ror.isrj.org/"},
    {"name":"Reviews of Progress","url":"http://reviewsofprogress.org/"},
    {"name":"Revista Electrónica de las Ciencias Computacionales e Informática","url":"http://www.reci.org.mx/"},
    {"name":"Revista Iberoamericana de Ciencas","url":"http://www.reibci.org/"},
    {"name":"Revista Iberoamericana de Contaduría, Economía y Administración","url":"http://www.ricea.org.mx/"},
    {"name":"Revista Iberoamericana de las Ciencias Biológicas y Agropecuarias","url":"http://ciba.org/"},
    {"name":"Revista Iberoamericana de las Ciencias Biológicas y Agropecuarias","url":"http://www.ciba.org.mx/"},
    {"name":"Revista Iberoamericana de las Ciencias de la Salud","url":"http://www.rics.org.mx/"},
    {"name":"Revista Iberoamericana de las Ciencias Sociales y Humanísticas","url":"http://www.ricsh.org.mxmx/"},
    {"name":"Revista Iberoamericana para la Investigación y el Desarrollo Educativo","url":"http://www.ride.org.mx/"},
    {"name":"Romanian Biotechnological Letters","url":"http://www.rombio.eu/"},
    {"name":"Sanskruti International Multidisciplinary Research Journal","url":"http://www.journals.savap.org.pk/"},
    {"name":"Scholarly Research Exchange","url":"http://srej.wc.lt/"},
    {"name":"Scholars World- International Refereed Multidisciplinary Journal Of Contemporary Research","url":"http://scholarsworld.net/english/"},
    {"name":"Science and Engineering Applications","url":"http://jfips.com/"},
    {"name":"Science International","url":"http://www.scienceinternational.com/"},
    {"name":"Science International (Lahore)","url":"http://sci-int.com/"},
    {"name":"Science Park","url":"http://www.scienceparks.in/Default.aspx"},
    {"name":"Science Postprint","url":"http://www.spp-j.com/"},
    {"name":"Science Research Reporter","url":"http://www.jsrr.in/"},
    {"name":"Science Reuters","url":"http://www.sciencereuters.com/"},
    {"name":"Scientific Light","url":"http://www.slg-journal.com/home"},
    {"name":"Scientific Research Journal","url":"http://www.scirj.org/"},
    {"name":"Scientific Research Journal of India","url":"https://sites.google.com/site/scientificrji/"},
    {"name":"Scientific Researches","url":"http://science-research.com/"},
    {"name":"Scientific Transactions in Environment and Technovation","url":"http://scientific%20transactions%20in%20environment%20and%20technovation/"},
    {"name":"Scientific World","url":"http://scientificworld.co.uk/"},
    {"name":"Scitech Journal","url":"http://www.thescitech.com/"},
    {"name":"Scottish Journal of Arts, Social Sciences and Scientific Studies","url":"http://scottishjournal.co.uk/"},
    {"name":"SCRO Annual Report Journal","url":"http://scroreport.com/index.php/SCROAR/index"},
    {"name":"Sensors & Transducers Journal","url":"http://www.sensorsportal.com/HTML/DIGEST/Journal_Subscription.htm"},
    {"name":"Seventh Sense Research Group Journal","url":"http://ssrgj.blogspot.com/"},
    {"name":"Shiraz E-Medical Journal","url":"http://emedicalj.com/"},
    {"name":"Shiv Rudraksha International Journal of Advanced Research in Engineering & Management","url":"http://www.srijarem.in/"},
    {"name":"Smart & Young","url":"http://smartandyoung.com.ua/uk/"},
    {"name":"Smart Nanosystems in Engineering and Medicine","url":"http://gintem.org/"},
    {"name":"South Asian Journal of Food Technology and Environment","url":"http://www.sweft.in/"},
    {"name":"South Asian Journal of Mathematics","url":"http://www.sajm.com.nu/index.htm"},
    {"name":"South Indian Journal Of Biological Sciences","url":"http://www.sijbs.com/index.html/"},
    {"name":"South Pacific Journal of Technology and Science","url":"http://spjts.com/"},
    {"name":"South Pacific Journal of Pharma and Bio Sciences","url":"http://spjpbs.com/"},
    {"name":"Sport Science","url":"http://www.sposci.com/index.html"},
    {"name":"Swedish Journal of Scientific Research","url":"https://sjsr.se/en/home.php"},
    {"name":"Swiss Journal of Research in Business and Social Science","url":"http://www.sjrbss.com/"},
    {"name":"Tactful Management Research Journal","url":"http://tmgt.lsrj.in/"},
    {"name":"Technical Journal of Engineering and Applied Sciences","url":"http://tjeas.com/"},
    {"name":"Technics Technologies Education Management","url":"http://www.ttem.ba/index.html"},
    {"name":"Translational Medicine and Biotechnology","url":"http://oiirj.org/oiirj/tmb/"},
    {"name":"Transnational Journal of Science and Technology","url":"http://www.tjournal.org/"},
    {"name":"Transworld Medical Journal","url":"http://www.tmjournals.com/"},
    {"name":"Trends Journal of Sciences Research","url":"http://www.tjsr.org/"},
    {"name":"Tropical Plant Research","url":"http://www.tropicalplantresearch.com/"},
    {"name":"Turkish Journal of Scientific Research","url":"http://tjsrjournal.com/"},
    {"name":"Turkish Online Journal of Educational Technology","url":"http://www.tojet.net/"},
    {"name":"Ultra Engineer","url":"http://www.ultra-engineer.org/"},
    {"name":"Ulutas Genetic Research Journal","url":"http://www.geneticresearchjournal.com/"},
    {"name":"The Ulutas Medical Journal","url":"http://www.ulutasmedicaljournal.com/"},
    {"name":"Universal Journal of Applied Computer Science and Technology","url":"http://uniascit.in/index.php"},
    {"name":"Universal Journal of Computer Science and Engineering Technology","url":"http://www.unicse.org/"},
    {"name":"Universal Journal of Pharmaceutical Research","url":"http://www.ujpr.org/"},
    {"name":"Universal Journal of Pharmacy","url":"http://www.ujponline.com/"},
    {"name":"Universe of Emerging Technology and Science","url":"http://www.uniets.com/"},
    {"name":"Visi Jurnal Akademik","url":"http://www.visijurnal.com/"},
    {"name":"Weberbauerella","url":"http://weberbauerella.org/"},
    {"name":"Weekly Science International Research Journal","url":"http://www.weeklyscience.org/Default.aspx"},
    {"name":"World Academy of Informatics and Management Sciences","url":"http://www.waims.co.in/index.aspx"},
    {"name":"World Applied Sciences Journal","url":"http://www.wasj.org/"},
    {"name":"World Essays Journal","url":"http://worldessaysj.com/en/"},
    {"name":"World Journal of Innovative Research","url":"https://www.wjir.org/"},
    {"name":"World Journal of Engineering Research and Technology","url":"http://www.wjert.org/"},
    {"name":"World Journal of Pharmaceutical and Medical Research","url":"http://www.wjpmr.com/"},
    {"name":"World Journal of Pharmaceutical and Life Sciences","url":"http://wjpls.org/home"},
    {"name":"World Journal of Pharmaceutical Research","url":"http://www.wjpr.net/"},
    {"name":"World Journal of Pharmaceutical Sciences ","url":"http://www.wjpsonline.org/"},
    {"name":"World Journal of Pharmacy and Pharmaceutical Sciences","url":"http://www.wjpps.com/"},
    {"name":"World Journal of Research and Review","url":"https://www.wjrr.org/"},
    {"name":"World Journal of Science and Technology","url":"http://worldjournalofscience.com/"},
    {"name":"World Medical Student Journal","url":"http://worldmsjournal.org/index.php/worldmsj"},
    {"name":"World Scientific News","url":"http://www.worldscientificnews.com/"},
    {"name":"World Wide Journal of Multidisciplinary Research and Development","url":"http://wwjmrd.com/"},
    {"name":"Adalya Journal","url":"http://adalyajournal.com/"},
    {"name":"Advances in Fixed Point Theory","url":"http://scik.org/index.php/afpt"},
    {"name":"Aegaeum","url":"http://aegaeum.com/"},
    {"name":"Agrociencia","url":"http://www.colopos.mx/"},
    {"name":"AGU International Journal of Engineering & Technology","url":"http://aguijet.com/"},
    {"name":"AGU International Journal of Professional Studies & Research","url":"http://aguijpsr.com/"},
    {"name":"AGU International Journal of Research in Social Science & Humanities","url":"http://aguijrssh.com/"},
    {"name":"Annals of Clinical and Medical Case Reports","url":"https://acmcasereport.com/"},
    {"name":"Annals of Clinical and Medical Case Reports","url":"http://acmcaserep.com/"},
    {"name":"Annals of Dental Specialty","url":"https://annalsofdentalspecialty.net.in/en"},
    {"name":"American Journal of Biomedical Science & Research","url":"https://biomedgrid.com/"},
    {"name":"American Journal of Humanities and Social Sciences Research","url":"https://www.ajhssr.com/"},
    {"name":"American Journal of Multidisciplinary Research and Development","url":"https://www.ajmrd.com/"},
    {"name":"Amphibian & Reptile Conservation","url":"http://amphibian-reptile-conservation.org/"},
    {"name":"Arabian Journal of Medical Sciences","url":"http://www.ajms.tk/"},
    {"name":"Archives of Applied Medicine","url":"https://aoamj.org/"},
    {"name":"ARCTIC Journal","url":"http://arcticjournal.org/index.html"},
    {"name":"Asian Journal of Applied Science and Technology","url":"http://www.ajast.net/"},
    {"name":"Asian Journal of Emerging Research","url":"http://amscentral.com/ajer/"},
    {"name":"Aurora’s International Journal of Computing​","url":"http://www.aurora-journal.com/"},
    {"name":"Biomedical Journal of Scientific & Technical Research","url":"https://biomedres.us/"},
    {"name":"Biomedical Journal of Scientific & Technical Research","url":"http://openaccessjournal.us/"},
    {"name":"BOREAL ENVIRONMENT RESEARCH","url":"http://borenv.com/"},
    {"name":"British Journal of Biomedical Research","url":"http://bjbmr.org/"},
    {"name":"British Journal of Medical & Health Sciences","url":"http://jmhsci.org/"},
    {"name":"British Journal of Pharmaceutical and Medical Research​","url":"https://www.bjpmr.org/"},
    {"name":"Canadian Journal of Biomedical Research and Technology","url":"https://biomedress.com/"},
    {"name":"CCAMLR Science","url":"http://www.ccamlrscience.com/"},
    {"name":"Cell Medicine","url":"https://www.cognizantcommunication.com/journal-titles/cell-medicine"},
    {"name":"Core Evidence","url":"https://www.dovepress.com/core-evidence-journal"},
    {"name":"Current Biomarker Findings","url":"https://www.dovepress.com/current-biomarker-findings-journal"},
    {"name":"Current Neurobiology","url":"http://currentneurobiology.org/"},
    {"name":"Current Science","url":"http://currentscience.org/"},
    {"name":"Danish Scientific Journal","url":"http://www.danish-journal.com/"},
    {"name":"Degenerative Neurological and Neuromuscular Disease","url":"https://www.dovepress.com/degenerative-neurological-and-neuromuscular-disease-journal"},
    {"name":"Disseminate Knowledge","url":"http://www.sjvndk.com/"},
    {"name":"Estudos de Psicologia (Campinas)","url":"http://www.scielo.br/estpsi"},
    {"name":"European Journal of General Dentistry","url":"http://www.ejgd.org/"},
    {"name":"European Journal of Molecular & Clinical Medicine","url":"https://ejmcm.com/"},
    {"name":"FOURRAGES","url":"http://afpf-asso.com/"},
    {"name":"Global Journal of Advance Research on Classical and Modern Geometries","url":"http://geometry-math-journal.ro/"},
    {"name":"Global Journal of Engineering Science and Researches","url":"http://www.gjesr.com/"},
    {"name":"Global Journal of Research on Medicinal Plants & Indigenous Medicine","url":"http://www.gjrmi.com/"},
    {"name":"Global Scientific Journal – GSJ Publication","url":"http://www.globalscientificjournal.com/"},
    {"name":"High Technology Letters","url":"http://www.gjstx-e.cn/"},
    {"name":"IARTEM e-journal","url":"http://biriwa.com/iartem/ejournal/"},
    {"name":"IBMRD’s Journal of Management Research","url":"http://www.ibmrdjournal.com/"},
    {"name":"Iconic Research & Engineering Journals","url":"http://www.irejournals.com/"},
    {"name":"The IIOAB Journal","url":"https://iioab-journal.webs.com/"},
    {"name":"IJPUB – International Peer Reviewed, Open Access Journal","url":"http://ijpub.org/"},
    {"name":"International Journal of Creative Research Thoughts","url":"http://ijcrt.org/"},
    {"name":"Indian Journal of Public Health Research and Development","url":"http://www.ijphrd.com/"},
    {"name":"Indonesian Journal of Business Finance and Accounting","url":"http://thomson.id/index.php/ijbfa"},
    {"name":"Indonesian Journal of Management and Business Economics","url":"http://thomson.id/index.php/ijmbe"},
    {"name":"Interciencia","url":"http://intercienciajournal.com/"},
    {"name":"International New Arts and Sciences Research Journal​","url":"http://www.artsandsciencesjournal.com/"},
    {"name":"International Bulletin of Drug Research","url":"http://www.ibdr.in/"},
    {"name":"International Education and Leadership","url":"http://www.jielusa.org/"},
    {"name":"International Educational Applied Research Journal","url":"http://iearj.com/"},
    {"name":"International Invention of Scientific Journal","url":"http://www.iisj.in/index.php/iisj"},
    {"name":"International Journal for Engineering and Emerging Technologies","url":"http://www.ijfeet.com/"},
    {"name":"International Journal of Advanced Computer Research","url":"http://accentsjournals.org/journals.php?journalsId=103"},
    {"name":"International Journal of Advanced Research in Computer Engineering & Technology","url":"http://ijarcet.org/"},
    {"name":"International Journal of Advanced Research in Education Technology and Management","url":"http://ijaretm.com/"},
    {"name":"International Journal of Advanced Research in Electronics and Communication Engineering","url":"http://ijarece.org/"},
    {"name":"International Journal of Advanced Research in Innovative Discoveries in Engineering and Applications","url":"http://ijaridea.com/"},
    {"name":"International Journal of Advanced Research in Management, Architecture, Technology and Engineering","url":"http://www.ijarmate.com/"},
    {"name":"International Journal of Advanced Research and Publications","url":"http://www.ijarp.org/"},
    {"name":"International Journal of Advanced Research Trends in Engineering and Technology","url":"http://ijartet.com/"},
    {"name":"International Journal of Advanced Scientific Research","url":"http://www.allscientificjournal.com/"},
    {"name":"International Journal of Agriculture, Environment and Bioresearch","url":"http://ijaeb.org/"},
    {"name":"International Journal of Agriculture and Biosciences","url":"http://www.ijagbio.com/"},
    {"name":"International Journal of Biopharmaceutics","url":"https://www.ijbonline.com/"},
    {"name":"International Journal of Business and Information","url":"https://ijbi.org/ijbi"},
    {"name":"International Journal of Business Management and Commerce","url":"http://www.ijbmcnet.com/"},
    {"name":"International Journal of Basic & Clinical Pharmacology","url":"http://www.ijbcp.com/"},
    {"name":"International Journal of Communication and Computer Technologies","url":"http://ijccts.org/"},
    {"name":"International Journal of Computer Science and Management Studies","url":"http://www.ijcsms.com/"},
    {"name":"International Journal of Computer Science and Mobile Computing","url":"https://www.ijcsmc.com/"},
    {"name":"IJPUB","url":"http://ijpub.org/"},
    {"name":"International Journal of Dental Science and Innovative Research","url":"https://www.ijdsir.com/"},
    {"name":"International Journal of Education and Science Research Review","url":"http://ijesrr.org/"},
    {"name":"International Journal of Electronics, Communication and Soft Computing Science and Engineering","url":"http://www.ijecscse.org/"},
    {"name":"International Journal of Electronics and Computer Science Engineering","url":"http://www.ijecse.org/"},
    {"name":"International Journal of Engineering, Economics And Management","url":"http://ijeem.org/"},
    {"name":"International Journal of Engineering Research and Sports Science","url":"http://www.ijerss.com/"},
    {"name":"International Journal of Engineering Science Technology And Research","url":"http://ijestr.com/"},
    {"name":"International Journal of Engineering Studies and Technical Approach","url":"http://ijesta.com/"},
    {"name":"International Journal of Eurasia Social Sciences","url":"http://www.ijoess.com/Anasayfa.Aspx"},
    {"name":"International Journal of Health Medicine and Current Research","url":"http://ijhmcr.com/"},
    {"name":"International Journal of Innovative Science and Research Technology","url":"https://ijisrt.com/"},
    {"name":"International Journal of Innovative Technology and Adaptive Management","url":"http://www.ijitam.org/"},
    {"name":"International Journal of Innovative Technology and Creative Engineering","url":"http://www.ijitce.co.uk/"},
    {"name":"International Journal of Latest Research in Humanities and Social Science","url":"http://www.ijlrhss.com/"},
    {"name":"International Journal of Learning and Teaching","url":"http://www.ijlt.org/"},
    {"name":"International Journal of Lifescience and Pharma Research","url":"http://www.ijlpr.com/"},
    {"name":"International Journal of Materials, Mechanics and Manufacturing","url":"http://www.ijmmm.org/"},
    {"name":"International Journal of Medical, Health Science and Internal Research","url":"http://www.ijmhsir.com/"},
    {"name":"International Journal of Medical Science and Advanced Clinical Research","url":"https://www.ijmacr.com/"},
    {"name":"International Journal of Medical Science and Applied Research","url":"https://www.ijmsar.com/"},
    {"name":"International Journal of Medical Science and Diagnosis Research","url":"https://www.ijmsdr.com/"},
    {"name":"International Journal of Medical Science and Innovative Research","url":"https://www.ijmsir.com/"},
    {"name":"International Journal of Medicine and Biomedical Research","url":"http://www.ijmbr.com/"},
    {"name":"International Journal of Medicine and Public Health","url":"http://www.ijmedph.org/"},
    {"name":"International Journal of Modern Trends in Engineering and Science","url":"http://ijmtes.com/"},
    {"name":"International Journal of Multidisciplinary Approach & Studies","url":"http://ijmas.com/"},
    {"name":"International Journal of Multidisciplinary Consortium","url":"http://ijmc.rtmonline.in/"},
    {"name":"International Journal of Nanomedicine","url":"https://www.dovepress.com/international-journal-of-nanomedicine-journal"},
    {"name":"International Journal of Novel Research and Development","url":"http://www.ijnrd.org/"},
    {"name":"International Journal of Preclinical and Pharmaceutical Research","url":"http://preclinicaljournal.com/"},
    {"name":"International Journal of Pharmaceutical Research and Allied Sciences","url":"https://ijpras.com/"},
    {"name":"International Journal of Reproduction, Contraception, Obstetrics and Gynecology","url":"http://www.ijrcog.org/"},
    {"name":"International Journal of Research and Applications","url":"http://ijraonline.com/"},
    {"name":"International Journal of Research in Computer Applications and Robotics","url":"http://www.ijrcar.com/"},
    {"name":"International Journal of Research in Medical Sciences","url":"http://www.msjonline.org/"},
    {"name":"International Journal of Scientific Engineering and Science","url":"http://ijses.com/"},
    {"name":"International Journal of Scientific Management and Development","url":"http://www.ijsmd.com/"},
    {"name":"International Journal of Scientific Research Engineering & Technology","url":"http://ijsret.org/"},
    {"name":"International Journal of Social Science and Business","url":"https://www.ijssb.com/"},
    {"name":"International Journal of Social Sciences and Information Technology","url":"https://www.ijssit.com/main/"},
    {"name":"International Journal of Trend in Scientific Research and Development","url":"https://www.ijtsrd.com/"},
    {"name":"International Journal of Zoology Studies","url":"http://www.zoologyjournals.com/"},
    {"name":"International Medical Journal","url":"https://www.seronijihou.com/"},
    {"name":"International Refereed Journal of Scientific Research in Engineering","url":"http://irjsre.com/"},
    {"name":"International Research Journal of Advanced Engineering and Science","url":"http://www.irjaes.com/"},
    {"name":"International Review of Humanities and Scientific Research","url":"https://www.irhsr.org/"},
    {"name":"Internet Journal of Rheumatology and Clinical Immunology","url":"https://www.chanrejournals.com/index.php/rheumatology/index"},
    {"name":"Iraqi National Journal of Chemistry","url":"http://iqnjc.com/"},
    {"name":"Istoriâ Zmievskogo kraâ","url":"https://colovrat.at.ua/"},
    {"name":"Journal of Academia and Industrial Research","url":"http://jairjp.com/"},
    {"name":"Journal of Accounting and Applied Business Research","url":"https://jaaabr.com/"},
    {"name":"Journal of Advanced Medical and Dental Sciences Research","url":"http://jamdsr.com/"},
    {"name":"Journal of Applied Bio-Science, Medicine, and Biology","url":"http://jabs.eu5.org/"},
    {"name":"Journal of Arts, Literature, Humanities and Social Sciences","url":"http://www.jalhss.com/index.php/jalhss"},
    {"name":"Journal of Engineering Technology","url":"http://www.joetsite.com/"},
    {"name":"Journal of English Language Teaching and Linguistics","url":"http://jeltl.org/"},
    {"name":"Journal of FisheriesSciences.com","url":"http://www.fisheriessciences.com/"},
    {"name":"Journal of Global Pharma Technology","url":"https://jgpt.co.in/"},
    {"name":"Journal of Multidisciplinary Academic Tourism","url":"http://dergipark.gov.tr/jomat"},
    {"name":"Journal of International Dental and Medical Research","url":"https://www.jidmr.com/"},
    {"name":"Journal of International Oral Health","url":"http://www.jioh.org/"},
    {"name":"Journal of Pharmacology and Pharmacotherapeutics","url":"http://www.jpharmacol.com/"},
    {"name":"Journal of Research in Ecology","url":"http://ecologyresearch.info/"},
    {"name":"Journal of Research and Opinion","url":"http://researchopinion.info/"},
    {"name":"Journal of Scientometric Research","url":"http://www.jscires.org/"},
    {"name":"Journal of Southwest Jiaotong University","url":"http://www.jsju.org/index.php/journal"},
    {"name":"Journal of Talent Development and Excellence","url":"http://www.iratde.com/"},
    {"name":"Journal of University of Shanghai for Science and Technology","url":"https://jusst.org/"},
    {"name":"Journal of Xi’an Shiyou University","url":"https://www.xisdxjxsu.asia/"},
    {"name":"Journal of Xi’an University of Architecture & Technology","url":"http://www.xajzkjdx.cn/"},
    {"name":"Journal of Xidian University","url":"http://xadzkjdx.cn/"},
    {"name":"Journal of the Pancreas","url":"http://www.joplink.net/"},
    {"name":"Jurnal Teknologi Informasi Dan Komunikasi Dalam Pendidikan","url":"http://jurnal.unimed.ac.id/2012/index.php/teknologi"},
    {"name":"Jurnal Teknologi Pendidikan","url":"http://jurnal.unimed.ac.id/2012/index.php/jtp"},
    {"name":"Jurnalul de Chirurgie","url":"http://jurnaluldechirurgie.ro/"},
    {"name":"MAGNT Research Report","url":"http://brisjast.com/"},
    {"name":"Material Science Research India","url":"http://www.materialsciencejournal.org/"},
    {"name":"Mechanics, Materials Science & Engineering Journal","url":"https://mmse.xyz/en/"},
    {"name":"Medical – Surgical Nursing Journal","url":"http://medsnj.com/en/index.html"},
    {"name":"Mintage Journal of Pharmaceutical and Medical Sciences","url":"http://www.mintagejournals.com/"},
    {"name":"Mitteilungen Klosterneuburg","url":"http://mitt-klosterneuburg.com/index.html"},
    {"name":"Mitteilungen Saechsischer Entomologen","url":"http://jamespublications.com/Mitteilungen_Saechsischer_Entomologen"},
    {"name":"Mugla Journal of  Science and Technology","url":"http://dergipark.gov.tr/muglajsci"},
    {"name":"National Journal of Commerce and Management","url":"http://njcm.pratibha-spandan.org/"},
    {"name":"The New American Journal of Medicine","url":"http://www.najmed.org/index.php"},
    {"name":"North American Journal of Medical Sciences","url":"http://www.najms.org/"},
    {"name":"Nursing and Midwifery Studies","url":"http://www.nmsjournal.com/"},
    {"name":"Oncology, Gastroenterology and Hepatology Reports","url":"http://www.oghreports.org/"},
    {"name":"Opción","url":"http://www.scieloopcion.com/"},
    {"name":"Oriental Journal of Chemistry","url":"http://www.orientjchem.org/"},
    {"name":"Paideuma Journal of Research","url":"http://paideumajournal.com/"},
    {"name":"Paideuma Journal of Research","url":"http://pjrpublication.com/"},
    {"name":"Palma Journal","url":"http://www.palmajournal.org/"},
    {"name":"Pharmacognosy Magazine","url":"http://www.phcog.com/"},
    {"name":"Pharmacognosy Research","url":"http://www.phcogres.com/"},
    {"name":"Pharmacognosy Reviews","url":"http://www.phcogrev.com/"},
    {"name":"Pioneer-scientists","url":"http://pioneer-scientists.org/"},
    {"name":"POLISH POLAR RESEARCH","url":"http://www.polishpolar.com/"},
    {"name":"Preslia Journal","url":"http://presliajournal.com/"},
    {"name":"Research on Modern Higher Education","url":"http://www.remhe.org/"},
    {"name":"Research Revolution","url":"http://www.researchrevolution.in/"},
    {"name":"Revista de Educacion","url":"http://revistaeducacion.org/"},
    {"name":"Revistas Electrónicas UACh","url":"http://www.ausrevista.info/"},
    {"name":"Revistas Electrónicas UACh","url":"http://www.ausrevista.com/"},
    {"name":"RGUSH Journal of Pharmaceutical Sciences","url":"http://www.rjps.in/"},
    {"name":"Signa Vitae – Journal of Intensive Care and Emergency Medicine","url":"http://www.signavitae.com/"},
    {"name":"Singaporean Journal of Business Economics and Management Studies","url":"https://www.singaporeanjbem.com/"},
    {"name":"Society: Politics, Economics, Law","url":"http://dom-hors.ru/"},
    {"name":"Taylors Science Gate","url":"http://taylorspublications.com/"},
    {"name":"Taylors Science Gate","url":"http://taylorspub.com/"},
    {"name":"Technology Reports of Kansai University","url":"http://kansaiuniversityreports.com/"},
    {"name":"TEST: Engineering & Management","url":"http://www.testmagzine.biz/"},
    {"name":"The Turkish Nephrology, Dialysis and Transplantation Journal","url":"http://www.tndt.org/"},
    {"name":"World Journal of Environmental Biosciences","url":"http://www.environmentaljournals.org/"},
    {"name":"World Nutrition, WPHNA","url":"https://worldnutritionjournal.org/index.php/wn"}
]

from urllib.parse import urlparse

POTENTIAL_PREDATORY_PUBLISHERS_HOSTS = set([urlparse(x.get("url")).netloc.replace("www.", "") for x in POTENTIAL_PREDATORY_PUBLISHERS])
POTENTIAL_PREDATORY_PUBLISHERS_NAMES = set([x.get("name").lower() for x in POTENTIAL_PREDATORY_PUBLISHERS])
POTENTIAL_PREDATORY_JOURNALS_URLS = set([x.get("url") for x in POTENTIAL_PREDATORY_JOURNALS])
POTENTIAL_PREDATORY_JOURNALS_NAMES = set([x.get("name").lower() for x in POTENTIAL_PREDATORY_JOURNALS])