from skidl import SKIDL, TEMPLATE, Part, Pin, SchLib

SKIDL_lib_version = '0.0.1'

philips = SchLib(tool=SKIDL).add_parts(*[
        Part(name='HTRC11001T',dest=TEMPLATE,tool=SKIDL,keywords='HITAG RFID',description='HITAG RF Reader Device, SOIC-14',ref_prefix='U',num_units=1,fplist=['SOIC-14*', 'SO-14*'],do_erc=True,pins=[
            Pin(num='1',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='2',name='TX2',func=Pin.OUTPUT,do_erc=True),
            Pin(num='3',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='4',name='TX1',func=Pin.OUTPUT,do_erc=True),
            Pin(num='5',name='MODE',do_erc=True),
            Pin(num='6',name='XTAL1',do_erc=True),
            Pin(num='7',name='XTAL2',func=Pin.OUTPUT,do_erc=True),
            Pin(num='8',name='SCLK',do_erc=True),
            Pin(num='9',name='DIN',do_erc=True),
            Pin(num='10',name='DOUT',func=Pin.OUTPUT,do_erc=True),
            Pin(num='12',name='CEXT',func=Pin.PASSIVE,do_erc=True),
            Pin(num='13',name='QGND',func=Pin.PASSIVE,do_erc=True),
            Pin(num='14',name='RX',do_erc=True)]),
        Part(name='P82B96',dest=TEMPLATE,tool=SKIDL,keywords='I2C Bus Buffer',description='Dual I2C Bus Buffer, DIP8/SO8/TSSOP8',ref_prefix='U',num_units=1,fplist=['DIP*', 'PDIP*', 'SOIC*', 'SO*', 'TSSOP*'],do_erc=True,pins=[
            Pin(num='1',name='SDA',func=Pin.BIDIR,do_erc=True),
            Pin(num='2',name='RXD-SDA',do_erc=True),
            Pin(num='3',name='TXD-SDA',func=Pin.OUTPUT,do_erc=True),
            Pin(num='4',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='5',name='TXD-SCL',func=Pin.OUTPUT,do_erc=True),
            Pin(num='6',name='RXD-SCL',do_erc=True),
            Pin(num='7',name='SCL',func=Pin.BIDIR,do_erc=True),
            Pin(num='8',name='VCC',func=Pin.PWRIN,do_erc=True)]),
        Part(name='PCA82C251',dest=TEMPLATE,tool=SKIDL,keywords='BUS CAN',description='CAN Transceiver for 24V Systems, SOIC-8',ref_prefix='U',num_units=1,fplist=['SO*', 'SOIC*'],do_erc=True,pins=[
            Pin(num='1',name='TxD',do_erc=True),
            Pin(num='2',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='3',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='4',name='RxD',func=Pin.OUTPUT,do_erc=True),
            Pin(num='5',name='Vref',func=Pin.OUTPUT,do_erc=True),
            Pin(num='6',name='CAN-',func=Pin.BIDIR,do_erc=True),
            Pin(num='7',name='CAN+',func=Pin.BIDIR,do_erc=True),
            Pin(num='8',name='Rsl',do_erc=True)]),
        Part(name='PCA9516',dest=TEMPLATE,tool=SKIDL,keywords='I2C Hub',description='5 channels I2C Hub, SO/TSSOP16',ref_prefix='U',num_units=1,fplist=['SO*', 'SOIC*', 'TSSOP*'],do_erc=True,pins=[
            Pin(num='1',name='SCL0',func=Pin.BIDIR,do_erc=True),
            Pin(num='2',name='SDA0',func=Pin.BIDIR,do_erc=True),
            Pin(num='3',name='SCL1',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='SDA1',func=Pin.BIDIR,do_erc=True),
            Pin(num='5',name='EN1',do_erc=True),
            Pin(num='6',name='SCL2',func=Pin.BIDIR,do_erc=True),
            Pin(num='7',name='SDA2',func=Pin.BIDIR,do_erc=True),
            Pin(num='8',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='9',name='EN2',do_erc=True),
            Pin(num='10',name='SCL3',func=Pin.BIDIR,do_erc=True),
            Pin(num='11',name='SDA3',func=Pin.BIDIR,do_erc=True),
            Pin(num='12',name='EN3',do_erc=True),
            Pin(num='13',name='SCL4',func=Pin.BIDIR,do_erc=True),
            Pin(num='14',name='SDA4',func=Pin.BIDIR,do_erc=True),
            Pin(num='15',name='EN4',do_erc=True),
            Pin(num='16',name='VCC',func=Pin.PWRIN,do_erc=True)]),
        Part(name='PCF8563',dest=TEMPLATE,tool=SKIDL,keywords='I2C RTC Clock Calendar',description='Realtime Clock/Calendar I2C Interface, DIP/SOIC/TSSOP-8',ref_prefix='U',num_units=1,fplist=['DIP*', 'PDIP*', 'SOIC*', 'SO*', 'TSSOP*'],do_erc=True,pins=[
            Pin(num='1',name='OSCI',do_erc=True),
            Pin(num='2',name='OSCO',func=Pin.OUTPUT,do_erc=True),
            Pin(num='3',name='~INT~',func=Pin.OUTPUT,do_erc=True),
            Pin(num='4',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='5',name='SDA',func=Pin.BIDIR,do_erc=True),
            Pin(num='6',name='SCL',do_erc=True),
            Pin(num='7',name='CLKO',func=Pin.OUTPUT,do_erc=True),
            Pin(num='8',name='VDD',func=Pin.PWRIN,do_erc=True)]),
        Part(name='PCF8574',dest=TEMPLATE,tool=SKIDL,keywords='I2C Expander',description='8 Bit Port/Expander to I2C Bus, DIP/SOIC-16',ref_prefix='U',num_units=1,fplist=['DIP*', 'PDIP*', 'SO*', 'SOIC*'],do_erc=True,aliases=['PCF8574A'],pins=[
            Pin(num='1',name='A0',do_erc=True),
            Pin(num='2',name='A1',do_erc=True),
            Pin(num='3',name='A2',do_erc=True),
            Pin(num='4',name='P0',func=Pin.BIDIR,do_erc=True),
            Pin(num='5',name='P1',func=Pin.BIDIR,do_erc=True),
            Pin(num='6',name='P2',func=Pin.BIDIR,do_erc=True),
            Pin(num='7',name='P3',func=Pin.BIDIR,do_erc=True),
            Pin(num='8',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='9',name='P4',func=Pin.BIDIR,do_erc=True),
            Pin(num='10',name='P5',func=Pin.BIDIR,do_erc=True),
            Pin(num='11',name='P6',func=Pin.BIDIR,do_erc=True),
            Pin(num='12',name='P7',func=Pin.BIDIR,do_erc=True),
            Pin(num='13',name='~INT~',func=Pin.OPENCOLL,do_erc=True),
            Pin(num='14',name='SCL',do_erc=True),
            Pin(num='15',name='SDA',func=Pin.BIDIR,do_erc=True),
            Pin(num='16',name='VDD',func=Pin.PWRIN,do_erc=True)]),
        Part(name='PCF8584',dest=TEMPLATE,tool=SKIDL,keywords='I2C Bus',description='I2C Bus Controller, DIP/SOIC-20',ref_prefix='U',num_units=1,fplist=['DIP*', 'PDIP*', 'SO*', 'SOIC*'],do_erc=True,pins=[
            Pin(num='1',name='CLK',do_erc=True),
            Pin(num='2',name='SDA',func=Pin.BIDIR,do_erc=True),
            Pin(num='3',name='SCL',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='~IACK~',do_erc=True),
            Pin(num='5',name='~INT~',func=Pin.OUTPUT,do_erc=True),
            Pin(num='6',name='A0',do_erc=True),
            Pin(num='7',name='D0',func=Pin.TRISTATE,do_erc=True),
            Pin(num='8',name='D1',func=Pin.TRISTATE,do_erc=True),
            Pin(num='9',name='D2',func=Pin.TRISTATE,do_erc=True),
            Pin(num='10',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='20',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='11',name='D3',func=Pin.TRISTATE,do_erc=True),
            Pin(num='12',name='D4',func=Pin.TRISTATE,do_erc=True),
            Pin(num='13',name='D5',func=Pin.TRISTATE,do_erc=True),
            Pin(num='14',name='D6',func=Pin.TRISTATE,do_erc=True),
            Pin(num='15',name='D7',func=Pin.TRISTATE,do_erc=True),
            Pin(num='16',name='~RD~',func=Pin.PASSIVE,do_erc=True),
            Pin(num='17',name='~CS~',do_erc=True),
            Pin(num='18',name='~WR~',do_erc=True),
            Pin(num='19',name='~RST~',func=Pin.BIDIR,do_erc=True)]),
        Part(name='PCF8591',dest=TEMPLATE,tool=SKIDL,keywords='I2C ADC DAC',description='4ch ADC, 1 DAC, I2C Bus Interface, DIP/SOIC-16',ref_prefix='U',num_units=1,fplist=['DIP*', 'PDIP*', 'SO*', 'SOIC*'],do_erc=True,pins=[
            Pin(num='1',name='AIN0',func=Pin.PASSIVE,do_erc=True),
            Pin(num='2',name='AIN1',func=Pin.PASSIVE,do_erc=True),
            Pin(num='3',name='AIN2',func=Pin.PASSIVE,do_erc=True),
            Pin(num='4',name='AIN3',func=Pin.PASSIVE,do_erc=True),
            Pin(num='5',name='A0',do_erc=True),
            Pin(num='6',name='A1',do_erc=True),
            Pin(num='7',name='A2',do_erc=True),
            Pin(num='8',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='9',name='SDA',func=Pin.BIDIR,do_erc=True),
            Pin(num='10',name='SCL',do_erc=True),
            Pin(num='11',name='OSC',func=Pin.BIDIR,do_erc=True),
            Pin(num='12',name='EXT',do_erc=True),
            Pin(num='13',name='AGND',func=Pin.PASSIVE,do_erc=True),
            Pin(num='14',name='VREF',func=Pin.PASSIVE,do_erc=True),
            Pin(num='15',name='AOUT',func=Pin.PASSIVE,do_erc=True),
            Pin(num='16',name='VDD',func=Pin.PWRIN,do_erc=True)]),
        Part(name='SAA7182',dest=TEMPLATE,tool=SKIDL,keywords='Video Encoder',description='Digital Video Encoder, Obsolete',ref_prefix='U',num_units=1,do_erc=True,pins=[
            Pin(num='1',name='~RESN~',do_erc=True),
            Pin(num='3',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='4',name='SA',do_erc=True),
            Pin(num='5',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='6',name='OVL2',do_erc=True),
            Pin(num='7',name='OVL1',do_erc=True),
            Pin(num='8',name='OVL0',do_erc=True),
            Pin(num='9',name='KEY',do_erc=True),
            Pin(num='10',name='DP0',do_erc=True),
            Pin(num='20',name='TTXRQ',func=Pin.OUTPUT,do_erc=True),
            Pin(num='30',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='50',name='CDIR',do_erc=True),
            Pin(num='60',name='VDDA',func=Pin.PWRIN,do_erc=True),
            Pin(num='70',name='VDDA',func=Pin.PWRIN,do_erc=True),
            Pin(num='80',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='11',name='DP1',do_erc=True),
            Pin(num='21',name='TTX',do_erc=True),
            Pin(num='31',name='MP3',do_erc=True),
            Pin(num='41',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='51',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='61',name='R',func=Pin.OUTPUT,do_erc=True),
            Pin(num='71',name='Y',func=Pin.OUTPUT,do_erc=True),
            Pin(num='81',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='12',name='DP2',do_erc=True),
            Pin(num='22',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='32',name='MP2',do_erc=True),
            Pin(num='42',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='52',name='VREFL',func=Pin.PASSIVE,do_erc=True),
            Pin(num='72',name='VDDA',func=Pin.PWRIN,do_erc=True),
            Pin(num='82',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='13',name='DP3',do_erc=True),
            Pin(num='33',name='MP1',do_erc=True),
            Pin(num='53',name='VREFH',func=Pin.PASSIVE,do_erc=True),
            Pin(num='63',name='CUR',do_erc=True),
            Pin(num='73',name='CVBS',func=Pin.OUTPUT,do_erc=True),
            Pin(num='83',name='SCL',do_erc=True),
            Pin(num='14',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='24',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='34',name='MP0',do_erc=True),
            Pin(num='44',name='XTALI',do_erc=True),
            Pin(num='54',name='VDDA',func=Pin.PWRIN,do_erc=True),
            Pin(num='64',name='VDDA',func=Pin.PWRIN,do_erc=True),
            Pin(num='74',name='VDDA',func=Pin.PWRIN,do_erc=True),
            Pin(num='84',name='SDA',func=Pin.BIDIR,do_erc=True),
            Pin(num='15',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='25',name='MP7',do_erc=True),
            Pin(num='35',name='RCV1',func=Pin.BIDIR,do_erc=True),
            Pin(num='45',name='XTAL',func=Pin.OUTPUT,do_erc=True),
            Pin(num='55',name='B',func=Pin.OUTPUT,do_erc=True),
            Pin(num='75',name='VREFH',func=Pin.PASSIVE,do_erc=True),
            Pin(num='16',name='DP4',do_erc=True),
            Pin(num='26',name='MP6',do_erc=True),
            Pin(num='36',name='RCV2',func=Pin.BIDIR,do_erc=True),
            Pin(num='76',name='VREFL',func=Pin.PASSIVE,do_erc=True),
            Pin(num='17',name='DP5',do_erc=True),
            Pin(num='27',name='MP5',do_erc=True),
            Pin(num='47',name='CREF',func=Pin.BIDIR,do_erc=True),
            Pin(num='57',name='VDDA',func=Pin.PWRIN,do_erc=True),
            Pin(num='67',name='VSSA',func=Pin.PWRIN,do_erc=True),
            Pin(num='77',name='AP',do_erc=True),
            Pin(num='18',name='DP6',do_erc=True),
            Pin(num='28',name='MP4',do_erc=True),
            Pin(num='38',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='48',name='LCC',func=Pin.BIDIR,do_erc=True),
            Pin(num='58',name='G',func=Pin.OUTPUT,do_erc=True),
            Pin(num='68',name='CUR',do_erc=True),
            Pin(num='78',name='SP',do_erc=True),
            Pin(num='19',name='DP7',do_erc=True),
            Pin(num='29',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='39',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='49',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='69',name='C',func=Pin.OUTPUT,do_erc=True),
            Pin(num='79',name='VSS',func=Pin.PWRIN,do_erc=True)]),
        Part(name='TDA8501',dest=TEMPLATE,tool=SKIDL,keywords='Video Encoder',description='PAL/NTSC Encoder, RGB or Y/Y-R/Y-B Inputs, DIP/SOIC-20',ref_prefix='U',num_units=1,fplist=['DIP*', 'PDIP*', 'SOIC*'],do_erc=True,pins=[
            Pin(num='1',name='-R.Y',do_erc=True),
            Pin(num='2',name='MCTR',do_erc=True),
            Pin(num='3',name='-B.Y',do_erc=True),
            Pin(num='4',name='H/2',func=Pin.BIDIR,do_erc=True),
            Pin(num='5',name='Y',do_erc=True),
            Pin(num='6',name='UOFF',func=Pin.OUTPUT,do_erc=True),
            Pin(num='7',name='R',do_erc=True),
            Pin(num='8',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='9',name='G',do_erc=True),
            Pin(num='10',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='20',name='Y+SIN',do_erc=True),
            Pin(num='11',name='B',do_erc=True),
            Pin(num='21',name='B/ADJ',func=Pin.PASSIVE,do_erc=True),
            Pin(num='12',name='VOFF',func=Pin.OUTPUT,do_erc=True),
            Pin(num='22',name='Y+SOUT',func=Pin.OUTPUT,do_erc=True),
            Pin(num='13',name='VREF',func=Pin.PASSIVE,do_erc=True),
            Pin(num='23',name='OSC',func=Pin.OUTPUT,do_erc=True),
            Pin(num='14',name='C/OUT',func=Pin.OUTPUT,do_erc=True),
            Pin(num='24',name='CS',do_erc=True),
            Pin(num='15',name='FLT',func=Pin.PASSIVE,do_erc=True),
            Pin(num='16',name='CVBS',func=Pin.OUTPUT,do_erc=True),
            Pin(num='17',name='NTSC/PAL',do_erc=True),
            Pin(num='18',name='NOTCH',do_erc=True),
            Pin(num='19',name='Y/OUT',func=Pin.OUTPUT,do_erc=True)]),
        Part(name='TDA8772',dest=TEMPLATE,tool=SKIDL,keywords='Video DAC Colour 8bit',description='Triple 8bit Video DAC, QFP-44',ref_prefix='U',num_units=1,fplist=['QFP*'],do_erc=True,pins=[
            Pin(num='1',name='R7',do_erc=True),
            Pin(num='2',name='R6',do_erc=True),
            Pin(num='3',name='R5',do_erc=True),
            Pin(num='4',name='R4',do_erc=True),
            Pin(num='5',name='R3',do_erc=True),
            Pin(num='6',name='R2',do_erc=True),
            Pin(num='7',name='R1',do_erc=True),
            Pin(num='8',name='R0',do_erc=True),
            Pin(num='9',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='10',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='20',name='G0',do_erc=True),
            Pin(num='30',name='B1',do_erc=True),
            Pin(num='40',name='GRE',func=Pin.OUTPUT,do_erc=True),
            Pin(num='11',name='SYNC',do_erc=True),
            Pin(num='21',name='CLKR',do_erc=True),
            Pin(num='31',name='B0',do_erc=True),
            Pin(num='41',name='IRFB',func=Pin.PASSIVE,do_erc=True),
            Pin(num='12',name='BLANK',do_erc=True),
            Pin(num='22',name='CLKG',do_erc=True),
            Pin(num='32',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='42',name='GNDA',func=Pin.PWRIN,do_erc=True),
            Pin(num='13',name='G7',do_erc=True),
            Pin(num='23',name='CLKB',do_erc=True),
            Pin(num='33',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='43',name='VCCA',func=Pin.PWRIN,do_erc=True),
            Pin(num='14',name='G6',do_erc=True),
            Pin(num='24',name='B7',do_erc=True),
            Pin(num='34',name='VRD',do_erc=True),
            Pin(num='44',name='RED',func=Pin.OUTPUT,do_erc=True),
            Pin(num='15',name='G5',do_erc=True),
            Pin(num='25',name='B6',do_erc=True),
            Pin(num='35',name='VCCA',func=Pin.PWRIN,do_erc=True),
            Pin(num='16',name='G4',do_erc=True),
            Pin(num='26',name='B5',do_erc=True),
            Pin(num='36',name='BLU',func=Pin.OUTPUT,do_erc=True),
            Pin(num='17',name='G3',do_erc=True),
            Pin(num='27',name='B4',do_erc=True),
            Pin(num='37',name='GNDA',func=Pin.PWRIN,do_erc=True),
            Pin(num='18',name='G2',do_erc=True),
            Pin(num='28',name='B3',do_erc=True),
            Pin(num='38',name='IRFA',func=Pin.PASSIVE,do_erc=True),
            Pin(num='19',name='G1',do_erc=True),
            Pin(num='29',name='B2',do_erc=True),
            Pin(num='39',name='VCCA',func=Pin.PWRIN,do_erc=True)])])
