from skidl import SKIDL, TEMPLATE, Part, Pin, SchLib

SKIDL_lib_version = '0.0.1'

opto = SchLib(tool=SKIDL).add_parts(*[
        Part(name='4N25',dest=TEMPLATE,tool=SKIDL,keywords='NPN DC Optocoupler Base Connected',description='DC Optocoupler, Phototransistor NPN, DIP6',ref_prefix='U',num_units=1,fplist=['DIP*W7.62mm*'],do_erc=True,aliases=['4N26', 'TIL111'],pins=[
            Pin(num='1',name='~',func=Pin.PASSIVE,do_erc=True),
            Pin(num='2',name='~',func=Pin.PASSIVE,do_erc=True),
            Pin(num='3',name='NC',func=Pin.NOCONNECT,do_erc=True),
            Pin(num='4',name='~',func=Pin.PASSIVE,do_erc=True),
            Pin(num='5',name='~',func=Pin.PASSIVE,do_erc=True),
            Pin(num='6',name='~',func=Pin.PASSIVE,do_erc=True)]),
        Part(name='6N135',dest=TEMPLATE,tool=SKIDL,keywords='High Speed Optocoupler',description='High Speed Optocoupler, TTL Compatible, CTR 24%, DIP8',ref_prefix='U',num_units=1,fplist=['DIP*W7.62mm*'],do_erc=True,aliases=['6N136'],pins=[
            Pin(num='1',name='NC',func=Pin.NOCONNECT,do_erc=True),
            Pin(num='2',name='~',func=Pin.PASSIVE,do_erc=True),
            Pin(num='3',name='~',func=Pin.PASSIVE,do_erc=True),
            Pin(num='4',name='NC',func=Pin.NOCONNECT,do_erc=True),
            Pin(num='5',name='~',func=Pin.PASSIVE,do_erc=True),
            Pin(num='6',name='~',func=Pin.PASSIVE,do_erc=True),
            Pin(num='7',name='~',func=Pin.PASSIVE,do_erc=True),
            Pin(num='8',name='~',func=Pin.PASSIVE,do_erc=True)]),
        Part(name='A1050',dest=TEMPLATE,tool=SKIDL,keywords='light dependent photo resistor LDR',description='light dependent resistor',ref_prefix='R',num_units=1,fplist=['Resistor*LDR*D6.4*RM3.4*'],do_erc=True,aliases=['A1060'],pins=[
            Pin(num='1',name='~',func=Pin.PASSIVE,do_erc=True),
            Pin(num='2',name='~',func=Pin.PASSIVE,do_erc=True)]),
        Part(name='A9050',dest=TEMPLATE,tool=SKIDL,keywords='light dependent photo resistor LDR',description='light dependent resistor',ref_prefix='R',num_units=1,fplist=['Resistor*LDR*5x4.1*RM3*'],do_erc=True,aliases=['A9060', 'A9013'],pins=[
            Pin(num='1',name='~',func=Pin.PASSIVE,do_erc=True),
            Pin(num='2',name='~',func=Pin.PASSIVE,do_erc=True)]),
        Part(name='ACPL-C790',dest=TEMPLATE,tool=SKIDL,keywords='Isolation Amplifer',description='Precision Isolation Amplifer, ±0.5% Gain Tolerance, Bandwidth 200kHz, Stretched SO-8',ref_prefix='U',num_units=1,fplist=['SOIC*8_5.850x6.807mm*Pitch1.27mm*'],do_erc=True,aliases=['ACPL-C79A', 'ACPL-C79B'],pins=[
            Pin(num='1',name='VDD1',func=Pin.PWRIN,do_erc=True),
            Pin(num='2',name='IN+',do_erc=True),
            Pin(num='3',name='IN-',do_erc=True),
            Pin(num='4',name='GND1',func=Pin.PWRIN,do_erc=True),
            Pin(num='5',name='GND2',func=Pin.PWRIN,do_erc=True),
            Pin(num='6',name='OUT-',func=Pin.OUTPUT,do_erc=True),
            Pin(num='7',name='OUT+',func=Pin.OUTPUT,do_erc=True),
            Pin(num='8',name='VDD2',func=Pin.PWRIN,do_erc=True)]),
        Part(name='ACPL-C870',dest=TEMPLATE,tool=SKIDL,keywords='Optycally Isolated Voltage Sensor',description='Precision Optycally Isolated Voltage Sensor, ±0.5% Gain Tolerance, Bandwidth 100kHz, Stretched SO-8',ref_prefix='U',num_units=1,fplist=['SOIC*8_5.850x6.807mm*Pitch1.27mm*'],do_erc=True,aliases=['ACPL-C87A', 'ACPL-C87B'],pins=[
            Pin(num='1',name='VDD1',func=Pin.PWRIN,do_erc=True),
            Pin(num='2',name='IN',do_erc=True),
            Pin(num='3',name='IN-',do_erc=True),
            Pin(num='4',name='GND1',func=Pin.PWRIN,do_erc=True),
            Pin(num='5',name='GND2',func=Pin.PWRIN,do_erc=True),
            Pin(num='6',name='OUT-',func=Pin.OUTPUT,do_erc=True),
            Pin(num='7',name='OUT+',func=Pin.OUTPUT,do_erc=True),
            Pin(num='8',name='VDD2',func=Pin.PWRIN,do_erc=True)]),
        Part(name='ACPL-P343',dest=TEMPLATE,tool=SKIDL,keywords='MOSFET Driver IGBT Driver Optocoupler',description='Gate Drive Optocoupler, Output Current 4.0/4.0A, Propagation Delay 200ns, Stretched SO-6',ref_prefix='U',num_units=1,fplist=['SOIC-6_4.58x6.81mm_Pitch1.27mm'],do_erc=True,pins=[
            Pin(num='1',name='A',func=Pin.PASSIVE,do_erc=True),
            Pin(num='2',name='NC',func=Pin.NOCONNECT,do_erc=True),
            Pin(num='3',name='C',func=Pin.PASSIVE,do_erc=True),
            Pin(num='4',name='VEE',func=Pin.PWROUT,do_erc=True),
            Pin(num='5',name='VO',func=Pin.PASSIVE,do_erc=True),
            Pin(num='6',name='VCC',func=Pin.PWRIN,do_erc=True)]),
        Part(name='ASMT-YTC2-0AA02',dest=TEMPLATE,tool=SKIDL,description='Triple LED RVB (Avago Technology)',ref_prefix='U',num_units=1,fplist=['LED*RGB*PLCC*'],do_erc=True,pins=[
            Pin(num='1',name='KB',func=Pin.PASSIVE,do_erc=True),
            Pin(num='2',name='KG',func=Pin.PASSIVE,do_erc=True),
            Pin(num='3',name='KR',func=Pin.PASSIVE,do_erc=True),
            Pin(num='4',name='AR',func=Pin.PASSIVE,do_erc=True),
            Pin(num='5',name='AG',func=Pin.PASSIVE,do_erc=True),
            Pin(num='6',name='AB',func=Pin.PASSIVE,do_erc=True)]),
        Part(name='BP103',dest=TEMPLATE,tool=SKIDL,keywords='NPN Phototransistor opto',description='NPN Phototransistor',ref_prefix='Q',num_units=1,fplist=['TO?18*Lens*'],do_erc=True,aliases=['BPY62'],pins=[
            Pin(num='1',name='E',func=Pin.PASSIVE,do_erc=True),
            Pin(num='2',name='B',do_erc=True),
            Pin(num='3',name='C',func=Pin.PASSIVE,do_erc=True)]),
        Part(name='BP104-SMD',dest=TEMPLATE,tool=SKIDL,keywords='opto photodiode',description='Silicon Photodiode with V? Characteristic, SMD package',ref_prefix='D',num_units=1,fplist=['PhotoDiode*SMD*DIL2*4.5x4*'],do_erc=True,aliases=['BPW34-SMD', 'SFH2430', 'SFH2440'],pins=[
            Pin(num='1',name='K',func=Pin.PASSIVE,do_erc=True),
            Pin(num='2',name='A',func=Pin.PASSIVE,do_erc=True)]),
        Part(name='BPW21',dest=TEMPLATE,tool=SKIDL,keywords='photodiode opto',description='Silicon Photodiode for the visible spectral range',ref_prefix='D',num_units=1,fplist=['TO?5*Window*'],do_erc=True,aliases=['BPX61'],pins=[
            Pin(num='1',name='K',func=Pin.PASSIVE,do_erc=True),
            Pin(num='2',name='A',func=Pin.PASSIVE,do_erc=True)]),
        Part(name='BPW34',dest=TEMPLATE,tool=SKIDL,keywords='opto PIN photodiode',description='Silicon PIN Photodiode',ref_prefix='D',num_units=1,fplist=['PhotoDiode*SMD*DIL2*4.3x4.65*RM5.08*'],do_erc=True,aliases=['BP104'],pins=[
            Pin(num='1',name='K',func=Pin.PASSIVE,do_erc=True),
            Pin(num='2',name='A',func=Pin.PASSIVE,do_erc=True)]),
        Part(name='BPW40',dest=TEMPLATE,tool=SKIDL,keywords='NPN phototransistor',description='silicon NPN phototransistor',ref_prefix='Q',num_units=1,fplist=['LED*5mm*'],do_erc=True,aliases=['BP103B', 'BP103BF', 'SFH300'],pins=[
            Pin(num='1',name='C',func=Pin.PASSIVE,do_erc=True),
            Pin(num='2',name='E',func=Pin.PASSIVE,do_erc=True)]),
        Part(name='BPW82',dest=TEMPLATE,tool=SKIDL,keywords='opto photo diode',description='Silicon PIN Photodiode with Daylight Blocking Filter',ref_prefix='D',num_units=1,fplist=['PhotoDiode*BPW82*'],do_erc=True,pins=[
            Pin(num='1',name='K',func=Pin.PASSIVE,do_erc=True),
            Pin(num='2',name='A',func=Pin.PASSIVE,do_erc=True)]),
        Part(name='BPX65',dest=TEMPLATE,tool=SKIDL,keywords='opto PIN photo diode',description='Silicon PIN Photodiode, TO-18 package',ref_prefix='D',num_units=1,fplist=['TO?18*Lens*'],do_erc=True,pins=[
            Pin(num='1',name='K',func=Pin.PASSIVE,do_erc=True),
            Pin(num='2',name='A',func=Pin.PASSIVE,do_erc=True)]),
        Part(name='CNY17-1',dest=TEMPLATE,tool=SKIDL,keywords='NPN DC Optocoupler Base Connected',description='DC Optocoupler Base Connected, Vce 70V, CTR 160-320%, Viso 5000V (RMS), DIP6',ref_prefix='U',num_units=1,fplist=['DIP*W7.62mm*', 'DIP*W10.16mm*', 'DIP*W9.53mm*SMD*'],do_erc=True,aliases=['CNY17-2', 'CNY17-3', 'CNY17-4'],pins=[
            Pin(num='1',name='~',func=Pin.PASSIVE,do_erc=True),
            Pin(num='2',name='~',func=Pin.PASSIVE,do_erc=True),
            Pin(num='3',name='NC',func=Pin.NOCONNECT,do_erc=True),
            Pin(num='4',name='~',func=Pin.PASSIVE,do_erc=True),
            Pin(num='5',name='~',func=Pin.PASSIVE,do_erc=True),
            Pin(num='6',name='~',func=Pin.PASSIVE,do_erc=True)]),
        Part(name='FOD420',dest=TEMPLATE,tool=SKIDL,keywords='Opto-Triac Opto Triac Random Phase',description='Random Phase Opto-Triac, Vdrm 800V, Ift 0.75mA, Itm 300mA, DIP6',ref_prefix='U',num_units=1,fplist=['DIP*W7.62mm*'],do_erc=True,aliases=['FOD4208', 'FOD4216', 'FOD4218'],pins=[
            Pin(num='1',name='~',func=Pin.PASSIVE,do_erc=True),
            Pin(num='2',name='~',func=Pin.PASSIVE,do_erc=True),
            Pin(num='3',name='NC',func=Pin.NOCONNECT,do_erc=True),
            Pin(num='4',name='~',func=Pin.PASSIVE,do_erc=True),
            Pin(num='5',name='NC',func=Pin.NOCONNECT,do_erc=True),
            Pin(num='6',name='~',func=Pin.PASSIVE,do_erc=True)]),
        Part(name='FODM3011',dest=TEMPLATE,tool=SKIDL,keywords='Opto-Triac Opto Triac Random Phase Mini-Flat',description='Full Pitch Mini-Flat Random Phase Opto-Triac, Vdrm 600V, Ift 5mA, MFP 4L',ref_prefix='U',num_units=1,fplist=['DIP*W7.62mm*SMD*'],do_erc=True,aliases=['FODM3012', 'FODM3022', 'FODM3023', 'FODM3052', 'FODM3053'],pins=[
            Pin(num='1',name='~',func=Pin.PASSIVE,do_erc=True),
            Pin(num='2',name='~',func=Pin.PASSIVE,do_erc=True),
            Pin(num='3',name='~',func=Pin.PASSIVE,do_erc=True),
            Pin(num='4',name='~',func=Pin.PASSIVE,do_erc=True)]),
        Part(name='H11L1',dest=TEMPLATE,tool=SKIDL,keywords='High Speed Schmitt Optocoupler',description='Schmitt Trigger Output Optocoupler, High Speed, DIP-6, 5mA turn on threshold',ref_prefix='U',num_units=1,fplist=['DIP*W7.62mm*', 'DIP*W10.16mm*', 'DIP*W9.53mm*SMD*'],do_erc=True,aliases=['H11L2', 'H11L3'],pins=[
            Pin(num='1',name='~',func=Pin.PASSIVE,do_erc=True),
            Pin(num='2',name='~',func=Pin.PASSIVE,do_erc=True),
            Pin(num='3',name='~',func=Pin.NOCONNECT,do_erc=True),
            Pin(num='4',name='~',func=Pin.OUTPUT,do_erc=True),
            Pin(num='5',name='~',func=Pin.PWRIN,do_erc=True),
            Pin(num='6',name='~',func=Pin.PWRIN,do_erc=True)]),
        Part(name='HCPL063',dest=TEMPLATE,tool=SKIDL,keywords='High Speed Optocoupler',description='Dual High Speed HCMOS/LSTTL/TTL Compatible Optocoupler, DIP-8, SOIC-8',ref_prefix='U',num_units=1,fplist=['DIP*W7.62mm*', 'DIP*W7.62mm*SMD*'],do_erc=True,pins=[
            Pin(num='1',name='A1',func=Pin.PASSIVE,do_erc=True),
            Pin(num='2',name='C1',func=Pin.PASSIVE,do_erc=True),
            Pin(num='3',name='A2',func=Pin.PASSIVE,do_erc=True),
            Pin(num='4',name='C2',func=Pin.PASSIVE,do_erc=True),
            Pin(num='5',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='6',name='VO2',func=Pin.OPENCOLL,do_erc=True),
            Pin(num='7',name='VO1',func=Pin.OPENCOLL,do_erc=True),
            Pin(num='8',name='VCC',func=Pin.PWRIN,do_erc=True)]),
        Part(name='HCPL2731',dest=TEMPLATE,tool=SKIDL,keywords='darlington optocoupler',description='Low Input Current high Gain Split Darlington Optocouplers',ref_prefix='U',num_units=2,fplist=['DIP*W7.62mm*', 'DIP*W9.53mm*SMD*'],do_erc=True,aliases=['HCPL2730'],pins=[
            Pin(num='8',name='VCC',func=Pin.PASSIVE,do_erc=True),
            Pin(num='1',name='ANODE',func=Pin.PASSIVE,do_erc=True),
            Pin(num='2',name='CATHODE',func=Pin.PASSIVE,do_erc=True),
            Pin(num='5',name='EMITTER',func=Pin.PASSIVE,do_erc=True),
            Pin(num='7',name='COLLECTOR',func=Pin.PASSIVE,do_erc=True),
            Pin(num='3',name='CATHODE',func=Pin.PASSIVE,do_erc=True),
            Pin(num='4',name='ANODE',func=Pin.PASSIVE,do_erc=True),
            Pin(num='5',name='EMITTER',func=Pin.PASSIVE,do_erc=True),
            Pin(num='6',name='COLLECTOR',func=Pin.PASSIVE,do_erc=True)]),
        Part(name='HCPL3120',dest=TEMPLATE,tool=SKIDL,keywords='MOSFET Driver IGBT Driver Optocoupler',description='Gate Drive Optocoupler, Output Current 2.5/2.5A, PDIP-8',ref_prefix='U',num_units=1,fplist=['DIP*W7.62mm*'],do_erc=True,pins=[
            Pin(num='1',name='NC',func=Pin.NOCONNECT,do_erc=True),
            Pin(num='2',name='A',func=Pin.PASSIVE,do_erc=True),
            Pin(num='3',name='C',func=Pin.PASSIVE,do_erc=True),
            Pin(num='4',name='NC',func=Pin.NOCONNECT,do_erc=True),
            Pin(num='5',name='VEE',func=Pin.PWROUT,do_erc=True),
            Pin(num='6',name='VO',func=Pin.PASSIVE,do_erc=True),
            Pin(num='7',name='VO',func=Pin.PASSIVE,do_erc=True),
            Pin(num='8',name='VCC',func=Pin.PWRIN,do_erc=True)]),
        Part(name='IL300',dest=TEMPLATE,tool=SKIDL,keywords='Isolated Linear Photocoupler',description='Isolated Linear Photocoupler, High Gain, Wideband, DIP8/SMD8',ref_prefix='U',num_units=1,fplist=['DIP*W7.62mm*', 'DIP*W10.16mm*', 'DIP*W7.62mm*SMD*', 'DIP*W9.53mm*SMD*', 'DIP*W11.48mm*SMD*'],do_erc=True,pins=[
            Pin(num='1',name='~',func=Pin.PASSIVE,do_erc=True),
            Pin(num='2',name='~',func=Pin.PASSIVE,do_erc=True),
            Pin(num='3',name='~',func=Pin.PASSIVE,do_erc=True),
            Pin(num='4',name='~',func=Pin.PASSIVE,do_erc=True),
            Pin(num='5',name='~',func=Pin.PASSIVE,do_erc=True),
            Pin(num='6',name='~',func=Pin.PASSIVE,do_erc=True)]),
        Part(name='IRL81A',dest=TEMPLATE,tool=SKIDL,keywords='IR LED',description='850nm High Power Infrared Emitter, Side-Emitter package',ref_prefix='D',num_units=1,fplist=['LED*SideEmitter*Rectangular*W4.5mm*H1.6mm*'],do_erc=True,pins=[
            Pin(num='1',name='K',func=Pin.PASSIVE,do_erc=True),
            Pin(num='2',name='A',func=Pin.PASSIVE,do_erc=True)]),
        Part(name='IS471F',dest=TEMPLATE,tool=SKIDL,keywords='opto IR receiver',description='Photo Modules for PCM Remote Control Systems',ref_prefix='U',num_units=1,fplist=['OPIC*Sharp*IS471F*'],do_erc=True,pins=[
            Pin(num='1',name='Vs',func=Pin.PWRIN,do_erc=True),
            Pin(num='2',name='OUT',func=Pin.OUTPUT,do_erc=True),
            Pin(num='3',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='4',name='GLo',func=Pin.OPENCOLL,do_erc=True)]),
        Part(name='IS485',dest=TEMPLATE,tool=SKIDL,keywords='opto receiver amplifier light detector OPIC',description='Bult-in Amplifier Type OPIC Light Detector',ref_prefix='U',num_units=1,fplist=['OPIC*Sharp*IS485*'],do_erc=True,pins=[
            Pin(num='1',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='2',name='OUT',func=Pin.OUTPUT,do_erc=True),
            Pin(num='3',name='Vs',func=Pin.PWRIN,do_erc=True)]),
        Part(name='IS486',dest=TEMPLATE,tool=SKIDL,keywords='opto receiver amplifier light detector OPIC',description='Bult-in Amplifier Type OPIC Light Detector',ref_prefix='U',num_units=1,fplist=['OPIC*Sharp*IS485*'],do_erc=True,pins=[
            Pin(num='1',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='2',name='OUT',func=Pin.OUTPUT,do_erc=True),
            Pin(num='3',name='Vs',func=Pin.PWRIN,do_erc=True)]),
        Part(name='KPS-5130',dest=TEMPLATE,tool=SKIDL,keywords='opto photodiode RGB color sensor',description='RGB Color Sensor',ref_prefix='PD',num_units=1,fplist=['KPS*5130*'],do_erc=True,pins=[
            Pin(num='1',name='AR',func=Pin.PASSIVE,do_erc=True),
            Pin(num='2',name='AG',func=Pin.PASSIVE,do_erc=True),
            Pin(num='3',name='AB',func=Pin.PASSIVE,do_erc=True),
            Pin(num='4',name='C',func=Pin.PASSIVE,do_erc=True)]),
        Part(name='LD271',dest=TEMPLATE,tool=SKIDL,keywords='IR LED',description='950nm High-Power IR-LED, 5mm',ref_prefix='D',num_units=1,fplist=['LED*5mm*'],do_erc=True,aliases=['SFH4546', 'CQY99', 'LD274', 'SFH4550'],pins=[
            Pin(num='1',name='K',func=Pin.PASSIVE,do_erc=True),
            Pin(num='2',name='A',func=Pin.PASSIVE,do_erc=True)]),
        Part(name='LDR03',dest=TEMPLATE,tool=SKIDL,keywords='light dependent photo resistor LDR',description='light dependent resistor',ref_prefix='R',num_units=1,fplist=['Resistor*LDR*10x8.5*RM7.6*'],do_erc=True,pins=[
            Pin(num='1',name='~',func=Pin.PASSIVE,do_erc=True),
            Pin(num='2',name='~',func=Pin.PASSIVE,do_erc=True)]),
        Part(name='LDR07',dest=TEMPLATE,tool=SKIDL,keywords='light dependent photo resistor LDR',description='light dependent resistor',ref_prefix='R',num_units=1,fplist=['Resistor*LDR*5.1x4.3*RM3.4*'],do_erc=True,pins=[
            Pin(num='1',name='~',func=Pin.PASSIVE,do_erc=True),
            Pin(num='2',name='~',func=Pin.PASSIVE,do_erc=True)]),
        Part(name='LPT80A',dest=TEMPLATE,tool=SKIDL,keywords='NPN phototransistor',description='NPN phototransistor, sielooker package',ref_prefix='Q',num_units=1,fplist=['PhotoTransistor*SideLooker*'],do_erc=True,pins=[
            Pin(num='1',name='C',func=Pin.PASSIVE,do_erc=True),
            Pin(num='2',name='E',func=Pin.PASSIVE,do_erc=True)]),
        Part(name='LTV-352T',dest=TEMPLATE,tool=SKIDL,keywords='NPN Darlington DC Optocoupler',description='DC Darlington Optocoupler, Vce 300V, CTR 1000%, MFSOP6',ref_prefix='U',num_units=1,fplist=['DIP*W7.62mm*SMD*'],do_erc=True,pins=[
            Pin(num='1',name='~',func=Pin.PASSIVE,do_erc=True),
            Pin(num='2',name='NC',func=Pin.NOCONNECT,do_erc=True),
            Pin(num='3',name='~',func=Pin.PASSIVE,do_erc=True),
            Pin(num='4',name='~',func=Pin.PASSIVE,do_erc=True),
            Pin(num='5',name='NC',func=Pin.NOCONNECT,do_erc=True),
            Pin(num='6',name='~',func=Pin.PASSIVE,do_erc=True)]),
        Part(name='LTV-354T',dest=TEMPLATE,tool=SKIDL,keywords='NPN AC DC Optocoupler',description='AC/DC Optocoupler, Vce 35V, CTR 20%, MFSOP6',ref_prefix='U',num_units=1,fplist=['DIP*W7.62mm*SMD*'],do_erc=True,pins=[
            Pin(num='1',name='~',func=Pin.PASSIVE,do_erc=True),
            Pin(num='2',name='NC',func=Pin.NOCONNECT,do_erc=True),
            Pin(num='3',name='~',func=Pin.PASSIVE,do_erc=True),
            Pin(num='4',name='~',func=Pin.PASSIVE,do_erc=True),
            Pin(num='5',name='NC',func=Pin.NOCONNECT,do_erc=True),
            Pin(num='6',name='~',func=Pin.PASSIVE,do_erc=True)]),
        Part(name='LTV-355T',dest=TEMPLATE,tool=SKIDL,keywords='NPN Darlington DC Optocoupler',description='DC Darlington Optocoupler, Vce 35V, CTR 600%, MFSOP6',ref_prefix='U',num_units=1,fplist=['DIP*W7.62mm*SMD*'],do_erc=True,pins=[
            Pin(num='1',name='~',func=Pin.PASSIVE,do_erc=True),
            Pin(num='2',name='NC',func=Pin.NOCONNECT,do_erc=True),
            Pin(num='3',name='~',func=Pin.PASSIVE,do_erc=True),
            Pin(num='4',name='~',func=Pin.PASSIVE,do_erc=True),
            Pin(num='5',name='NC',func=Pin.NOCONNECT,do_erc=True),
            Pin(num='6',name='~',func=Pin.PASSIVE,do_erc=True)]),
        Part(name='LTV-356T',dest=TEMPLATE,tool=SKIDL,keywords='NPN DC Optocoupler',description='DC Optocoupler, Vce 120V, CTR 50%, MFSOP6',ref_prefix='U',num_units=1,fplist=['DIP*W7.62mm*SMD*'],do_erc=True,aliases=['LTV-357T', 'LTV-358T'],pins=[
            Pin(num='1',name='~',func=Pin.PASSIVE,do_erc=True),
            Pin(num='2',name='NC',func=Pin.NOCONNECT,do_erc=True),
            Pin(num='3',name='~',func=Pin.PASSIVE,do_erc=True),
            Pin(num='4',name='~',func=Pin.PASSIVE,do_erc=True),
            Pin(num='5',name='NC',func=Pin.NOCONNECT,do_erc=True),
            Pin(num='6',name='~',func=Pin.PASSIVE,do_erc=True)]),
        Part(name='LTV-814',dest=TEMPLATE,tool=SKIDL,keywords='NPN AC DC Optocoupler',description='AC/DC Optocoupler, Vce 35V, CTR 20%, DIP4',ref_prefix='U',num_units=1,fplist=['DIP*W7.62mm*'],do_erc=True,pins=[
            Pin(num='1',name='~',func=Pin.PASSIVE,do_erc=True),
            Pin(num='2',name='~',func=Pin.PASSIVE,do_erc=True),
            Pin(num='3',name='~',func=Pin.PASSIVE,do_erc=True),
            Pin(num='4',name='~',func=Pin.PASSIVE,do_erc=True)]),
        Part(name='LTV-817',dest=TEMPLATE,tool=SKIDL,keywords='NPN DC Optocoupler',description='DC Optocoupler, Vce 35V, CTR 50%, DIP-4',ref_prefix='U',num_units=1,fplist=['DIP*W7.62mm*'],do_erc=True,pins=[
            Pin(num='1',name='~',func=Pin.PASSIVE,do_erc=True),
            Pin(num='2',name='~',func=Pin.PASSIVE,do_erc=True),
            Pin(num='3',name='~',func=Pin.PASSIVE,do_erc=True),
            Pin(num='4',name='~',func=Pin.PASSIVE,do_erc=True)]),
        Part(name='LTV-824',dest=TEMPLATE,tool=SKIDL,keywords='Dual NPN AC DC Optocoupler',description='Dual AC/DC Optocoupler, Vce 35V, CTR 20%, DIP8',ref_prefix='U',num_units=2,fplist=['DIP*W7.62mm*'],do_erc=True,pins=[
            Pin(num='1',name='~',func=Pin.PASSIVE,do_erc=True),
            Pin(num='2',name='~',func=Pin.PASSIVE,do_erc=True),
            Pin(num='7',name='~',func=Pin.PASSIVE,do_erc=True),
            Pin(num='8',name='~',func=Pin.PASSIVE,do_erc=True),
            Pin(num='3',name='~',func=Pin.PASSIVE,do_erc=True),
            Pin(num='4',name='~',func=Pin.PASSIVE,do_erc=True),
            Pin(num='5',name='~',func=Pin.PASSIVE,do_erc=True),
            Pin(num='6',name='~',func=Pin.PASSIVE,do_erc=True)]),
        Part(name='LTV-827',dest=TEMPLATE,tool=SKIDL,keywords='NPN DC Dual Optocoupler',description='Dual DC Optocoupler, Vce 35V, CTR 50%, DIP-8',ref_prefix='U',num_units=1,fplist=['DIP*W7.62mm*'],do_erc=True,pins=[
            Pin(num='1',name='~',func=Pin.PASSIVE,do_erc=True),
            Pin(num='2',name='~',func=Pin.PASSIVE,do_erc=True),
            Pin(num='3',name='~',func=Pin.PASSIVE,do_erc=True),
            Pin(num='4',name='~',func=Pin.PASSIVE,do_erc=True),
            Pin(num='5',name='~',func=Pin.PASSIVE,do_erc=True),
            Pin(num='6',name='~',func=Pin.PASSIVE,do_erc=True),
            Pin(num='7',name='~',func=Pin.PASSIVE,do_erc=True),
            Pin(num='8',name='~',func=Pin.PASSIVE,do_erc=True)]),
        Part(name='LTV-844',dest=TEMPLATE,tool=SKIDL,keywords='Quad NPN AC DC Optocoupler',description='Quad AC/DC Optocoupler, Vce 35V, CTR 20%, DIP16',ref_prefix='U',num_units=4,fplist=['DIP*W7.62mm*'],do_erc=True,pins=[
            Pin(num='1',name='~',func=Pin.PASSIVE,do_erc=True),
            Pin(num='2',name='~',func=Pin.PASSIVE,do_erc=True),
            Pin(num='15',name='~',func=Pin.PASSIVE,do_erc=True),
            Pin(num='16',name='~',func=Pin.PASSIVE,do_erc=True),
            Pin(num='3',name='~',func=Pin.PASSIVE,do_erc=True),
            Pin(num='4',name='~',func=Pin.PASSIVE,do_erc=True),
            Pin(num='13',name='~',func=Pin.PASSIVE,do_erc=True),
            Pin(num='14',name='~',func=Pin.PASSIVE,do_erc=True),
            Pin(num='5',name='~',func=Pin.PASSIVE,do_erc=True),
            Pin(num='6',name='~',func=Pin.PASSIVE,do_erc=True),
            Pin(num='11',name='~',func=Pin.PASSIVE,do_erc=True),
            Pin(num='12',name='~',func=Pin.PASSIVE,do_erc=True),
            Pin(num='7',name='~',func=Pin.PASSIVE,do_erc=True),
            Pin(num='8',name='~',func=Pin.PASSIVE,do_erc=True),
            Pin(num='9',name='~',func=Pin.PASSIVE,do_erc=True),
            Pin(num='10',name='~',func=Pin.PASSIVE,do_erc=True)]),
        Part(name='LTV-847',dest=TEMPLATE,tool=SKIDL,keywords='NPN DC Quad Optocoupler',description='Quad DC Optocoupler, Vce 35V, CTR 50%, DIP-16',ref_prefix='U',num_units=1,fplist=['DIP*W7.62mm*'],do_erc=True,pins=[
            Pin(num='1',name='~',func=Pin.PASSIVE,do_erc=True),
            Pin(num='2',name='~',func=Pin.PASSIVE,do_erc=True),
            Pin(num='3',name='~',func=Pin.PASSIVE,do_erc=True),
            Pin(num='4',name='~',func=Pin.PASSIVE,do_erc=True),
            Pin(num='5',name='~',func=Pin.PASSIVE,do_erc=True),
            Pin(num='6',name='~',func=Pin.PASSIVE,do_erc=True),
            Pin(num='7',name='~',func=Pin.PASSIVE,do_erc=True),
            Pin(num='8',name='~',func=Pin.PASSIVE,do_erc=True),
            Pin(num='9',name='~',func=Pin.PASSIVE,do_erc=True),
            Pin(num='10',name='~',func=Pin.PASSIVE,do_erc=True),
            Pin(num='11',name='~',func=Pin.PASSIVE,do_erc=True),
            Pin(num='12',name='~',func=Pin.PASSIVE,do_erc=True),
            Pin(num='13',name='~',func=Pin.PASSIVE,do_erc=True),
            Pin(num='14',name='~',func=Pin.PASSIVE,do_erc=True),
            Pin(num='15',name='~',func=Pin.PASSIVE,do_erc=True),
            Pin(num='16',name='~',func=Pin.PASSIVE,do_erc=True)]),
        Part(name='M9960',dest=TEMPLATE,tool=SKIDL,keywords='light dependent photo resistor LDR',description='light dependent resistor',ref_prefix='R',num_units=1,fplist=['Resistor*LDR*5.2x5.2*RM3.5*'],do_erc=True,pins=[
            Pin(num='1',name='~',func=Pin.PASSIVE,do_erc=True),
            Pin(num='2',name='~',func=Pin.PASSIVE,do_erc=True)]),
        Part(name='MOC3010M',dest=TEMPLATE,tool=SKIDL,keywords='Opto-Triac Opto Triac Random Phase',description='Random Phase Opto-Triac, Vdrm 400V, Ift 5mA, DIP6',ref_prefix='U',num_units=1,fplist=['DIP*W7.62mm*', 'SMD-6*'],do_erc=True,aliases=['MOC3011M', 'MOC3012M', 'MOC3020M', 'MOC3021M', 'MOC3022M', 'MOC3023M'],pins=[
            Pin(num='1',name='~',func=Pin.PASSIVE,do_erc=True),
            Pin(num='2',name='~',func=Pin.PASSIVE,do_erc=True),
            Pin(num='3',name='NC',func=Pin.NOCONNECT,do_erc=True),
            Pin(num='4',name='~',func=Pin.PASSIVE,do_erc=True),
            Pin(num='5',name='NC',func=Pin.NOCONNECT,do_erc=True),
            Pin(num='6',name='~',func=Pin.PASSIVE,do_erc=True)]),
        Part(name='MOC3031M',dest=TEMPLATE,tool=SKIDL,keywords='Opto-Triac Opto Triac Zero Cross',description='Zero Cross Opto-Triac, Vdrm 400V, Ift 5mA, DIP6',ref_prefix='U',num_units=1,fplist=['DIP*W7.62mm*', 'SMD-6*'],do_erc=True,aliases=['MOC3032M', 'MOC3033M', 'MOC3041M', 'MOC3042M', 'MOC3043M'],pins=[
            Pin(num='1',name='~',func=Pin.PASSIVE,do_erc=True),
            Pin(num='2',name='~',func=Pin.PASSIVE,do_erc=True),
            Pin(num='3',name='NC',func=Pin.NOCONNECT,do_erc=True),
            Pin(num='4',name='~',func=Pin.PASSIVE,do_erc=True),
            Pin(num='5',name='NC',func=Pin.NOCONNECT,do_erc=True),
            Pin(num='6',name='~',func=Pin.PASSIVE,do_erc=True)]),
        Part(name='MOC3051M',dest=TEMPLATE,tool=SKIDL,keywords='Opto-Triac Opto Triac Random Phase',description='Random Phase Opto-Triac, Vdrm 600V, Ift 10mA, DIP6',ref_prefix='U',num_units=1,fplist=['DIP*W7.62mm*', 'SMD-6*'],do_erc=True,aliases=['MOC3052M'],pins=[
            Pin(num='1',name='~',func=Pin.PASSIVE,do_erc=True),
            Pin(num='2',name='~',func=Pin.PASSIVE,do_erc=True),
            Pin(num='3',name='NC',func=Pin.NOCONNECT,do_erc=True),
            Pin(num='4',name='~',func=Pin.PASSIVE,do_erc=True),
            Pin(num='5',name='NC',func=Pin.NOCONNECT,do_erc=True),
            Pin(num='6',name='~',func=Pin.PASSIVE,do_erc=True)]),
        Part(name='MOC3061M',dest=TEMPLATE,tool=SKIDL,keywords='Opto-Triac Opto Triac Zero Cross',description='Zero Cross Opto-Triac, Vdrm 600V, Ift 5mA, dv/dt 1000, DIP6',ref_prefix='U',num_units=1,fplist=['DIP*W7.62mm*', 'SMD-6*'],do_erc=True,aliases=['MOC3062M', 'MOC3063M', 'MOC3162M', 'MOC3163M'],pins=[
            Pin(num='1',name='~',func=Pin.PASSIVE,do_erc=True),
            Pin(num='2',name='~',func=Pin.PASSIVE,do_erc=True),
            Pin(num='3',name='NC',func=Pin.NOCONNECT,do_erc=True),
            Pin(num='4',name='~',func=Pin.PASSIVE,do_erc=True),
            Pin(num='5',name='NC',func=Pin.NOCONNECT,do_erc=True),
            Pin(num='6',name='~',func=Pin.PASSIVE,do_erc=True)]),
        Part(name='MOC3081M',dest=TEMPLATE,tool=SKIDL,keywords='Opto-Triac Opto Triac Zero Cross',description='Zero Cross Opto-Triac, Vdrm 800V, Ift 5mA, DIP6',ref_prefix='U',num_units=1,fplist=['DIP*W7.62mm*', 'SMD-6*'],do_erc=True,aliases=['MOC3082M', 'MOC3083M'],pins=[
            Pin(num='1',name='~',func=Pin.PASSIVE,do_erc=True),
            Pin(num='2',name='~',func=Pin.PASSIVE,do_erc=True),
            Pin(num='3',name='NC',func=Pin.NOCONNECT,do_erc=True),
            Pin(num='4',name='~',func=Pin.PASSIVE,do_erc=True),
            Pin(num='5',name='NC',func=Pin.NOCONNECT,do_erc=True),
            Pin(num='6',name='~',func=Pin.PASSIVE,do_erc=True)]),
        Part(name='OPTO-DARLINGTON',dest=TEMPLATE,tool=SKIDL,keywords='NPN Darlington DC Optocoupler',description='Generic DC Darlington Optocoupler',ref_prefix='U',num_units=1,do_erc=True,pins=[
            Pin(num='1',name='~',func=Pin.PASSIVE,do_erc=True),
            Pin(num='2',name='~',func=Pin.PASSIVE,do_erc=True),
            Pin(num='3',name='NC',func=Pin.NOCONNECT,do_erc=True),
            Pin(num='4',name='~',func=Pin.PASSIVE,do_erc=True),
            Pin(num='5',name='~',func=Pin.PASSIVE,do_erc=True),
            Pin(num='6',name='~',func=Pin.PASSIVE,do_erc=True)]),
        Part(name='OPTO-THYRISTOR',dest=TEMPLATE,tool=SKIDL,keywords='OptoThyristor DC Optocoupler',description='Generic DC Optocoupler Thyristor Based',ref_prefix='U',num_units=1,do_erc=True,pins=[
            Pin(num='1',name='~',func=Pin.PASSIVE,do_erc=True),
            Pin(num='2',name='NC',func=Pin.NOCONNECT,do_erc=True),
            Pin(num='3',name='~',func=Pin.PASSIVE,do_erc=True),
            Pin(num='4',name='~',func=Pin.PASSIVE,do_erc=True),
            Pin(num='5',name='~',func=Pin.PASSIVE,do_erc=True),
            Pin(num='6',name='~',func=Pin.PASSIVE,do_erc=True)]),
        Part(name='OPTO-TRANSISTOR',dest=TEMPLATE,tool=SKIDL,keywords='NPN DC Optocoupler Base Connected',description='Generic Optocoupler with Base Connected',ref_prefix='U',num_units=1,do_erc=True,pins=[
            Pin(num='1',name='~',func=Pin.PASSIVE,do_erc=True),
            Pin(num='2',name='~',func=Pin.PASSIVE,do_erc=True),
            Pin(num='3',name='NC',func=Pin.NOCONNECT,do_erc=True),
            Pin(num='4',name='~',func=Pin.PASSIVE,do_erc=True),
            Pin(num='5',name='~',func=Pin.PASSIVE,do_erc=True),
            Pin(num='6',name='~',func=Pin.PASSIVE,do_erc=True)]),
        Part(name='OPTO-TRANSISTOR-4',dest=TEMPLATE,tool=SKIDL,keywords='NPN DC Quad Optocoupler',description='Generic DC Quad Optocoupler',ref_prefix='U',num_units=4,do_erc=True,pins=[
            Pin(num='1',name='~',func=Pin.PASSIVE,do_erc=True),
            Pin(num='2',name='~',func=Pin.PASSIVE,do_erc=True),
            Pin(num='15',name='~',func=Pin.PASSIVE,do_erc=True),
            Pin(num='16',name='~',func=Pin.PASSIVE,do_erc=True),
            Pin(num='3',name='~',func=Pin.PASSIVE,do_erc=True),
            Pin(num='4',name='~',func=Pin.PASSIVE,do_erc=True),
            Pin(num='13',name='~',func=Pin.PASSIVE,do_erc=True),
            Pin(num='14',name='~',func=Pin.PASSIVE,do_erc=True),
            Pin(num='5',name='~',func=Pin.PASSIVE,do_erc=True),
            Pin(num='6',name='~',func=Pin.PASSIVE,do_erc=True),
            Pin(num='11',name='~',func=Pin.PASSIVE,do_erc=True),
            Pin(num='12',name='~',func=Pin.PASSIVE,do_erc=True),
            Pin(num='7',name='~',func=Pin.PASSIVE,do_erc=True),
            Pin(num='8',name='~',func=Pin.PASSIVE,do_erc=True),
            Pin(num='9',name='~',func=Pin.PASSIVE,do_erc=True),
            Pin(num='10',name='~',func=Pin.PASSIVE,do_erc=True)]),
        Part(name='OPTO-TRIAC',dest=TEMPLATE,tool=SKIDL,keywords='Opto-Triac Opto Triac Random Phase',description='Generic Random Phase Opto-Triac',ref_prefix='U',num_units=1,do_erc=True,pins=[
            Pin(num='1',name='~',func=Pin.PASSIVE,do_erc=True),
            Pin(num='2',name='~',func=Pin.PASSIVE,do_erc=True),
            Pin(num='3',name='NC',func=Pin.NOCONNECT,do_erc=True),
            Pin(num='4',name='~',func=Pin.PASSIVE,do_erc=True),
            Pin(num='5',name='NC',func=Pin.NOCONNECT,do_erc=True),
            Pin(num='6',name='~',func=Pin.PASSIVE,do_erc=True)]),
        Part(name='PC3H4',dest=TEMPLATE,tool=SKIDL,keywords='NPN AC DC Optocoupler',description='AC/DC Optocoupler, Vce 70V, CTR 100-250%, SOP4',ref_prefix='U',num_units=1,fplist=['DIP*W7.62mm*SMD*'],do_erc=True,aliases=['PC3H4A'],pins=[
            Pin(num='1',name='~',func=Pin.PASSIVE,do_erc=True),
            Pin(num='2',name='~',func=Pin.PASSIVE,do_erc=True),
            Pin(num='3',name='~',func=Pin.PASSIVE,do_erc=True),
            Pin(num='4',name='~',func=Pin.PASSIVE,do_erc=True)]),
        Part(name='PC817',dest=TEMPLATE,tool=SKIDL,keywords='NPN DC Optocoupler',description='DC Optocoupler, Vce 35V, CTR 50-300%, DIP4',ref_prefix='U',num_units=1,fplist=['DIP*W7.62mm*'],do_erc=True,pins=[
            Pin(num='1',name='~',func=Pin.PASSIVE,do_erc=True),
            Pin(num='2',name='~',func=Pin.PASSIVE,do_erc=True),
            Pin(num='3',name='~',func=Pin.PASSIVE,do_erc=True),
            Pin(num='4',name='~',func=Pin.PASSIVE,do_erc=True)]),
        Part(name='PC827',dest=TEMPLATE,tool=SKIDL,keywords='NPN DC Dual Optocoupler',description='DC Dual Optocoupler, Vce 35V, CTR 50-300%, DIP8',ref_prefix='U',num_units=2,fplist=['DIP*W7.62mm*'],do_erc=True,pins=[
            Pin(num='1',name='~',func=Pin.PASSIVE,do_erc=True),
            Pin(num='2',name='~',func=Pin.PASSIVE,do_erc=True),
            Pin(num='7',name='~',func=Pin.PASSIVE,do_erc=True),
            Pin(num='8',name='~',func=Pin.PASSIVE,do_erc=True),
            Pin(num='3',name='~',func=Pin.PASSIVE,do_erc=True),
            Pin(num='4',name='~',func=Pin.PASSIVE,do_erc=True),
            Pin(num='5',name='~',func=Pin.PASSIVE,do_erc=True),
            Pin(num='6',name='~',func=Pin.PASSIVE,do_erc=True)]),
        Part(name='PC837',dest=TEMPLATE,tool=SKIDL,keywords='NPN DC Triple Optocoupler',description='DC Triple Optocoupler, Vce 35V, CTR 50-300%, DIP12',ref_prefix='U',num_units=3,fplist=['DIP*W7.62mm*'],do_erc=True,pins=[
            Pin(num='1',name='~',func=Pin.PASSIVE,do_erc=True),
            Pin(num='2',name='~',func=Pin.PASSIVE,do_erc=True),
            Pin(num='11',name='~',func=Pin.PASSIVE,do_erc=True),
            Pin(num='12',name='~',func=Pin.PASSIVE,do_erc=True),
            Pin(num='3',name='~',func=Pin.PASSIVE,do_erc=True),
            Pin(num='4',name='~',func=Pin.PASSIVE,do_erc=True),
            Pin(num='9',name='~',func=Pin.PASSIVE,do_erc=True),
            Pin(num='10',name='~',func=Pin.PASSIVE,do_erc=True),
            Pin(num='5',name='~',func=Pin.PASSIVE,do_erc=True),
            Pin(num='6',name='~',func=Pin.PASSIVE,do_erc=True),
            Pin(num='7',name='~',func=Pin.PASSIVE,do_erc=True),
            Pin(num='8',name='~',func=Pin.PASSIVE,do_erc=True)]),
        Part(name='PC847',dest=TEMPLATE,tool=SKIDL,keywords='NPN DC Quad Optocoupler',description='DC Quad Optocoupler, Vce 35V, CTR 50-300%, DIP16',ref_prefix='U',num_units=4,fplist=['DIP*W7.62mm*'],do_erc=True,pins=[
            Pin(num='1',name='~',func=Pin.PASSIVE,do_erc=True),
            Pin(num='2',name='~',func=Pin.PASSIVE,do_erc=True),
            Pin(num='15',name='~',func=Pin.PASSIVE,do_erc=True),
            Pin(num='16',name='~',func=Pin.PASSIVE,do_erc=True),
            Pin(num='3',name='~',func=Pin.PASSIVE,do_erc=True),
            Pin(num='4',name='~',func=Pin.PASSIVE,do_erc=True),
            Pin(num='13',name='~',func=Pin.PASSIVE,do_erc=True),
            Pin(num='14',name='~',func=Pin.PASSIVE,do_erc=True),
            Pin(num='5',name='~',func=Pin.PASSIVE,do_erc=True),
            Pin(num='6',name='~',func=Pin.PASSIVE,do_erc=True),
            Pin(num='11',name='~',func=Pin.PASSIVE,do_erc=True),
            Pin(num='12',name='~',func=Pin.PASSIVE,do_erc=True),
            Pin(num='7',name='~',func=Pin.PASSIVE,do_erc=True),
            Pin(num='8',name='~',func=Pin.PASSIVE,do_erc=True),
            Pin(num='9',name='~',func=Pin.PASSIVE,do_erc=True),
            Pin(num='10',name='~',func=Pin.PASSIVE,do_erc=True)]),
        Part(name='PL450B',dest=TEMPLATE,tool=SKIDL,keywords='opto laserdiode',description='Green Laser Diode',ref_prefix='LD',num_units=1,fplist=['LaserDiode*TO38ICut*'],do_erc=True,aliases=['PL520', 'PLT5_510'],pins=[
            Pin(num='1',name='A',func=Pin.PASSIVE,do_erc=True),
            Pin(num='2',name='NC',func=Pin.NOCONNECT,do_erc=True),
            Pin(num='3',name='C',func=Pin.PASSIVE,do_erc=True)]),
        Part(name='PLT5_488',dest=TEMPLATE,tool=SKIDL,keywords='opto laserdiode',description='Cyan Laser Diode',ref_prefix='LD',num_units=1,fplist=['LaserDiode*TO56*'],do_erc=True,pins=[
            Pin(num='1',name='~',func=Pin.PASSIVE,do_erc=True),
            Pin(num='2',name='~',func=Pin.PASSIVE,do_erc=True),
            Pin(num='3',name='~',func=Pin.PASSIVE,do_erc=True)]),
        Part(name='S102S01',dest=TEMPLATE,tool=SKIDL,keywords='Opto-Triac Opto Triac Random Phase Solid State Relays',description='Random Phase Opto-Triac, Vdrm 600V, Ift 8mA, IT 16A',ref_prefix='U',num_units=1,fplist=['SIP4*Sharp*SSR*Pitch7.62mm*'],do_erc=True,aliases=['S202S01', 'S116S01', 'S216S01', 'S112S01', 'S212S01'],pins=[
            Pin(num='1',name='~',func=Pin.PASSIVE,do_erc=True),
            Pin(num='2',name='~',func=Pin.PASSIVE,do_erc=True),
            Pin(num='3',name='~',func=Pin.PASSIVE,do_erc=True),
            Pin(num='4',name='~',func=Pin.PASSIVE,do_erc=True)]),
        Part(name='S102S02',dest=TEMPLATE,tool=SKIDL,keywords='Opto-Triac Opto Triac Zero Cross Solid State Relays',description='Zero Cross Opto-Triac, Vdrm 600V, Ift 8mA, IT 16A',ref_prefix='U',num_units=1,fplist=['SIP4*Sharp*SSR*Pitch7.62mm*'],do_erc=True,aliases=['S202S02', 'S116S02', 'S216S02'],pins=[
            Pin(num='1',name='~',func=Pin.PASSIVE,do_erc=True),
            Pin(num='2',name='~',func=Pin.PASSIVE,do_erc=True),
            Pin(num='3',name='~',func=Pin.PASSIVE,do_erc=True),
            Pin(num='4',name='~',func=Pin.PASSIVE,do_erc=True)]),
        Part(name='SFH203',dest=TEMPLATE,tool=SKIDL,keywords='PIN photodiode IR',description='Silicon PIN Photodiode with Daylight Blocking Filter',ref_prefix='D',num_units=1,fplist=['LED*5mm*'],do_erc=True,aliases=['SFH203FA'],pins=[
            Pin(num='1',name='K',func=Pin.PASSIVE,do_erc=True),
            Pin(num='2',name='A',func=Pin.PASSIVE,do_erc=True)]),
        Part(name='SFH205F',dest=TEMPLATE,tool=SKIDL,keywords='PIN Photodiode',description='Silicon PIN Photodiode with Daylight Blocking Filter',ref_prefix='D',num_units=1,fplist=['PhotoDiode*SFH205*'],do_erc=True,aliases=['SFH205FA'],pins=[
            Pin(num='1',name='K',func=Pin.PASSIVE,do_erc=True),
            Pin(num='2',name='A',func=Pin.PASSIVE,do_erc=True)]),
        Part(name='SFH206K',dest=TEMPLATE,tool=SKIDL,keywords='opto PIN photodiode',description='Silicon PIN Photodiode',ref_prefix='D',num_units=1,fplist=['PhotoDiode*SFH205*'],do_erc=True,pins=[
            Pin(num='1',name='K',func=Pin.PASSIVE,do_erc=True),
            Pin(num='2',name='A',func=Pin.PASSIVE,do_erc=True)]),
        Part(name='SFH216',dest=TEMPLATE,tool=SKIDL,keywords='opto PIN photo diode',description='Silicon PIN Photodiode With Very Short Switching Time, TO-18 package',ref_prefix='D',num_units=1,fplist=['TO?18*Window*'],do_erc=True,pins=[
            Pin(num='1',name='K',func=Pin.PASSIVE,do_erc=True),
            Pin(num='2',name='A',func=Pin.PASSIVE,do_erc=True)]),
        Part(name='SFH225FA',dest=TEMPLATE,tool=SKIDL,keywords='opto PIN photodiode IR',description='Silicon PIN Photodiode with Daylight Blocking Filter',ref_prefix='D',num_units=1,fplist=['PhotoDiode*SFH225*'],do_erc=True,aliases=['SFH235FA'],pins=[
            Pin(num='1',name='K',func=Pin.PASSIVE,do_erc=True),
            Pin(num='2',name='A',func=Pin.PASSIVE,do_erc=True)]),
        Part(name='SFH2400',dest=TEMPLATE,tool=SKIDL,keywords='opto photodiode',description='Silicon PIN Photodiode, SMD package',ref_prefix='D',num_units=1,fplist=['PhotoDiode*SMD*SmartDIL*'],do_erc=True,pins=[
            Pin(num='1',name='K',func=Pin.PASSIVE,do_erc=True),
            Pin(num='2',name='A',func=Pin.PASSIVE,do_erc=True)]),
        Part(name='SFH2701',dest=TEMPLATE,tool=SKIDL,keywords='opto photodiode',description='High Speed PIN Photodiode, SMD package',ref_prefix='D',num_units=1,fplist=['LED*1206*'],do_erc=True,pins=[
            Pin(num='1',name='K',func=Pin.PASSIVE,do_erc=True),
            Pin(num='2',name='A',func=Pin.PASSIVE,do_erc=True)]),
        Part(name='SFH309',dest=TEMPLATE,tool=SKIDL,keywords='npn phototransistor',description='Phototransistor NPN',ref_prefix='Q',num_units=1,fplist=['LED*3mm*'],do_erc=True,aliases=['BPW42'],pins=[
            Pin(num='1',name='C',func=Pin.PASSIVE,do_erc=True),
            Pin(num='2',name='E',func=Pin.PASSIVE,do_erc=True)]),
        Part(name='SFH4356P',dest=TEMPLATE,tool=SKIDL,keywords='opto IR LED',description='Infrared LED , 3mm LED package',ref_prefix='D',num_units=1,fplist=['LED*3mm*'],do_erc=True,aliases=['IR204A', 'TSAL4400', 'SFH4346'],pins=[
            Pin(num='1',name='K',func=Pin.PASSIVE,do_erc=True),
            Pin(num='2',name='A',func=Pin.PASSIVE,do_erc=True)]),
        Part(name='SFH460',dest=TEMPLATE,tool=SKIDL,keywords='opto IR LED',description='GaAlAs Infrared LED, TO-18 package',ref_prefix='D',num_units=1,fplist=['TO?18*Window*'],do_erc=True,pins=[
            Pin(num='1',name='K',func=Pin.PASSIVE,do_erc=True),
            Pin(num='2',name='A',func=Pin.PASSIVE,do_erc=True)]),
        Part(name='SFH482',dest=TEMPLATE,tool=SKIDL,keywords='opto IR LED',description='GaAlAs Infrared LED (880 nm), TO-18 package',ref_prefix='D',num_units=1,fplist=['TO?18*Window*'],do_erc=True,aliases=['SFH480'],pins=[
            Pin(num='1',name='K',func=Pin.PASSIVE,do_erc=True),
            Pin(num='2',name='A',func=Pin.PASSIVE,do_erc=True)]),
        Part(name='SPL_PL90',dest=TEMPLATE,tool=SKIDL,keywords='opto laserdiode',description='Pulsed Laser Diode in Plastic Package 25 W Peak Power',ref_prefix='LD',num_units=1,fplist=['LED*5mm*'],do_erc=True,pins=[
            Pin(num='1',name='C',func=Pin.PASSIVE,do_erc=True),
            Pin(num='2',name='A',func=Pin.PASSIVE,do_erc=True)]),
        Part(name='TLP127',dest=TEMPLATE,tool=SKIDL,keywords='NPN Darlington DC Optocoupler',description='DC Darlington Optocoupler, Vce 300V, CTR 1000%, MFSOP6',ref_prefix='U',num_units=1,fplist=['DIP*W7.62mm*SMD*'],do_erc=True,pins=[
            Pin(num='1',name='~',func=Pin.PASSIVE,do_erc=True),
            Pin(num='2',name='NC',func=Pin.NOCONNECT,do_erc=True),
            Pin(num='3',name='~',func=Pin.PASSIVE,do_erc=True),
            Pin(num='4',name='~',func=Pin.PASSIVE,do_erc=True),
            Pin(num='5',name='NC',func=Pin.NOCONNECT,do_erc=True),
            Pin(num='6',name='~',func=Pin.PASSIVE,do_erc=True)]),
        Part(name='TLP130',dest=TEMPLATE,tool=SKIDL,keywords='NPN AC DC Optocoupler Base Connected',description='AC DC Optocoupler Base Connected, Vce 80V, CTR 50-100%, MFSOP6',ref_prefix='U',num_units=1,fplist=['DIP*W7.62mm*SMD*'],do_erc=True,pins=[
            Pin(num='1',name='~',func=Pin.PASSIVE,do_erc=True),
            Pin(num='2',name='NC',func=Pin.NOCONNECT,do_erc=True),
            Pin(num='3',name='~',func=Pin.PASSIVE,do_erc=True),
            Pin(num='4',name='~',func=Pin.PASSIVE,do_erc=True),
            Pin(num='5',name='~',func=Pin.PASSIVE,do_erc=True),
            Pin(num='6',name='~',func=Pin.PASSIVE,do_erc=True)]),
        Part(name='TLP131',dest=TEMPLATE,tool=SKIDL,keywords='NPN DC Optocoupler Base Connected',description='DC Optocoupler Base Connected, Vce 80V, CTR 50-200%, MFSOP6',ref_prefix='U',num_units=1,fplist=['DIP*W7.62mm*SMD*'],do_erc=True,pins=[
            Pin(num='1',name='~',func=Pin.PASSIVE,do_erc=True),
            Pin(num='2',name='NC',func=Pin.NOCONNECT,do_erc=True),
            Pin(num='3',name='~',func=Pin.PASSIVE,do_erc=True),
            Pin(num='4',name='~',func=Pin.PASSIVE,do_erc=True),
            Pin(num='5',name='~',func=Pin.PASSIVE,do_erc=True),
            Pin(num='6',name='~',func=Pin.PASSIVE,do_erc=True)]),
        Part(name='TLP137',dest=TEMPLATE,tool=SKIDL,keywords='NPN DC Optocoupler Base Connected',description='DC Optocoupler Base Connected, Vce 80V, CTR 100-200%, MFSOP6',ref_prefix='U',num_units=1,fplist=['DIP*W7.62mm*SMD*'],do_erc=True,pins=[
            Pin(num='1',name='~',func=Pin.PASSIVE,do_erc=True),
            Pin(num='2',name='NC',func=Pin.NOCONNECT,do_erc=True),
            Pin(num='3',name='~',func=Pin.PASSIVE,do_erc=True),
            Pin(num='4',name='~',func=Pin.PASSIVE,do_erc=True),
            Pin(num='5',name='~',func=Pin.PASSIVE,do_erc=True),
            Pin(num='6',name='~',func=Pin.PASSIVE,do_erc=True)]),
        Part(name='TLP141G',dest=TEMPLATE,tool=SKIDL,keywords='OptoThyristor DC Optocoupler',description='DC Optocoupler Thyristor Based, Vdrm 400V, It 150mA, Viso 2500V, MFSOP6',ref_prefix='U',num_units=1,fplist=['DIP*W7.62mm*SMD*'],do_erc=True,pins=[
            Pin(num='1',name='~',func=Pin.PASSIVE,do_erc=True),
            Pin(num='2',name='NC',func=Pin.NOCONNECT,do_erc=True),
            Pin(num='3',name='~',func=Pin.PASSIVE,do_erc=True),
            Pin(num='4',name='~',func=Pin.PASSIVE,do_erc=True),
            Pin(num='5',name='~',func=Pin.PASSIVE,do_erc=True),
            Pin(num='6',name='~',func=Pin.PASSIVE,do_erc=True)]),
        Part(name='TLP160G',dest=TEMPLATE,tool=SKIDL,keywords='Opto-Triac Opto Triac Random',description='Random Phase Opto-Triac, Vdrm 600V, Ift 7mA, SOP6',ref_prefix='U',num_units=1,do_erc=True,aliases=['TLP160J'],pins=[
            Pin(num='1',name='~',func=Pin.PASSIVE,do_erc=True),
            Pin(num='2',name='NC',func=Pin.NOCONNECT,do_erc=True),
            Pin(num='3',name='~',func=Pin.PASSIVE,do_erc=True),
            Pin(num='4',name='~',func=Pin.PASSIVE,do_erc=True),
            Pin(num='5',name='NC',func=Pin.NOCONNECT,do_erc=True),
            Pin(num='6',name='~',func=Pin.PASSIVE,do_erc=True)]),
        Part(name='TLP161G',dest=TEMPLATE,tool=SKIDL,keywords='Opto-Triac Opto Triac Zero Cross',description='Zero Cross Opto-Triac, Vdrm 600V, Ift 7mA, SOP6',ref_prefix='U',num_units=1,do_erc=True,aliases=['TLP161J'],pins=[
            Pin(num='1',name='~',func=Pin.PASSIVE,do_erc=True),
            Pin(num='2',name='NC',func=Pin.NOCONNECT,do_erc=True),
            Pin(num='3',name='~',func=Pin.PASSIVE,do_erc=True),
            Pin(num='4',name='~',func=Pin.PASSIVE,do_erc=True),
            Pin(num='5',name='NC',func=Pin.NOCONNECT,do_erc=True),
            Pin(num='6',name='~',func=Pin.PASSIVE,do_erc=True)]),
        Part(name='TLP175A',dest=TEMPLATE,tool=SKIDL,keywords='MOSFET Output Photorelay 1-Form-A',description='MOSFET Photorelay 1-Form-A, Voff 60V, Ion 100mA, SOP6',ref_prefix='U',num_units=1,do_erc=True,pins=[
            Pin(num='1',name='~',func=Pin.PASSIVE,do_erc=True),
            Pin(num='2',name='NC',func=Pin.NOCONNECT,do_erc=True),
            Pin(num='3',name='~',func=Pin.PASSIVE,do_erc=True),
            Pin(num='4',name='~',func=Pin.PASSIVE,do_erc=True),
            Pin(num='5',name='NC',func=Pin.NOCONNECT,do_erc=True),
            Pin(num='6',name='~',func=Pin.PASSIVE,do_erc=True)]),
        Part(name='TLP184',dest=TEMPLATE,tool=SKIDL,keywords='NPN AC DC Optocoupler',description='AC/DC Optocoupler, Vce 80V, CTR 50-100%, MFSOP6',ref_prefix='U',num_units=1,fplist=['DIP*W7.62mm*SMD*'],do_erc=True,pins=[
            Pin(num='1',name='~',func=Pin.PASSIVE,do_erc=True),
            Pin(num='2',name='NC',func=Pin.NOCONNECT,do_erc=True),
            Pin(num='3',name='~',func=Pin.PASSIVE,do_erc=True),
            Pin(num='4',name='~',func=Pin.PASSIVE,do_erc=True),
            Pin(num='5',name='NC',func=Pin.NOCONNECT,do_erc=True),
            Pin(num='6',name='~',func=Pin.PASSIVE,do_erc=True)]),
        Part(name='TLP185',dest=TEMPLATE,tool=SKIDL,keywords='NPN DC Optocoupler',description='DC Optocoupler, Vce 80V, CTR 50-100%, MFSOP6',ref_prefix='U',num_units=1,fplist=['DIP*W7.62mm*SMD*'],do_erc=True,pins=[
            Pin(num='1',name='~',func=Pin.PASSIVE,do_erc=True),
            Pin(num='2',name='NC',func=Pin.NOCONNECT,do_erc=True),
            Pin(num='3',name='~',func=Pin.PASSIVE,do_erc=True),
            Pin(num='4',name='~',func=Pin.PASSIVE,do_erc=True),
            Pin(num='5',name='NC',func=Pin.NOCONNECT,do_erc=True),
            Pin(num='6',name='~',func=Pin.PASSIVE,do_erc=True)]),
        Part(name='TLP222A',dest=TEMPLATE,tool=SKIDL,keywords='MOSFET Output Photorelay 1-Form-A',description='MOSFET Photorelay 1-Form-A, Voff 60V, Ion 0,5A, DIP4',ref_prefix='U',num_units=1,fplist=['DIP*W7.62mm*'],do_erc=True,pins=[
            Pin(num='1',name='~',func=Pin.PASSIVE,do_erc=True),
            Pin(num='2',name='~',func=Pin.PASSIVE,do_erc=True),
            Pin(num='3',name='~',func=Pin.PASSIVE,do_erc=True),
            Pin(num='4',name='~',func=Pin.PASSIVE,do_erc=True)]),
        Part(name='TLP222A-2',dest=TEMPLATE,tool=SKIDL,keywords='Dual MOSFET Output Photorelay 1-Form-A',description='Dual MOSFET Photorelay 1-Form-A, Voff 60V, Ion 0,5A, DIP8',ref_prefix='U',num_units=2,fplist=['DIP*W7.62mm*'],do_erc=True,pins=[
            Pin(num='1',name='~',func=Pin.PASSIVE,do_erc=True),
            Pin(num='2',name='~',func=Pin.PASSIVE,do_erc=True),
            Pin(num='7',name='~',func=Pin.PASSIVE,do_erc=True),
            Pin(num='8',name='~',func=Pin.PASSIVE,do_erc=True),
            Pin(num='3',name='~',func=Pin.PASSIVE,do_erc=True),
            Pin(num='4',name='~',func=Pin.PASSIVE,do_erc=True),
            Pin(num='5',name='~',func=Pin.PASSIVE,do_erc=True),
            Pin(num='6',name='~',func=Pin.PASSIVE,do_erc=True)]),
        Part(name='TLP250',dest=TEMPLATE,tool=SKIDL,keywords='MOSFET Driver IGBT Driver Optocoupler',description='Gate Drive Optocoupler, Output Current 1.5/1.5A',ref_prefix='U',num_units=1,fplist=['DIP*W7.62mm*'],do_erc=True,pins=[
            Pin(num='1',name='NC',func=Pin.NOCONNECT,do_erc=True),
            Pin(num='2',name='A',func=Pin.PASSIVE,do_erc=True),
            Pin(num='3',name='C',func=Pin.PASSIVE,do_erc=True),
            Pin(num='4',name='NC',func=Pin.NOCONNECT,do_erc=True),
            Pin(num='5',name='VEE',func=Pin.PWROUT,do_erc=True),
            Pin(num='6',name='VO',func=Pin.PASSIVE,do_erc=True),
            Pin(num='7',name='VO',func=Pin.PASSIVE,do_erc=True),
            Pin(num='8',name='VCC',func=Pin.PWRIN,do_erc=True)]),
        Part(name='TLP290',dest=TEMPLATE,tool=SKIDL,keywords='NPN AC DC Phototransistor Optocoupler',description='AC/DC Phototransistor Optocoupler, Vce 80V, CTR 50-600%, SOP4',ref_prefix='U',num_units=1,fplist=['SOP*4*'],do_erc=True,aliases=['TCMT1600'],pins=[
            Pin(num='1',name='~',func=Pin.PASSIVE,do_erc=True),
            Pin(num='2',name='~',func=Pin.PASSIVE,do_erc=True),
            Pin(num='3',name='~',func=Pin.PASSIVE,do_erc=True),
            Pin(num='4',name='~',func=Pin.PASSIVE,do_erc=True)]),
        Part(name='TLP290-4',dest=TEMPLATE,tool=SKIDL,keywords='NPN AC DC Quad Phototransistor Optocoupler',description='Quad AC/DC Phototransistor Optocoupler, Vce 80V, CTR 50-600%, SOP16',ref_prefix='U',num_units=4,fplist=['SOP*16*'],do_erc=True,aliases=['TCMT4600', 'TCMT4606'],pins=[
            Pin(num='1',name='~',func=Pin.PASSIVE,do_erc=True),
            Pin(num='2',name='~',func=Pin.PASSIVE,do_erc=True),
            Pin(num='15',name='~',func=Pin.PASSIVE,do_erc=True),
            Pin(num='16',name='~',func=Pin.PASSIVE,do_erc=True),
            Pin(num='3',name='~',func=Pin.PASSIVE,do_erc=True),
            Pin(num='4',name='~',func=Pin.PASSIVE,do_erc=True),
            Pin(num='13',name='~',func=Pin.PASSIVE,do_erc=True),
            Pin(num='14',name='~',func=Pin.PASSIVE,do_erc=True),
            Pin(num='5',name='~',func=Pin.PASSIVE,do_erc=True),
            Pin(num='6',name='~',func=Pin.PASSIVE,do_erc=True),
            Pin(num='11',name='~',func=Pin.PASSIVE,do_erc=True),
            Pin(num='12',name='~',func=Pin.PASSIVE,do_erc=True),
            Pin(num='7',name='~',func=Pin.PASSIVE,do_erc=True),
            Pin(num='8',name='~',func=Pin.PASSIVE,do_erc=True),
            Pin(num='9',name='~',func=Pin.PASSIVE,do_erc=True),
            Pin(num='10',name='~',func=Pin.PASSIVE,do_erc=True)]),
        Part(name='TLP291',dest=TEMPLATE,tool=SKIDL,keywords='NPN DC Optocoupler',description='DC Optocoupler, Vce 80V, CTR 50-100%, SOP4',ref_prefix='U',num_units=1,fplist=['DIP*W7.62mm*SMD*'],do_erc=True,pins=[
            Pin(num='1',name='~',func=Pin.PASSIVE,do_erc=True),
            Pin(num='2',name='~',func=Pin.PASSIVE,do_erc=True),
            Pin(num='3',name='~',func=Pin.PASSIVE,do_erc=True),
            Pin(num='4',name='~',func=Pin.PASSIVE,do_erc=True)]),
        Part(name='TLP291-4',dest=TEMPLATE,tool=SKIDL,keywords='NPN DC Quad Optocoupler',description='Quad DC Optocoupler, Vce 80V, CTR 50-100%, SOP16',ref_prefix='U',num_units=4,fplist=['DIP*W7.62mm*SMD*'],do_erc=True,pins=[
            Pin(num='1',name='~',func=Pin.PASSIVE,do_erc=True),
            Pin(num='2',name='~',func=Pin.PASSIVE,do_erc=True),
            Pin(num='15',name='~',func=Pin.PASSIVE,do_erc=True),
            Pin(num='16',name='~',func=Pin.PASSIVE,do_erc=True),
            Pin(num='3',name='~',func=Pin.PASSIVE,do_erc=True),
            Pin(num='4',name='~',func=Pin.PASSIVE,do_erc=True),
            Pin(num='13',name='~',func=Pin.PASSIVE,do_erc=True),
            Pin(num='14',name='~',func=Pin.PASSIVE,do_erc=True),
            Pin(num='5',name='~',func=Pin.PASSIVE,do_erc=True),
            Pin(num='6',name='~',func=Pin.PASSIVE,do_erc=True),
            Pin(num='11',name='~',func=Pin.PASSIVE,do_erc=True),
            Pin(num='12',name='~',func=Pin.PASSIVE,do_erc=True),
            Pin(num='7',name='~',func=Pin.PASSIVE,do_erc=True),
            Pin(num='8',name='~',func=Pin.PASSIVE,do_erc=True),
            Pin(num='9',name='~',func=Pin.PASSIVE,do_erc=True),
            Pin(num='10',name='~',func=Pin.PASSIVE,do_erc=True)]),
        Part(name='TLP3021',dest=TEMPLATE,tool=SKIDL,keywords='Photo-Triac Opto Triac',description='Photo-Triac, Vdrm 400V, Ift 5mA, DIP6',ref_prefix='U',num_units=1,fplist=['DIP*W7.62mm*'],do_erc=True,aliases=['TLP3022', 'TLP3023'],pins=[
            Pin(num='1',name='~',func=Pin.PASSIVE,do_erc=True),
            Pin(num='2',name='~',func=Pin.PASSIVE,do_erc=True),
            Pin(num='3',name='NC',func=Pin.NOCONNECT,do_erc=True),
            Pin(num='4',name='~',func=Pin.PASSIVE,do_erc=True),
            Pin(num='5',name='NC',func=Pin.NOCONNECT,do_erc=True),
            Pin(num='6',name='~',func=Pin.PASSIVE,do_erc=True)]),
        Part(name='TLP627',dest=TEMPLATE,tool=SKIDL,keywords='NPN Darlington DC Optocoupler',description='DC Darlington Optocoupler, Vce 300V, CTR 1000%, DIP4',ref_prefix='U',num_units=1,fplist=['DIP*W7.62mm*'],do_erc=True,pins=[
            Pin(num='1',name='~',func=Pin.PASSIVE,do_erc=True),
            Pin(num='2',name='~',func=Pin.PASSIVE,do_erc=True),
            Pin(num='3',name='~',func=Pin.PASSIVE,do_erc=True),
            Pin(num='4',name='~',func=Pin.PASSIVE,do_erc=True)]),
        Part(name='TLP627-2',dest=TEMPLATE,tool=SKIDL,keywords='NPN Dual Darlington DC Optocoupler',description='DC Dual Darlington Optocoupler, Vce 300V, CTR 1000%, DIP8',ref_prefix='U',num_units=2,fplist=['DIP*W7.62mm*'],do_erc=True,pins=[
            Pin(num='1',name='~',func=Pin.PASSIVE,do_erc=True),
            Pin(num='2',name='~',func=Pin.PASSIVE,do_erc=True),
            Pin(num='7',name='~',func=Pin.PASSIVE,do_erc=True),
            Pin(num='8',name='~',func=Pin.PASSIVE,do_erc=True),
            Pin(num='3',name='~',func=Pin.PASSIVE,do_erc=True),
            Pin(num='4',name='~',func=Pin.PASSIVE,do_erc=True),
            Pin(num='5',name='~',func=Pin.PASSIVE,do_erc=True),
            Pin(num='6',name='~',func=Pin.PASSIVE,do_erc=True)]),
        Part(name='TLP627-4',dest=TEMPLATE,tool=SKIDL,keywords='NPN Quad Darlington DC Optocoupler',description='DC Quad Darlington Optocoupler, Vce 300V, CTR 1000%, DIP16',ref_prefix='U',num_units=4,fplist=['DIP*W7.62mm*'],do_erc=True,pins=[
            Pin(num='1',name='~',func=Pin.PASSIVE,do_erc=True),
            Pin(num='2',name='~',func=Pin.PASSIVE,do_erc=True),
            Pin(num='15',name='~',func=Pin.PASSIVE,do_erc=True),
            Pin(num='16',name='~',func=Pin.PASSIVE,do_erc=True),
            Pin(num='3',name='~',func=Pin.PASSIVE,do_erc=True),
            Pin(num='4',name='~',func=Pin.PASSIVE,do_erc=True),
            Pin(num='13',name='~',func=Pin.PASSIVE,do_erc=True),
            Pin(num='14',name='~',func=Pin.PASSIVE,do_erc=True),
            Pin(num='5',name='~',func=Pin.PASSIVE,do_erc=True),
            Pin(num='6',name='~',func=Pin.PASSIVE,do_erc=True),
            Pin(num='11',name='~',func=Pin.PASSIVE,do_erc=True),
            Pin(num='12',name='~',func=Pin.PASSIVE,do_erc=True),
            Pin(num='7',name='~',func=Pin.PASSIVE,do_erc=True),
            Pin(num='8',name='~',func=Pin.PASSIVE,do_erc=True),
            Pin(num='9',name='~',func=Pin.PASSIVE,do_erc=True),
            Pin(num='10',name='~',func=Pin.PASSIVE,do_erc=True)]),
        Part(name='TLP785',dest=TEMPLATE,tool=SKIDL,keywords='NPN DC Optocoupler',description='DC Optocoupler, Vce 80V, CTR 50-200%, DIP4',ref_prefix='U',num_units=1,fplist=['DIP*W7.62mm*'],do_erc=True,pins=[
            Pin(num='1',name='~',func=Pin.PASSIVE,do_erc=True),
            Pin(num='2',name='~',func=Pin.PASSIVE,do_erc=True),
            Pin(num='3',name='~',func=Pin.PASSIVE,do_erc=True),
            Pin(num='4',name='~',func=Pin.PASSIVE,do_erc=True)]),
        Part(name='TLP785F',dest=TEMPLATE,tool=SKIDL,keywords='NPN DC Optocoupler',description='DC Optocoupler, Vce 80V, CTR 50-200%, DIP4F',ref_prefix='U',num_units=1,fplist=['DIP*W10.16mm*'],do_erc=True,pins=[
            Pin(num='1',name='~',func=Pin.PASSIVE,do_erc=True),
            Pin(num='2',name='~',func=Pin.PASSIVE,do_erc=True),
            Pin(num='3',name='~',func=Pin.PASSIVE,do_erc=True),
            Pin(num='4',name='~',func=Pin.PASSIVE,do_erc=True)]),
        Part(name='TSDP341xx',dest=TEMPLATE,tool=SKIDL,keywords='opto IR receiver',description='IR Receiver Modules for Remote Control Systems',ref_prefix='U',num_units=1,fplist=['IRReceiver?Vishay?MOLD*'],do_erc=True,aliases=['TSDP343xx', 'TSOP341xx', 'TSOP343xx', 'TSOP345xx', 'TSOP41xx', 'TSOP43xx', 'TSOP45xx'],pins=[
            Pin(num='1',name='OUT',func=Pin.OUTPUT,do_erc=True),
            Pin(num='2',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='3',name='Vs',func=Pin.PWRIN,do_erc=True)]),
        Part(name='TSL2550-SO8',dest=TEMPLATE,tool=SKIDL,keywords='opto ambient light sensor',description='Ambient Light Sensor with SMbus Interface, SO-8 interface',ref_prefix='U',num_units=1,fplist=['SOIC*3.9x4.9mm*Pitch1.27mm*'],do_erc=True,pins=[
            Pin(num='1',name='Vdd',func=Pin.PWRIN,do_erc=True),
            Pin(num='2',name='NC',func=Pin.NOCONNECT,do_erc=True),
            Pin(num='3',name='NC',func=Pin.NOCONNECT,do_erc=True),
            Pin(num='4',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='5',name='CLK',do_erc=True),
            Pin(num='6',name='NC',func=Pin.NOCONNECT,do_erc=True),
            Pin(num='7',name='NC',func=Pin.NOCONNECT,do_erc=True),
            Pin(num='8',name='DAT',func=Pin.BIDIR,do_erc=True)]),
        Part(name='TSL2550-T4',dest=TEMPLATE,tool=SKIDL,keywords='opto ambient light sensor',description='Ambient Light Sensor with SMbus Interface, T-4 interface',ref_prefix='U',num_units=1,fplist=['TSSL2550*'],do_erc=True,pins=[
            Pin(num='1',name='Vdd',func=Pin.PWRIN,do_erc=True),
            Pin(num='2',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='3',name='CLK',do_erc=True),
            Pin(num='4',name='DAT',func=Pin.BIDIR,do_erc=True)]),
        Part(name='TSMP58138',dest=TEMPLATE,tool=SKIDL,keywords='opto IR repeater receiver',description='Photo Module (Repeater) for PCM Remote Control Systems',ref_prefix='U',num_units=1,fplist=['IRReceiver?Vishay?MINICAST*'],do_erc=True,aliases=['TSMP58000'],pins=[
            Pin(num='1',name='OUT',func=Pin.OUTPUT,do_erc=True),
            Pin(num='2',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='3',name='Vs',func=Pin.PWRIN,do_erc=True)]),
        Part(name='TSOP17xx',dest=TEMPLATE,tool=SKIDL,keywords='opto IR receiver',description='Photo Modules for PCM Remote Control Systems',ref_prefix='U',num_units=1,fplist=['IRReceiver?Vishay?CAST*'],do_erc=True,aliases=['TSOP312xx', 'TSOP314xx'],pins=[
            Pin(num='1',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='2',name='Vs',func=Pin.PWRIN,do_erc=True),
            Pin(num='3',name='OUT',func=Pin.OUTPUT,do_erc=True)]),
        Part(name='TSOP32S40F',dest=TEMPLATE,tool=SKIDL,keywords='opto IR receiver',description='IR Receiver Modules for Remote Control Systems',ref_prefix='U',num_units=1,fplist=['IRReceiver?Vishay?MOLD*'],do_erc=True,aliases=['TSOP321xx', 'TSOP323xx', 'TSOP325xx', 'TSOP21xx', 'TSOP23xx', 'TSOP25xx'],pins=[
            Pin(num='1',name='OUT',func=Pin.OUTPUT,do_erc=True),
            Pin(num='2',name='Vs',func=Pin.PWRIN,do_erc=True),
            Pin(num='3',name='GND',func=Pin.PWRIN,do_erc=True)]),
        Part(name='TSOP331xx',dest=TEMPLATE,tool=SKIDL,keywords='opto IR receiver',description='IR Receiver Modules for Remote Control Systems',ref_prefix='U',num_units=1,fplist=['IRReceiver?Vishay?MINIMOLD*'],do_erc=True,aliases=['TSOP333xx', 'TSOP335xx', 'TSOP531xx', 'TSOP533xx', 'TSOP535xx'],pins=[
            Pin(num='1',name='OUT',func=Pin.OUTPUT,do_erc=True),
            Pin(num='2',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='3',name='Vs',func=Pin.PWRIN,do_erc=True)]),
        Part(name='TSOP34S40F',dest=TEMPLATE,tool=SKIDL,keywords='opto IR receiver',description='IR Receiver Modules for Remote Control Systems',ref_prefix='U',num_units=1,fplist=['IRReceiver?Vishay?MOLD*'],do_erc=True,pins=[
            Pin(num='1',name='OUT',func=Pin.OUTPUT,do_erc=True),
            Pin(num='2',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='3',name='Vs',func=Pin.PWRIN,do_erc=True)]),
        Part(name='TSOP581xx',dest=TEMPLATE,tool=SKIDL,keywords='opto IR receiver proximity sensor',description='IR Detector for Mid Range Proximity Sensor',ref_prefix='U',num_units=1,fplist=['IRReceiver?Vishay?MINICAST*'],do_erc=True,aliases=['TSOP583xx', 'TSOP585xx', 'TSOP382xx', 'TSOP384xx', 'TSOP582xx', 'TSOP584xx', 'TSOP38G36', 'TSSP58038', 'TSSP58038SS1XB', 'TSSP58P38'],pins=[
            Pin(num='1',name='OUT',func=Pin.OUTPUT,do_erc=True),
            Pin(num='2',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='3',name='Vs',func=Pin.PWRIN,do_erc=True)]),
        Part(name='VO615A',dest=TEMPLATE,tool=SKIDL,keywords='NPN DC Optocoupler',description='DC Optocoupler, Vce 70V, CTR 200-400% @ 5mA, Viso 5000Vrms, DIP4',ref_prefix='U',num_units=1,fplist=['DIP*W7.62mm*', 'DIP*W10.16mm*', 'DIP*W7.62mm*SMD*', 'DIP*W9.53mm*SMD*', 'DIP*W11.48mm*SMD*'],do_erc=True,aliases=['VO615A-1', 'VO615A-2', 'VO615A-3', 'VO615A-4', 'VO615A-5', 'VO615A-6', 'VO615A-7', 'VO615A-8', 'VO615A-9'],pins=[
            Pin(num='1',name='~',func=Pin.PASSIVE,do_erc=True),
            Pin(num='2',name='~',func=Pin.PASSIVE,do_erc=True),
            Pin(num='3',name='~',func=Pin.PASSIVE,do_erc=True),
            Pin(num='4',name='~',func=Pin.PASSIVE,do_erc=True)]),
        Part(name='VT93xx',dest=TEMPLATE,tool=SKIDL,keywords='light dependent photo resistor LDR',description='light dependent resistor',ref_prefix='R',num_units=1,fplist=['Resistor*LDR*4.9x4.2*RM2.54*'],do_erc=True,pins=[
            Pin(num='1',name='~',func=Pin.PASSIVE,do_erc=True),
            Pin(num='2',name='~',func=Pin.PASSIVE,do_erc=True)])])
