from skidl import SKIDL, TEMPLATE, Part, Pin, SchLib

SKIDL_lib_version = '0.0.1'

microchip = SchLib(tool=SKIDL).add_parts(*[
        Part(name='ENC28J60-C/SS',dest=TEMPLATE,tool=SKIDL,keywords='ENC Ethernet',description='ENC28J60 Single Chip Ethernet Interface, SSOP-28',ref_prefix='U',num_units=1,fplist=['SSOP*'],do_erc=True,pins=[
            Pin(num='1',name='VCAP',do_erc=True),
            Pin(num='2',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='3',name='CLKOUT',func=Pin.OUTPUT,do_erc=True),
            Pin(num='4',name='~INT',func=Pin.OUTPUT,do_erc=True),
            Pin(num='5',name='~WOL',func=Pin.OUTPUT,do_erc=True),
            Pin(num='6',name='SO',func=Pin.OUTPUT,do_erc=True),
            Pin(num='7',name='SI',do_erc=True),
            Pin(num='8',name='SCK',do_erc=True),
            Pin(num='9',name='~CS',do_erc=True),
            Pin(num='10',name='~RESET',do_erc=True),
            Pin(num='20',name='VDDPLL',func=Pin.PWRIN,do_erc=True),
            Pin(num='11',name='VSSRX',func=Pin.PWRIN,do_erc=True),
            Pin(num='21',name='VSSPLL',func=Pin.PWRIN,do_erc=True),
            Pin(num='12',name='TPIN-',do_erc=True),
            Pin(num='22',name='VSSOSC',func=Pin.PWRIN,do_erc=True),
            Pin(num='13',name='TPIN+',do_erc=True),
            Pin(num='23',name='OSC1',do_erc=True),
            Pin(num='14',name='RBIAS',do_erc=True),
            Pin(num='24',name='OSC2',do_erc=True),
            Pin(num='15',name='VDDTX',func=Pin.PWRIN,do_erc=True),
            Pin(num='25',name='VDDOSC',func=Pin.PWRIN,do_erc=True),
            Pin(num='16',name='TPOUT-',func=Pin.OUTPUT,do_erc=True),
            Pin(num='26',name='LEDB',func=Pin.OUTPUT,do_erc=True),
            Pin(num='17',name='TPOUT+',func=Pin.OUTPUT,do_erc=True),
            Pin(num='27',name='LEDA',func=Pin.OUTPUT,do_erc=True),
            Pin(num='18',name='VSSTX',func=Pin.PWRIN,do_erc=True),
            Pin(num='28',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='19',name='VDDRX',func=Pin.PWRIN,do_erc=True)]),
        Part(name='ENC28J60-I/ML',dest=TEMPLATE,tool=SKIDL,keywords='ENC Ethernet',description='ENC28J60 Single Chip Ethernet Interface, QFN-28+EP',ref_prefix='U',num_units=1,fplist=['QFP*'],do_erc=True,pins=[
            Pin(num='1',name='~WOL',func=Pin.OUTPUT,do_erc=True),
            Pin(num='2',name='SO',func=Pin.OUTPUT,do_erc=True),
            Pin(num='3',name='SI',do_erc=True),
            Pin(num='4',name='SCK',do_erc=True),
            Pin(num='5',name='~CS',do_erc=True),
            Pin(num='6',name='~RESET',do_erc=True),
            Pin(num='7',name='VSSRX',func=Pin.PWROUT,do_erc=True),
            Pin(num='8',name='TPIN-',do_erc=True),
            Pin(num='9',name='TPIN+',do_erc=True),
            Pin(num='10',name='RBIAS',do_erc=True),
            Pin(num='20',name='OSC2',func=Pin.OUTPUT,do_erc=True),
            Pin(num='11',name='VDDTX',func=Pin.PWRIN,do_erc=True),
            Pin(num='21',name='VDDOSC',func=Pin.PWRIN,do_erc=True),
            Pin(num='12',name='TPOUT-',func=Pin.OUTPUT,do_erc=True),
            Pin(num='22',name='LEDB',func=Pin.OUTPUT,do_erc=True),
            Pin(num='13',name='TPOUT+',func=Pin.OUTPUT,do_erc=True),
            Pin(num='23',name='LEDA',func=Pin.OUTPUT,do_erc=True),
            Pin(num='14',name='VSSTX',func=Pin.PWROUT,do_erc=True),
            Pin(num='24',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='15',name='VDDRX',func=Pin.PWRIN,do_erc=True),
            Pin(num='25',name='VCAP',do_erc=True),
            Pin(num='16',name='VDDPLL',func=Pin.PWRIN,do_erc=True),
            Pin(num='26',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='17',name='VSSPLL',func=Pin.PWRIN,do_erc=True),
            Pin(num='27',name='CLKOUT',func=Pin.OUTPUT,do_erc=True),
            Pin(num='18',name='VSSOSC',func=Pin.PWRIN,do_erc=True),
            Pin(num='28',name='~INT',func=Pin.OUTPUT,do_erc=True),
            Pin(num='19',name='OSC1',do_erc=True)]),
        Part(name='ENC28J60-I/SO',dest=TEMPLATE,tool=SKIDL,keywords='ENC Ethernet',description='ENC28J60 Single Chip Ethernet Interface, SOIC-28',ref_prefix='U',num_units=1,fplist=['SOIC*'],do_erc=True,pins=[
            Pin(num='1',name='VCAP',do_erc=True),
            Pin(num='2',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='3',name='CLKOUT',func=Pin.OUTPUT,do_erc=True),
            Pin(num='4',name='~INT',func=Pin.OUTPUT,do_erc=True),
            Pin(num='5',name='~WOL',func=Pin.OUTPUT,do_erc=True),
            Pin(num='6',name='SO',func=Pin.OUTPUT,do_erc=True),
            Pin(num='7',name='SI',do_erc=True),
            Pin(num='8',name='SCK',do_erc=True),
            Pin(num='9',name='~CS',do_erc=True),
            Pin(num='10',name='~RESET',do_erc=True),
            Pin(num='20',name='VDDPLL',func=Pin.PWRIN,do_erc=True),
            Pin(num='11',name='VSSRX',func=Pin.PWRIN,do_erc=True),
            Pin(num='21',name='VSSPLL',func=Pin.PWRIN,do_erc=True),
            Pin(num='12',name='TPIN-',do_erc=True),
            Pin(num='22',name='VSSOSC',func=Pin.PWRIN,do_erc=True),
            Pin(num='13',name='TPIN+',do_erc=True),
            Pin(num='23',name='OSC1',do_erc=True),
            Pin(num='14',name='RBIAS',do_erc=True),
            Pin(num='24',name='OSC2',do_erc=True),
            Pin(num='15',name='VDDTX',func=Pin.PWRIN,do_erc=True),
            Pin(num='25',name='VDDOSC',func=Pin.PWRIN,do_erc=True),
            Pin(num='16',name='TPOUT-',func=Pin.OUTPUT,do_erc=True),
            Pin(num='26',name='LEDB',func=Pin.OUTPUT,do_erc=True),
            Pin(num='17',name='TPOUT+',func=Pin.OUTPUT,do_erc=True),
            Pin(num='27',name='LEDA',func=Pin.OUTPUT,do_erc=True),
            Pin(num='18',name='VSSTX',func=Pin.PWRIN,do_erc=True),
            Pin(num='28',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='19',name='VDDRX',func=Pin.PWRIN,do_erc=True)]),
        Part(name='ENC28J60-I/SP',dest=TEMPLATE,tool=SKIDL,keywords='ENC Ethernet',description='ENC28J60 Single Chip Ethernet Interface, PDIP-28',ref_prefix='U',num_units=1,fplist=['DIP*', 'PDIP*'],do_erc=True,pins=[
            Pin(num='1',name='VCAP',do_erc=True),
            Pin(num='2',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='3',name='CLKOUT',func=Pin.OUTPUT,do_erc=True),
            Pin(num='4',name='~INT',func=Pin.OUTPUT,do_erc=True),
            Pin(num='5',name='~WOL',func=Pin.OUTPUT,do_erc=True),
            Pin(num='6',name='SO',func=Pin.OUTPUT,do_erc=True),
            Pin(num='7',name='SI',do_erc=True),
            Pin(num='8',name='SCK',do_erc=True),
            Pin(num='9',name='~CS',do_erc=True),
            Pin(num='10',name='~RESET',do_erc=True),
            Pin(num='20',name='VDDPLL',func=Pin.PWRIN,do_erc=True),
            Pin(num='11',name='VSSRX',func=Pin.PWRIN,do_erc=True),
            Pin(num='21',name='VSSPLL',func=Pin.PWRIN,do_erc=True),
            Pin(num='12',name='TPIN-',do_erc=True),
            Pin(num='22',name='VSSOSC',func=Pin.PWRIN,do_erc=True),
            Pin(num='13',name='TPIN+',do_erc=True),
            Pin(num='23',name='OSC1',do_erc=True),
            Pin(num='14',name='RBIAS',do_erc=True),
            Pin(num='24',name='OSC2',do_erc=True),
            Pin(num='15',name='VDDTX',func=Pin.PWRIN,do_erc=True),
            Pin(num='25',name='VDDOSC',func=Pin.PWRIN,do_erc=True),
            Pin(num='16',name='TPOUT-',func=Pin.OUTPUT,do_erc=True),
            Pin(num='26',name='LEDB',func=Pin.OUTPUT,do_erc=True),
            Pin(num='17',name='TPOUT+',func=Pin.OUTPUT,do_erc=True),
            Pin(num='27',name='LEDA',func=Pin.OUTPUT,do_erc=True),
            Pin(num='18',name='VSSTX',func=Pin.PWRIN,do_erc=True),
            Pin(num='28',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='19',name='VDDRX',func=Pin.PWRIN,do_erc=True)]),
        Part(name='KSZ9031RNXCA',dest=TEMPLATE,tool=SKIDL,keywords='ETHERNET PHY RGMII WOL IEEE 802.3 MICROCHIP',description='10/1000/1000Mbps Ethernet Transciever with RGMII Interface',ref_prefix='U',num_units=1,fplist=['QFN*1EP*7x7mm*Pitch0.5mm*'],do_erc=True,pins=[
            Pin(num='1',name='AVDDH',func=Pin.PWRIN,do_erc=True),
            Pin(num='2',name='TXRXP_A',do_erc=True),
            Pin(num='3',name='TXRXM_A',do_erc=True),
            Pin(num='4',name='AVDDL',func=Pin.PWRIN,do_erc=True),
            Pin(num='5',name='TXRXP_B',do_erc=True),
            Pin(num='6',name='TXRXM_B',do_erc=True),
            Pin(num='7',name='TXRXP_C',do_erc=True),
            Pin(num='8',name='TXRXP_C',do_erc=True),
            Pin(num='9',name='AVDDL',func=Pin.PWRIN,do_erc=True),
            Pin(num='10',name='TXRXP_D',do_erc=True),
            Pin(num='20',name='TXD1',do_erc=True),
            Pin(num='30',name='DVDDL',func=Pin.PWRIN,do_erc=True),
            Pin(num='40',name='DVDDH',func=Pin.PWRIN,do_erc=True),
            Pin(num='11',name='TXRXM_D',do_erc=True),
            Pin(num='21',name='TXD2',do_erc=True),
            Pin(num='31',name='RXD1/MODE1',do_erc=True),
            Pin(num='41',name='CLK125_NDO/LED_MODE',do_erc=True),
            Pin(num='12',name='AVDDH',func=Pin.PWRIN,do_erc=True),
            Pin(num='22',name='TXD3',do_erc=True),
            Pin(num='32',name='RXD0/MODE0',do_erc=True),
            Pin(num='42',name='RESET_N',do_erc=True),
            Pin(num='13',name='NC',func=Pin.NOCONNECT,do_erc=True),
            Pin(num='23',name='DVDDL',func=Pin.PWRIN,do_erc=True),
            Pin(num='33',name='RX_DV/CLK125_EN',do_erc=True),
            Pin(num='43',name='LDO_O',do_erc=True),
            Pin(num='14',name='DVDDL',func=Pin.PWRIN,do_erc=True),
            Pin(num='24',name='GTX_CLK',do_erc=True),
            Pin(num='34',name='DVDDH',func=Pin.PWRIN,do_erc=True),
            Pin(num='44',name='AVDDL_PLL',func=Pin.PWRIN,do_erc=True),
            Pin(num='15',name='LED2/PHYAD1',func=Pin.BIDIR,do_erc=True),
            Pin(num='25',name='TX_EN',do_erc=True),
            Pin(num='35',name='RX_CLK/PHYAD2',do_erc=True),
            Pin(num='45',name='XO',do_erc=True),
            Pin(num='16',name='DVDDH',func=Pin.PWRIN,do_erc=True),
            Pin(num='26',name='DVDDL',func=Pin.PWRIN,do_erc=True),
            Pin(num='36',name='MDC',do_erc=True),
            Pin(num='46',name='XI',do_erc=True),
            Pin(num='17',name='LED1/PHAD0/PME_N1',func=Pin.BIDIR,do_erc=True),
            Pin(num='27',name='RXD3/MODE3',do_erc=True),
            Pin(num='37',name='MDIO',do_erc=True),
            Pin(num='47',name='NC',func=Pin.NOCONNECT,do_erc=True),
            Pin(num='18',name='DVDDL',func=Pin.PWRIN,do_erc=True),
            Pin(num='28',name='RXD2/MODE2',do_erc=True),
            Pin(num='38',name='INT_N/PME_N2',do_erc=True),
            Pin(num='48',name='ISET',func=Pin.OUTPUT,do_erc=True),
            Pin(num='19',name='TXD0',do_erc=True),
            Pin(num='29',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='39',name='DVDDL',func=Pin.PWRIN,do_erc=True),
            Pin(num='49',name='PAD_GND',func=Pin.PWRIN,do_erc=True)]),
        Part(name='LAN8720A',dest=TEMPLATE,tool=SKIDL,keywords='ETH PHY RMII',description='LAN8720 Ethernet PHY with RMII interface',ref_prefix='U',num_units=1,fplist=['QFN*1EP*4x4mm*Pitch0.5mm*'],do_erc=True,pins=[
            Pin(num='1',name='VDD2A',func=Pin.PWRIN,do_erc=True),
            Pin(num='2',name='LED2/nINTSEL',func=Pin.BIDIR,do_erc=True),
            Pin(num='3',name='LED1/REGOFF',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='XTAL2',func=Pin.PASSIVE,do_erc=True),
            Pin(num='5',name='XTAL1/CLKIN',func=Pin.PASSIVE,do_erc=True),
            Pin(num='6',name='VDDCR',func=Pin.PWRIN,do_erc=True),
            Pin(num='7',name='RXD1/MODE1',func=Pin.OUTPUT,do_erc=True),
            Pin(num='8',name='RXD0/MODE0',func=Pin.OUTPUT,do_erc=True),
            Pin(num='9',name='VDDIO',func=Pin.PWRIN,do_erc=True),
            Pin(num='10',name='RXER/PHYAD0',func=Pin.OUTPUT,do_erc=True),
            Pin(num='20',name='TXN',func=Pin.OUTPUT,do_erc=True),
            Pin(num='11',name='CRS_DV/MODE2',func=Pin.OUTPUT,do_erc=True),
            Pin(num='21',name='TXP',func=Pin.OUTPUT,do_erc=True),
            Pin(num='12',name='MDIO',func=Pin.BIDIR,do_erc=True),
            Pin(num='22',name='RXN',func=Pin.OUTPUT,do_erc=True),
            Pin(num='13',name='MDC',do_erc=True),
            Pin(num='23',name='RXP',func=Pin.OUTPUT,do_erc=True),
            Pin(num='14',name='INT/REFCLKO',func=Pin.OUTPUT,do_erc=True),
            Pin(num='24',name='RBIAS',do_erc=True),
            Pin(num='15',name='RST',do_erc=True),
            Pin(num='25',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='16',name='TXEN',do_erc=True),
            Pin(num='17',name='TXD0',do_erc=True),
            Pin(num='18',name='TXD1',do_erc=True),
            Pin(num='19',name='VDD1A',func=Pin.PWRIN,do_erc=True)]),
        Part(name='MCP2050-330-E/MQ',dest=TEMPLATE,tool=SKIDL,keywords='LIN transceiver regulator',description='LIN Transceiver with Voltage Regulator, 5V, QFN',ref_prefix='U',num_units=1,fplist=['QFN*1EP*5x5mm*Pitch0.65mm*'],do_erc=True,aliases=['MCP2050-500-E/MQ'],pins=[
            Pin(num='1',name='RXD',func=Pin.OUTPUT,do_erc=True),
            Pin(num='2',name='CS/LWAKE',do_erc=True),
            Pin(num='3',name='VREG',func=Pin.PWROUT,do_erc=True),
            Pin(num='4',name='TXD',do_erc=True),
            Pin(num='5',name='~RESET',func=Pin.OUTPUT,do_erc=True),
            Pin(num='6',name='NC',func=Pin.NOCONNECT,do_erc=True),
            Pin(num='7',name='LBUS',func=Pin.OPENCOLL,do_erc=True),
            Pin(num='8',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='9',name='NC',func=Pin.NOCONNECT,do_erc=True),
            Pin(num='10',name='NC',func=Pin.NOCONNECT,do_erc=True),
            Pin(num='20',name='NC',func=Pin.NOCONNECT,do_erc=True),
            Pin(num='11',name='NC',func=Pin.NOCONNECT,do_erc=True),
            Pin(num='21',name='PAD',func=Pin.NOCONNECT,do_erc=True),
            Pin(num='12',name='VBB',func=Pin.PWRIN,do_erc=True),
            Pin(num='13',name='FAULT/TXE',func=Pin.OPENCOLL,do_erc=True),
            Pin(num='14',name='WWDTSELECT',do_erc=True),
            Pin(num='15',name='~WWDTTRIG',do_erc=True),
            Pin(num='16',name='NC',func=Pin.NOCONNECT,do_erc=True),
            Pin(num='17',name='~WWDTRESET',func=Pin.OUTPUT,do_erc=True),
            Pin(num='18',name='VBAT_RATIO',func=Pin.OUTPUT,do_erc=True),
            Pin(num='19',name='NC',func=Pin.NOCONNECT,do_erc=True)]),
        Part(name='MCP2050-330-E/P',dest=TEMPLATE,tool=SKIDL,keywords='LIN transceiver regulator',description='LIN Transceiver with Voltage Regulator, 5V, PDIP',ref_prefix='U',num_units=1,fplist=['DIP*W7.62mm*'],do_erc=True,aliases=['MCP2050-500-E/P'],pins=[
            Pin(num='1',name='VBAT_RATIO',func=Pin.OUTPUT,do_erc=True),
            Pin(num='2',name='RXD',func=Pin.OUTPUT,do_erc=True),
            Pin(num='3',name='CS/LWAKE',do_erc=True),
            Pin(num='4',name='VREG',func=Pin.PWROUT,do_erc=True),
            Pin(num='5',name='TXD',do_erc=True),
            Pin(num='6',name='~RESET',func=Pin.OUTPUT,do_erc=True),
            Pin(num='7',name='NC',func=Pin.NOCONNECT,do_erc=True),
            Pin(num='8',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='9',name='LBUS',func=Pin.OPENCOLL,do_erc=True),
            Pin(num='10',name='VBB',func=Pin.PWRIN,do_erc=True),
            Pin(num='11',name='FAULT/TXE',func=Pin.OPENCOLL,do_erc=True),
            Pin(num='12',name='WWDTSELECT',do_erc=True),
            Pin(num='13',name='~WWDTTRIG',do_erc=True),
            Pin(num='14',name='~WWDTRESET',func=Pin.OUTPUT,do_erc=True)]),
        Part(name='MCP2050-330-E/SL',dest=TEMPLATE,tool=SKIDL,keywords='LIN transceiver regulator',description='LIN Transceiver with Voltage Regulator, 5V, SOIC',ref_prefix='U',num_units=1,fplist=['SOIC*3.9x8.7mm*Pitch1.27mm*'],do_erc=True,aliases=['MCP2050-500-E/SL'],pins=[
            Pin(num='1',name='VBAT_RATIO',func=Pin.OUTPUT,do_erc=True),
            Pin(num='2',name='RXD',func=Pin.OUTPUT,do_erc=True),
            Pin(num='3',name='CS/LWAKE',do_erc=True),
            Pin(num='4',name='VREG',func=Pin.PWROUT,do_erc=True),
            Pin(num='5',name='TXD',do_erc=True),
            Pin(num='6',name='~RESET',func=Pin.OUTPUT,do_erc=True),
            Pin(num='7',name='NC',func=Pin.NOCONNECT,do_erc=True),
            Pin(num='8',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='9',name='LBUS',func=Pin.OPENCOLL,do_erc=True),
            Pin(num='10',name='VBB',func=Pin.PWRIN,do_erc=True),
            Pin(num='11',name='FAULT/TXE',func=Pin.OPENCOLL,do_erc=True),
            Pin(num='12',name='WWDTSELECT',do_erc=True),
            Pin(num='13',name='~WWDTTRIG',do_erc=True),
            Pin(num='14',name='~WWDTRESET',func=Pin.OUTPUT,do_erc=True)]),
        Part(name='MCP23008',dest=TEMPLATE,tool=SKIDL,keywords='IO Expander I²C IIC I2C',description='8-Bit I/O Expander with I²C Interface (PDIP/SOIC)',ref_prefix='U',num_units=1,fplist=['DIP-18', 'SOIC-18'],do_erc=True,pins=[
            Pin(num='1',name='SCL',do_erc=True),
            Pin(num='2',name='SDA',func=Pin.BIDIR,do_erc=True),
            Pin(num='3',name='A2',do_erc=True),
            Pin(num='4',name='A1',do_erc=True),
            Pin(num='5',name='A0',do_erc=True),
            Pin(num='6',name='~RESET',do_erc=True),
            Pin(num='8',name='INT',func=Pin.OUTPUT,do_erc=True),
            Pin(num='9',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='10',name='GPB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='11',name='GPB1',func=Pin.BIDIR,do_erc=True),
            Pin(num='12',name='GPB2',func=Pin.BIDIR,do_erc=True),
            Pin(num='13',name='GPB3',func=Pin.BIDIR,do_erc=True),
            Pin(num='14',name='GPB4',func=Pin.BIDIR,do_erc=True),
            Pin(num='15',name='GPB5',func=Pin.BIDIR,do_erc=True),
            Pin(num='16',name='GPB6',func=Pin.BIDIR,do_erc=True),
            Pin(num='17',name='GPB7',func=Pin.BIDIR,do_erc=True),
            Pin(num='18',name='VCC',func=Pin.PWRIN,do_erc=True)]),
        Part(name='MCP23008_SSOP',dest=TEMPLATE,tool=SKIDL,keywords='IO Expander I²C IIC I2C',description='8-Bit I/O Expander with I²C Interface (SSOP)',ref_prefix='U',num_units=1,fplist=['SSOP-20'],do_erc=True,pins=[
            Pin(num='1',name='SCL',do_erc=True),
            Pin(num='2',name='SDA',func=Pin.BIDIR,do_erc=True),
            Pin(num='3',name='A2',do_erc=True),
            Pin(num='4',name='A1',do_erc=True),
            Pin(num='5',name='A0',do_erc=True),
            Pin(num='6',name='~RESET',do_erc=True),
            Pin(num='8',name='INT',func=Pin.OUTPUT,do_erc=True),
            Pin(num='9',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='20',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='12',name='GPB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='13',name='GPB1',func=Pin.BIDIR,do_erc=True),
            Pin(num='14',name='GPB2',func=Pin.BIDIR,do_erc=True),
            Pin(num='15',name='GPB3',func=Pin.BIDIR,do_erc=True),
            Pin(num='16',name='GPB4',func=Pin.BIDIR,do_erc=True),
            Pin(num='17',name='GPB5',func=Pin.BIDIR,do_erc=True),
            Pin(num='18',name='GPB6',func=Pin.BIDIR,do_erc=True),
            Pin(num='19',name='GPB7',func=Pin.BIDIR,do_erc=True)]),
        Part(name='MCP23016',dest=TEMPLATE,tool=SKIDL,keywords='IO Expander I²C IIC I2C',description='16-Bit I/O Expander with I²C Interface (PDIP/SOIC/SSOP)',ref_prefix='U',num_units=1,fplist=['DIP-28_W7.62mm*', 'SOIC-28', 'SSOP-28'],do_erc=True,pins=[
            Pin(num='1',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='2',name='GPB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='3',name='GPB1',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='GPB2',func=Pin.BIDIR,do_erc=True),
            Pin(num='5',name='GPB3',func=Pin.BIDIR,do_erc=True),
            Pin(num='6',name='~INT',func=Pin.OUTPUT,do_erc=True),
            Pin(num='7',name='GPB4',func=Pin.BIDIR,do_erc=True),
            Pin(num='9',name='CLK',do_erc=True),
            Pin(num='10',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='10',name='TP',func=Pin.OUTPUT,do_erc=True),
            Pin(num='20',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='11',name='GPB5',func=Pin.BIDIR,do_erc=True),
            Pin(num='21',name='GPA0',func=Pin.BIDIR,do_erc=True),
            Pin(num='12',name='GPB6',func=Pin.BIDIR,do_erc=True),
            Pin(num='22',name='GPA1',func=Pin.BIDIR,do_erc=True),
            Pin(num='13',name='GPB7',func=Pin.BIDIR,do_erc=True),
            Pin(num='23',name='GPA2',func=Pin.BIDIR,do_erc=True),
            Pin(num='14',name='SCL',do_erc=True),
            Pin(num='24',name='GPA3',func=Pin.BIDIR,do_erc=True),
            Pin(num='15',name='SDA',func=Pin.BIDIR,do_erc=True),
            Pin(num='25',name='GPA4',func=Pin.BIDIR,do_erc=True),
            Pin(num='16',name='A0',do_erc=True),
            Pin(num='26',name='GPA5',func=Pin.BIDIR,do_erc=True),
            Pin(num='17',name='A1',do_erc=True),
            Pin(num='27',name='GPA6',func=Pin.BIDIR,do_erc=True),
            Pin(num='18',name='A2',do_erc=True),
            Pin(num='28',name='GPA7',func=Pin.BIDIR,do_erc=True),
            Pin(num='19',name='GND',func=Pin.PWRIN,do_erc=True)]),
        Part(name='MCP23017',dest=TEMPLATE,tool=SKIDL,keywords='IO Expander I²C IIC I2C',description='16-Bit I/O Expander with I²C Interface (PDIP/SOIC/SSOP)',ref_prefix='U',num_units=1,fplist=['DIP-28_W7.62mm*', 'SOIC-28', 'SSOP-28'],do_erc=True,pins=[
            Pin(num='1',name='GPB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='2',name='GPB1',func=Pin.BIDIR,do_erc=True),
            Pin(num='3',name='GPB2',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='GPB3',func=Pin.BIDIR,do_erc=True),
            Pin(num='5',name='GPB4',func=Pin.BIDIR,do_erc=True),
            Pin(num='6',name='GPB5',func=Pin.BIDIR,do_erc=True),
            Pin(num='7',name='GPB6',func=Pin.BIDIR,do_erc=True),
            Pin(num='8',name='GPB7',func=Pin.BIDIR,do_erc=True),
            Pin(num='9',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='10',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='20',name='INTA',func=Pin.OUTPUT,do_erc=True),
            Pin(num='21',name='GPA0',func=Pin.BIDIR,do_erc=True),
            Pin(num='12',name='SCL',do_erc=True),
            Pin(num='22',name='GPA1',func=Pin.BIDIR,do_erc=True),
            Pin(num='13',name='SDA',func=Pin.BIDIR,do_erc=True),
            Pin(num='23',name='GPA2',func=Pin.BIDIR,do_erc=True),
            Pin(num='24',name='GPA3',func=Pin.BIDIR,do_erc=True),
            Pin(num='15',name='A0',do_erc=True),
            Pin(num='25',name='GPA4',func=Pin.BIDIR,do_erc=True),
            Pin(num='16',name='A1',do_erc=True),
            Pin(num='26',name='GPA5',func=Pin.BIDIR,do_erc=True),
            Pin(num='17',name='A2',do_erc=True),
            Pin(num='27',name='GPA6',func=Pin.BIDIR,do_erc=True),
            Pin(num='18',name='~RESET',do_erc=True),
            Pin(num='28',name='GPA7',func=Pin.BIDIR,do_erc=True),
            Pin(num='19',name='INTB',func=Pin.OUTPUT,do_erc=True)]),
        Part(name='MCP23S08',dest=TEMPLATE,tool=SKIDL,keywords='IO Expander SPI',description='8-Bit I/O Expander with SPI Interface (PDIP/SOIC)',ref_prefix='U',num_units=1,fplist=['DIP-18', 'SOIC-18'],do_erc=True,pins=[
            Pin(num='1',name='SCK',do_erc=True),
            Pin(num='2',name='SI',do_erc=True),
            Pin(num='3',name='SO',func=Pin.OUTPUT,do_erc=True),
            Pin(num='4',name='A1',do_erc=True),
            Pin(num='5',name='A0',do_erc=True),
            Pin(num='6',name='~RESET',do_erc=True),
            Pin(num='7',name='~CS',do_erc=True),
            Pin(num='8',name='INT',func=Pin.OUTPUT,do_erc=True),
            Pin(num='9',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='10',name='GPB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='11',name='GPB1',func=Pin.BIDIR,do_erc=True),
            Pin(num='12',name='GPB2',func=Pin.BIDIR,do_erc=True),
            Pin(num='13',name='GPB3',func=Pin.BIDIR,do_erc=True),
            Pin(num='14',name='GPB4',func=Pin.BIDIR,do_erc=True),
            Pin(num='15',name='GPB5',func=Pin.BIDIR,do_erc=True),
            Pin(num='16',name='GPB6',func=Pin.BIDIR,do_erc=True),
            Pin(num='17',name='GPB7',func=Pin.BIDIR,do_erc=True),
            Pin(num='18',name='VCC',func=Pin.PWRIN,do_erc=True)]),
        Part(name='MCP23S08_SSOP',dest=TEMPLATE,tool=SKIDL,keywords='IO Expander SPI',description='8-Bit I/O Expander with SPI Interface (SSOP)',ref_prefix='U',num_units=1,fplist=['SSOP-20'],do_erc=True,pins=[
            Pin(num='1',name='SCK',do_erc=True),
            Pin(num='2',name='SI',do_erc=True),
            Pin(num='3',name='SO',func=Pin.OUTPUT,do_erc=True),
            Pin(num='4',name='A1',do_erc=True),
            Pin(num='5',name='A0',do_erc=True),
            Pin(num='6',name='~RESET',do_erc=True),
            Pin(num='7',name='~CS',do_erc=True),
            Pin(num='8',name='INT',func=Pin.OUTPUT,do_erc=True),
            Pin(num='9',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='20',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='12',name='GPB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='13',name='GPB1',func=Pin.BIDIR,do_erc=True),
            Pin(num='14',name='GPB2',func=Pin.BIDIR,do_erc=True),
            Pin(num='15',name='GPB3',func=Pin.BIDIR,do_erc=True),
            Pin(num='16',name='GPB4',func=Pin.BIDIR,do_erc=True),
            Pin(num='17',name='GPB5',func=Pin.BIDIR,do_erc=True),
            Pin(num='18',name='GPB6',func=Pin.BIDIR,do_erc=True),
            Pin(num='19',name='GPB7',func=Pin.BIDIR,do_erc=True)]),
        Part(name='MCP23S17',dest=TEMPLATE,tool=SKIDL,keywords='IO Expander SPI',description='16-Bit I/O Expander with SPI Interface (PDIP/SOIC/SSOP)',ref_prefix='U',num_units=1,fplist=['DIP-28_W7.62mm*', 'SOIC-28', 'SSOP-28'],do_erc=True,pins=[
            Pin(num='1',name='GPB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='2',name='GPB1',func=Pin.BIDIR,do_erc=True),
            Pin(num='3',name='GPB2',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='GPB3',func=Pin.BIDIR,do_erc=True),
            Pin(num='5',name='GPB4',func=Pin.BIDIR,do_erc=True),
            Pin(num='6',name='GPB5',func=Pin.BIDIR,do_erc=True),
            Pin(num='7',name='GPB6',func=Pin.BIDIR,do_erc=True),
            Pin(num='8',name='GPB7',func=Pin.BIDIR,do_erc=True),
            Pin(num='9',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='10',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='20',name='INTA',func=Pin.OUTPUT,do_erc=True),
            Pin(num='11',name='~CS',do_erc=True),
            Pin(num='21',name='GPA0',func=Pin.BIDIR,do_erc=True),
            Pin(num='12',name='SCK',do_erc=True),
            Pin(num='22',name='GPA1',func=Pin.BIDIR,do_erc=True),
            Pin(num='13',name='SI',func=Pin.OUTPUT,do_erc=True),
            Pin(num='23',name='GPA2',func=Pin.BIDIR,do_erc=True),
            Pin(num='14',name='SO',func=Pin.OUTPUT,do_erc=True),
            Pin(num='24',name='GPA3',func=Pin.BIDIR,do_erc=True),
            Pin(num='15',name='A0',do_erc=True),
            Pin(num='25',name='GPA4',func=Pin.BIDIR,do_erc=True),
            Pin(num='16',name='A1',do_erc=True),
            Pin(num='26',name='GPA5',func=Pin.BIDIR,do_erc=True),
            Pin(num='17',name='A2',do_erc=True),
            Pin(num='27',name='GPA6',func=Pin.BIDIR,do_erc=True),
            Pin(num='18',name='~RESET',do_erc=True),
            Pin(num='28',name='GPA7',func=Pin.BIDIR,do_erc=True),
            Pin(num='19',name='INTB',func=Pin.OUTPUT,do_erc=True)]),
        Part(name='MCP2515-E/ST',dest=TEMPLATE,tool=SKIDL,keywords='CAN Controller SPI',description='Stand-Alone CAN Controller with SPI Interface, TSSOP-20, Industrial temperature range',ref_prefix='U',num_units=1,fplist=['TSSOP*'],do_erc=True,aliases=['MCP2515-I/ST'],pins=[
            Pin(num='1',name='TXCAN',func=Pin.OUTPUT,do_erc=True),
            Pin(num='2',name='RXCAN',do_erc=True),
            Pin(num='3',name='CLKOUT/SOF',func=Pin.OUTPUT,do_erc=True),
            Pin(num='4',name='~TX0RTS',do_erc=True),
            Pin(num='5',name='~TX1RTS',do_erc=True),
            Pin(num='6',name='NC',func=Pin.NOCONNECT,do_erc=True),
            Pin(num='7',name='~TX2RTS',do_erc=True),
            Pin(num='8',name='OSC2',func=Pin.OUTPUT,do_erc=True),
            Pin(num='9',name='OSC1',do_erc=True),
            Pin(num='10',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='20',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='11',name='~RX1BF',func=Pin.OUTPUT,do_erc=True),
            Pin(num='12',name='~RX0BF',func=Pin.OUTPUT,do_erc=True),
            Pin(num='13',name='~INT',func=Pin.OUTPUT,do_erc=True),
            Pin(num='14',name='SCK',do_erc=True),
            Pin(num='15',name='NC',func=Pin.NOCONNECT,do_erc=True),
            Pin(num='16',name='SI',do_erc=True),
            Pin(num='17',name='SO',func=Pin.OUTPUT,do_erc=True),
            Pin(num='18',name='~CS',do_erc=True),
            Pin(num='19',name='~RESET',do_erc=True)]),
        Part(name='MCP7940N',dest=TEMPLATE,tool=SKIDL,keywords='realtime clock RTC',description='Real-Time Clock, I2C, Battery Backup',ref_prefix='U',num_units=1,fplist=['SOIC*3.9x4.9mm*Pitch1.27mm*', 'TSSOP*4.4x3mm*Pitch0.65mm*', 'MSOP*3x3mm*Pitch0.65mm*', 'DFN*3x2mm*Pitch0.5mm*', 'DIP*W7.62mm*'],do_erc=True,pins=[
            Pin(num='1',name='X1',do_erc=True),
            Pin(num='2',name='X2',func=Pin.OUTPUT,do_erc=True),
            Pin(num='3',name='VBAT',func=Pin.PWRIN,do_erc=True),
            Pin(num='4',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='5',name='SDA',func=Pin.BIDIR,do_erc=True),
            Pin(num='6',name='SCL',do_erc=True),
            Pin(num='7',name='MFP',func=Pin.OPENCOLL,do_erc=True),
            Pin(num='8',name='VCC',func=Pin.PWRIN,do_erc=True)]),
        Part(name='USB3300',dest=TEMPLATE,tool=SKIDL,keywords='USB OTG Hi-Speed PHY ULPI Interface',description='Hi-Speed USB Host, Device or OTG PHY with ULPI Interface',ref_prefix='U',num_units=1,fplist=['*QFN*32*'],do_erc=True,pins=[
            Pin(num='1',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='2',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='3',name='CPEN',func=Pin.OUTPUT,do_erc=True),
            Pin(num='4',name='VBUS',func=Pin.PWRIN,do_erc=True),
            Pin(num='5',name='ID',do_erc=True),
            Pin(num='6',name='VDD3.3',func=Pin.PWRIN,do_erc=True),
            Pin(num='7',name='DP',func=Pin.BIDIR,do_erc=True),
            Pin(num='8',name='DM',func=Pin.BIDIR,do_erc=True),
            Pin(num='9',name='RESET',do_erc=True),
            Pin(num='10',name='EXTVBUS',do_erc=True),
            Pin(num='20',name='DATA4',func=Pin.BIDIR,do_erc=True),
            Pin(num='30',name='VDD3.3',func=Pin.PWRIN,do_erc=True),
            Pin(num='11',name='NXT',func=Pin.OUTPUT,do_erc=True),
            Pin(num='21',name='DATA3',func=Pin.BIDIR,do_erc=True),
            Pin(num='31',name='REG_EN',func=Pin.BIDIR,do_erc=True),
            Pin(num='12',name='DIR',func=Pin.OUTPUT,do_erc=True),
            Pin(num='22',name='DATA2',func=Pin.BIDIR,do_erc=True),
            Pin(num='32',name='RBIAS',func=Pin.PASSIVE,do_erc=True),
            Pin(num='13',name='STP',do_erc=True),
            Pin(num='23',name='DATA1',func=Pin.BIDIR,do_erc=True),
            Pin(num='33',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='14',name='CLKOUT',func=Pin.OUTPUT,do_erc=True),
            Pin(num='24',name='DATA0',func=Pin.BIDIR,do_erc=True),
            Pin(num='15',name='VDD1.8',func=Pin.PWROUT,do_erc=True),
            Pin(num='25',name='VDD3.3',func=Pin.PWRIN,do_erc=True),
            Pin(num='16',name='VDD3.3',func=Pin.PWRIN,do_erc=True),
            Pin(num='26',name='VDD1.8',func=Pin.PWROUT,do_erc=True),
            Pin(num='17',name='DATA7',func=Pin.BIDIR,do_erc=True),
            Pin(num='27',name='XO',func=Pin.OUTPUT,do_erc=True),
            Pin(num='18',name='DATA6',func=Pin.BIDIR,do_erc=True),
            Pin(num='28',name='XI',do_erc=True),
            Pin(num='19',name='DATA5',func=Pin.BIDIR,do_erc=True),
            Pin(num='29',name='VDDA1.8',func=Pin.PWROUT,do_erc=True)])])
