/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.stat.distribution;

import breeze.generic.UFunc;
import breeze.linalg.DenseMatrix;
import breeze.linalg.DenseMatrix$;
import breeze.linalg.DenseVector;
import breeze.linalg.DenseVector$;
import breeze.linalg.ImmutableNumericOps;
import breeze.linalg.Tensor$;
import breeze.linalg.Transpose$;
import breeze.linalg.Vector$;
import breeze.linalg.diag$;
import breeze.linalg.eigSym;
import breeze.linalg.eigSym$;
import breeze.linalg.max$;
import breeze.storage.Zero;
import java.io.Serializable;
import org.apache.spark.annotation.DeveloperApi;
import org.apache.spark.ml.impl.Utils$;
import org.apache.spark.ml.linalg.Matrices$;
import org.apache.spark.ml.linalg.Matrix;
import org.apache.spark.ml.linalg.Vector;
import org.apache.spark.ml.linalg.Vectors$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.math.Numeric;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction1;

@DeveloperApi
@ScalaSignature(bytes="\u0006\u0001\u0005\u0015a\u0001\u0002\t\u0012\u0001yA\u0001\u0002\u000b\u0001\u0003\u0006\u0004%\t!\u000b\u0005\ts\u0001\u0011\t\u0011)A\u0005U!A1\b\u0001BC\u0002\u0013\u0005A\b\u0003\u0005B\u0001\t\u0005\t\u0015!\u0003>\u0011\u0015\u0019\u0005\u0001\"\u0001E\u0011\u0019\u0019\u0005\u0001\"\u0001\u0016\u0019\"AA\f\u0001EC\u0002\u0013%Q\f\u0003\u0006c\u0001A\u0005\tr1Q\u0005\n\rD\u0001b\u001a\u0001\t\u0006\u0004%I\u0001\u001b\u0005\tU\u0002A)\u0019!C\u0005W\")Q\u000e\u0001C\u0001]\")!\u000f\u0001C\u0001g\"1Q\u000e\u0001C\u0001+YDaA\u001d\u0001\u0005\u0002UQ\b\"\u0002?\u0001\t\u0013\u0019'\u0001F'vYRLg/\u0019:jCR,w)Y;tg&\fgN\u0003\u0002\u0013'\u0005aA-[:ue&\u0014W\u000f^5p]*\u0011A#F\u0001\u0005gR\fGO\u0003\u0002\u0017/\u0005\u0011Q\u000e\u001c\u0006\u00031e\tQa\u001d9be.T!AG\u000e\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005a\u0012aA8sO\u000e\u00011c\u0001\u0001 KA\u0011\u0001eI\u0007\u0002C)\t!%A\u0003tG\u0006d\u0017-\u0003\u0002%C\t1\u0011I\\=SK\u001a\u0004\"\u0001\t\u0014\n\u0005\u001d\n#\u0001D*fe&\fG.\u001b>bE2,\u0017\u0001B7fC:,\u0012A\u000b\t\u0003W9j\u0011\u0001\f\u0006\u0003[U\ta\u0001\\5oC2<\u0017BA\u0018-\u0005\u00191Vm\u0019;pe\"\u001a\u0011!M\u001c\u0011\u0005I*T\"A\u001a\u000b\u0005Q:\u0012AC1o]>$\u0018\r^5p]&\u0011ag\r\u0002\u0006'&t7-Z\u0011\u0002q\u0005)!G\f\u0019/a\u0005)Q.Z1oA!\u001a!!M\u001c\u0002\u0007\r|g/F\u0001>!\tYc(\u0003\u0002@Y\t1Q*\u0019;sSbD3aA\u00198\u0003\u0011\u0019wN\u001e\u0011)\u0007\u0011\tt'\u0001\u0004=S:LGO\u0010\u000b\u0004\u000b\u001eK\u0005C\u0001$\u0001\u001b\u0005\t\u0002\"\u0002\u0015\u0006\u0001\u0004Q\u0003fA$2o!)1(\u0002a\u0001{!\u001a\u0011*M\u001c)\u0007\u0015\tt\u0007F\u0002F\u001bbCQ\u0001\u000b\u0004A\u00029\u00032aT*V\u001b\u0005\u0001&BA\u0017R\u0015\u0005\u0011\u0016A\u00022sK\u0016TX-\u0003\u0002U!\nYA)\u001a8tKZ+7\r^8s!\t\u0001c+\u0003\u0002XC\t1Ai\\;cY\u0016DQa\u000f\u0004A\u0002e\u00032a\u0014.V\u0013\tY\u0006KA\u0006EK:\u001cX-T1ue&D\u0018\u0001\u00032sK\u0016TX-T;\u0016\u00039C#aB0\u0011\u0005\u0001\u0002\u0017BA1\"\u0005%!(/\u00198tS\u0016tG/A\u0002yIE*\u0012\u0001\u001a\t\u0005A\u0015LV+\u0003\u0002gC\t1A+\u001e9mKJ\nAB]8piNKw-\\1J]Z,\u0012!\u0017\u0015\u0003\u0013}\u000b\u0011!^\u000b\u0002+\"\u0012!bX\u0001\u0004a\u00124GCA+p\u0011\u0015\u00018\u00021\u0001+\u0003\u0005A\bfA\u00062o\u00051An\\4qI\u001a$\"!\u0016;\t\u000bAd\u0001\u0019\u0001\u0016)\u00071\tt\u0007\u0006\u0002Vo\")\u0001/\u0004a\u0001qB\u0019q*_+\n\u0005=\u0002FCA+|\u0011\u0015\u0001h\u00021\u0001y\u0003q\u0019\u0017\r\\2vY\u0006$XmQ8wCJL\u0017M\\2f\u0007>t7\u000f^1oiND#\u0001\u0001@\u0011\u0005Iz\u0018bAA\u0001g\taA)\u001a<fY>\u0004XM]!qS\"\u001a\u0001!M\u001c")
public class MultivariateGaussian
implements scala.Serializable {
    private transient DenseVector<Object> breezeMu;
    private Tuple2<DenseMatrix<Object>, Object> x$1;
    private transient DenseMatrix<Object> rootSigmaInv;
    private transient double u;
    private final Vector mean;
    private final Matrix cov;
    private volatile transient byte bitmap$trans$0;
    private volatile boolean bitmap$0;

    public Vector mean() {
        return this.mean;
    }

    public Matrix cov() {
        return this.cov;
    }

    private DenseVector<Object> breezeMu$lzycompute() {
        MultivariateGaussian multivariateGaussian = this;
        synchronized (multivariateGaussian) {
            if ((byte)(this.bitmap$trans$0 & 1) == 0) {
                this.breezeMu = this.mean().asBreeze().toDenseVector$mcD$sp(ClassTag$.MODULE$.Double());
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 1);
            }
        }
        return this.breezeMu;
    }

    private DenseVector<Object> breezeMu() {
        return (byte)(this.bitmap$trans$0 & 1) == 0 ? this.breezeMu$lzycompute() : this.breezeMu;
    }

    private Tuple2<DenseMatrix<Object>, Object> x$1$lzycompute() {
        block5: {
            MultivariateGaussian multivariateGaussian = this;
            synchronized (multivariateGaussian) {
                double u;
                DenseMatrix rootSigmaInv;
                block7: {
                    Tuple2<DenseMatrix<Object>, Object> tuple2;
                    block6: {
                        if (this.bitmap$0) break block5;
                        tuple2 = this.calculateCovarianceConstants();
                        if (tuple2 == null) break block6;
                        rootSigmaInv = (DenseMatrix)tuple2._1();
                        u = tuple2._2$mcD$sp();
                        if (rootSigmaInv != null) break block7;
                    }
                    throw new MatchError(tuple2);
                }
                DenseMatrix denseMatrix = rootSigmaInv;
                double d = u;
                Tuple2 tuple2 = new Tuple2((Object)denseMatrix, (Object)BoxesRunTime.boxToDouble((double)d));
                this.x$1 = tuple2;
                this.bitmap$0 = true;
            }
        }
        return this.x$1;
    }

    private /* synthetic */ Tuple2 x$1() {
        return !this.bitmap$0 ? this.x$1$lzycompute() : this.x$1;
    }

    private DenseMatrix<Object> rootSigmaInv$lzycompute() {
        MultivariateGaussian multivariateGaussian = this;
        synchronized (multivariateGaussian) {
            if ((byte)(this.bitmap$trans$0 & 2) == 0) {
                this.rootSigmaInv = (DenseMatrix)this.x$1()._1();
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 2);
            }
        }
        return this.rootSigmaInv;
    }

    private DenseMatrix<Object> rootSigmaInv() {
        return (byte)(this.bitmap$trans$0 & 2) == 0 ? this.rootSigmaInv$lzycompute() : this.rootSigmaInv;
    }

    private double u$lzycompute() {
        MultivariateGaussian multivariateGaussian = this;
        synchronized (multivariateGaussian) {
            if ((byte)(this.bitmap$trans$0 & 4) == 0) {
                this.u = this.x$1()._2$mcD$sp();
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 4);
            }
        }
        return this.u;
    }

    private double u() {
        return (byte)(this.bitmap$trans$0 & 4) == 0 ? this.u$lzycompute() : this.u;
    }

    public double pdf(Vector x) {
        return this.pdf(x.asBreeze());
    }

    public double logpdf(Vector x) {
        return this.logpdf(x.asBreeze());
    }

    public double pdf(breeze.linalg.Vector<Object> x) {
        return package$.MODULE$.exp(this.logpdf(x));
    }

    public double logpdf(breeze.linalg.Vector<Object> x) {
        breeze.linalg.Vector delta = (breeze.linalg.Vector)x.$minus(this.breezeMu(), Vector$.MODULE$.castOps(Predef$.MODULE$.$conforms(), Predef$.MODULE$.$conforms(), (UFunc.UImpl2)Vector$.MODULE$.v_v_Idempotent_Op_Double_OpSub()));
        DenseVector v = (DenseVector)this.rootSigmaInv().$times((Object)delta, (UFunc.UImpl2)DenseMatrix$.MODULE$.op_DM_V_Double());
        return this.u() + BoxesRunTime.unboxToDouble((Object)((ImmutableNumericOps)v.t(Tensor$.MODULE$.transposeTensor(Predef$.MODULE$.$conforms()))).$times((Object)v, Transpose$.MODULE$.transTimesNormalFromDot((UFunc.UImpl2)DenseVector.canDotD$.MODULE$))) * -0.5;
    }

    private Tuple2<DenseMatrix<Object>, Object> calculateCovarianceConstants() {
        Tuple2 tuple2;
        eigSym.EigSym eigSym2 = (eigSym.EigSym)eigSym$.MODULE$.apply((Object)this.cov().asBreeze().toDenseMatrix$mcD$sp(ClassTag$.MODULE$.Double(), (Zero)Zero.DoubleZero$.MODULE$), (UFunc.UImpl)eigSym.EigSym_DM_Impl$.MODULE$);
        if (eigSym2 == null) {
            throw new MatchError((Object)eigSym2);
        }
        DenseVector d = (DenseVector)eigSym2.eigenvalues();
        DenseMatrix u = (DenseMatrix)eigSym2.eigenvectors();
        Tuple2 tuple22 = new Tuple2((Object)d, (Object)u);
        Tuple2 tuple23 = tuple22;
        DenseVector d2 = (DenseVector)tuple23._1();
        DenseMatrix u2 = (DenseMatrix)tuple23._2();
        double tol = Utils$.MODULE$.EPSILON() * BoxesRunTime.unboxToDouble((Object)max$.MODULE$.apply((Object)d2, max$.MODULE$.reduce_Double(DenseVector$.MODULE$.canIterateValues()))) * (double)d2.length();
        try {
            double logPseudoDetSigma = BoxesRunTime.unboxToDouble((Object)d2.activeValuesIterator().filter((Function1)(JFunction1.mcZD.sp & Serializable & scala.Serializable)x$3 -> x$3 > tol).map((Function1)(JFunction1.mcDD.sp & Serializable & scala.Serializable)x -> package$.MODULE$.log(x)).sum((Numeric)Numeric.DoubleIsFractional$.MODULE$));
            DenseMatrix pinvS = (DenseMatrix)diag$.MODULE$.apply((Object)new DenseVector.mcD.sp(((DenseVector)d2.map$mcD$sp((Function1)(JFunction1.mcDD.sp & Serializable & scala.Serializable)v -> v > tol ? package$.MODULE$.sqrt(1.0 / v) : 0.0, DenseVector$.MODULE$.canMapValues$mDDc$sp(ClassTag$.MODULE$.Double()))).toArray$mcD$sp(ClassTag$.MODULE$.Double())), diag$.MODULE$.diagDVDMImpl(ClassTag$.MODULE$.Double(), (Zero)Zero.DoubleZero$.MODULE$));
            tuple2 = new Tuple2(pinvS.$times(u2.t(DenseMatrix$.MODULE$.canTranspose()), (UFunc.UImpl2)DenseMatrix$.MODULE$.implOpMulMatrix_DMD_DMD_eq_DMD()), (Object)BoxesRunTime.boxToDouble((double)(-0.5 * ((double)this.mean().size() * package$.MODULE$.log(Math.PI * 2) + logPseudoDetSigma))));
        }
        catch (UnsupportedOperationException uex) {
            throw new IllegalArgumentException("Covariance matrix has no non-zero singular values");
        }
        return tuple2;
    }

    public MultivariateGaussian(Vector mean, Matrix cov) {
        this.mean = mean;
        this.cov = cov;
        Predef$.MODULE$.require(cov.numCols() == cov.numRows(), (Function0 & Serializable & scala.Serializable)() -> "Covariance matrix must be square");
        Predef$.MODULE$.require(mean.size() == cov.numCols(), (Function0 & Serializable & scala.Serializable)() -> "Mean vector length must match covariance matrix size");
    }

    public MultivariateGaussian(DenseVector<Object> mean, DenseMatrix<Object> cov) {
        this(Vectors$.MODULE$.fromBreeze((breeze.linalg.Vector<Object>)mean), Matrices$.MODULE$.fromBreeze((breeze.linalg.Matrix<Object>)cov));
    }
}

