/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.classification;

import com.github.fommil.netlib.BLAS;
import java.io.IOException;
import java.io.Serializable;
import org.apache.spark.ml.Model;
import org.apache.spark.ml.classification.GBTClassificationModel$;
import org.apache.spark.ml.classification.ProbabilisticClassificationModel;
import org.apache.spark.ml.classification.ProbabilisticClassifierParams;
import org.apache.spark.ml.feature.Instance;
import org.apache.spark.ml.linalg.DenseVector;
import org.apache.spark.ml.linalg.SparseVector;
import org.apache.spark.ml.linalg.Vector;
import org.apache.spark.ml.linalg.Vectors$;
import org.apache.spark.ml.param.BooleanParam;
import org.apache.spark.ml.param.DoubleParam;
import org.apache.spark.ml.param.IntParam;
import org.apache.spark.ml.param.LongParam;
import org.apache.spark.ml.param.Param;
import org.apache.spark.ml.param.ParamMap;
import org.apache.spark.ml.param.shared.HasCheckpointInterval;
import org.apache.spark.ml.param.shared.HasMaxIter;
import org.apache.spark.ml.param.shared.HasSeed;
import org.apache.spark.ml.param.shared.HasStepSize;
import org.apache.spark.ml.param.shared.HasValidationIndicatorCol;
import org.apache.spark.ml.param.shared.HasWeightCol;
import org.apache.spark.ml.regression.DecisionTreeRegressionModel;
import org.apache.spark.ml.tree.DecisionTreeParams;
import org.apache.spark.ml.tree.EnsembleModelReadWrite$;
import org.apache.spark.ml.tree.GBTClassifierParams;
import org.apache.spark.ml.tree.GBTParams;
import org.apache.spark.ml.tree.HasVarianceImpurity;
import org.apache.spark.ml.tree.Node;
import org.apache.spark.ml.tree.TreeEnsembleClassifierParams;
import org.apache.spark.ml.tree.TreeEnsembleModel;
import org.apache.spark.ml.tree.TreeEnsembleModel$;
import org.apache.spark.ml.tree.TreeEnsembleParams;
import org.apache.spark.ml.tree.impl.GradientBoostedTrees$;
import org.apache.spark.ml.util.DefaultParamsReader;
import org.apache.spark.ml.util.MLReader;
import org.apache.spark.ml.util.MLWritable;
import org.apache.spark.ml.util.MLWriter;
import org.apache.spark.ml.util.SchemaUtils$;
import org.apache.spark.mllib.tree.configuration.Algo$;
import org.apache.spark.mllib.tree.configuration.BoostingStrategy;
import org.apache.spark.mllib.tree.configuration.Strategy;
import org.apache.spark.mllib.tree.impurity.Impurity;
import org.apache.spark.mllib.tree.loss.ClassificationLoss;
import org.apache.spark.mllib.tree.model.DecisionTreeModel;
import org.apache.spark.mllib.tree.model.GradientBoostedTreesModel;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.expressions.UserDefinedFunction;
import org.apache.spark.sql.functions$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.json4s.DefaultFormats$;
import org.json4s.Formats;
import org.json4s.JsonAST;
import org.json4s.JsonDSL$;
import scala.Array$;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.reflect.Manifest;
import scala.reflect.ManifestFactory$;
import scala.reflect.ScalaSignature;
import scala.reflect.api.JavaUniverse;
import scala.reflect.api.Mirror;
import scala.reflect.api.TypeCreator;
import scala.reflect.api.TypeTags;
import scala.reflect.api.Types;
import scala.reflect.api.Universe;
import scala.reflect.runtime.package$;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\r\u0005b\u0001\u0002\u001d:\u0001\u0011C\u0001b\u001b\u0001\u0003\u0006\u0004%\t\u0005\u001c\u0005\n\u0003\u0007\u0001!\u0011!Q\u0001\n5D!\"a\u0002\u0001\u0005\u000b\u0007I\u0011BA\u0005\u0011)\t\t\u0002\u0001B\u0001B\u0003%\u00111\u0002\u0005\u000b\u0003'\u0001!Q1A\u0005\n\u0005U\u0001BCA\u0010\u0001\t\u0005\t\u0015!\u0003\u0002\u0018!Q\u0011\u0011\u0005\u0001\u0003\u0006\u0004%\t%a\t\t\u0015\u00055\u0002A!A!\u0002\u0013\t)\u0003\u0003\u0006\u00022\u0001\u0011)\u0019!C!\u0003GA!\"!\u000f\u0001\u0005\u0003\u0005\u000b\u0011BA\u0013\u0011!\ti\u0004\u0001C\u0001w\u0005}\u0002\u0002CA\u001f\u0001\u0011\u00051(!\u0015\t\u000f\u0005u\u0002\u0001\"\u0001\u0002\\!9\u0011Q\r\u0001\u0005B\u0005%\u0001\"CA7\u0001\t\u0007I\u0011AA\u0012\u0011!\t)\b\u0001Q\u0001\n\u0005\u0015\u0002bBA=\u0001\u0011\u0005\u0013Q\u0003\u0005\b\u0003{\u0002A\u0011IA@\u0011\u001d\t9\n\u0001C!\u00033Cq!!8\u0001\t\u0003\ny\u000eC\u0004\u0002f\u0002!\t%a:\t\u000f\u0005E\b\u0001\"\u0015\u0002t\"9\u0011\u0011 \u0001\u0005B\u0005m\bb\u0002B\b\u0001\u0011\u0005#\u0011\u0003\u0005\u000b\u0005+\u0001\u0001R1A\u0005\u0002\t]\u0001b\u0002B\u000e\u0001\u0011%!Q\u0004\u0005\t\u0005C\u0001A\u0011A\u001e\u0003$!I!q\u0007\u0001C\u0002\u0013%!\u0011\b\u0005\t\u0005\u000b\u0002\u0001\u0015!\u0003\u0003<!9!q\t\u0001\u0005\u0002\t%\u0003b\u0002B/\u0001\u0011\u0005#qL\u0004\b\u0005WJ\u0004\u0012\u0001B7\r\u0019A\u0014\b#\u0001\u0003p!9\u0011QH\u0011\u0005\u0002\tu\u0004\u0002\u0003B@C\t\u0007I\u0011\u00027\t\u000f\t\u0005\u0015\u0005)A\u0005[\"A!1Q\u0011C\u0002\u0013%A\u000eC\u0004\u0003\u0006\u0006\u0002\u000b\u0011B7\t\u000f\t\u001d\u0015\u0005\"\u0011\u0003\n\"9!1S\u0011\u0005B\tUea\u0002BOC\u0001\t#q\u0014\u0005\n\u0005CK#\u0011!Q\u0001\n=Cq!!\u0010*\t\u0003\u0011\u0019\u000bC\u0004\u0003,&\"\tF!,\u0007\r\t]\u0016\u0005\u0002B]\u0011\u001d\ti$\fC\u0001\u0005wC\u0011Ba0.\u0005\u0004%IA!1\t\u0011\tEW\u0006)A\u0005\u0005\u0007D\u0011Ba5.\u0005\u0004%IA!1\t\u0011\tUW\u0006)A\u0005\u0005\u0007DqAa%.\t\u0003\u00129\u000e\u0003\u0005\u0003\\\u0006\"\ta\u000fBo\u0011)\u0011Y0II\u0001\n\u0003Y$Q \u0005\u000b\u0007#\t\u0013\u0013!C\u0001w\tu\b\"CB\nC\u0005\u0005I\u0011BB\u000b\u0005Y9%\tV\"mCN\u001c\u0018NZ5dCRLwN\\'pI\u0016d'B\u0001\u001e<\u00039\u0019G.Y:tS\u001aL7-\u0019;j_:T!\u0001P\u001f\u0002\u00055d'B\u0001 @\u0003\u0015\u0019\b/\u0019:l\u0015\t\u0001\u0015)\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002\u0005\u0006\u0019qN]4\u0004\u0001M1\u0001!\u0012)W?\u0016\u0004BAR$J\u001f6\t\u0011(\u0003\u0002Is\t\u0001\u0003K]8cC\nLG.[:uS\u000e\u001cE.Y:tS\u001aL7-\u0019;j_:lu\u000eZ3m!\tQU*D\u0001L\u0015\ta5(\u0001\u0004mS:\fGnZ\u0005\u0003\u001d.\u0013aAV3di>\u0014\bC\u0001$\u0001!\t\tF+D\u0001S\u0015\t\u00196(\u0001\u0003ue\u0016,\u0017BA+S\u0005M9%\tV\"mCN\u001c\u0018NZ5feB\u000b'/Y7t!\r\tv+W\u0005\u00031J\u0013\u0011\u0003\u0016:fK\u0016s7/Z7cY\u0016lu\u000eZ3m!\tQV,D\u0001\\\u0015\ta6(\u0001\u0006sK\u001e\u0014Xm]:j_:L!AX.\u00037\u0011+7-[:j_:$&/Z3SK\u001e\u0014Xm]:j_:lu\u000eZ3m!\t\u00017-D\u0001b\u0015\t\u00117(\u0001\u0003vi&d\u0017B\u00013b\u0005)iEj\u0016:ji\u0006\u0014G.\u001a\t\u0003M&l\u0011a\u001a\u0006\u0002Q\u0006)1oY1mC&\u0011!n\u001a\u0002\r'\u0016\u0014\u0018.\u00197ju\u0006\u0014G.Z\u0001\u0004k&$W#A7\u0011\u00059,hBA8t!\t\u0001x-D\u0001r\u0015\t\u00118)\u0001\u0004=e>|GOP\u0005\u0003i\u001e\fa\u0001\u0015:fI\u00164\u0017B\u0001<x\u0005\u0019\u0019FO]5oO*\u0011Ao\u001a\u0015\u0004\u0003e|\bC\u0001>~\u001b\u0005Y(B\u0001?>\u0003)\tgN\\8uCRLwN\\\u0005\u0003}n\u0014QaU5oG\u0016\f#!!\u0001\u0002\u000bErcG\f\u0019\u0002\tULG\r\t\u0015\u0004\u0005e|\u0018AB0ue\u0016,7/\u0006\u0002\u0002\fA!a-!\u0004Z\u0013\r\tya\u001a\u0002\u0006\u0003J\u0014\u0018-_\u0001\b?R\u0014X-Z:!\u00031yFO]3f/\u0016Lw\r\u001b;t+\t\t9\u0002E\u0003g\u0003\u001b\tI\u0002E\u0002g\u00037I1!!\bh\u0005\u0019!u.\u001e2mK\u0006iq\f\u001e:fK^+\u0017n\u001a5ug\u0002\n1B\\;n\r\u0016\fG/\u001e:fgV\u0011\u0011Q\u0005\t\u0004M\u0006\u001d\u0012bAA\u0015O\n\u0019\u0011J\u001c;)\u0007\u001dIx0\u0001\u0007ok64U-\u0019;ve\u0016\u001c\b\u0005K\u0002\ts~\f!B\\;n\u00072\f7o]3tQ\u0011I\u00110!\u000e\"\u0005\u0005]\u0012!\u0002\u001a/e9\u0002\u0014a\u00038v[\u000ec\u0017m]:fg\u0002BCAC=\u00026\u00051A(\u001b8jiz\"2bTA!\u0003\u000b\n9%!\u0013\u0002N!)1n\u0003a\u0001[\"\"\u0011\u0011I=\u0000\u0011\u001d\t9a\u0003a\u0001\u0003\u0017Aq!a\u0005\f\u0001\u0004\t9\u0002C\u0004\u0002\"-\u0001\r!!\n)\t\u0005%\u0013p \u0005\b\u0003cY\u0001\u0019AA\u0013Q\u0015\ti%_A\u001b)%y\u00151KA+\u0003/\nI\u0006C\u0003l\u0019\u0001\u0007Q\u000eC\u0004\u0002\b1\u0001\r!a\u0003\t\u000f\u0005MA\u00021\u0001\u0002\u0018!9\u0011\u0011\u0005\u0007A\u0002\u0005\u0015BcB(\u0002^\u0005}\u0013\u0011\r\u0005\u0006W6\u0001\r!\u001c\u0005\b\u0003\u000fi\u0001\u0019AA\u0006\u0011\u001d\t\u0019\"\u0004a\u0001\u0003/A3!D=\u0000\u0003\u0015!(/Z3tQ\u0011q\u00110!\u001b\"\u0005\u0005-\u0014!B\u0019/i9\u0002\u0014aC4fi:+X\u000e\u0016:fKNDCaD=\u0002r\u0005\u0012\u00111O\u0001\u0006e9\u0002d\u0006M\u0001\rO\u0016$h*^7Ue\u0016,7\u000f\t\u0015\u0005!e\f\t(A\u0006ue\u0016,w+Z5hQR\u001c\b\u0006B\tz\u0003S\nq\u0002\u001e:b]N4wN]7TG\",W.\u0019\u000b\u0005\u0003\u0003\u000b\t\n\u0005\u0003\u0002\u0004\u00065UBAAC\u0015\u0011\t9)!#\u0002\u000bQL\b/Z:\u000b\u0007\u0005-U(A\u0002tc2LA!a$\u0002\u0006\nQ1\u000b\u001e:vGR$\u0016\u0010]3\t\u000f\u0005M%\u00031\u0001\u0002\u0002\u000611o\u00195f[\u0006D3AE=\u0000\u0003%!(/\u00198tM>\u0014X\u000e\u0006\u0003\u0002\u001c\u0006e\u0006\u0003BAO\u0003gsA!a(\u00020:!\u0011\u0011UAW\u001d\u0011\t\u0019+a+\u000f\t\u0005\u0015\u0016\u0011\u0016\b\u0004a\u0006\u001d\u0016\"\u0001\"\n\u0005\u0001\u000b\u0015B\u0001 @\u0013\r\tY)P\u0005\u0005\u0003c\u000bI)A\u0004qC\u000e\\\u0017mZ3\n\t\u0005U\u0016q\u0017\u0002\n\t\u0006$\u0018M\u0012:b[\u0016TA!!-\u0002\n\"9\u00111X\nA\u0002\u0005u\u0016a\u00023bi\u0006\u001cX\r\u001e\u0019\u0005\u0003\u007f\u000bY\r\u0005\u0004\u0002B\u0006\r\u0017qY\u0007\u0003\u0003\u0013KA!!2\u0002\n\n9A)\u0019;bg\u0016$\b\u0003BAe\u0003\u0017d\u0001\u0001\u0002\u0007\u0002N\u0006e\u0016\u0011!A\u0001\u0006\u0003\tyMA\u0002`II\nB!!5\u0002XB\u0019a-a5\n\u0007\u0005UwMA\u0004O_RD\u0017N\\4\u0011\u0007\u0019\fI.C\u0002\u0002\\\u001e\u00141!\u00118z\u0003\u001d\u0001(/\u001a3jGR$B!!\u0007\u0002b\"1\u00111\u001d\u000bA\u0002%\u000b\u0001BZ3biV\u0014Xm]\u0001\u000baJ,G-[2u%\u0006<HcA%\u0002j\"1\u00111]\u000bA\u0002%CC!F=\u0002n\u0006\u0012\u0011q^\u0001\u0006g9\u0002d\u0006M\u0001\u0017e\u0006<(\u0007\u001d:pE\u0006\u0014\u0017\u000e\\5us&s\u0007\u000b\\1dKR\u0019\u0011*!>\t\r\u0005]h\u00031\u0001J\u00035\u0011\u0018m\u001e)sK\u0012L7\r^5p]\u0006!1m\u001c9z)\ry\u0015Q \u0005\b\u0003\u007f<\u0002\u0019\u0001B\u0001\u0003\u0015)\u0007\u0010\u001e:b!\u0011\u0011\u0019A!\u0003\u000e\u0005\t\u0015!b\u0001B\u0004w\u0005)\u0001/\u0019:b[&!!1\u0002B\u0003\u0005!\u0001\u0016M]1n\u001b\u0006\u0004\b\u0006B\fz\u0003S\n\u0001\u0002^8TiJLgn\u001a\u000b\u0002[\"\"\u0001$_A5\u0003I1W-\u0019;ve\u0016LU\u000e]8si\u0006t7-Z:\u0016\u0003%CC!G=\u0002r\u00051Q.\u0019:hS:$B!!\u0007\u0003 !1\u00111\u001d\u000eA\u0002%\u000bQ\u0001^8PY\u0012,\"A!\n\u0011\t\t\u001d\"1G\u0007\u0003\u0005SQAAa\u000b\u0003.\u0005)Qn\u001c3fY*\u00191Ka\f\u000b\u0007\tER(A\u0003nY2L'-\u0003\u0003\u00036\t%\"!G$sC\u0012LWM\u001c;C_>\u001cH/\u001a3Ue\u0016,7/T8eK2\fA\u0001\\8tgV\u0011!1\b\t\u0005\u0005{\u0011\t%\u0004\u0002\u0003@)!!q\u0007B\u0017\u0013\u0011\u0011\u0019Ea\u0010\u0003%\rc\u0017m]:jM&\u001c\u0017\r^5p]2{7o]\u0001\u0006Y>\u001c8\u000fI\u0001\u0016KZ\fG.^1uK\u0016\u000b7\r[%uKJ\fG/[8o)\u0011\t9Ba\u0013\t\u000f\u0005mf\u00041\u0001\u0003NA\"!q\nB*!\u0019\t\t-a1\u0003RA!\u0011\u0011\u001aB*\t1\u0011)Fa\u0013\u0002\u0002\u0003\u0005)\u0011AAh\u0005\ryFe\r\u0015\u0005=e\u0014I&\t\u0002\u0003\\\u0005)!G\f\u001b/a\u0005)qO]5uKV\u0011!\u0011\r\t\u0004A\n\r\u0014b\u0001B3C\nAQ\nT,sSR,'\u000f\u000b\u0003 s\u0006E\u0004f\u0001\u0001z\u007f\u00061rI\u0011+DY\u0006\u001c8/\u001b4jG\u0006$\u0018n\u001c8N_\u0012,G\u000e\u0005\u0002GCM1\u0011E!\u001d\u0003x\u0015\u00042A\u001aB:\u0013\r\u0011)h\u001a\u0002\u0007\u0003:L(+\u001a4\u0011\t\u0001\u0014IhT\u0005\u0004\u0005w\n'AC'M%\u0016\fG-\u00192mKR\u0011!QN\u0001\u000f]Vlg)Z1ukJ,7oS3z\u0003=qW/\u001c$fCR,(/Z:LKf\u0004\u0013a\u00038v[R\u0013X-Z:LKf\fAB\\;n)J,Wm]&fs\u0002\nAA]3bIV\u0011!1\u0012\t\u0005A\n5u*C\u0002\u0003\u0010\u0006\u0014\u0001\"\u0014'SK\u0006$WM\u001d\u0015\u0005Oe\f\t(\u0001\u0003m_\u0006$GcA(\u0003\u0018\"1!\u0011\u0014\u0015A\u00025\fA\u0001]1uQ\"\"\u0001&_A9\u0005q9%\tV\"mCN\u001c\u0018NZ5dCRLwN\\'pI\u0016dwK]5uKJ\u001c2!\u000bB1\u0003!Ign\u001d;b]\u000e,G\u0003\u0002BS\u0005S\u00032Aa**\u001b\u0005\t\u0003B\u0002BQW\u0001\u0007q*\u0001\u0005tCZ,\u0017*\u001c9m)\u0011\u0011yK!.\u0011\u0007\u0019\u0014\t,C\u0002\u00034\u001e\u0014A!\u00168ji\"1!\u0011\u0014\u0017A\u00025\u0014Ad\u0012\"U\u00072\f7o]5gS\u000e\fG/[8o\u001b>$W\r\u001c*fC\u0012,'oE\u0002.\u0005\u0017#\"A!0\u0011\u0007\t\u001dV&A\u0005dY\u0006\u001c8OT1nKV\u0011!1\u0019\t\u0005\u0005\u000b\u0014y-\u0004\u0002\u0003H*!!\u0011\u001aBf\u0003\u0011a\u0017M\\4\u000b\u0005\t5\u0017\u0001\u00026bm\u0006L1A\u001eBd\u0003)\u0019G.Y:t\u001d\u0006lW\rI\u0001\u000eiJ,Wm\u00117bgNt\u0015-\\3\u0002\u001dQ\u0014X-Z\"mCN\u001ch*Y7fAQ\u0019qJ!7\t\r\te5\u00071\u0001n\u0003\u001d1'o\\7PY\u0012$2b\u0014Bp\u0005G\u0014iOa>\u0003z\"9!\u0011\u001d\u001bA\u0002\t\u0015\u0012\u0001C8mI6{G-\u001a7\t\u000f\t\u0015H\u00071\u0001\u0003h\u00061\u0001/\u0019:f]R\u00042A\u0012Bu\u0013\r\u0011Y/\u000f\u0002\u000e\u000f\n#6\t\\1tg&4\u0017.\u001a:\t\u000f\t=H\u00071\u0001\u0003r\u0006\u00192-\u0019;fO>\u0014\u0018nY1m\r\u0016\fG/\u001e:fgB9aNa=\u0002&\u0005\u0015\u0012b\u0001B{o\n\u0019Q*\u00199\t\u0013\u0005\u0005B\u0007%AA\u0002\u0005\u0015\u0002\"CA\u0019iA\u0005\t\u0019AA\u0013\u0003E1'o\\7PY\u0012$C-\u001a4bk2$H\u0005N\u000b\u0003\u0005\u007fTC!!\n\u0004\u0002-\u001211\u0001\t\u0005\u0007\u000b\u0019i!\u0004\u0002\u0004\b)!1\u0011BB\u0006\u0003%)hn\u00195fG.,GM\u0003\u0002}O&!1qBB\u0004\u0005E)hn\u00195fG.,GMV1sS\u0006t7-Z\u0001\u0012MJ|Wn\u00147eI\u0011,g-Y;mi\u0012*\u0014a\u0003:fC\u0012\u0014Vm]8mm\u0016$\"aa\u0006\u0011\t\t\u00157\u0011D\u0005\u0005\u00077\u00119M\u0001\u0004PE*,7\r\u001e\u0015\u0005Ce\f\t\b\u000b\u0003!s\u0006E\u0004")
public class GBTClassificationModel
extends ProbabilisticClassificationModel<Vector, GBTClassificationModel>
implements GBTClassifierParams,
TreeEnsembleModel<DecisionTreeRegressionModel>,
MLWritable {
    private Vector featureImportances;
    private final String uid;
    private final DecisionTreeRegressionModel[] _trees;
    private final double[] _treeWeights;
    private final int numFeatures;
    private final int numClasses;
    private final int getNumTrees;
    private final ClassificationLoss loss;
    private int totalNumNodes;
    private final Param<String> lossType;
    private final Param<String> impurity;
    private final DoubleParam validationTol;
    private final DoubleParam stepSize;
    private final Param<String> validationIndicatorCol;
    private final IntParam maxIter;
    private final DoubleParam subsamplingRate;
    private final Param<String> featureSubsetStrategy;
    private final Param<String> leafCol;
    private final IntParam maxDepth;
    private final IntParam maxBins;
    private final IntParam minInstancesPerNode;
    private final DoubleParam minWeightFractionPerNode;
    private final DoubleParam minInfoGain;
    private final IntParam maxMemoryInMB;
    private final BooleanParam cacheNodeIds;
    private final Param<String> weightCol;
    private final LongParam seed;
    private final IntParam checkpointInterval;
    private volatile byte bitmap$0;

    public static GBTClassificationModel load(String string) {
        return GBTClassificationModel$.MODULE$.load(string);
    }

    public static MLReader<GBTClassificationModel> read() {
        return GBTClassificationModel$.MODULE$.read();
    }

    @Override
    public void save(String path) throws IOException {
        MLWritable.save$(this, path);
    }

    @Override
    public Vector javaTreeWeights() {
        return TreeEnsembleModel.javaTreeWeights$(this);
    }

    @Override
    public String toDebugString() {
        return TreeEnsembleModel.toDebugString$(this);
    }

    @Override
    public Vector predictLeaf(Vector features) {
        return TreeEnsembleModel.predictLeaf$(this, features);
    }

    @Override
    public StructField getLeafField(String leafCol) {
        return TreeEnsembleModel.getLeafField$(this, leafCol);
    }

    @Override
    public String getLossType() {
        return GBTClassifierParams.getLossType$(this);
    }

    @Override
    public ClassificationLoss getOldLossType() {
        return GBTClassifierParams.getOldLossType$(this);
    }

    @Override
    public final String getImpurity() {
        return HasVarianceImpurity.getImpurity$(this);
    }

    @Override
    public Impurity getOldImpurity() {
        return HasVarianceImpurity.getOldImpurity$(this);
    }

    @Override
    public /* synthetic */ StructType org$apache$spark$ml$tree$TreeEnsembleClassifierParams$$super$validateAndTransformSchema(StructType schema, boolean fitting, DataType featuresDataType) {
        return ProbabilisticClassifierParams.validateAndTransformSchema$(this, schema, fitting, featuresDataType);
    }

    @Override
    public StructType validateAndTransformSchema(StructType schema, boolean fitting, DataType featuresDataType) {
        return TreeEnsembleClassifierParams.validateAndTransformSchema$(this, schema, fitting, featuresDataType);
    }

    @Override
    public /* synthetic */ Strategy org$apache$spark$ml$tree$GBTParams$$super$getOldStrategy(Map categoricalFeatures, int numClasses, Enumeration.Value oldAlgo, Impurity oldImpurity) {
        return TreeEnsembleParams.getOldStrategy$(this, categoricalFeatures, numClasses, oldAlgo, oldImpurity);
    }

    @Override
    public final double getValidationTol() {
        return GBTParams.getValidationTol$(this);
    }

    @Override
    public BoostingStrategy getOldBoostingStrategy(Map<Object, Object> categoricalFeatures, Enumeration.Value oldAlgo) {
        return GBTParams.getOldBoostingStrategy$(this, categoricalFeatures, oldAlgo);
    }

    @Override
    public final String getValidationIndicatorCol() {
        return HasValidationIndicatorCol.getValidationIndicatorCol$(this);
    }

    @Override
    public final double getStepSize() {
        return HasStepSize.getStepSize$(this);
    }

    @Override
    public final int getMaxIter() {
        return HasMaxIter.getMaxIter$(this);
    }

    @Override
    public /* synthetic */ Strategy org$apache$spark$ml$tree$TreeEnsembleParams$$super$getOldStrategy(Map categoricalFeatures, int numClasses, Enumeration.Value oldAlgo, Impurity oldImpurity, double subsamplingRate) {
        return DecisionTreeParams.getOldStrategy$(this, categoricalFeatures, numClasses, oldAlgo, oldImpurity, subsamplingRate);
    }

    @Override
    public final double getSubsamplingRate() {
        return TreeEnsembleParams.getSubsamplingRate$(this);
    }

    @Override
    public Strategy getOldStrategy(Map<Object, Object> categoricalFeatures, int numClasses, Enumeration.Value oldAlgo, Impurity oldImpurity) {
        return TreeEnsembleParams.getOldStrategy$(this, categoricalFeatures, numClasses, oldAlgo, oldImpurity);
    }

    @Override
    public final String getFeatureSubsetStrategy() {
        return TreeEnsembleParams.getFeatureSubsetStrategy$(this);
    }

    @Override
    public final DecisionTreeParams setLeafCol(String value) {
        return DecisionTreeParams.setLeafCol$(this, value);
    }

    @Override
    public final String getLeafCol() {
        return DecisionTreeParams.getLeafCol$(this);
    }

    @Override
    public final int getMaxDepth() {
        return DecisionTreeParams.getMaxDepth$(this);
    }

    @Override
    public final int getMaxBins() {
        return DecisionTreeParams.getMaxBins$(this);
    }

    @Override
    public final int getMinInstancesPerNode() {
        return DecisionTreeParams.getMinInstancesPerNode$(this);
    }

    @Override
    public final double getMinWeightFractionPerNode() {
        return DecisionTreeParams.getMinWeightFractionPerNode$(this);
    }

    @Override
    public final double getMinInfoGain() {
        return DecisionTreeParams.getMinInfoGain$(this);
    }

    @Override
    public final int getMaxMemoryInMB() {
        return DecisionTreeParams.getMaxMemoryInMB$(this);
    }

    @Override
    public final boolean getCacheNodeIds() {
        return DecisionTreeParams.getCacheNodeIds$(this);
    }

    @Override
    public Strategy getOldStrategy(Map<Object, Object> categoricalFeatures, int numClasses, Enumeration.Value oldAlgo, Impurity oldImpurity, double subsamplingRate) {
        return DecisionTreeParams.getOldStrategy$(this, categoricalFeatures, numClasses, oldAlgo, oldImpurity, subsamplingRate);
    }

    @Override
    public final String getWeightCol() {
        return HasWeightCol.getWeightCol$(this);
    }

    @Override
    public final long getSeed() {
        return HasSeed.getSeed$(this);
    }

    @Override
    public final int getCheckpointInterval() {
        return HasCheckpointInterval.getCheckpointInterval$(this);
    }

    private int totalNumNodes$lzycompute() {
        GBTClassificationModel gBTClassificationModel = this;
        synchronized (gBTClassificationModel) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.totalNumNodes = TreeEnsembleModel.totalNumNodes$(this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.totalNumNodes;
    }

    @Override
    public int totalNumNodes() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.totalNumNodes$lzycompute() : this.totalNumNodes;
    }

    @Override
    public Param<String> lossType() {
        return this.lossType;
    }

    @Override
    public void org$apache$spark$ml$tree$GBTClassifierParams$_setter_$lossType_$eq(Param<String> x$1) {
        this.lossType = x$1;
    }

    @Override
    public final Param<String> impurity() {
        return this.impurity;
    }

    @Override
    public final void org$apache$spark$ml$tree$HasVarianceImpurity$_setter_$impurity_$eq(Param<String> x$1) {
        this.impurity = x$1;
    }

    @Override
    public final DoubleParam validationTol() {
        return this.validationTol;
    }

    @Override
    public final DoubleParam stepSize() {
        return this.stepSize;
    }

    @Override
    public final void org$apache$spark$ml$tree$GBTParams$_setter_$validationTol_$eq(DoubleParam x$1) {
        this.validationTol = x$1;
    }

    @Override
    public final void org$apache$spark$ml$tree$GBTParams$_setter_$stepSize_$eq(DoubleParam x$1) {
        this.stepSize = x$1;
    }

    @Override
    public final Param<String> validationIndicatorCol() {
        return this.validationIndicatorCol;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasValidationIndicatorCol$_setter_$validationIndicatorCol_$eq(Param<String> x$1) {
        this.validationIndicatorCol = x$1;
    }

    @Override
    public void org$apache$spark$ml$param$shared$HasStepSize$_setter_$stepSize_$eq(DoubleParam x$1) {
    }

    @Override
    public final IntParam maxIter() {
        return this.maxIter;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasMaxIter$_setter_$maxIter_$eq(IntParam x$1) {
        this.maxIter = x$1;
    }

    @Override
    public final DoubleParam subsamplingRate() {
        return this.subsamplingRate;
    }

    @Override
    public final Param<String> featureSubsetStrategy() {
        return this.featureSubsetStrategy;
    }

    @Override
    public final void org$apache$spark$ml$tree$TreeEnsembleParams$_setter_$subsamplingRate_$eq(DoubleParam x$1) {
        this.subsamplingRate = x$1;
    }

    @Override
    public final void org$apache$spark$ml$tree$TreeEnsembleParams$_setter_$featureSubsetStrategy_$eq(Param<String> x$1) {
        this.featureSubsetStrategy = x$1;
    }

    @Override
    public final Param<String> leafCol() {
        return this.leafCol;
    }

    @Override
    public final IntParam maxDepth() {
        return this.maxDepth;
    }

    @Override
    public final IntParam maxBins() {
        return this.maxBins;
    }

    @Override
    public final IntParam minInstancesPerNode() {
        return this.minInstancesPerNode;
    }

    @Override
    public final DoubleParam minWeightFractionPerNode() {
        return this.minWeightFractionPerNode;
    }

    @Override
    public final DoubleParam minInfoGain() {
        return this.minInfoGain;
    }

    @Override
    public final IntParam maxMemoryInMB() {
        return this.maxMemoryInMB;
    }

    @Override
    public final BooleanParam cacheNodeIds() {
        return this.cacheNodeIds;
    }

    @Override
    public final void org$apache$spark$ml$tree$DecisionTreeParams$_setter_$leafCol_$eq(Param<String> x$1) {
        this.leafCol = x$1;
    }

    @Override
    public final void org$apache$spark$ml$tree$DecisionTreeParams$_setter_$maxDepth_$eq(IntParam x$1) {
        this.maxDepth = x$1;
    }

    @Override
    public final void org$apache$spark$ml$tree$DecisionTreeParams$_setter_$maxBins_$eq(IntParam x$1) {
        this.maxBins = x$1;
    }

    @Override
    public final void org$apache$spark$ml$tree$DecisionTreeParams$_setter_$minInstancesPerNode_$eq(IntParam x$1) {
        this.minInstancesPerNode = x$1;
    }

    @Override
    public final void org$apache$spark$ml$tree$DecisionTreeParams$_setter_$minWeightFractionPerNode_$eq(DoubleParam x$1) {
        this.minWeightFractionPerNode = x$1;
    }

    @Override
    public final void org$apache$spark$ml$tree$DecisionTreeParams$_setter_$minInfoGain_$eq(DoubleParam x$1) {
        this.minInfoGain = x$1;
    }

    @Override
    public final void org$apache$spark$ml$tree$DecisionTreeParams$_setter_$maxMemoryInMB_$eq(IntParam x$1) {
        this.maxMemoryInMB = x$1;
    }

    @Override
    public final void org$apache$spark$ml$tree$DecisionTreeParams$_setter_$cacheNodeIds_$eq(BooleanParam x$1) {
        this.cacheNodeIds = x$1;
    }

    @Override
    public final Param<String> weightCol() {
        return this.weightCol;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasWeightCol$_setter_$weightCol_$eq(Param<String> x$1) {
        this.weightCol = x$1;
    }

    @Override
    public final LongParam seed() {
        return this.seed;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasSeed$_setter_$seed_$eq(LongParam x$1) {
        this.seed = x$1;
    }

    @Override
    public final IntParam checkpointInterval() {
        return this.checkpointInterval;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasCheckpointInterval$_setter_$checkpointInterval_$eq(IntParam x$1) {
        this.checkpointInterval = x$1;
    }

    @Override
    public String uid() {
        return this.uid;
    }

    private DecisionTreeRegressionModel[] _trees() {
        return this._trees;
    }

    private double[] _treeWeights() {
        return this._treeWeights;
    }

    @Override
    public int numFeatures() {
        return this.numFeatures;
    }

    @Override
    public int numClasses() {
        return this.numClasses;
    }

    public DecisionTreeRegressionModel[] trees() {
        return this._trees();
    }

    public int getNumTrees() {
        return this.getNumTrees;
    }

    @Override
    public double[] treeWeights() {
        return this._treeWeights();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public StructType transformSchema(StructType schema) {
        void var2_2;
        block0: {
            StructType outputSchema = super.transformSchema(schema);
            if (!new StringOps(Predef$.MODULE$.augmentString(this.$(this.leafCol()))).nonEmpty()) break block0;
            outputSchema = SchemaUtils$.MODULE$.updateField(outputSchema, this.getLeafField(this.$(this.leafCol())), SchemaUtils$.MODULE$.updateField$default$3());
        }
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Dataset<Row> transform(Dataset<?> dataset) {
        Dataset dataset2;
        StructType outputSchema = this.transformSchema(dataset.schema(), true);
        Dataset<Row> outputData = super.transform(dataset);
        if (new StringOps(Predef$.MODULE$.augmentString(this.$(this.leafCol()))).nonEmpty()) {
            JavaUniverse $u = package$.MODULE$.universe();
            JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(GBTClassificationModel.class.getClassLoader());
            JavaUniverse $u2 = package$.MODULE$.universe();
            JavaUniverse.JavaMirror $m2 = package$.MODULE$.universe().runtimeMirror(GBTClassificationModel.class.getClassLoader());
            public final class Org_apache_spark_ml_classification_GBTClassificationModel$$typecreator1$1
            extends TypeCreator {
                public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                    Universe $u = $m$untyped.universe();
                    Mirror<U> $m = $m$untyped;
                    return $m.staticClass("org.apache.spark.ml.linalg.Vector").asType().toTypeConstructor();
                }

                public Org_apache_spark_ml_classification_GBTClassificationModel$$typecreator1$1(GBTClassificationModel $outer) {
                }
            }
            public final class Org_apache_spark_ml_classification_GBTClassificationModel$$typecreator2$1
            extends TypeCreator {
                public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                    Universe $u = $m$untyped.universe();
                    Mirror<U> $m = $m$untyped;
                    return $m.staticClass("org.apache.spark.ml.linalg.Vector").asType().toTypeConstructor();
                }

                public Org_apache_spark_ml_classification_GBTClassificationModel$$typecreator2$1(GBTClassificationModel $outer) {
                }
            }
            UserDefinedFunction leafUDF = functions$.MODULE$.udf((Function1 & Serializable & scala.Serializable)features -> this.predictLeaf((Vector)features), ((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_ml_classification_GBTClassificationModel$$typecreator1$1(null)), ((TypeTags)$u2).TypeTag().apply((Mirror)$m2, (TypeCreator)new Org_apache_spark_ml_classification_GBTClassificationModel$$typecreator2$1(null)));
            dataset2 = outputData.withColumn(this.$(this.leafCol()), leafUDF.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col(this.$(this.featuresCol()))})), outputSchema.apply(this.$(this.leafCol())).metadata());
        } else {
            void var3_3;
            dataset2 = var3_3;
        }
        return dataset2;
    }

    @Override
    public double predict(Vector features) {
        return this.isDefined(this.thresholds()) ? super.predict(features) : (this.margin(features) > 0.0 ? 1.0 : 0.0);
    }

    @Override
    public Vector predictRaw(Vector features) {
        double prediction = this.margin(features);
        return Vectors$.MODULE$.dense(new double[]{-prediction, prediction});
    }

    @Override
    public Vector raw2probabilityInPlace(Vector rawPrediction) {
        Vector vector = rawPrediction;
        if (!(vector instanceof DenseVector)) {
            if (vector instanceof SparseVector) {
                throw new RuntimeException("Unexpected error in GBTClassificationModel: raw2probabilityInPlace encountered SparseVector");
            }
            throw new MatchError((Object)vector);
        }
        DenseVector denseVector = (DenseVector)vector;
        denseVector.values()[0] = this.loss().computeProbability(denseVector.values()[0]);
        denseVector.values()[1] = 1.0 - denseVector.values()[0];
        DenseVector denseVector2 = denseVector;
        return denseVector2;
    }

    @Override
    public GBTClassificationModel copy(ParamMap extra) {
        return (GBTClassificationModel)((Model)this.copyValues(new GBTClassificationModel(this.uid(), this._trees(), this._treeWeights(), this.numFeatures(), this.numClasses()), extra)).setParent(this.parent());
    }

    @Override
    public String toString() {
        return new StringBuilder(68).append("GBTClassificationModel: uid = ").append(this.uid()).append(", numTrees=").append(this.getNumTrees()).append(", numClasses=").append(this.numClasses()).append(", ").append("numFeatures=").append(this.numFeatures()).toString();
    }

    private Vector featureImportances$lzycompute() {
        GBTClassificationModel gBTClassificationModel = this;
        synchronized (gBTClassificationModel) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.featureImportances = TreeEnsembleModel$.MODULE$.featureImportances(this.trees(), this.numFeatures(), false);
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.featureImportances;
    }

    public Vector featureImportances() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.featureImportances$lzycompute() : this.featureImportances;
    }

    private double margin(Vector features) {
        double[] treePredictions = (double[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this._trees())).map((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToDouble((double)GBTClassificationModel.$anonfun$margin$1(features, x$4)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double()));
        return BLAS.getInstance().ddot(this.getNumTrees(), treePredictions, 1, this._treeWeights(), 1);
    }

    public GradientBoostedTreesModel toOld() {
        return new GradientBoostedTreesModel(Algo$.MODULE$.Classification(), (DecisionTreeModel[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this._trees())).map((Function1 & Serializable & scala.Serializable)x$5 -> x$5.toOld(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(DecisionTreeModel.class))), this._treeWeights());
    }

    private ClassificationLoss loss() {
        return this.loss;
    }

    public double[] evaluateEachIteration(Dataset<?> dataset) {
        RDD<Instance> data = this.extractInstances(dataset);
        return GradientBoostedTrees$.MODULE$.evaluateEachIteration(data, this.trees(), this.treeWeights(), this.loss(), Algo$.MODULE$.Classification());
    }

    @Override
    public MLWriter write() {
        return new GBTClassificationModelWriter(this);
    }

    public static final /* synthetic */ double $anonfun$margin$1(Vector features$1, DecisionTreeRegressionModel x$4) {
        return x$4.rootNode().predictImpl(features$1).prediction();
    }

    public GBTClassificationModel(String uid, DecisionTreeRegressionModel[] _trees, double[] _treeWeights, int numFeatures, int numClasses) {
        this.uid = uid;
        this._trees = _trees;
        this._treeWeights = _treeWeights;
        this.numFeatures = numFeatures;
        this.numClasses = numClasses;
        HasCheckpointInterval.$init$(this);
        HasSeed.$init$(this);
        HasWeightCol.$init$(this);
        DecisionTreeParams.$init$(this);
        TreeEnsembleParams.$init$(this);
        HasMaxIter.$init$(this);
        HasStepSize.$init$(this);
        HasValidationIndicatorCol.$init$(this);
        GBTParams.$init$(this);
        TreeEnsembleClassifierParams.$init$(this);
        HasVarianceImpurity.$init$(this);
        GBTClassifierParams.$init$(this);
        TreeEnsembleModel.$init$(this);
        MLWritable.$init$(this);
        Predef$.MODULE$.require(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])_trees)).nonEmpty(), (Function0 & Serializable & scala.Serializable)() -> "GBTClassificationModel requires at least 1 tree.");
        Predef$.MODULE$.require(_trees.length == _treeWeights.length, (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(91).append("GBTClassificationModel given trees, treeWeights").append(" of non-matching lengths (").append(this._trees().length).append(", ").append(this._treeWeights().length).append(", respectively).").toString());
        this.getNumTrees = this.trees().length;
        this.loss = this.getOldLossType();
    }

    public GBTClassificationModel(String uid, DecisionTreeRegressionModel[] _trees, double[] _treeWeights, int numFeatures) {
        this(uid, _trees, _treeWeights, numFeatures, 2);
    }

    public GBTClassificationModel(String uid, DecisionTreeRegressionModel[] _trees, double[] _treeWeights) {
        this(uid, _trees, _treeWeights, -1, 2);
    }

    public static class GBTClassificationModelReader
    extends MLReader<GBTClassificationModel> {
        private final String className = GBTClassificationModel.class.getName();
        private final String treeClassName = DecisionTreeRegressionModel.class.getName();

        private String className() {
            return this.className;
        }

        private String treeClassName() {
            return this.treeClassName;
        }

        @Override
        public GBTClassificationModel load(String path) {
            Tuple2[] tuple2Array;
            DefaultParamsReader.Metadata metadata;
            double[] treeWeights;
            DefaultFormats$ format;
            block3: {
                Tuple3<DefaultParamsReader.Metadata, Tuple2<DefaultParamsReader.Metadata, Node>[], double[]> tuple3;
                block2: {
                    format = DefaultFormats$.MODULE$;
                    tuple3 = EnsembleModelReadWrite$.MODULE$.loadImpl(path, this.sparkSession(), this.className(), this.treeClassName());
                    if (tuple3 == null) break block2;
                    DefaultParamsReader.Metadata metadata2 = (DefaultParamsReader.Metadata)tuple3._1();
                    Tuple2[] treesData = (Tuple2[])tuple3._2();
                    treeWeights = (double[])tuple3._3();
                    if (metadata2 == null) break block2;
                    metadata = metadata2;
                    if (treesData == null) break block2;
                    tuple2Array = treesData;
                    if (treeWeights != null) break block3;
                }
                throw new MatchError(tuple3);
            }
            double[] dArray = treeWeights;
            Tuple3 tuple3 = new Tuple3((Object)metadata, (Object)tuple2Array, (Object)dArray);
            Tuple3 tuple32 = tuple3;
            DefaultParamsReader.Metadata metadata3 = (DefaultParamsReader.Metadata)tuple32._1();
            Tuple2[] treesData = (Tuple2[])tuple32._2();
            double[] treeWeights2 = (double[])tuple32._3();
            int numFeatures = BoxesRunTime.unboxToInt((Object)org.json4s.package$.MODULE$.jvalue2extractable(org.json4s.package$.MODULE$.jvalue2monadic(metadata3.metadata()).$bslash(GBTClassificationModel$.MODULE$.org$apache$spark$ml$classification$GBTClassificationModel$$numFeaturesKey())).extract((Formats)format, (Manifest)ManifestFactory$.MODULE$.Int()));
            int numTrees = BoxesRunTime.unboxToInt((Object)org.json4s.package$.MODULE$.jvalue2extractable(org.json4s.package$.MODULE$.jvalue2monadic(metadata3.metadata()).$bslash(GBTClassificationModel$.MODULE$.org$apache$spark$ml$classification$GBTClassificationModel$$numTreesKey())).extract((Formats)format, (Manifest)ManifestFactory$.MODULE$.Int()));
            DecisionTreeRegressionModel[] trees = (DecisionTreeRegressionModel[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])treesData)).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
                Tuple2 tuple2 = x0$1;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                DefaultParamsReader.Metadata treeMetadata = (DefaultParamsReader.Metadata)tuple2._1();
                Node root = (Node)tuple2._2();
                DecisionTreeRegressionModel tree = new DecisionTreeRegressionModel(treeMetadata.uid(), root, numFeatures);
                treeMetadata.getAndSetParams(tree, treeMetadata.getAndSetParams$default$2());
                DecisionTreeRegressionModel decisionTreeRegressionModel = tree;
                return decisionTreeRegressionModel;
            }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(DecisionTreeRegressionModel.class)));
            Predef$.MODULE$.require(numTrees == trees.length, (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(79).append("GBTClassificationModel.load expected ").append(numTrees).append(" trees based on metadata but found ").append(trees.length).append(" trees.").toString());
            GBTClassificationModel model = new GBTClassificationModel(metadata3.uid(), trees, treeWeights2, numFeatures);
            metadata3.getAndSetParams(model, (Option<List<String>>)new Some((Object)new .colon.colon((Object)"impurity", (List)Nil$.MODULE$)));
            return model;
        }
    }

    public static class GBTClassificationModelWriter
    extends MLWriter {
        private final GBTClassificationModel instance;

        @Override
        public void saveImpl(String path) {
            JsonAST.JObject extraMetadata = JsonDSL$.MODULE$.map2jvalue((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)GBTClassificationModel$.MODULE$.org$apache$spark$ml$classification$GBTClassificationModel$$numFeaturesKey()), (Object)BoxesRunTime.boxToInteger((int)this.instance.numFeatures())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)GBTClassificationModel$.MODULE$.org$apache$spark$ml$classification$GBTClassificationModel$$numTreesKey()), (Object)BoxesRunTime.boxToInteger((int)this.instance.getNumTrees()))})), (Function1 & Serializable & scala.Serializable)x -> JsonDSL$.MODULE$.int2jvalue(BoxesRunTime.unboxToInt((Object)x)));
            EnsembleModelReadWrite$.MODULE$.saveImpl(this.instance, path, this.sparkSession(), extraMetadata);
        }

        public GBTClassificationModelWriter(GBTClassificationModel instance) {
            this.instance = instance;
        }
    }
}

