/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.hive.thriftserver;

import java.io.Serializable;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.hadoop.hive.ql.security.authorization.plugin.HiveOperationType;
import org.apache.hadoop.hive.ql.security.authorization.plugin.HivePrivilegeObject;
import org.apache.hive.service.cli.CLIServiceUtils;
import org.apache.hive.service.cli.HiveSQLException;
import org.apache.hive.service.cli.OperationState;
import org.apache.hive.service.cli.RowSet;
import org.apache.hive.service.cli.operation.GetColumnsOperation;
import org.apache.hive.service.cli.session.HiveSession;
import org.apache.spark.internal.Logging;
import org.apache.spark.sql.SQLContext;
import org.apache.spark.sql.catalyst.TableIdentifier;
import org.apache.spark.sql.catalyst.catalog.CatalogTableType;
import org.apache.spark.sql.catalyst.catalog.SessionCatalog;
import org.apache.spark.sql.hive.thriftserver.HiveThriftServer2$;
import org.apache.spark.sql.hive.thriftserver.SparkOperation;
import org.apache.spark.sql.hive.thriftserver.ThriftserverShimUtils$;
import org.apache.spark.sql.internal.NonClosableMutableURLClassLoader;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.util.Utils$;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Map;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;

@ScalaSignature(bytes="\u0006\u0001\u0005\u0005d!B\b\u0011\u0001Ia\u0002\u0002\u0003\u001a\u0001\u0005\u000b\u0007I\u0011\u0001\u001b\t\u0011e\u0002!\u0011!Q\u0001\nUB\u0001B\u000f\u0001\u0003\u0002\u0003\u0006Ia\u000f\u0005\t\u0003\u0002\u0011\t\u0011)A\u0005\u0005\"Aq\n\u0001B\u0001B\u0003%!\t\u0003\u0005Q\u0001\t\u0005\t\u0015!\u0003C\u0011!\t\u0006A!A!\u0002\u0013\u0011\u0005\"\u0002*\u0001\t\u0003\u0019\u0006bB.\u0001\u0005\u0004%\t\u0001\u0018\u0005\u0007I\u0002\u0001\u000b\u0011B/\t\u000b\u0015\u0004A\u0011\t4\t\u000b-\u0004A\u0011\u00027\t\u000f\u0005%\u0001\u0001\"\u0003\u0002\f!a\u0011\u0011\u000b\u0001\u0011\u0002\u0003\u0005\t\u0011\"\u0001\u0002T\tA2\u000b]1sW\u001e+GoQ8mk6t7o\u00149fe\u0006$\u0018n\u001c8\u000b\u0005E\u0011\u0012\u0001\u0004;ie&4Go]3sm\u0016\u0014(BA\n\u0015\u0003\u0011A\u0017N^3\u000b\u0005U1\u0012aA:rY*\u0011q\u0003G\u0001\u0006gB\f'o\u001b\u0006\u00033i\ta!\u00199bG\",'\"A\u000e\u0002\u0007=\u0014xm\u0005\u0003\u0001;!b\u0003C\u0001\u0010'\u001b\u0005y\"B\u0001\u0011\"\u0003%y\u0007/\u001a:bi&|gN\u0003\u0002#G\u0005\u00191\r\\5\u000b\u0005\u0011*\u0013aB:feZL7-\u001a\u0006\u0003'aI!aJ\u0010\u0003'\u001d+GoQ8mk6t7o\u00149fe\u0006$\u0018n\u001c8\u0011\u0005%RS\"\u0001\t\n\u0005-\u0002\"AD*qCJ\\w\n]3sCRLwN\u001c\t\u0003[Aj\u0011A\f\u0006\u0003_Y\t\u0001\"\u001b8uKJt\u0017\r\\\u0005\u0003c9\u0012q\u0001T8hO&tw-\u0001\u0006tc2\u001cuN\u001c;fqR\u001c\u0001!F\u00016!\t1t'D\u0001\u0015\u0013\tADC\u0001\u0006T#2\u001buN\u001c;fqR\f1b]9m\u0007>tG/\u001a=uA\u0005i\u0001/\u0019:f]R\u001cVm]:j_:\u0004\"\u0001P \u000e\u0003uR!AP\u0011\u0002\u000fM,7o]5p]&\u0011\u0001)\u0010\u0002\f\u0011&4XmU3tg&|g.A\u0006dCR\fGn\\4OC6,\u0007CA\"M\u001d\t!%\n\u0005\u0002F\u00116\taI\u0003\u0002Hg\u00051AH]8pizR\u0011!S\u0001\u0006g\u000e\fG.Y\u0005\u0003\u0017\"\u000ba\u0001\u0015:fI\u00164\u0017BA'O\u0005\u0019\u0019FO]5oO*\u00111\nS\u0001\u000bg\u000eDW-\\1OC6,\u0017!\u0003;bE2,g*Y7f\u0003)\u0019w\u000e\\;n]:\u000bW.Z\u0001\u0007y%t\u0017\u000e\u001e \u0015\u000fQ+fk\u0016-Z5B\u0011\u0011\u0006\u0001\u0005\u0006e!\u0001\r!\u000e\u0005\u0006u!\u0001\ra\u000f\u0005\u0006\u0003\"\u0001\rA\u0011\u0005\u0006\u001f\"\u0001\rA\u0011\u0005\u0006!\"\u0001\rA\u0011\u0005\u0006#\"\u0001\rAQ\u0001\bG\u0006$\u0018\r\\8h+\u0005i\u0006C\u00010c\u001b\u0005y&BA.a\u0015\t\tG#\u0001\u0005dCR\fG._:u\u0013\t\u0019wL\u0001\bTKN\u001c\u0018n\u001c8DCR\fGn\\4\u0002\u0011\r\fG/\u00197pO\u0002\n1B];o\u0013:$XM\u001d8bYR\tq\r\u0005\u0002iS6\t\u0001*\u0003\u0002k\u0011\n!QK\\5u\u0003-\tG\r\u001a+p%><8+\u001a;\u0015\u000b\u001dl\u0017p\u001f?\t\u000b9d\u0001\u0019A8\u0002\u001b\r|G.^7o!\u0006$H/\u001a:o!\t\u0001x/D\u0001r\u0015\t\u00118/A\u0003sK\u001e,\u0007P\u0003\u0002uk\u0006!Q\u000f^5m\u0015\u00051\u0018\u0001\u00026bm\u0006L!\u0001_9\u0003\u000fA\u000bG\u000f^3s]\")!\u0010\u0004a\u0001\u0005\u00061AM\u0019(b[\u0016DQ\u0001\u0015\u0007A\u0002\tCQ! \u0007A\u0002y\faa]2iK6\f\u0007cA@\u0002\u00065\u0011\u0011\u0011\u0001\u0006\u0004\u0003\u0007!\u0012!\u0002;za\u0016\u001c\u0018\u0002BA\u0004\u0003\u0003\u0011!b\u0015;sk\u000e$H+\u001f9f\u0003-9W\r\u001e)sSZ|%M[:\u0015\t\u00055\u0011Q\b\t\u0007\u0003\u001f\tI\"a\b\u000f\t\u0005E\u0011Q\u0003\b\u0004\u000b\u0006M\u0011\"A%\n\u0007\u0005]\u0001*A\u0004qC\u000e\\\u0017mZ3\n\t\u0005m\u0011Q\u0004\u0002\u0004'\u0016\f(bAA\f\u0011B!\u0011\u0011EA\u001d\u001b\t\t\u0019C\u0003\u0003\u0002&\u0005\u001d\u0012A\u00029mk\u001eLgN\u0003\u0003\u0002*\u0005-\u0012!D1vi\"|'/\u001b>bi&|gN\u0003\u0003\u0002.\u0005=\u0012\u0001C:fGV\u0014\u0018\u000e^=\u000b\t\u0005E\u00121G\u0001\u0003c2T1aEA\u001b\u0015\r\t9\u0004G\u0001\u0007Q\u0006$wn\u001c9\n\t\u0005m\u00121\u0005\u0002\u0014\u0011&4X\r\u0015:jm&dWmZ3PE*,7\r\u001e\u0005\b\u0003\u007fi\u0001\u0019AA!\u0003\u001d!'M\r+bEN\u0004baQA\"\u0005\u0006\u001d\u0013bAA#\u001d\n\u0019Q*\u00199\u0011\r\u0005=\u0011\u0011DA%!\u0011\tY%!\u0014\u000e\u0003\u0001L1!a\u0014a\u0005=!\u0016M\u00197f\u0013\u0012,g\u000e^5gS\u0016\u0014\u0018\u0001\u00059s_R,7\r^3eII|woU3u)\u0011\t)&!\u0018\u0011\t\u0005]\u0013\u0011L\u0007\u0002C%\u0019\u00111L\u0011\u0003\rI{woU3u\u0011!\tyFDA\u0001\u0002\u0004!\u0016a\u0001=%c\u0001")
public class SparkGetColumnsOperation
extends GetColumnsOperation
implements SparkOperation {
    private final SQLContext sqlContext;
    private final HiveSession parentSession;
    private final String catalogName;
    private final String schemaName;
    private final String tableName;
    private final String columnName;
    private final SessionCatalog catalog;
    private String statementId;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    @Override
    public /* synthetic */ void org$apache$spark$sql$hive$thriftserver$SparkOperation$$super$run() {
        super.run();
    }

    @Override
    public /* synthetic */ void org$apache$spark$sql$hive$thriftserver$SparkOperation$$super$close() {
        super.close();
    }

    @Override
    public void cleanup() {
        SparkOperation.cleanup$(this);
    }

    @Override
    public void run() {
        SparkOperation.run$(this);
    }

    @Override
    public void close() {
        SparkOperation.close$(this);
    }

    @Override
    public <T> T withLocalProperties(Function0<T> f) {
        return (T)SparkOperation.withLocalProperties$(this, f);
    }

    @Override
    public String tableTypeString(CatalogTableType tableType) {
        return SparkOperation.tableTypeString$(this, tableType);
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    @Override
    public String statementId() {
        return this.statementId;
    }

    @Override
    public void statementId_$eq(String x$1) {
        this.statementId = x$1;
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public /* synthetic */ RowSet protected$rowSet(SparkGetColumnsOperation x$1) {
        return x$1.rowSet;
    }

    @Override
    public SQLContext sqlContext() {
        return this.sqlContext;
    }

    public SessionCatalog catalog() {
        return this.catalog;
    }

    @Override
    public void runInternal() {
        String cmdStr = new StringBuilder(45).append("catalog : ").append(this.catalogName).append(", schemaPattern : ").append(this.schemaName).append(", tablePattern : ").append(this.tableName).toString();
        String logMsg = new StringBuilder(33).append("Listing columns '").append(cmdStr).append(", columnName : ").append(this.columnName).append("'").toString();
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(6).append(logMsg).append(" with ").append(this.statementId()).toString());
        this.setState(OperationState.RUNNING);
        NonClosableMutableURLClassLoader executionHiveClassLoader = this.sqlContext().sharedState().jarClassLoader();
        Thread.currentThread().setContextClassLoader((ClassLoader)executionHiveClassLoader);
        HiveThriftServer2$.MODULE$.eventManager().onStatementStart(this.statementId(), this.parentSession.getSessionHandle().getSessionId().toString(), logMsg, this.statementId(), this.parentSession.getUsername());
        String schemaPattern = this.convertSchemaPattern(this.schemaName);
        String tablePattern = this.convertIdentifierPattern(this.tableName, true);
        ObjectRef columnPattern = ObjectRef.create(null);
        if (this.columnName != null) {
            columnPattern.elem = Pattern.compile(this.convertIdentifierPattern(this.columnName, false));
        }
        Map db2Tabs = ((TraversableOnce)this.catalog().listDatabases(schemaPattern).map((Function1 & Serializable & scala.Serializable)dbName -> new Tuple2(dbName, (Object)this.catalog().listTables(dbName, tablePattern, false)), Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        if (this.isAuthV2Enabled()) {
            List privObjs = (List)JavaConverters$.MODULE$.seqAsJavaListConverter(this.getPrivObjs((Map<String, Seq<TableIdentifier>>)db2Tabs)).asJava();
            this.authorizeMetaGets(HiveOperationType.GET_COLUMNS, privObjs, cmdStr);
        }
        try {
            db2Tabs.foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
                SparkGetColumnsOperation.$anonfun$runInternal$3(this, columnPattern, x0$1);
                return BoxedUnit.UNIT;
            });
            String globalTempViewDb = this.catalog().globalTempViewManager().database();
            Pattern databasePattern = Pattern.compile(CLIServiceUtils.patternToRegex(this.schemaName));
            if (databasePattern.matcher(globalTempViewDb).matches()) {
                this.catalog().globalTempViewManager().listViewNames(tablePattern).foreach((Function1 & Serializable & scala.Serializable)globalTempView -> {
                    SparkGetColumnsOperation.$anonfun$runInternal$5(this, columnPattern, globalTempViewDb, globalTempView);
                    return BoxedUnit.UNIT;
                });
            }
            this.catalog().listLocalTempViews(tablePattern).foreach((Function1 & Serializable & scala.Serializable)localTempView -> {
                SparkGetColumnsOperation.$anonfun$runInternal$7(this, columnPattern, localTempView);
                return BoxedUnit.UNIT;
            });
            this.setState(OperationState.FINISHED);
        }
        catch (Throwable e) {
            this.logError((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(43).append("Error executing get columns operation with ").append(this.statementId()).toString(), e);
            this.setState(OperationState.ERROR);
            Throwable throwable = e;
            if (throwable instanceof HiveSQLException) {
                HiveSQLException hiveSQLException = (HiveSQLException)throwable;
                HiveThriftServer2$.MODULE$.eventManager().onStatementError(this.statementId(), hiveSQLException.getMessage(), Utils$.MODULE$.exceptionString((Throwable)hiveSQLException));
                throw hiveSQLException;
            }
            Throwable root = ExceptionUtils.getRootCause((Throwable)e);
            HiveThriftServer2$.MODULE$.eventManager().onStatementError(this.statementId(), root.getMessage(), Utils$.MODULE$.exceptionString(root));
            throw new HiveSQLException(new StringBuilder(23).append("Error getting columns: ").append(root.toString()).toString(), root);
        }
        HiveThriftServer2$.MODULE$.eventManager().onStatementFinish(this.statementId());
    }

    private void addToRowSet(Pattern columnPattern, String dbName, String tableName, StructType schema) {
        schema.foreach((Function1 & Serializable & scala.Serializable)column -> {
            Object object;
            if (columnPattern != null && !columnPattern.matcher(column.name()).matches()) {
                object = BoxedUnit.UNIT;
            } else {
                Object[] rowData = new Object[]{null, dbName, tableName, column.name(), BoxesRunTime.boxToInteger((int)ThriftserverShimUtils$.MODULE$.toJavaSQLType(column.dataType().sql())), column.dataType().sql(), null, null, null, null, column.nullable() ? BoxesRunTime.boxToInteger((int)1) : BoxesRunTime.boxToInteger((int)0), column.getComment().getOrElse((Function0 & Serializable & scala.Serializable)() -> ""), null, null, null, null, null, "YES", null, null, null, null, "NO"};
                object = this.protected$rowSet(this).addRow(rowData);
            }
            return object;
        });
    }

    private Seq<HivePrivilegeObject> getPrivObjs(Map<String, Seq<TableIdentifier>> db2Tabs) {
        return (Seq)db2Tabs.foldLeft((Object)Seq$.MODULE$.empty(), (Function2 & Serializable & scala.Serializable)(x0$1, x1$1) -> {
            Tuple2 tuple2;
            Seq i;
            block3: {
                Tuple2 tuple22;
                block2: {
                    tuple22 = new Tuple2(x0$1, x1$1);
                    if (tuple22 == null) break block2;
                    i = (Seq)tuple22._1();
                    tuple2 = (Tuple2)tuple22._2();
                    if (tuple2 != null) break block3;
                }
                throw new MatchError((Object)tuple22);
            }
            String dbName = (String)tuple2._1();
            Seq tables = (Seq)tuple2._2();
            Seq seq = (Seq)i.$plus$plus((GenTraversableOnce)tables.map((Function1 & Serializable & scala.Serializable)tableId -> new HivePrivilegeObject(HivePrivilegeObject.HivePrivilegeObjectType.TABLE_OR_VIEW, dbName, tableId.table()), Seq$.MODULE$.canBuildFrom()), Seq$.MODULE$.canBuildFrom());
            return seq;
        });
    }

    public static final /* synthetic */ void $anonfun$runInternal$3(SparkGetColumnsOperation $this, ObjectRef columnPattern$1, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        String dbName = (String)tuple2._1();
        Seq tables = (Seq)tuple2._2();
        $this.catalog().getTablesByName(tables).foreach((Function1 & Serializable & scala.Serializable)catalogTable -> {
            $this.addToRowSet((Pattern)columnPattern$1.elem, dbName, catalogTable.identifier().table(), catalogTable.schema());
            return BoxedUnit.UNIT;
        });
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ void $anonfun$runInternal$5(SparkGetColumnsOperation $this, ObjectRef columnPattern$1, String globalTempViewDb$1, String globalTempView) {
        $this.catalog().globalTempViewManager().get(globalTempView).foreach((Function1 & Serializable & scala.Serializable)plan -> {
            $this.addToRowSet((Pattern)columnPattern$1.elem, globalTempViewDb$1, globalTempView, plan.schema());
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$runInternal$7(SparkGetColumnsOperation $this, ObjectRef columnPattern$1, TableIdentifier localTempView) {
        $this.catalog().getTempView(localTempView.table()).foreach((Function1 & Serializable & scala.Serializable)plan -> {
            $this.addToRowSet((Pattern)columnPattern$1.elem, null, localTempView.table(), plan.schema());
            return BoxedUnit.UNIT;
        });
    }

    public SparkGetColumnsOperation(SQLContext sqlContext, HiveSession parentSession, String catalogName, String schemaName, String tableName, String columnName) {
        this.sqlContext = sqlContext;
        this.parentSession = parentSession;
        this.catalogName = catalogName;
        this.schemaName = schemaName;
        this.tableName = tableName;
        this.columnName = columnName;
        super(parentSession, catalogName, schemaName, tableName, columnName);
        Logging.$init$((Logging)this);
        SparkOperation.$init$(this);
        this.catalog = sqlContext.sessionState().catalog();
    }
}

