"""Code generated by Speakeasy (https://speakeasyapi.dev). DO NOT EDIT."""

import requests as requests_http
from . import utils
from codat.models import operations
from typing import Optional

class TaxComponents:
    r"""Retrieve standardized data from linked commerce platforms."""
    _client: requests_http.Session
    _security_client: requests_http.Session
    _server_url: str
    _language: str
    _sdk_version: str
    _gen_version: str

    def __init__(self, client: requests_http.Session, security_client: requests_http.Session, server_url: str, language: str, sdk_version: str, gen_version: str) -> None:
        self._client = client
        self._security_client = security_client
        self._server_url = server_url
        self._language = language
        self._sdk_version = sdk_version
        self._gen_version = gen_version
        
    def get_companies_company_id_connections_connection_id_data_commerce_tax_components(self, request: operations.GetCompaniesCompanyIDConnectionsConnectionIDDataCommerceTaxComponentsRequest) -> operations.GetCompaniesCompanyIDConnectionsConnectionIDDataCommerceTaxComponentsResponse:
        r"""List tax components
        This endpoint returns a lits of tax rates from the commerce platform, including tax rate names and values. This supports the mapping of tax rates from the commerce platform to the accounting platform.
        """
        base_url = self._server_url
        
        url = utils.generate_url(operations.GetCompaniesCompanyIDConnectionsConnectionIDDataCommerceTaxComponentsRequest, base_url, '/companies/{companyId}/connections/{connectionId}/data/commerce-taxComponents', request)
        
        
        client = self._security_client
        
        http_res = client.request('GET', url)
        content_type = http_res.headers.get('Content-Type')

        res = operations.GetCompaniesCompanyIDConnectionsConnectionIDDataCommerceTaxComponentsResponse(status_code=http_res.status_code, content_type=content_type, raw_response=http_res)
        
        if http_res.status_code == 200:
            if utils.match_content_type(content_type, 'application/json'):
                out = utils.unmarshal_json(http_res.text, Optional[operations.GetCompaniesCompanyIDConnectionsConnectionIDDataCommerceTaxComponents200ApplicationJSON])
                res.get_companies_company_id_connections_connection_id_data_commerce_tax_components_200_application_json_object = out

        return res

    