# Copyright 2024 IQM
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
"""Station control interface models."""

from iqm.station_control.interface.models.dut import DutData, DutFieldData
from iqm.station_control.interface.models.observation import (
    ObservationData,
    ObservationDefinition,
    ObservationLite,
    ObservationUpdate,
)
from iqm.station_control.interface.models.observation_set import (
    ObservationSetData,
    ObservationSetDefinition,
    ObservationSetUpdate,
)
from iqm.station_control.interface.models.run import RunData, RunDefinition, RunLite
from iqm.station_control.interface.models.sequence import (
    SequenceMetadataData,
    SequenceMetadataDefinition,
    SequenceResultData,
    SequenceResultDefinition,
)
from iqm.station_control.interface.models.sweep import SweepData, SweepDefinition, SweepStatus
from iqm.station_control.interface.models.type_aliases import (
    DutType,
    GetObservationsMode,
    ObservationSetType,
    SoftwareVersionSet,
    Statuses,
    SweepResults,
)
