"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.ChangeController = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_cloudwatch_1 = require("aws-cdk-lib/aws-cloudwatch");
const aws_events_1 = require("aws-cdk-lib/aws-events");
const aws_events_targets_1 = require("aws-cdk-lib/aws-events-targets");
const aws_iam_1 = require("aws-cdk-lib/aws-iam");
const constructs_1 = require("constructs");
const change_controller_function_1 = require("./change-controller-function");
class ChangeController extends constructs_1.Construct {
    constructor(scope, id, props) {
        super(scope, id);
        const fn = new change_controller_function_1.ChangeControllerFunction(this, 'ChangeControllerLambda');
        // Grant permission for stage transitions
        fn.addToRolePolicy(new aws_iam_1.PolicyStatement({
            resources: [`${props.stage.pipeline.pipelineArn}*`],
            actions: [
                'codepipeline:EnableStageTransition',
                'codepipeline:DisableStageTransition',
                'codepipeline:GetPipelineState',
            ],
            effect: aws_iam_1.Effect.ALLOW,
        }));
        // Grant permission to retrieve calendars
        fn.addToRolePolicy(new aws_iam_1.PolicyStatement({
            resources: [props.calendar.calendarArn],
            actions: ['ssm:GetCalendarState'],
            effect: aws_iam_1.Effect.ALLOW,
        }));
        // Grant permisssion to check alarm states
        fn.addToRolePolicy(new aws_iam_1.PolicyStatement({
            resources: ['*'],
            actions: ['cloudwatch:DescribeAlarms'],
            effect: aws_iam_1.Effect.ALLOW,
        }));
        // Any error in the lambda function will close the time window
        fn.metricErrors()
            .with({ statistic: 'sum' })
            .createAlarm(this, 'change-controller-alarm', {
            alarmName: `ChangeController-${props.stage.pipeline.pipelineName}${props.stage.stageName}`,
            evaluationPeriods: 1,
            threshold: 1,
            comparisonOperator: aws_cloudwatch_1.ComparisonOperator.GREATER_THAN_OR_EQUAL_TO_THRESHOLD,
            treatMissingData: aws_cloudwatch_1.TreatMissingData.BREACHING,
        });
        // Create a rule to run the lambda on a schedule defined by the user
        new aws_events_1.Rule(this, 'Scheduler', {
            ruleName: fn.functionName,
            schedule: props.schedule,
            targets: [
                new aws_events_targets_1.LambdaFunction(fn, {
                    event: aws_events_1.RuleTargetInput.fromObject({
                        calendar: props.calendar,
                        searchTerms: props.searchTerms,
                        stageName: props.stage.stageName,
                        pipelineName: props.stage.pipeline.pipelineName,
                    }),
                }),
            ],
        });
    }
}
exports.ChangeController = ChangeController;
_a = JSII_RTTI_SYMBOL_1;
ChangeController[_a] = { fqn: "@cdklabs/cdk-codepipeline-extensions.ChangeController", version: "0.0.2" };
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiY2hhbmdlLWNvbnRyb2xsZXIuanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyIuLi8uLi8uLi9zcmMvdGltZS13aW5kb3dzL2NoYW5nZS1jb250cm9sbGVyL2NoYW5nZS1jb250cm9sbGVyLnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7Ozs7O0FBQUEsK0RBR29DO0FBRXBDLHVEQUF5RTtBQUN6RSx1RUFBZ0U7QUFDaEUsaURBQThEO0FBQzlELDJDQUF1QztBQUV2Qyw2RUFBd0U7QUFTeEUsTUFBYSxnQkFBaUIsU0FBUSxzQkFBUztJQUM3QyxZQUFZLEtBQWdCLEVBQUUsRUFBVSxFQUFFLEtBQTRCO1FBQ3BFLEtBQUssQ0FBQyxLQUFLLEVBQUUsRUFBRSxDQUFDLENBQUM7UUFFakIsTUFBTSxFQUFFLEdBQUcsSUFBSSxxREFBd0IsQ0FBQyxJQUFJLEVBQUUsd0JBQXdCLENBQUMsQ0FBQztRQUV4RSx5Q0FBeUM7UUFDekMsRUFBRSxDQUFDLGVBQWUsQ0FDaEIsSUFBSSx5QkFBZSxDQUFDO1lBQ2xCLFNBQVMsRUFBRSxDQUFDLEdBQUcsS0FBSyxDQUFDLEtBQUssQ0FBQyxRQUFRLENBQUMsV0FBVyxHQUFHLENBQUM7WUFDbkQsT0FBTyxFQUFFO2dCQUNQLG9DQUFvQztnQkFDcEMscUNBQXFDO2dCQUNyQywrQkFBK0I7YUFDaEM7WUFDRCxNQUFNLEVBQUUsZ0JBQU0sQ0FBQyxLQUFLO1NBQ3JCLENBQUMsQ0FDSCxDQUFDO1FBRUYseUNBQXlDO1FBQ3pDLEVBQUUsQ0FBQyxlQUFlLENBQ2hCLElBQUkseUJBQWUsQ0FBQztZQUNsQixTQUFTLEVBQUUsQ0FBQyxLQUFLLENBQUMsUUFBUSxDQUFDLFdBQVcsQ0FBQztZQUN2QyxPQUFPLEVBQUUsQ0FBQyxzQkFBc0IsQ0FBQztZQUNqQyxNQUFNLEVBQUUsZ0JBQU0sQ0FBQyxLQUFLO1NBQ3JCLENBQUMsQ0FDSCxDQUFDO1FBRUYsMENBQTBDO1FBQzFDLEVBQUUsQ0FBQyxlQUFlLENBQ2hCLElBQUkseUJBQWUsQ0FBQztZQUNsQixTQUFTLEVBQUUsQ0FBQyxHQUFHLENBQUM7WUFDaEIsT0FBTyxFQUFFLENBQUMsMkJBQTJCLENBQUM7WUFDdEMsTUFBTSxFQUFFLGdCQUFNLENBQUMsS0FBSztTQUNyQixDQUFDLENBQ0gsQ0FBQztRQUVGLDhEQUE4RDtRQUM5RCxFQUFFLENBQUMsWUFBWSxFQUFFO2FBQ2QsSUFBSSxDQUFDLEVBQUUsU0FBUyxFQUFFLEtBQUssRUFBRSxDQUFDO2FBQzFCLFdBQVcsQ0FBQyxJQUFJLEVBQUUseUJBQXlCLEVBQUU7WUFDNUMsU0FBUyxFQUFFLG9CQUFvQixLQUFLLENBQUMsS0FBSyxDQUFDLFFBQVEsQ0FBQyxZQUFZLEdBQUcsS0FBSyxDQUFDLEtBQUssQ0FBQyxTQUFTLEVBQUU7WUFDMUYsaUJBQWlCLEVBQUUsQ0FBQztZQUNwQixTQUFTLEVBQUUsQ0FBQztZQUNaLGtCQUFrQixFQUNoQixtQ0FBa0IsQ0FBQyxrQ0FBa0M7WUFDdkQsZ0JBQWdCLEVBQUUsaUNBQWdCLENBQUMsU0FBUztTQUM3QyxDQUFDLENBQUM7UUFFTCxvRUFBb0U7UUFDcEUsSUFBSSxpQkFBSSxDQUFDLElBQUksRUFBRSxXQUFXLEVBQUU7WUFDMUIsUUFBUSxFQUFFLEVBQUUsQ0FBQyxZQUFZO1lBQ3pCLFFBQVEsRUFBRSxLQUFLLENBQUMsUUFBUTtZQUN4QixPQUFPLEVBQUU7Z0JBQ1AsSUFBSSxtQ0FBYyxDQUFDLEVBQUUsRUFBRTtvQkFDckIsS0FBSyxFQUFFLDRCQUFlLENBQUMsVUFBVSxDQUFDO3dCQUNoQyxRQUFRLEVBQUUsS0FBSyxDQUFDLFFBQVE7d0JBQ3hCLFdBQVcsRUFBRSxLQUFLLENBQUMsV0FBVzt3QkFDOUIsU0FBUyxFQUFFLEtBQUssQ0FBQyxLQUFLLENBQUMsU0FBUzt3QkFDaEMsWUFBWSxFQUFFLEtBQUssQ0FBQyxLQUFLLENBQUMsUUFBUSxDQUFDLFlBQVk7cUJBQ2hELENBQUM7aUJBQ0gsQ0FBQzthQUNIO1NBQ0YsQ0FBQyxDQUFDO0lBQ0wsQ0FBQzs7QUFoRUgsNENBaUVDIiwic291cmNlc0NvbnRlbnQiOlsiaW1wb3J0IHtcbiAgQ29tcGFyaXNvbk9wZXJhdG9yLFxuICBUcmVhdE1pc3NpbmdEYXRhLFxufSBmcm9tICdhd3MtY2RrLWxpYi9hd3MtY2xvdWR3YXRjaCc7XG5pbXBvcnQgeyBJU3RhZ2UgfSBmcm9tICdhd3MtY2RrLWxpYi9hd3MtY29kZXBpcGVsaW5lJztcbmltcG9ydCB7IFJ1bGUsIFJ1bGVUYXJnZXRJbnB1dCwgU2NoZWR1bGUgfSBmcm9tICdhd3MtY2RrLWxpYi9hd3MtZXZlbnRzJztcbmltcG9ydCB7IExhbWJkYUZ1bmN0aW9uIH0gZnJvbSAnYXdzLWNkay1saWIvYXdzLWV2ZW50cy10YXJnZXRzJztcbmltcG9ydCB7IEVmZmVjdCwgUG9saWN5U3RhdGVtZW50IH0gZnJvbSAnYXdzLWNkay1saWIvYXdzLWlhbSc7XG5pbXBvcnQgeyBDb25zdHJ1Y3QgfSBmcm9tICdjb25zdHJ1Y3RzJztcbmltcG9ydCB7IENhbGVuZGFyIH0gZnJvbSAnLi4vY2FsZW5kYXIvY2FsZW5kYXInO1xuaW1wb3J0IHsgQ2hhbmdlQ29udHJvbGxlckZ1bmN0aW9uIH0gZnJvbSAnLi9jaGFuZ2UtY29udHJvbGxlci1mdW5jdGlvbic7XG5cbmV4cG9ydCBpbnRlcmZhY2UgQ2hhbmdlQ29udHJvbGxlclByb3BzIHtcbiAgcmVhZG9ubHkgY2FsZW5kYXI6IENhbGVuZGFyO1xuICByZWFkb25seSBzdGFnZTogSVN0YWdlO1xuICByZWFkb25seSBzY2hlZHVsZTogU2NoZWR1bGU7XG4gIHJlYWRvbmx5IHNlYXJjaFRlcm1zOiBzdHJpbmdbXTtcbn1cblxuZXhwb3J0IGNsYXNzIENoYW5nZUNvbnRyb2xsZXIgZXh0ZW5kcyBDb25zdHJ1Y3Qge1xuICBjb25zdHJ1Y3RvcihzY29wZTogQ29uc3RydWN0LCBpZDogc3RyaW5nLCBwcm9wczogQ2hhbmdlQ29udHJvbGxlclByb3BzKSB7XG4gICAgc3VwZXIoc2NvcGUsIGlkKTtcblxuICAgIGNvbnN0IGZuID0gbmV3IENoYW5nZUNvbnRyb2xsZXJGdW5jdGlvbih0aGlzLCAnQ2hhbmdlQ29udHJvbGxlckxhbWJkYScpO1xuXG4gICAgLy8gR3JhbnQgcGVybWlzc2lvbiBmb3Igc3RhZ2UgdHJhbnNpdGlvbnNcbiAgICBmbi5hZGRUb1JvbGVQb2xpY3koXG4gICAgICBuZXcgUG9saWN5U3RhdGVtZW50KHtcbiAgICAgICAgcmVzb3VyY2VzOiBbYCR7cHJvcHMuc3RhZ2UucGlwZWxpbmUucGlwZWxpbmVBcm59KmBdLFxuICAgICAgICBhY3Rpb25zOiBbXG4gICAgICAgICAgJ2NvZGVwaXBlbGluZTpFbmFibGVTdGFnZVRyYW5zaXRpb24nLFxuICAgICAgICAgICdjb2RlcGlwZWxpbmU6RGlzYWJsZVN0YWdlVHJhbnNpdGlvbicsXG4gICAgICAgICAgJ2NvZGVwaXBlbGluZTpHZXRQaXBlbGluZVN0YXRlJyxcbiAgICAgICAgXSxcbiAgICAgICAgZWZmZWN0OiBFZmZlY3QuQUxMT1csXG4gICAgICB9KVxuICAgICk7XG5cbiAgICAvLyBHcmFudCBwZXJtaXNzaW9uIHRvIHJldHJpZXZlIGNhbGVuZGFyc1xuICAgIGZuLmFkZFRvUm9sZVBvbGljeShcbiAgICAgIG5ldyBQb2xpY3lTdGF0ZW1lbnQoe1xuICAgICAgICByZXNvdXJjZXM6IFtwcm9wcy5jYWxlbmRhci5jYWxlbmRhckFybl0sXG4gICAgICAgIGFjdGlvbnM6IFsnc3NtOkdldENhbGVuZGFyU3RhdGUnXSxcbiAgICAgICAgZWZmZWN0OiBFZmZlY3QuQUxMT1csXG4gICAgICB9KVxuICAgICk7XG5cbiAgICAvLyBHcmFudCBwZXJtaXNzc2lvbiB0byBjaGVjayBhbGFybSBzdGF0ZXNcbiAgICBmbi5hZGRUb1JvbGVQb2xpY3koXG4gICAgICBuZXcgUG9saWN5U3RhdGVtZW50KHtcbiAgICAgICAgcmVzb3VyY2VzOiBbJyonXSxcbiAgICAgICAgYWN0aW9uczogWydjbG91ZHdhdGNoOkRlc2NyaWJlQWxhcm1zJ10sXG4gICAgICAgIGVmZmVjdDogRWZmZWN0LkFMTE9XLFxuICAgICAgfSlcbiAgICApO1xuXG4gICAgLy8gQW55IGVycm9yIGluIHRoZSBsYW1iZGEgZnVuY3Rpb24gd2lsbCBjbG9zZSB0aGUgdGltZSB3aW5kb3dcbiAgICBmbi5tZXRyaWNFcnJvcnMoKVxuICAgICAgLndpdGgoeyBzdGF0aXN0aWM6ICdzdW0nIH0pXG4gICAgICAuY3JlYXRlQWxhcm0odGhpcywgJ2NoYW5nZS1jb250cm9sbGVyLWFsYXJtJywge1xuICAgICAgICBhbGFybU5hbWU6IGBDaGFuZ2VDb250cm9sbGVyLSR7cHJvcHMuc3RhZ2UucGlwZWxpbmUucGlwZWxpbmVOYW1lfSR7cHJvcHMuc3RhZ2Uuc3RhZ2VOYW1lfWAsXG4gICAgICAgIGV2YWx1YXRpb25QZXJpb2RzOiAxLFxuICAgICAgICB0aHJlc2hvbGQ6IDEsXG4gICAgICAgIGNvbXBhcmlzb25PcGVyYXRvcjpcbiAgICAgICAgICBDb21wYXJpc29uT3BlcmF0b3IuR1JFQVRFUl9USEFOX09SX0VRVUFMX1RPX1RIUkVTSE9MRCxcbiAgICAgICAgdHJlYXRNaXNzaW5nRGF0YTogVHJlYXRNaXNzaW5nRGF0YS5CUkVBQ0hJTkcsXG4gICAgICB9KTtcblxuICAgIC8vIENyZWF0ZSBhIHJ1bGUgdG8gcnVuIHRoZSBsYW1iZGEgb24gYSBzY2hlZHVsZSBkZWZpbmVkIGJ5IHRoZSB1c2VyXG4gICAgbmV3IFJ1bGUodGhpcywgJ1NjaGVkdWxlcicsIHtcbiAgICAgIHJ1bGVOYW1lOiBmbi5mdW5jdGlvbk5hbWUsXG4gICAgICBzY2hlZHVsZTogcHJvcHMuc2NoZWR1bGUsXG4gICAgICB0YXJnZXRzOiBbXG4gICAgICAgIG5ldyBMYW1iZGFGdW5jdGlvbihmbiwge1xuICAgICAgICAgIGV2ZW50OiBSdWxlVGFyZ2V0SW5wdXQuZnJvbU9iamVjdCh7XG4gICAgICAgICAgICBjYWxlbmRhcjogcHJvcHMuY2FsZW5kYXIsXG4gICAgICAgICAgICBzZWFyY2hUZXJtczogcHJvcHMuc2VhcmNoVGVybXMsXG4gICAgICAgICAgICBzdGFnZU5hbWU6IHByb3BzLnN0YWdlLnN0YWdlTmFtZSxcbiAgICAgICAgICAgIHBpcGVsaW5lTmFtZTogcHJvcHMuc3RhZ2UucGlwZWxpbmUucGlwZWxpbmVOYW1lLFxuICAgICAgICAgIH0pLFxuICAgICAgICB9KSxcbiAgICAgIF0sXG4gICAgfSk7XG4gIH1cbn1cbiJdfQ==