# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.service_client import SDKClient
from msrest import Serializer, Deserializer

from ._configuration import ContainerServiceClientConfiguration
from .operations import OpenShiftManagedClustersOperations
from . import models


class ContainerServiceClient(SDKClient):
    """The Container Service Client.

    :ivar config: Configuration for client.
    :vartype config: ContainerServiceClientConfiguration

    :ivar open_shift_managed_clusters: OpenShiftManagedClusters operations
    :vartype open_shift_managed_clusters: azure.mgmt.containerservice.v2019_10_27_preview.operations.OpenShiftManagedClustersOperations

    :param credentials: Credentials needed for the client to connect to Azure.
    :type credentials: :mod:`A msrestazure Credentials
     object<msrestazure.azure_active_directory>`
    :param subscription_id: Subscription credentials which uniquely identify
     Microsoft Azure subscription. The subscription ID forms part of the URI
     for every service call.
    :type subscription_id: str
    :param str base_url: Service URL
    """

    def __init__(
            self, credentials, subscription_id, base_url=None):

        self.config = ContainerServiceClientConfiguration(credentials, subscription_id, base_url)
        super(ContainerServiceClient, self).__init__(self.config.credentials, self.config)

        client_models = {k: v for k, v in models.__dict__.items() if isinstance(v, type)}
        self.api_version = '2019-10-27-preview'
        self._serialize = Serializer(client_models)
        self._deserialize = Deserializer(client_models)

        self.open_shift_managed_clusters = OpenShiftManagedClustersOperations(
            self._client, self.config, self._serialize, self._deserialize)
