"use strict";
const assert_1 = require("@aws-cdk/assert");
const eks = require("../lib");
const util_1 = require("./util");
module.exports = {
    'add Helm chart': {
        'should have default namespace'(test) {
            // GIVEN
            const { stack, cluster } = util_1.testFixtureCluster();
            // WHEN
            new eks.HelmChart(stack, 'MyChart', { cluster, chart: 'chart' });
            // THEN
            assert_1.expect(stack).to(assert_1.haveResource(eks.HelmChart.RESOURCE_TYPE, { Namespace: 'default' }));
            test.done();
        },
        'should have a lowercase default release name'(test) {
            // GIVEN
            const { stack, cluster } = util_1.testFixtureCluster();
            // WHEN
            new eks.HelmChart(stack, 'MyChart', { cluster, chart: 'chart' });
            // THEN
            assert_1.expect(stack).to(assert_1.haveResource(eks.HelmChart.RESOURCE_TYPE, { Release: 'stackmychartff398361' }));
            test.done();
        },
        'should use the last 53 of the default release name'(test) {
            // GIVEN
            const { stack, cluster } = util_1.testFixtureCluster();
            // WHEN
            new eks.HelmChart(stack, 'MyChartNameWhichISMostProbablyLongerThanFiftyThreeCharacters', { cluster, chart: 'chart' });
            // THEN
            assert_1.expect(stack).to(assert_1.haveResource(eks.HelmChart.RESOURCE_TYPE, { Release: 'hismostprobablylongerthanfiftythreecharacterscaf15d09' }));
            test.done();
        },
        'with values'(test) {
            // GIVEN
            const { stack, cluster } = util_1.testFixtureCluster();
            // WHEN
            new eks.HelmChart(stack, 'MyChart', { cluster, chart: 'chart', values: { foo: 123 } });
            // THEN
            assert_1.expect(stack).to(assert_1.haveResource(eks.HelmChart.RESOURCE_TYPE, { Values: '{\"foo\":123}' }));
            test.done();
        },
        'should support waiting until everything is completed before marking release as successful'(test) {
            // GIVEN
            const { stack, cluster } = util_1.testFixtureCluster();
            // WHEN
            new eks.HelmChart(stack, 'MyWaitingChart', { cluster, chart: 'chart', wait: true });
            // THEN
            assert_1.expect(stack).to(assert_1.haveResource(eks.HelmChart.RESOURCE_TYPE, { Wait: true }));
            test.done();
        },
        'should default to not waiting before marking release as successful'(test) {
            // GIVEN
            const { stack, cluster } = util_1.testFixtureCluster();
            // WHEN
            new eks.HelmChart(stack, 'MyWaitingChart', { cluster, chart: 'chart' });
            // THEN
            assert_1.expect(stack).to(assert_1.haveResource(eks.HelmChart.RESOURCE_TYPE, { Wait: false }));
            test.done();
        },
    },
};
//# sourceMappingURL=data:application/json;base64,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