"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const core_1 = require("@aws-cdk/core");
const crypto = require("crypto");
const KUBECTL_APP_ARN = 'arn:aws:serverlessrepo:us-east-1:903779448426:applications/lambda-layer-kubectl';
const KUBECTL_APP_CN_ARN = 'arn:aws-cn:serverlessrepo:cn-north-1:487369736442:applications/lambda-layer-kubectl';
const KUBECTL_APP_VERSION = '1.13.7';
/**
 * An AWS Lambda layer that includes kubectl and the AWS CLI.
 *
 * @see https://github.com/aws-samples/aws-lambda-layer-kubectl
 */
class KubectlLayer extends core_1.Construct {
    constructor(scope, id, props = {}) {
        super(scope, id);
        /**
         * All runtimes are compatible.
         */
        this.compatibleRuntimes = undefined;
        const uniqueId = crypto.createHash('md5').update(this.node.path).digest('hex');
        const version = props.version || KUBECTL_APP_VERSION;
        this.stack.templateOptions.transforms = ['AWS::Serverless-2016-10-31']; // required for AWS::Serverless
        const resource = new core_1.CfnResource(this, 'Resource', {
            type: 'AWS::Serverless::Application',
            properties: {
                Location: {
                    ApplicationId: this.isChina() ? KUBECTL_APP_CN_ARN : KUBECTL_APP_ARN,
                    SemanticVersion: version,
                },
                Parameters: {
                    LayerName: `kubectl-${uniqueId}`,
                },
            },
        });
        this.layerVersionArn = core_1.Token.asString(resource.getAtt('Outputs.LayerVersionArn'));
    }
    /**
     * Gets or create a singleton instance of this construct.
     */
    static getOrCreate(scope, props = {}) {
        const stack = core_1.Stack.of(scope);
        const id = 'kubectl-layer-' + (props.version ? props.version : '8C2542BC-BF2B-4DFE-B765-E181FD30A9A0');
        const exists = stack.node.tryFindChild(id);
        if (exists) {
            return exists;
        }
        return new KubectlLayer(stack, id, props);
    }
    get stack() {
        return core_1.Stack.of(this);
    }
    addPermission(_id, _permission) {
        return;
    }
    isChina() {
        const region = this.stack.region;
        return !core_1.Token.isUnresolved(region) && region.startsWith('cn-');
    }
}
exports.KubectlLayer = KubectlLayer;
//# sourceMappingURL=data:application/json;base64,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