"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const core_1 = require("@aws-cdk/core");
/**
 * Values for `kubectl patch` --type argument
 */
var PatchType;
(function (PatchType) {
    /**
     * JSON Patch, RFC 6902
     */
    PatchType["JSON"] = "json";
    /**
     * JSON Merge patch
     */
    PatchType["MERGE"] = "merge";
    /**
     * Strategic merge patch
     */
    PatchType["STRATEGIC"] = "strategic";
})(PatchType = exports.PatchType || (exports.PatchType = {}));
/**
 * A CloudFormation resource which applies/restores a JSON patch into a
 * Kubernetes resource.
 * @see https://kubernetes.io/docs/tasks/run-application/update-api-object-kubectl-patch/
 */
class KubernetesPatch extends core_1.Construct {
    constructor(scope, id, props) {
        var _a, _b;
        super(scope, id);
        const stack = core_1.Stack.of(this);
        const provider = props.cluster._kubectlProvider;
        new core_1.CustomResource(this, 'Resource', {
            serviceToken: provider.serviceToken,
            resourceType: 'Custom::AWSCDK-EKS-KubernetesPatch',
            properties: {
                ResourceName: props.resourceName,
                ResourceNamespace: (_a = props.resourceNamespace) !== null && _a !== void 0 ? _a : 'default',
                ApplyPatchJson: stack.toJsonString(props.applyPatch),
                RestorePatchJson: stack.toJsonString(props.restorePatch),
                ClusterName: props.cluster.clusterName,
                RoleArn: props.cluster._getKubectlCreationRoleArn(provider.role),
                PatchType: (_b = props.patchType) !== null && _b !== void 0 ? _b : PatchType.STRATEGIC,
            },
        });
    }
}
exports.KubernetesPatch = KubernetesPatch;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiazhzLXBhdGNoLmpzIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsiazhzLXBhdGNoLnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7O0FBQUEsd0NBQWlFO0FBNENqRTs7R0FFRztBQUNILElBQVksU0FhWDtBQWJELFdBQVksU0FBUztJQUNuQjs7T0FFRztJQUNILDBCQUFhLENBQUE7SUFDYjs7T0FFRztJQUNILDRCQUFlLENBQUE7SUFDZjs7T0FFRztJQUNILG9DQUF1QixDQUFBO0FBQ3pCLENBQUMsRUFiVyxTQUFTLEdBQVQsaUJBQVMsS0FBVCxpQkFBUyxRQWFwQjtBQUVEOzs7O0dBSUc7QUFDSCxNQUFhLGVBQWdCLFNBQVEsZ0JBQVM7SUFDNUMsWUFBWSxLQUFnQixFQUFFLEVBQVUsRUFBRSxLQUEyQjs7UUFDbkUsS0FBSyxDQUFDLEtBQUssRUFBRSxFQUFFLENBQUMsQ0FBQztRQUVqQixNQUFNLEtBQUssR0FBRyxZQUFLLENBQUMsRUFBRSxDQUFDLElBQUksQ0FBQyxDQUFDO1FBQzdCLE1BQU0sUUFBUSxHQUFHLEtBQUssQ0FBQyxPQUFPLENBQUMsZ0JBQWdCLENBQUM7UUFFaEQsSUFBSSxxQkFBYyxDQUFDLElBQUksRUFBRSxVQUFVLEVBQUU7WUFDbkMsWUFBWSxFQUFFLFFBQVEsQ0FBQyxZQUFZO1lBQ25DLFlBQVksRUFBRSxvQ0FBb0M7WUFDbEQsVUFBVSxFQUFFO2dCQUNWLFlBQVksRUFBRSxLQUFLLENBQUMsWUFBWTtnQkFDaEMsaUJBQWlCLFFBQUUsS0FBSyxDQUFDLGlCQUFpQixtQ0FBSSxTQUFTO2dCQUN2RCxjQUFjLEVBQUUsS0FBSyxDQUFDLFlBQVksQ0FBQyxLQUFLLENBQUMsVUFBVSxDQUFDO2dCQUNwRCxnQkFBZ0IsRUFBRSxLQUFLLENBQUMsWUFBWSxDQUFDLEtBQUssQ0FBQyxZQUFZLENBQUM7Z0JBQ3hELFdBQVcsRUFBRSxLQUFLLENBQUMsT0FBTyxDQUFDLFdBQVc7Z0JBQ3RDLE9BQU8sRUFBRSxLQUFLLENBQUMsT0FBTyxDQUFDLDBCQUEwQixDQUFDLFFBQVEsQ0FBQyxJQUFJLENBQUM7Z0JBQ2hFLFNBQVMsUUFBRSxLQUFLLENBQUMsU0FBUyxtQ0FBSSxTQUFTLENBQUMsU0FBUzthQUNsRDtTQUNGLENBQUMsQ0FBQztJQUNMLENBQUM7Q0FDRjtBQXJCRCwwQ0FxQkMiLCJzb3VyY2VzQ29udGVudCI6WyJpbXBvcnQgeyBDb25zdHJ1Y3QsIEN1c3RvbVJlc291cmNlLCBTdGFjayB9IGZyb20gJ0Bhd3MtY2RrL2NvcmUnO1xuaW1wb3J0IHsgQ2x1c3RlciB9IGZyb20gJy4vY2x1c3Rlcic7XG5cbi8qKlxuICogUHJvcGVydGllcyBmb3IgS3ViZXJuZXRlc1BhdGNoXG4gKi9cbmV4cG9ydCBpbnRlcmZhY2UgS3ViZXJuZXRlc1BhdGNoUHJvcHMge1xuICAvKipcbiAgICogVGhlIGNsdXN0ZXIgdG8gYXBwbHkgdGhlIHBhdGNoIHRvLlxuICAgKiBbZGlzYWJsZS1hd3NsaW50OnJlZi12aWEtaW50ZXJmYWNlXVxuICAgKi9cbiAgcmVhZG9ubHkgY2x1c3RlcjogQ2x1c3RlcjtcblxuICAvKipcbiAgICogVGhlIEpTT04gb2JqZWN0IHRvIHBhc3MgdG8gYGt1YmVjdGwgcGF0Y2hgIHdoZW4gdGhlIHJlc291cmNlIGlzIGNyZWF0ZWQvdXBkYXRlZC5cbiAgICovXG4gIHJlYWRvbmx5IGFwcGx5UGF0Y2g6IHsgW2tleTogc3RyaW5nXTogYW55IH07XG5cbiAgLyoqXG4gICAqIFRoZSBKU09OIG9iamVjdCB0byBwYXNzIHRvIGBrdWJlY3RsIHBhdGNoYCB3aGVuIHRoZSByZXNvdXJjZSBpcyByZW1vdmVkLlxuICAgKi9cbiAgcmVhZG9ubHkgcmVzdG9yZVBhdGNoOiB7IFtrZXk6IHN0cmluZ106IGFueSB9O1xuXG4gIC8qKlxuICAgKiBUaGUgZnVsbCBuYW1lIG9mIHRoZSByZXNvdXJjZSB0byBwYXRjaCAoZS5nLiBgZGVwbG95bWVudC9jb3JlZG5zYCkuXG4gICAqL1xuICByZWFkb25seSByZXNvdXJjZU5hbWU6IHN0cmluZztcblxuICAvKipcbiAgICogVGhlIGt1YmVybmV0ZXMgQVBJIG5hbWVzcGFjZVxuICAgKlxuICAgKiBAZGVmYXVsdCBcImRlZmF1bHRcIlxuICAgKi9cbiAgcmVhZG9ubHkgcmVzb3VyY2VOYW1lc3BhY2U/OiBzdHJpbmc7XG5cbiAgLyoqXG4gICAqIFRoZSBwYXRjaCB0eXBlIHRvIHBhc3MgdG8gYGt1YmVjdGwgcGF0Y2hgLlxuICAgKiBUaGUgZGVmYXVsdCB0eXBlIHVzZWQgYnkgYGt1YmVjdGwgcGF0Y2hgIGlzIFwic3RyYXRlZ2ljXCIuXG4gICAqXG4gICAqIEBkZWZhdWx0IFBhdGNoVHlwZS5TVFJBVEVHSUNcbiAgICovXG4gIHJlYWRvbmx5IHBhdGNoVHlwZT86IFBhdGNoVHlwZTtcbn1cblxuLyoqXG4gKiBWYWx1ZXMgZm9yIGBrdWJlY3RsIHBhdGNoYCAtLXR5cGUgYXJndW1lbnRcbiAqL1xuZXhwb3J0IGVudW0gUGF0Y2hUeXBlIHtcbiAgLyoqXG4gICAqIEpTT04gUGF0Y2gsIFJGQyA2OTAyXG4gICAqL1xuICBKU09OID0gJ2pzb24nLFxuICAvKipcbiAgICogSlNPTiBNZXJnZSBwYXRjaFxuICAgKi9cbiAgTUVSR0UgPSAnbWVyZ2UnLFxuICAvKipcbiAgICogU3RyYXRlZ2ljIG1lcmdlIHBhdGNoXG4gICAqL1xuICBTVFJBVEVHSUMgPSAnc3RyYXRlZ2ljJ1xufVxuXG4vKipcbiAqIEEgQ2xvdWRGb3JtYXRpb24gcmVzb3VyY2Ugd2hpY2ggYXBwbGllcy9yZXN0b3JlcyBhIEpTT04gcGF0Y2ggaW50byBhXG4gKiBLdWJlcm5ldGVzIHJlc291cmNlLlxuICogQHNlZSBodHRwczovL2t1YmVybmV0ZXMuaW8vZG9jcy90YXNrcy9ydW4tYXBwbGljYXRpb24vdXBkYXRlLWFwaS1vYmplY3Qta3ViZWN0bC1wYXRjaC9cbiAqL1xuZXhwb3J0IGNsYXNzIEt1YmVybmV0ZXNQYXRjaCBleHRlbmRzIENvbnN0cnVjdCB7XG4gIGNvbnN0cnVjdG9yKHNjb3BlOiBDb25zdHJ1Y3QsIGlkOiBzdHJpbmcsIHByb3BzOiBLdWJlcm5ldGVzUGF0Y2hQcm9wcykge1xuICAgIHN1cGVyKHNjb3BlLCBpZCk7XG5cbiAgICBjb25zdCBzdGFjayA9IFN0YWNrLm9mKHRoaXMpO1xuICAgIGNvbnN0IHByb3ZpZGVyID0gcHJvcHMuY2x1c3Rlci5fa3ViZWN0bFByb3ZpZGVyO1xuXG4gICAgbmV3IEN1c3RvbVJlc291cmNlKHRoaXMsICdSZXNvdXJjZScsIHtcbiAgICAgIHNlcnZpY2VUb2tlbjogcHJvdmlkZXIuc2VydmljZVRva2VuLFxuICAgICAgcmVzb3VyY2VUeXBlOiAnQ3VzdG9tOjpBV1NDREstRUtTLUt1YmVybmV0ZXNQYXRjaCcsXG4gICAgICBwcm9wZXJ0aWVzOiB7XG4gICAgICAgIFJlc291cmNlTmFtZTogcHJvcHMucmVzb3VyY2VOYW1lLFxuICAgICAgICBSZXNvdXJjZU5hbWVzcGFjZTogcHJvcHMucmVzb3VyY2VOYW1lc3BhY2UgPz8gJ2RlZmF1bHQnLFxuICAgICAgICBBcHBseVBhdGNoSnNvbjogc3RhY2sudG9Kc29uU3RyaW5nKHByb3BzLmFwcGx5UGF0Y2gpLFxuICAgICAgICBSZXN0b3JlUGF0Y2hKc29uOiBzdGFjay50b0pzb25TdHJpbmcocHJvcHMucmVzdG9yZVBhdGNoKSxcbiAgICAgICAgQ2x1c3Rlck5hbWU6IHByb3BzLmNsdXN0ZXIuY2x1c3Rlck5hbWUsXG4gICAgICAgIFJvbGVBcm46IHByb3BzLmNsdXN0ZXIuX2dldEt1YmVjdGxDcmVhdGlvblJvbGVBcm4ocHJvdmlkZXIucm9sZSksXG4gICAgICAgIFBhdGNoVHlwZTogcHJvcHMucGF0Y2hUeXBlID8/IFBhdGNoVHlwZS5TVFJBVEVHSUMsXG4gICAgICB9LFxuICAgIH0pO1xuICB9XG59XG4iXX0=