"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
class ResourceHandler {
    constructor(eks, event) {
        this.eks = eks;
        this.requestType = event.RequestType;
        this.requestId = event.RequestId;
        this.logicalResourceId = event.LogicalResourceId;
        this.physicalResourceId = event.PhysicalResourceId;
        this.event = event;
        const roleToAssume = event.ResourceProperties.AssumeRoleArn;
        if (!roleToAssume) {
            throw new Error('AssumeRoleArn must be provided');
        }
        eks.configureAssumeRole({
            RoleArn: roleToAssume,
            RoleSessionName: `AWSCDK.EKSCluster.${this.requestType}.${this.requestId}`,
        });
    }
    onEvent() {
        switch (this.requestType) {
            case 'Create': return this.onCreate();
            case 'Update': return this.onUpdate();
            case 'Delete': return this.onDelete();
        }
        throw new Error(`Invalid request type ${this.requestType}`);
    }
    isComplete() {
        switch (this.requestType) {
            case 'Create': return this.isCreateComplete();
            case 'Update': return this.isUpdateComplete();
            case 'Delete': return this.isDeleteComplete();
        }
        throw new Error(`Invalid request type ${this.requestType}`);
    }
    log(x) {
        // tslint:disable-next-line: no-console
        console.log(JSON.stringify(x, undefined, 2));
    }
}
exports.ResourceHandler = ResourceHandler;
//# sourceMappingURL=data:application/json;base64,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